# GO Postgres #

go-postgres library provide NoSQL functionality which can execute queries with pool of connections.

### What is this repository for? ###

* Establish postgres connection pool
* Execute the SQL queries

### How do I get set up? ###

#### Establish Postgres Connection

```go
package main

import (
	"fmt"
	"bitbucket.org/mybudget-dev/go-postgres"
)

func main() {
	conf := gopostgres.DBConfig{
		User:     "User",
		Password: "Password",
		HostPort: "Host:Port",
		Database: "Database",
	}
	DBPool, err := gopostgres.NewDBPool(conf)
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	defer DBPool.Close()

}
```

#### Postgres Insert #####

```go
package main

import (
	"context"
	"fmt"
	"bitbucket.org/mybudget-dev/go-postgres"
)

func main() {
	conf := gopostgres.DBConfig{
		User:     "User",
		Password: "Password",
		HostPort: "Host:Port",
		Database: "Database",
	}
	sql, err := gopostgres.NewDBPool(conf)
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	defer sql.Close()

	// insert data into postgres
	data := "data"
	transaction, err := sql.BeginTransaction(context.Background())
	if err != nil {
		return
	}
	userQuery :=
		fmt.Sprintf(`INSERT INTO "%s"(data) VALUES($1)`,
			"table")
	statement, err := transaction.Prepare(userQuery)
	if statement != nil {
		defer statement.Close()
	} else {
		fmt.Println(err.Error())
		return
	}
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	_, err = statement.Exec(&data)
	if err != nil {
		if errorTransaction := transaction.Rollback(); errorTransaction != nil {
			fmt.Println(err.Error())
		}
	}
}
```

#### Postgres Get #####

````go
package main

import (
	"context"
	"fmt"
	"bitbucket.org/mybudget-dev/go-postgres"
)

func main() {
	conf := gopostgres.DBConfig{
		User:     "User",
		Password: "Password",
		HostPort: "Host:Port",
		Database: "Database",
	}
	sql, err := gopostgres.NewDBPool(conf)
	if err != nil {
		fmt.Println(err.Error())
		return
	}
	defer sql.Close()

	// get data from postgres
	key := 1
	query := fmt.Sprintf(`SELECT data FROM "%s" WHERE key=$1  ;`, "table")
	statementOfLocation, err := sql.Prepare(context.Background(), query)
	if statementOfLocation != nil {
		defer statementOfLocation.Close()
	}
	if err != nil {
		fmt.Println(err.Error())
		return
	}

	row, err := statementOfLocation.Query(key)
	if row != nil {
		defer row.Close()
	}
	if err != nil {
		fmt.Println(err.Error())
		return
	}

	var data interface{}
	for row.Next() {
		err = row.Scan(&data)
		if err != nil {
			fmt.Println(err.Error())
			return
		}
	}
}
````