package gopostgres

import (
	"context"
	"database/sql"
	"errors"
	"fmt"
	_ "github.com/lib/pq"
)

type DBConfig struct {
	User     string
	Password string
	Host     string
	Port     string
	Database string
}

type DBPool struct {
	*sql.DB
}

func NewDBPool(conf DBConfig) (*DBPool, error) {
	connString := fmt.Sprintf(
		"postgres://%s:%s@%s:%s/%s?sslmode=disable",
		conf.User,
		conf.Password,
		conf.Host,
		conf.Port,
		conf.Database,
	)
	db, err := sql.Open("postgres", connString)
	if err != nil {
		return nil, err
	}

	return &DBPool{db}, nil
}

// BeginTransaction starts a transaction in postgres
func (a *DBPool) BeginTransaction(ctx context.Context) (TransactionInterface, error) {
	tx, err := a.BeginTx(ctx, nil)
	if err != nil {
		return nil, errors.New(err.Error())
	}

	return &Transaction{
		tx,
	}, nil
}

// Prepare prepares a row statement
func (a *DBPool) Prepare(ctx context.Context, sql string) (StatementInterface, error) {
	statement, err := a.PrepareContext(ctx, sql)
	if err != nil {
		return nil, errors.New(err.Error())
	}

	return &Statement{
		Stmt: statement,
	}, nil
}

// Stop will close the Postgres adapter releasing connections
func (a *DBPool) Stop() error {
	return a.Close()
}
