package gopostgres

import (
	"database/sql"
	"errors"
)

// Statement type is used to implement statement interface
type Statement struct {
	Stmt *sql.Stmt
}

// Exec executes a prepared statement
func (st *Statement) Exec(args ...interface{}) (sql.Result, error) {
	data, err := st.Stmt.Exec(args...)
	if err != nil {
		return nil, errors.New(err.Error())
	}

	return data, nil
}

// Query executes a prepared statement and returns sql.Rows type
func (st *Statement) Query(args ...interface{}) (RowsInterface, error) {
	result, err := st.Stmt.Query(args...)
	if err != nil {
		return nil, errors.New(err.Error())
	}

	return result, nil
}

// Close closes the statement
func (st *Statement) Close() error {
	return st.Stmt.Close()
}
