// This file was generated by counterfeiter
package fakes

import (
	"lib/marshal"
	"sync"
)

type Marshaler struct {
	MarshalStub        func(input interface{}) ([]byte, error)
	marshalMutex       sync.RWMutex
	marshalArgsForCall []struct {
		input interface{}
	}
	marshalReturns struct {
		result1 []byte
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *Marshaler) Marshal(input interface{}) ([]byte, error) {
	fake.marshalMutex.Lock()
	fake.marshalArgsForCall = append(fake.marshalArgsForCall, struct {
		input interface{}
	}{input})
	fake.recordInvocation("Marshal", []interface{}{input})
	fake.marshalMutex.Unlock()
	if fake.MarshalStub != nil {
		return fake.MarshalStub(input)
	} else {
		return fake.marshalReturns.result1, fake.marshalReturns.result2
	}
}

func (fake *Marshaler) MarshalCallCount() int {
	fake.marshalMutex.RLock()
	defer fake.marshalMutex.RUnlock()
	return len(fake.marshalArgsForCall)
}

func (fake *Marshaler) MarshalArgsForCall(i int) interface{} {
	fake.marshalMutex.RLock()
	defer fake.marshalMutex.RUnlock()
	return fake.marshalArgsForCall[i].input
}

func (fake *Marshaler) MarshalReturns(result1 []byte, result2 error) {
	fake.MarshalStub = nil
	fake.marshalReturns = struct {
		result1 []byte
		result2 error
	}{result1, result2}
}

func (fake *Marshaler) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.marshalMutex.RLock()
	defer fake.marshalMutex.RUnlock()
	return fake.invocations
}

func (fake *Marshaler) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ marshal.Marshaler = new(Marshaler)
