package acceptance_test

import (
	"fmt"
	"math/rand"
	"time"

	"github.com/cloudfoundry-incubator/cf-test-helpers/cf"
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
	"github.com/onsi/gomega/gbytes"
	"github.com/onsi/gomega/gexec"
)

var _ = Describe("Custom iptables compatibility", func() {
	var (
		appName   string
		orgName   string
		spaceName string
	)

	BeforeEach(func() {
		if !testConfig.RunCustomIPTablesCompatibilityTest {
			Skip("skipping custom iptables compatibility tests")
		}

		appName = fmt.Sprintf("appA-%d", rand.Int31())

		orgName = testConfig.Prefix + "custom-iptables-org"
		spaceName = testConfig.Prefix + "space"
		setupOrgAndSpace(orgName, spaceName)

		By("pushing the test app")
		pushProxy(appName)
	})

	AfterEach(func() {
		By("deleting the test org")
		Expect(cf.Cf("delete-org", orgName, "-f").Wait(Timeout_Push)).To(gexec.Exit(0))
	})

	Describe("when a custom iptables rule is added and a new app is pushed", func() {
		It("still applies the iptable rule to the new app", func(done Done) {
			By("checking that the app can reach the process running on the host")
			session := cf.Cf("ssh", appName, "-c", "curl $CF_INSTANCE_IP:8898").Wait(5 * time.Second)
			Eventually(session).Should(gexec.Exit(0))
			Expect(session.Out).To(gbytes.Say("Hello world!!"))

			close(done)
		}, 180 /* <-- overall spec timeout in seconds */)
	})
})
