// Code generated by counterfeiter. DO NOT EDIT.
package v2actionfakes

import (
	"sync"

	"code.cloudfoundry.org/cli/actor/v2action"
	"code.cloudfoundry.org/cli/api/cloudcontroller/ccv2"
)

type FakeCloudControllerClient struct {
	CreateApplicationStub        func(app ccv2.Application) (ccv2.Application, ccv2.Warnings, error)
	createApplicationMutex       sync.RWMutex
	createApplicationArgsForCall []struct {
		app ccv2.Application
	}
	createApplicationReturns struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	createApplicationReturnsOnCall map[int]struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	CreateRouteStub        func(route ccv2.Route, generatePort bool) (ccv2.Route, ccv2.Warnings, error)
	createRouteMutex       sync.RWMutex
	createRouteArgsForCall []struct {
		route        ccv2.Route
		generatePort bool
	}
	createRouteReturns struct {
		result1 ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	createRouteReturnsOnCall map[int]struct {
		result1 ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	CreateServiceBindingStub        func(appGUID string, serviceBindingGUID string, parameters map[string]interface{}) (ccv2.ServiceBinding, ccv2.Warnings, error)
	createServiceBindingMutex       sync.RWMutex
	createServiceBindingArgsForCall []struct {
		appGUID            string
		serviceBindingGUID string
		parameters         map[string]interface{}
	}
	createServiceBindingReturns struct {
		result1 ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}
	createServiceBindingReturnsOnCall map[int]struct {
		result1 ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}
	CreateUserStub        func(uaaUserID string) (ccv2.User, ccv2.Warnings, error)
	createUserMutex       sync.RWMutex
	createUserArgsForCall []struct {
		uaaUserID string
	}
	createUserReturns struct {
		result1 ccv2.User
		result2 ccv2.Warnings
		result3 error
	}
	createUserReturnsOnCall map[int]struct {
		result1 ccv2.User
		result2 ccv2.Warnings
		result3 error
	}
	DeleteOrganizationJobStub        func(orgGUID string) (ccv2.Job, ccv2.Warnings, error)
	deleteOrganizationJobMutex       sync.RWMutex
	deleteOrganizationJobArgsForCall []struct {
		orgGUID string
	}
	deleteOrganizationJobReturns struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}
	deleteOrganizationJobReturnsOnCall map[int]struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}
	DeleteRouteStub        func(routeGUID string) (ccv2.Warnings, error)
	deleteRouteMutex       sync.RWMutex
	deleteRouteArgsForCall []struct {
		routeGUID string
	}
	deleteRouteReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	deleteRouteReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	DeleteRouteApplicationStub        func(routeGUID string, appGUID string) (ccv2.Warnings, error)
	deleteRouteApplicationMutex       sync.RWMutex
	deleteRouteApplicationArgsForCall []struct {
		routeGUID string
		appGUID   string
	}
	deleteRouteApplicationReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	deleteRouteApplicationReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	DeleteSecurityGroupSpaceStub        func(securityGroupGUID string, spaceGUID string) (ccv2.Warnings, error)
	deleteSecurityGroupSpaceMutex       sync.RWMutex
	deleteSecurityGroupSpaceArgsForCall []struct {
		securityGroupGUID string
		spaceGUID         string
	}
	deleteSecurityGroupSpaceReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	deleteSecurityGroupSpaceReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	DeleteSecurityGroupStagingSpaceStub        func(securityGroupGUID string, spaceGUID string) (ccv2.Warnings, error)
	deleteSecurityGroupStagingSpaceMutex       sync.RWMutex
	deleteSecurityGroupStagingSpaceArgsForCall []struct {
		securityGroupGUID string
		spaceGUID         string
	}
	deleteSecurityGroupStagingSpaceReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	deleteSecurityGroupStagingSpaceReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	DeleteServiceBindingStub        func(serviceBindingGUID string) (ccv2.Warnings, error)
	deleteServiceBindingMutex       sync.RWMutex
	deleteServiceBindingArgsForCall []struct {
		serviceBindingGUID string
	}
	deleteServiceBindingReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	deleteServiceBindingReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	DeleteSpaceJobStub        func(spaceGUID string) (ccv2.Job, ccv2.Warnings, error)
	deleteSpaceJobMutex       sync.RWMutex
	deleteSpaceJobArgsForCall []struct {
		spaceGUID string
	}
	deleteSpaceJobReturns struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}
	deleteSpaceJobReturnsOnCall map[int]struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}
	DoesRouteExistStub        func(route ccv2.Route) (bool, ccv2.Warnings, error)
	doesRouteExistMutex       sync.RWMutex
	doesRouteExistArgsForCall []struct {
		route ccv2.Route
	}
	doesRouteExistReturns struct {
		result1 bool
		result2 ccv2.Warnings
		result3 error
	}
	doesRouteExistReturnsOnCall map[int]struct {
		result1 bool
		result2 ccv2.Warnings
		result3 error
	}
	GetApplicationStub        func(guid string) (ccv2.Application, ccv2.Warnings, error)
	getApplicationMutex       sync.RWMutex
	getApplicationArgsForCall []struct {
		guid string
	}
	getApplicationReturns struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	getApplicationReturnsOnCall map[int]struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	GetApplicationApplicationInstanceStatusesStub        func(guid string) (map[int]ccv2.ApplicationInstanceStatus, ccv2.Warnings, error)
	getApplicationApplicationInstanceStatusesMutex       sync.RWMutex
	getApplicationApplicationInstanceStatusesArgsForCall []struct {
		guid string
	}
	getApplicationApplicationInstanceStatusesReturns struct {
		result1 map[int]ccv2.ApplicationInstanceStatus
		result2 ccv2.Warnings
		result3 error
	}
	getApplicationApplicationInstanceStatusesReturnsOnCall map[int]struct {
		result1 map[int]ccv2.ApplicationInstanceStatus
		result2 ccv2.Warnings
		result3 error
	}
	GetApplicationApplicationInstancesStub        func(guid string) (map[int]ccv2.ApplicationInstance, ccv2.Warnings, error)
	getApplicationApplicationInstancesMutex       sync.RWMutex
	getApplicationApplicationInstancesArgsForCall []struct {
		guid string
	}
	getApplicationApplicationInstancesReturns struct {
		result1 map[int]ccv2.ApplicationInstance
		result2 ccv2.Warnings
		result3 error
	}
	getApplicationApplicationInstancesReturnsOnCall map[int]struct {
		result1 map[int]ccv2.ApplicationInstance
		result2 ccv2.Warnings
		result3 error
	}
	GetApplicationRoutesStub        func(appGUID string, filters ...ccv2.Filter) ([]ccv2.Route, ccv2.Warnings, error)
	getApplicationRoutesMutex       sync.RWMutex
	getApplicationRoutesArgsForCall []struct {
		appGUID string
		filters []ccv2.Filter
	}
	getApplicationRoutesReturns struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	getApplicationRoutesReturnsOnCall map[int]struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	GetApplicationsStub        func(filters ...ccv2.Filter) ([]ccv2.Application, ccv2.Warnings, error)
	getApplicationsMutex       sync.RWMutex
	getApplicationsArgsForCall []struct {
		filters []ccv2.Filter
	}
	getApplicationsReturns struct {
		result1 []ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	getApplicationsReturnsOnCall map[int]struct {
		result1 []ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	GetConfigFeatureFlagsStub        func() ([]ccv2.FeatureFlag, ccv2.Warnings, error)
	getConfigFeatureFlagsMutex       sync.RWMutex
	getConfigFeatureFlagsArgsForCall []struct{}
	getConfigFeatureFlagsReturns     struct {
		result1 []ccv2.FeatureFlag
		result2 ccv2.Warnings
		result3 error
	}
	getConfigFeatureFlagsReturnsOnCall map[int]struct {
		result1 []ccv2.FeatureFlag
		result2 ccv2.Warnings
		result3 error
	}
	GetJobStub        func(jobGUID string) (ccv2.Job, ccv2.Warnings, error)
	getJobMutex       sync.RWMutex
	getJobArgsForCall []struct {
		jobGUID string
	}
	getJobReturns struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}
	getJobReturnsOnCall map[int]struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}
	GetOrganizationStub        func(guid string) (ccv2.Organization, ccv2.Warnings, error)
	getOrganizationMutex       sync.RWMutex
	getOrganizationArgsForCall []struct {
		guid string
	}
	getOrganizationReturns struct {
		result1 ccv2.Organization
		result2 ccv2.Warnings
		result3 error
	}
	getOrganizationReturnsOnCall map[int]struct {
		result1 ccv2.Organization
		result2 ccv2.Warnings
		result3 error
	}
	GetOrganizationPrivateDomainsStub        func(orgGUID string, filters ...ccv2.Filter) ([]ccv2.Domain, ccv2.Warnings, error)
	getOrganizationPrivateDomainsMutex       sync.RWMutex
	getOrganizationPrivateDomainsArgsForCall []struct {
		orgGUID string
		filters []ccv2.Filter
	}
	getOrganizationPrivateDomainsReturns struct {
		result1 []ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}
	getOrganizationPrivateDomainsReturnsOnCall map[int]struct {
		result1 []ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}
	GetOrganizationQuotaStub        func(guid string) (ccv2.OrganizationQuota, ccv2.Warnings, error)
	getOrganizationQuotaMutex       sync.RWMutex
	getOrganizationQuotaArgsForCall []struct {
		guid string
	}
	getOrganizationQuotaReturns struct {
		result1 ccv2.OrganizationQuota
		result2 ccv2.Warnings
		result3 error
	}
	getOrganizationQuotaReturnsOnCall map[int]struct {
		result1 ccv2.OrganizationQuota
		result2 ccv2.Warnings
		result3 error
	}
	GetOrganizationsStub        func(filters ...ccv2.Filter) ([]ccv2.Organization, ccv2.Warnings, error)
	getOrganizationsMutex       sync.RWMutex
	getOrganizationsArgsForCall []struct {
		filters []ccv2.Filter
	}
	getOrganizationsReturns struct {
		result1 []ccv2.Organization
		result2 ccv2.Warnings
		result3 error
	}
	getOrganizationsReturnsOnCall map[int]struct {
		result1 []ccv2.Organization
		result2 ccv2.Warnings
		result3 error
	}
	GetPrivateDomainStub        func(domainGUID string) (ccv2.Domain, ccv2.Warnings, error)
	getPrivateDomainMutex       sync.RWMutex
	getPrivateDomainArgsForCall []struct {
		domainGUID string
	}
	getPrivateDomainReturns struct {
		result1 ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}
	getPrivateDomainReturnsOnCall map[int]struct {
		result1 ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}
	GetRouteApplicationsStub        func(routeGUID string, filters ...ccv2.Filter) ([]ccv2.Application, ccv2.Warnings, error)
	getRouteApplicationsMutex       sync.RWMutex
	getRouteApplicationsArgsForCall []struct {
		routeGUID string
		filters   []ccv2.Filter
	}
	getRouteApplicationsReturns struct {
		result1 []ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	getRouteApplicationsReturnsOnCall map[int]struct {
		result1 []ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	GetRoutesStub        func(filters ...ccv2.Filter) ([]ccv2.Route, ccv2.Warnings, error)
	getRoutesMutex       sync.RWMutex
	getRoutesArgsForCall []struct {
		filters []ccv2.Filter
	}
	getRoutesReturns struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	getRoutesReturnsOnCall map[int]struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	GetSecurityGroupSpacesStub        func(securityGroupGUID string) ([]ccv2.Space, ccv2.Warnings, error)
	getSecurityGroupSpacesMutex       sync.RWMutex
	getSecurityGroupSpacesArgsForCall []struct {
		securityGroupGUID string
	}
	getSecurityGroupSpacesReturns struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}
	getSecurityGroupSpacesReturnsOnCall map[int]struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}
	GetSecurityGroupStagingSpacesStub        func(securityGroupGUID string) ([]ccv2.Space, ccv2.Warnings, error)
	getSecurityGroupStagingSpacesMutex       sync.RWMutex
	getSecurityGroupStagingSpacesArgsForCall []struct {
		securityGroupGUID string
	}
	getSecurityGroupStagingSpacesReturns struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}
	getSecurityGroupStagingSpacesReturnsOnCall map[int]struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}
	GetSecurityGroupsStub        func(filters ...ccv2.Filter) ([]ccv2.SecurityGroup, ccv2.Warnings, error)
	getSecurityGroupsMutex       sync.RWMutex
	getSecurityGroupsArgsForCall []struct {
		filters []ccv2.Filter
	}
	getSecurityGroupsReturns struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}
	getSecurityGroupsReturnsOnCall map[int]struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}
	GetServiceStub        func(serviceGUID string) (ccv2.Service, ccv2.Warnings, error)
	getServiceMutex       sync.RWMutex
	getServiceArgsForCall []struct {
		serviceGUID string
	}
	getServiceReturns struct {
		result1 ccv2.Service
		result2 ccv2.Warnings
		result3 error
	}
	getServiceReturnsOnCall map[int]struct {
		result1 ccv2.Service
		result2 ccv2.Warnings
		result3 error
	}
	GetServiceBindingsStub        func(filters ...ccv2.Filter) ([]ccv2.ServiceBinding, ccv2.Warnings, error)
	getServiceBindingsMutex       sync.RWMutex
	getServiceBindingsArgsForCall []struct {
		filters []ccv2.Filter
	}
	getServiceBindingsReturns struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}
	getServiceBindingsReturnsOnCall map[int]struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}
	GetServiceInstanceStub        func(serviceInstanceGUID string) (ccv2.ServiceInstance, ccv2.Warnings, error)
	getServiceInstanceMutex       sync.RWMutex
	getServiceInstanceArgsForCall []struct {
		serviceInstanceGUID string
	}
	getServiceInstanceReturns struct {
		result1 ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}
	getServiceInstanceReturnsOnCall map[int]struct {
		result1 ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}
	GetServiceInstanceServiceBindingsStub        func(serviceInstanceGUID string) ([]ccv2.ServiceBinding, ccv2.Warnings, error)
	getServiceInstanceServiceBindingsMutex       sync.RWMutex
	getServiceInstanceServiceBindingsArgsForCall []struct {
		serviceInstanceGUID string
	}
	getServiceInstanceServiceBindingsReturns struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}
	getServiceInstanceServiceBindingsReturnsOnCall map[int]struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}
	GetServiceInstanceSharedFromStub        func(serviceInstanceGUID string) (ccv2.ServiceInstanceSharedFrom, ccv2.Warnings, error)
	getServiceInstanceSharedFromMutex       sync.RWMutex
	getServiceInstanceSharedFromArgsForCall []struct {
		serviceInstanceGUID string
	}
	getServiceInstanceSharedFromReturns struct {
		result1 ccv2.ServiceInstanceSharedFrom
		result2 ccv2.Warnings
		result3 error
	}
	getServiceInstanceSharedFromReturnsOnCall map[int]struct {
		result1 ccv2.ServiceInstanceSharedFrom
		result2 ccv2.Warnings
		result3 error
	}
	GetServiceInstanceSharedTosStub        func(serviceInstanceGUID string) ([]ccv2.ServiceInstanceSharedTo, ccv2.Warnings, error)
	getServiceInstanceSharedTosMutex       sync.RWMutex
	getServiceInstanceSharedTosArgsForCall []struct {
		serviceInstanceGUID string
	}
	getServiceInstanceSharedTosReturns struct {
		result1 []ccv2.ServiceInstanceSharedTo
		result2 ccv2.Warnings
		result3 error
	}
	getServiceInstanceSharedTosReturnsOnCall map[int]struct {
		result1 []ccv2.ServiceInstanceSharedTo
		result2 ccv2.Warnings
		result3 error
	}
	GetServiceInstancesStub        func(filters ...ccv2.Filter) ([]ccv2.ServiceInstance, ccv2.Warnings, error)
	getServiceInstancesMutex       sync.RWMutex
	getServiceInstancesArgsForCall []struct {
		filters []ccv2.Filter
	}
	getServiceInstancesReturns struct {
		result1 []ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}
	getServiceInstancesReturnsOnCall map[int]struct {
		result1 []ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}
	GetServicePlanStub        func(servicePlanGUID string) (ccv2.ServicePlan, ccv2.Warnings, error)
	getServicePlanMutex       sync.RWMutex
	getServicePlanArgsForCall []struct {
		servicePlanGUID string
	}
	getServicePlanReturns struct {
		result1 ccv2.ServicePlan
		result2 ccv2.Warnings
		result3 error
	}
	getServicePlanReturnsOnCall map[int]struct {
		result1 ccv2.ServicePlan
		result2 ccv2.Warnings
		result3 error
	}
	GetSharedDomainStub        func(domainGUID string) (ccv2.Domain, ccv2.Warnings, error)
	getSharedDomainMutex       sync.RWMutex
	getSharedDomainArgsForCall []struct {
		domainGUID string
	}
	getSharedDomainReturns struct {
		result1 ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}
	getSharedDomainReturnsOnCall map[int]struct {
		result1 ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}
	GetSharedDomainsStub        func(filters ...ccv2.Filter) ([]ccv2.Domain, ccv2.Warnings, error)
	getSharedDomainsMutex       sync.RWMutex
	getSharedDomainsArgsForCall []struct {
		filters []ccv2.Filter
	}
	getSharedDomainsReturns struct {
		result1 []ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}
	getSharedDomainsReturnsOnCall map[int]struct {
		result1 []ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}
	GetSpaceQuotaDefinitionStub        func(guid string) (ccv2.SpaceQuota, ccv2.Warnings, error)
	getSpaceQuotaDefinitionMutex       sync.RWMutex
	getSpaceQuotaDefinitionArgsForCall []struct {
		guid string
	}
	getSpaceQuotaDefinitionReturns struct {
		result1 ccv2.SpaceQuota
		result2 ccv2.Warnings
		result3 error
	}
	getSpaceQuotaDefinitionReturnsOnCall map[int]struct {
		result1 ccv2.SpaceQuota
		result2 ccv2.Warnings
		result3 error
	}
	GetSpaceRoutesStub        func(spaceGUID string, filters ...ccv2.Filter) ([]ccv2.Route, ccv2.Warnings, error)
	getSpaceRoutesMutex       sync.RWMutex
	getSpaceRoutesArgsForCall []struct {
		spaceGUID string
		filters   []ccv2.Filter
	}
	getSpaceRoutesReturns struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	getSpaceRoutesReturnsOnCall map[int]struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	GetSpaceSecurityGroupsStub        func(spaceGUID string, filters ...ccv2.Filter) ([]ccv2.SecurityGroup, ccv2.Warnings, error)
	getSpaceSecurityGroupsMutex       sync.RWMutex
	getSpaceSecurityGroupsArgsForCall []struct {
		spaceGUID string
		filters   []ccv2.Filter
	}
	getSpaceSecurityGroupsReturns struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}
	getSpaceSecurityGroupsReturnsOnCall map[int]struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}
	GetSpaceServiceInstancesStub        func(spaceGUID string, includeUserProvidedServices bool, filters ...ccv2.Filter) ([]ccv2.ServiceInstance, ccv2.Warnings, error)
	getSpaceServiceInstancesMutex       sync.RWMutex
	getSpaceServiceInstancesArgsForCall []struct {
		spaceGUID                   string
		includeUserProvidedServices bool
		filters                     []ccv2.Filter
	}
	getSpaceServiceInstancesReturns struct {
		result1 []ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}
	getSpaceServiceInstancesReturnsOnCall map[int]struct {
		result1 []ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}
	GetSpaceStagingSecurityGroupsStub        func(spaceGUID string, filters ...ccv2.Filter) ([]ccv2.SecurityGroup, ccv2.Warnings, error)
	getSpaceStagingSecurityGroupsMutex       sync.RWMutex
	getSpaceStagingSecurityGroupsArgsForCall []struct {
		spaceGUID string
		filters   []ccv2.Filter
	}
	getSpaceStagingSecurityGroupsReturns struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}
	getSpaceStagingSecurityGroupsReturnsOnCall map[int]struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}
	GetSpacesStub        func(filters ...ccv2.Filter) ([]ccv2.Space, ccv2.Warnings, error)
	getSpacesMutex       sync.RWMutex
	getSpacesArgsForCall []struct {
		filters []ccv2.Filter
	}
	getSpacesReturns struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}
	getSpacesReturnsOnCall map[int]struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}
	GetStackStub        func(guid string) (ccv2.Stack, ccv2.Warnings, error)
	getStackMutex       sync.RWMutex
	getStackArgsForCall []struct {
		guid string
	}
	getStackReturns struct {
		result1 ccv2.Stack
		result2 ccv2.Warnings
		result3 error
	}
	getStackReturnsOnCall map[int]struct {
		result1 ccv2.Stack
		result2 ccv2.Warnings
		result3 error
	}
	GetStacksStub        func(filters ...ccv2.Filter) ([]ccv2.Stack, ccv2.Warnings, error)
	getStacksMutex       sync.RWMutex
	getStacksArgsForCall []struct {
		filters []ccv2.Filter
	}
	getStacksReturns struct {
		result1 []ccv2.Stack
		result2 ccv2.Warnings
		result3 error
	}
	getStacksReturnsOnCall map[int]struct {
		result1 []ccv2.Stack
		result2 ccv2.Warnings
		result3 error
	}
	GetUserProvidedServiceInstanceServiceBindingsStub        func(userProvidedServiceInstanceGUID string) ([]ccv2.ServiceBinding, ccv2.Warnings, error)
	getUserProvidedServiceInstanceServiceBindingsMutex       sync.RWMutex
	getUserProvidedServiceInstanceServiceBindingsArgsForCall []struct {
		userProvidedServiceInstanceGUID string
	}
	getUserProvidedServiceInstanceServiceBindingsReturns struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}
	getUserProvidedServiceInstanceServiceBindingsReturnsOnCall map[int]struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}
	PollJobStub        func(job ccv2.Job) (ccv2.Warnings, error)
	pollJobMutex       sync.RWMutex
	pollJobArgsForCall []struct {
		job ccv2.Job
	}
	pollJobReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	pollJobReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	RestageApplicationStub        func(app ccv2.Application) (ccv2.Application, ccv2.Warnings, error)
	restageApplicationMutex       sync.RWMutex
	restageApplicationArgsForCall []struct {
		app ccv2.Application
	}
	restageApplicationReturns struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	restageApplicationReturnsOnCall map[int]struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	TargetCFStub        func(settings ccv2.TargetSettings) (ccv2.Warnings, error)
	targetCFMutex       sync.RWMutex
	targetCFArgsForCall []struct {
		settings ccv2.TargetSettings
	}
	targetCFReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	targetCFReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	UpdateApplicationStub        func(app ccv2.Application) (ccv2.Application, ccv2.Warnings, error)
	updateApplicationMutex       sync.RWMutex
	updateApplicationArgsForCall []struct {
		app ccv2.Application
	}
	updateApplicationReturns struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	updateApplicationReturnsOnCall map[int]struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}
	UpdateResourceMatchStub        func(resourcesToMatch []ccv2.Resource) ([]ccv2.Resource, ccv2.Warnings, error)
	updateResourceMatchMutex       sync.RWMutex
	updateResourceMatchArgsForCall []struct {
		resourcesToMatch []ccv2.Resource
	}
	updateResourceMatchReturns struct {
		result1 []ccv2.Resource
		result2 ccv2.Warnings
		result3 error
	}
	updateResourceMatchReturnsOnCall map[int]struct {
		result1 []ccv2.Resource
		result2 ccv2.Warnings
		result3 error
	}
	UpdateRouteApplicationStub        func(routeGUID string, appGUID string) (ccv2.Route, ccv2.Warnings, error)
	updateRouteApplicationMutex       sync.RWMutex
	updateRouteApplicationArgsForCall []struct {
		routeGUID string
		appGUID   string
	}
	updateRouteApplicationReturns struct {
		result1 ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	updateRouteApplicationReturnsOnCall map[int]struct {
		result1 ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}
	UpdateSecurityGroupSpaceStub        func(securityGroupGUID string, spaceGUID string) (ccv2.Warnings, error)
	updateSecurityGroupSpaceMutex       sync.RWMutex
	updateSecurityGroupSpaceArgsForCall []struct {
		securityGroupGUID string
		spaceGUID         string
	}
	updateSecurityGroupSpaceReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	updateSecurityGroupSpaceReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	UpdateSecurityGroupStagingSpaceStub        func(securityGroupGUID string, spaceGUID string) (ccv2.Warnings, error)
	updateSecurityGroupStagingSpaceMutex       sync.RWMutex
	updateSecurityGroupStagingSpaceArgsForCall []struct {
		securityGroupGUID string
		spaceGUID         string
	}
	updateSecurityGroupStagingSpaceReturns struct {
		result1 ccv2.Warnings
		result2 error
	}
	updateSecurityGroupStagingSpaceReturnsOnCall map[int]struct {
		result1 ccv2.Warnings
		result2 error
	}
	UploadApplicationPackageStub        func(appGUID string, existingResources []ccv2.Resource, newResources ccv2.Reader, newResourcesLength int64) (ccv2.Job, ccv2.Warnings, error)
	uploadApplicationPackageMutex       sync.RWMutex
	uploadApplicationPackageArgsForCall []struct {
		appGUID            string
		existingResources  []ccv2.Resource
		newResources       ccv2.Reader
		newResourcesLength int64
	}
	uploadApplicationPackageReturns struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}
	uploadApplicationPackageReturnsOnCall map[int]struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}
	APIStub        func() string
	aPIMutex       sync.RWMutex
	aPIArgsForCall []struct{}
	aPIReturns     struct {
		result1 string
	}
	aPIReturnsOnCall map[int]struct {
		result1 string
	}
	APIVersionStub        func() string
	aPIVersionMutex       sync.RWMutex
	aPIVersionArgsForCall []struct{}
	aPIVersionReturns     struct {
		result1 string
	}
	aPIVersionReturnsOnCall map[int]struct {
		result1 string
	}
	AuthorizationEndpointStub        func() string
	authorizationEndpointMutex       sync.RWMutex
	authorizationEndpointArgsForCall []struct{}
	authorizationEndpointReturns     struct {
		result1 string
	}
	authorizationEndpointReturnsOnCall map[int]struct {
		result1 string
	}
	DopplerEndpointStub        func() string
	dopplerEndpointMutex       sync.RWMutex
	dopplerEndpointArgsForCall []struct{}
	dopplerEndpointReturns     struct {
		result1 string
	}
	dopplerEndpointReturnsOnCall map[int]struct {
		result1 string
	}
	MinCLIVersionStub        func() string
	minCLIVersionMutex       sync.RWMutex
	minCLIVersionArgsForCall []struct{}
	minCLIVersionReturns     struct {
		result1 string
	}
	minCLIVersionReturnsOnCall map[int]struct {
		result1 string
	}
	RoutingEndpointStub        func() string
	routingEndpointMutex       sync.RWMutex
	routingEndpointArgsForCall []struct{}
	routingEndpointReturns     struct {
		result1 string
	}
	routingEndpointReturnsOnCall map[int]struct {
		result1 string
	}
	TokenEndpointStub        func() string
	tokenEndpointMutex       sync.RWMutex
	tokenEndpointArgsForCall []struct{}
	tokenEndpointReturns     struct {
		result1 string
	}
	tokenEndpointReturnsOnCall map[int]struct {
		result1 string
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeCloudControllerClient) CreateApplication(app ccv2.Application) (ccv2.Application, ccv2.Warnings, error) {
	fake.createApplicationMutex.Lock()
	ret, specificReturn := fake.createApplicationReturnsOnCall[len(fake.createApplicationArgsForCall)]
	fake.createApplicationArgsForCall = append(fake.createApplicationArgsForCall, struct {
		app ccv2.Application
	}{app})
	fake.recordInvocation("CreateApplication", []interface{}{app})
	fake.createApplicationMutex.Unlock()
	if fake.CreateApplicationStub != nil {
		return fake.CreateApplicationStub(app)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.createApplicationReturns.result1, fake.createApplicationReturns.result2, fake.createApplicationReturns.result3
}

func (fake *FakeCloudControllerClient) CreateApplicationCallCount() int {
	fake.createApplicationMutex.RLock()
	defer fake.createApplicationMutex.RUnlock()
	return len(fake.createApplicationArgsForCall)
}

func (fake *FakeCloudControllerClient) CreateApplicationArgsForCall(i int) ccv2.Application {
	fake.createApplicationMutex.RLock()
	defer fake.createApplicationMutex.RUnlock()
	return fake.createApplicationArgsForCall[i].app
}

func (fake *FakeCloudControllerClient) CreateApplicationReturns(result1 ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.CreateApplicationStub = nil
	fake.createApplicationReturns = struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) CreateApplicationReturnsOnCall(i int, result1 ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.CreateApplicationStub = nil
	if fake.createApplicationReturnsOnCall == nil {
		fake.createApplicationReturnsOnCall = make(map[int]struct {
			result1 ccv2.Application
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.createApplicationReturnsOnCall[i] = struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) CreateRoute(route ccv2.Route, generatePort bool) (ccv2.Route, ccv2.Warnings, error) {
	fake.createRouteMutex.Lock()
	ret, specificReturn := fake.createRouteReturnsOnCall[len(fake.createRouteArgsForCall)]
	fake.createRouteArgsForCall = append(fake.createRouteArgsForCall, struct {
		route        ccv2.Route
		generatePort bool
	}{route, generatePort})
	fake.recordInvocation("CreateRoute", []interface{}{route, generatePort})
	fake.createRouteMutex.Unlock()
	if fake.CreateRouteStub != nil {
		return fake.CreateRouteStub(route, generatePort)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.createRouteReturns.result1, fake.createRouteReturns.result2, fake.createRouteReturns.result3
}

func (fake *FakeCloudControllerClient) CreateRouteCallCount() int {
	fake.createRouteMutex.RLock()
	defer fake.createRouteMutex.RUnlock()
	return len(fake.createRouteArgsForCall)
}

func (fake *FakeCloudControllerClient) CreateRouteArgsForCall(i int) (ccv2.Route, bool) {
	fake.createRouteMutex.RLock()
	defer fake.createRouteMutex.RUnlock()
	return fake.createRouteArgsForCall[i].route, fake.createRouteArgsForCall[i].generatePort
}

func (fake *FakeCloudControllerClient) CreateRouteReturns(result1 ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.CreateRouteStub = nil
	fake.createRouteReturns = struct {
		result1 ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) CreateRouteReturnsOnCall(i int, result1 ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.CreateRouteStub = nil
	if fake.createRouteReturnsOnCall == nil {
		fake.createRouteReturnsOnCall = make(map[int]struct {
			result1 ccv2.Route
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.createRouteReturnsOnCall[i] = struct {
		result1 ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) CreateServiceBinding(appGUID string, serviceBindingGUID string, parameters map[string]interface{}) (ccv2.ServiceBinding, ccv2.Warnings, error) {
	fake.createServiceBindingMutex.Lock()
	ret, specificReturn := fake.createServiceBindingReturnsOnCall[len(fake.createServiceBindingArgsForCall)]
	fake.createServiceBindingArgsForCall = append(fake.createServiceBindingArgsForCall, struct {
		appGUID            string
		serviceBindingGUID string
		parameters         map[string]interface{}
	}{appGUID, serviceBindingGUID, parameters})
	fake.recordInvocation("CreateServiceBinding", []interface{}{appGUID, serviceBindingGUID, parameters})
	fake.createServiceBindingMutex.Unlock()
	if fake.CreateServiceBindingStub != nil {
		return fake.CreateServiceBindingStub(appGUID, serviceBindingGUID, parameters)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.createServiceBindingReturns.result1, fake.createServiceBindingReturns.result2, fake.createServiceBindingReturns.result3
}

func (fake *FakeCloudControllerClient) CreateServiceBindingCallCount() int {
	fake.createServiceBindingMutex.RLock()
	defer fake.createServiceBindingMutex.RUnlock()
	return len(fake.createServiceBindingArgsForCall)
}

func (fake *FakeCloudControllerClient) CreateServiceBindingArgsForCall(i int) (string, string, map[string]interface{}) {
	fake.createServiceBindingMutex.RLock()
	defer fake.createServiceBindingMutex.RUnlock()
	return fake.createServiceBindingArgsForCall[i].appGUID, fake.createServiceBindingArgsForCall[i].serviceBindingGUID, fake.createServiceBindingArgsForCall[i].parameters
}

func (fake *FakeCloudControllerClient) CreateServiceBindingReturns(result1 ccv2.ServiceBinding, result2 ccv2.Warnings, result3 error) {
	fake.CreateServiceBindingStub = nil
	fake.createServiceBindingReturns = struct {
		result1 ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) CreateServiceBindingReturnsOnCall(i int, result1 ccv2.ServiceBinding, result2 ccv2.Warnings, result3 error) {
	fake.CreateServiceBindingStub = nil
	if fake.createServiceBindingReturnsOnCall == nil {
		fake.createServiceBindingReturnsOnCall = make(map[int]struct {
			result1 ccv2.ServiceBinding
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.createServiceBindingReturnsOnCall[i] = struct {
		result1 ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) CreateUser(uaaUserID string) (ccv2.User, ccv2.Warnings, error) {
	fake.createUserMutex.Lock()
	ret, specificReturn := fake.createUserReturnsOnCall[len(fake.createUserArgsForCall)]
	fake.createUserArgsForCall = append(fake.createUserArgsForCall, struct {
		uaaUserID string
	}{uaaUserID})
	fake.recordInvocation("CreateUser", []interface{}{uaaUserID})
	fake.createUserMutex.Unlock()
	if fake.CreateUserStub != nil {
		return fake.CreateUserStub(uaaUserID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.createUserReturns.result1, fake.createUserReturns.result2, fake.createUserReturns.result3
}

func (fake *FakeCloudControllerClient) CreateUserCallCount() int {
	fake.createUserMutex.RLock()
	defer fake.createUserMutex.RUnlock()
	return len(fake.createUserArgsForCall)
}

func (fake *FakeCloudControllerClient) CreateUserArgsForCall(i int) string {
	fake.createUserMutex.RLock()
	defer fake.createUserMutex.RUnlock()
	return fake.createUserArgsForCall[i].uaaUserID
}

func (fake *FakeCloudControllerClient) CreateUserReturns(result1 ccv2.User, result2 ccv2.Warnings, result3 error) {
	fake.CreateUserStub = nil
	fake.createUserReturns = struct {
		result1 ccv2.User
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) CreateUserReturnsOnCall(i int, result1 ccv2.User, result2 ccv2.Warnings, result3 error) {
	fake.CreateUserStub = nil
	if fake.createUserReturnsOnCall == nil {
		fake.createUserReturnsOnCall = make(map[int]struct {
			result1 ccv2.User
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.createUserReturnsOnCall[i] = struct {
		result1 ccv2.User
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) DeleteOrganizationJob(orgGUID string) (ccv2.Job, ccv2.Warnings, error) {
	fake.deleteOrganizationJobMutex.Lock()
	ret, specificReturn := fake.deleteOrganizationJobReturnsOnCall[len(fake.deleteOrganizationJobArgsForCall)]
	fake.deleteOrganizationJobArgsForCall = append(fake.deleteOrganizationJobArgsForCall, struct {
		orgGUID string
	}{orgGUID})
	fake.recordInvocation("DeleteOrganizationJob", []interface{}{orgGUID})
	fake.deleteOrganizationJobMutex.Unlock()
	if fake.DeleteOrganizationJobStub != nil {
		return fake.DeleteOrganizationJobStub(orgGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.deleteOrganizationJobReturns.result1, fake.deleteOrganizationJobReturns.result2, fake.deleteOrganizationJobReturns.result3
}

func (fake *FakeCloudControllerClient) DeleteOrganizationJobCallCount() int {
	fake.deleteOrganizationJobMutex.RLock()
	defer fake.deleteOrganizationJobMutex.RUnlock()
	return len(fake.deleteOrganizationJobArgsForCall)
}

func (fake *FakeCloudControllerClient) DeleteOrganizationJobArgsForCall(i int) string {
	fake.deleteOrganizationJobMutex.RLock()
	defer fake.deleteOrganizationJobMutex.RUnlock()
	return fake.deleteOrganizationJobArgsForCall[i].orgGUID
}

func (fake *FakeCloudControllerClient) DeleteOrganizationJobReturns(result1 ccv2.Job, result2 ccv2.Warnings, result3 error) {
	fake.DeleteOrganizationJobStub = nil
	fake.deleteOrganizationJobReturns = struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) DeleteOrganizationJobReturnsOnCall(i int, result1 ccv2.Job, result2 ccv2.Warnings, result3 error) {
	fake.DeleteOrganizationJobStub = nil
	if fake.deleteOrganizationJobReturnsOnCall == nil {
		fake.deleteOrganizationJobReturnsOnCall = make(map[int]struct {
			result1 ccv2.Job
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.deleteOrganizationJobReturnsOnCall[i] = struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) DeleteRoute(routeGUID string) (ccv2.Warnings, error) {
	fake.deleteRouteMutex.Lock()
	ret, specificReturn := fake.deleteRouteReturnsOnCall[len(fake.deleteRouteArgsForCall)]
	fake.deleteRouteArgsForCall = append(fake.deleteRouteArgsForCall, struct {
		routeGUID string
	}{routeGUID})
	fake.recordInvocation("DeleteRoute", []interface{}{routeGUID})
	fake.deleteRouteMutex.Unlock()
	if fake.DeleteRouteStub != nil {
		return fake.DeleteRouteStub(routeGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.deleteRouteReturns.result1, fake.deleteRouteReturns.result2
}

func (fake *FakeCloudControllerClient) DeleteRouteCallCount() int {
	fake.deleteRouteMutex.RLock()
	defer fake.deleteRouteMutex.RUnlock()
	return len(fake.deleteRouteArgsForCall)
}

func (fake *FakeCloudControllerClient) DeleteRouteArgsForCall(i int) string {
	fake.deleteRouteMutex.RLock()
	defer fake.deleteRouteMutex.RUnlock()
	return fake.deleteRouteArgsForCall[i].routeGUID
}

func (fake *FakeCloudControllerClient) DeleteRouteReturns(result1 ccv2.Warnings, result2 error) {
	fake.DeleteRouteStub = nil
	fake.deleteRouteReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteRouteReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.DeleteRouteStub = nil
	if fake.deleteRouteReturnsOnCall == nil {
		fake.deleteRouteReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.deleteRouteReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteRouteApplication(routeGUID string, appGUID string) (ccv2.Warnings, error) {
	fake.deleteRouteApplicationMutex.Lock()
	ret, specificReturn := fake.deleteRouteApplicationReturnsOnCall[len(fake.deleteRouteApplicationArgsForCall)]
	fake.deleteRouteApplicationArgsForCall = append(fake.deleteRouteApplicationArgsForCall, struct {
		routeGUID string
		appGUID   string
	}{routeGUID, appGUID})
	fake.recordInvocation("DeleteRouteApplication", []interface{}{routeGUID, appGUID})
	fake.deleteRouteApplicationMutex.Unlock()
	if fake.DeleteRouteApplicationStub != nil {
		return fake.DeleteRouteApplicationStub(routeGUID, appGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.deleteRouteApplicationReturns.result1, fake.deleteRouteApplicationReturns.result2
}

func (fake *FakeCloudControllerClient) DeleteRouteApplicationCallCount() int {
	fake.deleteRouteApplicationMutex.RLock()
	defer fake.deleteRouteApplicationMutex.RUnlock()
	return len(fake.deleteRouteApplicationArgsForCall)
}

func (fake *FakeCloudControllerClient) DeleteRouteApplicationArgsForCall(i int) (string, string) {
	fake.deleteRouteApplicationMutex.RLock()
	defer fake.deleteRouteApplicationMutex.RUnlock()
	return fake.deleteRouteApplicationArgsForCall[i].routeGUID, fake.deleteRouteApplicationArgsForCall[i].appGUID
}

func (fake *FakeCloudControllerClient) DeleteRouteApplicationReturns(result1 ccv2.Warnings, result2 error) {
	fake.DeleteRouteApplicationStub = nil
	fake.deleteRouteApplicationReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteRouteApplicationReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.DeleteRouteApplicationStub = nil
	if fake.deleteRouteApplicationReturnsOnCall == nil {
		fake.deleteRouteApplicationReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.deleteRouteApplicationReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupSpace(securityGroupGUID string, spaceGUID string) (ccv2.Warnings, error) {
	fake.deleteSecurityGroupSpaceMutex.Lock()
	ret, specificReturn := fake.deleteSecurityGroupSpaceReturnsOnCall[len(fake.deleteSecurityGroupSpaceArgsForCall)]
	fake.deleteSecurityGroupSpaceArgsForCall = append(fake.deleteSecurityGroupSpaceArgsForCall, struct {
		securityGroupGUID string
		spaceGUID         string
	}{securityGroupGUID, spaceGUID})
	fake.recordInvocation("DeleteSecurityGroupSpace", []interface{}{securityGroupGUID, spaceGUID})
	fake.deleteSecurityGroupSpaceMutex.Unlock()
	if fake.DeleteSecurityGroupSpaceStub != nil {
		return fake.DeleteSecurityGroupSpaceStub(securityGroupGUID, spaceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.deleteSecurityGroupSpaceReturns.result1, fake.deleteSecurityGroupSpaceReturns.result2
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupSpaceCallCount() int {
	fake.deleteSecurityGroupSpaceMutex.RLock()
	defer fake.deleteSecurityGroupSpaceMutex.RUnlock()
	return len(fake.deleteSecurityGroupSpaceArgsForCall)
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupSpaceArgsForCall(i int) (string, string) {
	fake.deleteSecurityGroupSpaceMutex.RLock()
	defer fake.deleteSecurityGroupSpaceMutex.RUnlock()
	return fake.deleteSecurityGroupSpaceArgsForCall[i].securityGroupGUID, fake.deleteSecurityGroupSpaceArgsForCall[i].spaceGUID
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupSpaceReturns(result1 ccv2.Warnings, result2 error) {
	fake.DeleteSecurityGroupSpaceStub = nil
	fake.deleteSecurityGroupSpaceReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupSpaceReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.DeleteSecurityGroupSpaceStub = nil
	if fake.deleteSecurityGroupSpaceReturnsOnCall == nil {
		fake.deleteSecurityGroupSpaceReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.deleteSecurityGroupSpaceReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupStagingSpace(securityGroupGUID string, spaceGUID string) (ccv2.Warnings, error) {
	fake.deleteSecurityGroupStagingSpaceMutex.Lock()
	ret, specificReturn := fake.deleteSecurityGroupStagingSpaceReturnsOnCall[len(fake.deleteSecurityGroupStagingSpaceArgsForCall)]
	fake.deleteSecurityGroupStagingSpaceArgsForCall = append(fake.deleteSecurityGroupStagingSpaceArgsForCall, struct {
		securityGroupGUID string
		spaceGUID         string
	}{securityGroupGUID, spaceGUID})
	fake.recordInvocation("DeleteSecurityGroupStagingSpace", []interface{}{securityGroupGUID, spaceGUID})
	fake.deleteSecurityGroupStagingSpaceMutex.Unlock()
	if fake.DeleteSecurityGroupStagingSpaceStub != nil {
		return fake.DeleteSecurityGroupStagingSpaceStub(securityGroupGUID, spaceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.deleteSecurityGroupStagingSpaceReturns.result1, fake.deleteSecurityGroupStagingSpaceReturns.result2
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupStagingSpaceCallCount() int {
	fake.deleteSecurityGroupStagingSpaceMutex.RLock()
	defer fake.deleteSecurityGroupStagingSpaceMutex.RUnlock()
	return len(fake.deleteSecurityGroupStagingSpaceArgsForCall)
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupStagingSpaceArgsForCall(i int) (string, string) {
	fake.deleteSecurityGroupStagingSpaceMutex.RLock()
	defer fake.deleteSecurityGroupStagingSpaceMutex.RUnlock()
	return fake.deleteSecurityGroupStagingSpaceArgsForCall[i].securityGroupGUID, fake.deleteSecurityGroupStagingSpaceArgsForCall[i].spaceGUID
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupStagingSpaceReturns(result1 ccv2.Warnings, result2 error) {
	fake.DeleteSecurityGroupStagingSpaceStub = nil
	fake.deleteSecurityGroupStagingSpaceReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteSecurityGroupStagingSpaceReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.DeleteSecurityGroupStagingSpaceStub = nil
	if fake.deleteSecurityGroupStagingSpaceReturnsOnCall == nil {
		fake.deleteSecurityGroupStagingSpaceReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.deleteSecurityGroupStagingSpaceReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteServiceBinding(serviceBindingGUID string) (ccv2.Warnings, error) {
	fake.deleteServiceBindingMutex.Lock()
	ret, specificReturn := fake.deleteServiceBindingReturnsOnCall[len(fake.deleteServiceBindingArgsForCall)]
	fake.deleteServiceBindingArgsForCall = append(fake.deleteServiceBindingArgsForCall, struct {
		serviceBindingGUID string
	}{serviceBindingGUID})
	fake.recordInvocation("DeleteServiceBinding", []interface{}{serviceBindingGUID})
	fake.deleteServiceBindingMutex.Unlock()
	if fake.DeleteServiceBindingStub != nil {
		return fake.DeleteServiceBindingStub(serviceBindingGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.deleteServiceBindingReturns.result1, fake.deleteServiceBindingReturns.result2
}

func (fake *FakeCloudControllerClient) DeleteServiceBindingCallCount() int {
	fake.deleteServiceBindingMutex.RLock()
	defer fake.deleteServiceBindingMutex.RUnlock()
	return len(fake.deleteServiceBindingArgsForCall)
}

func (fake *FakeCloudControllerClient) DeleteServiceBindingArgsForCall(i int) string {
	fake.deleteServiceBindingMutex.RLock()
	defer fake.deleteServiceBindingMutex.RUnlock()
	return fake.deleteServiceBindingArgsForCall[i].serviceBindingGUID
}

func (fake *FakeCloudControllerClient) DeleteServiceBindingReturns(result1 ccv2.Warnings, result2 error) {
	fake.DeleteServiceBindingStub = nil
	fake.deleteServiceBindingReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteServiceBindingReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.DeleteServiceBindingStub = nil
	if fake.deleteServiceBindingReturnsOnCall == nil {
		fake.deleteServiceBindingReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.deleteServiceBindingReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) DeleteSpaceJob(spaceGUID string) (ccv2.Job, ccv2.Warnings, error) {
	fake.deleteSpaceJobMutex.Lock()
	ret, specificReturn := fake.deleteSpaceJobReturnsOnCall[len(fake.deleteSpaceJobArgsForCall)]
	fake.deleteSpaceJobArgsForCall = append(fake.deleteSpaceJobArgsForCall, struct {
		spaceGUID string
	}{spaceGUID})
	fake.recordInvocation("DeleteSpaceJob", []interface{}{spaceGUID})
	fake.deleteSpaceJobMutex.Unlock()
	if fake.DeleteSpaceJobStub != nil {
		return fake.DeleteSpaceJobStub(spaceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.deleteSpaceJobReturns.result1, fake.deleteSpaceJobReturns.result2, fake.deleteSpaceJobReturns.result3
}

func (fake *FakeCloudControllerClient) DeleteSpaceJobCallCount() int {
	fake.deleteSpaceJobMutex.RLock()
	defer fake.deleteSpaceJobMutex.RUnlock()
	return len(fake.deleteSpaceJobArgsForCall)
}

func (fake *FakeCloudControllerClient) DeleteSpaceJobArgsForCall(i int) string {
	fake.deleteSpaceJobMutex.RLock()
	defer fake.deleteSpaceJobMutex.RUnlock()
	return fake.deleteSpaceJobArgsForCall[i].spaceGUID
}

func (fake *FakeCloudControllerClient) DeleteSpaceJobReturns(result1 ccv2.Job, result2 ccv2.Warnings, result3 error) {
	fake.DeleteSpaceJobStub = nil
	fake.deleteSpaceJobReturns = struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) DeleteSpaceJobReturnsOnCall(i int, result1 ccv2.Job, result2 ccv2.Warnings, result3 error) {
	fake.DeleteSpaceJobStub = nil
	if fake.deleteSpaceJobReturnsOnCall == nil {
		fake.deleteSpaceJobReturnsOnCall = make(map[int]struct {
			result1 ccv2.Job
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.deleteSpaceJobReturnsOnCall[i] = struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) DoesRouteExist(route ccv2.Route) (bool, ccv2.Warnings, error) {
	fake.doesRouteExistMutex.Lock()
	ret, specificReturn := fake.doesRouteExistReturnsOnCall[len(fake.doesRouteExistArgsForCall)]
	fake.doesRouteExistArgsForCall = append(fake.doesRouteExistArgsForCall, struct {
		route ccv2.Route
	}{route})
	fake.recordInvocation("DoesRouteExist", []interface{}{route})
	fake.doesRouteExistMutex.Unlock()
	if fake.DoesRouteExistStub != nil {
		return fake.DoesRouteExistStub(route)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.doesRouteExistReturns.result1, fake.doesRouteExistReturns.result2, fake.doesRouteExistReturns.result3
}

func (fake *FakeCloudControllerClient) DoesRouteExistCallCount() int {
	fake.doesRouteExistMutex.RLock()
	defer fake.doesRouteExistMutex.RUnlock()
	return len(fake.doesRouteExistArgsForCall)
}

func (fake *FakeCloudControllerClient) DoesRouteExistArgsForCall(i int) ccv2.Route {
	fake.doesRouteExistMutex.RLock()
	defer fake.doesRouteExistMutex.RUnlock()
	return fake.doesRouteExistArgsForCall[i].route
}

func (fake *FakeCloudControllerClient) DoesRouteExistReturns(result1 bool, result2 ccv2.Warnings, result3 error) {
	fake.DoesRouteExistStub = nil
	fake.doesRouteExistReturns = struct {
		result1 bool
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) DoesRouteExistReturnsOnCall(i int, result1 bool, result2 ccv2.Warnings, result3 error) {
	fake.DoesRouteExistStub = nil
	if fake.doesRouteExistReturnsOnCall == nil {
		fake.doesRouteExistReturnsOnCall = make(map[int]struct {
			result1 bool
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.doesRouteExistReturnsOnCall[i] = struct {
		result1 bool
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplication(guid string) (ccv2.Application, ccv2.Warnings, error) {
	fake.getApplicationMutex.Lock()
	ret, specificReturn := fake.getApplicationReturnsOnCall[len(fake.getApplicationArgsForCall)]
	fake.getApplicationArgsForCall = append(fake.getApplicationArgsForCall, struct {
		guid string
	}{guid})
	fake.recordInvocation("GetApplication", []interface{}{guid})
	fake.getApplicationMutex.Unlock()
	if fake.GetApplicationStub != nil {
		return fake.GetApplicationStub(guid)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getApplicationReturns.result1, fake.getApplicationReturns.result2, fake.getApplicationReturns.result3
}

func (fake *FakeCloudControllerClient) GetApplicationCallCount() int {
	fake.getApplicationMutex.RLock()
	defer fake.getApplicationMutex.RUnlock()
	return len(fake.getApplicationArgsForCall)
}

func (fake *FakeCloudControllerClient) GetApplicationArgsForCall(i int) string {
	fake.getApplicationMutex.RLock()
	defer fake.getApplicationMutex.RUnlock()
	return fake.getApplicationArgsForCall[i].guid
}

func (fake *FakeCloudControllerClient) GetApplicationReturns(result1 ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationStub = nil
	fake.getApplicationReturns = struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplicationReturnsOnCall(i int, result1 ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationStub = nil
	if fake.getApplicationReturnsOnCall == nil {
		fake.getApplicationReturnsOnCall = make(map[int]struct {
			result1 ccv2.Application
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getApplicationReturnsOnCall[i] = struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstanceStatuses(guid string) (map[int]ccv2.ApplicationInstanceStatus, ccv2.Warnings, error) {
	fake.getApplicationApplicationInstanceStatusesMutex.Lock()
	ret, specificReturn := fake.getApplicationApplicationInstanceStatusesReturnsOnCall[len(fake.getApplicationApplicationInstanceStatusesArgsForCall)]
	fake.getApplicationApplicationInstanceStatusesArgsForCall = append(fake.getApplicationApplicationInstanceStatusesArgsForCall, struct {
		guid string
	}{guid})
	fake.recordInvocation("GetApplicationApplicationInstanceStatuses", []interface{}{guid})
	fake.getApplicationApplicationInstanceStatusesMutex.Unlock()
	if fake.GetApplicationApplicationInstanceStatusesStub != nil {
		return fake.GetApplicationApplicationInstanceStatusesStub(guid)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getApplicationApplicationInstanceStatusesReturns.result1, fake.getApplicationApplicationInstanceStatusesReturns.result2, fake.getApplicationApplicationInstanceStatusesReturns.result3
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstanceStatusesCallCount() int {
	fake.getApplicationApplicationInstanceStatusesMutex.RLock()
	defer fake.getApplicationApplicationInstanceStatusesMutex.RUnlock()
	return len(fake.getApplicationApplicationInstanceStatusesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstanceStatusesArgsForCall(i int) string {
	fake.getApplicationApplicationInstanceStatusesMutex.RLock()
	defer fake.getApplicationApplicationInstanceStatusesMutex.RUnlock()
	return fake.getApplicationApplicationInstanceStatusesArgsForCall[i].guid
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstanceStatusesReturns(result1 map[int]ccv2.ApplicationInstanceStatus, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationApplicationInstanceStatusesStub = nil
	fake.getApplicationApplicationInstanceStatusesReturns = struct {
		result1 map[int]ccv2.ApplicationInstanceStatus
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstanceStatusesReturnsOnCall(i int, result1 map[int]ccv2.ApplicationInstanceStatus, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationApplicationInstanceStatusesStub = nil
	if fake.getApplicationApplicationInstanceStatusesReturnsOnCall == nil {
		fake.getApplicationApplicationInstanceStatusesReturnsOnCall = make(map[int]struct {
			result1 map[int]ccv2.ApplicationInstanceStatus
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getApplicationApplicationInstanceStatusesReturnsOnCall[i] = struct {
		result1 map[int]ccv2.ApplicationInstanceStatus
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstances(guid string) (map[int]ccv2.ApplicationInstance, ccv2.Warnings, error) {
	fake.getApplicationApplicationInstancesMutex.Lock()
	ret, specificReturn := fake.getApplicationApplicationInstancesReturnsOnCall[len(fake.getApplicationApplicationInstancesArgsForCall)]
	fake.getApplicationApplicationInstancesArgsForCall = append(fake.getApplicationApplicationInstancesArgsForCall, struct {
		guid string
	}{guid})
	fake.recordInvocation("GetApplicationApplicationInstances", []interface{}{guid})
	fake.getApplicationApplicationInstancesMutex.Unlock()
	if fake.GetApplicationApplicationInstancesStub != nil {
		return fake.GetApplicationApplicationInstancesStub(guid)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getApplicationApplicationInstancesReturns.result1, fake.getApplicationApplicationInstancesReturns.result2, fake.getApplicationApplicationInstancesReturns.result3
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstancesCallCount() int {
	fake.getApplicationApplicationInstancesMutex.RLock()
	defer fake.getApplicationApplicationInstancesMutex.RUnlock()
	return len(fake.getApplicationApplicationInstancesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstancesArgsForCall(i int) string {
	fake.getApplicationApplicationInstancesMutex.RLock()
	defer fake.getApplicationApplicationInstancesMutex.RUnlock()
	return fake.getApplicationApplicationInstancesArgsForCall[i].guid
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstancesReturns(result1 map[int]ccv2.ApplicationInstance, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationApplicationInstancesStub = nil
	fake.getApplicationApplicationInstancesReturns = struct {
		result1 map[int]ccv2.ApplicationInstance
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplicationApplicationInstancesReturnsOnCall(i int, result1 map[int]ccv2.ApplicationInstance, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationApplicationInstancesStub = nil
	if fake.getApplicationApplicationInstancesReturnsOnCall == nil {
		fake.getApplicationApplicationInstancesReturnsOnCall = make(map[int]struct {
			result1 map[int]ccv2.ApplicationInstance
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getApplicationApplicationInstancesReturnsOnCall[i] = struct {
		result1 map[int]ccv2.ApplicationInstance
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplicationRoutes(appGUID string, filters ...ccv2.Filter) ([]ccv2.Route, ccv2.Warnings, error) {
	fake.getApplicationRoutesMutex.Lock()
	ret, specificReturn := fake.getApplicationRoutesReturnsOnCall[len(fake.getApplicationRoutesArgsForCall)]
	fake.getApplicationRoutesArgsForCall = append(fake.getApplicationRoutesArgsForCall, struct {
		appGUID string
		filters []ccv2.Filter
	}{appGUID, filters})
	fake.recordInvocation("GetApplicationRoutes", []interface{}{appGUID, filters})
	fake.getApplicationRoutesMutex.Unlock()
	if fake.GetApplicationRoutesStub != nil {
		return fake.GetApplicationRoutesStub(appGUID, filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getApplicationRoutesReturns.result1, fake.getApplicationRoutesReturns.result2, fake.getApplicationRoutesReturns.result3
}

func (fake *FakeCloudControllerClient) GetApplicationRoutesCallCount() int {
	fake.getApplicationRoutesMutex.RLock()
	defer fake.getApplicationRoutesMutex.RUnlock()
	return len(fake.getApplicationRoutesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetApplicationRoutesArgsForCall(i int) (string, []ccv2.Filter) {
	fake.getApplicationRoutesMutex.RLock()
	defer fake.getApplicationRoutesMutex.RUnlock()
	return fake.getApplicationRoutesArgsForCall[i].appGUID, fake.getApplicationRoutesArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetApplicationRoutesReturns(result1 []ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationRoutesStub = nil
	fake.getApplicationRoutesReturns = struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplicationRoutesReturnsOnCall(i int, result1 []ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationRoutesStub = nil
	if fake.getApplicationRoutesReturnsOnCall == nil {
		fake.getApplicationRoutesReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Route
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getApplicationRoutesReturnsOnCall[i] = struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplications(filters ...ccv2.Filter) ([]ccv2.Application, ccv2.Warnings, error) {
	fake.getApplicationsMutex.Lock()
	ret, specificReturn := fake.getApplicationsReturnsOnCall[len(fake.getApplicationsArgsForCall)]
	fake.getApplicationsArgsForCall = append(fake.getApplicationsArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetApplications", []interface{}{filters})
	fake.getApplicationsMutex.Unlock()
	if fake.GetApplicationsStub != nil {
		return fake.GetApplicationsStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getApplicationsReturns.result1, fake.getApplicationsReturns.result2, fake.getApplicationsReturns.result3
}

func (fake *FakeCloudControllerClient) GetApplicationsCallCount() int {
	fake.getApplicationsMutex.RLock()
	defer fake.getApplicationsMutex.RUnlock()
	return len(fake.getApplicationsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetApplicationsArgsForCall(i int) []ccv2.Filter {
	fake.getApplicationsMutex.RLock()
	defer fake.getApplicationsMutex.RUnlock()
	return fake.getApplicationsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetApplicationsReturns(result1 []ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationsStub = nil
	fake.getApplicationsReturns = struct {
		result1 []ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetApplicationsReturnsOnCall(i int, result1 []ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.GetApplicationsStub = nil
	if fake.getApplicationsReturnsOnCall == nil {
		fake.getApplicationsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Application
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getApplicationsReturnsOnCall[i] = struct {
		result1 []ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetConfigFeatureFlags() ([]ccv2.FeatureFlag, ccv2.Warnings, error) {
	fake.getConfigFeatureFlagsMutex.Lock()
	ret, specificReturn := fake.getConfigFeatureFlagsReturnsOnCall[len(fake.getConfigFeatureFlagsArgsForCall)]
	fake.getConfigFeatureFlagsArgsForCall = append(fake.getConfigFeatureFlagsArgsForCall, struct{}{})
	fake.recordInvocation("GetConfigFeatureFlags", []interface{}{})
	fake.getConfigFeatureFlagsMutex.Unlock()
	if fake.GetConfigFeatureFlagsStub != nil {
		return fake.GetConfigFeatureFlagsStub()
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getConfigFeatureFlagsReturns.result1, fake.getConfigFeatureFlagsReturns.result2, fake.getConfigFeatureFlagsReturns.result3
}

func (fake *FakeCloudControllerClient) GetConfigFeatureFlagsCallCount() int {
	fake.getConfigFeatureFlagsMutex.RLock()
	defer fake.getConfigFeatureFlagsMutex.RUnlock()
	return len(fake.getConfigFeatureFlagsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetConfigFeatureFlagsReturns(result1 []ccv2.FeatureFlag, result2 ccv2.Warnings, result3 error) {
	fake.GetConfigFeatureFlagsStub = nil
	fake.getConfigFeatureFlagsReturns = struct {
		result1 []ccv2.FeatureFlag
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetConfigFeatureFlagsReturnsOnCall(i int, result1 []ccv2.FeatureFlag, result2 ccv2.Warnings, result3 error) {
	fake.GetConfigFeatureFlagsStub = nil
	if fake.getConfigFeatureFlagsReturnsOnCall == nil {
		fake.getConfigFeatureFlagsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.FeatureFlag
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getConfigFeatureFlagsReturnsOnCall[i] = struct {
		result1 []ccv2.FeatureFlag
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetJob(jobGUID string) (ccv2.Job, ccv2.Warnings, error) {
	fake.getJobMutex.Lock()
	ret, specificReturn := fake.getJobReturnsOnCall[len(fake.getJobArgsForCall)]
	fake.getJobArgsForCall = append(fake.getJobArgsForCall, struct {
		jobGUID string
	}{jobGUID})
	fake.recordInvocation("GetJob", []interface{}{jobGUID})
	fake.getJobMutex.Unlock()
	if fake.GetJobStub != nil {
		return fake.GetJobStub(jobGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getJobReturns.result1, fake.getJobReturns.result2, fake.getJobReturns.result3
}

func (fake *FakeCloudControllerClient) GetJobCallCount() int {
	fake.getJobMutex.RLock()
	defer fake.getJobMutex.RUnlock()
	return len(fake.getJobArgsForCall)
}

func (fake *FakeCloudControllerClient) GetJobArgsForCall(i int) string {
	fake.getJobMutex.RLock()
	defer fake.getJobMutex.RUnlock()
	return fake.getJobArgsForCall[i].jobGUID
}

func (fake *FakeCloudControllerClient) GetJobReturns(result1 ccv2.Job, result2 ccv2.Warnings, result3 error) {
	fake.GetJobStub = nil
	fake.getJobReturns = struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetJobReturnsOnCall(i int, result1 ccv2.Job, result2 ccv2.Warnings, result3 error) {
	fake.GetJobStub = nil
	if fake.getJobReturnsOnCall == nil {
		fake.getJobReturnsOnCall = make(map[int]struct {
			result1 ccv2.Job
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getJobReturnsOnCall[i] = struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetOrganization(guid string) (ccv2.Organization, ccv2.Warnings, error) {
	fake.getOrganizationMutex.Lock()
	ret, specificReturn := fake.getOrganizationReturnsOnCall[len(fake.getOrganizationArgsForCall)]
	fake.getOrganizationArgsForCall = append(fake.getOrganizationArgsForCall, struct {
		guid string
	}{guid})
	fake.recordInvocation("GetOrganization", []interface{}{guid})
	fake.getOrganizationMutex.Unlock()
	if fake.GetOrganizationStub != nil {
		return fake.GetOrganizationStub(guid)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getOrganizationReturns.result1, fake.getOrganizationReturns.result2, fake.getOrganizationReturns.result3
}

func (fake *FakeCloudControllerClient) GetOrganizationCallCount() int {
	fake.getOrganizationMutex.RLock()
	defer fake.getOrganizationMutex.RUnlock()
	return len(fake.getOrganizationArgsForCall)
}

func (fake *FakeCloudControllerClient) GetOrganizationArgsForCall(i int) string {
	fake.getOrganizationMutex.RLock()
	defer fake.getOrganizationMutex.RUnlock()
	return fake.getOrganizationArgsForCall[i].guid
}

func (fake *FakeCloudControllerClient) GetOrganizationReturns(result1 ccv2.Organization, result2 ccv2.Warnings, result3 error) {
	fake.GetOrganizationStub = nil
	fake.getOrganizationReturns = struct {
		result1 ccv2.Organization
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetOrganizationReturnsOnCall(i int, result1 ccv2.Organization, result2 ccv2.Warnings, result3 error) {
	fake.GetOrganizationStub = nil
	if fake.getOrganizationReturnsOnCall == nil {
		fake.getOrganizationReturnsOnCall = make(map[int]struct {
			result1 ccv2.Organization
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getOrganizationReturnsOnCall[i] = struct {
		result1 ccv2.Organization
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetOrganizationPrivateDomains(orgGUID string, filters ...ccv2.Filter) ([]ccv2.Domain, ccv2.Warnings, error) {
	fake.getOrganizationPrivateDomainsMutex.Lock()
	ret, specificReturn := fake.getOrganizationPrivateDomainsReturnsOnCall[len(fake.getOrganizationPrivateDomainsArgsForCall)]
	fake.getOrganizationPrivateDomainsArgsForCall = append(fake.getOrganizationPrivateDomainsArgsForCall, struct {
		orgGUID string
		filters []ccv2.Filter
	}{orgGUID, filters})
	fake.recordInvocation("GetOrganizationPrivateDomains", []interface{}{orgGUID, filters})
	fake.getOrganizationPrivateDomainsMutex.Unlock()
	if fake.GetOrganizationPrivateDomainsStub != nil {
		return fake.GetOrganizationPrivateDomainsStub(orgGUID, filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getOrganizationPrivateDomainsReturns.result1, fake.getOrganizationPrivateDomainsReturns.result2, fake.getOrganizationPrivateDomainsReturns.result3
}

func (fake *FakeCloudControllerClient) GetOrganizationPrivateDomainsCallCount() int {
	fake.getOrganizationPrivateDomainsMutex.RLock()
	defer fake.getOrganizationPrivateDomainsMutex.RUnlock()
	return len(fake.getOrganizationPrivateDomainsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetOrganizationPrivateDomainsArgsForCall(i int) (string, []ccv2.Filter) {
	fake.getOrganizationPrivateDomainsMutex.RLock()
	defer fake.getOrganizationPrivateDomainsMutex.RUnlock()
	return fake.getOrganizationPrivateDomainsArgsForCall[i].orgGUID, fake.getOrganizationPrivateDomainsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetOrganizationPrivateDomainsReturns(result1 []ccv2.Domain, result2 ccv2.Warnings, result3 error) {
	fake.GetOrganizationPrivateDomainsStub = nil
	fake.getOrganizationPrivateDomainsReturns = struct {
		result1 []ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetOrganizationPrivateDomainsReturnsOnCall(i int, result1 []ccv2.Domain, result2 ccv2.Warnings, result3 error) {
	fake.GetOrganizationPrivateDomainsStub = nil
	if fake.getOrganizationPrivateDomainsReturnsOnCall == nil {
		fake.getOrganizationPrivateDomainsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Domain
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getOrganizationPrivateDomainsReturnsOnCall[i] = struct {
		result1 []ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetOrganizationQuota(guid string) (ccv2.OrganizationQuota, ccv2.Warnings, error) {
	fake.getOrganizationQuotaMutex.Lock()
	ret, specificReturn := fake.getOrganizationQuotaReturnsOnCall[len(fake.getOrganizationQuotaArgsForCall)]
	fake.getOrganizationQuotaArgsForCall = append(fake.getOrganizationQuotaArgsForCall, struct {
		guid string
	}{guid})
	fake.recordInvocation("GetOrganizationQuota", []interface{}{guid})
	fake.getOrganizationQuotaMutex.Unlock()
	if fake.GetOrganizationQuotaStub != nil {
		return fake.GetOrganizationQuotaStub(guid)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getOrganizationQuotaReturns.result1, fake.getOrganizationQuotaReturns.result2, fake.getOrganizationQuotaReturns.result3
}

func (fake *FakeCloudControllerClient) GetOrganizationQuotaCallCount() int {
	fake.getOrganizationQuotaMutex.RLock()
	defer fake.getOrganizationQuotaMutex.RUnlock()
	return len(fake.getOrganizationQuotaArgsForCall)
}

func (fake *FakeCloudControllerClient) GetOrganizationQuotaArgsForCall(i int) string {
	fake.getOrganizationQuotaMutex.RLock()
	defer fake.getOrganizationQuotaMutex.RUnlock()
	return fake.getOrganizationQuotaArgsForCall[i].guid
}

func (fake *FakeCloudControllerClient) GetOrganizationQuotaReturns(result1 ccv2.OrganizationQuota, result2 ccv2.Warnings, result3 error) {
	fake.GetOrganizationQuotaStub = nil
	fake.getOrganizationQuotaReturns = struct {
		result1 ccv2.OrganizationQuota
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetOrganizationQuotaReturnsOnCall(i int, result1 ccv2.OrganizationQuota, result2 ccv2.Warnings, result3 error) {
	fake.GetOrganizationQuotaStub = nil
	if fake.getOrganizationQuotaReturnsOnCall == nil {
		fake.getOrganizationQuotaReturnsOnCall = make(map[int]struct {
			result1 ccv2.OrganizationQuota
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getOrganizationQuotaReturnsOnCall[i] = struct {
		result1 ccv2.OrganizationQuota
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetOrganizations(filters ...ccv2.Filter) ([]ccv2.Organization, ccv2.Warnings, error) {
	fake.getOrganizationsMutex.Lock()
	ret, specificReturn := fake.getOrganizationsReturnsOnCall[len(fake.getOrganizationsArgsForCall)]
	fake.getOrganizationsArgsForCall = append(fake.getOrganizationsArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetOrganizations", []interface{}{filters})
	fake.getOrganizationsMutex.Unlock()
	if fake.GetOrganizationsStub != nil {
		return fake.GetOrganizationsStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getOrganizationsReturns.result1, fake.getOrganizationsReturns.result2, fake.getOrganizationsReturns.result3
}

func (fake *FakeCloudControllerClient) GetOrganizationsCallCount() int {
	fake.getOrganizationsMutex.RLock()
	defer fake.getOrganizationsMutex.RUnlock()
	return len(fake.getOrganizationsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetOrganizationsArgsForCall(i int) []ccv2.Filter {
	fake.getOrganizationsMutex.RLock()
	defer fake.getOrganizationsMutex.RUnlock()
	return fake.getOrganizationsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetOrganizationsReturns(result1 []ccv2.Organization, result2 ccv2.Warnings, result3 error) {
	fake.GetOrganizationsStub = nil
	fake.getOrganizationsReturns = struct {
		result1 []ccv2.Organization
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetOrganizationsReturnsOnCall(i int, result1 []ccv2.Organization, result2 ccv2.Warnings, result3 error) {
	fake.GetOrganizationsStub = nil
	if fake.getOrganizationsReturnsOnCall == nil {
		fake.getOrganizationsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Organization
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getOrganizationsReturnsOnCall[i] = struct {
		result1 []ccv2.Organization
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetPrivateDomain(domainGUID string) (ccv2.Domain, ccv2.Warnings, error) {
	fake.getPrivateDomainMutex.Lock()
	ret, specificReturn := fake.getPrivateDomainReturnsOnCall[len(fake.getPrivateDomainArgsForCall)]
	fake.getPrivateDomainArgsForCall = append(fake.getPrivateDomainArgsForCall, struct {
		domainGUID string
	}{domainGUID})
	fake.recordInvocation("GetPrivateDomain", []interface{}{domainGUID})
	fake.getPrivateDomainMutex.Unlock()
	if fake.GetPrivateDomainStub != nil {
		return fake.GetPrivateDomainStub(domainGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getPrivateDomainReturns.result1, fake.getPrivateDomainReturns.result2, fake.getPrivateDomainReturns.result3
}

func (fake *FakeCloudControllerClient) GetPrivateDomainCallCount() int {
	fake.getPrivateDomainMutex.RLock()
	defer fake.getPrivateDomainMutex.RUnlock()
	return len(fake.getPrivateDomainArgsForCall)
}

func (fake *FakeCloudControllerClient) GetPrivateDomainArgsForCall(i int) string {
	fake.getPrivateDomainMutex.RLock()
	defer fake.getPrivateDomainMutex.RUnlock()
	return fake.getPrivateDomainArgsForCall[i].domainGUID
}

func (fake *FakeCloudControllerClient) GetPrivateDomainReturns(result1 ccv2.Domain, result2 ccv2.Warnings, result3 error) {
	fake.GetPrivateDomainStub = nil
	fake.getPrivateDomainReturns = struct {
		result1 ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetPrivateDomainReturnsOnCall(i int, result1 ccv2.Domain, result2 ccv2.Warnings, result3 error) {
	fake.GetPrivateDomainStub = nil
	if fake.getPrivateDomainReturnsOnCall == nil {
		fake.getPrivateDomainReturnsOnCall = make(map[int]struct {
			result1 ccv2.Domain
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getPrivateDomainReturnsOnCall[i] = struct {
		result1 ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetRouteApplications(routeGUID string, filters ...ccv2.Filter) ([]ccv2.Application, ccv2.Warnings, error) {
	fake.getRouteApplicationsMutex.Lock()
	ret, specificReturn := fake.getRouteApplicationsReturnsOnCall[len(fake.getRouteApplicationsArgsForCall)]
	fake.getRouteApplicationsArgsForCall = append(fake.getRouteApplicationsArgsForCall, struct {
		routeGUID string
		filters   []ccv2.Filter
	}{routeGUID, filters})
	fake.recordInvocation("GetRouteApplications", []interface{}{routeGUID, filters})
	fake.getRouteApplicationsMutex.Unlock()
	if fake.GetRouteApplicationsStub != nil {
		return fake.GetRouteApplicationsStub(routeGUID, filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getRouteApplicationsReturns.result1, fake.getRouteApplicationsReturns.result2, fake.getRouteApplicationsReturns.result3
}

func (fake *FakeCloudControllerClient) GetRouteApplicationsCallCount() int {
	fake.getRouteApplicationsMutex.RLock()
	defer fake.getRouteApplicationsMutex.RUnlock()
	return len(fake.getRouteApplicationsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetRouteApplicationsArgsForCall(i int) (string, []ccv2.Filter) {
	fake.getRouteApplicationsMutex.RLock()
	defer fake.getRouteApplicationsMutex.RUnlock()
	return fake.getRouteApplicationsArgsForCall[i].routeGUID, fake.getRouteApplicationsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetRouteApplicationsReturns(result1 []ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.GetRouteApplicationsStub = nil
	fake.getRouteApplicationsReturns = struct {
		result1 []ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetRouteApplicationsReturnsOnCall(i int, result1 []ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.GetRouteApplicationsStub = nil
	if fake.getRouteApplicationsReturnsOnCall == nil {
		fake.getRouteApplicationsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Application
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getRouteApplicationsReturnsOnCall[i] = struct {
		result1 []ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetRoutes(filters ...ccv2.Filter) ([]ccv2.Route, ccv2.Warnings, error) {
	fake.getRoutesMutex.Lock()
	ret, specificReturn := fake.getRoutesReturnsOnCall[len(fake.getRoutesArgsForCall)]
	fake.getRoutesArgsForCall = append(fake.getRoutesArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetRoutes", []interface{}{filters})
	fake.getRoutesMutex.Unlock()
	if fake.GetRoutesStub != nil {
		return fake.GetRoutesStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getRoutesReturns.result1, fake.getRoutesReturns.result2, fake.getRoutesReturns.result3
}

func (fake *FakeCloudControllerClient) GetRoutesCallCount() int {
	fake.getRoutesMutex.RLock()
	defer fake.getRoutesMutex.RUnlock()
	return len(fake.getRoutesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetRoutesArgsForCall(i int) []ccv2.Filter {
	fake.getRoutesMutex.RLock()
	defer fake.getRoutesMutex.RUnlock()
	return fake.getRoutesArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetRoutesReturns(result1 []ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.GetRoutesStub = nil
	fake.getRoutesReturns = struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetRoutesReturnsOnCall(i int, result1 []ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.GetRoutesStub = nil
	if fake.getRoutesReturnsOnCall == nil {
		fake.getRoutesReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Route
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getRoutesReturnsOnCall[i] = struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSecurityGroupSpaces(securityGroupGUID string) ([]ccv2.Space, ccv2.Warnings, error) {
	fake.getSecurityGroupSpacesMutex.Lock()
	ret, specificReturn := fake.getSecurityGroupSpacesReturnsOnCall[len(fake.getSecurityGroupSpacesArgsForCall)]
	fake.getSecurityGroupSpacesArgsForCall = append(fake.getSecurityGroupSpacesArgsForCall, struct {
		securityGroupGUID string
	}{securityGroupGUID})
	fake.recordInvocation("GetSecurityGroupSpaces", []interface{}{securityGroupGUID})
	fake.getSecurityGroupSpacesMutex.Unlock()
	if fake.GetSecurityGroupSpacesStub != nil {
		return fake.GetSecurityGroupSpacesStub(securityGroupGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSecurityGroupSpacesReturns.result1, fake.getSecurityGroupSpacesReturns.result2, fake.getSecurityGroupSpacesReturns.result3
}

func (fake *FakeCloudControllerClient) GetSecurityGroupSpacesCallCount() int {
	fake.getSecurityGroupSpacesMutex.RLock()
	defer fake.getSecurityGroupSpacesMutex.RUnlock()
	return len(fake.getSecurityGroupSpacesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSecurityGroupSpacesArgsForCall(i int) string {
	fake.getSecurityGroupSpacesMutex.RLock()
	defer fake.getSecurityGroupSpacesMutex.RUnlock()
	return fake.getSecurityGroupSpacesArgsForCall[i].securityGroupGUID
}

func (fake *FakeCloudControllerClient) GetSecurityGroupSpacesReturns(result1 []ccv2.Space, result2 ccv2.Warnings, result3 error) {
	fake.GetSecurityGroupSpacesStub = nil
	fake.getSecurityGroupSpacesReturns = struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSecurityGroupSpacesReturnsOnCall(i int, result1 []ccv2.Space, result2 ccv2.Warnings, result3 error) {
	fake.GetSecurityGroupSpacesStub = nil
	if fake.getSecurityGroupSpacesReturnsOnCall == nil {
		fake.getSecurityGroupSpacesReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Space
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSecurityGroupSpacesReturnsOnCall[i] = struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSecurityGroupStagingSpaces(securityGroupGUID string) ([]ccv2.Space, ccv2.Warnings, error) {
	fake.getSecurityGroupStagingSpacesMutex.Lock()
	ret, specificReturn := fake.getSecurityGroupStagingSpacesReturnsOnCall[len(fake.getSecurityGroupStagingSpacesArgsForCall)]
	fake.getSecurityGroupStagingSpacesArgsForCall = append(fake.getSecurityGroupStagingSpacesArgsForCall, struct {
		securityGroupGUID string
	}{securityGroupGUID})
	fake.recordInvocation("GetSecurityGroupStagingSpaces", []interface{}{securityGroupGUID})
	fake.getSecurityGroupStagingSpacesMutex.Unlock()
	if fake.GetSecurityGroupStagingSpacesStub != nil {
		return fake.GetSecurityGroupStagingSpacesStub(securityGroupGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSecurityGroupStagingSpacesReturns.result1, fake.getSecurityGroupStagingSpacesReturns.result2, fake.getSecurityGroupStagingSpacesReturns.result3
}

func (fake *FakeCloudControllerClient) GetSecurityGroupStagingSpacesCallCount() int {
	fake.getSecurityGroupStagingSpacesMutex.RLock()
	defer fake.getSecurityGroupStagingSpacesMutex.RUnlock()
	return len(fake.getSecurityGroupStagingSpacesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSecurityGroupStagingSpacesArgsForCall(i int) string {
	fake.getSecurityGroupStagingSpacesMutex.RLock()
	defer fake.getSecurityGroupStagingSpacesMutex.RUnlock()
	return fake.getSecurityGroupStagingSpacesArgsForCall[i].securityGroupGUID
}

func (fake *FakeCloudControllerClient) GetSecurityGroupStagingSpacesReturns(result1 []ccv2.Space, result2 ccv2.Warnings, result3 error) {
	fake.GetSecurityGroupStagingSpacesStub = nil
	fake.getSecurityGroupStagingSpacesReturns = struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSecurityGroupStagingSpacesReturnsOnCall(i int, result1 []ccv2.Space, result2 ccv2.Warnings, result3 error) {
	fake.GetSecurityGroupStagingSpacesStub = nil
	if fake.getSecurityGroupStagingSpacesReturnsOnCall == nil {
		fake.getSecurityGroupStagingSpacesReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Space
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSecurityGroupStagingSpacesReturnsOnCall[i] = struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSecurityGroups(filters ...ccv2.Filter) ([]ccv2.SecurityGroup, ccv2.Warnings, error) {
	fake.getSecurityGroupsMutex.Lock()
	ret, specificReturn := fake.getSecurityGroupsReturnsOnCall[len(fake.getSecurityGroupsArgsForCall)]
	fake.getSecurityGroupsArgsForCall = append(fake.getSecurityGroupsArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetSecurityGroups", []interface{}{filters})
	fake.getSecurityGroupsMutex.Unlock()
	if fake.GetSecurityGroupsStub != nil {
		return fake.GetSecurityGroupsStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSecurityGroupsReturns.result1, fake.getSecurityGroupsReturns.result2, fake.getSecurityGroupsReturns.result3
}

func (fake *FakeCloudControllerClient) GetSecurityGroupsCallCount() int {
	fake.getSecurityGroupsMutex.RLock()
	defer fake.getSecurityGroupsMutex.RUnlock()
	return len(fake.getSecurityGroupsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSecurityGroupsArgsForCall(i int) []ccv2.Filter {
	fake.getSecurityGroupsMutex.RLock()
	defer fake.getSecurityGroupsMutex.RUnlock()
	return fake.getSecurityGroupsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetSecurityGroupsReturns(result1 []ccv2.SecurityGroup, result2 ccv2.Warnings, result3 error) {
	fake.GetSecurityGroupsStub = nil
	fake.getSecurityGroupsReturns = struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSecurityGroupsReturnsOnCall(i int, result1 []ccv2.SecurityGroup, result2 ccv2.Warnings, result3 error) {
	fake.GetSecurityGroupsStub = nil
	if fake.getSecurityGroupsReturnsOnCall == nil {
		fake.getSecurityGroupsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.SecurityGroup
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSecurityGroupsReturnsOnCall[i] = struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetService(serviceGUID string) (ccv2.Service, ccv2.Warnings, error) {
	fake.getServiceMutex.Lock()
	ret, specificReturn := fake.getServiceReturnsOnCall[len(fake.getServiceArgsForCall)]
	fake.getServiceArgsForCall = append(fake.getServiceArgsForCall, struct {
		serviceGUID string
	}{serviceGUID})
	fake.recordInvocation("GetService", []interface{}{serviceGUID})
	fake.getServiceMutex.Unlock()
	if fake.GetServiceStub != nil {
		return fake.GetServiceStub(serviceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceReturns.result1, fake.getServiceReturns.result2, fake.getServiceReturns.result3
}

func (fake *FakeCloudControllerClient) GetServiceCallCount() int {
	fake.getServiceMutex.RLock()
	defer fake.getServiceMutex.RUnlock()
	return len(fake.getServiceArgsForCall)
}

func (fake *FakeCloudControllerClient) GetServiceArgsForCall(i int) string {
	fake.getServiceMutex.RLock()
	defer fake.getServiceMutex.RUnlock()
	return fake.getServiceArgsForCall[i].serviceGUID
}

func (fake *FakeCloudControllerClient) GetServiceReturns(result1 ccv2.Service, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceStub = nil
	fake.getServiceReturns = struct {
		result1 ccv2.Service
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceReturnsOnCall(i int, result1 ccv2.Service, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceStub = nil
	if fake.getServiceReturnsOnCall == nil {
		fake.getServiceReturnsOnCall = make(map[int]struct {
			result1 ccv2.Service
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getServiceReturnsOnCall[i] = struct {
		result1 ccv2.Service
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceBindings(filters ...ccv2.Filter) ([]ccv2.ServiceBinding, ccv2.Warnings, error) {
	fake.getServiceBindingsMutex.Lock()
	ret, specificReturn := fake.getServiceBindingsReturnsOnCall[len(fake.getServiceBindingsArgsForCall)]
	fake.getServiceBindingsArgsForCall = append(fake.getServiceBindingsArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetServiceBindings", []interface{}{filters})
	fake.getServiceBindingsMutex.Unlock()
	if fake.GetServiceBindingsStub != nil {
		return fake.GetServiceBindingsStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceBindingsReturns.result1, fake.getServiceBindingsReturns.result2, fake.getServiceBindingsReturns.result3
}

func (fake *FakeCloudControllerClient) GetServiceBindingsCallCount() int {
	fake.getServiceBindingsMutex.RLock()
	defer fake.getServiceBindingsMutex.RUnlock()
	return len(fake.getServiceBindingsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetServiceBindingsArgsForCall(i int) []ccv2.Filter {
	fake.getServiceBindingsMutex.RLock()
	defer fake.getServiceBindingsMutex.RUnlock()
	return fake.getServiceBindingsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetServiceBindingsReturns(result1 []ccv2.ServiceBinding, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceBindingsStub = nil
	fake.getServiceBindingsReturns = struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceBindingsReturnsOnCall(i int, result1 []ccv2.ServiceBinding, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceBindingsStub = nil
	if fake.getServiceBindingsReturnsOnCall == nil {
		fake.getServiceBindingsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.ServiceBinding
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getServiceBindingsReturnsOnCall[i] = struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstance(serviceInstanceGUID string) (ccv2.ServiceInstance, ccv2.Warnings, error) {
	fake.getServiceInstanceMutex.Lock()
	ret, specificReturn := fake.getServiceInstanceReturnsOnCall[len(fake.getServiceInstanceArgsForCall)]
	fake.getServiceInstanceArgsForCall = append(fake.getServiceInstanceArgsForCall, struct {
		serviceInstanceGUID string
	}{serviceInstanceGUID})
	fake.recordInvocation("GetServiceInstance", []interface{}{serviceInstanceGUID})
	fake.getServiceInstanceMutex.Unlock()
	if fake.GetServiceInstanceStub != nil {
		return fake.GetServiceInstanceStub(serviceInstanceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceInstanceReturns.result1, fake.getServiceInstanceReturns.result2, fake.getServiceInstanceReturns.result3
}

func (fake *FakeCloudControllerClient) GetServiceInstanceCallCount() int {
	fake.getServiceInstanceMutex.RLock()
	defer fake.getServiceInstanceMutex.RUnlock()
	return len(fake.getServiceInstanceArgsForCall)
}

func (fake *FakeCloudControllerClient) GetServiceInstanceArgsForCall(i int) string {
	fake.getServiceInstanceMutex.RLock()
	defer fake.getServiceInstanceMutex.RUnlock()
	return fake.getServiceInstanceArgsForCall[i].serviceInstanceGUID
}

func (fake *FakeCloudControllerClient) GetServiceInstanceReturns(result1 ccv2.ServiceInstance, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstanceStub = nil
	fake.getServiceInstanceReturns = struct {
		result1 ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstanceReturnsOnCall(i int, result1 ccv2.ServiceInstance, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstanceStub = nil
	if fake.getServiceInstanceReturnsOnCall == nil {
		fake.getServiceInstanceReturnsOnCall = make(map[int]struct {
			result1 ccv2.ServiceInstance
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getServiceInstanceReturnsOnCall[i] = struct {
		result1 ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstanceServiceBindings(serviceInstanceGUID string) ([]ccv2.ServiceBinding, ccv2.Warnings, error) {
	fake.getServiceInstanceServiceBindingsMutex.Lock()
	ret, specificReturn := fake.getServiceInstanceServiceBindingsReturnsOnCall[len(fake.getServiceInstanceServiceBindingsArgsForCall)]
	fake.getServiceInstanceServiceBindingsArgsForCall = append(fake.getServiceInstanceServiceBindingsArgsForCall, struct {
		serviceInstanceGUID string
	}{serviceInstanceGUID})
	fake.recordInvocation("GetServiceInstanceServiceBindings", []interface{}{serviceInstanceGUID})
	fake.getServiceInstanceServiceBindingsMutex.Unlock()
	if fake.GetServiceInstanceServiceBindingsStub != nil {
		return fake.GetServiceInstanceServiceBindingsStub(serviceInstanceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceInstanceServiceBindingsReturns.result1, fake.getServiceInstanceServiceBindingsReturns.result2, fake.getServiceInstanceServiceBindingsReturns.result3
}

func (fake *FakeCloudControllerClient) GetServiceInstanceServiceBindingsCallCount() int {
	fake.getServiceInstanceServiceBindingsMutex.RLock()
	defer fake.getServiceInstanceServiceBindingsMutex.RUnlock()
	return len(fake.getServiceInstanceServiceBindingsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetServiceInstanceServiceBindingsArgsForCall(i int) string {
	fake.getServiceInstanceServiceBindingsMutex.RLock()
	defer fake.getServiceInstanceServiceBindingsMutex.RUnlock()
	return fake.getServiceInstanceServiceBindingsArgsForCall[i].serviceInstanceGUID
}

func (fake *FakeCloudControllerClient) GetServiceInstanceServiceBindingsReturns(result1 []ccv2.ServiceBinding, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstanceServiceBindingsStub = nil
	fake.getServiceInstanceServiceBindingsReturns = struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstanceServiceBindingsReturnsOnCall(i int, result1 []ccv2.ServiceBinding, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstanceServiceBindingsStub = nil
	if fake.getServiceInstanceServiceBindingsReturnsOnCall == nil {
		fake.getServiceInstanceServiceBindingsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.ServiceBinding
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getServiceInstanceServiceBindingsReturnsOnCall[i] = struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedFrom(serviceInstanceGUID string) (ccv2.ServiceInstanceSharedFrom, ccv2.Warnings, error) {
	fake.getServiceInstanceSharedFromMutex.Lock()
	ret, specificReturn := fake.getServiceInstanceSharedFromReturnsOnCall[len(fake.getServiceInstanceSharedFromArgsForCall)]
	fake.getServiceInstanceSharedFromArgsForCall = append(fake.getServiceInstanceSharedFromArgsForCall, struct {
		serviceInstanceGUID string
	}{serviceInstanceGUID})
	fake.recordInvocation("GetServiceInstanceSharedFrom", []interface{}{serviceInstanceGUID})
	fake.getServiceInstanceSharedFromMutex.Unlock()
	if fake.GetServiceInstanceSharedFromStub != nil {
		return fake.GetServiceInstanceSharedFromStub(serviceInstanceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceInstanceSharedFromReturns.result1, fake.getServiceInstanceSharedFromReturns.result2, fake.getServiceInstanceSharedFromReturns.result3
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedFromCallCount() int {
	fake.getServiceInstanceSharedFromMutex.RLock()
	defer fake.getServiceInstanceSharedFromMutex.RUnlock()
	return len(fake.getServiceInstanceSharedFromArgsForCall)
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedFromArgsForCall(i int) string {
	fake.getServiceInstanceSharedFromMutex.RLock()
	defer fake.getServiceInstanceSharedFromMutex.RUnlock()
	return fake.getServiceInstanceSharedFromArgsForCall[i].serviceInstanceGUID
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedFromReturns(result1 ccv2.ServiceInstanceSharedFrom, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstanceSharedFromStub = nil
	fake.getServiceInstanceSharedFromReturns = struct {
		result1 ccv2.ServiceInstanceSharedFrom
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedFromReturnsOnCall(i int, result1 ccv2.ServiceInstanceSharedFrom, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstanceSharedFromStub = nil
	if fake.getServiceInstanceSharedFromReturnsOnCall == nil {
		fake.getServiceInstanceSharedFromReturnsOnCall = make(map[int]struct {
			result1 ccv2.ServiceInstanceSharedFrom
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getServiceInstanceSharedFromReturnsOnCall[i] = struct {
		result1 ccv2.ServiceInstanceSharedFrom
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedTos(serviceInstanceGUID string) ([]ccv2.ServiceInstanceSharedTo, ccv2.Warnings, error) {
	fake.getServiceInstanceSharedTosMutex.Lock()
	ret, specificReturn := fake.getServiceInstanceSharedTosReturnsOnCall[len(fake.getServiceInstanceSharedTosArgsForCall)]
	fake.getServiceInstanceSharedTosArgsForCall = append(fake.getServiceInstanceSharedTosArgsForCall, struct {
		serviceInstanceGUID string
	}{serviceInstanceGUID})
	fake.recordInvocation("GetServiceInstanceSharedTos", []interface{}{serviceInstanceGUID})
	fake.getServiceInstanceSharedTosMutex.Unlock()
	if fake.GetServiceInstanceSharedTosStub != nil {
		return fake.GetServiceInstanceSharedTosStub(serviceInstanceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceInstanceSharedTosReturns.result1, fake.getServiceInstanceSharedTosReturns.result2, fake.getServiceInstanceSharedTosReturns.result3
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedTosCallCount() int {
	fake.getServiceInstanceSharedTosMutex.RLock()
	defer fake.getServiceInstanceSharedTosMutex.RUnlock()
	return len(fake.getServiceInstanceSharedTosArgsForCall)
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedTosArgsForCall(i int) string {
	fake.getServiceInstanceSharedTosMutex.RLock()
	defer fake.getServiceInstanceSharedTosMutex.RUnlock()
	return fake.getServiceInstanceSharedTosArgsForCall[i].serviceInstanceGUID
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedTosReturns(result1 []ccv2.ServiceInstanceSharedTo, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstanceSharedTosStub = nil
	fake.getServiceInstanceSharedTosReturns = struct {
		result1 []ccv2.ServiceInstanceSharedTo
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstanceSharedTosReturnsOnCall(i int, result1 []ccv2.ServiceInstanceSharedTo, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstanceSharedTosStub = nil
	if fake.getServiceInstanceSharedTosReturnsOnCall == nil {
		fake.getServiceInstanceSharedTosReturnsOnCall = make(map[int]struct {
			result1 []ccv2.ServiceInstanceSharedTo
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getServiceInstanceSharedTosReturnsOnCall[i] = struct {
		result1 []ccv2.ServiceInstanceSharedTo
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstances(filters ...ccv2.Filter) ([]ccv2.ServiceInstance, ccv2.Warnings, error) {
	fake.getServiceInstancesMutex.Lock()
	ret, specificReturn := fake.getServiceInstancesReturnsOnCall[len(fake.getServiceInstancesArgsForCall)]
	fake.getServiceInstancesArgsForCall = append(fake.getServiceInstancesArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetServiceInstances", []interface{}{filters})
	fake.getServiceInstancesMutex.Unlock()
	if fake.GetServiceInstancesStub != nil {
		return fake.GetServiceInstancesStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceInstancesReturns.result1, fake.getServiceInstancesReturns.result2, fake.getServiceInstancesReturns.result3
}

func (fake *FakeCloudControllerClient) GetServiceInstancesCallCount() int {
	fake.getServiceInstancesMutex.RLock()
	defer fake.getServiceInstancesMutex.RUnlock()
	return len(fake.getServiceInstancesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetServiceInstancesArgsForCall(i int) []ccv2.Filter {
	fake.getServiceInstancesMutex.RLock()
	defer fake.getServiceInstancesMutex.RUnlock()
	return fake.getServiceInstancesArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetServiceInstancesReturns(result1 []ccv2.ServiceInstance, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstancesStub = nil
	fake.getServiceInstancesReturns = struct {
		result1 []ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServiceInstancesReturnsOnCall(i int, result1 []ccv2.ServiceInstance, result2 ccv2.Warnings, result3 error) {
	fake.GetServiceInstancesStub = nil
	if fake.getServiceInstancesReturnsOnCall == nil {
		fake.getServiceInstancesReturnsOnCall = make(map[int]struct {
			result1 []ccv2.ServiceInstance
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getServiceInstancesReturnsOnCall[i] = struct {
		result1 []ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServicePlan(servicePlanGUID string) (ccv2.ServicePlan, ccv2.Warnings, error) {
	fake.getServicePlanMutex.Lock()
	ret, specificReturn := fake.getServicePlanReturnsOnCall[len(fake.getServicePlanArgsForCall)]
	fake.getServicePlanArgsForCall = append(fake.getServicePlanArgsForCall, struct {
		servicePlanGUID string
	}{servicePlanGUID})
	fake.recordInvocation("GetServicePlan", []interface{}{servicePlanGUID})
	fake.getServicePlanMutex.Unlock()
	if fake.GetServicePlanStub != nil {
		return fake.GetServicePlanStub(servicePlanGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServicePlanReturns.result1, fake.getServicePlanReturns.result2, fake.getServicePlanReturns.result3
}

func (fake *FakeCloudControllerClient) GetServicePlanCallCount() int {
	fake.getServicePlanMutex.RLock()
	defer fake.getServicePlanMutex.RUnlock()
	return len(fake.getServicePlanArgsForCall)
}

func (fake *FakeCloudControllerClient) GetServicePlanArgsForCall(i int) string {
	fake.getServicePlanMutex.RLock()
	defer fake.getServicePlanMutex.RUnlock()
	return fake.getServicePlanArgsForCall[i].servicePlanGUID
}

func (fake *FakeCloudControllerClient) GetServicePlanReturns(result1 ccv2.ServicePlan, result2 ccv2.Warnings, result3 error) {
	fake.GetServicePlanStub = nil
	fake.getServicePlanReturns = struct {
		result1 ccv2.ServicePlan
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetServicePlanReturnsOnCall(i int, result1 ccv2.ServicePlan, result2 ccv2.Warnings, result3 error) {
	fake.GetServicePlanStub = nil
	if fake.getServicePlanReturnsOnCall == nil {
		fake.getServicePlanReturnsOnCall = make(map[int]struct {
			result1 ccv2.ServicePlan
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getServicePlanReturnsOnCall[i] = struct {
		result1 ccv2.ServicePlan
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSharedDomain(domainGUID string) (ccv2.Domain, ccv2.Warnings, error) {
	fake.getSharedDomainMutex.Lock()
	ret, specificReturn := fake.getSharedDomainReturnsOnCall[len(fake.getSharedDomainArgsForCall)]
	fake.getSharedDomainArgsForCall = append(fake.getSharedDomainArgsForCall, struct {
		domainGUID string
	}{domainGUID})
	fake.recordInvocation("GetSharedDomain", []interface{}{domainGUID})
	fake.getSharedDomainMutex.Unlock()
	if fake.GetSharedDomainStub != nil {
		return fake.GetSharedDomainStub(domainGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSharedDomainReturns.result1, fake.getSharedDomainReturns.result2, fake.getSharedDomainReturns.result3
}

func (fake *FakeCloudControllerClient) GetSharedDomainCallCount() int {
	fake.getSharedDomainMutex.RLock()
	defer fake.getSharedDomainMutex.RUnlock()
	return len(fake.getSharedDomainArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSharedDomainArgsForCall(i int) string {
	fake.getSharedDomainMutex.RLock()
	defer fake.getSharedDomainMutex.RUnlock()
	return fake.getSharedDomainArgsForCall[i].domainGUID
}

func (fake *FakeCloudControllerClient) GetSharedDomainReturns(result1 ccv2.Domain, result2 ccv2.Warnings, result3 error) {
	fake.GetSharedDomainStub = nil
	fake.getSharedDomainReturns = struct {
		result1 ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSharedDomainReturnsOnCall(i int, result1 ccv2.Domain, result2 ccv2.Warnings, result3 error) {
	fake.GetSharedDomainStub = nil
	if fake.getSharedDomainReturnsOnCall == nil {
		fake.getSharedDomainReturnsOnCall = make(map[int]struct {
			result1 ccv2.Domain
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSharedDomainReturnsOnCall[i] = struct {
		result1 ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSharedDomains(filters ...ccv2.Filter) ([]ccv2.Domain, ccv2.Warnings, error) {
	fake.getSharedDomainsMutex.Lock()
	ret, specificReturn := fake.getSharedDomainsReturnsOnCall[len(fake.getSharedDomainsArgsForCall)]
	fake.getSharedDomainsArgsForCall = append(fake.getSharedDomainsArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetSharedDomains", []interface{}{filters})
	fake.getSharedDomainsMutex.Unlock()
	if fake.GetSharedDomainsStub != nil {
		return fake.GetSharedDomainsStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSharedDomainsReturns.result1, fake.getSharedDomainsReturns.result2, fake.getSharedDomainsReturns.result3
}

func (fake *FakeCloudControllerClient) GetSharedDomainsCallCount() int {
	fake.getSharedDomainsMutex.RLock()
	defer fake.getSharedDomainsMutex.RUnlock()
	return len(fake.getSharedDomainsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSharedDomainsArgsForCall(i int) []ccv2.Filter {
	fake.getSharedDomainsMutex.RLock()
	defer fake.getSharedDomainsMutex.RUnlock()
	return fake.getSharedDomainsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetSharedDomainsReturns(result1 []ccv2.Domain, result2 ccv2.Warnings, result3 error) {
	fake.GetSharedDomainsStub = nil
	fake.getSharedDomainsReturns = struct {
		result1 []ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSharedDomainsReturnsOnCall(i int, result1 []ccv2.Domain, result2 ccv2.Warnings, result3 error) {
	fake.GetSharedDomainsStub = nil
	if fake.getSharedDomainsReturnsOnCall == nil {
		fake.getSharedDomainsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Domain
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSharedDomainsReturnsOnCall[i] = struct {
		result1 []ccv2.Domain
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceQuotaDefinition(guid string) (ccv2.SpaceQuota, ccv2.Warnings, error) {
	fake.getSpaceQuotaDefinitionMutex.Lock()
	ret, specificReturn := fake.getSpaceQuotaDefinitionReturnsOnCall[len(fake.getSpaceQuotaDefinitionArgsForCall)]
	fake.getSpaceQuotaDefinitionArgsForCall = append(fake.getSpaceQuotaDefinitionArgsForCall, struct {
		guid string
	}{guid})
	fake.recordInvocation("GetSpaceQuotaDefinition", []interface{}{guid})
	fake.getSpaceQuotaDefinitionMutex.Unlock()
	if fake.GetSpaceQuotaDefinitionStub != nil {
		return fake.GetSpaceQuotaDefinitionStub(guid)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSpaceQuotaDefinitionReturns.result1, fake.getSpaceQuotaDefinitionReturns.result2, fake.getSpaceQuotaDefinitionReturns.result3
}

func (fake *FakeCloudControllerClient) GetSpaceQuotaDefinitionCallCount() int {
	fake.getSpaceQuotaDefinitionMutex.RLock()
	defer fake.getSpaceQuotaDefinitionMutex.RUnlock()
	return len(fake.getSpaceQuotaDefinitionArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSpaceQuotaDefinitionArgsForCall(i int) string {
	fake.getSpaceQuotaDefinitionMutex.RLock()
	defer fake.getSpaceQuotaDefinitionMutex.RUnlock()
	return fake.getSpaceQuotaDefinitionArgsForCall[i].guid
}

func (fake *FakeCloudControllerClient) GetSpaceQuotaDefinitionReturns(result1 ccv2.SpaceQuota, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceQuotaDefinitionStub = nil
	fake.getSpaceQuotaDefinitionReturns = struct {
		result1 ccv2.SpaceQuota
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceQuotaDefinitionReturnsOnCall(i int, result1 ccv2.SpaceQuota, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceQuotaDefinitionStub = nil
	if fake.getSpaceQuotaDefinitionReturnsOnCall == nil {
		fake.getSpaceQuotaDefinitionReturnsOnCall = make(map[int]struct {
			result1 ccv2.SpaceQuota
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSpaceQuotaDefinitionReturnsOnCall[i] = struct {
		result1 ccv2.SpaceQuota
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceRoutes(spaceGUID string, filters ...ccv2.Filter) ([]ccv2.Route, ccv2.Warnings, error) {
	fake.getSpaceRoutesMutex.Lock()
	ret, specificReturn := fake.getSpaceRoutesReturnsOnCall[len(fake.getSpaceRoutesArgsForCall)]
	fake.getSpaceRoutesArgsForCall = append(fake.getSpaceRoutesArgsForCall, struct {
		spaceGUID string
		filters   []ccv2.Filter
	}{spaceGUID, filters})
	fake.recordInvocation("GetSpaceRoutes", []interface{}{spaceGUID, filters})
	fake.getSpaceRoutesMutex.Unlock()
	if fake.GetSpaceRoutesStub != nil {
		return fake.GetSpaceRoutesStub(spaceGUID, filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSpaceRoutesReturns.result1, fake.getSpaceRoutesReturns.result2, fake.getSpaceRoutesReturns.result3
}

func (fake *FakeCloudControllerClient) GetSpaceRoutesCallCount() int {
	fake.getSpaceRoutesMutex.RLock()
	defer fake.getSpaceRoutesMutex.RUnlock()
	return len(fake.getSpaceRoutesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSpaceRoutesArgsForCall(i int) (string, []ccv2.Filter) {
	fake.getSpaceRoutesMutex.RLock()
	defer fake.getSpaceRoutesMutex.RUnlock()
	return fake.getSpaceRoutesArgsForCall[i].spaceGUID, fake.getSpaceRoutesArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetSpaceRoutesReturns(result1 []ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceRoutesStub = nil
	fake.getSpaceRoutesReturns = struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceRoutesReturnsOnCall(i int, result1 []ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceRoutesStub = nil
	if fake.getSpaceRoutesReturnsOnCall == nil {
		fake.getSpaceRoutesReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Route
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSpaceRoutesReturnsOnCall[i] = struct {
		result1 []ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceSecurityGroups(spaceGUID string, filters ...ccv2.Filter) ([]ccv2.SecurityGroup, ccv2.Warnings, error) {
	fake.getSpaceSecurityGroupsMutex.Lock()
	ret, specificReturn := fake.getSpaceSecurityGroupsReturnsOnCall[len(fake.getSpaceSecurityGroupsArgsForCall)]
	fake.getSpaceSecurityGroupsArgsForCall = append(fake.getSpaceSecurityGroupsArgsForCall, struct {
		spaceGUID string
		filters   []ccv2.Filter
	}{spaceGUID, filters})
	fake.recordInvocation("GetSpaceSecurityGroups", []interface{}{spaceGUID, filters})
	fake.getSpaceSecurityGroupsMutex.Unlock()
	if fake.GetSpaceSecurityGroupsStub != nil {
		return fake.GetSpaceSecurityGroupsStub(spaceGUID, filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSpaceSecurityGroupsReturns.result1, fake.getSpaceSecurityGroupsReturns.result2, fake.getSpaceSecurityGroupsReturns.result3
}

func (fake *FakeCloudControllerClient) GetSpaceSecurityGroupsCallCount() int {
	fake.getSpaceSecurityGroupsMutex.RLock()
	defer fake.getSpaceSecurityGroupsMutex.RUnlock()
	return len(fake.getSpaceSecurityGroupsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSpaceSecurityGroupsArgsForCall(i int) (string, []ccv2.Filter) {
	fake.getSpaceSecurityGroupsMutex.RLock()
	defer fake.getSpaceSecurityGroupsMutex.RUnlock()
	return fake.getSpaceSecurityGroupsArgsForCall[i].spaceGUID, fake.getSpaceSecurityGroupsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetSpaceSecurityGroupsReturns(result1 []ccv2.SecurityGroup, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceSecurityGroupsStub = nil
	fake.getSpaceSecurityGroupsReturns = struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceSecurityGroupsReturnsOnCall(i int, result1 []ccv2.SecurityGroup, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceSecurityGroupsStub = nil
	if fake.getSpaceSecurityGroupsReturnsOnCall == nil {
		fake.getSpaceSecurityGroupsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.SecurityGroup
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSpaceSecurityGroupsReturnsOnCall[i] = struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceServiceInstances(spaceGUID string, includeUserProvidedServices bool, filters ...ccv2.Filter) ([]ccv2.ServiceInstance, ccv2.Warnings, error) {
	fake.getSpaceServiceInstancesMutex.Lock()
	ret, specificReturn := fake.getSpaceServiceInstancesReturnsOnCall[len(fake.getSpaceServiceInstancesArgsForCall)]
	fake.getSpaceServiceInstancesArgsForCall = append(fake.getSpaceServiceInstancesArgsForCall, struct {
		spaceGUID                   string
		includeUserProvidedServices bool
		filters                     []ccv2.Filter
	}{spaceGUID, includeUserProvidedServices, filters})
	fake.recordInvocation("GetSpaceServiceInstances", []interface{}{spaceGUID, includeUserProvidedServices, filters})
	fake.getSpaceServiceInstancesMutex.Unlock()
	if fake.GetSpaceServiceInstancesStub != nil {
		return fake.GetSpaceServiceInstancesStub(spaceGUID, includeUserProvidedServices, filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSpaceServiceInstancesReturns.result1, fake.getSpaceServiceInstancesReturns.result2, fake.getSpaceServiceInstancesReturns.result3
}

func (fake *FakeCloudControllerClient) GetSpaceServiceInstancesCallCount() int {
	fake.getSpaceServiceInstancesMutex.RLock()
	defer fake.getSpaceServiceInstancesMutex.RUnlock()
	return len(fake.getSpaceServiceInstancesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSpaceServiceInstancesArgsForCall(i int) (string, bool, []ccv2.Filter) {
	fake.getSpaceServiceInstancesMutex.RLock()
	defer fake.getSpaceServiceInstancesMutex.RUnlock()
	return fake.getSpaceServiceInstancesArgsForCall[i].spaceGUID, fake.getSpaceServiceInstancesArgsForCall[i].includeUserProvidedServices, fake.getSpaceServiceInstancesArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetSpaceServiceInstancesReturns(result1 []ccv2.ServiceInstance, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceServiceInstancesStub = nil
	fake.getSpaceServiceInstancesReturns = struct {
		result1 []ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceServiceInstancesReturnsOnCall(i int, result1 []ccv2.ServiceInstance, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceServiceInstancesStub = nil
	if fake.getSpaceServiceInstancesReturnsOnCall == nil {
		fake.getSpaceServiceInstancesReturnsOnCall = make(map[int]struct {
			result1 []ccv2.ServiceInstance
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSpaceServiceInstancesReturnsOnCall[i] = struct {
		result1 []ccv2.ServiceInstance
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceStagingSecurityGroups(spaceGUID string, filters ...ccv2.Filter) ([]ccv2.SecurityGroup, ccv2.Warnings, error) {
	fake.getSpaceStagingSecurityGroupsMutex.Lock()
	ret, specificReturn := fake.getSpaceStagingSecurityGroupsReturnsOnCall[len(fake.getSpaceStagingSecurityGroupsArgsForCall)]
	fake.getSpaceStagingSecurityGroupsArgsForCall = append(fake.getSpaceStagingSecurityGroupsArgsForCall, struct {
		spaceGUID string
		filters   []ccv2.Filter
	}{spaceGUID, filters})
	fake.recordInvocation("GetSpaceStagingSecurityGroups", []interface{}{spaceGUID, filters})
	fake.getSpaceStagingSecurityGroupsMutex.Unlock()
	if fake.GetSpaceStagingSecurityGroupsStub != nil {
		return fake.GetSpaceStagingSecurityGroupsStub(spaceGUID, filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSpaceStagingSecurityGroupsReturns.result1, fake.getSpaceStagingSecurityGroupsReturns.result2, fake.getSpaceStagingSecurityGroupsReturns.result3
}

func (fake *FakeCloudControllerClient) GetSpaceStagingSecurityGroupsCallCount() int {
	fake.getSpaceStagingSecurityGroupsMutex.RLock()
	defer fake.getSpaceStagingSecurityGroupsMutex.RUnlock()
	return len(fake.getSpaceStagingSecurityGroupsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSpaceStagingSecurityGroupsArgsForCall(i int) (string, []ccv2.Filter) {
	fake.getSpaceStagingSecurityGroupsMutex.RLock()
	defer fake.getSpaceStagingSecurityGroupsMutex.RUnlock()
	return fake.getSpaceStagingSecurityGroupsArgsForCall[i].spaceGUID, fake.getSpaceStagingSecurityGroupsArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetSpaceStagingSecurityGroupsReturns(result1 []ccv2.SecurityGroup, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceStagingSecurityGroupsStub = nil
	fake.getSpaceStagingSecurityGroupsReturns = struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaceStagingSecurityGroupsReturnsOnCall(i int, result1 []ccv2.SecurityGroup, result2 ccv2.Warnings, result3 error) {
	fake.GetSpaceStagingSecurityGroupsStub = nil
	if fake.getSpaceStagingSecurityGroupsReturnsOnCall == nil {
		fake.getSpaceStagingSecurityGroupsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.SecurityGroup
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSpaceStagingSecurityGroupsReturnsOnCall[i] = struct {
		result1 []ccv2.SecurityGroup
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpaces(filters ...ccv2.Filter) ([]ccv2.Space, ccv2.Warnings, error) {
	fake.getSpacesMutex.Lock()
	ret, specificReturn := fake.getSpacesReturnsOnCall[len(fake.getSpacesArgsForCall)]
	fake.getSpacesArgsForCall = append(fake.getSpacesArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetSpaces", []interface{}{filters})
	fake.getSpacesMutex.Unlock()
	if fake.GetSpacesStub != nil {
		return fake.GetSpacesStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getSpacesReturns.result1, fake.getSpacesReturns.result2, fake.getSpacesReturns.result3
}

func (fake *FakeCloudControllerClient) GetSpacesCallCount() int {
	fake.getSpacesMutex.RLock()
	defer fake.getSpacesMutex.RUnlock()
	return len(fake.getSpacesArgsForCall)
}

func (fake *FakeCloudControllerClient) GetSpacesArgsForCall(i int) []ccv2.Filter {
	fake.getSpacesMutex.RLock()
	defer fake.getSpacesMutex.RUnlock()
	return fake.getSpacesArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetSpacesReturns(result1 []ccv2.Space, result2 ccv2.Warnings, result3 error) {
	fake.GetSpacesStub = nil
	fake.getSpacesReturns = struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetSpacesReturnsOnCall(i int, result1 []ccv2.Space, result2 ccv2.Warnings, result3 error) {
	fake.GetSpacesStub = nil
	if fake.getSpacesReturnsOnCall == nil {
		fake.getSpacesReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Space
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getSpacesReturnsOnCall[i] = struct {
		result1 []ccv2.Space
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetStack(guid string) (ccv2.Stack, ccv2.Warnings, error) {
	fake.getStackMutex.Lock()
	ret, specificReturn := fake.getStackReturnsOnCall[len(fake.getStackArgsForCall)]
	fake.getStackArgsForCall = append(fake.getStackArgsForCall, struct {
		guid string
	}{guid})
	fake.recordInvocation("GetStack", []interface{}{guid})
	fake.getStackMutex.Unlock()
	if fake.GetStackStub != nil {
		return fake.GetStackStub(guid)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getStackReturns.result1, fake.getStackReturns.result2, fake.getStackReturns.result3
}

func (fake *FakeCloudControllerClient) GetStackCallCount() int {
	fake.getStackMutex.RLock()
	defer fake.getStackMutex.RUnlock()
	return len(fake.getStackArgsForCall)
}

func (fake *FakeCloudControllerClient) GetStackArgsForCall(i int) string {
	fake.getStackMutex.RLock()
	defer fake.getStackMutex.RUnlock()
	return fake.getStackArgsForCall[i].guid
}

func (fake *FakeCloudControllerClient) GetStackReturns(result1 ccv2.Stack, result2 ccv2.Warnings, result3 error) {
	fake.GetStackStub = nil
	fake.getStackReturns = struct {
		result1 ccv2.Stack
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetStackReturnsOnCall(i int, result1 ccv2.Stack, result2 ccv2.Warnings, result3 error) {
	fake.GetStackStub = nil
	if fake.getStackReturnsOnCall == nil {
		fake.getStackReturnsOnCall = make(map[int]struct {
			result1 ccv2.Stack
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getStackReturnsOnCall[i] = struct {
		result1 ccv2.Stack
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetStacks(filters ...ccv2.Filter) ([]ccv2.Stack, ccv2.Warnings, error) {
	fake.getStacksMutex.Lock()
	ret, specificReturn := fake.getStacksReturnsOnCall[len(fake.getStacksArgsForCall)]
	fake.getStacksArgsForCall = append(fake.getStacksArgsForCall, struct {
		filters []ccv2.Filter
	}{filters})
	fake.recordInvocation("GetStacks", []interface{}{filters})
	fake.getStacksMutex.Unlock()
	if fake.GetStacksStub != nil {
		return fake.GetStacksStub(filters...)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getStacksReturns.result1, fake.getStacksReturns.result2, fake.getStacksReturns.result3
}

func (fake *FakeCloudControllerClient) GetStacksCallCount() int {
	fake.getStacksMutex.RLock()
	defer fake.getStacksMutex.RUnlock()
	return len(fake.getStacksArgsForCall)
}

func (fake *FakeCloudControllerClient) GetStacksArgsForCall(i int) []ccv2.Filter {
	fake.getStacksMutex.RLock()
	defer fake.getStacksMutex.RUnlock()
	return fake.getStacksArgsForCall[i].filters
}

func (fake *FakeCloudControllerClient) GetStacksReturns(result1 []ccv2.Stack, result2 ccv2.Warnings, result3 error) {
	fake.GetStacksStub = nil
	fake.getStacksReturns = struct {
		result1 []ccv2.Stack
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetStacksReturnsOnCall(i int, result1 []ccv2.Stack, result2 ccv2.Warnings, result3 error) {
	fake.GetStacksStub = nil
	if fake.getStacksReturnsOnCall == nil {
		fake.getStacksReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Stack
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getStacksReturnsOnCall[i] = struct {
		result1 []ccv2.Stack
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetUserProvidedServiceInstanceServiceBindings(userProvidedServiceInstanceGUID string) ([]ccv2.ServiceBinding, ccv2.Warnings, error) {
	fake.getUserProvidedServiceInstanceServiceBindingsMutex.Lock()
	ret, specificReturn := fake.getUserProvidedServiceInstanceServiceBindingsReturnsOnCall[len(fake.getUserProvidedServiceInstanceServiceBindingsArgsForCall)]
	fake.getUserProvidedServiceInstanceServiceBindingsArgsForCall = append(fake.getUserProvidedServiceInstanceServiceBindingsArgsForCall, struct {
		userProvidedServiceInstanceGUID string
	}{userProvidedServiceInstanceGUID})
	fake.recordInvocation("GetUserProvidedServiceInstanceServiceBindings", []interface{}{userProvidedServiceInstanceGUID})
	fake.getUserProvidedServiceInstanceServiceBindingsMutex.Unlock()
	if fake.GetUserProvidedServiceInstanceServiceBindingsStub != nil {
		return fake.GetUserProvidedServiceInstanceServiceBindingsStub(userProvidedServiceInstanceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getUserProvidedServiceInstanceServiceBindingsReturns.result1, fake.getUserProvidedServiceInstanceServiceBindingsReturns.result2, fake.getUserProvidedServiceInstanceServiceBindingsReturns.result3
}

func (fake *FakeCloudControllerClient) GetUserProvidedServiceInstanceServiceBindingsCallCount() int {
	fake.getUserProvidedServiceInstanceServiceBindingsMutex.RLock()
	defer fake.getUserProvidedServiceInstanceServiceBindingsMutex.RUnlock()
	return len(fake.getUserProvidedServiceInstanceServiceBindingsArgsForCall)
}

func (fake *FakeCloudControllerClient) GetUserProvidedServiceInstanceServiceBindingsArgsForCall(i int) string {
	fake.getUserProvidedServiceInstanceServiceBindingsMutex.RLock()
	defer fake.getUserProvidedServiceInstanceServiceBindingsMutex.RUnlock()
	return fake.getUserProvidedServiceInstanceServiceBindingsArgsForCall[i].userProvidedServiceInstanceGUID
}

func (fake *FakeCloudControllerClient) GetUserProvidedServiceInstanceServiceBindingsReturns(result1 []ccv2.ServiceBinding, result2 ccv2.Warnings, result3 error) {
	fake.GetUserProvidedServiceInstanceServiceBindingsStub = nil
	fake.getUserProvidedServiceInstanceServiceBindingsReturns = struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) GetUserProvidedServiceInstanceServiceBindingsReturnsOnCall(i int, result1 []ccv2.ServiceBinding, result2 ccv2.Warnings, result3 error) {
	fake.GetUserProvidedServiceInstanceServiceBindingsStub = nil
	if fake.getUserProvidedServiceInstanceServiceBindingsReturnsOnCall == nil {
		fake.getUserProvidedServiceInstanceServiceBindingsReturnsOnCall = make(map[int]struct {
			result1 []ccv2.ServiceBinding
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.getUserProvidedServiceInstanceServiceBindingsReturnsOnCall[i] = struct {
		result1 []ccv2.ServiceBinding
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) PollJob(job ccv2.Job) (ccv2.Warnings, error) {
	fake.pollJobMutex.Lock()
	ret, specificReturn := fake.pollJobReturnsOnCall[len(fake.pollJobArgsForCall)]
	fake.pollJobArgsForCall = append(fake.pollJobArgsForCall, struct {
		job ccv2.Job
	}{job})
	fake.recordInvocation("PollJob", []interface{}{job})
	fake.pollJobMutex.Unlock()
	if fake.PollJobStub != nil {
		return fake.PollJobStub(job)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.pollJobReturns.result1, fake.pollJobReturns.result2
}

func (fake *FakeCloudControllerClient) PollJobCallCount() int {
	fake.pollJobMutex.RLock()
	defer fake.pollJobMutex.RUnlock()
	return len(fake.pollJobArgsForCall)
}

func (fake *FakeCloudControllerClient) PollJobArgsForCall(i int) ccv2.Job {
	fake.pollJobMutex.RLock()
	defer fake.pollJobMutex.RUnlock()
	return fake.pollJobArgsForCall[i].job
}

func (fake *FakeCloudControllerClient) PollJobReturns(result1 ccv2.Warnings, result2 error) {
	fake.PollJobStub = nil
	fake.pollJobReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) PollJobReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.PollJobStub = nil
	if fake.pollJobReturnsOnCall == nil {
		fake.pollJobReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.pollJobReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) RestageApplication(app ccv2.Application) (ccv2.Application, ccv2.Warnings, error) {
	fake.restageApplicationMutex.Lock()
	ret, specificReturn := fake.restageApplicationReturnsOnCall[len(fake.restageApplicationArgsForCall)]
	fake.restageApplicationArgsForCall = append(fake.restageApplicationArgsForCall, struct {
		app ccv2.Application
	}{app})
	fake.recordInvocation("RestageApplication", []interface{}{app})
	fake.restageApplicationMutex.Unlock()
	if fake.RestageApplicationStub != nil {
		return fake.RestageApplicationStub(app)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.restageApplicationReturns.result1, fake.restageApplicationReturns.result2, fake.restageApplicationReturns.result3
}

func (fake *FakeCloudControllerClient) RestageApplicationCallCount() int {
	fake.restageApplicationMutex.RLock()
	defer fake.restageApplicationMutex.RUnlock()
	return len(fake.restageApplicationArgsForCall)
}

func (fake *FakeCloudControllerClient) RestageApplicationArgsForCall(i int) ccv2.Application {
	fake.restageApplicationMutex.RLock()
	defer fake.restageApplicationMutex.RUnlock()
	return fake.restageApplicationArgsForCall[i].app
}

func (fake *FakeCloudControllerClient) RestageApplicationReturns(result1 ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.RestageApplicationStub = nil
	fake.restageApplicationReturns = struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) RestageApplicationReturnsOnCall(i int, result1 ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.RestageApplicationStub = nil
	if fake.restageApplicationReturnsOnCall == nil {
		fake.restageApplicationReturnsOnCall = make(map[int]struct {
			result1 ccv2.Application
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.restageApplicationReturnsOnCall[i] = struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) TargetCF(settings ccv2.TargetSettings) (ccv2.Warnings, error) {
	fake.targetCFMutex.Lock()
	ret, specificReturn := fake.targetCFReturnsOnCall[len(fake.targetCFArgsForCall)]
	fake.targetCFArgsForCall = append(fake.targetCFArgsForCall, struct {
		settings ccv2.TargetSettings
	}{settings})
	fake.recordInvocation("TargetCF", []interface{}{settings})
	fake.targetCFMutex.Unlock()
	if fake.TargetCFStub != nil {
		return fake.TargetCFStub(settings)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.targetCFReturns.result1, fake.targetCFReturns.result2
}

func (fake *FakeCloudControllerClient) TargetCFCallCount() int {
	fake.targetCFMutex.RLock()
	defer fake.targetCFMutex.RUnlock()
	return len(fake.targetCFArgsForCall)
}

func (fake *FakeCloudControllerClient) TargetCFArgsForCall(i int) ccv2.TargetSettings {
	fake.targetCFMutex.RLock()
	defer fake.targetCFMutex.RUnlock()
	return fake.targetCFArgsForCall[i].settings
}

func (fake *FakeCloudControllerClient) TargetCFReturns(result1 ccv2.Warnings, result2 error) {
	fake.TargetCFStub = nil
	fake.targetCFReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) TargetCFReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.TargetCFStub = nil
	if fake.targetCFReturnsOnCall == nil {
		fake.targetCFReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.targetCFReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) UpdateApplication(app ccv2.Application) (ccv2.Application, ccv2.Warnings, error) {
	fake.updateApplicationMutex.Lock()
	ret, specificReturn := fake.updateApplicationReturnsOnCall[len(fake.updateApplicationArgsForCall)]
	fake.updateApplicationArgsForCall = append(fake.updateApplicationArgsForCall, struct {
		app ccv2.Application
	}{app})
	fake.recordInvocation("UpdateApplication", []interface{}{app})
	fake.updateApplicationMutex.Unlock()
	if fake.UpdateApplicationStub != nil {
		return fake.UpdateApplicationStub(app)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.updateApplicationReturns.result1, fake.updateApplicationReturns.result2, fake.updateApplicationReturns.result3
}

func (fake *FakeCloudControllerClient) UpdateApplicationCallCount() int {
	fake.updateApplicationMutex.RLock()
	defer fake.updateApplicationMutex.RUnlock()
	return len(fake.updateApplicationArgsForCall)
}

func (fake *FakeCloudControllerClient) UpdateApplicationArgsForCall(i int) ccv2.Application {
	fake.updateApplicationMutex.RLock()
	defer fake.updateApplicationMutex.RUnlock()
	return fake.updateApplicationArgsForCall[i].app
}

func (fake *FakeCloudControllerClient) UpdateApplicationReturns(result1 ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.UpdateApplicationStub = nil
	fake.updateApplicationReturns = struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) UpdateApplicationReturnsOnCall(i int, result1 ccv2.Application, result2 ccv2.Warnings, result3 error) {
	fake.UpdateApplicationStub = nil
	if fake.updateApplicationReturnsOnCall == nil {
		fake.updateApplicationReturnsOnCall = make(map[int]struct {
			result1 ccv2.Application
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.updateApplicationReturnsOnCall[i] = struct {
		result1 ccv2.Application
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) UpdateResourceMatch(resourcesToMatch []ccv2.Resource) ([]ccv2.Resource, ccv2.Warnings, error) {
	var resourcesToMatchCopy []ccv2.Resource
	if resourcesToMatch != nil {
		resourcesToMatchCopy = make([]ccv2.Resource, len(resourcesToMatch))
		copy(resourcesToMatchCopy, resourcesToMatch)
	}
	fake.updateResourceMatchMutex.Lock()
	ret, specificReturn := fake.updateResourceMatchReturnsOnCall[len(fake.updateResourceMatchArgsForCall)]
	fake.updateResourceMatchArgsForCall = append(fake.updateResourceMatchArgsForCall, struct {
		resourcesToMatch []ccv2.Resource
	}{resourcesToMatchCopy})
	fake.recordInvocation("UpdateResourceMatch", []interface{}{resourcesToMatchCopy})
	fake.updateResourceMatchMutex.Unlock()
	if fake.UpdateResourceMatchStub != nil {
		return fake.UpdateResourceMatchStub(resourcesToMatch)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.updateResourceMatchReturns.result1, fake.updateResourceMatchReturns.result2, fake.updateResourceMatchReturns.result3
}

func (fake *FakeCloudControllerClient) UpdateResourceMatchCallCount() int {
	fake.updateResourceMatchMutex.RLock()
	defer fake.updateResourceMatchMutex.RUnlock()
	return len(fake.updateResourceMatchArgsForCall)
}

func (fake *FakeCloudControllerClient) UpdateResourceMatchArgsForCall(i int) []ccv2.Resource {
	fake.updateResourceMatchMutex.RLock()
	defer fake.updateResourceMatchMutex.RUnlock()
	return fake.updateResourceMatchArgsForCall[i].resourcesToMatch
}

func (fake *FakeCloudControllerClient) UpdateResourceMatchReturns(result1 []ccv2.Resource, result2 ccv2.Warnings, result3 error) {
	fake.UpdateResourceMatchStub = nil
	fake.updateResourceMatchReturns = struct {
		result1 []ccv2.Resource
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) UpdateResourceMatchReturnsOnCall(i int, result1 []ccv2.Resource, result2 ccv2.Warnings, result3 error) {
	fake.UpdateResourceMatchStub = nil
	if fake.updateResourceMatchReturnsOnCall == nil {
		fake.updateResourceMatchReturnsOnCall = make(map[int]struct {
			result1 []ccv2.Resource
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.updateResourceMatchReturnsOnCall[i] = struct {
		result1 []ccv2.Resource
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) UpdateRouteApplication(routeGUID string, appGUID string) (ccv2.Route, ccv2.Warnings, error) {
	fake.updateRouteApplicationMutex.Lock()
	ret, specificReturn := fake.updateRouteApplicationReturnsOnCall[len(fake.updateRouteApplicationArgsForCall)]
	fake.updateRouteApplicationArgsForCall = append(fake.updateRouteApplicationArgsForCall, struct {
		routeGUID string
		appGUID   string
	}{routeGUID, appGUID})
	fake.recordInvocation("UpdateRouteApplication", []interface{}{routeGUID, appGUID})
	fake.updateRouteApplicationMutex.Unlock()
	if fake.UpdateRouteApplicationStub != nil {
		return fake.UpdateRouteApplicationStub(routeGUID, appGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.updateRouteApplicationReturns.result1, fake.updateRouteApplicationReturns.result2, fake.updateRouteApplicationReturns.result3
}

func (fake *FakeCloudControllerClient) UpdateRouteApplicationCallCount() int {
	fake.updateRouteApplicationMutex.RLock()
	defer fake.updateRouteApplicationMutex.RUnlock()
	return len(fake.updateRouteApplicationArgsForCall)
}

func (fake *FakeCloudControllerClient) UpdateRouteApplicationArgsForCall(i int) (string, string) {
	fake.updateRouteApplicationMutex.RLock()
	defer fake.updateRouteApplicationMutex.RUnlock()
	return fake.updateRouteApplicationArgsForCall[i].routeGUID, fake.updateRouteApplicationArgsForCall[i].appGUID
}

func (fake *FakeCloudControllerClient) UpdateRouteApplicationReturns(result1 ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.UpdateRouteApplicationStub = nil
	fake.updateRouteApplicationReturns = struct {
		result1 ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) UpdateRouteApplicationReturnsOnCall(i int, result1 ccv2.Route, result2 ccv2.Warnings, result3 error) {
	fake.UpdateRouteApplicationStub = nil
	if fake.updateRouteApplicationReturnsOnCall == nil {
		fake.updateRouteApplicationReturnsOnCall = make(map[int]struct {
			result1 ccv2.Route
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.updateRouteApplicationReturnsOnCall[i] = struct {
		result1 ccv2.Route
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupSpace(securityGroupGUID string, spaceGUID string) (ccv2.Warnings, error) {
	fake.updateSecurityGroupSpaceMutex.Lock()
	ret, specificReturn := fake.updateSecurityGroupSpaceReturnsOnCall[len(fake.updateSecurityGroupSpaceArgsForCall)]
	fake.updateSecurityGroupSpaceArgsForCall = append(fake.updateSecurityGroupSpaceArgsForCall, struct {
		securityGroupGUID string
		spaceGUID         string
	}{securityGroupGUID, spaceGUID})
	fake.recordInvocation("UpdateSecurityGroupSpace", []interface{}{securityGroupGUID, spaceGUID})
	fake.updateSecurityGroupSpaceMutex.Unlock()
	if fake.UpdateSecurityGroupSpaceStub != nil {
		return fake.UpdateSecurityGroupSpaceStub(securityGroupGUID, spaceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.updateSecurityGroupSpaceReturns.result1, fake.updateSecurityGroupSpaceReturns.result2
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupSpaceCallCount() int {
	fake.updateSecurityGroupSpaceMutex.RLock()
	defer fake.updateSecurityGroupSpaceMutex.RUnlock()
	return len(fake.updateSecurityGroupSpaceArgsForCall)
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupSpaceArgsForCall(i int) (string, string) {
	fake.updateSecurityGroupSpaceMutex.RLock()
	defer fake.updateSecurityGroupSpaceMutex.RUnlock()
	return fake.updateSecurityGroupSpaceArgsForCall[i].securityGroupGUID, fake.updateSecurityGroupSpaceArgsForCall[i].spaceGUID
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupSpaceReturns(result1 ccv2.Warnings, result2 error) {
	fake.UpdateSecurityGroupSpaceStub = nil
	fake.updateSecurityGroupSpaceReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupSpaceReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.UpdateSecurityGroupSpaceStub = nil
	if fake.updateSecurityGroupSpaceReturnsOnCall == nil {
		fake.updateSecurityGroupSpaceReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.updateSecurityGroupSpaceReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupStagingSpace(securityGroupGUID string, spaceGUID string) (ccv2.Warnings, error) {
	fake.updateSecurityGroupStagingSpaceMutex.Lock()
	ret, specificReturn := fake.updateSecurityGroupStagingSpaceReturnsOnCall[len(fake.updateSecurityGroupStagingSpaceArgsForCall)]
	fake.updateSecurityGroupStagingSpaceArgsForCall = append(fake.updateSecurityGroupStagingSpaceArgsForCall, struct {
		securityGroupGUID string
		spaceGUID         string
	}{securityGroupGUID, spaceGUID})
	fake.recordInvocation("UpdateSecurityGroupStagingSpace", []interface{}{securityGroupGUID, spaceGUID})
	fake.updateSecurityGroupStagingSpaceMutex.Unlock()
	if fake.UpdateSecurityGroupStagingSpaceStub != nil {
		return fake.UpdateSecurityGroupStagingSpaceStub(securityGroupGUID, spaceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.updateSecurityGroupStagingSpaceReturns.result1, fake.updateSecurityGroupStagingSpaceReturns.result2
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupStagingSpaceCallCount() int {
	fake.updateSecurityGroupStagingSpaceMutex.RLock()
	defer fake.updateSecurityGroupStagingSpaceMutex.RUnlock()
	return len(fake.updateSecurityGroupStagingSpaceArgsForCall)
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupStagingSpaceArgsForCall(i int) (string, string) {
	fake.updateSecurityGroupStagingSpaceMutex.RLock()
	defer fake.updateSecurityGroupStagingSpaceMutex.RUnlock()
	return fake.updateSecurityGroupStagingSpaceArgsForCall[i].securityGroupGUID, fake.updateSecurityGroupStagingSpaceArgsForCall[i].spaceGUID
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupStagingSpaceReturns(result1 ccv2.Warnings, result2 error) {
	fake.UpdateSecurityGroupStagingSpaceStub = nil
	fake.updateSecurityGroupStagingSpaceReturns = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) UpdateSecurityGroupStagingSpaceReturnsOnCall(i int, result1 ccv2.Warnings, result2 error) {
	fake.UpdateSecurityGroupStagingSpaceStub = nil
	if fake.updateSecurityGroupStagingSpaceReturnsOnCall == nil {
		fake.updateSecurityGroupStagingSpaceReturnsOnCall = make(map[int]struct {
			result1 ccv2.Warnings
			result2 error
		})
	}
	fake.updateSecurityGroupStagingSpaceReturnsOnCall[i] = struct {
		result1 ccv2.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeCloudControllerClient) UploadApplicationPackage(appGUID string, existingResources []ccv2.Resource, newResources ccv2.Reader, newResourcesLength int64) (ccv2.Job, ccv2.Warnings, error) {
	var existingResourcesCopy []ccv2.Resource
	if existingResources != nil {
		existingResourcesCopy = make([]ccv2.Resource, len(existingResources))
		copy(existingResourcesCopy, existingResources)
	}
	fake.uploadApplicationPackageMutex.Lock()
	ret, specificReturn := fake.uploadApplicationPackageReturnsOnCall[len(fake.uploadApplicationPackageArgsForCall)]
	fake.uploadApplicationPackageArgsForCall = append(fake.uploadApplicationPackageArgsForCall, struct {
		appGUID            string
		existingResources  []ccv2.Resource
		newResources       ccv2.Reader
		newResourcesLength int64
	}{appGUID, existingResourcesCopy, newResources, newResourcesLength})
	fake.recordInvocation("UploadApplicationPackage", []interface{}{appGUID, existingResourcesCopy, newResources, newResourcesLength})
	fake.uploadApplicationPackageMutex.Unlock()
	if fake.UploadApplicationPackageStub != nil {
		return fake.UploadApplicationPackageStub(appGUID, existingResources, newResources, newResourcesLength)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.uploadApplicationPackageReturns.result1, fake.uploadApplicationPackageReturns.result2, fake.uploadApplicationPackageReturns.result3
}

func (fake *FakeCloudControllerClient) UploadApplicationPackageCallCount() int {
	fake.uploadApplicationPackageMutex.RLock()
	defer fake.uploadApplicationPackageMutex.RUnlock()
	return len(fake.uploadApplicationPackageArgsForCall)
}

func (fake *FakeCloudControllerClient) UploadApplicationPackageArgsForCall(i int) (string, []ccv2.Resource, ccv2.Reader, int64) {
	fake.uploadApplicationPackageMutex.RLock()
	defer fake.uploadApplicationPackageMutex.RUnlock()
	return fake.uploadApplicationPackageArgsForCall[i].appGUID, fake.uploadApplicationPackageArgsForCall[i].existingResources, fake.uploadApplicationPackageArgsForCall[i].newResources, fake.uploadApplicationPackageArgsForCall[i].newResourcesLength
}

func (fake *FakeCloudControllerClient) UploadApplicationPackageReturns(result1 ccv2.Job, result2 ccv2.Warnings, result3 error) {
	fake.UploadApplicationPackageStub = nil
	fake.uploadApplicationPackageReturns = struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) UploadApplicationPackageReturnsOnCall(i int, result1 ccv2.Job, result2 ccv2.Warnings, result3 error) {
	fake.UploadApplicationPackageStub = nil
	if fake.uploadApplicationPackageReturnsOnCall == nil {
		fake.uploadApplicationPackageReturnsOnCall = make(map[int]struct {
			result1 ccv2.Job
			result2 ccv2.Warnings
			result3 error
		})
	}
	fake.uploadApplicationPackageReturnsOnCall[i] = struct {
		result1 ccv2.Job
		result2 ccv2.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeCloudControllerClient) API() string {
	fake.aPIMutex.Lock()
	ret, specificReturn := fake.aPIReturnsOnCall[len(fake.aPIArgsForCall)]
	fake.aPIArgsForCall = append(fake.aPIArgsForCall, struct{}{})
	fake.recordInvocation("API", []interface{}{})
	fake.aPIMutex.Unlock()
	if fake.APIStub != nil {
		return fake.APIStub()
	}
	if specificReturn {
		return ret.result1
	}
	return fake.aPIReturns.result1
}

func (fake *FakeCloudControllerClient) APICallCount() int {
	fake.aPIMutex.RLock()
	defer fake.aPIMutex.RUnlock()
	return len(fake.aPIArgsForCall)
}

func (fake *FakeCloudControllerClient) APIReturns(result1 string) {
	fake.APIStub = nil
	fake.aPIReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) APIReturnsOnCall(i int, result1 string) {
	fake.APIStub = nil
	if fake.aPIReturnsOnCall == nil {
		fake.aPIReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.aPIReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) APIVersion() string {
	fake.aPIVersionMutex.Lock()
	ret, specificReturn := fake.aPIVersionReturnsOnCall[len(fake.aPIVersionArgsForCall)]
	fake.aPIVersionArgsForCall = append(fake.aPIVersionArgsForCall, struct{}{})
	fake.recordInvocation("APIVersion", []interface{}{})
	fake.aPIVersionMutex.Unlock()
	if fake.APIVersionStub != nil {
		return fake.APIVersionStub()
	}
	if specificReturn {
		return ret.result1
	}
	return fake.aPIVersionReturns.result1
}

func (fake *FakeCloudControllerClient) APIVersionCallCount() int {
	fake.aPIVersionMutex.RLock()
	defer fake.aPIVersionMutex.RUnlock()
	return len(fake.aPIVersionArgsForCall)
}

func (fake *FakeCloudControllerClient) APIVersionReturns(result1 string) {
	fake.APIVersionStub = nil
	fake.aPIVersionReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) APIVersionReturnsOnCall(i int, result1 string) {
	fake.APIVersionStub = nil
	if fake.aPIVersionReturnsOnCall == nil {
		fake.aPIVersionReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.aPIVersionReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) AuthorizationEndpoint() string {
	fake.authorizationEndpointMutex.Lock()
	ret, specificReturn := fake.authorizationEndpointReturnsOnCall[len(fake.authorizationEndpointArgsForCall)]
	fake.authorizationEndpointArgsForCall = append(fake.authorizationEndpointArgsForCall, struct{}{})
	fake.recordInvocation("AuthorizationEndpoint", []interface{}{})
	fake.authorizationEndpointMutex.Unlock()
	if fake.AuthorizationEndpointStub != nil {
		return fake.AuthorizationEndpointStub()
	}
	if specificReturn {
		return ret.result1
	}
	return fake.authorizationEndpointReturns.result1
}

func (fake *FakeCloudControllerClient) AuthorizationEndpointCallCount() int {
	fake.authorizationEndpointMutex.RLock()
	defer fake.authorizationEndpointMutex.RUnlock()
	return len(fake.authorizationEndpointArgsForCall)
}

func (fake *FakeCloudControllerClient) AuthorizationEndpointReturns(result1 string) {
	fake.AuthorizationEndpointStub = nil
	fake.authorizationEndpointReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) AuthorizationEndpointReturnsOnCall(i int, result1 string) {
	fake.AuthorizationEndpointStub = nil
	if fake.authorizationEndpointReturnsOnCall == nil {
		fake.authorizationEndpointReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.authorizationEndpointReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) DopplerEndpoint() string {
	fake.dopplerEndpointMutex.Lock()
	ret, specificReturn := fake.dopplerEndpointReturnsOnCall[len(fake.dopplerEndpointArgsForCall)]
	fake.dopplerEndpointArgsForCall = append(fake.dopplerEndpointArgsForCall, struct{}{})
	fake.recordInvocation("DopplerEndpoint", []interface{}{})
	fake.dopplerEndpointMutex.Unlock()
	if fake.DopplerEndpointStub != nil {
		return fake.DopplerEndpointStub()
	}
	if specificReturn {
		return ret.result1
	}
	return fake.dopplerEndpointReturns.result1
}

func (fake *FakeCloudControllerClient) DopplerEndpointCallCount() int {
	fake.dopplerEndpointMutex.RLock()
	defer fake.dopplerEndpointMutex.RUnlock()
	return len(fake.dopplerEndpointArgsForCall)
}

func (fake *FakeCloudControllerClient) DopplerEndpointReturns(result1 string) {
	fake.DopplerEndpointStub = nil
	fake.dopplerEndpointReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) DopplerEndpointReturnsOnCall(i int, result1 string) {
	fake.DopplerEndpointStub = nil
	if fake.dopplerEndpointReturnsOnCall == nil {
		fake.dopplerEndpointReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.dopplerEndpointReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) MinCLIVersion() string {
	fake.minCLIVersionMutex.Lock()
	ret, specificReturn := fake.minCLIVersionReturnsOnCall[len(fake.minCLIVersionArgsForCall)]
	fake.minCLIVersionArgsForCall = append(fake.minCLIVersionArgsForCall, struct{}{})
	fake.recordInvocation("MinCLIVersion", []interface{}{})
	fake.minCLIVersionMutex.Unlock()
	if fake.MinCLIVersionStub != nil {
		return fake.MinCLIVersionStub()
	}
	if specificReturn {
		return ret.result1
	}
	return fake.minCLIVersionReturns.result1
}

func (fake *FakeCloudControllerClient) MinCLIVersionCallCount() int {
	fake.minCLIVersionMutex.RLock()
	defer fake.minCLIVersionMutex.RUnlock()
	return len(fake.minCLIVersionArgsForCall)
}

func (fake *FakeCloudControllerClient) MinCLIVersionReturns(result1 string) {
	fake.MinCLIVersionStub = nil
	fake.minCLIVersionReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) MinCLIVersionReturnsOnCall(i int, result1 string) {
	fake.MinCLIVersionStub = nil
	if fake.minCLIVersionReturnsOnCall == nil {
		fake.minCLIVersionReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.minCLIVersionReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) RoutingEndpoint() string {
	fake.routingEndpointMutex.Lock()
	ret, specificReturn := fake.routingEndpointReturnsOnCall[len(fake.routingEndpointArgsForCall)]
	fake.routingEndpointArgsForCall = append(fake.routingEndpointArgsForCall, struct{}{})
	fake.recordInvocation("RoutingEndpoint", []interface{}{})
	fake.routingEndpointMutex.Unlock()
	if fake.RoutingEndpointStub != nil {
		return fake.RoutingEndpointStub()
	}
	if specificReturn {
		return ret.result1
	}
	return fake.routingEndpointReturns.result1
}

func (fake *FakeCloudControllerClient) RoutingEndpointCallCount() int {
	fake.routingEndpointMutex.RLock()
	defer fake.routingEndpointMutex.RUnlock()
	return len(fake.routingEndpointArgsForCall)
}

func (fake *FakeCloudControllerClient) RoutingEndpointReturns(result1 string) {
	fake.RoutingEndpointStub = nil
	fake.routingEndpointReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) RoutingEndpointReturnsOnCall(i int, result1 string) {
	fake.RoutingEndpointStub = nil
	if fake.routingEndpointReturnsOnCall == nil {
		fake.routingEndpointReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.routingEndpointReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) TokenEndpoint() string {
	fake.tokenEndpointMutex.Lock()
	ret, specificReturn := fake.tokenEndpointReturnsOnCall[len(fake.tokenEndpointArgsForCall)]
	fake.tokenEndpointArgsForCall = append(fake.tokenEndpointArgsForCall, struct{}{})
	fake.recordInvocation("TokenEndpoint", []interface{}{})
	fake.tokenEndpointMutex.Unlock()
	if fake.TokenEndpointStub != nil {
		return fake.TokenEndpointStub()
	}
	if specificReturn {
		return ret.result1
	}
	return fake.tokenEndpointReturns.result1
}

func (fake *FakeCloudControllerClient) TokenEndpointCallCount() int {
	fake.tokenEndpointMutex.RLock()
	defer fake.tokenEndpointMutex.RUnlock()
	return len(fake.tokenEndpointArgsForCall)
}

func (fake *FakeCloudControllerClient) TokenEndpointReturns(result1 string) {
	fake.TokenEndpointStub = nil
	fake.tokenEndpointReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) TokenEndpointReturnsOnCall(i int, result1 string) {
	fake.TokenEndpointStub = nil
	if fake.tokenEndpointReturnsOnCall == nil {
		fake.tokenEndpointReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.tokenEndpointReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeCloudControllerClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.createApplicationMutex.RLock()
	defer fake.createApplicationMutex.RUnlock()
	fake.createRouteMutex.RLock()
	defer fake.createRouteMutex.RUnlock()
	fake.createServiceBindingMutex.RLock()
	defer fake.createServiceBindingMutex.RUnlock()
	fake.createUserMutex.RLock()
	defer fake.createUserMutex.RUnlock()
	fake.deleteOrganizationJobMutex.RLock()
	defer fake.deleteOrganizationJobMutex.RUnlock()
	fake.deleteRouteMutex.RLock()
	defer fake.deleteRouteMutex.RUnlock()
	fake.deleteRouteApplicationMutex.RLock()
	defer fake.deleteRouteApplicationMutex.RUnlock()
	fake.deleteSecurityGroupSpaceMutex.RLock()
	defer fake.deleteSecurityGroupSpaceMutex.RUnlock()
	fake.deleteSecurityGroupStagingSpaceMutex.RLock()
	defer fake.deleteSecurityGroupStagingSpaceMutex.RUnlock()
	fake.deleteServiceBindingMutex.RLock()
	defer fake.deleteServiceBindingMutex.RUnlock()
	fake.deleteSpaceJobMutex.RLock()
	defer fake.deleteSpaceJobMutex.RUnlock()
	fake.doesRouteExistMutex.RLock()
	defer fake.doesRouteExistMutex.RUnlock()
	fake.getApplicationMutex.RLock()
	defer fake.getApplicationMutex.RUnlock()
	fake.getApplicationApplicationInstanceStatusesMutex.RLock()
	defer fake.getApplicationApplicationInstanceStatusesMutex.RUnlock()
	fake.getApplicationApplicationInstancesMutex.RLock()
	defer fake.getApplicationApplicationInstancesMutex.RUnlock()
	fake.getApplicationRoutesMutex.RLock()
	defer fake.getApplicationRoutesMutex.RUnlock()
	fake.getApplicationsMutex.RLock()
	defer fake.getApplicationsMutex.RUnlock()
	fake.getConfigFeatureFlagsMutex.RLock()
	defer fake.getConfigFeatureFlagsMutex.RUnlock()
	fake.getJobMutex.RLock()
	defer fake.getJobMutex.RUnlock()
	fake.getOrganizationMutex.RLock()
	defer fake.getOrganizationMutex.RUnlock()
	fake.getOrganizationPrivateDomainsMutex.RLock()
	defer fake.getOrganizationPrivateDomainsMutex.RUnlock()
	fake.getOrganizationQuotaMutex.RLock()
	defer fake.getOrganizationQuotaMutex.RUnlock()
	fake.getOrganizationsMutex.RLock()
	defer fake.getOrganizationsMutex.RUnlock()
	fake.getPrivateDomainMutex.RLock()
	defer fake.getPrivateDomainMutex.RUnlock()
	fake.getRouteApplicationsMutex.RLock()
	defer fake.getRouteApplicationsMutex.RUnlock()
	fake.getRoutesMutex.RLock()
	defer fake.getRoutesMutex.RUnlock()
	fake.getSecurityGroupSpacesMutex.RLock()
	defer fake.getSecurityGroupSpacesMutex.RUnlock()
	fake.getSecurityGroupStagingSpacesMutex.RLock()
	defer fake.getSecurityGroupStagingSpacesMutex.RUnlock()
	fake.getSecurityGroupsMutex.RLock()
	defer fake.getSecurityGroupsMutex.RUnlock()
	fake.getServiceMutex.RLock()
	defer fake.getServiceMutex.RUnlock()
	fake.getServiceBindingsMutex.RLock()
	defer fake.getServiceBindingsMutex.RUnlock()
	fake.getServiceInstanceMutex.RLock()
	defer fake.getServiceInstanceMutex.RUnlock()
	fake.getServiceInstanceServiceBindingsMutex.RLock()
	defer fake.getServiceInstanceServiceBindingsMutex.RUnlock()
	fake.getServiceInstanceSharedFromMutex.RLock()
	defer fake.getServiceInstanceSharedFromMutex.RUnlock()
	fake.getServiceInstanceSharedTosMutex.RLock()
	defer fake.getServiceInstanceSharedTosMutex.RUnlock()
	fake.getServiceInstancesMutex.RLock()
	defer fake.getServiceInstancesMutex.RUnlock()
	fake.getServicePlanMutex.RLock()
	defer fake.getServicePlanMutex.RUnlock()
	fake.getSharedDomainMutex.RLock()
	defer fake.getSharedDomainMutex.RUnlock()
	fake.getSharedDomainsMutex.RLock()
	defer fake.getSharedDomainsMutex.RUnlock()
	fake.getSpaceQuotaDefinitionMutex.RLock()
	defer fake.getSpaceQuotaDefinitionMutex.RUnlock()
	fake.getSpaceRoutesMutex.RLock()
	defer fake.getSpaceRoutesMutex.RUnlock()
	fake.getSpaceSecurityGroupsMutex.RLock()
	defer fake.getSpaceSecurityGroupsMutex.RUnlock()
	fake.getSpaceServiceInstancesMutex.RLock()
	defer fake.getSpaceServiceInstancesMutex.RUnlock()
	fake.getSpaceStagingSecurityGroupsMutex.RLock()
	defer fake.getSpaceStagingSecurityGroupsMutex.RUnlock()
	fake.getSpacesMutex.RLock()
	defer fake.getSpacesMutex.RUnlock()
	fake.getStackMutex.RLock()
	defer fake.getStackMutex.RUnlock()
	fake.getStacksMutex.RLock()
	defer fake.getStacksMutex.RUnlock()
	fake.getUserProvidedServiceInstanceServiceBindingsMutex.RLock()
	defer fake.getUserProvidedServiceInstanceServiceBindingsMutex.RUnlock()
	fake.pollJobMutex.RLock()
	defer fake.pollJobMutex.RUnlock()
	fake.restageApplicationMutex.RLock()
	defer fake.restageApplicationMutex.RUnlock()
	fake.targetCFMutex.RLock()
	defer fake.targetCFMutex.RUnlock()
	fake.updateApplicationMutex.RLock()
	defer fake.updateApplicationMutex.RUnlock()
	fake.updateResourceMatchMutex.RLock()
	defer fake.updateResourceMatchMutex.RUnlock()
	fake.updateRouteApplicationMutex.RLock()
	defer fake.updateRouteApplicationMutex.RUnlock()
	fake.updateSecurityGroupSpaceMutex.RLock()
	defer fake.updateSecurityGroupSpaceMutex.RUnlock()
	fake.updateSecurityGroupStagingSpaceMutex.RLock()
	defer fake.updateSecurityGroupStagingSpaceMutex.RUnlock()
	fake.uploadApplicationPackageMutex.RLock()
	defer fake.uploadApplicationPackageMutex.RUnlock()
	fake.aPIMutex.RLock()
	defer fake.aPIMutex.RUnlock()
	fake.aPIVersionMutex.RLock()
	defer fake.aPIVersionMutex.RUnlock()
	fake.authorizationEndpointMutex.RLock()
	defer fake.authorizationEndpointMutex.RUnlock()
	fake.dopplerEndpointMutex.RLock()
	defer fake.dopplerEndpointMutex.RUnlock()
	fake.minCLIVersionMutex.RLock()
	defer fake.minCLIVersionMutex.RUnlock()
	fake.routingEndpointMutex.RLock()
	defer fake.routingEndpointMutex.RUnlock()
	fake.tokenEndpointMutex.RLock()
	defer fake.tokenEndpointMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeCloudControllerClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ v2action.CloudControllerClient = new(FakeCloudControllerClient)
