// Copyright 2020 The Gitea Authors. All rights reserved.
// Use of this source code is governed by a MIT-style
// license that can be found in the LICENSE file.

package emoji

// Code generated by gen.go. DO NOT EDIT.
// Sourced from https://raw.githubusercontent.com/github/gemoji/master/db/emoji.json
//
var GemojiData = Gemoji{
	{"\U0001f44d", "thumbs up", []string{"+1", "thumbsup"}, "6.0", true},
	{"\U0001f44e", "thumbs down", []string{"-1", "thumbsdown"}, "6.0", true},
	{"\U0001f4af", "hundred points", []string{"100"}, "6.0", false},
	{"\U0001f522", "input numbers", []string{"1234"}, "6.0", false},
	{"\U0001f947", "1st place medal", []string{"1st_place_medal"}, "9.0", false},
	{"\U0001f948", "2nd place medal", []string{"2nd_place_medal"}, "9.0", false},
	{"\U0001f949", "3rd place medal", []string{"3rd_place_medal"}, "9.0", false},
	{"\U0001f3b1", "pool 8 ball", []string{"8ball"}, "6.0", false},
	{"\U0001f170\ufe0f", "A button (blood type)", []string{"a"}, "6.0", false},
	{"\U0001f18e", "AB button (blood type)", []string{"ab"}, "6.0", false},
	{"\U0001f9ee", "abacus", []string{"abacus"}, "11.0", false},
	{"\U0001f524", "input latin letters", []string{"abc"}, "6.0", false},
	{"\U0001f521", "input latin lowercase", []string{"abcd"}, "6.0", false},
	{"\U0001f251", "Japanese “acceptable” button", []string{"accept"}, "6.0", false},
	{"\U0001fa79", "adhesive bandage", []string{"adhesive_bandage"}, "12.0", false},
	{"\U0001f9d1", "person", []string{"adult"}, "11.0", true},
	{"\U0001f6a1", "aerial tramway", []string{"aerial_tramway"}, "6.0", false},
	{"\U0001f1e6\U0001f1eb", "flag: Afghanistan", []string{"afghanistan"}, "6.0", false},
	{"\u2708\ufe0f", "airplane", []string{"airplane"}, "", false},
	{"\U0001f1e6\U0001f1fd", "flag: Åland Islands", []string{"aland_islands"}, "6.0", false},
	{"\u23f0", "alarm clock", []string{"alarm_clock"}, "6.0", false},
	{"\U0001f1e6\U0001f1f1", "flag: Albania", []string{"albania"}, "6.0", false},
	{"\u2697\ufe0f", "alembic", []string{"alembic"}, "4.1", false},
	{"\U0001f1e9\U0001f1ff", "flag: Algeria", []string{"algeria"}, "6.0", false},
	{"\U0001f47d", "alien", []string{"alien"}, "6.0", false},
	{"\U0001f691", "ambulance", []string{"ambulance"}, "6.0", false},
	{"\U0001f1e6\U0001f1f8", "flag: American Samoa", []string{"american_samoa"}, "6.0", false},
	{"\U0001f3fa", "amphora", []string{"amphora"}, "8.0", false},
	{"\u2693", "anchor", []string{"anchor"}, "4.1", false},
	{"\U0001f1e6\U0001f1e9", "flag: Andorra", []string{"andorra"}, "6.0", false},
	{"\U0001f47c", "baby angel", []string{"angel"}, "6.0", true},
	{"\U0001f4a2", "anger symbol", []string{"anger"}, "6.0", false},
	{"\U0001f1e6\U0001f1f4", "flag: Angola", []string{"angola"}, "6.0", false},
	{"\U0001f620", "angry face", []string{"angry"}, "6.0", false},
	{"\U0001f1e6\U0001f1ee", "flag: Anguilla", []string{"anguilla"}, "6.0", false},
	{"\U0001f627", "anguished face", []string{"anguished"}, "6.1", false},
	{"\U0001f41c", "ant", []string{"ant"}, "6.0", false},
	{"\U0001f1e6\U0001f1f6", "flag: Antarctica", []string{"antarctica"}, "6.0", false},
	{"\U0001f1e6\U0001f1ec", "flag: Antigua & Barbuda", []string{"antigua_barbuda"}, "6.0", false},
	{"\U0001f34e", "red apple", []string{"apple"}, "6.0", false},
	{"\u2652", "Aquarius", []string{"aquarius"}, "", false},
	{"\U0001f1e6\U0001f1f7", "flag: Argentina", []string{"argentina"}, "6.0", false},
	{"\u2648", "Aries", []string{"aries"}, "", false},
	{"\U0001f1e6\U0001f1f2", "flag: Armenia", []string{"armenia"}, "6.0", false},
	{"\u25c0\ufe0f", "reverse button", []string{"arrow_backward"}, "", false},
	{"\u23ec", "fast down button", []string{"arrow_double_down"}, "6.0", false},
	{"\u23eb", "fast up button", []string{"arrow_double_up"}, "6.0", false},
	{"\u2b07\ufe0f", "down arrow", []string{"arrow_down"}, "4.0", false},
	{"\U0001f53d", "downwards button", []string{"arrow_down_small"}, "6.0", false},
	{"\u25b6\ufe0f", "play button", []string{"arrow_forward"}, "", false},
	{"\u2935\ufe0f", "right arrow curving down", []string{"arrow_heading_down"}, "", false},
	{"\u2934\ufe0f", "right arrow curving up", []string{"arrow_heading_up"}, "", false},
	{"\u2b05\ufe0f", "left arrow", []string{"arrow_left"}, "4.0", false},
	{"\u2199\ufe0f", "down-left arrow", []string{"arrow_lower_left"}, "", false},
	{"\u2198\ufe0f", "down-right arrow", []string{"arrow_lower_right"}, "", false},
	{"\u27a1\ufe0f", "right arrow", []string{"arrow_right"}, "", false},
	{"\u21aa\ufe0f", "left arrow curving right", []string{"arrow_right_hook"}, "", false},
	{"\u2b06\ufe0f", "up arrow", []string{"arrow_up"}, "4.0", false},
	{"\u2195\ufe0f", "up-down arrow", []string{"arrow_up_down"}, "", false},
	{"\U0001f53c", "upwards button", []string{"arrow_up_small"}, "6.0", false},
	{"\u2196\ufe0f", "up-left arrow", []string{"arrow_upper_left"}, "", false},
	{"\u2197\ufe0f", "up-right arrow", []string{"arrow_upper_right"}, "", false},
	{"\U0001f503", "clockwise vertical arrows", []string{"arrows_clockwise"}, "6.0", false},
	{"\U0001f504", "counterclockwise arrows button", []string{"arrows_counterclockwise"}, "6.0", false},
	{"\U0001f3a8", "artist palette", []string{"art"}, "6.0", false},
	{"\U0001f69b", "articulated lorry", []string{"articulated_lorry"}, "6.0", false},
	{"\U0001f6f0\ufe0f", "satellite", []string{"artificial_satellite"}, "7.0", false},
	{"\U0001f9d1\u200d\U0001f3a8", "artist", []string{"artist"}, "12.1", true},
	{"\U0001f1e6\U0001f1fc", "flag: Aruba", []string{"aruba"}, "6.0", false},
	{"\U0001f1e6\U0001f1e8", "flag: Ascension Island", []string{"ascension_island"}, "11.0", false},
	{"*\ufe0f\u20e3", "keycap: *", []string{"asterisk"}, "", false},
	{"\U0001f632", "astonished face", []string{"astonished"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f680", "astronaut", []string{"astronaut"}, "12.1", true},
	{"\U0001f45f", "running shoe", []string{"athletic_shoe"}, "6.0", false},
	{"\U0001f3e7", "ATM sign", []string{"atm"}, "6.0", false},
	{"\u269b\ufe0f", "atom symbol", []string{"atom_symbol"}, "4.1", false},
	{"\U0001f1e6\U0001f1fa", "flag: Australia", []string{"australia"}, "6.0", false},
	{"\U0001f1e6\U0001f1f9", "flag: Austria", []string{"austria"}, "6.0", false},
	{"\U0001f6fa", "auto rickshaw", []string{"auto_rickshaw"}, "12.0", false},
	{"\U0001f951", "avocado", []string{"avocado"}, "9.0", false},
	{"\U0001fa93", "axe", []string{"axe"}, "12.0", false},
	{"\U0001f1e6\U0001f1ff", "flag: Azerbaijan", []string{"azerbaijan"}, "6.0", false},
	{"\U0001f171\ufe0f", "B button (blood type)", []string{"b"}, "6.0", false},
	{"\U0001f476", "baby", []string{"baby"}, "6.0", true},
	{"\U0001f37c", "baby bottle", []string{"baby_bottle"}, "6.0", false},
	{"\U0001f424", "baby chick", []string{"baby_chick"}, "6.0", false},
	{"\U0001f6bc", "baby symbol", []string{"baby_symbol"}, "6.0", false},
	{"\U0001f519", "BACK arrow", []string{"back"}, "6.0", false},
	{"\U0001f953", "bacon", []string{"bacon"}, "9.0", false},
	{"\U0001f9a1", "badger", []string{"badger"}, "11.0", false},
	{"\U0001f3f8", "badminton", []string{"badminton"}, "8.0", false},
	{"\U0001f96f", "bagel", []string{"bagel"}, "11.0", false},
	{"\U0001f6c4", "baggage claim", []string{"baggage_claim"}, "6.0", false},
	{"\U0001f956", "baguette bread", []string{"baguette_bread"}, "9.0", false},
	{"\U0001f1e7\U0001f1f8", "flag: Bahamas", []string{"bahamas"}, "6.0", false},
	{"\U0001f1e7\U0001f1ed", "flag: Bahrain", []string{"bahrain"}, "6.0", false},
	{"\u2696\ufe0f", "balance scale", []string{"balance_scale"}, "4.1", false},
	{"\U0001f468\u200d\U0001f9b2", "man: bald", []string{"bald_man"}, "11.0", true},
	{"\U0001f469\u200d\U0001f9b2", "woman: bald", []string{"bald_woman"}, "11.0", true},
	{"\U0001fa70", "ballet shoes", []string{"ballet_shoes"}, "12.0", false},
	{"\U0001f388", "balloon", []string{"balloon"}, "6.0", false},
	{"\U0001f5f3\ufe0f", "ballot box with ballot", []string{"ballot_box"}, "7.0", false},
	{"\u2611\ufe0f", "check box with check", []string{"ballot_box_with_check"}, "", false},
	{"\U0001f38d", "pine decoration", []string{"bamboo"}, "6.0", false},
	{"\U0001f34c", "banana", []string{"banana"}, "6.0", false},
	{"\u203c\ufe0f", "double exclamation mark", []string{"bangbang"}, "", false},
	{"\U0001f1e7\U0001f1e9", "flag: Bangladesh", []string{"bangladesh"}, "6.0", false},
	{"\U0001fa95", "banjo", []string{"banjo"}, "12.0", false},
	{"\U0001f3e6", "bank", []string{"bank"}, "6.0", false},
	{"\U0001f4ca", "bar chart", []string{"bar_chart"}, "6.0", false},
	{"\U0001f1e7\U0001f1e7", "flag: Barbados", []string{"barbados"}, "6.0", false},
	{"\U0001f488", "barber pole", []string{"barber"}, "6.0", false},
	{"\u26be", "baseball", []string{"baseball"}, "5.2", false},
	{"\U0001f9fa", "basket", []string{"basket"}, "11.0", false},
	{"\U0001f3c0", "basketball", []string{"basketball"}, "6.0", false},
	{"\U0001f987", "bat", []string{"bat"}, "9.0", false},
	{"\U0001f6c0", "person taking bath", []string{"bath"}, "6.0", true},
	{"\U0001f6c1", "bathtub", []string{"bathtub"}, "6.0", false},
	{"\U0001f50b", "battery", []string{"battery"}, "6.0", false},
	{"\U0001f3d6\ufe0f", "beach with umbrella", []string{"beach_umbrella"}, "7.0", false},
	{"\U0001f43b", "bear", []string{"bear"}, "6.0", false},
	{"\U0001f9d4", "man: beard", []string{"bearded_person"}, "11.0", true},
	{"\U0001f6cf\ufe0f", "bed", []string{"bed"}, "7.0", false},
	{"\U0001f41d", "honeybee", []string{"bee", "honeybee"}, "6.0", false},
	{"\U0001f37a", "beer mug", []string{"beer"}, "6.0", false},
	{"\U0001f37b", "clinking beer mugs", []string{"beers"}, "6.0", false},
	{"\U0001f530", "Japanese symbol for beginner", []string{"beginner"}, "6.0", false},
	{"\U0001f1e7\U0001f1fe", "flag: Belarus", []string{"belarus"}, "6.0", false},
	{"\U0001f1e7\U0001f1ea", "flag: Belgium", []string{"belgium"}, "6.0", false},
	{"\U0001f1e7\U0001f1ff", "flag: Belize", []string{"belize"}, "6.0", false},
	{"\U0001f514", "bell", []string{"bell"}, "6.0", false},
	{"\U0001f6ce\ufe0f", "bellhop bell", []string{"bellhop_bell"}, "7.0", false},
	{"\U0001f1e7\U0001f1ef", "flag: Benin", []string{"benin"}, "6.0", false},
	{"\U0001f371", "bento box", []string{"bento"}, "6.0", false},
	{"\U0001f1e7\U0001f1f2", "flag: Bermuda", []string{"bermuda"}, "6.0", false},
	{"\U0001f9c3", "beverage box", []string{"beverage_box"}, "12.0", false},
	{"\U0001f1e7\U0001f1f9", "flag: Bhutan", []string{"bhutan"}, "6.0", false},
	{"\U0001f6b4", "person biking", []string{"bicyclist"}, "6.0", true},
	{"\U0001f6b2", "bicycle", []string{"bike"}, "6.0", false},
	{"\U0001f6b4\u200d\u2642\ufe0f", "man biking", []string{"biking_man"}, "11.0", true},
	{"\U0001f6b4\u200d\u2640\ufe0f", "woman biking", []string{"biking_woman"}, "6.0", true},
	{"\U0001f459", "bikini", []string{"bikini"}, "6.0", false},
	{"\U0001f9e2", "billed cap", []string{"billed_cap"}, "11.0", false},
	{"\u2623\ufe0f", "biohazard", []string{"biohazard"}, "", false},
	{"\U0001f426", "bird", []string{"bird"}, "6.0", false},
	{"\U0001f382", "birthday cake", []string{"birthday"}, "6.0", false},
	{"\u26ab", "black circle", []string{"black_circle"}, "4.1", false},
	{"\U0001f3f4", "black flag", []string{"black_flag"}, "7.0", false},
	{"\U0001f5a4", "black heart", []string{"black_heart"}, "9.0", false},
	{"\U0001f0cf", "joker", []string{"black_joker"}, "6.0", false},
	{"\u2b1b", "black large square", []string{"black_large_square"}, "5.1", false},
	{"\u25fe", "black medium-small square", []string{"black_medium_small_square"}, "3.2", false},
	{"\u25fc\ufe0f", "black medium square", []string{"black_medium_square"}, "3.2", false},
	{"\u2712\ufe0f", "black nib", []string{"black_nib"}, "", false},
	{"\u25aa\ufe0f", "black small square", []string{"black_small_square"}, "", false},
	{"\U0001f532", "black square button", []string{"black_square_button"}, "6.0", false},
	{"\U0001f471\u200d\u2642\ufe0f", "man: blond hair", []string{"blond_haired_man"}, "11.0", true},
	{"\U0001f471", "person: blond hair", []string{"blond_haired_person"}, "6.0", true},
	{"\U0001f471\u200d\u2640\ufe0f", "woman: blond hair", []string{"blond_haired_woman", "blonde_woman"}, "6.0", true},
	{"\U0001f33c", "blossom", []string{"blossom"}, "6.0", false},
	{"\U0001f421", "blowfish", []string{"blowfish"}, "6.0", false},
	{"\U0001f4d8", "blue book", []string{"blue_book"}, "6.0", false},
	{"\U0001f699", "sport utility vehicle", []string{"blue_car"}, "6.0", false},
	{"\U0001f499", "blue heart", []string{"blue_heart"}, "6.0", false},
	{"\U0001f7e6", "blue square", []string{"blue_square"}, "12.0", false},
	{"\U0001f60a", "smiling face with smiling eyes", []string{"blush"}, "6.0", false},
	{"\U0001f417", "boar", []string{"boar"}, "6.0", false},
	{"\u26f5", "sailboat", []string{"boat", "sailboat"}, "5.2", false},
	{"\U0001f1e7\U0001f1f4", "flag: Bolivia", []string{"bolivia"}, "6.0", false},
	{"\U0001f4a3", "bomb", []string{"bomb"}, "6.0", false},
	{"\U0001f9b4", "bone", []string{"bone"}, "11.0", false},
	{"\U0001f4d6", "open book", []string{"book", "open_book"}, "6.0", false},
	{"\U0001f516", "bookmark", []string{"bookmark"}, "6.0", false},
	{"\U0001f4d1", "bookmark tabs", []string{"bookmark_tabs"}, "6.0", false},
	{"\U0001f4da", "books", []string{"books"}, "6.0", false},
	{"\U0001f4a5", "collision", []string{"boom", "collision"}, "6.0", false},
	{"\U0001f462", "woman’s boot", []string{"boot"}, "6.0", false},
	{"\U0001f1e7\U0001f1e6", "flag: Bosnia & Herzegovina", []string{"bosnia_herzegovina"}, "6.0", false},
	{"\U0001f1e7\U0001f1fc", "flag: Botswana", []string{"botswana"}, "6.0", false},
	{"\u26f9\ufe0f\u200d\u2642\ufe0f", "man bouncing ball", []string{"bouncing_ball_man", "basketball_man"}, "11.0", true},
	{"\u26f9\ufe0f", "person bouncing ball", []string{"bouncing_ball_person"}, "5.2", true},
	{"\u26f9\ufe0f\u200d\u2640\ufe0f", "woman bouncing ball", []string{"bouncing_ball_woman", "basketball_woman"}, "7.0", true},
	{"\U0001f490", "bouquet", []string{"bouquet"}, "6.0", false},
	{"\U0001f1e7\U0001f1fb", "flag: Bouvet Island", []string{"bouvet_island"}, "11.0", false},
	{"\U0001f647", "person bowing", []string{"bow"}, "6.0", true},
	{"\U0001f3f9", "bow and arrow", []string{"bow_and_arrow"}, "8.0", false},
	{"\U0001f647\u200d\u2642\ufe0f", "man bowing", []string{"bowing_man"}, "11.0", true},
	{"\U0001f647\u200d\u2640\ufe0f", "woman bowing", []string{"bowing_woman"}, "6.0", true},
	{"\U0001f963", "bowl with spoon", []string{"bowl_with_spoon"}, "11.0", false},
	{"\U0001f3b3", "bowling", []string{"bowling"}, "6.0", false},
	{"\U0001f94a", "boxing glove", []string{"boxing_glove"}, "9.0", false},
	{"\U0001f466", "boy", []string{"boy"}, "6.0", true},
	{"\U0001f9e0", "brain", []string{"brain"}, "11.0", false},
	{"\U0001f1e7\U0001f1f7", "flag: Brazil", []string{"brazil"}, "6.0", false},
	{"\U0001f35e", "bread", []string{"bread"}, "6.0", false},
	{"\U0001f931", "breast-feeding", []string{"breast_feeding"}, "11.0", true},
	{"\U0001f9f1", "brick", []string{"bricks"}, "11.0", false},
	{"\U0001f309", "bridge at night", []string{"bridge_at_night"}, "6.0", false},
	{"\U0001f4bc", "briefcase", []string{"briefcase"}, "6.0", false},
	{"\U0001f1ee\U0001f1f4", "flag: British Indian Ocean Territory", []string{"british_indian_ocean_territory"}, "6.0", false},
	{"\U0001f1fb\U0001f1ec", "flag: British Virgin Islands", []string{"british_virgin_islands"}, "6.0", false},
	{"\U0001f966", "broccoli", []string{"broccoli"}, "11.0", false},
	{"\U0001f494", "broken heart", []string{"broken_heart"}, "6.0", false},
	{"\U0001f9f9", "broom", []string{"broom"}, "11.0", false},
	{"\U0001f7e4", "brown circle", []string{"brown_circle"}, "12.0", false},
	{"\U0001f90e", "brown heart", []string{"brown_heart"}, "12.0", false},
	{"\U0001f7eb", "brown square", []string{"brown_square"}, "12.0", false},
	{"\U0001f1e7\U0001f1f3", "flag: Brunei", []string{"brunei"}, "6.0", false},
	{"\U0001f41b", "bug", []string{"bug"}, "6.0", false},
	{"\U0001f3d7\ufe0f", "building construction", []string{"building_construction"}, "7.0", false},
	{"\U0001f4a1", "light bulb", []string{"bulb"}, "6.0", false},
	{"\U0001f1e7\U0001f1ec", "flag: Bulgaria", []string{"bulgaria"}, "6.0", false},
	{"\U0001f685", "bullet train", []string{"bullettrain_front"}, "6.0", false},
	{"\U0001f684", "high-speed train", []string{"bullettrain_side"}, "6.0", false},
	{"\U0001f1e7\U0001f1eb", "flag: Burkina Faso", []string{"burkina_faso"}, "6.0", false},
	{"\U0001f32f", "burrito", []string{"burrito"}, "8.0", false},
	{"\U0001f1e7\U0001f1ee", "flag: Burundi", []string{"burundi"}, "6.0", false},
	{"\U0001f68c", "bus", []string{"bus"}, "6.0", false},
	{"\U0001f574\ufe0f", "person in suit levitating", []string{"business_suit_levitating"}, "7.0", true},
	{"\U0001f68f", "bus stop", []string{"busstop"}, "6.0", false},
	{"\U0001f464", "bust in silhouette", []string{"bust_in_silhouette"}, "6.0", false},
	{"\U0001f465", "busts in silhouette", []string{"busts_in_silhouette"}, "6.0", false},
	{"\U0001f9c8", "butter", []string{"butter"}, "12.0", false},
	{"\U0001f98b", "butterfly", []string{"butterfly"}, "9.0", false},
	{"\U0001f335", "cactus", []string{"cactus"}, "6.0", false},
	{"\U0001f370", "shortcake", []string{"cake"}, "6.0", false},
	{"\U0001f4c6", "tear-off calendar", []string{"calendar"}, "6.0", false},
	{"\U0001f919", "call me hand", []string{"call_me_hand"}, "9.0", true},
	{"\U0001f4f2", "mobile phone with arrow", []string{"calling"}, "6.0", false},
	{"\U0001f1f0\U0001f1ed", "flag: Cambodia", []string{"cambodia"}, "6.0", false},
	{"\U0001f42b", "two-hump camel", []string{"camel"}, "6.0", false},
	{"\U0001f4f7", "camera", []string{"camera"}, "6.0", false},
	{"\U0001f4f8", "camera with flash", []string{"camera_flash"}, "7.0", false},
	{"\U0001f1e8\U0001f1f2", "flag: Cameroon", []string{"cameroon"}, "6.0", false},
	{"\U0001f3d5\ufe0f", "camping", []string{"camping"}, "7.0", false},
	{"\U0001f1e8\U0001f1e6", "flag: Canada", []string{"canada"}, "6.0", false},
	{"\U0001f1ee\U0001f1e8", "flag: Canary Islands", []string{"canary_islands"}, "6.0", false},
	{"\u264b", "Cancer", []string{"cancer"}, "", false},
	{"\U0001f56f\ufe0f", "candle", []string{"candle"}, "7.0", false},
	{"\U0001f36c", "candy", []string{"candy"}, "6.0", false},
	{"\U0001f96b", "canned food", []string{"canned_food"}, "11.0", false},
	{"\U0001f6f6", "canoe", []string{"canoe"}, "9.0", false},
	{"\U0001f1e8\U0001f1fb", "flag: Cape Verde", []string{"cape_verde"}, "6.0", false},
	{"\U0001f520", "input latin uppercase", []string{"capital_abcd"}, "6.0", false},
	{"\u2651", "Capricorn", []string{"capricorn"}, "", false},
	{"\U0001f697", "automobile", []string{"car", "red_car"}, "6.0", false},
	{"\U0001f5c3\ufe0f", "card file box", []string{"card_file_box"}, "7.0", false},
	{"\U0001f4c7", "card index", []string{"card_index"}, "6.0", false},
	{"\U0001f5c2\ufe0f", "card index dividers", []string{"card_index_dividers"}, "7.0", false},
	{"\U0001f1e7\U0001f1f6", "flag: Caribbean Netherlands", []string{"caribbean_netherlands"}, "6.0", false},
	{"\U0001f3a0", "carousel horse", []string{"carousel_horse"}, "6.0", false},
	{"\U0001f955", "carrot", []string{"carrot"}, "9.0", false},
	{"\U0001f938", "person cartwheeling", []string{"cartwheeling"}, "11.0", true},
	{"\U0001f431", "cat face", []string{"cat"}, "6.0", false},
	{"\U0001f408", "cat", []string{"cat2"}, "6.0", false},
	{"\U0001f1f0\U0001f1fe", "flag: Cayman Islands", []string{"cayman_islands"}, "6.0", false},
	{"\U0001f4bf", "optical disk", []string{"cd"}, "6.0", false},
	{"\U0001f1e8\U0001f1eb", "flag: Central African Republic", []string{"central_african_republic"}, "6.0", false},
	{"\U0001f1ea\U0001f1e6", "flag: Ceuta & Melilla", []string{"ceuta_melilla"}, "11.0", false},
	{"\U0001f1f9\U0001f1e9", "flag: Chad", []string{"chad"}, "6.0", false},
	{"\u26d3\ufe0f", "chains", []string{"chains"}, "5.2", false},
	{"\U0001fa91", "chair", []string{"chair"}, "12.0", false},
	{"\U0001f37e", "bottle with popping cork", []string{"champagne"}, "8.0", false},
	{"\U0001f4b9", "chart increasing with yen", []string{"chart"}, "6.0", false},
	{"\U0001f4c9", "chart decreasing", []string{"chart_with_downwards_trend"}, "6.0", false},
	{"\U0001f4c8", "chart increasing", []string{"chart_with_upwards_trend"}, "6.0", false},
	{"\U0001f3c1", "chequered flag", []string{"checkered_flag"}, "6.0", false},
	{"\U0001f9c0", "cheese wedge", []string{"cheese"}, "8.0", false},
	{"\U0001f352", "cherries", []string{"cherries"}, "6.0", false},
	{"\U0001f338", "cherry blossom", []string{"cherry_blossom"}, "6.0", false},
	{"\u265f\ufe0f", "chess pawn", []string{"chess_pawn"}, "11.0", false},
	{"\U0001f330", "chestnut", []string{"chestnut"}, "6.0", false},
	{"\U0001f414", "chicken", []string{"chicken"}, "6.0", false},
	{"\U0001f9d2", "child", []string{"child"}, "11.0", true},
	{"\U0001f6b8", "children crossing", []string{"children_crossing"}, "6.0", false},
	{"\U0001f1e8\U0001f1f1", "flag: Chile", []string{"chile"}, "6.0", false},
	{"\U0001f43f\ufe0f", "chipmunk", []string{"chipmunk"}, "7.0", false},
	{"\U0001f36b", "chocolate bar", []string{"chocolate_bar"}, "6.0", false},
	{"\U0001f962", "chopsticks", []string{"chopsticks"}, "11.0", false},
	{"\U0001f1e8\U0001f1fd", "flag: Christmas Island", []string{"christmas_island"}, "6.0", false},
	{"\U0001f384", "Christmas tree", []string{"christmas_tree"}, "6.0", false},
	{"\u26ea", "church", []string{"church"}, "5.2", false},
	{"\U0001f3a6", "cinema", []string{"cinema"}, "6.0", false},
	{"\U0001f3aa", "circus tent", []string{"circus_tent"}, "6.0", false},
	{"\U0001f307", "sunset", []string{"city_sunrise"}, "6.0", false},
	{"\U0001f306", "cityscape at dusk", []string{"city_sunset"}, "6.0", false},
	{"\U0001f3d9\ufe0f", "cityscape", []string{"cityscape"}, "7.0", false},
	{"\U0001f191", "CL button", []string{"cl"}, "6.0", false},
	{"\U0001f5dc\ufe0f", "clamp", []string{"clamp"}, "7.0", false},
	{"\U0001f44f", "clapping hands", []string{"clap"}, "6.0", true},
	{"\U0001f3ac", "clapper board", []string{"clapper"}, "6.0", false},
	{"\U0001f3db\ufe0f", "classical building", []string{"classical_building"}, "7.0", false},
	{"\U0001f9d7", "person climbing", []string{"climbing"}, "11.0", true},
	{"\U0001f9d7\u200d\u2642\ufe0f", "man climbing", []string{"climbing_man"}, "11.0", true},
	{"\U0001f9d7\u200d\u2640\ufe0f", "woman climbing", []string{"climbing_woman"}, "11.0", true},
	{"\U0001f942", "clinking glasses", []string{"clinking_glasses"}, "9.0", false},
	{"\U0001f4cb", "clipboard", []string{"clipboard"}, "6.0", false},
	{"\U0001f1e8\U0001f1f5", "flag: Clipperton Island", []string{"clipperton_island"}, "11.0", false},
	{"\U0001f550", "one o’clock", []string{"clock1"}, "6.0", false},
	{"\U0001f559", "ten o’clock", []string{"clock10"}, "6.0", false},
	{"\U0001f565", "ten-thirty", []string{"clock1030"}, "6.0", false},
	{"\U0001f55a", "eleven o’clock", []string{"clock11"}, "6.0", false},
	{"\U0001f566", "eleven-thirty", []string{"clock1130"}, "6.0", false},
	{"\U0001f55b", "twelve o’clock", []string{"clock12"}, "6.0", false},
	{"\U0001f567", "twelve-thirty", []string{"clock1230"}, "6.0", false},
	{"\U0001f55c", "one-thirty", []string{"clock130"}, "6.0", false},
	{"\U0001f551", "two o’clock", []string{"clock2"}, "6.0", false},
	{"\U0001f55d", "two-thirty", []string{"clock230"}, "6.0", false},
	{"\U0001f552", "three o’clock", []string{"clock3"}, "6.0", false},
	{"\U0001f55e", "three-thirty", []string{"clock330"}, "6.0", false},
	{"\U0001f553", "four o’clock", []string{"clock4"}, "6.0", false},
	{"\U0001f55f", "four-thirty", []string{"clock430"}, "6.0", false},
	{"\U0001f554", "five o’clock", []string{"clock5"}, "6.0", false},
	{"\U0001f560", "five-thirty", []string{"clock530"}, "6.0", false},
	{"\U0001f555", "six o’clock", []string{"clock6"}, "6.0", false},
	{"\U0001f561", "six-thirty", []string{"clock630"}, "6.0", false},
	{"\U0001f556", "seven o’clock", []string{"clock7"}, "6.0", false},
	{"\U0001f562", "seven-thirty", []string{"clock730"}, "6.0", false},
	{"\U0001f557", "eight o’clock", []string{"clock8"}, "6.0", false},
	{"\U0001f563", "eight-thirty", []string{"clock830"}, "6.0", false},
	{"\U0001f558", "nine o’clock", []string{"clock9"}, "6.0", false},
	{"\U0001f564", "nine-thirty", []string{"clock930"}, "6.0", false},
	{"\U0001f4d5", "closed book", []string{"closed_book"}, "6.0", false},
	{"\U0001f510", "locked with key", []string{"closed_lock_with_key"}, "6.0", false},
	{"\U0001f302", "closed umbrella", []string{"closed_umbrella"}, "6.0", false},
	{"\u2601\ufe0f", "cloud", []string{"cloud"}, "", false},
	{"\U0001f329\ufe0f", "cloud with lightning", []string{"cloud_with_lightning"}, "7.0", false},
	{"\u26c8\ufe0f", "cloud with lightning and rain", []string{"cloud_with_lightning_and_rain"}, "5.2", false},
	{"\U0001f327\ufe0f", "cloud with rain", []string{"cloud_with_rain"}, "7.0", false},
	{"\U0001f328\ufe0f", "cloud with snow", []string{"cloud_with_snow"}, "7.0", false},
	{"\U0001f921", "clown face", []string{"clown_face"}, "9.0", false},
	{"\u2663\ufe0f", "club suit", []string{"clubs"}, "", false},
	{"\U0001f1e8\U0001f1f3", "flag: China", []string{"cn"}, "6.0", false},
	{"\U0001f9e5", "coat", []string{"coat"}, "11.0", false},
	{"\U0001f378", "cocktail glass", []string{"cocktail"}, "6.0", false},
	{"\U0001f965", "coconut", []string{"coconut"}, "11.0", false},
	{"\U0001f1e8\U0001f1e8", "flag: Cocos (Keeling) Islands", []string{"cocos_islands"}, "6.0", false},
	{"\u2615", "hot beverage", []string{"coffee"}, "4.0", false},
	{"\u26b0\ufe0f", "coffin", []string{"coffin"}, "4.1", false},
	{"\U0001f976", "cold face", []string{"cold_face"}, "11.0", false},
	{"\U0001f630", "anxious face with sweat", []string{"cold_sweat"}, "6.0", false},
	{"\U0001f1e8\U0001f1f4", "flag: Colombia", []string{"colombia"}, "6.0", false},
	{"\u2604\ufe0f", "comet", []string{"comet"}, "", false},
	{"\U0001f1f0\U0001f1f2", "flag: Comoros", []string{"comoros"}, "6.0", false},
	{"\U0001f9ed", "compass", []string{"compass"}, "11.0", false},
	{"\U0001f4bb", "laptop", []string{"computer"}, "6.0", false},
	{"\U0001f5b1\ufe0f", "computer mouse", []string{"computer_mouse"}, "7.0", false},
	{"\U0001f38a", "confetti ball", []string{"confetti_ball"}, "6.0", false},
	{"\U0001f616", "confounded face", []string{"confounded"}, "6.0", false},
	{"\U0001f615", "confused face", []string{"confused"}, "6.1", false},
	{"\U0001f1e8\U0001f1ec", "flag: Congo - Brazzaville", []string{"congo_brazzaville"}, "6.0", false},
	{"\U0001f1e8\U0001f1e9", "flag: Congo - Kinshasa", []string{"congo_kinshasa"}, "6.0", false},
	{"\u3297\ufe0f", "Japanese “congratulations” button", []string{"congratulations"}, "", false},
	{"\U0001f6a7", "construction", []string{"construction"}, "6.0", false},
	{"\U0001f477", "construction worker", []string{"construction_worker"}, "6.0", true},
	{"\U0001f477\u200d\u2642\ufe0f", "man construction worker", []string{"construction_worker_man"}, "11.0", true},
	{"\U0001f477\u200d\u2640\ufe0f", "woman construction worker", []string{"construction_worker_woman"}, "6.0", true},
	{"\U0001f39b\ufe0f", "control knobs", []string{"control_knobs"}, "7.0", false},
	{"\U0001f3ea", "convenience store", []string{"convenience_store"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f373", "cook", []string{"cook"}, "12.1", true},
	{"\U0001f1e8\U0001f1f0", "flag: Cook Islands", []string{"cook_islands"}, "6.0", false},
	{"\U0001f36a", "cookie", []string{"cookie"}, "6.0", false},
	{"\U0001f192", "COOL button", []string{"cool"}, "6.0", false},
	{"\u00a9\ufe0f", "copyright", []string{"copyright"}, "", false},
	{"\U0001f33d", "ear of corn", []string{"corn"}, "6.0", false},
	{"\U0001f1e8\U0001f1f7", "flag: Costa Rica", []string{"costa_rica"}, "6.0", false},
	{"\U0001f1e8\U0001f1ee", "flag: Côte d’Ivoire", []string{"cote_divoire"}, "6.0", false},
	{"\U0001f6cb\ufe0f", "couch and lamp", []string{"couch_and_lamp"}, "7.0", false},
	{"\U0001f46b", "woman and man holding hands", []string{"couple"}, "6.0", true},
	{"\U0001f491", "couple with heart", []string{"couple_with_heart"}, "6.0", false},
	{"\U0001f468\u200d\u2764\ufe0f\u200d\U0001f468", "couple with heart: man, man", []string{"couple_with_heart_man_man"}, "6.0", false},
	{"\U0001f469\u200d\u2764\ufe0f\u200d\U0001f468", "couple with heart: woman, man", []string{"couple_with_heart_woman_man"}, "11.0", false},
	{"\U0001f469\u200d\u2764\ufe0f\u200d\U0001f469", "couple with heart: woman, woman", []string{"couple_with_heart_woman_woman"}, "6.0", false},
	{"\U0001f48f", "kiss", []string{"couplekiss"}, "6.0", false},
	{"\U0001f468\u200d\u2764\ufe0f\u200d\U0001f48b\u200d\U0001f468", "kiss: man, man", []string{"couplekiss_man_man"}, "6.0", false},
	{"\U0001f469\u200d\u2764\ufe0f\u200d\U0001f48b\u200d\U0001f468", "kiss: woman, man", []string{"couplekiss_man_woman"}, "11.0", false},
	{"\U0001f469\u200d\u2764\ufe0f\u200d\U0001f48b\u200d\U0001f469", "kiss: woman, woman", []string{"couplekiss_woman_woman"}, "6.0", false},
	{"\U0001f42e", "cow face", []string{"cow"}, "6.0", false},
	{"\U0001f404", "cow", []string{"cow2"}, "6.0", false},
	{"\U0001f920", "cowboy hat face", []string{"cowboy_hat_face"}, "9.0", false},
	{"\U0001f980", "crab", []string{"crab"}, "8.0", false},
	{"\U0001f58d\ufe0f", "crayon", []string{"crayon"}, "7.0", false},
	{"\U0001f4b3", "credit card", []string{"credit_card"}, "6.0", false},
	{"\U0001f319", "crescent moon", []string{"crescent_moon"}, "6.0", false},
	{"\U0001f997", "cricket", []string{"cricket"}, "11.0", false},
	{"\U0001f3cf", "cricket game", []string{"cricket_game"}, "8.0", false},
	{"\U0001f1ed\U0001f1f7", "flag: Croatia", []string{"croatia"}, "6.0", false},
	{"\U0001f40a", "crocodile", []string{"crocodile"}, "6.0", false},
	{"\U0001f950", "croissant", []string{"croissant"}, "9.0", false},
	{"\U0001f91e", "crossed fingers", []string{"crossed_fingers"}, "9.0", true},
	{"\U0001f38c", "crossed flags", []string{"crossed_flags"}, "6.0", false},
	{"\u2694\ufe0f", "crossed swords", []string{"crossed_swords"}, "4.1", false},
	{"\U0001f451", "crown", []string{"crown"}, "6.0", false},
	{"\U0001f622", "crying face", []string{"cry"}, "6.0", false},
	{"\U0001f63f", "crying cat", []string{"crying_cat_face"}, "6.0", false},
	{"\U0001f52e", "crystal ball", []string{"crystal_ball"}, "6.0", false},
	{"\U0001f1e8\U0001f1fa", "flag: Cuba", []string{"cuba"}, "6.0", false},
	{"\U0001f952", "cucumber", []string{"cucumber"}, "9.0", false},
	{"\U0001f964", "cup with straw", []string{"cup_with_straw"}, "11.0", false},
	{"\U0001f9c1", "cupcake", []string{"cupcake"}, "11.0", false},
	{"\U0001f498", "heart with arrow", []string{"cupid"}, "6.0", false},
	{"\U0001f1e8\U0001f1fc", "flag: Curaçao", []string{"curacao"}, "6.0", false},
	{"\U0001f94c", "curling stone", []string{"curling_stone"}, "11.0", false},
	{"\U0001f468\u200d\U0001f9b1", "man: curly hair", []string{"curly_haired_man"}, "11.0", true},
	{"\U0001f469\u200d\U0001f9b1", "woman: curly hair", []string{"curly_haired_woman"}, "11.0", true},
	{"\u27b0", "curly loop", []string{"curly_loop"}, "6.0", false},
	{"\U0001f4b1", "currency exchange", []string{"currency_exchange"}, "6.0", false},
	{"\U0001f35b", "curry rice", []string{"curry"}, "6.0", false},
	{"\U0001f92c", "face with symbols on mouth", []string{"cursing_face"}, "11.0", false},
	{"\U0001f36e", "custard", []string{"custard"}, "6.0", false},
	{"\U0001f6c3", "customs", []string{"customs"}, "6.0", false},
	{"\U0001f969", "cut of meat", []string{"cut_of_meat"}, "11.0", false},
	{"\U0001f300", "cyclone", []string{"cyclone"}, "6.0", false},
	{"\U0001f1e8\U0001f1fe", "flag: Cyprus", []string{"cyprus"}, "6.0", false},
	{"\U0001f1e8\U0001f1ff", "flag: Czechia", []string{"czech_republic"}, "6.0", false},
	{"\U0001f5e1\ufe0f", "dagger", []string{"dagger"}, "7.0", false},
	{"\U0001f46f", "people with bunny ears", []string{"dancers"}, "6.0", false},
	{"\U0001f46f\u200d\u2642\ufe0f", "men with bunny ears", []string{"dancing_men"}, "6.0", false},
	{"\U0001f46f\u200d\u2640\ufe0f", "women with bunny ears", []string{"dancing_women"}, "11.0", false},
	{"\U0001f361", "dango", []string{"dango"}, "6.0", false},
	{"\U0001f576\ufe0f", "sunglasses", []string{"dark_sunglasses"}, "7.0", false},
	{"\U0001f3af", "direct hit", []string{"dart"}, "6.0", false},
	{"\U0001f4a8", "dashing away", []string{"dash"}, "6.0", false},
	{"\U0001f4c5", "calendar", []string{"date"}, "6.0", false},
	{"\U0001f1e9\U0001f1ea", "flag: Germany", []string{"de"}, "6.0", false},
	{"\U0001f9cf\u200d\u2642\ufe0f", "deaf man", []string{"deaf_man"}, "12.0", true},
	{"\U0001f9cf", "deaf person", []string{"deaf_person"}, "12.0", true},
	{"\U0001f9cf\u200d\u2640\ufe0f", "deaf woman", []string{"deaf_woman"}, "12.0", true},
	{"\U0001f333", "deciduous tree", []string{"deciduous_tree"}, "6.0", false},
	{"\U0001f98c", "deer", []string{"deer"}, "9.0", false},
	{"\U0001f1e9\U0001f1f0", "flag: Denmark", []string{"denmark"}, "6.0", false},
	{"\U0001f3ec", "department store", []string{"department_store"}, "6.0", false},
	{"\U0001f3da\ufe0f", "derelict house", []string{"derelict_house"}, "7.0", false},
	{"\U0001f3dc\ufe0f", "desert", []string{"desert"}, "7.0", false},
	{"\U0001f3dd\ufe0f", "desert island", []string{"desert_island"}, "7.0", false},
	{"\U0001f5a5\ufe0f", "desktop computer", []string{"desktop_computer"}, "7.0", false},
	{"\U0001f575\ufe0f", "detective", []string{"detective"}, "7.0", true},
	{"\U0001f4a0", "diamond with a dot", []string{"diamond_shape_with_a_dot_inside"}, "6.0", false},
	{"\u2666\ufe0f", "diamond suit", []string{"diamonds"}, "", false},
	{"\U0001f1e9\U0001f1ec", "flag: Diego Garcia", []string{"diego_garcia"}, "11.0", false},
	{"\U0001f61e", "disappointed face", []string{"disappointed"}, "6.0", false},
	{"\U0001f625", "sad but relieved face", []string{"disappointed_relieved"}, "6.0", false},
	{"\U0001f93f", "diving mask", []string{"diving_mask"}, "12.0", false},
	{"\U0001fa94", "diya lamp", []string{"diya_lamp"}, "12.0", false},
	{"\U0001f4ab", "dizzy", []string{"dizzy"}, "6.0", false},
	{"\U0001f635", "dizzy face", []string{"dizzy_face"}, "6.0", false},
	{"\U0001f1e9\U0001f1ef", "flag: Djibouti", []string{"djibouti"}, "6.0", false},
	{"\U0001f9ec", "dna", []string{"dna"}, "11.0", false},
	{"\U0001f6af", "no littering", []string{"do_not_litter"}, "6.0", false},
	{"\U0001f436", "dog face", []string{"dog"}, "6.0", false},
	{"\U0001f415", "dog", []string{"dog2"}, "6.0", false},
	{"\U0001f4b5", "dollar banknote", []string{"dollar"}, "6.0", false},
	{"\U0001f38e", "Japanese dolls", []string{"dolls"}, "6.0", false},
	{"\U0001f42c", "dolphin", []string{"dolphin", "flipper"}, "6.0", false},
	{"\U0001f1e9\U0001f1f2", "flag: Dominica", []string{"dominica"}, "6.0", false},
	{"\U0001f1e9\U0001f1f4", "flag: Dominican Republic", []string{"dominican_republic"}, "6.0", false},
	{"\U0001f6aa", "door", []string{"door"}, "6.0", false},
	{"\U0001f369", "doughnut", []string{"doughnut"}, "6.0", false},
	{"\U0001f54a\ufe0f", "dove", []string{"dove"}, "7.0", false},
	{"\U0001f409", "dragon", []string{"dragon"}, "6.0", false},
	{"\U0001f432", "dragon face", []string{"dragon_face"}, "6.0", false},
	{"\U0001f457", "dress", []string{"dress"}, "6.0", false},
	{"\U0001f42a", "camel", []string{"dromedary_camel"}, "6.0", false},
	{"\U0001f924", "drooling face", []string{"drooling_face"}, "9.0", false},
	{"\U0001fa78", "drop of blood", []string{"drop_of_blood"}, "12.0", false},
	{"\U0001f4a7", "droplet", []string{"droplet"}, "6.0", false},
	{"\U0001f941", "drum", []string{"drum"}, "", false},
	{"\U0001f986", "duck", []string{"duck"}, "9.0", false},
	{"\U0001f95f", "dumpling", []string{"dumpling"}, "11.0", false},
	{"\U0001f4c0", "dvd", []string{"dvd"}, "6.0", false},
	{"\U0001f4e7", "e-mail", []string{"e-mail"}, "6.0", false},
	{"\U0001f985", "eagle", []string{"eagle"}, "9.0", false},
	{"\U0001f442", "ear", []string{"ear"}, "6.0", true},
	{"\U0001f33e", "sheaf of rice", []string{"ear_of_rice"}, "6.0", false},
	{"\U0001f9bb", "ear with hearing aid", []string{"ear_with_hearing_aid"}, "12.0", true},
	{"\U0001f30d", "globe showing Europe-Africa", []string{"earth_africa"}, "6.0", false},
	{"\U0001f30e", "globe showing Americas", []string{"earth_americas"}, "6.0", false},
	{"\U0001f30f", "globe showing Asia-Australia", []string{"earth_asia"}, "6.0", false},
	{"\U0001f1ea\U0001f1e8", "flag: Ecuador", []string{"ecuador"}, "6.0", false},
	{"\U0001f95a", "egg", []string{"egg"}, "9.0", false},
	{"\U0001f346", "eggplant", []string{"eggplant"}, "6.0", false},
	{"\U0001f1ea\U0001f1ec", "flag: Egypt", []string{"egypt"}, "6.0", false},
	{"8\ufe0f\u20e3", "keycap: 8", []string{"eight"}, "", false},
	{"\u2734\ufe0f", "eight-pointed star", []string{"eight_pointed_black_star"}, "", false},
	{"\u2733\ufe0f", "eight-spoked asterisk", []string{"eight_spoked_asterisk"}, "", false},
	{"\u23cf\ufe0f", "eject button", []string{"eject_button"}, "11.0", false},
	{"\U0001f1f8\U0001f1fb", "flag: El Salvador", []string{"el_salvador"}, "6.0", false},
	{"\U0001f50c", "electric plug", []string{"electric_plug"}, "6.0", false},
	{"\U0001f418", "elephant", []string{"elephant"}, "6.0", false},
	{"\U0001f9dd", "elf", []string{"elf"}, "11.0", true},
	{"\U0001f9dd\u200d\u2642\ufe0f", "man elf", []string{"elf_man"}, "11.0", true},
	{"\U0001f9dd\u200d\u2640\ufe0f", "woman elf", []string{"elf_woman"}, "11.0", true},
	{"\u2709\ufe0f", "envelope", []string{"email", "envelope"}, "", false},
	{"\U0001f51a", "END arrow", []string{"end"}, "6.0", false},
	{"\U0001f3f4\U000e0067\U000e0062\U000e0065\U000e006e\U000e0067\U000e007f", "flag: England", []string{"england"}, "11.0", false},
	{"\U0001f4e9", "envelope with arrow", []string{"envelope_with_arrow"}, "6.0", false},
	{"\U0001f1ec\U0001f1f6", "flag: Equatorial Guinea", []string{"equatorial_guinea"}, "6.0", false},
	{"\U0001f1ea\U0001f1f7", "flag: Eritrea", []string{"eritrea"}, "6.0", false},
	{"\U0001f1ea\U0001f1f8", "flag: Spain", []string{"es"}, "6.0", false},
	{"\U0001f1ea\U0001f1ea", "flag: Estonia", []string{"estonia"}, "6.0", false},
	{"\U0001f1ea\U0001f1f9", "flag: Ethiopia", []string{"ethiopia"}, "6.0", false},
	{"\U0001f1ea\U0001f1fa", "flag: European Union", []string{"eu", "european_union"}, "6.0", false},
	{"\U0001f4b6", "euro banknote", []string{"euro"}, "6.0", false},
	{"\U0001f3f0", "castle", []string{"european_castle"}, "6.0", false},
	{"\U0001f3e4", "post office", []string{"european_post_office"}, "6.0", false},
	{"\U0001f332", "evergreen tree", []string{"evergreen_tree"}, "6.0", false},
	{"\u2757", "exclamation mark", []string{"exclamation", "heavy_exclamation_mark"}, "5.2", false},
	{"\U0001f92f", "exploding head", []string{"exploding_head"}, "11.0", false},
	{"\U0001f611", "expressionless face", []string{"expressionless"}, "6.1", false},
	{"\U0001f441\ufe0f", "eye", []string{"eye"}, "7.0", false},
	{"\U0001f441\ufe0f\u200d\U0001f5e8\ufe0f", "eye in speech bubble", []string{"eye_speech_bubble"}, "11.0", false},
	{"\U0001f453", "glasses", []string{"eyeglasses"}, "6.0", false},
	{"\U0001f440", "eyes", []string{"eyes"}, "6.0", false},
	{"\U0001f915", "face with head-bandage", []string{"face_with_head_bandage"}, "8.0", false},
	{"\U0001f912", "face with thermometer", []string{"face_with_thermometer"}, "8.0", false},
	{"\U0001f926", "person facepalming", []string{"facepalm"}, "11.0", true},
	{"\U0001f3ed", "factory", []string{"factory"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f3ed", "factory worker", []string{"factory_worker"}, "12.1", true},
	{"\U0001f9da", "fairy", []string{"fairy"}, "11.0", true},
	{"\U0001f9da\u200d\u2642\ufe0f", "man fairy", []string{"fairy_man"}, "11.0", true},
	{"\U0001f9da\u200d\u2640\ufe0f", "woman fairy", []string{"fairy_woman"}, "11.0", true},
	{"\U0001f9c6", "falafel", []string{"falafel"}, "12.0", false},
	{"\U0001f1eb\U0001f1f0", "flag: Falkland Islands", []string{"falkland_islands"}, "6.0", false},
	{"\U0001f342", "fallen leaf", []string{"fallen_leaf"}, "6.0", false},
	{"\U0001f46a", "family", []string{"family"}, "6.0", false},
	{"\U0001f468\u200d\U0001f466", "family: man, boy", []string{"family_man_boy"}, "6.0", false},
	{"\U0001f468\u200d\U0001f466\u200d\U0001f466", "family: man, boy, boy", []string{"family_man_boy_boy"}, "6.0", false},
	{"\U0001f468\u200d\U0001f467", "family: man, girl", []string{"family_man_girl"}, "6.0", false},
	{"\U0001f468\u200d\U0001f467\u200d\U0001f466", "family: man, girl, boy", []string{"family_man_girl_boy"}, "6.0", false},
	{"\U0001f468\u200d\U0001f467\u200d\U0001f467", "family: man, girl, girl", []string{"family_man_girl_girl"}, "6.0", false},
	{"\U0001f468\u200d\U0001f468\u200d\U0001f466", "family: man, man, boy", []string{"family_man_man_boy"}, "6.0", false},
	{"\U0001f468\u200d\U0001f468\u200d\U0001f466\u200d\U0001f466", "family: man, man, boy, boy", []string{"family_man_man_boy_boy"}, "6.0", false},
	{"\U0001f468\u200d\U0001f468\u200d\U0001f467", "family: man, man, girl", []string{"family_man_man_girl"}, "6.0", false},
	{"\U0001f468\u200d\U0001f468\u200d\U0001f467\u200d\U0001f466", "family: man, man, girl, boy", []string{"family_man_man_girl_boy"}, "6.0", false},
	{"\U0001f468\u200d\U0001f468\u200d\U0001f467\u200d\U0001f467", "family: man, man, girl, girl", []string{"family_man_man_girl_girl"}, "6.0", false},
	{"\U0001f468\u200d\U0001f469\u200d\U0001f466", "family: man, woman, boy", []string{"family_man_woman_boy"}, "11.0", false},
	{"\U0001f468\u200d\U0001f469\u200d\U0001f466\u200d\U0001f466", "family: man, woman, boy, boy", []string{"family_man_woman_boy_boy"}, "6.0", false},
	{"\U0001f468\u200d\U0001f469\u200d\U0001f467", "family: man, woman, girl", []string{"family_man_woman_girl"}, "6.0", false},
	{"\U0001f468\u200d\U0001f469\u200d\U0001f467\u200d\U0001f466", "family: man, woman, girl, boy", []string{"family_man_woman_girl_boy"}, "6.0", false},
	{"\U0001f468\u200d\U0001f469\u200d\U0001f467\u200d\U0001f467", "family: man, woman, girl, girl", []string{"family_man_woman_girl_girl"}, "6.0", false},
	{"\U0001f469\u200d\U0001f466", "family: woman, boy", []string{"family_woman_boy"}, "6.0", false},
	{"\U0001f469\u200d\U0001f466\u200d\U0001f466", "family: woman, boy, boy", []string{"family_woman_boy_boy"}, "6.0", false},
	{"\U0001f469\u200d\U0001f467", "family: woman, girl", []string{"family_woman_girl"}, "6.0", false},
	{"\U0001f469\u200d\U0001f467\u200d\U0001f466", "family: woman, girl, boy", []string{"family_woman_girl_boy"}, "6.0", false},
	{"\U0001f469\u200d\U0001f467\u200d\U0001f467", "family: woman, girl, girl", []string{"family_woman_girl_girl"}, "6.0", false},
	{"\U0001f469\u200d\U0001f469\u200d\U0001f466", "family: woman, woman, boy", []string{"family_woman_woman_boy"}, "6.0", false},
	{"\U0001f469\u200d\U0001f469\u200d\U0001f466\u200d\U0001f466", "family: woman, woman, boy, boy", []string{"family_woman_woman_boy_boy"}, "6.0", false},
	{"\U0001f469\u200d\U0001f469\u200d\U0001f467", "family: woman, woman, girl", []string{"family_woman_woman_girl"}, "6.0", false},
	{"\U0001f469\u200d\U0001f469\u200d\U0001f467\u200d\U0001f466", "family: woman, woman, girl, boy", []string{"family_woman_woman_girl_boy"}, "6.0", false},
	{"\U0001f469\u200d\U0001f469\u200d\U0001f467\u200d\U0001f467", "family: woman, woman, girl, girl", []string{"family_woman_woman_girl_girl"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f33e", "farmer", []string{"farmer"}, "12.1", true},
	{"\U0001f1eb\U0001f1f4", "flag: Faroe Islands", []string{"faroe_islands"}, "6.0", false},
	{"\u23e9", "fast-forward button", []string{"fast_forward"}, "6.0", false},
	{"\U0001f4e0", "fax machine", []string{"fax"}, "6.0", false},
	{"\U0001f628", "fearful face", []string{"fearful"}, "6.0", false},
	{"\U0001f43e", "paw prints", []string{"feet", "paw_prints"}, "6.0", false},
	{"\U0001f575\ufe0f\u200d\u2640\ufe0f", "woman detective", []string{"female_detective"}, "6.0", true},
	{"\u2640\ufe0f", "female sign", []string{"female_sign"}, "11.0", false},
	{"\U0001f3a1", "ferris wheel", []string{"ferris_wheel"}, "6.0", false},
	{"\u26f4\ufe0f", "ferry", []string{"ferry"}, "5.2", false},
	{"\U0001f3d1", "field hockey", []string{"field_hockey"}, "8.0", false},
	{"\U0001f1eb\U0001f1ef", "flag: Fiji", []string{"fiji"}, "6.0", false},
	{"\U0001f5c4\ufe0f", "file cabinet", []string{"file_cabinet"}, "7.0", false},
	{"\U0001f4c1", "file folder", []string{"file_folder"}, "6.0", false},
	{"\U0001f4fd\ufe0f", "film projector", []string{"film_projector"}, "7.0", false},
	{"\U0001f39e\ufe0f", "film frames", []string{"film_strip"}, "7.0", false},
	{"\U0001f1eb\U0001f1ee", "flag: Finland", []string{"finland"}, "6.0", false},
	{"\U0001f525", "fire", []string{"fire"}, "6.0", false},
	{"\U0001f692", "fire engine", []string{"fire_engine"}, "6.0", false},
	{"\U0001f9ef", "fire extinguisher", []string{"fire_extinguisher"}, "11.0", false},
	{"\U0001f9e8", "firecracker", []string{"firecracker"}, "11.0", false},
	{"\U0001f9d1\u200d\U0001f692", "firefighter", []string{"firefighter"}, "12.1", true},
	{"\U0001f386", "fireworks", []string{"fireworks"}, "6.0", false},
	{"\U0001f313", "first quarter moon", []string{"first_quarter_moon"}, "6.0", false},
	{"\U0001f31b", "first quarter moon face", []string{"first_quarter_moon_with_face"}, "6.0", false},
	{"\U0001f41f", "fish", []string{"fish"}, "6.0", false},
	{"\U0001f365", "fish cake with swirl", []string{"fish_cake"}, "6.0", false},
	{"\U0001f3a3", "fishing pole", []string{"fishing_pole_and_fish"}, "6.0", false},
	{"\U0001f91b", "left-facing fist", []string{"fist_left"}, "9.0", true},
	{"\U0001f44a", "oncoming fist", []string{"fist_oncoming", "facepunch", "punch"}, "6.0", true},
	{"\u270a", "raised fist", []string{"fist_raised", "fist"}, "6.0", true},
	{"\U0001f91c", "right-facing fist", []string{"fist_right"}, "9.0", true},
	{"5\ufe0f\u20e3", "keycap: 5", []string{"five"}, "", false},
	{"\U0001f38f", "carp streamer", []string{"flags"}, "6.0", false},
	{"\U0001f9a9", "flamingo", []string{"flamingo"}, "12.0", false},
	{"\U0001f526", "flashlight", []string{"flashlight"}, "6.0", false},
	{"\U0001f97f", "flat shoe", []string{"flat_shoe"}, "11.0", false},
	{"\u269c\ufe0f", "fleur-de-lis", []string{"fleur_de_lis"}, "4.1", false},
	{"\U0001f6ec", "airplane arrival", []string{"flight_arrival"}, "7.0", false},
	{"\U0001f6eb", "airplane departure", []string{"flight_departure"}, "7.0", false},
	{"\U0001f4be", "floppy disk", []string{"floppy_disk"}, "6.0", false},
	{"\U0001f3b4", "flower playing cards", []string{"flower_playing_cards"}, "6.0", false},
	{"\U0001f633", "flushed face", []string{"flushed"}, "6.0", false},
	{"\U0001f94f", "flying disc", []string{"flying_disc"}, "11.0", false},
	{"\U0001f6f8", "flying saucer", []string{"flying_saucer"}, "11.0", false},
	{"\U0001f32b\ufe0f", "fog", []string{"fog"}, "7.0", false},
	{"\U0001f301", "foggy", []string{"foggy"}, "6.0", false},
	{"\U0001f9b6", "foot", []string{"foot"}, "11.0", true},
	{"\U0001f3c8", "american football", []string{"football"}, "6.0", false},
	{"\U0001f463", "footprints", []string{"footprints"}, "6.0", false},
	{"\U0001f374", "fork and knife", []string{"fork_and_knife"}, "6.0", false},
	{"\U0001f960", "fortune cookie", []string{"fortune_cookie"}, "11.0", false},
	{"\u26f2", "fountain", []string{"fountain"}, "5.2", false},
	{"\U0001f58b\ufe0f", "fountain pen", []string{"fountain_pen"}, "7.0", false},
	{"4\ufe0f\u20e3", "keycap: 4", []string{"four"}, "", false},
	{"\U0001f340", "four leaf clover", []string{"four_leaf_clover"}, "6.0", false},
	{"\U0001f98a", "fox", []string{"fox_face"}, "9.0", false},
	{"\U0001f1eb\U0001f1f7", "flag: France", []string{"fr"}, "6.0", false},
	{"\U0001f5bc\ufe0f", "framed picture", []string{"framed_picture"}, "7.0", false},
	{"\U0001f193", "FREE button", []string{"free"}, "6.0", false},
	{"\U0001f1ec\U0001f1eb", "flag: French Guiana", []string{"french_guiana"}, "6.0", false},
	{"\U0001f1f5\U0001f1eb", "flag: French Polynesia", []string{"french_polynesia"}, "6.0", false},
	{"\U0001f1f9\U0001f1eb", "flag: French Southern Territories", []string{"french_southern_territories"}, "6.0", false},
	{"\U0001f373", "cooking", []string{"fried_egg"}, "6.0", false},
	{"\U0001f364", "fried shrimp", []string{"fried_shrimp"}, "6.0", false},
	{"\U0001f35f", "french fries", []string{"fries"}, "6.0", false},
	{"\U0001f438", "frog", []string{"frog"}, "6.0", false},
	{"\U0001f626", "frowning face with open mouth", []string{"frowning"}, "6.1", false},
	{"\u2639\ufe0f", "frowning face", []string{"frowning_face"}, "", false},
	{"\U0001f64d\u200d\u2642\ufe0f", "man frowning", []string{"frowning_man"}, "6.0", true},
	{"\U0001f64d", "person frowning", []string{"frowning_person"}, "6.0", true},
	{"\U0001f64d\u200d\u2640\ufe0f", "woman frowning", []string{"frowning_woman"}, "11.0", true},
	{"\u26fd", "fuel pump", []string{"fuelpump"}, "5.2", false},
	{"\U0001f315", "full moon", []string{"full_moon"}, "6.0", false},
	{"\U0001f31d", "full moon face", []string{"full_moon_with_face"}, "6.0", false},
	{"\u26b1\ufe0f", "funeral urn", []string{"funeral_urn"}, "4.1", false},
	{"\U0001f1ec\U0001f1e6", "flag: Gabon", []string{"gabon"}, "6.0", false},
	{"\U0001f1ec\U0001f1f2", "flag: Gambia", []string{"gambia"}, "6.0", false},
	{"\U0001f3b2", "game die", []string{"game_die"}, "6.0", false},
	{"\U0001f9c4", "garlic", []string{"garlic"}, "12.0", false},
	{"\U0001f1ec\U0001f1e7", "flag: United Kingdom", []string{"gb", "uk"}, "6.0", false},
	{"\u2699\ufe0f", "gear", []string{"gear"}, "4.1", false},
	{"\U0001f48e", "gem stone", []string{"gem"}, "6.0", false},
	{"\u264a", "Gemini", []string{"gemini"}, "", false},
	{"\U0001f9de", "genie", []string{"genie"}, "11.0", false},
	{"\U0001f9de\u200d\u2642\ufe0f", "man genie", []string{"genie_man"}, "11.0", false},
	{"\U0001f9de\u200d\u2640\ufe0f", "woman genie", []string{"genie_woman"}, "11.0", false},
	{"\U0001f1ec\U0001f1ea", "flag: Georgia", []string{"georgia"}, "6.0", false},
	{"\U0001f1ec\U0001f1ed", "flag: Ghana", []string{"ghana"}, "6.0", false},
	{"\U0001f47b", "ghost", []string{"ghost"}, "6.0", false},
	{"\U0001f1ec\U0001f1ee", "flag: Gibraltar", []string{"gibraltar"}, "6.0", false},
	{"\U0001f381", "wrapped gift", []string{"gift"}, "6.0", false},
	{"\U0001f49d", "heart with ribbon", []string{"gift_heart"}, "6.0", false},
	{"\U0001f992", "giraffe", []string{"giraffe"}, "11.0", false},
	{"\U0001f467", "girl", []string{"girl"}, "6.0", true},
	{"\U0001f310", "globe with meridians", []string{"globe_with_meridians"}, "6.0", false},
	{"\U0001f9e4", "gloves", []string{"gloves"}, "11.0", false},
	{"\U0001f945", "goal net", []string{"goal_net"}, "9.0", false},
	{"\U0001f410", "goat", []string{"goat"}, "6.0", false},
	{"\U0001f97d", "goggles", []string{"goggles"}, "11.0", false},
	{"\u26f3", "flag in hole", []string{"golf"}, "5.2", false},
	{"\U0001f3cc\ufe0f", "person golfing", []string{"golfing"}, "7.0", true},
	{"\U0001f3cc\ufe0f\u200d\u2642\ufe0f", "man golfing", []string{"golfing_man"}, "11.0", true},
	{"\U0001f3cc\ufe0f\u200d\u2640\ufe0f", "woman golfing", []string{"golfing_woman"}, "", true},
	{"\U0001f98d", "gorilla", []string{"gorilla"}, "9.0", false},
	{"\U0001f347", "grapes", []string{"grapes"}, "6.0", false},
	{"\U0001f1ec\U0001f1f7", "flag: Greece", []string{"greece"}, "6.0", false},
	{"\U0001f34f", "green apple", []string{"green_apple"}, "6.0", false},
	{"\U0001f4d7", "green book", []string{"green_book"}, "6.0", false},
	{"\U0001f7e2", "green circle", []string{"green_circle"}, "12.0", false},
	{"\U0001f49a", "green heart", []string{"green_heart"}, "6.0", false},
	{"\U0001f957", "green salad", []string{"green_salad"}, "9.0", false},
	{"\U0001f7e9", "green square", []string{"green_square"}, "12.0", false},
	{"\U0001f1ec\U0001f1f1", "flag: Greenland", []string{"greenland"}, "6.0", false},
	{"\U0001f1ec\U0001f1e9", "flag: Grenada", []string{"grenada"}, "6.0", false},
	{"\u2755", "white exclamation mark", []string{"grey_exclamation"}, "6.0", false},
	{"\u2754", "white question mark", []string{"grey_question"}, "6.0", false},
	{"\U0001f62c", "grimacing face", []string{"grimacing"}, "6.1", false},
	{"\U0001f601", "beaming face with smiling eyes", []string{"grin"}, "6.0", false},
	{"\U0001f600", "grinning face", []string{"grinning"}, "6.1", false},
	{"\U0001f1ec\U0001f1f5", "flag: Guadeloupe", []string{"guadeloupe"}, "6.0", false},
	{"\U0001f1ec\U0001f1fa", "flag: Guam", []string{"guam"}, "6.0", false},
	{"\U0001f482", "guard", []string{"guard"}, "6.0", true},
	{"\U0001f482\u200d\u2642\ufe0f", "man guard", []string{"guardsman"}, "11.0", true},
	{"\U0001f482\u200d\u2640\ufe0f", "woman guard", []string{"guardswoman"}, "6.0", true},
	{"\U0001f1ec\U0001f1f9", "flag: Guatemala", []string{"guatemala"}, "6.0", false},
	{"\U0001f1ec\U0001f1ec", "flag: Guernsey", []string{"guernsey"}, "6.0", false},
	{"\U0001f9ae", "guide dog", []string{"guide_dog"}, "12.0", false},
	{"\U0001f1ec\U0001f1f3", "flag: Guinea", []string{"guinea"}, "6.0", false},
	{"\U0001f1ec\U0001f1fc", "flag: Guinea-Bissau", []string{"guinea_bissau"}, "6.0", false},
	{"\U0001f3b8", "guitar", []string{"guitar"}, "6.0", false},
	{"\U0001f52b", "pistol", []string{"gun"}, "6.0", false},
	{"\U0001f1ec\U0001f1fe", "flag: Guyana", []string{"guyana"}, "6.0", false},
	{"\U0001f487", "person getting haircut", []string{"haircut"}, "6.0", true},
	{"\U0001f487\u200d\u2642\ufe0f", "man getting haircut", []string{"haircut_man"}, "6.0", true},
	{"\U0001f487\u200d\u2640\ufe0f", "woman getting haircut", []string{"haircut_woman"}, "11.0", true},
	{"\U0001f1ed\U0001f1f9", "flag: Haiti", []string{"haiti"}, "6.0", false},
	{"\U0001f354", "hamburger", []string{"hamburger"}, "6.0", false},
	{"\U0001f528", "hammer", []string{"hammer"}, "6.0", false},
	{"\u2692\ufe0f", "hammer and pick", []string{"hammer_and_pick"}, "4.1", false},
	{"\U0001f6e0\ufe0f", "hammer and wrench", []string{"hammer_and_wrench"}, "7.0", false},
	{"\U0001f439", "hamster", []string{"hamster"}, "6.0", false},
	{"\u270b", "raised hand", []string{"hand", "raised_hand"}, "6.0", true},
	{"\U0001f92d", "face with hand over mouth", []string{"hand_over_mouth"}, "11.0", false},
	{"\U0001f45c", "handbag", []string{"handbag"}, "6.0", false},
	{"\U0001f93e", "person playing handball", []string{"handball_person"}, "11.0", true},
	{"\U0001f91d", "handshake", []string{"handshake"}, "9.0", false},
	{"\U0001f4a9", "pile of poo", []string{"hankey", "poop", "shit"}, "6.0", false},
	{"#\ufe0f\u20e3", "keycap: #", []string{"hash"}, "", false},
	{"\U0001f425", "front-facing baby chick", []string{"hatched_chick"}, "6.0", false},
	{"\U0001f423", "hatching chick", []string{"hatching_chick"}, "6.0", false},
	{"\U0001f3a7", "headphone", []string{"headphones"}, "6.0", false},
	{"\U0001f9d1\u200d\u2695\ufe0f", "health worker", []string{"health_worker"}, "12.1", true},
	{"\U0001f649", "hear-no-evil monkey", []string{"hear_no_evil"}, "6.0", false},
	{"\U0001f1ed\U0001f1f2", "flag: Heard & McDonald Islands", []string{"heard_mcdonald_islands"}, "11.0", false},
	{"\u2764\ufe0f", "red heart", []string{"heart"}, "", false},
	{"\U0001f49f", "heart decoration", []string{"heart_decoration"}, "6.0", false},
	{"\U0001f60d", "smiling face with heart-eyes", []string{"heart_eyes"}, "6.0", false},
	{"\U0001f63b", "smiling cat with heart-eyes", []string{"heart_eyes_cat"}, "6.0", false},
	{"\U0001f493", "beating heart", []string{"heartbeat"}, "6.0", false},
	{"\U0001f497", "growing heart", []string{"heartpulse"}, "6.0", false},
	{"\u2665\ufe0f", "heart suit", []string{"hearts"}, "", false},
	{"\u2714\ufe0f", "check mark", []string{"heavy_check_mark"}, "", false},
	{"\u2797", "divide", []string{"heavy_division_sign"}, "6.0", false},
	{"\U0001f4b2", "heavy dollar sign", []string{"heavy_dollar_sign"}, "6.0", false},
	{"\u2763\ufe0f", "heart exclamation", []string{"heavy_heart_exclamation"}, "", false},
	{"\u2796", "minus", []string{"heavy_minus_sign"}, "6.0", false},
	{"\u2716\ufe0f", "multiply", []string{"heavy_multiplication_x"}, "", false},
	{"\u2795", "plus", []string{"heavy_plus_sign"}, "6.0", false},
	{"\U0001f994", "hedgehog", []string{"hedgehog"}, "11.0", false},
	{"\U0001f681", "helicopter", []string{"helicopter"}, "6.0", false},
	{"\U0001f33f", "herb", []string{"herb"}, "6.0", false},
	{"\U0001f33a", "hibiscus", []string{"hibiscus"}, "6.0", false},
	{"\U0001f506", "bright button", []string{"high_brightness"}, "6.0", false},
	{"\U0001f460", "high-heeled shoe", []string{"high_heel"}, "6.0", false},
	{"\U0001f97e", "hiking boot", []string{"hiking_boot"}, "11.0", false},
	{"\U0001f6d5", "hindu temple", []string{"hindu_temple"}, "12.0", false},
	{"\U0001f99b", "hippopotamus", []string{"hippopotamus"}, "11.0", false},
	{"\U0001f52a", "kitchen knife", []string{"hocho", "knife"}, "6.0", false},
	{"\U0001f573\ufe0f", "hole", []string{"hole"}, "7.0", false},
	{"\U0001f1ed\U0001f1f3", "flag: Honduras", []string{"honduras"}, "6.0", false},
	{"\U0001f36f", "honey pot", []string{"honey_pot"}, "6.0", false},
	{"\U0001f1ed\U0001f1f0", "flag: Hong Kong SAR China", []string{"hong_kong"}, "6.0", false},
	{"\U0001f434", "horse face", []string{"horse"}, "6.0", false},
	{"\U0001f3c7", "horse racing", []string{"horse_racing"}, "6.0", true},
	{"\U0001f3e5", "hospital", []string{"hospital"}, "6.0", false},
	{"\U0001f975", "hot face", []string{"hot_face"}, "11.0", false},
	{"\U0001f336\ufe0f", "hot pepper", []string{"hot_pepper"}, "7.0", false},
	{"\U0001f32d", "hot dog", []string{"hotdog"}, "8.0", false},
	{"\U0001f3e8", "hotel", []string{"hotel"}, "6.0", false},
	{"\u2668\ufe0f", "hot springs", []string{"hotsprings"}, "", false},
	{"\u231b", "hourglass done", []string{"hourglass"}, "", false},
	{"\u23f3", "hourglass not done", []string{"hourglass_flowing_sand"}, "6.0", false},
	{"\U0001f3e0", "house", []string{"house"}, "6.0", false},
	{"\U0001f3e1", "house with garden", []string{"house_with_garden"}, "6.0", false},
	{"\U0001f3d8\ufe0f", "houses", []string{"houses"}, "7.0", false},
	{"\U0001f917", "hugging face", []string{"hugs"}, "8.0", false},
	{"\U0001f1ed\U0001f1fa", "flag: Hungary", []string{"hungary"}, "6.0", false},
	{"\U0001f62f", "hushed face", []string{"hushed"}, "6.1", false},
	{"\U0001f368", "ice cream", []string{"ice_cream"}, "6.0", false},
	{"\U0001f9ca", "ice", []string{"ice_cube"}, "12.0", false},
	{"\U0001f3d2", "ice hockey", []string{"ice_hockey"}, "8.0", false},
	{"\u26f8\ufe0f", "ice skate", []string{"ice_skate"}, "5.2", false},
	{"\U0001f366", "soft ice cream", []string{"icecream"}, "6.0", false},
	{"\U0001f1ee\U0001f1f8", "flag: Iceland", []string{"iceland"}, "6.0", false},
	{"\U0001f194", "ID button", []string{"id"}, "6.0", false},
	{"\U0001f250", "Japanese “bargain” button", []string{"ideograph_advantage"}, "6.0", false},
	{"\U0001f47f", "angry face with horns", []string{"imp"}, "6.0", false},
	{"\U0001f4e5", "inbox tray", []string{"inbox_tray"}, "6.0", false},
	{"\U0001f4e8", "incoming envelope", []string{"incoming_envelope"}, "6.0", false},
	{"\U0001f1ee\U0001f1f3", "flag: India", []string{"india"}, "6.0", false},
	{"\U0001f1ee\U0001f1e9", "flag: Indonesia", []string{"indonesia"}, "6.0", false},
	{"\u267e\ufe0f", "infinity", []string{"infinity"}, "11.0", false},
	{"\u2139\ufe0f", "information", []string{"information_source"}, "3.0", false},
	{"\U0001f607", "smiling face with halo", []string{"innocent"}, "6.0", false},
	{"\u2049\ufe0f", "exclamation question mark", []string{"interrobang"}, "3.0", false},
	{"\U0001f4f1", "mobile phone", []string{"iphone"}, "6.0", false},
	{"\U0001f1ee\U0001f1f7", "flag: Iran", []string{"iran"}, "6.0", false},
	{"\U0001f1ee\U0001f1f6", "flag: Iraq", []string{"iraq"}, "6.0", false},
	{"\U0001f1ee\U0001f1ea", "flag: Ireland", []string{"ireland"}, "6.0", false},
	{"\U0001f1ee\U0001f1f2", "flag: Isle of Man", []string{"isle_of_man"}, "6.0", false},
	{"\U0001f1ee\U0001f1f1", "flag: Israel", []string{"israel"}, "6.0", false},
	{"\U0001f1ee\U0001f1f9", "flag: Italy", []string{"it"}, "6.0", false},
	{"\U0001f3ee", "red paper lantern", []string{"izakaya_lantern", "lantern"}, "6.0", false},
	{"\U0001f383", "jack-o-lantern", []string{"jack_o_lantern"}, "6.0", false},
	{"\U0001f1ef\U0001f1f2", "flag: Jamaica", []string{"jamaica"}, "6.0", false},
	{"\U0001f5fe", "map of Japan", []string{"japan"}, "6.0", false},
	{"\U0001f3ef", "Japanese castle", []string{"japanese_castle"}, "6.0", false},
	{"\U0001f47a", "goblin", []string{"japanese_goblin"}, "6.0", false},
	{"\U0001f479", "ogre", []string{"japanese_ogre"}, "6.0", false},
	{"\U0001f456", "jeans", []string{"jeans"}, "6.0", false},
	{"\U0001f1ef\U0001f1ea", "flag: Jersey", []string{"jersey"}, "6.0", false},
	{"\U0001f9e9", "puzzle piece", []string{"jigsaw"}, "11.0", false},
	{"\U0001f1ef\U0001f1f4", "flag: Jordan", []string{"jordan"}, "6.0", false},
	{"\U0001f602", "face with tears of joy", []string{"joy"}, "6.0", false},
	{"\U0001f639", "cat with tears of joy", []string{"joy_cat"}, "6.0", false},
	{"\U0001f579\ufe0f", "joystick", []string{"joystick"}, "7.0", false},
	{"\U0001f1ef\U0001f1f5", "flag: Japan", []string{"jp"}, "6.0", false},
	{"\U0001f9d1\u200d\u2696\ufe0f", "judge", []string{"judge"}, "12.1", true},
	{"\U0001f939", "person juggling", []string{"juggling_person"}, "11.0", true},
	{"\U0001f54b", "kaaba", []string{"kaaba"}, "8.0", false},
	{"\U0001f998", "kangaroo", []string{"kangaroo"}, "11.0", false},
	{"\U0001f1f0\U0001f1ff", "flag: Kazakhstan", []string{"kazakhstan"}, "6.0", false},
	{"\U0001f1f0\U0001f1ea", "flag: Kenya", []string{"kenya"}, "6.0", false},
	{"\U0001f511", "key", []string{"key"}, "6.0", false},
	{"\u2328\ufe0f", "keyboard", []string{"keyboard"}, "", false},
	{"\U0001f51f", "keycap: 10", []string{"keycap_ten"}, "6.0", false},
	{"\U0001f6f4", "kick scooter", []string{"kick_scooter"}, "9.0", false},
	{"\U0001f458", "kimono", []string{"kimono"}, "6.0", false},
	{"\U0001f1f0\U0001f1ee", "flag: Kiribati", []string{"kiribati"}, "6.0", false},
	{"\U0001f48b", "kiss mark", []string{"kiss"}, "6.0", false},
	{"\U0001f617", "kissing face", []string{"kissing"}, "6.1", false},
	{"\U0001f63d", "kissing cat", []string{"kissing_cat"}, "6.0", false},
	{"\U0001f61a", "kissing face with closed eyes", []string{"kissing_closed_eyes"}, "6.0", false},
	{"\U0001f618", "face blowing a kiss", []string{"kissing_heart"}, "6.0", false},
	{"\U0001f619", "kissing face with smiling eyes", []string{"kissing_smiling_eyes"}, "6.1", false},
	{"\U0001fa81", "kite", []string{"kite"}, "12.0", false},
	{"\U0001f95d", "kiwi fruit", []string{"kiwi_fruit"}, "9.0", false},
	{"\U0001f9ce\u200d\u2642\ufe0f", "man kneeling", []string{"kneeling_man"}, "12.0", true},
	{"\U0001f9ce", "person kneeling", []string{"kneeling_person"}, "12.0", true},
	{"\U0001f9ce\u200d\u2640\ufe0f", "woman kneeling", []string{"kneeling_woman"}, "12.0", true},
	{"\U0001f428", "koala", []string{"koala"}, "6.0", false},
	{"\U0001f201", "Japanese “here” button", []string{"koko"}, "6.0", false},
	{"\U0001f1fd\U0001f1f0", "flag: Kosovo", []string{"kosovo"}, "6.0", false},
	{"\U0001f1f0\U0001f1f7", "flag: South Korea", []string{"kr"}, "6.0", false},
	{"\U0001f1f0\U0001f1fc", "flag: Kuwait", []string{"kuwait"}, "6.0", false},
	{"\U0001f1f0\U0001f1ec", "flag: Kyrgyzstan", []string{"kyrgyzstan"}, "6.0", false},
	{"\U0001f97c", "lab coat", []string{"lab_coat"}, "11.0", false},
	{"\U0001f3f7\ufe0f", "label", []string{"label"}, "7.0", false},
	{"\U0001f94d", "lacrosse", []string{"lacrosse"}, "11.0", false},
	{"\U0001f41e", "lady beetle", []string{"lady_beetle"}, "6.0", false},
	{"\U0001f1f1\U0001f1e6", "flag: Laos", []string{"laos"}, "6.0", false},
	{"\U0001f535", "blue circle", []string{"large_blue_circle"}, "6.0", false},
	{"\U0001f537", "large blue diamond", []string{"large_blue_diamond"}, "6.0", false},
	{"\U0001f536", "large orange diamond", []string{"large_orange_diamond"}, "6.0", false},
	{"\U0001f317", "last quarter moon", []string{"last_quarter_moon"}, "6.0", false},
	{"\U0001f31c", "last quarter moon face", []string{"last_quarter_moon_with_face"}, "6.0", false},
	{"\u271d\ufe0f", "latin cross", []string{"latin_cross"}, "", false},
	{"\U0001f1f1\U0001f1fb", "flag: Latvia", []string{"latvia"}, "6.0", false},
	{"\U0001f606", "grinning squinting face", []string{"laughing", "satisfied", "laugh"}, "6.0", false},
	{"\U0001f96c", "leafy green", []string{"leafy_green"}, "11.0", false},
	{"\U0001f343", "leaf fluttering in wind", []string{"leaves"}, "6.0", false},
	{"\U0001f1f1\U0001f1e7", "flag: Lebanon", []string{"lebanon"}, "6.0", false},
	{"\U0001f4d2", "ledger", []string{"ledger"}, "6.0", false},
	{"\U0001f6c5", "left luggage", []string{"left_luggage"}, "6.0", false},
	{"\u2194\ufe0f", "left-right arrow", []string{"left_right_arrow"}, "", false},
	{"\U0001f5e8\ufe0f", "left speech bubble", []string{"left_speech_bubble"}, "11.0", false},
	{"\u21a9\ufe0f", "right arrow curving left", []string{"leftwards_arrow_with_hook"}, "", false},
	{"\U0001f9b5", "leg", []string{"leg"}, "11.0", true},
	{"\U0001f34b", "lemon", []string{"lemon"}, "6.0", false},
	{"\u264c", "Leo", []string{"leo"}, "", false},
	{"\U0001f406", "leopard", []string{"leopard"}, "6.0", false},
	{"\U0001f1f1\U0001f1f8", "flag: Lesotho", []string{"lesotho"}, "6.0", false},
	{"\U0001f39a\ufe0f", "level slider", []string{"level_slider"}, "7.0", false},
	{"\U0001f1f1\U0001f1f7", "flag: Liberia", []string{"liberia"}, "6.0", false},
	{"\u264e", "Libra", []string{"libra"}, "", false},
	{"\U0001f1f1\U0001f1fe", "flag: Libya", []string{"libya"}, "6.0", false},
	{"\U0001f1f1\U0001f1ee", "flag: Liechtenstein", []string{"liechtenstein"}, "6.0", false},
	{"\U0001f688", "light rail", []string{"light_rail"}, "6.0", false},
	{"\U0001f517", "link", []string{"link"}, "6.0", false},
	{"\U0001f981", "lion", []string{"lion"}, "8.0", false},
	{"\U0001f444", "mouth", []string{"lips"}, "6.0", false},
	{"\U0001f484", "lipstick", []string{"lipstick"}, "6.0", false},
	{"\U0001f1f1\U0001f1f9", "flag: Lithuania", []string{"lithuania"}, "6.0", false},
	{"\U0001f98e", "lizard", []string{"lizard"}, "9.0", false},
	{"\U0001f999", "llama", []string{"llama"}, "11.0", false},
	{"\U0001f99e", "lobster", []string{"lobster"}, "11.0", false},
	{"\U0001f512", "locked", []string{"lock"}, "6.0", false},
	{"\U0001f50f", "locked with pen", []string{"lock_with_ink_pen"}, "6.0", false},
	{"\U0001f36d", "lollipop", []string{"lollipop"}, "6.0", false},
	{"\u27bf", "double curly loop", []string{"loop"}, "6.0", false},
	{"\U0001f9f4", "lotion bottle", []string{"lotion_bottle"}, "11.0", false},
	{"\U0001f9d8", "person in lotus position", []string{"lotus_position"}, "11.0", true},
	{"\U0001f9d8\u200d\u2642\ufe0f", "man in lotus position", []string{"lotus_position_man"}, "11.0", true},
	{"\U0001f9d8\u200d\u2640\ufe0f", "woman in lotus position", []string{"lotus_position_woman"}, "11.0", true},
	{"\U0001f50a", "speaker high volume", []string{"loud_sound"}, "6.0", false},
	{"\U0001f4e2", "loudspeaker", []string{"loudspeaker"}, "6.0", false},
	{"\U0001f3e9", "love hotel", []string{"love_hotel"}, "6.0", false},
	{"\U0001f48c", "love letter", []string{"love_letter"}, "6.0", false},
	{"\U0001f91f", "love-you gesture", []string{"love_you_gesture"}, "11.0", true},
	{"\U0001f505", "dim button", []string{"low_brightness"}, "6.0", false},
	{"\U0001f9f3", "luggage", []string{"luggage"}, "11.0", false},
	{"\U0001f1f1\U0001f1fa", "flag: Luxembourg", []string{"luxembourg"}, "6.0", false},
	{"\U0001f925", "lying face", []string{"lying_face"}, "9.0", false},
	{"\u24c2\ufe0f", "circled M", []string{"m"}, "", false},
	{"\U0001f1f2\U0001f1f4", "flag: Macao SAR China", []string{"macau"}, "6.0", false},
	{"\U0001f1f2\U0001f1f0", "flag: North Macedonia", []string{"macedonia"}, "6.0", false},
	{"\U0001f1f2\U0001f1ec", "flag: Madagascar", []string{"madagascar"}, "6.0", false},
	{"\U0001f50d", "magnifying glass tilted left", []string{"mag"}, "6.0", false},
	{"\U0001f50e", "magnifying glass tilted right", []string{"mag_right"}, "6.0", false},
	{"\U0001f9d9", "mage", []string{"mage"}, "11.0", true},
	{"\U0001f9d9\u200d\u2642\ufe0f", "man mage", []string{"mage_man"}, "11.0", true},
	{"\U0001f9d9\u200d\u2640\ufe0f", "woman mage", []string{"mage_woman"}, "11.0", true},
	{"\U0001f9f2", "magnet", []string{"magnet"}, "11.0", false},
	{"\U0001f004", "mahjong red dragon", []string{"mahjong"}, "", false},
	{"\U0001f4eb", "closed mailbox with raised flag", []string{"mailbox"}, "6.0", false},
	{"\U0001f4ea", "closed mailbox with lowered flag", []string{"mailbox_closed"}, "6.0", false},
	{"\U0001f4ec", "open mailbox with raised flag", []string{"mailbox_with_mail"}, "6.0", false},
	{"\U0001f4ed", "open mailbox with lowered flag", []string{"mailbox_with_no_mail"}, "6.0", false},
	{"\U0001f1f2\U0001f1fc", "flag: Malawi", []string{"malawi"}, "6.0", false},
	{"\U0001f1f2\U0001f1fe", "flag: Malaysia", []string{"malaysia"}, "6.0", false},
	{"\U0001f1f2\U0001f1fb", "flag: Maldives", []string{"maldives"}, "6.0", false},
	{"\U0001f575\ufe0f\u200d\u2642\ufe0f", "man detective", []string{"male_detective"}, "11.0", true},
	{"\u2642\ufe0f", "male sign", []string{"male_sign"}, "11.0", false},
	{"\U0001f1f2\U0001f1f1", "flag: Mali", []string{"mali"}, "6.0", false},
	{"\U0001f1f2\U0001f1f9", "flag: Malta", []string{"malta"}, "6.0", false},
	{"\U0001f468", "man", []string{"man"}, "6.0", true},
	{"\U0001f468\u200d\U0001f3a8", "man artist", []string{"man_artist"}, "", true},
	{"\U0001f468\u200d\U0001f680", "man astronaut", []string{"man_astronaut"}, "", true},
	{"\U0001f938\u200d\u2642\ufe0f", "man cartwheeling", []string{"man_cartwheeling"}, "", true},
	{"\U0001f468\u200d\U0001f373", "man cook", []string{"man_cook"}, "", true},
	{"\U0001f57a", "man dancing", []string{"man_dancing"}, "9.0", true},
	{"\U0001f926\u200d\u2642\ufe0f", "man facepalming", []string{"man_facepalming"}, "9.0", true},
	{"\U0001f468\u200d\U0001f3ed", "man factory worker", []string{"man_factory_worker"}, "", true},
	{"\U0001f468\u200d\U0001f33e", "man farmer", []string{"man_farmer"}, "", true},
	{"\U0001f468\u200d\U0001f692", "man firefighter", []string{"man_firefighter"}, "", true},
	{"\U0001f468\u200d\u2695\ufe0f", "man health worker", []string{"man_health_worker"}, "", true},
	{"\U0001f468\u200d\U0001f9bd", "man in manual wheelchair", []string{"man_in_manual_wheelchair"}, "12.0", true},
	{"\U0001f468\u200d\U0001f9bc", "man in motorized wheelchair", []string{"man_in_motorized_wheelchair"}, "12.0", true},
	{"\U0001f468\u200d\u2696\ufe0f", "man judge", []string{"man_judge"}, "", true},
	{"\U0001f939\u200d\u2642\ufe0f", "man juggling", []string{"man_juggling"}, "9.0", true},
	{"\U0001f468\u200d\U0001f527", "man mechanic", []string{"man_mechanic"}, "", true},
	{"\U0001f468\u200d\U0001f4bc", "man office worker", []string{"man_office_worker"}, "", true},
	{"\U0001f468\u200d\u2708\ufe0f", "man pilot", []string{"man_pilot"}, "", true},
	{"\U0001f93e\u200d\u2642\ufe0f", "man playing handball", []string{"man_playing_handball"}, "9.0", true},
	{"\U0001f93d\u200d\u2642\ufe0f", "man playing water polo", []string{"man_playing_water_polo"}, "9.0", true},
	{"\U0001f468\u200d\U0001f52c", "man scientist", []string{"man_scientist"}, "", true},
	{"\U0001f937\u200d\u2642\ufe0f", "man shrugging", []string{"man_shrugging"}, "9.0", true},
	{"\U0001f468\u200d\U0001f3a4", "man singer", []string{"man_singer"}, "", true},
	{"\U0001f468\u200d\U0001f393", "man student", []string{"man_student"}, "", true},
	{"\U0001f468\u200d\U0001f3eb", "man teacher", []string{"man_teacher"}, "", true},
	{"\U0001f468\u200d\U0001f4bb", "man technologist", []string{"man_technologist"}, "", true},
	{"\U0001f472", "person with skullcap", []string{"man_with_gua_pi_mao"}, "6.0", true},
	{"\U0001f468\u200d\U0001f9af", "man with white cane", []string{"man_with_probing_cane"}, "12.0", true},
	{"\U0001f473\u200d\u2642\ufe0f", "man wearing turban", []string{"man_with_turban"}, "11.0", true},
	{"\U0001f96d", "mango", []string{"mango"}, "11.0", false},
	{"\U0001f45e", "man’s shoe", []string{"mans_shoe", "shoe"}, "6.0", false},
	{"\U0001f570\ufe0f", "mantelpiece clock", []string{"mantelpiece_clock"}, "7.0", false},
	{"\U0001f9bd", "manual wheelchair", []string{"manual_wheelchair"}, "12.0", false},
	{"\U0001f341", "maple leaf", []string{"maple_leaf"}, "6.0", false},
	{"\U0001f1f2\U0001f1ed", "flag: Marshall Islands", []string{"marshall_islands"}, "6.0", false},
	{"\U0001f94b", "martial arts uniform", []string{"martial_arts_uniform"}, "9.0", false},
	{"\U0001f1f2\U0001f1f6", "flag: Martinique", []string{"martinique"}, "6.0", false},
	{"\U0001f637", "face with medical mask", []string{"mask"}, "6.0", false},
	{"\U0001f486", "person getting massage", []string{"massage"}, "6.0", true},
	{"\U0001f486\u200d\u2642\ufe0f", "man getting massage", []string{"massage_man"}, "6.0", true},
	{"\U0001f486\u200d\u2640\ufe0f", "woman getting massage", []string{"massage_woman"}, "11.0", true},
	{"\U0001f9c9", "mate", []string{"mate"}, "12.0", false},
	{"\U0001f1f2\U0001f1f7", "flag: Mauritania", []string{"mauritania"}, "6.0", false},
	{"\U0001f1f2\U0001f1fa", "flag: Mauritius", []string{"mauritius"}, "6.0", false},
	{"\U0001f1fe\U0001f1f9", "flag: Mayotte", []string{"mayotte"}, "6.0", false},
	{"\U0001f356", "meat on bone", []string{"meat_on_bone"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f527", "mechanic", []string{"mechanic"}, "12.1", true},
	{"\U0001f9be", "mechanical arm", []string{"mechanical_arm"}, "12.0", false},
	{"\U0001f9bf", "mechanical leg", []string{"mechanical_leg"}, "12.0", false},
	{"\U0001f396\ufe0f", "military medal", []string{"medal_military"}, "7.0", false},
	{"\U0001f3c5", "sports medal", []string{"medal_sports"}, "7.0", false},
	{"\u2695\ufe0f", "medical symbol", []string{"medical_symbol"}, "11.0", false},
	{"\U0001f4e3", "megaphone", []string{"mega"}, "6.0", false},
	{"\U0001f348", "melon", []string{"melon"}, "6.0", false},
	{"\U0001f4dd", "memo", []string{"memo", "pencil"}, "6.0", false},
	{"\U0001f93c\u200d\u2642\ufe0f", "men wrestling", []string{"men_wrestling"}, "9.0", false},
	{"\U0001f54e", "menorah", []string{"menorah"}, "8.0", false},
	{"\U0001f6b9", "men’s room", []string{"mens"}, "6.0", false},
	{"\U0001f9dc\u200d\u2640\ufe0f", "mermaid", []string{"mermaid"}, "11.0", true},
	{"\U0001f9dc\u200d\u2642\ufe0f", "merman", []string{"merman"}, "11.0", true},
	{"\U0001f9dc", "merperson", []string{"merperson"}, "11.0", true},
	{"\U0001f918", "sign of the horns", []string{"metal"}, "8.0", true},
	{"\U0001f687", "metro", []string{"metro"}, "6.0", false},
	{"\U0001f1f2\U0001f1fd", "flag: Mexico", []string{"mexico"}, "6.0", false},
	{"\U0001f9a0", "microbe", []string{"microbe"}, "11.0", false},
	{"\U0001f1eb\U0001f1f2", "flag: Micronesia", []string{"micronesia"}, "6.0", false},
	{"\U0001f3a4", "microphone", []string{"microphone"}, "6.0", false},
	{"\U0001f52c", "microscope", []string{"microscope"}, "6.0", false},
	{"\U0001f595", "middle finger", []string{"middle_finger", "fu"}, "7.0", true},
	{"\U0001f95b", "glass of milk", []string{"milk_glass"}, "9.0", false},
	{"\U0001f30c", "milky way", []string{"milky_way"}, "6.0", false},
	{"\U0001f690", "minibus", []string{"minibus"}, "6.0", false},
	{"\U0001f4bd", "computer disk", []string{"minidisc"}, "6.0", false},
	{"\U0001f4f4", "mobile phone off", []string{"mobile_phone_off"}, "6.0", false},
	{"\U0001f1f2\U0001f1e9", "flag: Moldova", []string{"moldova"}, "6.0", false},
	{"\U0001f1f2\U0001f1e8", "flag: Monaco", []string{"monaco"}, "6.0", false},
	{"\U0001f911", "money-mouth face", []string{"money_mouth_face"}, "8.0", false},
	{"\U0001f4b8", "money with wings", []string{"money_with_wings"}, "6.0", false},
	{"\U0001f4b0", "money bag", []string{"moneybag"}, "6.0", false},
	{"\U0001f1f2\U0001f1f3", "flag: Mongolia", []string{"mongolia"}, "6.0", false},
	{"\U0001f412", "monkey", []string{"monkey"}, "6.0", false},
	{"\U0001f435", "monkey face", []string{"monkey_face"}, "6.0", false},
	{"\U0001f9d0", "face with monocle", []string{"monocle_face"}, "11.0", false},
	{"\U0001f69d", "monorail", []string{"monorail"}, "6.0", false},
	{"\U0001f1f2\U0001f1ea", "flag: Montenegro", []string{"montenegro"}, "6.0", false},
	{"\U0001f1f2\U0001f1f8", "flag: Montserrat", []string{"montserrat"}, "6.0", false},
	{"\U0001f314", "waxing gibbous moon", []string{"moon", "waxing_gibbous_moon"}, "6.0", false},
	{"\U0001f96e", "moon cake", []string{"moon_cake"}, "11.0", false},
	{"\U0001f1f2\U0001f1e6", "flag: Morocco", []string{"morocco"}, "6.0", false},
	{"\U0001f393", "graduation cap", []string{"mortar_board"}, "6.0", false},
	{"\U0001f54c", "mosque", []string{"mosque"}, "8.0", false},
	{"\U0001f99f", "mosquito", []string{"mosquito"}, "11.0", false},
	{"\U0001f6e5\ufe0f", "motor boat", []string{"motor_boat"}, "7.0", false},
	{"\U0001f6f5", "motor scooter", []string{"motor_scooter"}, "9.0", false},
	{"\U0001f3cd\ufe0f", "motorcycle", []string{"motorcycle"}, "7.0", false},
	{"\U0001f9bc", "motorized wheelchair", []string{"motorized_wheelchair"}, "12.0", false},
	{"\U0001f6e3\ufe0f", "motorway", []string{"motorway"}, "7.0", false},
	{"\U0001f5fb", "mount fuji", []string{"mount_fuji"}, "6.0", false},
	{"\u26f0\ufe0f", "mountain", []string{"mountain"}, "5.2", false},
	{"\U0001f6b5", "person mountain biking", []string{"mountain_bicyclist"}, "6.0", true},
	{"\U0001f6b5\u200d\u2642\ufe0f", "man mountain biking", []string{"mountain_biking_man"}, "11.0", true},
	{"\U0001f6b5\u200d\u2640\ufe0f", "woman mountain biking", []string{"mountain_biking_woman"}, "6.0", true},
	{"\U0001f6a0", "mountain cableway", []string{"mountain_cableway"}, "6.0", false},
	{"\U0001f69e", "mountain railway", []string{"mountain_railway"}, "6.0", false},
	{"\U0001f3d4\ufe0f", "snow-capped mountain", []string{"mountain_snow"}, "7.0", false},
	{"\U0001f42d", "mouse face", []string{"mouse"}, "6.0", false},
	{"\U0001f401", "mouse", []string{"mouse2"}, "6.0", false},
	{"\U0001f3a5", "movie camera", []string{"movie_camera"}, "6.0", false},
	{"\U0001f5ff", "moai", []string{"moyai"}, "6.0", false},
	{"\U0001f1f2\U0001f1ff", "flag: Mozambique", []string{"mozambique"}, "6.0", false},
	{"\U0001f936", "Mrs. Claus", []string{"mrs_claus"}, "9.0", true},
	{"\U0001f4aa", "flexed biceps", []string{"muscle"}, "6.0", true},
	{"\U0001f344", "mushroom", []string{"mushroom"}, "6.0", false},
	{"\U0001f3b9", "musical keyboard", []string{"musical_keyboard"}, "6.0", false},
	{"\U0001f3b5", "musical note", []string{"musical_note"}, "6.0", false},
	{"\U0001f3bc", "musical score", []string{"musical_score"}, "6.0", false},
	{"\U0001f507", "muted speaker", []string{"mute"}, "6.0", false},
	{"\U0001f1f2\U0001f1f2", "flag: Myanmar (Burma)", []string{"myanmar"}, "6.0", false},
	{"\U0001f485", "nail polish", []string{"nail_care"}, "6.0", true},
	{"\U0001f4db", "name badge", []string{"name_badge"}, "6.0", false},
	{"\U0001f1f3\U0001f1e6", "flag: Namibia", []string{"namibia"}, "6.0", false},
	{"\U0001f3de\ufe0f", "national park", []string{"national_park"}, "7.0", false},
	{"\U0001f1f3\U0001f1f7", "flag: Nauru", []string{"nauru"}, "6.0", false},
	{"\U0001f922", "nauseated face", []string{"nauseated_face"}, "9.0", false},
	{"\U0001f9ff", "nazar amulet", []string{"nazar_amulet"}, "11.0", false},
	{"\U0001f454", "necktie", []string{"necktie"}, "6.0", false},
	{"\u274e", "cross mark button", []string{"negative_squared_cross_mark"}, "6.0", false},
	{"\U0001f1f3\U0001f1f5", "flag: Nepal", []string{"nepal"}, "6.0", false},
	{"\U0001f913", "nerd face", []string{"nerd_face"}, "8.0", false},
	{"\U0001f1f3\U0001f1f1", "flag: Netherlands", []string{"netherlands"}, "6.0", false},
	{"\U0001f610", "neutral face", []string{"neutral_face"}, "6.0", false},
	{"\U0001f195", "NEW button", []string{"new"}, "6.0", false},
	{"\U0001f1f3\U0001f1e8", "flag: New Caledonia", []string{"new_caledonia"}, "6.0", false},
	{"\U0001f311", "new moon", []string{"new_moon"}, "6.0", false},
	{"\U0001f31a", "new moon face", []string{"new_moon_with_face"}, "6.0", false},
	{"\U0001f1f3\U0001f1ff", "flag: New Zealand", []string{"new_zealand"}, "6.0", false},
	{"\U0001f4f0", "newspaper", []string{"newspaper"}, "6.0", false},
	{"\U0001f5de\ufe0f", "rolled-up newspaper", []string{"newspaper_roll"}, "7.0", false},
	{"\u23ed\ufe0f", "next track button", []string{"next_track_button"}, "6.0", false},
	{"\U0001f196", "NG button", []string{"ng"}, "6.0", false},
	{"\U0001f1f3\U0001f1ee", "flag: Nicaragua", []string{"nicaragua"}, "6.0", false},
	{"\U0001f1f3\U0001f1ea", "flag: Niger", []string{"niger"}, "6.0", false},
	{"\U0001f1f3\U0001f1ec", "flag: Nigeria", []string{"nigeria"}, "6.0", false},
	{"\U0001f303", "night with stars", []string{"night_with_stars"}, "6.0", false},
	{"9\ufe0f\u20e3", "keycap: 9", []string{"nine"}, "", false},
	{"\U0001f1f3\U0001f1fa", "flag: Niue", []string{"niue"}, "6.0", false},
	{"\U0001f515", "bell with slash", []string{"no_bell"}, "6.0", false},
	{"\U0001f6b3", "no bicycles", []string{"no_bicycles"}, "6.0", false},
	{"\u26d4", "no entry", []string{"no_entry"}, "5.2", false},
	{"\U0001f6ab", "prohibited", []string{"no_entry_sign"}, "6.0", false},
	{"\U0001f645", "person gesturing NO", []string{"no_good"}, "6.0", true},
	{"\U0001f645\u200d\u2642\ufe0f", "man gesturing NO", []string{"no_good_man", "ng_man"}, "6.0", true},
	{"\U0001f645\u200d\u2640\ufe0f", "woman gesturing NO", []string{"no_good_woman", "ng_woman"}, "11.0", true},
	{"\U0001f4f5", "no mobile phones", []string{"no_mobile_phones"}, "6.0", false},
	{"\U0001f636", "face without mouth", []string{"no_mouth"}, "6.0", false},
	{"\U0001f6b7", "no pedestrians", []string{"no_pedestrians"}, "6.0", false},
	{"\U0001f6ad", "no smoking", []string{"no_smoking"}, "6.0", false},
	{"\U0001f6b1", "non-potable water", []string{"non-potable_water"}, "6.0", false},
	{"\U0001f1f3\U0001f1eb", "flag: Norfolk Island", []string{"norfolk_island"}, "6.0", false},
	{"\U0001f1f0\U0001f1f5", "flag: North Korea", []string{"north_korea"}, "6.0", false},
	{"\U0001f1f2\U0001f1f5", "flag: Northern Mariana Islands", []string{"northern_mariana_islands"}, "6.0", false},
	{"\U0001f1f3\U0001f1f4", "flag: Norway", []string{"norway"}, "6.0", false},
	{"\U0001f443", "nose", []string{"nose"}, "6.0", true},
	{"\U0001f4d3", "notebook", []string{"notebook"}, "6.0", false},
	{"\U0001f4d4", "notebook with decorative cover", []string{"notebook_with_decorative_cover"}, "6.0", false},
	{"\U0001f3b6", "musical notes", []string{"notes"}, "6.0", false},
	{"\U0001f529", "nut and bolt", []string{"nut_and_bolt"}, "6.0", false},
	{"\u2b55", "hollow red circle", []string{"o"}, "5.2", false},
	{"\U0001f17e\ufe0f", "O button (blood type)", []string{"o2"}, "6.0", false},
	{"\U0001f30a", "water wave", []string{"ocean"}, "6.0", false},
	{"\U0001f419", "octopus", []string{"octopus"}, "6.0", false},
	{"\U0001f362", "oden", []string{"oden"}, "6.0", false},
	{"\U0001f3e2", "office building", []string{"office"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f4bc", "office worker", []string{"office_worker"}, "12.1", true},
	{"\U0001f6e2\ufe0f", "oil drum", []string{"oil_drum"}, "7.0", false},
	{"\U0001f197", "OK button", []string{"ok"}, "6.0", false},
	{"\U0001f44c", "OK hand", []string{"ok_hand"}, "6.0", true},
	{"\U0001f646\u200d\u2642\ufe0f", "man gesturing OK", []string{"ok_man"}, "6.0", true},
	{"\U0001f646", "person gesturing OK", []string{"ok_person"}, "6.0", true},
	{"\U0001f646\u200d\u2640\ufe0f", "woman gesturing OK", []string{"ok_woman"}, "11.0", true},
	{"\U0001f5dd\ufe0f", "old key", []string{"old_key"}, "7.0", false},
	{"\U0001f9d3", "older person", []string{"older_adult"}, "11.0", true},
	{"\U0001f474", "old man", []string{"older_man"}, "6.0", true},
	{"\U0001f475", "old woman", []string{"older_woman"}, "6.0", true},
	{"\U0001f549\ufe0f", "om", []string{"om"}, "7.0", false},
	{"\U0001f1f4\U0001f1f2", "flag: Oman", []string{"oman"}, "6.0", false},
	{"\U0001f51b", "ON! arrow", []string{"on"}, "6.0", false},
	{"\U0001f698", "oncoming automobile", []string{"oncoming_automobile"}, "6.0", false},
	{"\U0001f68d", "oncoming bus", []string{"oncoming_bus"}, "6.0", false},
	{"\U0001f694", "oncoming police car", []string{"oncoming_police_car"}, "6.0", false},
	{"\U0001f696", "oncoming taxi", []string{"oncoming_taxi"}, "6.0", false},
	{"1\ufe0f\u20e3", "keycap: 1", []string{"one"}, "", false},
	{"\U0001fa71", "one-piece swimsuit", []string{"one_piece_swimsuit"}, "12.0", false},
	{"\U0001f9c5", "onion", []string{"onion"}, "12.0", false},
	{"\U0001f4c2", "open file folder", []string{"open_file_folder"}, "6.0", false},
	{"\U0001f450", "open hands", []string{"open_hands"}, "6.0", true},
	{"\U0001f62e", "face with open mouth", []string{"open_mouth"}, "6.1", false},
	{"\u2602\ufe0f", "umbrella", []string{"open_umbrella"}, "", false},
	{"\u26ce", "Ophiuchus", []string{"ophiuchus"}, "6.0", false},
	{"\U0001f4d9", "orange book", []string{"orange_book"}, "6.0", false},
	{"\U0001f7e0", "orange circle", []string{"orange_circle"}, "12.0", false},
	{"\U0001f9e1", "orange heart", []string{"orange_heart"}, "11.0", false},
	{"\U0001f7e7", "orange square", []string{"orange_square"}, "12.0", false},
	{"\U0001f9a7", "orangutan", []string{"orangutan"}, "12.0", false},
	{"\u2626\ufe0f", "orthodox cross", []string{"orthodox_cross"}, "", false},
	{"\U0001f9a6", "otter", []string{"otter"}, "12.0", false},
	{"\U0001f4e4", "outbox tray", []string{"outbox_tray"}, "6.0", false},
	{"\U0001f989", "owl", []string{"owl"}, "9.0", false},
	{"\U0001f402", "ox", []string{"ox"}, "6.0", false},
	{"\U0001f9aa", "oyster", []string{"oyster"}, "12.0", false},
	{"\U0001f4e6", "package", []string{"package"}, "6.0", false},
	{"\U0001f4c4", "page facing up", []string{"page_facing_up"}, "6.0", false},
	{"\U0001f4c3", "page with curl", []string{"page_with_curl"}, "6.0", false},
	{"\U0001f4df", "pager", []string{"pager"}, "6.0", false},
	{"\U0001f58c\ufe0f", "paintbrush", []string{"paintbrush"}, "7.0", false},
	{"\U0001f1f5\U0001f1f0", "flag: Pakistan", []string{"pakistan"}, "6.0", false},
	{"\U0001f1f5\U0001f1fc", "flag: Palau", []string{"palau"}, "6.0", false},
	{"\U0001f1f5\U0001f1f8", "flag: Palestinian Territories", []string{"palestinian_territories"}, "6.0", false},
	{"\U0001f334", "palm tree", []string{"palm_tree"}, "6.0", false},
	{"\U0001f932", "palms up together", []string{"palms_up_together"}, "11.0", true},
	{"\U0001f1f5\U0001f1e6", "flag: Panama", []string{"panama"}, "6.0", false},
	{"\U0001f95e", "pancakes", []string{"pancakes"}, "9.0", false},
	{"\U0001f43c", "panda", []string{"panda_face"}, "6.0", false},
	{"\U0001f4ce", "paperclip", []string{"paperclip"}, "6.0", false},
	{"\U0001f587\ufe0f", "linked paperclips", []string{"paperclips"}, "7.0", false},
	{"\U0001f1f5\U0001f1ec", "flag: Papua New Guinea", []string{"papua_new_guinea"}, "6.0", false},
	{"\U0001fa82", "parachute", []string{"parachute"}, "12.0", false},
	{"\U0001f1f5\U0001f1fe", "flag: Paraguay", []string{"paraguay"}, "6.0", false},
	{"\u26f1\ufe0f", "umbrella on ground", []string{"parasol_on_ground"}, "5.2", false},
	{"\U0001f17f\ufe0f", "P button", []string{"parking"}, "5.2", false},
	{"\U0001f99c", "parrot", []string{"parrot"}, "11.0", false},
	{"\u303d\ufe0f", "part alternation mark", []string{"part_alternation_mark"}, "3.2", false},
	{"\u26c5", "sun behind cloud", []string{"partly_sunny"}, "5.2", false},
	{"\U0001f973", "partying face", []string{"partying_face"}, "11.0", false},
	{"\U0001f6f3\ufe0f", "passenger ship", []string{"passenger_ship"}, "7.0", false},
	{"\U0001f6c2", "passport control", []string{"passport_control"}, "6.0", false},
	{"\u23f8\ufe0f", "pause button", []string{"pause_button"}, "7.0", false},
	{"\u262e\ufe0f", "peace symbol", []string{"peace_symbol"}, "", false},
	{"\U0001f351", "peach", []string{"peach"}, "6.0", false},
	{"\U0001f99a", "peacock", []string{"peacock"}, "11.0", false},
	{"\U0001f95c", "peanuts", []string{"peanuts"}, "9.0", false},
	{"\U0001f350", "pear", []string{"pear"}, "6.0", false},
	{"\U0001f58a\ufe0f", "pen", []string{"pen"}, "7.0", false},
	{"\u270f\ufe0f", "pencil", []string{"pencil2"}, "", false},
	{"\U0001f427", "penguin", []string{"penguin"}, "6.0", false},
	{"\U0001f614", "pensive face", []string{"pensive"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f91d\u200d\U0001f9d1", "people holding hands", []string{"people_holding_hands"}, "12.0", true},
	{"\U0001f3ad", "performing arts", []string{"performing_arts"}, "6.0", false},
	{"\U0001f623", "persevering face", []string{"persevere"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f9b2", "person: bald", []string{"person_bald"}, "12.1", true},
	{"\U0001f9d1\u200d\U0001f9b1", "person: curly hair", []string{"person_curly_hair"}, "12.1", true},
	{"\U0001f93a", "person fencing", []string{"person_fencing"}, "9.0", false},
	{"\U0001f9d1\u200d\U0001f9bd", "person in manual wheelchair", []string{"person_in_manual_wheelchair"}, "12.1", true},
	{"\U0001f9d1\u200d\U0001f9bc", "person in motorized wheelchair", []string{"person_in_motorized_wheelchair"}, "12.1", true},
	{"\U0001f935", "person in tuxedo", []string{"person_in_tuxedo"}, "9.0", true},
	{"\U0001f9d1\u200d\U0001f9b0", "person: red hair", []string{"person_red_hair"}, "12.1", true},
	{"\U0001f9d1\u200d\U0001f9b3", "person: white hair", []string{"person_white_hair"}, "12.1", true},
	{"\U0001f9d1\u200d\U0001f9af", "person with white cane", []string{"person_with_probing_cane"}, "12.1", true},
	{"\U0001f473", "person wearing turban", []string{"person_with_turban"}, "6.0", true},
	{"\U0001f470", "person with veil", []string{"person_with_veil"}, "6.0", true},
	{"\U0001f1f5\U0001f1ea", "flag: Peru", []string{"peru"}, "6.0", false},
	{"\U0001f9eb", "petri dish", []string{"petri_dish"}, "11.0", false},
	{"\U0001f1f5\U0001f1ed", "flag: Philippines", []string{"philippines"}, "6.0", false},
	{"\u260e\ufe0f", "telephone", []string{"phone", "telephone"}, "", false},
	{"\u26cf\ufe0f", "pick", []string{"pick"}, "5.2", false},
	{"\U0001f967", "pie", []string{"pie"}, "11.0", false},
	{"\U0001f437", "pig face", []string{"pig"}, "6.0", false},
	{"\U0001f416", "pig", []string{"pig2"}, "6.0", false},
	{"\U0001f43d", "pig nose", []string{"pig_nose"}, "6.0", false},
	{"\U0001f48a", "pill", []string{"pill"}, "6.0", false},
	{"\U0001f9d1\u200d\u2708\ufe0f", "pilot", []string{"pilot"}, "12.1", true},
	{"\U0001f90f", "pinching hand", []string{"pinching_hand"}, "12.0", true},
	{"\U0001f34d", "pineapple", []string{"pineapple"}, "6.0", false},
	{"\U0001f3d3", "ping pong", []string{"ping_pong"}, "8.0", false},
	{"\U0001f3f4\u200d\u2620\ufe0f", "pirate flag", []string{"pirate_flag"}, "11.0", false},
	{"\u2653", "Pisces", []string{"pisces"}, "", false},
	{"\U0001f1f5\U0001f1f3", "flag: Pitcairn Islands", []string{"pitcairn_islands"}, "6.0", false},
	{"\U0001f355", "pizza", []string{"pizza"}, "6.0", false},
	{"\U0001f6d0", "place of worship", []string{"place_of_worship"}, "8.0", false},
	{"\U0001f37d\ufe0f", "fork and knife with plate", []string{"plate_with_cutlery"}, "7.0", false},
	{"\u23ef\ufe0f", "play or pause button", []string{"play_or_pause_button"}, "6.0", false},
	{"\U0001f97a", "pleading face", []string{"pleading_face"}, "11.0", false},
	{"\U0001f447", "backhand index pointing down", []string{"point_down"}, "6.0", true},
	{"\U0001f448", "backhand index pointing left", []string{"point_left"}, "6.0", true},
	{"\U0001f449", "backhand index pointing right", []string{"point_right"}, "6.0", true},
	{"\u261d\ufe0f", "index pointing up", []string{"point_up"}, "", true},
	{"\U0001f446", "backhand index pointing up", []string{"point_up_2"}, "6.0", true},
	{"\U0001f1f5\U0001f1f1", "flag: Poland", []string{"poland"}, "6.0", false},
	{"\U0001f693", "police car", []string{"police_car"}, "6.0", false},
	{"\U0001f46e", "police officer", []string{"police_officer", "cop"}, "6.0", true},
	{"\U0001f46e\u200d\u2642\ufe0f", "man police officer", []string{"policeman"}, "11.0", true},
	{"\U0001f46e\u200d\u2640\ufe0f", "woman police officer", []string{"policewoman"}, "6.0", true},
	{"\U0001f429", "poodle", []string{"poodle"}, "6.0", false},
	{"\U0001f37f", "popcorn", []string{"popcorn"}, "8.0", false},
	{"\U0001f1f5\U0001f1f9", "flag: Portugal", []string{"portugal"}, "6.0", false},
	{"\U0001f3e3", "Japanese post office", []string{"post_office"}, "6.0", false},
	{"\U0001f4ef", "postal horn", []string{"postal_horn"}, "6.0", false},
	{"\U0001f4ee", "postbox", []string{"postbox"}, "6.0", false},
	{"\U0001f6b0", "potable water", []string{"potable_water"}, "6.0", false},
	{"\U0001f954", "potato", []string{"potato"}, "9.0", false},
	{"\U0001f45d", "clutch bag", []string{"pouch"}, "6.0", false},
	{"\U0001f357", "poultry leg", []string{"poultry_leg"}, "6.0", false},
	{"\U0001f4b7", "pound banknote", []string{"pound"}, "6.0", false},
	{"\U0001f63e", "pouting cat", []string{"pouting_cat"}, "6.0", false},
	{"\U0001f64e", "person pouting", []string{"pouting_face"}, "6.0", true},
	{"\U0001f64e\u200d\u2642\ufe0f", "man pouting", []string{"pouting_man"}, "6.0", true},
	{"\U0001f64e\u200d\u2640\ufe0f", "woman pouting", []string{"pouting_woman"}, "11.0", true},
	{"\U0001f64f", "folded hands", []string{"pray"}, "6.0", true},
	{"\U0001f4ff", "prayer beads", []string{"prayer_beads"}, "8.0", false},
	{"\U0001f930", "pregnant woman", []string{"pregnant_woman"}, "9.0", true},
	{"\U0001f968", "pretzel", []string{"pretzel"}, "11.0", false},
	{"\u23ee\ufe0f", "last track button", []string{"previous_track_button"}, "6.0", false},
	{"\U0001f934", "prince", []string{"prince"}, "9.0", true},
	{"\U0001f478", "princess", []string{"princess"}, "6.0", true},
	{"\U0001f5a8\ufe0f", "printer", []string{"printer"}, "7.0", false},
	{"\U0001f9af", "white cane", []string{"probing_cane"}, "12.0", false},
	{"\U0001f1f5\U0001f1f7", "flag: Puerto Rico", []string{"puerto_rico"}, "6.0", false},
	{"\U0001f7e3", "purple circle", []string{"purple_circle"}, "12.0", false},
	{"\U0001f49c", "purple heart", []string{"purple_heart"}, "6.0", false},
	{"\U0001f7ea", "purple square", []string{"purple_square"}, "12.0", false},
	{"\U0001f45b", "purse", []string{"purse"}, "6.0", false},
	{"\U0001f4cc", "pushpin", []string{"pushpin"}, "6.0", false},
	{"\U0001f6ae", "litter in bin sign", []string{"put_litter_in_its_place"}, "6.0", false},
	{"\U0001f1f6\U0001f1e6", "flag: Qatar", []string{"qatar"}, "6.0", false},
	{"\u2753", "question mark", []string{"question"}, "6.0", false},
	{"\U0001f430", "rabbit face", []string{"rabbit"}, "6.0", false},
	{"\U0001f407", "rabbit", []string{"rabbit2"}, "6.0", false},
	{"\U0001f99d", "raccoon", []string{"raccoon"}, "11.0", false},
	{"\U0001f40e", "horse", []string{"racehorse"}, "6.0", false},
	{"\U0001f3ce\ufe0f", "racing car", []string{"racing_car"}, "7.0", false},
	{"\U0001f4fb", "radio", []string{"radio"}, "6.0", false},
	{"\U0001f518", "radio button", []string{"radio_button"}, "6.0", false},
	{"\u2622\ufe0f", "radioactive", []string{"radioactive"}, "", false},
	{"\U0001f621", "pouting face", []string{"rage", "pout"}, "6.0", false},
	{"\U0001f683", "railway car", []string{"railway_car"}, "6.0", false},
	{"\U0001f6e4\ufe0f", "railway track", []string{"railway_track"}, "7.0", false},
	{"\U0001f308", "rainbow", []string{"rainbow"}, "6.0", false},
	{"\U0001f3f3\ufe0f\u200d\U0001f308", "rainbow flag", []string{"rainbow_flag"}, "6.0", false},
	{"\U0001f91a", "raised back of hand", []string{"raised_back_of_hand"}, "9.0", true},
	{"\U0001f928", "face with raised eyebrow", []string{"raised_eyebrow"}, "11.0", false},
	{"\U0001f590\ufe0f", "hand with fingers splayed", []string{"raised_hand_with_fingers_splayed"}, "7.0", true},
	{"\U0001f64c", "raising hands", []string{"raised_hands"}, "6.0", true},
	{"\U0001f64b", "person raising hand", []string{"raising_hand"}, "6.0", true},
	{"\U0001f64b\u200d\u2642\ufe0f", "man raising hand", []string{"raising_hand_man"}, "6.0", true},
	{"\U0001f64b\u200d\u2640\ufe0f", "woman raising hand", []string{"raising_hand_woman"}, "11.0", true},
	{"\U0001f40f", "ram", []string{"ram"}, "6.0", false},
	{"\U0001f35c", "steaming bowl", []string{"ramen"}, "6.0", false},
	{"\U0001f400", "rat", []string{"rat"}, "6.0", false},
	{"\U0001fa92", "razor", []string{"razor"}, "12.0", false},
	{"\U0001f9fe", "receipt", []string{"receipt"}, "11.0", false},
	{"\u23fa\ufe0f", "record button", []string{"record_button"}, "7.0", false},
	{"\u267b\ufe0f", "recycling symbol", []string{"recycle"}, "3.2", false},
	{"\U0001f534", "red circle", []string{"red_circle"}, "6.0", false},
	{"\U0001f9e7", "red envelope", []string{"red_envelope"}, "11.0", false},
	{"\U0001f468\u200d\U0001f9b0", "man: red hair", []string{"red_haired_man"}, "11.0", true},
	{"\U0001f469\u200d\U0001f9b0", "woman: red hair", []string{"red_haired_woman"}, "11.0", true},
	{"\U0001f7e5", "red square", []string{"red_square"}, "12.0", false},
	{"\u00ae\ufe0f", "registered", []string{"registered"}, "", false},
	{"\u263a\ufe0f", "smiling face", []string{"relaxed"}, "", false},
	{"\U0001f60c", "relieved face", []string{"relieved"}, "6.0", false},
	{"\U0001f397\ufe0f", "reminder ribbon", []string{"reminder_ribbon"}, "7.0", false},
	{"\U0001f501", "repeat button", []string{"repeat"}, "6.0", false},
	{"\U0001f502", "repeat single button", []string{"repeat_one"}, "6.0", false},
	{"\u26d1\ufe0f", "rescue worker’s helmet", []string{"rescue_worker_helmet"}, "5.2", false},
	{"\U0001f6bb", "restroom", []string{"restroom"}, "6.0", false},
	{"\U0001f1f7\U0001f1ea", "flag: Réunion", []string{"reunion"}, "6.0", false},
	{"\U0001f49e", "revolving hearts", []string{"revolving_hearts"}, "6.0", false},
	{"\u23ea", "fast reverse button", []string{"rewind"}, "6.0", false},
	{"\U0001f98f", "rhinoceros", []string{"rhinoceros"}, "9.0", false},
	{"\U0001f380", "ribbon", []string{"ribbon"}, "6.0", false},
	{"\U0001f35a", "cooked rice", []string{"rice"}, "6.0", false},
	{"\U0001f359", "rice ball", []string{"rice_ball"}, "6.0", false},
	{"\U0001f358", "rice cracker", []string{"rice_cracker"}, "6.0", false},
	{"\U0001f391", "moon viewing ceremony", []string{"rice_scene"}, "6.0", false},
	{"\U0001f5ef\ufe0f", "right anger bubble", []string{"right_anger_bubble"}, "7.0", false},
	{"\U0001f48d", "ring", []string{"ring"}, "6.0", false},
	{"\U0001fa90", "ringed planet", []string{"ringed_planet"}, "12.0", false},
	{"\U0001f916", "robot", []string{"robot"}, "8.0", false},
	{"\U0001f680", "rocket", []string{"rocket"}, "6.0", false},
	{"\U0001f923", "rolling on the floor laughing", []string{"rofl"}, "9.0", false},
	{"\U0001f644", "face with rolling eyes", []string{"roll_eyes"}, "8.0", false},
	{"\U0001f9fb", "roll of paper", []string{"roll_of_paper"}, "11.0", false},
	{"\U0001f3a2", "roller coaster", []string{"roller_coaster"}, "6.0", false},
	{"\U0001f1f7\U0001f1f4", "flag: Romania", []string{"romania"}, "6.0", false},
	{"\U0001f413", "rooster", []string{"rooster"}, "6.0", false},
	{"\U0001f339", "rose", []string{"rose"}, "6.0", false},
	{"\U0001f3f5\ufe0f", "rosette", []string{"rosette"}, "7.0", false},
	{"\U0001f6a8", "police car light", []string{"rotating_light"}, "6.0", false},
	{"\U0001f4cd", "round pushpin", []string{"round_pushpin"}, "6.0", false},
	{"\U0001f6a3", "person rowing boat", []string{"rowboat"}, "6.0", true},
	{"\U0001f6a3\u200d\u2642\ufe0f", "man rowing boat", []string{"rowing_man"}, "11.0", true},
	{"\U0001f6a3\u200d\u2640\ufe0f", "woman rowing boat", []string{"rowing_woman"}, "6.0", true},
	{"\U0001f1f7\U0001f1fa", "flag: Russia", []string{"ru"}, "6.0", false},
	{"\U0001f3c9", "rugby football", []string{"rugby_football"}, "6.0", false},
	{"\U0001f3c3", "person running", []string{"runner", "running"}, "6.0", true},
	{"\U0001f3c3\u200d\u2642\ufe0f", "man running", []string{"running_man"}, "11.0", true},
	{"\U0001f3bd", "running shirt", []string{"running_shirt_with_sash"}, "6.0", false},
	{"\U0001f3c3\u200d\u2640\ufe0f", "woman running", []string{"running_woman"}, "6.0", true},
	{"\U0001f1f7\U0001f1fc", "flag: Rwanda", []string{"rwanda"}, "6.0", false},
	{"\U0001f202\ufe0f", "Japanese “service charge” button", []string{"sa"}, "6.0", false},
	{"\U0001f9f7", "safety pin", []string{"safety_pin"}, "11.0", false},
	{"\U0001f9ba", "safety vest", []string{"safety_vest"}, "12.0", false},
	{"\u2650", "Sagittarius", []string{"sagittarius"}, "", false},
	{"\U0001f376", "sake", []string{"sake"}, "6.0", false},
	{"\U0001f9c2", "salt", []string{"salt"}, "11.0", false},
	{"\U0001f1fc\U0001f1f8", "flag: Samoa", []string{"samoa"}, "6.0", false},
	{"\U0001f1f8\U0001f1f2", "flag: San Marino", []string{"san_marino"}, "6.0", false},
	{"\U0001f461", "woman’s sandal", []string{"sandal"}, "6.0", false},
	{"\U0001f96a", "sandwich", []string{"sandwich"}, "11.0", false},
	{"\U0001f385", "Santa Claus", []string{"santa"}, "6.0", true},
	{"\U0001f1f8\U0001f1f9", "flag: São Tomé & Príncipe", []string{"sao_tome_principe"}, "6.0", false},
	{"\U0001f97b", "sari", []string{"sari"}, "12.0", false},
	{"\U0001f4e1", "satellite antenna", []string{"satellite"}, "6.0", false},
	{"\U0001f1f8\U0001f1e6", "flag: Saudi Arabia", []string{"saudi_arabia"}, "6.0", false},
	{"\U0001f9d6\u200d\u2642\ufe0f", "man in steamy room", []string{"sauna_man"}, "11.0", true},
	{"\U0001f9d6", "person in steamy room", []string{"sauna_person"}, "11.0", true},
	{"\U0001f9d6\u200d\u2640\ufe0f", "woman in steamy room", []string{"sauna_woman"}, "11.0", true},
	{"\U0001f995", "sauropod", []string{"sauropod"}, "11.0", false},
	{"\U0001f3b7", "saxophone", []string{"saxophone"}, "6.0", false},
	{"\U0001f9e3", "scarf", []string{"scarf"}, "11.0", false},
	{"\U0001f3eb", "school", []string{"school"}, "6.0", false},
	{"\U0001f392", "backpack", []string{"school_satchel"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f52c", "scientist", []string{"scientist"}, "12.1", true},
	{"\u2702\ufe0f", "scissors", []string{"scissors"}, "", false},
	{"\U0001f982", "scorpion", []string{"scorpion"}, "8.0", false},
	{"\u264f", "Scorpio", []string{"scorpius"}, "", false},
	{"\U0001f3f4\U000e0067\U000e0062\U000e0073\U000e0063\U000e0074\U000e007f", "flag: Scotland", []string{"scotland"}, "11.0", false},
	{"\U0001f631", "face screaming in fear", []string{"scream"}, "6.0", false},
	{"\U0001f640", "weary cat", []string{"scream_cat"}, "6.0", false},
	{"\U0001f4dc", "scroll", []string{"scroll"}, "6.0", false},
	{"\U0001f4ba", "seat", []string{"seat"}, "6.0", false},
	{"\u3299\ufe0f", "Japanese “secret” button", []string{"secret"}, "", false},
	{"\U0001f648", "see-no-evil monkey", []string{"see_no_evil"}, "6.0", false},
	{"\U0001f331", "seedling", []string{"seedling"}, "6.0", false},
	{"\U0001f933", "selfie", []string{"selfie"}, "9.0", true},
	{"\U0001f1f8\U0001f1f3", "flag: Senegal", []string{"senegal"}, "6.0", false},
	{"\U0001f1f7\U0001f1f8", "flag: Serbia", []string{"serbia"}, "6.0", false},
	{"\U0001f415\u200d\U0001f9ba", "service dog", []string{"service_dog"}, "12.0", false},
	{"7\ufe0f\u20e3", "keycap: 7", []string{"seven"}, "", false},
	{"\U0001f1f8\U0001f1e8", "flag: Seychelles", []string{"seychelles"}, "6.0", false},
	{"\U0001f958", "shallow pan of food", []string{"shallow_pan_of_food"}, "", false},
	{"\u2618\ufe0f", "shamrock", []string{"shamrock"}, "4.1", false},
	{"\U0001f988", "shark", []string{"shark"}, "9.0", false},
	{"\U0001f367", "shaved ice", []string{"shaved_ice"}, "6.0", false},
	{"\U0001f411", "ewe", []string{"sheep"}, "6.0", false},
	{"\U0001f41a", "spiral shell", []string{"shell"}, "6.0", false},
	{"\U0001f6e1\ufe0f", "shield", []string{"shield"}, "7.0", false},
	{"\u26e9\ufe0f", "shinto shrine", []string{"shinto_shrine"}, "5.2", false},
	{"\U0001f6a2", "ship", []string{"ship"}, "6.0", false},
	{"\U0001f455", "t-shirt", []string{"shirt", "tshirt"}, "6.0", false},
	{"\U0001f6cd\ufe0f", "shopping bags", []string{"shopping"}, "7.0", false},
	{"\U0001f6d2", "shopping cart", []string{"shopping_cart"}, "9.0", false},
	{"\U0001fa73", "shorts", []string{"shorts"}, "12.0", false},
	{"\U0001f6bf", "shower", []string{"shower"}, "6.0", false},
	{"\U0001f990", "shrimp", []string{"shrimp"}, "9.0", false},
	{"\U0001f937", "person shrugging", []string{"shrug"}, "11.0", true},
	{"\U0001f92b", "shushing face", []string{"shushing_face"}, "11.0", false},
	{"\U0001f1f8\U0001f1f1", "flag: Sierra Leone", []string{"sierra_leone"}, "6.0", false},
	{"\U0001f4f6", "antenna bars", []string{"signal_strength"}, "6.0", false},
	{"\U0001f1f8\U0001f1ec", "flag: Singapore", []string{"singapore"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f3a4", "singer", []string{"singer"}, "12.1", true},
	{"\U0001f1f8\U0001f1fd", "flag: Sint Maarten", []string{"sint_maarten"}, "6.0", false},
	{"6\ufe0f\u20e3", "keycap: 6", []string{"six"}, "", false},
	{"\U0001f52f", "dotted six-pointed star", []string{"six_pointed_star"}, "6.0", false},
	{"\U0001f6f9", "skateboard", []string{"skateboard"}, "11.0", false},
	{"\U0001f3bf", "skis", []string{"ski"}, "6.0", false},
	{"\u26f7\ufe0f", "skier", []string{"skier"}, "5.2", false},
	{"\U0001f480", "skull", []string{"skull"}, "6.0", false},
	{"\u2620\ufe0f", "skull and crossbones", []string{"skull_and_crossbones"}, "", false},
	{"\U0001f9a8", "skunk", []string{"skunk"}, "12.0", false},
	{"\U0001f6f7", "sled", []string{"sled"}, "11.0", false},
	{"\U0001f634", "sleeping face", []string{"sleeping"}, "6.1", false},
	{"\U0001f6cc", "person in bed", []string{"sleeping_bed"}, "7.0", true},
	{"\U0001f62a", "sleepy face", []string{"sleepy"}, "6.0", false},
	{"\U0001f641", "slightly frowning face", []string{"slightly_frowning_face"}, "7.0", false},
	{"\U0001f642", "slightly smiling face", []string{"slightly_smiling_face"}, "7.0", false},
	{"\U0001f3b0", "slot machine", []string{"slot_machine"}, "6.0", false},
	{"\U0001f9a5", "sloth", []string{"sloth"}, "12.0", false},
	{"\U0001f1f8\U0001f1f0", "flag: Slovakia", []string{"slovakia"}, "6.0", false},
	{"\U0001f1f8\U0001f1ee", "flag: Slovenia", []string{"slovenia"}, "6.0", false},
	{"\U0001f6e9\ufe0f", "small airplane", []string{"small_airplane"}, "7.0", false},
	{"\U0001f539", "small blue diamond", []string{"small_blue_diamond"}, "6.0", false},
	{"\U0001f538", "small orange diamond", []string{"small_orange_diamond"}, "6.0", false},
	{"\U0001f53a", "red triangle pointed up", []string{"small_red_triangle"}, "6.0", false},
	{"\U0001f53b", "red triangle pointed down", []string{"small_red_triangle_down"}, "6.0", false},
	{"\U0001f604", "grinning face with smiling eyes", []string{"smile"}, "6.0", false},
	{"\U0001f638", "grinning cat with smiling eyes", []string{"smile_cat"}, "6.0", false},
	{"\U0001f603", "grinning face with big eyes", []string{"smiley"}, "6.0", false},
	{"\U0001f63a", "grinning cat", []string{"smiley_cat"}, "6.0", false},
	{"\U0001f970", "smiling face with hearts", []string{"smiling_face_with_three_hearts"}, "11.0", false},
	{"\U0001f608", "smiling face with horns", []string{"smiling_imp"}, "6.0", false},
	{"\U0001f60f", "smirking face", []string{"smirk"}, "6.0", false},
	{"\U0001f63c", "cat with wry smile", []string{"smirk_cat"}, "6.0", false},
	{"\U0001f6ac", "cigarette", []string{"smoking"}, "6.0", false},
	{"\U0001f40c", "snail", []string{"snail"}, "6.0", false},
	{"\U0001f40d", "snake", []string{"snake"}, "6.0", false},
	{"\U0001f927", "sneezing face", []string{"sneezing_face"}, "9.0", false},
	{"\U0001f3c2", "snowboarder", []string{"snowboarder"}, "6.0", true},
	{"\u2744\ufe0f", "snowflake", []string{"snowflake"}, "", false},
	{"\u26c4", "snowman without snow", []string{"snowman"}, "5.2", false},
	{"\u2603\ufe0f", "snowman", []string{"snowman_with_snow"}, "", false},
	{"\U0001f9fc", "soap", []string{"soap"}, "11.0", false},
	{"\U0001f62d", "loudly crying face", []string{"sob"}, "6.0", false},
	{"\u26bd", "soccer ball", []string{"soccer"}, "5.2", false},
	{"\U0001f9e6", "socks", []string{"socks"}, "11.0", false},
	{"\U0001f94e", "softball", []string{"softball"}, "11.0", false},
	{"\U0001f1f8\U0001f1e7", "flag: Solomon Islands", []string{"solomon_islands"}, "6.0", false},
	{"\U0001f1f8\U0001f1f4", "flag: Somalia", []string{"somalia"}, "6.0", false},
	{"\U0001f51c", "SOON arrow", []string{"soon"}, "6.0", false},
	{"\U0001f198", "SOS button", []string{"sos"}, "6.0", false},
	{"\U0001f509", "speaker medium volume", []string{"sound"}, "6.0", false},
	{"\U0001f1ff\U0001f1e6", "flag: South Africa", []string{"south_africa"}, "6.0", false},
	{"\U0001f1ec\U0001f1f8", "flag: South Georgia & South Sandwich Islands", []string{"south_georgia_south_sandwich_islands"}, "6.0", false},
	{"\U0001f1f8\U0001f1f8", "flag: South Sudan", []string{"south_sudan"}, "6.0", false},
	{"\U0001f47e", "alien monster", []string{"space_invader"}, "6.0", false},
	{"\u2660\ufe0f", "spade suit", []string{"spades"}, "", false},
	{"\U0001f35d", "spaghetti", []string{"spaghetti"}, "6.0", false},
	{"\u2747\ufe0f", "sparkle", []string{"sparkle"}, "", false},
	{"\U0001f387", "sparkler", []string{"sparkler"}, "6.0", false},
	{"\u2728", "sparkles", []string{"sparkles"}, "6.0", false},
	{"\U0001f496", "sparkling heart", []string{"sparkling_heart"}, "6.0", false},
	{"\U0001f64a", "speak-no-evil monkey", []string{"speak_no_evil"}, "6.0", false},
	{"\U0001f508", "speaker low volume", []string{"speaker"}, "6.0", false},
	{"\U0001f5e3\ufe0f", "speaking head", []string{"speaking_head"}, "7.0", false},
	{"\U0001f4ac", "speech balloon", []string{"speech_balloon"}, "6.0", false},
	{"\U0001f6a4", "speedboat", []string{"speedboat"}, "6.0", false},
	{"\U0001f577\ufe0f", "spider", []string{"spider"}, "7.0", false},
	{"\U0001f578\ufe0f", "spider web", []string{"spider_web"}, "7.0", false},
	{"\U0001f5d3\ufe0f", "spiral calendar", []string{"spiral_calendar"}, "7.0", false},
	{"\U0001f5d2\ufe0f", "spiral notepad", []string{"spiral_notepad"}, "7.0", false},
	{"\U0001f9fd", "sponge", []string{"sponge"}, "11.0", false},
	{"\U0001f944", "spoon", []string{"spoon"}, "9.0", false},
	{"\U0001f991", "squid", []string{"squid"}, "9.0", false},
	{"\U0001f1f1\U0001f1f0", "flag: Sri Lanka", []string{"sri_lanka"}, "6.0", false},
	{"\U0001f1e7\U0001f1f1", "flag: St. Barthélemy", []string{"st_barthelemy"}, "6.0", false},
	{"\U0001f1f8\U0001f1ed", "flag: St. Helena", []string{"st_helena"}, "6.0", false},
	{"\U0001f1f0\U0001f1f3", "flag: St. Kitts & Nevis", []string{"st_kitts_nevis"}, "6.0", false},
	{"\U0001f1f1\U0001f1e8", "flag: St. Lucia", []string{"st_lucia"}, "6.0", false},
	{"\U0001f1f2\U0001f1eb", "flag: St. Martin", []string{"st_martin"}, "11.0", false},
	{"\U0001f1f5\U0001f1f2", "flag: St. Pierre & Miquelon", []string{"st_pierre_miquelon"}, "6.0", false},
	{"\U0001f1fb\U0001f1e8", "flag: St. Vincent & Grenadines", []string{"st_vincent_grenadines"}, "6.0", false},
	{"\U0001f3df\ufe0f", "stadium", []string{"stadium"}, "7.0", false},
	{"\U0001f9cd\u200d\u2642\ufe0f", "man standing", []string{"standing_man"}, "12.0", true},
	{"\U0001f9cd", "person standing", []string{"standing_person"}, "12.0", true},
	{"\U0001f9cd\u200d\u2640\ufe0f", "woman standing", []string{"standing_woman"}, "12.0", true},
	{"\u2b50", "star", []string{"star"}, "5.1", false},
	{"\U0001f31f", "glowing star", []string{"star2"}, "6.0", false},
	{"\u262a\ufe0f", "star and crescent", []string{"star_and_crescent"}, "", false},
	{"\u2721\ufe0f", "star of David", []string{"star_of_david"}, "", false},
	{"\U0001f929", "star-struck", []string{"star_struck"}, "11.0", false},
	{"\U0001f320", "shooting star", []string{"stars"}, "6.0", false},
	{"\U0001f689", "station", []string{"station"}, "6.0", false},
	{"\U0001f5fd", "Statue of Liberty", []string{"statue_of_liberty"}, "6.0", false},
	{"\U0001f682", "locomotive", []string{"steam_locomotive"}, "6.0", false},
	{"\U0001fa7a", "stethoscope", []string{"stethoscope"}, "12.0", false},
	{"\U0001f372", "pot of food", []string{"stew"}, "6.0", false},
	{"\u23f9\ufe0f", "stop button", []string{"stop_button"}, "7.0", false},
	{"\U0001f6d1", "stop sign", []string{"stop_sign"}, "9.0", false},
	{"\u23f1\ufe0f", "stopwatch", []string{"stopwatch"}, "6.0", false},
	{"\U0001f4cf", "straight ruler", []string{"straight_ruler"}, "6.0", false},
	{"\U0001f353", "strawberry", []string{"strawberry"}, "6.0", false},
	{"\U0001f61b", "face with tongue", []string{"stuck_out_tongue"}, "6.1", false},
	{"\U0001f61d", "squinting face with tongue", []string{"stuck_out_tongue_closed_eyes"}, "6.0", false},
	{"\U0001f61c", "winking face with tongue", []string{"stuck_out_tongue_winking_eye"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f393", "student", []string{"student"}, "12.1", true},
	{"\U0001f399\ufe0f", "studio microphone", []string{"studio_microphone"}, "7.0", false},
	{"\U0001f959", "stuffed flatbread", []string{"stuffed_flatbread"}, "9.0", false},
	{"\U0001f1f8\U0001f1e9", "flag: Sudan", []string{"sudan"}, "6.0", false},
	{"\U0001f325\ufe0f", "sun behind large cloud", []string{"sun_behind_large_cloud"}, "7.0", false},
	{"\U0001f326\ufe0f", "sun behind rain cloud", []string{"sun_behind_rain_cloud"}, "7.0", false},
	{"\U0001f324\ufe0f", "sun behind small cloud", []string{"sun_behind_small_cloud"}, "7.0", false},
	{"\U0001f31e", "sun with face", []string{"sun_with_face"}, "6.0", false},
	{"\U0001f33b", "sunflower", []string{"sunflower"}, "6.0", false},
	{"\U0001f60e", "smiling face with sunglasses", []string{"sunglasses"}, "6.0", false},
	{"\u2600\ufe0f", "sun", []string{"sunny"}, "", false},
	{"\U0001f305", "sunrise", []string{"sunrise"}, "6.0", false},
	{"\U0001f304", "sunrise over mountains", []string{"sunrise_over_mountains"}, "6.0", false},
	{"\U0001f9b8", "superhero", []string{"superhero"}, "11.0", true},
	{"\U0001f9b8\u200d\u2642\ufe0f", "man superhero", []string{"superhero_man"}, "11.0", true},
	{"\U0001f9b8\u200d\u2640\ufe0f", "woman superhero", []string{"superhero_woman"}, "11.0", true},
	{"\U0001f9b9", "supervillain", []string{"supervillain"}, "11.0", true},
	{"\U0001f9b9\u200d\u2642\ufe0f", "man supervillain", []string{"supervillain_man"}, "11.0", true},
	{"\U0001f9b9\u200d\u2640\ufe0f", "woman supervillain", []string{"supervillain_woman"}, "11.0", true},
	{"\U0001f3c4", "person surfing", []string{"surfer"}, "6.0", true},
	{"\U0001f3c4\u200d\u2642\ufe0f", "man surfing", []string{"surfing_man"}, "11.0", true},
	{"\U0001f3c4\u200d\u2640\ufe0f", "woman surfing", []string{"surfing_woman"}, "7.0", true},
	{"\U0001f1f8\U0001f1f7", "flag: Suriname", []string{"suriname"}, "6.0", false},
	{"\U0001f363", "sushi", []string{"sushi"}, "6.0", false},
	{"\U0001f69f", "suspension railway", []string{"suspension_railway"}, "6.0", false},
	{"\U0001f1f8\U0001f1ef", "flag: Svalbard & Jan Mayen", []string{"svalbard_jan_mayen"}, "11.0", false},
	{"\U0001f9a2", "swan", []string{"swan"}, "11.0", false},
	{"\U0001f1f8\U0001f1ff", "flag: Eswatini", []string{"swaziland"}, "6.0", false},
	{"\U0001f613", "downcast face with sweat", []string{"sweat"}, "6.0", false},
	{"\U0001f4a6", "sweat droplets", []string{"sweat_drops"}, "6.0", false},
	{"\U0001f605", "grinning face with sweat", []string{"sweat_smile"}, "6.0", false},
	{"\U0001f1f8\U0001f1ea", "flag: Sweden", []string{"sweden"}, "6.0", false},
	{"\U0001f360", "roasted sweet potato", []string{"sweet_potato"}, "6.0", false},
	{"\U0001fa72", "briefs", []string{"swim_brief"}, "12.0", false},
	{"\U0001f3ca", "person swimming", []string{"swimmer"}, "6.0", true},
	{"\U0001f3ca\u200d\u2642\ufe0f", "man swimming", []string{"swimming_man"}, "11.0", true},
	{"\U0001f3ca\u200d\u2640\ufe0f", "woman swimming", []string{"swimming_woman"}, "6.0", true},
	{"\U0001f1e8\U0001f1ed", "flag: Switzerland", []string{"switzerland"}, "6.0", false},
	{"\U0001f523", "input symbols", []string{"symbols"}, "6.0", false},
	{"\U0001f54d", "synagogue", []string{"synagogue"}, "8.0", false},
	{"\U0001f1f8\U0001f1fe", "flag: Syria", []string{"syria"}, "6.0", false},
	{"\U0001f489", "syringe", []string{"syringe"}, "6.0", false},
	{"\U0001f996", "T-Rex", []string{"t-rex"}, "11.0", false},
	{"\U0001f32e", "taco", []string{"taco"}, "8.0", false},
	{"\U0001f389", "party popper", []string{"tada", "hooray"}, "6.0", false},
	{"\U0001f1f9\U0001f1fc", "flag: Taiwan", []string{"taiwan"}, "6.0", false},
	{"\U0001f1f9\U0001f1ef", "flag: Tajikistan", []string{"tajikistan"}, "6.0", false},
	{"\U0001f961", "takeout box", []string{"takeout_box"}, "11.0", false},
	{"\U0001f38b", "tanabata tree", []string{"tanabata_tree"}, "6.0", false},
	{"\U0001f34a", "tangerine", []string{"tangerine", "orange", "mandarin"}, "6.0", false},
	{"\U0001f1f9\U0001f1ff", "flag: Tanzania", []string{"tanzania"}, "6.0", false},
	{"\u2649", "Taurus", []string{"taurus"}, "", false},
	{"\U0001f695", "taxi", []string{"taxi"}, "6.0", false},
	{"\U0001f375", "teacup without handle", []string{"tea"}, "6.0", false},
	{"\U0001f9d1\u200d\U0001f3eb", "teacher", []string{"teacher"}, "12.1", true},
	{"\U0001f9d1\u200d\U0001f4bb", "technologist", []string{"technologist"}, "12.1", true},
	{"\U0001f9f8", "teddy bear", []string{"teddy_bear"}, "11.0", false},
	{"\U0001f4de", "telephone receiver", []string{"telephone_receiver"}, "6.0", false},
	{"\U0001f52d", "telescope", []string{"telescope"}, "6.0", false},
	{"\U0001f3be", "tennis", []string{"tennis"}, "6.0", false},
	{"\u26fa", "tent", []string{"tent"}, "5.2", false},
	{"\U0001f9ea", "test tube", []string{"test_tube"}, "11.0", false},
	{"\U0001f1f9\U0001f1ed", "flag: Thailand", []string{"thailand"}, "6.0", false},
	{"\U0001f321\ufe0f", "thermometer", []string{"thermometer"}, "7.0", false},
	{"\U0001f914", "thinking face", []string{"thinking"}, "8.0", false},
	{"\U0001f4ad", "thought balloon", []string{"thought_balloon"}, "6.0", false},
	{"\U0001f9f5", "thread", []string{"thread"}, "11.0", false},
	{"3\ufe0f\u20e3", "keycap: 3", []string{"three"}, "", false},
	{"\U0001f3ab", "ticket", []string{"ticket"}, "6.0", false},
	{"\U0001f39f\ufe0f", "admission tickets", []string{"tickets"}, "7.0", false},
	{"\U0001f42f", "tiger face", []string{"tiger"}, "6.0", false},
	{"\U0001f405", "tiger", []string{"tiger2"}, "6.0", false},
	{"\u23f2\ufe0f", "timer clock", []string{"timer_clock"}, "6.0", false},
	{"\U0001f1f9\U0001f1f1", "flag: Timor-Leste", []string{"timor_leste"}, "6.0", false},
	{"\U0001f481\u200d\u2642\ufe0f", "man tipping hand", []string{"tipping_hand_man", "sassy_man"}, "6.0", true},
	{"\U0001f481", "person tipping hand", []string{"tipping_hand_person", "information_desk_person"}, "6.0", true},
	{"\U0001f481\u200d\u2640\ufe0f", "woman tipping hand", []string{"tipping_hand_woman", "sassy_woman"}, "11.0", true},
	{"\U0001f62b", "tired face", []string{"tired_face"}, "6.0", false},
	{"\u2122\ufe0f", "trade mark", []string{"tm"}, "", false},
	{"\U0001f1f9\U0001f1ec", "flag: Togo", []string{"togo"}, "6.0", false},
	{"\U0001f6bd", "toilet", []string{"toilet"}, "6.0", false},
	{"\U0001f1f9\U0001f1f0", "flag: Tokelau", []string{"tokelau"}, "6.0", false},
	{"\U0001f5fc", "Tokyo tower", []string{"tokyo_tower"}, "6.0", false},
	{"\U0001f345", "tomato", []string{"tomato"}, "6.0", false},
	{"\U0001f1f9\U0001f1f4", "flag: Tonga", []string{"tonga"}, "6.0", false},
	{"\U0001f445", "tongue", []string{"tongue"}, "6.0", false},
	{"\U0001f9f0", "toolbox", []string{"toolbox"}, "11.0", false},
	{"\U0001f9b7", "tooth", []string{"tooth"}, "11.0", false},
	{"\U0001f51d", "TOP arrow", []string{"top"}, "6.0", false},
	{"\U0001f3a9", "top hat", []string{"tophat"}, "6.0", false},
	{"\U0001f32a\ufe0f", "tornado", []string{"tornado"}, "7.0", false},
	{"\U0001f1f9\U0001f1f7", "flag: Turkey", []string{"tr"}, "8.0", false},
	{"\U0001f5b2\ufe0f", "trackball", []string{"trackball"}, "7.0", false},
	{"\U0001f69c", "tractor", []string{"tractor"}, "6.0", false},
	{"\U0001f6a5", "horizontal traffic light", []string{"traffic_light"}, "6.0", false},
	{"\U0001f68b", "tram car", []string{"train"}, "6.0", false},
	{"\U0001f686", "train", []string{"train2"}, "6.0", false},
	{"\U0001f68a", "tram", []string{"tram"}, "6.0", false},
	{"\U0001f6a9", "triangular flag", []string{"triangular_flag_on_post"}, "6.0", false},
	{"\U0001f4d0", "triangular ruler", []string{"triangular_ruler"}, "6.0", false},
	{"\U0001f531", "trident emblem", []string{"trident"}, "6.0", false},
	{"\U0001f1f9\U0001f1f9", "flag: Trinidad & Tobago", []string{"trinidad_tobago"}, "6.0", false},
	{"\U0001f1f9\U0001f1e6", "flag: Tristan da Cunha", []string{"tristan_da_cunha"}, "11.0", false},
	{"\U0001f624", "face with steam from nose", []string{"triumph"}, "6.0", false},
	{"\U0001f68e", "trolleybus", []string{"trolleybus"}, "6.0", false},
	{"\U0001f3c6", "trophy", []string{"trophy"}, "6.0", false},
	{"\U0001f379", "tropical drink", []string{"tropical_drink"}, "6.0", false},
	{"\U0001f420", "tropical fish", []string{"tropical_fish"}, "6.0", false},
	{"\U0001f69a", "delivery truck", []string{"truck"}, "6.0", false},
	{"\U0001f3ba", "trumpet", []string{"trumpet"}, "6.0", false},
	{"\U0001f337", "tulip", []string{"tulip"}, "6.0", false},
	{"\U0001f943", "tumbler glass", []string{"tumbler_glass"}, "9.0", false},
	{"\U0001f1f9\U0001f1f3", "flag: Tunisia", []string{"tunisia"}, "6.0", false},
	{"\U0001f983", "turkey", []string{"turkey"}, "8.0", false},
	{"\U0001f1f9\U0001f1f2", "flag: Turkmenistan", []string{"turkmenistan"}, "6.0", false},
	{"\U0001f1f9\U0001f1e8", "flag: Turks & Caicos Islands", []string{"turks_caicos_islands"}, "6.0", false},
	{"\U0001f422", "turtle", []string{"turtle"}, "6.0", false},
	{"\U0001f1f9\U0001f1fb", "flag: Tuvalu", []string{"tuvalu"}, "6.0", false},
	{"\U0001f4fa", "television", []string{"tv"}, "6.0", false},
	{"\U0001f500", "shuffle tracks button", []string{"twisted_rightwards_arrows"}, "6.0", false},
	{"2\ufe0f\u20e3", "keycap: 2", []string{"two"}, "", false},
	{"\U0001f495", "two hearts", []string{"two_hearts"}, "6.0", false},
	{"\U0001f46c", "men holding hands", []string{"two_men_holding_hands"}, "6.0", true},
	{"\U0001f46d", "women holding hands", []string{"two_women_holding_hands"}, "6.0", true},
	{"\U0001f239", "Japanese “discount” button", []string{"u5272"}, "6.0", false},
	{"\U0001f234", "Japanese “passing grade” button", []string{"u5408"}, "6.0", false},
	{"\U0001f23a", "Japanese “open for business” button", []string{"u55b6"}, "6.0", false},
	{"\U0001f22f", "Japanese “reserved” button", []string{"u6307"}, "", false},
	{"\U0001f237\ufe0f", "Japanese “monthly amount” button", []string{"u6708"}, "6.0", false},
	{"\U0001f236", "Japanese “not free of charge” button", []string{"u6709"}, "6.0", false},
	{"\U0001f235", "Japanese “no vacancy” button", []string{"u6e80"}, "6.0", false},
	{"\U0001f21a", "Japanese “free of charge” button", []string{"u7121"}, "", false},
	{"\U0001f238", "Japanese “application” button", []string{"u7533"}, "6.0", false},
	{"\U0001f232", "Japanese “prohibited” button", []string{"u7981"}, "6.0", false},
	{"\U0001f233", "Japanese “vacancy” button", []string{"u7a7a"}, "6.0", false},
	{"\U0001f1fa\U0001f1ec", "flag: Uganda", []string{"uganda"}, "6.0", false},
	{"\U0001f1fa\U0001f1e6", "flag: Ukraine", []string{"ukraine"}, "6.0", false},
	{"\u2614", "umbrella with rain drops", []string{"umbrella"}, "4.0", false},
	{"\U0001f612", "unamused face", []string{"unamused"}, "6.0", false},
	{"\U0001f51e", "no one under eighteen", []string{"underage"}, "6.0", false},
	{"\U0001f984", "unicorn", []string{"unicorn"}, "8.0", false},
	{"\U0001f1e6\U0001f1ea", "flag: United Arab Emirates", []string{"united_arab_emirates"}, "6.0", false},
	{"\U0001f1fa\U0001f1f3", "flag: United Nations", []string{"united_nations"}, "11.0", false},
	{"\U0001f513", "unlocked", []string{"unlock"}, "6.0", false},
	{"\U0001f199", "UP! button", []string{"up"}, "6.0", false},
	{"\U0001f643", "upside-down face", []string{"upside_down_face"}, "8.0", false},
	{"\U0001f1fa\U0001f1fe", "flag: Uruguay", []string{"uruguay"}, "6.0", false},
	{"\U0001f1fa\U0001f1f8", "flag: United States", []string{"us"}, "6.0", false},
	{"\U0001f1fa\U0001f1f2", "flag: U.S. Outlying Islands", []string{"us_outlying_islands"}, "11.0", false},
	{"\U0001f1fb\U0001f1ee", "flag: U.S. Virgin Islands", []string{"us_virgin_islands"}, "6.0", false},
	{"\U0001f1fa\U0001f1ff", "flag: Uzbekistan", []string{"uzbekistan"}, "6.0", false},
	{"\u270c\ufe0f", "victory hand", []string{"v"}, "", true},
	{"\U0001f9db", "vampire", []string{"vampire"}, "11.0", true},
	{"\U0001f9db\u200d\u2642\ufe0f", "man vampire", []string{"vampire_man"}, "11.0", true},
	{"\U0001f9db\u200d\u2640\ufe0f", "woman vampire", []string{"vampire_woman"}, "11.0", true},
	{"\U0001f1fb\U0001f1fa", "flag: Vanuatu", []string{"vanuatu"}, "6.0", false},
	{"\U0001f1fb\U0001f1e6", "flag: Vatican City", []string{"vatican_city"}, "6.0", false},
	{"\U0001f1fb\U0001f1ea", "flag: Venezuela", []string{"venezuela"}, "6.0", false},
	{"\U0001f6a6", "vertical traffic light", []string{"vertical_traffic_light"}, "6.0", false},
	{"\U0001f4fc", "videocassette", []string{"vhs"}, "6.0", false},
	{"\U0001f4f3", "vibration mode", []string{"vibration_mode"}, "6.0", false},
	{"\U0001f4f9", "video camera", []string{"video_camera"}, "6.0", false},
	{"\U0001f3ae", "video game", []string{"video_game"}, "6.0", false},
	{"\U0001f1fb\U0001f1f3", "flag: Vietnam", []string{"vietnam"}, "6.0", false},
	{"\U0001f3bb", "violin", []string{"violin"}, "6.0", false},
	{"\u264d", "Virgo", []string{"virgo"}, "", false},
	{"\U0001f30b", "volcano", []string{"volcano"}, "6.0", false},
	{"\U0001f3d0", "volleyball", []string{"volleyball"}, "8.0", false},
	{"\U0001f92e", "face vomiting", []string{"vomiting_face"}, "11.0", false},
	{"\U0001f19a", "VS button", []string{"vs"}, "6.0", false},
	{"\U0001f596", "vulcan salute", []string{"vulcan_salute"}, "7.0", true},
	{"\U0001f9c7", "waffle", []string{"waffle"}, "12.0", false},
	{"\U0001f3f4\U000e0067\U000e0062\U000e0077\U000e006c\U000e0073\U000e007f", "flag: Wales", []string{"wales"}, "11.0", false},
	{"\U0001f6b6", "person walking", []string{"walking"}, "6.0", true},
	{"\U0001f6b6\u200d\u2642\ufe0f", "man walking", []string{"walking_man"}, "11.0", true},
	{"\U0001f6b6\u200d\u2640\ufe0f", "woman walking", []string{"walking_woman"}, "6.0", true},
	{"\U0001f1fc\U0001f1eb", "flag: Wallis & Futuna", []string{"wallis_futuna"}, "6.0", false},
	{"\U0001f318", "waning crescent moon", []string{"waning_crescent_moon"}, "6.0", false},
	{"\U0001f316", "waning gibbous moon", []string{"waning_gibbous_moon"}, "6.0", false},
	{"\u26a0\ufe0f", "warning", []string{"warning"}, "4.0", false},
	{"\U0001f5d1\ufe0f", "wastebasket", []string{"wastebasket"}, "7.0", false},
	{"\u231a", "watch", []string{"watch"}, "", false},
	{"\U0001f403", "water buffalo", []string{"water_buffalo"}, "6.0", false},
	{"\U0001f93d", "person playing water polo", []string{"water_polo"}, "11.0", true},
	{"\U0001f349", "watermelon", []string{"watermelon"}, "6.0", false},
	{"\U0001f44b", "waving hand", []string{"wave"}, "6.0", true},
	{"\u3030\ufe0f", "wavy dash", []string{"wavy_dash"}, "", false},
	{"\U0001f312", "waxing crescent moon", []string{"waxing_crescent_moon"}, "6.0", false},
	{"\U0001f6be", "water closet", []string{"wc"}, "6.0", false},
	{"\U0001f629", "weary face", []string{"weary"}, "6.0", false},
	{"\U0001f492", "wedding", []string{"wedding"}, "6.0", false},
	{"\U0001f3cb\ufe0f", "person lifting weights", []string{"weight_lifting"}, "7.0", true},
	{"\U0001f3cb\ufe0f\u200d\u2642\ufe0f", "man lifting weights", []string{"weight_lifting_man"}, "11.0", true},
	{"\U0001f3cb\ufe0f\u200d\u2640\ufe0f", "woman lifting weights", []string{"weight_lifting_woman"}, "6.0", true},
	{"\U0001f1ea\U0001f1ed", "flag: Western Sahara", []string{"western_sahara"}, "6.0", false},
	{"\U0001f433", "spouting whale", []string{"whale"}, "6.0", false},
	{"\U0001f40b", "whale", []string{"whale2"}, "6.0", false},
	{"\u2638\ufe0f", "wheel of dharma", []string{"wheel_of_dharma"}, "", false},
	{"\u267f", "wheelchair symbol", []string{"wheelchair"}, "4.1", false},
	{"\u2705", "check mark button", []string{"white_check_mark"}, "6.0", false},
	{"\u26aa", "white circle", []string{"white_circle"}, "4.1", false},
	{"\U0001f3f3\ufe0f", "white flag", []string{"white_flag"}, "7.0", false},
	{"\U0001f4ae", "white flower", []string{"white_flower"}, "6.0", false},
	{"\U0001f468\u200d\U0001f9b3", "man: white hair", []string{"white_haired_man"}, "11.0", true},
	{"\U0001f469\u200d\U0001f9b3", "woman: white hair", []string{"white_haired_woman"}, "11.0", true},
	{"\U0001f90d", "white heart", []string{"white_heart"}, "12.0", false},
	{"\u2b1c", "white large square", []string{"white_large_square"}, "5.1", false},
	{"\u25fd", "white medium-small square", []string{"white_medium_small_square"}, "3.2", false},
	{"\u25fb\ufe0f", "white medium square", []string{"white_medium_square"}, "3.2", false},
	{"\u25ab\ufe0f", "white small square", []string{"white_small_square"}, "", false},
	{"\U0001f533", "white square button", []string{"white_square_button"}, "6.0", false},
	{"\U0001f940", "wilted flower", []string{"wilted_flower"}, "9.0", false},
	{"\U0001f390", "wind chime", []string{"wind_chime"}, "6.0", false},
	{"\U0001f32c\ufe0f", "wind face", []string{"wind_face"}, "7.0", false},
	{"\U0001f377", "wine glass", []string{"wine_glass"}, "6.0", false},
	{"\U0001f609", "winking face", []string{"wink"}, "6.0", false},
	{"\U0001f43a", "wolf", []string{"wolf"}, "6.0", false},
	{"\U0001f469", "woman", []string{"woman"}, "6.0", true},
	{"\U0001f469\u200d\U0001f3a8", "woman artist", []string{"woman_artist"}, "", true},
	{"\U0001f469\u200d\U0001f680", "woman astronaut", []string{"woman_astronaut"}, "", true},
	{"\U0001f938\u200d\u2640\ufe0f", "woman cartwheeling", []string{"woman_cartwheeling"}, "", true},
	{"\U0001f469\u200d\U0001f373", "woman cook", []string{"woman_cook"}, "", true},
	{"\U0001f483", "woman dancing", []string{"woman_dancing", "dancer"}, "6.0", true},
	{"\U0001f926\u200d\u2640\ufe0f", "woman facepalming", []string{"woman_facepalming"}, "9.0", true},
	{"\U0001f469\u200d\U0001f3ed", "woman factory worker", []string{"woman_factory_worker"}, "", true},
	{"\U0001f469\u200d\U0001f33e", "woman farmer", []string{"woman_farmer"}, "", true},
	{"\U0001f469\u200d\U0001f692", "woman firefighter", []string{"woman_firefighter"}, "", true},
	{"\U0001f469\u200d\u2695\ufe0f", "woman health worker", []string{"woman_health_worker"}, "", true},
	{"\U0001f469\u200d\U0001f9bd", "woman in manual wheelchair", []string{"woman_in_manual_wheelchair"}, "12.0", true},
	{"\U0001f469\u200d\U0001f9bc", "woman in motorized wheelchair", []string{"woman_in_motorized_wheelchair"}, "12.0", true},
	{"\U0001f469\u200d\u2696\ufe0f", "woman judge", []string{"woman_judge"}, "", true},
	{"\U0001f939\u200d\u2640\ufe0f", "woman juggling", []string{"woman_juggling"}, "9.0", true},
	{"\U0001f469\u200d\U0001f527", "woman mechanic", []string{"woman_mechanic"}, "", true},
	{"\U0001f469\u200d\U0001f4bc", "woman office worker", []string{"woman_office_worker"}, "", true},
	{"\U0001f469\u200d\u2708\ufe0f", "woman pilot", []string{"woman_pilot"}, "", true},
	{"\U0001f93e\u200d\u2640\ufe0f", "woman playing handball", []string{"woman_playing_handball"}, "9.0", true},
	{"\U0001f93d\u200d\u2640\ufe0f", "woman playing water polo", []string{"woman_playing_water_polo"}, "9.0", true},
	{"\U0001f469\u200d\U0001f52c", "woman scientist", []string{"woman_scientist"}, "", true},
	{"\U0001f937\u200d\u2640\ufe0f", "woman shrugging", []string{"woman_shrugging"}, "9.0", true},
	{"\U0001f469\u200d\U0001f3a4", "woman singer", []string{"woman_singer"}, "", true},
	{"\U0001f469\u200d\U0001f393", "woman student", []string{"woman_student"}, "", true},
	{"\U0001f469\u200d\U0001f3eb", "woman teacher", []string{"woman_teacher"}, "", true},
	{"\U0001f469\u200d\U0001f4bb", "woman technologist", []string{"woman_technologist"}, "", true},
	{"\U0001f9d5", "woman with headscarf", []string{"woman_with_headscarf"}, "11.0", true},
	{"\U0001f469\u200d\U0001f9af", "woman with white cane", []string{"woman_with_probing_cane"}, "12.0", true},
	{"\U0001f473\u200d\u2640\ufe0f", "woman wearing turban", []string{"woman_with_turban"}, "6.0", true},
	{"\U0001f45a", "woman’s clothes", []string{"womans_clothes"}, "6.0", false},
	{"\U0001f452", "woman’s hat", []string{"womans_hat"}, "6.0", false},
	{"\U0001f93c\u200d\u2640\ufe0f", "women wrestling", []string{"women_wrestling"}, "9.0", false},
	{"\U0001f6ba", "women’s room", []string{"womens"}, "6.0", false},
	{"\U0001f974", "woozy face", []string{"woozy_face"}, "11.0", false},
	{"\U0001f5fa\ufe0f", "world map", []string{"world_map"}, "7.0", false},
	{"\U0001f61f", "worried face", []string{"worried"}, "6.1", false},
	{"\U0001f527", "wrench", []string{"wrench"}, "6.0", false},
	{"\U0001f93c", "people wrestling", []string{"wrestling"}, "11.0", false},
	{"\u270d\ufe0f", "writing hand", []string{"writing_hand"}, "", true},
	{"\u274c", "cross mark", []string{"x"}, "6.0", false},
	{"\U0001f9f6", "yarn", []string{"yarn"}, "11.0", false},
	{"\U0001f971", "yawning face", []string{"yawning_face"}, "12.0", false},
	{"\U0001f7e1", "yellow circle", []string{"yellow_circle"}, "12.0", false},
	{"\U0001f49b", "yellow heart", []string{"yellow_heart"}, "6.0", false},
	{"\U0001f7e8", "yellow square", []string{"yellow_square"}, "12.0", false},
	{"\U0001f1fe\U0001f1ea", "flag: Yemen", []string{"yemen"}, "6.0", false},
	{"\U0001f4b4", "yen banknote", []string{"yen"}, "6.0", false},
	{"\u262f\ufe0f", "yin yang", []string{"yin_yang"}, "", false},
	{"\U0001fa80", "yo-yo", []string{"yo_yo"}, "12.0", false},
	{"\U0001f60b", "face savoring food", []string{"yum"}, "6.0", false},
	{"\U0001f1ff\U0001f1f2", "flag: Zambia", []string{"zambia"}, "6.0", false},
	{"\U0001f92a", "zany face", []string{"zany_face"}, "11.0", false},
	{"\u26a1", "high voltage", []string{"zap"}, "4.0", false},
	{"\U0001f993", "zebra", []string{"zebra"}, "11.0", false},
	{"0\ufe0f\u20e3", "keycap: 0", []string{"zero"}, "", false},
	{"\U0001f1ff\U0001f1fc", "flag: Zimbabwe", []string{"zimbabwe"}, "6.0", false},
	{"\U0001f910", "zipper-mouth face", []string{"zipper_mouth_face"}, "8.0", false},
	{"\U0001f9df", "zombie", []string{"zombie"}, "11.0", false},
	{"\U0001f9df\u200d\u2642\ufe0f", "man zombie", []string{"zombie_man"}, "11.0", false},
	{"\U0001f9df\u200d\u2640\ufe0f", "woman zombie", []string{"zombie_woman"}, "11.0", false},
	{"\U0001f4a4", "zzz", []string{"zzz"}, "6.0", false},
	{"\U0001f44d\U0001f3ff", "thumbs up: Dark Skin Tone", []string{"+1_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44d\U0001f3fb", "thumbs up: Light Skin Tone", []string{"+1_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44d\U0001f3fc", "thumbs up: Medium-Light Skin Tone", []string{"+1_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44d\U0001f3fd", "thumbs up: Medium Skin Tone", []string{"+1_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f44d\U0001f3fe", "thumbs up: Medium-Dark Skin Tone", []string{"+1_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44e\U0001f3fb", "thumbs down: Light Skin Tone", []string{"-1_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44e\U0001f3fc", "thumbs down: Medium-Light Skin Tone", []string{"-1_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44e\U0001f3fd", "thumbs down: Medium Skin Tone", []string{"-1_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f44e\U0001f3fe", "thumbs down: Medium-Dark Skin Tone", []string{"-1_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44e\U0001f3ff", "thumbs down: Dark Skin Tone", []string{"-1_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd", "person: Medium Skin Tone", []string{"adult_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe", "person: Medium-Dark Skin Tone", []string{"adult_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff", "person: Dark Skin Tone", []string{"adult_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb", "person: Light Skin Tone", []string{"adult_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc", "person: Medium-Light Skin Tone", []string{"adult_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f47c\U0001f3fb", "baby angel: Light Skin Tone", []string{"angel_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f47c\U0001f3fc", "baby angel: Medium-Light Skin Tone", []string{"angel_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f47c\U0001f3fd", "baby angel: Medium Skin Tone", []string{"angel_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f47c\U0001f3fe", "baby angel: Medium-Dark Skin Tone", []string{"angel_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f47c\U0001f3ff", "baby angel: Dark Skin Tone", []string{"angel_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f3a8", "artist: Medium-Dark Skin Tone", []string{"artist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f3a8", "artist: Dark Skin Tone", []string{"artist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f3a8", "artist: Light Skin Tone", []string{"artist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f3a8", "artist: Medium-Light Skin Tone", []string{"artist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f3a8", "artist: Medium Skin Tone", []string{"artist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f680", "astronaut: Light Skin Tone", []string{"astronaut_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f680", "astronaut: Medium-Light Skin Tone", []string{"astronaut_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f680", "astronaut: Medium Skin Tone", []string{"astronaut_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f680", "astronaut: Medium-Dark Skin Tone", []string{"astronaut_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f680", "astronaut: Dark Skin Tone", []string{"astronaut_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f476\U0001f3fb", "baby: Light Skin Tone", []string{"baby_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f476\U0001f3fc", "baby: Medium-Light Skin Tone", []string{"baby_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f476\U0001f3fd", "baby: Medium Skin Tone", []string{"baby_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f476\U0001f3fe", "baby: Medium-Dark Skin Tone", []string{"baby_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f476\U0001f3ff", "baby: Dark Skin Tone", []string{"baby_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f9b2", "man: bald: Light Skin Tone", []string{"bald_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f9b2", "man: bald: Medium-Light Skin Tone", []string{"bald_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f9b2", "man: bald: Medium Skin Tone", []string{"bald_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f9b2", "man: bald: Medium-Dark Skin Tone", []string{"bald_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f9b2", "man: bald: Dark Skin Tone", []string{"bald_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f9b2", "woman: bald: Dark Skin Tone", []string{"bald_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f9b2", "woman: bald: Light Skin Tone", []string{"bald_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f9b2", "woman: bald: Medium-Light Skin Tone", []string{"bald_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f9b2", "woman: bald: Medium Skin Tone", []string{"bald_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f9b2", "woman: bald: Medium-Dark Skin Tone", []string{"bald_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6c0\U0001f3fb", "person taking bath: Light Skin Tone", []string{"bath_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6c0\U0001f3fc", "person taking bath: Medium-Light Skin Tone", []string{"bath_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6c0\U0001f3fd", "person taking bath: Medium Skin Tone", []string{"bath_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6c0\U0001f3fe", "person taking bath: Medium-Dark Skin Tone", []string{"bath_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6c0\U0001f3ff", "person taking bath: Dark Skin Tone", []string{"bath_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d4\U0001f3fb", "man: beard: Light Skin Tone", []string{"bearded_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d4\U0001f3fc", "man: beard: Medium-Light Skin Tone", []string{"bearded_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d4\U0001f3fd", "man: beard: Medium Skin Tone", []string{"bearded_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d4\U0001f3fe", "man: beard: Medium-Dark Skin Tone", []string{"bearded_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d4\U0001f3ff", "man: beard: Dark Skin Tone", []string{"bearded_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3ff", "person biking: Dark Skin Tone", []string{"bicyclist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fb", "person biking: Light Skin Tone", []string{"bicyclist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fc", "person biking: Medium-Light Skin Tone", []string{"bicyclist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fd", "person biking: Medium Skin Tone", []string{"bicyclist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fe", "person biking: Medium-Dark Skin Tone", []string{"bicyclist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fe\u200d\u2642\ufe0f", "man biking: Medium-Dark Skin Tone", []string{"biking_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3ff\u200d\u2642\ufe0f", "man biking: Dark Skin Tone", []string{"biking_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fb\u200d\u2642\ufe0f", "man biking: Light Skin Tone", []string{"biking_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fc\u200d\u2642\ufe0f", "man biking: Medium-Light Skin Tone", []string{"biking_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fd\u200d\u2642\ufe0f", "man biking: Medium Skin Tone", []string{"biking_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fb\u200d\u2640\ufe0f", "woman biking: Light Skin Tone", []string{"biking_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fc\u200d\u2640\ufe0f", "woman biking: Medium-Light Skin Tone", []string{"biking_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fd\u200d\u2640\ufe0f", "woman biking: Medium Skin Tone", []string{"biking_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3fe\u200d\u2640\ufe0f", "woman biking: Medium-Dark Skin Tone", []string{"biking_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b4\U0001f3ff\u200d\u2640\ufe0f", "woman biking: Dark Skin Tone", []string{"biking_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fb\u200d\u2642\ufe0f", "man: blond hair: Light Skin Tone", []string{"blond_haired_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fc\u200d\u2642\ufe0f", "man: blond hair: Medium-Light Skin Tone", []string{"blond_haired_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fd\u200d\u2642\ufe0f", "man: blond hair: Medium Skin Tone", []string{"blond_haired_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fe\u200d\u2642\ufe0f", "man: blond hair: Medium-Dark Skin Tone", []string{"blond_haired_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3ff\u200d\u2642\ufe0f", "man: blond hair: Dark Skin Tone", []string{"blond_haired_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fb", "person: blond hair: Light Skin Tone", []string{"blond_haired_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fc", "person: blond hair: Medium-Light Skin Tone", []string{"blond_haired_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fd", "person: blond hair: Medium Skin Tone", []string{"blond_haired_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fe", "person: blond hair: Medium-Dark Skin Tone", []string{"blond_haired_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3ff", "person: blond hair: Dark Skin Tone", []string{"blond_haired_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fb\u200d\u2640\ufe0f", "woman: blond hair: Light Skin Tone", []string{"blond_haired_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fc\u200d\u2640\ufe0f", "woman: blond hair: Medium-Light Skin Tone", []string{"blond_haired_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fd\u200d\u2640\ufe0f", "woman: blond hair: Medium Skin Tone", []string{"blond_haired_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3fe\u200d\u2640\ufe0f", "woman: blond hair: Medium-Dark Skin Tone", []string{"blond_haired_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f471\U0001f3ff\u200d\u2640\ufe0f", "woman: blond hair: Dark Skin Tone", []string{"blond_haired_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fe\ufe0f\u200d\u2642\ufe0f", "man bouncing ball: Medium-Dark Skin Tone", []string{"bouncing_ball_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3ff\ufe0f\u200d\u2642\ufe0f", "man bouncing ball: Dark Skin Tone", []string{"bouncing_ball_man_Dark_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fb\ufe0f\u200d\u2642\ufe0f", "man bouncing ball: Light Skin Tone", []string{"bouncing_ball_man_Light_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fc\ufe0f\u200d\u2642\ufe0f", "man bouncing ball: Medium-Light Skin Tone", []string{"bouncing_ball_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fd\ufe0f\u200d\u2642\ufe0f", "man bouncing ball: Medium Skin Tone", []string{"bouncing_ball_man_Medium_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fb\ufe0f", "person bouncing ball: Light Skin Tone", []string{"bouncing_ball_person_Light_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fc\ufe0f", "person bouncing ball: Medium-Light Skin Tone", []string{"bouncing_ball_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fd\ufe0f", "person bouncing ball: Medium Skin Tone", []string{"bouncing_ball_person_Medium_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fe\ufe0f", "person bouncing ball: Medium-Dark Skin Tone", []string{"bouncing_ball_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3ff\ufe0f", "person bouncing ball: Dark Skin Tone", []string{"bouncing_ball_person_Dark_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fe\ufe0f\u200d\u2640\ufe0f", "woman bouncing ball: Medium-Dark Skin Tone", []string{"bouncing_ball_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3ff\ufe0f\u200d\u2640\ufe0f", "woman bouncing ball: Dark Skin Tone", []string{"bouncing_ball_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fb\ufe0f\u200d\u2640\ufe0f", "woman bouncing ball: Light Skin Tone", []string{"bouncing_ball_woman_Light_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fc\ufe0f\u200d\u2640\ufe0f", "woman bouncing ball: Medium-Light Skin Tone", []string{"bouncing_ball_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\u26f9\U0001f3fd\ufe0f\u200d\u2640\ufe0f", "woman bouncing ball: Medium Skin Tone", []string{"bouncing_ball_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fb", "person bowing: Light Skin Tone", []string{"bow_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fc", "person bowing: Medium-Light Skin Tone", []string{"bow_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fd", "person bowing: Medium Skin Tone", []string{"bow_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fe", "person bowing: Medium-Dark Skin Tone", []string{"bow_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3ff", "person bowing: Dark Skin Tone", []string{"bow_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3ff\u200d\u2642\ufe0f", "man bowing: Dark Skin Tone", []string{"bowing_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fb\u200d\u2642\ufe0f", "man bowing: Light Skin Tone", []string{"bowing_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fc\u200d\u2642\ufe0f", "man bowing: Medium-Light Skin Tone", []string{"bowing_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fd\u200d\u2642\ufe0f", "man bowing: Medium Skin Tone", []string{"bowing_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fe\u200d\u2642\ufe0f", "man bowing: Medium-Dark Skin Tone", []string{"bowing_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fe\u200d\u2640\ufe0f", "woman bowing: Medium-Dark Skin Tone", []string{"bowing_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3ff\u200d\u2640\ufe0f", "woman bowing: Dark Skin Tone", []string{"bowing_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fb\u200d\u2640\ufe0f", "woman bowing: Light Skin Tone", []string{"bowing_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fc\u200d\u2640\ufe0f", "woman bowing: Medium-Light Skin Tone", []string{"bowing_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f647\U0001f3fd\u200d\u2640\ufe0f", "woman bowing: Medium Skin Tone", []string{"bowing_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f466\U0001f3fb", "boy: Light Skin Tone", []string{"boy_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f466\U0001f3fc", "boy: Medium-Light Skin Tone", []string{"boy_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f466\U0001f3fd", "boy: Medium Skin Tone", []string{"boy_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f466\U0001f3fe", "boy: Medium-Dark Skin Tone", []string{"boy_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f466\U0001f3ff", "boy: Dark Skin Tone", []string{"boy_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f931\U0001f3fe", "breast-feeding: Medium-Dark Skin Tone", []string{"breast_feeding_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f931\U0001f3ff", "breast-feeding: Dark Skin Tone", []string{"breast_feeding_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f931\U0001f3fb", "breast-feeding: Light Skin Tone", []string{"breast_feeding_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f931\U0001f3fc", "breast-feeding: Medium-Light Skin Tone", []string{"breast_feeding_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f931\U0001f3fd", "breast-feeding: Medium Skin Tone", []string{"breast_feeding_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f574\U0001f3fb\ufe0f", "person in suit levitating: Light Skin Tone", []string{"business_suit_levitating_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f574\U0001f3fc\ufe0f", "person in suit levitating: Medium-Light Skin Tone", []string{"business_suit_levitating_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f574\U0001f3fd\ufe0f", "person in suit levitating: Medium Skin Tone", []string{"business_suit_levitating_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f574\U0001f3fe\ufe0f", "person in suit levitating: Medium-Dark Skin Tone", []string{"business_suit_levitating_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f574\U0001f3ff\ufe0f", "person in suit levitating: Dark Skin Tone", []string{"business_suit_levitating_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f919\U0001f3fb", "call me hand: Light Skin Tone", []string{"call_me_hand_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f919\U0001f3fc", "call me hand: Medium-Light Skin Tone", []string{"call_me_hand_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f919\U0001f3fd", "call me hand: Medium Skin Tone", []string{"call_me_hand_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f919\U0001f3fe", "call me hand: Medium-Dark Skin Tone", []string{"call_me_hand_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f919\U0001f3ff", "call me hand: Dark Skin Tone", []string{"call_me_hand_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fc", "person cartwheeling: Medium-Light Skin Tone", []string{"cartwheeling_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fd", "person cartwheeling: Medium Skin Tone", []string{"cartwheeling_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fe", "person cartwheeling: Medium-Dark Skin Tone", []string{"cartwheeling_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3ff", "person cartwheeling: Dark Skin Tone", []string{"cartwheeling_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fb", "person cartwheeling: Light Skin Tone", []string{"cartwheeling_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d2\U0001f3fd", "child: Medium Skin Tone", []string{"child_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d2\U0001f3fe", "child: Medium-Dark Skin Tone", []string{"child_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d2\U0001f3ff", "child: Dark Skin Tone", []string{"child_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d2\U0001f3fb", "child: Light Skin Tone", []string{"child_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d2\U0001f3fc", "child: Medium-Light Skin Tone", []string{"child_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44f\U0001f3fb", "clapping hands: Light Skin Tone", []string{"clap_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44f\U0001f3fc", "clapping hands: Medium-Light Skin Tone", []string{"clap_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44f\U0001f3fd", "clapping hands: Medium Skin Tone", []string{"clap_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f44f\U0001f3fe", "clapping hands: Medium-Dark Skin Tone", []string{"clap_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44f\U0001f3ff", "clapping hands: Dark Skin Tone", []string{"clap_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fd", "person climbing: Medium Skin Tone", []string{"climbing_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fe", "person climbing: Medium-Dark Skin Tone", []string{"climbing_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3ff", "person climbing: Dark Skin Tone", []string{"climbing_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fb", "person climbing: Light Skin Tone", []string{"climbing_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fc", "person climbing: Medium-Light Skin Tone", []string{"climbing_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fb\u200d\u2642\ufe0f", "man climbing: Light Skin Tone", []string{"climbing_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fc\u200d\u2642\ufe0f", "man climbing: Medium-Light Skin Tone", []string{"climbing_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fd\u200d\u2642\ufe0f", "man climbing: Medium Skin Tone", []string{"climbing_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fe\u200d\u2642\ufe0f", "man climbing: Medium-Dark Skin Tone", []string{"climbing_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3ff\u200d\u2642\ufe0f", "man climbing: Dark Skin Tone", []string{"climbing_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fb\u200d\u2640\ufe0f", "woman climbing: Light Skin Tone", []string{"climbing_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fc\u200d\u2640\ufe0f", "woman climbing: Medium-Light Skin Tone", []string{"climbing_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fd\u200d\u2640\ufe0f", "woman climbing: Medium Skin Tone", []string{"climbing_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3fe\u200d\u2640\ufe0f", "woman climbing: Medium-Dark Skin Tone", []string{"climbing_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d7\U0001f3ff\u200d\u2640\ufe0f", "woman climbing: Dark Skin Tone", []string{"climbing_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fb", "construction worker: Light Skin Tone", []string{"construction_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fc", "construction worker: Medium-Light Skin Tone", []string{"construction_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fd", "construction worker: Medium Skin Tone", []string{"construction_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fe", "construction worker: Medium-Dark Skin Tone", []string{"construction_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3ff", "construction worker: Dark Skin Tone", []string{"construction_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fb\u200d\u2642\ufe0f", "man construction worker: Light Skin Tone", []string{"construction_worker_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fc\u200d\u2642\ufe0f", "man construction worker: Medium-Light Skin Tone", []string{"construction_worker_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fd\u200d\u2642\ufe0f", "man construction worker: Medium Skin Tone", []string{"construction_worker_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fe\u200d\u2642\ufe0f", "man construction worker: Medium-Dark Skin Tone", []string{"construction_worker_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3ff\u200d\u2642\ufe0f", "man construction worker: Dark Skin Tone", []string{"construction_worker_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fb\u200d\u2640\ufe0f", "woman construction worker: Light Skin Tone", []string{"construction_worker_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fc\u200d\u2640\ufe0f", "woman construction worker: Medium-Light Skin Tone", []string{"construction_worker_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fd\u200d\u2640\ufe0f", "woman construction worker: Medium Skin Tone", []string{"construction_worker_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3fe\u200d\u2640\ufe0f", "woman construction worker: Medium-Dark Skin Tone", []string{"construction_worker_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f477\U0001f3ff\u200d\u2640\ufe0f", "woman construction worker: Dark Skin Tone", []string{"construction_worker_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f373", "cook: Medium Skin Tone", []string{"cook_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f373", "cook: Medium-Dark Skin Tone", []string{"cook_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f373", "cook: Dark Skin Tone", []string{"cook_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f373", "cook: Light Skin Tone", []string{"cook_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f373", "cook: Medium-Light Skin Tone", []string{"cook_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46b\U0001f3fb", "woman and man holding hands: Light Skin Tone", []string{"couple_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46b\U0001f3fc", "woman and man holding hands: Medium-Light Skin Tone", []string{"couple_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46b\U0001f3fd", "woman and man holding hands: Medium Skin Tone", []string{"couple_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f46b\U0001f3fe", "woman and man holding hands: Medium-Dark Skin Tone", []string{"couple_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46b\U0001f3ff", "woman and man holding hands: Dark Skin Tone", []string{"couple_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91e\U0001f3ff", "crossed fingers: Dark Skin Tone", []string{"crossed_fingers_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91e\U0001f3fb", "crossed fingers: Light Skin Tone", []string{"crossed_fingers_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91e\U0001f3fc", "crossed fingers: Medium-Light Skin Tone", []string{"crossed_fingers_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91e\U0001f3fd", "crossed fingers: Medium Skin Tone", []string{"crossed_fingers_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f91e\U0001f3fe", "crossed fingers: Medium-Dark Skin Tone", []string{"crossed_fingers_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f9b1", "man: curly hair: Medium Skin Tone", []string{"curly_haired_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f9b1", "man: curly hair: Medium-Dark Skin Tone", []string{"curly_haired_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f9b1", "man: curly hair: Dark Skin Tone", []string{"curly_haired_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f9b1", "man: curly hair: Light Skin Tone", []string{"curly_haired_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f9b1", "man: curly hair: Medium-Light Skin Tone", []string{"curly_haired_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f9b1", "woman: curly hair: Light Skin Tone", []string{"curly_haired_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f9b1", "woman: curly hair: Medium-Light Skin Tone", []string{"curly_haired_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f9b1", "woman: curly hair: Medium Skin Tone", []string{"curly_haired_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f9b1", "woman: curly hair: Medium-Dark Skin Tone", []string{"curly_haired_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f9b1", "woman: curly hair: Dark Skin Tone", []string{"curly_haired_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fb\u200d\u2642\ufe0f", "deaf man: Light Skin Tone", []string{"deaf_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fc\u200d\u2642\ufe0f", "deaf man: Medium-Light Skin Tone", []string{"deaf_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fd\u200d\u2642\ufe0f", "deaf man: Medium Skin Tone", []string{"deaf_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fe\u200d\u2642\ufe0f", "deaf man: Medium-Dark Skin Tone", []string{"deaf_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3ff\u200d\u2642\ufe0f", "deaf man: Dark Skin Tone", []string{"deaf_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fd", "deaf person: Medium Skin Tone", []string{"deaf_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fe", "deaf person: Medium-Dark Skin Tone", []string{"deaf_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3ff", "deaf person: Dark Skin Tone", []string{"deaf_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fb", "deaf person: Light Skin Tone", []string{"deaf_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fc", "deaf person: Medium-Light Skin Tone", []string{"deaf_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fb\u200d\u2640\ufe0f", "deaf woman: Light Skin Tone", []string{"deaf_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fc\u200d\u2640\ufe0f", "deaf woman: Medium-Light Skin Tone", []string{"deaf_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fd\u200d\u2640\ufe0f", "deaf woman: Medium Skin Tone", []string{"deaf_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3fe\u200d\u2640\ufe0f", "deaf woman: Medium-Dark Skin Tone", []string{"deaf_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cf\U0001f3ff\u200d\u2640\ufe0f", "deaf woman: Dark Skin Tone", []string{"deaf_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fe\ufe0f", "detective: Medium-Dark Skin Tone", []string{"detective_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3ff\ufe0f", "detective: Dark Skin Tone", []string{"detective_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fb\ufe0f", "detective: Light Skin Tone", []string{"detective_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fc\ufe0f", "detective: Medium-Light Skin Tone", []string{"detective_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fd\ufe0f", "detective: Medium Skin Tone", []string{"detective_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f442\U0001f3fc", "ear: Medium-Light Skin Tone", []string{"ear_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f442\U0001f3fd", "ear: Medium Skin Tone", []string{"ear_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f442\U0001f3fe", "ear: Medium-Dark Skin Tone", []string{"ear_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f442\U0001f3ff", "ear: Dark Skin Tone", []string{"ear_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f442\U0001f3fb", "ear: Light Skin Tone", []string{"ear_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9bb\U0001f3fb", "ear with hearing aid: Light Skin Tone", []string{"ear_with_hearing_aid_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9bb\U0001f3fc", "ear with hearing aid: Medium-Light Skin Tone", []string{"ear_with_hearing_aid_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9bb\U0001f3fd", "ear with hearing aid: Medium Skin Tone", []string{"ear_with_hearing_aid_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9bb\U0001f3fe", "ear with hearing aid: Medium-Dark Skin Tone", []string{"ear_with_hearing_aid_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9bb\U0001f3ff", "ear with hearing aid: Dark Skin Tone", []string{"ear_with_hearing_aid_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fb", "elf: Light Skin Tone", []string{"elf_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fc", "elf: Medium-Light Skin Tone", []string{"elf_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fd", "elf: Medium Skin Tone", []string{"elf_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fe", "elf: Medium-Dark Skin Tone", []string{"elf_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3ff", "elf: Dark Skin Tone", []string{"elf_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3ff\u200d\u2642\ufe0f", "man elf: Dark Skin Tone", []string{"elf_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fb\u200d\u2642\ufe0f", "man elf: Light Skin Tone", []string{"elf_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fc\u200d\u2642\ufe0f", "man elf: Medium-Light Skin Tone", []string{"elf_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fd\u200d\u2642\ufe0f", "man elf: Medium Skin Tone", []string{"elf_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fe\u200d\u2642\ufe0f", "man elf: Medium-Dark Skin Tone", []string{"elf_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fb\u200d\u2640\ufe0f", "woman elf: Light Skin Tone", []string{"elf_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fc\u200d\u2640\ufe0f", "woman elf: Medium-Light Skin Tone", []string{"elf_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fd\u200d\u2640\ufe0f", "woman elf: Medium Skin Tone", []string{"elf_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3fe\u200d\u2640\ufe0f", "woman elf: Medium-Dark Skin Tone", []string{"elf_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dd\U0001f3ff\u200d\u2640\ufe0f", "woman elf: Dark Skin Tone", []string{"elf_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fb", "person facepalming: Light Skin Tone", []string{"facepalm_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fc", "person facepalming: Medium-Light Skin Tone", []string{"facepalm_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fd", "person facepalming: Medium Skin Tone", []string{"facepalm_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fe", "person facepalming: Medium-Dark Skin Tone", []string{"facepalm_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3ff", "person facepalming: Dark Skin Tone", []string{"facepalm_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f3ed", "factory worker: Dark Skin Tone", []string{"factory_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f3ed", "factory worker: Light Skin Tone", []string{"factory_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f3ed", "factory worker: Medium-Light Skin Tone", []string{"factory_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f3ed", "factory worker: Medium Skin Tone", []string{"factory_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f3ed", "factory worker: Medium-Dark Skin Tone", []string{"factory_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fb", "fairy: Light Skin Tone", []string{"fairy_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fc", "fairy: Medium-Light Skin Tone", []string{"fairy_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fd", "fairy: Medium Skin Tone", []string{"fairy_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fe", "fairy: Medium-Dark Skin Tone", []string{"fairy_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3ff", "fairy: Dark Skin Tone", []string{"fairy_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fb\u200d\u2642\ufe0f", "man fairy: Light Skin Tone", []string{"fairy_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fc\u200d\u2642\ufe0f", "man fairy: Medium-Light Skin Tone", []string{"fairy_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fd\u200d\u2642\ufe0f", "man fairy: Medium Skin Tone", []string{"fairy_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fe\u200d\u2642\ufe0f", "man fairy: Medium-Dark Skin Tone", []string{"fairy_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3ff\u200d\u2642\ufe0f", "man fairy: Dark Skin Tone", []string{"fairy_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fe\u200d\u2640\ufe0f", "woman fairy: Medium-Dark Skin Tone", []string{"fairy_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3ff\u200d\u2640\ufe0f", "woman fairy: Dark Skin Tone", []string{"fairy_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fb\u200d\u2640\ufe0f", "woman fairy: Light Skin Tone", []string{"fairy_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fc\u200d\u2640\ufe0f", "woman fairy: Medium-Light Skin Tone", []string{"fairy_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9da\U0001f3fd\u200d\u2640\ufe0f", "woman fairy: Medium Skin Tone", []string{"fairy_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f33e", "farmer: Light Skin Tone", []string{"farmer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f33e", "farmer: Medium-Light Skin Tone", []string{"farmer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f33e", "farmer: Medium Skin Tone", []string{"farmer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f33e", "farmer: Medium-Dark Skin Tone", []string{"farmer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f33e", "farmer: Dark Skin Tone", []string{"farmer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fc\ufe0f\u200d\u2640\ufe0f", "woman detective: Medium-Light Skin Tone", []string{"female_detective_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fd\ufe0f\u200d\u2640\ufe0f", "woman detective: Medium Skin Tone", []string{"female_detective_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fe\ufe0f\u200d\u2640\ufe0f", "woman detective: Medium-Dark Skin Tone", []string{"female_detective_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3ff\ufe0f\u200d\u2640\ufe0f", "woman detective: Dark Skin Tone", []string{"female_detective_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fb\ufe0f\u200d\u2640\ufe0f", "woman detective: Light Skin Tone", []string{"female_detective_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f692", "firefighter: Medium-Light Skin Tone", []string{"firefighter_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f692", "firefighter: Medium Skin Tone", []string{"firefighter_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f692", "firefighter: Medium-Dark Skin Tone", []string{"firefighter_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f692", "firefighter: Dark Skin Tone", []string{"firefighter_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f692", "firefighter: Light Skin Tone", []string{"firefighter_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91b\U0001f3fc", "left-facing fist: Medium-Light Skin Tone", []string{"fist_left_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91b\U0001f3fd", "left-facing fist: Medium Skin Tone", []string{"fist_left_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f91b\U0001f3fe", "left-facing fist: Medium-Dark Skin Tone", []string{"fist_left_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91b\U0001f3ff", "left-facing fist: Dark Skin Tone", []string{"fist_left_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91b\U0001f3fb", "left-facing fist: Light Skin Tone", []string{"fist_left_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44a\U0001f3fc", "oncoming fist: Medium-Light Skin Tone", []string{"fist_oncoming_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44a\U0001f3fd", "oncoming fist: Medium Skin Tone", []string{"fist_oncoming_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f44a\U0001f3fe", "oncoming fist: Medium-Dark Skin Tone", []string{"fist_oncoming_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44a\U0001f3ff", "oncoming fist: Dark Skin Tone", []string{"fist_oncoming_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44a\U0001f3fb", "oncoming fist: Light Skin Tone", []string{"fist_oncoming_Light_Skin_Tone"}, "12.0", false},
	{"\u270a\U0001f3fc", "raised fist: Medium-Light Skin Tone", []string{"fist_raised_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\u270a\U0001f3fd", "raised fist: Medium Skin Tone", []string{"fist_raised_Medium_Skin_Tone"}, "12.0", false},
	{"\u270a\U0001f3fe", "raised fist: Medium-Dark Skin Tone", []string{"fist_raised_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\u270a\U0001f3ff", "raised fist: Dark Skin Tone", []string{"fist_raised_Dark_Skin_Tone"}, "12.0", false},
	{"\u270a\U0001f3fb", "raised fist: Light Skin Tone", []string{"fist_raised_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91c\U0001f3fb", "right-facing fist: Light Skin Tone", []string{"fist_right_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91c\U0001f3fc", "right-facing fist: Medium-Light Skin Tone", []string{"fist_right_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91c\U0001f3fd", "right-facing fist: Medium Skin Tone", []string{"fist_right_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f91c\U0001f3fe", "right-facing fist: Medium-Dark Skin Tone", []string{"fist_right_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91c\U0001f3ff", "right-facing fist: Dark Skin Tone", []string{"fist_right_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b6\U0001f3fd", "foot: Medium Skin Tone", []string{"foot_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9b6\U0001f3fe", "foot: Medium-Dark Skin Tone", []string{"foot_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b6\U0001f3ff", "foot: Dark Skin Tone", []string{"foot_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b6\U0001f3fb", "foot: Light Skin Tone", []string{"foot_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b6\U0001f3fc", "foot: Medium-Light Skin Tone", []string{"foot_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fe\u200d\u2642\ufe0f", "man frowning: Medium-Dark Skin Tone", []string{"frowning_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3ff\u200d\u2642\ufe0f", "man frowning: Dark Skin Tone", []string{"frowning_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fb\u200d\u2642\ufe0f", "man frowning: Light Skin Tone", []string{"frowning_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fc\u200d\u2642\ufe0f", "man frowning: Medium-Light Skin Tone", []string{"frowning_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fd\u200d\u2642\ufe0f", "man frowning: Medium Skin Tone", []string{"frowning_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fd", "person frowning: Medium Skin Tone", []string{"frowning_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fe", "person frowning: Medium-Dark Skin Tone", []string{"frowning_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3ff", "person frowning: Dark Skin Tone", []string{"frowning_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fb", "person frowning: Light Skin Tone", []string{"frowning_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fc", "person frowning: Medium-Light Skin Tone", []string{"frowning_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fb\u200d\u2640\ufe0f", "woman frowning: Light Skin Tone", []string{"frowning_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fc\u200d\u2640\ufe0f", "woman frowning: Medium-Light Skin Tone", []string{"frowning_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fd\u200d\u2640\ufe0f", "woman frowning: Medium Skin Tone", []string{"frowning_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3fe\u200d\u2640\ufe0f", "woman frowning: Medium-Dark Skin Tone", []string{"frowning_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64d\U0001f3ff\u200d\u2640\ufe0f", "woman frowning: Dark Skin Tone", []string{"frowning_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f467\U0001f3fc", "girl: Medium-Light Skin Tone", []string{"girl_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f467\U0001f3fd", "girl: Medium Skin Tone", []string{"girl_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f467\U0001f3fe", "girl: Medium-Dark Skin Tone", []string{"girl_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f467\U0001f3ff", "girl: Dark Skin Tone", []string{"girl_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f467\U0001f3fb", "girl: Light Skin Tone", []string{"girl_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fb\ufe0f", "person golfing: Light Skin Tone", []string{"golfing_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fc\ufe0f", "person golfing: Medium-Light Skin Tone", []string{"golfing_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fd\ufe0f", "person golfing: Medium Skin Tone", []string{"golfing_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fe\ufe0f", "person golfing: Medium-Dark Skin Tone", []string{"golfing_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3ff\ufe0f", "person golfing: Dark Skin Tone", []string{"golfing_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fb\ufe0f\u200d\u2642\ufe0f", "man golfing: Light Skin Tone", []string{"golfing_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fc\ufe0f\u200d\u2642\ufe0f", "man golfing: Medium-Light Skin Tone", []string{"golfing_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fd\ufe0f\u200d\u2642\ufe0f", "man golfing: Medium Skin Tone", []string{"golfing_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fe\ufe0f\u200d\u2642\ufe0f", "man golfing: Medium-Dark Skin Tone", []string{"golfing_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3ff\ufe0f\u200d\u2642\ufe0f", "man golfing: Dark Skin Tone", []string{"golfing_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fb\ufe0f\u200d\u2640\ufe0f", "woman golfing: Light Skin Tone", []string{"golfing_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fc\ufe0f\u200d\u2640\ufe0f", "woman golfing: Medium-Light Skin Tone", []string{"golfing_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fd\ufe0f\u200d\u2640\ufe0f", "woman golfing: Medium Skin Tone", []string{"golfing_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3fe\ufe0f\u200d\u2640\ufe0f", "woman golfing: Medium-Dark Skin Tone", []string{"golfing_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cc\U0001f3ff\ufe0f\u200d\u2640\ufe0f", "woman golfing: Dark Skin Tone", []string{"golfing_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fb", "guard: Light Skin Tone", []string{"guard_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fc", "guard: Medium-Light Skin Tone", []string{"guard_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fd", "guard: Medium Skin Tone", []string{"guard_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fe", "guard: Medium-Dark Skin Tone", []string{"guard_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3ff", "guard: Dark Skin Tone", []string{"guard_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3ff\u200d\u2642\ufe0f", "man guard: Dark Skin Tone", []string{"guardsman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fb\u200d\u2642\ufe0f", "man guard: Light Skin Tone", []string{"guardsman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fc\u200d\u2642\ufe0f", "man guard: Medium-Light Skin Tone", []string{"guardsman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fd\u200d\u2642\ufe0f", "man guard: Medium Skin Tone", []string{"guardsman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fe\u200d\u2642\ufe0f", "man guard: Medium-Dark Skin Tone", []string{"guardsman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fb\u200d\u2640\ufe0f", "woman guard: Light Skin Tone", []string{"guardswoman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fc\u200d\u2640\ufe0f", "woman guard: Medium-Light Skin Tone", []string{"guardswoman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fd\u200d\u2640\ufe0f", "woman guard: Medium Skin Tone", []string{"guardswoman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3fe\u200d\u2640\ufe0f", "woman guard: Medium-Dark Skin Tone", []string{"guardswoman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f482\U0001f3ff\u200d\u2640\ufe0f", "woman guard: Dark Skin Tone", []string{"guardswoman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fe", "person getting haircut: Medium-Dark Skin Tone", []string{"haircut_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3ff", "person getting haircut: Dark Skin Tone", []string{"haircut_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fb", "person getting haircut: Light Skin Tone", []string{"haircut_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fc", "person getting haircut: Medium-Light Skin Tone", []string{"haircut_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fd", "person getting haircut: Medium Skin Tone", []string{"haircut_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fb\u200d\u2642\ufe0f", "man getting haircut: Light Skin Tone", []string{"haircut_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fc\u200d\u2642\ufe0f", "man getting haircut: Medium-Light Skin Tone", []string{"haircut_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fd\u200d\u2642\ufe0f", "man getting haircut: Medium Skin Tone", []string{"haircut_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fe\u200d\u2642\ufe0f", "man getting haircut: Medium-Dark Skin Tone", []string{"haircut_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3ff\u200d\u2642\ufe0f", "man getting haircut: Dark Skin Tone", []string{"haircut_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fc\u200d\u2640\ufe0f", "woman getting haircut: Medium-Light Skin Tone", []string{"haircut_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fd\u200d\u2640\ufe0f", "woman getting haircut: Medium Skin Tone", []string{"haircut_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fe\u200d\u2640\ufe0f", "woman getting haircut: Medium-Dark Skin Tone", []string{"haircut_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3ff\u200d\u2640\ufe0f", "woman getting haircut: Dark Skin Tone", []string{"haircut_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f487\U0001f3fb\u200d\u2640\ufe0f", "woman getting haircut: Light Skin Tone", []string{"haircut_woman_Light_Skin_Tone"}, "12.0", false},
	{"\u270b\U0001f3fc", "raised hand: Medium-Light Skin Tone", []string{"hand_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\u270b\U0001f3fd", "raised hand: Medium Skin Tone", []string{"hand_Medium_Skin_Tone"}, "12.0", false},
	{"\u270b\U0001f3fe", "raised hand: Medium-Dark Skin Tone", []string{"hand_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\u270b\U0001f3ff", "raised hand: Dark Skin Tone", []string{"hand_Dark_Skin_Tone"}, "12.0", false},
	{"\u270b\U0001f3fb", "raised hand: Light Skin Tone", []string{"hand_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fe", "person playing handball: Medium-Dark Skin Tone", []string{"handball_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3ff", "person playing handball: Dark Skin Tone", []string{"handball_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fb", "person playing handball: Light Skin Tone", []string{"handball_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fc", "person playing handball: Medium-Light Skin Tone", []string{"handball_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fd", "person playing handball: Medium Skin Tone", []string{"handball_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\u2695\ufe0f", "health worker: Dark Skin Tone", []string{"health_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\u2695\ufe0f", "health worker: Light Skin Tone", []string{"health_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\u2695\ufe0f", "health worker: Medium-Light Skin Tone", []string{"health_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\u2695\ufe0f", "health worker: Medium Skin Tone", []string{"health_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\u2695\ufe0f", "health worker: Medium-Dark Skin Tone", []string{"health_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c7\U0001f3fd", "horse racing: Medium Skin Tone", []string{"horse_racing_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3c7\U0001f3fe", "horse racing: Medium-Dark Skin Tone", []string{"horse_racing_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c7\U0001f3ff", "horse racing: Dark Skin Tone", []string{"horse_racing_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c7\U0001f3fb", "horse racing: Light Skin Tone", []string{"horse_racing_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c7\U0001f3fc", "horse racing: Medium-Light Skin Tone", []string{"horse_racing_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\u2696\ufe0f", "judge: Medium-Light Skin Tone", []string{"judge_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\u2696\ufe0f", "judge: Medium Skin Tone", []string{"judge_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\u2696\ufe0f", "judge: Medium-Dark Skin Tone", []string{"judge_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\u2696\ufe0f", "judge: Dark Skin Tone", []string{"judge_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\u2696\ufe0f", "judge: Light Skin Tone", []string{"judge_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fd", "person juggling: Medium Skin Tone", []string{"juggling_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fe", "person juggling: Medium-Dark Skin Tone", []string{"juggling_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3ff", "person juggling: Dark Skin Tone", []string{"juggling_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fb", "person juggling: Light Skin Tone", []string{"juggling_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fc", "person juggling: Medium-Light Skin Tone", []string{"juggling_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fb\u200d\u2642\ufe0f", "man kneeling: Light Skin Tone", []string{"kneeling_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fc\u200d\u2642\ufe0f", "man kneeling: Medium-Light Skin Tone", []string{"kneeling_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fd\u200d\u2642\ufe0f", "man kneeling: Medium Skin Tone", []string{"kneeling_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fe\u200d\u2642\ufe0f", "man kneeling: Medium-Dark Skin Tone", []string{"kneeling_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3ff\u200d\u2642\ufe0f", "man kneeling: Dark Skin Tone", []string{"kneeling_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fb", "person kneeling: Light Skin Tone", []string{"kneeling_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fc", "person kneeling: Medium-Light Skin Tone", []string{"kneeling_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fd", "person kneeling: Medium Skin Tone", []string{"kneeling_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fe", "person kneeling: Medium-Dark Skin Tone", []string{"kneeling_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3ff", "person kneeling: Dark Skin Tone", []string{"kneeling_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3ff\u200d\u2640\ufe0f", "woman kneeling: Dark Skin Tone", []string{"kneeling_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fb\u200d\u2640\ufe0f", "woman kneeling: Light Skin Tone", []string{"kneeling_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fc\u200d\u2640\ufe0f", "woman kneeling: Medium-Light Skin Tone", []string{"kneeling_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fd\u200d\u2640\ufe0f", "woman kneeling: Medium Skin Tone", []string{"kneeling_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9ce\U0001f3fe\u200d\u2640\ufe0f", "woman kneeling: Medium-Dark Skin Tone", []string{"kneeling_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b5\U0001f3fb", "leg: Light Skin Tone", []string{"leg_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b5\U0001f3fc", "leg: Medium-Light Skin Tone", []string{"leg_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b5\U0001f3fd", "leg: Medium Skin Tone", []string{"leg_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9b5\U0001f3fe", "leg: Medium-Dark Skin Tone", []string{"leg_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b5\U0001f3ff", "leg: Dark Skin Tone", []string{"leg_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fd", "person in lotus position: Medium Skin Tone", []string{"lotus_position_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fe", "person in lotus position: Medium-Dark Skin Tone", []string{"lotus_position_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3ff", "person in lotus position: Dark Skin Tone", []string{"lotus_position_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fb", "person in lotus position: Light Skin Tone", []string{"lotus_position_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fc", "person in lotus position: Medium-Light Skin Tone", []string{"lotus_position_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fd\u200d\u2642\ufe0f", "man in lotus position: Medium Skin Tone", []string{"lotus_position_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fe\u200d\u2642\ufe0f", "man in lotus position: Medium-Dark Skin Tone", []string{"lotus_position_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3ff\u200d\u2642\ufe0f", "man in lotus position: Dark Skin Tone", []string{"lotus_position_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fb\u200d\u2642\ufe0f", "man in lotus position: Light Skin Tone", []string{"lotus_position_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fc\u200d\u2642\ufe0f", "man in lotus position: Medium-Light Skin Tone", []string{"lotus_position_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fd\u200d\u2640\ufe0f", "woman in lotus position: Medium Skin Tone", []string{"lotus_position_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fe\u200d\u2640\ufe0f", "woman in lotus position: Medium-Dark Skin Tone", []string{"lotus_position_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3ff\u200d\u2640\ufe0f", "woman in lotus position: Dark Skin Tone", []string{"lotus_position_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fb\u200d\u2640\ufe0f", "woman in lotus position: Light Skin Tone", []string{"lotus_position_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d8\U0001f3fc\u200d\u2640\ufe0f", "woman in lotus position: Medium-Light Skin Tone", []string{"lotus_position_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91f\U0001f3fc", "love-you gesture: Medium-Light Skin Tone", []string{"love_you_gesture_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91f\U0001f3fd", "love-you gesture: Medium Skin Tone", []string{"love_you_gesture_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f91f\U0001f3fe", "love-you gesture: Medium-Dark Skin Tone", []string{"love_you_gesture_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91f\U0001f3ff", "love-you gesture: Dark Skin Tone", []string{"love_you_gesture_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91f\U0001f3fb", "love-you gesture: Light Skin Tone", []string{"love_you_gesture_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fb", "mage: Light Skin Tone", []string{"mage_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fc", "mage: Medium-Light Skin Tone", []string{"mage_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fd", "mage: Medium Skin Tone", []string{"mage_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fe", "mage: Medium-Dark Skin Tone", []string{"mage_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3ff", "mage: Dark Skin Tone", []string{"mage_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fe\u200d\u2642\ufe0f", "man mage: Medium-Dark Skin Tone", []string{"mage_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3ff\u200d\u2642\ufe0f", "man mage: Dark Skin Tone", []string{"mage_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fb\u200d\u2642\ufe0f", "man mage: Light Skin Tone", []string{"mage_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fc\u200d\u2642\ufe0f", "man mage: Medium-Light Skin Tone", []string{"mage_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fd\u200d\u2642\ufe0f", "man mage: Medium Skin Tone", []string{"mage_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fb\u200d\u2640\ufe0f", "woman mage: Light Skin Tone", []string{"mage_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fc\u200d\u2640\ufe0f", "woman mage: Medium-Light Skin Tone", []string{"mage_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fd\u200d\u2640\ufe0f", "woman mage: Medium Skin Tone", []string{"mage_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3fe\u200d\u2640\ufe0f", "woman mage: Medium-Dark Skin Tone", []string{"mage_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d9\U0001f3ff\u200d\u2640\ufe0f", "woman mage: Dark Skin Tone", []string{"mage_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fc\ufe0f\u200d\u2642\ufe0f", "man detective: Medium-Light Skin Tone", []string{"male_detective_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fd\ufe0f\u200d\u2642\ufe0f", "man detective: Medium Skin Tone", []string{"male_detective_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fe\ufe0f\u200d\u2642\ufe0f", "man detective: Medium-Dark Skin Tone", []string{"male_detective_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3ff\ufe0f\u200d\u2642\ufe0f", "man detective: Dark Skin Tone", []string{"male_detective_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f575\U0001f3fb\ufe0f\u200d\u2642\ufe0f", "man detective: Light Skin Tone", []string{"male_detective_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe", "man: Medium-Dark Skin Tone", []string{"man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff", "man: Dark Skin Tone", []string{"man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb", "man: Light Skin Tone", []string{"man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc", "man: Medium-Light Skin Tone", []string{"man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd", "man: Medium Skin Tone", []string{"man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f3a8", "man artist: Dark Skin Tone", []string{"man_artist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f3a8", "man artist: Light Skin Tone", []string{"man_artist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f3a8", "man artist: Medium-Light Skin Tone", []string{"man_artist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f3a8", "man artist: Medium Skin Tone", []string{"man_artist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f3a8", "man artist: Medium-Dark Skin Tone", []string{"man_artist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f680", "man astronaut: Medium Skin Tone", []string{"man_astronaut_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f680", "man astronaut: Medium-Dark Skin Tone", []string{"man_astronaut_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f680", "man astronaut: Dark Skin Tone", []string{"man_astronaut_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f680", "man astronaut: Light Skin Tone", []string{"man_astronaut_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f680", "man astronaut: Medium-Light Skin Tone", []string{"man_astronaut_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fc\u200d\u2642\ufe0f", "man cartwheeling: Medium-Light Skin Tone", []string{"man_cartwheeling_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fd\u200d\u2642\ufe0f", "man cartwheeling: Medium Skin Tone", []string{"man_cartwheeling_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fe\u200d\u2642\ufe0f", "man cartwheeling: Medium-Dark Skin Tone", []string{"man_cartwheeling_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3ff\u200d\u2642\ufe0f", "man cartwheeling: Dark Skin Tone", []string{"man_cartwheeling_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fb\u200d\u2642\ufe0f", "man cartwheeling: Light Skin Tone", []string{"man_cartwheeling_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f373", "man cook: Medium-Dark Skin Tone", []string{"man_cook_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f373", "man cook: Dark Skin Tone", []string{"man_cook_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f373", "man cook: Light Skin Tone", []string{"man_cook_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f373", "man cook: Medium-Light Skin Tone", []string{"man_cook_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f373", "man cook: Medium Skin Tone", []string{"man_cook_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f57a\U0001f3fb", "man dancing: Light Skin Tone", []string{"man_dancing_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f57a\U0001f3fc", "man dancing: Medium-Light Skin Tone", []string{"man_dancing_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f57a\U0001f3fd", "man dancing: Medium Skin Tone", []string{"man_dancing_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f57a\U0001f3fe", "man dancing: Medium-Dark Skin Tone", []string{"man_dancing_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f57a\U0001f3ff", "man dancing: Dark Skin Tone", []string{"man_dancing_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fe\u200d\u2642\ufe0f", "man facepalming: Medium-Dark Skin Tone", []string{"man_facepalming_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3ff\u200d\u2642\ufe0f", "man facepalming: Dark Skin Tone", []string{"man_facepalming_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fb\u200d\u2642\ufe0f", "man facepalming: Light Skin Tone", []string{"man_facepalming_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fc\u200d\u2642\ufe0f", "man facepalming: Medium-Light Skin Tone", []string{"man_facepalming_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fd\u200d\u2642\ufe0f", "man facepalming: Medium Skin Tone", []string{"man_facepalming_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f3ed", "man factory worker: Dark Skin Tone", []string{"man_factory_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f3ed", "man factory worker: Light Skin Tone", []string{"man_factory_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f3ed", "man factory worker: Medium-Light Skin Tone", []string{"man_factory_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f3ed", "man factory worker: Medium Skin Tone", []string{"man_factory_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f3ed", "man factory worker: Medium-Dark Skin Tone", []string{"man_factory_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f33e", "man farmer: Light Skin Tone", []string{"man_farmer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f33e", "man farmer: Medium-Light Skin Tone", []string{"man_farmer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f33e", "man farmer: Medium Skin Tone", []string{"man_farmer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f33e", "man farmer: Medium-Dark Skin Tone", []string{"man_farmer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f33e", "man farmer: Dark Skin Tone", []string{"man_farmer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f692", "man firefighter: Dark Skin Tone", []string{"man_firefighter_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f692", "man firefighter: Light Skin Tone", []string{"man_firefighter_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f692", "man firefighter: Medium-Light Skin Tone", []string{"man_firefighter_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f692", "man firefighter: Medium Skin Tone", []string{"man_firefighter_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f692", "man firefighter: Medium-Dark Skin Tone", []string{"man_firefighter_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\u2695\ufe0f", "man health worker: Light Skin Tone", []string{"man_health_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\u2695\ufe0f", "man health worker: Medium-Light Skin Tone", []string{"man_health_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\u2695\ufe0f", "man health worker: Medium Skin Tone", []string{"man_health_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\u2695\ufe0f", "man health worker: Medium-Dark Skin Tone", []string{"man_health_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\u2695\ufe0f", "man health worker: Dark Skin Tone", []string{"man_health_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f9bd", "man in manual wheelchair: Light Skin Tone", []string{"man_in_manual_wheelchair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f9bd", "man in manual wheelchair: Medium-Light Skin Tone", []string{"man_in_manual_wheelchair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f9bd", "man in manual wheelchair: Medium Skin Tone", []string{"man_in_manual_wheelchair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f9bd", "man in manual wheelchair: Medium-Dark Skin Tone", []string{"man_in_manual_wheelchair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f9bd", "man in manual wheelchair: Dark Skin Tone", []string{"man_in_manual_wheelchair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f9bc", "man in motorized wheelchair: Light Skin Tone", []string{"man_in_motorized_wheelchair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f9bc", "man in motorized wheelchair: Medium-Light Skin Tone", []string{"man_in_motorized_wheelchair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f9bc", "man in motorized wheelchair: Medium Skin Tone", []string{"man_in_motorized_wheelchair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f9bc", "man in motorized wheelchair: Medium-Dark Skin Tone", []string{"man_in_motorized_wheelchair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f9bc", "man in motorized wheelchair: Dark Skin Tone", []string{"man_in_motorized_wheelchair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\u2696\ufe0f", "man judge: Medium Skin Tone", []string{"man_judge_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\u2696\ufe0f", "man judge: Medium-Dark Skin Tone", []string{"man_judge_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\u2696\ufe0f", "man judge: Dark Skin Tone", []string{"man_judge_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\u2696\ufe0f", "man judge: Light Skin Tone", []string{"man_judge_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\u2696\ufe0f", "man judge: Medium-Light Skin Tone", []string{"man_judge_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fe\u200d\u2642\ufe0f", "man juggling: Medium-Dark Skin Tone", []string{"man_juggling_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3ff\u200d\u2642\ufe0f", "man juggling: Dark Skin Tone", []string{"man_juggling_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fb\u200d\u2642\ufe0f", "man juggling: Light Skin Tone", []string{"man_juggling_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fc\u200d\u2642\ufe0f", "man juggling: Medium-Light Skin Tone", []string{"man_juggling_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fd\u200d\u2642\ufe0f", "man juggling: Medium Skin Tone", []string{"man_juggling_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f527", "man mechanic: Light Skin Tone", []string{"man_mechanic_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f527", "man mechanic: Medium-Light Skin Tone", []string{"man_mechanic_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f527", "man mechanic: Medium Skin Tone", []string{"man_mechanic_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f527", "man mechanic: Medium-Dark Skin Tone", []string{"man_mechanic_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f527", "man mechanic: Dark Skin Tone", []string{"man_mechanic_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f4bc", "man office worker: Light Skin Tone", []string{"man_office_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f4bc", "man office worker: Medium-Light Skin Tone", []string{"man_office_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f4bc", "man office worker: Medium Skin Tone", []string{"man_office_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f4bc", "man office worker: Medium-Dark Skin Tone", []string{"man_office_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f4bc", "man office worker: Dark Skin Tone", []string{"man_office_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\u2708\ufe0f", "man pilot: Light Skin Tone", []string{"man_pilot_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\u2708\ufe0f", "man pilot: Medium-Light Skin Tone", []string{"man_pilot_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\u2708\ufe0f", "man pilot: Medium Skin Tone", []string{"man_pilot_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\u2708\ufe0f", "man pilot: Medium-Dark Skin Tone", []string{"man_pilot_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\u2708\ufe0f", "man pilot: Dark Skin Tone", []string{"man_pilot_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fb\u200d\u2642\ufe0f", "man playing handball: Light Skin Tone", []string{"man_playing_handball_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fc\u200d\u2642\ufe0f", "man playing handball: Medium-Light Skin Tone", []string{"man_playing_handball_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fd\u200d\u2642\ufe0f", "man playing handball: Medium Skin Tone", []string{"man_playing_handball_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fe\u200d\u2642\ufe0f", "man playing handball: Medium-Dark Skin Tone", []string{"man_playing_handball_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3ff\u200d\u2642\ufe0f", "man playing handball: Dark Skin Tone", []string{"man_playing_handball_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fb\u200d\u2642\ufe0f", "man playing water polo: Light Skin Tone", []string{"man_playing_water_polo_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fc\u200d\u2642\ufe0f", "man playing water polo: Medium-Light Skin Tone", []string{"man_playing_water_polo_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fd\u200d\u2642\ufe0f", "man playing water polo: Medium Skin Tone", []string{"man_playing_water_polo_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fe\u200d\u2642\ufe0f", "man playing water polo: Medium-Dark Skin Tone", []string{"man_playing_water_polo_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3ff\u200d\u2642\ufe0f", "man playing water polo: Dark Skin Tone", []string{"man_playing_water_polo_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f52c", "man scientist: Light Skin Tone", []string{"man_scientist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f52c", "man scientist: Medium-Light Skin Tone", []string{"man_scientist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f52c", "man scientist: Medium Skin Tone", []string{"man_scientist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f52c", "man scientist: Medium-Dark Skin Tone", []string{"man_scientist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f52c", "man scientist: Dark Skin Tone", []string{"man_scientist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fb\u200d\u2642\ufe0f", "man shrugging: Light Skin Tone", []string{"man_shrugging_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fc\u200d\u2642\ufe0f", "man shrugging: Medium-Light Skin Tone", []string{"man_shrugging_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fd\u200d\u2642\ufe0f", "man shrugging: Medium Skin Tone", []string{"man_shrugging_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fe\u200d\u2642\ufe0f", "man shrugging: Medium-Dark Skin Tone", []string{"man_shrugging_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3ff\u200d\u2642\ufe0f", "man shrugging: Dark Skin Tone", []string{"man_shrugging_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f3a4", "man singer: Light Skin Tone", []string{"man_singer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f3a4", "man singer: Medium-Light Skin Tone", []string{"man_singer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f3a4", "man singer: Medium Skin Tone", []string{"man_singer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f3a4", "man singer: Medium-Dark Skin Tone", []string{"man_singer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f3a4", "man singer: Dark Skin Tone", []string{"man_singer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f393", "man student: Medium-Dark Skin Tone", []string{"man_student_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f393", "man student: Dark Skin Tone", []string{"man_student_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f393", "man student: Light Skin Tone", []string{"man_student_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f393", "man student: Medium-Light Skin Tone", []string{"man_student_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f393", "man student: Medium Skin Tone", []string{"man_student_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f3eb", "man teacher: Medium-Light Skin Tone", []string{"man_teacher_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f3eb", "man teacher: Medium Skin Tone", []string{"man_teacher_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f3eb", "man teacher: Medium-Dark Skin Tone", []string{"man_teacher_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f3eb", "man teacher: Dark Skin Tone", []string{"man_teacher_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f3eb", "man teacher: Light Skin Tone", []string{"man_teacher_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f4bb", "man technologist: Light Skin Tone", []string{"man_technologist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f4bb", "man technologist: Medium-Light Skin Tone", []string{"man_technologist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f4bb", "man technologist: Medium Skin Tone", []string{"man_technologist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f4bb", "man technologist: Medium-Dark Skin Tone", []string{"man_technologist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f4bb", "man technologist: Dark Skin Tone", []string{"man_technologist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f472\U0001f3fb", "person with skullcap: Light Skin Tone", []string{"man_with_gua_pi_mao_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f472\U0001f3fc", "person with skullcap: Medium-Light Skin Tone", []string{"man_with_gua_pi_mao_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f472\U0001f3fd", "person with skullcap: Medium Skin Tone", []string{"man_with_gua_pi_mao_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f472\U0001f3fe", "person with skullcap: Medium-Dark Skin Tone", []string{"man_with_gua_pi_mao_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f472\U0001f3ff", "person with skullcap: Dark Skin Tone", []string{"man_with_gua_pi_mao_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f9af", "man with white cane: Medium-Dark Skin Tone", []string{"man_with_probing_cane_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f9af", "man with white cane: Dark Skin Tone", []string{"man_with_probing_cane_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f9af", "man with white cane: Light Skin Tone", []string{"man_with_probing_cane_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f9af", "man with white cane: Medium-Light Skin Tone", []string{"man_with_probing_cane_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f9af", "man with white cane: Medium Skin Tone", []string{"man_with_probing_cane_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fe\u200d\u2642\ufe0f", "man wearing turban: Medium-Dark Skin Tone", []string{"man_with_turban_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3ff\u200d\u2642\ufe0f", "man wearing turban: Dark Skin Tone", []string{"man_with_turban_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fb\u200d\u2642\ufe0f", "man wearing turban: Light Skin Tone", []string{"man_with_turban_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fc\u200d\u2642\ufe0f", "man wearing turban: Medium-Light Skin Tone", []string{"man_with_turban_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fd\u200d\u2642\ufe0f", "man wearing turban: Medium Skin Tone", []string{"man_with_turban_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fb", "person getting massage: Light Skin Tone", []string{"massage_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fc", "person getting massage: Medium-Light Skin Tone", []string{"massage_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fd", "person getting massage: Medium Skin Tone", []string{"massage_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fe", "person getting massage: Medium-Dark Skin Tone", []string{"massage_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3ff", "person getting massage: Dark Skin Tone", []string{"massage_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fe\u200d\u2642\ufe0f", "man getting massage: Medium-Dark Skin Tone", []string{"massage_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3ff\u200d\u2642\ufe0f", "man getting massage: Dark Skin Tone", []string{"massage_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fb\u200d\u2642\ufe0f", "man getting massage: Light Skin Tone", []string{"massage_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fc\u200d\u2642\ufe0f", "man getting massage: Medium-Light Skin Tone", []string{"massage_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fd\u200d\u2642\ufe0f", "man getting massage: Medium Skin Tone", []string{"massage_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fd\u200d\u2640\ufe0f", "woman getting massage: Medium Skin Tone", []string{"massage_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fe\u200d\u2640\ufe0f", "woman getting massage: Medium-Dark Skin Tone", []string{"massage_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3ff\u200d\u2640\ufe0f", "woman getting massage: Dark Skin Tone", []string{"massage_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fb\u200d\u2640\ufe0f", "woman getting massage: Light Skin Tone", []string{"massage_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f486\U0001f3fc\u200d\u2640\ufe0f", "woman getting massage: Medium-Light Skin Tone", []string{"massage_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f527", "mechanic: Light Skin Tone", []string{"mechanic_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f527", "mechanic: Medium-Light Skin Tone", []string{"mechanic_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f527", "mechanic: Medium Skin Tone", []string{"mechanic_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f527", "mechanic: Medium-Dark Skin Tone", []string{"mechanic_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f527", "mechanic: Dark Skin Tone", []string{"mechanic_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3ff\u200d\u2640\ufe0f", "mermaid: Dark Skin Tone", []string{"mermaid_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fb\u200d\u2640\ufe0f", "mermaid: Light Skin Tone", []string{"mermaid_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fc\u200d\u2640\ufe0f", "mermaid: Medium-Light Skin Tone", []string{"mermaid_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fd\u200d\u2640\ufe0f", "mermaid: Medium Skin Tone", []string{"mermaid_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fe\u200d\u2640\ufe0f", "mermaid: Medium-Dark Skin Tone", []string{"mermaid_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fb\u200d\u2642\ufe0f", "merman: Light Skin Tone", []string{"merman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fc\u200d\u2642\ufe0f", "merman: Medium-Light Skin Tone", []string{"merman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fd\u200d\u2642\ufe0f", "merman: Medium Skin Tone", []string{"merman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fe\u200d\u2642\ufe0f", "merman: Medium-Dark Skin Tone", []string{"merman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3ff\u200d\u2642\ufe0f", "merman: Dark Skin Tone", []string{"merman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fb", "merperson: Light Skin Tone", []string{"merperson_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fc", "merperson: Medium-Light Skin Tone", []string{"merperson_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fd", "merperson: Medium Skin Tone", []string{"merperson_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3fe", "merperson: Medium-Dark Skin Tone", []string{"merperson_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9dc\U0001f3ff", "merperson: Dark Skin Tone", []string{"merperson_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f918\U0001f3fc", "sign of the horns: Medium-Light Skin Tone", []string{"metal_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f918\U0001f3fd", "sign of the horns: Medium Skin Tone", []string{"metal_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f918\U0001f3fe", "sign of the horns: Medium-Dark Skin Tone", []string{"metal_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f918\U0001f3ff", "sign of the horns: Dark Skin Tone", []string{"metal_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f918\U0001f3fb", "sign of the horns: Light Skin Tone", []string{"metal_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f595\U0001f3fb", "middle finger: Light Skin Tone", []string{"middle_finger_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f595\U0001f3fc", "middle finger: Medium-Light Skin Tone", []string{"middle_finger_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f595\U0001f3fd", "middle finger: Medium Skin Tone", []string{"middle_finger_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f595\U0001f3fe", "middle finger: Medium-Dark Skin Tone", []string{"middle_finger_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f595\U0001f3ff", "middle finger: Dark Skin Tone", []string{"middle_finger_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fe", "person mountain biking: Medium-Dark Skin Tone", []string{"mountain_bicyclist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3ff", "person mountain biking: Dark Skin Tone", []string{"mountain_bicyclist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fb", "person mountain biking: Light Skin Tone", []string{"mountain_bicyclist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fc", "person mountain biking: Medium-Light Skin Tone", []string{"mountain_bicyclist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fd", "person mountain biking: Medium Skin Tone", []string{"mountain_bicyclist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fb\u200d\u2642\ufe0f", "man mountain biking: Light Skin Tone", []string{"mountain_biking_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fc\u200d\u2642\ufe0f", "man mountain biking: Medium-Light Skin Tone", []string{"mountain_biking_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fd\u200d\u2642\ufe0f", "man mountain biking: Medium Skin Tone", []string{"mountain_biking_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fe\u200d\u2642\ufe0f", "man mountain biking: Medium-Dark Skin Tone", []string{"mountain_biking_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3ff\u200d\u2642\ufe0f", "man mountain biking: Dark Skin Tone", []string{"mountain_biking_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fb\u200d\u2640\ufe0f", "woman mountain biking: Light Skin Tone", []string{"mountain_biking_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fc\u200d\u2640\ufe0f", "woman mountain biking: Medium-Light Skin Tone", []string{"mountain_biking_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fd\u200d\u2640\ufe0f", "woman mountain biking: Medium Skin Tone", []string{"mountain_biking_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3fe\u200d\u2640\ufe0f", "woman mountain biking: Medium-Dark Skin Tone", []string{"mountain_biking_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b5\U0001f3ff\u200d\u2640\ufe0f", "woman mountain biking: Dark Skin Tone", []string{"mountain_biking_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f936\U0001f3fb", "Mrs. Claus: Light Skin Tone", []string{"mrs_claus_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f936\U0001f3fc", "Mrs. Claus: Medium-Light Skin Tone", []string{"mrs_claus_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f936\U0001f3fd", "Mrs. Claus: Medium Skin Tone", []string{"mrs_claus_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f936\U0001f3fe", "Mrs. Claus: Medium-Dark Skin Tone", []string{"mrs_claus_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f936\U0001f3ff", "Mrs. Claus: Dark Skin Tone", []string{"mrs_claus_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f4aa\U0001f3ff", "flexed biceps: Dark Skin Tone", []string{"muscle_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f4aa\U0001f3fb", "flexed biceps: Light Skin Tone", []string{"muscle_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f4aa\U0001f3fc", "flexed biceps: Medium-Light Skin Tone", []string{"muscle_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f4aa\U0001f3fd", "flexed biceps: Medium Skin Tone", []string{"muscle_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f4aa\U0001f3fe", "flexed biceps: Medium-Dark Skin Tone", []string{"muscle_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f485\U0001f3ff", "nail polish: Dark Skin Tone", []string{"nail_care_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f485\U0001f3fb", "nail polish: Light Skin Tone", []string{"nail_care_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f485\U0001f3fc", "nail polish: Medium-Light Skin Tone", []string{"nail_care_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f485\U0001f3fd", "nail polish: Medium Skin Tone", []string{"nail_care_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f485\U0001f3fe", "nail polish: Medium-Dark Skin Tone", []string{"nail_care_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fd", "person gesturing NO: Medium Skin Tone", []string{"no_good_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fe", "person gesturing NO: Medium-Dark Skin Tone", []string{"no_good_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3ff", "person gesturing NO: Dark Skin Tone", []string{"no_good_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fb", "person gesturing NO: Light Skin Tone", []string{"no_good_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fc", "person gesturing NO: Medium-Light Skin Tone", []string{"no_good_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fd\u200d\u2642\ufe0f", "man gesturing NO: Medium Skin Tone", []string{"no_good_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fe\u200d\u2642\ufe0f", "man gesturing NO: Medium-Dark Skin Tone", []string{"no_good_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3ff\u200d\u2642\ufe0f", "man gesturing NO: Dark Skin Tone", []string{"no_good_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fb\u200d\u2642\ufe0f", "man gesturing NO: Light Skin Tone", []string{"no_good_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fc\u200d\u2642\ufe0f", "man gesturing NO: Medium-Light Skin Tone", []string{"no_good_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fb\u200d\u2640\ufe0f", "woman gesturing NO: Light Skin Tone", []string{"no_good_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fc\u200d\u2640\ufe0f", "woman gesturing NO: Medium-Light Skin Tone", []string{"no_good_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fd\u200d\u2640\ufe0f", "woman gesturing NO: Medium Skin Tone", []string{"no_good_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3fe\u200d\u2640\ufe0f", "woman gesturing NO: Medium-Dark Skin Tone", []string{"no_good_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f645\U0001f3ff\u200d\u2640\ufe0f", "woman gesturing NO: Dark Skin Tone", []string{"no_good_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f443\U0001f3fb", "nose: Light Skin Tone", []string{"nose_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f443\U0001f3fc", "nose: Medium-Light Skin Tone", []string{"nose_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f443\U0001f3fd", "nose: Medium Skin Tone", []string{"nose_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f443\U0001f3fe", "nose: Medium-Dark Skin Tone", []string{"nose_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f443\U0001f3ff", "nose: Dark Skin Tone", []string{"nose_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f4bc", "office worker: Light Skin Tone", []string{"office_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f4bc", "office worker: Medium-Light Skin Tone", []string{"office_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f4bc", "office worker: Medium Skin Tone", []string{"office_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f4bc", "office worker: Medium-Dark Skin Tone", []string{"office_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f4bc", "office worker: Dark Skin Tone", []string{"office_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44c\U0001f3fc", "OK hand: Medium-Light Skin Tone", []string{"ok_hand_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44c\U0001f3fd", "OK hand: Medium Skin Tone", []string{"ok_hand_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f44c\U0001f3fe", "OK hand: Medium-Dark Skin Tone", []string{"ok_hand_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44c\U0001f3ff", "OK hand: Dark Skin Tone", []string{"ok_hand_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44c\U0001f3fb", "OK hand: Light Skin Tone", []string{"ok_hand_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fb\u200d\u2642\ufe0f", "man gesturing OK: Light Skin Tone", []string{"ok_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fc\u200d\u2642\ufe0f", "man gesturing OK: Medium-Light Skin Tone", []string{"ok_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fd\u200d\u2642\ufe0f", "man gesturing OK: Medium Skin Tone", []string{"ok_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fe\u200d\u2642\ufe0f", "man gesturing OK: Medium-Dark Skin Tone", []string{"ok_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3ff\u200d\u2642\ufe0f", "man gesturing OK: Dark Skin Tone", []string{"ok_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fb", "person gesturing OK: Light Skin Tone", []string{"ok_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fc", "person gesturing OK: Medium-Light Skin Tone", []string{"ok_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fd", "person gesturing OK: Medium Skin Tone", []string{"ok_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fe", "person gesturing OK: Medium-Dark Skin Tone", []string{"ok_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3ff", "person gesturing OK: Dark Skin Tone", []string{"ok_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fe\u200d\u2640\ufe0f", "woman gesturing OK: Medium-Dark Skin Tone", []string{"ok_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3ff\u200d\u2640\ufe0f", "woman gesturing OK: Dark Skin Tone", []string{"ok_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fb\u200d\u2640\ufe0f", "woman gesturing OK: Light Skin Tone", []string{"ok_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fc\u200d\u2640\ufe0f", "woman gesturing OK: Medium-Light Skin Tone", []string{"ok_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f646\U0001f3fd\u200d\u2640\ufe0f", "woman gesturing OK: Medium Skin Tone", []string{"ok_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d3\U0001f3fb", "older person: Light Skin Tone", []string{"older_adult_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d3\U0001f3fc", "older person: Medium-Light Skin Tone", []string{"older_adult_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d3\U0001f3fd", "older person: Medium Skin Tone", []string{"older_adult_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d3\U0001f3fe", "older person: Medium-Dark Skin Tone", []string{"older_adult_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d3\U0001f3ff", "older person: Dark Skin Tone", []string{"older_adult_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f474\U0001f3fb", "old man: Light Skin Tone", []string{"older_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f474\U0001f3fc", "old man: Medium-Light Skin Tone", []string{"older_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f474\U0001f3fd", "old man: Medium Skin Tone", []string{"older_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f474\U0001f3fe", "old man: Medium-Dark Skin Tone", []string{"older_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f474\U0001f3ff", "old man: Dark Skin Tone", []string{"older_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f475\U0001f3fb", "old woman: Light Skin Tone", []string{"older_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f475\U0001f3fc", "old woman: Medium-Light Skin Tone", []string{"older_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f475\U0001f3fd", "old woman: Medium Skin Tone", []string{"older_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f475\U0001f3fe", "old woman: Medium-Dark Skin Tone", []string{"older_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f475\U0001f3ff", "old woman: Dark Skin Tone", []string{"older_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f450\U0001f3fb", "open hands: Light Skin Tone", []string{"open_hands_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f450\U0001f3fc", "open hands: Medium-Light Skin Tone", []string{"open_hands_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f450\U0001f3fd", "open hands: Medium Skin Tone", []string{"open_hands_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f450\U0001f3fe", "open hands: Medium-Dark Skin Tone", []string{"open_hands_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f450\U0001f3ff", "open hands: Dark Skin Tone", []string{"open_hands_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f932\U0001f3fe", "palms up together: Medium-Dark Skin Tone", []string{"palms_up_together_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f932\U0001f3ff", "palms up together: Dark Skin Tone", []string{"palms_up_together_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f932\U0001f3fb", "palms up together: Light Skin Tone", []string{"palms_up_together_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f932\U0001f3fc", "palms up together: Medium-Light Skin Tone", []string{"palms_up_together_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f932\U0001f3fd", "palms up together: Medium Skin Tone", []string{"palms_up_together_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f91d\u200d\U0001f9d1", "people holding hands: Medium Skin Tone", []string{"people_holding_hands_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f91d\u200d\U0001f9d1", "people holding hands: Medium-Dark Skin Tone", []string{"people_holding_hands_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f91d\u200d\U0001f9d1", "people holding hands: Dark Skin Tone", []string{"people_holding_hands_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f91d\u200d\U0001f9d1", "people holding hands: Light Skin Tone", []string{"people_holding_hands_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f91d\u200d\U0001f9d1", "people holding hands: Medium-Light Skin Tone", []string{"people_holding_hands_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f9b2", "person: bald: Medium Skin Tone", []string{"person_bald_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f9b2", "person: bald: Medium-Dark Skin Tone", []string{"person_bald_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f9b2", "person: bald: Dark Skin Tone", []string{"person_bald_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f9b2", "person: bald: Light Skin Tone", []string{"person_bald_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f9b2", "person: bald: Medium-Light Skin Tone", []string{"person_bald_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f9b1", "person: curly hair: Light Skin Tone", []string{"person_curly_hair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f9b1", "person: curly hair: Medium-Light Skin Tone", []string{"person_curly_hair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f9b1", "person: curly hair: Medium Skin Tone", []string{"person_curly_hair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f9b1", "person: curly hair: Medium-Dark Skin Tone", []string{"person_curly_hair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f9b1", "person: curly hair: Dark Skin Tone", []string{"person_curly_hair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f9bd", "person in manual wheelchair: Light Skin Tone", []string{"person_in_manual_wheelchair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f9bd", "person in manual wheelchair: Medium-Light Skin Tone", []string{"person_in_manual_wheelchair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f9bd", "person in manual wheelchair: Medium Skin Tone", []string{"person_in_manual_wheelchair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f9bd", "person in manual wheelchair: Medium-Dark Skin Tone", []string{"person_in_manual_wheelchair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f9bd", "person in manual wheelchair: Dark Skin Tone", []string{"person_in_manual_wheelchair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f9bc", "person in motorized wheelchair: Dark Skin Tone", []string{"person_in_motorized_wheelchair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f9bc", "person in motorized wheelchair: Light Skin Tone", []string{"person_in_motorized_wheelchair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f9bc", "person in motorized wheelchair: Medium-Light Skin Tone", []string{"person_in_motorized_wheelchair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f9bc", "person in motorized wheelchair: Medium Skin Tone", []string{"person_in_motorized_wheelchair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f9bc", "person in motorized wheelchair: Medium-Dark Skin Tone", []string{"person_in_motorized_wheelchair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f935\U0001f3fb", "person in tuxedo: Light Skin Tone", []string{"person_in_tuxedo_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f935\U0001f3fc", "person in tuxedo: Medium-Light Skin Tone", []string{"person_in_tuxedo_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f935\U0001f3fd", "person in tuxedo: Medium Skin Tone", []string{"person_in_tuxedo_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f935\U0001f3fe", "person in tuxedo: Medium-Dark Skin Tone", []string{"person_in_tuxedo_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f935\U0001f3ff", "person in tuxedo: Dark Skin Tone", []string{"person_in_tuxedo_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f9b0", "person: red hair: Medium-Light Skin Tone", []string{"person_red_hair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f9b0", "person: red hair: Medium Skin Tone", []string{"person_red_hair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f9b0", "person: red hair: Medium-Dark Skin Tone", []string{"person_red_hair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f9b0", "person: red hair: Dark Skin Tone", []string{"person_red_hair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f9b0", "person: red hair: Light Skin Tone", []string{"person_red_hair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f9b3", "person: white hair: Light Skin Tone", []string{"person_white_hair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f9b3", "person: white hair: Medium-Light Skin Tone", []string{"person_white_hair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f9b3", "person: white hair: Medium Skin Tone", []string{"person_white_hair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f9b3", "person: white hair: Medium-Dark Skin Tone", []string{"person_white_hair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f9b3", "person: white hair: Dark Skin Tone", []string{"person_white_hair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f9af", "person with white cane: Medium-Light Skin Tone", []string{"person_with_probing_cane_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f9af", "person with white cane: Medium Skin Tone", []string{"person_with_probing_cane_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f9af", "person with white cane: Medium-Dark Skin Tone", []string{"person_with_probing_cane_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f9af", "person with white cane: Dark Skin Tone", []string{"person_with_probing_cane_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f9af", "person with white cane: Light Skin Tone", []string{"person_with_probing_cane_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fb", "person wearing turban: Light Skin Tone", []string{"person_with_turban_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fc", "person wearing turban: Medium-Light Skin Tone", []string{"person_with_turban_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fd", "person wearing turban: Medium Skin Tone", []string{"person_with_turban_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fe", "person wearing turban: Medium-Dark Skin Tone", []string{"person_with_turban_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3ff", "person wearing turban: Dark Skin Tone", []string{"person_with_turban_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f470\U0001f3fc", "person with veil: Medium-Light Skin Tone", []string{"person_with_veil_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f470\U0001f3fd", "person with veil: Medium Skin Tone", []string{"person_with_veil_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f470\U0001f3fe", "person with veil: Medium-Dark Skin Tone", []string{"person_with_veil_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f470\U0001f3ff", "person with veil: Dark Skin Tone", []string{"person_with_veil_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f470\U0001f3fb", "person with veil: Light Skin Tone", []string{"person_with_veil_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\u2708\ufe0f", "pilot: Light Skin Tone", []string{"pilot_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\u2708\ufe0f", "pilot: Medium-Light Skin Tone", []string{"pilot_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\u2708\ufe0f", "pilot: Medium Skin Tone", []string{"pilot_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\u2708\ufe0f", "pilot: Medium-Dark Skin Tone", []string{"pilot_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\u2708\ufe0f", "pilot: Dark Skin Tone", []string{"pilot_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f90f\U0001f3fd", "pinching hand: Medium Skin Tone", []string{"pinching_hand_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f90f\U0001f3fe", "pinching hand: Medium-Dark Skin Tone", []string{"pinching_hand_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f90f\U0001f3ff", "pinching hand: Dark Skin Tone", []string{"pinching_hand_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f90f\U0001f3fb", "pinching hand: Light Skin Tone", []string{"pinching_hand_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f90f\U0001f3fc", "pinching hand: Medium-Light Skin Tone", []string{"pinching_hand_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f447\U0001f3ff", "backhand index pointing down: Dark Skin Tone", []string{"point_down_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f447\U0001f3fb", "backhand index pointing down: Light Skin Tone", []string{"point_down_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f447\U0001f3fc", "backhand index pointing down: Medium-Light Skin Tone", []string{"point_down_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f447\U0001f3fd", "backhand index pointing down: Medium Skin Tone", []string{"point_down_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f447\U0001f3fe", "backhand index pointing down: Medium-Dark Skin Tone", []string{"point_down_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f448\U0001f3fb", "backhand index pointing left: Light Skin Tone", []string{"point_left_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f448\U0001f3fc", "backhand index pointing left: Medium-Light Skin Tone", []string{"point_left_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f448\U0001f3fd", "backhand index pointing left: Medium Skin Tone", []string{"point_left_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f448\U0001f3fe", "backhand index pointing left: Medium-Dark Skin Tone", []string{"point_left_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f448\U0001f3ff", "backhand index pointing left: Dark Skin Tone", []string{"point_left_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f449\U0001f3fb", "backhand index pointing right: Light Skin Tone", []string{"point_right_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f449\U0001f3fc", "backhand index pointing right: Medium-Light Skin Tone", []string{"point_right_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f449\U0001f3fd", "backhand index pointing right: Medium Skin Tone", []string{"point_right_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f449\U0001f3fe", "backhand index pointing right: Medium-Dark Skin Tone", []string{"point_right_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f449\U0001f3ff", "backhand index pointing right: Dark Skin Tone", []string{"point_right_Dark_Skin_Tone"}, "12.0", false},
	{"\u261d\U0001f3fb\ufe0f", "index pointing up: Light Skin Tone", []string{"point_up_Light_Skin_Tone"}, "12.0", false},
	{"\u261d\U0001f3fc\ufe0f", "index pointing up: Medium-Light Skin Tone", []string{"point_up_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\u261d\U0001f3fd\ufe0f", "index pointing up: Medium Skin Tone", []string{"point_up_Medium_Skin_Tone"}, "12.0", false},
	{"\u261d\U0001f3fe\ufe0f", "index pointing up: Medium-Dark Skin Tone", []string{"point_up_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\u261d\U0001f3ff\ufe0f", "index pointing up: Dark Skin Tone", []string{"point_up_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f446\U0001f3fb", "backhand index pointing up: Light Skin Tone", []string{"point_up_2_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f446\U0001f3fc", "backhand index pointing up: Medium-Light Skin Tone", []string{"point_up_2_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f446\U0001f3fd", "backhand index pointing up: Medium Skin Tone", []string{"point_up_2_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f446\U0001f3fe", "backhand index pointing up: Medium-Dark Skin Tone", []string{"point_up_2_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f446\U0001f3ff", "backhand index pointing up: Dark Skin Tone", []string{"point_up_2_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fb", "police officer: Light Skin Tone", []string{"police_officer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fc", "police officer: Medium-Light Skin Tone", []string{"police_officer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fd", "police officer: Medium Skin Tone", []string{"police_officer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fe", "police officer: Medium-Dark Skin Tone", []string{"police_officer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3ff", "police officer: Dark Skin Tone", []string{"police_officer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fb\u200d\u2642\ufe0f", "man police officer: Light Skin Tone", []string{"policeman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fc\u200d\u2642\ufe0f", "man police officer: Medium-Light Skin Tone", []string{"policeman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fd\u200d\u2642\ufe0f", "man police officer: Medium Skin Tone", []string{"policeman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fe\u200d\u2642\ufe0f", "man police officer: Medium-Dark Skin Tone", []string{"policeman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3ff\u200d\u2642\ufe0f", "man police officer: Dark Skin Tone", []string{"policeman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fb\u200d\u2640\ufe0f", "woman police officer: Light Skin Tone", []string{"policewoman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fc\u200d\u2640\ufe0f", "woman police officer: Medium-Light Skin Tone", []string{"policewoman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fd\u200d\u2640\ufe0f", "woman police officer: Medium Skin Tone", []string{"policewoman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3fe\u200d\u2640\ufe0f", "woman police officer: Medium-Dark Skin Tone", []string{"policewoman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46e\U0001f3ff\u200d\u2640\ufe0f", "woman police officer: Dark Skin Tone", []string{"policewoman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fc", "person pouting: Medium-Light Skin Tone", []string{"pouting_face_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fd", "person pouting: Medium Skin Tone", []string{"pouting_face_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fe", "person pouting: Medium-Dark Skin Tone", []string{"pouting_face_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3ff", "person pouting: Dark Skin Tone", []string{"pouting_face_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fb", "person pouting: Light Skin Tone", []string{"pouting_face_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fb\u200d\u2642\ufe0f", "man pouting: Light Skin Tone", []string{"pouting_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fc\u200d\u2642\ufe0f", "man pouting: Medium-Light Skin Tone", []string{"pouting_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fd\u200d\u2642\ufe0f", "man pouting: Medium Skin Tone", []string{"pouting_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fe\u200d\u2642\ufe0f", "man pouting: Medium-Dark Skin Tone", []string{"pouting_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3ff\u200d\u2642\ufe0f", "man pouting: Dark Skin Tone", []string{"pouting_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fd\u200d\u2640\ufe0f", "woman pouting: Medium Skin Tone", []string{"pouting_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fe\u200d\u2640\ufe0f", "woman pouting: Medium-Dark Skin Tone", []string{"pouting_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3ff\u200d\u2640\ufe0f", "woman pouting: Dark Skin Tone", []string{"pouting_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fb\u200d\u2640\ufe0f", "woman pouting: Light Skin Tone", []string{"pouting_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64e\U0001f3fc\u200d\u2640\ufe0f", "woman pouting: Medium-Light Skin Tone", []string{"pouting_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64f\U0001f3fb", "folded hands: Light Skin Tone", []string{"pray_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64f\U0001f3fc", "folded hands: Medium-Light Skin Tone", []string{"pray_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64f\U0001f3fd", "folded hands: Medium Skin Tone", []string{"pray_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64f\U0001f3fe", "folded hands: Medium-Dark Skin Tone", []string{"pray_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64f\U0001f3ff", "folded hands: Dark Skin Tone", []string{"pray_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f930\U0001f3fd", "pregnant woman: Medium Skin Tone", []string{"pregnant_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f930\U0001f3fe", "pregnant woman: Medium-Dark Skin Tone", []string{"pregnant_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f930\U0001f3ff", "pregnant woman: Dark Skin Tone", []string{"pregnant_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f930\U0001f3fb", "pregnant woman: Light Skin Tone", []string{"pregnant_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f930\U0001f3fc", "pregnant woman: Medium-Light Skin Tone", []string{"pregnant_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f934\U0001f3fe", "prince: Medium-Dark Skin Tone", []string{"prince_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f934\U0001f3ff", "prince: Dark Skin Tone", []string{"prince_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f934\U0001f3fb", "prince: Light Skin Tone", []string{"prince_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f934\U0001f3fc", "prince: Medium-Light Skin Tone", []string{"prince_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f934\U0001f3fd", "prince: Medium Skin Tone", []string{"prince_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f478\U0001f3fb", "princess: Light Skin Tone", []string{"princess_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f478\U0001f3fc", "princess: Medium-Light Skin Tone", []string{"princess_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f478\U0001f3fd", "princess: Medium Skin Tone", []string{"princess_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f478\U0001f3fe", "princess: Medium-Dark Skin Tone", []string{"princess_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f478\U0001f3ff", "princess: Dark Skin Tone", []string{"princess_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91a\U0001f3fb", "raised back of hand: Light Skin Tone", []string{"raised_back_of_hand_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91a\U0001f3fc", "raised back of hand: Medium-Light Skin Tone", []string{"raised_back_of_hand_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f91a\U0001f3fd", "raised back of hand: Medium Skin Tone", []string{"raised_back_of_hand_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f91a\U0001f3fe", "raised back of hand: Medium-Dark Skin Tone", []string{"raised_back_of_hand_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f91a\U0001f3ff", "raised back of hand: Dark Skin Tone", []string{"raised_back_of_hand_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f590\U0001f3fe\ufe0f", "hand with fingers splayed: Medium-Dark Skin Tone", []string{"raised_hand_with_fingers_splayed_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f590\U0001f3ff\ufe0f", "hand with fingers splayed: Dark Skin Tone", []string{"raised_hand_with_fingers_splayed_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f590\U0001f3fb\ufe0f", "hand with fingers splayed: Light Skin Tone", []string{"raised_hand_with_fingers_splayed_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f590\U0001f3fc\ufe0f", "hand with fingers splayed: Medium-Light Skin Tone", []string{"raised_hand_with_fingers_splayed_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f590\U0001f3fd\ufe0f", "hand with fingers splayed: Medium Skin Tone", []string{"raised_hand_with_fingers_splayed_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64c\U0001f3fb", "raising hands: Light Skin Tone", []string{"raised_hands_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64c\U0001f3fc", "raising hands: Medium-Light Skin Tone", []string{"raised_hands_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64c\U0001f3fd", "raising hands: Medium Skin Tone", []string{"raised_hands_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64c\U0001f3fe", "raising hands: Medium-Dark Skin Tone", []string{"raised_hands_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64c\U0001f3ff", "raising hands: Dark Skin Tone", []string{"raised_hands_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fc", "person raising hand: Medium-Light Skin Tone", []string{"raising_hand_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fd", "person raising hand: Medium Skin Tone", []string{"raising_hand_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fe", "person raising hand: Medium-Dark Skin Tone", []string{"raising_hand_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3ff", "person raising hand: Dark Skin Tone", []string{"raising_hand_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fb", "person raising hand: Light Skin Tone", []string{"raising_hand_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3ff\u200d\u2642\ufe0f", "man raising hand: Dark Skin Tone", []string{"raising_hand_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fb\u200d\u2642\ufe0f", "man raising hand: Light Skin Tone", []string{"raising_hand_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fc\u200d\u2642\ufe0f", "man raising hand: Medium-Light Skin Tone", []string{"raising_hand_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fd\u200d\u2642\ufe0f", "man raising hand: Medium Skin Tone", []string{"raising_hand_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fe\u200d\u2642\ufe0f", "man raising hand: Medium-Dark Skin Tone", []string{"raising_hand_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fe\u200d\u2640\ufe0f", "woman raising hand: Medium-Dark Skin Tone", []string{"raising_hand_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3ff\u200d\u2640\ufe0f", "woman raising hand: Dark Skin Tone", []string{"raising_hand_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fb\u200d\u2640\ufe0f", "woman raising hand: Light Skin Tone", []string{"raising_hand_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fc\u200d\u2640\ufe0f", "woman raising hand: Medium-Light Skin Tone", []string{"raising_hand_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f64b\U0001f3fd\u200d\u2640\ufe0f", "woman raising hand: Medium Skin Tone", []string{"raising_hand_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f9b0", "man: red hair: Medium-Light Skin Tone", []string{"red_haired_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f9b0", "man: red hair: Medium Skin Tone", []string{"red_haired_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f9b0", "man: red hair: Medium-Dark Skin Tone", []string{"red_haired_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f9b0", "man: red hair: Dark Skin Tone", []string{"red_haired_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f9b0", "man: red hair: Light Skin Tone", []string{"red_haired_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f9b0", "woman: red hair: Light Skin Tone", []string{"red_haired_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f9b0", "woman: red hair: Medium-Light Skin Tone", []string{"red_haired_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f9b0", "woman: red hair: Medium Skin Tone", []string{"red_haired_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f9b0", "woman: red hair: Medium-Dark Skin Tone", []string{"red_haired_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f9b0", "woman: red hair: Dark Skin Tone", []string{"red_haired_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fb", "person rowing boat: Light Skin Tone", []string{"rowboat_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fc", "person rowing boat: Medium-Light Skin Tone", []string{"rowboat_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fd", "person rowing boat: Medium Skin Tone", []string{"rowboat_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fe", "person rowing boat: Medium-Dark Skin Tone", []string{"rowboat_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3ff", "person rowing boat: Dark Skin Tone", []string{"rowboat_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fb\u200d\u2642\ufe0f", "man rowing boat: Light Skin Tone", []string{"rowing_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fc\u200d\u2642\ufe0f", "man rowing boat: Medium-Light Skin Tone", []string{"rowing_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fd\u200d\u2642\ufe0f", "man rowing boat: Medium Skin Tone", []string{"rowing_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fe\u200d\u2642\ufe0f", "man rowing boat: Medium-Dark Skin Tone", []string{"rowing_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3ff\u200d\u2642\ufe0f", "man rowing boat: Dark Skin Tone", []string{"rowing_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fb\u200d\u2640\ufe0f", "woman rowing boat: Light Skin Tone", []string{"rowing_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fc\u200d\u2640\ufe0f", "woman rowing boat: Medium-Light Skin Tone", []string{"rowing_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fd\u200d\u2640\ufe0f", "woman rowing boat: Medium Skin Tone", []string{"rowing_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3fe\u200d\u2640\ufe0f", "woman rowing boat: Medium-Dark Skin Tone", []string{"rowing_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6a3\U0001f3ff\u200d\u2640\ufe0f", "woman rowing boat: Dark Skin Tone", []string{"rowing_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fb", "person running: Light Skin Tone", []string{"runner_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fc", "person running: Medium-Light Skin Tone", []string{"runner_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fd", "person running: Medium Skin Tone", []string{"runner_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fe", "person running: Medium-Dark Skin Tone", []string{"runner_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3ff", "person running: Dark Skin Tone", []string{"runner_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fb\u200d\u2642\ufe0f", "man running: Light Skin Tone", []string{"running_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fc\u200d\u2642\ufe0f", "man running: Medium-Light Skin Tone", []string{"running_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fd\u200d\u2642\ufe0f", "man running: Medium Skin Tone", []string{"running_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fe\u200d\u2642\ufe0f", "man running: Medium-Dark Skin Tone", []string{"running_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3ff\u200d\u2642\ufe0f", "man running: Dark Skin Tone", []string{"running_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fb\u200d\u2640\ufe0f", "woman running: Light Skin Tone", []string{"running_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fc\u200d\u2640\ufe0f", "woman running: Medium-Light Skin Tone", []string{"running_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fd\u200d\u2640\ufe0f", "woman running: Medium Skin Tone", []string{"running_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3fe\u200d\u2640\ufe0f", "woman running: Medium-Dark Skin Tone", []string{"running_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c3\U0001f3ff\u200d\u2640\ufe0f", "woman running: Dark Skin Tone", []string{"running_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f385\U0001f3fd", "Santa Claus: Medium Skin Tone", []string{"santa_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f385\U0001f3fe", "Santa Claus: Medium-Dark Skin Tone", []string{"santa_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f385\U0001f3ff", "Santa Claus: Dark Skin Tone", []string{"santa_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f385\U0001f3fb", "Santa Claus: Light Skin Tone", []string{"santa_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f385\U0001f3fc", "Santa Claus: Medium-Light Skin Tone", []string{"santa_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fb\u200d\u2642\ufe0f", "man in steamy room: Light Skin Tone", []string{"sauna_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fc\u200d\u2642\ufe0f", "man in steamy room: Medium-Light Skin Tone", []string{"sauna_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fd\u200d\u2642\ufe0f", "man in steamy room: Medium Skin Tone", []string{"sauna_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fe\u200d\u2642\ufe0f", "man in steamy room: Medium-Dark Skin Tone", []string{"sauna_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3ff\u200d\u2642\ufe0f", "man in steamy room: Dark Skin Tone", []string{"sauna_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fb", "person in steamy room: Light Skin Tone", []string{"sauna_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fc", "person in steamy room: Medium-Light Skin Tone", []string{"sauna_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fd", "person in steamy room: Medium Skin Tone", []string{"sauna_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fe", "person in steamy room: Medium-Dark Skin Tone", []string{"sauna_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3ff", "person in steamy room: Dark Skin Tone", []string{"sauna_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fb\u200d\u2640\ufe0f", "woman in steamy room: Light Skin Tone", []string{"sauna_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fc\u200d\u2640\ufe0f", "woman in steamy room: Medium-Light Skin Tone", []string{"sauna_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fd\u200d\u2640\ufe0f", "woman in steamy room: Medium Skin Tone", []string{"sauna_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3fe\u200d\u2640\ufe0f", "woman in steamy room: Medium-Dark Skin Tone", []string{"sauna_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d6\U0001f3ff\u200d\u2640\ufe0f", "woman in steamy room: Dark Skin Tone", []string{"sauna_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f52c", "scientist: Medium-Light Skin Tone", []string{"scientist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f52c", "scientist: Medium Skin Tone", []string{"scientist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f52c", "scientist: Medium-Dark Skin Tone", []string{"scientist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f52c", "scientist: Dark Skin Tone", []string{"scientist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f52c", "scientist: Light Skin Tone", []string{"scientist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f933\U0001f3fc", "selfie: Medium-Light Skin Tone", []string{"selfie_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f933\U0001f3fd", "selfie: Medium Skin Tone", []string{"selfie_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f933\U0001f3fe", "selfie: Medium-Dark Skin Tone", []string{"selfie_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f933\U0001f3ff", "selfie: Dark Skin Tone", []string{"selfie_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f933\U0001f3fb", "selfie: Light Skin Tone", []string{"selfie_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fe", "person shrugging: Medium-Dark Skin Tone", []string{"shrug_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3ff", "person shrugging: Dark Skin Tone", []string{"shrug_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fb", "person shrugging: Light Skin Tone", []string{"shrug_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fc", "person shrugging: Medium-Light Skin Tone", []string{"shrug_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fd", "person shrugging: Medium Skin Tone", []string{"shrug_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f3a4", "singer: Light Skin Tone", []string{"singer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f3a4", "singer: Medium-Light Skin Tone", []string{"singer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f3a4", "singer: Medium Skin Tone", []string{"singer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f3a4", "singer: Medium-Dark Skin Tone", []string{"singer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f3a4", "singer: Dark Skin Tone", []string{"singer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6cc\U0001f3fc", "person in bed: Medium-Light Skin Tone", []string{"sleeping_bed_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6cc\U0001f3fd", "person in bed: Medium Skin Tone", []string{"sleeping_bed_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6cc\U0001f3fe", "person in bed: Medium-Dark Skin Tone", []string{"sleeping_bed_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6cc\U0001f3ff", "person in bed: Dark Skin Tone", []string{"sleeping_bed_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6cc\U0001f3fb", "person in bed: Light Skin Tone", []string{"sleeping_bed_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c2\U0001f3ff", "snowboarder: Dark Skin Tone", []string{"snowboarder_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c2\U0001f3fb", "snowboarder: Light Skin Tone", []string{"snowboarder_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c2\U0001f3fc", "snowboarder: Medium-Light Skin Tone", []string{"snowboarder_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c2\U0001f3fd", "snowboarder: Medium Skin Tone", []string{"snowboarder_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3c2\U0001f3fe", "snowboarder: Medium-Dark Skin Tone", []string{"snowboarder_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fb\u200d\u2642\ufe0f", "man standing: Light Skin Tone", []string{"standing_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fc\u200d\u2642\ufe0f", "man standing: Medium-Light Skin Tone", []string{"standing_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fd\u200d\u2642\ufe0f", "man standing: Medium Skin Tone", []string{"standing_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fe\u200d\u2642\ufe0f", "man standing: Medium-Dark Skin Tone", []string{"standing_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3ff\u200d\u2642\ufe0f", "man standing: Dark Skin Tone", []string{"standing_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fd", "person standing: Medium Skin Tone", []string{"standing_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fe", "person standing: Medium-Dark Skin Tone", []string{"standing_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3ff", "person standing: Dark Skin Tone", []string{"standing_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fb", "person standing: Light Skin Tone", []string{"standing_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fc", "person standing: Medium-Light Skin Tone", []string{"standing_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fb\u200d\u2640\ufe0f", "woman standing: Light Skin Tone", []string{"standing_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fc\u200d\u2640\ufe0f", "woman standing: Medium-Light Skin Tone", []string{"standing_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fd\u200d\u2640\ufe0f", "woman standing: Medium Skin Tone", []string{"standing_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3fe\u200d\u2640\ufe0f", "woman standing: Medium-Dark Skin Tone", []string{"standing_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9cd\U0001f3ff\u200d\u2640\ufe0f", "woman standing: Dark Skin Tone", []string{"standing_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f393", "student: Medium Skin Tone", []string{"student_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f393", "student: Medium-Dark Skin Tone", []string{"student_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f393", "student: Dark Skin Tone", []string{"student_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f393", "student: Light Skin Tone", []string{"student_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f393", "student: Medium-Light Skin Tone", []string{"student_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fb", "superhero: Light Skin Tone", []string{"superhero_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fc", "superhero: Medium-Light Skin Tone", []string{"superhero_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fd", "superhero: Medium Skin Tone", []string{"superhero_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fe", "superhero: Medium-Dark Skin Tone", []string{"superhero_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3ff", "superhero: Dark Skin Tone", []string{"superhero_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fb\u200d\u2642\ufe0f", "man superhero: Light Skin Tone", []string{"superhero_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fc\u200d\u2642\ufe0f", "man superhero: Medium-Light Skin Tone", []string{"superhero_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fd\u200d\u2642\ufe0f", "man superhero: Medium Skin Tone", []string{"superhero_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fe\u200d\u2642\ufe0f", "man superhero: Medium-Dark Skin Tone", []string{"superhero_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3ff\u200d\u2642\ufe0f", "man superhero: Dark Skin Tone", []string{"superhero_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3ff\u200d\u2640\ufe0f", "woman superhero: Dark Skin Tone", []string{"superhero_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fb\u200d\u2640\ufe0f", "woman superhero: Light Skin Tone", []string{"superhero_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fc\u200d\u2640\ufe0f", "woman superhero: Medium-Light Skin Tone", []string{"superhero_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fd\u200d\u2640\ufe0f", "woman superhero: Medium Skin Tone", []string{"superhero_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9b8\U0001f3fe\u200d\u2640\ufe0f", "woman superhero: Medium-Dark Skin Tone", []string{"superhero_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fe", "supervillain: Medium-Dark Skin Tone", []string{"supervillain_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3ff", "supervillain: Dark Skin Tone", []string{"supervillain_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fb", "supervillain: Light Skin Tone", []string{"supervillain_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fc", "supervillain: Medium-Light Skin Tone", []string{"supervillain_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fd", "supervillain: Medium Skin Tone", []string{"supervillain_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3ff\u200d\u2642\ufe0f", "man supervillain: Dark Skin Tone", []string{"supervillain_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fb\u200d\u2642\ufe0f", "man supervillain: Light Skin Tone", []string{"supervillain_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fc\u200d\u2642\ufe0f", "man supervillain: Medium-Light Skin Tone", []string{"supervillain_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fd\u200d\u2642\ufe0f", "man supervillain: Medium Skin Tone", []string{"supervillain_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fe\u200d\u2642\ufe0f", "man supervillain: Medium-Dark Skin Tone", []string{"supervillain_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fd\u200d\u2640\ufe0f", "woman supervillain: Medium Skin Tone", []string{"supervillain_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fe\u200d\u2640\ufe0f", "woman supervillain: Medium-Dark Skin Tone", []string{"supervillain_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3ff\u200d\u2640\ufe0f", "woman supervillain: Dark Skin Tone", []string{"supervillain_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fb\u200d\u2640\ufe0f", "woman supervillain: Light Skin Tone", []string{"supervillain_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9b9\U0001f3fc\u200d\u2640\ufe0f", "woman supervillain: Medium-Light Skin Tone", []string{"supervillain_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fc", "person surfing: Medium-Light Skin Tone", []string{"surfer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fd", "person surfing: Medium Skin Tone", []string{"surfer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fe", "person surfing: Medium-Dark Skin Tone", []string{"surfer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3ff", "person surfing: Dark Skin Tone", []string{"surfer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fb", "person surfing: Light Skin Tone", []string{"surfer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fb\u200d\u2642\ufe0f", "man surfing: Light Skin Tone", []string{"surfing_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fc\u200d\u2642\ufe0f", "man surfing: Medium-Light Skin Tone", []string{"surfing_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fd\u200d\u2642\ufe0f", "man surfing: Medium Skin Tone", []string{"surfing_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fe\u200d\u2642\ufe0f", "man surfing: Medium-Dark Skin Tone", []string{"surfing_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3ff\u200d\u2642\ufe0f", "man surfing: Dark Skin Tone", []string{"surfing_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fb\u200d\u2640\ufe0f", "woman surfing: Light Skin Tone", []string{"surfing_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fc\u200d\u2640\ufe0f", "woman surfing: Medium-Light Skin Tone", []string{"surfing_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fd\u200d\u2640\ufe0f", "woman surfing: Medium Skin Tone", []string{"surfing_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3fe\u200d\u2640\ufe0f", "woman surfing: Medium-Dark Skin Tone", []string{"surfing_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3c4\U0001f3ff\u200d\u2640\ufe0f", "woman surfing: Dark Skin Tone", []string{"surfing_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3ff", "person swimming: Dark Skin Tone", []string{"swimmer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fb", "person swimming: Light Skin Tone", []string{"swimmer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fc", "person swimming: Medium-Light Skin Tone", []string{"swimmer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fd", "person swimming: Medium Skin Tone", []string{"swimmer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fe", "person swimming: Medium-Dark Skin Tone", []string{"swimmer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fb\u200d\u2642\ufe0f", "man swimming: Light Skin Tone", []string{"swimming_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fc\u200d\u2642\ufe0f", "man swimming: Medium-Light Skin Tone", []string{"swimming_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fd\u200d\u2642\ufe0f", "man swimming: Medium Skin Tone", []string{"swimming_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fe\u200d\u2642\ufe0f", "man swimming: Medium-Dark Skin Tone", []string{"swimming_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3ff\u200d\u2642\ufe0f", "man swimming: Dark Skin Tone", []string{"swimming_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fc\u200d\u2640\ufe0f", "woman swimming: Medium-Light Skin Tone", []string{"swimming_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fd\u200d\u2640\ufe0f", "woman swimming: Medium Skin Tone", []string{"swimming_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fe\u200d\u2640\ufe0f", "woman swimming: Medium-Dark Skin Tone", []string{"swimming_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3ff\u200d\u2640\ufe0f", "woman swimming: Dark Skin Tone", []string{"swimming_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3ca\U0001f3fb\u200d\u2640\ufe0f", "woman swimming: Light Skin Tone", []string{"swimming_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f3eb", "teacher: Medium-Light Skin Tone", []string{"teacher_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f3eb", "teacher: Medium Skin Tone", []string{"teacher_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f3eb", "teacher: Medium-Dark Skin Tone", []string{"teacher_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f3eb", "teacher: Dark Skin Tone", []string{"teacher_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f3eb", "teacher: Light Skin Tone", []string{"teacher_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fb\u200d\U0001f4bb", "technologist: Light Skin Tone", []string{"technologist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fc\u200d\U0001f4bb", "technologist: Medium-Light Skin Tone", []string{"technologist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fd\u200d\U0001f4bb", "technologist: Medium Skin Tone", []string{"technologist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3fe\u200d\U0001f4bb", "technologist: Medium-Dark Skin Tone", []string{"technologist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d1\U0001f3ff\u200d\U0001f4bb", "technologist: Dark Skin Tone", []string{"technologist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3ff\u200d\u2642\ufe0f", "man tipping hand: Dark Skin Tone", []string{"tipping_hand_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fb\u200d\u2642\ufe0f", "man tipping hand: Light Skin Tone", []string{"tipping_hand_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fc\u200d\u2642\ufe0f", "man tipping hand: Medium-Light Skin Tone", []string{"tipping_hand_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fd\u200d\u2642\ufe0f", "man tipping hand: Medium Skin Tone", []string{"tipping_hand_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fe\u200d\u2642\ufe0f", "man tipping hand: Medium-Dark Skin Tone", []string{"tipping_hand_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fb", "person tipping hand: Light Skin Tone", []string{"tipping_hand_person_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fc", "person tipping hand: Medium-Light Skin Tone", []string{"tipping_hand_person_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fd", "person tipping hand: Medium Skin Tone", []string{"tipping_hand_person_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fe", "person tipping hand: Medium-Dark Skin Tone", []string{"tipping_hand_person_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3ff", "person tipping hand: Dark Skin Tone", []string{"tipping_hand_person_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fd\u200d\u2640\ufe0f", "woman tipping hand: Medium Skin Tone", []string{"tipping_hand_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fe\u200d\u2640\ufe0f", "woman tipping hand: Medium-Dark Skin Tone", []string{"tipping_hand_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3ff\u200d\u2640\ufe0f", "woman tipping hand: Dark Skin Tone", []string{"tipping_hand_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fb\u200d\u2640\ufe0f", "woman tipping hand: Light Skin Tone", []string{"tipping_hand_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f481\U0001f3fc\u200d\u2640\ufe0f", "woman tipping hand: Medium-Light Skin Tone", []string{"tipping_hand_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46c\U0001f3fb", "men holding hands: Light Skin Tone", []string{"two_men_holding_hands_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46c\U0001f3fc", "men holding hands: Medium-Light Skin Tone", []string{"two_men_holding_hands_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46c\U0001f3fd", "men holding hands: Medium Skin Tone", []string{"two_men_holding_hands_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f46c\U0001f3fe", "men holding hands: Medium-Dark Skin Tone", []string{"two_men_holding_hands_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46c\U0001f3ff", "men holding hands: Dark Skin Tone", []string{"two_men_holding_hands_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46d\U0001f3fb", "women holding hands: Light Skin Tone", []string{"two_women_holding_hands_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46d\U0001f3fc", "women holding hands: Medium-Light Skin Tone", []string{"two_women_holding_hands_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f46d\U0001f3fd", "women holding hands: Medium Skin Tone", []string{"two_women_holding_hands_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f46d\U0001f3fe", "women holding hands: Medium-Dark Skin Tone", []string{"two_women_holding_hands_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f46d\U0001f3ff", "women holding hands: Dark Skin Tone", []string{"two_women_holding_hands_Dark_Skin_Tone"}, "12.0", false},
	{"\u270c\U0001f3fb\ufe0f", "victory hand: Light Skin Tone", []string{"v_Light_Skin_Tone"}, "12.0", false},
	{"\u270c\U0001f3fc\ufe0f", "victory hand: Medium-Light Skin Tone", []string{"v_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\u270c\U0001f3fd\ufe0f", "victory hand: Medium Skin Tone", []string{"v_Medium_Skin_Tone"}, "12.0", false},
	{"\u270c\U0001f3fe\ufe0f", "victory hand: Medium-Dark Skin Tone", []string{"v_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\u270c\U0001f3ff\ufe0f", "victory hand: Dark Skin Tone", []string{"v_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fb", "vampire: Light Skin Tone", []string{"vampire_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fc", "vampire: Medium-Light Skin Tone", []string{"vampire_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fd", "vampire: Medium Skin Tone", []string{"vampire_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fe", "vampire: Medium-Dark Skin Tone", []string{"vampire_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3ff", "vampire: Dark Skin Tone", []string{"vampire_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fb\u200d\u2642\ufe0f", "man vampire: Light Skin Tone", []string{"vampire_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fc\u200d\u2642\ufe0f", "man vampire: Medium-Light Skin Tone", []string{"vampire_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fd\u200d\u2642\ufe0f", "man vampire: Medium Skin Tone", []string{"vampire_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fe\u200d\u2642\ufe0f", "man vampire: Medium-Dark Skin Tone", []string{"vampire_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3ff\u200d\u2642\ufe0f", "man vampire: Dark Skin Tone", []string{"vampire_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fd\u200d\u2640\ufe0f", "woman vampire: Medium Skin Tone", []string{"vampire_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fe\u200d\u2640\ufe0f", "woman vampire: Medium-Dark Skin Tone", []string{"vampire_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3ff\u200d\u2640\ufe0f", "woman vampire: Dark Skin Tone", []string{"vampire_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fb\u200d\u2640\ufe0f", "woman vampire: Light Skin Tone", []string{"vampire_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9db\U0001f3fc\u200d\u2640\ufe0f", "woman vampire: Medium-Light Skin Tone", []string{"vampire_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f596\U0001f3fb", "vulcan salute: Light Skin Tone", []string{"vulcan_salute_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f596\U0001f3fc", "vulcan salute: Medium-Light Skin Tone", []string{"vulcan_salute_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f596\U0001f3fd", "vulcan salute: Medium Skin Tone", []string{"vulcan_salute_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f596\U0001f3fe", "vulcan salute: Medium-Dark Skin Tone", []string{"vulcan_salute_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f596\U0001f3ff", "vulcan salute: Dark Skin Tone", []string{"vulcan_salute_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fb", "person walking: Light Skin Tone", []string{"walking_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fc", "person walking: Medium-Light Skin Tone", []string{"walking_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fd", "person walking: Medium Skin Tone", []string{"walking_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fe", "person walking: Medium-Dark Skin Tone", []string{"walking_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3ff", "person walking: Dark Skin Tone", []string{"walking_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fb\u200d\u2642\ufe0f", "man walking: Light Skin Tone", []string{"walking_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fc\u200d\u2642\ufe0f", "man walking: Medium-Light Skin Tone", []string{"walking_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fd\u200d\u2642\ufe0f", "man walking: Medium Skin Tone", []string{"walking_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fe\u200d\u2642\ufe0f", "man walking: Medium-Dark Skin Tone", []string{"walking_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3ff\u200d\u2642\ufe0f", "man walking: Dark Skin Tone", []string{"walking_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fb\u200d\u2640\ufe0f", "woman walking: Light Skin Tone", []string{"walking_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fc\u200d\u2640\ufe0f", "woman walking: Medium-Light Skin Tone", []string{"walking_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fd\u200d\u2640\ufe0f", "woman walking: Medium Skin Tone", []string{"walking_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3fe\u200d\u2640\ufe0f", "woman walking: Medium-Dark Skin Tone", []string{"walking_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f6b6\U0001f3ff\u200d\u2640\ufe0f", "woman walking: Dark Skin Tone", []string{"walking_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fd", "person playing water polo: Medium Skin Tone", []string{"water_polo_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fe", "person playing water polo: Medium-Dark Skin Tone", []string{"water_polo_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3ff", "person playing water polo: Dark Skin Tone", []string{"water_polo_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fb", "person playing water polo: Light Skin Tone", []string{"water_polo_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fc", "person playing water polo: Medium-Light Skin Tone", []string{"water_polo_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44b\U0001f3fc", "waving hand: Medium-Light Skin Tone", []string{"wave_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f44b\U0001f3fd", "waving hand: Medium Skin Tone", []string{"wave_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f44b\U0001f3fe", "waving hand: Medium-Dark Skin Tone", []string{"wave_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44b\U0001f3ff", "waving hand: Dark Skin Tone", []string{"wave_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f44b\U0001f3fb", "waving hand: Light Skin Tone", []string{"wave_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fb\ufe0f", "person lifting weights: Light Skin Tone", []string{"weight_lifting_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fc\ufe0f", "person lifting weights: Medium-Light Skin Tone", []string{"weight_lifting_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fd\ufe0f", "person lifting weights: Medium Skin Tone", []string{"weight_lifting_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fe\ufe0f", "person lifting weights: Medium-Dark Skin Tone", []string{"weight_lifting_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3ff\ufe0f", "person lifting weights: Dark Skin Tone", []string{"weight_lifting_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fb\ufe0f\u200d\u2642\ufe0f", "man lifting weights: Light Skin Tone", []string{"weight_lifting_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fc\ufe0f\u200d\u2642\ufe0f", "man lifting weights: Medium-Light Skin Tone", []string{"weight_lifting_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fd\ufe0f\u200d\u2642\ufe0f", "man lifting weights: Medium Skin Tone", []string{"weight_lifting_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fe\ufe0f\u200d\u2642\ufe0f", "man lifting weights: Medium-Dark Skin Tone", []string{"weight_lifting_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3ff\ufe0f\u200d\u2642\ufe0f", "man lifting weights: Dark Skin Tone", []string{"weight_lifting_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3ff\ufe0f\u200d\u2640\ufe0f", "woman lifting weights: Dark Skin Tone", []string{"weight_lifting_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fb\ufe0f\u200d\u2640\ufe0f", "woman lifting weights: Light Skin Tone", []string{"weight_lifting_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fc\ufe0f\u200d\u2640\ufe0f", "woman lifting weights: Medium-Light Skin Tone", []string{"weight_lifting_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fd\ufe0f\u200d\u2640\ufe0f", "woman lifting weights: Medium Skin Tone", []string{"weight_lifting_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f3cb\U0001f3fe\ufe0f\u200d\u2640\ufe0f", "woman lifting weights: Medium-Dark Skin Tone", []string{"weight_lifting_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fb\u200d\U0001f9b3", "man: white hair: Light Skin Tone", []string{"white_haired_man_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fc\u200d\U0001f9b3", "man: white hair: Medium-Light Skin Tone", []string{"white_haired_man_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fd\u200d\U0001f9b3", "man: white hair: Medium Skin Tone", []string{"white_haired_man_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3fe\u200d\U0001f9b3", "man: white hair: Medium-Dark Skin Tone", []string{"white_haired_man_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f468\U0001f3ff\u200d\U0001f9b3", "man: white hair: Dark Skin Tone", []string{"white_haired_man_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f9b3", "woman: white hair: Medium-Dark Skin Tone", []string{"white_haired_woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f9b3", "woman: white hair: Dark Skin Tone", []string{"white_haired_woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f9b3", "woman: white hair: Light Skin Tone", []string{"white_haired_woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f9b3", "woman: white hair: Medium-Light Skin Tone", []string{"white_haired_woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f9b3", "woman: white hair: Medium Skin Tone", []string{"white_haired_woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb", "woman: Light Skin Tone", []string{"woman_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc", "woman: Medium-Light Skin Tone", []string{"woman_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd", "woman: Medium Skin Tone", []string{"woman_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe", "woman: Medium-Dark Skin Tone", []string{"woman_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff", "woman: Dark Skin Tone", []string{"woman_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f3a8", "woman artist: Light Skin Tone", []string{"woman_artist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f3a8", "woman artist: Medium-Light Skin Tone", []string{"woman_artist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f3a8", "woman artist: Medium Skin Tone", []string{"woman_artist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f3a8", "woman artist: Medium-Dark Skin Tone", []string{"woman_artist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f3a8", "woman artist: Dark Skin Tone", []string{"woman_artist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f680", "woman astronaut: Light Skin Tone", []string{"woman_astronaut_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f680", "woman astronaut: Medium-Light Skin Tone", []string{"woman_astronaut_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f680", "woman astronaut: Medium Skin Tone", []string{"woman_astronaut_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f680", "woman astronaut: Medium-Dark Skin Tone", []string{"woman_astronaut_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f680", "woman astronaut: Dark Skin Tone", []string{"woman_astronaut_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fb\u200d\u2640\ufe0f", "woman cartwheeling: Light Skin Tone", []string{"woman_cartwheeling_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fc\u200d\u2640\ufe0f", "woman cartwheeling: Medium-Light Skin Tone", []string{"woman_cartwheeling_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fd\u200d\u2640\ufe0f", "woman cartwheeling: Medium Skin Tone", []string{"woman_cartwheeling_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3fe\u200d\u2640\ufe0f", "woman cartwheeling: Medium-Dark Skin Tone", []string{"woman_cartwheeling_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f938\U0001f3ff\u200d\u2640\ufe0f", "woman cartwheeling: Dark Skin Tone", []string{"woman_cartwheeling_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f373", "woman cook: Medium-Light Skin Tone", []string{"woman_cook_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f373", "woman cook: Medium Skin Tone", []string{"woman_cook_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f373", "woman cook: Medium-Dark Skin Tone", []string{"woman_cook_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f373", "woman cook: Dark Skin Tone", []string{"woman_cook_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f373", "woman cook: Light Skin Tone", []string{"woman_cook_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f483\U0001f3fd", "woman dancing: Medium Skin Tone", []string{"woman_dancing_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f483\U0001f3fe", "woman dancing: Medium-Dark Skin Tone", []string{"woman_dancing_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f483\U0001f3ff", "woman dancing: Dark Skin Tone", []string{"woman_dancing_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f483\U0001f3fb", "woman dancing: Light Skin Tone", []string{"woman_dancing_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f483\U0001f3fc", "woman dancing: Medium-Light Skin Tone", []string{"woman_dancing_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fb\u200d\u2640\ufe0f", "woman facepalming: Light Skin Tone", []string{"woman_facepalming_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fc\u200d\u2640\ufe0f", "woman facepalming: Medium-Light Skin Tone", []string{"woman_facepalming_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fd\u200d\u2640\ufe0f", "woman facepalming: Medium Skin Tone", []string{"woman_facepalming_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3fe\u200d\u2640\ufe0f", "woman facepalming: Medium-Dark Skin Tone", []string{"woman_facepalming_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f926\U0001f3ff\u200d\u2640\ufe0f", "woman facepalming: Dark Skin Tone", []string{"woman_facepalming_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f3ed", "woman factory worker: Light Skin Tone", []string{"woman_factory_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f3ed", "woman factory worker: Medium-Light Skin Tone", []string{"woman_factory_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f3ed", "woman factory worker: Medium Skin Tone", []string{"woman_factory_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f3ed", "woman factory worker: Medium-Dark Skin Tone", []string{"woman_factory_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f3ed", "woman factory worker: Dark Skin Tone", []string{"woman_factory_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f33e", "woman farmer: Light Skin Tone", []string{"woman_farmer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f33e", "woman farmer: Medium-Light Skin Tone", []string{"woman_farmer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f33e", "woman farmer: Medium Skin Tone", []string{"woman_farmer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f33e", "woman farmer: Medium-Dark Skin Tone", []string{"woman_farmer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f33e", "woman farmer: Dark Skin Tone", []string{"woman_farmer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f692", "woman firefighter: Medium-Light Skin Tone", []string{"woman_firefighter_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f692", "woman firefighter: Medium Skin Tone", []string{"woman_firefighter_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f692", "woman firefighter: Medium-Dark Skin Tone", []string{"woman_firefighter_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f692", "woman firefighter: Dark Skin Tone", []string{"woman_firefighter_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f692", "woman firefighter: Light Skin Tone", []string{"woman_firefighter_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\u2695\ufe0f", "woman health worker: Light Skin Tone", []string{"woman_health_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\u2695\ufe0f", "woman health worker: Medium-Light Skin Tone", []string{"woman_health_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\u2695\ufe0f", "woman health worker: Medium Skin Tone", []string{"woman_health_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\u2695\ufe0f", "woman health worker: Medium-Dark Skin Tone", []string{"woman_health_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\u2695\ufe0f", "woman health worker: Dark Skin Tone", []string{"woman_health_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f9bd", "woman in manual wheelchair: Light Skin Tone", []string{"woman_in_manual_wheelchair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f9bd", "woman in manual wheelchair: Medium-Light Skin Tone", []string{"woman_in_manual_wheelchair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f9bd", "woman in manual wheelchair: Medium Skin Tone", []string{"woman_in_manual_wheelchair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f9bd", "woman in manual wheelchair: Medium-Dark Skin Tone", []string{"woman_in_manual_wheelchair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f9bd", "woman in manual wheelchair: Dark Skin Tone", []string{"woman_in_manual_wheelchair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f9bc", "woman in motorized wheelchair: Medium-Dark Skin Tone", []string{"woman_in_motorized_wheelchair_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f9bc", "woman in motorized wheelchair: Dark Skin Tone", []string{"woman_in_motorized_wheelchair_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f9bc", "woman in motorized wheelchair: Light Skin Tone", []string{"woman_in_motorized_wheelchair_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f9bc", "woman in motorized wheelchair: Medium-Light Skin Tone", []string{"woman_in_motorized_wheelchair_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f9bc", "woman in motorized wheelchair: Medium Skin Tone", []string{"woman_in_motorized_wheelchair_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\u2696\ufe0f", "woman judge: Light Skin Tone", []string{"woman_judge_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\u2696\ufe0f", "woman judge: Medium-Light Skin Tone", []string{"woman_judge_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\u2696\ufe0f", "woman judge: Medium Skin Tone", []string{"woman_judge_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\u2696\ufe0f", "woman judge: Medium-Dark Skin Tone", []string{"woman_judge_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\u2696\ufe0f", "woman judge: Dark Skin Tone", []string{"woman_judge_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fb\u200d\u2640\ufe0f", "woman juggling: Light Skin Tone", []string{"woman_juggling_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fc\u200d\u2640\ufe0f", "woman juggling: Medium-Light Skin Tone", []string{"woman_juggling_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fd\u200d\u2640\ufe0f", "woman juggling: Medium Skin Tone", []string{"woman_juggling_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3fe\u200d\u2640\ufe0f", "woman juggling: Medium-Dark Skin Tone", []string{"woman_juggling_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f939\U0001f3ff\u200d\u2640\ufe0f", "woman juggling: Dark Skin Tone", []string{"woman_juggling_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f527", "woman mechanic: Light Skin Tone", []string{"woman_mechanic_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f527", "woman mechanic: Medium-Light Skin Tone", []string{"woman_mechanic_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f527", "woman mechanic: Medium Skin Tone", []string{"woman_mechanic_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f527", "woman mechanic: Medium-Dark Skin Tone", []string{"woman_mechanic_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f527", "woman mechanic: Dark Skin Tone", []string{"woman_mechanic_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f4bc", "woman office worker: Light Skin Tone", []string{"woman_office_worker_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f4bc", "woman office worker: Medium-Light Skin Tone", []string{"woman_office_worker_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f4bc", "woman office worker: Medium Skin Tone", []string{"woman_office_worker_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f4bc", "woman office worker: Medium-Dark Skin Tone", []string{"woman_office_worker_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f4bc", "woman office worker: Dark Skin Tone", []string{"woman_office_worker_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\u2708\ufe0f", "woman pilot: Dark Skin Tone", []string{"woman_pilot_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\u2708\ufe0f", "woman pilot: Light Skin Tone", []string{"woman_pilot_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\u2708\ufe0f", "woman pilot: Medium-Light Skin Tone", []string{"woman_pilot_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\u2708\ufe0f", "woman pilot: Medium Skin Tone", []string{"woman_pilot_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\u2708\ufe0f", "woman pilot: Medium-Dark Skin Tone", []string{"woman_pilot_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fb\u200d\u2640\ufe0f", "woman playing handball: Light Skin Tone", []string{"woman_playing_handball_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fc\u200d\u2640\ufe0f", "woman playing handball: Medium-Light Skin Tone", []string{"woman_playing_handball_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fd\u200d\u2640\ufe0f", "woman playing handball: Medium Skin Tone", []string{"woman_playing_handball_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3fe\u200d\u2640\ufe0f", "woman playing handball: Medium-Dark Skin Tone", []string{"woman_playing_handball_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93e\U0001f3ff\u200d\u2640\ufe0f", "woman playing handball: Dark Skin Tone", []string{"woman_playing_handball_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fc\u200d\u2640\ufe0f", "woman playing water polo: Medium-Light Skin Tone", []string{"woman_playing_water_polo_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fd\u200d\u2640\ufe0f", "woman playing water polo: Medium Skin Tone", []string{"woman_playing_water_polo_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fe\u200d\u2640\ufe0f", "woman playing water polo: Medium-Dark Skin Tone", []string{"woman_playing_water_polo_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3ff\u200d\u2640\ufe0f", "woman playing water polo: Dark Skin Tone", []string{"woman_playing_water_polo_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f93d\U0001f3fb\u200d\u2640\ufe0f", "woman playing water polo: Light Skin Tone", []string{"woman_playing_water_polo_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f52c", "woman scientist: Light Skin Tone", []string{"woman_scientist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f52c", "woman scientist: Medium-Light Skin Tone", []string{"woman_scientist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f52c", "woman scientist: Medium Skin Tone", []string{"woman_scientist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f52c", "woman scientist: Medium-Dark Skin Tone", []string{"woman_scientist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f52c", "woman scientist: Dark Skin Tone", []string{"woman_scientist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fb\u200d\u2640\ufe0f", "woman shrugging: Light Skin Tone", []string{"woman_shrugging_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fc\u200d\u2640\ufe0f", "woman shrugging: Medium-Light Skin Tone", []string{"woman_shrugging_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fd\u200d\u2640\ufe0f", "woman shrugging: Medium Skin Tone", []string{"woman_shrugging_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3fe\u200d\u2640\ufe0f", "woman shrugging: Medium-Dark Skin Tone", []string{"woman_shrugging_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f937\U0001f3ff\u200d\u2640\ufe0f", "woman shrugging: Dark Skin Tone", []string{"woman_shrugging_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f3a4", "woman singer: Medium-Light Skin Tone", []string{"woman_singer_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f3a4", "woman singer: Medium Skin Tone", []string{"woman_singer_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f3a4", "woman singer: Medium-Dark Skin Tone", []string{"woman_singer_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f3a4", "woman singer: Dark Skin Tone", []string{"woman_singer_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f3a4", "woman singer: Light Skin Tone", []string{"woman_singer_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f393", "woman student: Medium-Light Skin Tone", []string{"woman_student_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f393", "woman student: Medium Skin Tone", []string{"woman_student_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f393", "woman student: Medium-Dark Skin Tone", []string{"woman_student_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f393", "woman student: Dark Skin Tone", []string{"woman_student_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f393", "woman student: Light Skin Tone", []string{"woman_student_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f3eb", "woman teacher: Dark Skin Tone", []string{"woman_teacher_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f3eb", "woman teacher: Light Skin Tone", []string{"woman_teacher_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f3eb", "woman teacher: Medium-Light Skin Tone", []string{"woman_teacher_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f3eb", "woman teacher: Medium Skin Tone", []string{"woman_teacher_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f3eb", "woman teacher: Medium-Dark Skin Tone", []string{"woman_teacher_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f4bb", "woman technologist: Light Skin Tone", []string{"woman_technologist_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f4bb", "woman technologist: Medium-Light Skin Tone", []string{"woman_technologist_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f4bb", "woman technologist: Medium Skin Tone", []string{"woman_technologist_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f4bb", "woman technologist: Medium-Dark Skin Tone", []string{"woman_technologist_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f4bb", "woman technologist: Dark Skin Tone", []string{"woman_technologist_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d5\U0001f3fc", "woman with headscarf: Medium-Light Skin Tone", []string{"woman_with_headscarf_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f9d5\U0001f3fd", "woman with headscarf: Medium Skin Tone", []string{"woman_with_headscarf_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f9d5\U0001f3fe", "woman with headscarf: Medium-Dark Skin Tone", []string{"woman_with_headscarf_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d5\U0001f3ff", "woman with headscarf: Dark Skin Tone", []string{"woman_with_headscarf_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f9d5\U0001f3fb", "woman with headscarf: Light Skin Tone", []string{"woman_with_headscarf_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fc\u200d\U0001f9af", "woman with white cane: Medium-Light Skin Tone", []string{"woman_with_probing_cane_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fd\u200d\U0001f9af", "woman with white cane: Medium Skin Tone", []string{"woman_with_probing_cane_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fe\u200d\U0001f9af", "woman with white cane: Medium-Dark Skin Tone", []string{"woman_with_probing_cane_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3ff\u200d\U0001f9af", "woman with white cane: Dark Skin Tone", []string{"woman_with_probing_cane_Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f469\U0001f3fb\u200d\U0001f9af", "woman with white cane: Light Skin Tone", []string{"woman_with_probing_cane_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fb\u200d\u2640\ufe0f", "woman wearing turban: Light Skin Tone", []string{"woman_with_turban_Light_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fc\u200d\u2640\ufe0f", "woman wearing turban: Medium-Light Skin Tone", []string{"woman_with_turban_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fd\u200d\u2640\ufe0f", "woman wearing turban: Medium Skin Tone", []string{"woman_with_turban_Medium_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3fe\u200d\u2640\ufe0f", "woman wearing turban: Medium-Dark Skin Tone", []string{"woman_with_turban_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\U0001f473\U0001f3ff\u200d\u2640\ufe0f", "woman wearing turban: Dark Skin Tone", []string{"woman_with_turban_Dark_Skin_Tone"}, "12.0", false},
	{"\u270d\U0001f3fb\ufe0f", "writing hand: Light Skin Tone", []string{"writing_hand_Light_Skin_Tone"}, "12.0", false},
	{"\u270d\U0001f3fc\ufe0f", "writing hand: Medium-Light Skin Tone", []string{"writing_hand_Medium-Light_Skin_Tone"}, "12.0", false},
	{"\u270d\U0001f3fd\ufe0f", "writing hand: Medium Skin Tone", []string{"writing_hand_Medium_Skin_Tone"}, "12.0", false},
	{"\u270d\U0001f3fe\ufe0f", "writing hand: Medium-Dark Skin Tone", []string{"writing_hand_Medium-Dark_Skin_Tone"}, "12.0", false},
	{"\u270d\U0001f3ff\ufe0f", "writing hand: Dark Skin Tone", []string{"writing_hand_Dark_Skin_Tone"}, "12.0", false},
}
