# Changelog

This changelog goes through all the changes that have been made in each release
without substantial changes to our git log; to see the highlights of what has
been added to each release, please refer to the [blog](https://blog.gitea.io).

## [1.5.3](https://github.com/go-gitea/gitea/releases/tag/v1.5.3) - 2018-10-31
* SECURITY
  * Fix remote command execution vulnerability in upstream library (#5177) (#5196)

## [1.5.2](https://github.com/go-gitea/gitea/releases/tag/v1.5.2) - 2018-10-09
* SECURITY
  * Enforce token on api routes (#4840) (#4905)
* BUGFIXES
  * Remove links from topics in edit mode (#5030)
  * Detect charset and convert non UTF-8 files for display (#4950) (#4994)
  * Fix layout of the topics editing form (#4971) (#4993)
  * Fix null pointer dereference in ParseCommitWithSignature (#4964)
  * Fix url in discord webhook (#4951)
  * Fix font-cropping UI bug in diff (#4726) (#4929)
  * Fix bug forget to remove Stopwatch when remove repository (#4933)
  * Fix bug when repo remained bare if multiple branches pushed (#4927)
  * Fix redirect with non-ascii branch names (#4764) (#4887)
  * Fix issues api allow pulls (#4852) (#4862)
  * Fix trimming of markup section names (#4864)

## [1.5.1](https://github.com/go-gitea/gitea/releases/tag/v1.5.1) - 2018-09-03
* SECURITY
  * Don't disclose emails of all users when sending out emails (#4784)
  * Improve URL validation for external wiki and external issues (#4710) (#4740)
  * Make cookies HttpOnly and obey COOKIE_SECURE flag (#4706) (#4707)
* BUGFIXES
  * Fix missing release title in webhook (#4783) (#4800)
  * Make sure to reset commit count in the cache on mirror syncing (#4770)
  * Fixed bug where team with admin privelege type doesn't get any unit (#4759)
  * Fix failure on creating pull request with assignees (#4583) (#4727)
  * Hide org/create menu item in Dashboard if user has no rights (#4678) (#4686)
* TRANSLATION
  * Fix incorrect caption of webhook setting (#4701) (#4718)

## [1.5.0](https://github.com/go-gitea/gitea/releases/tag/v1.5.0) - 2018-08-10
* SECURITY
  * Check that repositories can only be migrated to own user or organizations (#4366) (#4370)
  * Limit uploaded avatar image-size to 4096px x 3072px by default (#4353)
  * Do not allow to reuse TOTP passcode (#3878)
* BUGFIXES
  * Fix column droping for MSSQL that need new transaction for that (#4440) (#4484)
  * Redirect to correct page after using scratch token (#4458) (#4472)
  * Replace src with raw to fix image paths (#4377) (#4386)
  * Fixes repo membership check in API (#4341) (#4379)
  * Add default merge options when adding new repository (#4369) (#4373)
  * Fix repository last updated time update when delete a user who watched the repo (#4363) (#4371)
  * Fix html entity escaping in branch deletion message (#4471) (#4485)
  * Fix out-of-transaction query in removeOrgUser (#4521) (#4524)
  * Fix incorrect MergeWhitelistTeamIDs check in CanUserMerge function (#4519)
  * Fix panic issue on update avatar email (#4580) (#4590)
  * Fix bugs when too many IN variables (#4594) (#4597)
  * Push whitelist now doesn't apply to branch deletion (#4601) (#4640)
  * Site admin could create repos even MAX_CREATION_LIMIT=0 (#4645) (#4650)
* FEATURE
  * Add cli commands to regen hooks & keys (#3979)
  * Add support for FIDO U2F (#3971)
  * Added user language setting (#3875)
  * LDAP Public SSH Keys synchronization (#1844)
  * Add topic support (#3711)
  * Multiple assignees (#3705)
  * Add protected branch whitelists for merging (#3689)
  * Global code search support (#3664)
  * Add label descriptions (#3662)
  * Add issue search via API (#3612)
  * Add repository setting to enable/disable health checks (#3607)
  * Emoji Autocomplete (#3433)
  * Implements generator cli for secrets (#3531)
* ENHANCEMENT
  * Add more webhooks support and refactor webhook templates directory (#3929)
  * Add new option to allow only OAuth2/OpenID user registration (#3910)
  * Add option to use paged LDAP search when synchronizing users (#3895)
  * Symlink icons (#1416)
  * Improve release page UI (#3693)
  * Add admin dashboard option to run health checks (#3606)
  * Add branch link in branch list (#3576)
  * Reduce sql query times in retrieveFeeds (#3547)
  * Option to enable or disable swagger endpoints (#3502)
  * Add missing licenses (#3497)
  * Reduce repo indexer disk usage (#3452)
  * Enable caching on assets and avatars (#3376)
  * Add repository search ordered by stars/forks. Forks column in admin repo list (#3969)
  * Add Environment Variables to Docker template (#4012)
  * LFS: make HTTP auth period configurable (#4035)
  * Add config path as an optionial flag when changing pass via CLI (#4184)
  * Refactor User Settings sections (#3900)
  * Allow square brackets in external issue patterns (#3408)
  * Add Attachment API (#3478)
  * Add EnableTimetracking option to app settings (#3719)
  * Add config option to enable or disable log executed SQL (#3726)
  * Shows total tracked time in issue and milestone list (#3341)
* TRANSLATION
  * Improve English grammar and consistency (#3614)
* DEPLOYMENT
  * Allow Gitea to run as different USER in Docker (#3961)
  * Provide compressed release binaries (#3991)
  * Sign release binaries (#4188)

## [1.4.3](https://github.com/go-gitea/gitea/releases/tag/v1.4.3) - 2018-06-26
* SECURITY
  * HTML-escape plain-text READMEs (#4192) (#4214)
  * Fix open redirect vulnerability on login screen (#4312) (#4312)
* BUGFIXES
  * Fix broken monitoring page when running processes are shown (#4203) (#4208)
  * Fix delete comment bug (#4216) (#4228)
  * Delete reactions added to issues and comments when deleting repository (#4232) (#4237)
  * Fix wiki URL encoding bug (#4091) (#4254)
  * Fix code tab link when viewing tags (#3908) (#4263)
  * Fix webhook type conflation (#4285) (#4285)

## [1.4.2](https://github.com/go-gitea/gitea/releases/tag/v1.4.2) - 2018-06-04
* BUGFIXES
  * Adjust z-index for floating labels (#3939) (#3950)
  * Add missing token validation on application settings page (#3976) #3978
  * Webhook and hook_task clean up (#4006)
  * Fix webhook bug of response info is not displayed in UI (#4023)
  * Fix writer cannot read bare repo guide (#4033) (#4039)
  * Don't force due date to current time (#3830) (#4057)
  * Fix wiki redirects (#3919) (#4065)
  * Fix attachment ENABLED (#4064) (#4066)
  * Added deletion of an empty line at the end of file (#4054) (#4074)
  * Use ResolveReference instead of path.Join (#4073)
  * Fix #4081 Check for leading / in base before removing it (#4083)
  * Respository's home page not updated after first push (#4075)

## [1.4.1](https://github.com/go-gitea/gitea/releases/tag/v1.4.1) - 2018-05-03
* BREAKING
  * Add "error" as reserved username (#3882) (#3886)
* SECURITY
  * Do not allow inactive users to access repositories using private key (#3887) (#3889)
  * Fix path cleanup in file editor, when initilizing new repository and LFS oids  (#3871) (#3873)
  * Remove unnecessary allowed safe HTML (#3778) (#3779)
  * Correctly check http git access rights for reverse proxy authorized users (#3721) (#3743)
* BUGFIXES
  * Fix to use only needed columns from tables to get repository git paths (#3870) (#3883)
  * Fix GPG expire time display when time is zero (#3584) (#3884)
  * Fix to update only issue last update time when adding a comment (#3855) (#3860)
  * Fix repository star count after deleting user (#3781) (#3783)
  * Use the active branch for the code tab (#3720) (#3776)
  * Set default branch name on first push (#3715) (#3723)
  * Show clipboard button if disable HTTP of git protocol (#3773) (#3774)

## [1.4.0](https://github.com/go-gitea/gitea/releases/tag/v1.4.0) - 2018-03-25
* BREAKING
  * Drop deprecated GOGS\_WORK\_DIR use (#2946)
  * Fix API status code for hook creation (#2814)
* SECURITY
  * Escape branch name in dropdown menu (#3691) (#3692)
  * Refactor and simplify to correctly validate redirect to URL (#3674) (#3676)
  * Fix escaping changed title in comments (#3530) (#3534)
  * Escape search query (#3486) (#3488)
  * Sanitize logs for mirror sync (#3057)
* FEATURE
  * Serve .patch and .diff for pull requests (#3305, #3293)
  * Add repo-sync-releases admin command (#3254)
  * Support default private when creating or migrating repository (#3239)
  * Writable deploy keys (closes #671) (#3225)
  * Add Pull Request merge options - Ignore white-space for conflict checking, Rebase, Squash merge (#3188)
  * Added progressbar for issues with checkboxes (#1146). (#3171)
  * Mention completion for issue editor. (#3136)
  * Add 'mark all read' option to notifications (#3097)
  * Git LFS lock api (#2938)
  * Add reactions to issues/PR and comments (#2856)
  * Add dingtalk webhook  (#2777)
  * Responsive view (#2750)
* BUGFIXES
  * Fix wiki inter-links with spaces (#3560) (#3632)
  * Fix query protected branch bug (#3563) (#3571)
  * Fix remove team member issue (#3566) (#3570)
  * Fix the protected branch panic issue (#3567) (#3569)
  * If Mirrors repository no content is fetched, updated time should not be changed (#3551) (#3565)
  * Bug fix for mirrored repository releases sorted (#3522) (#3555)
  * Add issue closed time column to fix activity closed issues list (#3537) (#3540)
  * Update markbates/goth library to support OAuth2 with new dropbox API (#3533) (#3539)
  * Fixes missing avatars in offline mode (#3471) (#3477)
  * Fix synchronization bug in repo indexer (#3455) (#3461)
  * Fix rendering of wiki page list if wiki repo contains other files (#3454) (#3463)
  * Fix webhook X-GitHub-* headers casing for better compatibility (#3429)
  * Add content type and doctype to requests made with go-get (#3426, #3423)
  * Fix SQL type error for webhooks (#3424)
  * Fix PR merge error (#3421)
  * Recognize more characters in crossreferenced repo name (#3413)
  * Fix MSSQL bug on org (#3405)
  * HTML escape all lines of the search result (#3402)
  * Change local copy origin url after repository rename (#3399)
  * Force-push to base repo's ref/pull/#/head (#3393)
  * Fix bug when a user delete but assigned on issue (#3318)
  * Use issue number/index instead of id for API URL. Fix #3297 (#3298)
  * Fix repo-transfer-and-team-repo-count bug (#3241)
  * Fix always-on SSL Mode checkbox in admin page (#3208)
  * Fix source download link when no code unit allowed (#3166)
  * Fix org owner cannot be removed if he is not in owner team (#3164)
  * Fix run web with -p push failed (#3154)
  * Fix gpg tmpl (#3153)
  * Fix SSH auth lfs locks (#3152)
  * Improvements for supporting UI Location (#3146)
  * Fix new pull request link (#3133)
  * Fix missing branch in release bug (#3108)
  * Allow adding collaborators with (fullname) (#3103)
  * Fix repo links (#3093)
  * fix lfs url refs + keep path upper/lowercase in db. (#3092)
  * Fix redis session failed (#3086)
  * Fix bugs in issue dashboard stats (#3073)
  * Fix avatar URLs (#3069)
  * Fix ref parsing in commit messages (#3067)
  * Fix issue list branch link broken (#3061)
  * sendmail: correct option to set envelope-sender (#3044)
  * Fix missing password length check when change password (#3039)
  * Fix git lfs path (#3016)
  * Fix API-Endpoint release (#3005) (#3012)
  * Set OpenID support on by default when installing new instance (#3010)
  * Various wiki bug fixes (#2996)
  * Fix go-get, src and raw urls to new scheme (#2978)
  * Fix error when add user has full name to team (#2973)
  * Fix memcache support when value is returned as string always (#2924)
* ENHANCEMENT
  * Use GiteaServer as the user agent for http requests (#3404)
  * Delete indexer DB entries when (re)creating index (#3385)
  * Change how merged PR commit info are prepared (#3368)
  * Asynchronously populate the repo indexer (#3366)
  * Make the default action for the gitea executable that of running the webserver (#3331)
  * Templates for extra links in top navbar and repo tool tabs. (#3308)
  * Fixed asterisk based tasklist items #3295 (#3296)
  * Add more additional template snippets (#3286)
  * Open external tracker in blank window, consistently with wiki (#3227)
  * Fix repo links on user profile (#3197)
  * Enable emoji for wiki view (#3158)
  * Small improve on deleting attachements (#3145)
  * Reduce overhead of upgrades for users with custom stylesheets/JS (#3051)
  * Default log level to Info without hardcoding it in installer (#3041)
  * Memory usage improvements (#3013)
  * Add fingerprint to ssh key endpoints. (#3009)
  * Improve memory usage when reaching diff limits (#2990)
  * Expandable commit bodies (#2980)
  * Update gitgraph.js to fix blurry commit graph on HiDPI screens (#2957)
  * Fix language names (#2955)
  * Remove render issue link (#2954)
  * Page parameter for repo search API (#2915)
  * Apply LANDING\_PAGE config options for logged in users (#2894)
  * Enable admin to search by email (#2888)
  * Hide add key button if SSH is disabled (#2873)
  * Fix comment API paths (#2813)
  * Add an option to allow redirect of http port 80 to https. (#1928)
* MISC
  * Fix organization profile on mobile devices (#3332)
  * Fix guide link for webhooks in repository settings (#3291) (#3292)
  * Enable Libravatar by default in new installations (#3287)
  * Improve suppressed diff boxes (#3193)
  * fix button heights on commits page (#3091)
  * Minor copy changes (#3074)
  * Sort repos in issues dashboard sidebar (#3072)
  * Remove box-shadow from UI, fix dashboard issue (#3065)
  * Adjust branch button size (#3063)
  * Fix misalignment issue in repo header (#3062)
  * Delete a user's public key via admin api (closes #3014) (#3059)
  * Dashboard: Fix line height problem in issue titles (#3054)
  * Remove duplicate "Max Diff Lines" from config view (#2987)
  * Drop unmaintained gogs migration script (#2947)
  * App restarts to quickly if it fails to start. (#2945)
  * Add owner to delete repo message (#2886)

## [1.3.1](https://github.com/go-gitea/gitea/releases/tag/v1.3.1) - 2017-12-08
* BUGFIXES
  * Sanitize logs for mirror sync (#3057, #3082) (#3078)
  * Fix missing branch in release bug (#3108) (#3117)
  * Fix repo indexer and submodule bug (#3107) (#3110)
  * Fix legacy URL redirects (#3100) (#3106)
  * Fix redis session failed (#3086) (#3089)
  * Fix issue list branch link broken (#3061) (#3070)
  * Fix missing password length check when change password (#3039) (#3071)

## [1.3.0](https://github.com/go-gitea/gitea/releases/tag/v1.3.0) - 2017-11-29
* BREAKING
  * Make URL scheme unambiguous (#2408)
* FEATURE
  * Add branch overiew page (#2108)
  * Code/repo search (#2582)
  * Add Activity page to repository (#2674)
  * Issue Timetracking (#2211)
  * Add orgmode document type on file view and readme (#2525)
  * Add external markup render support (#2570)
  * Implementation of discord webhook (#2402)
  * Webhooks for repo creation/deletion (#1663)
  * Complete push webhooks (#2530)
  * Add possibility to record branch information in an issue (#780)
  * Create new branch from branch selection dropdown (#2130)
  * Implementation of all repositories of a user from user->settings (#1740)
  * Add LFS object verification step after upload (#2868)
  * Configurable SSH cipher suite (#913)
  * Disable custom Git Hooks globally via configuration file (#2450)
  * Sync releases table with tags on push and for mirrors (#2459)
* BUGFIXES
  * Fix label comments for French locale (#3017)
  * Remove duplicate "Max Diff Lines" from config view (#3001)
  * Fix over-escaped characters (#2992)
  * Fix go-get, src and raw urls to new scheme (#2986)
  * Fix error when add user has full name to team (#2975)
  * Fix files/commits of merged PRs (#2970)
  * Update golang x/crypto dependencies - Fix SSH transport fail (#2951)
  * Fix memcache support when value is returned as string always (#2950)
  * Fix issue link rendering in commit messages (#2897)
  * Fix adding a new authentication source after selecting OAuth (#2889)
  * Fix new branch creation to new url scheme (#2884)
  * Allow spaces in username for LDAP users (#2880)
  * Fix LFS not returning correct content length when requesting a range … (#2864)
  * Fix fork repository cycle to self (#2860)
  * Fix click create pull request button 404 (#2859)
  * Fix API raw file content access for default branch (#2849)
  * Clean repository ROOT directory name with filepath.Clean (#2846)
  * Fix API raw requests for commits and tags (#2841)
  * Fix order of comments (#2835)
  * Issue content should not be updated when closing with comment (#2833)
  * Fix ordering in app.ini and fix run mode option (#2829)
  * Fix redirect url of legacy commits route (#2825)
  * Fix commits page url (#2823)
  * Fix wrong translations (#2818)
  * Fix dropdown menu position when explore repos (#2808)
  * Fix Git LFS object/repo link storage in database and small refactoring (#2803)
  * Use relative URLs for avatars on the dashboard (#2800)
  * Add checks for commits with missing author and time (#2771)
  * Fix emojify image URL (#2769)
  * Hide unactive on explore users and some refactors (#2741)
  * Fix IE unsupported javascript construction in branch dropdown (#2736)
  * Only update mirror last update after successful sync (#2730)
  * Fix semantic-ui style conflict with v-cloak (#2722)
  * Fixing wrong translation on sort type oldest/latest (#2720)
  * Fix PR, milestone and label functionality if issue unit is disabled (#2710)
  * Fix plain readme didn't render correctly on repo home page (#2705)
  * Fix organization removal from watch table migration (#2703)
  * Fix repository search function (#2689)
  * fix panic on gogs webhook creation (#2675)
  * Fix orgnization user watch repository (#2670)
  * GPG key email verification no longer case sensitive (#2661) (#2663)
  * Fix index column deletion (#2651)
  * table `pull_request` wasn't updated correctly (#2649)
  * Fix go get response if only app URL is custom in configuration (#2634)
  * Fix doubled issue tab introduced in migration v16 (#2611)
  * Rewrite migrations to not depend on future code changes (#2604)
  * Fix implementation of repo Home func (#2601)
  * Fix translation upload to crowdin (#2599)
  * Reduce usage of allcols on update (#2596)
  * fix go get subpackage bug (#2584)
  * Fix broken migration to add can_push field back to table (#2574)
  * fix readme view bug (#2566)
  * Fix sending mail with a non-latin display name. #2102 (#2559)
  * Restricting access to fork functioanlity to users with Code access (#2534)
  * fix updated update on public key (#2514)
  * Added bucket name to s3 drone plugin (#2505)
  * fixes 500 error on dashboard when using MSSQL (#2504)
  * fix wrong rendering of commit detail page (#2503)
  * Hotfix: Add time manually adds time in nanoseconds (#2499)
  * Remove repository mirrors from "collaborative" list (#2497)
  * fix release failed since the wrong token name (#2496)
  * Fix slice out of bounds error in mailer (#2479)
  * Fix #2470 (#2477)
  * fix orgnization webhooks (#2422)
  * fix webhook test (#2415)
  * fix missing orgnization discord webhook (#2414)
  * Fix route handler order (#2409)
  * Prevent sending emails and notifications to inactive users (#2384)
  * Move themes to plugin directory. Fixes #2372 (#2375)
  * fix duplicated feed (#2370)
  * Fix missing collabrative repos (#2367)
  * Only check at least one email gpg key (#2266)
  * don't check minimum key size when disabled (#1754)
  * Fix run command race (#1470)
  * fix .netrc authentication (#2700)
  * Fix so that user can still fork his own repository to his organizations (#2699)
  * Fix can_push value to false in protected_branch (#2560)
  * Fix copy in email templates (#2801)
  * Fix inconsistencies in user settings UI (#2901)
  * Fix attachments icon size on zoom in/out (#2853)
  * Fix ignored errors in API route (#2850)
  * Fix activity css conflit with semantic ui (#2758)
  * Fix notifications tabs according to semantic-ui docs (#2733)
  * Fix typos in app.ini (#2732)
  * Fix duplicated rel attribute (#2549)
  * Fix tests code to prevent some runtime errors (#2381)
* ENHANCEMENT
  * Memory usage improvements and lower minimal git requirement to 1.7.2 (#3013) (#3028)
  * Set OpenID support on by default when installing new instance (#3010) (#3027)
  * Use api.TrackedTime in API (#2807)
  * Configurable SSH key exchange algorithm and MAC suite (#2806)
  * Add Safari pinned tab icon (#2799)
  * Improve force push detect when push (#2798)
  * Add wrapping to long diff lines (#2789)
  * Link members and repositories count to each page on org home. (#2787)
  * Show Sendmail settings on admin config page (#2782)
  * Add commit count caching (#2774)
  * Use identicon image for default gravatar. (#2767)
  * Add default ssh ciphers (#2761)
  * Remove manual of unsupported option (#2757)
  * Add search mode option to /api/repo/search (#2756)
  * Move swagger-ui under /api/v1 (#2746)
  * Add support for extra sendmail arguments (#2731)
  * Use buffersize to reduce database connection when iterate (#2724)
  * Render plain text README.txt monospaced (#2721)
  * Integration test for activity page (#2704)
  * Merge password and 2fa page on user settings (#2695)
  * Allow custom SSH user in UI for built-in SSH server (#2617) (#2678)
  * Refactor duplicated code in repo handlers (#2657)
  * Replace deprecated Id method with ID (#2655)
  * Remove redudant functions and code (#2652)
  * hide navbar when only 1 sign-in method is available (#2444) (#2648)
  * Change default sort order (#2647)
  * Change pull description text (#2075) (#2646)
  * Remove direct user adding to organization members (#2641)
  * Use session when creating user (#2638)
  * Use Semantic UI's Search component for user and repo search (#2636)
  * Use AfterLoad instead of AfterSet on Structs (#2628)
  * Remove redudant CheckUnit calls in router (#2627)
  * Remove repo unit index (#2621)
  * Remove redudant issue LoadAttributes() calls (#2614)
  * Make indexer code more reusable (#2590)
  * Use custom type and constants to hold available order by options (#2572)
  * Use named ActionType constants in template helper (#2545)
  * Make basic functionality work without JavaScript (#2541)
  * Ctrl + Enter to submit forms (#2540)
  * Automatically regenerate indexer for incompatible versions (#2524)
  * Set default lfs content path to data/lfs (#2521)
  * Convert spaces to tabs in footer.tmpl (#2520)
  * Sort repository tree entries in natural way (#2506)
  * Open external wiki in new window (#2489)
  * Use created & updated instead BeforeInsert & BeforeUpdate (#2482)
  * Hide branch on pull request view or create UI (#2454)
  * improve protected branch to add whitelist support (#2451)
  * some refactors for issue and comments (#2419)
  * Restructure markup & markdown to prepare for multiple markup language… (#2411)
  * Improve issue search (#2387)
  * Add UseCompatSSHURI setting (#2356)
  * Use custom search for each filter type in dashboard (#2343)
  * Failed authentication are now properly logged (#2334)
  * Add environment variable support for Docker image (#2201)
  * Set session and indexers' data files rel to AppDataPath (#2192)
  * Display commit status on landing page of repo (#1784)
* TESTING
  * Add integration test for logging out (#2892)
  * Integration test for user deleting account (#2891)
  * Use different directories for session files in integration tests (#2834)
  * Add deleted_branch table fixture (#2832)
  * Include HTTP method in test error message (#2815)
  * Add repository search unit and integration tests (#2575)
  * Expand fixtures (#2571)
  * Fix /api/repo/search integration tests (#2550)
  * Make integration tests more user-friendly (#2536)
  * Fix unit test race condition (#2516)
  * Add missing fixture to clean gpg_key table (#2494)
  * Hotfix for integration testing (#2473)
  * Make repo private to not interfere with other tests (#2467)
  * Error message for integration test (#2410)
  * Fix "index out of range" runtime error in repo_list tests (#2376)
  * Add git clone test on integration test (#1682)
* TRANSLATION
  * Fix localization texts that contain semicolon (#2900)
  * Fix activity locale (#2709)
  * Update translation from crowdin (#2368)
* BUILD
  * change the email and name to GitBot account. (#2848)
  * Fix removing backslash before quotes in translations (#2831)
  * add gitea remote in drone. (#2817)
  * add remote name for git push. (#2816)
  * Launch Gitea with custom UID/GID for 'git' user (fixes #2286) (#2791)
  * Download and pushing translations (#2727)
  * Automatic update of translations (#2585)
  * Add pre-build step for nodejs stuff (#2581)
  * Compress css with nodejs (#2580)
  * Remove go version check for make fmt (#2558)
  * Fix lint errors (#2547)
  * Always run fmt check in CI (#2546)
  * Fix fmt errors (#2544)
  * add codecov.io service. (#2493)
  * Fix some tests : make coverage -> test (#2492)
  * Fix fmt error in mailer (#2490)
  * Allow changing integration test database connection using env variables (#2484)
  * Add changelog config file for generate changelog (#2461)
  * Changes for latest DroneCI (#2362)
  * Use standard lessc and minify CSS using Node.js (#2337)
* DOCS
  * Update screenshots on README (#2910)
  * Gogs -> Gitea (#2909)
  * Update swagger documentation (#2899)
  * Fix typo (#2810)
  * Fix Polish language name spelling (#2766)
  * Fix Various Grammar Issues and Adjust Unnatural Wording (#2737)
  * Add maintainer label for docker file (#2658)
  * Link to gitea-specific Vagrant example (#2624)
  * add release notes of v1.1.4 (#2463)
  * Wrap most paragraphs to 80 columns (#2396)
  * Update CONTRIBUTING following #2329  discussion (#2394)
  * Update hard-coded version to 1.3.0+dev (#2390)
  * Clarify Translation Process. Also fix branch names (#2378)
  * Admin grammar fixes and improvements (#2056)
* MISC
  * Sync MaxGitDiffLineCharacters with conf/app.ini (#2779)
  * Dockerfile: Updated alpine image to 3.6. (#2486)
  * Basic VSCode configuration for building and debugging (#2483)
  * Added vendor dir for js/css libs; Documented sources (#1484) (#2241)

## [1.2.3](https://github.com/go-gitea/gitea/releases/tag/v1.2.3) - 2017-11-03
* BUGFIXES
  * Only require one email when validating GPG key (#2266, #2467, #2663) (#2788)
  * Fix order of comments (#2835) (#2839)

## [1.2.2](https://github.com/go-gitea/gitea/releases/tag/v1.2.2) - 2017-10-26
* BUGFIXES
  * Add checks for commits with missing author and time (#2771) (#2785)
  * Fix sending mail with a non-latin display name (#2559) (#2783)
  * Sync MaxGitDiffLineCharacters with conf/app.ini (#2779) (#2780)
  * Update vendor git (#2765) (#2772)
  * Fix emojify image URL (#2769) (#2773)

## [1.2.1](https://github.com/go-gitea/gitea/releases/tag/v1.2.1) - 2017-10-16
* BUGFIXES
  * Fix PR, milestone and label functionality if issue unit is disabled (#2710) (#2714)
  * Fix plain readme didn't render correctly on repo home page (#2705) (#2712)
  * Fix so that user can still fork his own repository to his organizations (#2699) (#2707)
  * Fix .netrc authentication (#2700) (#2708)
  * Fix slice out of bounds error in mailer (#2479) (#2696)

## [1.2.0](https://github.com/go-gitea/gitea/releases/tag/v1.2.0) - 2017-10-10
* SECURITY
  * Sanitation fix from Gogs (#1461)
* BREAKING
  * Rename /forget_password url to /forgot_password (#1219)
* FEATURE
  * Logo: Add task to generate images from SVG and change to new logo (#2194)
  * Status-API (#1332)
  * Show commit status icon in commits table (#1688)
  * Additional OAuth2 providers (#1010)
  * GPG commit validation (#1150)
  * Rework SSH key management UI to add GPG (#1293)
  * Implement GPG api (#710)
  * Login via OpenID-2.0 (#618)
  * Add units to team (#947)
  * Batch updates for issues (#926)
  * Add Gitea Webhook (#1755)
  * API: support '/orgs/:org/repos' (#2047)
  * Display all organization from user settings (#1739)
  * LDAP user synchronization (#1478)
  * Adding #issuecomment to the URL in E-Mail notifications (#1674)
  * Add download count field and unit testing for attachment. (#1512)
  * Add repo mirror sync API endpoint (#1508)
  * Add markup package to prepare for org markup format (#1493)
  * Support for custom html meta  (#1423)
  * Per issue/PR watch/unwatch (#1410)
  * Allow ENABLE_OPENID_SIGNUP to depend on DISABLE_REGISTRATION (#1369)
  * Repo size in admin panel (#1482)
  * Show user OpenID URIs in their profile (#1314)
  * Add change-password admin command (#1304)
  * Only use issue and wiki on repo. (#1297)
  * Allow push to init a wiki repo (#1279)
* ENHANCEMENT
  * Make time diff translatable (#2057)
  * Smaller watch, star, and fork buttons (#2052)
  * Display config file path on admin panel (#2030)
  * Only show SSH clone URL if signed in (#2169) (#2170)
  * Only show "No Description" to repo admins (#2167)
  * Always return valid go-get meta, even if unauthorized (#2010)
  * Enable assignee e-mail notification (#2003)
  * Let not-logged-in users view releases (#1999)
  * No highlighting for .txt files (#1922)
  * Make side nav on dashboard stackable (#1778)
  * Setting to disable authorized_keys backup (#1856)
  * Hide the create organization button (in dashboard/organization section) (#1705)
  * LFS: Return 404 for unimplemented endpoints (#1330)
  * Show a link to password reset from user settings requiring a password (#862)
  * Reserve the "explore" user/org name (#1222)
  * Send notifications to partecipants in issue comments (#1217)
  * Improve style of user OpenID setting page (#1324)
  * Use font-awesome OpenID icon more (#1320)
  * Use readonly input form to show the validated OpenID URI (#1308)
  * Add captcha support to OpenID based signup (#1307)
  * Minor improvements on commit graph UI (#1380)
  * Mirror sync interval specified as duration string (#1407)
  * Make issue in commit graph "clickable" (#1392)
  * Use whole button (commit graph) as link (#1390)
  * Autofocus on 2fa passcode fields (#1460)
  * Sort on repo size in admin panel (#1654)
  * Improve dashboard repo search (#1652)
  * Use a better default MAX_GIT_DIFF_LINE_CHARACTERS (#1845)
  * Adds Parent property to the repo API (#1687)
  * Add configuration option for default permission to create Organizations (#1686)
  * Remove sha1 hash display in repository table (#1678)
  * Download files to their original filename (#1676)
  * Exposes in API the Repo entity's Size and IsBare property (#1668)
  * Change two factor code entry box from text to number (#1733)
  * Directly show error if user hit repository limit  (#1767)
  * Generate small and large logos at 4x resolution (#2233)
  * Tags listed in releases tab (#2389) (#2424)
* BUGFIXES
  * Fix adding branch as protected to not allow pushing to it (#2556)
  * Orgs: fix org page title when full name is not defined (#1495)
  * Fix double borders on edit page (#1152) (#1153)
  * Search bar fixes for #1187 and #1205 (#1207)
  * Fix upgrade failed after ever rollback (#1194)
  * Fix FCGI (over TCP) support (#1368)
  * Backport of migration fixes (#2604) (#2677)
  * fix panic on gogs webhook creation (#2675) (#2676)
  * Backport: Fixes 500 error on dashboard when using MSSQL (#2504) (#2662)
  * Fix go get response if only app URL is custom in configuration (#2634) (#2640)
  * Fix deletion of unprotected branches (#2630)
  * Backport of 2611 / Fix doubled issue tab introduced in migration v16 (#2622)
  * v38 migration used an outdated version of RepoUnit model (#2602)
  * fix go get subpackage bug (#2584) (#2589)
  * Backport: Sync releases table with tags on push and for mirrors (#2459) (#2554)
  * Backport: Restricting access to fork functioanlity to users with Code access (#2542)
  * Fix migration from pre-v15 to 1.2.0 (#2460) (#2465)
  * Fix migration from pre-v15 to 1.2.0 (#2460)
  * fix duplicated feed (#2370) (#2413)
  * Fix releases to be counted from database not tags (#2389)
  * Fix missing collabrative repos (#2367) (#2382)
  * Add more test for login links and fix a bug on action retrieve (#2361)
  * Fix SQL condition bug in GetFeeds(..) (#2360)
  * fix bug on create repo link on dashboard (#2359)
  * Fix order of elements in dashboard html (#2344)
  * Fix repo-search template errors for go1.7 (#2336)
  * Add missing forks key for dashboard repository component (#2325)
  * fix template error on explore repos (#2319)
  * Trigger sync webhooks on UI commit (#2302)
  * fix 500 error when view an issue which's milestone deleted (#2297)
  * Only update needed columns when update user (#2296)
  * Fix rendering of external links (#2292)
  * Fix and improve dashboard repo UI (#2285)
  * Make short link pattern greedy (#2259)
  * Temporarily patch go-ini/ini with fork (#2255)
  * Convert xorm literal queries to method calls (#2253)
  * update code.gitea.io/git in vendor to fix delete branch fails (#2250)
  * Replace calls to xorm UseBool with Where (#2237)
  * rhel7 has a git version with four digits (1.8.3.1) (#2236)
  * Fix internal requests when gitea listens to unix socket or only external IP (#2234)
  * Check for access in /repositories/:id (#2227)
  * Fixed robots.txt 404 error (#2226)
  * Fix counts on issues dashboard (#2215)
  * Fix unclosed session bug (#2214)
  * Add collaborative repositories to the dashboard (#2205)
  * Fix issue updated_unix bug (#2204)
  * Fix Commits nil pointer dereference (#2203)
  * Fix bare-repo bugs (#2199)
  * Fix PR nil-dereference bug (#2195)
  * Allow only single fork per user/organization (#2193)
  * Fix key usage time update if the key is used in parallel for multiple operations (#2185)
  * Only allow token authentication with 2FA enabled (#2184)
  * Fix profile update for non-local users (#2178)
  * Fix compiling without sqlite and gcc (#2177)
  * Make compare button URL aware if current repo is a fork (#2162) (#2163)
  * Remove unit types commits and settings (#2161)
  * Fix OpenID registration route (#2160)
  * Fix repository settings collobration list display (#2151)
  * Ignore invalid issue numbers in commit messages. Fixes  #2022 (#2150)
  * Fix SHA1 hash linking (#2143)
  * Fix repo API bug (#2133)
  * Use POSIX complaint ! operator in find (#2132)
  * Fix GET /users/:username/repos endpoint (#2125)
  * Fix username rendering bug (#2122)
  * Fix wiki preview links (#2119)
  * vendor: update sqlite to fix "database is locked" errors (#2116)
  * Fix unchecked error bug (#2110)
  * Fix missing-return bug (#2109)
  * Fix API for branches with slashes (#2096)
  * Fix git hooks update to receive required arguments (#2095)
  * upgrade git source code. (#2094)
  * Fix SQL bug in models.PullRequests (#2092)
  * Don't ignore gravatar error (#2083)
  * Fix release display and correct paging (#2080)
  * remove unnecessary blank lines and wrong error log (#2079)
  * Check for valid renamed usernames (#2077)
  * Update git module (#2074)
  * Fix org hooks UI (#2072)
  * Fix #1271: Call location.reload after XHR finishes (#2071)
  * Fix default ghost assignee bug (#2069)
  * Fix bug in issue labels API (#2048)
  * Load label ID in NewLabels (#2045)
  * Fix: `http: multiple response.WriteHeader calls` (#2038)
  * Pagination on releases page (#2035)
  * repo/editor: fix breadcrumb path cuts parent dirs (#3859) (#2032)
  * Fix displaying commits and files of PR created from now deleted fork (#2023)
  * Fix #2001 and fix issue comments hidden (#2016)
  * Update code.gitea.io/git (#2014)
  * Keep sort when switching page (#2013)
  * Important: wrong PR merge commit ID saved (#2007)
  * Don't show non-comments in comments API (#2001)
  * Fix "Dashboard shows deleted comments" (#1995)
  * Make branch deletion URL more like GitHub's, fixes #1397 (#1994)
  * Fix fast-forward PR bug (#1989)
  * Fix GPG email checking to be case insensitive (#1988)
  * fix bug for normal user visit public repo (#1984)
  * fix collborators lack of units on orgnization repositories (#1968)
  * Fix diff of renamed and modified file (#1967)
  * Fix uppercase default branch bug (#1965)
  * Fix bug in Action.loadRepo() (#1959)
  * Fix deleted milestone bug (#1942)
  * Fix engine bug in getIssueByID (#1934)
  * Switch to keybase go-crypto (for some elliptic curve key) + test (#1925)
  * Fix setting.AppPath for integration tests (#1923)
  * Fix search by issue type (#1914)
  * Fix ghost user bug (#1913)
  * Require token before checking membership/ownership (#1905)
  * Bug fixes for org member API (#1904)
  * A missing / to provide a correct endpoint (#1903)
  * Fix 500 in public activity page (#1901)
  * Center-aligned login topbar (#1880)
  * Migration to fix existing owner team units (#1873)
  * Fix paginater length (#1866)
  * Fix bug in removeOrgRepo (#1858)
  * Display draft releases (#1854)
  * Fix 404 for external tracking issues (#1852)
  * Update code.gitea.io/git (#1849)
  * Fix user profile activity feed (#1848)
  * Don't ignore error in getMergeCommit (#1843)
  * Fix locking bug in removeOrgRepo (#1842)
  * Fix status table race condition (#1835)
  * Fix PR template error (#1834)
  * Fix pull request compare link (#1832)
  * Use ghost users in issues/PRs (#1831)
  * Commitless repos should be bare (#1829)
  * Update code.gitea.io/git (#1824)
  * Fix invalid reference in feeds template (#1820)
  * fix bug to deny to add orgnization as a member of an orgnization or team (#1815)
  * xxx_active_code_live setting in printed in hours and minutes instead … (#1814)
  * Fix deadlock in updateRepository (#1813)
  * Give all units to owner team (#1812)
  * Fix 500 for GET /teams/:id endpoints (#1811)
  * fix bug not to trim space of login username (#1796)
  * Fix renaming bug (#1786)
  * Fix activity feed (#1779)
  * Make navbar scroll on overflow (#1777)
  * Delete repo redirects on repo deletion (#1776)
  * Fix unloaded owner bug (#1770)
  * Admin should always be allowed to create repositories even if hit limit (#1765)
  * Update HighlightJS and fix YAML files highlighting (#1764)
  * fix: #1757 fix set MAX_CREATION_LIMIT as zero. (#1762)
  * fix admin lost permission caused by #947 (#1753)
  * More fixes for dashboard search (#1750)
  * fixes wrong after field in webhook payload (#1746)
  * fix avatar update bug (#1729)
  * Fix FOUC on Firefox (#1728)
  * Fix changes introduce by update of go-swagger. (#1727)
  * Fix #1719 (#1722)
  * Correct flash after sending password reset email (#1718)
  * Fix and test for delete user (#1713)
  * Fix rendering of issue checkboxes (#1709)
  * Enforce netgo build tag while cross-compilation (#1690)
  * fix bug when push a branch name with / & fix an integration test bug (#1689)
  * fix potential sqlite lock (#1680)
  * Fix commit sha1 URL rendering in markdown (#1677)
  * Fix static files permission under public/ (#1675)
  * fix: tag contain character ) will http 500 on release page (#1670)
  * Fix CSS for code in wiki markdown (#1660)
  * fix multiple readme file rendering and fix #1657 (#1658)
  * Add primary key and index to external login user table (#1656)
  * fix #1643 and improve integration test (#1645)
  * Fix version in Makefile (#1636)
  * Handle display of GPG key without end date (#1628)
  * fix bug on issue view when not login (#1624)
  * bug fixed for API to get user's repos (#1622)
  * fix lost text color on button on set as primary email (#1621)
  * Add create_at and updated_at in PR json (#1616)
  * update git and fix #1133 (#1614)
  * fix bug on status API (#1533)
  * Do not show empty collaborators segment (#1531)
  * Fix markdown rendering (#1530)
  * fix go get sub package and add domain on installation to let go get work defaultly (#1518)
  * fix #1501 ssh hangs caused by #1461 (#1513)
  * Fix empty file download (#1506)
  * Fix broken v27 migration - change mirror interval from int to bigint (#1504)
  * Do not allow commiting to protected branch from online editor (#1502)
  * Add internal routes for ssh hook comands (#1471)
  * Fix races within code.gitea.io/git.(*Command).RunInDirTimeoutPipeline (#1465)
  * Simple quick fix for #1418 (#1456)
  * fix gpg API panic when no verification (#1451)
  * fix migrate failed and org dashboard failed on MSSQL database (#1448)
  * Optimize and fix autolink function (#1442) (#1444)
  * Fix and simplify repo branches (settings) UI (#1435)
  * Fix disabled fields in repo settings UI (#1431)
  * fixes pull request hanging when it contains normal and LFS files (#1425)
  * Fix races in the log module by using syncmap (#1421)
  * Add length check for the return string (#1420)
  * Fix "Error: No issue number specified"  when pushing (#1393)
  * Corrected Mirror.NextUpdate not set (#1388)
  * fix: remove `str2html` from org full name (#1360)
  * Correct broken unaligned load/store in armv5 (#1355)
  * Remove href on first/last link when on first/last page (#1345)
  * Fix broken table layout (#1344)
  * LFS: Fix SSH authentication for trailing arguments (#1328)
  * Remove empty file (#1326)
  * Fix delete user failed on sqlite (#1321)
  * Fix inconsistency in layout (#1316)
  * Fix gpg wrong column types (#1303)
  * Fix wiki bugs (#1294)
  * Fix missing less sources for oauth (#1288)
  * Make sure both scripts/ can live side by side (#1264)
  * Fix nil-dereference bug (#1258)
  * rewrite pre-commit, post-commit and options hooks (fixes #1250) (#1257)
  * Commit search appearence fixes (#1254)
  * Fix forget migration for wiki hooks (#1227)
  * Fix repo settings external tracker failed and check external urls (#1215)
  * Fix 500 caused by branches settings introduced by #1198 (#1214)
  * fix #1189, commit messages containing a pipe (#1203)
  * Bug fixed for delete repo failed (#1193)
  * Fix migration failed when authorized_keys is not exist (#1180)
  * Fix ini format incomiptable with crowdin (#1177)
* TESTING
  * Integration tests for issues API (#2059)
  * Add integration tests for signin (#2363)
  * Add INTERNAL_TOKEN to integration .ini file (#2346)
  * Add public links check (#2323)
  * Fix hooks for integration repo (#2216)
  * More integration tests for comment API (#2156)
  * Cache session cookies in tests (#2128)
  * Less verbose integration tests (#2123)
  * Fix improper setup for integration tests (#2050)
  * Improve integration test helper functions (#2049)
  * Add integration test for issue creating (#2002)
  * Use testing/benchmark interface (#1993)
  * Add integration test for repository migration (#1983)
  * Consolidate boilerplate in integration tests (#1979)
  * Set console to debug for integration tests (#1976)
  * Add pull-create integration test (#1972)
  * Coverage reports for integration tests (#1960)
  * Add integration test for pull-request merge (#1912)
  * Add integration test for file editing (#1907)
  * Add integration test for repository forking (#1896)
  * Run unused test (#1875)
  * Don't recreate database in integration tests (#1697)
  * remove sqlite tag when integration test with mysql/postgres and recreate database when init integration test (#1693)
  * MySQL, Postgres integration tests in drone (#1638)
  * improve integration test to resue models/fixtures and store git repos with tests (#1627)
  * Improve govendor testing (#1623)
  * Integration test framework (#1290)
  * Unit tests for issue_list (#1209)
  * Add integration test for signup (#1135)
* TRANSLATION
  * update translation from crowdin (#2368) (#2380)
  * Small fixes (#2144)
  * Missing signed commit display translations (#2134)
  * Sync latest translations from crowdin (#2104)
  * Add make command update-translations for update translations from crodwin (#2097)
  * Fix some mistakes (#1833)
  * Improve clarity between is_activated and prohibit_login (#1788)
  * Improve grammar (#1775)
  * Fix bad grammar and wordiness (#1741)
  * Make strings translatable (#1188) (#1198)
* BUILD
  * Dockerfile for aarch64 (#1128) (#1130)
  * backport from v1.2 branch: add secrets for github release (#2588) (#2598)
  * Add secrets for github release to fix drone failed (#2588)
  * Backport changes for latest drone (#2586)
  * Removing .drone.yml.sig (#2579)
  * Fix drone for tags (#2573) (#2576)
  * Backport: Remove go version check for make fmt (#2558) (#2561)
  * Backport: Fix lint, fmt and integration testing errors (#2553)
  * update latest xorm version to vendor (#2353)
  * Remove integration test executables on `make clean` (#2340)
  * refactor(Makefile): allow overriding default go program (#2310)
  * Revert to upstream ini dependency (#2304)
  * Use /dev/urandom to create random password (#2298)
  * update drone sig file. (#2262)
  * go get github.com/wadey/gocovmerge when needed (#2235)
  * fix typo (#2145)
  * Revert "Reduce number of layer" (#2086)
  * Reduce number of layer (#2078)
  * Skip sqlite integration in CI (#2058)
  * fix golint error and rename func for suggestion. (#1997)
  * fix misspell (#1996)
  * update drone sig file (#1981)
  * send notification if status changed (#1973)
  * switch gitter to discord for drone. (#1971)
  * Fix missing backslash in Dockerfile.rpi (#1952)
  * Don't run 'make release' on PRs (#1908)
  * Update code.gitea.io/git (#1892)
  * Use production version of vuejs (#1869)
  * Add a variable for docker tag (#1825)
  * resign drone and fix #1816 (#1819)
  * Separate generate swagger + fix sed os specific (#1791)
  * Only run coverage on merges/pushes to master (#1783)
  * Remove stale rule from Makefile (#1782)
  * feat: upgrade drone docker image to support multi-stage build. (#1732)
  * Realy don't cache apk index (#1694)
  * Limit clone depth when drone-building (#1644)
  * Refactor Dockerfile (#1632)
  * Check if missing/modified/unused deps in vendor and fix errors (#1468)
  * Add GOFLAGS and EXTRA_GOFLAGS (#1438)
  * Include formatting check to the `make test` (and thus also `check`) rule (#1366)
* DOCS
  * fix wrong changelog title (#2395)
  * fix webhook link (#2289)
  * Improve swagger doc (#2274)
  * Add link to forum in issue template (#2070)
  * add missing lfs config on example file (#2039)
  * Add discourse link (#2027)
  * Fix wording (#2024)
  * Fix typo (#1974)
  * Swagger docs for list/create forks (#1941)
  * Update links to Discord server (#1940)
  * [ci skip] update discord badge. (#1930)
  * Change join chat from gitter to discord (#1929)
  * Update changelog with v1.1.1 (#1926)
  * Correct grammar in APIEmpty documentation (#1748)
  * Add swagger comment for MirrorSync (#1747)
  * Add "Table of Contents" in CONTRIBUTING.md (#1634)
  * Fix service description in Debian init file (#1538)
  * Use MAINTAINERS file in repository in CONTRIBUTING (#1489)
  * Generate swagger json (#1402)
  * Changed text when password reset disabled. (#1364)
  * Removed email copyright year (#1348)
  * Specify that time interval units are seconds (#1311)
  * Gitea OpenID-2.0 login has been tested with livejournal.com too (#1306)
  * Make wording of commit search more clear (#1291)
  * Add notice that LFS mirroring is not supported (#1251)
  * Fix typos in models/ and modules/ (#1248)
  * Refactor and fix incorrect comment (#1247)
  * Fix migration comment (#1241)
  * Update locale_en-US.ini (#1235)
  * Add LibreJS support (#1201)
  * rename OSX to macOS (#1176)
  * add mssql to app.ini db config comment (#1172)
  * Add MSSQL to issues template (#1171)
* MISC
  * Add badge and link to the Matrix room (#2348)
  * ignore coverage steps. (#2257)
  * Use sqlite3 database as default for Docker image (#2182)
  * update drone discord plugin to 0.0.4 version (#1992)
  * fix typo (#1990)
  * Move 3rd party js/css into `public/vendor` and document sources (#2383)
  * Prevent conflicting TOTP accounts by adding AppURL to issuer parameter (#2335)
  * Fix variable name typo (#2327)
  * Make use of Vue more universal (#2318)
  * Remove (almost) server side data rendering from repo-search component (#2317)
  * Add OpenID configuration in install page (#2276)
  * More tweaks to repo top panel (#2267)
  * File path tweaks in UI (#2264)
  * Make SHOW_USER_EMAIL also apply to profiles (#2258)
  * EnableUnit() -> UnitEnabled() (#2242)
  * Prevent selection of diff line numbers (#2240)
  * Remove unused variable on makefile (#2225)
  * No error log entries for repo 404 (#2200)
  * Refactor vue delimeters to use es6 template delimeters (#2171)
  * Replace tmp with TMPDIR. (#2152)
  * Remove unused files (#2124)
  * Improve org error handling (#2117)
  * Absolute path for setting.CustomConf (#2085)
  * remove deprecated code for Gogs compitable (#2041)
  * Refactor session close as xorm already does everything needed internally  (#2020)
  * SQLite has a query timeout. Hopefully fixes most 'database locked' errors (#1961)
  * Use monospace font in githook editor (#1958)
  * Fix import order (#1951)
  * Gracefully handle bare repositories on API operations. (#1932)
  * Fix errors caused by force push (#1927)
  * Display URLs in integration test logs (#1924)
  * Set TMPDIR enviroment variable for dump command (#1915)
  * Cache ctx.User in retrieveFeeds (#1902)
  * Make `LocalCopyPath` a setting instead of a hard-coded path (#1881)
  * Add check misspelling (#1877)
  * Fix misspelled variables (#1874)
  * Gofmt (#1868, #1710, #1662)
  * Rename misnamed migration (#1867)
  * Support CRLF when splitting code lines for display (#1862)
  * Add convert less css file step. (#1861)
  * Prevent accidential selection of line numbers in code view (#1860)
  * Delete Public SSH Key tmp file after calculating fingerprint (#1855)
  * Remove annoying difference in button heights. (#1853)
  * Only run test coverage on master branch. (#1838)
  * Error from mktemp command in MacOS. (#1837)
  * Use writeTmpKeyFile in calcFingerprint (#1828)
  * ROOT_URL setting use the default as shown in conf/app.ini (#1823)
  * Rename RepoCreationNum -> MaxCreationLimit (#1766)
  * Add button to admin ui (#1738)
  * Correct spelling mistakes (#1703)
  * Make openid support default false for compitable with v1.1 (#1650)
  * Send mails as HTML as default. Setting for send as plain text. (#1648)
  * fix potential lock when sqlite (#1647)
  * Optimize png images via Google zopflipng [ci skip] (#1639)
  * Upgrade alpine to v3.5 in Dockerfile (#1633)
  * remove unused vendor packages (#1620)
  * markup: microoptimise for many short filenames in directory (#1534)
  * support health check via / and fix #969 (#1520)
  * Remove env user salt since no need to use (#1515)
  * Drop db operations from hook commands (#1514)
  * Better URL validation (#1507)
  * Migrate WatchInfo struct to api (#1492)
  * refactor: show command help message. (#1486)
  * refactor update ssh key use time (#1466)
  * Set VERSION from git once, in a variable (#1447)
  * Remove unused mutex field (#1440)
  * Simplify settings pages with item list (#1389)
  * Clean-up PostgreSQL Tests (#1361)
  * refactor: remove workaround after the golang 1.7 release. (#1349)
  * Delete the useless code (#1335)
  * Run "make fmt" with go-1.6 (#1333)
  * Refactor admin/auth/new.tmpl (#1277)
  * Refactor repo/issue/view_content.tmpl (#1276)
  * Cleaner ui for admin, repo settings, and user settings page (#1269) (#1270)
  * Cleaner UI for explore page (#1253) (#1255)
  * Synced licenses with github repo (#1246)
  * Synced gitignores with github repo (#1245)
  * Simplify RepositoryList.loadAttributes() (#1211)
  * Move user_follow to separate file (#1210)
  * Reduce conditionals in signin/signup inner forms (#1138)

## [1.1.4](https://github.com/go-gitea/gitea/releases/tag/v1.1.4) - 2017-09-04

* BUGFIXES
  * Fix rendering of external links (#2292) (#2315)
  * Fix deleted milestone bug (#1942) (#2300)
  * fix 500 error when view an issue which's milestone deleted (#2297) (#2299)
  * Fix SHA1 hash linking (#2143) (#2293)
  * back port from #1709 (#2291)

## [1.1.3](https://github.com/go-gitea/gitea/releases/tag/v1.1.3) - 2017-08-03

* BUGFIXES
  * Fix PR template error (#2008)
  * Fix markdown rendering (fix #1530) (#2043)
  * Fix missing less sources for oauth (backport #1288) (#2135)
  * Don't ignore gravatar error (#2138)
  * Fix diff of renamed and modified file (#2136)
  * Fix fast-forward PR bug (#2137)
  * Fix some security bugs

## [1.1.2](https://github.com/go-gitea/gitea/releases/tag/v1.1.2) - 2017-06-13

* BUGFIXES
  * Enforce netgo build tag while cross-compilation (Backport of #1690) (#1731)
  * fix update avatar
  * fix delete user failed on sqlite (#1321)
  * fix bug not to trim space of login username (#1806)
  * Backport bugfixes #1220 and #1393 to v1.1 (#1758)

## [1.1.1](https://github.com/go-gitea/gitea/releases/tag/v1.1.1) - 2017-05-04

* BUGFIXES
  * Markdown Sanitation Fix [#1646](https://github.com/go-gitea/gitea/pull/1646)
  * Fix broken hooks [#1376](https://github.com/go-gitea/gitea/pull/1376)
  * Fix migration issue [#1375](https://github.com/go-gitea/gitea/pull/1375)
  * Fix Wiki Issues [#1338](https://github.com/go-gitea/gitea/pull/1338)
  * Forgotten migration for wiki githooks [#1237](https://github.com/go-gitea/gitea/pull/1237)
  * Commit messages can contain pipes [#1218](https://github.com/go-gitea/gitea/pull/1218)
  * Verify external tracker URLs [#1236](https://github.com/go-gitea/gitea/pull/1236)
  * Allow upgrade after downgrade [#1197](https://github.com/go-gitea/gitea/pull/1197)
  * 500 on delete repo with issue [#1195](https://github.com/go-gitea/gitea/pull/1195)
  * INI compat with CrowdIn [#1192](https://github.com/go-gitea/gitea/pull/1192)

## [1.1.0](https://github.com/go-gitea/gitea/releases/tag/v1.1.0) - 2017-03-09

* BREAKING
  * The SSH keys can potentially break, make sure to regenerate the authorized keys
* FEATURE
  * Git LFSv2 support [#122](https://github.com/go-gitea/gitea/pull/122)
  * API endpoints for repo watching [#191](https://github.com/go-gitea/gitea/pull/191)
  * Search within private repos [#222](https://github.com/go-gitea/gitea/pull/222)
  * Hide user email address on explore page [#336](https://github.com/go-gitea/gitea/pull/336)
  * Protected branch system [#339](https://github.com/go-gitea/gitea/pull/339)
  * Sendmail for mail delivery [#355](https://github.com/go-gitea/gitea/pull/355)
  * API endpoints for org webhooks [#372](https://github.com/go-gitea/gitea/pull/372)
  * Enabled MSSQL support [#383](https://github.com/go-gitea/gitea/pull/383)
  * API endpoints for org teams [#370](https://github.com/go-gitea/gitea/pull/370)
  * API endpoints for collaborators [#375](https://github.com/go-gitea/gitea/pull/375)
  * Graceful server restart [#416](https://github.com/go-gitea/gitea/pull/416)
  * Commitgraph / timeline on commits page [#428](https://github.com/go-gitea/gitea/pull/428)
  * API endpoints for repo forks [#509](https://github.com/go-gitea/gitea/pull/509)
  * API endpoints for releases [#510](https://github.com/go-gitea/gitea/pull/510)
  * Folder jumping [#511](https://github.com/go-gitea/gitea/pull/511)
  * Stars tab on profile page [#519](https://github.com/go-gitea/gitea/pull/519)
  * Notification system [#523](https://github.com/go-gitea/gitea/pull/523)
  * Push and pull through reverse proxy basic auth [#524](https://github.com/go-gitea/gitea/pull/524)
  * Search for issues and pull requests [#530](https://github.com/go-gitea/gitea/pull/530)
  * API endpoint for stargazers [#597](https://github.com/go-gitea/gitea/pull/597)
  * API endpoints for subscribers [#598](https://github.com/go-gitea/gitea/pull/598)
  * PID file support [#610](https://github.com/go-gitea/gitea/pull/610)
  * Two factor authentication (2FA) [#630](https://github.com/go-gitea/gitea/pull/630)
  * API endpoints for org users [#645](https://github.com/go-gitea/gitea/pull/645)
  * Release attachments [#673](https://github.com/go-gitea/gitea/pull/673)
  * OAuth2 consumer [#679](https://github.com/go-gitea/gitea/pull/679)
  * Add ability to fork your own repos [#761](https://github.com/go-gitea/gitea/pull/761)
  * Search repository on dashboard [#773](https://github.com/go-gitea/gitea/pull/773)
  * Search bar on user profile [#787](https://github.com/go-gitea/gitea/pull/787)
  * Track label changes on issue view [#788](https://github.com/go-gitea/gitea/pull/788)
  * Allow using custom time format [#798](https://github.com/go-gitea/gitea/pull/798)
  * Redirects for renamed repos [#807](https://github.com/go-gitea/gitea/pull/807)
  * Track assignee changes on issue view [#808](https://github.com/go-gitea/gitea/pull/808)
  * Track title changes on issue view [#841](https://github.com/go-gitea/gitea/pull/841)
  * Archive cleanup action [#885](https://github.com/go-gitea/gitea/pull/885)
  * Basic Open Graph support [#901](https://github.com/go-gitea/gitea/pull/901)
  * Take back control of Git hooks [#1006](https://github.com/go-gitea/gitea/pull/1006)
  * API endpoints for user repos [#1059](https://github.com/go-gitea/gitea/pull/1059)
* BUGFIXES
  * Fixed counting issues for issue filters [#413](https://github.com/go-gitea/gitea/pull/413)
  * Added back default settings for SSH [#500](https://github.com/go-gitea/gitea/pull/500)
  * Fixed repo permissions [#513](https://github.com/go-gitea/gitea/pull/513)
  * Issues cannot be created with labels [#622](https://github.com/go-gitea/gitea/pull/622)
  * Add a reserved wiki paths check to the wiki [#720](https://github.com/go-gitea/gitea/pull/720)
  * Update website binding MaxSize to 255 [#722](https://github.com/go-gitea/gitea/pull/722)
  * User can see the private activity on public history [#818](https://github.com/go-gitea/gitea/pull/818)
  * Wrong pages number which includes private repositories [#844](https://github.com/go-gitea/gitea/pull/844)
  * Trim whitespaces for search keyword [#893](https://github.com/go-gitea/gitea/pull/893)
  * Don't rewrite non-gitea public keys [#906](https://github.com/go-gitea/gitea/pull/906)
  * Use fingerprint to check instead content for public key [#911](https://github.com/go-gitea/gitea/pull/911)
  * Fix random avatars [#1147](https://github.com/go-gitea/gitea/pull/1147)
* ENHANCEMENT
  * Refactored process manager [#75](https://github.com/go-gitea/gitea/pull/75)
  * Restrict rights to create new orgs [#193](https://github.com/go-gitea/gitea/pull/193)
  * Added label and milestone sorting [#199](https://github.com/go-gitea/gitea/pull/199)
  * Make minimum password length configurable [#223](https://github.com/go-gitea/gitea/pull/223)
  * Speedup conflict checking on pull requests [#276](https://github.com/go-gitea/gitea/pull/276)
  * Added button to delete merged pull request branches [#441](https://github.com/go-gitea/gitea/pull/441)
  * Improved issue references within markdown [#471](https://github.com/go-gitea/gitea/pull/471)
  * Dutch translation for the landingpage [#487](https://github.com/go-gitea/gitea/pull/487)
  * Added Gogs migration script [#532](https://github.com/go-gitea/gitea/pull/532)
  * Support a .gitea folder for issue templates [#582](https://github.com/go-gitea/gitea/pull/582)
  * Enhanced diff-view coloring [#584](https://github.com/go-gitea/gitea/pull/584)
  * Added ETag header to avatars [#721](https://github.com/go-gitea/gitea/pull/721)
  * Added option to config to disable local path imports [#724](https://github.com/go-gitea/gitea/pull/724)
  * Allow custom public files [#782](https://github.com/go-gitea/gitea/pull/782)
  * Added pprof endpoint for debugging [#801](https://github.com/go-gitea/gitea/pull/801)
  * Added `X-GitHub-*` headers [#809](https://github.com/go-gitea/gitea/pull/809)
  * Fill SSH key title automatically [#863](https://github.com/go-gitea/gitea/pull/863)
  * Display Git version on admin panel [#921](https://github.com/go-gitea/gitea/pull/921)
  * Expose URL field on issue API [#982](https://github.com/go-gitea/gitea/pull/982)
  * Statically compile the binaries [#985](https://github.com/go-gitea/gitea/pull/985)
  * Embed build tags into version string [#1051](https://github.com/go-gitea/gitea/pull/1051)
  * Gitignore support for FSharp and Clojure [#1072](https://github.com/go-gitea/gitea/pull/1072)
  * Custom templates for static builds [#1087](https://github.com/go-gitea/gitea/pull/1087)
  * Add ProxyFromEnvironment if none set [#1096](https://github.com/go-gitea/gitea/pull/1096)
* MISC
  * Replaced remaining Gogs references
  * Added more tests on various packages
  * Use Crowdin for translations again
  * Resolved some XSS attack vectors
  * Optimized and reduced number of database queries

## [1.0.2](https://github.com/go-gitea/gitea/releases/tag/v1.0.2) - 2017-02-21

* BUGFIXES
  * Fixed issue counter [#882](https://github.com/go-gitea/gitea/pull/882)
  * Fixed XSS vulnerability on wiki page [#955](https://github.com/go-gitea/gitea/pull/955)
  * Add data dir without session to dump [#587](https://github.com/go-gitea/gitea/pull/587)
  * Fixed wiki page renaming [#958](https://github.com/go-gitea/gitea/pull/958)
  * Drop default console logger if not required [#960](https://github.com/go-gitea/gitea/pull/960)
  * Fixed docker docs link on install page [#972](https://github.com/go-gitea/gitea/pull/972)
  * Handle SetModel errors [#957](https://github.com/go-gitea/gitea/pull/957)
  * Fixed XSS vulnerability on milestones [#977](https://github.com/go-gitea/gitea/pull/977)
  * Fixed XSS vulnerability on alerts [#981](https://github.com/go-gitea/gitea/pull/981)

## [1.0.1](https://github.com/go-gitea/gitea/releases/tag/v1.0.1) - 2017-01-05

* BUGFIXES
  * Fixed localized `MIN_PASSWORD_LENGTH` [#501](https://github.com/go-gitea/gitea/pull/501)
  * Fixed 500 error on organization delete [#507](https://github.com/go-gitea/gitea/pull/507)
  * Ignore empty wiki repo on migrate [#544](https://github.com/go-gitea/gitea/pull/544)
  * Proper check access for forking [#563](https://github.com/go-gitea/gitea/pull/563)
  * Fix SSH domain on installer [#506](https://github.com/go-gitea/gitea/pull/506)
  * Fix missing data rows on admin UI [#580](https://github.com/go-gitea/gitea/pull/580)
  * Do not delete tags with releases by default [#579](https://github.com/go-gitea/gitea/pull/579)
  * Fix missing session config data on admin UI [#578](https://github.com/go-gitea/gitea/pull/578)
  * Properly show the version within footer on the UI [#593](https://github.com/go-gitea/gitea/pull/593)

## [1.0.0](https://github.com/go-gitea/gitea/releases/tag/v1.0.0) - 2016-12-23

* BREAKING
  * We have various changes on the API, scripting against API must be updated
* FEATURE
  * Show last login for admins [#121](https://github.com/go-gitea/gitea/pull/121)
* BUGFIXES
  * Fixed sender of notifications [#2](https://github.com/go-gitea/gitea/pull/2)
  * Fixed keyword hijacking vulnerability [#20](https://github.com/go-gitea/gitea/pull/20)
  * Fixed non-markdown readme rendering [#95](https://github.com/go-gitea/gitea/pull/95)
  * Allow updating draft releases [#169](https://github.com/go-gitea/gitea/pull/169)
  * GitHub API compliance [#227](https://github.com/go-gitea/gitea/pull/227)
  * Added commit SHA to tag webhook [#286](https://github.com/go-gitea/gitea/issues/286)
  * Secured links via noopener [#315](https://github.com/go-gitea/gitea/issues/315)
  * Replace tabs with spaces on wiki title [#371](https://github.com/go-gitea/gitea/pull/371)
  * Fixed vulnerability on labels and releases [#409](https://github.com/go-gitea/gitea/pull/409)
  * Fixed issue comment API [#449](https://github.com/go-gitea/gitea/pull/449)
* ENHANCEMENT
  * Use proper import path for libravatar [#3](https://github.com/go-gitea/gitea/pull/3)
  * Integrated DroneCI for tests and builds [#24](https://github.com/go-gitea/gitea/issues/24)
  * Integrated dependency manager [#29](https://github.com/go-gitea/gitea/issues/29)
  * Embedded bindata optionally [#30](https://github.com/go-gitea/gitea/issues/30)
  * Integrated pagination for releases [#73](https://github.com/go-gitea/gitea/pull/73)
  * Autogenerate version on every build [#91](https://github.com/go-gitea/gitea/issues/91)
  * Refactored Docker container [#104](https://github.com/go-gitea/gitea/issues/104)
  * Added short-hash support for downloads [#211](https://github.com/go-gitea/gitea/issues/211)
  * Display tooltip for downloads [#221](https://github.com/go-gitea/gitea/issues/221)
  * Improved HTTP headers for issue attachments [#270](https://github.com/go-gitea/gitea/pull/270)
  * Integrate public as bindata optionally [#293](https://github.com/go-gitea/gitea/pull/293)
  * Integrate templates as bindata optionally [#314](https://github.com/go-gitea/gitea/pull/314)
  * Inject more ENV variables into custom hooks [#316](https://github.com/go-gitea/gitea/issues/316)
  * Correct LDAP login validation [#342](https://github.com/go-gitea/gitea/pull/342)
  * Integrate conf as bindata optionally [#354](https://github.com/go-gitea/gitea/pull/354)
  * Serve video files in browser [#418](https://github.com/go-gitea/gitea/pull/418)
  * Configurable SSH host binding [#431](https://github.com/go-gitea/gitea/issues/431)
* MISC
  * Forked from Gogs and renamed to Gitea
  * Catching more errors with logs
  * Fixed all linting errors
  * Made the go linter entirely happy
  * Really integrated vendoring
