package handler

import (
	"cart/domain/model"
	"cart/domain/service"
	cart "cart/proto/cart"
	"context"
	"git.imooc.com/jayzone/common"
)
type Cart struct{
     CartDataService service.ICartDataService
}

func (c *Cart) AddCart(ctx context.Context, request *cart.CartInfo, response *cart.ResponseAdd) (err error) {
	cart := new(model.Cart)
	common.SwapTo(request, cart)
	response.CartId, err = c.CartDataService.AddCart(cart)
	return err
}

func (c *Cart) CleanCart(ctx context.Context, request *cart.Clean, response *cart.Response) error {
	if err := c.CartDataService.CleanCart(request.UserId); err != nil {
		return err
	}
	response.Msg = "购物车清空成功"
	return nil
}

func (c *Cart) Incr(ctx context.Context, request *cart.Item, response *cart.Response) error {
	err := c.CartDataService.IncrNum(request.Id, request.ChangeNum)
	if err != nil {
		return err
	}
	response.Msg = "购购物车添加成功"
	return nil
}

func (c *Cart) Decr(ctx context.Context, request *cart.Item, response *cart.Response) error {
	err := c.CartDataService.DecrNum(request.Id, request.ChangeNum)
	if err != nil {
		return err
	}
	response.Msg = "购物车减少成功"
	return nil
}

func (c *Cart) DeleteItemByID(ctx context.Context, request *cart.CartID, response *cart.Response) error {
	err := c.CartDataService.DeleteCart(request.CartId)
	if err != nil {
		return err
	}
	response.Msg = "购物车删除成功"
	return nil
}

func (c *Cart) GetAll(ctx context.Context, request *cart.CartFindAll, response *cart.CartAll) error {
	cartAll, err := c.CartDataService.FindAllCart(request.UserId)
	if err != nil {
		return err
	}
	for _, v := range cartAll {
		cart := new(cart.CartInfo)
		if err := common.SwapTo(v, cart); err != nil {
			return err
		}
		response.CartInfo = append(response.CartInfo, cart)
	}
	return nil

}
