package bolt

import (
	"time"

	"git.orcatech.org/sdks/golang/config"
)

/* This is generated code */

const (
	// ConfigName the configuration subsection name when embeding in other configurations
	ConfigName = "bolt"

	// configDatabase Configuration key for setting database
	configDatabase = "database"

	// defaultDatabase Default value for setting database
	defaultDatabase string = "/tmp/bolt.db"

	// configOpenTimeout Configuration key for setting open_timeout
	configOpenTimeout = "open_timeout"

	// defaultOpenTimeout Default value for setting open_timeout
	defaultOpenTimeout time.Duration = 10 * time.Second
)

// NewConfig Returns a set of configuration options parsed from command line flags and/or configuration file
func NewConfig() *Configuration {
	return &Configuration{
		Sectioner: config.Append(
			config.NewSection("bolt",
				config.NewSetting(configDatabase, defaultDatabase, "Path to database file to use as permenent storage"),
				config.NewSetting(configOpenTimeout, defaultOpenTimeout, "How long wait for other processes to close their handle to the db"),
			),
		),
	}
}

// Configuration configuration options read in from the a configuration file and
// parsed from configuration flags
type Configuration struct {
	config.Sectioner
}

// Database Path to database file to use as permenent storage
func (c *Configuration) Database() string {
	return c.Setting(configDatabase).String()
}

// OpenTimeout How long wait for other processes to close their handle to the db
func (c *Configuration) OpenTimeout() time.Duration {
	return c.Setting(configOpenTimeout).Duration()
}
