package bolt

import (
	bolt "github.com/coreos/bbolt"
)

type Cursor struct {
	cursor  *bolt.Cursor
	options Optioner
}

func (b *Cursor) Bucket() *Bucket {
	return &Bucket{bucket: b.cursor.Bucket(), options: b.options}
}

func (b *Cursor) Delete() error {
	return b.cursor.Delete()
}

func (b *Cursor) First() (key []byte, value []byte, err error) {
	return b.decrypt(b.cursor.First())
}

func (b *Cursor) Last() (key []byte, value []byte, err error) {
	return b.decrypt(b.cursor.Last())
}

func (b *Cursor) Next() (key []byte, value []byte, err error) {
	return b.decrypt(b.cursor.Next())
}

func (b *Cursor) Prev() (key []byte, value []byte, err error) {
	return b.decrypt(b.cursor.Prev())
}

func (b *Cursor) Seek(seek []byte) (key []byte, value []byte, err error) {
	return b.decrypt(b.cursor.Seek(seek))
}

func (b *Cursor) decrypt(key []byte, value []byte) ([]byte, []byte, error) {
	v, err := decrypt(b.options, value)
	return key, v, err
}
