package bolt

import (
	"time"
	
)
/* This is generated code */

// Optioner ...
type Optioner interface {

	// Database Path to database file to use as permenent storage
	Database() string

	// OpenTimeout How long wait for other processes to close their handle to the db
	OpenTimeout() time.Duration
}

// Options a set of configurable options that can be set at runtime
type Options struct {

	// OptionDatabase Path to database file to use as permenent storage
	OptionDatabase string

	// OptionOpenTimeout How long wait for other processes to close their handle to the db
	OptionOpenTimeout time.Duration
}

// NewOptions Returns a set of configurable options that can be set at runtime
// and are initially set to the default values.
func NewOptions() *Options {
	return &Options{
		OptionDatabase: defaultDatabase,
		OptionOpenTimeout: defaultOpenTimeout,
	}
}

// Database Returns the Database to satisfy the Optioner interface
func (o *Options) Database() string {
	return o.OptionDatabase
}

// OpenTimeout Returns the OpenTimeout to satisfy the Optioner interface
func (o *Options) OpenTimeout() time.Duration {
	return o.OptionOpenTimeout
}
