package bolt

import (
	"io"
	"os"

	bolt "github.com/coreos/bbolt"
)

type Tx struct {
	tx      *bolt.Tx
	options Optioner
}

func (t *Tx) Bucket(name []byte) *Bucket {
	return &Bucket{
		bucket:  t.tx.Bucket(name),
		options: t.options,
	}
}

func (t *Tx) Check() <-chan error {
	return t.tx.Check()
}

func (t *Tx) Commit() error {
	return t.tx.Commit()
}

func (t *Tx) Copy(w io.Writer) error {
	return t.tx.Copy(w)
}

func (t *Tx) CopyFile(path string, mode os.FileMode) error {
	return t.tx.CopyFile(path, mode)
}

func (t *Tx) CreateBucket(name []byte) (*Bucket, error) {
	b, err := t.tx.CreateBucket(name)
	if err != nil {
		return nil, err
	}
	return &Bucket{bucket: b, options: t.options}, nil
}

func (t *Tx) CreateBucketIfNotExists(name []byte) (*Bucket, error) {
	b, err := t.tx.CreateBucketIfNotExists(name)
	if err != nil {
		return nil, err
	}
	return &Bucket{bucket: b, options: t.options}, nil
}

func (t *Tx) Cursor() *Cursor {
	return &Cursor{cursor: t.tx.Cursor(), options: t.options}
}

func (t *Tx) DB() *DB {
	return &DB{db: t.tx.DB(), options: t.options}
}
