package bolt

import (
	"os"
	"testing"

	"git.orcatech.org/sdks/golang/log/v2"
	bolt "github.com/coreos/bbolt"
)

func initLogger(t *testing.T) {
	lopts := log.NewOptions()
	lopts.OptionLevel = log.LevelTest
	lopts.OptionPrependFile = true
	lopts.OptionProcessor = log.ProcessorSTR
	log.SetOptions(lopts)
	log.Testing(t)
}

const (
	dstPath  = "./tests/dst.db"
	dstPath2 = "./tests/dst2.db"
)

func TestTxCommit(t *testing.T) {
	initLogger(t)

	if err := os.Remove(dstPath); err != nil {
		t.Fatal(err)
	}

	dst, err := bolt.Open("./tests/dst.db", 0600, bolt.DefaultOptions)
	if err != nil {
		t.Fatal(err)
	}
	defer dst.Close()

	src, err := bolt.Open("./tests/571nyce.db", 0600, bolt.DefaultOptions)
	if err != nil {
		t.Fatal(err)
	}

	if err := compactInBatches(dst, src); err != nil {
		t.Fatal(err)
	}
}
