# FUSE

As a golang project, `go-ipfs` is easily downloaded and installed with `go get github.com/jbenet/go-ipfs`. All data is stored in a leveldb data store in `~/.go-ipfs/datastore`. If, however, you would like to mount the datastore (`ipfs mount /ipfs`) and use it as you would a normal filesystem, you will need to install fuse.

As a precursor, you will have to create the `/ipfs` and `/ipns` directories explicitly. Note that modifying root requires sudo permissions.

```sh
# make the directories
sudo mkdir /ipfs
sudo mkdir /ipns

# chown them so ipfs can use them without root permissions
sudo chown <username> /ipfs
sudo chown <username> /ipns
```

## Mac OSX -- OSXFUSE

It has been discovered that versions of `osxfuse` prior to `2.7.0` will cause a kernel panic. For everyone's sake, please upgrade (latest at time of writing is `2.7.4`). The installer can be found at https://osxfuse.github.io/. There is also a homebrew formula (`brew install osxfuse`) but users report best results installing from the official OSXFUSE installer package.

Note that `ipfs` attempts an automatic version check on `osxfuse` to prevent you from shooting yourself in the foot if you have pre `2.7.0`. Since checking the OSXFUSE version [is more complicated than it should be], running `ipfs mount` may require you to install another binary:

```sh
go get github.com/jbenet/go-fuse-version/fuse-version
```

If you run into any problems installing FUSE or mounting IPFS, hop on IRC and speak with us, or if you figure something new out, please add to this document!

## Linux

Install `fuse` with your favorite package manager:

```
sudo apt-get install fuse
```

Then change permissions on the fuse config:

```sh
sudo chown <username>:<groupname> /etc/fuse.conf
```

(note `<groupname>` should probably be `fuse`)

## Troubleshooting

If the mount command crashes and your mountpoint gets stuck:

```
sudo umount /ipfs
sudo umount /ipns
```

If you manage to mount on other systems (or followed an alternative path to one above), please contribute to these docs :D
