package kernel32

import "syscall"

var (
	kernel32                                      = syscall.NewLazyDLL("kernel32.dll")
	acquireSRWLockExclusive                       = kernel32.NewProc("AcquireSRWLockExclusive")
	acquireSRWLockShared                          = kernel32.NewProc("AcquireSRWLockShared")
	activateActCtx                                = kernel32.NewProc("ActivateActCtx")
	addAtomA                                      = kernel32.NewProc("AddAtomA")
	addAtomW                                      = kernel32.NewProc("AddAtomW")
	addConsoleAliasA                              = kernel32.NewProc("AddConsoleAliasA")
	addConsoleAliasW                              = kernel32.NewProc("AddConsoleAliasW")
	addIntegrityLabelToBoundaryDescriptor         = kernel32.NewProc("AddIntegrityLabelToBoundaryDescriptor")
	addLocalAlternateComputerNameA                = kernel32.NewProc("AddLocalAlternateComputerNameA")
	addLocalAlternateComputerNameW                = kernel32.NewProc("AddLocalAlternateComputerNameW")
	addRefActCtx                                  = kernel32.NewProc("AddRefActCtx")
	addSIDToBoundaryDescriptor                    = kernel32.NewProc("AddSIDToBoundaryDescriptor")
	addSecureMemoryCacheCallback                  = kernel32.NewProc("AddSecureMemoryCacheCallback")
	addVectoredContinueHandler                    = kernel32.NewProc("AddVectoredContinueHandler")
	addVectoredExceptionHandler                   = kernel32.NewProc("AddVectoredExceptionHandler")
	adjustCalendarDate                            = kernel32.NewProc("AdjustCalendarDate")
	allocConsole                                  = kernel32.NewProc("AllocConsole")
	allocateUserPhysicalPages                     = kernel32.NewProc("AllocateUserPhysicalPages")
	allocateUserPhysicalPagesNuma                 = kernel32.NewProc("AllocateUserPhysicalPagesNuma")
	applicationRecoveryFinished                   = kernel32.NewProc("ApplicationRecoveryFinished")
	applicationRecoveryInProgress                 = kernel32.NewProc("ApplicationRecoveryInProgress")
	areFileApisANSI                               = kernel32.NewProc("AreFileApisANSI")
	assignProcessToJobObject                      = kernel32.NewProc("AssignProcessToJobObject")
	attachConsole                                 = kernel32.NewProc("AttachConsole")
	backupRead                                    = kernel32.NewProc("BackupRead")
	backupSeek                                    = kernel32.NewProc("BackupSeek")
	backupWrite                                   = kernel32.NewProc("BackupWrite")
	baseCheckAppcompatCache                       = kernel32.NewProc("BaseCheckAppcompatCache")
	baseCheckAppcompatCacheEx                     = kernel32.NewProc("BaseCheckAppcompatCacheEx")
	baseCheckRunApp                               = kernel32.NewProc("BaseCheckRunApp")
	baseCleanupAppcompatCacheSupport              = kernel32.NewProc("BaseCleanupAppcompatCacheSupport")
	baseDllReadWriteIniFile                       = kernel32.NewProc("BaseDllReadWriteIniFile")
	baseDumpAppcompatCache                        = kernel32.NewProc("BaseDumpAppcompatCache")
	baseFlushAppcompatCache                       = kernel32.NewProc("BaseFlushAppcompatCache")
	baseFormatObjectAttributes                    = kernel32.NewProc("BaseFormatObjectAttributes")
	baseFormatTimeOut                             = kernel32.NewProc("BaseFormatTimeOut")
	baseGenerateAppCompatData                     = kernel32.NewProc("BaseGenerateAppCompatData")
	baseGetNamedObjectDirectory                   = kernel32.NewProc("BaseGetNamedObjectDirectory")
	baseInitAppcompatCacheSupport                 = kernel32.NewProc("BaseInitAppcompatCacheSupport")
	baseIsAppcompatInfrastructureDisabled         = kernel32.NewProc("BaseIsAppcompatInfrastructureDisabled")
	baseQueryModuleData                           = kernel32.NewProc("BaseQueryModuleData")
	baseSetLastNTError                            = kernel32.NewProc("BaseSetLastNTError")
	baseThreadInitThunk                           = kernel32.NewProc("BaseThreadInitThunk")
	baseUpdateAppcompatCache                      = kernel32.NewProc("BaseUpdateAppcompatCache")
	baseVerifyUnicodeString                       = kernel32.NewProc("BaseVerifyUnicodeString")
	basep8BitStringToDynamicUnicodeString         = kernel32.NewProc("Basep8BitStringToDynamicUnicodeString")
	basepAllocateActivationContextActivationBlock = kernel32.NewProc("BasepAllocateActivationContextActivationBlock")
	basepAnsiStringToDynamicUnicodeString         = kernel32.NewProc("BasepAnsiStringToDynamicUnicodeString")
	basepCheckAppCompat                           = kernel32.NewProc("BasepCheckAppCompat")
	basepCheckBadapp                              = kernel32.NewProc("BasepCheckBadapp")
	basepCheckWinSaferRestrictions                = kernel32.NewProc("BasepCheckWinSaferRestrictions")
	basepFreeActivationContextActivationBlock     = kernel32.NewProc("BasepFreeActivationContextActivationBlock")
	basepFreeAppCompatData                        = kernel32.NewProc("BasepFreeAppCompatData")
	basepMapModuleHandle                          = kernel32.NewProc("BasepMapModuleHandle")
	beep                                          = kernel32.NewProc("Beep")
	beginUpdateResourceA                          = kernel32.NewProc("BeginUpdateResourceA")
	beginUpdateResourceW                          = kernel32.NewProc("BeginUpdateResourceW")
	bindIoCompletionCallback                      = kernel32.NewProc("BindIoCompletionCallback")
	buildCommDCBA                                 = kernel32.NewProc("BuildCommDCBA")
	buildCommDCBAndTimeoutsA                      = kernel32.NewProc("BuildCommDCBAndTimeoutsA")
	buildCommDCBAndTimeoutsW                      = kernel32.NewProc("BuildCommDCBAndTimeoutsW")
	buildCommDCBW                                 = kernel32.NewProc("BuildCommDCBW")
	callNamedPipeA                                = kernel32.NewProc("CallNamedPipeA")
	callNamedPipeW                                = kernel32.NewProc("CallNamedPipeW")
	callbackMayRunLong                            = kernel32.NewProc("CallbackMayRunLong")
	cancelDeviceWakeupRequest                     = kernel32.NewProc("CancelDeviceWakeupRequest")
	cancelIo                                      = kernel32.NewProc("CancelIo")
	cancelIoEx                                    = kernel32.NewProc("CancelIoEx")
	cancelSynchronousIo                           = kernel32.NewProc("CancelSynchronousIo")
	cancelThreadpoolIo                            = kernel32.NewProc("CancelThreadpoolIo")
	cancelTimerQueueTimer                         = kernel32.NewProc("CancelTimerQueueTimer")
	cancelWaitableTimer                           = kernel32.NewProc("CancelWaitableTimer")
	changeTimerQueueTimer                         = kernel32.NewProc("ChangeTimerQueueTimer")
	checkElevation                                = kernel32.NewProc("CheckElevation")
	checkElevationEnabled                         = kernel32.NewProc("CheckElevationEnabled")
	checkForReadOnlyResource                      = kernel32.NewProc("CheckForReadOnlyResource")
	checkNameLegalDOS8Dot3A                       = kernel32.NewProc("CheckNameLegalDOS8Dot3A")
	checkNameLegalDOS8Dot3W                       = kernel32.NewProc("CheckNameLegalDOS8Dot3W")
	checkRemoteDebuggerPresent                    = kernel32.NewProc("CheckRemoteDebuggerPresent")
	clearCommBreak                                = kernel32.NewProc("ClearCommBreak")
	clearCommError                                = kernel32.NewProc("ClearCommError")
	closeConsoleHandle                            = kernel32.NewProc("CloseConsoleHandle")
	closeHandle                                   = kernel32.NewProc("CloseHandle")
	closePrivateNamespace                         = kernel32.NewProc("ClosePrivateNamespace")
	closeProfileUserMapping                       = kernel32.NewProc("CloseProfileUserMapping")
	closeThreadpool                               = kernel32.NewProc("CloseThreadpool")
	closeThreadpoolCleanupGroup                   = kernel32.NewProc("CloseThreadpoolCleanupGroup")
	closeThreadpoolCleanupGroupMembers            = kernel32.NewProc("CloseThreadpoolCleanupGroupMembers")
	closeThreadpoolIo                             = kernel32.NewProc("CloseThreadpoolIo")
	closeThreadpoolTimer                          = kernel32.NewProc("CloseThreadpoolTimer")
	closeThreadpoolWait                           = kernel32.NewProc("CloseThreadpoolWait")
	closeThreadpoolWork                           = kernel32.NewProc("CloseThreadpoolWork")
	cmdBatNotification                            = kernel32.NewProc("CmdBatNotification")
	commConfigDialogA                             = kernel32.NewProc("CommConfigDialogA")
	commConfigDialogW                             = kernel32.NewProc("CommConfigDialogW")
	compareCalendarDates                          = kernel32.NewProc("CompareCalendarDates")
	compareFileTime                               = kernel32.NewProc("CompareFileTime")
	compareStringA                                = kernel32.NewProc("CompareStringA")
	compareStringEx                               = kernel32.NewProc("CompareStringEx")
	compareStringOrdinal                          = kernel32.NewProc("CompareStringOrdinal")
	compareStringW                                = kernel32.NewProc("CompareStringW")
	connectNamedPipe                              = kernel32.NewProc("ConnectNamedPipe")
	consoleMenuControl                            = kernel32.NewProc("ConsoleMenuControl")
	continueDebugEvent                            = kernel32.NewProc("ContinueDebugEvent")
	convertCalDateTimeToSystemTime                = kernel32.NewProc("ConvertCalDateTimeToSystemTime")
	convertDefaultLocale                          = kernel32.NewProc("ConvertDefaultLocale")
	convertFiberToThread                          = kernel32.NewProc("ConvertFiberToThread")
	convertNLSDayOfWeekToWin32DayOfWeek           = kernel32.NewProc("ConvertNLSDayOfWeekToWin32DayOfWeek")
	convertSystemTimeToCalDateTime                = kernel32.NewProc("ConvertSystemTimeToCalDateTime")
	convertThreadToFiber                          = kernel32.NewProc("ConvertThreadToFiber")
	convertThreadToFiberEx                        = kernel32.NewProc("ConvertThreadToFiberEx")
	copyContext                                   = kernel32.NewProc("CopyContext")
	copyFileA                                     = kernel32.NewProc("CopyFileA")
	copyFileExA                                   = kernel32.NewProc("CopyFileExA")
	copyFileExW                                   = kernel32.NewProc("CopyFileExW")
	copyFileTransactedA                           = kernel32.NewProc("CopyFileTransactedA")
	copyFileTransactedW                           = kernel32.NewProc("CopyFileTransactedW")
	copyFileW                                     = kernel32.NewProc("CopyFileW")
	copyLZFile                                    = kernel32.NewProc("CopyLZFile")
	createActCtxA                                 = kernel32.NewProc("CreateActCtxA")
	createActCtxW                                 = kernel32.NewProc("CreateActCtxW")
	createBoundaryDescriptorA                     = kernel32.NewProc("CreateBoundaryDescriptorA")
	createBoundaryDescriptorW                     = kernel32.NewProc("CreateBoundaryDescriptorW")
	createConsoleScreenBuffer                     = kernel32.NewProc("CreateConsoleScreenBuffer")
	createDirectoryA                              = kernel32.NewProc("CreateDirectoryA")
	createDirectoryExA                            = kernel32.NewProc("CreateDirectoryExA")
	createDirectoryExW                            = kernel32.NewProc("CreateDirectoryExW")
	createDirectoryTransactedA                    = kernel32.NewProc("CreateDirectoryTransactedA")
	createDirectoryTransactedW                    = kernel32.NewProc("CreateDirectoryTransactedW")
	createDirectoryW                              = kernel32.NewProc("CreateDirectoryW")
	createEventA                                  = kernel32.NewProc("CreateEventA")
	createEventExA                                = kernel32.NewProc("CreateEventExA")
	createEventExW                                = kernel32.NewProc("CreateEventExW")
	createEventW                                  = kernel32.NewProc("CreateEventW")
	createFiber                                   = kernel32.NewProc("CreateFiber")
	createFiberEx                                 = kernel32.NewProc("CreateFiberEx")
	createFileA                                   = kernel32.NewProc("CreateFileA")
	createFileMappingA                            = kernel32.NewProc("CreateFileMappingA")
	createFileMappingNumaA                        = kernel32.NewProc("CreateFileMappingNumaA")
	createFileMappingNumaW                        = kernel32.NewProc("CreateFileMappingNumaW")
	createFileMappingW                            = kernel32.NewProc("CreateFileMappingW")
	createFileTransactedA                         = kernel32.NewProc("CreateFileTransactedA")
	createFileTransactedW                         = kernel32.NewProc("CreateFileTransactedW")
	createFileW                                   = kernel32.NewProc("CreateFileW")
	createHardLinkA                               = kernel32.NewProc("CreateHardLinkA")
	createHardLinkTransactedA                     = kernel32.NewProc("CreateHardLinkTransactedA")
	createHardLinkTransactedW                     = kernel32.NewProc("CreateHardLinkTransactedW")
	createHardLinkW                               = kernel32.NewProc("CreateHardLinkW")
	createIoCompletionPort                        = kernel32.NewProc("CreateIoCompletionPort")
	createJobObjectA                              = kernel32.NewProc("CreateJobObjectA")
	createJobObjectW                              = kernel32.NewProc("CreateJobObjectW")
	createJobSet                                  = kernel32.NewProc("CreateJobSet")
	createMailslotA                               = kernel32.NewProc("CreateMailslotA")
	createMailslotW                               = kernel32.NewProc("CreateMailslotW")
	createMemoryResourceNotification              = kernel32.NewProc("CreateMemoryResourceNotification")
	createMutexA                                  = kernel32.NewProc("CreateMutexA")
	createMutexExA                                = kernel32.NewProc("CreateMutexExA")
	createMutexExW                                = kernel32.NewProc("CreateMutexExW")
	createMutexW                                  = kernel32.NewProc("CreateMutexW")
	createNamedPipeA                              = kernel32.NewProc("CreateNamedPipeA")
	createNamedPipeW                              = kernel32.NewProc("CreateNamedPipeW")
	createPipe                                    = kernel32.NewProc("CreatePipe")
	createPrivateNamespaceA                       = kernel32.NewProc("CreatePrivateNamespaceA")
	createPrivateNamespaceW                       = kernel32.NewProc("CreatePrivateNamespaceW")
	createProcessA                                = kernel32.NewProc("CreateProcessA")
	createProcessAsUserW                          = kernel32.NewProc("CreateProcessAsUserW")
	createProcessInternalA                        = kernel32.NewProc("CreateProcessInternalA")
	createProcessInternalW                        = kernel32.NewProc("CreateProcessInternalW")
	createProcessW                                = kernel32.NewProc("CreateProcessW")
	createRemoteThread                            = kernel32.NewProc("CreateRemoteThread")
	createRemoteThreadEx                          = kernel32.NewProc("CreateRemoteThreadEx")
	createSemaphoreA                              = kernel32.NewProc("CreateSemaphoreA")
	createSemaphoreExA                            = kernel32.NewProc("CreateSemaphoreExA")
	createSemaphoreExW                            = kernel32.NewProc("CreateSemaphoreExW")
	createSemaphoreW                              = kernel32.NewProc("CreateSemaphoreW")
	createSymbolicLinkA                           = kernel32.NewProc("CreateSymbolicLinkA")
	createSymbolicLinkTransactedA                 = kernel32.NewProc("CreateSymbolicLinkTransactedA")
	createSymbolicLinkTransactedW                 = kernel32.NewProc("CreateSymbolicLinkTransactedW")
	createSymbolicLinkW                           = kernel32.NewProc("CreateSymbolicLinkW")
	createTapePartition                           = kernel32.NewProc("CreateTapePartition")
	createThread                                  = kernel32.NewProc("CreateThread")
	createThreadpool                              = kernel32.NewProc("CreateThreadpool")
	createThreadpoolCleanupGroup                  = kernel32.NewProc("CreateThreadpoolCleanupGroup")
	createThreadpoolIo                            = kernel32.NewProc("CreateThreadpoolIo")
	createThreadpoolTimer                         = kernel32.NewProc("CreateThreadpoolTimer")
	createThreadpoolWait                          = kernel32.NewProc("CreateThreadpoolWait")
	createThreadpoolWork                          = kernel32.NewProc("CreateThreadpoolWork")
	createTimerQueue                              = kernel32.NewProc("CreateTimerQueue")
	createTimerQueueTimer                         = kernel32.NewProc("CreateTimerQueueTimer")
	createToolhelp32Snapshot                      = kernel32.NewProc("CreateToolhelp32Snapshot")
	createUmsCompletionList                       = kernel32.NewProc("CreateUmsCompletionList")
	createUmsThreadContext                        = kernel32.NewProc("CreateUmsThreadContext")
	createWaitableTimerA                          = kernel32.NewProc("CreateWaitableTimerA")
	createWaitableTimerExA                        = kernel32.NewProc("CreateWaitableTimerExA")
	createWaitableTimerExW                        = kernel32.NewProc("CreateWaitableTimerExW")
	createWaitableTimerW                          = kernel32.NewProc("CreateWaitableTimerW")
	ctrlRoutine                                   = kernel32.NewProc("CtrlRoutine")
	deactivateActCtx                              = kernel32.NewProc("DeactivateActCtx")
	debugActiveProcess                            = kernel32.NewProc("DebugActiveProcess")
	debugActiveProcessStop                        = kernel32.NewProc("DebugActiveProcessStop")
	debugBreak                                    = kernel32.NewProc("DebugBreak")
	debugBreakProcess                             = kernel32.NewProc("DebugBreakProcess")
	debugSetProcessKillOnExit                     = kernel32.NewProc("DebugSetProcessKillOnExit")
	decodePointer                                 = kernel32.NewProc("DecodePointer")
	decodeSystemPointer                           = kernel32.NewProc("DecodeSystemPointer")
	defineDosDeviceA                              = kernel32.NewProc("DefineDosDeviceA")
	defineDosDeviceW                              = kernel32.NewProc("DefineDosDeviceW")
	delayLoadFailureHook                          = kernel32.NewProc("DelayLoadFailureHook")
	deleteAtom                                    = kernel32.NewProc("DeleteAtom")
	deleteBoundaryDescriptor                      = kernel32.NewProc("DeleteBoundaryDescriptor")
	deleteCriticalSection                         = kernel32.NewProc("DeleteCriticalSection")
	deleteFiber                                   = kernel32.NewProc("DeleteFiber")
	deleteFileA                                   = kernel32.NewProc("DeleteFileA")
	deleteFileTransactedA                         = kernel32.NewProc("DeleteFileTransactedA")
	deleteFileTransactedW                         = kernel32.NewProc("DeleteFileTransactedW")
	deleteFileW                                   = kernel32.NewProc("DeleteFileW")
	deleteProcThreadAttributeList                 = kernel32.NewProc("DeleteProcThreadAttributeList")
	deleteTimerQueue                              = kernel32.NewProc("DeleteTimerQueue")
	deleteTimerQueueEx                            = kernel32.NewProc("DeleteTimerQueueEx")
	deleteTimerQueueTimer                         = kernel32.NewProc("DeleteTimerQueueTimer")
	deleteUmsCompletionList                       = kernel32.NewProc("DeleteUmsCompletionList")
	deleteUmsThreadContext                        = kernel32.NewProc("DeleteUmsThreadContext")
	deleteVolumeMountPointA                       = kernel32.NewProc("DeleteVolumeMountPointA")
	deleteVolumeMountPointW                       = kernel32.NewProc("DeleteVolumeMountPointW")
	dequeueUmsCompletionListItems                 = kernel32.NewProc("DequeueUmsCompletionListItems")
	deviceIoControl                               = kernel32.NewProc("DeviceIoControl")
	disableThreadLibraryCalls                     = kernel32.NewProc("DisableThreadLibraryCalls")
	disableThreadProfiling                        = kernel32.NewProc("DisableThreadProfiling")
	disassociateCurrentThreadFromCallback         = kernel32.NewProc("DisassociateCurrentThreadFromCallback")
	disconnectNamedPipe                           = kernel32.NewProc("DisconnectNamedPipe")
	dnsHostnameToComputerNameA                    = kernel32.NewProc("DnsHostnameToComputerNameA")
	dnsHostnameToComputerNameW                    = kernel32.NewProc("DnsHostnameToComputerNameW")
	dosDateTimeToFileTime                         = kernel32.NewProc("DosDateTimeToFileTime")
	dosPathToSessionPathA                         = kernel32.NewProc("DosPathToSessionPathA")
	dosPathToSessionPathW                         = kernel32.NewProc("DosPathToSessionPathW")
	duplicateConsoleHandle                        = kernel32.NewProc("DuplicateConsoleHandle")
	duplicateHandle                               = kernel32.NewProc("DuplicateHandle")
	enableThreadProfiling                         = kernel32.NewProc("EnableThreadProfiling")
	encodePointer                                 = kernel32.NewProc("EncodePointer")
	encodeSystemPointer                           = kernel32.NewProc("EncodeSystemPointer")
	endUpdateResourceA                            = kernel32.NewProc("EndUpdateResourceA")
	endUpdateResourceW                            = kernel32.NewProc("EndUpdateResourceW")
	enterCriticalSection                          = kernel32.NewProc("EnterCriticalSection")
	enterUmsSchedulingMode                        = kernel32.NewProc("EnterUmsSchedulingMode")
	enumCalendarInfoA                             = kernel32.NewProc("EnumCalendarInfoA")
	enumCalendarInfoExA                           = kernel32.NewProc("EnumCalendarInfoExA")
	enumCalendarInfoExEx                          = kernel32.NewProc("EnumCalendarInfoExEx")
	enumCalendarInfoExW                           = kernel32.NewProc("EnumCalendarInfoExW")
	enumCalendarInfoW                             = kernel32.NewProc("EnumCalendarInfoW")
	enumDateFormatsA                              = kernel32.NewProc("EnumDateFormatsA")
	enumDateFormatsExA                            = kernel32.NewProc("EnumDateFormatsExA")
	enumDateFormatsExEx                           = kernel32.NewProc("EnumDateFormatsExEx")
	enumDateFormatsExW                            = kernel32.NewProc("EnumDateFormatsExW")
	enumDateFormatsW                              = kernel32.NewProc("EnumDateFormatsW")
	enumLanguageGroupLocalesA                     = kernel32.NewProc("EnumLanguageGroupLocalesA")
	enumLanguageGroupLocalesW                     = kernel32.NewProc("EnumLanguageGroupLocalesW")
	enumResourceLanguagesA                        = kernel32.NewProc("EnumResourceLanguagesA")
	enumResourceLanguagesExA                      = kernel32.NewProc("EnumResourceLanguagesExA")
	enumResourceLanguagesExW                      = kernel32.NewProc("EnumResourceLanguagesExW")
	enumResourceLanguagesW                        = kernel32.NewProc("EnumResourceLanguagesW")
	enumResourceNamesA                            = kernel32.NewProc("EnumResourceNamesA")
	enumResourceNamesExA                          = kernel32.NewProc("EnumResourceNamesExA")
	enumResourceNamesExW                          = kernel32.NewProc("EnumResourceNamesExW")
	enumResourceNamesW                            = kernel32.NewProc("EnumResourceNamesW")
	enumResourceTypesA                            = kernel32.NewProc("EnumResourceTypesA")
	enumResourceTypesExA                          = kernel32.NewProc("EnumResourceTypesExA")
	enumResourceTypesExW                          = kernel32.NewProc("EnumResourceTypesExW")
	enumResourceTypesW                            = kernel32.NewProc("EnumResourceTypesW")
	enumSystemCodePagesA                          = kernel32.NewProc("EnumSystemCodePagesA")
	enumSystemCodePagesW                          = kernel32.NewProc("EnumSystemCodePagesW")
	enumSystemFirmwareTables                      = kernel32.NewProc("EnumSystemFirmwareTables")
	enumSystemGeoID                               = kernel32.NewProc("EnumSystemGeoID")
	enumSystemLanguageGroupsA                     = kernel32.NewProc("EnumSystemLanguageGroupsA")
	enumSystemLanguageGroupsW                     = kernel32.NewProc("EnumSystemLanguageGroupsW")
	enumSystemLocalesA                            = kernel32.NewProc("EnumSystemLocalesA")
	enumSystemLocalesEx                           = kernel32.NewProc("EnumSystemLocalesEx")
	enumSystemLocalesW                            = kernel32.NewProc("EnumSystemLocalesW")
	enumTimeFormatsA                              = kernel32.NewProc("EnumTimeFormatsA")
	enumTimeFormatsEx                             = kernel32.NewProc("EnumTimeFormatsEx")
	enumTimeFormatsW                              = kernel32.NewProc("EnumTimeFormatsW")
	enumUILanguagesA                              = kernel32.NewProc("EnumUILanguagesA")
	enumUILanguagesW                              = kernel32.NewProc("EnumUILanguagesW")
	enumerateLocalComputerNamesA                  = kernel32.NewProc("EnumerateLocalComputerNamesA")
	enumerateLocalComputerNamesW                  = kernel32.NewProc("EnumerateLocalComputerNamesW")
	eraseTape                                     = kernel32.NewProc("EraseTape")
	escapeCommFunction                            = kernel32.NewProc("EscapeCommFunction")
	executeUmsThread                              = kernel32.NewProc("ExecuteUmsThread")
	exitProcess                                   = kernel32.NewProc("ExitProcess")
	exitThread                                    = kernel32.NewProc("ExitThread")
	exitVDM                                       = kernel32.NewProc("ExitVDM")
	expandEnvironmentStringsA                     = kernel32.NewProc("ExpandEnvironmentStringsA")
	expandEnvironmentStringsW                     = kernel32.NewProc("ExpandEnvironmentStringsW")
	expungeConsoleCommandHistoryA                 = kernel32.NewProc("ExpungeConsoleCommandHistoryA")
	expungeConsoleCommandHistoryW                 = kernel32.NewProc("ExpungeConsoleCommandHistoryW")
	fatalAppExitA                                 = kernel32.NewProc("FatalAppExitA")
	fatalAppExitW                                 = kernel32.NewProc("FatalAppExitW")
	fatalExit                                     = kernel32.NewProc("FatalExit")
	fileTimeToDosDateTime                         = kernel32.NewProc("FileTimeToDosDateTime")
	fileTimeToLocalFileTime                       = kernel32.NewProc("FileTimeToLocalFileTime")
	fileTimeToSystemTime                          = kernel32.NewProc("FileTimeToSystemTime")
	fillConsoleOutputAttribute                    = kernel32.NewProc("FillConsoleOutputAttribute")
	fillConsoleOutputCharacterA                   = kernel32.NewProc("FillConsoleOutputCharacterA")
	fillConsoleOutputCharacterW                   = kernel32.NewProc("FillConsoleOutputCharacterW")
	findActCtxSectionGuid                         = kernel32.NewProc("FindActCtxSectionGuid")
	findActCtxSectionStringA                      = kernel32.NewProc("FindActCtxSectionStringA")
	findActCtxSectionStringW                      = kernel32.NewProc("FindActCtxSectionStringW")
	findAtomA                                     = kernel32.NewProc("FindAtomA")
	findAtomW                                     = kernel32.NewProc("FindAtomW")
	findClose                                     = kernel32.NewProc("FindClose")
	findCloseChangeNotification                   = kernel32.NewProc("FindCloseChangeNotification")
	findFirstChangeNotificationA                  = kernel32.NewProc("FindFirstChangeNotificationA")
	findFirstChangeNotificationW                  = kernel32.NewProc("FindFirstChangeNotificationW")
	findFirstFileA                                = kernel32.NewProc("FindFirstFileA")
	findFirstFileExA                              = kernel32.NewProc("FindFirstFileExA")
	findFirstFileExW                              = kernel32.NewProc("FindFirstFileExW")
	findFirstFileNameTransactedW                  = kernel32.NewProc("FindFirstFileNameTransactedW")
	findFirstFileNameW                            = kernel32.NewProc("FindFirstFileNameW")
	findFirstFileTransactedA                      = kernel32.NewProc("FindFirstFileTransactedA")
	findFirstFileTransactedW                      = kernel32.NewProc("FindFirstFileTransactedW")
	findFirstFileW                                = kernel32.NewProc("FindFirstFileW")
	findFirstStreamTransactedW                    = kernel32.NewProc("FindFirstStreamTransactedW")
	findFirstStreamW                              = kernel32.NewProc("FindFirstStreamW")
	findFirstVolumeA                              = kernel32.NewProc("FindFirstVolumeA")
	findFirstVolumeMountPointA                    = kernel32.NewProc("FindFirstVolumeMountPointA")
	findFirstVolumeMountPointW                    = kernel32.NewProc("FindFirstVolumeMountPointW")
	findFirstVolumeW                              = kernel32.NewProc("FindFirstVolumeW")
	findNLSString                                 = kernel32.NewProc("FindNLSString")
	findNLSStringEx                               = kernel32.NewProc("FindNLSStringEx")
	findNextChangeNotification                    = kernel32.NewProc("FindNextChangeNotification")
	findNextFileA                                 = kernel32.NewProc("FindNextFileA")
	findNextFileNameW                             = kernel32.NewProc("FindNextFileNameW")
	findNextFileW                                 = kernel32.NewProc("FindNextFileW")
	findNextStreamW                               = kernel32.NewProc("FindNextStreamW")
	findNextVolumeA                               = kernel32.NewProc("FindNextVolumeA")
	findNextVolumeMountPointA                     = kernel32.NewProc("FindNextVolumeMountPointA")
	findNextVolumeMountPointW                     = kernel32.NewProc("FindNextVolumeMountPointW")
	findNextVolumeW                               = kernel32.NewProc("FindNextVolumeW")
	findResourceA                                 = kernel32.NewProc("FindResourceA")
	findResourceExA                               = kernel32.NewProc("FindResourceExA")
	findResourceExW                               = kernel32.NewProc("FindResourceExW")
	findResourceW                                 = kernel32.NewProc("FindResourceW")
	findStringOrdinal                             = kernel32.NewProc("FindStringOrdinal")
	findVolumeClose                               = kernel32.NewProc("FindVolumeClose")
	findVolumeMountPointClose                     = kernel32.NewProc("FindVolumeMountPointClose")
	flsAlloc                                      = kernel32.NewProc("FlsAlloc")
	flsFree                                       = kernel32.NewProc("FlsFree")
	flsGetValue                                   = kernel32.NewProc("FlsGetValue")
	flsSetValue                                   = kernel32.NewProc("FlsSetValue")
	flushConsoleInputBuffer                       = kernel32.NewProc("FlushConsoleInputBuffer")
	flushFileBuffers                              = kernel32.NewProc("FlushFileBuffers")
	flushInstructionCache                         = kernel32.NewProc("FlushInstructionCache")
	flushProcessWriteBuffers                      = kernel32.NewProc("FlushProcessWriteBuffers")
	flushViewOfFile                               = kernel32.NewProc("FlushViewOfFile")
	foldStringA                                   = kernel32.NewProc("FoldStringA")
	foldStringW                                   = kernel32.NewProc("FoldStringW")
	formatMessageA                                = kernel32.NewProc("FormatMessageA")
	formatMessageW                                = kernel32.NewProc("FormatMessageW")
	freeConsole                                   = kernel32.NewProc("FreeConsole")
	freeEnvironmentStringsA                       = kernel32.NewProc("FreeEnvironmentStringsA")
	freeEnvironmentStringsW                       = kernel32.NewProc("FreeEnvironmentStringsW")
	freeLibrary                                   = kernel32.NewProc("FreeLibrary")
	freeLibraryAndExitThread                      = kernel32.NewProc("FreeLibraryAndExitThread")
	freeLibraryWhenCallbackReturns                = kernel32.NewProc("FreeLibraryWhenCallbackReturns")
	freeResource                                  = kernel32.NewProc("FreeResource")
	freeUserPhysicalPages                         = kernel32.NewProc("FreeUserPhysicalPages")
	generateConsoleCtrlEvent                      = kernel32.NewProc("GenerateConsoleCtrlEvent")
	getACP                                        = kernel32.NewProc("GetACP")
	getActiveProcessorCount                       = kernel32.NewProc("GetActiveProcessorCount")
	getActiveProcessorGroupCount                  = kernel32.NewProc("GetActiveProcessorGroupCount")
	getApplicationRecoveryCallback                = kernel32.NewProc("GetApplicationRecoveryCallback")
	getApplicationRestartSettings                 = kernel32.NewProc("GetApplicationRestartSettings")
	getAtomNameA                                  = kernel32.NewProc("GetAtomNameA")
	getAtomNameW                                  = kernel32.NewProc("GetAtomNameW")
	getBinaryType                                 = kernel32.NewProc("GetBinaryType")
	getBinaryTypeA                                = kernel32.NewProc("GetBinaryTypeA")
	getBinaryTypeW                                = kernel32.NewProc("GetBinaryTypeW")
	getCPInfo                                     = kernel32.NewProc("GetCPInfo")
	getCPInfoExA                                  = kernel32.NewProc("GetCPInfoExA")
	getCPInfoExW                                  = kernel32.NewProc("GetCPInfoExW")
	getCalendarDateFormat                         = kernel32.NewProc("GetCalendarDateFormat")
	getCalendarDateFormatEx                       = kernel32.NewProc("GetCalendarDateFormatEx")
	getCalendarDaysInMonth                        = kernel32.NewProc("GetCalendarDaysInMonth")
	getCalendarDifferenceInDays                   = kernel32.NewProc("GetCalendarDifferenceInDays")
	getCalendarInfoA                              = kernel32.NewProc("GetCalendarInfoA")
	getCalendarInfoEx                             = kernel32.NewProc("GetCalendarInfoEx")
	getCalendarInfoW                              = kernel32.NewProc("GetCalendarInfoW")
	getCalendarMonthsInYear                       = kernel32.NewProc("GetCalendarMonthsInYear")
	getCalendarSupportedDateRange                 = kernel32.NewProc("GetCalendarSupportedDateRange")
	getCalendarWeekNumber                         = kernel32.NewProc("GetCalendarWeekNumber")
	getComPlusPackageInstallStatus                = kernel32.NewProc("GetComPlusPackageInstallStatus")
	getCommConfig                                 = kernel32.NewProc("GetCommConfig")
	getCommMask                                   = kernel32.NewProc("GetCommMask")
	getCommModemStatus                            = kernel32.NewProc("GetCommModemStatus")
	getCommProperties                             = kernel32.NewProc("GetCommProperties")
	getCommState                                  = kernel32.NewProc("GetCommState")
	getCommTimeouts                               = kernel32.NewProc("GetCommTimeouts")
	getCommandLineA                               = kernel32.NewProc("GetCommandLineA")
	getCommandLineW                               = kernel32.NewProc("GetCommandLineW")
	getCompressedFileSizeA                        = kernel32.NewProc("GetCompressedFileSizeA")
	getCompressedFileSizeTransactedA              = kernel32.NewProc("GetCompressedFileSizeTransactedA")
	getCompressedFileSizeTransactedW              = kernel32.NewProc("GetCompressedFileSizeTransactedW")
	getCompressedFileSizeW                        = kernel32.NewProc("GetCompressedFileSizeW")
	getComputerNameA                              = kernel32.NewProc("GetComputerNameA")
	getComputerNameExA                            = kernel32.NewProc("GetComputerNameExA")
	getComputerNameExW                            = kernel32.NewProc("GetComputerNameExW")
	getComputerNameW                              = kernel32.NewProc("GetComputerNameW")
	getConsoleAliasA                              = kernel32.NewProc("GetConsoleAliasA")
	getConsoleAliasExesA                          = kernel32.NewProc("GetConsoleAliasExesA")
	getConsoleAliasExesLengthA                    = kernel32.NewProc("GetConsoleAliasExesLengthA")
	getConsoleAliasExesLengthW                    = kernel32.NewProc("GetConsoleAliasExesLengthW")
	getConsoleAliasExesW                          = kernel32.NewProc("GetConsoleAliasExesW")
	getConsoleAliasW                              = kernel32.NewProc("GetConsoleAliasW")
	getConsoleAliasesA                            = kernel32.NewProc("GetConsoleAliasesA")
	getConsoleAliasesLengthA                      = kernel32.NewProc("GetConsoleAliasesLengthA")
	getConsoleAliasesLengthW                      = kernel32.NewProc("GetConsoleAliasesLengthW")
	getConsoleAliasesW                            = kernel32.NewProc("GetConsoleAliasesW")
	getConsoleCP                                  = kernel32.NewProc("GetConsoleCP")
	getConsoleCharType                            = kernel32.NewProc("GetConsoleCharType")
	getConsoleCommandHistoryA                     = kernel32.NewProc("GetConsoleCommandHistoryA")
	getConsoleCommandHistoryLengthA               = kernel32.NewProc("GetConsoleCommandHistoryLengthA")
	getConsoleCommandHistoryLengthW               = kernel32.NewProc("GetConsoleCommandHistoryLengthW")
	getConsoleCommandHistoryW                     = kernel32.NewProc("GetConsoleCommandHistoryW")
	getConsoleCursorInfo                          = kernel32.NewProc("GetConsoleCursorInfo")
	getConsoleCursorMode                          = kernel32.NewProc("GetConsoleCursorMode")
	getConsoleDisplayMode                         = kernel32.NewProc("GetConsoleDisplayMode")
	getConsoleFontInfo                            = kernel32.NewProc("GetConsoleFontInfo")
	getConsoleFontSize                            = kernel32.NewProc("GetConsoleFontSize")
	getConsoleHardwareState                       = kernel32.NewProc("GetConsoleHardwareState")
	getConsoleHistoryInfo                         = kernel32.NewProc("GetConsoleHistoryInfo")
	getConsoleInputExeNameA                       = kernel32.NewProc("GetConsoleInputExeNameA")
	getConsoleInputExeNameW                       = kernel32.NewProc("GetConsoleInputExeNameW")
	getConsoleInputWaitHandle                     = kernel32.NewProc("GetConsoleInputWaitHandle")
	getConsoleKeyboardLayoutNameA                 = kernel32.NewProc("GetConsoleKeyboardLayoutNameA")
	getConsoleKeyboardLayoutNameW                 = kernel32.NewProc("GetConsoleKeyboardLayoutNameW")
	getConsoleMode                                = kernel32.NewProc("GetConsoleMode")
	getConsoleNlsMode                             = kernel32.NewProc("GetConsoleNlsMode")
	getConsoleOriginalTitleA                      = kernel32.NewProc("GetConsoleOriginalTitleA")
	getConsoleOriginalTitleW                      = kernel32.NewProc("GetConsoleOriginalTitleW")
	getConsoleOutputCP                            = kernel32.NewProc("GetConsoleOutputCP")
	getConsoleProcessList                         = kernel32.NewProc("GetConsoleProcessList")
	getConsoleScreenBufferInfo                    = kernel32.NewProc("GetConsoleScreenBufferInfo")
	getConsoleScreenBufferInfoEx                  = kernel32.NewProc("GetConsoleScreenBufferInfoEx")
	getConsoleSelectionInfo                       = kernel32.NewProc("GetConsoleSelectionInfo")
	getConsoleTitleA                              = kernel32.NewProc("GetConsoleTitleA")
	getConsoleTitleW                              = kernel32.NewProc("GetConsoleTitleW")
	getConsoleWindow                              = kernel32.NewProc("GetConsoleWindow")
	getCurrencyFormatA                            = kernel32.NewProc("GetCurrencyFormatA")
	getCurrencyFormatEx                           = kernel32.NewProc("GetCurrencyFormatEx")
	getCurrencyFormatW                            = kernel32.NewProc("GetCurrencyFormatW")
	getCurrentActCtx                              = kernel32.NewProc("GetCurrentActCtx")
	getCurrentConsoleFont                         = kernel32.NewProc("GetCurrentConsoleFont")
	getCurrentConsoleFontEx                       = kernel32.NewProc("GetCurrentConsoleFontEx")
	getCurrentDirectoryA                          = kernel32.NewProc("GetCurrentDirectoryA")
	getCurrentDirectoryW                          = kernel32.NewProc("GetCurrentDirectoryW")
	getCurrentProcess                             = kernel32.NewProc("GetCurrentProcess")
	getCurrentProcessId                           = kernel32.NewProc("GetCurrentProcessId")
	getCurrentProcessorNumber                     = kernel32.NewProc("GetCurrentProcessorNumber")
	getCurrentProcessorNumberEx                   = kernel32.NewProc("GetCurrentProcessorNumberEx")
	getCurrentThread                              = kernel32.NewProc("GetCurrentThread")
	getCurrentThreadId                            = kernel32.NewProc("GetCurrentThreadId")
	getCurrentUmsThread                           = kernel32.NewProc("GetCurrentUmsThread")
	getDateFormatA                                = kernel32.NewProc("GetDateFormatA")
	getDateFormatEx                               = kernel32.NewProc("GetDateFormatEx")
	getDateFormatW                                = kernel32.NewProc("GetDateFormatW")
	getDefaultCommConfigA                         = kernel32.NewProc("GetDefaultCommConfigA")
	getDefaultCommConfigW                         = kernel32.NewProc("GetDefaultCommConfigW")
	getDevicePowerState                           = kernel32.NewProc("GetDevicePowerState")
	getDiskFreeSpaceA                             = kernel32.NewProc("GetDiskFreeSpaceA")
	getDiskFreeSpaceExA                           = kernel32.NewProc("GetDiskFreeSpaceExA")
	getDiskFreeSpaceExW                           = kernel32.NewProc("GetDiskFreeSpaceExW")
	getDiskFreeSpaceW                             = kernel32.NewProc("GetDiskFreeSpaceW")
	getDllDirectoryA                              = kernel32.NewProc("GetDllDirectoryA")
	getDllDirectoryW                              = kernel32.NewProc("GetDllDirectoryW")
	getDriveTypeA                                 = kernel32.NewProc("GetDriveTypeA")
	getDriveTypeW                                 = kernel32.NewProc("GetDriveTypeW")
	getDurationFormat                             = kernel32.NewProc("GetDurationFormat")
	getDurationFormatEx                           = kernel32.NewProc("GetDurationFormatEx")
	getDynamicTimeZoneInformation                 = kernel32.NewProc("GetDynamicTimeZoneInformation")
	getEnabledXStateFeatures                      = kernel32.NewProc("GetEnabledXStateFeatures")
	getEnvironmentStrings                         = kernel32.NewProc("GetEnvironmentStrings")
	getEnvironmentStringsA                        = kernel32.NewProc("GetEnvironmentStringsA")
	getEnvironmentStringsW                        = kernel32.NewProc("GetEnvironmentStringsW")
	getEnvironmentVariableA                       = kernel32.NewProc("GetEnvironmentVariableA")
	getEnvironmentVariableW                       = kernel32.NewProc("GetEnvironmentVariableW")
	getEraNameCountedString                       = kernel32.NewProc("GetEraNameCountedString")
	getErrorMode                                  = kernel32.NewProc("GetErrorMode")
	getExitCodeProcess                            = kernel32.NewProc("GetExitCodeProcess")
	getExitCodeThread                             = kernel32.NewProc("GetExitCodeThread")
	getExpandedNameA                              = kernel32.NewProc("GetExpandedNameA")
	getExpandedNameW                              = kernel32.NewProc("GetExpandedNameW")
	getFileAttributesA                            = kernel32.NewProc("GetFileAttributesA")
	getFileAttributesExA                          = kernel32.NewProc("GetFileAttributesExA")
	getFileAttributesExW                          = kernel32.NewProc("GetFileAttributesExW")
	getFileAttributesTransactedA                  = kernel32.NewProc("GetFileAttributesTransactedA")
	getFileAttributesTransactedW                  = kernel32.NewProc("GetFileAttributesTransactedW")
	getFileAttributesW                            = kernel32.NewProc("GetFileAttributesW")
	getFileBandwidthReservation                   = kernel32.NewProc("GetFileBandwidthReservation")
	getFileInformationByHandle                    = kernel32.NewProc("GetFileInformationByHandle")
	getFileInformationByHandleEx                  = kernel32.NewProc("GetFileInformationByHandleEx")
	getFileMUIInfo                                = kernel32.NewProc("GetFileMUIInfo")
	getFileMUIPath                                = kernel32.NewProc("GetFileMUIPath")
	getFileSize                                   = kernel32.NewProc("GetFileSize")
	getFileSizeEx                                 = kernel32.NewProc("GetFileSizeEx")
	getFileTime                                   = kernel32.NewProc("GetFileTime")
	getFileType                                   = kernel32.NewProc("GetFileType")
	getFinalPathNameByHandleA                     = kernel32.NewProc("GetFinalPathNameByHandleA")
	getFinalPathNameByHandleW                     = kernel32.NewProc("GetFinalPathNameByHandleW")
	getFirmwareEnvironmentVariableA               = kernel32.NewProc("GetFirmwareEnvironmentVariableA")
	getFirmwareEnvironmentVariableW               = kernel32.NewProc("GetFirmwareEnvironmentVariableW")
	getFullPathNameA                              = kernel32.NewProc("GetFullPathNameA")
	getFullPathNameTransactedA                    = kernel32.NewProc("GetFullPathNameTransactedA")
	getFullPathNameTransactedW                    = kernel32.NewProc("GetFullPathNameTransactedW")
	getFullPathNameW                              = kernel32.NewProc("GetFullPathNameW")
	getGeoInfoA                                   = kernel32.NewProc("GetGeoInfoA")
	getGeoInfoW                                   = kernel32.NewProc("GetGeoInfoW")
	getHandleInformation                          = kernel32.NewProc("GetHandleInformation")
	getLargePageMinimum                           = kernel32.NewProc("GetLargePageMinimum")
	getLargestConsoleWindowSize                   = kernel32.NewProc("GetLargestConsoleWindowSize")
	getLastError                                  = kernel32.NewProc("GetLastError")
	getLocalTime                                  = kernel32.NewProc("GetLocalTime")
	getLocaleInfoA                                = kernel32.NewProc("GetLocaleInfoA")
	getLocaleInfoEx                               = kernel32.NewProc("GetLocaleInfoEx")
	getLocaleInfoW                                = kernel32.NewProc("GetLocaleInfoW")
	getLogicalDriveStringsA                       = kernel32.NewProc("GetLogicalDriveStringsA")
	getLogicalDriveStringsW                       = kernel32.NewProc("GetLogicalDriveStringsW")
	getLogicalDrives                              = kernel32.NewProc("GetLogicalDrives")
	getLogicalProcessorInformation                = kernel32.NewProc("GetLogicalProcessorInformation")
	getLogicalProcessorInformationEx              = kernel32.NewProc("GetLogicalProcessorInformationEx")
	getLongPathNameA                              = kernel32.NewProc("GetLongPathNameA")
	getLongPathNameTransactedA                    = kernel32.NewProc("GetLongPathNameTransactedA")
	getLongPathNameTransactedW                    = kernel32.NewProc("GetLongPathNameTransactedW")
	getLongPathNameW                              = kernel32.NewProc("GetLongPathNameW")
	getMailslotInfo                               = kernel32.NewProc("GetMailslotInfo")
	getMaximumProcessorCount                      = kernel32.NewProc("GetMaximumProcessorCount")
	getMaximumProcessorGroupCount                 = kernel32.NewProc("GetMaximumProcessorGroupCount")
	getModuleFileNameA                            = kernel32.NewProc("GetModuleFileNameA")
	getModuleFileNameW                            = kernel32.NewProc("GetModuleFileNameW")
	getModuleHandleA                              = kernel32.NewProc("GetModuleHandleA")
	getModuleHandleExA                            = kernel32.NewProc("GetModuleHandleExA")
	getModuleHandleExW                            = kernel32.NewProc("GetModuleHandleExW")
	getModuleHandleW                              = kernel32.NewProc("GetModuleHandleW")
	getNLSVersion                                 = kernel32.NewProc("GetNLSVersion")
	getNLSVersionEx                               = kernel32.NewProc("GetNLSVersionEx")
	getNamedPipeAttribute                         = kernel32.NewProc("GetNamedPipeAttribute")
	getNamedPipeClientComputerNameA               = kernel32.NewProc("GetNamedPipeClientComputerNameA")
	getNamedPipeClientComputerNameW               = kernel32.NewProc("GetNamedPipeClientComputerNameW")
	getNamedPipeClientProcessId                   = kernel32.NewProc("GetNamedPipeClientProcessId")
	getNamedPipeClientSessionId                   = kernel32.NewProc("GetNamedPipeClientSessionId")
	getNamedPipeHandleStateA                      = kernel32.NewProc("GetNamedPipeHandleStateA")
	getNamedPipeHandleStateW                      = kernel32.NewProc("GetNamedPipeHandleStateW")
	getNamedPipeInfo                              = kernel32.NewProc("GetNamedPipeInfo")
	getNamedPipeServerProcessId                   = kernel32.NewProc("GetNamedPipeServerProcessId")
	getNamedPipeServerSessionId                   = kernel32.NewProc("GetNamedPipeServerSessionId")
	getNativeSystemInfo                           = kernel32.NewProc("GetNativeSystemInfo")
	getNextUmsListItem                            = kernel32.NewProc("GetNextUmsListItem")
	getNextVDMCommand                             = kernel32.NewProc("GetNextVDMCommand")
	getNumaAvailableMemoryNode                    = kernel32.NewProc("GetNumaAvailableMemoryNode")
	getNumaAvailableMemoryNodeEx                  = kernel32.NewProc("GetNumaAvailableMemoryNodeEx")
	getNumaHighestNodeNumber                      = kernel32.NewProc("GetNumaHighestNodeNumber")
	getNumaNodeNumberFromHandle                   = kernel32.NewProc("GetNumaNodeNumberFromHandle")
	getNumaNodeProcessorMask                      = kernel32.NewProc("GetNumaNodeProcessorMask")
	getNumaNodeProcessorMaskEx                    = kernel32.NewProc("GetNumaNodeProcessorMaskEx")
	getNumaProcessorNode                          = kernel32.NewProc("GetNumaProcessorNode")
	getNumaProcessorNodeEx                        = kernel32.NewProc("GetNumaProcessorNodeEx")
	getNumaProximityNode                          = kernel32.NewProc("GetNumaProximityNode")
	getNumaProximityNodeEx                        = kernel32.NewProc("GetNumaProximityNodeEx")
	getNumberFormatA                              = kernel32.NewProc("GetNumberFormatA")
	getNumberFormatEx                             = kernel32.NewProc("GetNumberFormatEx")
	getNumberFormatW                              = kernel32.NewProc("GetNumberFormatW")
	getNumberOfConsoleFonts                       = kernel32.NewProc("GetNumberOfConsoleFonts")
	getNumberOfConsoleInputEvents                 = kernel32.NewProc("GetNumberOfConsoleInputEvents")
	getNumberOfConsoleMouseButtons                = kernel32.NewProc("GetNumberOfConsoleMouseButtons")
	getOEMCP                                      = kernel32.NewProc("GetOEMCP")
	getOverlappedResult                           = kernel32.NewProc("GetOverlappedResult")
	getPhysicallyInstalledSystemMemory            = kernel32.NewProc("GetPhysicallyInstalledSystemMemory")
	getPriorityClass                              = kernel32.NewProc("GetPriorityClass")
	getPrivateProfileIntA                         = kernel32.NewProc("GetPrivateProfileIntA")
	getPrivateProfileIntW                         = kernel32.NewProc("GetPrivateProfileIntW")
	getPrivateProfileSectionA                     = kernel32.NewProc("GetPrivateProfileSectionA")
	getPrivateProfileSectionNamesA                = kernel32.NewProc("GetPrivateProfileSectionNamesA")
	getPrivateProfileSectionNamesW                = kernel32.NewProc("GetPrivateProfileSectionNamesW")
	getPrivateProfileSectionW                     = kernel32.NewProc("GetPrivateProfileSectionW")
	getPrivateProfileStringA                      = kernel32.NewProc("GetPrivateProfileStringA")
	getPrivateProfileStringW                      = kernel32.NewProc("GetPrivateProfileStringW")
	getPrivateProfileStructA                      = kernel32.NewProc("GetPrivateProfileStructA")
	getPrivateProfileStructW                      = kernel32.NewProc("GetPrivateProfileStructW")
	getProcAddress                                = kernel32.NewProc("GetProcAddress")
	getProcessAffinityMask                        = kernel32.NewProc("GetProcessAffinityMask")
	getProcessDEPPolicy                           = kernel32.NewProc("GetProcessDEPPolicy")
	getProcessGroupAffinity                       = kernel32.NewProc("GetProcessGroupAffinity")
	getProcessHandleCount                         = kernel32.NewProc("GetProcessHandleCount")
	getProcessHeap                                = kernel32.NewProc("GetProcessHeap")
	getProcessHeaps                               = kernel32.NewProc("GetProcessHeaps")
	getProcessId                                  = kernel32.NewProc("GetProcessId")
	getProcessIdOfThread                          = kernel32.NewProc("GetProcessIdOfThread")
	getProcessIoCounters                          = kernel32.NewProc("GetProcessIoCounters")
	getProcessPreferredUILanguages                = kernel32.NewProc("GetProcessPreferredUILanguages")
	getProcessPriorityBoost                       = kernel32.NewProc("GetProcessPriorityBoost")
	getProcessShutdownParameters                  = kernel32.NewProc("GetProcessShutdownParameters")
	getProcessTimes                               = kernel32.NewProc("GetProcessTimes")
	getProcessUserModeExceptionPolicy             = kernel32.NewProc("GetProcessUserModeExceptionPolicy")
	getProcessVersion                             = kernel32.NewProc("GetProcessVersion")
	getProcessWorkingSetSize                      = kernel32.NewProc("GetProcessWorkingSetSize")
	getProcessWorkingSetSizeEx                    = kernel32.NewProc("GetProcessWorkingSetSizeEx")
	getProcessorSystemCycleTime                   = kernel32.NewProc("GetProcessorSystemCycleTime")
	getProductInfo                                = kernel32.NewProc("GetProductInfo")
	getProfileIntA                                = kernel32.NewProc("GetProfileIntA")
	getProfileIntW                                = kernel32.NewProc("GetProfileIntW")
	getProfileSectionA                            = kernel32.NewProc("GetProfileSectionA")
	getProfileSectionW                            = kernel32.NewProc("GetProfileSectionW")
	getProfileStringA                             = kernel32.NewProc("GetProfileStringA")
	getProfileStringW                             = kernel32.NewProc("GetProfileStringW")
	getQueuedCompletionStatus                     = kernel32.NewProc("GetQueuedCompletionStatus")
	getQueuedCompletionStatusEx                   = kernel32.NewProc("GetQueuedCompletionStatusEx")
	getShortPathNameA                             = kernel32.NewProc("GetShortPathNameA")
	getShortPathNameW                             = kernel32.NewProc("GetShortPathNameW")
	getStartupInfoA                               = kernel32.NewProc("GetStartupInfoA")
	getStartupInfoW                               = kernel32.NewProc("GetStartupInfoW")
	getStdHandle                                  = kernel32.NewProc("GetStdHandle")
	getStringScripts                              = kernel32.NewProc("GetStringScripts")
	getStringTypeA                                = kernel32.NewProc("GetStringTypeA")
	getStringTypeExA                              = kernel32.NewProc("GetStringTypeExA")
	getStringTypeExW                              = kernel32.NewProc("GetStringTypeExW")
	getStringTypeW                                = kernel32.NewProc("GetStringTypeW")
	getSystemDEPPolicy                            = kernel32.NewProc("GetSystemDEPPolicy")
	getSystemDefaultLCID                          = kernel32.NewProc("GetSystemDefaultLCID")
	getSystemDefaultLangID                        = kernel32.NewProc("GetSystemDefaultLangID")
	getSystemDefaultLocaleName                    = kernel32.NewProc("GetSystemDefaultLocaleName")
	getSystemDefaultUILanguage                    = kernel32.NewProc("GetSystemDefaultUILanguage")
	getSystemDirectoryA                           = kernel32.NewProc("GetSystemDirectoryA")
	getSystemDirectoryW                           = kernel32.NewProc("GetSystemDirectoryW")
	getSystemFileCacheSize                        = kernel32.NewProc("GetSystemFileCacheSize")
	getSystemFirmwareTable                        = kernel32.NewProc("GetSystemFirmwareTable")
	getSystemInfo                                 = kernel32.NewProc("GetSystemInfo")
	getSystemPowerStatus                          = kernel32.NewProc("GetSystemPowerStatus")
	getSystemPreferredUILanguages                 = kernel32.NewProc("GetSystemPreferredUILanguages")
	getSystemRegistryQuota                        = kernel32.NewProc("GetSystemRegistryQuota")
	getSystemTime                                 = kernel32.NewProc("GetSystemTime")
	getSystemTimeAdjustment                       = kernel32.NewProc("GetSystemTimeAdjustment")
	getSystemTimeAsFileTime                       = kernel32.NewProc("GetSystemTimeAsFileTime")
	getSystemTimes                                = kernel32.NewProc("GetSystemTimes")
	getSystemWindowsDirectoryA                    = kernel32.NewProc("GetSystemWindowsDirectoryA")
	getSystemWindowsDirectoryW                    = kernel32.NewProc("GetSystemWindowsDirectoryW")
	getSystemWow64DirectoryA                      = kernel32.NewProc("GetSystemWow64DirectoryA")
	getSystemWow64DirectoryW                      = kernel32.NewProc("GetSystemWow64DirectoryW")
	getTapeParameters                             = kernel32.NewProc("GetTapeParameters")
	getTapePosition                               = kernel32.NewProc("GetTapePosition")
	getTapeStatus                                 = kernel32.NewProc("GetTapeStatus")
	getTempFileNameA                              = kernel32.NewProc("GetTempFileNameA")
	getTempFileNameW                              = kernel32.NewProc("GetTempFileNameW")
	getTempPathA                                  = kernel32.NewProc("GetTempPathA")
	getTempPathW                                  = kernel32.NewProc("GetTempPathW")
	getThreadContext                              = kernel32.NewProc("GetThreadContext")
	getThreadErrorMode                            = kernel32.NewProc("GetThreadErrorMode")
	getThreadGroupAffinity                        = kernel32.NewProc("GetThreadGroupAffinity")
	getThreadIOPendingFlag                        = kernel32.NewProc("GetThreadIOPendingFlag")
	getThreadId                                   = kernel32.NewProc("GetThreadId")
	getThreadIdealProcessorEx                     = kernel32.NewProc("GetThreadIdealProcessorEx")
	getThreadLocale                               = kernel32.NewProc("GetThreadLocale")
	getThreadPreferredUILanguages                 = kernel32.NewProc("GetThreadPreferredUILanguages")
	getThreadPriority                             = kernel32.NewProc("GetThreadPriority")
	getThreadPriorityBoost                        = kernel32.NewProc("GetThreadPriorityBoost")
	getThreadSelectorEntry                        = kernel32.NewProc("GetThreadSelectorEntry")
	getThreadTimes                                = kernel32.NewProc("GetThreadTimes")
	getThreadUILanguage                           = kernel32.NewProc("GetThreadUILanguage")
	getTickCount                                  = kernel32.NewProc("GetTickCount")
	getTickCount64                                = kernel32.NewProc("GetTickCount64")
	getTimeFormatA                                = kernel32.NewProc("GetTimeFormatA")
	getTimeFormatEx                               = kernel32.NewProc("GetTimeFormatEx")
	getTimeFormatW                                = kernel32.NewProc("GetTimeFormatW")
	getTimeZoneInformation                        = kernel32.NewProc("GetTimeZoneInformation")
	getTimeZoneInformationForYear                 = kernel32.NewProc("GetTimeZoneInformationForYear")
	getUILanguageInfo                             = kernel32.NewProc("GetUILanguageInfo")
	getUmsCompletionListEvent                     = kernel32.NewProc("GetUmsCompletionListEvent")
	getUmsSystemThreadInformation                 = kernel32.NewProc("GetUmsSystemThreadInformation")
	getUserDefaultLCID                            = kernel32.NewProc("GetUserDefaultLCID")
	getUserDefaultLangID                          = kernel32.NewProc("GetUserDefaultLangID")
	getUserDefaultLocaleName                      = kernel32.NewProc("GetUserDefaultLocaleName")
	getUserDefaultUILanguage                      = kernel32.NewProc("GetUserDefaultUILanguage")
	getUserGeoID                                  = kernel32.NewProc("GetUserGeoID")
	getUserPreferredUILanguages                   = kernel32.NewProc("GetUserPreferredUILanguages")
	getVDMCurrentDirectories                      = kernel32.NewProc("GetVDMCurrentDirectories")
	getVersion                                    = kernel32.NewProc("GetVersion")
	getVersionExA                                 = kernel32.NewProc("GetVersionExA")
	getVersionExW                                 = kernel32.NewProc("GetVersionExW")
	getVolumeInformationA                         = kernel32.NewProc("GetVolumeInformationA")
	getVolumeInformationByHandleW                 = kernel32.NewProc("GetVolumeInformationByHandleW")
	getVolumeInformationW                         = kernel32.NewProc("GetVolumeInformationW")
	getVolumeNameForVolumeMountPointA             = kernel32.NewProc("GetVolumeNameForVolumeMountPointA")
	getVolumeNameForVolumeMountPointW             = kernel32.NewProc("GetVolumeNameForVolumeMountPointW")
	getVolumePathNameA                            = kernel32.NewProc("GetVolumePathNameA")
	getVolumePathNameW                            = kernel32.NewProc("GetVolumePathNameW")
	getVolumePathNamesForVolumeNameA              = kernel32.NewProc("GetVolumePathNamesForVolumeNameA")
	getVolumePathNamesForVolumeNameW              = kernel32.NewProc("GetVolumePathNamesForVolumeNameW")
	getWindowsDirectoryA                          = kernel32.NewProc("GetWindowsDirectoryA")
	getWindowsDirectoryW                          = kernel32.NewProc("GetWindowsDirectoryW")
	getWriteWatch                                 = kernel32.NewProc("GetWriteWatch")
	getXStateFeaturesMask                         = kernel32.NewProc("GetXStateFeaturesMask")
	globalAddAtomA                                = kernel32.NewProc("GlobalAddAtomA")
	globalAddAtomW                                = kernel32.NewProc("GlobalAddAtomW")
	globalAlloc                                   = kernel32.NewProc("GlobalAlloc")
	globalCompact                                 = kernel32.NewProc("GlobalCompact")
	globalDeleteAtom                              = kernel32.NewProc("GlobalDeleteAtom")
	globalFindAtomA                               = kernel32.NewProc("GlobalFindAtomA")
	globalFindAtomW                               = kernel32.NewProc("GlobalFindAtomW")
	globalFix                                     = kernel32.NewProc("GlobalFix")
	globalFlags                                   = kernel32.NewProc("GlobalFlags")
	globalFree                                    = kernel32.NewProc("GlobalFree")
	globalGetAtomNameA                            = kernel32.NewProc("GlobalGetAtomNameA")
	globalGetAtomNameW                            = kernel32.NewProc("GlobalGetAtomNameW")
	globalHandle                                  = kernel32.NewProc("GlobalHandle")
	globalLock                                    = kernel32.NewProc("GlobalLock")
	globalMemoryStatus                            = kernel32.NewProc("GlobalMemoryStatus")
	globalMemoryStatusEx                          = kernel32.NewProc("GlobalMemoryStatusEx")
	globalReAlloc                                 = kernel32.NewProc("GlobalReAlloc")
	globalSize                                    = kernel32.NewProc("GlobalSize")
	globalUnWire                                  = kernel32.NewProc("GlobalUnWire")
	globalUnfix                                   = kernel32.NewProc("GlobalUnfix")
	globalUnlock                                  = kernel32.NewProc("GlobalUnlock")
	globalWire                                    = kernel32.NewProc("GlobalWire")
	heap32First                                   = kernel32.NewProc("Heap32First")
	heap32ListFirst                               = kernel32.NewProc("Heap32ListFirst")
	heap32ListNext                                = kernel32.NewProc("Heap32ListNext")
	heap32Next                                    = kernel32.NewProc("Heap32Next")
	heapAlloc                                     = kernel32.NewProc("HeapAlloc")
	heapCompact                                   = kernel32.NewProc("HeapCompact")
	heapCreate                                    = kernel32.NewProc("HeapCreate")
	heapDestroy                                   = kernel32.NewProc("HeapDestroy")
	heapFree                                      = kernel32.NewProc("HeapFree")
	heapLock                                      = kernel32.NewProc("HeapLock")
	heapQueryInformation                          = kernel32.NewProc("HeapQueryInformation")
	heapReAlloc                                   = kernel32.NewProc("HeapReAlloc")
	heapSetInformation                            = kernel32.NewProc("HeapSetInformation")
	heapSize                                      = kernel32.NewProc("HeapSize")
	heapSummary                                   = kernel32.NewProc("HeapSummary")
	heapUnlock                                    = kernel32.NewProc("HeapUnlock")
	heapValidate                                  = kernel32.NewProc("HeapValidate")
	heapWalk                                      = kernel32.NewProc("HeapWalk")
	idnToAscii                                    = kernel32.NewProc("IdnToAscii")
	idnToNameprepUnicode                          = kernel32.NewProc("IdnToNameprepUnicode")
	idnToUnicode                                  = kernel32.NewProc("IdnToUnicode")
	initAtomTable                                 = kernel32.NewProc("InitAtomTable")
	initOnceBeginInitialize                       = kernel32.NewProc("InitOnceBeginInitialize")
	initOnceComplete                              = kernel32.NewProc("InitOnceComplete")
	initOnceExecuteOnce                           = kernel32.NewProc("InitOnceExecuteOnce")
	initOnceInitialize                            = kernel32.NewProc("InitOnceInitialize")
	initializeConditionVariable                   = kernel32.NewProc("InitializeConditionVariable")
	initializeContext                             = kernel32.NewProc("InitializeContext")
	initializeCriticalSection                     = kernel32.NewProc("InitializeCriticalSection")
	initializeCriticalSectionAndSpinCount         = kernel32.NewProc("InitializeCriticalSectionAndSpinCount")
	initializeCriticalSectionEx                   = kernel32.NewProc("InitializeCriticalSectionEx")
	initializeProcThreadAttributeList             = kernel32.NewProc("InitializeProcThreadAttributeList")
	initializeSListHead                           = kernel32.NewProc("InitializeSListHead")
	initializeSRWLock                             = kernel32.NewProc("InitializeSRWLock")
	interlockedFlushSList                         = kernel32.NewProc("InterlockedFlushSList")
	interlockedPopEntrySList                      = kernel32.NewProc("InterlockedPopEntrySList")
	interlockedPushEntrySList                     = kernel32.NewProc("InterlockedPushEntrySList")
	interlockedPushListSList                      = kernel32.NewProc("InterlockedPushListSList")
	invalidateConsoleDIBits                       = kernel32.NewProc("InvalidateConsoleDIBits")
	isBadCodePtr                                  = kernel32.NewProc("IsBadCodePtr")
	isBadHugeReadPtr                              = kernel32.NewProc("IsBadHugeReadPtr")
	isBadHugeWritePtr                             = kernel32.NewProc("IsBadHugeWritePtr")
	isBadReadPtr                                  = kernel32.NewProc("IsBadReadPtr")
	isBadStringPtrA                               = kernel32.NewProc("IsBadStringPtrA")
	isBadStringPtrW                               = kernel32.NewProc("IsBadStringPtrW")
	isBadWritePtr                                 = kernel32.NewProc("IsBadWritePtr")
	isCalendarLeapDay                             = kernel32.NewProc("IsCalendarLeapDay")
	isCalendarLeapMonth                           = kernel32.NewProc("IsCalendarLeapMonth")
	isCalendarLeapYear                            = kernel32.NewProc("IsCalendarLeapYear")
	isDBCSLeadByte                                = kernel32.NewProc("IsDBCSLeadByte")
	isDBCSLeadByteEx                              = kernel32.NewProc("IsDBCSLeadByteEx")
	isDebuggerPresent                             = kernel32.NewProc("IsDebuggerPresent")
	isNLSDefinedString                            = kernel32.NewProc("IsNLSDefinedString")
	isNormalizedString                            = kernel32.NewProc("IsNormalizedString")
	isProcessInJob                                = kernel32.NewProc("IsProcessInJob")
	isProcessorFeaturePresent                     = kernel32.NewProc("IsProcessorFeaturePresent")
	isSystemResumeAutomatic                       = kernel32.NewProc("IsSystemResumeAutomatic")
	isThreadAFiber                                = kernel32.NewProc("IsThreadAFiber")
	isThreadpoolTimerSet                          = kernel32.NewProc("IsThreadpoolTimerSet")
	isTimeZoneRedirectionEnabled                  = kernel32.NewProc("IsTimeZoneRedirectionEnabled")
	isValidCalDateTime                            = kernel32.NewProc("IsValidCalDateTime")
	isValidCodePage                               = kernel32.NewProc("IsValidCodePage")
	isValidLanguageGroup                          = kernel32.NewProc("IsValidLanguageGroup")
	isValidLocale                                 = kernel32.NewProc("IsValidLocale")
	isValidLocaleName                             = kernel32.NewProc("IsValidLocaleName")
	isWow64Process                                = kernel32.NewProc("IsWow64Process")
	k32EmptyWorkingSet                            = kernel32.NewProc("K32EmptyWorkingSet")
	k32EnumDeviceDrivers                          = kernel32.NewProc("K32EnumDeviceDrivers")
	k32EnumPageFilesA                             = kernel32.NewProc("K32EnumPageFilesA")
	k32EnumPageFilesW                             = kernel32.NewProc("K32EnumPageFilesW")
	k32EnumProcessModules                         = kernel32.NewProc("K32EnumProcessModules")
	k32EnumProcessModulesEx                       = kernel32.NewProc("K32EnumProcessModulesEx")
	k32EnumProcesses                              = kernel32.NewProc("K32EnumProcesses")
	k32GetDeviceDriverBaseNameA                   = kernel32.NewProc("K32GetDeviceDriverBaseNameA")
	k32GetDeviceDriverBaseNameW                   = kernel32.NewProc("K32GetDeviceDriverBaseNameW")
	k32GetDeviceDriverFileNameA                   = kernel32.NewProc("K32GetDeviceDriverFileNameA")
	k32GetDeviceDriverFileNameW                   = kernel32.NewProc("K32GetDeviceDriverFileNameW")
	k32GetMappedFileNameA                         = kernel32.NewProc("K32GetMappedFileNameA")
	k32GetMappedFileNameW                         = kernel32.NewProc("K32GetMappedFileNameW")
	k32GetModuleBaseNameA                         = kernel32.NewProc("K32GetModuleBaseNameA")
	k32GetModuleBaseNameW                         = kernel32.NewProc("K32GetModuleBaseNameW")
	k32GetModuleFileNameExA                       = kernel32.NewProc("K32GetModuleFileNameExA")
	k32GetModuleFileNameExW                       = kernel32.NewProc("K32GetModuleFileNameExW")
	k32GetModuleInformation                       = kernel32.NewProc("K32GetModuleInformation")
	k32GetPerformanceInfo                         = kernel32.NewProc("K32GetPerformanceInfo")
	k32GetProcessImageFileNameA                   = kernel32.NewProc("K32GetProcessImageFileNameA")
	k32GetProcessImageFileNameW                   = kernel32.NewProc("K32GetProcessImageFileNameW")
	k32GetProcessMemoryInfo                       = kernel32.NewProc("K32GetProcessMemoryInfo")
	k32GetWsChanges                               = kernel32.NewProc("K32GetWsChanges")
	k32GetWsChangesEx                             = kernel32.NewProc("K32GetWsChangesEx")
	k32InitializeProcessForWsWatch                = kernel32.NewProc("K32InitializeProcessForWsWatch")
	k32QueryWorkingSet                            = kernel32.NewProc("K32QueryWorkingSet")
	k32QueryWorkingSetEx                          = kernel32.NewProc("K32QueryWorkingSetEx")
	lCIDToLocaleName                              = kernel32.NewProc("LCIDToLocaleName")
	lCMapStringA                                  = kernel32.NewProc("LCMapStringA")
	lCMapStringEx                                 = kernel32.NewProc("LCMapStringEx")
	lCMapStringW                                  = kernel32.NewProc("LCMapStringW")
	lZClose                                       = kernel32.NewProc("LZClose")
	lZCloseFile                                   = kernel32.NewProc("LZCloseFile")
	lZCopy                                        = kernel32.NewProc("LZCopy")
	lZCreateFileW                                 = kernel32.NewProc("LZCreateFileW")
	lZDone                                        = kernel32.NewProc("LZDone")
	lZInit                                        = kernel32.NewProc("LZInit")
	lZOpenFileA                                   = kernel32.NewProc("LZOpenFileA")
	lZOpenFileW                                   = kernel32.NewProc("LZOpenFileW")
	lZRead                                        = kernel32.NewProc("LZRead")
	lZSeek                                        = kernel32.NewProc("LZSeek")
	lZStart                                       = kernel32.NewProc("LZStart")
	leaveCriticalSection                          = kernel32.NewProc("LeaveCriticalSection")
	leaveCriticalSectionWhenCallbackReturns       = kernel32.NewProc("LeaveCriticalSectionWhenCallbackReturns")
	loadAppInitDlls                               = kernel32.NewProc("LoadAppInitDlls")
	loadLibraryA                                  = kernel32.NewProc("LoadLibraryA")
	loadLibraryExA                                = kernel32.NewProc("LoadLibraryExA")
	loadLibraryExW                                = kernel32.NewProc("LoadLibraryExW")
	loadLibraryW                                  = kernel32.NewProc("LoadLibraryW")
	loadModule                                    = kernel32.NewProc("LoadModule")
	loadResource                                  = kernel32.NewProc("LoadResource")
	loadStringBaseExW                             = kernel32.NewProc("LoadStringBaseExW")
	loadStringBaseW                               = kernel32.NewProc("LoadStringBaseW")
	localAlloc                                    = kernel32.NewProc("LocalAlloc")
	localCompact                                  = kernel32.NewProc("LocalCompact")
	localFileTimeToFileTime                       = kernel32.NewProc("LocalFileTimeToFileTime")
	localFlags                                    = kernel32.NewProc("LocalFlags")
	localFree                                     = kernel32.NewProc("LocalFree")
	localHandle                                   = kernel32.NewProc("LocalHandle")
	localLock                                     = kernel32.NewProc("LocalLock")
	localReAlloc                                  = kernel32.NewProc("LocalReAlloc")
	localShrink                                   = kernel32.NewProc("LocalShrink")
	localSize                                     = kernel32.NewProc("LocalSize")
	localUnlock                                   = kernel32.NewProc("LocalUnlock")
	localeNameToLCID                              = kernel32.NewProc("LocaleNameToLCID")
	locateXStateFeature                           = kernel32.NewProc("LocateXStateFeature")
	lockFile                                      = kernel32.NewProc("LockFile")
	lockFileEx                                    = kernel32.NewProc("LockFileEx")
	lockResource                                  = kernel32.NewProc("LockResource")
	mapUserPhysicalPages                          = kernel32.NewProc("MapUserPhysicalPages")
	mapUserPhysicalPagesScatter                   = kernel32.NewProc("MapUserPhysicalPagesScatter")
	mapViewOfFile                                 = kernel32.NewProc("MapViewOfFile")
	mapViewOfFileEx                               = kernel32.NewProc("MapViewOfFileEx")
	mapViewOfFileExNuma                           = kernel32.NewProc("MapViewOfFileExNuma")
	module32First                                 = kernel32.NewProc("Module32First")
	module32FirstW                                = kernel32.NewProc("Module32FirstW")
	module32Next                                  = kernel32.NewProc("Module32Next")
	module32NextW                                 = kernel32.NewProc("Module32NextW")
	moveFileA                                     = kernel32.NewProc("MoveFileA")
	moveFileExA                                   = kernel32.NewProc("MoveFileExA")
	moveFileExW                                   = kernel32.NewProc("MoveFileExW")
	moveFileTransactedA                           = kernel32.NewProc("MoveFileTransactedA")
	moveFileTransactedW                           = kernel32.NewProc("MoveFileTransactedW")
	moveFileW                                     = kernel32.NewProc("MoveFileW")
	moveFileWithProgressA                         = kernel32.NewProc("MoveFileWithProgressA")
	moveFileWithProgressW                         = kernel32.NewProc("MoveFileWithProgressW")
	mulDiv                                        = kernel32.NewProc("MulDiv")
	multiByteToWideChar                           = kernel32.NewProc("MultiByteToWideChar")
	needCurrentDirectoryForExePathA               = kernel32.NewProc("NeedCurrentDirectoryForExePathA")
	needCurrentDirectoryForExePathW               = kernel32.NewProc("NeedCurrentDirectoryForExePathW")
	nlsCheckPolicy                                = kernel32.NewProc("NlsCheckPolicy")
	nlsEventDataDescCreate                        = kernel32.NewProc("NlsEventDataDescCreate")
	nlsGetCacheUpdateCount                        = kernel32.NewProc("NlsGetCacheUpdateCount")
	nlsUpdateLocale                               = kernel32.NewProc("NlsUpdateLocale")
	nlsUpdateSystemLocale                         = kernel32.NewProc("NlsUpdateSystemLocale")
	nlsWriteEtwEvent                              = kernel32.NewProc("NlsWriteEtwEvent")
	normalizeString                               = kernel32.NewProc("NormalizeString")
	notifyMountMgr                                = kernel32.NewProc("NotifyMountMgr")
	notifyUILanguageChange                        = kernel32.NewProc("NotifyUILanguageChange")
	openConsoleW                                  = kernel32.NewProc("OpenConsoleW")
	openEventA                                    = kernel32.NewProc("OpenEventA")
	openEventW                                    = kernel32.NewProc("OpenEventW")
	openFile                                      = kernel32.NewProc("OpenFile")
	openFileById                                  = kernel32.NewProc("OpenFileById")
	openFileMappingA                              = kernel32.NewProc("OpenFileMappingA")
	openFileMappingW                              = kernel32.NewProc("OpenFileMappingW")
	openJobObjectA                                = kernel32.NewProc("OpenJobObjectA")
	openJobObjectW                                = kernel32.NewProc("OpenJobObjectW")
	openMutexA                                    = kernel32.NewProc("OpenMutexA")
	openMutexW                                    = kernel32.NewProc("OpenMutexW")
	openPrivateNamespaceA                         = kernel32.NewProc("OpenPrivateNamespaceA")
	openPrivateNamespaceW                         = kernel32.NewProc("OpenPrivateNamespaceW")
	openProcess                                   = kernel32.NewProc("OpenProcess")
	openProcessToken                              = kernel32.NewProc("OpenProcessToken")
	openProfileUserMapping                        = kernel32.NewProc("OpenProfileUserMapping")
	openSemaphoreA                                = kernel32.NewProc("OpenSemaphoreA")
	openSemaphoreW                                = kernel32.NewProc("OpenSemaphoreW")
	openThread                                    = kernel32.NewProc("OpenThread")
	openThreadToken                               = kernel32.NewProc("OpenThreadToken")
	openWaitableTimerA                            = kernel32.NewProc("OpenWaitableTimerA")
	openWaitableTimerW                            = kernel32.NewProc("OpenWaitableTimerW")
	outputDebugStringA                            = kernel32.NewProc("OutputDebugStringA")
	outputDebugStringW                            = kernel32.NewProc("OutputDebugStringW")
	peekConsoleInputA                             = kernel32.NewProc("PeekConsoleInputA")
	peekConsoleInputW                             = kernel32.NewProc("PeekConsoleInputW")
	peekNamedPipe                                 = kernel32.NewProc("PeekNamedPipe")
	postQueuedCompletionStatus                    = kernel32.NewProc("PostQueuedCompletionStatus")
	powerClearRequest                             = kernel32.NewProc("PowerClearRequest")
	powerCreateRequest                            = kernel32.NewProc("PowerCreateRequest")
	powerSetRequest                               = kernel32.NewProc("PowerSetRequest")
	prepareTape                                   = kernel32.NewProc("PrepareTape")
	privCopyFileExW                               = kernel32.NewProc("PrivCopyFileExW")
	privMoveFileIdentityW                         = kernel32.NewProc("PrivMoveFileIdentityW")
	process32First                                = kernel32.NewProc("Process32First")
	process32FirstW                               = kernel32.NewProc("Process32FirstW")
	process32Next                                 = kernel32.NewProc("Process32Next")
	process32NextW                                = kernel32.NewProc("Process32NextW")
	processIdToSessionId                          = kernel32.NewProc("ProcessIdToSessionId")
	pulseEvent                                    = kernel32.NewProc("PulseEvent")
	purgeComm                                     = kernel32.NewProc("PurgeComm")
	queryActCtxSettingsW                          = kernel32.NewProc("QueryActCtxSettingsW")
	queryActCtxW                                  = kernel32.NewProc("QueryActCtxW")
	queryDepthSList                               = kernel32.NewProc("QueryDepthSList")
	queryDosDeviceA                               = kernel32.NewProc("QueryDosDeviceA")
	queryDosDeviceW                               = kernel32.NewProc("QueryDosDeviceW")
	queryFullProcessImageNameA                    = kernel32.NewProc("QueryFullProcessImageNameA")
	queryFullProcessImageNameW                    = kernel32.NewProc("QueryFullProcessImageNameW")
	queryIdleProcessorCycleTime                   = kernel32.NewProc("QueryIdleProcessorCycleTime")
	queryIdleProcessorCycleTimeEx                 = kernel32.NewProc("QueryIdleProcessorCycleTimeEx")
	queryInformationJobObject                     = kernel32.NewProc("QueryInformationJobObject")
	queryMemoryResourceNotification               = kernel32.NewProc("QueryMemoryResourceNotification")
	queryPerformanceCounter                       = kernel32.NewProc("QueryPerformanceCounter")
	queryPerformanceFrequency                     = kernel32.NewProc("QueryPerformanceFrequency")
	queryProcessAffinityUpdateMode                = kernel32.NewProc("QueryProcessAffinityUpdateMode")
	queryProcessCycleTime                         = kernel32.NewProc("QueryProcessCycleTime")
	queryThreadCycleTime                          = kernel32.NewProc("QueryThreadCycleTime")
	queryThreadProfiling                          = kernel32.NewProc("QueryThreadProfiling")
	queryThreadpoolStackInformation               = kernel32.NewProc("QueryThreadpoolStackInformation")
	queryUmsThreadInformation                     = kernel32.NewProc("QueryUmsThreadInformation")
	queryUnbiasedInterruptTime                    = kernel32.NewProc("QueryUnbiasedInterruptTime")
	queueUserAPC                                  = kernel32.NewProc("QueueUserAPC")
	queueUserWorkItem                             = kernel32.NewProc("QueueUserWorkItem")
	raiseException                                = kernel32.NewProc("RaiseException")
	raiseFailFastException                        = kernel32.NewProc("RaiseFailFastException")
	reOpenFile                                    = kernel32.NewProc("ReOpenFile")
	readConsoleA                                  = kernel32.NewProc("ReadConsoleA")
	readConsoleInputA                             = kernel32.NewProc("ReadConsoleInputA")
	readConsoleInputExA                           = kernel32.NewProc("ReadConsoleInputExA")
	readConsoleInputExW                           = kernel32.NewProc("ReadConsoleInputExW")
	readConsoleInputW                             = kernel32.NewProc("ReadConsoleInputW")
	readConsoleOutputA                            = kernel32.NewProc("ReadConsoleOutputA")
	readConsoleOutputAttribute                    = kernel32.NewProc("ReadConsoleOutputAttribute")
	readConsoleOutputCharacterA                   = kernel32.NewProc("ReadConsoleOutputCharacterA")
	readConsoleOutputCharacterW                   = kernel32.NewProc("ReadConsoleOutputCharacterW")
	readConsoleOutputW                            = kernel32.NewProc("ReadConsoleOutputW")
	readConsoleW                                  = kernel32.NewProc("ReadConsoleW")
	readDirectoryChangesW                         = kernel32.NewProc("ReadDirectoryChangesW")
	readFile                                      = kernel32.NewProc("ReadFile")
	readFileEx                                    = kernel32.NewProc("ReadFileEx")
	readFileScatter                               = kernel32.NewProc("ReadFileScatter")
	readProcessMemory                             = kernel32.NewProc("ReadProcessMemory")
	readThreadProfilingData                       = kernel32.NewProc("ReadThreadProfilingData")
	regCloseKey                                   = kernel32.NewProc("RegCloseKey")
	regCreateKeyExA                               = kernel32.NewProc("RegCreateKeyExA")
	regCreateKeyExW                               = kernel32.NewProc("RegCreateKeyExW")
	regDeleteKeyExA                               = kernel32.NewProc("RegDeleteKeyExA")
	regDeleteKeyExW                               = kernel32.NewProc("RegDeleteKeyExW")
	regDeleteTreeA                                = kernel32.NewProc("RegDeleteTreeA")
	regDeleteTreeW                                = kernel32.NewProc("RegDeleteTreeW")
	regDeleteValueA                               = kernel32.NewProc("RegDeleteValueA")
	regDeleteValueW                               = kernel32.NewProc("RegDeleteValueW")
	regDisablePredefinedCacheEx                   = kernel32.NewProc("RegDisablePredefinedCacheEx")
	regEnumKeyExA                                 = kernel32.NewProc("RegEnumKeyExA")
	regEnumKeyExW                                 = kernel32.NewProc("RegEnumKeyExW")
	regEnumValueA                                 = kernel32.NewProc("RegEnumValueA")
	regEnumValueW                                 = kernel32.NewProc("RegEnumValueW")
	regFlushKey                                   = kernel32.NewProc("RegFlushKey")
	regGetKeySecurity                             = kernel32.NewProc("RegGetKeySecurity")
	regGetValueA                                  = kernel32.NewProc("RegGetValueA")
	regGetValueW                                  = kernel32.NewProc("RegGetValueW")
	regKrnGetGlobalState                          = kernel32.NewProc("RegKrnGetGlobalState")
	regKrnInitialize                              = kernel32.NewProc("RegKrnInitialize")
	regLoadKeyA                                   = kernel32.NewProc("RegLoadKeyA")
	regLoadKeyW                                   = kernel32.NewProc("RegLoadKeyW")
	regLoadMUIStringA                             = kernel32.NewProc("RegLoadMUIStringA")
	regLoadMUIStringW                             = kernel32.NewProc("RegLoadMUIStringW")
	regNotifyChangeKeyValue                       = kernel32.NewProc("RegNotifyChangeKeyValue")
	regOpenCurrentUser                            = kernel32.NewProc("RegOpenCurrentUser")
	regOpenKeyExA                                 = kernel32.NewProc("RegOpenKeyExA")
	regOpenKeyExW                                 = kernel32.NewProc("RegOpenKeyExW")
	regOpenUserClassesRoot                        = kernel32.NewProc("RegOpenUserClassesRoot")
	regQueryInfoKeyA                              = kernel32.NewProc("RegQueryInfoKeyA")
	regQueryInfoKeyW                              = kernel32.NewProc("RegQueryInfoKeyW")
	regQueryValueExA                              = kernel32.NewProc("RegQueryValueExA")
	regQueryValueExW                              = kernel32.NewProc("RegQueryValueExW")
	regRestoreKeyA                                = kernel32.NewProc("RegRestoreKeyA")
	regRestoreKeyW                                = kernel32.NewProc("RegRestoreKeyW")
	regSaveKeyExA                                 = kernel32.NewProc("RegSaveKeyExA")
	regSaveKeyExW                                 = kernel32.NewProc("RegSaveKeyExW")
	regSetKeySecurity                             = kernel32.NewProc("RegSetKeySecurity")
	regSetValueExA                                = kernel32.NewProc("RegSetValueExA")
	regSetValueExW                                = kernel32.NewProc("RegSetValueExW")
	regUnLoadKeyA                                 = kernel32.NewProc("RegUnLoadKeyA")
	regUnLoadKeyW                                 = kernel32.NewProc("RegUnLoadKeyW")
	registerApplicationRecoveryCallback           = kernel32.NewProc("RegisterApplicationRecoveryCallback")
	registerApplicationRestart                    = kernel32.NewProc("RegisterApplicationRestart")
	registerConsoleIME                            = kernel32.NewProc("RegisterConsoleIME")
	registerConsoleOS2                            = kernel32.NewProc("RegisterConsoleOS2")
	registerConsoleVDM                            = kernel32.NewProc("RegisterConsoleVDM")
	registerWaitForInputIdle                      = kernel32.NewProc("RegisterWaitForInputIdle")
	registerWaitForSingleObject                   = kernel32.NewProc("RegisterWaitForSingleObject")
	registerWaitForSingleObjectEx                 = kernel32.NewProc("RegisterWaitForSingleObjectEx")
	registerWowBaseHandlers                       = kernel32.NewProc("RegisterWowBaseHandlers")
	registerWowExec                               = kernel32.NewProc("RegisterWowExec")
	releaseActCtx                                 = kernel32.NewProc("ReleaseActCtx")
	releaseMutex                                  = kernel32.NewProc("ReleaseMutex")
	releaseMutexWhenCallbackReturns               = kernel32.NewProc("ReleaseMutexWhenCallbackReturns")
	releaseSRWLockExclusive                       = kernel32.NewProc("ReleaseSRWLockExclusive")
	releaseSRWLockShared                          = kernel32.NewProc("ReleaseSRWLockShared")
	releaseSemaphore                              = kernel32.NewProc("ReleaseSemaphore")
	releaseSemaphoreWhenCallbackReturns           = kernel32.NewProc("ReleaseSemaphoreWhenCallbackReturns")
	removeDirectoryA                              = kernel32.NewProc("RemoveDirectoryA")
	removeDirectoryTransactedA                    = kernel32.NewProc("RemoveDirectoryTransactedA")
	removeDirectoryTransactedW                    = kernel32.NewProc("RemoveDirectoryTransactedW")
	removeDirectoryW                              = kernel32.NewProc("RemoveDirectoryW")
	removeLocalAlternateComputerNameA             = kernel32.NewProc("RemoveLocalAlternateComputerNameA")
	removeLocalAlternateComputerNameW             = kernel32.NewProc("RemoveLocalAlternateComputerNameW")
	removeSecureMemoryCacheCallback               = kernel32.NewProc("RemoveSecureMemoryCacheCallback")
	removeVectoredContinueHandler                 = kernel32.NewProc("RemoveVectoredContinueHandler")
	removeVectoredExceptionHandler                = kernel32.NewProc("RemoveVectoredExceptionHandler")
	replaceFile                                   = kernel32.NewProc("ReplaceFile")
	replaceFileA                                  = kernel32.NewProc("ReplaceFileA")
	replaceFileW                                  = kernel32.NewProc("ReplaceFileW")
	replacePartitionUnit                          = kernel32.NewProc("ReplacePartitionUnit")
	requestDeviceWakeup                           = kernel32.NewProc("RequestDeviceWakeup")
	requestWakeupLatency                          = kernel32.NewProc("RequestWakeupLatency")
	resetEvent                                    = kernel32.NewProc("ResetEvent")
	resetWriteWatch                               = kernel32.NewProc("ResetWriteWatch")
	resolveLocaleName                             = kernel32.NewProc("ResolveLocaleName")
	restoreLastError                              = kernel32.NewProc("RestoreLastError")
	resumeThread                                  = kernel32.NewProc("ResumeThread")
	rtlAddFunctionTable                           = kernel32.NewProc("RtlAddFunctionTable")
	rtlCaptureContext                             = kernel32.NewProc("RtlCaptureContext")
	rtlCaptureStackBackTrace                      = kernel32.NewProc("RtlCaptureStackBackTrace")
	rtlCompareMemory                              = kernel32.NewProc("RtlCompareMemory")
	rtlCopyMemory                                 = kernel32.NewProc("RtlCopyMemory")
	rtlDeleteFunctionTable                        = kernel32.NewProc("RtlDeleteFunctionTable")
	rtlFillMemory                                 = kernel32.NewProc("RtlFillMemory")
	rtlInstallFunctionTableCallback               = kernel32.NewProc("RtlInstallFunctionTableCallback")
	rtlLookupFunctionEntry                        = kernel32.NewProc("RtlLookupFunctionEntry")
	rtlMoveMemory                                 = kernel32.NewProc("RtlMoveMemory")
	rtlPcToFileHeader                             = kernel32.NewProc("RtlPcToFileHeader")
	rtlRaiseException                             = kernel32.NewProc("RtlRaiseException")
	rtlRestoreContext                             = kernel32.NewProc("RtlRestoreContext")
	rtlUnwind                                     = kernel32.NewProc("RtlUnwind")
	rtlUnwindEx                                   = kernel32.NewProc("RtlUnwindEx")
	rtlVirtualUnwind                              = kernel32.NewProc("RtlVirtualUnwind")
	rtlZeroMemory                                 = kernel32.NewProc("RtlZeroMemory")
	scrollConsoleScreenBufferA                    = kernel32.NewProc("ScrollConsoleScreenBufferA")
	scrollConsoleScreenBufferW                    = kernel32.NewProc("ScrollConsoleScreenBufferW")
	searchPathA                                   = kernel32.NewProc("SearchPathA")
	searchPathW                                   = kernel32.NewProc("SearchPathW")
	setCalendarInfoA                              = kernel32.NewProc("SetCalendarInfoA")
	setCalendarInfoW                              = kernel32.NewProc("SetCalendarInfoW")
	setClientTimeZoneInformation                  = kernel32.NewProc("SetClientTimeZoneInformation")
	setComPlusPackageInstallStatus                = kernel32.NewProc("SetComPlusPackageInstallStatus")
	setCommBreak                                  = kernel32.NewProc("SetCommBreak")
	setCommConfig                                 = kernel32.NewProc("SetCommConfig")
	setCommMask                                   = kernel32.NewProc("SetCommMask")
	setCommState                                  = kernel32.NewProc("SetCommState")
	setCommTimeouts                               = kernel32.NewProc("SetCommTimeouts")
	setComputerNameA                              = kernel32.NewProc("SetComputerNameA")
	setComputerNameExA                            = kernel32.NewProc("SetComputerNameExA")
	setComputerNameExW                            = kernel32.NewProc("SetComputerNameExW")
	setComputerNameW                              = kernel32.NewProc("SetComputerNameW")
	setConsoleActiveScreenBuffer                  = kernel32.NewProc("SetConsoleActiveScreenBuffer")
	setConsoleCP                                  = kernel32.NewProc("SetConsoleCP")
	setConsoleCtrlHandler                         = kernel32.NewProc("SetConsoleCtrlHandler")
	setConsoleCursor                              = kernel32.NewProc("SetConsoleCursor")
	setConsoleCursorInfo                          = kernel32.NewProc("SetConsoleCursorInfo")
	setConsoleCursorMode                          = kernel32.NewProc("SetConsoleCursorMode")
	setConsoleCursorPosition                      = kernel32.NewProc("SetConsoleCursorPosition")
	setConsoleDisplayMode                         = kernel32.NewProc("SetConsoleDisplayMode")
	setConsoleFont                                = kernel32.NewProc("SetConsoleFont")
	setConsoleHardwareState                       = kernel32.NewProc("SetConsoleHardwareState")
	setConsoleHistoryInfo                         = kernel32.NewProc("SetConsoleHistoryInfo")
	setConsoleIcon                                = kernel32.NewProc("SetConsoleIcon")
	setConsoleInputExeNameA                       = kernel32.NewProc("SetConsoleInputExeNameA")
	setConsoleInputExeNameW                       = kernel32.NewProc("SetConsoleInputExeNameW")
	setConsoleKeyShortcuts                        = kernel32.NewProc("SetConsoleKeyShortcuts")
	setConsoleLocalEUDC                           = kernel32.NewProc("SetConsoleLocalEUDC")
	setConsoleMaximumWindowSize                   = kernel32.NewProc("SetConsoleMaximumWindowSize")
	setConsoleMenuClose                           = kernel32.NewProc("SetConsoleMenuClose")
	setConsoleMode                                = kernel32.NewProc("SetConsoleMode")
	setConsoleNlsMode                             = kernel32.NewProc("SetConsoleNlsMode")
	setConsoleNumberOfCommandsA                   = kernel32.NewProc("SetConsoleNumberOfCommandsA")
	setConsoleNumberOfCommandsW                   = kernel32.NewProc("SetConsoleNumberOfCommandsW")
	setConsoleOS2OemFormat                        = kernel32.NewProc("SetConsoleOS2OemFormat")
	setConsoleOutputCP                            = kernel32.NewProc("SetConsoleOutputCP")
	setConsolePalette                             = kernel32.NewProc("SetConsolePalette")
	setConsoleScreenBufferInfoEx                  = kernel32.NewProc("SetConsoleScreenBufferInfoEx")
	setConsoleScreenBufferSize                    = kernel32.NewProc("SetConsoleScreenBufferSize")
	setConsoleTextAttribute                       = kernel32.NewProc("SetConsoleTextAttribute")
	setConsoleTitleA                              = kernel32.NewProc("SetConsoleTitleA")
	setConsoleTitleW                              = kernel32.NewProc("SetConsoleTitleW")
	setConsoleWindowInfo                          = kernel32.NewProc("SetConsoleWindowInfo")
	setCriticalSectionSpinCount                   = kernel32.NewProc("SetCriticalSectionSpinCount")
	setCurrentConsoleFontEx                       = kernel32.NewProc("SetCurrentConsoleFontEx")
	setCurrentDirectoryA                          = kernel32.NewProc("SetCurrentDirectoryA")
	setCurrentDirectoryW                          = kernel32.NewProc("SetCurrentDirectoryW")
	setDefaultCommConfigA                         = kernel32.NewProc("SetDefaultCommConfigA")
	setDefaultCommConfigW                         = kernel32.NewProc("SetDefaultCommConfigW")
	setDllDirectoryA                              = kernel32.NewProc("SetDllDirectoryA")
	setDllDirectoryW                              = kernel32.NewProc("SetDllDirectoryW")
	setDynamicTimeZoneInformation                 = kernel32.NewProc("SetDynamicTimeZoneInformation")
	setEndOfFile                                  = kernel32.NewProc("SetEndOfFile")
	setEnvironmentStringsA                        = kernel32.NewProc("SetEnvironmentStringsA")
	setEnvironmentStringsW                        = kernel32.NewProc("SetEnvironmentStringsW")
	setEnvironmentVariableA                       = kernel32.NewProc("SetEnvironmentVariableA")
	setEnvironmentVariableW                       = kernel32.NewProc("SetEnvironmentVariableW")
	setErrorMode                                  = kernel32.NewProc("SetErrorMode")
	setEvent                                      = kernel32.NewProc("SetEvent")
	setEventWhenCallbackReturns                   = kernel32.NewProc("SetEventWhenCallbackReturns")
	setFileApisToANSI                             = kernel32.NewProc("SetFileApisToANSI")
	setFileApisToOEM                              = kernel32.NewProc("SetFileApisToOEM")
	setFileAttributesA                            = kernel32.NewProc("SetFileAttributesA")
	setFileAttributesTransactedA                  = kernel32.NewProc("SetFileAttributesTransactedA")
	setFileAttributesTransactedW                  = kernel32.NewProc("SetFileAttributesTransactedW")
	setFileAttributesW                            = kernel32.NewProc("SetFileAttributesW")
	setFileBandwidthReservation                   = kernel32.NewProc("SetFileBandwidthReservation")
	setFileCompletionNotificationModes            = kernel32.NewProc("SetFileCompletionNotificationModes")
	setFileInformationByHandle                    = kernel32.NewProc("SetFileInformationByHandle")
	setFileIoOverlappedRange                      = kernel32.NewProc("SetFileIoOverlappedRange")
	setFilePointer                                = kernel32.NewProc("SetFilePointer")
	setFilePointerEx                              = kernel32.NewProc("SetFilePointerEx")
	setFileShortNameA                             = kernel32.NewProc("SetFileShortNameA")
	setFileShortNameW                             = kernel32.NewProc("SetFileShortNameW")
	setFileTime                                   = kernel32.NewProc("SetFileTime")
	setFileValidData                              = kernel32.NewProc("SetFileValidData")
	setFirmwareEnvironmentVariableA               = kernel32.NewProc("SetFirmwareEnvironmentVariableA")
	setFirmwareEnvironmentVariableW               = kernel32.NewProc("SetFirmwareEnvironmentVariableW")
	setHandleCount                                = kernel32.NewProc("SetHandleCount")
	setHandleInformation                          = kernel32.NewProc("SetHandleInformation")
	setInformationJobObject                       = kernel32.NewProc("SetInformationJobObject")
	setLastConsoleEventActive                     = kernel32.NewProc("SetLastConsoleEventActive")
	setLastError                                  = kernel32.NewProc("SetLastError")
	setLocalPrimaryComputerNameA                  = kernel32.NewProc("SetLocalPrimaryComputerNameA")
	setLocalPrimaryComputerNameW                  = kernel32.NewProc("SetLocalPrimaryComputerNameW")
	setLocalTime                                  = kernel32.NewProc("SetLocalTime")
	setLocaleInfoA                                = kernel32.NewProc("SetLocaleInfoA")
	setLocaleInfoW                                = kernel32.NewProc("SetLocaleInfoW")
	setMailslotInfo                               = kernel32.NewProc("SetMailslotInfo")
	setMessageWaitingIndicator                    = kernel32.NewProc("SetMessageWaitingIndicator")
	setNamedPipeAttribute                         = kernel32.NewProc("SetNamedPipeAttribute")
	setNamedPipeHandleState                       = kernel32.NewProc("SetNamedPipeHandleState")
	setPriorityClass                              = kernel32.NewProc("SetPriorityClass")
	setProcessAffinityMask                        = kernel32.NewProc("SetProcessAffinityMask")
	setProcessAffinityUpdateMode                  = kernel32.NewProc("SetProcessAffinityUpdateMode")
	setProcessDEPPolicy                           = kernel32.NewProc("SetProcessDEPPolicy")
	setProcessPreferredUILanguages                = kernel32.NewProc("SetProcessPreferredUILanguages")
	setProcessPriorityBoost                       = kernel32.NewProc("SetProcessPriorityBoost")
	setProcessShutdownParameters                  = kernel32.NewProc("SetProcessShutdownParameters")
	setProcessUserModeExceptionPolicy             = kernel32.NewProc("SetProcessUserModeExceptionPolicy")
	setProcessWorkingSetSize                      = kernel32.NewProc("SetProcessWorkingSetSize")
	setProcessWorkingSetSizeEx                    = kernel32.NewProc("SetProcessWorkingSetSizeEx")
	setSearchPathMode                             = kernel32.NewProc("SetSearchPathMode")
	setStdHandle                                  = kernel32.NewProc("SetStdHandle")
	setStdHandleEx                                = kernel32.NewProc("SetStdHandleEx")
	setSystemFileCacheSize                        = kernel32.NewProc("SetSystemFileCacheSize")
	setSystemPowerState                           = kernel32.NewProc("SetSystemPowerState")
	setSystemTime                                 = kernel32.NewProc("SetSystemTime")
	setSystemTimeAdjustment                       = kernel32.NewProc("SetSystemTimeAdjustment")
	setTapeParameters                             = kernel32.NewProc("SetTapeParameters")
	setTapePosition                               = kernel32.NewProc("SetTapePosition")
	setTermsrvAppInstallMode                      = kernel32.NewProc("SetTermsrvAppInstallMode")
	setThreadAffinityMask                         = kernel32.NewProc("SetThreadAffinityMask")
	setThreadContext                              = kernel32.NewProc("SetThreadContext")
	setThreadErrorMode                            = kernel32.NewProc("SetThreadErrorMode")
	setThreadExecutionState                       = kernel32.NewProc("SetThreadExecutionState")
	setThreadGroupAffinity                        = kernel32.NewProc("SetThreadGroupAffinity")
	setThreadIdealProcessor                       = kernel32.NewProc("SetThreadIdealProcessor")
	setThreadIdealProcessorEx                     = kernel32.NewProc("SetThreadIdealProcessorEx")
	setThreadLocale                               = kernel32.NewProc("SetThreadLocale")
	setThreadPreferredUILanguages                 = kernel32.NewProc("SetThreadPreferredUILanguages")
	setThreadPriority                             = kernel32.NewProc("SetThreadPriority")
	setThreadPriorityBoost                        = kernel32.NewProc("SetThreadPriorityBoost")
	setThreadStackGuarantee                       = kernel32.NewProc("SetThreadStackGuarantee")
	setThreadToken                                = kernel32.NewProc("SetThreadToken")
	setThreadUILanguage                           = kernel32.NewProc("SetThreadUILanguage")
	setThreadpoolStackInformation                 = kernel32.NewProc("SetThreadpoolStackInformation")
	setThreadpoolThreadMaximum                    = kernel32.NewProc("SetThreadpoolThreadMaximum")
	setThreadpoolThreadMinimum                    = kernel32.NewProc("SetThreadpoolThreadMinimum")
	setThreadpoolTimer                            = kernel32.NewProc("SetThreadpoolTimer")
	setThreadpoolWait                             = kernel32.NewProc("SetThreadpoolWait")
	setTimeZoneInformation                        = kernel32.NewProc("SetTimeZoneInformation")
	setTimerQueueTimer                            = kernel32.NewProc("SetTimerQueueTimer")
	setUmsThreadInformation                       = kernel32.NewProc("SetUmsThreadInformation")
	setUnhandledExceptionFilter                   = kernel32.NewProc("SetUnhandledExceptionFilter")
	setUserGeoID                                  = kernel32.NewProc("SetUserGeoID")
	setVDMCurrentDirectories                      = kernel32.NewProc("SetVDMCurrentDirectories")
	setVolumeLabelA                               = kernel32.NewProc("SetVolumeLabelA")
	setVolumeLabelW                               = kernel32.NewProc("SetVolumeLabelW")
	setVolumeMountPointA                          = kernel32.NewProc("SetVolumeMountPointA")
	setVolumeMountPointW                          = kernel32.NewProc("SetVolumeMountPointW")
	setWaitableTimer                              = kernel32.NewProc("SetWaitableTimer")
	setWaitableTimerEx                            = kernel32.NewProc("SetWaitableTimerEx")
	setXStateFeaturesMask                         = kernel32.NewProc("SetXStateFeaturesMask")
	setupComm                                     = kernel32.NewProc("SetupComm")
	showConsoleCursor                             = kernel32.NewProc("ShowConsoleCursor")
	signalObjectAndWait                           = kernel32.NewProc("SignalObjectAndWait")
	sizeofResource                                = kernel32.NewProc("SizeofResource")
	sleep                                         = kernel32.NewProc("Sleep")
	sleepConditionVariableCS                      = kernel32.NewProc("SleepConditionVariableCS")
	sleepConditionVariableSRW                     = kernel32.NewProc("SleepConditionVariableSRW")
	sleepEx                                       = kernel32.NewProc("SleepEx")
	sortCloseHandle                               = kernel32.NewProc("SortCloseHandle")
	sortGetHandle                                 = kernel32.NewProc("SortGetHandle")
	startThreadpoolIo                             = kernel32.NewProc("StartThreadpoolIo")
	submitThreadpoolWork                          = kernel32.NewProc("SubmitThreadpoolWork")
	suspendThread                                 = kernel32.NewProc("SuspendThread")
	switchToFiber                                 = kernel32.NewProc("SwitchToFiber")
	switchToThread                                = kernel32.NewProc("SwitchToThread")
	systemTimeToFileTime                          = kernel32.NewProc("SystemTimeToFileTime")
	systemTimeToTzSpecificLocalTime               = kernel32.NewProc("SystemTimeToTzSpecificLocalTime")
	terminateJobObject                            = kernel32.NewProc("TerminateJobObject")
	terminateProcess                              = kernel32.NewProc("TerminateProcess")
	terminateThread                               = kernel32.NewProc("TerminateThread")
	termsrvAppInstallMode                         = kernel32.NewProc("TermsrvAppInstallMode")
	thread32First                                 = kernel32.NewProc("Thread32First")
	thread32Next                                  = kernel32.NewProc("Thread32Next")
	tlsAlloc                                      = kernel32.NewProc("TlsAlloc")
	tlsFree                                       = kernel32.NewProc("TlsFree")
	tlsGetValue                                   = kernel32.NewProc("TlsGetValue")
	tlsSetValue                                   = kernel32.NewProc("TlsSetValue")
	toolhelp32ReadProcessMemory                   = kernel32.NewProc("Toolhelp32ReadProcessMemory")
	transactNamedPipe                             = kernel32.NewProc("TransactNamedPipe")
	transmitCommChar                              = kernel32.NewProc("TransmitCommChar")
	tryAcquireSRWLockExclusive                    = kernel32.NewProc("TryAcquireSRWLockExclusive")
	tryAcquireSRWLockShared                       = kernel32.NewProc("TryAcquireSRWLockShared")
	tryEnterCriticalSection                       = kernel32.NewProc("TryEnterCriticalSection")
	trySubmitThreadpoolCallback                   = kernel32.NewProc("TrySubmitThreadpoolCallback")
	tzSpecificLocalTimeToSystemTime               = kernel32.NewProc("TzSpecificLocalTimeToSystemTime")
	uTRegister                                    = kernel32.NewProc("UTRegister")
	uTUnRegister                                  = kernel32.NewProc("UTUnRegister")
	umsThreadYield                                = kernel32.NewProc("UmsThreadYield")
	unhandledExceptionFilter                      = kernel32.NewProc("UnhandledExceptionFilter")
	unlockFile                                    = kernel32.NewProc("UnlockFile")
	unlockFileEx                                  = kernel32.NewProc("UnlockFileEx")
	unmapViewOfFile                               = kernel32.NewProc("UnmapViewOfFile")
	unregisterApplicationRecoveryCallback         = kernel32.NewProc("UnregisterApplicationRecoveryCallback")
	unregisterApplicationRestart                  = kernel32.NewProc("UnregisterApplicationRestart")
	unregisterConsoleIME                          = kernel32.NewProc("UnregisterConsoleIME")
	unregisterWait                                = kernel32.NewProc("UnregisterWait")
	unregisterWaitEx                              = kernel32.NewProc("UnregisterWaitEx")
	updateCalendarDayOfWeek                       = kernel32.NewProc("UpdateCalendarDayOfWeek")
	updateProcThreadAttribute                     = kernel32.NewProc("UpdateProcThreadAttribute")
	updateResourceA                               = kernel32.NewProc("UpdateResourceA")
	updateResourceW                               = kernel32.NewProc("UpdateResourceW")
	vDMConsoleOperation                           = kernel32.NewProc("VDMConsoleOperation")
	vDMOperationStarted                           = kernel32.NewProc("VDMOperationStarted")
	verLanguageNameA                              = kernel32.NewProc("VerLanguageNameA")
	verLanguageNameW                              = kernel32.NewProc("VerLanguageNameW")
	verSetConditionMask                           = kernel32.NewProc("VerSetConditionMask")
	verifyConsoleIoHandle                         = kernel32.NewProc("VerifyConsoleIoHandle")
	verifyScripts                                 = kernel32.NewProc("VerifyScripts")
	verifyVersionInfoA                            = kernel32.NewProc("VerifyVersionInfoA")
	verifyVersionInfoW                            = kernel32.NewProc("VerifyVersionInfoW")
	virtualAlloc                                  = kernel32.NewProc("VirtualAlloc")
	virtualAllocEx                                = kernel32.NewProc("VirtualAllocEx")
	virtualAllocExNuma                            = kernel32.NewProc("VirtualAllocExNuma")
	virtualFree                                   = kernel32.NewProc("VirtualFree")
	virtualFreeEx                                 = kernel32.NewProc("VirtualFreeEx")
	virtualLock                                   = kernel32.NewProc("VirtualLock")
	virtualProtect                                = kernel32.NewProc("VirtualProtect")
	virtualProtectEx                              = kernel32.NewProc("VirtualProtectEx")
	virtualQuery                                  = kernel32.NewProc("VirtualQuery")
	virtualQueryEx                                = kernel32.NewProc("VirtualQueryEx")
	virtualUnlock                                 = kernel32.NewProc("VirtualUnlock")
	wTSGetActiveConsoleSessionId                  = kernel32.NewProc("WTSGetActiveConsoleSessionId")
	waitCommEvent                                 = kernel32.NewProc("WaitCommEvent")
	waitForDebugEvent                             = kernel32.NewProc("WaitForDebugEvent")
	waitForMultipleObjects                        = kernel32.NewProc("WaitForMultipleObjects")
	waitForMultipleObjectsEx                      = kernel32.NewProc("WaitForMultipleObjectsEx")
	waitForSingleObject                           = kernel32.NewProc("WaitForSingleObject")
	waitForSingleObjectEx                         = kernel32.NewProc("WaitForSingleObjectEx")
	waitForThreadpoolIoCallbacks                  = kernel32.NewProc("WaitForThreadpoolIoCallbacks")
	waitForThreadpoolTimerCallbacks               = kernel32.NewProc("WaitForThreadpoolTimerCallbacks")
	waitForThreadpoolWaitCallbacks                = kernel32.NewProc("WaitForThreadpoolWaitCallbacks")
	waitForThreadpoolWorkCallbacks                = kernel32.NewProc("WaitForThreadpoolWorkCallbacks")
	waitNamedPipeA                                = kernel32.NewProc("WaitNamedPipeA")
	waitNamedPipeW                                = kernel32.NewProc("WaitNamedPipeW")
	wakeAllConditionVariable                      = kernel32.NewProc("WakeAllConditionVariable")
	wakeConditionVariable                         = kernel32.NewProc("WakeConditionVariable")
	werGetFlags                                   = kernel32.NewProc("WerGetFlags")
	werRegisterFile                               = kernel32.NewProc("WerRegisterFile")
	werRegisterMemoryBlock                        = kernel32.NewProc("WerRegisterMemoryBlock")
	werRegisterRuntimeExceptionModule             = kernel32.NewProc("WerRegisterRuntimeExceptionModule")
	werSetFlags                                   = kernel32.NewProc("WerSetFlags")
	werUnregisterFile                             = kernel32.NewProc("WerUnregisterFile")
	werUnregisterMemoryBlock                      = kernel32.NewProc("WerUnregisterMemoryBlock")
	werUnregisterRuntimeExceptionModule           = kernel32.NewProc("WerUnregisterRuntimeExceptionModule")
	werpCleanupMessageMapping                     = kernel32.NewProc("WerpCleanupMessageMapping")
	werpInitiateRemoteRecovery                    = kernel32.NewProc("WerpInitiateRemoteRecovery")
	werpNotifyLoadStringResource                  = kernel32.NewProc("WerpNotifyLoadStringResource")
	werpNotifyLoadStringResourceEx                = kernel32.NewProc("WerpNotifyLoadStringResourceEx")
	werpNotifyUseStringResource                   = kernel32.NewProc("WerpNotifyUseStringResource")
	werpStringLookup                              = kernel32.NewProc("WerpStringLookup")
	wideCharToMultiByte                           = kernel32.NewProc("WideCharToMultiByte")
	winExec                                       = kernel32.NewProc("WinExec")
	wow64DisableWow64FsRedirection                = kernel32.NewProc("Wow64DisableWow64FsRedirection")
	wow64EnableWow64FsRedirection                 = kernel32.NewProc("Wow64EnableWow64FsRedirection")
	wow64GetThreadContext                         = kernel32.NewProc("Wow64GetThreadContext")
	wow64GetThreadSelectorEntry                   = kernel32.NewProc("Wow64GetThreadSelectorEntry")
	wow64RevertWow64FsRedirection                 = kernel32.NewProc("Wow64RevertWow64FsRedirection")
	wow64SetThreadContext                         = kernel32.NewProc("Wow64SetThreadContext")
	wow64SuspendThread                            = kernel32.NewProc("Wow64SuspendThread")
	writeConsoleA                                 = kernel32.NewProc("WriteConsoleA")
	writeConsoleInputA                            = kernel32.NewProc("WriteConsoleInputA")
	writeConsoleInputVDMA                         = kernel32.NewProc("WriteConsoleInputVDMA")
	writeConsoleInputVDMW                         = kernel32.NewProc("WriteConsoleInputVDMW")
	writeConsoleInputW                            = kernel32.NewProc("WriteConsoleInputW")
	writeConsoleOutputA                           = kernel32.NewProc("WriteConsoleOutputA")
	writeConsoleOutputAttribute                   = kernel32.NewProc("WriteConsoleOutputAttribute")
	writeConsoleOutputCharacterA                  = kernel32.NewProc("WriteConsoleOutputCharacterA")
	writeConsoleOutputCharacterW                  = kernel32.NewProc("WriteConsoleOutputCharacterW")
	writeConsoleOutputW                           = kernel32.NewProc("WriteConsoleOutputW")
	writeConsoleW                                 = kernel32.NewProc("WriteConsoleW")
	writeFile                                     = kernel32.NewProc("WriteFile")
	writeFileEx                                   = kernel32.NewProc("WriteFileEx")
	writeFileGather                               = kernel32.NewProc("WriteFileGather")
	writePrivateProfileSectionA                   = kernel32.NewProc("WritePrivateProfileSectionA")
	writePrivateProfileSectionW                   = kernel32.NewProc("WritePrivateProfileSectionW")
	writePrivateProfileStringA                    = kernel32.NewProc("WritePrivateProfileStringA")
	writePrivateProfileStringW                    = kernel32.NewProc("WritePrivateProfileStringW")
	writePrivateProfileStructA                    = kernel32.NewProc("WritePrivateProfileStructA")
	writePrivateProfileStructW                    = kernel32.NewProc("WritePrivateProfileStructW")
	writeProcessMemory                            = kernel32.NewProc("WriteProcessMemory")
	writeProfileSectionA                          = kernel32.NewProc("WriteProfileSectionA")
	writeProfileSectionW                          = kernel32.NewProc("WriteProfileSectionW")
	writeProfileStringA                           = kernel32.NewProc("WriteProfileStringA")
	writeProfileStringW                           = kernel32.NewProc("WriteProfileStringW")
	writeTapemark                                 = kernel32.NewProc("WriteTapemark")
	zombifyActCtx                                 = kernel32.NewProc("ZombifyActCtx")
)
