/*
Copyright 2019 The MayaData Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "openebs.io/metac/apis/metacontroller/v1alpha1"
)

// FakeCompositeControllers implements CompositeControllerInterface
type FakeCompositeControllers struct {
	Fake *FakeMetacontrollerV1alpha1
}

var compositecontrollersResource = schema.GroupVersionResource{Group: "metacontroller", Version: "v1alpha1", Resource: "compositecontrollers"}

var compositecontrollersKind = schema.GroupVersionKind{Group: "metacontroller", Version: "v1alpha1", Kind: "CompositeController"}

// Get takes name of the compositeController, and returns the corresponding compositeController object, and an error if there is any.
func (c *FakeCompositeControllers) Get(name string, options v1.GetOptions) (result *v1alpha1.CompositeController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(compositecontrollersResource, name), &v1alpha1.CompositeController{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CompositeController), err
}

// List takes label and field selectors, and returns the list of CompositeControllers that match those selectors.
func (c *FakeCompositeControllers) List(opts v1.ListOptions) (result *v1alpha1.CompositeControllerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(compositecontrollersResource, compositecontrollersKind, opts), &v1alpha1.CompositeControllerList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.CompositeControllerList{ListMeta: obj.(*v1alpha1.CompositeControllerList).ListMeta}
	for _, item := range obj.(*v1alpha1.CompositeControllerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested compositeControllers.
func (c *FakeCompositeControllers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(compositecontrollersResource, opts))
}

// Create takes the representation of a compositeController and creates it.  Returns the server's representation of the compositeController, and an error, if there is any.
func (c *FakeCompositeControllers) Create(compositeController *v1alpha1.CompositeController) (result *v1alpha1.CompositeController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(compositecontrollersResource, compositeController), &v1alpha1.CompositeController{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CompositeController), err
}

// Update takes the representation of a compositeController and updates it. Returns the server's representation of the compositeController, and an error, if there is any.
func (c *FakeCompositeControllers) Update(compositeController *v1alpha1.CompositeController) (result *v1alpha1.CompositeController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(compositecontrollersResource, compositeController), &v1alpha1.CompositeController{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CompositeController), err
}

// Delete takes name of the compositeController and deletes it. Returns an error if one occurs.
func (c *FakeCompositeControllers) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(compositecontrollersResource, name), &v1alpha1.CompositeController{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCompositeControllers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(compositecontrollersResource, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.CompositeControllerList{})
	return err
}

// Patch applies the patch and returns the patched compositeController.
func (c *FakeCompositeControllers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.CompositeController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(compositecontrollersResource, name, pt, data, subresources...), &v1alpha1.CompositeController{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.CompositeController), err
}
