/*
Copyright 2019 The MayaData Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "openebs.io/metac/apis/metacontroller/v1alpha1"
)

// FakeDecoratorControllers implements DecoratorControllerInterface
type FakeDecoratorControllers struct {
	Fake *FakeMetacontrollerV1alpha1
}

var decoratorcontrollersResource = schema.GroupVersionResource{Group: "metacontroller", Version: "v1alpha1", Resource: "decoratorcontrollers"}

var decoratorcontrollersKind = schema.GroupVersionKind{Group: "metacontroller", Version: "v1alpha1", Kind: "DecoratorController"}

// Get takes name of the decoratorController, and returns the corresponding decoratorController object, and an error if there is any.
func (c *FakeDecoratorControllers) Get(name string, options v1.GetOptions) (result *v1alpha1.DecoratorController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(decoratorcontrollersResource, name), &v1alpha1.DecoratorController{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DecoratorController), err
}

// List takes label and field selectors, and returns the list of DecoratorControllers that match those selectors.
func (c *FakeDecoratorControllers) List(opts v1.ListOptions) (result *v1alpha1.DecoratorControllerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(decoratorcontrollersResource, decoratorcontrollersKind, opts), &v1alpha1.DecoratorControllerList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.DecoratorControllerList{ListMeta: obj.(*v1alpha1.DecoratorControllerList).ListMeta}
	for _, item := range obj.(*v1alpha1.DecoratorControllerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested decoratorControllers.
func (c *FakeDecoratorControllers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(decoratorcontrollersResource, opts))
}

// Create takes the representation of a decoratorController and creates it.  Returns the server's representation of the decoratorController, and an error, if there is any.
func (c *FakeDecoratorControllers) Create(decoratorController *v1alpha1.DecoratorController) (result *v1alpha1.DecoratorController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(decoratorcontrollersResource, decoratorController), &v1alpha1.DecoratorController{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DecoratorController), err
}

// Update takes the representation of a decoratorController and updates it. Returns the server's representation of the decoratorController, and an error, if there is any.
func (c *FakeDecoratorControllers) Update(decoratorController *v1alpha1.DecoratorController) (result *v1alpha1.DecoratorController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(decoratorcontrollersResource, decoratorController), &v1alpha1.DecoratorController{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DecoratorController), err
}

// Delete takes name of the decoratorController and deletes it. Returns an error if one occurs.
func (c *FakeDecoratorControllers) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(decoratorcontrollersResource, name), &v1alpha1.DecoratorController{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDecoratorControllers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(decoratorcontrollersResource, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.DecoratorControllerList{})
	return err
}

// Patch applies the patch and returns the patched decoratorController.
func (c *FakeDecoratorControllers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.DecoratorController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(decoratorcontrollersResource, name, pt, data, subresources...), &v1alpha1.DecoratorController{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DecoratorController), err
}
