/*
Copyright 2019 The MayaData Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "openebs.io/metac/apis/metacontroller/v1alpha1"
)

// FakeGenericControllers implements GenericControllerInterface
type FakeGenericControllers struct {
	Fake *FakeMetacontrollerV1alpha1
	ns   string
}

var genericcontrollersResource = schema.GroupVersionResource{Group: "metacontroller", Version: "v1alpha1", Resource: "genericcontrollers"}

var genericcontrollersKind = schema.GroupVersionKind{Group: "metacontroller", Version: "v1alpha1", Kind: "GenericController"}

// Get takes name of the genericController, and returns the corresponding genericController object, and an error if there is any.
func (c *FakeGenericControllers) Get(name string, options v1.GetOptions) (result *v1alpha1.GenericController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(genericcontrollersResource, c.ns, name), &v1alpha1.GenericController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GenericController), err
}

// List takes label and field selectors, and returns the list of GenericControllers that match those selectors.
func (c *FakeGenericControllers) List(opts v1.ListOptions) (result *v1alpha1.GenericControllerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(genericcontrollersResource, genericcontrollersKind, c.ns, opts), &v1alpha1.GenericControllerList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.GenericControllerList{ListMeta: obj.(*v1alpha1.GenericControllerList).ListMeta}
	for _, item := range obj.(*v1alpha1.GenericControllerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested genericControllers.
func (c *FakeGenericControllers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(genericcontrollersResource, c.ns, opts))

}

// Create takes the representation of a genericController and creates it.  Returns the server's representation of the genericController, and an error, if there is any.
func (c *FakeGenericControllers) Create(genericController *v1alpha1.GenericController) (result *v1alpha1.GenericController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(genericcontrollersResource, c.ns, genericController), &v1alpha1.GenericController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GenericController), err
}

// Update takes the representation of a genericController and updates it. Returns the server's representation of the genericController, and an error, if there is any.
func (c *FakeGenericControllers) Update(genericController *v1alpha1.GenericController) (result *v1alpha1.GenericController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(genericcontrollersResource, c.ns, genericController), &v1alpha1.GenericController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GenericController), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeGenericControllers) UpdateStatus(genericController *v1alpha1.GenericController) (*v1alpha1.GenericController, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(genericcontrollersResource, "status", c.ns, genericController), &v1alpha1.GenericController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GenericController), err
}

// Delete takes name of the genericController and deletes it. Returns an error if one occurs.
func (c *FakeGenericControllers) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(genericcontrollersResource, c.ns, name), &v1alpha1.GenericController{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeGenericControllers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(genericcontrollersResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.GenericControllerList{})
	return err
}

// Patch applies the patch and returns the patched genericController.
func (c *FakeGenericControllers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.GenericController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(genericcontrollersResource, c.ns, name, pt, data, subresources...), &v1alpha1.GenericController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.GenericController), err
}
