/*
Copyright 2019 The MayaData Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "openebs.io/metac/apis/metacontroller/v1alpha1"
	scheme "openebs.io/metac/client/generated/clientset/versioned/scheme"
)

// GenericControllersGetter has a method to return a GenericControllerInterface.
// A group's client should implement this interface.
type GenericControllersGetter interface {
	GenericControllers(namespace string) GenericControllerInterface
}

// GenericControllerInterface has methods to work with GenericController resources.
type GenericControllerInterface interface {
	Create(*v1alpha1.GenericController) (*v1alpha1.GenericController, error)
	Update(*v1alpha1.GenericController) (*v1alpha1.GenericController, error)
	UpdateStatus(*v1alpha1.GenericController) (*v1alpha1.GenericController, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.GenericController, error)
	List(opts v1.ListOptions) (*v1alpha1.GenericControllerList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.GenericController, err error)
	GenericControllerExpansion
}

// genericControllers implements GenericControllerInterface
type genericControllers struct {
	client rest.Interface
	ns     string
}

// newGenericControllers returns a GenericControllers
func newGenericControllers(c *MetacontrollerV1alpha1Client, namespace string) *genericControllers {
	return &genericControllers{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the genericController, and returns the corresponding genericController object, and an error if there is any.
func (c *genericControllers) Get(name string, options v1.GetOptions) (result *v1alpha1.GenericController, err error) {
	result = &v1alpha1.GenericController{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("genericcontrollers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of GenericControllers that match those selectors.
func (c *genericControllers) List(opts v1.ListOptions) (result *v1alpha1.GenericControllerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.GenericControllerList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("genericcontrollers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested genericControllers.
func (c *genericControllers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("genericcontrollers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a genericController and creates it.  Returns the server's representation of the genericController, and an error, if there is any.
func (c *genericControllers) Create(genericController *v1alpha1.GenericController) (result *v1alpha1.GenericController, err error) {
	result = &v1alpha1.GenericController{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("genericcontrollers").
		Body(genericController).
		Do().
		Into(result)
	return
}

// Update takes the representation of a genericController and updates it. Returns the server's representation of the genericController, and an error, if there is any.
func (c *genericControllers) Update(genericController *v1alpha1.GenericController) (result *v1alpha1.GenericController, err error) {
	result = &v1alpha1.GenericController{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("genericcontrollers").
		Name(genericController.Name).
		Body(genericController).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *genericControllers) UpdateStatus(genericController *v1alpha1.GenericController) (result *v1alpha1.GenericController, err error) {
	result = &v1alpha1.GenericController{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("genericcontrollers").
		Name(genericController.Name).
		SubResource("status").
		Body(genericController).
		Do().
		Into(result)
	return
}

// Delete takes name of the genericController and deletes it. Returns an error if one occurs.
func (c *genericControllers) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("genericcontrollers").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *genericControllers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("genericcontrollers").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched genericController.
func (c *genericControllers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.GenericController, err error) {
	result = &v1alpha1.GenericController{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("genericcontrollers").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
