/*
Copyright 2019 The MayaData Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	metacontrollerv1alpha1 "openebs.io/metac/apis/metacontroller/v1alpha1"
	versioned "openebs.io/metac/client/generated/clientset/versioned"
	internalinterfaces "openebs.io/metac/client/generated/informers/externalversions/internalinterfaces"
	v1alpha1 "openebs.io/metac/client/generated/listers/metacontroller/v1alpha1"
)

// DecoratorControllerInformer provides access to a shared informer and lister for
// DecoratorControllers.
type DecoratorControllerInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.DecoratorControllerLister
}

type decoratorControllerInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewDecoratorControllerInformer constructs a new informer for DecoratorController type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewDecoratorControllerInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredDecoratorControllerInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredDecoratorControllerInformer constructs a new informer for DecoratorController type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredDecoratorControllerInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.MetacontrollerV1alpha1().DecoratorControllers().List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.MetacontrollerV1alpha1().DecoratorControllers().Watch(options)
			},
		},
		&metacontrollerv1alpha1.DecoratorController{},
		resyncPeriod,
		indexers,
	)
}

func (f *decoratorControllerInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredDecoratorControllerInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *decoratorControllerInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&metacontrollerv1alpha1.DecoratorController{}, f.defaultInformer)
}

func (f *decoratorControllerInformer) Lister() v1alpha1.DecoratorControllerLister {
	return v1alpha1.NewDecoratorControllerLister(f.Informer().GetIndexer())
}
