/*
Copyright 2019 The MayaData Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "openebs.io/metac/apis/metacontroller/v1alpha1"
)

// DecoratorControllerLister helps list DecoratorControllers.
type DecoratorControllerLister interface {
	// List lists all DecoratorControllers in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.DecoratorController, err error)
	// Get retrieves the DecoratorController from the index for a given name.
	Get(name string) (*v1alpha1.DecoratorController, error)
	DecoratorControllerListerExpansion
}

// decoratorControllerLister implements the DecoratorControllerLister interface.
type decoratorControllerLister struct {
	indexer cache.Indexer
}

// NewDecoratorControllerLister returns a new DecoratorControllerLister.
func NewDecoratorControllerLister(indexer cache.Indexer) DecoratorControllerLister {
	return &decoratorControllerLister{indexer: indexer}
}

// List lists all DecoratorControllers in the indexer.
func (s *decoratorControllerLister) List(selector labels.Selector) (ret []*v1alpha1.DecoratorController, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.DecoratorController))
	})
	return ret, err
}

// Get retrieves the DecoratorController from the index for a given name.
func (s *decoratorControllerLister) Get(name string) (*v1alpha1.DecoratorController, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("decoratorcontroller"), name)
	}
	return obj.(*v1alpha1.DecoratorController), nil
}
