/*
Copyright 2019 The MayaData Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "openebs.io/metac/apis/metacontroller/v1alpha1"
)

// GenericControllerLister helps list GenericControllers.
type GenericControllerLister interface {
	// List lists all GenericControllers in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.GenericController, err error)
	// GenericControllers returns an object that can list and get GenericControllers.
	GenericControllers(namespace string) GenericControllerNamespaceLister
	GenericControllerListerExpansion
}

// genericControllerLister implements the GenericControllerLister interface.
type genericControllerLister struct {
	indexer cache.Indexer
}

// NewGenericControllerLister returns a new GenericControllerLister.
func NewGenericControllerLister(indexer cache.Indexer) GenericControllerLister {
	return &genericControllerLister{indexer: indexer}
}

// List lists all GenericControllers in the indexer.
func (s *genericControllerLister) List(selector labels.Selector) (ret []*v1alpha1.GenericController, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GenericController))
	})
	return ret, err
}

// GenericControllers returns an object that can list and get GenericControllers.
func (s *genericControllerLister) GenericControllers(namespace string) GenericControllerNamespaceLister {
	return genericControllerNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// GenericControllerNamespaceLister helps list and get GenericControllers.
type GenericControllerNamespaceLister interface {
	// List lists all GenericControllers in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.GenericController, err error)
	// Get retrieves the GenericController from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.GenericController, error)
	GenericControllerNamespaceListerExpansion
}

// genericControllerNamespaceLister implements the GenericControllerNamespaceLister
// interface.
type genericControllerNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all GenericControllers in the indexer for a given namespace.
func (s genericControllerNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.GenericController, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.GenericController))
	})
	return ret, err
}

// Get retrieves the GenericController from the indexer for a given namespace and name.
func (s genericControllerNamespaceLister) Get(name string) (*v1alpha1.GenericController, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("genericcontroller"), name)
	}
	return obj.(*v1alpha1.GenericController), nil
}
