## DaemonJob

This is an example CompositeController that's similar to Job,
except that a pod will be scheduled to each node, similar to DaemonSet.

The implementation was inspired by this [blog post](http://blog.itaysk.com/2017/12/26/the-single-use-daemonset-pattern-and-prepulling-images-in-kubernetes).
This particular pattern has some caveats, like how multiple containers run in
series instead of concurrently, but it suffices as an example of using
CompositeController to wrap up any such pattern you could think of.

### Prerequisites

* Install [Metacontroller](https://github.com/GoogleCloudPlatform/metacontroller)

### Deploy the controller

```sh
kubectl create configmap daemonjob-controller -n metacontroller --from-file=sync.py
kubectl apply -f daemonjob-controller.yaml
```

### Create a DaemonJob

In a separate terminal watch for DaemonJobs, DaemonSets and Pods

```sh
watch -n1 kubectl get ds,dj,po
```

Create the DaemonJob

```sh
kubectl apply -f my-daemonjob.yaml
```

In the terminal where you have the `watch` command running you will see a
DaemonSet being created as soon as the DaemonJob is deployed and then a pod will
start on each node of your cluster.
These pods will stay in the init stage for about 30s (sleep command in the
container) and will be terminated as soon as all of them have reached the
`Running` state.
The DeamonSet generated by the DaemonJob will also be cleaned up after all the
Pods are done.

### Clean up

```sh
kubectl delete -f daemonjob-controller.yaml
kubectl delete configmap -n metacontroller daemonjob-controller
```
