## Service-Per-Pod Decorator

This is an example of DecoratorController that adds a Service for each Pod in a
StatefulSet, for any StatefulSet that requests this by adding an annotation
that specifies the name of the label containing the Pod name.

In Kubernetes 1.9+, StatefulSet automatically adds the Pod name as a label on
each of its Pods, so you can enable Service-Per-Pod like this:

```yaml
apiVersion: apps/v1beta2
kind: StatefulSet
metadata:
  annotations:
    service-per-pod-label: "statefulset.kubernetes.io/pod-name"
    service-per-pod-ports: "80:8080"
...
```

For earlier versions, this example also contains a second DecoratorController
that adds the Pod name label since StatefulSet previously didn't do it.

The Pod name label is only added to Pods that request it with an annotation,
which you can add in the StatefulSet's Pod template:

```yaml
apiVersion: apps/v1beta2
kind: StatefulSet
metadata:
  annotations:
    service-per-pod-label: "pod-name"
    service-per-pod-ports: "80:8080"
...
spec:
  template:
    metadata:
      annotations:
        pod-name-label: "pod-name"
...
```

If the StatefulSet is then deleted, or if the `service-per-pod-label` annotation
is removed to opt out of the decorator, any Services created will be cleaned up.

### Prerequisites

* Kubernetes 1.8+ is recommended for its improved CRD support, especially garbage collection.
* Install Metac using yamls from manifests folder

```sh
# cd to metac's root folder

kubectl apply -f ./manifests/metacontroller-namespace.yaml
kubectl apply -f ./manifests/metacontroller-rbac.yaml
kubectl apply -f ./manifests/metacontroller.yaml

kubectl get crd
```

### Deploy the DecoratorControllers

```sh
# cd to examples/service-per-pod/

# any change in any of the hooks should be accompanied
# by deleting configmap & operator & re-applying the same
kubectl create configmap service-per-pod-hooks -n metac --from-file=hooks
kubectl apply -f operator.yaml

# verify
kubectl get dctl
kubectl get cm -n metac
kubectl get deploy -n metac
kubectl get svc -n metac
```

### Create an Example StatefulSet

```sh
kubectl apply -f my-statefulset.yaml
```

Watch for the Services to get created:

```sh
kubectl get services --watch
```

Check that the StatefulSet's Pods can be selected by `pod-name` label:

```sh
kubectl get pod -l pod-name=nginx-0
kubectl get pod -l pod-name=nginx-1
kubectl get pod -l pod-name=nginx-2
```

Check that the per-Pod Services get cleaned up when the StatefulSet is deleted:

```sh
kubectl delete -f my-statefulset.yaml
kubectl get services
```
