<!-- Links in /docs/documentation should NOT have `.md` at the end, because they end up in our wiki at release. -->

# ng new

## Overview
`ng new [name]` creates a new angular application.

Default applications are created in a directory of the same name, with an initialized Angular application.

## Options
<details>
  <summary>directory</summary>
  <p>
    `--directory` (alias: `-dir`) _default value: dir_
  </p>
  <p>
    The directory name to create the app in.
  </p>
</details>

<details>
  <summary>dry-run</summary>
  <p>
    `--dry-run` (alias: `-d`) _default value: false_
  </p>
  <p>
    Run through without making any changes.
  </p>
</details>

<details>
  <summary>inline-style</summary>
  <p>
    `--inline-style` (alias: `-is`) _default value: false_
  </p>
  <p>
    Should have an inline style.
  </p>
</details>

<details>
  <summary>inline-template</summary>
  <p>
    `--inline-template` (alias: `-it`) _default value: false_
  </p>
  <p>
    Should have an inline template.
  </p>
</details>

<details>
  <summary>prefix</summary>
  <p>
    `--prefix` (alias: `-p`) _default value: app_
  </p>
  <p>
    The prefix to use for all component selectors.
  </p>
</details>

<details>
  <summary>routing</summary>
  <p>
    `--routing` _default value: false_
  </p>
  <p>
    Generate a routing module.
  </p>
</details>

<details>
  <summary>skip-commit</summary>
  <p>
    `--skip-commit` (alias: `-sc`) _default value: false_
  </p>
  <p>
    Skip committing the first commit to git.
  </p>
</details>

<details>
  <summary>skip-git</summary>
  <p>
    `--skip-git` (alias: `-sg`) _default value: false_
  </p>
  <p>
    Skip initializing a git repository.
  </p>
</details>

<details>
  <summary>skip-install</summary>
  <p>
    `--skip-install` (alias: `-si`) _default value: false_
  </p>
  <p>
    Skip installing packages.
  </p>
</details>

<details>
  <summary>skip-tests</summary>
  <p>
    <code>--skip-tests</code> (aliases: <code>-st</code>) <em>default value: false</em>
  </p>
  <p>
    Skip creating spec files.
  </p>
  <p>
    Skip including e2e functionality.
  </p>
</details>

<details>
  <summary>source-dir</summary>
  <p>
    `--source-dir` (alias: `-sd`) _default value: src_
  </p>
  <p>
    The name of the source directory.
  </p>
</details>

<details>
  <summary>style</summary>
  <p>
    `--style` _default value: css_
  </p>
  <p>
    The style file default extension.
  </p>
</details>

<details>
  <summary>verbose</summary>
  <p>
    `--verbose` (alias: `-v`) _default value: false_
  </p>
  <p>
    Adds more details to output logging.
  </p>
</details>
