import {ng} from '../../../utils/process';
import {appendToFile, expectFileToMatch, prependToFile, replaceInFile} from '../../../utils/fs';
import {expectToFail} from '../../../utils/utils';
import {ngVersionMatches} from '../../../utils/version';

export default function() {
  // TODO(architect): This behaviour seems to have changed in devkit/build-webpack. Figure out why.
  return;

  return ng('generate', 'component', 'test-component', '--module', 'app.module.ts')
    .then(() => prependToFile('projects/test-project/src/app/test-component/test-component.component.ts', `
      import { Optional, SkipSelf } from '@angular/core';
    `))
    .then(() => replaceInFile('projects/test-project/src/app/test-component/test-component.component.ts',
      /constructor.*/, `
        constructor(@Optional() @SkipSelf() public test: TestComponentComponent) {
          console.log(test);
        }
      `))
    .then(() => appendToFile('projects/test-project/src/app/app.component.html', `
      <app-test-component></app-test-component>
    `))
    .then(() => ng('build', '--aot'))
    .then(() => expectToFail(() => expectFileToMatch('dist/test-project/main.js', /\bComponent\b/)))
    // Check that the decorators are still kept.
    .then(() => expectFileToMatch('dist/test-project/main.js', /ctorParameters.*Optional.*SkipSelf/))
    .then(() => expectToFail(() => expectFileToMatch('dist/test-project/main.js', /\bNgModule\b/)));
}
