/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetPreProcessor;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetProvider
implements Provider<Set<FileInfo>> {
    private final Set<FileSetPreProcessor> preProcessors;
    private final Set<FileInfo> fileSet;

    @Inject
    public FileSetProvider(Set<FileSetPreProcessor> preProcessors, @Named(value="originalFileSet") Set<FileInfo> fileSet) {
        this.preProcessors = preProcessors;
        this.fileSet = fileSet;
    }

    @Override
    public Set<FileInfo> get() {
        Set<FileInfo> currentFileSet = this.fileSet;
        for (FileSetPreProcessor preProcessor : this.preProcessors) {
            currentFileSet = preProcessor.process(currentFileSet);
        }
        return currentFileSet;
    }
}

