/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.servlet.RequestScoped;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.ForwardingServlet;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.StandaloneRunnerFilesFilter;
import com.google.jstestdriver.StandaloneRunnerFilesFilterImpl;
import com.google.jstestdriver.Time;
import com.google.jstestdriver.TimeImpl;
import com.google.jstestdriver.annotations.BaseResourceLocation;
import com.google.jstestdriver.annotations.BrowserTimeout;
import com.google.jstestdriver.annotations.Port;
import com.google.jstestdriver.config.ExecutionType;
import com.google.jstestdriver.hooks.FileInfoScheme;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.RequestHandlersModule;
import com.google.jstestdriver.server.JstdTestCaseStore;
import com.google.jstestdriver.server.gateway.SimpleServletConfig;
import com.google.jstestdriver.server.handlers.BrowserControlledRunnerHandler;
import com.google.jstestdriver.server.handlers.BrowserLoggingHandler;
import com.google.jstestdriver.server.handlers.BrowserQueryResponseHandler;
import com.google.jstestdriver.server.handlers.CachingTestResourceHandler;
import com.google.jstestdriver.server.handlers.CaptureHandler;
import com.google.jstestdriver.server.handlers.CommandGetHandler;
import com.google.jstestdriver.server.handlers.CommandPostHandler;
import com.google.jstestdriver.server.handlers.FaviconHandler;
import com.google.jstestdriver.server.handlers.FileCacheHandler;
import com.google.jstestdriver.server.handlers.FileSetGetHandler;
import com.google.jstestdriver.server.handlers.FileSetPostHandler;
import com.google.jstestdriver.server.handlers.ForwardingHandler;
import com.google.jstestdriver.server.handlers.GatewayConfigurationHandler;
import com.google.jstestdriver.server.handlers.HeartbeatGetHandler;
import com.google.jstestdriver.server.handlers.HeartbeatPostHandler;
import com.google.jstestdriver.server.handlers.HelloHandler;
import com.google.jstestdriver.server.handlers.HomeHandler;
import com.google.jstestdriver.server.handlers.NonCachingTestResourceHandler;
import com.google.jstestdriver.server.handlers.QuitHandler;
import com.google.jstestdriver.server.handlers.SlaveResourceHandler;
import com.google.jstestdriver.server.handlers.StandaloneRunnerHandler;
import com.google.jstestdriver.server.handlers.StaticResourceHandler;
import com.google.jstestdriver.server.handlers.pages.BrowserControlledRunnerPage;
import com.google.jstestdriver.server.handlers.pages.ConsolePage;
import com.google.jstestdriver.server.handlers.pages.HeartbeatPage;
import com.google.jstestdriver.server.handlers.pages.Page;
import com.google.jstestdriver.server.handlers.pages.PageType;
import com.google.jstestdriver.server.handlers.pages.RunnerPage;
import com.google.jstestdriver.server.handlers.pages.SlavePageRequest;
import com.google.jstestdriver.server.handlers.pages.StandaloneRunnerPage;
import com.google.jstestdriver.servlet.fileset.BrowserFileCheck;
import com.google.jstestdriver.servlet.fileset.DeltaUpload;
import com.google.jstestdriver.servlet.fileset.FileSetRequestHandler;
import com.google.jstestdriver.servlet.fileset.TestCaseUpload;
import com.google.jstestdriver.util.ParameterParser;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JstdHandlersModule
extends RequestHandlersModule {
    private static final String PAGE = "page";
    private static final String MODE = "mode";
    private static final String ID = "id";
    private static final String TIMEOUT = "timeout";
    private static final String JSTD = "jstd";
    private final CapturedBrowsers capturedBrowsers;
    private final JstdTestCaseStore testCaseStore;
    private final long browserTimeout;
    private final HandlerPathPrefix handlerPrefix;
    private final Set<FileInfoScheme> schemes;
    private final ExecutionType executionType;
    private static final Map<String, Integer> PARAMETERS = ImmutableMap.builder().put("jstd", 0).put("rt", 1).put("timeout", 1).put("id", 1).put("mode", 1).put("page", 1).put("upload_size", 1).put("load_type", 1).put("refresh", 1).put("testcase_id", 1).build();
    private static final Set<String> BLACKLIST = ImmutableSet.builder().build();

    public JstdHandlersModule(CapturedBrowsers capturedBrowsers, JstdTestCaseStore testCaseStore, long browserTimeout, HandlerPathPrefix handlerPrefix, Set<FileInfoScheme> schemes, ExecutionType executionType) {
        this.capturedBrowsers = capturedBrowsers;
        this.testCaseStore = testCaseStore;
        this.browserTimeout = browserTimeout;
        this.handlerPrefix = handlerPrefix;
        this.schemes = schemes;
        this.executionType = executionType;
    }

    @Override
    protected void configureHandlers() {
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/"), HomeHandler.class);
        this.serve(HttpMethod.POST, this.handlerPrefix.prefixPath("/cache"), FileCacheHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/capture"), CaptureHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/capture/*"), CaptureHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/cmd"), CommandGetHandler.class);
        this.serve(HttpMethod.POST, this.handlerPrefix.prefixPath("/cmd"), CommandPostHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/favicon.ico"), FaviconHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/fileSet"), FileSetGetHandler.class);
        this.serve(HttpMethod.POST, this.handlerPrefix.prefixPath("/fileSet"), FileSetPostHandler.class);
        for (HttpMethod method : HttpMethod.values()) {
            this.serve(method, this.handlerPrefix.prefixPath("/forward/*"), ForwardingHandler.class);
        }
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/heartbeat"), HeartbeatGetHandler.class);
        this.serve(HttpMethod.POST, this.handlerPrefix.prefixPath("/heartbeat"), HeartbeatPostHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/proxy", JSTD), GatewayConfigurationHandler.class);
        this.serve(HttpMethod.POST, this.handlerPrefix.prefixPath("/proxy", JSTD), GatewayConfigurationHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/gateway", JSTD), GatewayConfigurationHandler.class);
        this.serve(HttpMethod.POST, this.handlerPrefix.prefixPath("/gateway", JSTD), GatewayConfigurationHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/hello"), HelloHandler.class);
        this.serve(HttpMethod.POST, this.handlerPrefix.prefixPath("/log"), BrowserLoggingHandler.class);
        this.serve(HttpMethod.POST, this.handlerPrefix.prefixPath("/query/*"), BrowserQueryResponseHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/runner/*"), StandaloneRunnerHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/slave/*"), SlaveResourceHandler.class);
        if (this.executionType == ExecutionType.STANDALONE) {
            this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/test/*"), CachingTestResourceHandler.class);
        } else {
            this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/test/*"), NonCachingTestResourceHandler.class);
        }
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/quit"), QuitHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/quit/*"), QuitHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/static/*"), StaticResourceHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/bcr"), BrowserControlledRunnerHandler.class);
        this.serve(HttpMethod.GET, this.handlerPrefix.prefixPath("/bcr/*"), BrowserControlledRunnerHandler.class);
        this.bindConstant().annotatedWith(BaseResourceLocation.class).to("/com/google/jstestdriver/javascript");
        this.bindConstant().annotatedWith(BrowserTimeout.class).to(this.browserTimeout);
        this.bind(CapturedBrowsers.class).toInstance(this.capturedBrowsers);
        this.bind(JstdTestCaseStore.class).toInstance(this.testCaseStore);
        this.bind(new Key<ConcurrentMap<SlaveBrowser, List<String>>>(){}).toInstance(new ConcurrentHashMap());
        this.bind(new Key<ConcurrentMap<SlaveBrowser, Thread>>(){}).toInstance(new ConcurrentHashMap());
        this.bind(new Key<Set<FileInfo>>(){}).toInstance(new HashSet());
        this.bind(StandaloneRunnerFilesFilter.class).to(StandaloneRunnerFilesFilterImpl.class);
        this.bind(HandlerPathPrefix.class).toInstance(this.handlerPrefix);
        this.bind(Time.class).to(TimeImpl.class);
        this.bind(new TypeLiteral<Set<FileInfoScheme>>(){}).toInstance(this.schemes);
        this.bind(ExecutionType.class).toInstance(this.executionType);
        MapBinder<PageType, Page> pageBinder = MapBinder.newMapBinder(this.binder(), PageType.class, Page.class);
        pageBinder.addBinding(PageType.CONSOLE).to(ConsolePage.class).in(RequestScoped.class);
        pageBinder.addBinding(PageType.HEARTBEAT).to(HeartbeatPage.class).in(RequestScoped.class);
        pageBinder.addBinding(PageType.RUNNER).to(RunnerPage.class).in(RequestScoped.class);
        pageBinder.addBinding(PageType.STANDALONE_RUNNER).to(StandaloneRunnerPage.class).in(RequestScoped.class);
        pageBinder.addBinding(PageType.VISUAL_STANDALONE_RUNNER).to(BrowserControlledRunnerPage.class).in(RequestScoped.class);
    }

    @Provides
    SlavePageRequest providePageRequest(ParameterParser parser, HttpServletRequest request, HandlerPathPrefix prefix, CapturedBrowsers browsers) {
        return new SlavePageRequest(parser.getParameterMap(PARAMETERS, BLACKLIST), request, prefix, browsers);
    }

    @Provides
    @Singleton
    List<FileSetRequestHandler<?>> provideFileSetRequestHandlers(BrowserFileCheck browserFileCheck, TestCaseUpload serverFileUpload, DeltaUpload deltaUpload) {
        return ImmutableList.of(browserFileCheck, serverFileUpload, deltaUpload);
    }

    @Provides
    @Singleton
    ForwardingServlet provideForwardingServlet(@Port Integer port, ServletContext context) throws ServletException {
        ForwardingServlet servlet = new ForwardingServlet("localhost", port);
        servlet.init(new SimpleServletConfig("forward", context, ImmutableMap.<String, String>of()));
        return servlet;
    }
}

