# Collection of git hooks for Terraform to be used with [pre-commit framework](http://pre-commit.com/)

[![Github tag](https://img.shields.io/github/tag/antonbabenko/pre-commit-terraform.svg)](https://github.com/antonbabenko/pre-commit-terraform/releases) ![](https://img.shields.io/maintenance/yes/2018.svg) [![Help Contribute to Open Source](https://www.codetriage.com/antonbabenko/pre-commit-terraform/badges/users.svg)](https://www.codetriage.com/antonbabenko/pre-commit-terraform)

## How to install

### Step 1

On MacOSX install the pre-commit package

```bash
brew install pre-commit
```

For other operating systems check the [official documentation](http://pre-commit.com/#install)

### Step 2

Step into the repository you want to have the pre-commit hooks installed and run:

```bash
cat <<EOF > .pre-commit-config.yaml
- repo: git://github.com/antonbabenko/pre-commit-terraform
  rev: v1.7.4
  hooks:
    - id: terraform_fmt
    - id: terraform_docs
EOF
```

### Step 3

Install the pre-commit hook

```bash
pre-commit install
```

### Step 4

After pre-commit hook has been installed you can run it manually on all files in the repository

```bash
pre-commit run -a
```

## Available Hooks

There are several [pre-commit](http://pre-commit.com/) hooks to keep Terraform configurations (both `*.tf` and `*.tfvars`) in a good shape:
* `terraform_fmt` - Rewrites all Terraform configuration files to a canonical format.
* `terraform_validate_no_variables` - Validates all Terraform configuration files without checking whether all required variables were set.
* `terraform_validate_with_variables` - Validates all Terraform configuration files and checks whether all required variables were specified.
* `terraform_docs` - Inserts input and output documentation into `README.md`. Recommended.
* `terraform_docs_without_aggregate_type_defaults` - Inserts input and output documentation into `README.md` without aggregate type defaults.
* `terraform_docs_replace` - Runs `terraform-docs` and pipes the output directly to README.md

Check the [source file](https://github.com/antonbabenko/pre-commit-terraform/blob/master/.pre-commit-hooks.yaml) to know arguments used for each hook.

## Notes about hooks

1. `terraform_validate_no_variables` and `terraform_validate_with_variables` will not work if variables are being set dynamically (eg, when using [Terragrunt](https://github.com/gruntwork-io/terragrunt)). Use `terragrunt validate` command instead.

1. `terraform_docs` and `terraform_docs_without_aggregate_type_defaults` will insert/update documentation generated by [terraform-docs](https://github.com/segmentio/terraform-docs) between markers - `<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->` and `<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->` if they are present in `README.md`. Make sure that `terraform-docs` is installed.

1. `terraform_docs_replace` replaces the entire README.md rather than doing string replacement between markers. Put your additional documentation at the top of your `main.tf` for it to be pulled in. The optional `--dest` argument lets you change the name of the file that gets created/modified.

    1. Example:
    ```yaml
    hooks:
      - id: terraform_docs_replace
        args: ['--with-aggregate-type-defaults', '--sort-inputs-by-required', '--dest=TEST.md']
    ```

1. It is possible to pass additional arguments to shell scripts when using `terraform_docs` and `terraform_docs_without_aggregate_type_defaults`. Send pull-request with the new hook if there is something missing.

## Notes for developers

1. Python hooks are supported now too. All you have to do is:
    1. add a line to the `console_sripts` array in `entry_points` in `setup.py`
    1. Put your python script in the `pre_commit_hooks` folder

Enjoy the clean and documented code!

## Authors

This repository is managed by [Anton Babenko](https://github.com/antonbabenko) with help from [these awesome contributors](https://github.com/antonbabenko/pre-commit-terraform/graphs/contributors).

## License

MIT licensed. See LICENSE for full details.
