package main

import (
	"net/http"

	"github.com/TykTechnologies/tyk/config"
)

// CertificateCheckMW is used if domain was not detected or multiple APIs bind on the same domain. In this case authentification check happens not on TLS side but on HTTP level using this middleware
type CertificateCheckMW struct {
	BaseMiddleware
}

func (m *CertificateCheckMW) Name() string {
	return "CertificateCheckMW"
}

func (m *CertificateCheckMW) EnabledForSpec() bool {
	return m.Spec.UseMutualTLSAuth
}

func (m *CertificateCheckMW) ProcessRequest(w http.ResponseWriter, r *http.Request, _ interface{}) (error, int) {
	if m.Spec.UseMutualTLSAuth {
		certIDs := append(m.Spec.ClientCertificates, config.Global.Security.Certificates.API...)

		if err := CertificateManager.ValidateRequestCertificate(certIDs, r); err != nil {
			return err, 403
		}
	}
	return nil, 200
}
