
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.axis2.jaxws.proxy.gorilla_dlw.sei;

import org.apache.axis2.jaxws.proxy.gorilla_dlw.data.Fruit;

import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebParam.Mode;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import java.util.List;

/**
 * This class was generated by the JAXWS SI.
 * JAX-WS RI 2.0_01-b15-fcs
 * Generated source version: 2.0
 * 
 */
@WebService(name = "GorillaInterface", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw")
@XmlSeeAlso(org.test.stock2.GetPrice.class)  // Test see also processing
public interface GorillaInterface {


    /**
     * 
     * @param data
     * @return
     *     returns java.lang.String
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoString", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoString")
    @ResponseWrapper(localName = "echoStringResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringResponse")
    public String echoString(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        String data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @param inout
     * @throws AssertFault
     */
    @WebMethod
    @RequestWrapper(localName = "echoString2", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoString2")
    @ResponseWrapper(localName = "echoString2Response", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoString2Response")
    public void echoString2(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        String data,
        @WebParam(name = "inout", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", mode = Mode.INOUT)
        Holder<String> inout)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.lang.Integer
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoInt", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoInt")
    @ResponseWrapper(localName = "echoIntResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoIntResponse")
    public Integer echoInt(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        Integer data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns org.apache.axis2.jaxws.proxy.gorilla_dlw.data.Fruit
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoEnum", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoEnum")
    @ResponseWrapper(localName = "echoEnumResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoEnumResponse")
    public Fruit echoEnum(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        Fruit data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.lang.Object
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoAnyType", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoAnyType")
    @ResponseWrapper(localName = "echoAnyTypeResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoAnyTypeResponse")
    public Object echoAnyType(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        Object data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.util.List<java.util.List<java.lang.String>>
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoStringList", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringList")
    @ResponseWrapper(localName = "echoStringListResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringListResponse")
    public List<String> echoStringList(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        List<String> data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns String[]
     * @throws AssertFault
     */
    // NOTE: The return and param are manually changed from List<String> to String[]
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoStringListAlt", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringListAlt")
    @ResponseWrapper(localName = "echoStringListAltResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringListAltResponse")
    public String[] echoStringListAlt(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        String[] data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.util.List<java.util.List<java.lang.String>>
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoStringListArray", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringListArray")
    @ResponseWrapper(localName = "echoStringListArrayResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringListArrayResponse")
    public List<List<String>> echoStringListArray(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        List<List<String>> data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoStringArray", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringArray")
    @ResponseWrapper(localName = "echoStringArrayResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringArrayResponse")
    public List<String> echoStringArray(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        List<String> data)
        throws AssertFault
    ;
    
    /**
     * 
     * @param data
     * @return
     *     returns String[]
     * @throws AssertFault
     */
    //  NOTE: The return and param are manually changed from List<String> to String[]
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoStringArrayAlt", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringArrayAlt")
    @ResponseWrapper(localName = "echoStringArrayAltResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoStringArrayAltResponse")
    public String[] echoStringArrayAlt(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        String[] data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoIndexedStringArray", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoIndexedStringArray")
    @ResponseWrapper(localName = "echoIndexedStringArrayResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoIndexedStringArrayResponse")
    public List<String> echoIndexedStringArray(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        List<String> data)
        throws AssertFault
    ;
    

    /**
     * 
     * @param data
     * @param inout
     * @throws AssertFault
     */
    @WebMethod
    @RequestWrapper(localName = "echoString2Array", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoString2Array")
    @ResponseWrapper(localName = "echoString2ArrayResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoString2ArrayResponse")
    public void echoString2Array(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        List<String> data,
        @WebParam(name = "inout", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", mode = Mode.INOUT)
        Holder<List<String>> inout)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.util.List<java.lang.Integer>
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoIntArray", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoIntArray")
    @ResponseWrapper(localName = "echoIntArrayResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoIntArrayResponse")
    public List<Integer> echoIntArray(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        List<Integer> data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.util.List<org.apache.axis2.jaxws.proxy.gorilla_dlw.data.Fruit>
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoEnumArray", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoEnumArray")
    @ResponseWrapper(localName = "echoEnumArrayResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoEnumArrayResponse")
    public List<Fruit> echoEnumArray(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        List<Fruit> data)
        throws AssertFault
    ;

    /**
     * 
     * @param data
     * @return
     *     returns java.util.List<java.lang.Object>
     * @throws AssertFault
     */
    @WebMethod
    @WebResult(name = "result", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoAnyTypeArray", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoAnyTypeArray")
    @ResponseWrapper(localName = "echoAnyTypeArrayResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoAnyTypeArrayResponse")
    public List<Object> echoAnyTypeArray(
        @WebParam(name = "data", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        List<Object> data)
        throws AssertFault
    ;
    /**
     * 
     * @param requestedTerminationTime
     * @param requestedLifetimeDuration
     * @return
     *     returns javax.xml.datatype.XMLGregorianCalendar
     */
    @WebMethod
    @WebResult(name = "response", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
    @RequestWrapper(localName = "echoDate", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoDate")
    @ResponseWrapper(localName = "echoDateResponse", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoDateResponse")
    public XMLGregorianCalendar echoDate(
        @WebParam(name = "RequestedTerminationTime", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        XMLGregorianCalendar requestedTerminationTime,
        @WebParam(name = "RequestedLifetimeDuration", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        Duration requestedLifetimeDuration);

    /**
     * 
     * @param request
     */
    @WebMethod
    @Oneway
    @RequestWrapper(localName = "echoPolymorphicDate", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data", className = "org.apache.axis2.jaxws.proxy.gorilla_dlw.data.EchoPolymorphicDate")
    public void echoPolymorphicDate(
        @WebParam(name = "request", targetNamespace = "http://org/apache/axis2/jaxws/proxy/gorilla_dlw/data")
        XMLGregorianCalendar request);
}
