Apache Axis2 1.7.0 Release Note
-------------------------------

Apache Axis2 1.7.0 is a major release that contains lots of bug fixes and
improvements, some of which introduce backward incompatible changes with respect
to Axis2 1.6.x (as described below). A complete list of JIRA issues fixed in
this release can be found [here][1]. Note that some of these fixes have also
been backported into Axis2 1.6.x maintenance releases; for more information,
check the "Fix Version/s" field of the relevant JIRA issues.

Please note that generated code such as client stubs is generally not compatible
across different major Axis2 releases. Therefore all such code needs to be
regenerated when upgrading to Axis2 1.7.0. This applies in particular to code
generated using the JAXBRI databinding which has been significantly improved.

[1]: https://issues.apache.org/jira/secure/ReleaseNote.jspa?projectId=10611&amp;version=12316136

### Changes in this release

*   XmlSchema has been upgraded from 1.4.x to 2.2.x and Woden from 1.0M9 to
    1.0M10. This is a backwards incompatible change with respect to Axis2 1.6.x;
    application code that interacts with XmlSchema or Woden needs to be updated
    to support the new versions.

*   Axis2 1.7.0 supports Apache HttpClient 4.x in addition to the no longer
    maintained Commons HttpClient 3.x. To enable the support for HttpClient 4.x, use
    `org.apache.axis2.transport.http.impl.httpclient4.HTTPClient4TransportSender`
    instead of `org.apache.axis2.transport.http.CommonsHTTPTransportSender` in
    `axis2.xml`. Please note that the code was written for HttpClient 4.2.x and
    should work with 4.3.x and 4.4.x, but is incompatible with 4.5.x.

*   Several classes, methods and constants deprecated in Axis2 1.3 and 1.4 have
    been removed. See [AXIS2-5315][] for more details.

    As a consequence, MEP URLs in the form `http://www.w3.org/2004/08/wsdl/XXX`
    and `http://www.w3.org/2006/01/wsdl/XXX` are no longer supported.
    Instead use `http://www.w3.org/ns/wsdl/XXX`.

[AXIS2-5315]: https://issues.apache.org/jira/browse/AXIS2-5315

*   The semantics of the `getAttachmentMap()` method in `MessageContext` has
    changed for incoming messages so that they match those for outgoing
    messages (For more details and context, see [AXIS2-5308][]):

    *   For SwA messages, the `Attachments` object on the message context no
        longer contains the root part (as in Axis2 1.6.x), but only attachment
        parts.
    *   For MTOM messages, application code should no longer assume that the
        `Attachments` object is set on the message context and contains all MIME
        parts of the message. Note that as of Axis2 1.7.0, this assumption is
        still true (because the JAX-WS implementation internally relies on this),
        but this will change in a subsequent release.

[AXIS2-5308]: https://issues.apache.org/jira/browse/AXIS2-5308
