// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: iam.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// User represents an actual person.
type User struct {
	// Identifier of the user.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Email address of the user.
	Email string `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	// Name of the user.
	// This may be empty if not filled out by the user.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Given name of the user.
	// This may be empty if not filled out by the user.
	GivenName string `protobuf:"bytes,4,opt,name=given_name,json=givenName,proto3" json:"given_name,omitempty"`
	// Family name of the user.
	// This may be empty if not filled out by the user.
	FamilyName string `protobuf:"bytes,5,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// The creation timestamp of the user.
	CreatedAt            *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *User) Reset()         { *m = User{} }
func (m *User) String() string { return proto.CompactTextString(m) }
func (*User) ProtoMessage()    {}
func (*User) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{0}
}
func (m *User) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_User.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_User.Merge(m, src)
}
func (m *User) XXX_Size() int {
	return m.Size()
}
func (m *User) XXX_DiscardUnknown() {
	xxx_messageInfo_User.DiscardUnknown(m)
}

var xxx_messageInfo_User proto.InternalMessageInfo

func (m *User) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *User) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *User) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *User) GetGivenName() string {
	if m != nil {
		return m.GivenName
	}
	return ""
}

func (m *User) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *User) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

// Group of user accounts.
type Group struct {
	// System identifier of the group.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the organization that owns this group.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the group
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the group
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The creation timestamp of the group
	CreatedAt            *types.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Group) Reset()         { *m = Group{} }
func (m *Group) String() string { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()    {}
func (*Group) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{1}
}
func (m *Group) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Group) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Group.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Group) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Group.Merge(m, src)
}
func (m *Group) XXX_Size() int {
	return m.Size()
}
func (m *Group) XXX_DiscardUnknown() {
	xxx_messageInfo_Group.DiscardUnknown(m)
}

var xxx_messageInfo_Group proto.InternalMessageInfo

func (m *Group) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Group) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Group) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Group) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Group) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

// List of groups.
type GroupList struct {
	Items                []*Group `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupList) Reset()         { *m = GroupList{} }
func (m *GroupList) String() string { return proto.CompactTextString(m) }
func (*GroupList) ProtoMessage()    {}
func (*GroupList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{2}
}
func (m *GroupList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupList.Merge(m, src)
}
func (m *GroupList) XXX_Size() int {
	return m.Size()
}
func (m *GroupList) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupList.DiscardUnknown(m)
}

var xxx_messageInfo_GroupList proto.InternalMessageInfo

func (m *GroupList) GetItems() []*Group {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for IsMemberOfGroup.
type IsMemberOfGroupRequest struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Identifier of the group
	GroupId              string   `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsMemberOfGroupRequest) Reset()         { *m = IsMemberOfGroupRequest{} }
func (m *IsMemberOfGroupRequest) String() string { return proto.CompactTextString(m) }
func (*IsMemberOfGroupRequest) ProtoMessage()    {}
func (*IsMemberOfGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{3}
}
func (m *IsMemberOfGroupRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsMemberOfGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsMemberOfGroupRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsMemberOfGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsMemberOfGroupRequest.Merge(m, src)
}
func (m *IsMemberOfGroupRequest) XXX_Size() int {
	return m.Size()
}
func (m *IsMemberOfGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsMemberOfGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsMemberOfGroupRequest proto.InternalMessageInfo

func (m *IsMemberOfGroupRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *IsMemberOfGroupRequest) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

// List of group members (user ID's)
type GroupMemberList struct {
	// List of ID's of users that are member of the group.
	Items                []string `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMemberList) Reset()         { *m = GroupMemberList{} }
func (m *GroupMemberList) String() string { return proto.CompactTextString(m) }
func (*GroupMemberList) ProtoMessage()    {}
func (*GroupMemberList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{4}
}
func (m *GroupMemberList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupMemberList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMemberList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupMemberList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMemberList.Merge(m, src)
}
func (m *GroupMemberList) XXX_Size() int {
	return m.Size()
}
func (m *GroupMemberList) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMemberList.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMemberList proto.InternalMessageInfo

func (m *GroupMemberList) GetItems() []string {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for Add/DeleteGroupMembers.
type GroupMembersRequest struct {
	// ID of the group to add/remove members to/from.
	GroupId string `protobuf:"bytes,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// ID's of users to add/remove to/from the group.
	UserIds              []string `protobuf:"bytes,2,rep,name=user_ids,json=userIds,proto3" json:"user_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMembersRequest) Reset()         { *m = GroupMembersRequest{} }
func (m *GroupMembersRequest) String() string { return proto.CompactTextString(m) }
func (*GroupMembersRequest) ProtoMessage()    {}
func (*GroupMembersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{5}
}
func (m *GroupMembersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupMembersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMembersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupMembersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMembersRequest.Merge(m, src)
}
func (m *GroupMembersRequest) XXX_Size() int {
	return m.Size()
}
func (m *GroupMembersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMembersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMembersRequest proto.InternalMessageInfo

func (m *GroupMembersRequest) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *GroupMembersRequest) GetUserIds() []string {
	if m != nil {
		return m.UserIds
	}
	return nil
}

// List of permissions.
type PermissionList struct {
	Items                []string `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PermissionList) Reset()         { *m = PermissionList{} }
func (m *PermissionList) String() string { return proto.CompactTextString(m) }
func (*PermissionList) ProtoMessage()    {}
func (*PermissionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{6}
}
func (m *PermissionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PermissionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PermissionList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PermissionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PermissionList.Merge(m, src)
}
func (m *PermissionList) XXX_Size() int {
	return m.Size()
}
func (m *PermissionList) XXX_DiscardUnknown() {
	xxx_messageInfo_PermissionList.DiscardUnknown(m)
}

var xxx_messageInfo_PermissionList proto.InternalMessageInfo

func (m *PermissionList) GetItems() []string {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for HasPermissionsRequest.
type HasPermissionsRequest struct {
	// URL of the resource to query permissions for.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The list of permissions that are required.
	Permissions          []string `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HasPermissionsRequest) Reset()         { *m = HasPermissionsRequest{} }
func (m *HasPermissionsRequest) String() string { return proto.CompactTextString(m) }
func (*HasPermissionsRequest) ProtoMessage()    {}
func (*HasPermissionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{7}
}
func (m *HasPermissionsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HasPermissionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HasPermissionsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HasPermissionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HasPermissionsRequest.Merge(m, src)
}
func (m *HasPermissionsRequest) XXX_Size() int {
	return m.Size()
}
func (m *HasPermissionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HasPermissionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HasPermissionsRequest proto.InternalMessageInfo

func (m *HasPermissionsRequest) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *HasPermissionsRequest) GetPermissions() []string {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// A role is a list of permissions.
// Roles can be bound to resources for members.
type Role struct {
	// System identifier of the role.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the organization that owns this role.
	// This value is undefined for predefined roles.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the role
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the role
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Permissions to grant when this role is bound.
	Permissions []string `protobuf:"bytes,5,rep,name=permissions,proto3" json:"permissions,omitempty"`
	// Set if this role is predefined.
	// This is a read-only value.
	IsPredefined bool `protobuf:"varint,6,opt,name=is_predefined,json=isPredefined,proto3" json:"is_predefined,omitempty"`
	// The creation timestamp of the role
	CreatedAt            *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Role) Reset()         { *m = Role{} }
func (m *Role) String() string { return proto.CompactTextString(m) }
func (*Role) ProtoMessage()    {}
func (*Role) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{8}
}
func (m *Role) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Role) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Role.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Role) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Role.Merge(m, src)
}
func (m *Role) XXX_Size() int {
	return m.Size()
}
func (m *Role) XXX_DiscardUnknown() {
	xxx_messageInfo_Role.DiscardUnknown(m)
}

var xxx_messageInfo_Role proto.InternalMessageInfo

func (m *Role) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Role) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Role) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Role) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Role) GetPermissions() []string {
	if m != nil {
		return m.Permissions
	}
	return nil
}

func (m *Role) GetIsPredefined() bool {
	if m != nil {
		return m.IsPredefined
	}
	return false
}

func (m *Role) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

// List of roles.
type RoleList struct {
	Items                []*Role  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleList) Reset()         { *m = RoleList{} }
func (m *RoleList) String() string { return proto.CompactTextString(m) }
func (*RoleList) ProtoMessage()    {}
func (*RoleList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{9}
}
func (m *RoleList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleList.Merge(m, src)
}
func (m *RoleList) XXX_Size() int {
	return m.Size()
}
func (m *RoleList) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleList.DiscardUnknown(m)
}

var xxx_messageInfo_RoleList proto.InternalMessageInfo

func (m *RoleList) GetItems() []*Role {
	if m != nil {
		return m.Items
	}
	return nil
}

// RoleBinding binds a Role to a member.
type RoleBinding struct {
	// System identifier of the role-binding.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the member to bind a role to.
	// Member ID is formatted as:
	// - user:<user_id>
	// - group:<group_id>
	MemberId string `protobuf:"bytes,2,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	// Identifier of the Role to grant to member
	RoleId               string   `protobuf:"bytes,3,opt,name=role_id,json=roleId,proto3" json:"role_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleBinding) Reset()         { *m = RoleBinding{} }
func (m *RoleBinding) String() string { return proto.CompactTextString(m) }
func (*RoleBinding) ProtoMessage()    {}
func (*RoleBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{10}
}
func (m *RoleBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleBinding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleBinding.Merge(m, src)
}
func (m *RoleBinding) XXX_Size() int {
	return m.Size()
}
func (m *RoleBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleBinding.DiscardUnknown(m)
}

var xxx_messageInfo_RoleBinding proto.InternalMessageInfo

func (m *RoleBinding) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RoleBinding) GetMemberId() string {
	if m != nil {
		return m.MemberId
	}
	return ""
}

func (m *RoleBinding) GetRoleId() string {
	if m != nil {
		return m.RoleId
	}
	return ""
}

// Policy bindings members to roles for access to a resource.
type Policy struct {
	// URL of the resource to which this policy applies.
	ResourceUrl string `protobuf:"bytes,1,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// Role bindings to apply to the resource.
	Bindings             []*RoleBinding `protobuf:"bytes,2,rep,name=bindings,proto3" json:"bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Policy) Reset()         { *m = Policy{} }
func (m *Policy) String() string { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()    {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{11}
}
func (m *Policy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return m.Size()
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

func (m *Policy) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *Policy) GetBindings() []*RoleBinding {
	if m != nil {
		return m.Bindings
	}
	return nil
}

// Request arguments for Add/DeleteRoleBindings.
type RoleBindingsRequest struct {
	// URL of the resource to add/remove policy binding to/from.
	ResourceUrl string `protobuf:"bytes,1,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// Role bindings to add/remove to the policy.
	Bindings             []*RoleBinding `protobuf:"bytes,2,rep,name=bindings,proto3" json:"bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RoleBindingsRequest) Reset()         { *m = RoleBindingsRequest{} }
func (m *RoleBindingsRequest) String() string { return proto.CompactTextString(m) }
func (*RoleBindingsRequest) ProtoMessage()    {}
func (*RoleBindingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{12}
}
func (m *RoleBindingsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleBindingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleBindingsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleBindingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleBindingsRequest.Merge(m, src)
}
func (m *RoleBindingsRequest) XXX_Size() int {
	return m.Size()
}
func (m *RoleBindingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleBindingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RoleBindingsRequest proto.InternalMessageInfo

func (m *RoleBindingsRequest) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *RoleBindingsRequest) GetBindings() []*RoleBinding {
	if m != nil {
		return m.Bindings
	}
	return nil
}

func init() {
	proto.RegisterType((*User)(nil), "arangodb.cloud.iam.v1.User")
	proto.RegisterType((*Group)(nil), "arangodb.cloud.iam.v1.Group")
	proto.RegisterType((*GroupList)(nil), "arangodb.cloud.iam.v1.GroupList")
	proto.RegisterType((*IsMemberOfGroupRequest)(nil), "arangodb.cloud.iam.v1.IsMemberOfGroupRequest")
	proto.RegisterType((*GroupMemberList)(nil), "arangodb.cloud.iam.v1.GroupMemberList")
	proto.RegisterType((*GroupMembersRequest)(nil), "arangodb.cloud.iam.v1.GroupMembersRequest")
	proto.RegisterType((*PermissionList)(nil), "arangodb.cloud.iam.v1.PermissionList")
	proto.RegisterType((*HasPermissionsRequest)(nil), "arangodb.cloud.iam.v1.HasPermissionsRequest")
	proto.RegisterType((*Role)(nil), "arangodb.cloud.iam.v1.Role")
	proto.RegisterType((*RoleList)(nil), "arangodb.cloud.iam.v1.RoleList")
	proto.RegisterType((*RoleBinding)(nil), "arangodb.cloud.iam.v1.RoleBinding")
	proto.RegisterType((*Policy)(nil), "arangodb.cloud.iam.v1.Policy")
	proto.RegisterType((*RoleBindingsRequest)(nil), "arangodb.cloud.iam.v1.RoleBindingsRequest")
}

func init() { proto.RegisterFile("iam.proto", fileDescriptor_0a2c201915207782) }

var fileDescriptor_0a2c201915207782 = []byte{
	// 1281 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x98, 0x5d, 0x6f, 0x1b, 0x45,
	0x17, 0xc7, 0x9f, 0x4d, 0xe3, 0xc4, 0x3e, 0xee, 0x93, 0x54, 0xd3, 0xbc, 0xb8, 0x79, 0x75, 0xb6,
	0xa4, 0x09, 0x56, 0xb2, 0x8b, 0xcd, 0x4b, 0x55, 0xa0, 0xa0, 0x94, 0x56, 0xc6, 0x22, 0x6d, 0x22,
	0xb7, 0xb9, 0x80, 0x1b, 0x6b, 0xed, 0x1d, 0x6f, 0x87, 0xee, 0x1b, 0x3b, 0x6b, 0xab, 0x69, 0x94,
	0x1b, 0x84, 0x10, 0x15, 0x20, 0x21, 0xb8, 0x41, 0x88, 0x4f, 0xc0, 0x1d, 0xd7, 0x7c, 0x01, 0x2e,
	0x91, 0xf8, 0x02, 0x28, 0xf0, 0x1d, 0xb8, 0x45, 0x33, 0xb3, 0x6b, 0x6f, 0x9c, 0xdd, 0xb5, 0xa3,
	0x12, 0xee, 0xbc, 0x73, 0xce, 0x9e, 0xdf, 0xff, 0xcc, 0x39, 0x7b, 0x76, 0xd6, 0x90, 0x23, 0x9a,
	0xa5, 0xb8, 0x9e, 0xe3, 0x3b, 0x68, 0x56, 0xf3, 0x34, 0xdb, 0x70, 0xf4, 0xa6, 0xd2, 0x32, 0x9d,
	0x8e, 0xae, 0x30, 0x4b, 0xb7, 0xbc, 0x30, 0xd7, 0x72, 0x2c, 0xcb, 0xb1, 0xd5, 0x6e, 0x59, 0x15,
	0xbf, 0x84, 0xfb, 0xc2, 0x5b, 0x06, 0xf1, 0x1f, 0x77, 0x9a, 0x4a, 0xcb, 0xb1, 0x54, 0xc3, 0x31,
	0x35, 0xdb, 0x50, 0xb9, 0xa1, 0xd9, 0x69, 0xab, 0xae, 0x7f, 0xe8, 0x62, 0xaa, 0xfa, 0xc4, 0xc2,
	0xd4, 0xd7, 0x2c, 0xb7, 0xff, 0x2b, 0xb8, 0x79, 0xc9, 0x70, 0x1c, 0xc3, 0xc4, 0xaa, 0xe6, 0x12,
	0x55, 0xb3, 0x6d, 0xc7, 0xd7, 0x7c, 0xe2, 0xd8, 0x54, 0x58, 0xe5, 0x5f, 0x24, 0x18, 0x3f, 0xa0,
	0xd8, 0x43, 0x53, 0x30, 0x46, 0xf4, 0x82, 0x54, 0x94, 0x36, 0x73, 0xf5, 0x31, 0xa2, 0xa3, 0x19,
	0xc8, 0x60, 0x4b, 0x23, 0x66, 0x61, 0x8c, 0x2f, 0x89, 0x0b, 0x84, 0x60, 0xdc, 0xd6, 0x2c, 0x5c,
	0xb8, 0xc4, 0x17, 0xf9, 0x6f, 0xb4, 0x0c, 0x60, 0x90, 0x2e, 0xb6, 0x1b, 0xdc, 0x32, 0xce, 0x2d,
	0x39, 0xbe, 0xf2, 0x80, 0x99, 0x57, 0x21, 0xdf, 0xd6, 0x2c, 0x62, 0x1e, 0x0a, 0x7b, 0x86, 0xdb,
	0x41, 0x2c, 0x71, 0x87, 0x5b, 0x00, 0x2d, 0x0f, 0x6b, 0x3e, 0xd6, 0x1b, 0x9a, 0x5f, 0x98, 0x28,
	0x4a, 0x9b, 0xf9, 0xca, 0x82, 0x22, 0x54, 0x2b, 0x61, 0x9e, 0xca, 0xa3, 0x30, 0xad, 0x7a, 0x2e,
	0xf0, 0xde, 0xf1, 0xe5, 0x9f, 0x25, 0xc8, 0x54, 0x3d, 0xa7, 0xe3, 0x9e, 0x91, 0xbf, 0x01, 0xd3,
	0x8e, 0x67, 0x68, 0x36, 0x79, 0xc6, 0xd3, 0x6d, 0x10, 0x3d, 0x48, 0x64, 0x2a, 0xba, 0x5c, 0xd3,
	0x63, 0x33, 0x2a, 0x42, 0x5e, 0xc7, 0xb4, 0xe5, 0x11, 0x97, 0x39, 0x05, 0x29, 0x45, 0x97, 0x06,
	0x34, 0x67, 0xce, 0xa3, 0xf9, 0x5d, 0xc8, 0x71, 0xc9, 0xbb, 0x84, 0xfa, 0xa8, 0x02, 0x19, 0xe2,
	0x63, 0x8b, 0x16, 0xa4, 0xe2, 0xa5, 0xcd, 0x7c, 0x65, 0x49, 0x89, 0x6d, 0x0c, 0x85, 0xdf, 0x50,
	0x17, 0xae, 0xf2, 0x2e, 0xcc, 0xd5, 0xe8, 0x7d, 0x6c, 0x35, 0xb1, 0xb7, 0xd7, 0x16, 0x16, 0xfc,
	0x49, 0x07, 0x53, 0x1f, 0xcd, 0xc3, 0x64, 0x87, 0x62, 0xaf, 0xd1, 0xdb, 0x89, 0x09, 0x76, 0x59,
	0xd3, 0xd1, 0x35, 0xc8, 0x1a, 0xcc, 0xb1, 0xbf, 0x0d, 0x93, 0xfc, 0xba, 0xa6, 0xcb, 0x1b, 0x30,
	0xcd, 0x63, 0x88, 0x80, 0x5c, 0xd4, 0x4c, 0x54, 0x54, 0x2e, 0xc4, 0x7e, 0x00, 0x57, 0x23, 0x8e,
	0x34, 0x64, 0x46, 0x43, 0x4b, 0xa7, 0x42, 0x33, 0x53, 0x20, 0x87, 0x16, 0xc6, 0x78, 0xa8, 0x49,
	0xa1, 0x87, 0xca, 0x37, 0x60, 0x6a, 0x1f, 0x7b, 0x16, 0xa1, 0x94, 0x38, 0x76, 0x2a, 0x74, 0xf6,
	0x7d, 0x8d, 0xf6, 0x5d, 0x7b, 0xd8, 0x2b, 0x70, 0xa9, 0xe3, 0x99, 0x01, 0x91, 0xfd, 0x64, 0x45,
	0x73, 0xfb, 0x7e, 0x01, 0x30, 0xba, 0x24, 0xff, 0x2d, 0xc1, 0x78, 0xdd, 0x31, 0xf1, 0x7f, 0xdd,
	0x2c, 0x03, 0xca, 0x32, 0x67, 0x94, 0xa1, 0xeb, 0xf0, 0x7f, 0x42, 0x1b, 0xae, 0x87, 0x75, 0xdc,
	0x26, 0x36, 0xd6, 0xf9, 0x53, 0x90, 0xad, 0x5f, 0x26, 0x74, 0xbf, 0xb7, 0x36, 0xd0, 0x73, 0x93,
	0xe7, 0xe9, 0xb9, 0xdb, 0x90, 0x65, 0x89, 0xf3, 0x8d, 0x2e, 0x9f, 0x6e, 0xb9, 0xc5, 0x84, 0x96,
	0x63, 0xfe, 0x61, 0x15, 0x1e, 0x42, 0x9e, 0x5d, 0xde, 0x21, 0xb6, 0x4e, 0x6c, 0xe3, 0xcc, 0xf6,
	0x2d, 0x42, 0xce, 0xe2, 0x4d, 0xd1, 0xdf, 0xb8, 0xac, 0x58, 0xa8, 0xe9, 0xac, 0x27, 0x3d, 0xc7,
	0xc4, 0xcc, 0x24, 0x76, 0x6d, 0x82, 0x5d, 0xd6, 0x74, 0xf9, 0x09, 0x4c, 0xec, 0x3b, 0x26, 0x69,
	0x1d, 0xa2, 0x35, 0xb8, 0xec, 0x61, 0xea, 0x74, 0xbc, 0x16, 0x6e, 0xf4, 0x8b, 0x9a, 0x0f, 0xd7,
	0x0e, 0x3c, 0x13, 0xbd, 0x03, 0xd9, 0xa6, 0xa0, 0x8b, 0xca, 0xe6, 0x2b, 0x72, 0x8a, 0xee, 0x40,
	0x68, 0xbd, 0x77, 0x8f, 0xfc, 0x14, 0xae, 0x46, 0x0c, 0xbd, 0x2e, 0xba, 0x78, 0x72, 0xe5, 0xa7,
	0x39, 0x80, 0xda, 0xce, 0xfd, 0x87, 0xd8, 0xeb, 0x92, 0x16, 0x46, 0x1f, 0x43, 0xbe, 0x8a, 0xfd,
	0x47, 0x8f, 0x09, 0xe5, 0x53, 0x77, 0x75, 0x30, 0x56, 0x30, 0xf7, 0xbb, 0x65, 0xe5, 0x9e, 0xe5,
	0xfa, 0x87, 0x0b, 0x49, 0xe5, 0x61, 0x77, 0xcb, 0xcb, 0x9f, 0xfe, 0xfe, 0xd7, 0x77, 0x63, 0xf3,
	0x68, 0x96, 0x0f, 0x77, 0xa2, 0x59, 0xec, 0xcd, 0x41, 0xb1, 0xd9, 0x56, 0xd9, 0x73, 0x86, 0x9e,
	0xc0, 0x64, 0x15, 0xfb, 0x9c, 0x73, 0x3d, 0x99, 0x53, 0xbb, 0xbb, 0xc7, 0xdb, 0x94, 0xa6, 0xb3,
	0x56, 0x38, 0xab, 0x80, 0xe6, 0xa2, 0x2c, 0x86, 0xa1, 0xea, 0x11, 0xd1, 0x8f, 0xd1, 0x57, 0x12,
	0x00, 0xeb, 0x2f, 0x3e, 0x23, 0x28, 0x5a, 0x4f, 0x06, 0x32, 0xaf, 0x10, 0x59, 0x4c, 0x1b, 0x78,
	0xcc, 0x51, 0x7e, 0x9d, 0x73, 0x55, 0xb4, 0x1d, 0xe5, 0x46, 0x1f, 0x4b, 0xaa, 0x1e, 0xb5, 0x1c,
	0xdb, 0xc7, 0x4f, 0xfd, 0x06, 0xd1, 0x8f, 0x55, 0x43, 0xf0, 0x6d, 0xc8, 0x56, 0xb1, 0x10, 0x33,
	0x5a, 0xf2, 0xa9, 0xa3, 0x57, 0x5e, 0xe5, 0x2a, 0xae, 0xa1, 0xf9, 0xa8, 0x0a, 0x81, 0x12, 0xe9,
	0x7f, 0x21, 0x41, 0xfe, 0x3d, 0xfe, 0xbc, 0x09, 0x66, 0x6a, 0xb8, 0x21, 0xb0, 0xdb, 0x1c, 0x76,
	0x53, 0xae, 0xa4, 0xa4, 0x3c, 0x30, 0xaf, 0xc2, 0xbc, 0xdf, 0x94, 0x4a, 0xc8, 0x82, 0xfc, 0x81,
	0xab, 0xff, 0x2b, 0x4a, 0x64, 0xae, 0x64, 0xa9, 0x92, 0x94, 0x76, 0x80, 0xbb, 0x8b, 0x4d, 0x3c,
	0x1a, 0x6e, 0x58, 0xbf, 0x87, 0x1b, 0x5d, 0x4a, 0xdc, 0xe8, 0x6f, 0x25, 0xb8, 0xd2, 0xeb, 0xb3,
	0xe0, 0x5d, 0x34, 0x6a, 0xb7, 0xdd, 0x48, 0xd3, 0xd6, 0x7f, 0x01, 0xca, 0x2a, 0x17, 0xf1, 0x32,
	0xda, 0x88, 0x13, 0x11, 0x6d, 0x36, 0x2b, 0xe0, 0x7f, 0x2d, 0xc1, 0xf4, 0x8e, 0xae, 0x9f, 0xd2,
	0x54, 0x1a, 0x0e, 0x0b, 0xe7, 0xd0, 0x90, 0x2a, 0xbc, 0xc2, 0xe5, 0x94, 0xe4, 0xf5, 0x38, 0x39,
	0xe1, 0xcb, 0xb7, 0x27, 0x86, 0xd5, 0xe4, 0x1b, 0x09, 0x50, 0xa4, 0x28, 0x17, 0x26, 0xa9, 0x34,
	0xba, 0xa4, 0x1f, 0x25, 0x98, 0x1e, 0x38, 0xb6, 0xa0, 0xed, 0x04, 0x46, 0xfc, 0xf1, 0x66, 0x61,
	0x2d, 0xb9, 0xca, 0x1f, 0x62, 0xba, 0xe7, 0x3d, 0x70, 0xe4, 0x9b, 0x5c, 0x57, 0x19, 0xa9, 0x23,
	0xe9, 0x52, 0x8f, 0x82, 0xf3, 0xc9, 0x31, 0x7a, 0x2e, 0x41, 0x8e, 0xd5, 0x9e, 0x0d, 0xf1, 0x91,
	0xfb, 0x69, 0x35, 0xe5, 0x4d, 0xc0, 0x1b, 0xe9, 0x35, 0x2e, 0x47, 0x41, 0x5b, 0x23, 0x0e, 0x2f,
	0x8f, 0xd3, 0xc5, 0xdc, 0xe6, 0x27, 0x95, 0x17, 0x9a, 0xdb, 0x2c, 0x42, 0xfc, 0xdc, 0xe6, 0x1c,
	0xf1, 0x3c, 0x7d, 0x26, 0x01, 0x88, 0xc1, 0xc5, 0x81, 0x69, 0xb1, 0xd2, 0x41, 0x6f, 0x73, 0xd0,
	0x1b, 0x72, 0xf9, 0x3c, 0x53, 0x8b, 0x0b, 0x61, 0xed, 0x41, 0x00, 0xc4, 0xd0, 0x7a, 0x41, 0x15,
	0x6b, 0x5c, 0xc5, 0x62, 0x25, 0x21, 0x5d, 0x31, 0xb0, 0x40, 0x3c, 0x1b, 0xc3, 0x51, 0x43, 0xc7,
	0x55, 0x80, 0x2b, 0xa5, 0xe0, 0x6c, 0xc8, 0x55, 0xb1, 0x1f, 0x1c, 0x75, 0x5e, 0x4a, 0x0e, 0x78,
	0x50, 0xdf, 0x0d, 0x0b, 0xba, 0x9c, 0xa0, 0x49, 0x04, 0x91, 0x97, 0x38, 0x74, 0x0e, 0xcd, 0x44,
	0xa1, 0x2e, 0xb3, 0x11, 0x4c, 0xd1, 0xe7, 0x62, 0x16, 0x45, 0x8f, 0x3b, 0x89, 0x0f, 0x7e, 0xcc,
	0x99, 0x68, 0x18, 0x7c, 0x93, 0xc3, 0x65, 0x79, 0x39, 0x0e, 0xae, 0x86, 0xc7, 0x1e, 0x96, 0xf8,
	0xf3, 0xde, 0x10, 0xba, 0x60, 0x2d, 0xa5, 0xe1, 0x5a, 0x7e, 0x90, 0x60, 0xbe, 0x8a, 0xfd, 0x7b,
	0xed, 0x36, 0x6e, 0xf9, 0xa4, 0x8b, 0x23, 0x5f, 0x14, 0x23, 0xd6, 0x64, 0x3d, 0x49, 0xca, 0xa9,
	0xcf, 0x18, 0xb9, 0xc2, 0x25, 0x6d, 0xa1, 0x52, 0xac, 0x24, 0x1c, 0xf2, 0xb7, 0xa3, 0xa7, 0xff,
	0x2f, 0x25, 0x98, 0x3a, 0xfd, 0x95, 0x83, 0xb6, 0x12, 0x68, 0xb1, 0x1f, 0x43, 0xa3, 0x0c, 0xc6,
	0x60, 0xab, 0x50, 0x31, 0x56, 0x57, 0x54, 0xcd, 0x33, 0x98, 0x66, 0x99, 0x44, 0xd5, 0x0c, 0x3d,
	0xa5, 0x8e, 0xb8, 0x39, 0xb1, 0xa7, 0xa8, 0x08, 0xfb, 0xce, 0xad, 0x5f, 0x4f, 0x56, 0xa4, 0xdf,
	0x4e, 0x56, 0xa4, 0x3f, 0x4e, 0x56, 0xa4, 0xef, 0xff, 0x5c, 0xf9, 0xdf, 0x47, 0x1b, 0x91, 0xbf,
	0x3e, 0x42, 0xc6, 0xb6, 0xa5, 0xd9, 0x9a, 0x81, 0x75, 0x16, 0x85, 0x06, 0x61, 0x9a, 0x13, 0xfc,
	0x0b, 0xe8, 0xd5, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x97, 0x2c, 0x73, 0xd2, 0x66, 0x11, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// IAMServiceClient is the client API for IAMService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IAMServiceClient interface {
	// Fetch all available information of the currently authenticated user.
	// Required permissions:
	// - None
	GetThisUser(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*User, error)
	// Fetch all available information of the user identified by the given ID.
	// Required permissions:
	// - resourcemanager.organization.get on one of the organizations that the request user and authenticated user are both a member of
	GetUser(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*User, error)
	// Fetch all groups of the organization identified by the given context ID.
	// Required permissions:
	// - iam.group.list on organization identified by given context ID.
	ListGroups(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupList, error)
	// Fetch a group by its id.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	GetGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Group, error)
	// Create a group
	// Required permissions:
	// - iam.group.create on organization that owns the group
	CreateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error)
	// Update a group
	// Required permissions:
	// - iam.group.update on organization that owns the group
	UpdateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error)
	// Delete a group
	// Required permissions:
	// - iam.group.delete on organization that owns the group
	DeleteGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*v1.Empty, error)
	// List of members of the group identified by the given context ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	ListGroupMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupMemberList, error)
	// Add one or more members to the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	AddGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*Group, error)
	// Remove one or more members from the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	DeleteGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*Group, error)
	// Is the user identified by the given user ID a member of the group identified by the given group ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group, unless the requested user is identical to the authenticated user.
	// Note that if the identified group does not exist, no is returned.
	IsMemberOfGroup(ctx context.Context, in *IsMemberOfGroupRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error)
	// Fetch all roles in the organization identified by the given context ID.
	// Required permissions:
	// - iam.role.list on organization identified by given context ID.
	ListRoles(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*RoleList, error)
	// Fetch a role by its id.
	// Required permissions:
	// - iam.role.get on organization that owns the role
	GetRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Role, error)
	// Create a custom role
	// Required permissions:
	// - iam.role.create on organization that owns the role
	CreateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error)
	// Update a custom role
	// Required permissions:
	// - iam.role.update on organization that owns the role
	UpdateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error)
	// Delete a custom role
	// Required permissions:
	// - iam.role.delete on organization that owns the role
	DeleteRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*v1.Empty, error)
	// Get the policy for a resource identified by given URL.
	// Required permissions:
	// - iam.policy.get on resource identified by the url
	GetPolicy(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*Policy, error)
	// Add one or more RoleBindings to the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	AddRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error)
	// Remove one or more RoleBindings from the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	DeleteRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error)
	// Return the list of permissions that are available to the currently authenticated
	// used for actions on the resource identified by the given URL.
	// Required permissions:
	// - None
	GetEffectivePermissions(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*PermissionList, error)
	// Does the authenticated user have all of the requested permissions for the resource
	// identified by the given URL?
	// Required permissions:
	// - None
	HasPermissions(ctx context.Context, in *HasPermissionsRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error)
	// List all known permissions.
	// Required permissions:
	// - None
	ListPermissions(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*PermissionList, error)
}

type iAMServiceClient struct {
	cc *grpc.ClientConn
}

func NewIAMServiceClient(cc *grpc.ClientConn) IAMServiceClient {
	return &iAMServiceClient{cc}
}

func (c *iAMServiceClient) GetThisUser(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetThisUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetUser(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListGroups(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupList, error) {
	out := new(GroupList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) CreateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/CreateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) UpdateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/UpdateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListGroupMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupMemberList, error) {
	out := new(GroupMemberList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) AddGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/AddGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) IsMemberOfGroup(ctx context.Context, in *IsMemberOfGroupRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error) {
	out := new(v1.YesOrNo)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/IsMemberOfGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListRoles(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*RoleList, error) {
	out := new(RoleList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) CreateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/CreateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) UpdateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/UpdateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetPolicy(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) AddRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/AddRoleBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteRoleBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetEffectivePermissions(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*PermissionList, error) {
	out := new(PermissionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetEffectivePermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) HasPermissions(ctx context.Context, in *HasPermissionsRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error) {
	out := new(v1.YesOrNo)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/HasPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListPermissions(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*PermissionList, error) {
	out := new(PermissionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IAMServiceServer is the server API for IAMService service.
type IAMServiceServer interface {
	// Fetch all available information of the currently authenticated user.
	// Required permissions:
	// - None
	GetThisUser(context.Context, *v1.Empty) (*User, error)
	// Fetch all available information of the user identified by the given ID.
	// Required permissions:
	// - resourcemanager.organization.get on one of the organizations that the request user and authenticated user are both a member of
	GetUser(context.Context, *v1.IDOptions) (*User, error)
	// Fetch all groups of the organization identified by the given context ID.
	// Required permissions:
	// - iam.group.list on organization identified by given context ID.
	ListGroups(context.Context, *v1.ListOptions) (*GroupList, error)
	// Fetch a group by its id.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	GetGroup(context.Context, *v1.IDOptions) (*Group, error)
	// Create a group
	// Required permissions:
	// - iam.group.create on organization that owns the group
	CreateGroup(context.Context, *Group) (*Group, error)
	// Update a group
	// Required permissions:
	// - iam.group.update on organization that owns the group
	UpdateGroup(context.Context, *Group) (*Group, error)
	// Delete a group
	// Required permissions:
	// - iam.group.delete on organization that owns the group
	DeleteGroup(context.Context, *Group) (*v1.Empty, error)
	// List of members of the group identified by the given context ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	ListGroupMembers(context.Context, *v1.ListOptions) (*GroupMemberList, error)
	// Add one or more members to the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	AddGroupMembers(context.Context, *GroupMembersRequest) (*Group, error)
	// Remove one or more members from the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	DeleteGroupMembers(context.Context, *GroupMembersRequest) (*Group, error)
	// Is the user identified by the given user ID a member of the group identified by the given group ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group, unless the requested user is identical to the authenticated user.
	// Note that if the identified group does not exist, no is returned.
	IsMemberOfGroup(context.Context, *IsMemberOfGroupRequest) (*v1.YesOrNo, error)
	// Fetch all roles in the organization identified by the given context ID.
	// Required permissions:
	// - iam.role.list on organization identified by given context ID.
	ListRoles(context.Context, *v1.ListOptions) (*RoleList, error)
	// Fetch a role by its id.
	// Required permissions:
	// - iam.role.get on organization that owns the role
	GetRole(context.Context, *v1.IDOptions) (*Role, error)
	// Create a custom role
	// Required permissions:
	// - iam.role.create on organization that owns the role
	CreateRole(context.Context, *Role) (*Role, error)
	// Update a custom role
	// Required permissions:
	// - iam.role.update on organization that owns the role
	UpdateRole(context.Context, *Role) (*Role, error)
	// Delete a custom role
	// Required permissions:
	// - iam.role.delete on organization that owns the role
	DeleteRole(context.Context, *Role) (*v1.Empty, error)
	// Get the policy for a resource identified by given URL.
	// Required permissions:
	// - iam.policy.get on resource identified by the url
	GetPolicy(context.Context, *v1.URLOptions) (*Policy, error)
	// Add one or more RoleBindings to the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	AddRoleBindings(context.Context, *RoleBindingsRequest) (*Policy, error)
	// Remove one or more RoleBindings from the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	DeleteRoleBindings(context.Context, *RoleBindingsRequest) (*Policy, error)
	// Return the list of permissions that are available to the currently authenticated
	// used for actions on the resource identified by the given URL.
	// Required permissions:
	// - None
	GetEffectivePermissions(context.Context, *v1.URLOptions) (*PermissionList, error)
	// Does the authenticated user have all of the requested permissions for the resource
	// identified by the given URL?
	// Required permissions:
	// - None
	HasPermissions(context.Context, *HasPermissionsRequest) (*v1.YesOrNo, error)
	// List all known permissions.
	// Required permissions:
	// - None
	ListPermissions(context.Context, *v1.Empty) (*PermissionList, error)
}

func RegisterIAMServiceServer(s *grpc.Server, srv IAMServiceServer) {
	s.RegisterService(&_IAMService_serviceDesc, srv)
}

func _IAMService_GetThisUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetThisUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetThisUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetThisUser(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetUser(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListGroups(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetGroup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/CreateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).CreateGroup(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).UpdateGroup(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteGroup(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListGroupMembers(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_AddGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).AddGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/AddGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).AddGroupMembers(ctx, req.(*GroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteGroupMembers(ctx, req.(*GroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_IsMemberOfGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsMemberOfGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).IsMemberOfGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/IsMemberOfGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).IsMemberOfGroup(ctx, req.(*IsMemberOfGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListRoles(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetRole(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_CreateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Role)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).CreateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/CreateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).CreateRole(ctx, req.(*Role))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_UpdateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Role)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).UpdateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/UpdateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).UpdateRole(ctx, req.(*Role))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Role)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteRole(ctx, req.(*Role))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.URLOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetPolicy(ctx, req.(*v1.URLOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_AddRoleBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RoleBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).AddRoleBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/AddRoleBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).AddRoleBindings(ctx, req.(*RoleBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteRoleBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RoleBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteRoleBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteRoleBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteRoleBindings(ctx, req.(*RoleBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetEffectivePermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.URLOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetEffectivePermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetEffectivePermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetEffectivePermissions(ctx, req.(*v1.URLOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_HasPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).HasPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/HasPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).HasPermissions(ctx, req.(*HasPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListPermissions(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _IAMService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.iam.v1.IAMService",
	HandlerType: (*IAMServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetThisUser",
			Handler:    _IAMService_GetThisUser_Handler,
		},
		{
			MethodName: "GetUser",
			Handler:    _IAMService_GetUser_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _IAMService_ListGroups_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _IAMService_GetGroup_Handler,
		},
		{
			MethodName: "CreateGroup",
			Handler:    _IAMService_CreateGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _IAMService_UpdateGroup_Handler,
		},
		{
			MethodName: "DeleteGroup",
			Handler:    _IAMService_DeleteGroup_Handler,
		},
		{
			MethodName: "ListGroupMembers",
			Handler:    _IAMService_ListGroupMembers_Handler,
		},
		{
			MethodName: "AddGroupMembers",
			Handler:    _IAMService_AddGroupMembers_Handler,
		},
		{
			MethodName: "DeleteGroupMembers",
			Handler:    _IAMService_DeleteGroupMembers_Handler,
		},
		{
			MethodName: "IsMemberOfGroup",
			Handler:    _IAMService_IsMemberOfGroup_Handler,
		},
		{
			MethodName: "ListRoles",
			Handler:    _IAMService_ListRoles_Handler,
		},
		{
			MethodName: "GetRole",
			Handler:    _IAMService_GetRole_Handler,
		},
		{
			MethodName: "CreateRole",
			Handler:    _IAMService_CreateRole_Handler,
		},
		{
			MethodName: "UpdateRole",
			Handler:    _IAMService_UpdateRole_Handler,
		},
		{
			MethodName: "DeleteRole",
			Handler:    _IAMService_DeleteRole_Handler,
		},
		{
			MethodName: "GetPolicy",
			Handler:    _IAMService_GetPolicy_Handler,
		},
		{
			MethodName: "AddRoleBindings",
			Handler:    _IAMService_AddRoleBindings_Handler,
		},
		{
			MethodName: "DeleteRoleBindings",
			Handler:    _IAMService_DeleteRoleBindings_Handler,
		},
		{
			MethodName: "GetEffectivePermissions",
			Handler:    _IAMService_GetEffectivePermissions_Handler,
		},
		{
			MethodName: "HasPermissions",
			Handler:    _IAMService_HasPermissions_Handler,
		},
		{
			MethodName: "ListPermissions",
			Handler:    _IAMService_ListPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "iam.proto",
}

func (m *User) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *User) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Email) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Email)))
		i += copy(dAtA[i:], m.Email)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.GivenName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.GivenName)))
		i += copy(dAtA[i:], m.GivenName)
	}
	if len(m.FamilyName) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.FamilyName)))
		i += copy(dAtA[i:], m.FamilyName)
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintIam(dAtA, i, uint64(m.CreatedAt.Size()))
		n1, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Group) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Group) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintIam(dAtA, i, uint64(m.CreatedAt.Size()))
		n2, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GroupList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintIam(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *IsMemberOfGroupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsMemberOfGroupRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UserId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.UserId)))
		i += copy(dAtA[i:], m.UserId)
	}
	if len(m.GroupId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.GroupId)))
		i += copy(dAtA[i:], m.GroupId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GroupMemberList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMemberList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GroupMembersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMembersRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.GroupId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.GroupId)))
		i += copy(dAtA[i:], m.GroupId)
	}
	if len(m.UserIds) > 0 {
		for _, s := range m.UserIds {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PermissionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PermissionList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HasPermissionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HasPermissionsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Url) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Role) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Role) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.IsPredefined {
		dAtA[i] = 0x30
		i++
		if m.IsPredefined {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintIam(dAtA, i, uint64(m.CreatedAt.Size()))
		n3, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintIam(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleBinding) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.MemberId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.MemberId)))
		i += copy(dAtA[i:], m.MemberId)
	}
	if len(m.RoleId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.RoleId)))
		i += copy(dAtA[i:], m.RoleId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResourceUrl) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.ResourceUrl)))
		i += copy(dAtA[i:], m.ResourceUrl)
	}
	if len(m.Bindings) > 0 {
		for _, msg := range m.Bindings {
			dAtA[i] = 0x12
			i++
			i = encodeVarintIam(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleBindingsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleBindingsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResourceUrl) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.ResourceUrl)))
		i += copy(dAtA[i:], m.ResourceUrl)
	}
	if len(m.Bindings) > 0 {
		for _, msg := range m.Bindings {
			dAtA[i] = 0x12
			i++
			i = encodeVarintIam(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintIam(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *User) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Email)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.GivenName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.FamilyName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Group) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IsMemberOfGroupRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.GroupId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMemberList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMembersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.UserIds) > 0 {
		for _, s := range m.UserIds {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PermissionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HasPermissionsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Role) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.IsPredefined {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleBinding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.MemberId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.RoleId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Policy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResourceUrl)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Bindings) > 0 {
		for _, e := range m.Bindings {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleBindingsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResourceUrl)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Bindings) > 0 {
		for _, e := range m.Bindings {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovIam(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozIam(x uint64) (n int) {
	return sovIam(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *User) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: User: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: User: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Email", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Email = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GivenName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GivenName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FamilyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FamilyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Group) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Group: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Group: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Group{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsMemberOfGroupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsMemberOfGroupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsMemberOfGroupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupMemberList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMemberList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMemberList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupMembersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMembersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMembersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserIds = append(m.UserIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PermissionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PermissionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PermissionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HasPermissionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HasPermissionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HasPermissionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = append(m.Permissions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Role) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Role: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Role: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = append(m.Permissions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsPredefined", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsPredefined = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Role{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleBinding) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleBinding: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleBinding: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoleId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RoleId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bindings = append(m.Bindings, &RoleBinding{})
			if err := m.Bindings[len(m.Bindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleBindingsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleBindingsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleBindingsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bindings = append(m.Bindings, &RoleBinding{})
			if err := m.Bindings[len(m.Bindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipIam(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowIam
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIam
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIam
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthIam
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowIam
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipIam(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthIam = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowIam   = fmt.Errorf("proto: integer overflow")
)
