// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: resourcemanager.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An Organization is represents a real world organization such as a company.
type Organization struct {
	// System identifier of the organization.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the organization
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the organization
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Set when this organization is deleted
	IsDeleted bool `protobuf:"varint,5,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// The creation timestamp of the organization
	CreatedAt *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the organization
	DeletedAt            *types.Timestamp `protobuf:"bytes,7,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Organization) Reset()         { *m = Organization{} }
func (m *Organization) String() string { return proto.CompactTextString(m) }
func (*Organization) ProtoMessage()    {}
func (*Organization) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{0}
}
func (m *Organization) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Organization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Organization.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Organization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Organization.Merge(m, src)
}
func (m *Organization) XXX_Size() int {
	return m.Size()
}
func (m *Organization) XXX_DiscardUnknown() {
	xxx_messageInfo_Organization.DiscardUnknown(m)
}

var xxx_messageInfo_Organization proto.InternalMessageInfo

func (m *Organization) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Organization) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Organization) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Organization) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Organization) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Organization) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Organization) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

// List of organizations.
type OrganizationList struct {
	Items                []*Organization `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *OrganizationList) Reset()         { *m = OrganizationList{} }
func (m *OrganizationList) String() string { return proto.CompactTextString(m) }
func (*OrganizationList) ProtoMessage()    {}
func (*OrganizationList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{1}
}
func (m *OrganizationList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationList.Merge(m, src)
}
func (m *OrganizationList) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationList) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationList.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationList proto.InternalMessageInfo

func (m *OrganizationList) GetItems() []*Organization {
	if m != nil {
		return m.Items
	}
	return nil
}

// Member of an organization.
// A member is always a user.
type Member struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Set if this user is owner of the organization
	Owner                bool     `protobuf:"varint,2,opt,name=owner,proto3" json:"owner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Member) Reset()         { *m = Member{} }
func (m *Member) String() string { return proto.CompactTextString(m) }
func (*Member) ProtoMessage()    {}
func (*Member) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{2}
}
func (m *Member) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Member) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Member.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Member) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Member.Merge(m, src)
}
func (m *Member) XXX_Size() int {
	return m.Size()
}
func (m *Member) XXX_DiscardUnknown() {
	xxx_messageInfo_Member.DiscardUnknown(m)
}

var xxx_messageInfo_Member proto.InternalMessageInfo

func (m *Member) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *Member) GetOwner() bool {
	if m != nil {
		return m.Owner
	}
	return false
}

// List of Members.
type MemberList struct {
	Items                []*Member `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MemberList) Reset()         { *m = MemberList{} }
func (m *MemberList) String() string { return proto.CompactTextString(m) }
func (*MemberList) ProtoMessage()    {}
func (*MemberList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{3}
}
func (m *MemberList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemberList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemberList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemberList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemberList.Merge(m, src)
}
func (m *MemberList) XXX_Size() int {
	return m.Size()
}
func (m *MemberList) XXX_DiscardUnknown() {
	xxx_messageInfo_MemberList.DiscardUnknown(m)
}

var xxx_messageInfo_MemberList proto.InternalMessageInfo

func (m *MemberList) GetItems() []*Member {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for IsMemberOfOrganization.
type IsMemberOfOrganizationRequest struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Identifier of the organization
	OrganizationId       string   `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsMemberOfOrganizationRequest) Reset()         { *m = IsMemberOfOrganizationRequest{} }
func (m *IsMemberOfOrganizationRequest) String() string { return proto.CompactTextString(m) }
func (*IsMemberOfOrganizationRequest) ProtoMessage()    {}
func (*IsMemberOfOrganizationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{4}
}
func (m *IsMemberOfOrganizationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsMemberOfOrganizationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsMemberOfOrganizationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsMemberOfOrganizationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsMemberOfOrganizationRequest.Merge(m, src)
}
func (m *IsMemberOfOrganizationRequest) XXX_Size() int {
	return m.Size()
}
func (m *IsMemberOfOrganizationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsMemberOfOrganizationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsMemberOfOrganizationRequest proto.InternalMessageInfo

func (m *IsMemberOfOrganizationRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *IsMemberOfOrganizationRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

// Request arguments for Add/DeleteOrganizationMembers.
type OrganizationMembersRequest struct {
	// Identifier of the organization to add/remove a user from
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Users to add/remove.
	// For every user, an owner flag is provided as well.
	// If you add an existing user, the owner flag or the add request
	// will overwrite the value of the existing owner flag.
	Members              *MemberList `protobuf:"bytes,2,opt,name=members,proto3" json:"members,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *OrganizationMembersRequest) Reset()         { *m = OrganizationMembersRequest{} }
func (m *OrganizationMembersRequest) String() string { return proto.CompactTextString(m) }
func (*OrganizationMembersRequest) ProtoMessage()    {}
func (*OrganizationMembersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{5}
}
func (m *OrganizationMembersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationMembersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationMembersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationMembersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationMembersRequest.Merge(m, src)
}
func (m *OrganizationMembersRequest) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationMembersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationMembersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationMembersRequest proto.InternalMessageInfo

func (m *OrganizationMembersRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *OrganizationMembersRequest) GetMembers() *MemberList {
	if m != nil {
		return m.Members
	}
	return nil
}

// A Project is represents a unit within an organization such as a department.
type Project struct {
	// System identifier of the project.
	// This is a read-only value.
	// It can be set when creating the project.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the project
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the project
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the organization that owns this project.
	// This is a read-only value.
	OrganizationId string `protobuf:"bytes,5,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Set when this project is deleted
	IsDeleted bool `protobuf:"varint,6,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// The creation timestamp of the project
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the project
	DeletedAt            *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Project) Reset()         { *m = Project{} }
func (m *Project) String() string { return proto.CompactTextString(m) }
func (*Project) ProtoMessage()    {}
func (*Project) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{6}
}
func (m *Project) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Project) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Project.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Project) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Project.Merge(m, src)
}
func (m *Project) XXX_Size() int {
	return m.Size()
}
func (m *Project) XXX_DiscardUnknown() {
	xxx_messageInfo_Project.DiscardUnknown(m)
}

var xxx_messageInfo_Project proto.InternalMessageInfo

func (m *Project) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Project) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Project) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Project) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Project) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Project) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Project) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Project) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

// List of Projects.
type ProjectList struct {
	Items                []*Project `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ProjectList) Reset()         { *m = ProjectList{} }
func (m *ProjectList) String() string { return proto.CompactTextString(m) }
func (*ProjectList) ProtoMessage()    {}
func (*ProjectList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{7}
}
func (m *ProjectList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProjectList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProjectList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProjectList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProjectList.Merge(m, src)
}
func (m *ProjectList) XXX_Size() int {
	return m.Size()
}
func (m *ProjectList) XXX_DiscardUnknown() {
	xxx_messageInfo_ProjectList.DiscardUnknown(m)
}

var xxx_messageInfo_ProjectList proto.InternalMessageInfo

func (m *ProjectList) GetItems() []*Project {
	if m != nil {
		return m.Items
	}
	return nil
}

func init() {
	proto.RegisterType((*Organization)(nil), "arangodb.cloud.resourcemanager.v1.Organization")
	proto.RegisterType((*OrganizationList)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationList")
	proto.RegisterType((*Member)(nil), "arangodb.cloud.resourcemanager.v1.Member")
	proto.RegisterType((*MemberList)(nil), "arangodb.cloud.resourcemanager.v1.MemberList")
	proto.RegisterType((*IsMemberOfOrganizationRequest)(nil), "arangodb.cloud.resourcemanager.v1.IsMemberOfOrganizationRequest")
	proto.RegisterType((*OrganizationMembersRequest)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationMembersRequest")
	proto.RegisterType((*Project)(nil), "arangodb.cloud.resourcemanager.v1.Project")
	proto.RegisterType((*ProjectList)(nil), "arangodb.cloud.resourcemanager.v1.ProjectList")
}

func init() { proto.RegisterFile("resourcemanager.proto", fileDescriptor_81de387952a6887e) }

var fileDescriptor_81de387952a6887e = []byte{
	// 959 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x97, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xc0, 0x19, 0xa7, 0xb1, 0x93, 0xe7, 0xa6, 0x2d, 0x03, 0xa4, 0xc6, 0xa2, 0xc1, 0x5d, 0x54,
	0x35, 0x58, 0x64, 0x97, 0x38, 0x42, 0x88, 0x96, 0xaa, 0x49, 0x9b, 0x28, 0x32, 0x25, 0x18, 0x0c,
	0x1c, 0xca, 0xc5, 0x5a, 0xef, 0x4c, 0x96, 0x45, 0xde, 0x9d, 0x65, 0x67, 0x6c, 0x28, 0x55, 0x2e,
	0x5c, 0x8b, 0xb8, 0x70, 0xe1, 0xcf, 0x81, 0x03, 0x17, 0x84, 0xc4, 0x09, 0x3e, 0x02, 0x12, 0x1c,
	0x2b, 0xf1, 0x05, 0x50, 0xe0, 0x5b, 0x70, 0x41, 0x33, 0xb3, 0x5b, 0x76, 0x8d, 0x5d, 0xef, 0xba,
	0xb4, 0xb7, 0xf1, 0xec, 0xfb, 0xf3, 0x7b, 0x6f, 0xde, 0xbc, 0x37, 0x86, 0xa7, 0x22, 0xca, 0xd9,
	0x30, 0x72, 0xa8, 0x6f, 0x07, 0xb6, 0x4b, 0x23, 0x33, 0x8c, 0x98, 0x60, 0xf8, 0xbc, 0x1d, 0xd9,
	0x81, 0xcb, 0x48, 0xdf, 0x74, 0x06, 0x6c, 0x48, 0xcc, 0x71, 0xa9, 0xd1, 0x66, 0x7d, 0xd5, 0x61,
	0xbe, 0xcf, 0x02, 0x6b, 0xb4, 0x69, 0xe9, 0x95, 0x56, 0xad, 0x5f, 0x76, 0x3d, 0xf1, 0xfe, 0xb0,
	0x6f, 0x3a, 0xcc, 0xb7, 0x5c, 0x36, 0xb0, 0x03, 0xd7, 0x52, 0x1f, 0xfa, 0xc3, 0x43, 0x2b, 0x14,
	0xb7, 0x42, 0xca, 0x2d, 0xe1, 0xf9, 0x94, 0x0b, 0xdb, 0x0f, 0xff, 0x5d, 0xc5, 0xca, 0xcf, 0xb8,
	0x8c, 0xb9, 0x03, 0x6a, 0xd9, 0xa1, 0x67, 0xd9, 0x41, 0xc0, 0x84, 0x2d, 0x3c, 0x16, 0x70, 0xfd,
	0xd5, 0xf8, 0x1b, 0xc1, 0xc9, 0x4e, 0xe4, 0xda, 0x81, 0xf7, 0x89, 0xda, 0xc7, 0xa7, 0xa0, 0xe4,
	0x91, 0x1a, 0x6a, 0xa0, 0xf5, 0xe5, 0x6e, 0xc9, 0x23, 0xf8, 0x0c, 0x2c, 0x0c, 0xa3, 0x41, 0xad,
	0xa4, 0x36, 0xe4, 0x12, 0x63, 0x38, 0x11, 0xd8, 0x3e, 0xad, 0x2d, 0xa8, 0x2d, 0xb5, 0xc6, 0x0d,
	0xa8, 0x12, 0xca, 0x9d, 0xc8, 0x0b, 0xa5, 0x91, 0xda, 0x09, 0xf5, 0x29, 0xbd, 0x85, 0xcf, 0x01,
	0x78, 0xbc, 0x47, 0xe8, 0x80, 0x0a, 0x4a, 0x6a, 0x8b, 0x0d, 0xb4, 0xbe, 0xd4, 0x5d, 0xf6, 0xf8,
	0xae, 0xde, 0xc0, 0xaf, 0x00, 0x38, 0x11, 0xb5, 0x05, 0x25, 0x3d, 0x5b, 0xd4, 0xca, 0x0d, 0xb4,
	0x5e, 0x6d, 0xd5, 0x4d, 0x8d, 0x6e, 0x26, 0xc1, 0x9a, 0xef, 0x24, 0xb1, 0x75, 0x97, 0x63, 0xe9,
	0x1d, 0x21, 0x55, 0x63, 0xb3, 0x52, 0xb5, 0x32, 0x5b, 0x35, 0x96, 0xde, 0x11, 0xc6, 0x4d, 0x38,
	0x93, 0x0e, 0xfe, 0x75, 0x8f, 0x0b, 0xbc, 0x07, 0x8b, 0x9e, 0xa0, 0x3e, 0xaf, 0xa1, 0xc6, 0xc2,
	0x7a, 0xb5, 0x65, 0x99, 0x33, 0xcf, 0xcd, 0x4c, 0xdb, 0xe8, 0x6a, 0x6d, 0xe3, 0x65, 0x28, 0x1f,
	0x50, 0xbf, 0x4f, 0x23, 0x7c, 0x16, 0x2a, 0x43, 0x4e, 0xa3, 0xde, 0xbd, 0xb4, 0x96, 0xe5, 0xcf,
	0x36, 0xc1, 0x4f, 0xc2, 0x22, 0xfb, 0x28, 0xa0, 0x91, 0x4a, 0xee, 0x52, 0x57, 0xff, 0x30, 0x0e,
	0x00, 0xb4, 0xa2, 0xa2, 0xb9, 0x9a, 0xa5, 0x79, 0x3e, 0x07, 0x8d, 0xd6, 0x4e, 0x38, 0x6c, 0x38,
	0xd7, 0xe6, 0x7a, 0xab, 0x73, 0x98, 0x01, 0xa5, 0x1f, 0x0e, 0x29, 0x17, 0xd3, 0xf1, 0x2e, 0xc2,
	0x69, 0x96, 0x92, 0x97, 0x02, 0xba, 0x0a, 0x4e, 0xa5, 0xb7, 0xdb, 0xc4, 0xf8, 0x1c, 0x41, 0x3d,
	0x6d, 0x59, 0x7b, 0xe3, 0x89, 0x83, 0x09, 0x76, 0xd0, 0x24, 0x3b, 0x78, 0x1f, 0x2a, 0xbe, 0x56,
	0x55, 0x8e, 0xaa, 0xad, 0x8d, 0xdc, 0xd1, 0xca, 0x5c, 0x75, 0x13, 0x6d, 0xe3, 0xdb, 0x12, 0x54,
	0xde, 0x8c, 0xd8, 0x07, 0xd4, 0x11, 0x0f, 0xad, 0x9e, 0x27, 0x44, 0xb5, 0x38, 0x31, 0xaa, 0x6c,
	0xe1, 0x97, 0xef, 0x5f, 0xf8, 0x95, 0xf9, 0x0b, 0x7f, 0xa9, 0x48, 0xe1, 0x77, 0xa0, 0x1a, 0x27,
	0x48, 0x55, 0xd9, 0x76, 0xb6, 0xca, 0x9a, 0x39, 0xf2, 0x1e, 0xab, 0xc7, 0x65, 0xd6, 0xba, 0xf3,
	0x04, 0xac, 0x76, 0x63, 0xa9, 0x03, 0x2d, 0xf5, 0x36, 0x8d, 0x46, 0x9e, 0x43, 0xf1, 0x77, 0x08,
	0x1e, 0x97, 0x5e, 0xd2, 0x25, 0xc2, 0xf1, 0x85, 0x71, 0x1f, 0x71, 0xc7, 0x1b, 0x6d, 0x9a, 0x4a,
	0x58, 0x65, 0x99, 0xd7, 0xb7, 0x0a, 0x5e, 0x3f, 0xa9, 0x6b, 0xb4, 0x3e, 0xfd, 0xfd, 0xaf, 0x2f,
	0x4a, 0x2f, 0xe0, 0xa6, 0x6a, 0x7a, 0x63, 0x1a, 0xb2, 0xbb, 0x72, 0x3a, 0x38, 0xb4, 0x58, 0x86,
	0xe7, 0x1b, 0x04, 0xa7, 0xf7, 0x69, 0x06, 0x12, 0x3f, 0x37, 0x9d, 0xb1, 0xbd, 0x9b, 0x10, 0x16,
	0x6d, 0x10, 0xb3, 0xe9, 0x32, 0x60, 0xd6, 0x6d, 0x8f, 0x1c, 0xe1, 0xef, 0x11, 0xe0, 0xeb, 0xea,
	0xe0, 0x33, 0x80, 0x45, 0x7d, 0x17, 0x87, 0x7d, 0x51, 0xc1, 0x36, 0x8d, 0x0b, 0xb9, 0x60, 0x2f,
	0xa1, 0x26, 0xfe, 0x11, 0x01, 0x7e, 0x37, 0x24, 0x8f, 0x1e, 0xf5, 0x25, 0x85, 0x6a, 0xb5, 0x0a,
	0xe4, 0x55, 0xf2, 0x7e, 0x8d, 0x00, 0xeb, 0xcb, 0xf8, 0x60, 0xbc, 0xcf, 0x4e, 0x2f, 0x96, 0x3d,
	0x3f, 0x14, 0xb7, 0x92, 0x73, 0x6f, 0x16, 0x39, 0xf7, 0x9f, 0x10, 0x9c, 0x1d, 0xbf, 0x3b, 0x71,
	0x7b, 0xcd, 0x7b, 0x83, 0x8a, 0x35, 0x51, 0xe3, 0x9a, 0xa2, 0x7c, 0x15, 0x5f, 0xca, 0x49, 0xe9,
	0xb0, 0x40, 0xd0, 0x8f, 0x45, 0xcf, 0x23, 0x47, 0x56, 0xdc, 0x7f, 0xf1, 0x2f, 0x08, 0x56, 0x77,
	0x08, 0x99, 0x04, 0x7d, 0xa5, 0x60, 0x5a, 0xb3, 0xb3, 0x64, 0x76, 0x92, 0x5f, 0x53, 0xf8, 0xbb,
	0xc6, 0xd5, 0x9c, 0xf8, 0x63, 0x3d, 0xfc, 0x5e, 0x0c, 0xb2, 0x32, 0x7e, 0x45, 0xf0, 0xf4, 0x7f,
	0x2b, 0xe3, 0x11, 0x47, 0xd2, 0xfc, 0x3f, 0x22, 0xb9, 0x8b, 0x60, 0x75, 0xf2, 0x2b, 0x00, 0x6f,
	0xe7, 0x08, 0xe3, 0xbe, 0x0f, 0x88, 0xfa, 0xf9, 0xe9, 0x91, 0xdc, 0xa4, 0xbc, 0x13, 0xbd, 0xc1,
	0x8c, 0xb7, 0x54, 0x2c, 0x37, 0x70, 0xfb, 0x01, 0x63, 0xb1, 0x6e, 0xc7, 0x4f, 0x95, 0x23, 0xfc,
	0x03, 0x82, 0x93, 0xb2, 0x60, 0xe3, 0x39, 0x94, 0xfb, 0x3a, 0x98, 0xf9, 0x67, 0x9b, 0xba, 0x0f,
	0xd7, 0x15, 0xfa, 0x15, 0x7c, 0x79, 0x8e, 0xfb, 0x10, 0x26, 0x6c, 0x9f, 0x21, 0x80, 0x7d, 0x9a,
	0xb0, 0xe6, 0x9b, 0x2b, 0x05, 0x86, 0xb0, 0xb1, 0xa1, 0x20, 0x2f, 0xe2, 0xa9, 0x5d, 0x3a, 0x21,
	0xd1, 0x5d, 0xe5, 0x67, 0x04, 0x2b, 0x7a, 0x9a, 0x24, 0x44, 0x05, 0x9c, 0x15, 0x02, 0xbb, 0xa1,
	0xc0, 0xf6, 0x8c, 0xed, 0x79, 0x0f, 0x3e, 0x01, 0x97, 0x55, 0xfc, 0x15, 0x82, 0x15, 0x3d, 0x59,
	0x1e, 0x36, 0x76, 0x3c, 0xf5, 0x5a, 0xf9, 0xf2, 0x29, 0xd9, 0xee, 0x20, 0x58, 0xd1, 0xbd, 0x62,
	0x1e, 0xb6, 0x99, 0xcd, 0x20, 0x3e, 0xe0, 0x66, 0x3e, 0xa0, 0x6b, 0x7b, 0xbf, 0x1d, 0xaf, 0xa1,
	0xbb, 0xc7, 0x6b, 0xe8, 0x8f, 0xe3, 0x35, 0xf4, 0xe5, 0x9f, 0x6b, 0x8f, 0xbd, 0xb7, 0x95, 0xfa,
	0x0b, 0x99, 0xf8, 0xda, 0xd0, 0xfa, 0x44, 0xda, 0xe4, 0x13, 0x8c, 0xf6, 0xcb, 0xea, 0x11, 0xb9,
	0xf5, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xaf, 0x99, 0x87, 0xc8, 0xd2, 0x0e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ResourceManagerServiceClient is the client API for ResourceManagerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResourceManagerServiceClient interface {
	// Fetch all organizations that the authenticated user is a member of.
	// Required permissions:
	// - None
	ListOrganizations(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationList, error)
	// Fetch an organization by its id.
	// The authenticated user must be a member of the organization.
	// Required permissions:
	// - None
	GetOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Organization, error)
	// Create a new organization
	// Required permissions:
	// - None
	CreateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error)
	// Update an organization
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	UpdateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error)
	// Delete an organization
	// Note that organization are never really removed.
	// Instead their is_deleted field is set to true.
	// Required permissions:
	// - resourcemanager.organization.delete on the organization
	DeleteOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*v1.Empty, error)
	// Get a list of members of the organization identified by the given context ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*MemberList, error)
	// Add one or more members to an organization.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	AddOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Remove one or more members from an organization.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	DeleteOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Is the user identified by the given user ID a member
	// of the organization identified by the given organization ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization, unless the requested user is identical to the authenticated user.
	// Note that if the identified user or organization does not exist, no is returned.
	IsMemberOfOrganization(ctx context.Context, in *IsMemberOfOrganizationRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error)
	// Fetch all projects in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.project.list on the organization identified by the given context ID
	ListProjects(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*ProjectList, error)
	// Fetch a project by its id.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.get on the project identified by the given ID
	GetProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Project, error)
	// Create a new project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.create on the organization that owns the project
	CreateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error)
	// Update a project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.update on the project
	UpdateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error)
	// Delete a project
	// Note that project are initially only marked for deleted.
	// Once all their resources are removed the project itself is deleted
	// and cannot be restored.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.delete on the project
	DeleteProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*v1.Empty, error)
}

type resourceManagerServiceClient struct {
	cc *grpc.ClientConn
}

func NewResourceManagerServiceClient(cc *grpc.ClientConn) ResourceManagerServiceClient {
	return &resourceManagerServiceClient{cc}
}

func (c *resourceManagerServiceClient) ListOrganizations(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationList, error) {
	out := new(OrganizationList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) CreateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) UpdateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListOrganizationMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*MemberList, error) {
	out := new(MemberList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) AddOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AddOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) IsMemberOfOrganization(ctx context.Context, in *IsMemberOfOrganizationRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error) {
	out := new(v1.YesOrNo)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/IsMemberOfOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListProjects(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*ProjectList, error) {
	out := new(ProjectList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) CreateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) UpdateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResourceManagerServiceServer is the server API for ResourceManagerService service.
type ResourceManagerServiceServer interface {
	// Fetch all organizations that the authenticated user is a member of.
	// Required permissions:
	// - None
	ListOrganizations(context.Context, *v1.ListOptions) (*OrganizationList, error)
	// Fetch an organization by its id.
	// The authenticated user must be a member of the organization.
	// Required permissions:
	// - None
	GetOrganization(context.Context, *v1.IDOptions) (*Organization, error)
	// Create a new organization
	// Required permissions:
	// - None
	CreateOrganization(context.Context, *Organization) (*Organization, error)
	// Update an organization
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	UpdateOrganization(context.Context, *Organization) (*Organization, error)
	// Delete an organization
	// Note that organization are never really removed.
	// Instead their is_deleted field is set to true.
	// Required permissions:
	// - resourcemanager.organization.delete on the organization
	DeleteOrganization(context.Context, *Organization) (*v1.Empty, error)
	// Get a list of members of the organization identified by the given context ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationMembers(context.Context, *v1.ListOptions) (*MemberList, error)
	// Add one or more members to an organization.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	AddOrganizationMembers(context.Context, *OrganizationMembersRequest) (*v1.Empty, error)
	// Remove one or more members from an organization.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	DeleteOrganizationMembers(context.Context, *OrganizationMembersRequest) (*v1.Empty, error)
	// Is the user identified by the given user ID a member
	// of the organization identified by the given organization ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization, unless the requested user is identical to the authenticated user.
	// Note that if the identified user or organization does not exist, no is returned.
	IsMemberOfOrganization(context.Context, *IsMemberOfOrganizationRequest) (*v1.YesOrNo, error)
	// Fetch all projects in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.project.list on the organization identified by the given context ID
	ListProjects(context.Context, *v1.ListOptions) (*ProjectList, error)
	// Fetch a project by its id.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.get on the project identified by the given ID
	GetProject(context.Context, *v1.IDOptions) (*Project, error)
	// Create a new project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.create on the organization that owns the project
	CreateProject(context.Context, *Project) (*Project, error)
	// Update a project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.update on the project
	UpdateProject(context.Context, *Project) (*Project, error)
	// Delete a project
	// Note that project are initially only marked for deleted.
	// Once all their resources are removed the project itself is deleted
	// and cannot be restored.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.delete on the project
	DeleteProject(context.Context, *Project) (*v1.Empty, error)
}

func RegisterResourceManagerServiceServer(s *grpc.Server, srv ResourceManagerServiceServer) {
	s.RegisterService(&_ResourceManagerService_serviceDesc, srv)
}

func _ResourceManagerService_ListOrganizations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizations(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetOrganization(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_CreateOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Organization)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).CreateOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).CreateOrganization(ctx, req.(*Organization))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_UpdateOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Organization)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).UpdateOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).UpdateOrganization(ctx, req.(*Organization))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Organization)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteOrganization(ctx, req.(*Organization))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizationMembers(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_AddOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).AddOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AddOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).AddOrganizationMembers(ctx, req.(*OrganizationMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationMembers(ctx, req.(*OrganizationMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_IsMemberOfOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsMemberOfOrganizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).IsMemberOfOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/IsMemberOfOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).IsMemberOfOrganization(ctx, req.(*IsMemberOfOrganizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListProjects(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetProject(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_CreateProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Project)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).CreateProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).CreateProject(ctx, req.(*Project))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_UpdateProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Project)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).UpdateProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).UpdateProject(ctx, req.(*Project))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Project)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteProject(ctx, req.(*Project))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResourceManagerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.resourcemanager.v1.ResourceManagerService",
	HandlerType: (*ResourceManagerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListOrganizations",
			Handler:    _ResourceManagerService_ListOrganizations_Handler,
		},
		{
			MethodName: "GetOrganization",
			Handler:    _ResourceManagerService_GetOrganization_Handler,
		},
		{
			MethodName: "CreateOrganization",
			Handler:    _ResourceManagerService_CreateOrganization_Handler,
		},
		{
			MethodName: "UpdateOrganization",
			Handler:    _ResourceManagerService_UpdateOrganization_Handler,
		},
		{
			MethodName: "DeleteOrganization",
			Handler:    _ResourceManagerService_DeleteOrganization_Handler,
		},
		{
			MethodName: "ListOrganizationMembers",
			Handler:    _ResourceManagerService_ListOrganizationMembers_Handler,
		},
		{
			MethodName: "AddOrganizationMembers",
			Handler:    _ResourceManagerService_AddOrganizationMembers_Handler,
		},
		{
			MethodName: "DeleteOrganizationMembers",
			Handler:    _ResourceManagerService_DeleteOrganizationMembers_Handler,
		},
		{
			MethodName: "IsMemberOfOrganization",
			Handler:    _ResourceManagerService_IsMemberOfOrganization_Handler,
		},
		{
			MethodName: "ListProjects",
			Handler:    _ResourceManagerService_ListProjects_Handler,
		},
		{
			MethodName: "GetProject",
			Handler:    _ResourceManagerService_GetProject_Handler,
		},
		{
			MethodName: "CreateProject",
			Handler:    _ResourceManagerService_CreateProject_Handler,
		},
		{
			MethodName: "UpdateProject",
			Handler:    _ResourceManagerService_UpdateProject_Handler,
		},
		{
			MethodName: "DeleteProject",
			Handler:    _ResourceManagerService_DeleteProject_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "resourcemanager.proto",
}

func (m *Organization) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Organization) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.IsDeleted {
		dAtA[i] = 0x28
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.CreatedAt.Size()))
		n1, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.DeletedAt.Size()))
		n2, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OrganizationList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Member) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Member) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UserId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.UserId)))
		i += copy(dAtA[i:], m.UserId)
	}
	if m.Owner {
		dAtA[i] = 0x10
		i++
		if m.Owner {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MemberList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemberList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *IsMemberOfOrganizationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsMemberOfOrganizationRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UserId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.UserId)))
		i += copy(dAtA[i:], m.UserId)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OrganizationMembersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationMembersRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if m.Members != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Members.Size()))
		n3, err := m.Members.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Project) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Project) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if m.IsDeleted {
		dAtA[i] = 0x30
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.CreatedAt.Size()))
		n4, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.DeletedAt.Size()))
		n5, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ProjectList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProjectList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintResourcemanager(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Organization) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Member) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Owner {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MemberList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IsMemberOfOrganizationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationMembersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Members != nil {
		l = m.Members.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Project) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProjectList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovResourcemanager(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozResourcemanager(x uint64) (n int) {
	return sovResourcemanager(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Organization) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Organization: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Organization: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Organization{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Member) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Member: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Member: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Owner = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemberList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemberList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemberList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Member{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsMemberOfOrganizationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsMemberOfOrganizationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsMemberOfOrganizationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationMembersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationMembersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationMembersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Members", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Members == nil {
				m.Members = &MemberList{}
			}
			if err := m.Members.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Project) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Project: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Project: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProjectList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProjectList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProjectList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Project{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipResourcemanager(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthResourcemanager
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowResourcemanager
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipResourcemanager(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthResourcemanager = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowResourcemanager   = fmt.Errorf("proto: integer overflow")
)
