// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: crypto.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A CACertificate is represents a self-signed certificate authority used to sign
// TLS certificates for deployments & client authentication.
type CACertificate struct {
	// System identifier of the CA certificate.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the CA certificate
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the CA certificate
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that owns this CA certificate.
	// This value cannot be changed after creation.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Time from creation of the CA certificate to expiration.
	// This value cannot be changed after creation.
	Lifetime *types.Duration `protobuf:"bytes,6,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// The creation timestamp of the CA certificate
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the CA certificate
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// The expiration timestamp of the CA certificate
	// This is a read-only value.
	ExpiresAt *types.Timestamp `protobuf:"bytes,9,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// A PEM encoded representation of the public key of the CA certificate.
	// This is a read-only value.
	CertificatePem string `protobuf:"bytes,10,opt,name=certificate_pem,json=certificatePem,proto3" json:"certificate_pem,omitempty"`
	// Set when this CA certificate is deleted.
	// This is a read-only value.
	IsDeleted            bool     `protobuf:"varint,11,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CACertificate) Reset()         { *m = CACertificate{} }
func (m *CACertificate) String() string { return proto.CompactTextString(m) }
func (*CACertificate) ProtoMessage()    {}
func (*CACertificate) Descriptor() ([]byte, []int) {
	return fileDescriptor_527278fb02d03321, []int{0}
}
func (m *CACertificate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CACertificate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CACertificate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CACertificate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CACertificate.Merge(m, src)
}
func (m *CACertificate) XXX_Size() int {
	return m.Size()
}
func (m *CACertificate) XXX_DiscardUnknown() {
	xxx_messageInfo_CACertificate.DiscardUnknown(m)
}

var xxx_messageInfo_CACertificate proto.InternalMessageInfo

func (m *CACertificate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CACertificate) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *CACertificate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CACertificate) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CACertificate) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CACertificate) GetLifetime() *types.Duration {
	if m != nil {
		return m.Lifetime
	}
	return nil
}

func (m *CACertificate) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *CACertificate) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *CACertificate) GetExpiresAt() *types.Timestamp {
	if m != nil {
		return m.ExpiresAt
	}
	return nil
}

func (m *CACertificate) GetCertificatePem() string {
	if m != nil {
		return m.CertificatePem
	}
	return ""
}

func (m *CACertificate) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

// List of CACertificates.
type CACertificateList struct {
	Items                []*CACertificate `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CACertificateList) Reset()         { *m = CACertificateList{} }
func (m *CACertificateList) String() string { return proto.CompactTextString(m) }
func (*CACertificateList) ProtoMessage()    {}
func (*CACertificateList) Descriptor() ([]byte, []int) {
	return fileDescriptor_527278fb02d03321, []int{1}
}
func (m *CACertificateList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CACertificateList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CACertificateList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CACertificateList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CACertificateList.Merge(m, src)
}
func (m *CACertificateList) XXX_Size() int {
	return m.Size()
}
func (m *CACertificateList) XXX_DiscardUnknown() {
	xxx_messageInfo_CACertificateList.DiscardUnknown(m)
}

var xxx_messageInfo_CACertificateList proto.InternalMessageInfo

func (m *CACertificateList) GetItems() []*CACertificate {
	if m != nil {
		return m.Items
	}
	return nil
}

func init() {
	proto.RegisterType((*CACertificate)(nil), "arangodb.cloud.crypto.v1.CACertificate")
	proto.RegisterType((*CACertificateList)(nil), "arangodb.cloud.crypto.v1.CACertificateList")
}

func init() { proto.RegisterFile("crypto.proto", fileDescriptor_527278fb02d03321) }

var fileDescriptor_527278fb02d03321 = []byte{
	// 639 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x54, 0x41, 0x6b, 0x13, 0x41,
	0x14, 0x76, 0x92, 0xb6, 0x36, 0x13, 0x5b, 0xeb, 0x14, 0x64, 0x0d, 0x1a, 0x43, 0x54, 0x1a, 0x22,
	0xdd, 0xa5, 0x29, 0x05, 0x6b, 0x55, 0xa8, 0xa9, 0x48, 0x41, 0x50, 0xa2, 0x5e, 0xbc, 0x84, 0xc9,
	0xcc, 0x74, 0x1d, 0xd9, 0xdd, 0x19, 0x76, 0x26, 0xa1, 0xa5, 0xf4, 0xe2, 0xc5, 0x8b, 0xb7, 0x82,
	0xf8, 0x07, 0xc4, 0x7f, 0xe0, 0x6f, 0xf0, 0x28, 0xf8, 0x07, 0xa4, 0xfa, 0x43, 0x64, 0x66, 0x37,
	0x4d, 0xb6, 0x25, 0x64, 0xf1, 0xe0, 0xed, 0xf1, 0xde, 0xf7, 0xbd, 0xf7, 0xed, 0xf7, 0xde, 0x0e,
	0xbc, 0x44, 0xe2, 0x03, 0xa9, 0x85, 0x2b, 0x63, 0xa1, 0x05, 0x72, 0x70, 0x8c, 0x23, 0x5f, 0xd0,
	0x9e, 0x4b, 0x02, 0xd1, 0xa7, 0x6e, 0x5a, 0x1c, 0xac, 0x55, 0xae, 0x12, 0x11, 0x86, 0x22, 0xf2,
	0x06, 0x6b, 0x5e, 0x12, 0x25, 0x8c, 0xca, 0xa6, 0xcf, 0xf5, 0xdb, 0x7e, 0xcf, 0x25, 0x22, 0xf4,
	0x7c, 0x11, 0xe0, 0xc8, 0xf7, 0x6c, 0xa1, 0xd7, 0xdf, 0xf3, 0xa4, 0x3e, 0x90, 0x4c, 0x79, 0xb4,
	0x1f, 0x63, 0xcd, 0x45, 0x74, 0x1a, 0xa4, 0xd4, 0xad, 0xe9, 0x54, 0xcd, 0x43, 0xa6, 0x34, 0x0e,
	0xe5, 0x28, 0x4a, 0xc9, 0xd7, 0x7d, 0x21, 0xfc, 0x80, 0x79, 0x58, 0x72, 0x0f, 0x47, 0x91, 0xd0,
	0xb6, 0xb3, 0x4a, 0xaa, 0xf5, 0x6f, 0x45, 0xb8, 0xd0, 0xde, 0x6e, 0xb3, 0x58, 0xf3, 0x3d, 0x4e,
	0xb0, 0x66, 0x68, 0x11, 0x16, 0x38, 0x75, 0x40, 0x0d, 0x34, 0x4a, 0x9d, 0x02, 0xa7, 0x68, 0x09,
	0x16, 0xfb, 0x71, 0xe0, 0x14, 0x6c, 0xc2, 0x84, 0x08, 0xc1, 0x99, 0x08, 0x87, 0xcc, 0x29, 0xda,
	0x94, 0x8d, 0x51, 0x0d, 0x96, 0x29, 0x53, 0x24, 0xe6, 0xd2, 0x74, 0x77, 0x66, 0x6c, 0x69, 0x3c,
	0x85, 0x6e, 0x40, 0x28, 0x63, 0xf1, 0x8e, 0x11, 0xdd, 0xe5, 0xd4, 0x99, 0xb5, 0x80, 0x52, 0x9a,
	0xd9, 0xa5, 0x68, 0x03, 0xce, 0x07, 0x7c, 0x8f, 0x19, 0xf5, 0xce, 0x5c, 0x0d, 0x34, 0xca, 0xad,
	0x6b, 0x6e, 0xa2, 0xdc, 0x1d, 0x7e, 0xab, 0xbb, 0x93, 0xda, 0xd2, 0x39, 0x85, 0xa2, 0x4d, 0x08,
	0x49, 0xcc, 0xb0, 0x66, 0xb4, 0x8b, 0xb5, 0x73, 0xd1, 0x12, 0x2b, 0xe7, 0x88, 0xaf, 0x86, 0x9e,
	0x74, 0x4a, 0x29, 0x7a, 0x5b, 0x1b, 0x2a, 0x65, 0x01, 0x4b, 0xa9, 0xf3, 0xd3, 0xa9, 0x29, 0x3a,
	0xa1, 0xb2, 0x7d, 0xc9, 0x63, 0xa6, 0x0c, 0xb5, 0x34, 0x9d, 0x9a, 0xa2, 0xb7, 0x35, 0x5a, 0x81,
	0x97, 0xc9, 0xc8, 0xed, 0xae, 0x64, 0xa1, 0x03, 0xad, 0x17, 0x8b, 0x63, 0xe9, 0x17, 0x2c, 0x34,
	0x7e, 0x71, 0xd5, 0x4d, 0x67, 0x3a, 0xe5, 0x1a, 0x68, 0xcc, 0x77, 0x4a, 0x5c, 0xed, 0x24, 0x89,
	0x7a, 0x07, 0x5e, 0xc9, 0xec, 0xed, 0x19, 0x57, 0x1a, 0x3d, 0x84, 0xb3, 0x5c, 0xb3, 0x50, 0x39,
	0xa0, 0x56, 0x6c, 0x94, 0x5b, 0x2b, 0xee, 0xa4, 0x2b, 0x75, 0x33, 0xdc, 0x4e, 0xc2, 0x6a, 0x1d,
	0xcf, 0xc1, 0x85, 0xb6, 0x85, 0xbc, 0x64, 0xf1, 0x80, 0x13, 0x86, 0xbe, 0x00, 0x88, 0x4c, 0xe7,
	0x0c, 0x5c, 0xa1, 0x3b, 0xe7, 0x1a, 0x27, 0x97, 0x3e, 0x58, 0x73, 0x0d, 0xfa, 0xb9, 0xdd, 0xb8,
	0xaa, 0xdc, 0xcd, 0x39, 0xdf, 0x70, 0xea, 0x5b, 0xef, 0x7f, 0xfe, 0x39, 0x2e, 0x6c, 0xa0, 0x75,
	0x7b, 0xa9, 0x09, 0xd2, 0xfc, 0x44, 0xe9, 0x89, 0x28, 0xef, 0x90, 0x88, 0x48, 0xb3, 0x7d, 0x73,
	0x3e, 0x47, 0x1e, 0xc1, 0x64, 0x5c, 0xd0, 0x47, 0x00, 0x97, 0x9e, 0xb2, 0xac, 0x4c, 0x74, 0x6b,
	0xb2, 0xca, 0xdd, 0x9d, 0xa1, 0xc6, 0xbc, 0x1e, 0xd5, 0x9b, 0x56, 0xdf, 0x6d, 0x54, 0x3f, 0xa3,
	0x2f, 0xab, 0xc4, 0x3b, 0xe4, 0xf4, 0x08, 0x7d, 0x05, 0x70, 0xb9, 0x6d, 0x0f, 0x2d, 0xab, 0x28,
	0xef, 0xb0, 0xfc, 0xaa, 0x1e, 0x59, 0x55, 0xf7, 0xea, 0x93, 0x5d, 0x1b, 0xfd, 0x74, 0x67, 0x5d,
	0xbb, 0x0f, 0x9a, 0xe8, 0x13, 0x80, 0xcb, 0xaf, 0x25, 0xfd, 0x0f, 0x4a, 0x57, 0xad, 0xd2, 0x95,
	0x56, 0x0e, 0xff, 0x8c, 0xb0, 0x0f, 0x00, 0x2e, 0x27, 0xb7, 0xfe, 0x0f, 0x4b, 0xbd, 0x39, 0x19,
	0xf4, 0x24, 0x94, 0xfa, 0x60, 0xb8, 0xcc, 0x66, 0x0e, 0x31, 0x8f, 0x1f, 0x7c, 0x3f, 0xa9, 0x82,
	0x1f, 0x27, 0x55, 0xf0, 0xeb, 0xa4, 0x0a, 0x3e, 0xff, 0xae, 0x5e, 0x78, 0xd3, 0x1c, 0x7b, 0x8f,
	0x87, 0x83, 0x56, 0x43, 0x1c, 0x61, 0x9f, 0x51, 0xd3, 0x50, 0x8d, 0x3a, 0xf6, 0xe6, 0xec, 0x73,
	0xb0, 0xfe, 0x37, 0x00, 0x00, 0xff, 0xff, 0x74, 0xe2, 0xb4, 0x77, 0x3f, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CryptoServiceClient is the client API for CryptoService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CryptoServiceClient interface {
	// Fetch all CA certificates in the project identified by the given context ID.
	// Required permissions:
	// - crypto.cacertificate.list on the project identified by the given context ID
	ListCACertificates(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*CACertificateList, error)
	// Fetch a CA certificate by its id.
	// Required permissions:
	// - crypto.cacertificate.get on the CA certificate identified by the given ID
	GetCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*CACertificate, error)
	// Create a new CA certificate
	// Required permissions:
	// - crypto.cacertificate.create on the project that owns the CA certificate
	CreateCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*CACertificate, error)
	// Update a CA certificate
	// Required permissions:
	// - crypto.cacertificate.update on the CA certificate
	UpdateCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*CACertificate, error)
	// Delete a CA certificate
	// Note that CA certificate are initially only marked for deleted.
	// Once all the resources that depend on it are removed the CA certificate itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - crypto.cacertificate.delete on the CA certificate
	DeleteCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
}

type cryptoServiceClient struct {
	cc *grpc.ClientConn
}

func NewCryptoServiceClient(cc *grpc.ClientConn) CryptoServiceClient {
	return &cryptoServiceClient{cc}
}

func (c *cryptoServiceClient) ListCACertificates(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*CACertificateList, error) {
	out := new(CACertificateList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/ListCACertificates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) GetCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*CACertificate, error) {
	out := new(CACertificate)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/GetCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) CreateCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*CACertificate, error) {
	out := new(CACertificate)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/CreateCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) UpdateCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*CACertificate, error) {
	out := new(CACertificate)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/UpdateCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) DeleteCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/DeleteCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CryptoServiceServer is the server API for CryptoService service.
type CryptoServiceServer interface {
	// Fetch all CA certificates in the project identified by the given context ID.
	// Required permissions:
	// - crypto.cacertificate.list on the project identified by the given context ID
	ListCACertificates(context.Context, *v1.ListOptions) (*CACertificateList, error)
	// Fetch a CA certificate by its id.
	// Required permissions:
	// - crypto.cacertificate.get on the CA certificate identified by the given ID
	GetCACertificate(context.Context, *v1.IDOptions) (*CACertificate, error)
	// Create a new CA certificate
	// Required permissions:
	// - crypto.cacertificate.create on the project that owns the CA certificate
	CreateCACertificate(context.Context, *CACertificate) (*CACertificate, error)
	// Update a CA certificate
	// Required permissions:
	// - crypto.cacertificate.update on the CA certificate
	UpdateCACertificate(context.Context, *CACertificate) (*CACertificate, error)
	// Delete a CA certificate
	// Note that CA certificate are initially only marked for deleted.
	// Once all the resources that depend on it are removed the CA certificate itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - crypto.cacertificate.delete on the CA certificate
	DeleteCACertificate(context.Context, *v1.IDOptions) (*v1.Empty, error)
}

func RegisterCryptoServiceServer(s *grpc.Server, srv CryptoServiceServer) {
	s.RegisterService(&_CryptoService_serviceDesc, srv)
}

func _CryptoService_ListCACertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).ListCACertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/ListCACertificates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).ListCACertificates(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_GetCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).GetCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/GetCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).GetCACertificate(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_CreateCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CACertificate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).CreateCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/CreateCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).CreateCACertificate(ctx, req.(*CACertificate))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_UpdateCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CACertificate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).UpdateCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/UpdateCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).UpdateCACertificate(ctx, req.(*CACertificate))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_DeleteCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).DeleteCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/DeleteCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).DeleteCACertificate(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _CryptoService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.crypto.v1.CryptoService",
	HandlerType: (*CryptoServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCACertificates",
			Handler:    _CryptoService_ListCACertificates_Handler,
		},
		{
			MethodName: "GetCACertificate",
			Handler:    _CryptoService_GetCACertificate_Handler,
		},
		{
			MethodName: "CreateCACertificate",
			Handler:    _CryptoService_CreateCACertificate_Handler,
		},
		{
			MethodName: "UpdateCACertificate",
			Handler:    _CryptoService_UpdateCACertificate_Handler,
		},
		{
			MethodName: "DeleteCACertificate",
			Handler:    _CryptoService_DeleteCACertificate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "crypto.proto",
}

func (m *CACertificate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CACertificate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.ProjectId) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.ProjectId)))
		i += copy(dAtA[i:], m.ProjectId)
	}
	if m.Lifetime != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(m.Lifetime.Size()))
		n1, err := m.Lifetime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(m.CreatedAt.Size()))
		n2, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(m.DeletedAt.Size()))
		n3, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ExpiresAt != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(m.ExpiresAt.Size()))
		n4, err := m.ExpiresAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.CertificatePem) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.CertificatePem)))
		i += copy(dAtA[i:], m.CertificatePem)
	}
	if m.IsDeleted {
		dAtA[i] = 0x58
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CACertificateList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CACertificateList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCrypto(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintCrypto(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *CACertificate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.Lifetime != nil {
		l = m.Lifetime.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.ExpiresAt != nil {
		l = m.ExpiresAt.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.CertificatePem)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CACertificateList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovCrypto(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCrypto(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCrypto(x uint64) (n int) {
	return sovCrypto(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CACertificate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CACertificate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CACertificate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lifetime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lifetime == nil {
				m.Lifetime = &types.Duration{}
			}
			if err := m.Lifetime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiresAt == nil {
				m.ExpiresAt = &types.Timestamp{}
			}
			if err := m.ExpiresAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertificatePem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertificatePem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCrypto(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CACertificateList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CACertificateList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CACertificateList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &CACertificate{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCrypto(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCrypto(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCrypto
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCrypto
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCrypto(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCrypto = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCrypto   = fmt.Errorf("proto: integer overflow")
)
