//
// This file is AUTO-GENERATED by protoc-gen-ts.
// Do not modify it manually.
///
import api from '../../api'
import * as googleTypes from '../../googleTypes'
import { IDOptions as arangodb_cloud_common_v1_IDOptions } from '../../common/v1/common'
import { ListOptions as arangodb_cloud_common_v1_ListOptions } from '../../common/v1/common'

// File: platform/v1/platform.proto
// Package: arangodb.cloud.platform.v1

// Provider represents a specific cloud provider such as AWS or GCP.
export interface Provider {
  // System identifier of the provider.
  // string
  id: string;
  
  // Name of the provider
  // string
  name: string;
}

// List of providers.
export interface ProviderList {
  // Provider
  items: Provider[];
}

// Region represents a geographical region in which deployments are run.
export interface Region {
  // System identifier of the region.
  // string
  id: string;
  
  // Identifier of the provider that hosts this region.
  // string
  provider_id: string;
  
  // Location of the region
  // string
  location: string;
  
  // Is this region available for creating new deployments?
  // boolean
  available: boolean;
}

// List of regions.
export interface RegionList {
  // Region
  items: Region[];
}

// PlatformService is the API used to query for cloud provider & regional info.
export class PlatformService {
  // Fetch all providers that are supported by the ArangoDB cloud.
  // Required permissions:
  // - None
  async ListProviders(req: arangodb_cloud_common_v1_ListOptions): Promise<ProviderList> {
    const path = `/api/platform/v1/providers`;
    const url = path + api.queryString(req, []);
    return api.get(url, undefined);
  }
  
  // Fetch a provider by its id.
  // Required permissions:
  // - None
  async GetProvider(req: arangodb_cloud_common_v1_IDOptions): Promise<Provider> {
    const path = `/api/platform/v1/providers/${encodeURIComponent(req.id)}`;
    const url = path + api.queryString(req, [`id`]);
    return api.get(url, undefined);
  }
  
  // Fetch all regions provided by the provided identified by the given context ID.
  // Required permissions:
  // - None
  async ListRegions(req: arangodb_cloud_common_v1_ListOptions): Promise<RegionList> {
    const path = `/api/platform/v1/providers/${encodeURIComponent(req.context_id)}/regions`;
    const url = path + api.queryString(req, [`context_id`]);
    return api.get(url, undefined);
  }
  
  // Fetch a region by its id.
  // Required permissions:
  // - None
  async GetRegion(req: arangodb_cloud_common_v1_IDOptions): Promise<Region> {
    const path = `/api/platform/v1/regions/${encodeURIComponent(req.id)}`;
    const url = path + api.queryString(req, [`id`]);
    return api.get(url, undefined);
  }
}
