// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: security.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// IPWhitelist represents a list of CIDR ranges from which a deployment is accessible.
type IPWhitelist struct {
	// System identifier of the whitelist.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the whitelist.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the whitelist.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that contains this whitelist.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// List of CIDR ranges.
	// Values must follow format as defined in RFC 4632 and RFC 4291.
	CidrRanges []string `protobuf:"bytes,5,rep,name=cidr_ranges,json=cidrRanges,proto3" json:"cidr_ranges,omitempty"`
	// The creation timestamp of this whitelist.
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the whitelist
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,7,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this whitelist is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,8,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the user who created this whitelist.
	// This is a read-only value.
	CreatedById          string   `protobuf:"bytes,9,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IPWhitelist) Reset()         { *m = IPWhitelist{} }
func (m *IPWhitelist) String() string { return proto.CompactTextString(m) }
func (*IPWhitelist) ProtoMessage()    {}
func (*IPWhitelist) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{0}
}
func (m *IPWhitelist) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPWhitelist) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPWhitelist.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPWhitelist) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPWhitelist.Merge(m, src)
}
func (m *IPWhitelist) XXX_Size() int {
	return m.Size()
}
func (m *IPWhitelist) XXX_DiscardUnknown() {
	xxx_messageInfo_IPWhitelist.DiscardUnknown(m)
}

var xxx_messageInfo_IPWhitelist proto.InternalMessageInfo

func (m *IPWhitelist) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *IPWhitelist) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IPWhitelist) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *IPWhitelist) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *IPWhitelist) GetCidrRanges() []string {
	if m != nil {
		return m.CidrRanges
	}
	return nil
}

func (m *IPWhitelist) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *IPWhitelist) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *IPWhitelist) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *IPWhitelist) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

// List of IP whitelists.
type IPWhitelistList struct {
	Items                []*IPWhitelist `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *IPWhitelistList) Reset()         { *m = IPWhitelistList{} }
func (m *IPWhitelistList) String() string { return proto.CompactTextString(m) }
func (*IPWhitelistList) ProtoMessage()    {}
func (*IPWhitelistList) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{1}
}
func (m *IPWhitelistList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPWhitelistList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPWhitelistList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPWhitelistList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPWhitelistList.Merge(m, src)
}
func (m *IPWhitelistList) XXX_Size() int {
	return m.Size()
}
func (m *IPWhitelistList) XXX_DiscardUnknown() {
	xxx_messageInfo_IPWhitelistList.DiscardUnknown(m)
}

var xxx_messageInfo_IPWhitelistList proto.InternalMessageInfo

func (m *IPWhitelistList) GetItems() []*IPWhitelist {
	if m != nil {
		return m.Items
	}
	return nil
}

func init() {
	proto.RegisterType((*IPWhitelist)(nil), "arangodb.cloud.security.v1.IPWhitelist")
	proto.RegisterType((*IPWhitelistList)(nil), "arangodb.cloud.security.v1.IPWhitelistList")
}

func init() { proto.RegisterFile("security.proto", fileDescriptor_55a487c716a8b59c) }

var fileDescriptor_55a487c716a8b59c = []byte{
	// 613 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x94, 0xcf, 0x6b, 0xd4, 0x40,
	0x14, 0xc7, 0x9d, 0xed, 0x0f, 0x9b, 0x59, 0x6d, 0xed, 0x1c, 0x24, 0x2c, 0xba, 0x0d, 0x51, 0xe9,
	0x52, 0x6d, 0x86, 0x5d, 0x0f, 0x45, 0xa5, 0x42, 0x6b, 0x45, 0x16, 0x04, 0x4b, 0xaa, 0x08, 0x5e,
	0x96, 0xd9, 0xcc, 0x98, 0x8e, 0x6c, 0x32, 0x21, 0x33, 0xbb, 0xba, 0x2c, 0xbd, 0x88, 0x82, 0x77,
	0x3d, 0x78, 0xf3, 0xe2, 0x1f, 0xe3, 0xc1, 0x83, 0xe0, 0x3f, 0x20, 0xab, 0x7f, 0x88, 0xcc, 0x24,
	0x71, 0xa3, 0xb2, 0x98, 0x8b, 0xb7, 0xc9, 0x7b, 0xef, 0xfb, 0xe6, 0xf3, 0x7e, 0x4c, 0xe0, 0xaa,
	0x64, 0xc1, 0x30, 0xe5, 0x6a, 0xec, 0x25, 0xa9, 0x50, 0x02, 0x35, 0x48, 0x4a, 0xe2, 0x50, 0xd0,
	0xbe, 0x17, 0x0c, 0xc4, 0x90, 0x7a, 0xbf, 0xdc, 0xa3, 0x76, 0xe3, 0x7c, 0x20, 0xa2, 0x48, 0xc4,
	0x78, 0xd4, 0xc6, 0xd9, 0x29, 0xd3, 0x34, 0x6e, 0x85, 0x5c, 0x1d, 0x0f, 0xfb, 0x5e, 0x20, 0x22,
	0x1c, 0x8a, 0x01, 0x89, 0x43, 0x6c, 0x1c, 0xfd, 0xe1, 0x53, 0x9c, 0xa8, 0x71, 0xc2, 0x24, 0x56,
	0x3c, 0x62, 0x52, 0x91, 0x28, 0x99, 0x9d, 0x72, 0xf1, 0x85, 0x50, 0x88, 0x70, 0xc0, 0x30, 0x49,
	0x38, 0x26, 0x71, 0x2c, 0x14, 0x51, 0x5c, 0xc4, 0x32, 0xf3, 0xba, 0x9f, 0x6b, 0xb0, 0xde, 0x3d,
	0x7c, 0x7c, 0xcc, 0x15, 0x1b, 0x70, 0xa9, 0xd0, 0x2a, 0xac, 0x71, 0x6a, 0x03, 0x07, 0xb4, 0x2c,
	0xbf, 0xc6, 0x29, 0x42, 0x70, 0x31, 0x26, 0x11, 0xb3, 0x6b, 0xc6, 0x62, 0xce, 0xc8, 0x81, 0x75,
	0xca, 0x64, 0x90, 0xf2, 0x44, 0x67, 0xb2, 0x17, 0x8c, 0xab, 0x6c, 0x42, 0x17, 0x21, 0x4c, 0x52,
	0xf1, 0x8c, 0x05, 0xaa, 0xc7, 0xa9, 0xbd, 0x68, 0x02, 0xac, 0xdc, 0xd2, 0xa5, 0x68, 0x03, 0xd6,
	0x03, 0x4e, 0xd3, 0x9e, 0xee, 0x04, 0x93, 0xf6, 0x92, 0xb3, 0xd0, 0xb2, 0x7c, 0xa8, 0x4d, 0xbe,
	0xb1, 0xa0, 0x1b, 0x10, 0x06, 0x29, 0x23, 0x8a, 0xd1, 0x1e, 0x51, 0xf6, 0xb2, 0x03, 0x5a, 0xf5,
	0x4e, 0xc3, 0xcb, 0x0a, 0xf1, 0x8a, 0xd2, 0xbd, 0x87, 0x45, 0xa5, 0xbe, 0x95, 0x47, 0xef, 0x29,
	0x2d, 0xa5, 0x6c, 0xc0, 0x72, 0xe9, 0xe9, 0x7f, 0x4b, 0xf3, 0xe8, 0x3d, 0xa5, 0xa9, 0xb9, 0xec,
	0xe5, 0xdf, 0xf6, 0x8a, 0x03, 0x5a, 0x2b, 0xbe, 0xc5, 0xe5, 0x41, 0x66, 0x40, 0x2e, 0x3c, 0x5b,
	0x40, 0xf5, 0xc7, 0xba, 0x2e, 0x2b, 0x2b, 0x3c, 0x37, 0xee, 0x8f, 0xbb, 0xd4, 0x3d, 0x84, 0x6b,
	0xa5, 0x6e, 0xde, 0xd7, 0x1d, 0xdd, 0x85, 0x4b, 0x5c, 0xb1, 0x48, 0xda, 0xc0, 0x59, 0x68, 0xd5,
	0x3b, 0x9b, 0xde, 0xfc, 0x05, 0xf0, 0x4a, 0x5a, 0x3f, 0x53, 0x75, 0x5e, 0x2d, 0xc3, 0xb5, 0xa3,
	0x3c, 0xe4, 0x88, 0xa5, 0x23, 0x1e, 0x30, 0xf4, 0x01, 0xc0, 0x73, 0x3a, 0x77, 0x29, 0x5c, 0xa2,
	0x2b, 0x7f, 0x26, 0xce, 0x57, 0x68, 0xd4, 0xf6, 0x74, 0xec, 0x03, 0x33, 0x19, 0xd9, 0xb8, 0x5a,
	0xf1, 0x7e, 0xad, 0x71, 0x77, 0x5e, 0x7e, 0xfd, 0xf1, 0xb6, 0xd6, 0x46, 0xd8, 0x6c, 0x0f, 0x25,
	0x8a, 0xe8, 0xdd, 0xcc, 0x07, 0x29, 0xf1, 0x24, 0x10, 0xb1, 0x62, 0x2f, 0xf4, 0x90, 0x4f, 0x30,
	0x4f, 0x9e, 0xcf, 0x60, 0xde, 0x00, 0x78, 0xe6, 0x1e, 0x53, 0xb3, 0xbd, 0xba, 0x34, 0x9f, 0xae,
	0x7b, 0x50, 0xb0, 0x55, 0xed, 0x8d, 0xbb, 0x65, 0xb8, 0x2e, 0x23, 0xd7, 0x70, 0x15, 0x51, 0x9a,
	0xad, 0x4c, 0x81, 0x27, 0x9c, 0x9e, 0xa0, 0x8f, 0x00, 0xae, 0xdf, 0x31, 0x23, 0x2a, 0xef, 0x79,
	0xd5, 0xab, 0xaa, 0x33, 0xed, 0x1a, 0xa6, 0x1d, 0xb7, 0xf3, 0x17, 0x53, 0xde, 0x2f, 0x3c, 0x99,
	0xbd, 0x89, 0xdf, 0xdb, 0x75, 0x13, 0x6c, 0xa1, 0x77, 0x00, 0xae, 0x3f, 0x4a, 0xe8, 0x7f, 0xc7,
	0xdc, 0x36, 0x98, 0x9b, 0x9d, 0x0a, 0xad, 0xd3, 0x58, 0xaf, 0x01, 0x5c, 0xcf, 0x1e, 0x40, 0x19,
	0xab, 0xd2, 0x34, 0x37, 0xe6, 0x07, 0xdd, 0x8d, 0x12, 0x35, 0x2e, 0xa6, 0xb8, 0x55, 0x01, 0x65,
	0xff, 0xf6, 0xa7, 0x69, 0x13, 0x7c, 0x99, 0x36, 0xc1, 0xb7, 0x69, 0x13, 0xbc, 0xff, 0xde, 0x3c,
	0xf5, 0xe4, 0x5a, 0xe9, 0xa7, 0x58, 0x5c, 0xb4, 0x1d, 0x91, 0x98, 0x84, 0x8c, 0xea, 0x84, 0xb2,
	0x9c, 0xb1, 0xbf, 0x6c, 0x9e, 0xfe, 0xf5, 0x9f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x3b, 0x98, 0xd1,
	0x93, 0x8f, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SecurityServiceClient is the client API for SecurityService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityServiceClient interface {
	// Fetch all IP whitelists that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.ipwhitelist.list on the project identified by the given context ID.
	ListIPWhitelists(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IPWhitelistList, error)
	// Fetch an IP whitelist by its id.
	// Required permissions:
	// - security.ipwhitelist.get on the IP whitelist
	GetWhitelist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IPWhitelist, error)
	// Create a new IP whitelist
	// Required permissions:
	// - security.ipwhitelist.create on the project that owns the IP whitelist.
	CreateIPWhitelist(ctx context.Context, in *IPWhitelist, opts ...grpc.CallOption) (*IPWhitelist, error)
	// Update an IP whitelist
	// Required permissions:
	// - security.ipwhitelist.update on the IP whitelist
	UpdateIPWhitelist(ctx context.Context, in *IPWhitelist, opts ...grpc.CallOption) (*IPWhitelist, error)
	// Delete an IP whitelist.
	// Note that IP whitelists are initially only marked for deletion.
	// Once all their dependent deployments are removed, the whitelist is removed.
	// Required permissions:
	// - security.ipwhitelist.delete on the IP whitelist
	DeleteIPWhitelist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
}

type securityServiceClient struct {
	cc *grpc.ClientConn
}

func NewSecurityServiceClient(cc *grpc.ClientConn) SecurityServiceClient {
	return &securityServiceClient{cc}
}

func (c *securityServiceClient) ListIPWhitelists(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IPWhitelistList, error) {
	out := new(IPWhitelistList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/ListIPWhitelists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) GetWhitelist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IPWhitelist, error) {
	out := new(IPWhitelist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/GetWhitelist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) CreateIPWhitelist(ctx context.Context, in *IPWhitelist, opts ...grpc.CallOption) (*IPWhitelist, error) {
	out := new(IPWhitelist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/CreateIPWhitelist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) UpdateIPWhitelist(ctx context.Context, in *IPWhitelist, opts ...grpc.CallOption) (*IPWhitelist, error) {
	out := new(IPWhitelist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/UpdateIPWhitelist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) DeleteIPWhitelist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/DeleteIPWhitelist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityServiceServer is the server API for SecurityService service.
type SecurityServiceServer interface {
	// Fetch all IP whitelists that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.ipwhitelist.list on the project identified by the given context ID.
	ListIPWhitelists(context.Context, *v1.ListOptions) (*IPWhitelistList, error)
	// Fetch an IP whitelist by its id.
	// Required permissions:
	// - security.ipwhitelist.get on the IP whitelist
	GetWhitelist(context.Context, *v1.IDOptions) (*IPWhitelist, error)
	// Create a new IP whitelist
	// Required permissions:
	// - security.ipwhitelist.create on the project that owns the IP whitelist.
	CreateIPWhitelist(context.Context, *IPWhitelist) (*IPWhitelist, error)
	// Update an IP whitelist
	// Required permissions:
	// - security.ipwhitelist.update on the IP whitelist
	UpdateIPWhitelist(context.Context, *IPWhitelist) (*IPWhitelist, error)
	// Delete an IP whitelist.
	// Note that IP whitelists are initially only marked for deletion.
	// Once all their dependent deployments are removed, the whitelist is removed.
	// Required permissions:
	// - security.ipwhitelist.delete on the IP whitelist
	DeleteIPWhitelist(context.Context, *v1.IDOptions) (*v1.Empty, error)
}

func RegisterSecurityServiceServer(s *grpc.Server, srv SecurityServiceServer) {
	s.RegisterService(&_SecurityService_serviceDesc, srv)
}

func _SecurityService_ListIPWhitelists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).ListIPWhitelists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/ListIPWhitelists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).ListIPWhitelists(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_GetWhitelist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).GetWhitelist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/GetWhitelist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).GetWhitelist(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_CreateIPWhitelist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IPWhitelist)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).CreateIPWhitelist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/CreateIPWhitelist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).CreateIPWhitelist(ctx, req.(*IPWhitelist))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_UpdateIPWhitelist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IPWhitelist)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).UpdateIPWhitelist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/UpdateIPWhitelist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).UpdateIPWhitelist(ctx, req.(*IPWhitelist))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_DeleteIPWhitelist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).DeleteIPWhitelist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/DeleteIPWhitelist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).DeleteIPWhitelist(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.security.v1.SecurityService",
	HandlerType: (*SecurityServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListIPWhitelists",
			Handler:    _SecurityService_ListIPWhitelists_Handler,
		},
		{
			MethodName: "GetWhitelist",
			Handler:    _SecurityService_GetWhitelist_Handler,
		},
		{
			MethodName: "CreateIPWhitelist",
			Handler:    _SecurityService_CreateIPWhitelist_Handler,
		},
		{
			MethodName: "UpdateIPWhitelist",
			Handler:    _SecurityService_UpdateIPWhitelist_Handler,
		},
		{
			MethodName: "DeleteIPWhitelist",
			Handler:    _SecurityService_DeleteIPWhitelist_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "security.proto",
}

func (m *IPWhitelist) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPWhitelist) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.ProjectId) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.ProjectId)))
		i += copy(dAtA[i:], m.ProjectId)
	}
	if len(m.CidrRanges) > 0 {
		for _, s := range m.CidrRanges {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintSecurity(dAtA, i, uint64(m.CreatedAt.Size()))
		n1, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintSecurity(dAtA, i, uint64(m.DeletedAt.Size()))
		n2, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.IsDeleted {
		dAtA[i] = 0x40
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.CreatedById) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.CreatedById)))
		i += copy(dAtA[i:], m.CreatedById)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *IPWhitelistList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPWhitelistList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintSecurity(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintSecurity(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *IPWhitelist) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if len(m.CidrRanges) > 0 {
		for _, s := range m.CidrRanges {
			l = len(s)
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IPWhitelistList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSecurity(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozSecurity(x uint64) (n int) {
	return sovSecurity(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *IPWhitelist) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPWhitelist: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPWhitelist: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CidrRanges", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CidrRanges = append(m.CidrRanges, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPWhitelistList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPWhitelistList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPWhitelistList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &IPWhitelist{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSecurity(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSecurity
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthSecurity
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSecurity
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSecurity(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthSecurity
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSecurity = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSecurity   = fmt.Errorf("proto: integer overflow")
)
