// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: resourcemanager.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An Organization is represents a real world organization such as a company.
type Organization struct {
	// System identifier of the organization.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the organization
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the organization
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Set when this organization is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,5,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// The creation timestamp of the organization
	CreatedAt *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the organization
	DeletedAt *types.Timestamp `protobuf:"bytes,7,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Tier used for this organization.
	// This is a read-only value and cannot be initialized.
	Tier *Tier `protobuf:"bytes,8,opt,name=tier,proto3" json:"tier,omitempty"`
	// Total number of deployments created in this organization throughout
	// its entire lifetime per tier-id.
	// map: tier-id -> count
	// This is a read-only value.
	TotalDeployments     map[string]int32 `protobuf:"bytes,9,rep,name=total_deployments,json=totalDeployments,proto3" json:"total_deployments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Organization) Reset()         { *m = Organization{} }
func (m *Organization) String() string { return proto.CompactTextString(m) }
func (*Organization) ProtoMessage()    {}
func (*Organization) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{0}
}
func (m *Organization) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Organization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Organization.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Organization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Organization.Merge(m, src)
}
func (m *Organization) XXX_Size() int {
	return m.Size()
}
func (m *Organization) XXX_DiscardUnknown() {
	xxx_messageInfo_Organization.DiscardUnknown(m)
}

var xxx_messageInfo_Organization proto.InternalMessageInfo

func (m *Organization) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Organization) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Organization) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Organization) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Organization) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Organization) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Organization) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Organization) GetTier() *Tier {
	if m != nil {
		return m.Tier
	}
	return nil
}

func (m *Organization) GetTotalDeployments() map[string]int32 {
	if m != nil {
		return m.TotalDeployments
	}
	return nil
}

// List of organizations.
type OrganizationList struct {
	// Actual organizations
	Items []*Organization `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// Budget for organizations (owned by the caller)
	Budget               *v1.Budget `protobuf:"bytes,2,opt,name=budget,proto3" json:"budget,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *OrganizationList) Reset()         { *m = OrganizationList{} }
func (m *OrganizationList) String() string { return proto.CompactTextString(m) }
func (*OrganizationList) ProtoMessage()    {}
func (*OrganizationList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{1}
}
func (m *OrganizationList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationList.Merge(m, src)
}
func (m *OrganizationList) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationList) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationList.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationList proto.InternalMessageInfo

func (m *OrganizationList) GetItems() []*Organization {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *OrganizationList) GetBudget() *v1.Budget {
	if m != nil {
		return m.Budget
	}
	return nil
}

// Tier of an organization.
type Tier struct {
	// Identifier of the tier.
	// This is a read-only value and cannot be initialized.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human readable name of the tier.
	// This is a read-only value and cannot be initialized.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// If set the tier has support plans.
	// This is a read-only value and cannot be initialized.
	HasSupportPlans      bool     `protobuf:"varint,3,opt,name=has_support_plans,json=hasSupportPlans,proto3" json:"has_support_plans,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tier) Reset()         { *m = Tier{} }
func (m *Tier) String() string { return proto.CompactTextString(m) }
func (*Tier) ProtoMessage()    {}
func (*Tier) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{2}
}
func (m *Tier) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tier.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tier.Merge(m, src)
}
func (m *Tier) XXX_Size() int {
	return m.Size()
}
func (m *Tier) XXX_DiscardUnknown() {
	xxx_messageInfo_Tier.DiscardUnknown(m)
}

var xxx_messageInfo_Tier proto.InternalMessageInfo

func (m *Tier) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Tier) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tier) GetHasSupportPlans() bool {
	if m != nil {
		return m.HasSupportPlans
	}
	return false
}

// Member of an organization.
// A member is always a user.
type Member struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Set if this user is owner of the organization
	Owner                bool     `protobuf:"varint,2,opt,name=owner,proto3" json:"owner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Member) Reset()         { *m = Member{} }
func (m *Member) String() string { return proto.CompactTextString(m) }
func (*Member) ProtoMessage()    {}
func (*Member) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{3}
}
func (m *Member) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Member) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Member.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Member) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Member.Merge(m, src)
}
func (m *Member) XXX_Size() int {
	return m.Size()
}
func (m *Member) XXX_DiscardUnknown() {
	xxx_messageInfo_Member.DiscardUnknown(m)
}

var xxx_messageInfo_Member proto.InternalMessageInfo

func (m *Member) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *Member) GetOwner() bool {
	if m != nil {
		return m.Owner
	}
	return false
}

// List of Members.
type MemberList struct {
	Items                []*Member `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MemberList) Reset()         { *m = MemberList{} }
func (m *MemberList) String() string { return proto.CompactTextString(m) }
func (*MemberList) ProtoMessage()    {}
func (*MemberList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{4}
}
func (m *MemberList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemberList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemberList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemberList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemberList.Merge(m, src)
}
func (m *MemberList) XXX_Size() int {
	return m.Size()
}
func (m *MemberList) XXX_DiscardUnknown() {
	xxx_messageInfo_MemberList.DiscardUnknown(m)
}

var xxx_messageInfo_MemberList proto.InternalMessageInfo

func (m *MemberList) GetItems() []*Member {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for IsMemberOfOrganization.
type IsMemberOfOrganizationRequest struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Identifier of the organization
	OrganizationId       string   `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsMemberOfOrganizationRequest) Reset()         { *m = IsMemberOfOrganizationRequest{} }
func (m *IsMemberOfOrganizationRequest) String() string { return proto.CompactTextString(m) }
func (*IsMemberOfOrganizationRequest) ProtoMessage()    {}
func (*IsMemberOfOrganizationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{5}
}
func (m *IsMemberOfOrganizationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsMemberOfOrganizationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsMemberOfOrganizationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsMemberOfOrganizationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsMemberOfOrganizationRequest.Merge(m, src)
}
func (m *IsMemberOfOrganizationRequest) XXX_Size() int {
	return m.Size()
}
func (m *IsMemberOfOrganizationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsMemberOfOrganizationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsMemberOfOrganizationRequest proto.InternalMessageInfo

func (m *IsMemberOfOrganizationRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *IsMemberOfOrganizationRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

// Response for IsMemberOfOrganization.
type IsMemberOfOrganizationResponse struct {
	// Set if the requested user is a member of the requested organization.
	Member bool `protobuf:"varint,1,opt,name=member,proto3" json:"member,omitempty"`
	// Set if the requested user is an owner of the requested organization.
	Owner                bool     `protobuf:"varint,2,opt,name=owner,proto3" json:"owner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsMemberOfOrganizationResponse) Reset()         { *m = IsMemberOfOrganizationResponse{} }
func (m *IsMemberOfOrganizationResponse) String() string { return proto.CompactTextString(m) }
func (*IsMemberOfOrganizationResponse) ProtoMessage()    {}
func (*IsMemberOfOrganizationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{6}
}
func (m *IsMemberOfOrganizationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsMemberOfOrganizationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsMemberOfOrganizationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsMemberOfOrganizationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsMemberOfOrganizationResponse.Merge(m, src)
}
func (m *IsMemberOfOrganizationResponse) XXX_Size() int {
	return m.Size()
}
func (m *IsMemberOfOrganizationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_IsMemberOfOrganizationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_IsMemberOfOrganizationResponse proto.InternalMessageInfo

func (m *IsMemberOfOrganizationResponse) GetMember() bool {
	if m != nil {
		return m.Member
	}
	return false
}

func (m *IsMemberOfOrganizationResponse) GetOwner() bool {
	if m != nil {
		return m.Owner
	}
	return false
}

// Request arguments for Add/DeleteOrganizationMembers.
type OrganizationMembersRequest struct {
	// Identifier of the organization to add/remove a user from
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Users to add/remove.
	// For every user, an owner flag is provided as well.
	// If you add an existing user, the owner flag or the add request
	// will overwrite the value of the existing owner flag.
	Members              *MemberList `protobuf:"bytes,2,opt,name=members,proto3" json:"members,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *OrganizationMembersRequest) Reset()         { *m = OrganizationMembersRequest{} }
func (m *OrganizationMembersRequest) String() string { return proto.CompactTextString(m) }
func (*OrganizationMembersRequest) ProtoMessage()    {}
func (*OrganizationMembersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{7}
}
func (m *OrganizationMembersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationMembersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationMembersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationMembersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationMembersRequest.Merge(m, src)
}
func (m *OrganizationMembersRequest) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationMembersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationMembersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationMembersRequest proto.InternalMessageInfo

func (m *OrganizationMembersRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *OrganizationMembersRequest) GetMembers() *MemberList {
	if m != nil {
		return m.Members
	}
	return nil
}

// A Project is represents a unit within an organization such as a department.
type Project struct {
	// System identifier of the project.
	// This is a read-only value.
	// It can be set when creating the project.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the project
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the project
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the organization that owns this project.
	// This is a read-only value.
	OrganizationId string `protobuf:"bytes,5,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Set when this project is deleted
	IsDeleted bool `protobuf:"varint,6,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// The creation timestamp of the project
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the project
	DeletedAt            *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Project) Reset()         { *m = Project{} }
func (m *Project) String() string { return proto.CompactTextString(m) }
func (*Project) ProtoMessage()    {}
func (*Project) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{8}
}
func (m *Project) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Project) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Project.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Project) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Project.Merge(m, src)
}
func (m *Project) XXX_Size() int {
	return m.Size()
}
func (m *Project) XXX_DiscardUnknown() {
	xxx_messageInfo_Project.DiscardUnknown(m)
}

var xxx_messageInfo_Project proto.InternalMessageInfo

func (m *Project) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Project) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Project) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Project) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Project) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Project) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Project) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Project) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

// List of Projects.
type ProjectList struct {
	// Resulting projects
	Items []*Project `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// Budget for projects
	Budget               *v1.Budget `protobuf:"bytes,2,opt,name=budget,proto3" json:"budget,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ProjectList) Reset()         { *m = ProjectList{} }
func (m *ProjectList) String() string { return proto.CompactTextString(m) }
func (*ProjectList) ProtoMessage()    {}
func (*ProjectList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{9}
}
func (m *ProjectList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProjectList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProjectList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProjectList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProjectList.Merge(m, src)
}
func (m *ProjectList) XXX_Size() int {
	return m.Size()
}
func (m *ProjectList) XXX_DiscardUnknown() {
	xxx_messageInfo_ProjectList.DiscardUnknown(m)
}

var xxx_messageInfo_ProjectList proto.InternalMessageInfo

func (m *ProjectList) GetItems() []*Project {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *ProjectList) GetBudget() *v1.Budget {
	if m != nil {
		return m.Budget
	}
	return nil
}

// An Event represents something that happened to an organization
// in the ArangoDB Managed service.
type Event struct {
	// System identifier of the event.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Identifier of the organization that owns this event.
	// This is a read-only value.
	OrganizationId string `protobuf:"bytes,3,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Identifier of the subject of this event.
	// This is a read-only value.
	// If the subject of this event is an organization,
	// this value is a duplicate of organization_id.
	SubjectId string `protobuf:"bytes,4,opt,name=subject_id,json=subjectId,proto3" json:"subject_id,omitempty"`
	// Type of the event.
	Type string `protobuf:"bytes,5,opt,name=type,proto3" json:"type,omitempty"`
	// Payload of the event.
	// The fields used in the payload are specific
	// to the type of event.
	Payload map[string]string `protobuf:"bytes,6,rep,name=payload,proto3" json:"payload,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The creation timestamp of the event
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// URL of the subject of this event.
	// This is a read-only value.
	SubjectUrl           string   `protobuf:"bytes,8,opt,name=subject_url,json=subjectUrl,proto3" json:"subject_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{10}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Event) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Event) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Event) GetSubjectId() string {
	if m != nil {
		return m.SubjectId
	}
	return ""
}

func (m *Event) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Event) GetPayload() map[string]string {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Event) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Event) GetSubjectUrl() string {
	if m != nil {
		return m.SubjectUrl
	}
	return ""
}

// List of Events.
type EventList struct {
	Items                []*Event `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventList) Reset()         { *m = EventList{} }
func (m *EventList) String() string { return proto.CompactTextString(m) }
func (*EventList) ProtoMessage()    {}
func (*EventList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{11}
}
func (m *EventList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventList.Merge(m, src)
}
func (m *EventList) XXX_Size() int {
	return m.Size()
}
func (m *EventList) XXX_DiscardUnknown() {
	xxx_messageInfo_EventList.DiscardUnknown(m)
}

var xxx_messageInfo_EventList proto.InternalMessageInfo

func (m *EventList) GetItems() []*Event {
	if m != nil {
		return m.Items
	}
	return nil
}

// Options for ListEvents
type ListEventOptions struct {
	// Standard list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, filter on the subject_id of event
	SubjectIds []string `protobuf:"bytes,2,rep,name=subject_ids,json=subjectIds,proto3" json:"subject_ids,omitempty"`
	// If set, filter on the type of event
	Types []string `protobuf:"bytes,3,rep,name=types,proto3" json:"types,omitempty"`
	// If set, filter of events created after this timestamp
	CreatedAfter *types.Timestamp `protobuf:"bytes,4,opt,name=created_after,json=createdAfter,proto3" json:"created_after,omitempty"`
	// If set, filter of events created before this timestamp
	CreatedBefore        *types.Timestamp `protobuf:"bytes,5,opt,name=created_before,json=createdBefore,proto3" json:"created_before,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ListEventOptions) Reset()         { *m = ListEventOptions{} }
func (m *ListEventOptions) String() string { return proto.CompactTextString(m) }
func (*ListEventOptions) ProtoMessage()    {}
func (*ListEventOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{12}
}
func (m *ListEventOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListEventOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListEventOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListEventOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEventOptions.Merge(m, src)
}
func (m *ListEventOptions) XXX_Size() int {
	return m.Size()
}
func (m *ListEventOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEventOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ListEventOptions proto.InternalMessageInfo

func (m *ListEventOptions) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListEventOptions) GetSubjectIds() []string {
	if m != nil {
		return m.SubjectIds
	}
	return nil
}

func (m *ListEventOptions) GetTypes() []string {
	if m != nil {
		return m.Types
	}
	return nil
}

func (m *ListEventOptions) GetCreatedAfter() *types.Timestamp {
	if m != nil {
		return m.CreatedAfter
	}
	return nil
}

func (m *ListEventOptions) GetCreatedBefore() *types.Timestamp {
	if m != nil {
		return m.CreatedBefore
	}
	return nil
}

// An OrganizationInvite represents an invite for a human to join an
// organization.
type OrganizationInvite struct {
	// System identifier of the invite.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Identifier of the organization that the human is invited to join.
	// This is a read-only value.
	OrganizationId string `protobuf:"bytes,3,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Email address of the human who is invited.
	Email string `protobuf:"bytes,4,opt,name=email,proto3" json:"email,omitempty"`
	// If set, the invitee accepted the invite.
	// This is a read-only value.
	Accepted bool `protobuf:"varint,5,opt,name=accepted,proto3" json:"accepted,omitempty"`
	// If set, the invitee rejected the invite.
	// This is a read-only value.
	Rejected bool `protobuf:"varint,6,opt,name=rejected,proto3" json:"rejected,omitempty"`
	// The creation timestamp of the invite
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The acceptance timestamp of the invite
	// This is a read-only value.
	AcceptedAt *types.Timestamp `protobuf:"bytes,8,opt,name=accepted_at,json=acceptedAt,proto3" json:"accepted_at,omitempty"`
	// The rejection timestamp of the invite
	// This is a read-only value.
	RejectedAt *types.Timestamp `protobuf:"bytes,9,opt,name=rejected_at,json=rejectedAt,proto3" json:"rejected_at,omitempty"`
	// Identifier of the user that accepted or rejected this invite.
	// This is a read-only value.
	UserId string `protobuf:"bytes,10,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Identifier of the user that created this invite.
	CreatedById string `protobuf:"bytes,11,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// Identifier of the organization that the human is invited to join.
	// This is a read-only value.
	OrganizationName string `protobuf:"bytes,12,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// Name of the user that created this invite.
	// This is a read-only value.
	CreatedByName        string   `protobuf:"bytes,13,opt,name=created_by_name,json=createdByName,proto3" json:"created_by_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OrganizationInvite) Reset()         { *m = OrganizationInvite{} }
func (m *OrganizationInvite) String() string { return proto.CompactTextString(m) }
func (*OrganizationInvite) ProtoMessage()    {}
func (*OrganizationInvite) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{13}
}
func (m *OrganizationInvite) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationInvite) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationInvite.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationInvite) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationInvite.Merge(m, src)
}
func (m *OrganizationInvite) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationInvite) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationInvite.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationInvite proto.InternalMessageInfo

func (m *OrganizationInvite) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *OrganizationInvite) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *OrganizationInvite) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *OrganizationInvite) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *OrganizationInvite) GetAccepted() bool {
	if m != nil {
		return m.Accepted
	}
	return false
}

func (m *OrganizationInvite) GetRejected() bool {
	if m != nil {
		return m.Rejected
	}
	return false
}

func (m *OrganizationInvite) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *OrganizationInvite) GetAcceptedAt() *types.Timestamp {
	if m != nil {
		return m.AcceptedAt
	}
	return nil
}

func (m *OrganizationInvite) GetRejectedAt() *types.Timestamp {
	if m != nil {
		return m.RejectedAt
	}
	return nil
}

func (m *OrganizationInvite) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *OrganizationInvite) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *OrganizationInvite) GetOrganizationName() string {
	if m != nil {
		return m.OrganizationName
	}
	return ""
}

func (m *OrganizationInvite) GetCreatedByName() string {
	if m != nil {
		return m.CreatedByName
	}
	return ""
}

// List of OrganizationInvites.
type OrganizationInviteList struct {
	Items                []*OrganizationInvite `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OrganizationInviteList) Reset()         { *m = OrganizationInviteList{} }
func (m *OrganizationInviteList) String() string { return proto.CompactTextString(m) }
func (*OrganizationInviteList) ProtoMessage()    {}
func (*OrganizationInviteList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{14}
}
func (m *OrganizationInviteList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationInviteList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationInviteList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationInviteList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationInviteList.Merge(m, src)
}
func (m *OrganizationInviteList) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationInviteList) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationInviteList.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationInviteList proto.InternalMessageInfo

func (m *OrganizationInviteList) GetItems() []*OrganizationInvite {
	if m != nil {
		return m.Items
	}
	return nil
}

// Description of a kind of quota's
type QuotaDescription struct {
	// Kind of the quota
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Human readable description
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// If set, this kind of quota is valid at organization level
	ForOrganizations bool `protobuf:"varint,3,opt,name=for_organizations,json=forOrganizations,proto3" json:"for_organizations,omitempty"`
	// If set, this kind of quota is valid at project level
	ForProjects          bool     `protobuf:"varint,4,opt,name=for_projects,json=forProjects,proto3" json:"for_projects,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QuotaDescription) Reset()         { *m = QuotaDescription{} }
func (m *QuotaDescription) String() string { return proto.CompactTextString(m) }
func (*QuotaDescription) ProtoMessage()    {}
func (*QuotaDescription) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{15}
}
func (m *QuotaDescription) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaDescription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuotaDescription.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuotaDescription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaDescription.Merge(m, src)
}
func (m *QuotaDescription) XXX_Size() int {
	return m.Size()
}
func (m *QuotaDescription) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaDescription.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaDescription proto.InternalMessageInfo

func (m *QuotaDescription) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *QuotaDescription) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *QuotaDescription) GetForOrganizations() bool {
	if m != nil {
		return m.ForOrganizations
	}
	return false
}

func (m *QuotaDescription) GetForProjects() bool {
	if m != nil {
		return m.ForProjects
	}
	return false
}

// List of QuotaDescription's
type QuotaDescriptionList struct {
	Items                []*QuotaDescription `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *QuotaDescriptionList) Reset()         { *m = QuotaDescriptionList{} }
func (m *QuotaDescriptionList) String() string { return proto.CompactTextString(m) }
func (*QuotaDescriptionList) ProtoMessage()    {}
func (*QuotaDescriptionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{16}
}
func (m *QuotaDescriptionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaDescriptionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuotaDescriptionList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuotaDescriptionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaDescriptionList.Merge(m, src)
}
func (m *QuotaDescriptionList) XXX_Size() int {
	return m.Size()
}
func (m *QuotaDescriptionList) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaDescriptionList.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaDescriptionList proto.InternalMessageInfo

func (m *QuotaDescriptionList) GetItems() []*QuotaDescription {
	if m != nil {
		return m.Items
	}
	return nil
}

// Quota limit
type Quota struct {
	// Kind of quota
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Human readable description of the quota
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Current limit of the quota.
	// A value of 0 means unlimited.
	Limit                int64    `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Quota) Reset()         { *m = Quota{} }
func (m *Quota) String() string { return proto.CompactTextString(m) }
func (*Quota) ProtoMessage()    {}
func (*Quota) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{17}
}
func (m *Quota) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Quota) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Quota.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Quota) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Quota.Merge(m, src)
}
func (m *Quota) XXX_Size() int {
	return m.Size()
}
func (m *Quota) XXX_DiscardUnknown() {
	xxx_messageInfo_Quota.DiscardUnknown(m)
}

var xxx_messageInfo_Quota proto.InternalMessageInfo

func (m *Quota) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *Quota) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Quota) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

// List of Quota's
type QuotaList struct {
	Items                []*Quota `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QuotaList) Reset()         { *m = QuotaList{} }
func (m *QuotaList) String() string { return proto.CompactTextString(m) }
func (*QuotaList) ProtoMessage()    {}
func (*QuotaList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{18}
}
func (m *QuotaList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuotaList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuotaList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaList.Merge(m, src)
}
func (m *QuotaList) XXX_Size() int {
	return m.Size()
}
func (m *QuotaList) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaList.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaList proto.InternalMessageInfo

func (m *QuotaList) GetItems() []*Quota {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListXyzQuotas
type ListQuotasRequest struct {
	// Common list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, limit the returned list of quota's to these kinds.
	Kinds                []string `protobuf:"bytes,2,rep,name=kinds,proto3" json:"kinds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListQuotasRequest) Reset()         { *m = ListQuotasRequest{} }
func (m *ListQuotasRequest) String() string { return proto.CompactTextString(m) }
func (*ListQuotasRequest) ProtoMessage()    {}
func (*ListQuotasRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{19}
}
func (m *ListQuotasRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListQuotasRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListQuotasRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListQuotasRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListQuotasRequest.Merge(m, src)
}
func (m *ListQuotasRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListQuotasRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListQuotasRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListQuotasRequest proto.InternalMessageInfo

func (m *ListQuotasRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListQuotasRequest) GetKinds() []string {
	if m != nil {
		return m.Kinds
	}
	return nil
}

func init() {
	proto.RegisterType((*Organization)(nil), "arangodb.cloud.resourcemanager.v1.Organization")
	proto.RegisterMapType((map[string]int32)(nil), "arangodb.cloud.resourcemanager.v1.Organization.TotalDeploymentsEntry")
	proto.RegisterType((*OrganizationList)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationList")
	proto.RegisterType((*Tier)(nil), "arangodb.cloud.resourcemanager.v1.Tier")
	proto.RegisterType((*Member)(nil), "arangodb.cloud.resourcemanager.v1.Member")
	proto.RegisterType((*MemberList)(nil), "arangodb.cloud.resourcemanager.v1.MemberList")
	proto.RegisterType((*IsMemberOfOrganizationRequest)(nil), "arangodb.cloud.resourcemanager.v1.IsMemberOfOrganizationRequest")
	proto.RegisterType((*IsMemberOfOrganizationResponse)(nil), "arangodb.cloud.resourcemanager.v1.IsMemberOfOrganizationResponse")
	proto.RegisterType((*OrganizationMembersRequest)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationMembersRequest")
	proto.RegisterType((*Project)(nil), "arangodb.cloud.resourcemanager.v1.Project")
	proto.RegisterType((*ProjectList)(nil), "arangodb.cloud.resourcemanager.v1.ProjectList")
	proto.RegisterType((*Event)(nil), "arangodb.cloud.resourcemanager.v1.Event")
	proto.RegisterMapType((map[string]string)(nil), "arangodb.cloud.resourcemanager.v1.Event.PayloadEntry")
	proto.RegisterType((*EventList)(nil), "arangodb.cloud.resourcemanager.v1.EventList")
	proto.RegisterType((*ListEventOptions)(nil), "arangodb.cloud.resourcemanager.v1.ListEventOptions")
	proto.RegisterType((*OrganizationInvite)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationInvite")
	proto.RegisterType((*OrganizationInviteList)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationInviteList")
	proto.RegisterType((*QuotaDescription)(nil), "arangodb.cloud.resourcemanager.v1.QuotaDescription")
	proto.RegisterType((*QuotaDescriptionList)(nil), "arangodb.cloud.resourcemanager.v1.QuotaDescriptionList")
	proto.RegisterType((*Quota)(nil), "arangodb.cloud.resourcemanager.v1.Quota")
	proto.RegisterType((*QuotaList)(nil), "arangodb.cloud.resourcemanager.v1.QuotaList")
	proto.RegisterType((*ListQuotasRequest)(nil), "arangodb.cloud.resourcemanager.v1.ListQuotasRequest")
}

func init() { proto.RegisterFile("resourcemanager.proto", fileDescriptor_81de387952a6887e) }

var fileDescriptor_81de387952a6887e = []byte{
	// 1863 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x4f, 0x6f, 0x23, 0x49,
	0x15, 0xa7, 0xec, 0x38, 0xb1, 0x9f, 0x93, 0x99, 0xa4, 0x94, 0xc9, 0x7a, 0x2d, 0x36, 0x9b, 0xed,
	0xd5, 0x32, 0xc1, 0xb3, 0x71, 0x33, 0x0e, 0xa3, 0x9d, 0x49, 0x76, 0x37, 0x71, 0xfe, 0x28, 0x32,
	0xd9, 0x6c, 0x66, 0x7a, 0x66, 0x41, 0xe2, 0x12, 0xb5, 0xdd, 0x65, 0x4f, 0xef, 0xda, 0xdd, 0xbd,
	0xdd, 0xed, 0x80, 0x59, 0xcd, 0x05, 0x71, 0x41, 0x42, 0x73, 0x59, 0x21, 0x2d, 0x9a, 0x03, 0x12,
	0x5c, 0x10, 0x02, 0x2e, 0x70, 0x40, 0x48, 0xdc, 0x90, 0xe0, 0xc0, 0x01, 0x89, 0x2f, 0x00, 0x03,
	0x67, 0x04, 0x12, 0x1f, 0x00, 0xd5, 0xab, 0x2e, 0xa7, 0xdb, 0xb1, 0xe3, 0x6e, 0x67, 0x66, 0xd8,
	0x5b, 0x57, 0xd5, 0x7b, 0xaf, 0x7e, 0xef, 0x6f, 0xd5, 0xab, 0x86, 0x6b, 0x2e, 0xf3, 0xec, 0xae,
	0xdb, 0x60, 0x1d, 0xdd, 0xd2, 0x5b, 0xcc, 0x2d, 0x3b, 0xae, 0xed, 0xdb, 0xf4, 0x35, 0xdd, 0xd5,
	0xad, 0x96, 0x6d, 0xd4, 0xcb, 0x8d, 0xb6, 0xdd, 0x35, 0xca, 0x83, 0x54, 0xa7, 0x37, 0x8b, 0x4b,
	0x0d, 0xbb, 0xd3, 0xb1, 0x2d, 0xf5, 0xf4, 0xa6, 0x2a, 0xbe, 0x04, 0x6b, 0x71, 0xb3, 0x65, 0xfa,
	0x0f, 0xbb, 0xf5, 0x72, 0xc3, 0xee, 0xa8, 0x2d, 0xbb, 0xad, 0x5b, 0x2d, 0x15, 0x17, 0xea, 0xdd,
	0xa6, 0xea, 0xf8, 0x3d, 0x87, 0x79, 0xaa, 0x6f, 0x76, 0x98, 0xe7, 0xeb, 0x1d, 0xe7, 0xec, 0x2b,
	0x60, 0xfe, 0x62, 0xcb, 0xb6, 0x5b, 0x6d, 0xa6, 0xea, 0x8e, 0xa9, 0xea, 0x96, 0x65, 0xfb, 0xba,
	0x6f, 0xda, 0x96, 0x27, 0x56, 0x95, 0xff, 0xa4, 0x61, 0xf6, 0xd8, 0x6d, 0xe9, 0x96, 0xf9, 0x1d,
	0x9c, 0xa7, 0x57, 0x20, 0x65, 0x1a, 0x05, 0xb2, 0x42, 0x56, 0x73, 0x5a, 0xca, 0x34, 0xe8, 0x3c,
	0xa4, 0xbb, 0x6e, 0xbb, 0x90, 0xc2, 0x09, 0xfe, 0x49, 0x29, 0x4c, 0x59, 0x7a, 0x87, 0x15, 0xd2,
	0x38, 0x85, 0xdf, 0x74, 0x05, 0xf2, 0x06, 0xf3, 0x1a, 0xae, 0xe9, 0x70, 0x21, 0x85, 0x29, 0x5c,
	0x0a, 0x4f, 0xd1, 0x57, 0x00, 0x4c, 0xef, 0xc4, 0x60, 0x6d, 0xe6, 0x33, 0xa3, 0x90, 0x59, 0x21,
	0xab, 0x59, 0x2d, 0x67, 0x7a, 0x7b, 0x62, 0x82, 0xde, 0x01, 0x68, 0xb8, 0x4c, 0xf7, 0x99, 0x71,
	0xa2, 0xfb, 0x85, 0xe9, 0x15, 0xb2, 0x9a, 0xaf, 0x14, 0xcb, 0x02, 0x7a, 0x59, 0x2a, 0x5b, 0x7e,
	0x20, 0x75, 0xd3, 0x72, 0x01, 0x75, 0xd5, 0xe7, 0xac, 0x81, 0x58, 0xce, 0x3a, 0x33, 0x9e, 0x35,
	0xa0, 0xae, 0xfa, 0x74, 0x13, 0xa6, 0x7c, 0x93, 0xb9, 0x85, 0x2c, 0x32, 0x5d, 0x2f, 0x8f, 0x75,
	0x51, 0xf9, 0x81, 0xc9, 0x5c, 0x0d, 0x99, 0xa8, 0x0b, 0x0b, 0xbe, 0xed, 0xeb, 0xed, 0x13, 0x83,
	0x39, 0x6d, 0xbb, 0xd7, 0x61, 0x96, 0xef, 0x15, 0x72, 0x2b, 0xe9, 0xd5, 0x7c, 0x65, 0x3f, 0x86,
	0xa4, 0xb0, 0xd5, 0xcb, 0x0f, 0xb8, 0xa0, 0xbd, 0x33, 0x39, 0xfb, 0x96, 0xef, 0xf6, 0xb4, 0x79,
	0x7f, 0x60, 0xba, 0xb8, 0x0b, 0xd7, 0x86, 0x92, 0x72, 0x37, 0x7d, 0xc4, 0x7a, 0x81, 0xdf, 0xf8,
	0x27, 0x5d, 0x84, 0xcc, 0xa9, 0xde, 0xee, 0x32, 0x74, 0x5d, 0x46, 0x13, 0x83, 0x8d, 0xd4, 0x6d,
	0xa2, 0x7c, 0x4a, 0x60, 0x3e, 0xbc, 0xfb, 0x7b, 0xa6, 0xe7, 0xd3, 0x7d, 0xc8, 0x98, 0x3e, 0xeb,
	0x78, 0x05, 0x82, 0x1a, 0xa8, 0x09, 0x35, 0xd0, 0x04, 0x37, 0xbd, 0x0d, 0xd3, 0xf5, 0xae, 0xd1,
	0x62, 0x3e, 0x6e, 0x9b, 0xaf, 0xac, 0x0c, 0xca, 0x09, 0x02, 0xfb, 0xf4, 0x66, 0x79, 0x07, 0xe9,
	0xb4, 0x80, 0x5e, 0xf9, 0x3a, 0x4c, 0x71, 0xe3, 0x9e, 0x0b, 0x40, 0x19, 0x6e, 0xa9, 0x50, 0xb8,
	0x95, 0x60, 0xe1, 0xa1, 0xee, 0x9d, 0x78, 0x5d, 0xc7, 0xb1, 0x5d, 0xff, 0xc4, 0x69, 0xeb, 0x96,
	0x87, 0xf1, 0x98, 0xd5, 0xae, 0x3e, 0xd4, 0xbd, 0xfb, 0x62, 0xfe, 0x2e, 0x9f, 0x56, 0xde, 0x82,
	0xe9, 0x23, 0xd6, 0xa9, 0x33, 0x97, 0xbe, 0x04, 0x33, 0x5d, 0x8f, 0xb9, 0x27, 0x7d, 0xf1, 0xd3,
	0x7c, 0x58, 0x33, 0xb8, 0xa9, 0xec, 0x6f, 0x59, 0xcc, 0xc5, 0x3d, 0xb2, 0x9a, 0x18, 0x28, 0x47,
	0x00, 0x82, 0x11, 0xed, 0xb3, 0x15, 0xb5, 0xcf, 0x97, 0x63, 0xd8, 0x47, 0x70, 0x07, 0x96, 0x51,
	0x74, 0x78, 0xa5, 0xe6, 0x89, 0xa9, 0xe3, 0x66, 0xc4, 0x74, 0xec, 0xe3, 0x2e, 0xf3, 0xfc, 0xd1,
	0xf0, 0xae, 0xc3, 0x55, 0x3b, 0x44, 0xcf, 0x09, 0x84, 0x31, 0xae, 0x84, 0xa7, 0x6b, 0x86, 0xf2,
	0x3e, 0x2c, 0x8f, 0xda, 0xc2, 0x73, 0x6c, 0xcb, 0x63, 0x74, 0x09, 0xa6, 0x3b, 0xb8, 0x8e, 0x5b,
	0x64, 0xb5, 0x60, 0x34, 0xc2, 0x02, 0x8f, 0x09, 0x14, 0xc3, 0x62, 0x84, 0x68, 0x4f, 0x02, 0x1e,
	0x82, 0x8b, 0x0c, 0xc3, 0x45, 0x0f, 0x60, 0x46, 0xec, 0xe3, 0x05, 0x51, 0xb1, 0x16, 0xdb, 0x7a,
	0xdc, 0xf6, 0x9a, 0xe4, 0x56, 0x7e, 0x9c, 0x82, 0x99, 0xbb, 0xae, 0xfd, 0x21, 0x6b, 0xf8, 0xcf,
	0xad, 0x50, 0x0d, 0xd1, 0x2a, 0x33, 0x54, 0xab, 0x68, 0x45, 0x9b, 0xbe, 0xb8, 0xa2, 0xcd, 0x4c,
	0x5e, 0xd1, 0xb2, 0x09, 0x2a, 0x9a, 0xf2, 0x7d, 0x02, 0xf9, 0xc0, 0x42, 0x18, 0xb6, 0xdb, 0xd1,
	0xb0, 0x2d, 0xc5, 0x30, 0x7c, 0xc0, 0x7e, 0xf9, 0x8c, 0xfe, 0x57, 0x0a, 0x32, 0xfb, 0xa7, 0xcc,
	0x8a, 0xe3, 0xab, 0x21, 0x56, 0x4f, 0x8f, 0xb2, 0xba, 0xd7, 0xad, 0x73, 0x80, 0x9c, 0x46, 0xf8,
	0x2f, 0x17, 0xcc, 0xd4, 0xb0, 0x5a, 0xf0, 0x03, 0x31, 0x70, 0x19, 0x7e, 0xd3, 0x63, 0x98, 0x71,
	0xf4, 0x5e, 0xdb, 0xd6, 0xb9, 0x97, 0xb8, 0x15, 0x6e, 0xc5, 0xb0, 0x02, 0x02, 0x2f, 0xdf, 0x15,
	0x7c, 0xa2, 0x1c, 0x4b, 0x29, 0x97, 0x71, 0xed, 0xab, 0x90, 0x97, 0xf0, 0xb9, 0x05, 0xb2, 0x08,
	0x53, 0x6a, 0xf4, 0x81, 0xdb, 0x2e, 0x6e, 0xc0, 0x6c, 0x78, 0xd3, 0x71, 0x85, 0x3d, 0x17, 0x2e,
	0xec, 0x87, 0x90, 0x43, 0xd8, 0xe8, 0xf9, 0x77, 0xa3, 0x9e, 0x5f, 0x8d, 0xab, 0xb3, 0xac, 0x57,
	0x8f, 0x53, 0x30, 0xcf, 0x05, 0xe1, 0xe4, 0x31, 0xe6, 0x86, 0x47, 0xb7, 0x60, 0xc6, 0x16, 0x9f,
	0x88, 0x28, 0x5f, 0x79, 0x63, 0x74, 0x34, 0x70, 0xe6, 0x80, 0x4f, 0x93, 0x5c, 0x61, 0xfd, 0x4d,
	0x83, 0x97, 0x83, 0x74, 0x48, 0xff, 0x9a, 0xe1, 0x71, 0xed, 0xf0, 0x46, 0x53, 0x48, 0xe3, 0x92,
	0x18, 0xd0, 0x2d, 0x98, 0xeb, 0x5b, 0xbc, 0xe9, 0x33, 0x17, 0x1d, 0x7f, 0xb1, 0xd1, 0x67, 0xa5,
	0xd1, 0x39, 0x3d, 0xad, 0xc2, 0x15, 0x29, 0xa0, 0xce, 0x9a, 0xb6, 0x2b, 0x22, 0xe4, 0x62, 0x09,
	0x72, 0xcb, 0x1d, 0x64, 0x50, 0xfe, 0x9b, 0x06, 0x1a, 0xae, 0x86, 0x35, 0xeb, 0xd4, 0xf4, 0xd9,
	0xb3, 0x8c, 0xed, 0x45, 0xc8, 0xb0, 0x8e, 0x6e, 0xb6, 0x83, 0xb0, 0x16, 0x03, 0x5a, 0x84, 0xac,
	0xde, 0x68, 0x30, 0xe7, 0xec, 0xde, 0xd4, 0x1f, 0xf3, 0x35, 0x97, 0x71, 0xd3, 0xf5, 0x2b, 0x50,
	0x7f, 0x7c, 0x99, 0x28, 0xdd, 0x84, 0xbc, 0xdc, 0x22, 0x5e, 0x05, 0x02, 0x49, 0x2e, 0x98, 0x25,
	0x06, 0xce, 0x9c, 0x1b, 0xcf, 0x2c, 0xc9, 0xab, 0x91, 0x43, 0x10, 0x22, 0x87, 0xa0, 0x72, 0x16,
	0x01, 0xf5, 0x1e, 0x5f, 0xce, 0x8b, 0xd2, 0x2d, 0x7d, 0xd4, 0xab, 0x19, 0xf4, 0x06, 0x2c, 0x44,
	0x0c, 0x8d, 0xd5, 0x7f, 0x16, 0xe9, 0xe6, 0xc3, 0x0b, 0xef, 0xf3, 0x93, 0xe0, 0x4b, 0x70, 0x35,
	0x24, 0x10, 0x49, 0xe7, 0x90, 0xb4, 0xef, 0xf6, 0x1e, 0xa7, 0x53, 0x18, 0x2c, 0x9d, 0xf7, 0x3a,
	0x66, 0xd8, 0x61, 0x34, 0xc3, 0x6e, 0x25, 0xbc, 0x32, 0x09, 0x49, 0x32, 0xdd, 0x3e, 0x23, 0x30,
	0x7f, 0xaf, 0x6b, 0xfb, 0xfa, 0x5e, 0xe8, 0x2c, 0xa2, 0x30, 0xf5, 0x91, 0x69, 0xc9, 0xe8, 0xc2,
	0xef, 0xc1, 0x13, 0x2c, 0x75, 0xfe, 0x04, 0xbb, 0x01, 0x0b, 0x4d, 0xdb, 0x3d, 0x09, 0x6b, 0x2c,
	0x6f, 0x47, 0xf3, 0x4d, 0xdb, 0x0d, 0x63, 0xf0, 0xe8, 0x6b, 0x30, 0xcb, 0x89, 0x1d, 0x51, 0xf4,
	0x3d, 0x0c, 0xbd, 0xac, 0x96, 0x6f, 0xda, 0x6e, 0x70, 0x0e, 0xf0, 0x9b, 0xcb, 0xe2, 0x20, 0x32,
	0xd4, 0xbf, 0x16, 0xd5, 0x7f, 0x3d, 0x86, 0xfe, 0x83, 0x72, 0xa4, 0xf6, 0xf7, 0x21, 0x83, 0x4b,
	0x13, 0x6a, 0xbc, 0x08, 0x99, 0xb6, 0xd9, 0x31, 0x7d, 0xd4, 0x32, 0xad, 0x89, 0x01, 0x2f, 0x87,
	0x28, 0x74, 0xd2, 0x72, 0x88, 0xcc, 0x12, 0xe1, 0x87, 0xb0, 0xc0, 0xe5, 0xe0, 0x5c, 0xff, 0x06,
	0x74, 0xe9, 0x72, 0xb8, 0x08, 0x19, 0xae, 0xa2, 0x2c, 0x84, 0x62, 0x50, 0xf9, 0xe1, 0xeb, 0xb0,
	0xa4, 0x05, 0x78, 0x8e, 0x04, 0x9e, 0xfb, 0xcc, 0x3d, 0x35, 0x1b, 0x8c, 0xfe, 0x94, 0x08, 0x1c,
	0x51, 0x27, 0xc6, 0xdb, 0xb6, 0xb8, 0x9e, 0x30, 0x42, 0x39, 0xaf, 0x52, 0xf9, 0xee, 0x5f, 0xff,
	0xf9, 0x69, 0xea, 0x4d, 0x5a, 0xc2, 0x0e, 0x72, 0x80, 0x83, 0xb7, 0xaa, 0x1e, 0x6b, 0x37, 0xd5,
	0x48, 0xb0, 0xd1, 0x27, 0x04, 0xae, 0x1e, 0xb0, 0x08, 0x48, 0xfa, 0xfa, 0x68, 0x8c, 0xb5, 0x3d,
	0x89, 0x30, 0x69, 0xdb, 0x31, 0x1e, 0x5d, 0x04, 0x98, 0xfa, 0x89, 0x69, 0x3c, 0xa2, 0x3f, 0x23,
	0x40, 0x77, 0x31, 0xc7, 0x23, 0x00, 0x93, 0xee, 0x9d, 0x1c, 0xec, 0x57, 0x10, 0x6c, 0x49, 0x79,
	0x23, 0x16, 0xd8, 0x0d, 0x52, 0xa2, 0xbf, 0x24, 0x40, 0x3f, 0x70, 0x8c, 0x17, 0x0f, 0xf5, 0x16,
	0x42, 0x55, 0x2b, 0x09, 0xec, 0xca, 0xf1, 0x3e, 0x26, 0x40, 0xc5, 0x05, 0x38, 0xb9, 0xef, 0x5f,
	0x1d, 0x4d, 0xb4, 0xdf, 0x71, 0xfc, 0x9e, 0xf4, 0x75, 0x29, 0x89, 0xaf, 0x7f, 0x4d, 0xe0, 0xa5,
	0xc1, 0x7c, 0x09, 0xda, 0x98, 0xb8, 0x59, 0x93, 0xac, 0x59, 0x51, 0x76, 0x10, 0xe5, 0xdb, 0x74,
	0x23, 0x26, 0xca, 0x86, 0x6d, 0xf9, 0xec, 0xdb, 0xfc, 0x3a, 0xf4, 0x48, 0x0d, 0xfa, 0x1c, 0xfa,
	0x07, 0x02, 0x4b, 0x55, 0xc3, 0x18, 0x06, 0xfa, 0x9d, 0x84, 0x9e, 0x8c, 0xf6, 0x6c, 0xe3, 0x8d,
	0xfc, 0x35, 0x84, 0xbf, 0xa7, 0x6c, 0xc5, 0x84, 0x3f, 0x70, 0xb3, 0xe9, 0xeb, 0xc0, 0xa3, 0xe1,
	0x8f, 0x04, 0x5e, 0x3e, 0x1f, 0x0d, 0x2f, 0x58, 0x93, 0xd2, 0xb3, 0xd0, 0xe4, 0xdf, 0x04, 0x96,
	0x86, 0xb7, 0xd6, 0x74, 0x3b, 0x86, 0x1a, 0x17, 0x36, 0xfe, 0xc5, 0xea, 0x25, 0x24, 0x88, 0xbe,
	0x5e, 0xb9, 0x87, 0xba, 0x1e, 0xd2, 0xda, 0x25, 0x75, 0x55, 0x3f, 0x09, 0x6e, 0x5f, 0x8f, 0xb8,
	0xf3, 0x96, 0x06, 0x33, 0x47, 0x9c, 0x7e, 0xf4, 0xab, 0x31, 0x00, 0x9f, 0x3b, 0x2c, 0x8b, 0x6f,
	0xc6, 0x3d, 0x72, 0x31, 0x8d, 0x6a, 0xa8, 0xd1, 0x2e, 0xad, 0xc6, 0xd5, 0x48, 0x64, 0x6b, 0x39,
	0x9c, 0x4e, 0x1f, 0x0b, 0xb8, 0x3f, 0x27, 0x30, 0xcb, 0x65, 0xca, 0x0b, 0x4d, 0xdc, 0xc4, 0x2f,
	0xc7, 0x6f, 0x96, 0x11, 0xf2, 0x2e, 0x42, 0x7e, 0x87, 0x6e, 0x4e, 0x90, 0xf9, 0xf2, 0xfe, 0x45,
	0x7f, 0x40, 0x00, 0x0e, 0x98, 0xc4, 0x1a, 0xaf, 0x72, 0x26, 0xe8, 0xea, 0x95, 0x35, 0x04, 0x79,
	0x9d, 0x8e, 0x3c, 0x83, 0x24, 0x12, 0x51, 0x3f, 0x7f, 0x43, 0x60, 0x4e, 0x9c, 0x95, 0x12, 0x51,
	0x82, 0xcd, 0x12, 0x01, 0x3b, 0x44, 0x60, 0xfb, 0xca, 0xf6, 0xa4, 0x21, 0x2c, 0x81, 0xf3, 0x7c,
	0xfd, 0x11, 0x81, 0x39, 0x71, 0x6e, 0x3e, 0x6f, 0xd8, 0xc1, 0x99, 0x5e, 0x89, 0x67, 0x4f, 0x8e,
	0xed, 0x7b, 0x04, 0xe6, 0x44, 0x55, 0x4c, 0xe4, 0xe4, 0xb1, 0xf5, 0x2e, 0xf0, 0x6c, 0x29, 0xa6,
	0x67, 0x7f, 0x1f, 0xdc, 0x24, 0x03, 0x10, 0x2f, 0x30, 0xb5, 0xf7, 0x10, 0xe8, 0xbb, 0xf4, 0xed,
	0xf1, 0x40, 0x2f, 0xc8, 0xea, 0xdf, 0x11, 0x80, 0xfe, 0xfb, 0x84, 0x47, 0xd7, 0x63, 0x02, 0x0f,
	0x3f, 0x67, 0xc4, 0xc2, 0xdd, 0x7f, 0x51, 0x79, 0x26, 0x25, 0x89, 0x09, 0xb4, 0x7f, 0x1e, 0x72,
	0x2d, 0x11, 0xfd, 0x60, 0xec, 0xea, 0x74, 0x67, 0xa2, 0x76, 0x13, 0x15, 0x39, 0x46, 0x45, 0x6a,
	0xf4, 0x60, 0x82, 0x42, 0x15, 0x5e, 0x5a, 0x33, 0x03, 0xc8, 0xbf, 0x25, 0xf0, 0x32, 0x97, 0x7c,
	0xd4, 0xfb, 0xff, 0x28, 0x74, 0x07, 0x15, 0x5a, 0xa7, 0x37, 0x63, 0xf7, 0x28, 0x7d, 0xe8, 0xbf,
	0x22, 0x70, 0x6d, 0xa0, 0x55, 0x09, 0x1e, 0x76, 0x62, 0x65, 0xe5, 0x64, 0x4d, 0xff, 0x78, 0xc0,
	0xc3, 0xb0, 0x8a, 0xbc, 0xfd, 0x3b, 0x81, 0xc2, 0xf9, 0xee, 0x25, 0xc0, 0x3c, 0x19, 0x9c, 0x49,
	0xb5, 0xf8, 0x06, 0x6a, 0x71, 0x4f, 0x79, 0x6f, 0xd2, 0x92, 0x3d, 0x4c, 0x4b, 0x5e, 0x22, 0x9f,
	0x10, 0x28, 0x9c, 0xbf, 0x38, 0x26, 0xf1, 0xcb, 0xd8, 0x6a, 0x19, 0x78, 0xa0, 0x34, 0x81, 0x07,
	0x7e, 0x42, 0xa0, 0x50, 0xc5, 0xf7, 0xae, 0xe7, 0x86, 0x6e, 0x1b, 0xd1, 0x6d, 0x28, 0xb7, 0x13,
	0xa3, 0x53, 0xc5, 0x4b, 0x1c, 0x82, 0xd4, 0xf0, 0x5d, 0xed, 0xf3, 0x08, 0x52, 0xbc, 0xf8, 0xd1,
	0x5f, 0x10, 0xb8, 0xd6, 0x3f, 0x4d, 0x42, 0xcf, 0x42, 0xb1, 0x6b, 0xc6, 0x5b, 0x13, 0xbc, 0x39,
	0x61, 0xc5, 0x58, 0x47, 0xec, 0x6b, 0xf4, 0xc6, 0x28, 0xec, 0xe2, 0x94, 0x51, 0x43, 0xaf, 0x4c,
	0xde, 0xce, 0xfe, 0x9f, 0x9e, 0x2e, 0x93, 0xbf, 0x3c, 0x5d, 0x26, 0x7f, 0x7b, 0xba, 0x4c, 0x3e,
	0xfb, 0xc7, 0xf2, 0x17, 0xbe, 0xb9, 0x1e, 0xfa, 0x33, 0x2f, 0x91, 0xac, 0x09, 0x29, 0x06, 0x97,
	0xec, 0x0d, 0x11, 0x5d, 0x9f, 0xc6, 0x37, 0xd0, 0xf5, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x89,
	0xd5, 0x1f, 0x2e, 0x29, 0x20, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ResourceManagerServiceClient is the client API for ResourceManagerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResourceManagerServiceClient interface {
	// Fetch all organizations that the authenticated user is a member of.
	// Required permissions:
	// - None
	ListOrganizations(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationList, error)
	// Fetch an organization by its id.
	// The authenticated user must be a member of the organization.
	// Required permissions:
	// - None
	GetOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Organization, error)
	// Create a new organization
	// Required permissions:
	// - None
	CreateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error)
	// Update an organization
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	UpdateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error)
	// Delete an organization
	// Note that organization are never really removed.
	// Instead their is_deleted field is set to true.
	// Required permissions:
	// - resourcemanager.organization.delete on the organization
	DeleteOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Get a list of members of the organization identified by the given context ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*MemberList, error)
	// Add one or more members to an organization.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	AddOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Remove one or more members from an organization.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	DeleteOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Is the user identified by the given user ID a member
	// of the organization identified by the given organization ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization, unless the requested user is identical to the authenticated user.
	// Note that if the identified user or organization does not exist, no is returned.
	IsMemberOfOrganization(ctx context.Context, in *IsMemberOfOrganizationRequest, opts ...grpc.CallOption) (*IsMemberOfOrganizationResponse, error)
	// Get a list of quota values for the organization identified by the given context ID.
	// If a quota is not specified on organization level, a (potentially tier specific) default
	// value is returned.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationQuotas(ctx context.Context, in *ListQuotasRequest, opts ...grpc.CallOption) (*QuotaList, error)
	// Fetch all projects in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.project.list on the organization identified by the given context ID
	ListProjects(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*ProjectList, error)
	// Fetch a project by its id.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.get on the project identified by the given ID
	GetProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Project, error)
	// Create a new project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.create on the organization that owns the project
	CreateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error)
	// Update a project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.update on the project
	UpdateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error)
	// Delete a project
	// Note that project are initially only marked for deleted.
	// Once all their resources are removed the project itself is deleted
	// and cannot be restored.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.delete on the project
	DeleteProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Get a list of quota values for the project identified by the given context ID.
	// If a quota is not specified on project level, a value from organization level
	// is returned.
	// Required permissions:
	// - resourcemanager.project.get on the project
	ListProjectQuotas(ctx context.Context, in *ListQuotasRequest, opts ...grpc.CallOption) (*QuotaList, error)
	// Fetch all events in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.event.list on the organization identified by the given context ID
	ListEvents(ctx context.Context, in *ListEventOptions, opts ...grpc.CallOption) (*EventList, error)
	// Fetch all organization invites in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.organization-invite.list on the invite.
	ListOrganizationInvites(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationInviteList, error)
	// Fetch all organization invites for the email address of the authenticated user.
	// Required permissions:
	// - None
	ListMyOrganizationInvites(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationInviteList, error)
	// Fetch an organization invite by its id.
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.get on the invite.
	GetOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*OrganizationInvite, error)
	// Create a new organization invite.
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.create on the organization that the invite is for.
	CreateOrganizationInvite(ctx context.Context, in *OrganizationInvite, opts ...grpc.CallOption) (*OrganizationInvite, error)
	// Delete an organization invite
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.delete on the invite
	DeleteOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Accept an organization invite
	// The authenticated user's email address must match the email address specified in
	// the invite.
	// Required permissions:
	// - None
	AcceptOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Reject an organization invite
	// The authenticated user's email address must match the email address specified in
	// the invite.
	// Required permissions:
	// - None
	RejectOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch descriptions for all quota kinds know by the platform.
	// Required permissions:
	// - None
	ListQuotaDescriptions(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*QuotaDescriptionList, error)
}

type resourceManagerServiceClient struct {
	cc *grpc.ClientConn
}

func NewResourceManagerServiceClient(cc *grpc.ClientConn) ResourceManagerServiceClient {
	return &resourceManagerServiceClient{cc}
}

func (c *resourceManagerServiceClient) ListOrganizations(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationList, error) {
	out := new(OrganizationList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) CreateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) UpdateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListOrganizationMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*MemberList, error) {
	out := new(MemberList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) AddOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AddOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) IsMemberOfOrganization(ctx context.Context, in *IsMemberOfOrganizationRequest, opts ...grpc.CallOption) (*IsMemberOfOrganizationResponse, error) {
	out := new(IsMemberOfOrganizationResponse)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/IsMemberOfOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListOrganizationQuotas(ctx context.Context, in *ListQuotasRequest, opts ...grpc.CallOption) (*QuotaList, error) {
	out := new(QuotaList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationQuotas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListProjects(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*ProjectList, error) {
	out := new(ProjectList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) CreateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) UpdateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListProjectQuotas(ctx context.Context, in *ListQuotasRequest, opts ...grpc.CallOption) (*QuotaList, error) {
	out := new(QuotaList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjectQuotas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListEvents(ctx context.Context, in *ListEventOptions, opts ...grpc.CallOption) (*EventList, error) {
	out := new(EventList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListOrganizationInvites(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationInviteList, error) {
	out := new(OrganizationInviteList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationInvites", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListMyOrganizationInvites(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationInviteList, error) {
	out := new(OrganizationInviteList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListMyOrganizationInvites", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*OrganizationInvite, error) {
	out := new(OrganizationInvite)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) CreateOrganizationInvite(ctx context.Context, in *OrganizationInvite, opts ...grpc.CallOption) (*OrganizationInvite, error) {
	out := new(OrganizationInvite)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) AcceptOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AcceptOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) RejectOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/RejectOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListQuotaDescriptions(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*QuotaDescriptionList, error) {
	out := new(QuotaDescriptionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListQuotaDescriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResourceManagerServiceServer is the server API for ResourceManagerService service.
type ResourceManagerServiceServer interface {
	// Fetch all organizations that the authenticated user is a member of.
	// Required permissions:
	// - None
	ListOrganizations(context.Context, *v1.ListOptions) (*OrganizationList, error)
	// Fetch an organization by its id.
	// The authenticated user must be a member of the organization.
	// Required permissions:
	// - None
	GetOrganization(context.Context, *v1.IDOptions) (*Organization, error)
	// Create a new organization
	// Required permissions:
	// - None
	CreateOrganization(context.Context, *Organization) (*Organization, error)
	// Update an organization
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	UpdateOrganization(context.Context, *Organization) (*Organization, error)
	// Delete an organization
	// Note that organization are never really removed.
	// Instead their is_deleted field is set to true.
	// Required permissions:
	// - resourcemanager.organization.delete on the organization
	DeleteOrganization(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Get a list of members of the organization identified by the given context ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationMembers(context.Context, *v1.ListOptions) (*MemberList, error)
	// Add one or more members to an organization.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	AddOrganizationMembers(context.Context, *OrganizationMembersRequest) (*v1.Empty, error)
	// Remove one or more members from an organization.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	DeleteOrganizationMembers(context.Context, *OrganizationMembersRequest) (*v1.Empty, error)
	// Is the user identified by the given user ID a member
	// of the organization identified by the given organization ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization, unless the requested user is identical to the authenticated user.
	// Note that if the identified user or organization does not exist, no is returned.
	IsMemberOfOrganization(context.Context, *IsMemberOfOrganizationRequest) (*IsMemberOfOrganizationResponse, error)
	// Get a list of quota values for the organization identified by the given context ID.
	// If a quota is not specified on organization level, a (potentially tier specific) default
	// value is returned.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationQuotas(context.Context, *ListQuotasRequest) (*QuotaList, error)
	// Fetch all projects in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.project.list on the organization identified by the given context ID
	ListProjects(context.Context, *v1.ListOptions) (*ProjectList, error)
	// Fetch a project by its id.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.get on the project identified by the given ID
	GetProject(context.Context, *v1.IDOptions) (*Project, error)
	// Create a new project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.create on the organization that owns the project
	CreateProject(context.Context, *Project) (*Project, error)
	// Update a project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.update on the project
	UpdateProject(context.Context, *Project) (*Project, error)
	// Delete a project
	// Note that project are initially only marked for deleted.
	// Once all their resources are removed the project itself is deleted
	// and cannot be restored.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.delete on the project
	DeleteProject(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Get a list of quota values for the project identified by the given context ID.
	// If a quota is not specified on project level, a value from organization level
	// is returned.
	// Required permissions:
	// - resourcemanager.project.get on the project
	ListProjectQuotas(context.Context, *ListQuotasRequest) (*QuotaList, error)
	// Fetch all events in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.event.list on the organization identified by the given context ID
	ListEvents(context.Context, *ListEventOptions) (*EventList, error)
	// Fetch all organization invites in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.organization-invite.list on the invite.
	ListOrganizationInvites(context.Context, *v1.ListOptions) (*OrganizationInviteList, error)
	// Fetch all organization invites for the email address of the authenticated user.
	// Required permissions:
	// - None
	ListMyOrganizationInvites(context.Context, *v1.ListOptions) (*OrganizationInviteList, error)
	// Fetch an organization invite by its id.
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.get on the invite.
	GetOrganizationInvite(context.Context, *v1.IDOptions) (*OrganizationInvite, error)
	// Create a new organization invite.
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.create on the organization that the invite is for.
	CreateOrganizationInvite(context.Context, *OrganizationInvite) (*OrganizationInvite, error)
	// Delete an organization invite
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.delete on the invite
	DeleteOrganizationInvite(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Accept an organization invite
	// The authenticated user's email address must match the email address specified in
	// the invite.
	// Required permissions:
	// - None
	AcceptOrganizationInvite(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Reject an organization invite
	// The authenticated user's email address must match the email address specified in
	// the invite.
	// Required permissions:
	// - None
	RejectOrganizationInvite(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch descriptions for all quota kinds know by the platform.
	// Required permissions:
	// - None
	ListQuotaDescriptions(context.Context, *v1.ListOptions) (*QuotaDescriptionList, error)
}

func RegisterResourceManagerServiceServer(s *grpc.Server, srv ResourceManagerServiceServer) {
	s.RegisterService(&_ResourceManagerService_serviceDesc, srv)
}

func _ResourceManagerService_ListOrganizations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizations(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetOrganization(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_CreateOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Organization)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).CreateOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).CreateOrganization(ctx, req.(*Organization))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_UpdateOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Organization)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).UpdateOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).UpdateOrganization(ctx, req.(*Organization))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteOrganization(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizationMembers(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_AddOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).AddOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AddOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).AddOrganizationMembers(ctx, req.(*OrganizationMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationMembers(ctx, req.(*OrganizationMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_IsMemberOfOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsMemberOfOrganizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).IsMemberOfOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/IsMemberOfOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).IsMemberOfOrganization(ctx, req.(*IsMemberOfOrganizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListOrganizationQuotas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQuotasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizationQuotas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationQuotas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizationQuotas(ctx, req.(*ListQuotasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListProjects(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetProject(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_CreateProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Project)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).CreateProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).CreateProject(ctx, req.(*Project))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_UpdateProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Project)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).UpdateProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).UpdateProject(ctx, req.(*Project))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteProject(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListProjectQuotas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQuotasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListProjectQuotas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjectQuotas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListProjectQuotas(ctx, req.(*ListQuotasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListEvents(ctx, req.(*ListEventOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListOrganizationInvites_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizationInvites(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationInvites",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizationInvites(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListMyOrganizationInvites_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListMyOrganizationInvites(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListMyOrganizationInvites",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListMyOrganizationInvites(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetOrganizationInvite(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_CreateOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationInvite)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).CreateOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).CreateOrganizationInvite(ctx, req.(*OrganizationInvite))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationInvite(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_AcceptOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).AcceptOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AcceptOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).AcceptOrganizationInvite(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_RejectOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).RejectOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/RejectOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).RejectOrganizationInvite(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListQuotaDescriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListQuotaDescriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListQuotaDescriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListQuotaDescriptions(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResourceManagerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.resourcemanager.v1.ResourceManagerService",
	HandlerType: (*ResourceManagerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListOrganizations",
			Handler:    _ResourceManagerService_ListOrganizations_Handler,
		},
		{
			MethodName: "GetOrganization",
			Handler:    _ResourceManagerService_GetOrganization_Handler,
		},
		{
			MethodName: "CreateOrganization",
			Handler:    _ResourceManagerService_CreateOrganization_Handler,
		},
		{
			MethodName: "UpdateOrganization",
			Handler:    _ResourceManagerService_UpdateOrganization_Handler,
		},
		{
			MethodName: "DeleteOrganization",
			Handler:    _ResourceManagerService_DeleteOrganization_Handler,
		},
		{
			MethodName: "ListOrganizationMembers",
			Handler:    _ResourceManagerService_ListOrganizationMembers_Handler,
		},
		{
			MethodName: "AddOrganizationMembers",
			Handler:    _ResourceManagerService_AddOrganizationMembers_Handler,
		},
		{
			MethodName: "DeleteOrganizationMembers",
			Handler:    _ResourceManagerService_DeleteOrganizationMembers_Handler,
		},
		{
			MethodName: "IsMemberOfOrganization",
			Handler:    _ResourceManagerService_IsMemberOfOrganization_Handler,
		},
		{
			MethodName: "ListOrganizationQuotas",
			Handler:    _ResourceManagerService_ListOrganizationQuotas_Handler,
		},
		{
			MethodName: "ListProjects",
			Handler:    _ResourceManagerService_ListProjects_Handler,
		},
		{
			MethodName: "GetProject",
			Handler:    _ResourceManagerService_GetProject_Handler,
		},
		{
			MethodName: "CreateProject",
			Handler:    _ResourceManagerService_CreateProject_Handler,
		},
		{
			MethodName: "UpdateProject",
			Handler:    _ResourceManagerService_UpdateProject_Handler,
		},
		{
			MethodName: "DeleteProject",
			Handler:    _ResourceManagerService_DeleteProject_Handler,
		},
		{
			MethodName: "ListProjectQuotas",
			Handler:    _ResourceManagerService_ListProjectQuotas_Handler,
		},
		{
			MethodName: "ListEvents",
			Handler:    _ResourceManagerService_ListEvents_Handler,
		},
		{
			MethodName: "ListOrganizationInvites",
			Handler:    _ResourceManagerService_ListOrganizationInvites_Handler,
		},
		{
			MethodName: "ListMyOrganizationInvites",
			Handler:    _ResourceManagerService_ListMyOrganizationInvites_Handler,
		},
		{
			MethodName: "GetOrganizationInvite",
			Handler:    _ResourceManagerService_GetOrganizationInvite_Handler,
		},
		{
			MethodName: "CreateOrganizationInvite",
			Handler:    _ResourceManagerService_CreateOrganizationInvite_Handler,
		},
		{
			MethodName: "DeleteOrganizationInvite",
			Handler:    _ResourceManagerService_DeleteOrganizationInvite_Handler,
		},
		{
			MethodName: "AcceptOrganizationInvite",
			Handler:    _ResourceManagerService_AcceptOrganizationInvite_Handler,
		},
		{
			MethodName: "RejectOrganizationInvite",
			Handler:    _ResourceManagerService_RejectOrganizationInvite_Handler,
		},
		{
			MethodName: "ListQuotaDescriptions",
			Handler:    _ResourceManagerService_ListQuotaDescriptions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "resourcemanager.proto",
}

func (m *Organization) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Organization) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.IsDeleted {
		dAtA[i] = 0x28
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.CreatedAt.Size()))
		n1, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.DeletedAt.Size()))
		n2, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Tier != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Tier.Size()))
		n3, err := m.Tier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.TotalDeployments) > 0 {
		for k, _ := range m.TotalDeployments {
			dAtA[i] = 0x4a
			i++
			v := m.TotalDeployments[k]
			mapSize := 1 + len(k) + sovResourcemanager(uint64(len(k))) + 1 + sovResourcemanager(uint64(v))
			i = encodeVarintResourcemanager(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(v))
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OrganizationList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Budget != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Budget.Size()))
		n4, err := m.Budget.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Tier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tier) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.HasSupportPlans {
		dAtA[i] = 0x18
		i++
		if m.HasSupportPlans {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Member) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Member) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UserId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.UserId)))
		i += copy(dAtA[i:], m.UserId)
	}
	if m.Owner {
		dAtA[i] = 0x10
		i++
		if m.Owner {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MemberList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemberList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *IsMemberOfOrganizationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsMemberOfOrganizationRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UserId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.UserId)))
		i += copy(dAtA[i:], m.UserId)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *IsMemberOfOrganizationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsMemberOfOrganizationResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Member {
		dAtA[i] = 0x8
		i++
		if m.Member {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Owner {
		dAtA[i] = 0x10
		i++
		if m.Owner {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OrganizationMembersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationMembersRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if m.Members != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Members.Size()))
		n5, err := m.Members.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Project) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Project) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if m.IsDeleted {
		dAtA[i] = 0x30
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.CreatedAt.Size()))
		n6, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.DeletedAt.Size()))
		n7, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ProjectList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProjectList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Budget != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Budget.Size()))
		n8, err := m.Budget.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if len(m.SubjectId) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.SubjectId)))
		i += copy(dAtA[i:], m.SubjectId)
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if len(m.Payload) > 0 {
		for k, _ := range m.Payload {
			dAtA[i] = 0x32
			i++
			v := m.Payload[k]
			mapSize := 1 + len(k) + sovResourcemanager(uint64(len(k))) + 1 + len(v) + sovResourcemanager(uint64(len(v)))
			i = encodeVarintResourcemanager(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.CreatedAt.Size()))
		n9, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.SubjectUrl) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.SubjectUrl)))
		i += copy(dAtA[i:], m.SubjectUrl)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EventList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ListEventOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListEventOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Options != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Options.Size()))
		n10, err := m.Options.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if len(m.SubjectIds) > 0 {
		for _, s := range m.SubjectIds {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Types) > 0 {
		for _, s := range m.Types {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.CreatedAfter != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.CreatedAfter.Size()))
		n11, err := m.CreatedAfter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.CreatedBefore != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.CreatedBefore.Size()))
		n12, err := m.CreatedBefore.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OrganizationInvite) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationInvite) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if len(m.Email) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Email)))
		i += copy(dAtA[i:], m.Email)
	}
	if m.Accepted {
		dAtA[i] = 0x28
		i++
		if m.Accepted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Rejected {
		dAtA[i] = 0x30
		i++
		if m.Rejected {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.CreatedAt.Size()))
		n13, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.AcceptedAt != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.AcceptedAt.Size()))
		n14, err := m.AcceptedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.RejectedAt != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.RejectedAt.Size()))
		n15, err := m.RejectedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if len(m.UserId) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.UserId)))
		i += copy(dAtA[i:], m.UserId)
	}
	if len(m.CreatedById) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.CreatedById)))
		i += copy(dAtA[i:], m.CreatedById)
	}
	if len(m.OrganizationName) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationName)))
		i += copy(dAtA[i:], m.OrganizationName)
	}
	if len(m.CreatedByName) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.CreatedByName)))
		i += copy(dAtA[i:], m.CreatedByName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *OrganizationInviteList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationInviteList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *QuotaDescription) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaDescription) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.ForOrganizations {
		dAtA[i] = 0x18
		i++
		if m.ForOrganizations {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ForProjects {
		dAtA[i] = 0x20
		i++
		if m.ForProjects {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *QuotaDescriptionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaDescriptionList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Quota) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Quota) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.Limit != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *QuotaList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintResourcemanager(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ListQuotasRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListQuotasRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Options != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Options.Size()))
		n16, err := m.Options.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if len(m.Kinds) > 0 {
		for _, s := range m.Kinds {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintResourcemanager(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Organization) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Tier != nil {
		l = m.Tier.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if len(m.TotalDeployments) > 0 {
		for k, v := range m.TotalDeployments {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovResourcemanager(uint64(len(k))) + 1 + sovResourcemanager(uint64(v))
			n += mapEntrySize + 1 + sovResourcemanager(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.Budget != nil {
		l = m.Budget.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tier) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.HasSupportPlans {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Member) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Owner {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MemberList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IsMemberOfOrganizationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IsMemberOfOrganizationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Member {
		n += 2
	}
	if m.Owner {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationMembersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Members != nil {
		l = m.Members.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Project) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProjectList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.Budget != nil {
		l = m.Budget.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.SubjectId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if len(m.Payload) > 0 {
		for k, v := range m.Payload {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovResourcemanager(uint64(len(k))) + 1 + len(v) + sovResourcemanager(uint64(len(v)))
			n += mapEntrySize + 1 + sovResourcemanager(uint64(mapEntrySize))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.SubjectUrl)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListEventOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if len(m.SubjectIds) > 0 {
		for _, s := range m.SubjectIds {
			l = len(s)
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if len(m.Types) > 0 {
		for _, s := range m.Types {
			l = len(s)
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.CreatedAfter != nil {
		l = m.CreatedAfter.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.CreatedBefore != nil {
		l = m.CreatedBefore.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationInvite) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Email)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Accepted {
		n += 2
	}
	if m.Rejected {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.AcceptedAt != nil {
		l = m.AcceptedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.RejectedAt != nil {
		l = m.RejectedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationName)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.CreatedByName)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationInviteList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuotaDescription) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.ForOrganizations {
		n += 2
	}
	if m.ForProjects {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuotaDescriptionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Quota) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Limit != 0 {
		n += 1 + sovResourcemanager(uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuotaList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListQuotasRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if len(m.Kinds) > 0 {
		for _, s := range m.Kinds {
			l = len(s)
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovResourcemanager(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozResourcemanager(x uint64) (n int) {
	return sovResourcemanager(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Organization) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Organization: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Organization: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tier", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tier == nil {
				m.Tier = &Tier{}
			}
			if err := m.Tier.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalDeployments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TotalDeployments == nil {
				m.TotalDeployments = make(map[string]int32)
			}
			var mapkey string
			var mapvalue int32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowResourcemanager
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowResourcemanager
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthResourcemanager
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowResourcemanager
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipResourcemanager(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TotalDeployments[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Organization{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Budget", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Budget == nil {
				m.Budget = &v1.Budget{}
			}
			if err := m.Budget.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tier) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tier: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tier: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasSupportPlans", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasSupportPlans = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Member) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Member: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Member: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Owner = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemberList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemberList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemberList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Member{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsMemberOfOrganizationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsMemberOfOrganizationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsMemberOfOrganizationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsMemberOfOrganizationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsMemberOfOrganizationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsMemberOfOrganizationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Member", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Member = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Owner = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationMembersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationMembersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationMembersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Members", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Members == nil {
				m.Members = &MemberList{}
			}
			if err := m.Members.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Project) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Project: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Project: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProjectList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProjectList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProjectList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Project{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Budget", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Budget == nil {
				m.Budget = &v1.Budget{}
			}
			if err := m.Budget.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Payload == nil {
				m.Payload = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowResourcemanager
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowResourcemanager
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthResourcemanager
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowResourcemanager
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthResourcemanager
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipResourcemanager(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Payload[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Event{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListEventOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListEventOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListEventOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectIds = append(m.SubjectIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Types", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Types = append(m.Types, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAfter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAfter == nil {
				m.CreatedAfter = &types.Timestamp{}
			}
			if err := m.CreatedAfter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedBefore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedBefore == nil {
				m.CreatedBefore = &types.Timestamp{}
			}
			if err := m.CreatedBefore.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationInvite) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationInvite: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationInvite: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Email", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Email = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Accepted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Accepted = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rejected", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Rejected = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AcceptedAt == nil {
				m.AcceptedAt = &types.Timestamp{}
			}
			if err := m.AcceptedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RejectedAt == nil {
				m.RejectedAt = &types.Timestamp{}
			}
			if err := m.RejectedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedByName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedByName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationInviteList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationInviteList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationInviteList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &OrganizationInvite{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaDescription) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForOrganizations", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForOrganizations = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForProjects", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForProjects = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaDescriptionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaDescriptionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaDescriptionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &QuotaDescription{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Quota) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Quota: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Quota: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Quota{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListQuotasRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListQuotasRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListQuotasRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kinds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kinds = append(m.Kinds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipResourcemanager(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthResourcemanager
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthResourcemanager
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowResourcemanager
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipResourcemanager(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthResourcemanager
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthResourcemanager = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowResourcemanager   = fmt.Errorf("proto: integer overflow")
)
