// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: currency.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Currency represents a specific monetary currency.
type Currency struct {
	// System identifier of the currency.
	// E.g. "eur" or "usd"
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human readable name of the currency
	// E.g. "US Dollar"
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Human readable sign for the currency.
	// E.g. "$"
	Sign                 string   `protobuf:"bytes,3,opt,name=sign,proto3" json:"sign,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Currency) Reset()         { *m = Currency{} }
func (m *Currency) String() string { return proto.CompactTextString(m) }
func (*Currency) ProtoMessage()    {}
func (*Currency) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3dc60ed002193ea, []int{0}
}
func (m *Currency) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Currency) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Currency.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Currency) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Currency.Merge(m, src)
}
func (m *Currency) XXX_Size() int {
	return m.Size()
}
func (m *Currency) XXX_DiscardUnknown() {
	xxx_messageInfo_Currency.DiscardUnknown(m)
}

var xxx_messageInfo_Currency proto.InternalMessageInfo

func (m *Currency) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Currency) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Currency) GetSign() string {
	if m != nil {
		return m.Sign
	}
	return ""
}

// List of currencies.
type CurrencyList struct {
	Items                []*Currency `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CurrencyList) Reset()         { *m = CurrencyList{} }
func (m *CurrencyList) String() string { return proto.CompactTextString(m) }
func (*CurrencyList) ProtoMessage()    {}
func (*CurrencyList) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3dc60ed002193ea, []int{1}
}
func (m *CurrencyList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CurrencyList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CurrencyList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CurrencyList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CurrencyList.Merge(m, src)
}
func (m *CurrencyList) XXX_Size() int {
	return m.Size()
}
func (m *CurrencyList) XXX_DiscardUnknown() {
	xxx_messageInfo_CurrencyList.DiscardUnknown(m)
}

var xxx_messageInfo_CurrencyList proto.InternalMessageInfo

func (m *CurrencyList) GetItems() []*Currency {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for GetDefaultCurrency.
type GetDefaultCurrencyRequest struct {
	// Optional identifier for the organization to request the default
	// currency for.
	OrganizationId       string   `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDefaultCurrencyRequest) Reset()         { *m = GetDefaultCurrencyRequest{} }
func (m *GetDefaultCurrencyRequest) String() string { return proto.CompactTextString(m) }
func (*GetDefaultCurrencyRequest) ProtoMessage()    {}
func (*GetDefaultCurrencyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3dc60ed002193ea, []int{2}
}
func (m *GetDefaultCurrencyRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDefaultCurrencyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDefaultCurrencyRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDefaultCurrencyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDefaultCurrencyRequest.Merge(m, src)
}
func (m *GetDefaultCurrencyRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDefaultCurrencyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDefaultCurrencyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDefaultCurrencyRequest proto.InternalMessageInfo

func (m *GetDefaultCurrencyRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func init() {
	proto.RegisterType((*Currency)(nil), "arangodb.cloud.currency.v1.Currency")
	proto.RegisterType((*CurrencyList)(nil), "arangodb.cloud.currency.v1.CurrencyList")
	proto.RegisterType((*GetDefaultCurrencyRequest)(nil), "arangodb.cloud.currency.v1.GetDefaultCurrencyRequest")
}

func init() { proto.RegisterFile("currency.proto", fileDescriptor_d3dc60ed002193ea) }

var fileDescriptor_d3dc60ed002193ea = []byte{
	// 414 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x52, 0xcf, 0x4a, 0xe3, 0x40,
	0x18, 0xdf, 0x49, 0x77, 0x97, 0xdd, 0xe9, 0x92, 0xc2, 0x1c, 0x96, 0x6c, 0x76, 0x37, 0x74, 0xd3,
	0x5d, 0x36, 0x0b, 0xdb, 0x84, 0x56, 0xbc, 0x78, 0xf0, 0x50, 0x0b, 0xa5, 0x22, 0x08, 0xf5, 0xe6,
	0x45, 0xa6, 0x99, 0x31, 0x0e, 0x34, 0x33, 0x35, 0x99, 0x04, 0x54, 0xbc, 0xf4, 0xe0, 0x0b, 0x78,
	0xf1, 0xe0, 0xb3, 0x78, 0xf6, 0x28, 0xf8, 0x02, 0x52, 0x7d, 0x10, 0xc9, 0xa4, 0x89, 0x85, 0xd2,
	0xd2, 0xdb, 0xc7, 0xef, 0xcb, 0xef, 0xcf, 0xf7, 0x9b, 0x40, 0xdd, 0x4f, 0xa2, 0x88, 0x72, 0xff,
	0xcc, 0x1d, 0x47, 0x42, 0x0a, 0x64, 0xe2, 0x08, 0xf3, 0x40, 0x90, 0xa1, 0xeb, 0x8f, 0x44, 0x42,
	0xdc, 0x72, 0x9d, 0xb6, 0xcc, 0xaf, 0xbe, 0x08, 0x43, 0xc1, 0xbd, 0xb4, 0xe5, 0xe5, 0x53, 0xce,
	0x31, 0x7f, 0x04, 0x42, 0x04, 0x23, 0xea, 0xe1, 0x31, 0xf3, 0x30, 0xe7, 0x42, 0x62, 0xc9, 0x04,
	0x8f, 0xf3, 0xad, 0xdd, 0x81, 0x9f, 0x76, 0x66, 0x22, 0x48, 0x87, 0x1a, 0x23, 0x06, 0xa8, 0x03,
	0xe7, 0xf3, 0x40, 0x63, 0x04, 0x21, 0xf8, 0x9e, 0xe3, 0x90, 0x1a, 0x9a, 0x42, 0xd4, 0x9c, 0x61,
	0x31, 0x0b, 0xb8, 0x51, 0xc9, 0xb1, 0x6c, 0xb6, 0x77, 0xe1, 0x97, 0x42, 0x63, 0x8f, 0xc5, 0x12,
	0x6d, 0xc1, 0x0f, 0x4c, 0xd2, 0x30, 0x36, 0x40, 0xbd, 0xe2, 0x54, 0xdb, 0xbf, 0xdd, 0xe5, 0xa9,
	0xdd, 0x82, 0x38, 0xc8, 0x29, 0x76, 0x17, 0x7e, 0xeb, 0x51, 0xd9, 0xa5, 0xc7, 0x38, 0x19, 0xc9,
	0x72, 0x49, 0x4f, 0x13, 0x1a, 0x4b, 0xf4, 0x17, 0xd6, 0x44, 0x14, 0x60, 0xce, 0xce, 0xd5, 0x0d,
	0x47, 0x65, 0x5a, 0x7d, 0x1e, 0xee, 0x93, 0xf6, 0x5d, 0x05, 0xd6, 0x0a, 0xf2, 0x01, 0x8d, 0x52,
	0xe6, 0x53, 0x74, 0x05, 0xa0, 0x9e, 0xc5, 0x9b, 0xe1, 0x8c, 0xc6, 0xe8, 0xcf, 0x42, 0xb2, 0xbc,
	0xb8, 0xb4, 0xe5, 0x66, 0x5f, 0xee, 0x8f, 0x55, 0x53, 0xa6, 0xb3, 0xce, 0x01, 0x19, 0xc1, 0x6e,
	0x4c, 0x1e, 0x5f, 0xae, 0xb5, 0x9f, 0xe8, 0xbb, 0x6a, 0xbb, 0xf8, 0x4c, 0x3d, 0xc9, 0x9b, 0xeb,
	0x04, 0xc0, 0x6a, 0x8f, 0x96, 0xc7, 0xa1, 0xc6, 0xf2, 0x14, 0xfd, 0x6e, 0x91, 0x61, 0xad, 0x12,
	0x6d, 0x47, 0xf9, 0xdb, 0xa8, 0xbe, 0xc2, 0xdf, 0xbb, 0x60, 0xe4, 0x12, 0xdd, 0x02, 0x88, 0x16,
	0x8b, 0x46, 0x9b, 0xab, 0x6c, 0x96, 0x3e, 0xcc, 0x9a, 0xe9, 0xfe, 0xa9, 0x74, 0x0d, 0xf4, 0x6b,
	0x21, 0x1d, 0xc9, 0x65, 0x9b, 0x05, 0xd6, 0xd9, 0xbe, 0x9f, 0x5a, 0xe0, 0x61, 0x6a, 0x81, 0xa7,
	0xa9, 0x05, 0x6e, 0x9e, 0xad, 0x77, 0x87, 0xff, 0x03, 0x26, 0x4f, 0x92, 0x61, 0x56, 0x8e, 0x57,
	0x98, 0x35, 0x43, 0xcc, 0x71, 0x40, 0x49, 0xa6, 0x17, 0xcf, 0x0b, 0x0e, 0x3f, 0xaa, 0xbf, 0x7b,
	0xe3, 0x35, 0x00, 0x00, 0xff, 0xff, 0xe7, 0x83, 0x48, 0x35, 0x41, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CurrencyServiceClient is the client API for CurrencyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CurrencyServiceClient interface {
	// Fetch all providers that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListCurrencies(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*CurrencyList, error)
	// Fetch a currency by its id.
	// Required permissions:
	// - None
	GetCurrency(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Currency, error)
	// Fetch the default currency for a given (optional) organization.
	// Required permissions:
	// - resourcemanager.organization.get On the organization identified by given id.
	// - None In case no organization identifier was given.
	GetDefaultCurrency(ctx context.Context, in *GetDefaultCurrencyRequest, opts ...grpc.CallOption) (*Currency, error)
}

type currencyServiceClient struct {
	cc *grpc.ClientConn
}

func NewCurrencyServiceClient(cc *grpc.ClientConn) CurrencyServiceClient {
	return &currencyServiceClient{cc}
}

func (c *currencyServiceClient) ListCurrencies(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*CurrencyList, error) {
	out := new(CurrencyList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.currency.v1.CurrencyService/ListCurrencies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *currencyServiceClient) GetCurrency(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Currency, error) {
	out := new(Currency)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.currency.v1.CurrencyService/GetCurrency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *currencyServiceClient) GetDefaultCurrency(ctx context.Context, in *GetDefaultCurrencyRequest, opts ...grpc.CallOption) (*Currency, error) {
	out := new(Currency)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.currency.v1.CurrencyService/GetDefaultCurrency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CurrencyServiceServer is the server API for CurrencyService service.
type CurrencyServiceServer interface {
	// Fetch all providers that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListCurrencies(context.Context, *v1.ListOptions) (*CurrencyList, error)
	// Fetch a currency by its id.
	// Required permissions:
	// - None
	GetCurrency(context.Context, *v1.IDOptions) (*Currency, error)
	// Fetch the default currency for a given (optional) organization.
	// Required permissions:
	// - resourcemanager.organization.get On the organization identified by given id.
	// - None In case no organization identifier was given.
	GetDefaultCurrency(context.Context, *GetDefaultCurrencyRequest) (*Currency, error)
}

func RegisterCurrencyServiceServer(s *grpc.Server, srv CurrencyServiceServer) {
	s.RegisterService(&_CurrencyService_serviceDesc, srv)
}

func _CurrencyService_ListCurrencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CurrencyServiceServer).ListCurrencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.currency.v1.CurrencyService/ListCurrencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CurrencyServiceServer).ListCurrencies(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CurrencyService_GetCurrency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CurrencyServiceServer).GetCurrency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.currency.v1.CurrencyService/GetCurrency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CurrencyServiceServer).GetCurrency(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CurrencyService_GetDefaultCurrency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefaultCurrencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CurrencyServiceServer).GetDefaultCurrency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.currency.v1.CurrencyService/GetDefaultCurrency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CurrencyServiceServer).GetDefaultCurrency(ctx, req.(*GetDefaultCurrencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CurrencyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.currency.v1.CurrencyService",
	HandlerType: (*CurrencyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCurrencies",
			Handler:    _CurrencyService_ListCurrencies_Handler,
		},
		{
			MethodName: "GetCurrency",
			Handler:    _CurrencyService_GetCurrency_Handler,
		},
		{
			MethodName: "GetDefaultCurrency",
			Handler:    _CurrencyService_GetDefaultCurrency_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "currency.proto",
}

func (m *Currency) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Currency) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Sign) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.Sign)))
		i += copy(dAtA[i:], m.Sign)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CurrencyList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CurrencyList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCurrency(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GetDefaultCurrencyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDefaultCurrencyRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintCurrency(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Currency) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	l = len(m.Sign)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CurrencyList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovCurrency(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetDefaultCurrencyRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCurrency(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCurrency(x uint64) (n int) {
	return sovCurrency(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Currency) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCurrency
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Currency: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Currency: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sign", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sign = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCurrency(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CurrencyList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCurrency
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CurrencyList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CurrencyList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Currency{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCurrency(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDefaultCurrencyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCurrency
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDefaultCurrencyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDefaultCurrencyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCurrency(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCurrency(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCurrency
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCurrency
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthCurrency
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCurrency
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCurrency(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthCurrency
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCurrency = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCurrency   = fmt.Errorf("proto: integer overflow")
)
