// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: backup.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	v11 "github.com/arangodb-managed/apis/data/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// BackupPolicy represents a single backup policy for a deployment.
type BackupPolicy struct {
	// System identifier of the backup policy.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the backup policy
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the backup policy
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the deployment that owns this backup policy.
	// After creation, this value cannot be changed.
	DeploymentId string `protobuf:"bytes,5,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// The creation timestamp of the backup policy
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the backup policy
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,7,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this backup policy is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,8,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Pause this backup policy.
	// If a backup policy is paused, the backup policy will not result in new backups.
	// The backup policy isn't deleted, unsetting this field will resume the creation of backups again.
	IsPaused bool `protobuf:"varint,9,opt,name=is_paused,json=isPaused,proto3" json:"is_paused,omitempty"`
	// The schedule for this backup policy
	Schedule *BackupPolicy_Schedule `protobuf:"bytes,10,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Upload the backup, created by the backup policy, to an external source.
	Upload bool `protobuf:"varint,11,opt,name=upload,proto3" json:"upload,omitempty"`
	// Backups created by this policy will be automatically deleted after the specified retention period
	// A value of 0 means that backup will never be deleted.
	RetentionPeriod *types.Duration `protobuf:"bytes,12,opt,name=retention_period,json=retentionPeriod,proto3" json:"retention_period,omitempty"`
	// The owners of the organization can be notified by email
	// This field support the following values: "None|FailureOnly|Always"
	EmailNotification string `protobuf:"bytes,13,opt,name=email_notification,json=emailNotification,proto3" json:"email_notification,omitempty"`
	// Status of the backup policy
	Status               *BackupPolicy_Status `protobuf:"bytes,100,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BackupPolicy) Reset()         { *m = BackupPolicy{} }
func (m *BackupPolicy) String() string { return proto.CompactTextString(m) }
func (*BackupPolicy) ProtoMessage()    {}
func (*BackupPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{0}
}
func (m *BackupPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BackupPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupPolicy.Merge(m, src)
}
func (m *BackupPolicy) XXX_Size() int {
	return m.Size()
}
func (m *BackupPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_BackupPolicy proto.InternalMessageInfo

func (m *BackupPolicy) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BackupPolicy) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *BackupPolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BackupPolicy) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *BackupPolicy) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *BackupPolicy) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *BackupPolicy) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *BackupPolicy) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *BackupPolicy) GetIsPaused() bool {
	if m != nil {
		return m.IsPaused
	}
	return false
}

func (m *BackupPolicy) GetSchedule() *BackupPolicy_Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *BackupPolicy) GetUpload() bool {
	if m != nil {
		return m.Upload
	}
	return false
}

func (m *BackupPolicy) GetRetentionPeriod() *types.Duration {
	if m != nil {
		return m.RetentionPeriod
	}
	return nil
}

func (m *BackupPolicy) GetEmailNotification() string {
	if m != nil {
		return m.EmailNotification
	}
	return ""
}

func (m *BackupPolicy) GetStatus() *BackupPolicy_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

type BackupPolicy_Schedule struct {
	// Schedule type should be one of the following string: "Hourly|Daily|Monthly"
	// The schedule_hourly, schedule_daily or schedule_montly field should be set
	// Setting multiple fields, or inconsistent with this field result in an error during create/update
	ScheduleType string `protobuf:"bytes,1,opt,name=schedule_type,json=scheduleType,proto3" json:"schedule_type,omitempty"`
	// Schedule applies to the selected day of the week
	// This is applicable for Hourly type only, ignored for Daily and Monthly
	HourlySchedule *BackupPolicy_HourlySchedule `protobuf:"bytes,2,opt,name=hourly_schedule,json=hourlySchedule,proto3" json:"hourly_schedule,omitempty"`
	// Schedule applies to the selected day of the week
	// This is applicable for Daily type only, ignored for Hourly and Monthly
	DailySchedule *BackupPolicy_DailySchedule `protobuf:"bytes,3,opt,name=daily_schedule,json=dailySchedule,proto3" json:"daily_schedule,omitempty"`
	// Schedule applies to the selected day of the month
	// This is applicable for Monthly type only, ignored for Hourly and Daily
	MonthlySchedule      *BackupPolicy_MonthlySchedule `protobuf:"bytes,4,opt,name=monthly_schedule,json=monthlySchedule,proto3" json:"monthly_schedule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *BackupPolicy_Schedule) Reset()         { *m = BackupPolicy_Schedule{} }
func (m *BackupPolicy_Schedule) String() string { return proto.CompactTextString(m) }
func (*BackupPolicy_Schedule) ProtoMessage()    {}
func (*BackupPolicy_Schedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{0, 0}
}
func (m *BackupPolicy_Schedule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupPolicy_Schedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupPolicy_Schedule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BackupPolicy_Schedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupPolicy_Schedule.Merge(m, src)
}
func (m *BackupPolicy_Schedule) XXX_Size() int {
	return m.Size()
}
func (m *BackupPolicy_Schedule) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupPolicy_Schedule.DiscardUnknown(m)
}

var xxx_messageInfo_BackupPolicy_Schedule proto.InternalMessageInfo

func (m *BackupPolicy_Schedule) GetScheduleType() string {
	if m != nil {
		return m.ScheduleType
	}
	return ""
}

func (m *BackupPolicy_Schedule) GetHourlySchedule() *BackupPolicy_HourlySchedule {
	if m != nil {
		return m.HourlySchedule
	}
	return nil
}

func (m *BackupPolicy_Schedule) GetDailySchedule() *BackupPolicy_DailySchedule {
	if m != nil {
		return m.DailySchedule
	}
	return nil
}

func (m *BackupPolicy_Schedule) GetMonthlySchedule() *BackupPolicy_MonthlySchedule {
	if m != nil {
		return m.MonthlySchedule
	}
	return nil
}

// Note: Nested types inside nested types is not supported by the typescript generator
type BackupPolicy_HourlySchedule struct {
	// Schedule should run with an interval of the specified hours (1-23)
	ScheduleEveryIntervalHours int32    `protobuf:"varint,1,opt,name=schedule_every_interval_hours,json=scheduleEveryIntervalHours,proto3" json:"schedule_every_interval_hours,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *BackupPolicy_HourlySchedule) Reset()         { *m = BackupPolicy_HourlySchedule{} }
func (m *BackupPolicy_HourlySchedule) String() string { return proto.CompactTextString(m) }
func (*BackupPolicy_HourlySchedule) ProtoMessage()    {}
func (*BackupPolicy_HourlySchedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{0, 1}
}
func (m *BackupPolicy_HourlySchedule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupPolicy_HourlySchedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupPolicy_HourlySchedule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BackupPolicy_HourlySchedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupPolicy_HourlySchedule.Merge(m, src)
}
func (m *BackupPolicy_HourlySchedule) XXX_Size() int {
	return m.Size()
}
func (m *BackupPolicy_HourlySchedule) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupPolicy_HourlySchedule.DiscardUnknown(m)
}

var xxx_messageInfo_BackupPolicy_HourlySchedule proto.InternalMessageInfo

func (m *BackupPolicy_HourlySchedule) GetScheduleEveryIntervalHours() int32 {
	if m != nil {
		return m.ScheduleEveryIntervalHours
	}
	return 0
}

// Note: Nested types inside nested types is not supported by the typescript generator
type BackupPolicy_DailySchedule struct {
	// If set, a backup will be created on Mondays.
	Monday bool `protobuf:"varint,1,opt,name=monday,proto3" json:"monday,omitempty"`
	// If set, a backup will be created on Tuesdays.
	Tuesday bool `protobuf:"varint,2,opt,name=tuesday,proto3" json:"tuesday,omitempty"`
	// If set, a backup will be created on Wednesdays.
	Wednesday bool `protobuf:"varint,3,opt,name=wednesday,proto3" json:"wednesday,omitempty"`
	// If set, a backup will be created on Thursdays.
	Thursday bool `protobuf:"varint,4,opt,name=thursday,proto3" json:"thursday,omitempty"`
	// If set, a backup will be created on Fridays.
	Friday bool `protobuf:"varint,5,opt,name=friday,proto3" json:"friday,omitempty"`
	// If set, a backup will be created on Saturdays.
	Saturday bool `protobuf:"varint,6,opt,name=saturday,proto3" json:"saturday,omitempty"`
	// If set, a backup will be created on Sundays.
	Sunday bool `protobuf:"varint,7,opt,name=sunday,proto3" json:"sunday,omitempty"`
	// The (target) time of the schedule
	ScheduleAt           *TimeOfDay `protobuf:"bytes,10,opt,name=schedule_at,json=scheduleAt,proto3" json:"schedule_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BackupPolicy_DailySchedule) Reset()         { *m = BackupPolicy_DailySchedule{} }
func (m *BackupPolicy_DailySchedule) String() string { return proto.CompactTextString(m) }
func (*BackupPolicy_DailySchedule) ProtoMessage()    {}
func (*BackupPolicy_DailySchedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{0, 2}
}
func (m *BackupPolicy_DailySchedule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupPolicy_DailySchedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupPolicy_DailySchedule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BackupPolicy_DailySchedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupPolicy_DailySchedule.Merge(m, src)
}
func (m *BackupPolicy_DailySchedule) XXX_Size() int {
	return m.Size()
}
func (m *BackupPolicy_DailySchedule) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupPolicy_DailySchedule.DiscardUnknown(m)
}

var xxx_messageInfo_BackupPolicy_DailySchedule proto.InternalMessageInfo

func (m *BackupPolicy_DailySchedule) GetMonday() bool {
	if m != nil {
		return m.Monday
	}
	return false
}

func (m *BackupPolicy_DailySchedule) GetTuesday() bool {
	if m != nil {
		return m.Tuesday
	}
	return false
}

func (m *BackupPolicy_DailySchedule) GetWednesday() bool {
	if m != nil {
		return m.Wednesday
	}
	return false
}

func (m *BackupPolicy_DailySchedule) GetThursday() bool {
	if m != nil {
		return m.Thursday
	}
	return false
}

func (m *BackupPolicy_DailySchedule) GetFriday() bool {
	if m != nil {
		return m.Friday
	}
	return false
}

func (m *BackupPolicy_DailySchedule) GetSaturday() bool {
	if m != nil {
		return m.Saturday
	}
	return false
}

func (m *BackupPolicy_DailySchedule) GetSunday() bool {
	if m != nil {
		return m.Sunday
	}
	return false
}

func (m *BackupPolicy_DailySchedule) GetScheduleAt() *TimeOfDay {
	if m != nil {
		return m.ScheduleAt
	}
	return nil
}

// Note: Nested types inside nested types is not supported by the typescript generator
type BackupPolicy_MonthlySchedule struct {
	// Run the backup on the specified day of the month (1-31)
	// Note: Specifying a number larger than some months have days will result in no backup for those months (e.g. 29 for February (unless leap year)).
	DayOfMonth int32 `protobuf:"varint,1,opt,name=day_of_month,json=dayOfMonth,proto3" json:"day_of_month,omitempty"`
	// The (target) time of the schedule
	ScheduleAt           *TimeOfDay `protobuf:"bytes,10,opt,name=schedule_at,json=scheduleAt,proto3" json:"schedule_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BackupPolicy_MonthlySchedule) Reset()         { *m = BackupPolicy_MonthlySchedule{} }
func (m *BackupPolicy_MonthlySchedule) String() string { return proto.CompactTextString(m) }
func (*BackupPolicy_MonthlySchedule) ProtoMessage()    {}
func (*BackupPolicy_MonthlySchedule) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{0, 3}
}
func (m *BackupPolicy_MonthlySchedule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupPolicy_MonthlySchedule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupPolicy_MonthlySchedule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BackupPolicy_MonthlySchedule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupPolicy_MonthlySchedule.Merge(m, src)
}
func (m *BackupPolicy_MonthlySchedule) XXX_Size() int {
	return m.Size()
}
func (m *BackupPolicy_MonthlySchedule) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupPolicy_MonthlySchedule.DiscardUnknown(m)
}

var xxx_messageInfo_BackupPolicy_MonthlySchedule proto.InternalMessageInfo

func (m *BackupPolicy_MonthlySchedule) GetDayOfMonth() int32 {
	if m != nil {
		return m.DayOfMonth
	}
	return 0
}

func (m *BackupPolicy_MonthlySchedule) GetScheduleAt() *TimeOfDay {
	if m != nil {
		return m.ScheduleAt
	}
	return nil
}

// Status of the backup policy
// All members of this field are read-only.
type BackupPolicy_Status struct {
	// The timestamp when the next backup - initiated by this backup policy - will be created
	NextBackup *types.Timestamp `protobuf:"bytes,1,opt,name=next_backup,json=nextBackup,proto3" json:"next_backup,omitempty"`
	// Message in case of failure, otherwise an empty string
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupPolicy_Status) Reset()         { *m = BackupPolicy_Status{} }
func (m *BackupPolicy_Status) String() string { return proto.CompactTextString(m) }
func (*BackupPolicy_Status) ProtoMessage()    {}
func (*BackupPolicy_Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{0, 4}
}
func (m *BackupPolicy_Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupPolicy_Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupPolicy_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BackupPolicy_Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupPolicy_Status.Merge(m, src)
}
func (m *BackupPolicy_Status) XXX_Size() int {
	return m.Size()
}
func (m *BackupPolicy_Status) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupPolicy_Status.DiscardUnknown(m)
}

var xxx_messageInfo_BackupPolicy_Status proto.InternalMessageInfo

func (m *BackupPolicy_Status) GetNextBackup() *types.Timestamp {
	if m != nil {
		return m.NextBackup
	}
	return nil
}

func (m *BackupPolicy_Status) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// TimeOfDay describes a specific moment on a day
type TimeOfDay struct {
	// Hours part of the time of day (0-23)
	Hours int32 `protobuf:"varint,1,opt,name=hours,proto3" json:"hours,omitempty"`
	// Minutes part of the time of day (0-59)
	Minutes int32 `protobuf:"varint,2,opt,name=minutes,proto3" json:"minutes,omitempty"`
	// The time-zone this time of day applies to (empty means UTC)
	// Names MUST be exactly as defined in RFC-822.
	TimeZone             string   `protobuf:"bytes,3,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeOfDay) Reset()         { *m = TimeOfDay{} }
func (m *TimeOfDay) String() string { return proto.CompactTextString(m) }
func (*TimeOfDay) ProtoMessage()    {}
func (*TimeOfDay) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{1}
}
func (m *TimeOfDay) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeOfDay) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimeOfDay.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimeOfDay) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeOfDay.Merge(m, src)
}
func (m *TimeOfDay) XXX_Size() int {
	return m.Size()
}
func (m *TimeOfDay) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeOfDay.DiscardUnknown(m)
}

var xxx_messageInfo_TimeOfDay proto.InternalMessageInfo

func (m *TimeOfDay) GetHours() int32 {
	if m != nil {
		return m.Hours
	}
	return 0
}

func (m *TimeOfDay) GetMinutes() int32 {
	if m != nil {
		return m.Minutes
	}
	return 0
}

func (m *TimeOfDay) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

// List of backup policies.
type BackupPolicyList struct {
	Items                []*BackupPolicy `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *BackupPolicyList) Reset()         { *m = BackupPolicyList{} }
func (m *BackupPolicyList) String() string { return proto.CompactTextString(m) }
func (*BackupPolicyList) ProtoMessage()    {}
func (*BackupPolicyList) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{2}
}
func (m *BackupPolicyList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupPolicyList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupPolicyList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BackupPolicyList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupPolicyList.Merge(m, src)
}
func (m *BackupPolicyList) XXX_Size() int {
	return m.Size()
}
func (m *BackupPolicyList) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupPolicyList.DiscardUnknown(m)
}

var xxx_messageInfo_BackupPolicyList proto.InternalMessageInfo

func (m *BackupPolicyList) GetItems() []*BackupPolicy {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListBackupPolicies
type ListBackupPoliciesRequest struct {
	// Identifier of the deployment to request the backup policies for.
	DeploymentId string `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// If set, the result includes all backup policies, including those who set to deleted,
	// however are not removed from the system currently.
	// If not set, only backup policies not indicated as deleted are returned.
	IncludeDeleted bool `protobuf:"varint,2,opt,name=include_deleted,json=includeDeleted,proto3" json:"include_deleted,omitempty"`
	// Optional common list options, the context_id is ignored
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListBackupPoliciesRequest) Reset()         { *m = ListBackupPoliciesRequest{} }
func (m *ListBackupPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*ListBackupPoliciesRequest) ProtoMessage()    {}
func (*ListBackupPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{3}
}
func (m *ListBackupPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListBackupPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListBackupPoliciesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListBackupPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBackupPoliciesRequest.Merge(m, src)
}
func (m *ListBackupPoliciesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListBackupPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBackupPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBackupPoliciesRequest proto.InternalMessageInfo

func (m *ListBackupPoliciesRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ListBackupPoliciesRequest) GetIncludeDeleted() bool {
	if m != nil {
		return m.IncludeDeleted
	}
	return false
}

func (m *ListBackupPoliciesRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// Backup represents a single backup of a deployment.
type Backup struct {
	// System identifier of the backup.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the backup
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the backup
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the deployment that owns this backup.
	// After creation, this value cannot be changed.
	DeploymentId string `protobuf:"bytes,5,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Identifier of the backup policy that triggered this backup
	// After creation, this value cannot be changed.
	// If this field is empty, this is a manual backup
	BackupPolicyId string `protobuf:"bytes,6,opt,name=backup_policy_id,json=backupPolicyId,proto3" json:"backup_policy_id,omitempty"`
	// The creation timestamp of the backup (database object)
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the backup
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this backup is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// The timestamp that this backup will be automatically removed
	// You cannot provide a value in the past,
	// If the field is not set, the backup will not be automatically removed.
	AutoDeletedAt *types.Timestamp `protobuf:"bytes,10,opt,name=auto_deleted_at,json=autoDeletedAt,proto3" json:"auto_deleted_at,omitempty"`
	// Information about the deployment during backup
	DeploymentInfo *Backup_DeploymentInfo `protobuf:"bytes,11,opt,name=deployment_info,json=deploymentInfo,proto3" json:"deployment_info,omitempty"`
	// Upload the backup, created by the backup policy, to an external source.
	// Setting or unsetting this fields after the backup has been created will upload/delete the backup from the external source.
	// Setting this field when status.available = false will result in an error
	Upload bool `protobuf:"varint,12,opt,name=upload,proto3" json:"upload,omitempty"`
	// Status of the actual backup
	Status               *Backup_Status `protobuf:"bytes,100,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Backup) Reset()         { *m = Backup{} }
func (m *Backup) String() string { return proto.CompactTextString(m) }
func (*Backup) ProtoMessage()    {}
func (*Backup) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{4}
}
func (m *Backup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Backup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Backup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Backup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Backup.Merge(m, src)
}
func (m *Backup) XXX_Size() int {
	return m.Size()
}
func (m *Backup) XXX_DiscardUnknown() {
	xxx_messageInfo_Backup.DiscardUnknown(m)
}

var xxx_messageInfo_Backup proto.InternalMessageInfo

func (m *Backup) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Backup) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Backup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Backup) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Backup) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *Backup) GetBackupPolicyId() string {
	if m != nil {
		return m.BackupPolicyId
	}
	return ""
}

func (m *Backup) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Backup) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Backup) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Backup) GetAutoDeletedAt() *types.Timestamp {
	if m != nil {
		return m.AutoDeletedAt
	}
	return nil
}

func (m *Backup) GetDeploymentInfo() *Backup_DeploymentInfo {
	if m != nil {
		return m.DeploymentInfo
	}
	return nil
}

func (m *Backup) GetUpload() bool {
	if m != nil {
		return m.Upload
	}
	return false
}

func (m *Backup) GetStatus() *Backup_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// Information about the deployment during backup
// All members of this field are read-only.
type Backup_DeploymentInfo struct {
	// ArangoDB version of the deployment during backup.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Servers spec of the deployment during backup.
	Servers              *v11.Deployment_ServersSpec `protobuf:"bytes,2,opt,name=servers,proto3" json:"servers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *Backup_DeploymentInfo) Reset()         { *m = Backup_DeploymentInfo{} }
func (m *Backup_DeploymentInfo) String() string { return proto.CompactTextString(m) }
func (*Backup_DeploymentInfo) ProtoMessage()    {}
func (*Backup_DeploymentInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{4, 0}
}
func (m *Backup_DeploymentInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Backup_DeploymentInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Backup_DeploymentInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Backup_DeploymentInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Backup_DeploymentInfo.Merge(m, src)
}
func (m *Backup_DeploymentInfo) XXX_Size() int {
	return m.Size()
}
func (m *Backup_DeploymentInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Backup_DeploymentInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Backup_DeploymentInfo proto.InternalMessageInfo

func (m *Backup_DeploymentInfo) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Backup_DeploymentInfo) GetServers() *v11.Deployment_ServersSpec {
	if m != nil {
		return m.Servers
	}
	return nil
}

// Status of the actual backup
// All members of this field are read-only.
type Backup_Status struct {
	// The creation timestamp of the backup
	CreatedAt *types.Timestamp `protobuf:"bytes,1,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// ArangoDB version of the backup
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// The state of the backup
	// Will be one of the following: "Pending|Scheduled|Download|DownloadError|Downloading|Create|Upload|Uploading|UploadError|Ready|Deleted|Failed"
	State string `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	// Set when the backup is failed
	IsFailed bool `protobuf:"varint,4,opt,name=is_failed,json=isFailed,proto3" json:"is_failed,omitempty"`
	// State message
	Message string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// Progress of the backup (upload or download)
	Progress string `protobuf:"bytes,6,opt,name=progress,proto3" json:"progress,omitempty"`
	// Size of the backup (in bytes)
	SizeBytes int64 `protobuf:"varint,7,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Set when the backup has been fully uploaded
	Uploaded bool `protobuf:"varint,8,opt,name=uploaded,proto3" json:"uploaded,omitempty"`
	// Set when the backup has been fully downloaded
	Downloaded bool `protobuf:"varint,9,opt,name=downloaded,proto3" json:"downloaded,omitempty"`
	// Set when the backup is available to restore to / recover from
	Available            bool     `protobuf:"varint,10,opt,name=available,proto3" json:"available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Backup_Status) Reset()         { *m = Backup_Status{} }
func (m *Backup_Status) String() string { return proto.CompactTextString(m) }
func (*Backup_Status) ProtoMessage()    {}
func (*Backup_Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{4, 1}
}
func (m *Backup_Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Backup_Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Backup_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Backup_Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Backup_Status.Merge(m, src)
}
func (m *Backup_Status) XXX_Size() int {
	return m.Size()
}
func (m *Backup_Status) XXX_DiscardUnknown() {
	xxx_messageInfo_Backup_Status.DiscardUnknown(m)
}

var xxx_messageInfo_Backup_Status proto.InternalMessageInfo

func (m *Backup_Status) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Backup_Status) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Backup_Status) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *Backup_Status) GetIsFailed() bool {
	if m != nil {
		return m.IsFailed
	}
	return false
}

func (m *Backup_Status) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Backup_Status) GetProgress() string {
	if m != nil {
		return m.Progress
	}
	return ""
}

func (m *Backup_Status) GetSizeBytes() int64 {
	if m != nil {
		return m.SizeBytes
	}
	return 0
}

func (m *Backup_Status) GetUploaded() bool {
	if m != nil {
		return m.Uploaded
	}
	return false
}

func (m *Backup_Status) GetDownloaded() bool {
	if m != nil {
		return m.Downloaded
	}
	return false
}

func (m *Backup_Status) GetAvailable() bool {
	if m != nil {
		return m.Available
	}
	return false
}

// List of backups.
type BackupList struct {
	Items                []*Backup `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BackupList) Reset()         { *m = BackupList{} }
func (m *BackupList) String() string { return proto.CompactTextString(m) }
func (*BackupList) ProtoMessage()    {}
func (*BackupList) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{5}
}
func (m *BackupList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BackupList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupList.Merge(m, src)
}
func (m *BackupList) XXX_Size() int {
	return m.Size()
}
func (m *BackupList) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupList.DiscardUnknown(m)
}

var xxx_messageInfo_BackupList proto.InternalMessageInfo

func (m *BackupList) GetItems() []*Backup {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListBackups
type ListBackupsRequest struct {
	// Identifier of the deployment to request the backups for.
	DeploymentId string `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Request backups that are created at or after this timestamp.
	// This is an optional field.
	From *types.Timestamp `protobuf:"bytes,2,opt,name=from,proto3" json:"from,omitempty"`
	// Request backups that are created before this timestamp.
	// This is an optional field.
	To *types.Timestamp `protobuf:"bytes,3,opt,name=to,proto3" json:"to,omitempty"`
	// Optional common list options, the context_id is ignored
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListBackupsRequest) Reset()         { *m = ListBackupsRequest{} }
func (m *ListBackupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBackupsRequest) ProtoMessage()    {}
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_65240d19de191688, []int{6}
}
func (m *ListBackupsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListBackupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListBackupsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListBackupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBackupsRequest.Merge(m, src)
}
func (m *ListBackupsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListBackupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBackupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBackupsRequest proto.InternalMessageInfo

func (m *ListBackupsRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ListBackupsRequest) GetFrom() *types.Timestamp {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *ListBackupsRequest) GetTo() *types.Timestamp {
	if m != nil {
		return m.To
	}
	return nil
}

func (m *ListBackupsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func init() {
	proto.RegisterType((*BackupPolicy)(nil), "arangodb.cloud.backup.v1.BackupPolicy")
	proto.RegisterType((*BackupPolicy_Schedule)(nil), "arangodb.cloud.backup.v1.BackupPolicy.Schedule")
	proto.RegisterType((*BackupPolicy_HourlySchedule)(nil), "arangodb.cloud.backup.v1.BackupPolicy.HourlySchedule")
	proto.RegisterType((*BackupPolicy_DailySchedule)(nil), "arangodb.cloud.backup.v1.BackupPolicy.DailySchedule")
	proto.RegisterType((*BackupPolicy_MonthlySchedule)(nil), "arangodb.cloud.backup.v1.BackupPolicy.MonthlySchedule")
	proto.RegisterType((*BackupPolicy_Status)(nil), "arangodb.cloud.backup.v1.BackupPolicy.Status")
	proto.RegisterType((*TimeOfDay)(nil), "arangodb.cloud.backup.v1.TimeOfDay")
	proto.RegisterType((*BackupPolicyList)(nil), "arangodb.cloud.backup.v1.BackupPolicyList")
	proto.RegisterType((*ListBackupPoliciesRequest)(nil), "arangodb.cloud.backup.v1.ListBackupPoliciesRequest")
	proto.RegisterType((*Backup)(nil), "arangodb.cloud.backup.v1.Backup")
	proto.RegisterType((*Backup_DeploymentInfo)(nil), "arangodb.cloud.backup.v1.Backup.DeploymentInfo")
	proto.RegisterType((*Backup_Status)(nil), "arangodb.cloud.backup.v1.Backup.Status")
	proto.RegisterType((*BackupList)(nil), "arangodb.cloud.backup.v1.BackupList")
	proto.RegisterType((*ListBackupsRequest)(nil), "arangodb.cloud.backup.v1.ListBackupsRequest")
}

func init() { proto.RegisterFile("backup.proto", fileDescriptor_65240d19de191688) }

var fileDescriptor_65240d19de191688 = []byte{
	// 1587 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0xdd, 0x6f, 0x1b, 0x59,
	0x15, 0x67, 0x9c, 0xd8, 0xb1, 0x8f, 0xbf, 0xc2, 0xd5, 0x6a, 0xe5, 0x35, 0xdd, 0x6c, 0x34, 0xd9,
	0xd2, 0x28, 0x90, 0x31, 0xc9, 0xb2, 0xd5, 0x2e, 0xdd, 0xa5, 0x4a, 0xea, 0x40, 0x2b, 0x3e, 0x1a,
	0x4d, 0x8a, 0x54, 0x15, 0x89, 0xd1, 0xb5, 0xe7, 0xda, 0xb9, 0xc2, 0x33, 0x77, 0x98, 0x7b, 0xc7,
	0xad, 0x5b, 0xf5, 0x01, 0x90, 0x78, 0x40, 0x42, 0x3c, 0xf4, 0x85, 0x57, 0x1e, 0xe1, 0x6f, 0x40,
	0xe2, 0x95, 0x37, 0x90, 0x2a, 0xf1, 0x8c, 0x0a, 0xff, 0x00, 0xe2, 0x1f, 0x40, 0xf7, 0x63, 0x26,
	0x33, 0x6e, 0x13, 0x3b, 0x25, 0x68, 0x9f, 0xea, 0xf3, 0x7d, 0xee, 0xb9, 0xbf, 0x7b, 0x7e, 0x93,
	0x42, 0x63, 0x80, 0x87, 0x3f, 0x4d, 0x22, 0x27, 0x8a, 0x99, 0x60, 0xa8, 0x83, 0x63, 0x1c, 0x8e,
	0x99, 0x3f, 0x70, 0x86, 0x13, 0x96, 0xf8, 0x8e, 0x31, 0x4e, 0xf7, 0xba, 0xc8, 0xc7, 0x02, 0xf7,
	0xa6, 0x7b, 0x3d, 0xf9, 0xaf, 0xf6, 0xee, 0xbe, 0x3b, 0x64, 0x41, 0xc0, 0x42, 0xa9, 0xd5, 0xbf,
	0x8c, 0xfe, 0xd6, 0x98, 0x8a, 0xd3, 0x64, 0xe0, 0x0c, 0x59, 0xd0, 0x1b, 0xb3, 0x09, 0x0e, 0xc7,
	0x3d, 0x65, 0x18, 0x24, 0xa3, 0x5e, 0x24, 0x66, 0x11, 0xe1, 0x3d, 0x41, 0x03, 0xc2, 0x05, 0x0e,
	0xa2, 0xb3, 0x5f, 0x26, 0xf8, 0xd3, 0xc5, 0xc1, 0x7e, 0x12, 0x63, 0x41, 0x59, 0x98, 0xfd, 0x30,
	0xa1, 0xd7, 0xc6, 0x8c, 0x8d, 0x27, 0xa4, 0x87, 0x23, 0xda, 0xc3, 0x61, 0xc8, 0x84, 0x32, 0x72,
	0x6d, 0xb5, 0xff, 0x5d, 0x87, 0xc6, 0xa1, 0x3a, 0xcf, 0x31, 0x9b, 0xd0, 0xe1, 0x0c, 0xb5, 0xa0,
	0x44, 0xfd, 0x8e, 0xb5, 0x69, 0x6d, 0xd7, 0xdc, 0x12, 0xf5, 0xd1, 0x3a, 0xac, 0x24, 0xf1, 0xa4,
	0x53, 0x52, 0x0a, 0xf9, 0x13, 0x21, 0x58, 0x0d, 0x71, 0x40, 0x3a, 0x2b, 0x4a, 0xa5, 0x7e, 0xa3,
	0x4d, 0xa8, 0xfb, 0x84, 0x0f, 0x63, 0x1a, 0xc9, 0xe4, 0x9d, 0x55, 0x65, 0xca, 0xab, 0xd0, 0x16,
	0x34, 0x7d, 0x12, 0x4d, 0xd8, 0x2c, 0x20, 0xa1, 0xf0, 0xa8, 0xdf, 0x29, 0x2b, 0x9f, 0xc6, 0x99,
	0xf2, 0x9e, 0x8f, 0x3e, 0x05, 0x18, 0xc6, 0x04, 0x0b, 0xe2, 0x7b, 0x58, 0x74, 0x2a, 0x9b, 0xd6,
	0x76, 0x7d, 0xbf, 0xeb, 0xe8, 0x03, 0x38, 0xe9, 0x81, 0x9d, 0x07, 0xe9, 0x70, 0xdc, 0x9a, 0xf1,
	0x3e, 0x10, 0x32, 0xd4, 0x27, 0x13, 0x62, 0x42, 0xd7, 0x16, 0x87, 0x1a, 0xef, 0x03, 0x81, 0xde,
	0x07, 0xa0, 0xdc, 0x33, 0x72, 0xa7, 0xba, 0x69, 0x6d, 0x57, 0xdd, 0x1a, 0xe5, 0x7d, 0xad, 0x40,
	0x5f, 0x81, 0x1a, 0xe5, 0x5e, 0x84, 0x13, 0x4e, 0xfc, 0x4e, 0x4d, 0x59, 0xab, 0x94, 0x1f, 0x2b,
	0x19, 0x7d, 0x0f, 0xaa, 0x7c, 0x78, 0x4a, 0xfc, 0x64, 0x42, 0x3a, 0xa0, 0x8a, 0xf6, 0x9c, 0xf3,
	0xe0, 0xe2, 0xe4, 0x07, 0xed, 0x9c, 0x98, 0x30, 0x37, 0x4b, 0x80, 0xde, 0x85, 0x4a, 0x12, 0x4d,
	0x18, 0xf6, 0x3b, 0x75, 0x55, 0xc6, 0x48, 0xa8, 0x0f, 0xeb, 0x31, 0x11, 0x24, 0x94, 0x83, 0xf4,
	0x22, 0x12, 0x53, 0xe6, 0x77, 0x1a, 0xaa, 0xd8, 0x7b, 0xaf, 0x9d, 0xb0, 0x6f, 0x6e, 0xdf, 0x6d,
	0x67, 0x21, 0xc7, 0x2a, 0x02, 0xed, 0x02, 0x22, 0x01, 0xa6, 0x13, 0x2f, 0x64, 0x82, 0x8e, 0xe8,
	0x50, 0xb9, 0x75, 0x9a, 0xea, 0x1a, 0xbe, 0xac, 0x2c, 0x3f, 0xcc, 0x19, 0xd0, 0x11, 0x54, 0xb8,
	0xc0, 0x22, 0xe1, 0x1d, 0x5f, 0x95, 0xda, 0x5d, 0xf6, 0x5c, 0x2a, 0xc8, 0x35, 0xc1, 0xdd, 0xbf,
	0x96, 0xa0, 0x9a, 0x1e, 0x55, 0x82, 0x20, 0x3d, 0xac, 0x27, 0x51, 0x6b, 0x70, 0xd6, 0x48, 0x95,
	0x0f, 0x66, 0x11, 0x41, 0x3f, 0x81, 0xf6, 0x29, 0x4b, 0xe2, 0xc9, 0xcc, 0xcb, 0x26, 0x5b, 0x52,
	0x1d, 0x7c, 0xbc, 0x64, 0x07, 0x77, 0x55, 0x74, 0x36, 0xdf, 0xd6, 0x69, 0x41, 0x46, 0x3f, 0x86,
	0x96, 0x8f, 0x69, 0x3e, 0xfd, 0x8a, 0x4a, 0xff, 0xcd, 0x25, 0xd3, 0xf7, 0x65, 0x70, 0x96, 0xbd,
	0xe9, 0xe7, 0x45, 0x84, 0x61, 0x3d, 0x60, 0xa1, 0x38, 0xcd, 0xa7, 0x5f, 0x55, 0xe9, 0x6f, 0x2e,
	0x99, 0xfe, 0x07, 0x3a, 0x3c, 0x2b, 0xd0, 0x0e, 0x8a, 0x8a, 0xee, 0x09, 0xb4, 0x8a, 0x27, 0x44,
	0x07, 0xf0, 0x7e, 0x36, 0x56, 0x32, 0x25, 0xf1, 0xcc, 0xa3, 0xa1, 0x20, 0xf1, 0x14, 0x4f, 0x3c,
	0x79, 0x76, 0xae, 0xc6, 0x5c, 0x76, 0xbb, 0xa9, 0xd3, 0x91, 0xf4, 0xb9, 0x67, 0x5c, 0x64, 0x2e,
	0xde, 0xfd, 0x4d, 0x09, 0x9a, 0x85, 0x83, 0x49, 0x30, 0x06, 0x2c, 0xf4, 0xf1, 0x4c, 0x45, 0x57,
	0x5d, 0x23, 0xa1, 0x0e, 0xac, 0x89, 0x84, 0x70, 0x69, 0x28, 0x29, 0x43, 0x2a, 0xa2, 0x6b, 0x50,
	0x7b, 0x4c, 0xfc, 0x50, 0xdb, 0x56, 0xf4, 0x33, 0xca, 0x14, 0xa8, 0x0b, 0x55, 0x71, 0x9a, 0xc4,
	0xca, 0xb8, 0xaa, 0x5f, 0x51, 0x2a, 0xcb, 0x5a, 0xa3, 0x98, 0x4a, 0x4b, 0x59, 0xd7, 0xd2, 0x92,
	0x8c, 0xe1, 0x58, 0x24, 0xb1, 0xb4, 0x54, 0x74, 0x4c, 0x2a, 0xcb, 0x18, 0x9e, 0xa8, 0xfe, 0xd6,
	0x74, 0x8c, 0x96, 0x50, 0x1f, 0xea, 0xd9, 0x30, 0xb0, 0x30, 0x8f, 0x72, 0xeb, 0xfc, 0xe1, 0xcb,
	0x95, 0x70, 0x7f, 0xd4, 0xc7, 0x33, 0x17, 0xd2, 0xb8, 0x03, 0xd1, 0x9d, 0x41, 0x7b, 0xee, 0x22,
	0xd0, 0x26, 0x34, 0x7c, 0x3c, 0xf3, 0xd8, 0xc8, 0x53, 0x37, 0x62, 0x86, 0x0a, 0x3e, 0x9e, 0xdd,
	0x1f, 0x29, 0xdf, 0x2b, 0x2a, 0xed, 0x41, 0x45, 0xbf, 0x21, 0x74, 0x0b, 0xea, 0x21, 0x79, 0x22,
	0x3c, 0x1d, 0xa1, 0x0a, 0x5e, 0xbc, 0xd4, 0x40, 0xba, 0x6b, 0x34, 0xc9, 0x7b, 0x0a, 0x08, 0xe7,
	0x78, 0x4c, 0xcc, 0xf2, 0x4e, 0x45, 0xfb, 0x21, 0xd4, 0xb2, 0xca, 0xe8, 0x1d, 0x28, 0xe7, 0x31,
	0xa2, 0x05, 0x15, 0x4c, 0xc3, 0x44, 0x10, 0xae, 0x82, 0xcb, 0x6e, 0x2a, 0xca, 0x6d, 0x28, 0xc9,
	0xc9, 0x7b, 0xca, 0xc2, 0x94, 0x02, 0xaa, 0x52, 0xf1, 0x88, 0x85, 0xc4, 0x3e, 0x86, 0xf5, 0x3c,
	0x96, 0xbf, 0x4f, 0xb9, 0x40, 0x9f, 0x41, 0x99, 0x0a, 0x12, 0xc8, 0x02, 0x2b, 0xdb, 0xf5, 0xfd,
	0xaf, 0x2e, 0xf7, 0x0c, 0x5c, 0x1d, 0x64, 0xff, 0xd1, 0x82, 0xf7, 0x64, 0x9a, 0x9c, 0x8d, 0x12,
	0xee, 0x92, 0x9f, 0x25, 0x84, 0x8b, 0xd7, 0x49, 0xc5, 0x7a, 0x03, 0xa9, 0xdc, 0x80, 0x36, 0x0d,
	0x87, 0x93, 0xc4, 0x27, 0xd9, 0x8e, 0xd7, 0xc0, 0x6d, 0x19, 0x75, 0xba, 0xe8, 0x6f, 0xc3, 0x1a,
	0x53, 0x64, 0xc5, 0xcd, 0xd5, 0x5d, 0x9f, 0xef, 0xd5, 0x10, 0xfa, 0x74, 0xcf, 0x91, 0x3d, 0xdd,
	0xd7, 0xce, 0x6e, 0x1a, 0x65, 0xff, 0x67, 0x0d, 0x2a, 0x66, 0xfa, 0x5f, 0x28, 0x8d, 0x6e, 0xc3,
	0xba, 0x9e, 0xaa, 0x17, 0xa9, 0x61, 0x4a, 0xbf, 0x8a, 0xf2, 0x6b, 0x0d, 0x72, 0x33, 0x7e, 0x8d,
	0x70, 0xd7, 0xde, 0x9e, 0x70, 0xab, 0x6f, 0x4f, 0xb8, 0xb5, 0x79, 0xc2, 0x3d, 0x84, 0x36, 0x4e,
	0x04, 0xf3, 0x72, 0xe9, 0x61, 0x61, 0xfa, 0xa6, 0x0c, 0xe9, 0x67, 0x25, 0x1e, 0x42, 0x3b, 0x3f,
	0xa7, 0x70, 0xc4, 0x14, 0xa7, 0x2e, 0x41, 0xcf, 0x4e, 0xff, 0x6c, 0x94, 0xe1, 0x88, 0xb9, 0x2d,
	0xbf, 0x20, 0xe7, 0x48, 0xba, 0x51, 0x20, 0xe9, 0xdb, 0x73, 0x7c, 0x79, 0x63, 0x61, 0xa1, 0x39,
	0xa6, 0x14, 0xd0, 0x2a, 0x96, 0x96, 0xaf, 0x70, 0x4a, 0x62, 0x2e, 0xa1, 0xa0, 0x91, 0x94, 0x8a,
	0xe8, 0x2e, 0xac, 0x71, 0x12, 0x4b, 0xc9, 0x70, 0xa3, 0x33, 0x5f, 0x4d, 0x7d, 0x91, 0x4e, 0xf7,
	0x72, 0xa7, 0x71, 0x4e, 0x74, 0xc4, 0x49, 0x44, 0x86, 0x6e, 0x1a, 0xde, 0xfd, 0x73, 0x29, 0x5b,
	0x37, 0x45, 0x30, 0x58, 0x97, 0x01, 0x43, 0xae, 0xd3, 0x52, 0xb1, 0xd3, 0x77, 0xa0, 0x2c, 0xcf,
	0x97, 0xe2, 0x5c, 0x0b, 0xe6, 0x9b, 0x6a, 0x84, 0xe9, 0x84, 0xf8, 0x29, 0x1b, 0x50, 0xfe, 0x1d,
	0x25, 0xe7, 0x37, 0x57, 0xb9, 0xb0, 0xb9, 0x24, 0x1f, 0x44, 0x31, 0x1b, 0xc7, 0x84, 0x73, 0x03,
	0xe8, 0x4c, 0x96, 0xa0, 0xe2, 0xf4, 0x29, 0xf1, 0x06, 0x33, 0xb9, 0xb5, 0x24, 0x94, 0x57, 0xdc,
	0x9a, 0xd4, 0x1c, 0x4a, 0x85, 0x0c, 0xd5, 0x17, 0x95, 0x7d, 0xe2, 0x65, 0x32, 0xda, 0x00, 0xf0,
	0xd9, 0xe3, 0xd0, 0x58, 0x35, 0x1e, 0x73, 0x1a, 0x49, 0x6c, 0x78, 0x8a, 0xe9, 0x04, 0x0f, 0xcc,
	0x57, 0x5e, 0xd5, 0x3d, 0x53, 0xd8, 0x7d, 0x00, 0x7d, 0xa1, 0x6a, 0xdd, 0xdd, 0x2c, 0xae, 0xbb,
	0xcd, 0x45, 0x28, 0x48, 0x17, 0xdd, 0xdf, 0x2d, 0x40, 0x67, 0x8b, 0xee, 0x72, 0x1b, 0xce, 0x81,
	0xd5, 0x51, 0xcc, 0x02, 0x03, 0x85, 0x8b, 0xae, 0x4c, 0xf9, 0xa1, 0x1d, 0x28, 0x09, 0x66, 0xbe,
	0x7a, 0x2e, 0xf2, 0x2e, 0x09, 0xf6, 0x3f, 0x2f, 0xc5, 0xfd, 0x97, 0x4d, 0x68, 0xea, 0x43, 0x49,
	0xfc, 0xd1, 0x21, 0x41, 0x7f, 0x2a, 0x1c, 0x35, 0xdd, 0xe9, 0xe8, 0xa3, 0xf3, 0x47, 0x75, 0x2e,
	0x03, 0x74, 0x77, 0x96, 0xa3, 0x13, 0x99, 0xc0, 0x3e, 0xfa, 0xc5, 0xcb, 0x7f, 0xbd, 0x28, 0xdd,
	0x46, 0x9f, 0xab, 0xbf, 0x85, 0xb4, 0xa3, 0xfa, 0xe3, 0x2d, 0x9b, 0x65, 0xef, 0x99, 0xe9, 0xda,
	0x19, 0xb2, 0x50, 0x48, 0xea, 0xa5, 0xfe, 0x73, 0xe3, 0x19, 0xa5, 0x7d, 0xfe, 0xda, 0x82, 0xf6,
	0x77, 0x89, 0x28, 0xfc, 0xd5, 0xb4, 0x75, 0xfe, 0x50, 0xee, 0xf5, 0xcd, 0x48, 0xba, 0x4b, 0x52,
	0x9f, 0xbd, 0xa3, 0xfa, 0xfc, 0x10, 0xd9, 0x73, 0x7d, 0x16, 0xfb, 0xe8, 0x3d, 0xa3, 0xfe, 0x73,
	0xf4, 0x07, 0x0b, 0xd0, 0x1d, 0xf5, 0x0c, 0x0b, 0xfd, 0x2c, 0x59, 0x6a, 0xe9, 0x96, 0xee, 0xa8,
	0x96, 0x3e, 0xb7, 0x3f, 0xb9, 0x60, 0x74, 0x05, 0x9c, 0xce, 0x4f, 0xed, 0x5b, 0xd6, 0x0e, 0x7a,
	0x61, 0x01, 0xfa, 0x51, 0xe4, 0xff, 0xbf, 0x7b, 0xdd, 0x55, 0xbd, 0xde, 0xd8, 0x5f, 0x62, 0x7c,
	0xb2, 0xab, 0x5f, 0x59, 0x80, 0x34, 0x6f, 0x5c, 0xfe, 0x46, 0x3f, 0x38, 0xdf, 0xe9, 0x28, 0x88,
	0x44, 0x76, 0x95, 0x3b, 0xcb, 0x5c, 0xe5, 0xef, 0x2d, 0xa8, 0xe7, 0x36, 0x00, 0xfa, 0xfa, 0x32,
	0xef, 0x21, 0x7b, 0x08, 0x1f, 0x2e, 0x9a, 0x8e, 0x7a, 0x02, 0xdf, 0x56, 0xfd, 0x7c, 0x82, 0x6e,
	0xbe, 0xd5, 0x13, 0xe0, 0x68, 0x0a, 0xb5, 0x0c, 0xfa, 0xcb, 0x8d, 0x68, 0xe1, 0x02, 0xb4, 0x6d,
	0xd5, 0xd3, 0x35, 0xd4, 0x7d, 0xe3, 0x8c, 0xf4, 0x6c, 0x7e, 0x6b, 0x41, 0x23, 0x0f, 0x73, 0xb4,
	0x30, 0xed, 0x12, 0x85, 0x6f, 0xa9, 0xc2, 0x1f, 0xdb, 0xdf, 0xb8, 0x2c, 0xa8, 0x25, 0x6c, 0x66,
	0xd0, 0xc8, 0x63, 0xf9, 0x4a, 0x1a, 0xba, 0xae, 0x1a, 0xfa, 0x60, 0xff, 0x82, 0x49, 0xc8, 0xd2,
	0xbf, 0xb4, 0xa0, 0xd5, 0x37, 0xec, 0x74, 0x99, 0xab, 0x58, 0x88, 0xd6, 0xaf, 0xa9, 0xfa, 0xd7,
	0xed, 0xad, 0xf3, 0xeb, 0xf7, 0x52, 0x5a, 0x44, 0x3f, 0xb7, 0xa0, 0xe9, 0x12, 0x2e, 0x58, 0x4c,
	0xae, 0xb4, 0x09, 0xf3, 0x64, 0x6c, 0xfb, 0x82, 0x26, 0x62, 0x5d, 0x17, 0x3d, 0x81, 0x46, 0xfe,
	0xe9, 0x5e, 0x51, 0x07, 0x06, 0x90, 0x3b, 0x17, 0x5c, 0xc3, 0xe1, 0x67, 0x7f, 0x79, 0xb5, 0x61,
	0xfd, 0xed, 0xd5, 0x86, 0xf5, 0x8f, 0x57, 0x1b, 0xd6, 0xef, 0xfe, 0xb9, 0xf1, 0xa5, 0x47, 0x3b,
	0xb9, 0xff, 0xa2, 0x4b, 0x0b, 0xec, 0x06, 0x38, 0xc4, 0x63, 0xe2, 0xcb, 0x44, 0xfc, 0x2c, 0xd3,
	0xa0, 0xa2, 0xc8, 0xf6, 0xa3, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x2c, 0xbe, 0x99, 0x2b, 0x68,
	0x14, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BackupServiceClient is the client API for BackupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BackupServiceClient interface {
	// Fetch all backup policies for a specific deployment.
	// Required permissions:
	// - backup.backuppolicy.list on the deployment that owns the backup policies and is identified by the given ID.
	ListBackupPolicies(ctx context.Context, in *ListBackupPoliciesRequest, opts ...grpc.CallOption) (*BackupPolicyList, error)
	// Fetch a backup policy identified by the given ID.
	// Required permissions:
	// - backup.backuppolicy.get on the backup policy identified by the given ID.
	GetBackupPolicy(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*BackupPolicy, error)
	// Create a new backup policy
	// Required permissions:
	// -  backup.backuppolicy.create on the deployment that owns the backup policy and is identified by the given ID..
	CreateBackupPolicy(ctx context.Context, in *BackupPolicy, opts ...grpc.CallOption) (*BackupPolicy, error)
	// Update a backup policy
	// Required permissions:
	// -  backup.backuppolicy.update on the backup policy identified by the given ID.
	UpdateBackupPolicy(ctx context.Context, in *BackupPolicy, opts ...grpc.CallOption) (*BackupPolicy, error)
	// Delete a backup policy identified by the given ID.
	// Note that the backup policy are initially only marked for deletion, no backups will be deleted with this operation.
	// Once all their dependent backups are removed, the backup policy is removed.
	// Required permissions:
	// -  backup.backuppolicy.delete on the backup policy identified by the given ID.
	DeleteBackupPolicy(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch all backups for a specific deployment.
	// Required permissions:
	// - backup.backup.list on the deployment that owns the backup and is identified by the given ID.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*BackupList, error)
	// Fetch a backup identified by the given ID.
	// Required permissions:
	// - backup.backup.get on the backup identified by the given ID.
	GetBackup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Backup, error)
	// Create a new manual backup
	// Setting the backup_policy_id field in the backup is not allowed
	// Required permissions:
	// -  backup.backup.create on the deployment that owns the backup and is identified by the given ID.
	CreateBackup(ctx context.Context, in *Backup, opts ...grpc.CallOption) (*Backup, error)
	// Update a backup
	// Required permissions:
	// -  backup.backup.update on the backup identified by the given ID.
	UpdateBackup(ctx context.Context, in *Backup, opts ...grpc.CallOption) (*Backup, error)
	// Download a backup identified by the given ID from remote storage to the volumes of the servers of the deployment
	// If this backup was already be downloaded, another download will be done.
	// If the backup is still available on the cluster there is no need to explicitly download the backup before restoring.
	// This function will return immediately.
	// To track status, please invoke GetBackup and check the .status field inside the returned backup object
	// Required permissions:
	// -  backup.backup.download on the backup identified by the given ID.
	DownloadBackup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Restore (or recover) a backup identified by the given ID
	// This operation can only be executed on backups where status.available is set
	// This function will return immediately.
	// To track status, please invoke GetDeployment on the data API and check the
	// .status.restoring_backup and .status.restore_backup_status fields inside the returned deployment object
	// Required permissions (both are needed):
	// -  backup.backup.restore on the backup identified by the given ID.
	// -  data.deployment.restore-backup on the deployment that owns this backup
	RestoreBackup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Delete a backup identified by the given ID, after which removal of any remote storage of the backup is started.
	// Note that the backup are initially only marked for deletion.
	// Once all remote storage for the backup has been removed, the backup itself is removed.
	// Required permissions:
	// -  backup.backup.delete on the backup identified by the given ID.
	DeleteBackup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
}

type backupServiceClient struct {
	cc *grpc.ClientConn
}

func NewBackupServiceClient(cc *grpc.ClientConn) BackupServiceClient {
	return &backupServiceClient{cc}
}

func (c *backupServiceClient) ListBackupPolicies(ctx context.Context, in *ListBackupPoliciesRequest, opts ...grpc.CallOption) (*BackupPolicyList, error) {
	out := new(BackupPolicyList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/ListBackupPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) GetBackupPolicy(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*BackupPolicy, error) {
	out := new(BackupPolicy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/GetBackupPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) CreateBackupPolicy(ctx context.Context, in *BackupPolicy, opts ...grpc.CallOption) (*BackupPolicy, error) {
	out := new(BackupPolicy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/CreateBackupPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) UpdateBackupPolicy(ctx context.Context, in *BackupPolicy, opts ...grpc.CallOption) (*BackupPolicy, error) {
	out := new(BackupPolicy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/UpdateBackupPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) DeleteBackupPolicy(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/DeleteBackupPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*BackupList, error) {
	out := new(BackupList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) GetBackup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/GetBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) CreateBackup(ctx context.Context, in *Backup, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/CreateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) UpdateBackup(ctx context.Context, in *Backup, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/UpdateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) DownloadBackup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/DownloadBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) RestoreBackup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/RestoreBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupServiceClient) DeleteBackup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.backup.v1.BackupService/DeleteBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackupServiceServer is the server API for BackupService service.
type BackupServiceServer interface {
	// Fetch all backup policies for a specific deployment.
	// Required permissions:
	// - backup.backuppolicy.list on the deployment that owns the backup policies and is identified by the given ID.
	ListBackupPolicies(context.Context, *ListBackupPoliciesRequest) (*BackupPolicyList, error)
	// Fetch a backup policy identified by the given ID.
	// Required permissions:
	// - backup.backuppolicy.get on the backup policy identified by the given ID.
	GetBackupPolicy(context.Context, *v1.IDOptions) (*BackupPolicy, error)
	// Create a new backup policy
	// Required permissions:
	// -  backup.backuppolicy.create on the deployment that owns the backup policy and is identified by the given ID..
	CreateBackupPolicy(context.Context, *BackupPolicy) (*BackupPolicy, error)
	// Update a backup policy
	// Required permissions:
	// -  backup.backuppolicy.update on the backup policy identified by the given ID.
	UpdateBackupPolicy(context.Context, *BackupPolicy) (*BackupPolicy, error)
	// Delete a backup policy identified by the given ID.
	// Note that the backup policy are initially only marked for deletion, no backups will be deleted with this operation.
	// Once all their dependent backups are removed, the backup policy is removed.
	// Required permissions:
	// -  backup.backuppolicy.delete on the backup policy identified by the given ID.
	DeleteBackupPolicy(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch all backups for a specific deployment.
	// Required permissions:
	// - backup.backup.list on the deployment that owns the backup and is identified by the given ID.
	ListBackups(context.Context, *ListBackupsRequest) (*BackupList, error)
	// Fetch a backup identified by the given ID.
	// Required permissions:
	// - backup.backup.get on the backup identified by the given ID.
	GetBackup(context.Context, *v1.IDOptions) (*Backup, error)
	// Create a new manual backup
	// Setting the backup_policy_id field in the backup is not allowed
	// Required permissions:
	// -  backup.backup.create on the deployment that owns the backup and is identified by the given ID.
	CreateBackup(context.Context, *Backup) (*Backup, error)
	// Update a backup
	// Required permissions:
	// -  backup.backup.update on the backup identified by the given ID.
	UpdateBackup(context.Context, *Backup) (*Backup, error)
	// Download a backup identified by the given ID from remote storage to the volumes of the servers of the deployment
	// If this backup was already be downloaded, another download will be done.
	// If the backup is still available on the cluster there is no need to explicitly download the backup before restoring.
	// This function will return immediately.
	// To track status, please invoke GetBackup and check the .status field inside the returned backup object
	// Required permissions:
	// -  backup.backup.download on the backup identified by the given ID.
	DownloadBackup(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Restore (or recover) a backup identified by the given ID
	// This operation can only be executed on backups where status.available is set
	// This function will return immediately.
	// To track status, please invoke GetDeployment on the data API and check the
	// .status.restoring_backup and .status.restore_backup_status fields inside the returned deployment object
	// Required permissions (both are needed):
	// -  backup.backup.restore on the backup identified by the given ID.
	// -  data.deployment.restore-backup on the deployment that owns this backup
	RestoreBackup(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Delete a backup identified by the given ID, after which removal of any remote storage of the backup is started.
	// Note that the backup are initially only marked for deletion.
	// Once all remote storage for the backup has been removed, the backup itself is removed.
	// Required permissions:
	// -  backup.backup.delete on the backup identified by the given ID.
	DeleteBackup(context.Context, *v1.IDOptions) (*v1.Empty, error)
}

func RegisterBackupServiceServer(s *grpc.Server, srv BackupServiceServer) {
	s.RegisterService(&_BackupService_serviceDesc, srv)
}

func _BackupService_ListBackupPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).ListBackupPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/ListBackupPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).ListBackupPolicies(ctx, req.(*ListBackupPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_GetBackupPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).GetBackupPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/GetBackupPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).GetBackupPolicy(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_CreateBackupPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupPolicy)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).CreateBackupPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/CreateBackupPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).CreateBackupPolicy(ctx, req.(*BackupPolicy))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_UpdateBackupPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupPolicy)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).UpdateBackupPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/UpdateBackupPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).UpdateBackupPolicy(ctx, req.(*BackupPolicy))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_DeleteBackupPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).DeleteBackupPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/DeleteBackupPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).DeleteBackupPolicy(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/GetBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).GetBackup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Backup)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/CreateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).CreateBackup(ctx, req.(*Backup))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_UpdateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Backup)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).UpdateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/UpdateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).UpdateBackup(ctx, req.(*Backup))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_DownloadBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).DownloadBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/DownloadBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).DownloadBackup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_RestoreBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).RestoreBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/RestoreBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).RestoreBackup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupService_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupServiceServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.backup.v1.BackupService/DeleteBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupServiceServer).DeleteBackup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _BackupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.backup.v1.BackupService",
	HandlerType: (*BackupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListBackupPolicies",
			Handler:    _BackupService_ListBackupPolicies_Handler,
		},
		{
			MethodName: "GetBackupPolicy",
			Handler:    _BackupService_GetBackupPolicy_Handler,
		},
		{
			MethodName: "CreateBackupPolicy",
			Handler:    _BackupService_CreateBackupPolicy_Handler,
		},
		{
			MethodName: "UpdateBackupPolicy",
			Handler:    _BackupService_UpdateBackupPolicy_Handler,
		},
		{
			MethodName: "DeleteBackupPolicy",
			Handler:    _BackupService_DeleteBackupPolicy_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _BackupService_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _BackupService_GetBackup_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _BackupService_CreateBackup_Handler,
		},
		{
			MethodName: "UpdateBackup",
			Handler:    _BackupService_UpdateBackup_Handler,
		},
		{
			MethodName: "DownloadBackup",
			Handler:    _BackupService_DownloadBackup_Handler,
		},
		{
			MethodName: "RestoreBackup",
			Handler:    _BackupService_RestoreBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _BackupService_DeleteBackup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "backup.proto",
}

func (m *BackupPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.DeploymentId) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.DeploymentId)))
		i += copy(dAtA[i:], m.DeploymentId)
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.CreatedAt.Size()))
		n1, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.DeletedAt.Size()))
		n2, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.IsDeleted {
		dAtA[i] = 0x40
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.IsPaused {
		dAtA[i] = 0x48
		i++
		if m.IsPaused {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Schedule != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Schedule.Size()))
		n3, err := m.Schedule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Upload {
		dAtA[i] = 0x58
		i++
		if m.Upload {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RetentionPeriod != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.RetentionPeriod.Size()))
		n4, err := m.RetentionPeriod.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.EmailNotification) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.EmailNotification)))
		i += copy(dAtA[i:], m.EmailNotification)
	}
	if m.Status != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x6
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Status.Size()))
		n5, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupPolicy_Schedule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupPolicy_Schedule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ScheduleType) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.ScheduleType)))
		i += copy(dAtA[i:], m.ScheduleType)
	}
	if m.HourlySchedule != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.HourlySchedule.Size()))
		n6, err := m.HourlySchedule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.DailySchedule != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.DailySchedule.Size()))
		n7, err := m.DailySchedule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.MonthlySchedule != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.MonthlySchedule.Size()))
		n8, err := m.MonthlySchedule.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupPolicy_HourlySchedule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupPolicy_HourlySchedule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ScheduleEveryIntervalHours != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ScheduleEveryIntervalHours))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupPolicy_DailySchedule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupPolicy_DailySchedule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Monday {
		dAtA[i] = 0x8
		i++
		if m.Monday {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Tuesday {
		dAtA[i] = 0x10
		i++
		if m.Tuesday {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Wednesday {
		dAtA[i] = 0x18
		i++
		if m.Wednesday {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Thursday {
		dAtA[i] = 0x20
		i++
		if m.Thursday {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Friday {
		dAtA[i] = 0x28
		i++
		if m.Friday {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Saturday {
		dAtA[i] = 0x30
		i++
		if m.Saturday {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Sunday {
		dAtA[i] = 0x38
		i++
		if m.Sunday {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ScheduleAt != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ScheduleAt.Size()))
		n9, err := m.ScheduleAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupPolicy_MonthlySchedule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupPolicy_MonthlySchedule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DayOfMonth != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.DayOfMonth))
	}
	if m.ScheduleAt != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ScheduleAt.Size()))
		n10, err := m.ScheduleAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupPolicy_Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupPolicy_Status) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NextBackup != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.NextBackup.Size()))
		n11, err := m.NextBackup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TimeOfDay) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeOfDay) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Hours != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Hours))
	}
	if m.Minutes != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Minutes))
	}
	if len(m.TimeZone) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.TimeZone)))
		i += copy(dAtA[i:], m.TimeZone)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupPolicyList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupPolicyList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ListBackupPoliciesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListBackupPoliciesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DeploymentId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.DeploymentId)))
		i += copy(dAtA[i:], m.DeploymentId)
	}
	if m.IncludeDeleted {
		dAtA[i] = 0x10
		i++
		if m.IncludeDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Options != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Options.Size()))
		n12, err := m.Options.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Backup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Backup) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.DeploymentId) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.DeploymentId)))
		i += copy(dAtA[i:], m.DeploymentId)
	}
	if len(m.BackupPolicyId) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.BackupPolicyId)))
		i += copy(dAtA[i:], m.BackupPolicyId)
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.CreatedAt.Size()))
		n13, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.DeletedAt.Size()))
		n14, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.IsDeleted {
		dAtA[i] = 0x48
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.AutoDeletedAt != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.AutoDeletedAt.Size()))
		n15, err := m.AutoDeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.DeploymentInfo != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.DeploymentInfo.Size()))
		n16, err := m.DeploymentInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.Upload {
		dAtA[i] = 0x60
		i++
		if m.Upload {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Status != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x6
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Status.Size()))
		n17, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Backup_DeploymentInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Backup_DeploymentInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Version) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	if m.Servers != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Servers.Size()))
		n18, err := m.Servers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Backup_Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Backup_Status) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CreatedAt != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.CreatedAt.Size()))
		n19, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	if len(m.State) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.State)))
		i += copy(dAtA[i:], m.State)
	}
	if m.IsFailed {
		dAtA[i] = 0x20
		i++
		if m.IsFailed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	if len(m.Progress) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Progress)))
		i += copy(dAtA[i:], m.Progress)
	}
	if m.SizeBytes != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.SizeBytes))
	}
	if m.Uploaded {
		dAtA[i] = 0x40
		i++
		if m.Uploaded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Downloaded {
		dAtA[i] = 0x48
		i++
		if m.Downloaded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Available {
		dAtA[i] = 0x50
		i++
		if m.Available {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ListBackupsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListBackupsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DeploymentId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.DeploymentId)))
		i += copy(dAtA[i:], m.DeploymentId)
	}
	if m.From != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.From.Size()))
		n20, err := m.From.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.To != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.To.Size()))
		n21, err := m.To.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.Options != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Options.Size()))
		n22, err := m.Options.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintBackup(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *BackupPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.IsPaused {
		n += 2
	}
	if m.Schedule != nil {
		l = m.Schedule.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Upload {
		n += 2
	}
	if m.RetentionPeriod != nil {
		l = m.RetentionPeriod.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.EmailNotification)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 2 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupPolicy_Schedule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ScheduleType)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.HourlySchedule != nil {
		l = m.HourlySchedule.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.DailySchedule != nil {
		l = m.DailySchedule.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.MonthlySchedule != nil {
		l = m.MonthlySchedule.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupPolicy_HourlySchedule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ScheduleEveryIntervalHours != 0 {
		n += 1 + sovBackup(uint64(m.ScheduleEveryIntervalHours))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupPolicy_DailySchedule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Monday {
		n += 2
	}
	if m.Tuesday {
		n += 2
	}
	if m.Wednesday {
		n += 2
	}
	if m.Thursday {
		n += 2
	}
	if m.Friday {
		n += 2
	}
	if m.Saturday {
		n += 2
	}
	if m.Sunday {
		n += 2
	}
	if m.ScheduleAt != nil {
		l = m.ScheduleAt.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupPolicy_MonthlySchedule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DayOfMonth != 0 {
		n += 1 + sovBackup(uint64(m.DayOfMonth))
	}
	if m.ScheduleAt != nil {
		l = m.ScheduleAt.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupPolicy_Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NextBackup != nil {
		l = m.NextBackup.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimeOfDay) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Hours != 0 {
		n += 1 + sovBackup(uint64(m.Hours))
	}
	if m.Minutes != 0 {
		n += 1 + sovBackup(uint64(m.Minutes))
	}
	l = len(m.TimeZone)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupPolicyList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListBackupPoliciesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.IncludeDeleted {
		n += 2
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Backup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.BackupPolicyId)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.AutoDeletedAt != nil {
		l = m.AutoDeletedAt.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.DeploymentInfo != nil {
		l = m.DeploymentInfo.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Upload {
		n += 2
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 2 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Backup_DeploymentInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Servers != nil {
		l = m.Servers.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Backup_Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.IsFailed {
		n += 2
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Progress)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.SizeBytes != 0 {
		n += 1 + sovBackup(uint64(m.SizeBytes))
	}
	if m.Uploaded {
		n += 2
	}
	if m.Downloaded {
		n += 2
	}
	if m.Available {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListBackupsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.From != nil {
		l = m.From.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.To != nil {
		l = m.To.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovBackup(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBackup(x uint64) (n int) {
	return sovBackup(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BackupPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsPaused", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsPaused = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Schedule == nil {
				m.Schedule = &BackupPolicy_Schedule{}
			}
			if err := m.Schedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Upload", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Upload = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetentionPeriod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetentionPeriod == nil {
				m.RetentionPeriod = &types.Duration{}
			}
			if err := m.RetentionPeriod.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmailNotification", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EmailNotification = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &BackupPolicy_Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupPolicy_Schedule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Schedule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Schedule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScheduleType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HourlySchedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HourlySchedule == nil {
				m.HourlySchedule = &BackupPolicy_HourlySchedule{}
			}
			if err := m.HourlySchedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DailySchedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DailySchedule == nil {
				m.DailySchedule = &BackupPolicy_DailySchedule{}
			}
			if err := m.DailySchedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonthlySchedule", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MonthlySchedule == nil {
				m.MonthlySchedule = &BackupPolicy_MonthlySchedule{}
			}
			if err := m.MonthlySchedule.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupPolicy_HourlySchedule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HourlySchedule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HourlySchedule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleEveryIntervalHours", wireType)
			}
			m.ScheduleEveryIntervalHours = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScheduleEveryIntervalHours |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupPolicy_DailySchedule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DailySchedule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DailySchedule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Monday", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Monday = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tuesday", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tuesday = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Wednesday", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Wednesday = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Thursday", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Thursday = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Friday", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Friday = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Saturday", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Saturday = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sunday", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Sunday = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleAt == nil {
				m.ScheduleAt = &TimeOfDay{}
			}
			if err := m.ScheduleAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupPolicy_MonthlySchedule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MonthlySchedule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MonthlySchedule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DayOfMonth", wireType)
			}
			m.DayOfMonth = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DayOfMonth |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScheduleAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScheduleAt == nil {
				m.ScheduleAt = &TimeOfDay{}
			}
			if err := m.ScheduleAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupPolicy_Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextBackup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NextBackup == nil {
				m.NextBackup = &types.Timestamp{}
			}
			if err := m.NextBackup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeOfDay) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeOfDay: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeOfDay: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hours", wireType)
			}
			m.Hours = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Hours |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Minutes", wireType)
			}
			m.Minutes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Minutes |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeZone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeZone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupPolicyList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupPolicyList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupPolicyList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &BackupPolicy{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListBackupPoliciesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListBackupPoliciesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListBackupPoliciesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Backup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Backup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Backup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupPolicyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackupPolicyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoDeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AutoDeletedAt == nil {
				m.AutoDeletedAt = &types.Timestamp{}
			}
			if err := m.AutoDeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeploymentInfo == nil {
				m.DeploymentInfo = &Backup_DeploymentInfo{}
			}
			if err := m.DeploymentInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Upload", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Upload = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &Backup_Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Backup_DeploymentInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Servers == nil {
				m.Servers = &v11.Deployment_ServersSpec{}
			}
			if err := m.Servers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Backup_Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFailed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFailed = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Progress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Progress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeBytes", wireType)
			}
			m.SizeBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SizeBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uploaded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Uploaded = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Downloaded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Downloaded = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Available = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Backup{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListBackupsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListBackupsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListBackupsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.From == nil {
				m.From = &types.Timestamp{}
			}
			if err := m.From.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = &types.Timestamp{}
			}
			if err := m.To.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBackup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBackup(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthBackup
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthBackup
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBackup
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBackup(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthBackup
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBackup = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBackup   = fmt.Errorf("proto: integer overflow")
)
