// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: data.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A Deployment is represents one deployment of an ArangoDB cluster.
type Deployment struct {
	// System identifier of the deployment.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the deployment
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the deployment
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that owns this deployment.
	// After creation, this value cannot be changed.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of the region in which the deployment is created.
	// After creation, this value cannot be changed.
	RegionId string `protobuf:"bytes,6,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// The creation timestamp of the deployment
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the deployment
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this deployment is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Optional identifier of the support plan selected for this deployment.
	// After creation, this value cannot be changed.
	// If no support plan identifier is set, the default support plan is used.
	SupportPlanId string `protobuf:"bytes,10,opt,name=support_plan_id,json=supportPlanId,proto3" json:"support_plan_id,omitempty"`
	// Identifier of the user who created this deployment.
	// This is a read-only value.
	CreatedById string `protobuf:"bytes,11,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// ArangoDB version to use for this deployment.
	// See Version.version.
	// If you change this value to a higher version,
	// the deployment will be upgraded.
	// If you change this value to a lower patch value,
	// the deployment will be downgraded.
	// Any attempt to change to a lower minor or major version
	// is considered an invalid request.
	// Any attempt to change to a version that is not in the
	// list of available versions is considered an invalid request.
	Version      string                      `protobuf:"bytes,101,opt,name=version,proto3" json:"version,omitempty"`
	Certificates *Deployment_CertificateSpec `protobuf:"bytes,102,opt,name=certificates,proto3" json:"certificates,omitempty"`
	Servers      *Deployment_ServersSpec     `protobuf:"bytes,103,opt,name=servers,proto3" json:"servers,omitempty"`
	// Optional identifier of IP whitelist to use for this deployment.
	IpwhitelistId string             `protobuf:"bytes,105,opt,name=ipwhitelist_id,json=ipwhitelistId,proto3" json:"ipwhitelist_id,omitempty"`
	Status        *Deployment_Status `protobuf:"bytes,201,opt,name=status,proto3" json:"status,omitempty"`
	// Detailed size of the deployment
	// This is a read-only field.
	Size_      *DeploymentSize        `protobuf:"bytes,202,opt,name=size,proto3" json:"size,omitempty"`
	Expiration *Deployment_Expiration `protobuf:"bytes,301,opt,name=expiration,proto3" json:"expiration,omitempty"`
	// Information about a backup restore.
	// If this field is set the deployment will be restored to that backup.
	// This is a read-only field. To set this field please use the backup service RestoreBackup method.
	BackupRestore        *Deployment_BackupRestoreSpec `protobuf:"bytes,401,opt,name=backup_restore,json=backupRestore,proto3" json:"backup_restore,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *Deployment) Reset()         { *m = Deployment{} }
func (m *Deployment) String() string { return proto.CompactTextString(m) }
func (*Deployment) ProtoMessage()    {}
func (*Deployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0}
}
func (m *Deployment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment.Merge(m, src)
}
func (m *Deployment) XXX_Size() int {
	return m.Size()
}
func (m *Deployment) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment proto.InternalMessageInfo

func (m *Deployment) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Deployment) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Deployment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Deployment) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Deployment) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Deployment) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *Deployment) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Deployment) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Deployment) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Deployment) GetSupportPlanId() string {
	if m != nil {
		return m.SupportPlanId
	}
	return ""
}

func (m *Deployment) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *Deployment) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Deployment) GetCertificates() *Deployment_CertificateSpec {
	if m != nil {
		return m.Certificates
	}
	return nil
}

func (m *Deployment) GetServers() *Deployment_ServersSpec {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *Deployment) GetIpwhitelistId() string {
	if m != nil {
		return m.IpwhitelistId
	}
	return ""
}

func (m *Deployment) GetStatus() *Deployment_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Deployment) GetSize_() *DeploymentSize {
	if m != nil {
		return m.Size_
	}
	return nil
}

func (m *Deployment) GetExpiration() *Deployment_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (m *Deployment) GetBackupRestore() *Deployment_BackupRestoreSpec {
	if m != nil {
		return m.BackupRestore
	}
	return nil
}

type Deployment_CertificateSpec struct {
	// Identifier of the CACertificate used to sign TLS certificates for the deployment.
	// If you change this value after the creation of the deployment a complete
	// rotation of the deployment is required, which will result in some downtime.
	CaCertificateId string `protobuf:"bytes,1,opt,name=ca_certificate_id,json=caCertificateId,proto3" json:"ca_certificate_id,omitempty"`
	// Zero or more DNS names to include in the TLS certificate of the deployment.
	AlternateDnsNames    []string `protobuf:"bytes,2,rep,name=alternate_dns_names,json=alternateDnsNames,proto3" json:"alternate_dns_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_CertificateSpec) Reset()         { *m = Deployment_CertificateSpec{} }
func (m *Deployment_CertificateSpec) String() string { return proto.CompactTextString(m) }
func (*Deployment_CertificateSpec) ProtoMessage()    {}
func (*Deployment_CertificateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 0}
}
func (m *Deployment_CertificateSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_CertificateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_CertificateSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_CertificateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_CertificateSpec.Merge(m, src)
}
func (m *Deployment_CertificateSpec) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_CertificateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_CertificateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_CertificateSpec proto.InternalMessageInfo

func (m *Deployment_CertificateSpec) GetCaCertificateId() string {
	if m != nil {
		return m.CaCertificateId
	}
	return ""
}

func (m *Deployment_CertificateSpec) GetAlternateDnsNames() []string {
	if m != nil {
		return m.AlternateDnsNames
	}
	return nil
}

type Deployment_ServersSpec struct {
	// Number of coordinators of the deployment
	Coordinators int32 `protobuf:"varint,1,opt,name=coordinators,proto3" json:"coordinators,omitempty"`
	// Amount of memory (in GB) to allocate for coordinators.
	CoordinatorMemorySize int32 `protobuf:"varint,2,opt,name=coordinator_memory_size,json=coordinatorMemorySize,proto3" json:"coordinator_memory_size,omitempty"`
	// Custom command line arguments passed to all coordinators.
	CoordinatorArgs []string `protobuf:"bytes,3,rep,name=coordinator_args,json=coordinatorArgs,proto3" json:"coordinator_args,omitempty"`
	// Number of dbservers of the deployment
	Dbservers int32 `protobuf:"varint,11,opt,name=dbservers,proto3" json:"dbservers,omitempty"`
	// Amount of memory (in GB) to allocate for dbservers.
	DbserverMemorySize int32 `protobuf:"varint,12,opt,name=dbserver_memory_size,json=dbserverMemorySize,proto3" json:"dbserver_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for dbservers.
	DbserverDiskSize int32 `protobuf:"varint,13,opt,name=dbserver_disk_size,json=dbserverDiskSize,proto3" json:"dbserver_disk_size,omitempty"`
	// Custom command line arguments passed to all dbservers.
	DbserverArgs         []string `protobuf:"bytes,14,rep,name=dbserver_args,json=dbserverArgs,proto3" json:"dbserver_args,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_ServersSpec) Reset()         { *m = Deployment_ServersSpec{} }
func (m *Deployment_ServersSpec) String() string { return proto.CompactTextString(m) }
func (*Deployment_ServersSpec) ProtoMessage()    {}
func (*Deployment_ServersSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 1}
}
func (m *Deployment_ServersSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_ServersSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_ServersSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_ServersSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_ServersSpec.Merge(m, src)
}
func (m *Deployment_ServersSpec) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_ServersSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_ServersSpec.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_ServersSpec proto.InternalMessageInfo

func (m *Deployment_ServersSpec) GetCoordinators() int32 {
	if m != nil {
		return m.Coordinators
	}
	return 0
}

func (m *Deployment_ServersSpec) GetCoordinatorMemorySize() int32 {
	if m != nil {
		return m.CoordinatorMemorySize
	}
	return 0
}

func (m *Deployment_ServersSpec) GetCoordinatorArgs() []string {
	if m != nil {
		return m.CoordinatorArgs
	}
	return nil
}

func (m *Deployment_ServersSpec) GetDbservers() int32 {
	if m != nil {
		return m.Dbservers
	}
	return 0
}

func (m *Deployment_ServersSpec) GetDbserverMemorySize() int32 {
	if m != nil {
		return m.DbserverMemorySize
	}
	return 0
}

func (m *Deployment_ServersSpec) GetDbserverDiskSize() int32 {
	if m != nil {
		return m.DbserverDiskSize
	}
	return 0
}

func (m *Deployment_ServersSpec) GetDbserverArgs() []string {
	if m != nil {
		return m.DbserverArgs
	}
	return nil
}

// Status of a single server (of the ArangoDB cluster)
type Deployment_ServerStatus struct {
	// ID of the server
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Type of server (agent|coordinator|dbserver)
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Human readable description of the status of the deployment.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The creation timestamp of the server
	CreatedAt *types.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Set once the server is ready
	Ready bool `protobuf:"varint,5,opt,name=ready,proto3" json:"ready,omitempty"`
	// Set once the server has been known to be a member of the cluster
	MemberOfCluster bool `protobuf:"varint,6,opt,name=member_of_cluster,json=memberOfCluster,proto3" json:"member_of_cluster,omitempty"`
	// Set if the server is in a failed state
	// Every server is always in 1 (and only 1) of these state: failed/creating/ok/upgrading.
	Failed bool `protobuf:"varint,7,opt,name=failed,proto3" json:"failed,omitempty"`
	// Set if the server is still being created
	// Every server is always in 1 (and only 1) of these state: failed/creating/ok/upgrading.
	Creating bool `protobuf:"varint,8,opt,name=creating,proto3" json:"creating,omitempty"`
	// Set if the server is in the ok state.
	// Every server is always in 1 (and only 1) of these state: failed/creating/ok/upgrading.
	Ok bool `protobuf:"varint,9,opt,name=ok,proto3" json:"ok,omitempty"`
	// Set if the server is still being upgraded
	// Every server is always in 1 (and only 1) of these state: failed/creating/ok/upgrading.
	Upgrading bool `protobuf:"varint,10,opt,name=upgrading,proto3" json:"upgrading,omitempty"`
	// Latest known ArangoDB version used by this server.
	// Initially this field is empty.
	Version string `protobuf:"bytes,11,opt,name=version,proto3" json:"version,omitempty"`
	// Information about the data volume used to store the data
	DataVolumeInfo       *DataVolumeInfo `protobuf:"bytes,20,opt,name=data_volume_info,json=dataVolumeInfo,proto3" json:"data_volume_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Deployment_ServerStatus) Reset()         { *m = Deployment_ServerStatus{} }
func (m *Deployment_ServerStatus) String() string { return proto.CompactTextString(m) }
func (*Deployment_ServerStatus) ProtoMessage()    {}
func (*Deployment_ServerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 2}
}
func (m *Deployment_ServerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_ServerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_ServerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_ServerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_ServerStatus.Merge(m, src)
}
func (m *Deployment_ServerStatus) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_ServerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_ServerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_ServerStatus proto.InternalMessageInfo

func (m *Deployment_ServerStatus) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Deployment_ServerStatus) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Deployment_ServerStatus) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Deployment_ServerStatus) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Deployment_ServerStatus) GetReady() bool {
	if m != nil {
		return m.Ready
	}
	return false
}

func (m *Deployment_ServerStatus) GetMemberOfCluster() bool {
	if m != nil {
		return m.MemberOfCluster
	}
	return false
}

func (m *Deployment_ServerStatus) GetFailed() bool {
	if m != nil {
		return m.Failed
	}
	return false
}

func (m *Deployment_ServerStatus) GetCreating() bool {
	if m != nil {
		return m.Creating
	}
	return false
}

func (m *Deployment_ServerStatus) GetOk() bool {
	if m != nil {
		return m.Ok
	}
	return false
}

func (m *Deployment_ServerStatus) GetUpgrading() bool {
	if m != nil {
		return m.Upgrading
	}
	return false
}

func (m *Deployment_ServerStatus) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Deployment_ServerStatus) GetDataVolumeInfo() *DataVolumeInfo {
	if m != nil {
		return m.DataVolumeInfo
	}
	return nil
}

// Status of the deployment
// All members of this field are read-only.
type Deployment_Status struct {
	// Endpoint URL used to reach the deployment
	// This value will be empty during the creation of the deployment.
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Human readable description of the status of the deployment.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Set once the deployment has been created.
	Created bool `protobuf:"varint,3,opt,name=created,proto3" json:"created,omitempty"`
	// Set if the deployment is ready to be used.
	// If the deployment has downtime (e.g. because of changing a CA certificate)
	// this will go to false until the downtime is over.
	Ready bool `protobuf:"varint,4,opt,name=ready,proto3" json:"ready,omitempty"`
	// Set if the deployment is being upgraded.
	Upgrading bool `protobuf:"varint,5,opt,name=upgrading,proto3" json:"upgrading,omitempty"`
	// Versions of running servers
	ServerVersions []string `protobuf:"bytes,6,rep,name=server_versions,json=serverVersions,proto3" json:"server_versions,omitempty"`
	// Status of individual servers of the deployment
	Servers []*Deployment_ServerStatus `protobuf:"bytes,7,rep,name=servers,proto3" json:"servers,omitempty"`
	// Set if the ready boolean is transitioned to true for the very first time.
	BootstrappedAt *types.Timestamp `protobuf:"bytes,8,opt,name=bootstrapped_at,json=bootstrappedAt,proto3" json:"bootstrapped_at,omitempty"`
	// Set if bootstrapped_at has a value, otherwise false.
	Bootstrapped bool `protobuf:"varint,9,opt,name=bootstrapped,proto3" json:"bootstrapped,omitempty"`
	// The status of backup restore (if applicable).
	// This field will be set to empty if a new revision of the spec is available
	BackupRestoreStatus  *Deployment_BackupRestoreStatus `protobuf:"bytes,100,opt,name=backup_restore_status,json=backupRestoreStatus,proto3" json:"backup_restore_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Deployment_Status) Reset()         { *m = Deployment_Status{} }
func (m *Deployment_Status) String() string { return proto.CompactTextString(m) }
func (*Deployment_Status) ProtoMessage()    {}
func (*Deployment_Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 3}
}
func (m *Deployment_Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_Status.Merge(m, src)
}
func (m *Deployment_Status) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_Status) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_Status.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_Status proto.InternalMessageInfo

func (m *Deployment_Status) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Deployment_Status) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Deployment_Status) GetCreated() bool {
	if m != nil {
		return m.Created
	}
	return false
}

func (m *Deployment_Status) GetReady() bool {
	if m != nil {
		return m.Ready
	}
	return false
}

func (m *Deployment_Status) GetUpgrading() bool {
	if m != nil {
		return m.Upgrading
	}
	return false
}

func (m *Deployment_Status) GetServerVersions() []string {
	if m != nil {
		return m.ServerVersions
	}
	return nil
}

func (m *Deployment_Status) GetServers() []*Deployment_ServerStatus {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *Deployment_Status) GetBootstrappedAt() *types.Timestamp {
	if m != nil {
		return m.BootstrappedAt
	}
	return nil
}

func (m *Deployment_Status) GetBootstrapped() bool {
	if m != nil {
		return m.Bootstrapped
	}
	return false
}

func (m *Deployment_Status) GetBackupRestoreStatus() *Deployment_BackupRestoreStatus {
	if m != nil {
		return m.BackupRestoreStatus
	}
	return nil
}

// The status of backup restore
// All members of this message are read-only.
type Deployment_BackupRestoreStatus struct {
	// The revision of the used BackupRestoreSpec
	Revision int32 `protobuf:"varint,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// Set if the deployment is preparing or restoring a backup
	Restoring bool `protobuf:"varint,10,opt,name=restoring,proto3" json:"restoring,omitempty"`
	// Status of the restore backup operation.
	// Enum of the following values: "<empty>|Preparing|Restoring|Restored|Failed"
	Status string `protobuf:"bytes,11,opt,name=status,proto3" json:"status,omitempty"`
	// Failure reason of the backup restore (if applicable)
	FailureReason        string   `protobuf:"bytes,12,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_BackupRestoreStatus) Reset()         { *m = Deployment_BackupRestoreStatus{} }
func (m *Deployment_BackupRestoreStatus) String() string { return proto.CompactTextString(m) }
func (*Deployment_BackupRestoreStatus) ProtoMessage()    {}
func (*Deployment_BackupRestoreStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 4}
}
func (m *Deployment_BackupRestoreStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_BackupRestoreStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_BackupRestoreStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_BackupRestoreStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_BackupRestoreStatus.Merge(m, src)
}
func (m *Deployment_BackupRestoreStatus) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_BackupRestoreStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_BackupRestoreStatus.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_BackupRestoreStatus proto.InternalMessageInfo

func (m *Deployment_BackupRestoreStatus) GetRevision() int32 {
	if m != nil {
		return m.Revision
	}
	return 0
}

func (m *Deployment_BackupRestoreStatus) GetRestoring() bool {
	if m != nil {
		return m.Restoring
	}
	return false
}

func (m *Deployment_BackupRestoreStatus) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Deployment_BackupRestoreStatus) GetFailureReason() string {
	if m != nil {
		return m.FailureReason
	}
	return ""
}

// Expiration of the deployment.
// All members of this message are read-only.
type Deployment_Expiration struct {
	// The expiration timestamp of the deployment
	// If not set, the deployment will not expire.
	ExpiresAt *types.Timestamp `protobuf:"bytes,1,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// Human readable reason for why the deployment expires (or does not expire).
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	// The timestamp of when the last "this deployment will expire at" email was
	// send.
	// If not set, no such email has been send.
	LastWarningEmailSendAt *types.Timestamp `protobuf:"bytes,3,opt,name=last_warning_email_send_at,json=lastWarningEmailSendAt,proto3" json:"last_warning_email_send_at,omitempty"`
	// List of email addresses to which the last warning email has been send.
	// Not set when no such email has been send.
	LastWarningEmailSendTo []string `protobuf:"bytes,4,rep,name=last_warning_email_send_to,json=lastWarningEmailSendTo,proto3" json:"last_warning_email_send_to,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Deployment_Expiration) Reset()         { *m = Deployment_Expiration{} }
func (m *Deployment_Expiration) String() string { return proto.CompactTextString(m) }
func (*Deployment_Expiration) ProtoMessage()    {}
func (*Deployment_Expiration) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 5}
}
func (m *Deployment_Expiration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_Expiration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_Expiration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_Expiration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_Expiration.Merge(m, src)
}
func (m *Deployment_Expiration) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_Expiration) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_Expiration.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_Expiration proto.InternalMessageInfo

func (m *Deployment_Expiration) GetExpiresAt() *types.Timestamp {
	if m != nil {
		return m.ExpiresAt
	}
	return nil
}

func (m *Deployment_Expiration) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Deployment_Expiration) GetLastWarningEmailSendAt() *types.Timestamp {
	if m != nil {
		return m.LastWarningEmailSendAt
	}
	return nil
}

func (m *Deployment_Expiration) GetLastWarningEmailSendTo() []string {
	if m != nil {
		return m.LastWarningEmailSendTo
	}
	return nil
}

// Information about a backup restore.
// All members of this message are read-only.
type Deployment_BackupRestoreSpec struct {
	// The revision of this BackupRestoreSpec
	Revision int32 `protobuf:"varint,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// The timestamp of when the last revision has been updated.
	LastUpdatedAt *types.Timestamp `protobuf:"bytes,2,opt,name=last_updated_at,json=lastUpdatedAt,proto3" json:"last_updated_at,omitempty"`
	// Identifier of a backup to restore to.
	BackupId             string   `protobuf:"bytes,10,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_BackupRestoreSpec) Reset()         { *m = Deployment_BackupRestoreSpec{} }
func (m *Deployment_BackupRestoreSpec) String() string { return proto.CompactTextString(m) }
func (*Deployment_BackupRestoreSpec) ProtoMessage()    {}
func (*Deployment_BackupRestoreSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 6}
}
func (m *Deployment_BackupRestoreSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_BackupRestoreSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_BackupRestoreSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_BackupRestoreSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_BackupRestoreSpec.Merge(m, src)
}
func (m *Deployment_BackupRestoreSpec) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_BackupRestoreSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_BackupRestoreSpec.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_BackupRestoreSpec proto.InternalMessageInfo

func (m *Deployment_BackupRestoreSpec) GetRevision() int32 {
	if m != nil {
		return m.Revision
	}
	return 0
}

func (m *Deployment_BackupRestoreSpec) GetLastUpdatedAt() *types.Timestamp {
	if m != nil {
		return m.LastUpdatedAt
	}
	return nil
}

func (m *Deployment_BackupRestoreSpec) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

// Request arguments for ListServersSpecPresets and GetDefaultServersSpecPreset
type ServersSpecPresetsRequest struct {
	// Identifier of project that will own a deployment.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of a region in which a deployment will be created.
	RegionId             string   `protobuf:"bytes,2,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServersSpecPresetsRequest) Reset()         { *m = ServersSpecPresetsRequest{} }
func (m *ServersSpecPresetsRequest) String() string { return proto.CompactTextString(m) }
func (*ServersSpecPresetsRequest) ProtoMessage()    {}
func (*ServersSpecPresetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{1}
}
func (m *ServersSpecPresetsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecPresetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecPresetsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecPresetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecPresetsRequest.Merge(m, src)
}
func (m *ServersSpecPresetsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecPresetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecPresetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecPresetsRequest proto.InternalMessageInfo

func (m *ServersSpecPresetsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ServersSpecPresetsRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

// Specification of a ServersSpecPreset, which can be used to initialize a deployment.servers
type ServersSpecPreset struct {
	// Name of the ServersSpecPreset
	// This is a read-only value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set when this preset is the default.
	// This is a read-only value.
	IsDefault bool `protobuf:"varint,2,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// The ServersSpec associated for this name
	Servers              *Deployment_ServersSpec `protobuf:"bytes,3,opt,name=servers,proto3" json:"servers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ServersSpecPreset) Reset()         { *m = ServersSpecPreset{} }
func (m *ServersSpecPreset) String() string { return proto.CompactTextString(m) }
func (*ServersSpecPreset) ProtoMessage()    {}
func (*ServersSpecPreset) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{2}
}
func (m *ServersSpecPreset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecPreset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecPreset.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecPreset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecPreset.Merge(m, src)
}
func (m *ServersSpecPreset) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecPreset) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecPreset.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecPreset proto.InternalMessageInfo

func (m *ServersSpecPreset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServersSpecPreset) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *ServersSpecPreset) GetServers() *Deployment_ServersSpec {
	if m != nil {
		return m.Servers
	}
	return nil
}

// List of ServersSpecPreset.
type ServersSpecPresetList struct {
	Items                []*ServersSpecPreset `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ServersSpecPresetList) Reset()         { *m = ServersSpecPresetList{} }
func (m *ServersSpecPresetList) String() string { return proto.CompactTextString(m) }
func (*ServersSpecPresetList) ProtoMessage()    {}
func (*ServersSpecPresetList) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{3}
}
func (m *ServersSpecPresetList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecPresetList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecPresetList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecPresetList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecPresetList.Merge(m, src)
}
func (m *ServersSpecPresetList) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecPresetList) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecPresetList.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecPresetList proto.InternalMessageInfo

func (m *ServersSpecPresetList) GetItems() []*ServersSpecPreset {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for GetDeploymentCredentials
type DeploymentCredentialsRequest struct {
	// Identifier of deployment to request credentials for.
	DeploymentId         string   `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentCredentialsRequest) Reset()         { *m = DeploymentCredentialsRequest{} }
func (m *DeploymentCredentialsRequest) String() string { return proto.CompactTextString(m) }
func (*DeploymentCredentialsRequest) ProtoMessage()    {}
func (*DeploymentCredentialsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{4}
}
func (m *DeploymentCredentialsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentCredentialsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentCredentialsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentCredentialsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentCredentialsRequest.Merge(m, src)
}
func (m *DeploymentCredentialsRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentCredentialsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentCredentialsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentCredentialsRequest proto.InternalMessageInfo

func (m *DeploymentCredentialsRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

// Result for GetDeploymentCredentials
type DeploymentCredentials struct {
	// Name of the user for which credentials were asked.
	// Default to username of root user.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Password of the user for which credentials were asked.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentCredentials) Reset()         { *m = DeploymentCredentials{} }
func (m *DeploymentCredentials) String() string { return proto.CompactTextString(m) }
func (*DeploymentCredentials) ProtoMessage()    {}
func (*DeploymentCredentials) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{5}
}
func (m *DeploymentCredentials) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentCredentials) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentCredentials.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentCredentials) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentCredentials.Merge(m, src)
}
func (m *DeploymentCredentials) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentCredentials) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentCredentials.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentCredentials proto.InternalMessageInfo

func (m *DeploymentCredentials) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *DeploymentCredentials) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// List of Deployments.
type DeploymentList struct {
	// Actual deployments
	Items []*Deployment `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// Budget for deployments
	Budget               *v1.Budget `protobuf:"bytes,2,opt,name=budget,proto3" json:"budget,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *DeploymentList) Reset()         { *m = DeploymentList{} }
func (m *DeploymentList) String() string { return proto.CompactTextString(m) }
func (*DeploymentList) ProtoMessage()    {}
func (*DeploymentList) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{6}
}
func (m *DeploymentList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentList.Merge(m, src)
}
func (m *DeploymentList) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentList) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentList.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentList proto.InternalMessageInfo

func (m *DeploymentList) GetItems() []*Deployment {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *DeploymentList) GetBudget() *v1.Budget {
	if m != nil {
		return m.Budget
	}
	return nil
}

// Version of an ArangoDB release
type Version struct {
	// Version in the format of major.minor.patch
	Version              string   `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Version) Reset()         { *m = Version{} }
func (m *Version) String() string { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()    {}
func (*Version) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{7}
}
func (m *Version) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Version) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Version.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Version) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Version.Merge(m, src)
}
func (m *Version) XXX_Size() int {
	return m.Size()
}
func (m *Version) XXX_DiscardUnknown() {
	xxx_messageInfo_Version.DiscardUnknown(m)
}

var xxx_messageInfo_Version proto.InternalMessageInfo

func (m *Version) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

// List of Versions.
type VersionList struct {
	Items                []*Version `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *VersionList) Reset()         { *m = VersionList{} }
func (m *VersionList) String() string { return proto.CompactTextString(m) }
func (*VersionList) ProtoMessage()    {}
func (*VersionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{8}
}
func (m *VersionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VersionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VersionList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VersionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionList.Merge(m, src)
}
func (m *VersionList) XXX_Size() int {
	return m.Size()
}
func (m *VersionList) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionList.DiscardUnknown(m)
}

var xxx_messageInfo_VersionList proto.InternalMessageInfo

func (m *VersionList) GetItems() []*Version {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListVersions.
type ListVersionsRequest struct {
	// Common list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, the result includes all versions for that are available for the
	// organization identified by this ID.
	// If not set, only versions are returned that are available to all organizations.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, only versions will be returned that are safe to upgrade to from this version.
	CurrentVersion       string   `protobuf:"bytes,3,opt,name=current_version,json=currentVersion,proto3" json:"current_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVersionsRequest) Reset()         { *m = ListVersionsRequest{} }
func (m *ListVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListVersionsRequest) ProtoMessage()    {}
func (*ListVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{9}
}
func (m *ListVersionsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListVersionsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVersionsRequest.Merge(m, src)
}
func (m *ListVersionsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListVersionsRequest proto.InternalMessageInfo

func (m *ListVersionsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListVersionsRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListVersionsRequest) GetCurrentVersion() string {
	if m != nil {
		return m.CurrentVersion
	}
	return ""
}

// Request arguments for ListServersSpecLimits
type ServersSpecLimitsRequest struct {
	// Identifier of project that will own a deployment.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of a region in which a deployment will be created.
	RegionId string `protobuf:"bytes,2,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// Optional identifier of a deployment for which compatible server specifications are request.
	DeploymentId         string   `protobuf:"bytes,3,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServersSpecLimitsRequest) Reset()         { *m = ServersSpecLimitsRequest{} }
func (m *ServersSpecLimitsRequest) String() string { return proto.CompactTextString(m) }
func (*ServersSpecLimitsRequest) ProtoMessage()    {}
func (*ServersSpecLimitsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{10}
}
func (m *ServersSpecLimitsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecLimitsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecLimitsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecLimitsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecLimitsRequest.Merge(m, src)
}
func (m *ServersSpecLimitsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecLimitsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecLimitsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecLimitsRequest proto.InternalMessageInfo

func (m *ServersSpecLimitsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ServersSpecLimitsRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *ServersSpecLimitsRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

// Limits of allowed values for fields of Deployment.ServersSpec.
type ServersSpecLimits struct {
	// Limits for the number of coordinators of the deployment
	Coordinators *ServersSpecLimits_Limits `protobuf:"bytes,1,opt,name=coordinators,proto3" json:"coordinators,omitempty"`
	// Possible values for the amount of memory (in GB) to allocate
	// for coordinators.
	CoordinatorMemorySize *ServersSpecLimits_Limits `protobuf:"bytes,2,opt,name=coordinator_memory_size,json=coordinatorMemorySize,proto3" json:"coordinator_memory_size,omitempty"`
	// Limits for the number of dbservers of the deployment
	Dbservers *ServersSpecLimits_Limits `protobuf:"bytes,11,opt,name=dbservers,proto3" json:"dbservers,omitempty"`
	// Possible values for the amount of memory (in GB) to allocate
	// for dbservers.
	DbserverMemorySize *ServersSpecLimits_Limits `protobuf:"bytes,12,opt,name=dbserver_memory_size,json=dbserverMemorySize,proto3" json:"dbserver_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for dbservers.
	DbserverDiskSize     *ServersSpecLimits_Limits `protobuf:"bytes,13,opt,name=dbserver_disk_size,json=dbserverDiskSize,proto3" json:"dbserver_disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ServersSpecLimits) Reset()         { *m = ServersSpecLimits{} }
func (m *ServersSpecLimits) String() string { return proto.CompactTextString(m) }
func (*ServersSpecLimits) ProtoMessage()    {}
func (*ServersSpecLimits) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{11}
}
func (m *ServersSpecLimits) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecLimits) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecLimits.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecLimits) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecLimits.Merge(m, src)
}
func (m *ServersSpecLimits) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecLimits) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecLimits.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecLimits proto.InternalMessageInfo

func (m *ServersSpecLimits) GetCoordinators() *ServersSpecLimits_Limits {
	if m != nil {
		return m.Coordinators
	}
	return nil
}

func (m *ServersSpecLimits) GetCoordinatorMemorySize() *ServersSpecLimits_Limits {
	if m != nil {
		return m.CoordinatorMemorySize
	}
	return nil
}

func (m *ServersSpecLimits) GetDbservers() *ServersSpecLimits_Limits {
	if m != nil {
		return m.Dbservers
	}
	return nil
}

func (m *ServersSpecLimits) GetDbserverMemorySize() *ServersSpecLimits_Limits {
	if m != nil {
		return m.DbserverMemorySize
	}
	return nil
}

func (m *ServersSpecLimits) GetDbserverDiskSize() *ServersSpecLimits_Limits {
	if m != nil {
		return m.DbserverDiskSize
	}
	return nil
}

type ServersSpecLimits_Limits struct {
	// Minimum value
	Min int32 `protobuf:"varint,1,opt,name=min,proto3" json:"min,omitempty"`
	// Maximum value
	Max int32 `protobuf:"varint,2,opt,name=max,proto3" json:"max,omitempty"`
	// Set of allowed values.
	// If this field is non-empty, only one of these values
	// is allowed.
	AllowedValues        []int32  `protobuf:"varint,3,rep,packed,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServersSpecLimits_Limits) Reset()         { *m = ServersSpecLimits_Limits{} }
func (m *ServersSpecLimits_Limits) String() string { return proto.CompactTextString(m) }
func (*ServersSpecLimits_Limits) ProtoMessage()    {}
func (*ServersSpecLimits_Limits) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{11, 0}
}
func (m *ServersSpecLimits_Limits) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecLimits_Limits) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecLimits_Limits.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecLimits_Limits) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecLimits_Limits.Merge(m, src)
}
func (m *ServersSpecLimits_Limits) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecLimits_Limits) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecLimits_Limits.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecLimits_Limits proto.InternalMessageInfo

func (m *ServersSpecLimits_Limits) GetMin() int32 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *ServersSpecLimits_Limits) GetMax() int32 {
	if m != nil {
		return m.Max
	}
	return 0
}

func (m *ServersSpecLimits_Limits) GetAllowedValues() []int32 {
	if m != nil {
		return m.AllowedValues
	}
	return nil
}

// Request arguments for CalculateDeploymentSize
type CalculateDeploymentSizeRequest struct {
	// Number of coordinators of the deployment
	Coordinators int32 `protobuf:"varint,1,opt,name=coordinators,proto3" json:"coordinators,omitempty"`
	// Amount of memory (in GB) to allocate for each coordinator.
	CoordinatorMemorySize int32 `protobuf:"varint,2,opt,name=coordinator_memory_size,json=coordinatorMemorySize,proto3" json:"coordinator_memory_size,omitempty"`
	// Number of dbservers of the deployment
	Dbservers int32 `protobuf:"varint,11,opt,name=dbservers,proto3" json:"dbservers,omitempty"`
	// Amount of memory (in GB) to allocate for each dbserver.
	DbserverMemorySize int32 `protobuf:"varint,12,opt,name=dbserver_memory_size,json=dbserverMemorySize,proto3" json:"dbserver_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for each dbserver.
	DbserverDiskSize     int32    `protobuf:"varint,13,opt,name=dbserver_disk_size,json=dbserverDiskSize,proto3" json:"dbserver_disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CalculateDeploymentSizeRequest) Reset()         { *m = CalculateDeploymentSizeRequest{} }
func (m *CalculateDeploymentSizeRequest) String() string { return proto.CompactTextString(m) }
func (*CalculateDeploymentSizeRequest) ProtoMessage()    {}
func (*CalculateDeploymentSizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{12}
}
func (m *CalculateDeploymentSizeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CalculateDeploymentSizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CalculateDeploymentSizeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CalculateDeploymentSizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CalculateDeploymentSizeRequest.Merge(m, src)
}
func (m *CalculateDeploymentSizeRequest) XXX_Size() int {
	return m.Size()
}
func (m *CalculateDeploymentSizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CalculateDeploymentSizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CalculateDeploymentSizeRequest proto.InternalMessageInfo

func (m *CalculateDeploymentSizeRequest) GetCoordinators() int32 {
	if m != nil {
		return m.Coordinators
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetCoordinatorMemorySize() int32 {
	if m != nil {
		return m.CoordinatorMemorySize
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetDbservers() int32 {
	if m != nil {
		return m.Dbservers
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetDbserverMemorySize() int32 {
	if m != nil {
		return m.DbserverMemorySize
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetDbserverDiskSize() int32 {
	if m != nil {
		return m.DbserverDiskSize
	}
	return 0
}

// Result of CalculateDeploymentSize
type DeploymentSize struct {
	// Number of agents
	Agents int32 `protobuf:"varint,1,opt,name=agents,proto3" json:"agents,omitempty"`
	// Amount of memory (in GB) to allocate for each agent.
	AgentMemorySize int32 `protobuf:"varint,2,opt,name=agent_memory_size,json=agentMemorySize,proto3" json:"agent_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for each agent.
	AgentDiskSize int32 `protobuf:"varint,3,opt,name=agent_disk_size,json=agentDiskSize,proto3" json:"agent_disk_size,omitempty"`
	// Total (combined) amount of memory (in GB) used by all servers (agents, coordinators & dbservers)
	TotalMemorySize int32 `protobuf:"varint,11,opt,name=total_memory_size,json=totalMemorySize,proto3" json:"total_memory_size,omitempty"`
	// Total (combined) amount of disk space (in GB) used by all servers (agents & dbservers)
	TotalDiskSize        int32    `protobuf:"varint,12,opt,name=total_disk_size,json=totalDiskSize,proto3" json:"total_disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentSize) Reset()         { *m = DeploymentSize{} }
func (m *DeploymentSize) String() string { return proto.CompactTextString(m) }
func (*DeploymentSize) ProtoMessage()    {}
func (*DeploymentSize) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{13}
}
func (m *DeploymentSize) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentSize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentSize.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentSize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentSize.Merge(m, src)
}
func (m *DeploymentSize) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentSize) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentSize.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentSize proto.InternalMessageInfo

func (m *DeploymentSize) GetAgents() int32 {
	if m != nil {
		return m.Agents
	}
	return 0
}

func (m *DeploymentSize) GetAgentMemorySize() int32 {
	if m != nil {
		return m.AgentMemorySize
	}
	return 0
}

func (m *DeploymentSize) GetAgentDiskSize() int32 {
	if m != nil {
		return m.AgentDiskSize
	}
	return 0
}

func (m *DeploymentSize) GetTotalMemorySize() int32 {
	if m != nil {
		return m.TotalMemorySize
	}
	return 0
}

func (m *DeploymentSize) GetTotalDiskSize() int32 {
	if m != nil {
		return m.TotalDiskSize
	}
	return 0
}

// DataVolumeInfo provides information about a data volume
type DataVolumeInfo struct {
	// The total number of bytes of the data volume.
	TotalBytes int64 `protobuf:"varint,1,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	// The number of bytes used on the data volume.
	UsedBytes int64 `protobuf:"varint,2,opt,name=used_bytes,json=usedBytes,proto3" json:"used_bytes,omitempty"`
	// The number of bytes available on the data volume.
	AvailableBytes int64 `protobuf:"varint,3,opt,name=available_bytes,json=availableBytes,proto3" json:"available_bytes,omitempty"`
	// When this info has been measused
	MeasuredAt           *types.Timestamp `protobuf:"bytes,10,opt,name=measured_at,json=measuredAt,proto3" json:"measured_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *DataVolumeInfo) Reset()         { *m = DataVolumeInfo{} }
func (m *DataVolumeInfo) String() string { return proto.CompactTextString(m) }
func (*DataVolumeInfo) ProtoMessage()    {}
func (*DataVolumeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{14}
}
func (m *DataVolumeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataVolumeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataVolumeInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataVolumeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataVolumeInfo.Merge(m, src)
}
func (m *DataVolumeInfo) XXX_Size() int {
	return m.Size()
}
func (m *DataVolumeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DataVolumeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DataVolumeInfo proto.InternalMessageInfo

func (m *DataVolumeInfo) GetTotalBytes() int64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

func (m *DataVolumeInfo) GetUsedBytes() int64 {
	if m != nil {
		return m.UsedBytes
	}
	return 0
}

func (m *DataVolumeInfo) GetAvailableBytes() int64 {
	if m != nil {
		return m.AvailableBytes
	}
	return 0
}

func (m *DataVolumeInfo) GetMeasuredAt() *types.Timestamp {
	if m != nil {
		return m.MeasuredAt
	}
	return nil
}

// Instructions for connecting a driver to a deployment
type ConnectDriverInstructions struct {
	// Per driver instructions for connecting to a deployment
	Drivers              []*ConnectDriverInstructions_DriverInstructions `protobuf:"bytes,1,rep,name=drivers,proto3" json:"drivers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *ConnectDriverInstructions) Reset()         { *m = ConnectDriverInstructions{} }
func (m *ConnectDriverInstructions) String() string { return proto.CompactTextString(m) }
func (*ConnectDriverInstructions) ProtoMessage()    {}
func (*ConnectDriverInstructions) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{15}
}
func (m *ConnectDriverInstructions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectDriverInstructions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectDriverInstructions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectDriverInstructions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectDriverInstructions.Merge(m, src)
}
func (m *ConnectDriverInstructions) XXX_Size() int {
	return m.Size()
}
func (m *ConnectDriverInstructions) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectDriverInstructions.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectDriverInstructions proto.InternalMessageInfo

func (m *ConnectDriverInstructions) GetDrivers() []*ConnectDriverInstructions_DriverInstructions {
	if m != nil {
		return m.Drivers
	}
	return nil
}

// Instructions for a specific driver
type ConnectDriverInstructions_DriverInstructions struct {
	// Human readable name of the driver.
	// E.g. "ArangoDB Go driver"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Lines of code
	Code []string `protobuf:"bytes,2,rep,name=code,proto3" json:"code,omitempty"`
	// Human readable remarks
	Remarks []string `protobuf:"bytes,3,rep,name=remarks,proto3" json:"remarks,omitempty"`
	// URL for getting more information on the driver.
	DriverUrl            string   `protobuf:"bytes,4,opt,name=driver_url,json=driverUrl,proto3" json:"driver_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectDriverInstructions_DriverInstructions) Reset() {
	*m = ConnectDriverInstructions_DriverInstructions{}
}
func (m *ConnectDriverInstructions_DriverInstructions) String() string {
	return proto.CompactTextString(m)
}
func (*ConnectDriverInstructions_DriverInstructions) ProtoMessage() {}
func (*ConnectDriverInstructions_DriverInstructions) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{15, 0}
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectDriverInstructions_DriverInstructions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectDriverInstructions_DriverInstructions.Merge(m, src)
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_Size() int {
	return m.Size()
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectDriverInstructions_DriverInstructions.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectDriverInstructions_DriverInstructions proto.InternalMessageInfo

func (m *ConnectDriverInstructions_DriverInstructions) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ConnectDriverInstructions_DriverInstructions) GetCode() []string {
	if m != nil {
		return m.Code
	}
	return nil
}

func (m *ConnectDriverInstructions_DriverInstructions) GetRemarks() []string {
	if m != nil {
		return m.Remarks
	}
	return nil
}

func (m *ConnectDriverInstructions_DriverInstructions) GetDriverUrl() string {
	if m != nil {
		return m.DriverUrl
	}
	return ""
}

func init() {
	proto.RegisterType((*Deployment)(nil), "arangodb.cloud.data.v1.Deployment")
	proto.RegisterType((*Deployment_CertificateSpec)(nil), "arangodb.cloud.data.v1.Deployment.CertificateSpec")
	proto.RegisterType((*Deployment_ServersSpec)(nil), "arangodb.cloud.data.v1.Deployment.ServersSpec")
	proto.RegisterType((*Deployment_ServerStatus)(nil), "arangodb.cloud.data.v1.Deployment.ServerStatus")
	proto.RegisterType((*Deployment_Status)(nil), "arangodb.cloud.data.v1.Deployment.Status")
	proto.RegisterType((*Deployment_BackupRestoreStatus)(nil), "arangodb.cloud.data.v1.Deployment.BackupRestoreStatus")
	proto.RegisterType((*Deployment_Expiration)(nil), "arangodb.cloud.data.v1.Deployment.Expiration")
	proto.RegisterType((*Deployment_BackupRestoreSpec)(nil), "arangodb.cloud.data.v1.Deployment.BackupRestoreSpec")
	proto.RegisterType((*ServersSpecPresetsRequest)(nil), "arangodb.cloud.data.v1.ServersSpecPresetsRequest")
	proto.RegisterType((*ServersSpecPreset)(nil), "arangodb.cloud.data.v1.ServersSpecPreset")
	proto.RegisterType((*ServersSpecPresetList)(nil), "arangodb.cloud.data.v1.ServersSpecPresetList")
	proto.RegisterType((*DeploymentCredentialsRequest)(nil), "arangodb.cloud.data.v1.DeploymentCredentialsRequest")
	proto.RegisterType((*DeploymentCredentials)(nil), "arangodb.cloud.data.v1.DeploymentCredentials")
	proto.RegisterType((*DeploymentList)(nil), "arangodb.cloud.data.v1.DeploymentList")
	proto.RegisterType((*Version)(nil), "arangodb.cloud.data.v1.Version")
	proto.RegisterType((*VersionList)(nil), "arangodb.cloud.data.v1.VersionList")
	proto.RegisterType((*ListVersionsRequest)(nil), "arangodb.cloud.data.v1.ListVersionsRequest")
	proto.RegisterType((*ServersSpecLimitsRequest)(nil), "arangodb.cloud.data.v1.ServersSpecLimitsRequest")
	proto.RegisterType((*ServersSpecLimits)(nil), "arangodb.cloud.data.v1.ServersSpecLimits")
	proto.RegisterType((*ServersSpecLimits_Limits)(nil), "arangodb.cloud.data.v1.ServersSpecLimits.Limits")
	proto.RegisterType((*CalculateDeploymentSizeRequest)(nil), "arangodb.cloud.data.v1.CalculateDeploymentSizeRequest")
	proto.RegisterType((*DeploymentSize)(nil), "arangodb.cloud.data.v1.DeploymentSize")
	proto.RegisterType((*DataVolumeInfo)(nil), "arangodb.cloud.data.v1.DataVolumeInfo")
	proto.RegisterType((*ConnectDriverInstructions)(nil), "arangodb.cloud.data.v1.ConnectDriverInstructions")
	proto.RegisterType((*ConnectDriverInstructions_DriverInstructions)(nil), "arangodb.cloud.data.v1.ConnectDriverInstructions.DriverInstructions")
}

func init() { proto.RegisterFile("data.proto", fileDescriptor_871986018790d2fd) }

var fileDescriptor_871986018790d2fd = []byte{
	// 2292 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0x4d, 0x8c, 0x1b, 0x49,
	0xf5, 0xff, 0xb7, 0x3d, 0x9f, 0xcf, 0x33, 0xf6, 0xa4, 0x92, 0x99, 0xf5, 0xfa, 0x9f, 0x4d, 0x46,
	0x1d, 0x25, 0x3b, 0x09, 0x8c, 0x9d, 0x19, 0x96, 0x28, 0x9b, 0x08, 0xc2, 0x7c, 0x84, 0x60, 0x69,
	0x49, 0xa2, 0x4e, 0x36, 0x8b, 0x10, 0xda, 0x56, 0xb9, 0xbb, 0xc6, 0xe9, 0x9d, 0x76, 0x77, 0xd3,
	0x55, 0x3d, 0xc9, 0x64, 0x88, 0x22, 0xa1, 0x3d, 0x23, 0x10, 0x1c, 0xf6, 0xc6, 0x15, 0x0e, 0x5c,
	0x41, 0x7c, 0x9c, 0x38, 0x01, 0xa7, 0x95, 0xb8, 0x70, 0x41, 0x42, 0x81, 0x3b, 0x12, 0xdc, 0x38,
	0xa1, 0x7a, 0x55, 0xdd, 0xee, 0x1e, 0xdb, 0x63, 0x27, 0xb0, 0xe2, 0xe6, 0x7a, 0xf5, 0xbe, 0xea,
	0xbd, 0x57, 0xef, 0xfd, 0xaa, 0x0d, 0xe0, 0x52, 0x41, 0x9b, 0x51, 0x1c, 0x8a, 0x90, 0xac, 0xd0,
	0x98, 0x06, 0xdd, 0xd0, 0xed, 0x34, 0x1d, 0x3f, 0x4c, 0xdc, 0x26, 0x6e, 0x1d, 0x6c, 0x34, 0x56,
	0x9c, 0xb0, 0xd7, 0x0b, 0x83, 0xd6, 0xc1, 0x46, 0x4b, 0xfd, 0x52, 0xfc, 0x8d, 0x9b, 0x5d, 0x4f,
	0x3c, 0x4e, 0x3a, 0x4d, 0x27, 0xec, 0xb5, 0xba, 0xa1, 0x4f, 0x83, 0x6e, 0x0b, 0x37, 0x3a, 0xc9,
	0x5e, 0x2b, 0x12, 0x87, 0x11, 0xe3, 0x2d, 0xe1, 0xf5, 0x18, 0x17, 0xb4, 0x17, 0xf5, 0x7f, 0x69,
	0xe1, 0xb3, 0xdd, 0x30, 0xec, 0xfa, 0xac, 0x45, 0x23, 0xaf, 0x45, 0x83, 0x20, 0x14, 0x54, 0x78,
	0x61, 0xc0, 0xd5, 0xae, 0xf9, 0xa7, 0x65, 0x80, 0x5d, 0x16, 0xf9, 0xe1, 0x61, 0x8f, 0x05, 0x82,
	0x54, 0xa1, 0xe4, 0xb9, 0x75, 0x63, 0xd5, 0x58, 0x9b, 0xb7, 0x4a, 0x9e, 0x4b, 0x96, 0xa0, 0x9c,
	0xc4, 0x7e, 0xbd, 0x84, 0x04, 0xf9, 0x93, 0x10, 0x98, 0x0a, 0x68, 0x8f, 0xd5, 0xcb, 0x48, 0xc2,
	0xdf, 0x64, 0x15, 0x2a, 0x2e, 0xe3, 0x4e, 0xec, 0x45, 0x52, 0x75, 0x7d, 0x0a, 0xb7, 0xf2, 0x24,
	0xf2, 0x16, 0x40, 0x14, 0x87, 0x1f, 0x31, 0x47, 0xd8, 0x9e, 0x5b, 0x9f, 0x46, 0x86, 0x79, 0x4d,
	0x69, 0xbb, 0xe4, 0xff, 0x61, 0x3e, 0x66, 0x5d, 0x2f, 0x0c, 0xe4, 0xee, 0x0c, 0xee, 0xce, 0x29,
	0x42, 0xdb, 0x25, 0xef, 0x02, 0x38, 0x31, 0xa3, 0x82, 0xb9, 0x36, 0x15, 0xf5, 0xd9, 0x55, 0x63,
	0xad, 0xb2, 0xd9, 0x68, 0xaa, 0x53, 0x35, 0xd3, 0x38, 0x34, 0x1f, 0xa6, 0xc7, 0xb6, 0xe6, 0x35,
	0xf7, 0x96, 0x90, 0xa2, 0x2e, 0xf3, 0x99, 0x16, 0x9d, 0x1b, 0x2f, 0xaa, 0xb9, 0xb7, 0x84, 0xf4,
	0xd8, 0xe3, 0xb6, 0x5e, 0xd7, 0xe7, 0x57, 0x8d, 0xb5, 0x39, 0x6b, 0xde, 0xe3, 0xbb, 0x8a, 0x40,
	0x2e, 0x41, 0x8d, 0x27, 0x51, 0x14, 0xc6, 0xc2, 0x8e, 0x7c, 0x8a, 0x7e, 0x03, 0xfa, 0xbd, 0xa8,
	0xc9, 0xf7, 0x7d, 0x2a, 0x9d, 0x37, 0x61, 0x31, 0x75, 0xbe, 0x73, 0x28, 0xb9, 0x2a, 0x2a, 0x38,
	0x9a, 0xb8, 0x7d, 0xd8, 0x76, 0x49, 0x1d, 0x66, 0x0f, 0x58, 0xcc, 0x65, 0xe8, 0x18, 0xee, 0xa6,
	0x4b, 0xf2, 0x08, 0x16, 0x1c, 0x16, 0x0b, 0x6f, 0xcf, 0x73, 0xa8, 0x60, 0xbc, 0xbe, 0x87, 0x27,
	0xd8, 0x6c, 0x0e, 0xaf, 0x9f, 0x66, 0x3f, 0x91, 0xcd, 0x9d, 0xbe, 0xd8, 0x83, 0x88, 0x39, 0x56,
	0x41, 0x0f, 0xf9, 0x1a, 0xcc, 0x72, 0x16, 0x4b, 0x2b, 0xf5, 0x2e, 0xaa, 0x6c, 0x4e, 0xa0, 0xf2,
	0x81, 0x92, 0x40, 0x75, 0xa9, 0x38, 0xb9, 0x08, 0x55, 0x2f, 0x7a, 0xf2, 0xd8, 0x13, 0xcc, 0xf7,
	0x38, 0x26, 0xd7, 0x53, 0x61, 0xc8, 0x51, 0xdb, 0x2e, 0xd9, 0x86, 0x19, 0x2e, 0xa8, 0x48, 0x78,
	0xfd, 0xf7, 0x06, 0x1a, 0xbc, 0x3c, 0x89, 0x41, 0x94, 0xb0, 0xb4, 0x24, 0xb9, 0x09, 0x53, 0xdc,
	0x7b, 0xc6, 0xea, 0x7f, 0x50, 0x1a, 0x2e, 0x8d, 0xd7, 0xf0, 0xc0, 0x7b, 0xc6, 0x2c, 0x14, 0x22,
	0x77, 0x01, 0xd8, 0xd3, 0xc8, 0x8b, 0xb1, 0xf8, 0xeb, 0x3f, 0x2b, 0xa1, 0x8a, 0xf5, 0x09, 0x9c,
	0xb8, 0x9d, 0x49, 0x59, 0x39, 0x0d, 0xe4, 0x5b, 0x50, 0xed, 0x50, 0x67, 0x3f, 0x89, 0xec, 0x98,
	0x71, 0x11, 0xc6, 0xac, 0xfe, 0x83, 0x32, 0xea, 0x7c, 0x67, 0x02, 0x9d, 0xdb, 0x28, 0x69, 0x29,
	0x41, 0x8c, 0xe7, 0x62, 0x27, 0x4f, 0x6a, 0xf4, 0xa0, 0x76, 0x2c, 0x81, 0xe4, 0x0a, 0x9c, 0x72,
	0xa8, 0x9d, 0xcb, 0xa2, 0x9d, 0x5d, 0xd4, 0x9a, 0x43, 0x73, 0xdc, 0x6d, 0x97, 0x34, 0xe1, 0x34,
	0xf5, 0x05, 0x8b, 0x03, 0xc9, 0xe6, 0x06, 0xdc, 0x96, 0xb7, 0x94, 0xd7, 0x4b, 0xab, 0xe5, 0xb5,
	0x79, 0xeb, 0x54, 0xb6, 0xb5, 0x1b, 0xf0, 0xbb, 0x72, 0xa3, 0xf1, 0x8b, 0x12, 0x54, 0x72, 0xd9,
	0x25, 0x26, 0x2c, 0x38, 0x61, 0x18, 0xbb, 0x5e, 0x40, 0x45, 0x18, 0x73, 0x34, 0x33, 0x6d, 0x15,
	0x68, 0xe4, 0x1a, 0xbc, 0x91, 0x5b, 0xdb, 0x3d, 0xd6, 0x0b, 0xe3, 0x43, 0x1b, 0x13, 0x54, 0x42,
	0xf6, 0xe5, 0xdc, 0xf6, 0xd7, 0x71, 0x57, 0xa6, 0x83, 0x5c, 0x86, 0xa5, 0xbc, 0x1c, 0x8d, 0xbb,
	0xbc, 0x5e, 0x46, 0xc7, 0x6a, 0x39, 0xfa, 0x56, 0xdc, 0xe5, 0xe4, 0x2c, 0xcc, 0xbb, 0x9d, 0xb4,
	0x4e, 0x2b, 0xa8, 0xb4, 0x4f, 0x20, 0x57, 0xe1, 0x4c, 0xba, 0x28, 0x58, 0x5f, 0x40, 0x46, 0x92,
	0xee, 0xe5, 0x4c, 0x7f, 0x1e, 0x32, 0xaa, 0xed, 0x7a, 0x7c, 0x5f, 0xf1, 0x2f, 0x22, 0xff, 0x52,
	0xba, 0xb3, 0xeb, 0xf1, 0x7d, 0xe4, 0xbe, 0x00, 0x8b, 0x19, 0x37, 0x7a, 0x59, 0x45, 0x2f, 0x17,
	0x52, 0xa2, 0x74, 0xb1, 0xf1, 0xe3, 0x32, 0x2c, 0xa8, 0xc8, 0xa9, 0x62, 0x1d, 0x68, 0xa0, 0x04,
	0xa6, 0x64, 0x83, 0xd6, 0x1d, 0x14, 0x7f, 0x1f, 0x6f, 0x97, 0xe5, 0xc1, 0x76, 0x59, 0x6c, 0x79,
	0x53, 0xaf, 0xd2, 0xf2, 0xce, 0xc0, 0x74, 0xcc, 0xa8, 0x7b, 0x88, 0x4d, 0x76, 0xce, 0x52, 0x0b,
	0x59, 0x3d, 0x3d, 0xd6, 0xeb, 0xb0, 0xd8, 0x0e, 0xf7, 0x6c, 0xc7, 0x4f, 0xb8, 0x60, 0x31, 0x36,
	0xda, 0x39, 0xab, 0xa6, 0x36, 0xee, 0xed, 0xed, 0x28, 0x32, 0x59, 0x81, 0x99, 0x3d, 0xea, 0xf9,
	0xcc, 0xc5, 0x5e, 0x3b, 0x67, 0xe9, 0x15, 0x69, 0xc0, 0x1c, 0x9a, 0xf1, 0x82, 0x2e, 0xb6, 0xd2,
	0x39, 0x2b, 0x5b, 0xcb, 0x63, 0x87, 0xfb, 0xba, 0x4b, 0x96, 0xc2, 0x7d, 0x99, 0xba, 0x24, 0xea,
	0xc6, 0xd4, 0x95, 0xcc, 0xa0, 0x9a, 0x67, 0x46, 0xc8, 0x37, 0xbc, 0x4a, 0xb1, 0xe1, 0xdd, 0x87,
	0x25, 0x79, 0x5f, 0xec, 0x83, 0xd0, 0x4f, 0x7a, 0xcc, 0xf6, 0x82, 0xbd, 0xb0, 0x7e, 0x66, 0xcc,
	0x75, 0xa7, 0x82, 0x3e, 0x42, 0xf6, 0x76, 0xb0, 0x17, 0x5a, 0x55, 0xb7, 0xb0, 0x6e, 0xfc, 0xb9,
	0x0c, 0x33, 0x3a, 0x37, 0x0d, 0x98, 0x63, 0x81, 0x1b, 0x85, 0x5e, 0x20, 0x74, 0x86, 0xb2, 0xf5,
	0xf1, 0x9c, 0x94, 0x06, 0x73, 0x52, 0x87, 0x59, 0x1d, 0x65, 0xcc, 0xd8, 0x9c, 0x95, 0x2e, 0xfb,
	0x21, 0x9f, 0xca, 0x87, 0xbc, 0x10, 0x82, 0xe9, 0xe3, 0x21, 0x78, 0x1b, 0x6a, 0xba, 0xb6, 0xf4,
	0xd1, 0x79, 0x7d, 0x06, 0xeb, 0xab, 0xaa, 0xc8, 0x8f, 0x34, 0x95, 0xb4, 0xfb, 0xad, 0x7a, 0x76,
	0xb5, 0xbc, 0x56, 0xd9, 0x6c, 0x4d, 0xdc, 0xaa, 0x75, 0xff, 0xcc, 0x7a, 0xf5, 0x0e, 0xd4, 0x3a,
	0x61, 0x28, 0xb8, 0x88, 0x69, 0x14, 0x4d, 0x3a, 0x12, 0xab, 0x79, 0x91, 0x2d, 0x21, 0x7b, 0x43,
	0x9e, 0xa2, 0x73, 0x5e, 0xa0, 0x91, 0x8f, 0x60, 0xb9, 0xd8, 0x1c, 0x6d, 0xdd, 0xfc, 0x5d, 0x34,
	0x77, 0xed, 0x95, 0x5b, 0xa4, 0x3a, 0xc8, 0xe9, 0xce, 0x20, 0xb1, 0xf1, 0x3d, 0x03, 0x4e, 0x0f,
	0x61, 0x96, 0xc9, 0x8e, 0xd9, 0x81, 0x87, 0x45, 0xa6, 0xfa, 0x57, 0xb6, 0x96, 0xa9, 0x51, 0x8e,
	0xe5, 0xaa, 0x33, 0x23, 0xc8, 0xfa, 0xd7, 0xee, 0xaa, 0xe2, 0x4c, 0xe7, 0xcf, 0x45, 0xa8, 0xca,
	0x9b, 0x90, 0xc4, 0xcc, 0x8e, 0x19, 0xe5, 0x61, 0x80, 0xad, 0x66, 0xde, 0x5a, 0xd4, 0x54, 0x0b,
	0x89, 0x8d, 0x7f, 0x1a, 0x00, 0xfd, 0xa1, 0x21, 0xaf, 0x32, 0x8e, 0x0d, 0xc6, 0x65, 0xbc, 0x8d,
	0xf1, 0x57, 0x59, 0x73, 0x6f, 0x09, 0xe9, 0x88, 0x36, 0xa4, 0xca, 0x51, 0xaf, 0xc8, 0x23, 0x68,
	0xf8, 0x94, 0x0b, 0xfb, 0x09, 0x8d, 0x03, 0x2f, 0xe8, 0xda, 0xac, 0x47, 0x3d, 0xdf, 0xe6, 0x2c,
	0xc0, 0x94, 0x96, 0xc7, 0x9a, 0x58, 0x91, 0xd2, 0x1f, 0x28, 0xe1, 0xdb, 0x52, 0xf6, 0x01, 0x0b,
	0x64, 0x6a, 0x6f, 0x8c, 0xd6, 0x2b, 0xc2, 0xfa, 0x14, 0x96, 0xe7, 0x50, 0xd9, 0x87, 0x61, 0xe3,
	0xfb, 0x06, 0x9c, 0x1a, 0x18, 0x6b, 0x27, 0x26, 0x61, 0x1b, 0x6a, 0x68, 0x2d, 0x89, 0xdc, 0xb4,
	0xd1, 0x95, 0xc6, 0xba, 0xbe, 0x28, 0x45, 0xde, 0x57, 0x12, 0x5b, 0x42, 0xe2, 0x46, 0x5d, 0x68,
	0x19, 0xfe, 0x9a, 0x53, 0x84, 0xb6, 0x6b, 0x7e, 0x00, 0x6f, 0xe6, 0x86, 0xda, 0xfd, 0x98, 0x71,
	0x26, 0xb8, 0xc5, 0xbe, 0x9d, 0x30, 0x2e, 0x8e, 0x01, 0x52, 0xe3, 0x44, 0x40, 0x5a, 0x2a, 0x02,
	0x52, 0x53, 0x9e, 0x75, 0x40, 0x73, 0x06, 0x8c, 0x8d, 0x1c, 0x30, 0x4e, 0x41, 0xe4, 0x1e, 0x4d,
	0x7c, 0x75, 0x3c, 0x0d, 0x22, 0x91, 0x90, 0x87, 0x61, 0xe5, 0xff, 0x08, 0x86, 0x99, 0xdf, 0x80,
	0xe5, 0x01, 0x8f, 0xde, 0xf3, 0xb8, 0x20, 0xb7, 0x60, 0xda, 0x13, 0xac, 0x27, 0x67, 0x78, 0xf9,
	0x24, 0xd8, 0x35, 0x20, 0x6d, 0x29, 0x39, 0x73, 0x07, 0xce, 0xf6, 0x8d, 0xef, 0xc4, 0xcc, 0x65,
	0x81, 0xf0, 0xa8, 0x9f, 0x05, 0x52, 0x8e, 0xc9, 0x6c, 0xbf, 0x1f, 0xcb, 0x85, 0x3e, 0xb1, 0xed,
	0x9a, 0xf7, 0x60, 0x79, 0xa8, 0x12, 0x59, 0x20, 0x09, 0x97, 0x68, 0x24, 0x0b, 0x5c, 0xb6, 0x96,
	0x7b, 0x11, 0xe5, 0xfc, 0x49, 0x18, 0x67, 0x29, 0x48, 0xd7, 0xe6, 0xc7, 0x06, 0x54, 0xfb, 0x1a,
	0xf1, 0xa4, 0xd7, 0x8b, 0x27, 0x35, 0xc7, 0x87, 0x52, 0x1f, 0x91, 0x5c, 0x87, 0x99, 0x4e, 0xe2,
	0x76, 0x59, 0x5a, 0x80, 0xab, 0xc7, 0x45, 0xf5, 0x63, 0xec, 0x60, 0xa3, 0xb9, 0x8d, 0x7c, 0x96,
	0xe6, 0x37, 0x2f, 0xc0, 0xac, 0x6e, 0xd4, 0xf9, 0x99, 0x66, 0x14, 0x66, 0x9a, 0xb9, 0x0b, 0x15,
	0xcd, 0x84, 0x7e, 0x7e, 0xb1, 0xe8, 0xe7, 0xf9, 0x51, 0x7e, 0x6a, 0x99, 0x34, 0x0f, 0x3f, 0x31,
	0xe0, 0xb4, 0x94, 0x4f, 0x07, 0x43, 0x1a, 0xff, 0x5b, 0x30, 0x1b, 0xe2, 0x80, 0xe2, 0xba, 0xb9,
	0x5c, 0x1c, 0xed, 0xbd, 0x94, 0xbf, 0xa7, 0x98, 0xad, 0x54, 0x4a, 0x4e, 0xa2, 0x30, 0xee, 0xd2,
	0xc0, 0x7b, 0x86, 0x0d, 0xab, 0x5f, 0xf0, 0xd5, 0x3c, 0xb9, 0xed, 0x4a, 0x46, 0x27, 0x89, 0x63,
	0x99, 0xe6, 0xf4, 0xa4, 0x0a, 0xba, 0x54, 0x35, 0x59, 0xbb, 0x66, 0x1e, 0x41, 0x3d, 0x57, 0x4e,
	0xef, 0x79, 0x3d, 0xef, 0xbf, 0x72, 0xef, 0x06, 0x4b, 0xad, 0x3c, 0xa4, 0xd4, 0x7e, 0x33, 0x55,
	0xb8, 0x9c, 0xca, 0x3a, 0x79, 0x38, 0x04, 0xd1, 0x56, 0x36, 0xaf, 0x4e, 0x70, 0x1b, 0x94, 0x82,
	0xa6, 0x3e, 0x45, 0x11, 0x03, 0x3f, 0x3e, 0x19, 0x03, 0xbf, 0x8e, 0x81, 0x11, 0xa8, 0xf9, 0xee,
	0x71, 0x28, 0xfc, 0x3a, 0xba, 0x73, 0xe0, 0xb9, 0x73, 0x02, 0x78, 0x7e, 0x1d, 0xd5, 0xc3, 0xe0,
	0xf6, 0x87, 0x23, 0xe1, 0xf6, 0xeb, 0x58, 0x18, 0x00, 0xe8, 0x8d, 0x07, 0x30, 0xa3, 0xb3, 0xbb,
	0x04, 0xe5, 0x9e, 0x97, 0x4e, 0x18, 0xf9, 0x13, 0x29, 0xf4, 0xa9, 0x7e, 0x89, 0xc8, 0x9f, 0x72,
	0x7a, 0x53, 0xdf, 0x0f, 0x9f, 0x30, 0xd7, 0x3e, 0xa0, 0x7e, 0xc2, 0xd4, 0xab, 0x63, 0xda, 0x5a,
	0xd4, 0xd4, 0x47, 0x48, 0x34, 0xff, 0x65, 0xc0, 0xb9, 0x1d, 0xea, 0x3b, 0x89, 0x2f, 0x1f, 0x48,
	0xc5, 0x97, 0xa4, 0x2e, 0xe1, 0xcf, 0xf2, 0x75, 0xf4, 0x3f, 0x7d, 0xf2, 0x98, 0x9f, 0x16, 0xba,
	0x2a, 0x2a, 0x58, 0x81, 0x19, 0xda, 0x65, 0x81, 0x48, 0x8f, 0xa9, 0x57, 0xf2, 0x41, 0x81, 0xbf,
	0x86, 0x1c, 0xad, 0x86, 0x1b, 0x39, 0x27, 0x2e, 0x81, 0x22, 0xe5, 0x3c, 0x28, 0x23, 0xe7, 0x22,
	0x92, 0xb3, 0x17, 0xd7, 0x15, 0x38, 0x25, 0x42, 0x41, 0xfd, 0x82, 0x4e, 0x15, 0x84, 0x1a, 0x6e,
	0x14, 0x75, 0x2a, 0xde, 0xbe, 0x4e, 0x15, 0x85, 0x45, 0x24, 0x67, 0x47, 0xfa, 0xb9, 0x3c, 0x52,
	0xe1, 0x45, 0x40, 0xce, 0x43, 0x45, 0x89, 0x76, 0x0e, 0x05, 0x53, 0xe7, 0x2a, 0x5b, 0x80, 0xa4,
	0x6d, 0x49, 0x91, 0x3d, 0x2a, 0xe1, 0xf8, 0xc1, 0x46, 0xe0, 0xab, 0x59, 0xee, 0xcf, 0x4b, 0x8a,
	0xda, 0x7e, 0x1b, 0x6a, 0xf4, 0x80, 0x7a, 0x3e, 0xed, 0xf8, 0x4c, 0xf3, 0x94, 0x91, 0xa7, 0x9a,
	0x91, 0x15, 0xe3, 0x4d, 0xa8, 0xf4, 0x18, 0xe5, 0x49, 0xac, 0xd0, 0x0d, 0x8c, 0x45, 0x37, 0x90,
	0xb2, 0x6f, 0x09, 0xf3, 0x1f, 0x06, 0xbc, 0xb9, 0x13, 0x06, 0x01, 0x73, 0xc4, 0x6e, 0xec, 0x1d,
	0xb0, 0xb8, 0x1d, 0x70, 0x11, 0x27, 0x8e, 0x6a, 0xda, 0x1f, 0xc2, 0xac, 0x8b, 0xd4, 0x74, 0x8c,
	0xec, 0x8e, 0xba, 0x50, 0x23, 0x75, 0x34, 0x07, 0x49, 0x56, 0xaa, 0xb4, 0x91, 0x00, 0x19, 0x62,
	0x75, 0x18, 0xc4, 0x21, 0x30, 0xe5, 0x84, 0x2e, 0xd3, 0x1f, 0x17, 0xf0, 0xb7, 0x9c, 0x85, 0x31,
	0xeb, 0xd1, 0x78, 0x3f, 0x7d, 0xda, 0xa7, 0x4b, 0x19, 0x5a, 0x65, 0xc2, 0x4e, 0x62, 0x5f, 0x7f,
	0x28, 0x9c, 0x57, 0x94, 0xf7, 0x63, 0x7f, 0xf3, 0xef, 0x55, 0xa8, 0xc8, 0x6c, 0xc9, 0x2e, 0xe0,
	0x39, 0x8c, 0x7c, 0x62, 0x40, 0x4d, 0x0e, 0xad, 0x7e, 0x51, 0x72, 0x32, 0xd9, 0x7c, 0x6b, 0x4c,
	0xf0, 0x79, 0x48, 0xb2, 0x9b, 0xd7, 0xbe, 0xfb, 0xc7, 0xbf, 0xfd, 0xb0, 0x74, 0x95, 0x34, 0xf1,
	0x03, 0xa9, 0x64, 0x6a, 0x1d, 0x6c, 0xb4, 0xf4, 0x44, 0xe2, 0xad, 0x23, 0x27, 0x0c, 0x04, 0x7b,
	0x2a, 0xc7, 0xcd, 0xf3, 0x96, 0x9b, 0x73, 0xe3, 0x05, 0x2c, 0xde, 0x61, 0x39, 0xc7, 0xc8, 0x85,
	0xd1, 0x7e, 0xb5, 0x77, 0x53, 0xaf, 0x26, 0x40, 0x25, 0xe6, 0x45, 0xf4, 0xe8, 0x3c, 0x79, 0xab,
	0xe0, 0x51, 0xce, 0x76, 0xeb, 0xc8, 0x73, 0x9f, 0x93, 0x1f, 0x19, 0xb0, 0xb4, 0x83, 0x2f, 0xd0,
	0x9c, 0x13, 0x13, 0xe8, 0x9f, 0xc8, 0x87, 0xeb, 0xe8, 0xc3, 0xa6, 0xb9, 0x3e, 0x2c, 0x2a, 0xad,
	0xa3, 0xfe, 0x08, 0x2f, 0x04, 0xe5, 0x86, 0x71, 0x85, 0x7c, 0x6c, 0xc0, 0x92, 0x02, 0xe8, 0x9f,
	0x81, 0x5b, 0x6b, 0xe8, 0x96, 0xb9, 0x79, 0x72, 0x68, 0xa4, 0x1b, 0x2f, 0x60, 0x49, 0x7d, 0xaa,
	0x7d, 0xd5, 0x0c, 0x9d, 0x1f, 0xcd, 0x74, 0xbb, 0x17, 0x89, 0xc3, 0x34, 0x3d, 0x57, 0xc6, 0xa4,
	0xe7, 0xd7, 0x06, 0xd4, 0x0b, 0x05, 0x92, 0x87, 0xbd, 0x13, 0x7c, 0x24, 0x1c, 0x84, 0xda, 0x8d,
	0xf5, 0x57, 0x92, 0x32, 0x6f, 0xa0, 0xa3, 0xef, 0x90, 0xcd, 0x11, 0x8e, 0x3a, 0x7d, 0xde, 0xd6,
	0x51, 0x01, 0x58, 0x3d, 0x27, 0x2f, 0x60, 0x21, 0x0f, 0x36, 0xc9, 0xe7, 0x46, 0x99, 0x1e, 0x02,
	0x49, 0x1b, 0x17, 0xc6, 0x40, 0x5a, 0xbc, 0x77, 0x6f, 0xa1, 0x77, 0x6f, 0x90, 0xe5, 0x82, 0x77,
	0xe9, 0xc7, 0x10, 0xf2, 0x1d, 0x38, 0x85, 0xd1, 0xc3, 0x87, 0x52, 0x8a, 0xb1, 0xc7, 0xe5, 0xa6,
	0x31, 0x0e, 0x4c, 0x8f, 0xb8, 0x5b, 0xa9, 0xd5, 0x96, 0x7e, 0xa9, 0x91, 0x5f, 0x19, 0x70, 0xe6,
	0x0e, 0x13, 0x83, 0x38, 0x72, 0x72, 0xdc, 0x92, 0x06, 0xe3, 0xf2, 0xc4, 0x12, 0xe6, 0x6d, 0x74,
	0xee, 0x16, 0xf9, 0xd2, 0x88, 0x56, 0x94, 0xbf, 0x75, 0x0a, 0x14, 0xf3, 0xd6, 0x51, 0x06, 0x97,
	0x9f, 0xb7, 0x7c, 0xe5, 0xe3, 0x6f, 0x0d, 0x58, 0x91, 0x21, 0x1e, 0x7c, 0xfc, 0x92, 0x8d, 0x89,
	0x9f, 0x7f, 0xe3, 0x8b, 0x6e, 0xe8, 0x7b, 0xd3, 0xfc, 0x2a, 0x9e, 0xe1, 0x2b, 0xe4, 0xcb, 0xaf,
	0x79, 0x86, 0x48, 0x7b, 0xfa, 0x53, 0x03, 0xde, 0x18, 0x81, 0xc3, 0xc8, 0xc8, 0xef, 0x47, 0x27,
	0x03, 0xb7, 0xc6, 0x84, 0xff, 0x18, 0x98, 0x4d, 0x3c, 0xc3, 0x1a, 0xb9, 0x34, 0xe2, 0xe2, 0xac,
	0x4b, 0xb8, 0xd1, 0x72, 0x52, 0x63, 0xe4, 0x97, 0x06, 0x9c, 0xbd, 0xc3, 0xc4, 0xe8, 0x69, 0x3d,
	0x51, 0xe3, 0xd9, 0x78, 0xe5, 0x09, 0x6e, 0x6e, 0xa1, 0xa3, 0x37, 0xc9, 0xbb, 0x27, 0xb6, 0xa2,
	0x96, 0xa3, 0x14, 0xac, 0xab, 0x39, 0xbb, 0xee, 0xe5, 0x54, 0x6c, 0xdf, 0xf8, 0xdd, 0xcb, 0x73,
	0xc6, 0xa7, 0x2f, 0xcf, 0x19, 0x7f, 0x79, 0x79, 0xce, 0xf8, 0xe4, 0xaf, 0xe7, 0xfe, 0xef, 0x9b,
	0x6b, 0xb9, 0x3f, 0x1b, 0x53, 0x8f, 0xd6, 0x7b, 0x34, 0xa0, 0x5d, 0xe6, 0x4a, 0x3b, 0x3c, 0x35,
	0xd4, 0x99, 0x41, 0x08, 0xf3, 0x85, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0x42, 0x34, 0xfa, 0x87,
	0xdb, 0x1c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataServiceClient is the client API for DataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataServiceClient interface {
	// Fetch all deployments in the project identified by the given context ID.
	// Required permissions:
	// - data.deployment.list on the project identified by the given context ID
	ListDeployments(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*DeploymentList, error)
	// Fetch a deployment by its id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetDeployment(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Deployment, error)
	// Create a new deployment
	// Required permissions:
	// - data.deployment.create on the project that owns the deployment
	// Note that deployment.status & deployment.expiration are ignored
	// in this request.
	CreateDeployment(ctx context.Context, in *Deployment, opts ...grpc.CallOption) (*Deployment, error)
	// Update a deployment
	// Required permissions:
	// - data.deployment.update on the deployment
	// Note that deployment.status & deployment.expiration are ignored
	// in this request.
	UpdateDeployment(ctx context.Context, in *Deployment, opts ...grpc.CallOption) (*Deployment, error)
	// Delete a deployment
	// Note that deployments are initially only marked for deletion.
	// Once all their resources are removed the deployment itself is removed.
	// Required permissions:
	// - data.deployment.delete on the deployment
	DeleteDeployment(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch credentials for accessing deployment by its id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	// - data.deploymentcredentials.get on the deployment identified by the given ID
	GetDeploymentCredentials(ctx context.Context, in *DeploymentCredentialsRequest, opts ...grpc.CallOption) (*DeploymentCredentials, error)
	// Fetch all ArangoDB versions that are available for deployments.
	// Required permissions:
	// - None
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*VersionList, error)
	// Fetch the default ArangoDB version for new deployment.
	// Required permissions:
	// - None
	GetDefaultVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*Version, error)
	// Fetch the limits for server specifications for deployments
	// owned by the given projected, created in the given region.
	// Required permissions:
	// - data.limits.get on the requested project
	// - data.deployment.get on the specified deployment (if deployment_id is set)
	GetServersSpecLimits(ctx context.Context, in *ServersSpecLimitsRequest, opts ...grpc.CallOption) (*ServersSpecLimits, error)
	// Fetch the presets for server specifications for deployments
	// owned by the given projected, created in the given region.
	// Required permissions:
	// - data.presets.list on the requested project
	ListServersSpecPresets(ctx context.Context, in *ServersSpecPresetsRequest, opts ...grpc.CallOption) (*ServersSpecPresetList, error)
	// Calculate the total size of a deployment with given arguments.
	// Required permissions:
	// - none
	CalculateDeploymentSize(ctx context.Context, in *CalculateDeploymentSizeRequest, opts ...grpc.CallOption) (*DeploymentSize, error)
	// Fetch instructions for connecting drivers to the deployment identified by the given id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetConnectDriverInstructions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ConnectDriverInstructions, error)
}

type dataServiceClient struct {
	cc *grpc.ClientConn
}

func NewDataServiceClient(cc *grpc.ClientConn) DataServiceClient {
	return &dataServiceClient{cc}
}

func (c *dataServiceClient) ListDeployments(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*DeploymentList, error) {
	out := new(DeploymentList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetDeployment(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) CreateDeployment(ctx context.Context, in *Deployment, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/CreateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) UpdateDeployment(ctx context.Context, in *Deployment, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/UpdateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) DeleteDeployment(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/DeleteDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetDeploymentCredentials(ctx context.Context, in *DeploymentCredentialsRequest, opts ...grpc.CallOption) (*DeploymentCredentials, error) {
	out := new(DeploymentCredentials)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetDeploymentCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*VersionList, error) {
	out := new(VersionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/ListVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetDefaultVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetDefaultVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetServersSpecLimits(ctx context.Context, in *ServersSpecLimitsRequest, opts ...grpc.CallOption) (*ServersSpecLimits, error) {
	out := new(ServersSpecLimits)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetServersSpecLimits", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) ListServersSpecPresets(ctx context.Context, in *ServersSpecPresetsRequest, opts ...grpc.CallOption) (*ServersSpecPresetList, error) {
	out := new(ServersSpecPresetList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/ListServersSpecPresets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) CalculateDeploymentSize(ctx context.Context, in *CalculateDeploymentSizeRequest, opts ...grpc.CallOption) (*DeploymentSize, error) {
	out := new(DeploymentSize)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/CalculateDeploymentSize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetConnectDriverInstructions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ConnectDriverInstructions, error) {
	out := new(ConnectDriverInstructions)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetConnectDriverInstructions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataServiceServer is the server API for DataService service.
type DataServiceServer interface {
	// Fetch all deployments in the project identified by the given context ID.
	// Required permissions:
	// - data.deployment.list on the project identified by the given context ID
	ListDeployments(context.Context, *v1.ListOptions) (*DeploymentList, error)
	// Fetch a deployment by its id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetDeployment(context.Context, *v1.IDOptions) (*Deployment, error)
	// Create a new deployment
	// Required permissions:
	// - data.deployment.create on the project that owns the deployment
	// Note that deployment.status & deployment.expiration are ignored
	// in this request.
	CreateDeployment(context.Context, *Deployment) (*Deployment, error)
	// Update a deployment
	// Required permissions:
	// - data.deployment.update on the deployment
	// Note that deployment.status & deployment.expiration are ignored
	// in this request.
	UpdateDeployment(context.Context, *Deployment) (*Deployment, error)
	// Delete a deployment
	// Note that deployments are initially only marked for deletion.
	// Once all their resources are removed the deployment itself is removed.
	// Required permissions:
	// - data.deployment.delete on the deployment
	DeleteDeployment(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch credentials for accessing deployment by its id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	// - data.deploymentcredentials.get on the deployment identified by the given ID
	GetDeploymentCredentials(context.Context, *DeploymentCredentialsRequest) (*DeploymentCredentials, error)
	// Fetch all ArangoDB versions that are available for deployments.
	// Required permissions:
	// - None
	ListVersions(context.Context, *ListVersionsRequest) (*VersionList, error)
	// Fetch the default ArangoDB version for new deployment.
	// Required permissions:
	// - None
	GetDefaultVersion(context.Context, *v1.Empty) (*Version, error)
	// Fetch the limits for server specifications for deployments
	// owned by the given projected, created in the given region.
	// Required permissions:
	// - data.limits.get on the requested project
	// - data.deployment.get on the specified deployment (if deployment_id is set)
	GetServersSpecLimits(context.Context, *ServersSpecLimitsRequest) (*ServersSpecLimits, error)
	// Fetch the presets for server specifications for deployments
	// owned by the given projected, created in the given region.
	// Required permissions:
	// - data.presets.list on the requested project
	ListServersSpecPresets(context.Context, *ServersSpecPresetsRequest) (*ServersSpecPresetList, error)
	// Calculate the total size of a deployment with given arguments.
	// Required permissions:
	// - none
	CalculateDeploymentSize(context.Context, *CalculateDeploymentSizeRequest) (*DeploymentSize, error)
	// Fetch instructions for connecting drivers to the deployment identified by the given id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetConnectDriverInstructions(context.Context, *v1.IDOptions) (*ConnectDriverInstructions, error)
}

// UnimplementedDataServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDataServiceServer struct {
}

func (*UnimplementedDataServiceServer) ListDeployments(ctx context.Context, req *v1.ListOptions) (*DeploymentList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (*UnimplementedDataServiceServer) GetDeployment(ctx context.Context, req *v1.IDOptions) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (*UnimplementedDataServiceServer) CreateDeployment(ctx context.Context, req *Deployment) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeployment not implemented")
}
func (*UnimplementedDataServiceServer) UpdateDeployment(ctx context.Context, req *Deployment) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeployment not implemented")
}
func (*UnimplementedDataServiceServer) DeleteDeployment(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeployment not implemented")
}
func (*UnimplementedDataServiceServer) GetDeploymentCredentials(ctx context.Context, req *DeploymentCredentialsRequest) (*DeploymentCredentials, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeploymentCredentials not implemented")
}
func (*UnimplementedDataServiceServer) ListVersions(ctx context.Context, req *ListVersionsRequest) (*VersionList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (*UnimplementedDataServiceServer) GetDefaultVersion(ctx context.Context, req *v1.Empty) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultVersion not implemented")
}
func (*UnimplementedDataServiceServer) GetServersSpecLimits(ctx context.Context, req *ServersSpecLimitsRequest) (*ServersSpecLimits, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServersSpecLimits not implemented")
}
func (*UnimplementedDataServiceServer) ListServersSpecPresets(ctx context.Context, req *ServersSpecPresetsRequest) (*ServersSpecPresetList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServersSpecPresets not implemented")
}
func (*UnimplementedDataServiceServer) CalculateDeploymentSize(ctx context.Context, req *CalculateDeploymentSizeRequest) (*DeploymentSize, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateDeploymentSize not implemented")
}
func (*UnimplementedDataServiceServer) GetConnectDriverInstructions(ctx context.Context, req *v1.IDOptions) (*ConnectDriverInstructions, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectDriverInstructions not implemented")
}

func RegisterDataServiceServer(s *grpc.Server, srv DataServiceServer) {
	s.RegisterService(&_DataService_serviceDesc, srv)
}

func _DataService_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).ListDeployments(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetDeployment(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_CreateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Deployment)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).CreateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/CreateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).CreateDeployment(ctx, req.(*Deployment))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_UpdateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Deployment)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).UpdateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/UpdateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).UpdateDeployment(ctx, req.(*Deployment))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_DeleteDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).DeleteDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/DeleteDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).DeleteDeployment(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetDeploymentCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeploymentCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetDeploymentCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetDeploymentCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetDeploymentCredentials(ctx, req.(*DeploymentCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetDefaultVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetDefaultVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetDefaultVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetDefaultVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetServersSpecLimits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ServersSpecLimitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetServersSpecLimits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetServersSpecLimits",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetServersSpecLimits(ctx, req.(*ServersSpecLimitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_ListServersSpecPresets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ServersSpecPresetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).ListServersSpecPresets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/ListServersSpecPresets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).ListServersSpecPresets(ctx, req.(*ServersSpecPresetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_CalculateDeploymentSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateDeploymentSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).CalculateDeploymentSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/CalculateDeploymentSize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).CalculateDeploymentSize(ctx, req.(*CalculateDeploymentSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetConnectDriverInstructions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetConnectDriverInstructions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetConnectDriverInstructions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetConnectDriverInstructions(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.data.v1.DataService",
	HandlerType: (*DataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDeployments",
			Handler:    _DataService_ListDeployments_Handler,
		},
		{
			MethodName: "GetDeployment",
			Handler:    _DataService_GetDeployment_Handler,
		},
		{
			MethodName: "CreateDeployment",
			Handler:    _DataService_CreateDeployment_Handler,
		},
		{
			MethodName: "UpdateDeployment",
			Handler:    _DataService_UpdateDeployment_Handler,
		},
		{
			MethodName: "DeleteDeployment",
			Handler:    _DataService_DeleteDeployment_Handler,
		},
		{
			MethodName: "GetDeploymentCredentials",
			Handler:    _DataService_GetDeploymentCredentials_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _DataService_ListVersions_Handler,
		},
		{
			MethodName: "GetDefaultVersion",
			Handler:    _DataService_GetDefaultVersion_Handler,
		},
		{
			MethodName: "GetServersSpecLimits",
			Handler:    _DataService_GetServersSpecLimits_Handler,
		},
		{
			MethodName: "ListServersSpecPresets",
			Handler:    _DataService_ListServersSpecPresets_Handler,
		},
		{
			MethodName: "CalculateDeploymentSize",
			Handler:    _DataService_CalculateDeploymentSize_Handler,
		},
		{
			MethodName: "GetConnectDriverInstructions",
			Handler:    _DataService_GetConnectDriverInstructions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "data.proto",
}

func (m *Deployment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BackupRestore != nil {
		{
			size, err := m.BackupRestore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x8a
	}
	if m.Expiration != nil {
		{
			size, err := m.Expiration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xea
	}
	if m.Size_ != nil {
		{
			size, err := m.Size_.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd2
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xca
	}
	if len(m.IpwhitelistId) > 0 {
		i -= len(m.IpwhitelistId)
		copy(dAtA[i:], m.IpwhitelistId)
		i = encodeVarintData(dAtA, i, uint64(len(m.IpwhitelistId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xca
	}
	if m.Servers != nil {
		{
			size, err := m.Servers.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xba
	}
	if m.Certificates != nil {
		{
			size, err := m.Certificates.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb2
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintData(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintData(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.SupportPlanId) > 0 {
		i -= len(m.SupportPlanId)
		copy(dAtA[i:], m.SupportPlanId)
		i = encodeVarintData(dAtA, i, uint64(len(m.SupportPlanId)))
		i--
		dAtA[i] = 0x52
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintData(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintData(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintData(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_CertificateSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_CertificateSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_CertificateSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AlternateDnsNames) > 0 {
		for iNdEx := len(m.AlternateDnsNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AlternateDnsNames[iNdEx])
			copy(dAtA[i:], m.AlternateDnsNames[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.AlternateDnsNames[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.CaCertificateId) > 0 {
		i -= len(m.CaCertificateId)
		copy(dAtA[i:], m.CaCertificateId)
		i = encodeVarintData(dAtA, i, uint64(len(m.CaCertificateId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_ServersSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_ServersSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_ServersSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DbserverArgs) > 0 {
		for iNdEx := len(m.DbserverArgs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DbserverArgs[iNdEx])
			copy(dAtA[i:], m.DbserverArgs[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.DbserverArgs[iNdEx])))
			i--
			dAtA[i] = 0x72
		}
	}
	if m.DbserverDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverDiskSize))
		i--
		dAtA[i] = 0x68
	}
	if m.DbserverMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverMemorySize))
		i--
		dAtA[i] = 0x60
	}
	if m.Dbservers != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Dbservers))
		i--
		dAtA[i] = 0x58
	}
	if len(m.CoordinatorArgs) > 0 {
		for iNdEx := len(m.CoordinatorArgs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.CoordinatorArgs[iNdEx])
			copy(dAtA[i:], m.CoordinatorArgs[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.CoordinatorArgs[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.CoordinatorMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.CoordinatorMemorySize))
		i--
		dAtA[i] = 0x10
	}
	if m.Coordinators != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Coordinators))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_ServerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_ServerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_ServerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DataVolumeInfo != nil {
		{
			size, err := m.DataVolumeInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintData(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Upgrading {
		i--
		if m.Upgrading {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.Ok {
		i--
		if m.Ok {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.Creating {
		i--
		if m.Creating {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.Failed {
		i--
		if m.Failed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.MemberOfCluster {
		i--
		if m.MemberOfCluster {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.Ready {
		i--
		if m.Ready {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintData(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintData(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintData(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_Status) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_Status) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BackupRestoreStatus != nil {
		{
			size, err := m.BackupRestoreStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if m.Bootstrapped {
		i--
		if m.Bootstrapped {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.BootstrappedAt != nil {
		{
			size, err := m.BootstrappedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Servers) > 0 {
		for iNdEx := len(m.Servers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Servers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.ServerVersions) > 0 {
		for iNdEx := len(m.ServerVersions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ServerVersions[iNdEx])
			copy(dAtA[i:], m.ServerVersions[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.ServerVersions[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Upgrading {
		i--
		if m.Upgrading {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Ready {
		i--
		if m.Ready {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Created {
		i--
		if m.Created {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintData(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintData(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_BackupRestoreStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_BackupRestoreStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_BackupRestoreStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.FailureReason) > 0 {
		i -= len(m.FailureReason)
		copy(dAtA[i:], m.FailureReason)
		i = encodeVarintData(dAtA, i, uint64(len(m.FailureReason)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintData(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Restoring {
		i--
		if m.Restoring {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.Revision != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Revision))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_Expiration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_Expiration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_Expiration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LastWarningEmailSendTo) > 0 {
		for iNdEx := len(m.LastWarningEmailSendTo) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LastWarningEmailSendTo[iNdEx])
			copy(dAtA[i:], m.LastWarningEmailSendTo[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.LastWarningEmailSendTo[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.LastWarningEmailSendAt != nil {
		{
			size, err := m.LastWarningEmailSendAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintData(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x12
	}
	if m.ExpiresAt != nil {
		{
			size, err := m.ExpiresAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_BackupRestoreSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_BackupRestoreSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_BackupRestoreSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.BackupId) > 0 {
		i -= len(m.BackupId)
		copy(dAtA[i:], m.BackupId)
		i = encodeVarintData(dAtA, i, uint64(len(m.BackupId)))
		i--
		dAtA[i] = 0x52
	}
	if m.LastUpdatedAt != nil {
		{
			size, err := m.LastUpdatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Revision != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Revision))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecPresetsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecPresetsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecPresetsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecPreset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecPreset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecPreset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Servers != nil {
		{
			size, err := m.Servers.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecPresetList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecPresetList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecPresetList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentCredentialsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentCredentialsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentCredentialsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintData(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentCredentials) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentCredentials) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentCredentials) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintData(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintData(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Budget != nil {
		{
			size, err := m.Budget.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Version) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Version) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Version) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintData(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VersionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VersionList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VersionList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListVersionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListVersionsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListVersionsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CurrentVersion) > 0 {
		i -= len(m.CurrentVersion)
		copy(dAtA[i:], m.CurrentVersion)
		i = encodeVarintData(dAtA, i, uint64(len(m.CurrentVersion)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintData(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecLimitsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecLimitsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecLimitsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintData(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecLimits) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecLimits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecLimits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DbserverDiskSize != nil {
		{
			size, err := m.DbserverDiskSize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.DbserverMemorySize != nil {
		{
			size, err := m.DbserverMemorySize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.Dbservers != nil {
		{
			size, err := m.Dbservers.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.CoordinatorMemorySize != nil {
		{
			size, err := m.CoordinatorMemorySize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Coordinators != nil {
		{
			size, err := m.Coordinators.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecLimits_Limits) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecLimits_Limits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecLimits_Limits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AllowedValues) > 0 {
		dAtA25 := make([]byte, len(m.AllowedValues)*10)
		var j24 int
		for _, num1 := range m.AllowedValues {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA25[j24] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j24++
			}
			dAtA25[j24] = uint8(num)
			j24++
		}
		i -= j24
		copy(dAtA[i:], dAtA25[:j24])
		i = encodeVarintData(dAtA, i, uint64(j24))
		i--
		dAtA[i] = 0x1a
	}
	if m.Max != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Max))
		i--
		dAtA[i] = 0x10
	}
	if m.Min != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Min))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CalculateDeploymentSizeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CalculateDeploymentSizeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CalculateDeploymentSizeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DbserverDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverDiskSize))
		i--
		dAtA[i] = 0x68
	}
	if m.DbserverMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverMemorySize))
		i--
		dAtA[i] = 0x60
	}
	if m.Dbservers != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Dbservers))
		i--
		dAtA[i] = 0x58
	}
	if m.CoordinatorMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.CoordinatorMemorySize))
		i--
		dAtA[i] = 0x10
	}
	if m.Coordinators != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Coordinators))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentSize) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentSize) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentSize) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TotalDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.TotalDiskSize))
		i--
		dAtA[i] = 0x60
	}
	if m.TotalMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.TotalMemorySize))
		i--
		dAtA[i] = 0x58
	}
	if m.AgentDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.AgentDiskSize))
		i--
		dAtA[i] = 0x18
	}
	if m.AgentMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.AgentMemorySize))
		i--
		dAtA[i] = 0x10
	}
	if m.Agents != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Agents))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DataVolumeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataVolumeInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataVolumeInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MeasuredAt != nil {
		{
			size, err := m.MeasuredAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.AvailableBytes != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.AvailableBytes))
		i--
		dAtA[i] = 0x18
	}
	if m.UsedBytes != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.UsedBytes))
		i--
		dAtA[i] = 0x10
	}
	if m.TotalBytes != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.TotalBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConnectDriverInstructions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectDriverInstructions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectDriverInstructions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Drivers) > 0 {
		for iNdEx := len(m.Drivers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Drivers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ConnectDriverInstructions_DriverInstructions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectDriverInstructions_DriverInstructions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectDriverInstructions_DriverInstructions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DriverUrl) > 0 {
		i -= len(m.DriverUrl)
		copy(dAtA[i:], m.DriverUrl)
		i = encodeVarintData(dAtA, i, uint64(len(m.DriverUrl)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Remarks) > 0 {
		for iNdEx := len(m.Remarks) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Remarks[iNdEx])
			copy(dAtA[i:], m.Remarks[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.Remarks[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Code) > 0 {
		for iNdEx := len(m.Code) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Code[iNdEx])
			copy(dAtA[i:], m.Code[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.Code[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintData(dAtA []byte, offset int, v uint64) int {
	offset -= sovData(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.SupportPlanId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	if m.Certificates != nil {
		l = m.Certificates.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.Servers != nil {
		l = m.Servers.Size()
		n += 2 + l + sovData(uint64(l))
	}
	l = len(m.IpwhitelistId)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.Size_ != nil {
		l = m.Size_.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.Expiration != nil {
		l = m.Expiration.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.BackupRestore != nil {
		l = m.BackupRestore.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_CertificateSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CaCertificateId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.AlternateDnsNames) > 0 {
		for _, s := range m.AlternateDnsNames {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_ServersSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Coordinators != 0 {
		n += 1 + sovData(uint64(m.Coordinators))
	}
	if m.CoordinatorMemorySize != 0 {
		n += 1 + sovData(uint64(m.CoordinatorMemorySize))
	}
	if len(m.CoordinatorArgs) > 0 {
		for _, s := range m.CoordinatorArgs {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.Dbservers != 0 {
		n += 1 + sovData(uint64(m.Dbservers))
	}
	if m.DbserverMemorySize != 0 {
		n += 1 + sovData(uint64(m.DbserverMemorySize))
	}
	if m.DbserverDiskSize != 0 {
		n += 1 + sovData(uint64(m.DbserverDiskSize))
	}
	if len(m.DbserverArgs) > 0 {
		for _, s := range m.DbserverArgs {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_ServerStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Ready {
		n += 2
	}
	if m.MemberOfCluster {
		n += 2
	}
	if m.Failed {
		n += 2
	}
	if m.Creating {
		n += 2
	}
	if m.Ok {
		n += 2
	}
	if m.Upgrading {
		n += 2
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.DataVolumeInfo != nil {
		l = m.DataVolumeInfo.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.Created {
		n += 2
	}
	if m.Ready {
		n += 2
	}
	if m.Upgrading {
		n += 2
	}
	if len(m.ServerVersions) > 0 {
		for _, s := range m.ServerVersions {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if len(m.Servers) > 0 {
		for _, e := range m.Servers {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.BootstrappedAt != nil {
		l = m.BootstrappedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Bootstrapped {
		n += 2
	}
	if m.BackupRestoreStatus != nil {
		l = m.BackupRestoreStatus.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_BackupRestoreStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Revision != 0 {
		n += 1 + sovData(uint64(m.Revision))
	}
	if m.Restoring {
		n += 2
	}
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.FailureReason)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_Expiration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExpiresAt != nil {
		l = m.ExpiresAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.LastWarningEmailSendAt != nil {
		l = m.LastWarningEmailSendAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.LastWarningEmailSendTo) > 0 {
		for _, s := range m.LastWarningEmailSendTo {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_BackupRestoreSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Revision != 0 {
		n += 1 + sovData(uint64(m.Revision))
	}
	if m.LastUpdatedAt != nil {
		l = m.LastUpdatedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.BackupId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecPresetsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecPreset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.IsDefault {
		n += 2
	}
	if m.Servers != nil {
		l = m.Servers.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecPresetList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentCredentialsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentCredentials) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.Budget != nil {
		l = m.Budget.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Version) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VersionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListVersionsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.CurrentVersion)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecLimitsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecLimits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Coordinators != nil {
		l = m.Coordinators.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.CoordinatorMemorySize != nil {
		l = m.CoordinatorMemorySize.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Dbservers != nil {
		l = m.Dbservers.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.DbserverMemorySize != nil {
		l = m.DbserverMemorySize.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.DbserverDiskSize != nil {
		l = m.DbserverDiskSize.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecLimits_Limits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Min != 0 {
		n += 1 + sovData(uint64(m.Min))
	}
	if m.Max != 0 {
		n += 1 + sovData(uint64(m.Max))
	}
	if len(m.AllowedValues) > 0 {
		l = 0
		for _, e := range m.AllowedValues {
			l += sovData(uint64(e))
		}
		n += 1 + sovData(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CalculateDeploymentSizeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Coordinators != 0 {
		n += 1 + sovData(uint64(m.Coordinators))
	}
	if m.CoordinatorMemorySize != 0 {
		n += 1 + sovData(uint64(m.CoordinatorMemorySize))
	}
	if m.Dbservers != 0 {
		n += 1 + sovData(uint64(m.Dbservers))
	}
	if m.DbserverMemorySize != 0 {
		n += 1 + sovData(uint64(m.DbserverMemorySize))
	}
	if m.DbserverDiskSize != 0 {
		n += 1 + sovData(uint64(m.DbserverDiskSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentSize) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Agents != 0 {
		n += 1 + sovData(uint64(m.Agents))
	}
	if m.AgentMemorySize != 0 {
		n += 1 + sovData(uint64(m.AgentMemorySize))
	}
	if m.AgentDiskSize != 0 {
		n += 1 + sovData(uint64(m.AgentDiskSize))
	}
	if m.TotalMemorySize != 0 {
		n += 1 + sovData(uint64(m.TotalMemorySize))
	}
	if m.TotalDiskSize != 0 {
		n += 1 + sovData(uint64(m.TotalDiskSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataVolumeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalBytes != 0 {
		n += 1 + sovData(uint64(m.TotalBytes))
	}
	if m.UsedBytes != 0 {
		n += 1 + sovData(uint64(m.UsedBytes))
	}
	if m.AvailableBytes != 0 {
		n += 1 + sovData(uint64(m.AvailableBytes))
	}
	if m.MeasuredAt != nil {
		l = m.MeasuredAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectDriverInstructions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Drivers) > 0 {
		for _, e := range m.Drivers {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectDriverInstructions_DriverInstructions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.Code) > 0 {
		for _, s := range m.Code {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if len(m.Remarks) > 0 {
		for _, s := range m.Remarks {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	l = len(m.DriverUrl)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovData(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozData(x uint64) (n int) {
	return sovData(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Deployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Deployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Deployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportPlanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SupportPlanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 102:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Certificates == nil {
				m.Certificates = &Deployment_CertificateSpec{}
			}
			if err := m.Certificates.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 103:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Servers == nil {
				m.Servers = &Deployment_ServersSpec{}
			}
			if err := m.Servers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 105:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpwhitelistId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IpwhitelistId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 201:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &Deployment_Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 202:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Size_ == nil {
				m.Size_ = &DeploymentSize{}
			}
			if err := m.Size_.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 301:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expiration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expiration == nil {
				m.Expiration = &Deployment_Expiration{}
			}
			if err := m.Expiration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 401:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupRestore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BackupRestore == nil {
				m.BackupRestore = &Deployment_BackupRestoreSpec{}
			}
			if err := m.BackupRestore.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_CertificateSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificateSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificateSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificateId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificateId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlternateDnsNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlternateDnsNames = append(m.AlternateDnsNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_ServersSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Coordinators", wireType)
			}
			m.Coordinators = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Coordinators |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorMemorySize", wireType)
			}
			m.CoordinatorMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CoordinatorMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorArgs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CoordinatorArgs = append(m.CoordinatorArgs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dbservers", wireType)
			}
			m.Dbservers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Dbservers |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverMemorySize", wireType)
			}
			m.DbserverMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverDiskSize", wireType)
			}
			m.DbserverDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverArgs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DbserverArgs = append(m.DbserverArgs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_ServerStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ready", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ready = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberOfCluster", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemberOfCluster = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Failed = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Creating", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Creating = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ok", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ok = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Upgrading", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Upgrading = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataVolumeInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DataVolumeInfo == nil {
				m.DataVolumeInfo = &DataVolumeInfo{}
			}
			if err := m.DataVolumeInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Created = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ready", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ready = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Upgrading", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Upgrading = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerVersions = append(m.ServerVersions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Servers = append(m.Servers, &Deployment_ServerStatus{})
			if err := m.Servers[len(m.Servers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BootstrappedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BootstrappedAt == nil {
				m.BootstrappedAt = &types.Timestamp{}
			}
			if err := m.BootstrappedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bootstrapped", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Bootstrapped = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupRestoreStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BackupRestoreStatus == nil {
				m.BackupRestoreStatus = &Deployment_BackupRestoreStatus{}
			}
			if err := m.BackupRestoreStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_BackupRestoreStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupRestoreStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupRestoreStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			m.Revision = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Revision |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restoring", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Restoring = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailureReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailureReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_Expiration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Expiration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Expiration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiresAt == nil {
				m.ExpiresAt = &types.Timestamp{}
			}
			if err := m.ExpiresAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWarningEmailSendAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastWarningEmailSendAt == nil {
				m.LastWarningEmailSendAt = &types.Timestamp{}
			}
			if err := m.LastWarningEmailSendAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWarningEmailSendTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastWarningEmailSendTo = append(m.LastWarningEmailSendTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_BackupRestoreSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupRestoreSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupRestoreSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			m.Revision = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Revision |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdatedAt == nil {
				m.LastUpdatedAt = &types.Timestamp{}
			}
			if err := m.LastUpdatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecPresetsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpecPresetsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpecPresetsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecPreset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpecPreset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpecPreset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Servers == nil {
				m.Servers = &Deployment_ServersSpec{}
			}
			if err := m.Servers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecPresetList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpecPresetList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpecPresetList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &ServersSpecPreset{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentCredentialsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentCredentialsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentCredentialsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentCredentials) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentCredentials: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentCredentials: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Deployment{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Budget", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Budget == nil {
				m.Budget = &v1.Budget{}
			}
			if err := m.Budget.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Version) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Version: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Version: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VersionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VersionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VersionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Version{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListVersionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListVersionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListVersionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrentVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecLimitsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpecLimitsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpecLimitsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecLimits) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpecLimits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpecLimits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Coordinators", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Coordinators == nil {
				m.Coordinators = &ServersSpecLimits_Limits{}
			}
			if err := m.Coordinators.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorMemorySize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CoordinatorMemorySize == nil {
				m.CoordinatorMemorySize = &ServersSpecLimits_Limits{}
			}
			if err := m.CoordinatorMemorySize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dbservers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dbservers == nil {
				m.Dbservers = &ServersSpecLimits_Limits{}
			}
			if err := m.Dbservers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverMemorySize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DbserverMemorySize == nil {
				m.DbserverMemorySize = &ServersSpecLimits_Limits{}
			}
			if err := m.DbserverMemorySize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverDiskSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DbserverDiskSize == nil {
				m.DbserverDiskSize = &ServersSpecLimits_Limits{}
			}
			if err := m.DbserverDiskSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecLimits_Limits) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Limits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Limits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			m.Min = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Min |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			m.Max = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Max |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowData
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AllowedValues = append(m.AllowedValues, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowData
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthData
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthData
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.AllowedValues) == 0 {
					m.AllowedValues = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowData
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AllowedValues = append(m.AllowedValues, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowedValues", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CalculateDeploymentSizeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CalculateDeploymentSizeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CalculateDeploymentSizeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Coordinators", wireType)
			}
			m.Coordinators = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Coordinators |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorMemorySize", wireType)
			}
			m.CoordinatorMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CoordinatorMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dbservers", wireType)
			}
			m.Dbservers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Dbservers |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverMemorySize", wireType)
			}
			m.DbserverMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverDiskSize", wireType)
			}
			m.DbserverDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentSize) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentSize: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentSize: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Agents", wireType)
			}
			m.Agents = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Agents |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentMemorySize", wireType)
			}
			m.AgentMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AgentMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentDiskSize", wireType)
			}
			m.AgentDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AgentDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalMemorySize", wireType)
			}
			m.TotalMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalDiskSize", wireType)
			}
			m.TotalDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataVolumeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataVolumeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataVolumeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsedBytes", wireType)
			}
			m.UsedBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UsedBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailableBytes", wireType)
			}
			m.AvailableBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvailableBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MeasuredAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MeasuredAt == nil {
				m.MeasuredAt = &types.Timestamp{}
			}
			if err := m.MeasuredAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectDriverInstructions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectDriverInstructions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectDriverInstructions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Drivers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Drivers = append(m.Drivers, &ConnectDriverInstructions_DriverInstructions{})
			if err := m.Drivers[len(m.Drivers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectDriverInstructions_DriverInstructions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DriverInstructions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DriverInstructions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Code = append(m.Code, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Remarks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Remarks = append(m.Remarks, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DriverUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipData(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowData
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthData
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthData
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowData
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipData(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthData
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthData = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowData   = fmt.Errorf("proto: integer overflow")
)
