// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: usage.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A UsageItem message contained usage tracking information for a tracked
// resource (usually deployment) in a specific time period.
type UsageItem struct {
	// System identifier of the usage item.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Kind of usage item
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	// Identification of the resource covered by this usage item
	Resource *UsageItem_Resource `protobuf:"bytes,4,opt,name=resource,proto3" json:"resource,omitempty"`
	// This usage item covers a time period that starts at this timestamp
	StartsAt *types.Timestamp `protobuf:"bytes,5,opt,name=starts_at,json=startsAt,proto3" json:"starts_at,omitempty"`
	// This usage item covers a time period that ends at this timestamp.
	// If the usage item has not yet ended, this field is is set to the current time.
	EndsAt *types.Timestamp `protobuf:"bytes,6,opt,name=ends_at,json=endsAt,proto3" json:"ends_at,omitempty"`
	// Set when this usage item has ended.
	HasEnded bool `protobuf:"varint,7,opt,name=has_ended,json=hasEnded,proto3" json:"has_ended,omitempty"`
	// Identifier of the tier the organization was using at the start of this usage period.
	TierId string `protobuf:"bytes,8,opt,name=tier_id,json=tierId,proto3" json:"tier_id,omitempty"`
	// Identifier of the invoice that includes this usage item.
	// The usage item must be ended when this field it set.
	InvoiceId string `protobuf:"bytes,9,opt,name=invoice_id,json=invoiceId,proto3" json:"invoice_id,omitempty"`
	// Amount of (computer) resources used by the resource covered by this usage item.
	// This field is only set when the usage item is of kind DeploymentSize.
	DeploymentSize *UsageItem_DeploymentSize `protobuf:"bytes,101,opt,name=deployment_size,json=deploymentSize,proto3" json:"deployment_size,omitempty"`
	// Amount of network traffic used by the resource covered by this usage item.
	// This field is only set when the usage item is of kind NetworkTransferSize.
	NetworkTransferSize  *UsageItem_NetworkTransferSize `protobuf:"bytes,102,opt,name=network_transfer_size,json=networkTransferSize,proto3" json:"network_transfer_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *UsageItem) Reset()         { *m = UsageItem{} }
func (m *UsageItem) String() string { return proto.CompactTextString(m) }
func (*UsageItem) ProtoMessage()    {}
func (*UsageItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc9154f4fefb0f53, []int{0}
}
func (m *UsageItem) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UsageItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UsageItem.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UsageItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsageItem.Merge(m, src)
}
func (m *UsageItem) XXX_Size() int {
	return m.Size()
}
func (m *UsageItem) XXX_DiscardUnknown() {
	xxx_messageInfo_UsageItem.DiscardUnknown(m)
}

var xxx_messageInfo_UsageItem proto.InternalMessageInfo

func (m *UsageItem) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UsageItem) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *UsageItem) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *UsageItem) GetResource() *UsageItem_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *UsageItem) GetStartsAt() *types.Timestamp {
	if m != nil {
		return m.StartsAt
	}
	return nil
}

func (m *UsageItem) GetEndsAt() *types.Timestamp {
	if m != nil {
		return m.EndsAt
	}
	return nil
}

func (m *UsageItem) GetHasEnded() bool {
	if m != nil {
		return m.HasEnded
	}
	return false
}

func (m *UsageItem) GetTierId() string {
	if m != nil {
		return m.TierId
	}
	return ""
}

func (m *UsageItem) GetInvoiceId() string {
	if m != nil {
		return m.InvoiceId
	}
	return ""
}

func (m *UsageItem) GetDeploymentSize() *UsageItem_DeploymentSize {
	if m != nil {
		return m.DeploymentSize
	}
	return nil
}

func (m *UsageItem) GetNetworkTransferSize() *UsageItem_NetworkTransferSize {
	if m != nil {
		return m.NetworkTransferSize
	}
	return nil
}

type UsageItem_Resource struct {
	// System identifier of the resource that this usage item covers.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of the resource that this usage item covers
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Kind of resource that this usage item covers.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	// Human readable description of the resource that this usage item covers.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the organization that owns the resource that this usage item covers.
	OrganizationId string `protobuf:"bytes,5,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the organization that owns the resource that this usage item covers.
	OrganizationName string `protobuf:"bytes,6,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// Identifier of the project that owns the resource that this usage item covers.
	ProjectId string `protobuf:"bytes,7,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Name of the project that owns the resource that this usage item covers.
	ProjectName string `protobuf:"bytes,8,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// Identifier of the deployment that owns the resource that this usage item covers.
	DeploymentId string `protobuf:"bytes,9,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Name of the deployment that owns the resource that this usage item covers.
	DeploymentName string `protobuf:"bytes,10,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	// Name of the deployment member that owns the resource that this usage item covers.
	// This field is only set when the usage item is specific for a member of the deployment (e.g. network transfer)
	DeploymentMemberName string `protobuf:"bytes,11,opt,name=deployment_member_name,json=deploymentMemberName,proto3" json:"deployment_member_name,omitempty"`
	// Identifier of the cloud provider that is used to run the deployment.
	CloudProviderId string `protobuf:"bytes,12,opt,name=cloud_provider_id,json=cloudProviderId,proto3" json:"cloud_provider_id,omitempty"`
	// Identifier of the cloud region that is used to run the deployment.
	CloudRegionId string `protobuf:"bytes,13,opt,name=cloud_region_id,json=cloudRegionId,proto3" json:"cloud_region_id,omitempty"`
	// Identifier of the support plan that is attached to the deployment.
	SupportPlanId        string   `protobuf:"bytes,14,opt,name=support_plan_id,json=supportPlanId,proto3" json:"support_plan_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UsageItem_Resource) Reset()         { *m = UsageItem_Resource{} }
func (m *UsageItem_Resource) String() string { return proto.CompactTextString(m) }
func (*UsageItem_Resource) ProtoMessage()    {}
func (*UsageItem_Resource) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc9154f4fefb0f53, []int{0, 0}
}
func (m *UsageItem_Resource) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UsageItem_Resource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UsageItem_Resource.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UsageItem_Resource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsageItem_Resource.Merge(m, src)
}
func (m *UsageItem_Resource) XXX_Size() int {
	return m.Size()
}
func (m *UsageItem_Resource) XXX_DiscardUnknown() {
	xxx_messageInfo_UsageItem_Resource.DiscardUnknown(m)
}

var xxx_messageInfo_UsageItem_Resource proto.InternalMessageInfo

func (m *UsageItem_Resource) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UsageItem_Resource) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *UsageItem_Resource) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *UsageItem_Resource) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *UsageItem_Resource) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *UsageItem_Resource) GetOrganizationName() string {
	if m != nil {
		return m.OrganizationName
	}
	return ""
}

func (m *UsageItem_Resource) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UsageItem_Resource) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *UsageItem_Resource) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *UsageItem_Resource) GetDeploymentName() string {
	if m != nil {
		return m.DeploymentName
	}
	return ""
}

func (m *UsageItem_Resource) GetDeploymentMemberName() string {
	if m != nil {
		return m.DeploymentMemberName
	}
	return ""
}

func (m *UsageItem_Resource) GetCloudProviderId() string {
	if m != nil {
		return m.CloudProviderId
	}
	return ""
}

func (m *UsageItem_Resource) GetCloudRegionId() string {
	if m != nil {
		return m.CloudRegionId
	}
	return ""
}

func (m *UsageItem_Resource) GetSupportPlanId() string {
	if m != nil {
		return m.SupportPlanId
	}
	return ""
}

type UsageItem_DeploymentSize struct {
	// Number of coordinators of the deployment
	Coordinators int32 `protobuf:"varint,1,opt,name=coordinators,proto3" json:"coordinators,omitempty"`
	// Amount of memory (in GB) allocated for each coordinator.
	CoordinatorMemorySize int32 `protobuf:"varint,2,opt,name=coordinator_memory_size,json=coordinatorMemorySize,proto3" json:"coordinator_memory_size,omitempty"`
	// Number of dbservers of the deployment
	Dbservers int32 `protobuf:"varint,11,opt,name=dbservers,proto3" json:"dbservers,omitempty"`
	// Amount of memory (in GB) allocated for each dbserver.
	DbserverMemorySize int32 `protobuf:"varint,12,opt,name=dbserver_memory_size,json=dbserverMemorySize,proto3" json:"dbserver_memory_size,omitempty"`
	// Amount of disk space (in GB) allocated for each dbserver.
	DbserverDiskSize int32 `protobuf:"varint,13,opt,name=dbserver_disk_size,json=dbserverDiskSize,proto3" json:"dbserver_disk_size,omitempty"`
	// Number of agents of the deployment
	Agents int32 `protobuf:"varint,21,opt,name=agents,proto3" json:"agents,omitempty"`
	// Amount of memory (in GB) allocated for each agent.
	AgentMemorySize int32 `protobuf:"varint,22,opt,name=agent_memory_size,json=agentMemorySize,proto3" json:"agent_memory_size,omitempty"`
	// Amount of disk space (in GB) allocated for each agent.
	AgentDiskSize        int32    `protobuf:"varint,23,opt,name=agent_disk_size,json=agentDiskSize,proto3" json:"agent_disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UsageItem_DeploymentSize) Reset()         { *m = UsageItem_DeploymentSize{} }
func (m *UsageItem_DeploymentSize) String() string { return proto.CompactTextString(m) }
func (*UsageItem_DeploymentSize) ProtoMessage()    {}
func (*UsageItem_DeploymentSize) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc9154f4fefb0f53, []int{0, 1}
}
func (m *UsageItem_DeploymentSize) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UsageItem_DeploymentSize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UsageItem_DeploymentSize.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UsageItem_DeploymentSize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsageItem_DeploymentSize.Merge(m, src)
}
func (m *UsageItem_DeploymentSize) XXX_Size() int {
	return m.Size()
}
func (m *UsageItem_DeploymentSize) XXX_DiscardUnknown() {
	xxx_messageInfo_UsageItem_DeploymentSize.DiscardUnknown(m)
}

var xxx_messageInfo_UsageItem_DeploymentSize proto.InternalMessageInfo

func (m *UsageItem_DeploymentSize) GetCoordinators() int32 {
	if m != nil {
		return m.Coordinators
	}
	return 0
}

func (m *UsageItem_DeploymentSize) GetCoordinatorMemorySize() int32 {
	if m != nil {
		return m.CoordinatorMemorySize
	}
	return 0
}

func (m *UsageItem_DeploymentSize) GetDbservers() int32 {
	if m != nil {
		return m.Dbservers
	}
	return 0
}

func (m *UsageItem_DeploymentSize) GetDbserverMemorySize() int32 {
	if m != nil {
		return m.DbserverMemorySize
	}
	return 0
}

func (m *UsageItem_DeploymentSize) GetDbserverDiskSize() int32 {
	if m != nil {
		return m.DbserverDiskSize
	}
	return 0
}

func (m *UsageItem_DeploymentSize) GetAgents() int32 {
	if m != nil {
		return m.Agents
	}
	return 0
}

func (m *UsageItem_DeploymentSize) GetAgentMemorySize() int32 {
	if m != nil {
		return m.AgentMemorySize
	}
	return 0
}

func (m *UsageItem_DeploymentSize) GetAgentDiskSize() int32 {
	if m != nil {
		return m.AgentDiskSize
	}
	return 0
}

type UsageItem_NetworkTransferSize struct {
	// Amount of network traffic (in bytes) caused by the use of a deployment.
	TransferSize         int64    `protobuf:"varint,1,opt,name=transfer_size,json=transferSize,proto3" json:"transfer_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UsageItem_NetworkTransferSize) Reset()         { *m = UsageItem_NetworkTransferSize{} }
func (m *UsageItem_NetworkTransferSize) String() string { return proto.CompactTextString(m) }
func (*UsageItem_NetworkTransferSize) ProtoMessage()    {}
func (*UsageItem_NetworkTransferSize) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc9154f4fefb0f53, []int{0, 2}
}
func (m *UsageItem_NetworkTransferSize) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UsageItem_NetworkTransferSize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UsageItem_NetworkTransferSize.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UsageItem_NetworkTransferSize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsageItem_NetworkTransferSize.Merge(m, src)
}
func (m *UsageItem_NetworkTransferSize) XXX_Size() int {
	return m.Size()
}
func (m *UsageItem_NetworkTransferSize) XXX_DiscardUnknown() {
	xxx_messageInfo_UsageItem_NetworkTransferSize.DiscardUnknown(m)
}

var xxx_messageInfo_UsageItem_NetworkTransferSize proto.InternalMessageInfo

func (m *UsageItem_NetworkTransferSize) GetTransferSize() int64 {
	if m != nil {
		return m.TransferSize
	}
	return 0
}

// List of UsageItems.
type UsageItemList struct {
	Items                []*UsageItem `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *UsageItemList) Reset()         { *m = UsageItemList{} }
func (m *UsageItemList) String() string { return proto.CompactTextString(m) }
func (*UsageItemList) ProtoMessage()    {}
func (*UsageItemList) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc9154f4fefb0f53, []int{1}
}
func (m *UsageItemList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UsageItemList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UsageItemList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UsageItemList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UsageItemList.Merge(m, src)
}
func (m *UsageItemList) XXX_Size() int {
	return m.Size()
}
func (m *UsageItemList) XXX_DiscardUnknown() {
	xxx_messageInfo_UsageItemList.DiscardUnknown(m)
}

var xxx_messageInfo_UsageItemList proto.InternalMessageInfo

func (m *UsageItemList) GetItems() []*UsageItem {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListUsageItems
type ListUsageItemsRequest struct {
	// Request usage items for the organization with this id.
	// This is a required field.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Request usage items that overlaps in time with the time period that starts with this timestamp (inclusive).
	// This is a required field.
	From *types.Timestamp `protobuf:"bytes,2,opt,name=from,proto3" json:"from,omitempty"`
	// Request usage items that overlaps in time with the time period that ends with this timestamp (inclusive).
	// This is a required field.
	To *types.Timestamp `protobuf:"bytes,3,opt,name=to,proto3" json:"to,omitempty"`
	// Standard list options
	// This is an optional field.
	Options *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	// Limit to usage items for the resource with this URL.
	// This is an optional field.
	ResourceUrl string `protobuf:"bytes,11,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// Limit to usage items for the resource with this kind.
	// This is an optional field.
	ResourceKind string `protobuf:"bytes,12,opt,name=resource_kind,json=resourceKind,proto3" json:"resource_kind,omitempty"`
	// Limit to usage items for the project with this id.
	// This is an optional field.
	ProjectId string `protobuf:"bytes,13,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Limit to usage items for the deployment with this id.
	// This is an optional field.
	DeploymentId string `protobuf:"bytes,14,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// If set, limit to usage items that have no invoice_id set.
	HasNoInvoiceId bool `protobuf:"varint,20,opt,name=has_no_invoice_id,json=hasNoInvoiceId,proto3" json:"has_no_invoice_id,omitempty"`
	// If set, limit to usage items that have an invoice_id set.
	HasInvoiceId         bool     `protobuf:"varint,21,opt,name=has_invoice_id,json=hasInvoiceId,proto3" json:"has_invoice_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListUsageItemsRequest) Reset()         { *m = ListUsageItemsRequest{} }
func (m *ListUsageItemsRequest) String() string { return proto.CompactTextString(m) }
func (*ListUsageItemsRequest) ProtoMessage()    {}
func (*ListUsageItemsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_fc9154f4fefb0f53, []int{2}
}
func (m *ListUsageItemsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListUsageItemsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListUsageItemsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListUsageItemsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListUsageItemsRequest.Merge(m, src)
}
func (m *ListUsageItemsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListUsageItemsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListUsageItemsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListUsageItemsRequest proto.InternalMessageInfo

func (m *ListUsageItemsRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListUsageItemsRequest) GetFrom() *types.Timestamp {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *ListUsageItemsRequest) GetTo() *types.Timestamp {
	if m != nil {
		return m.To
	}
	return nil
}

func (m *ListUsageItemsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListUsageItemsRequest) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *ListUsageItemsRequest) GetResourceKind() string {
	if m != nil {
		return m.ResourceKind
	}
	return ""
}

func (m *ListUsageItemsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListUsageItemsRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ListUsageItemsRequest) GetHasNoInvoiceId() bool {
	if m != nil {
		return m.HasNoInvoiceId
	}
	return false
}

func (m *ListUsageItemsRequest) GetHasInvoiceId() bool {
	if m != nil {
		return m.HasInvoiceId
	}
	return false
}

func init() {
	proto.RegisterType((*UsageItem)(nil), "arangodb.cloud.usage.v1.UsageItem")
	proto.RegisterType((*UsageItem_Resource)(nil), "arangodb.cloud.usage.v1.UsageItem.Resource")
	proto.RegisterType((*UsageItem_DeploymentSize)(nil), "arangodb.cloud.usage.v1.UsageItem.DeploymentSize")
	proto.RegisterType((*UsageItem_NetworkTransferSize)(nil), "arangodb.cloud.usage.v1.UsageItem.NetworkTransferSize")
	proto.RegisterType((*UsageItemList)(nil), "arangodb.cloud.usage.v1.UsageItemList")
	proto.RegisterType((*ListUsageItemsRequest)(nil), "arangodb.cloud.usage.v1.ListUsageItemsRequest")
}

func init() { proto.RegisterFile("usage.proto", fileDescriptor_fc9154f4fefb0f53) }

var fileDescriptor_fc9154f4fefb0f53 = []byte{
	// 1032 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xc6, 0x76, 0x7e, 0xec, 0xe3, 0x9f, 0x24, 0xd3, 0xfc, 0x58, 0xa6, 0x44, 0xc1, 0x40, 0x48,
	0x5b, 0x58, 0x93, 0x14, 0xb5, 0x40, 0x2f, 0xaa, 0xa2, 0x22, 0x64, 0x41, 0x43, 0xb5, 0x6d, 0x6f,
	0x7a, 0x63, 0x8d, 0x3d, 0x93, 0xcd, 0x34, 0xde, 0x99, 0x65, 0x66, 0x6c, 0x94, 0x20, 0x6e, 0x78,
	0x05, 0x6e, 0x78, 0x03, 0xc4, 0x2b, 0xf4, 0x09, 0xb8, 0x44, 0x42, 0xe2, 0x1a, 0x05, 0x9e, 0x82,
	0x2b, 0x34, 0x67, 0x76, 0x37, 0xeb, 0x34, 0x6d, 0x2a, 0xee, 0x76, 0xbe, 0xef, 0x3b, 0xe7, 0xcc,
	0xcc, 0xf9, 0x99, 0x85, 0xfa, 0xc4, 0xd0, 0x88, 0x07, 0x89, 0x56, 0x56, 0x91, 0x0d, 0xaa, 0xa9,
	0x8c, 0x14, 0x1b, 0x06, 0xa3, 0xb1, 0x9a, 0xb0, 0xc0, 0x73, 0xd3, 0xdd, 0xce, 0xfa, 0x48, 0xc5,
	0xb1, 0x92, 0xbd, 0xe9, 0x6e, 0xcf, 0x7f, 0x79, 0x83, 0xce, 0x9d, 0x48, 0xd8, 0xc3, 0xc9, 0x30,
	0x18, 0xa9, 0xb8, 0x17, 0xa9, 0x31, 0x95, 0x51, 0x0f, 0x89, 0xe1, 0xe4, 0xa0, 0x97, 0xd8, 0xe3,
	0x84, 0x9b, 0x9e, 0x15, 0x31, 0x37, 0x96, 0xc6, 0xc9, 0xd9, 0x57, 0x6a, 0x7c, 0x35, 0x52, 0x2a,
	0x1a, 0xf3, 0x1e, 0x4d, 0x44, 0x8f, 0x4a, 0xa9, 0x2c, 0xb5, 0x42, 0x49, 0xe3, 0xd9, 0xee, 0x2f,
	0x75, 0xa8, 0x3d, 0x71, 0xf1, 0xfb, 0x96, 0xc7, 0xa4, 0x05, 0x65, 0xc1, 0xda, 0xa5, 0xad, 0xd2,
	0x4e, 0x2d, 0x2c, 0x0b, 0x46, 0x96, 0xa1, 0x32, 0xd1, 0xe3, 0x76, 0x19, 0x01, 0xf7, 0x49, 0x08,
	0xcc, 0x1d, 0x09, 0xc9, 0xda, 0x15, 0x84, 0xf0, 0x9b, 0x7c, 0x09, 0x55, 0xcd, 0x8d, 0x9a, 0xe8,
	0x11, 0x6f, 0xcf, 0x6d, 0x95, 0x76, 0xea, 0x7b, 0x37, 0x82, 0x97, 0x1c, 0x31, 0xc8, 0x63, 0x05,
	0x61, 0x6a, 0x12, 0xe6, 0xc6, 0xe4, 0x36, 0xd4, 0x8c, 0xa5, 0xda, 0x9a, 0x01, 0xb5, 0xed, 0x79,
	0xf4, 0xd4, 0x09, 0xfc, 0xf6, 0x83, 0xec, 0xc0, 0xc1, 0xe3, 0xec, 0x7c, 0x61, 0xd5, 0x8b, 0xef,
	0x59, 0x72, 0x13, 0x16, 0xb9, 0x64, 0x68, 0xb6, 0x70, 0xa9, 0xd9, 0x82, 0x93, 0xde, 0xb3, 0xe4,
	0x4d, 0xa8, 0x1d, 0x52, 0x33, 0xe0, 0x92, 0x71, 0xd6, 0x5e, 0xdc, 0x2a, 0xed, 0x54, 0xc3, 0xea,
	0x21, 0x35, 0x5f, 0xb8, 0x35, 0xd9, 0x80, 0x45, 0x2b, 0xb8, 0x1e, 0x08, 0xd6, 0xae, 0xe2, 0x51,
	0x17, 0xdc, 0xb2, 0xcf, 0xc8, 0x5b, 0x00, 0x42, 0x4e, 0x95, 0x18, 0x71, 0xc7, 0xd5, 0x90, 0xab,
	0xa5, 0x48, 0x9f, 0x91, 0xa7, 0xb0, 0xc4, 0x78, 0x32, 0x56, 0xc7, 0x31, 0x97, 0x76, 0x60, 0xc4,
	0x09, 0x6f, 0x73, 0xdc, 0xd1, 0xee, 0x6b, 0x5c, 0xc9, 0xfd, 0xdc, 0xf2, 0x91, 0x38, 0xe1, 0x61,
	0x8b, 0xcd, 0xac, 0xc9, 0x33, 0x58, 0x93, 0xdc, 0x7e, 0xa7, 0xf4, 0xd1, 0xc0, 0x6a, 0x2a, 0xcd,
	0x01, 0xd7, 0x3e, 0xc2, 0x01, 0x46, 0xb8, 0xf5, 0x1a, 0x11, 0xf6, 0xbd, 0xfd, 0xe3, 0xd4, 0x1c,
	0xc3, 0x5c, 0x91, 0x2f, 0x82, 0x9d, 0x7f, 0x2b, 0x50, 0xcd, 0x32, 0xf4, 0x3f, 0xcb, 0x62, 0x0b,
	0xea, 0x8c, 0x9b, 0x91, 0x16, 0x89, 0x2b, 0x38, 0xac, 0x8c, 0x5a, 0x58, 0x84, 0xc8, 0xfb, 0xb0,
	0xa4, 0x74, 0x44, 0xa5, 0x38, 0xc1, 0x9a, 0x74, 0x17, 0x3a, 0x8f, 0xaa, 0x56, 0x11, 0xee, 0x33,
	0x72, 0x03, 0x56, 0x66, 0x84, 0x92, 0xc6, 0x1c, 0x33, 0x5d, 0x0b, 0x97, 0x8b, 0xc4, 0x3e, 0x8d,
	0xb9, 0xcb, 0x50, 0xa2, 0xd5, 0x33, 0x3e, 0xb2, 0xce, 0xe1, 0xa2, 0xcf, 0x50, 0x8a, 0xf4, 0x19,
	0x79, 0x1b, 0x1a, 0x19, 0x8d, 0x6e, 0x7c, 0x7a, 0xeb, 0x29, 0x86, 0x1e, 0xde, 0x81, 0x66, 0x21,
	0x89, 0x79, 0x9a, 0x1b, 0x67, 0x60, 0x9f, 0xb9, 0xcd, 0x17, 0x44, 0xe8, 0x0a, 0xfc, 0xe6, 0xcf,
	0x60, 0xf4, 0xf6, 0x31, 0xac, 0x17, 0x84, 0x31, 0x8f, 0x87, 0x5c, 0x7b, 0x7d, 0x1d, 0xf5, 0xab,
	0x67, 0xec, 0x03, 0x24, 0xd1, 0xea, 0x3a, 0xac, 0x60, 0x16, 0x07, 0x89, 0x56, 0x53, 0xc1, 0x7c,
	0x29, 0x36, 0xd0, 0x60, 0x09, 0x89, 0x87, 0x29, 0xde, 0x67, 0x64, 0x1b, 0x3c, 0x34, 0xd0, 0x3c,
	0x4a, 0xef, 0xb1, 0x89, 0xca, 0x26, 0xc2, 0x21, 0xa2, 0x5e, 0x67, 0x26, 0x49, 0xa2, 0xb4, 0x1d,
	0x24, 0x63, 0x8a, 0xba, 0x96, 0xd7, 0xa5, 0xf0, 0xc3, 0x31, 0x95, 0x7d, 0xd6, 0xf9, 0xb3, 0x0c,
	0xad, 0xd9, 0x5a, 0x24, 0x5d, 0x68, 0x8c, 0x94, 0xd2, 0x4c, 0x48, 0x6a, 0x95, 0x36, 0x58, 0x0c,
	0xf3, 0xe1, 0x0c, 0x46, 0x6e, 0xc1, 0x46, 0x61, 0xed, 0x4e, 0xaa, 0xf4, 0xb1, 0xaf, 0xd0, 0x32,
	0xca, 0xd7, 0x0a, 0xf4, 0x03, 0x64, 0xd1, 0xf7, 0x55, 0xa8, 0xb1, 0xa1, 0xe1, 0x7a, 0xca, 0xb5,
	0xc1, 0x3b, 0x99, 0x0f, 0xcf, 0x00, 0xf2, 0x11, 0xac, 0x66, 0x8b, 0x19, 0x97, 0x0d, 0x14, 0x92,
	0x8c, 0x2b, 0xf8, 0xfb, 0x00, 0x72, 0x74, 0xc0, 0x84, 0x39, 0xf2, 0xfa, 0x26, 0xea, 0x97, 0x33,
	0xe6, 0xbe, 0x30, 0x47, 0xa8, 0x5e, 0x87, 0x05, 0x1a, 0x71, 0x69, 0x4d, 0x7b, 0x0d, 0x15, 0xe9,
	0xca, 0x25, 0x00, 0xbf, 0x66, 0x82, 0xae, 0xa3, 0x64, 0x09, 0x89, 0x42, 0xc4, 0x6d, 0xf0, 0x50,
	0x21, 0xdc, 0x06, 0x2a, 0x9b, 0x08, 0x67, 0xb1, 0x3a, 0x9f, 0xc1, 0x95, 0x0b, 0x3a, 0xd0, 0xd5,
	0xdb, 0x6c, 0x43, 0xbb, 0xdb, 0xad, 0x84, 0x0d, 0x5b, 0x10, 0x75, 0xfb, 0xd0, 0xcc, 0xfb, 0xf8,
	0x6b, 0x61, 0x2c, 0xf9, 0x04, 0xe6, 0x85, 0xe5, 0xb1, 0xcb, 0x45, 0x65, 0xa7, 0xbe, 0xd7, 0xbd,
	0xbc, 0xfd, 0x43, 0x6f, 0xd0, 0x7d, 0x5e, 0x81, 0x35, 0xe7, 0x22, 0x27, 0x4c, 0xc8, 0xbf, 0x9d,
	0x70, 0x63, 0x2f, 0xea, 0xc8, 0xd2, 0x85, 0x1d, 0x19, 0xc0, 0xdc, 0x81, 0x56, 0x31, 0x26, 0xf6,
	0xd5, 0xe3, 0x16, 0x75, 0xe4, 0x3a, 0x94, 0xad, 0xc2, 0xf1, 0xf0, 0x6a, 0x75, 0xd9, 0x2a, 0x72,
	0x17, 0x16, 0x15, 0x0e, 0x08, 0x83, 0x1d, 0x55, 0xdf, 0x7b, 0xef, 0xfc, 0xd1, 0xd2, 0xd7, 0x71,
	0xba, 0x1b, 0xb8, 0x63, 0x7c, 0xe3, 0xc5, 0x61, 0x66, 0xe5, 0x5a, 0x3c, 0x7b, 0x53, 0x06, 0x6e,
	0x50, 0xf9, 0x3e, 0xab, 0x67, 0xd8, 0x13, 0x3d, 0x76, 0x57, 0x9e, 0x4b, 0x70, 0x72, 0xf9, 0xd6,
	0xca, 0xed, 0xbe, 0x72, 0x13, 0x6c, 0x76, 0x92, 0x34, 0xcf, 0x4f, 0x92, 0x17, 0xc6, 0x44, 0xeb,
	0x82, 0x31, 0x71, 0x0d, 0x56, 0xdc, 0x2b, 0x23, 0xd5, 0xa0, 0xf0, 0x6c, 0xac, 0xe2, 0x6b, 0xd3,
	0x3a, 0xa4, 0x66, 0x5f, 0xf5, 0xf3, 0xb7, 0xe3, 0x5d, 0x70, 0x48, 0x51, 0xb7, 0x86, 0xba, 0xc6,
	0x21, 0x35, 0xb9, 0x6a, 0xef, 0x79, 0x09, 0x1a, 0x98, 0xb8, 0x47, 0x5c, 0x4f, 0xc5, 0x88, 0x93,
	0x5f, 0x4b, 0xd0, 0x9a, 0xcd, 0x26, 0x09, 0x5e, 0x5a, 0x0b, 0x17, 0xa6, 0xbd, 0xb3, 0x7d, 0x79,
	0xed, 0x38, 0xc3, 0xee, 0xdd, 0x1f, 0xff, 0xf8, 0xe7, 0xa7, 0xf2, 0xa7, 0xe4, 0x36, 0xfe, 0x4d,
	0xa0, 0xc8, 0xfd, 0xac, 0x14, 0x6b, 0xa3, 0xf7, 0xfd, 0xb9, 0x02, 0xfa, 0xc1, 0xeb, 0xb0, 0xf2,
	0x3e, 0xbf, 0xf3, 0xdb, 0xe9, 0x66, 0xe9, 0xf7, 0xd3, 0xcd, 0xd2, 0x5f, 0xa7, 0x9b, 0xa5, 0x9f,
	0xff, 0xde, 0x7c, 0xe3, 0xe9, 0xb5, 0xc2, 0xbf, 0x4d, 0xb6, 0x89, 0x0f, 0x63, 0x2a, 0x69, 0xc4,
	0x99, 0x8b, 0x62, 0xf2, 0x30, 0xc3, 0x05, 0xac, 0x97, 0x9b, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff,
	0xbd, 0xe6, 0xf2, 0x48, 0x4d, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// UsageServiceClient is the client API for UsageService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UsageServiceClient interface {
	// Fetch all UsageItem resources in the organization identified by the given
	// organization ID that match the given criteria.
	// Required permissions:
	// - usage.usageitem.list on the organization identified by the given organization ID
	ListUsageItems(ctx context.Context, in *ListUsageItemsRequest, opts ...grpc.CallOption) (*UsageItemList, error)
}

type usageServiceClient struct {
	cc *grpc.ClientConn
}

func NewUsageServiceClient(cc *grpc.ClientConn) UsageServiceClient {
	return &usageServiceClient{cc}
}

func (c *usageServiceClient) ListUsageItems(ctx context.Context, in *ListUsageItemsRequest, opts ...grpc.CallOption) (*UsageItemList, error) {
	out := new(UsageItemList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.usage.v1.UsageService/ListUsageItems", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UsageServiceServer is the server API for UsageService service.
type UsageServiceServer interface {
	// Fetch all UsageItem resources in the organization identified by the given
	// organization ID that match the given criteria.
	// Required permissions:
	// - usage.usageitem.list on the organization identified by the given organization ID
	ListUsageItems(context.Context, *ListUsageItemsRequest) (*UsageItemList, error)
}

// UnimplementedUsageServiceServer can be embedded to have forward compatible implementations.
type UnimplementedUsageServiceServer struct {
}

func (*UnimplementedUsageServiceServer) ListUsageItems(ctx context.Context, req *ListUsageItemsRequest) (*UsageItemList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUsageItems not implemented")
}

func RegisterUsageServiceServer(s *grpc.Server, srv UsageServiceServer) {
	s.RegisterService(&_UsageService_serviceDesc, srv)
}

func _UsageService_ListUsageItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsageItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UsageServiceServer).ListUsageItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.usage.v1.UsageService/ListUsageItems",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UsageServiceServer).ListUsageItems(ctx, req.(*ListUsageItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _UsageService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.usage.v1.UsageService",
	HandlerType: (*UsageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListUsageItems",
			Handler:    _UsageService_ListUsageItems_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "usage.proto",
}

func (m *UsageItem) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsageItem) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UsageItem) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NetworkTransferSize != nil {
		{
			size, err := m.NetworkTransferSize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintUsage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb2
	}
	if m.DeploymentSize != nil {
		{
			size, err := m.DeploymentSize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintUsage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.InvoiceId) > 0 {
		i -= len(m.InvoiceId)
		copy(dAtA[i:], m.InvoiceId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.InvoiceId)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.TierId) > 0 {
		i -= len(m.TierId)
		copy(dAtA[i:], m.TierId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.TierId)))
		i--
		dAtA[i] = 0x42
	}
	if m.HasEnded {
		i--
		if m.HasEnded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.EndsAt != nil {
		{
			size, err := m.EndsAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintUsage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.StartsAt != nil {
		{
			size, err := m.StartsAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintUsage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintUsage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UsageItem_Resource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsageItem_Resource) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UsageItem_Resource) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SupportPlanId) > 0 {
		i -= len(m.SupportPlanId)
		copy(dAtA[i:], m.SupportPlanId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.SupportPlanId)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.CloudRegionId) > 0 {
		i -= len(m.CloudRegionId)
		copy(dAtA[i:], m.CloudRegionId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.CloudRegionId)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.CloudProviderId) > 0 {
		i -= len(m.CloudProviderId)
		copy(dAtA[i:], m.CloudProviderId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.CloudProviderId)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.DeploymentMemberName) > 0 {
		i -= len(m.DeploymentMemberName)
		copy(dAtA[i:], m.DeploymentMemberName)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.DeploymentMemberName)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.DeploymentName) > 0 {
		i -= len(m.DeploymentName)
		copy(dAtA[i:], m.DeploymentName)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.DeploymentName)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.ProjectName) > 0 {
		i -= len(m.ProjectName)
		copy(dAtA[i:], m.ProjectName)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.ProjectName)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.OrganizationName) > 0 {
		i -= len(m.OrganizationName)
		copy(dAtA[i:], m.OrganizationName)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.OrganizationName)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UsageItem_DeploymentSize) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsageItem_DeploymentSize) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UsageItem_DeploymentSize) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AgentDiskSize != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.AgentDiskSize))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.AgentMemorySize != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.AgentMemorySize))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.Agents != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.Agents))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.DbserverDiskSize != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.DbserverDiskSize))
		i--
		dAtA[i] = 0x68
	}
	if m.DbserverMemorySize != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.DbserverMemorySize))
		i--
		dAtA[i] = 0x60
	}
	if m.Dbservers != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.Dbservers))
		i--
		dAtA[i] = 0x58
	}
	if m.CoordinatorMemorySize != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.CoordinatorMemorySize))
		i--
		dAtA[i] = 0x10
	}
	if m.Coordinators != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.Coordinators))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *UsageItem_NetworkTransferSize) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsageItem_NetworkTransferSize) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UsageItem_NetworkTransferSize) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TransferSize != 0 {
		i = encodeVarintUsage(dAtA, i, uint64(m.TransferSize))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *UsageItemList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UsageItemList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UsageItemList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintUsage(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListUsageItemsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListUsageItemsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListUsageItemsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HasInvoiceId {
		i--
		if m.HasInvoiceId {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.HasNoInvoiceId {
		i--
		if m.HasNoInvoiceId {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.ResourceKind) > 0 {
		i -= len(m.ResourceKind)
		copy(dAtA[i:], m.ResourceKind)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.ResourceKind)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.ResourceUrl) > 0 {
		i -= len(m.ResourceUrl)
		copy(dAtA[i:], m.ResourceUrl)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.ResourceUrl)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintUsage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.To != nil {
		{
			size, err := m.To.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintUsage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.From != nil {
		{
			size, err := m.From.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintUsage(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintUsage(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintUsage(dAtA []byte, offset int, v uint64) int {
	offset -= sovUsage(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *UsageItem) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.StartsAt != nil {
		l = m.StartsAt.Size()
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.EndsAt != nil {
		l = m.EndsAt.Size()
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.HasEnded {
		n += 2
	}
	l = len(m.TierId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.InvoiceId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.DeploymentSize != nil {
		l = m.DeploymentSize.Size()
		n += 2 + l + sovUsage(uint64(l))
	}
	if m.NetworkTransferSize != nil {
		l = m.NetworkTransferSize.Size()
		n += 2 + l + sovUsage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UsageItem_Resource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.OrganizationName)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.ProjectName)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.DeploymentName)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.DeploymentMemberName)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.CloudProviderId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.CloudRegionId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.SupportPlanId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UsageItem_DeploymentSize) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Coordinators != 0 {
		n += 1 + sovUsage(uint64(m.Coordinators))
	}
	if m.CoordinatorMemorySize != 0 {
		n += 1 + sovUsage(uint64(m.CoordinatorMemorySize))
	}
	if m.Dbservers != 0 {
		n += 1 + sovUsage(uint64(m.Dbservers))
	}
	if m.DbserverMemorySize != 0 {
		n += 1 + sovUsage(uint64(m.DbserverMemorySize))
	}
	if m.DbserverDiskSize != 0 {
		n += 1 + sovUsage(uint64(m.DbserverDiskSize))
	}
	if m.Agents != 0 {
		n += 2 + sovUsage(uint64(m.Agents))
	}
	if m.AgentMemorySize != 0 {
		n += 2 + sovUsage(uint64(m.AgentMemorySize))
	}
	if m.AgentDiskSize != 0 {
		n += 2 + sovUsage(uint64(m.AgentDiskSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UsageItem_NetworkTransferSize) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TransferSize != 0 {
		n += 1 + sovUsage(uint64(m.TransferSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UsageItemList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovUsage(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListUsageItemsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.From != nil {
		l = m.From.Size()
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.To != nil {
		l = m.To.Size()
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.ResourceUrl)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.ResourceKind)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovUsage(uint64(l))
	}
	if m.HasNoInvoiceId {
		n += 3
	}
	if m.HasInvoiceId {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovUsage(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozUsage(x uint64) (n int) {
	return sovUsage(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *UsageItem) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowUsage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UsageItem: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UsageItem: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resource == nil {
				m.Resource = &UsageItem_Resource{}
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartsAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartsAt == nil {
				m.StartsAt = &types.Timestamp{}
			}
			if err := m.StartsAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndsAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndsAt == nil {
				m.EndsAt = &types.Timestamp{}
			}
			if err := m.EndsAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasEnded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasEnded = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TierId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TierId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InvoiceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InvoiceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeploymentSize == nil {
				m.DeploymentSize = &UsageItem_DeploymentSize{}
			}
			if err := m.DeploymentSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 102:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkTransferSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NetworkTransferSize == nil {
				m.NetworkTransferSize = &UsageItem_NetworkTransferSize{}
			}
			if err := m.NetworkTransferSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipUsage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsageItem_Resource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowUsage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Resource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Resource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentMemberName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentMemberName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloudProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CloudProviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloudRegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CloudRegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportPlanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SupportPlanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipUsage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsageItem_DeploymentSize) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowUsage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentSize: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentSize: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Coordinators", wireType)
			}
			m.Coordinators = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Coordinators |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorMemorySize", wireType)
			}
			m.CoordinatorMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CoordinatorMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dbservers", wireType)
			}
			m.Dbservers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Dbservers |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverMemorySize", wireType)
			}
			m.DbserverMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverDiskSize", wireType)
			}
			m.DbserverDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Agents", wireType)
			}
			m.Agents = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Agents |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentMemorySize", wireType)
			}
			m.AgentMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AgentMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentDiskSize", wireType)
			}
			m.AgentDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AgentDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipUsage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsageItem_NetworkTransferSize) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowUsage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkTransferSize: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkTransferSize: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransferSize", wireType)
			}
			m.TransferSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TransferSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipUsage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UsageItemList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowUsage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UsageItemList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UsageItemList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &UsageItem{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipUsage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListUsageItemsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowUsage
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListUsageItemsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListUsageItemsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.From == nil {
				m.From = &types.Timestamp{}
			}
			if err := m.From.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = &types.Timestamp{}
			}
			if err := m.To.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceKind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceKind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthUsage
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthUsage
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasNoInvoiceId", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasNoInvoiceId = bool(v != 0)
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasInvoiceId", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasInvoiceId = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipUsage(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthUsage
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipUsage(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowUsage
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowUsage
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthUsage
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthUsage
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowUsage
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipUsage(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthUsage
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthUsage = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowUsage   = fmt.Errorf("proto: integer overflow")
)
