// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: billing.proto

package v1

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An Invoice message describes a transaction for usage of ArangoDB Oasis.
type Invoice struct {
	// System identifier of the invoice.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Identifier of the organization that is responsible for the payment of this invoice.
	OrganizationId string `protobuf:"bytes,3,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the organization that is responsible for the payment of this invoice.
	OrganizationName string `protobuf:"bytes,4,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// Identifier of the legal entity that is the sender of this invoice.
	EntityId string `protobuf:"bytes,5,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Name of the legal entity that is the sender of this invoice.
	EntityName string `protobuf:"bytes,6,opt,name=entity_name,json=entityName,proto3" json:"entity_name,omitempty"`
	// Invoice number (used by accounting)
	InvoiceNumber string `protobuf:"bytes,7,opt,name=invoice_number,json=invoiceNumber,proto3" json:"invoice_number,omitempty"`
	// The creation date of the invoice
	CreatedAt *types.Timestamp `protobuf:"bytes,10,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// All items of the invoice
	Items []*Invoice_Item `protobuf:"bytes,100,rep,name=items,proto3" json:"items,omitempty"`
	// Currency for all amounts
	CurrencyId string `protobuf:"bytes,110,opt,name=currency_id,json=currencyId,proto3" json:"currency_id,omitempty"`
	// Sum all amount for all items
	TotalAmountExclVat float32 `protobuf:"fixed32,111,opt,name=total_amount_excl_vat,json=totalAmountExclVat,proto3" json:"total_amount_excl_vat,omitempty"`
	// VAT amount for all items
	TotalVat float32 `protobuf:"fixed32,112,opt,name=total_vat,json=totalVat,proto3" json:"total_vat,omitempty"`
	// Sum of total_amount_ex_vat + total_vat.
	// This is the amount that the customer will be charged for.
	TotalAmountInclVat float32 `protobuf:"fixed32,113,opt,name=total_amount_incl_vat,json=totalAmountInclVat,proto3" json:"total_amount_incl_vat,omitempty"`
	// If set, the VAT reverse charge rule is applied for this invoice.
	VatReverseCharge bool            `protobuf:"varint,114,opt,name=vat_reverse_charge,json=vatReverseCharge,proto3" json:"vat_reverse_charge,omitempty"`
	Status           *Invoice_Status `protobuf:"bytes,200,opt,name=status,proto3" json:"status,omitempty"`
	// All payment attempts for this invoice, ordered by created_at.
	Payments             []*Invoice_Payment `protobuf:"bytes,201,rep,name=payments,proto3" json:"payments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Invoice) Reset()         { *m = Invoice{} }
func (m *Invoice) String() string { return proto.CompactTextString(m) }
func (*Invoice) ProtoMessage()    {}
func (*Invoice) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{0}
}
func (m *Invoice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Invoice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Invoice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Invoice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Invoice.Merge(m, src)
}
func (m *Invoice) XXX_Size() int {
	return m.Size()
}
func (m *Invoice) XXX_DiscardUnknown() {
	xxx_messageInfo_Invoice.DiscardUnknown(m)
}

var xxx_messageInfo_Invoice proto.InternalMessageInfo

func (m *Invoice) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Invoice) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Invoice) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Invoice) GetOrganizationName() string {
	if m != nil {
		return m.OrganizationName
	}
	return ""
}

func (m *Invoice) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Invoice) GetEntityName() string {
	if m != nil {
		return m.EntityName
	}
	return ""
}

func (m *Invoice) GetInvoiceNumber() string {
	if m != nil {
		return m.InvoiceNumber
	}
	return ""
}

func (m *Invoice) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Invoice) GetItems() []*Invoice_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *Invoice) GetCurrencyId() string {
	if m != nil {
		return m.CurrencyId
	}
	return ""
}

func (m *Invoice) GetTotalAmountExclVat() float32 {
	if m != nil {
		return m.TotalAmountExclVat
	}
	return 0
}

func (m *Invoice) GetTotalVat() float32 {
	if m != nil {
		return m.TotalVat
	}
	return 0
}

func (m *Invoice) GetTotalAmountInclVat() float32 {
	if m != nil {
		return m.TotalAmountInclVat
	}
	return 0
}

func (m *Invoice) GetVatReverseCharge() bool {
	if m != nil {
		return m.VatReverseCharge
	}
	return false
}

func (m *Invoice) GetStatus() *Invoice_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Invoice) GetPayments() []*Invoice_Payment {
	if m != nil {
		return m.Payments
	}
	return nil
}

// A single item of the invoice
type Invoice_Item struct {
	// Identifiers of the UsageItems that this item covers.
	UsageitemIds []string `protobuf:"bytes,4,rep,name=usageitem_ids,json=usageitemIds,proto3" json:"usageitem_ids,omitempty"`
	// Amount of money (ex VAT) for this item
	Amount float32 `protobuf:"fixed32,2,opt,name=amount,proto3" json:"amount,omitempty"`
	// Human readable description of this item
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Invoice_Item) Reset()         { *m = Invoice_Item{} }
func (m *Invoice_Item) String() string { return proto.CompactTextString(m) }
func (*Invoice_Item) ProtoMessage()    {}
func (*Invoice_Item) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{0, 0}
}
func (m *Invoice_Item) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Invoice_Item) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Invoice_Item.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Invoice_Item) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Invoice_Item.Merge(m, src)
}
func (m *Invoice_Item) XXX_Size() int {
	return m.Size()
}
func (m *Invoice_Item) XXX_DiscardUnknown() {
	xxx_messageInfo_Invoice_Item.DiscardUnknown(m)
}

var xxx_messageInfo_Invoice_Item proto.InternalMessageInfo

func (m *Invoice_Item) GetUsageitemIds() []string {
	if m != nil {
		return m.UsageitemIds
	}
	return nil
}

func (m *Invoice_Item) GetAmount() float32 {
	if m != nil {
		return m.Amount
	}
	return 0
}

func (m *Invoice_Item) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Status of the invoice
type Invoice_Status struct {
	// If set, this invoice is still being processed.
	IsPending bool `protobuf:"varint,1,opt,name=is_pending,json=isPending,proto3" json:"is_pending,omitempty"`
	// If set, a successful payment has been made for this invoice.
	IsCompleted bool `protobuf:"varint,2,opt,name=is_completed,json=isCompleted,proto3" json:"is_completed,omitempty"`
	// If set, all payment attempts for this invoice have been rejected.
	IsRejected bool `protobuf:"varint,3,opt,name=is_rejected,json=isRejected,proto3" json:"is_rejected,omitempty"`
	// The timestamp of succesfull completion of the payment.
	// This field equals the completed_at field of the last payment if
	// that payment succeeded, nil otherwise.
	CompletedAt *types.Timestamp `protobuf:"bytes,10,opt,name=completed_at,json=completedAt,proto3" json:"completed_at,omitempty"`
	// The timestamp of rejected completion of the payment.
	// This field equals the rejected_at field of the last payment if
	// that payment failed, nil otherwise.
	RejectedAt           *types.Timestamp `protobuf:"bytes,11,opt,name=rejected_at,json=rejectedAt,proto3" json:"rejected_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Invoice_Status) Reset()         { *m = Invoice_Status{} }
func (m *Invoice_Status) String() string { return proto.CompactTextString(m) }
func (*Invoice_Status) ProtoMessage()    {}
func (*Invoice_Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{0, 1}
}
func (m *Invoice_Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Invoice_Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Invoice_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Invoice_Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Invoice_Status.Merge(m, src)
}
func (m *Invoice_Status) XXX_Size() int {
	return m.Size()
}
func (m *Invoice_Status) XXX_DiscardUnknown() {
	xxx_messageInfo_Invoice_Status.DiscardUnknown(m)
}

var xxx_messageInfo_Invoice_Status proto.InternalMessageInfo

func (m *Invoice_Status) GetIsPending() bool {
	if m != nil {
		return m.IsPending
	}
	return false
}

func (m *Invoice_Status) GetIsCompleted() bool {
	if m != nil {
		return m.IsCompleted
	}
	return false
}

func (m *Invoice_Status) GetIsRejected() bool {
	if m != nil {
		return m.IsRejected
	}
	return false
}

func (m *Invoice_Status) GetCompletedAt() *types.Timestamp {
	if m != nil {
		return m.CompletedAt
	}
	return nil
}

func (m *Invoice_Status) GetRejectedAt() *types.Timestamp {
	if m != nil {
		return m.RejectedAt
	}
	return nil
}

// Payment (attempt) of the invoice
type Invoice_Payment struct {
	// The timestamp of the start of the payment attempt.
	CreatedAt *types.Timestamp `protobuf:"bytes,1,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Identifier of the payment provider that is used for this payment.
	PaymentProviderId string `protobuf:"bytes,2,opt,name=payment_provider_id,json=paymentProviderId,proto3" json:"payment_provider_id,omitempty"`
	// Identifier of this payment (created by payment provider)
	PaymentId string `protobuf:"bytes,3,opt,name=payment_id,json=paymentId,proto3" json:"payment_id,omitempty"`
	// Identifier of the payment method that is used for this payment.
	PaymentMethodId string `protobuf:"bytes,4,opt,name=payment_method_id,json=paymentMethodId,proto3" json:"payment_method_id,omitempty"`
	// If set, this payment is still being processed.
	IsPending bool `protobuf:"varint,10,opt,name=is_pending,json=isPending,proto3" json:"is_pending,omitempty"`
	// If set, this payment has been payed for succesfully.
	IsCompleted bool `protobuf:"varint,11,opt,name=is_completed,json=isCompleted,proto3" json:"is_completed,omitempty"`
	// If set, this payment has been rejected.
	IsRejected bool `protobuf:"varint,12,opt,name=is_rejected,json=isRejected,proto3" json:"is_rejected,omitempty"`
	// The timestamp of succesfull completion of the payment.
	CompletedAt *types.Timestamp `protobuf:"bytes,20,opt,name=completed_at,json=completedAt,proto3" json:"completed_at,omitempty"`
	// The timestamp of rejected completion of the payment.
	RejectedAt *types.Timestamp `protobuf:"bytes,21,opt,name=rejected_at,json=rejectedAt,proto3" json:"rejected_at,omitempty"`
	// Human readable reason for the rejection.
	RejectionReason      string   `protobuf:"bytes,22,opt,name=rejection_reason,json=rejectionReason,proto3" json:"rejection_reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Invoice_Payment) Reset()         { *m = Invoice_Payment{} }
func (m *Invoice_Payment) String() string { return proto.CompactTextString(m) }
func (*Invoice_Payment) ProtoMessage()    {}
func (*Invoice_Payment) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{0, 2}
}
func (m *Invoice_Payment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Invoice_Payment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Invoice_Payment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Invoice_Payment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Invoice_Payment.Merge(m, src)
}
func (m *Invoice_Payment) XXX_Size() int {
	return m.Size()
}
func (m *Invoice_Payment) XXX_DiscardUnknown() {
	xxx_messageInfo_Invoice_Payment.DiscardUnknown(m)
}

var xxx_messageInfo_Invoice_Payment proto.InternalMessageInfo

func (m *Invoice_Payment) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Invoice_Payment) GetPaymentProviderId() string {
	if m != nil {
		return m.PaymentProviderId
	}
	return ""
}

func (m *Invoice_Payment) GetPaymentId() string {
	if m != nil {
		return m.PaymentId
	}
	return ""
}

func (m *Invoice_Payment) GetPaymentMethodId() string {
	if m != nil {
		return m.PaymentMethodId
	}
	return ""
}

func (m *Invoice_Payment) GetIsPending() bool {
	if m != nil {
		return m.IsPending
	}
	return false
}

func (m *Invoice_Payment) GetIsCompleted() bool {
	if m != nil {
		return m.IsCompleted
	}
	return false
}

func (m *Invoice_Payment) GetIsRejected() bool {
	if m != nil {
		return m.IsRejected
	}
	return false
}

func (m *Invoice_Payment) GetCompletedAt() *types.Timestamp {
	if m != nil {
		return m.CompletedAt
	}
	return nil
}

func (m *Invoice_Payment) GetRejectedAt() *types.Timestamp {
	if m != nil {
		return m.RejectedAt
	}
	return nil
}

func (m *Invoice_Payment) GetRejectionReason() string {
	if m != nil {
		return m.RejectionReason
	}
	return ""
}

// List of Invoices.
type InvoiceList struct {
	Items                []*Invoice `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *InvoiceList) Reset()         { *m = InvoiceList{} }
func (m *InvoiceList) String() string { return proto.CompactTextString(m) }
func (*InvoiceList) ProtoMessage()    {}
func (*InvoiceList) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{1}
}
func (m *InvoiceList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InvoiceList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InvoiceList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InvoiceList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InvoiceList.Merge(m, src)
}
func (m *InvoiceList) XXX_Size() int {
	return m.Size()
}
func (m *InvoiceList) XXX_DiscardUnknown() {
	xxx_messageInfo_InvoiceList.DiscardUnknown(m)
}

var xxx_messageInfo_InvoiceList proto.InternalMessageInfo

func (m *InvoiceList) GetItems() []*Invoice {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListInvoices
type ListInvoicesRequest struct {
	// Request invoices for the organization with this id.
	// This is a required field.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Request invoices that are created at or after this timestamp.
	// This is an optional field.
	From *types.Timestamp `protobuf:"bytes,2,opt,name=from,proto3" json:"from,omitempty"`
	// Request invoices that are created before this timestamp.
	// This is an optional field.
	To *types.Timestamp `protobuf:"bytes,3,opt,name=to,proto3" json:"to,omitempty"`
	// Standard list options
	// This is an optional field.
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListInvoicesRequest) Reset()         { *m = ListInvoicesRequest{} }
func (m *ListInvoicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInvoicesRequest) ProtoMessage()    {}
func (*ListInvoicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{2}
}
func (m *ListInvoicesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListInvoicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListInvoicesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListInvoicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInvoicesRequest.Merge(m, src)
}
func (m *ListInvoicesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListInvoicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInvoicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInvoicesRequest proto.InternalMessageInfo

func (m *ListInvoicesRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListInvoicesRequest) GetFrom() *types.Timestamp {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *ListInvoicesRequest) GetTo() *types.Timestamp {
	if m != nil {
		return m.To
	}
	return nil
}

func (m *ListInvoicesRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// Payment providers are services that handle payments.
type PaymentProvider struct {
	// System identifier of this payment provider.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the payment provider
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the payment provider
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Type of payment method supported by this provider
	Type                 string   `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PaymentProvider) Reset()         { *m = PaymentProvider{} }
func (m *PaymentProvider) String() string { return proto.CompactTextString(m) }
func (*PaymentProvider) ProtoMessage()    {}
func (*PaymentProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{3}
}
func (m *PaymentProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PaymentProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PaymentProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PaymentProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PaymentProvider.Merge(m, src)
}
func (m *PaymentProvider) XXX_Size() int {
	return m.Size()
}
func (m *PaymentProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_PaymentProvider.DiscardUnknown(m)
}

var xxx_messageInfo_PaymentProvider proto.InternalMessageInfo

func (m *PaymentProvider) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PaymentProvider) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PaymentProvider) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PaymentProvider) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

// List of Payment providers
type PaymentProviderList struct {
	Items                []*PaymentProvider `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PaymentProviderList) Reset()         { *m = PaymentProviderList{} }
func (m *PaymentProviderList) String() string { return proto.CompactTextString(m) }
func (*PaymentProviderList) ProtoMessage()    {}
func (*PaymentProviderList) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{4}
}
func (m *PaymentProviderList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PaymentProviderList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PaymentProviderList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PaymentProviderList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PaymentProviderList.Merge(m, src)
}
func (m *PaymentProviderList) XXX_Size() int {
	return m.Size()
}
func (m *PaymentProviderList) XXX_DiscardUnknown() {
	xxx_messageInfo_PaymentProviderList.DiscardUnknown(m)
}

var xxx_messageInfo_PaymentProviderList proto.InternalMessageInfo

func (m *PaymentProviderList) GetItems() []*PaymentProvider {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for PreparePaymentMethod.
type PreparePaymentMethodRequest struct {
	// ID of the provider to prepare
	ProviderId string `protobuf:"bytes,1,opt,name=provider_id,json=providerId,proto3" json:"provider_id,omitempty"`
	// ID of the organization that will own the future payment method
	OrganizationId       string   `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PreparePaymentMethodRequest) Reset()         { *m = PreparePaymentMethodRequest{} }
func (m *PreparePaymentMethodRequest) String() string { return proto.CompactTextString(m) }
func (*PreparePaymentMethodRequest) ProtoMessage()    {}
func (*PreparePaymentMethodRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{5}
}
func (m *PreparePaymentMethodRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PreparePaymentMethodRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PreparePaymentMethodRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PreparePaymentMethodRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreparePaymentMethodRequest.Merge(m, src)
}
func (m *PreparePaymentMethodRequest) XXX_Size() int {
	return m.Size()
}
func (m *PreparePaymentMethodRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PreparePaymentMethodRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PreparePaymentMethodRequest proto.InternalMessageInfo

func (m *PreparePaymentMethodRequest) GetProviderId() string {
	if m != nil {
		return m.ProviderId
	}
	return ""
}

func (m *PreparePaymentMethodRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

// Response data for PreparePaymentMethod.
type PreparedPaymentMethod struct {
	// ID of the provider of the future payment method
	ProviderId string `protobuf:"bytes,1,opt,name=provider_id,json=providerId,proto3" json:"provider_id,omitempty"`
	// ID of the organization that will own the future payment method
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Token (semantics depends on payment provider)
	Token string `protobuf:"bytes,11,opt,name=token,proto3" json:"token,omitempty"`
	// URL of custom script to load to create the payment method
	ScriptUrl string `protobuf:"bytes,12,opt,name=script_url,json=scriptUrl,proto3" json:"script_url,omitempty"`
	// Signature used to verify the consistency of the data in this message.
	Signature            string   `protobuf:"bytes,101,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PreparedPaymentMethod) Reset()         { *m = PreparedPaymentMethod{} }
func (m *PreparedPaymentMethod) String() string { return proto.CompactTextString(m) }
func (*PreparedPaymentMethod) ProtoMessage()    {}
func (*PreparedPaymentMethod) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{6}
}
func (m *PreparedPaymentMethod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PreparedPaymentMethod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PreparedPaymentMethod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PreparedPaymentMethod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreparedPaymentMethod.Merge(m, src)
}
func (m *PreparedPaymentMethod) XXX_Size() int {
	return m.Size()
}
func (m *PreparedPaymentMethod) XXX_DiscardUnknown() {
	xxx_messageInfo_PreparedPaymentMethod.DiscardUnknown(m)
}

var xxx_messageInfo_PreparedPaymentMethod proto.InternalMessageInfo

func (m *PreparedPaymentMethod) GetProviderId() string {
	if m != nil {
		return m.ProviderId
	}
	return ""
}

func (m *PreparedPaymentMethod) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *PreparedPaymentMethod) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *PreparedPaymentMethod) GetScriptUrl() string {
	if m != nil {
		return m.ScriptUrl
	}
	return ""
}

func (m *PreparedPaymentMethod) GetSignature() string {
	if m != nil {
		return m.Signature
	}
	return ""
}

// Request arguments for CreatePaymentMethod
type CreatePaymentMethodRequest struct {
	// The result of PreparePaymentMethod.
	PreparedPaymentMethod *PreparedPaymentMethod `protobuf:"bytes,1,opt,name=prepared_payment_method,json=preparedPaymentMethod,proto3" json:"prepared_payment_method,omitempty"`
	// First name of owner of payment method
	FirstName string `protobuf:"bytes,2,opt,name=first_name,json=firstName,proto3" json:"first_name,omitempty"`
	// Last name of owner of payment method
	LastName             string   `protobuf:"bytes,3,opt,name=last_name,json=lastName,proto3" json:"last_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreatePaymentMethodRequest) Reset()         { *m = CreatePaymentMethodRequest{} }
func (m *CreatePaymentMethodRequest) String() string { return proto.CompactTextString(m) }
func (*CreatePaymentMethodRequest) ProtoMessage()    {}
func (*CreatePaymentMethodRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{7}
}
func (m *CreatePaymentMethodRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreatePaymentMethodRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreatePaymentMethodRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreatePaymentMethodRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreatePaymentMethodRequest.Merge(m, src)
}
func (m *CreatePaymentMethodRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreatePaymentMethodRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreatePaymentMethodRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreatePaymentMethodRequest proto.InternalMessageInfo

func (m *CreatePaymentMethodRequest) GetPreparedPaymentMethod() *PreparedPaymentMethod {
	if m != nil {
		return m.PreparedPaymentMethod
	}
	return nil
}

func (m *CreatePaymentMethodRequest) GetFirstName() string {
	if m != nil {
		return m.FirstName
	}
	return ""
}

func (m *CreatePaymentMethodRequest) GetLastName() string {
	if m != nil {
		return m.LastName
	}
	return ""
}

// Request arguments for ListPaymentProviders
type ListPaymentProvidersRequest struct {
	// Identifier of the organization for which payment providers are requested.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Optional common list options. (Context ID is ignored)
	Options              *v1.ListOptions `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListPaymentProvidersRequest) Reset()         { *m = ListPaymentProvidersRequest{} }
func (m *ListPaymentProvidersRequest) String() string { return proto.CompactTextString(m) }
func (*ListPaymentProvidersRequest) ProtoMessage()    {}
func (*ListPaymentProvidersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{8}
}
func (m *ListPaymentProvidersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPaymentProvidersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPaymentProvidersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPaymentProvidersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPaymentProvidersRequest.Merge(m, src)
}
func (m *ListPaymentProvidersRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListPaymentProvidersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPaymentProvidersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPaymentProvidersRequest proto.InternalMessageInfo

func (m *ListPaymentProvidersRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListPaymentProvidersRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// Payment methods are specific methods for paying at a specific payment provider
// such as a specific credit card.
type PaymentMethod struct {
	// System identifier of this payment method.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the payment method
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the payment method
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the payment provider used for this payment method
	// This is a read-only field.
	PaymentProviderId string `protobuf:"bytes,4,opt,name=payment_provider_id,json=paymentProviderId,proto3" json:"payment_provider_id,omitempty"`
	// Identifier of the organization that owns this payment method
	// This is a read-only field.
	OrganizationId string `protobuf:"bytes,5,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Creation timestamp of this payment method
	// This is a read-only field.
	CreatedAt *types.Timestamp `protobuf:"bytes,10,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Deletion timestamp of this payment method
	// This is a read-only field.
	DeletedAt *types.Timestamp `protobuf:"bytes,11,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set if the payment method is deleted.
	// This is a read-only field.
	IsDeleted bool `protobuf:"varint,12,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// If set, this timestamp specifies when the payment method is no longer valid.
	// If not set, there is no (known) end date for this payment method.
	ValidUntil *types.Timestamp `protobuf:"bytes,13,opt,name=valid_until,json=validUntil,proto3" json:"valid_until,omitempty"`
	// Token for this payment method, provided by the payment provider.
	// This is a read-only field.
	Token string `protobuf:"bytes,14,opt,name=token,proto3" json:"token,omitempty"`
	// Type of payment method
	Type string `protobuf:"bytes,15,opt,name=type,proto3" json:"type,omitempty"`
	// If set, this payment method is the default for its organization.
	// This is a read-only field.
	IsDefault            bool                          `protobuf:"varint,16,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	CreditCardInfo       *PaymentMethod_CreditCardInfo `protobuf:"bytes,101,opt,name=credit_card_info,json=creditCardInfo,proto3" json:"credit_card_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PaymentMethod) Reset()         { *m = PaymentMethod{} }
func (m *PaymentMethod) String() string { return proto.CompactTextString(m) }
func (*PaymentMethod) ProtoMessage()    {}
func (*PaymentMethod) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{9}
}
func (m *PaymentMethod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PaymentMethod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PaymentMethod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PaymentMethod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PaymentMethod.Merge(m, src)
}
func (m *PaymentMethod) XXX_Size() int {
	return m.Size()
}
func (m *PaymentMethod) XXX_DiscardUnknown() {
	xxx_messageInfo_PaymentMethod.DiscardUnknown(m)
}

var xxx_messageInfo_PaymentMethod proto.InternalMessageInfo

func (m *PaymentMethod) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PaymentMethod) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PaymentMethod) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PaymentMethod) GetPaymentProviderId() string {
	if m != nil {
		return m.PaymentProviderId
	}
	return ""
}

func (m *PaymentMethod) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *PaymentMethod) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *PaymentMethod) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *PaymentMethod) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *PaymentMethod) GetValidUntil() *types.Timestamp {
	if m != nil {
		return m.ValidUntil
	}
	return nil
}

func (m *PaymentMethod) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *PaymentMethod) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *PaymentMethod) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *PaymentMethod) GetCreditCardInfo() *PaymentMethod_CreditCardInfo {
	if m != nil {
		return m.CreditCardInfo
	}
	return nil
}

// Information of the creditcard.
// Only set when type == "creditcard"
type PaymentMethod_CreditCardInfo struct {
	// Last 4 digits of the CC number.
	LastDigits string `protobuf:"bytes,1,opt,name=last_digits,json=lastDigits,proto3" json:"last_digits,omitempty"`
	// Type of creditcard
	CardType             string   `protobuf:"bytes,2,opt,name=card_type,json=cardType,proto3" json:"card_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PaymentMethod_CreditCardInfo) Reset()         { *m = PaymentMethod_CreditCardInfo{} }
func (m *PaymentMethod_CreditCardInfo) String() string { return proto.CompactTextString(m) }
func (*PaymentMethod_CreditCardInfo) ProtoMessage()    {}
func (*PaymentMethod_CreditCardInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{9, 0}
}
func (m *PaymentMethod_CreditCardInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PaymentMethod_CreditCardInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PaymentMethod_CreditCardInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PaymentMethod_CreditCardInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PaymentMethod_CreditCardInfo.Merge(m, src)
}
func (m *PaymentMethod_CreditCardInfo) XXX_Size() int {
	return m.Size()
}
func (m *PaymentMethod_CreditCardInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_PaymentMethod_CreditCardInfo.DiscardUnknown(m)
}

var xxx_messageInfo_PaymentMethod_CreditCardInfo proto.InternalMessageInfo

func (m *PaymentMethod_CreditCardInfo) GetLastDigits() string {
	if m != nil {
		return m.LastDigits
	}
	return ""
}

func (m *PaymentMethod_CreditCardInfo) GetCardType() string {
	if m != nil {
		return m.CardType
	}
	return ""
}

// List of Payment methods
type PaymentMethodList struct {
	Items                []*PaymentMethod `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *PaymentMethodList) Reset()         { *m = PaymentMethodList{} }
func (m *PaymentMethodList) String() string { return proto.CompactTextString(m) }
func (*PaymentMethodList) ProtoMessage()    {}
func (*PaymentMethodList) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{10}
}
func (m *PaymentMethodList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PaymentMethodList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PaymentMethodList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PaymentMethodList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PaymentMethodList.Merge(m, src)
}
func (m *PaymentMethodList) XXX_Size() int {
	return m.Size()
}
func (m *PaymentMethodList) XXX_DiscardUnknown() {
	xxx_messageInfo_PaymentMethodList.DiscardUnknown(m)
}

var xxx_messageInfo_PaymentMethodList proto.InternalMessageInfo

func (m *PaymentMethodList) GetItems() []*PaymentMethod {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListPaymentMethods
type ListPaymentMethodsRequest struct {
	// Identifier of the organization for which payment methods are requested.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Optional common list options. (Context ID is ignored)
	Options              *v1.ListOptions `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListPaymentMethodsRequest) Reset()         { *m = ListPaymentMethodsRequest{} }
func (m *ListPaymentMethodsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPaymentMethodsRequest) ProtoMessage()    {}
func (*ListPaymentMethodsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{11}
}
func (m *ListPaymentMethodsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPaymentMethodsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPaymentMethodsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPaymentMethodsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPaymentMethodsRequest.Merge(m, src)
}
func (m *ListPaymentMethodsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListPaymentMethodsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPaymentMethodsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPaymentMethodsRequest proto.InternalMessageInfo

func (m *ListPaymentMethodsRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListPaymentMethodsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// Request argument for SetDefaultPaymentMethod
type SetDefaultPaymentMethodRequest struct {
	// Identifier of the organization for which the default payment method will be set.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Identifier of the new default payment method for the organization.
	PaymentMethodId      string   `protobuf:"bytes,2,opt,name=payment_method_id,json=paymentMethodId,proto3" json:"payment_method_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetDefaultPaymentMethodRequest) Reset()         { *m = SetDefaultPaymentMethodRequest{} }
func (m *SetDefaultPaymentMethodRequest) String() string { return proto.CompactTextString(m) }
func (*SetDefaultPaymentMethodRequest) ProtoMessage()    {}
func (*SetDefaultPaymentMethodRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{12}
}
func (m *SetDefaultPaymentMethodRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SetDefaultPaymentMethodRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SetDefaultPaymentMethodRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SetDefaultPaymentMethodRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetDefaultPaymentMethodRequest.Merge(m, src)
}
func (m *SetDefaultPaymentMethodRequest) XXX_Size() int {
	return m.Size()
}
func (m *SetDefaultPaymentMethodRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetDefaultPaymentMethodRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetDefaultPaymentMethodRequest proto.InternalMessageInfo

func (m *SetDefaultPaymentMethodRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *SetDefaultPaymentMethodRequest) GetPaymentMethodId() string {
	if m != nil {
		return m.PaymentMethodId
	}
	return ""
}

// Address of organization
type Address struct {
	// Address lines
	Address []string `protobuf:"bytes,1,rep,name=address,proto3" json:"address,omitempty"`
	// ZIP code (if any)
	Zipcode string `protobuf:"bytes,2,opt,name=zipcode,proto3" json:"zipcode,omitempty"`
	// City
	City string `protobuf:"bytes,3,opt,name=city,proto3" json:"city,omitempty"`
	// State
	// For US, this must be an ISO 3166-2 2-letter state code
	// See https://en.wikipedia.org/wiki/List_of_U.S._state_abbreviations
	State string `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
	// Country code
	CountryCode          string   `protobuf:"bytes,5,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Address) Reset()         { *m = Address{} }
func (m *Address) String() string { return proto.CompactTextString(m) }
func (*Address) ProtoMessage()    {}
func (*Address) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{13}
}
func (m *Address) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Address) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Address.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Address) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Address.Merge(m, src)
}
func (m *Address) XXX_Size() int {
	return m.Size()
}
func (m *Address) XXX_DiscardUnknown() {
	xxx_messageInfo_Address.DiscardUnknown(m)
}

var xxx_messageInfo_Address proto.InternalMessageInfo

func (m *Address) GetAddress() []string {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Address) GetZipcode() string {
	if m != nil {
		return m.Zipcode
	}
	return ""
}

func (m *Address) GetCity() string {
	if m != nil {
		return m.City
	}
	return ""
}

func (m *Address) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *Address) GetCountryCode() string {
	if m != nil {
		return m.CountryCode
	}
	return ""
}

// Billing configuration for an organization
type BillingConfig struct {
	// Address of the organization
	Address *Address `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// EU VAT number of the organization (if any)
	VatNumber string `protobuf:"bytes,2,opt,name=vat_number,json=vatNumber,proto3" json:"vat_number,omitempty"`
	// Email address(es) to send emails related to billing (mostly invoices) to.
	EmailAddresses []string `protobuf:"bytes,3,rep,name=email_addresses,json=emailAddresses,proto3" json:"email_addresses,omitempty"`
	// US sales tax number of the organization (if any)
	UsTaxNumber          string   `protobuf:"bytes,4,opt,name=us_tax_number,json=usTaxNumber,proto3" json:"us_tax_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BillingConfig) Reset()         { *m = BillingConfig{} }
func (m *BillingConfig) String() string { return proto.CompactTextString(m) }
func (*BillingConfig) ProtoMessage()    {}
func (*BillingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{14}
}
func (m *BillingConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BillingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BillingConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BillingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BillingConfig.Merge(m, src)
}
func (m *BillingConfig) XXX_Size() int {
	return m.Size()
}
func (m *BillingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_BillingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_BillingConfig proto.InternalMessageInfo

func (m *BillingConfig) GetAddress() *Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *BillingConfig) GetVatNumber() string {
	if m != nil {
		return m.VatNumber
	}
	return ""
}

func (m *BillingConfig) GetEmailAddresses() []string {
	if m != nil {
		return m.EmailAddresses
	}
	return nil
}

func (m *BillingConfig) GetUsTaxNumber() string {
	if m != nil {
		return m.UsTaxNumber
	}
	return ""
}

// Request arguments for SetBillingConfig.
type SetBillingConfigRequest struct {
	// Identifier of the organization for which billing address is to be set.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Billing configuration to set.
	Config               *BillingConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *SetBillingConfigRequest) Reset()         { *m = SetBillingConfigRequest{} }
func (m *SetBillingConfigRequest) String() string { return proto.CompactTextString(m) }
func (*SetBillingConfigRequest) ProtoMessage()    {}
func (*SetBillingConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_958db8ba491a6b57, []int{15}
}
func (m *SetBillingConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SetBillingConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SetBillingConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SetBillingConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetBillingConfigRequest.Merge(m, src)
}
func (m *SetBillingConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *SetBillingConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetBillingConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetBillingConfigRequest proto.InternalMessageInfo

func (m *SetBillingConfigRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *SetBillingConfigRequest) GetConfig() *BillingConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func init() {
	proto.RegisterType((*Invoice)(nil), "arangodb.cloud.billing.v1.Invoice")
	proto.RegisterType((*Invoice_Item)(nil), "arangodb.cloud.billing.v1.Invoice.Item")
	proto.RegisterType((*Invoice_Status)(nil), "arangodb.cloud.billing.v1.Invoice.Status")
	proto.RegisterType((*Invoice_Payment)(nil), "arangodb.cloud.billing.v1.Invoice.Payment")
	proto.RegisterType((*InvoiceList)(nil), "arangodb.cloud.billing.v1.InvoiceList")
	proto.RegisterType((*ListInvoicesRequest)(nil), "arangodb.cloud.billing.v1.ListInvoicesRequest")
	proto.RegisterType((*PaymentProvider)(nil), "arangodb.cloud.billing.v1.PaymentProvider")
	proto.RegisterType((*PaymentProviderList)(nil), "arangodb.cloud.billing.v1.PaymentProviderList")
	proto.RegisterType((*PreparePaymentMethodRequest)(nil), "arangodb.cloud.billing.v1.PreparePaymentMethodRequest")
	proto.RegisterType((*PreparedPaymentMethod)(nil), "arangodb.cloud.billing.v1.PreparedPaymentMethod")
	proto.RegisterType((*CreatePaymentMethodRequest)(nil), "arangodb.cloud.billing.v1.CreatePaymentMethodRequest")
	proto.RegisterType((*ListPaymentProvidersRequest)(nil), "arangodb.cloud.billing.v1.ListPaymentProvidersRequest")
	proto.RegisterType((*PaymentMethod)(nil), "arangodb.cloud.billing.v1.PaymentMethod")
	proto.RegisterType((*PaymentMethod_CreditCardInfo)(nil), "arangodb.cloud.billing.v1.PaymentMethod.CreditCardInfo")
	proto.RegisterType((*PaymentMethodList)(nil), "arangodb.cloud.billing.v1.PaymentMethodList")
	proto.RegisterType((*ListPaymentMethodsRequest)(nil), "arangodb.cloud.billing.v1.ListPaymentMethodsRequest")
	proto.RegisterType((*SetDefaultPaymentMethodRequest)(nil), "arangodb.cloud.billing.v1.SetDefaultPaymentMethodRequest")
	proto.RegisterType((*Address)(nil), "arangodb.cloud.billing.v1.Address")
	proto.RegisterType((*BillingConfig)(nil), "arangodb.cloud.billing.v1.BillingConfig")
	proto.RegisterType((*SetBillingConfigRequest)(nil), "arangodb.cloud.billing.v1.SetBillingConfigRequest")
}

func init() { proto.RegisterFile("billing.proto", fileDescriptor_958db8ba491a6b57) }

var fileDescriptor_958db8ba491a6b57 = []byte{
	// 1916 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0xcd, 0x6f, 0x1c, 0x49,
	0x15, 0xa7, 0xc6, 0x8e, 0xed, 0x79, 0xe3, 0xaf, 0x94, 0xf3, 0xd1, 0x3b, 0xd9, 0x38, 0xa6, 0x23,
	0x13, 0xc7, 0xd9, 0xf4, 0xac, 0x0d, 0xbb, 0x4b, 0x12, 0x42, 0x32, 0x71, 0x22, 0x6b, 0x24, 0xc8,
	0x5a, 0xed, 0x04, 0x24, 0x2e, 0xad, 0x72, 0x77, 0x79, 0x52, 0xec, 0xf4, 0xc7, 0x76, 0xd7, 0x8c,
	0xe2, 0x5d, 0x72, 0x41, 0x20, 0x10, 0x07, 0x2e, 0xcb, 0x01, 0x8e, 0x9c, 0x10, 0xf7, 0xbd, 0x70,
	0x42, 0x02, 0x09, 0x36, 0x37, 0x24, 0x8e, 0x70, 0x40, 0x01, 0x89, 0x7f, 0x82, 0x03, 0xaa, 0x57,
	0xd5, 0xe3, 0x99, 0x49, 0x7b, 0x3e, 0x92, 0x48, 0x7b, 0xeb, 0x7e, 0xef, 0xd5, 0xab, 0xf7, 0x7e,
	0xef, 0xb3, 0x67, 0x60, 0xe1, 0x40, 0xb4, 0x5a, 0x22, 0x6a, 0x3a, 0x49, 0x1a, 0xcb, 0x98, 0xbe,
	0xc5, 0x52, 0x16, 0x35, 0xe3, 0xe0, 0xc0, 0xf1, 0x5b, 0x71, 0x3b, 0x70, 0x72, 0x6e, 0x67, 0xab,
	0x7a, 0xce, 0x8f, 0xc3, 0x30, 0x8e, 0x6a, 0x9d, 0xad, 0x9a, 0x7e, 0xd2, 0x47, 0xaa, 0xb7, 0x9a,
	0x42, 0x3e, 0x69, 0x1f, 0x38, 0x7e, 0x1c, 0xd6, 0x9a, 0x71, 0x8b, 0x45, 0xcd, 0x1a, 0x32, 0x0e,
	0xda, 0x87, 0xb5, 0x44, 0x1e, 0x25, 0x3c, 0xab, 0x49, 0x11, 0xf2, 0x4c, 0xb2, 0x30, 0x39, 0x7e,
	0x32, 0x87, 0xdf, 0x6e, 0xc6, 0x71, 0xb3, 0xc5, 0x6b, 0x2c, 0x11, 0x35, 0x16, 0x45, 0xb1, 0x64,
	0x52, 0xc4, 0x51, 0xa6, 0xb9, 0xf6, 0x3f, 0x2b, 0x30, 0xdb, 0x88, 0x3a, 0xb1, 0xf0, 0x39, 0x5d,
	0x84, 0x92, 0x08, 0x2c, 0xb2, 0x46, 0x36, 0xca, 0x6e, 0x49, 0x04, 0x74, 0x19, 0xa6, 0xda, 0x69,
	0xcb, 0x2a, 0x21, 0x41, 0x3d, 0xd2, 0x2b, 0xb0, 0x14, 0xa7, 0x4d, 0x16, 0x89, 0x4f, 0x50, 0x89,
	0x27, 0x02, 0x6b, 0x0a, 0xb9, 0x8b, 0xbd, 0xe4, 0x46, 0x40, 0xaf, 0xc1, 0xe9, 0x3e, 0xc1, 0x88,
	0x85, 0xdc, 0x9a, 0x46, 0xd1, 0xe5, 0x5e, 0xc6, 0x43, 0x16, 0x72, 0x7a, 0x01, 0xca, 0x3c, 0x92,
	0x42, 0x1e, 0x29, 0x7d, 0xa7, 0x50, 0x68, 0x4e, 0x13, 0x1a, 0x01, 0xbd, 0x04, 0x15, 0xc3, 0x44,
	0x1d, 0x33, 0xc8, 0x06, 0x4d, 0xc2, 0xd3, 0xeb, 0xb0, 0x28, 0xb4, 0x03, 0x5e, 0xd4, 0x0e, 0x0f,
	0x78, 0x6a, 0xcd, 0xa2, 0xcc, 0x82, 0xa1, 0x3e, 0x44, 0x22, 0xbd, 0x01, 0xe0, 0xa7, 0x9c, 0x49,
	0x1e, 0x78, 0x4c, 0x5a, 0xb0, 0x46, 0x36, 0x2a, 0xdb, 0x55, 0x47, 0x63, 0xe3, 0xe4, 0x68, 0x3a,
	0x8f, 0x72, 0xf0, 0xdc, 0xb2, 0x91, 0xae, 0x4b, 0x7a, 0x1b, 0x4e, 0x09, 0xc9, 0xc3, 0xcc, 0x0a,
	0xd6, 0xa6, 0x36, 0x2a, 0xdb, 0x57, 0x9c, 0x13, 0x23, 0xe8, 0x18, 0x28, 0x9d, 0x86, 0xe4, 0xa1,
	0xab, 0x4f, 0x29, 0x0f, 0xfc, 0x76, 0x9a, 0xf2, 0xc8, 0x47, 0x07, 0x23, 0xed, 0x41, 0x4e, 0x6a,
	0x04, 0x74, 0x0b, 0xce, 0xca, 0x58, 0xb2, 0x96, 0xc7, 0xc2, 0xb8, 0x1d, 0x49, 0x8f, 0x3f, 0xf5,
	0x5b, 0x5e, 0x87, 0x49, 0x2b, 0x5e, 0x23, 0x1b, 0x25, 0x97, 0x22, 0xb3, 0x8e, 0xbc, 0x07, 0x4f,
	0xfd, 0xd6, 0xf7, 0x98, 0x54, 0x90, 0xe9, 0x23, 0x4a, 0x2c, 0x41, 0xb1, 0x39, 0x24, 0x28, 0xe6,
	0xa0, 0x3e, 0x11, 0x19, 0x7d, 0x1f, 0xbf, 0xa4, 0xaf, 0x11, 0x69, 0x7d, 0xef, 0x00, 0xed, 0x30,
	0xe9, 0xa5, 0xbc, 0xc3, 0xd3, 0x8c, 0x7b, 0xfe, 0x13, 0x96, 0x36, 0xb9, 0x95, 0xae, 0x91, 0x8d,
	0x39, 0x77, 0xb9, 0xc3, 0xa4, 0xab, 0x19, 0x3b, 0x48, 0xa7, 0xf7, 0x60, 0x26, 0x93, 0x4c, 0xb6,
	0x33, 0xeb, 0x0b, 0x82, 0x40, 0x5e, 0x1d, 0x03, 0x92, 0x7d, 0x3c, 0xe1, 0x9a, 0x93, 0x74, 0x17,
	0xe6, 0x12, 0x76, 0x14, 0xf2, 0x48, 0x66, 0xd6, 0x73, 0x82, 0xc0, 0x6e, 0x8e, 0xa1, 0x65, 0x4f,
	0x9f, 0x71, 0xbb, 0x87, 0xab, 0x1c, 0xa6, 0x15, 0xda, 0xf4, 0x32, 0x2c, 0xb4, 0x33, 0xd6, 0xe4,
	0x0a, 0x74, 0x4f, 0x04, 0x99, 0x35, 0xbd, 0x36, 0xb5, 0x51, 0x76, 0xe7, 0xbb, 0xc4, 0x46, 0x90,
	0xd1, 0x73, 0x30, 0xa3, 0x41, 0xc1, 0xac, 0x2e, 0xb9, 0xe6, 0x8d, 0xae, 0x41, 0x25, 0xe0, 0x99,
	0x9f, 0x8a, 0x44, 0x65, 0xa5, 0x49, 0xea, 0x5e, 0x52, 0xf5, 0xbf, 0x04, 0x66, 0xb4, 0x0b, 0xf4,
	0x22, 0x80, 0xc8, 0xbc, 0x84, 0x47, 0x81, 0x88, 0x9a, 0x58, 0x2f, 0x73, 0x6e, 0x59, 0x64, 0x7b,
	0x9a, 0x40, 0xbf, 0x0a, 0xf3, 0x22, 0xf3, 0xfc, 0x38, 0x4c, 0x5a, 0x5c, 0xf2, 0x00, 0x6f, 0x9a,
	0x73, 0x2b, 0x22, 0xdb, 0xc9, 0x49, 0x2a, 0x25, 0x44, 0xe6, 0xa5, 0xfc, 0x87, 0xdc, 0x57, 0x12,
	0x53, 0x28, 0x01, 0x22, 0x73, 0x0d, 0x85, 0xde, 0x86, 0xf9, 0xae, 0x82, 0xf1, 0xf2, 0xb5, 0xd2,
	0x95, 0xaf, 0x4b, 0x7a, 0x0b, 0x2a, 0xb9, 0x72, 0x75, 0xba, 0x32, 0xf2, 0x34, 0xe4, 0xe2, 0x75,
	0x59, 0x7d, 0x3e, 0x05, 0xb3, 0x06, 0xe6, 0x81, 0xaa, 0x21, 0x93, 0x54, 0x8d, 0x03, 0x2b, 0x26,
	0x46, 0x5e, 0x92, 0xc6, 0x1d, 0x11, 0xf0, 0x54, 0xa5, 0xbf, 0xee, 0x26, 0xa7, 0x0d, 0x6b, 0xcf,
	0x70, 0x1a, 0x81, 0x42, 0x35, 0x97, 0xef, 0xb6, 0x95, 0xb2, 0xa1, 0x34, 0x02, 0xba, 0x09, 0xf9,
	0x19, 0x2f, 0xe4, 0xf2, 0x49, 0x1c, 0x28, 0x29, 0xdd, 0x51, 0x96, 0x0c, 0xe3, 0xbb, 0x48, 0xd7,
	0xaa, 0x7a, 0x02, 0x04, 0xa3, 0x02, 0x54, 0x19, 0x19, 0xa0, 0xf9, 0x91, 0x01, 0x3a, 0xf3, 0x5a,
	0x01, 0x3a, 0x3b, 0x49, 0x80, 0xe8, 0x55, 0x58, 0xd6, 0x6f, 0xaa, 0xb3, 0xa6, 0x9c, 0x65, 0x71,
	0x64, 0x9d, 0xd3, 0x48, 0x74, 0xe9, 0x2e, 0x92, 0xed, 0x5d, 0xa8, 0x98, 0xca, 0xf9, 0x8e, 0xc8,
	0x24, 0xfd, 0x66, 0xde, 0xc9, 0x74, 0xc1, 0xd9, 0xa3, 0x0b, 0xce, 0x34, 0x31, 0xfb, 0x1f, 0x04,
	0x56, 0x94, 0x0a, 0x43, 0xce, 0x5c, 0xfe, 0x71, 0x9b, 0x67, 0xb2, 0x68, 0x22, 0x90, 0xc2, 0x89,
	0xe0, 0xc0, 0xf4, 0x61, 0x1a, 0x87, 0x18, 0xff, 0xe1, 0xae, 0xa2, 0x1c, 0xdd, 0x84, 0x92, 0x8c,
	0x31, 0x0d, 0x86, 0x4b, 0x97, 0x64, 0x4c, 0xef, 0xc0, 0x6c, 0x8c, 0x55, 0x9a, 0x99, 0x42, 0x59,
	0x1f, 0x74, 0xcc, 0x8c, 0xd3, 0xce, 0x96, 0xa3, 0x9c, 0xf8, 0x50, 0x0b, 0xbb, 0xf9, 0x29, 0xfb,
	0x23, 0x58, 0xda, 0xeb, 0x4f, 0xc8, 0x97, 0x86, 0x21, 0x85, 0x69, 0x1c, 0x40, 0x3a, 0x7f, 0xf1,
	0x79, 0x74, 0xd7, 0x50, 0xa7, 0xd4, 0x7c, 0x36, 0x89, 0x8a, 0xcf, 0xf6, 0xf7, 0x61, 0x65, 0xe0,
	0x32, 0x8c, 0xcd, 0xdd, 0xfe, 0xd8, 0x0c, 0x6b, 0x86, 0x03, 0xc7, 0xf3, 0x18, 0x35, 0xe1, 0xc2,
	0x5e, 0xca, 0x13, 0x96, 0xf2, 0xbd, 0xde, 0x82, 0xc8, 0x43, 0x75, 0x09, 0x2a, 0xbd, 0x85, 0xa8,
	0x5d, 0x83, 0xe4, 0xb8, 0x02, 0x0b, 0x62, 0x59, 0x2a, 0x8a, 0xa5, 0xfd, 0x39, 0x81, 0xb3, 0xe6,
	0xa6, 0xa0, 0xef, 0xaa, 0x37, 0x77, 0x07, 0x3d, 0x03, 0xa7, 0x64, 0xfc, 0x11, 0x8f, 0xb0, 0x3a,
	0xcb, 0xae, 0x7e, 0x51, 0x95, 0xad, 0xc1, 0xf5, 0xd4, 0x66, 0x32, 0xaf, 0x9b, 0x84, 0xa6, 0x3c,
	0x4e, 0x5b, 0xf4, 0x6d, 0x28, 0x67, 0xa2, 0x19, 0x31, 0xd9, 0x4e, 0xb9, 0xc5, 0x0d, 0x37, 0x27,
	0xd8, 0x7f, 0x22, 0x50, 0xdd, 0xc1, 0xfe, 0x54, 0x88, 0xcf, 0x13, 0x38, 0x9f, 0x18, 0xa7, 0xbc,
	0xfe, 0x56, 0x63, 0x1a, 0xdf, 0xbb, 0xc3, 0x42, 0x52, 0x04, 0x87, 0x7b, 0x36, 0x29, 0x44, 0xe9,
	0x22, 0xc0, 0xa1, 0x48, 0x33, 0xe9, 0xf5, 0x64, 0x54, 0x19, 0x29, 0xf9, 0x3e, 0xd4, 0x62, 0x39,
	0x57, 0x27, 0xd5, 0x9c, 0x22, 0x28, 0xa6, 0xfd, 0x33, 0x02, 0x17, 0x54, 0xbe, 0x0c, 0xe4, 0xc0,
	0xe4, 0x05, 0xd9, 0x53, 0x34, 0xa5, 0x57, 0x2a, 0x9a, 0xff, 0x4d, 0xc3, 0x42, 0xbf, 0x5f, 0x6f,
	0xa6, 0x66, 0x4e, 0x18, 0x1c, 0xd3, 0x27, 0x0d, 0x8e, 0x02, 0x8f, 0x4f, 0x15, 0x7a, 0xfc, 0x1a,
	0x2b, 0xe0, 0x0d, 0x80, 0x80, 0x77, 0x9b, 0xfd, 0xe8, 0x79, 0x5a, 0x36, 0xd2, 0x75, 0x69, 0x86,
	0x91, 0x79, 0x37, 0x93, 0xa4, 0x2c, 0xb2, 0xfb, 0x9a, 0xa0, 0x26, 0x41, 0x87, 0xb5, 0x44, 0xe0,
	0xb5, 0x23, 0x29, 0x5a, 0xd6, 0xc2, 0xe8, 0x49, 0x80, 0xe2, 0x8f, 0x95, 0xf4, 0x71, 0x91, 0x2c,
	0xf6, 0x16, 0x49, 0xde, 0x74, 0x96, 0x8e, 0x9b, 0x4e, 0xd7, 0x8a, 0x43, 0xd6, 0x6e, 0x49, 0x6b,
	0xf9, 0xd8, 0x0a, 0x24, 0x50, 0x06, 0xcb, 0x7e, 0xca, 0x03, 0x21, 0x3d, 0x9f, 0xa5, 0x81, 0x27,
	0xa2, 0xc3, 0x18, 0xeb, 0xa7, 0xb2, 0xfd, 0xc1, 0xe8, 0x3e, 0xa4, 0xa3, 0xef, 0xec, 0xa0, 0x82,
	0x1d, 0x96, 0x06, 0x8d, 0xe8, 0x30, 0x76, 0x17, 0xfd, 0xbe, 0xf7, 0xea, 0x43, 0x58, 0xec, 0x97,
	0x50, 0xcd, 0x02, 0xf3, 0x3c, 0x10, 0x4d, 0x21, 0xb3, 0xbc, 0x59, 0x28, 0xd2, 0x7d, 0xa4, 0xa8,
	0x42, 0x40, 0x73, 0xd0, 0x1b, 0x9d, 0x44, 0x73, 0x8a, 0xf0, 0x48, 0xb5, 0xd1, 0x7d, 0x38, 0xdd,
	0x77, 0x3f, 0x36, 0xd1, 0x6f, 0xf7, 0x37, 0xd1, 0x8d, 0x71, 0x8d, 0xcf, 0x5b, 0xe8, 0x4f, 0x09,
	0xbc, 0xd5, 0x53, 0x5d, 0x9a, 0xf9, 0x25, 0xd4, 0x56, 0x1b, 0x56, 0xf7, 0xb9, 0x34, 0xd1, 0x29,
	0xec, 0x56, 0x63, 0xdb, 0x52, 0xb8, 0x38, 0x95, 0x0a, 0x17, 0x27, 0xfb, 0x17, 0x04, 0x66, 0xeb,
	0x41, 0x90, 0xf2, 0x2c, 0xa3, 0x16, 0xcc, 0x32, 0xfd, 0x88, 0x60, 0x96, 0xdd, 0xfc, 0x55, 0x71,
	0x3e, 0x11, 0x89, 0x1f, 0x07, 0x79, 0x50, 0xf2, 0x57, 0x95, 0x79, 0xbe, 0x90, 0x47, 0xa6, 0xaa,
	0xf1, 0x59, 0xe5, 0xa8, 0x5a, 0xf9, 0xf3, 0x19, 0xa8, 0x5f, 0xd4, 0x0e, 0xe6, 0xab, 0xcd, 0x3b,
	0x3d, 0xf2, 0x50, 0x91, 0xae, 0xd8, 0x8a, 0xa1, 0xed, 0xc4, 0x01, 0xb7, 0xff, 0x40, 0x60, 0xe1,
	0x9e, 0x8e, 0xd7, 0x4e, 0x1c, 0x1d, 0x8a, 0x26, 0xfd, 0x56, 0xaf, 0x49, 0x64, 0xc4, 0x02, 0x63,
	0xfc, 0x38, 0x36, 0xfb, 0x22, 0x80, 0xfa, 0xc6, 0x31, 0x1f, 0x89, 0xa6, 0xeb, 0x76, 0x98, 0x34,
	0x1f, 0x88, 0x57, 0x60, 0x89, 0x87, 0x4c, 0xb4, 0x3c, 0x23, 0xcf, 0x33, 0x6b, 0x0a, 0xfd, 0x5e,
	0x44, 0x72, 0x3d, 0xa7, 0x52, 0x5b, 0x7d, 0x68, 0x78, 0x92, 0x3d, 0xcd, 0x55, 0x69, 0xc7, 0x2a,
	0xed, 0xec, 0x11, 0x7b, 0xaa, 0x95, 0xd9, 0x3f, 0x21, 0x70, 0x7e, 0x9f, 0xcb, 0x3e, 0xf3, 0x27,
	0x8e, 0xdc, 0x5d, 0x98, 0xf1, 0xf1, 0xa4, 0x49, 0xa2, 0x61, 0xd9, 0xdc, 0x7f, 0x93, 0x39, 0xb7,
	0xfd, 0x39, 0x85, 0x45, 0xc3, 0xd9, 0xe7, 0x69, 0x47, 0x7d, 0xe4, 0xff, 0x8e, 0xc0, 0x7c, 0xef,
	0x22, 0x47, 0x9d, 0x21, 0x5a, 0x0b, 0x36, 0xbe, 0xea, 0xd7, 0x46, 0x2f, 0x8d, 0xea, 0x98, 0x7d,
	0xe7, 0xc7, 0x7f, 0xff, 0xcf, 0x67, 0xa5, 0x1b, 0xf4, 0x03, 0xfc, 0xe5, 0xc1, 0x08, 0xd5, 0x3a,
	0x5b, 0xb5, 0x5e, 0x2f, 0x6b, 0x9f, 0x0e, 0x40, 0xf1, 0xac, 0x26, 0x72, 0xc3, 0x7e, 0x04, 0xb0,
	0xcb, 0xf3, 0xeb, 0xe9, 0xe5, 0x93, 0x2b, 0xa8, 0x71, 0xdf, 0xd4, 0x4f, 0x75, 0x8c, 0x85, 0xd6,
	0x5e, 0x47, 0xbb, 0x2e, 0xd1, 0x8b, 0x83, 0x76, 0xe5, 0x17, 0xd7, 0x3e, 0x15, 0xc1, 0x33, 0xfa,
	0x57, 0x02, 0x67, 0x8a, 0xe6, 0x2c, 0x7d, 0x7f, 0x04, 0x5e, 0x27, 0x0c, 0xe6, 0xaa, 0x33, 0xfe,
	0x42, 0x87, 0xf8, 0xed, 0xa2, 0x9d, 0x75, 0x7a, 0x67, 0x42, 0xfc, 0x4c, 0x4d, 0x27, 0x5d, 0x83,
	0x7f, 0x45, 0x80, 0xee, 0xf2, 0x41, 0xbb, 0xc6, 0x03, 0x74, 0x82, 0x2d, 0xd4, 0xbe, 0x8e, 0x06,
	0x5f, 0xa1, 0xeb, 0x83, 0x06, 0x0f, 0x5a, 0xa4, 0x01, 0xfe, 0x23, 0x01, 0xfa, 0x72, 0xab, 0xa5,
	0xdf, 0x18, 0x0f, 0xde, 0xfe, 0xce, 0x5c, 0x7d, 0x67, 0xdc, 0x46, 0x8f, 0xd0, 0x3e, 0x40, 0x4b,
	0xef, 0xd0, 0xdb, 0xaf, 0x06, 0x6d, 0x68, 0x4c, 0xfd, 0x25, 0x81, 0xe5, 0x63, 0x60, 0xcd, 0x0e,
	0x34, 0x16, 0xac, 0x63, 0xcf, 0x25, 0xfb, 0x1a, 0x9a, 0xba, 0x4e, 0x2f, 0x9f, 0x00, 0xaa, 0xb1,
	0x45, 0x43, 0xfa, 0x67, 0x02, 0x67, 0x8a, 0xbe, 0x00, 0x86, 0xe6, 0xec, 0x90, 0x4f, 0x86, 0xea,
	0xc4, 0x1b, 0xaf, 0x5d, 0x47, 0x7b, 0x6f, 0xd9, 0xef, 0x8f, 0x4e, 0x82, 0x9e, 0xe5, 0xee, 0x59,
	0xcd, 0x2c, 0xca, 0x37, 0xc9, 0x26, 0xfd, 0x2d, 0x81, 0x95, 0x82, 0x35, 0x9d, 0xbe, 0x37, 0xc4,
	0x98, 0x93, 0xd7, 0xfa, 0x09, 0xb0, 0xbe, 0x8a, 0xb6, 0x5f, 0xb6, 0x57, 0x87, 0x63, 0xad, 0x6c,
	0xfc, 0x0d, 0x81, 0x95, 0xc7, 0x49, 0xf0, 0x92, 0x8d, 0x63, 0x5f, 0x36, 0x81, 0x59, 0x0e, 0x9a,
	0xb5, 0x51, 0x1d, 0x27, 0x05, 0x94, 0x6d, 0x3f, 0x27, 0xb0, 0xa2, 0xb7, 0xcb, 0x57, 0xc8, 0xcc,
	0x4b, 0x27, 0x0b, 0x3d, 0x08, 0x13, 0x79, 0x94, 0x27, 0xe4, 0xe6, 0x58, 0x09, 0xf9, 0x7b, 0x02,
	0xe7, 0x77, 0x8b, 0xf7, 0x98, 0x37, 0x5d, 0x28, 0x63, 0x8e, 0x1b, 0x95, 0x6b, 0x66, 0x0b, 0xbe,
	0xde, 0x67, 0x31, 0xfd, 0x8b, 0x1e, 0xd9, 0x85, 0xb6, 0xde, 0x18, 0x62, 0xc6, 0xf0, 0x3d, 0x6d,
	0x34, 0xa0, 0x1f, 0xa2, 0xe1, 0x8d, 0xea, 0xfd, 0x09, 0x9b, 0x51, 0xa1, 0x17, 0x2a, 0xfe, 0x9f,
	0xe9, 0xb6, 0xd4, 0xbf, 0x3a, 0xbd, 0x36, 0xda, 0x7d, 0xea, 0xec, 0x77, 0xd1, 0xe8, 0x4d, 0xba,
	0x31, 0x1a, 0x6d, 0xbd, 0x8a, 0xa8, 0x54, 0x58, 0x1e, 0xdc, 0x88, 0xe8, 0xf6, 0x70, 0x5c, 0x8b,
	0xd6, 0xa7, 0xd1, 0x80, 0xde, 0x45, 0xdb, 0x6e, 0x56, 0xdf, 0x9b, 0x10, 0x50, 0x6d, 0xe8, 0x4d,
	0xb2, 0x79, 0xef, 0xf6, 0x17, 0x2f, 0x56, 0xc9, 0xdf, 0x5e, 0xac, 0x92, 0x7f, 0xbd, 0x58, 0x25,
	0xbf, 0xfe, 0xf7, 0xea, 0x57, 0x7e, 0x70, 0xad, 0xe7, 0x1f, 0x98, 0xfc, 0xfa, 0xeb, 0x21, 0x8b,
	0x58, 0x93, 0x07, 0xea, 0x9a, 0xac, 0xe7, 0x9e, 0x83, 0x19, 0xfc, 0x6a, 0xfb, 0xfa, 0xff, 0x03,
	0x00, 0x00, 0xff, 0xff, 0xcd, 0xe9, 0xb5, 0x55, 0xf9, 0x19, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BillingServiceClient is the client API for BillingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BillingServiceClient interface {
	// Fetch all Invoice resources for the organization identified by the given
	// organization ID that match the given criteria.
	// Required permissions:
	// - billing.invoice.list on the organization identified by the given organization ID
	ListInvoices(ctx context.Context, in *ListInvoicesRequest, opts ...grpc.CallOption) (*InvoiceList, error)
	// Fetch a specific Invoice identified by the given ID.
	// Required permissions:
	// - billing.invoice.get on the organization that owns the invoice
	//   with given ID.
	GetInvoice(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Invoice, error)
	// Fetch all payment providers that are usable for the organization identified
	// by the given context ID.
	// Required permissions:
	// - billing.paymentprovider.list on the organization identified by the given context ID
	ListPaymentProviders(ctx context.Context, in *ListPaymentProvidersRequest, opts ...grpc.CallOption) (*PaymentProviderList, error)
	// Fetch a specific payment provider identified by the given ID.
	// Required permissions:
	// - None
	GetPaymentProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*PaymentProvider, error)
	// Fetch all payment methods that are configured for the organization identified
	// by the given context ID.
	// Required permissions:
	// - billing.paymentmethod.list on the organization identified by the given context ID
	ListPaymentMethods(ctx context.Context, in *ListPaymentMethodsRequest, opts ...grpc.CallOption) (*PaymentMethodList, error)
	// Fetch a specific payment method identified by the given ID.
	// Required permissions:
	// - billing.paymentmethod.get on the organization that owns the payment method
	//   which is identified by the given ID
	GetPaymentMethod(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*PaymentMethod, error)
	// Prepare the payment provider for creating a new payment method.
	// Required permissions:
	// - billing.paymentmethod.create on the organization that owns future payment method.
	PreparePaymentMethod(ctx context.Context, in *PreparePaymentMethodRequest, opts ...grpc.CallOption) (*PreparedPaymentMethod, error)
	// Create a new payment method.
	// Required permissions:
	// - billing.paymentmethod.create on the organization that owns the given payment method.
	CreatePaymentMethod(ctx context.Context, in *CreatePaymentMethodRequest, opts ...grpc.CallOption) (*PaymentMethod, error)
	// Update a specific payment method.
	// Note that only name, description & valid period are updated.
	// Required permissions:
	// - billing.paymentmethod.update on the organization that owns the given payment method.
	UpdatePaymentMethod(ctx context.Context, in *PaymentMethod, opts ...grpc.CallOption) (*PaymentMethod, error)
	// Delete a specific payment method identified by the given ID.
	// Required permissions:
	// - billing.paymentmethod.delete on the organization that owns the given payment method
	//   which is identified by the given ID.
	DeletePaymentMethod(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch the default PaymentMethod for an organization identified by the given ID.
	// Required permissions:
	// - billing.paymentmethod.get-default on the organization that is identified by the given ID
	GetDefaultPaymentMethod(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*PaymentMethod, error)
	// Update the default PaymentMethod for an organization identified by the
	// given organization ID, to the payment method identified by the given payment method ID.
	// Required permissions:
	// - billing.paymentmethod.set-default on the organization identified by the given organization ID
	SetDefaultPaymentMethod(ctx context.Context, in *SetDefaultPaymentMethodRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch the billing configuration of an organization identified by the given ID.
	// Required permissions:
	// - billing.config.get on the organization that is identified by the given ID
	GetBillingConfig(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*BillingConfig, error)
	// Update the billing configuration for an organization identified by the
	// given organization ID.
	// Required permissions:
	// - billing.config.set on the organization identified by the given organization ID
	SetBillingConfig(ctx context.Context, in *SetBillingConfigRequest, opts ...grpc.CallOption) (*v1.Empty, error)
}

type billingServiceClient struct {
	cc *grpc.ClientConn
}

func NewBillingServiceClient(cc *grpc.ClientConn) BillingServiceClient {
	return &billingServiceClient{cc}
}

func (c *billingServiceClient) ListInvoices(ctx context.Context, in *ListInvoicesRequest, opts ...grpc.CallOption) (*InvoiceList, error) {
	out := new(InvoiceList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/ListInvoices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) GetInvoice(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Invoice, error) {
	out := new(Invoice)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/GetInvoice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) ListPaymentProviders(ctx context.Context, in *ListPaymentProvidersRequest, opts ...grpc.CallOption) (*PaymentProviderList, error) {
	out := new(PaymentProviderList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/ListPaymentProviders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) GetPaymentProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*PaymentProvider, error) {
	out := new(PaymentProvider)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/GetPaymentProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) ListPaymentMethods(ctx context.Context, in *ListPaymentMethodsRequest, opts ...grpc.CallOption) (*PaymentMethodList, error) {
	out := new(PaymentMethodList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/ListPaymentMethods", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) GetPaymentMethod(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*PaymentMethod, error) {
	out := new(PaymentMethod)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/GetPaymentMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) PreparePaymentMethod(ctx context.Context, in *PreparePaymentMethodRequest, opts ...grpc.CallOption) (*PreparedPaymentMethod, error) {
	out := new(PreparedPaymentMethod)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/PreparePaymentMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) CreatePaymentMethod(ctx context.Context, in *CreatePaymentMethodRequest, opts ...grpc.CallOption) (*PaymentMethod, error) {
	out := new(PaymentMethod)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/CreatePaymentMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) UpdatePaymentMethod(ctx context.Context, in *PaymentMethod, opts ...grpc.CallOption) (*PaymentMethod, error) {
	out := new(PaymentMethod)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/UpdatePaymentMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) DeletePaymentMethod(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/DeletePaymentMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) GetDefaultPaymentMethod(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*PaymentMethod, error) {
	out := new(PaymentMethod)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/GetDefaultPaymentMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) SetDefaultPaymentMethod(ctx context.Context, in *SetDefaultPaymentMethodRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/SetDefaultPaymentMethod", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) GetBillingConfig(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*BillingConfig, error) {
	out := new(BillingConfig)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/GetBillingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingServiceClient) SetBillingConfig(ctx context.Context, in *SetBillingConfigRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.billing.v1.BillingService/SetBillingConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BillingServiceServer is the server API for BillingService service.
type BillingServiceServer interface {
	// Fetch all Invoice resources for the organization identified by the given
	// organization ID that match the given criteria.
	// Required permissions:
	// - billing.invoice.list on the organization identified by the given organization ID
	ListInvoices(context.Context, *ListInvoicesRequest) (*InvoiceList, error)
	// Fetch a specific Invoice identified by the given ID.
	// Required permissions:
	// - billing.invoice.get on the organization that owns the invoice
	//   with given ID.
	GetInvoice(context.Context, *v1.IDOptions) (*Invoice, error)
	// Fetch all payment providers that are usable for the organization identified
	// by the given context ID.
	// Required permissions:
	// - billing.paymentprovider.list on the organization identified by the given context ID
	ListPaymentProviders(context.Context, *ListPaymentProvidersRequest) (*PaymentProviderList, error)
	// Fetch a specific payment provider identified by the given ID.
	// Required permissions:
	// - None
	GetPaymentProvider(context.Context, *v1.IDOptions) (*PaymentProvider, error)
	// Fetch all payment methods that are configured for the organization identified
	// by the given context ID.
	// Required permissions:
	// - billing.paymentmethod.list on the organization identified by the given context ID
	ListPaymentMethods(context.Context, *ListPaymentMethodsRequest) (*PaymentMethodList, error)
	// Fetch a specific payment method identified by the given ID.
	// Required permissions:
	// - billing.paymentmethod.get on the organization that owns the payment method
	//   which is identified by the given ID
	GetPaymentMethod(context.Context, *v1.IDOptions) (*PaymentMethod, error)
	// Prepare the payment provider for creating a new payment method.
	// Required permissions:
	// - billing.paymentmethod.create on the organization that owns future payment method.
	PreparePaymentMethod(context.Context, *PreparePaymentMethodRequest) (*PreparedPaymentMethod, error)
	// Create a new payment method.
	// Required permissions:
	// - billing.paymentmethod.create on the organization that owns the given payment method.
	CreatePaymentMethod(context.Context, *CreatePaymentMethodRequest) (*PaymentMethod, error)
	// Update a specific payment method.
	// Note that only name, description & valid period are updated.
	// Required permissions:
	// - billing.paymentmethod.update on the organization that owns the given payment method.
	UpdatePaymentMethod(context.Context, *PaymentMethod) (*PaymentMethod, error)
	// Delete a specific payment method identified by the given ID.
	// Required permissions:
	// - billing.paymentmethod.delete on the organization that owns the given payment method
	//   which is identified by the given ID.
	DeletePaymentMethod(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch the default PaymentMethod for an organization identified by the given ID.
	// Required permissions:
	// - billing.paymentmethod.get-default on the organization that is identified by the given ID
	GetDefaultPaymentMethod(context.Context, *v1.IDOptions) (*PaymentMethod, error)
	// Update the default PaymentMethod for an organization identified by the
	// given organization ID, to the payment method identified by the given payment method ID.
	// Required permissions:
	// - billing.paymentmethod.set-default on the organization identified by the given organization ID
	SetDefaultPaymentMethod(context.Context, *SetDefaultPaymentMethodRequest) (*v1.Empty, error)
	// Fetch the billing configuration of an organization identified by the given ID.
	// Required permissions:
	// - billing.config.get on the organization that is identified by the given ID
	GetBillingConfig(context.Context, *v1.IDOptions) (*BillingConfig, error)
	// Update the billing configuration for an organization identified by the
	// given organization ID.
	// Required permissions:
	// - billing.config.set on the organization identified by the given organization ID
	SetBillingConfig(context.Context, *SetBillingConfigRequest) (*v1.Empty, error)
}

// UnimplementedBillingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBillingServiceServer struct {
}

func (*UnimplementedBillingServiceServer) ListInvoices(ctx context.Context, req *ListInvoicesRequest) (*InvoiceList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInvoices not implemented")
}
func (*UnimplementedBillingServiceServer) GetInvoice(ctx context.Context, req *v1.IDOptions) (*Invoice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInvoice not implemented")
}
func (*UnimplementedBillingServiceServer) ListPaymentProviders(ctx context.Context, req *ListPaymentProvidersRequest) (*PaymentProviderList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPaymentProviders not implemented")
}
func (*UnimplementedBillingServiceServer) GetPaymentProvider(ctx context.Context, req *v1.IDOptions) (*PaymentProvider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPaymentProvider not implemented")
}
func (*UnimplementedBillingServiceServer) ListPaymentMethods(ctx context.Context, req *ListPaymentMethodsRequest) (*PaymentMethodList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPaymentMethods not implemented")
}
func (*UnimplementedBillingServiceServer) GetPaymentMethod(ctx context.Context, req *v1.IDOptions) (*PaymentMethod, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPaymentMethod not implemented")
}
func (*UnimplementedBillingServiceServer) PreparePaymentMethod(ctx context.Context, req *PreparePaymentMethodRequest) (*PreparedPaymentMethod, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PreparePaymentMethod not implemented")
}
func (*UnimplementedBillingServiceServer) CreatePaymentMethod(ctx context.Context, req *CreatePaymentMethodRequest) (*PaymentMethod, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePaymentMethod not implemented")
}
func (*UnimplementedBillingServiceServer) UpdatePaymentMethod(ctx context.Context, req *PaymentMethod) (*PaymentMethod, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePaymentMethod not implemented")
}
func (*UnimplementedBillingServiceServer) DeletePaymentMethod(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePaymentMethod not implemented")
}
func (*UnimplementedBillingServiceServer) GetDefaultPaymentMethod(ctx context.Context, req *v1.IDOptions) (*PaymentMethod, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultPaymentMethod not implemented")
}
func (*UnimplementedBillingServiceServer) SetDefaultPaymentMethod(ctx context.Context, req *SetDefaultPaymentMethodRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultPaymentMethod not implemented")
}
func (*UnimplementedBillingServiceServer) GetBillingConfig(ctx context.Context, req *v1.IDOptions) (*BillingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBillingConfig not implemented")
}
func (*UnimplementedBillingServiceServer) SetBillingConfig(ctx context.Context, req *SetBillingConfigRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetBillingConfig not implemented")
}

func RegisterBillingServiceServer(s *grpc.Server, srv BillingServiceServer) {
	s.RegisterService(&_BillingService_serviceDesc, srv)
}

func _BillingService_ListInvoices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInvoicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).ListInvoices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/ListInvoices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).ListInvoices(ctx, req.(*ListInvoicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_GetInvoice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).GetInvoice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/GetInvoice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).GetInvoice(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_ListPaymentProviders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPaymentProvidersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).ListPaymentProviders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/ListPaymentProviders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).ListPaymentProviders(ctx, req.(*ListPaymentProvidersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_GetPaymentProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).GetPaymentProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/GetPaymentProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).GetPaymentProvider(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_ListPaymentMethods_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPaymentMethodsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).ListPaymentMethods(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/ListPaymentMethods",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).ListPaymentMethods(ctx, req.(*ListPaymentMethodsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_GetPaymentMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).GetPaymentMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/GetPaymentMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).GetPaymentMethod(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_PreparePaymentMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PreparePaymentMethodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).PreparePaymentMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/PreparePaymentMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).PreparePaymentMethod(ctx, req.(*PreparePaymentMethodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_CreatePaymentMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePaymentMethodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).CreatePaymentMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/CreatePaymentMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).CreatePaymentMethod(ctx, req.(*CreatePaymentMethodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_UpdatePaymentMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PaymentMethod)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).UpdatePaymentMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/UpdatePaymentMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).UpdatePaymentMethod(ctx, req.(*PaymentMethod))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_DeletePaymentMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).DeletePaymentMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/DeletePaymentMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).DeletePaymentMethod(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_GetDefaultPaymentMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).GetDefaultPaymentMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/GetDefaultPaymentMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).GetDefaultPaymentMethod(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_SetDefaultPaymentMethod_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultPaymentMethodRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).SetDefaultPaymentMethod(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/SetDefaultPaymentMethod",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).SetDefaultPaymentMethod(ctx, req.(*SetDefaultPaymentMethodRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_GetBillingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).GetBillingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/GetBillingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).GetBillingConfig(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingService_SetBillingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetBillingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingServiceServer).SetBillingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.billing.v1.BillingService/SetBillingConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingServiceServer).SetBillingConfig(ctx, req.(*SetBillingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BillingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.billing.v1.BillingService",
	HandlerType: (*BillingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInvoices",
			Handler:    _BillingService_ListInvoices_Handler,
		},
		{
			MethodName: "GetInvoice",
			Handler:    _BillingService_GetInvoice_Handler,
		},
		{
			MethodName: "ListPaymentProviders",
			Handler:    _BillingService_ListPaymentProviders_Handler,
		},
		{
			MethodName: "GetPaymentProvider",
			Handler:    _BillingService_GetPaymentProvider_Handler,
		},
		{
			MethodName: "ListPaymentMethods",
			Handler:    _BillingService_ListPaymentMethods_Handler,
		},
		{
			MethodName: "GetPaymentMethod",
			Handler:    _BillingService_GetPaymentMethod_Handler,
		},
		{
			MethodName: "PreparePaymentMethod",
			Handler:    _BillingService_PreparePaymentMethod_Handler,
		},
		{
			MethodName: "CreatePaymentMethod",
			Handler:    _BillingService_CreatePaymentMethod_Handler,
		},
		{
			MethodName: "UpdatePaymentMethod",
			Handler:    _BillingService_UpdatePaymentMethod_Handler,
		},
		{
			MethodName: "DeletePaymentMethod",
			Handler:    _BillingService_DeletePaymentMethod_Handler,
		},
		{
			MethodName: "GetDefaultPaymentMethod",
			Handler:    _BillingService_GetDefaultPaymentMethod_Handler,
		},
		{
			MethodName: "SetDefaultPaymentMethod",
			Handler:    _BillingService_SetDefaultPaymentMethod_Handler,
		},
		{
			MethodName: "GetBillingConfig",
			Handler:    _BillingService_GetBillingConfig_Handler,
		},
		{
			MethodName: "SetBillingConfig",
			Handler:    _BillingService_SetBillingConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "billing.proto",
}

func (m *Invoice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Invoice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Invoice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Payments) > 0 {
		for iNdEx := len(m.Payments) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Payments[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBilling(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xc
			i--
			dAtA[i] = 0xca
		}
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xc2
	}
	if m.VatReverseCharge {
		i--
		if m.VatReverseCharge {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x7
		i--
		dAtA[i] = 0x90
	}
	if m.TotalAmountInclVat != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TotalAmountInclVat))))
		i--
		dAtA[i] = 0x7
		i--
		dAtA[i] = 0x8d
	}
	if m.TotalVat != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TotalVat))))
		i--
		dAtA[i] = 0x7
		i--
		dAtA[i] = 0x85
	}
	if m.TotalAmountExclVat != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.TotalAmountExclVat))))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xfd
	}
	if len(m.CurrencyId) > 0 {
		i -= len(m.CurrencyId)
		copy(dAtA[i:], m.CurrencyId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.CurrencyId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xf2
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBilling(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xa2
		}
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.InvoiceNumber) > 0 {
		i -= len(m.InvoiceNumber)
		copy(dAtA[i:], m.InvoiceNumber)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.InvoiceNumber)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.EntityName) > 0 {
		i -= len(m.EntityName)
		copy(dAtA[i:], m.EntityName)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.EntityName)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.EntityId) > 0 {
		i -= len(m.EntityId)
		copy(dAtA[i:], m.EntityId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.EntityId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.OrganizationName) > 0 {
		i -= len(m.OrganizationName)
		copy(dAtA[i:], m.OrganizationName)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Invoice_Item) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Invoice_Item) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Invoice_Item) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.UsageitemIds) > 0 {
		for iNdEx := len(m.UsageitemIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.UsageitemIds[iNdEx])
			copy(dAtA[i:], m.UsageitemIds[iNdEx])
			i = encodeVarintBilling(dAtA, i, uint64(len(m.UsageitemIds[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Amount != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Amount))))
		i--
		dAtA[i] = 0x15
	}
	return len(dAtA) - i, nil
}

func (m *Invoice_Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Invoice_Status) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Invoice_Status) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RejectedAt != nil {
		{
			size, err := m.RejectedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.CompletedAt != nil {
		{
			size, err := m.CompletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.IsRejected {
		i--
		if m.IsRejected {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.IsCompleted {
		i--
		if m.IsCompleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.IsPending {
		i--
		if m.IsPending {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Invoice_Payment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Invoice_Payment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Invoice_Payment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RejectionReason) > 0 {
		i -= len(m.RejectionReason)
		copy(dAtA[i:], m.RejectionReason)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.RejectionReason)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.RejectedAt != nil {
		{
			size, err := m.RejectedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.CompletedAt != nil {
		{
			size, err := m.CompletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.IsRejected {
		i--
		if m.IsRejected {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.IsCompleted {
		i--
		if m.IsCompleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if m.IsPending {
		i--
		if m.IsPending {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if len(m.PaymentMethodId) > 0 {
		i -= len(m.PaymentMethodId)
		copy(dAtA[i:], m.PaymentMethodId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.PaymentMethodId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.PaymentId) > 0 {
		i -= len(m.PaymentId)
		copy(dAtA[i:], m.PaymentId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.PaymentId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.PaymentProviderId) > 0 {
		i -= len(m.PaymentProviderId)
		copy(dAtA[i:], m.PaymentProviderId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.PaymentProviderId)))
		i--
		dAtA[i] = 0x12
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InvoiceList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InvoiceList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InvoiceList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBilling(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListInvoicesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListInvoicesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListInvoicesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.To != nil {
		{
			size, err := m.To.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.From != nil {
		{
			size, err := m.From.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PaymentProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PaymentProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PaymentProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PaymentProviderList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PaymentProviderList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PaymentProviderList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBilling(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PreparePaymentMethodRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PreparePaymentMethodRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PreparePaymentMethodRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProviderId) > 0 {
		i -= len(m.ProviderId)
		copy(dAtA[i:], m.ProviderId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.ProviderId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PreparedPaymentMethod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PreparedPaymentMethod) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PreparedPaymentMethod) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Signature) > 0 {
		i -= len(m.Signature)
		copy(dAtA[i:], m.Signature)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Signature)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.ScriptUrl) > 0 {
		i -= len(m.ScriptUrl)
		copy(dAtA[i:], m.ScriptUrl)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.ScriptUrl)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProviderId) > 0 {
		i -= len(m.ProviderId)
		copy(dAtA[i:], m.ProviderId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.ProviderId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CreatePaymentMethodRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreatePaymentMethodRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreatePaymentMethodRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LastName) > 0 {
		i -= len(m.LastName)
		copy(dAtA[i:], m.LastName)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.LastName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.FirstName) > 0 {
		i -= len(m.FirstName)
		copy(dAtA[i:], m.FirstName)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.FirstName)))
		i--
		dAtA[i] = 0x12
	}
	if m.PreparedPaymentMethod != nil {
		{
			size, err := m.PreparedPaymentMethod.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListPaymentProvidersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPaymentProvidersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPaymentProvidersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PaymentMethod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PaymentMethod) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PaymentMethod) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CreditCardInfo != nil {
		{
			size, err := m.CreditCardInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x7a
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0x72
	}
	if m.ValidUntil != nil {
		{
			size, err := m.ValidUntil.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.PaymentProviderId) > 0 {
		i -= len(m.PaymentProviderId)
		copy(dAtA[i:], m.PaymentProviderId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.PaymentProviderId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PaymentMethod_CreditCardInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PaymentMethod_CreditCardInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PaymentMethod_CreditCardInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CardType) > 0 {
		i -= len(m.CardType)
		copy(dAtA[i:], m.CardType)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.CardType)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.LastDigits) > 0 {
		i -= len(m.LastDigits)
		copy(dAtA[i:], m.LastDigits)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.LastDigits)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PaymentMethodList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PaymentMethodList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PaymentMethodList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintBilling(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListPaymentMethodsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPaymentMethodsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPaymentMethodsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SetDefaultPaymentMethodRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetDefaultPaymentMethodRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SetDefaultPaymentMethodRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PaymentMethodId) > 0 {
		i -= len(m.PaymentMethodId)
		copy(dAtA[i:], m.PaymentMethodId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.PaymentMethodId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Address) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Address) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Address) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CountryCode) > 0 {
		i -= len(m.CountryCode)
		copy(dAtA[i:], m.CountryCode)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.CountryCode)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.State) > 0 {
		i -= len(m.State)
		copy(dAtA[i:], m.State)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.State)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.City) > 0 {
		i -= len(m.City)
		copy(dAtA[i:], m.City)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.City)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Zipcode) > 0 {
		i -= len(m.Zipcode)
		copy(dAtA[i:], m.Zipcode)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.Zipcode)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Address) > 0 {
		for iNdEx := len(m.Address) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Address[iNdEx])
			copy(dAtA[i:], m.Address[iNdEx])
			i = encodeVarintBilling(dAtA, i, uint64(len(m.Address[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *BillingConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BillingConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BillingConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.UsTaxNumber) > 0 {
		i -= len(m.UsTaxNumber)
		copy(dAtA[i:], m.UsTaxNumber)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.UsTaxNumber)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.EmailAddresses) > 0 {
		for iNdEx := len(m.EmailAddresses) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EmailAddresses[iNdEx])
			copy(dAtA[i:], m.EmailAddresses[iNdEx])
			i = encodeVarintBilling(dAtA, i, uint64(len(m.EmailAddresses[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.VatNumber) > 0 {
		i -= len(m.VatNumber)
		copy(dAtA[i:], m.VatNumber)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.VatNumber)))
		i--
		dAtA[i] = 0x12
	}
	if m.Address != nil {
		{
			size, err := m.Address.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SetBillingConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetBillingConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SetBillingConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintBilling(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintBilling(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintBilling(dAtA []byte, offset int, v uint64) int {
	offset -= sovBilling(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Invoice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.OrganizationName)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.EntityId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.EntityName)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.InvoiceNumber)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 2 + l + sovBilling(uint64(l))
		}
	}
	l = len(m.CurrencyId)
	if l > 0 {
		n += 2 + l + sovBilling(uint64(l))
	}
	if m.TotalAmountExclVat != 0 {
		n += 6
	}
	if m.TotalVat != 0 {
		n += 6
	}
	if m.TotalAmountInclVat != 0 {
		n += 6
	}
	if m.VatReverseCharge {
		n += 3
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 2 + l + sovBilling(uint64(l))
	}
	if len(m.Payments) > 0 {
		for _, e := range m.Payments {
			l = e.Size()
			n += 2 + l + sovBilling(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Invoice_Item) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Amount != 0 {
		n += 5
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if len(m.UsageitemIds) > 0 {
		for _, s := range m.UsageitemIds {
			l = len(s)
			n += 1 + l + sovBilling(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Invoice_Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IsPending {
		n += 2
	}
	if m.IsCompleted {
		n += 2
	}
	if m.IsRejected {
		n += 2
	}
	if m.CompletedAt != nil {
		l = m.CompletedAt.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.RejectedAt != nil {
		l = m.RejectedAt.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Invoice_Payment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.PaymentProviderId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.PaymentId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.PaymentMethodId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.IsPending {
		n += 2
	}
	if m.IsCompleted {
		n += 2
	}
	if m.IsRejected {
		n += 2
	}
	if m.CompletedAt != nil {
		l = m.CompletedAt.Size()
		n += 2 + l + sovBilling(uint64(l))
	}
	if m.RejectedAt != nil {
		l = m.RejectedAt.Size()
		n += 2 + l + sovBilling(uint64(l))
	}
	l = len(m.RejectionReason)
	if l > 0 {
		n += 2 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InvoiceList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovBilling(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListInvoicesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.From != nil {
		l = m.From.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.To != nil {
		l = m.To.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PaymentProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PaymentProviderList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovBilling(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PreparePaymentMethodRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProviderId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PreparedPaymentMethod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProviderId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.ScriptUrl)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Signature)
	if l > 0 {
		n += 2 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CreatePaymentMethodRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PreparedPaymentMethod != nil {
		l = m.PreparedPaymentMethod.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.FirstName)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.LastName)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListPaymentProvidersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PaymentMethod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.PaymentProviderId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.ValidUntil != nil {
		l = m.ValidUntil.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.IsDefault {
		n += 3
	}
	if m.CreditCardInfo != nil {
		l = m.CreditCardInfo.Size()
		n += 2 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PaymentMethod_CreditCardInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.LastDigits)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.CardType)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PaymentMethodList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovBilling(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListPaymentMethodsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SetDefaultPaymentMethodRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.PaymentMethodId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Address) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Address) > 0 {
		for _, s := range m.Address {
			l = len(s)
			n += 1 + l + sovBilling(uint64(l))
		}
	}
	l = len(m.Zipcode)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.City)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.CountryCode)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BillingConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	l = len(m.VatNumber)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if len(m.EmailAddresses) > 0 {
		for _, s := range m.EmailAddresses {
			l = len(s)
			n += 1 + l + sovBilling(uint64(l))
		}
	}
	l = len(m.UsTaxNumber)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SetBillingConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovBilling(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovBilling(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozBilling(x uint64) (n int) {
	return sovBilling(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Invoice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Invoice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Invoice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntityId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EntityId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntityName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EntityName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InvoiceNumber", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InvoiceNumber = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Invoice_Item{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 110:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrencyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrencyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 111:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalAmountExclVat", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.TotalAmountExclVat = float32(math.Float32frombits(v))
		case 112:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalVat", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.TotalVat = float32(math.Float32frombits(v))
		case 113:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalAmountInclVat", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.TotalAmountInclVat = float32(math.Float32frombits(v))
		case 114:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VatReverseCharge", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.VatReverseCharge = bool(v != 0)
		case 200:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &Invoice_Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 201:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payments = append(m.Payments, &Invoice_Payment{})
			if err := m.Payments[len(m.Payments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Invoice_Item) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Item: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Item: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Amount", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Amount = float32(math.Float32frombits(v))
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsageitemIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UsageitemIds = append(m.UsageitemIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Invoice_Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsPending", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsPending = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsCompleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsCompleted = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRejected", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRejected = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletedAt == nil {
				m.CompletedAt = &types.Timestamp{}
			}
			if err := m.CompletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RejectedAt == nil {
				m.RejectedAt = &types.Timestamp{}
			}
			if err := m.RejectedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Invoice_Payment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Payment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Payment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PaymentProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PaymentProviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PaymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PaymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PaymentMethodId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PaymentMethodId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsPending", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsPending = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsCompleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsCompleted = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRejected", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRejected = bool(v != 0)
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CompletedAt == nil {
				m.CompletedAt = &types.Timestamp{}
			}
			if err := m.CompletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RejectedAt == nil {
				m.RejectedAt = &types.Timestamp{}
			}
			if err := m.RejectedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectionReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RejectionReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InvoiceList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InvoiceList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InvoiceList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Invoice{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListInvoicesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListInvoicesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListInvoicesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.From == nil {
				m.From = &types.Timestamp{}
			}
			if err := m.From.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = &types.Timestamp{}
			}
			if err := m.To.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PaymentProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PaymentProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PaymentProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PaymentProviderList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PaymentProviderList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PaymentProviderList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &PaymentProvider{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PreparePaymentMethodRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PreparePaymentMethodRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PreparePaymentMethodRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PreparedPaymentMethod) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PreparedPaymentMethod: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PreparedPaymentMethod: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScriptUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScriptUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Signature", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Signature = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreatePaymentMethodRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreatePaymentMethodRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreatePaymentMethodRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreparedPaymentMethod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PreparedPaymentMethod == nil {
				m.PreparedPaymentMethod = &PreparedPaymentMethod{}
			}
			if err := m.PreparedPaymentMethod.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FirstName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPaymentProvidersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPaymentProvidersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPaymentProvidersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PaymentMethod) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PaymentMethod: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PaymentMethod: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PaymentProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PaymentProviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidUntil", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ValidUntil == nil {
				m.ValidUntil = &types.Timestamp{}
			}
			if err := m.ValidUntil.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreditCardInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreditCardInfo == nil {
				m.CreditCardInfo = &PaymentMethod_CreditCardInfo{}
			}
			if err := m.CreditCardInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PaymentMethod_CreditCardInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreditCardInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreditCardInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastDigits", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastDigits = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CardType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CardType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PaymentMethodList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PaymentMethodList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PaymentMethodList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &PaymentMethod{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPaymentMethodsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPaymentMethodsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPaymentMethodsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetDefaultPaymentMethodRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetDefaultPaymentMethodRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetDefaultPaymentMethodRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PaymentMethodId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PaymentMethodId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Address) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Address: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Address: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = append(m.Address, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zipcode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Zipcode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field City", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.City = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CountryCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CountryCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BillingConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BillingConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BillingConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Address == nil {
				m.Address = &Address{}
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VatNumber", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VatNumber = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmailAddresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EmailAddresses = append(m.EmailAddresses, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsTaxNumber", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UsTaxNumber = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetBillingConfigRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetBillingConfigRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetBillingConfigRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBilling
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthBilling
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &BillingConfig{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBilling(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthBilling
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBilling(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBilling
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBilling
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthBilling
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthBilling
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBilling
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBilling(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthBilling
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBilling = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBilling   = fmt.Errorf("proto: integer overflow")
)
