// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: iam.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// User represents an actual person.
type User struct {
	// Identifier of the user.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Primary email address of the user.
	// All emails send to this user will use this address.
	// This is a read-only value.
	Email string `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	// Name of the user.
	// This may be empty if not filled out by the user.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Given name of the user.
	// This may be empty if not filled out by the user.
	GivenName string `protobuf:"bytes,4,opt,name=given_name,json=givenName,proto3" json:"given_name,omitempty"`
	// Family name of the user.
	// This may be empty if not filled out by the user.
	FamilyName string `protobuf:"bytes,5,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// The creation timestamp of the user.
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Additional email addresses of the user.
	// This will be filled in when the authentication provided
	// knows multiple email addresses for the user.
	// This is a read-only value.
	AdditionalEmails []string `protobuf:"bytes,7,rep,name=additional_emails,json=additionalEmails,proto3" json:"additional_emails,omitempty"`
	// Mobile phone number of the user.
	// This value must be unique globally.
	//
	// This field will not be filled, unless:
	// - The currently authenticated user is this user
	// - The currently authenticated user has `iam.user.get-personal-data` permission
	//   on the organization that user is a member of.
	//
	// This value can only be changed to a non-empty value.
	// If changed, the new number has to be verified again.
	MobilePhone string `protobuf:"bytes,8,opt,name=mobile_phone,json=mobilePhone,proto3" json:"mobile_phone,omitempty"`
	// Set when the mobile phone number has been successfully verified.
	// This is a read-only value.
	MobilePhoneVerified bool `protobuf:"varint,9,opt,name=mobile_phone_verified,json=mobilePhoneVerified,proto3" json:"mobile_phone_verified,omitempty"`
	// Company name of the user
	// This may be empty if not filled out by the user.
	CompanyName string `protobuf:"bytes,10,opt,name=company_name,json=companyName,proto3" json:"company_name,omitempty"`
	// If set, this user is denied access to the dashboard.
	// This is a read-only value.
	DashboardAccessDenied bool `protobuf:"varint,11,opt,name=dashboard_access_denied,json=dashboardAccessDenied,proto3" json:"dashboard_access_denied,omitempty"`
	// If set, this field describes the reason why this user is denied access to the dashboard.
	// This is a read-only value.
	DashboardAccessDeniedReason string `protobuf:"bytes,12,opt,name=dashboard_access_denied_reason,json=dashboardAccessDeniedReason,proto3" json:"dashboard_access_denied_reason,omitempty"`
	// If set, this user is currently being authenticated using an API key (identified by this ID)
	ApikeyId string `protobuf:"bytes,13,opt,name=apikey_id,json=apikeyId,proto3" json:"apikey_id,omitempty"`
	// If set, contains Slack name of this user in the arangodb-community slack.
	SlackName string `protobuf:"bytes,14,opt,name=slack_name,json=slackName,proto3" json:"slack_name,omitempty"`
	// The timestamp of the last login of the user.
	// This is a read-only value.
	LastLoginAt *types.Timestamp `protobuf:"bytes,15,opt,name=last_login_at,json=lastLoginAt,proto3" json:"last_login_at,omitempty"`
	// If set, contains IP address from which the user last logged in.
	LastIp               string   `protobuf:"bytes,16,opt,name=last_ip,json=lastIp,proto3" json:"last_ip,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *User) Reset()         { *m = User{} }
func (m *User) String() string { return proto.CompactTextString(m) }
func (*User) ProtoMessage()    {}
func (*User) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{0}
}
func (m *User) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_User.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_User.Merge(m, src)
}
func (m *User) XXX_Size() int {
	return m.Size()
}
func (m *User) XXX_DiscardUnknown() {
	xxx_messageInfo_User.DiscardUnknown(m)
}

var xxx_messageInfo_User proto.InternalMessageInfo

func (m *User) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *User) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *User) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *User) GetGivenName() string {
	if m != nil {
		return m.GivenName
	}
	return ""
}

func (m *User) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *User) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *User) GetAdditionalEmails() []string {
	if m != nil {
		return m.AdditionalEmails
	}
	return nil
}

func (m *User) GetMobilePhone() string {
	if m != nil {
		return m.MobilePhone
	}
	return ""
}

func (m *User) GetMobilePhoneVerified() bool {
	if m != nil {
		return m.MobilePhoneVerified
	}
	return false
}

func (m *User) GetCompanyName() string {
	if m != nil {
		return m.CompanyName
	}
	return ""
}

func (m *User) GetDashboardAccessDenied() bool {
	if m != nil {
		return m.DashboardAccessDenied
	}
	return false
}

func (m *User) GetDashboardAccessDeniedReason() string {
	if m != nil {
		return m.DashboardAccessDeniedReason
	}
	return ""
}

func (m *User) GetApikeyId() string {
	if m != nil {
		return m.ApikeyId
	}
	return ""
}

func (m *User) GetSlackName() string {
	if m != nil {
		return m.SlackName
	}
	return ""
}

func (m *User) GetLastLoginAt() *types.Timestamp {
	if m != nil {
		return m.LastLoginAt
	}
	return nil
}

func (m *User) GetLastIp() string {
	if m != nil {
		return m.LastIp
	}
	return ""
}

// Request arguments for VerifyUserMobilePhone
type VerifyUserMobilePhoneRequest struct {
	// Code that was send to the mobile phone number.
	Code                 string   `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VerifyUserMobilePhoneRequest) Reset()         { *m = VerifyUserMobilePhoneRequest{} }
func (m *VerifyUserMobilePhoneRequest) String() string { return proto.CompactTextString(m) }
func (*VerifyUserMobilePhoneRequest) ProtoMessage()    {}
func (*VerifyUserMobilePhoneRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{1}
}
func (m *VerifyUserMobilePhoneRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerifyUserMobilePhoneRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerifyUserMobilePhoneRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerifyUserMobilePhoneRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerifyUserMobilePhoneRequest.Merge(m, src)
}
func (m *VerifyUserMobilePhoneRequest) XXX_Size() int {
	return m.Size()
}
func (m *VerifyUserMobilePhoneRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VerifyUserMobilePhoneRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VerifyUserMobilePhoneRequest proto.InternalMessageInfo

func (m *VerifyUserMobilePhoneRequest) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

// Group of user accounts.
type Group struct {
	// System identifier of the group.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the organization that owns this group.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the group
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the group
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The creation timestamp of the group
	CreatedAt *types.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the group
	DeletedAt *types.Timestamp `protobuf:"bytes,6,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this organization is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,7,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,8,opt,name=url,proto3" json:"url,omitempty"`
	// Set if this group is virtual and managed by the system.
	// This is a read-only value.
	IsVirtual            bool     `protobuf:"varint,9,opt,name=is_virtual,json=isVirtual,proto3" json:"is_virtual,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Group) Reset()         { *m = Group{} }
func (m *Group) String() string { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()    {}
func (*Group) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{2}
}
func (m *Group) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Group) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Group.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Group) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Group.Merge(m, src)
}
func (m *Group) XXX_Size() int {
	return m.Size()
}
func (m *Group) XXX_DiscardUnknown() {
	xxx_messageInfo_Group.DiscardUnknown(m)
}

var xxx_messageInfo_Group proto.InternalMessageInfo

func (m *Group) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Group) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Group) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Group) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Group) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Group) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Group) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Group) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Group) GetIsVirtual() bool {
	if m != nil {
		return m.IsVirtual
	}
	return false
}

// List of groups.
type GroupList struct {
	Items                []*Group `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupList) Reset()         { *m = GroupList{} }
func (m *GroupList) String() string { return proto.CompactTextString(m) }
func (*GroupList) ProtoMessage()    {}
func (*GroupList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{3}
}
func (m *GroupList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupList.Merge(m, src)
}
func (m *GroupList) XXX_Size() int {
	return m.Size()
}
func (m *GroupList) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupList.DiscardUnknown(m)
}

var xxx_messageInfo_GroupList proto.InternalMessageInfo

func (m *GroupList) GetItems() []*Group {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for IsMemberOfGroup.
type IsMemberOfGroupRequest struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Identifier of the group
	GroupId              string   `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsMemberOfGroupRequest) Reset()         { *m = IsMemberOfGroupRequest{} }
func (m *IsMemberOfGroupRequest) String() string { return proto.CompactTextString(m) }
func (*IsMemberOfGroupRequest) ProtoMessage()    {}
func (*IsMemberOfGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{4}
}
func (m *IsMemberOfGroupRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsMemberOfGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsMemberOfGroupRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsMemberOfGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsMemberOfGroupRequest.Merge(m, src)
}
func (m *IsMemberOfGroupRequest) XXX_Size() int {
	return m.Size()
}
func (m *IsMemberOfGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsMemberOfGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsMemberOfGroupRequest proto.InternalMessageInfo

func (m *IsMemberOfGroupRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *IsMemberOfGroupRequest) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

// List of group members (user ID's)
type GroupMemberList struct {
	// List of ID's of users that are member of the group.
	Items                []string `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMemberList) Reset()         { *m = GroupMemberList{} }
func (m *GroupMemberList) String() string { return proto.CompactTextString(m) }
func (*GroupMemberList) ProtoMessage()    {}
func (*GroupMemberList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{5}
}
func (m *GroupMemberList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupMemberList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMemberList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupMemberList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMemberList.Merge(m, src)
}
func (m *GroupMemberList) XXX_Size() int {
	return m.Size()
}
func (m *GroupMemberList) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMemberList.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMemberList proto.InternalMessageInfo

func (m *GroupMemberList) GetItems() []string {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for Add/DeleteGroupMembers.
type GroupMembersRequest struct {
	// ID of the group to add/remove members to/from.
	GroupId string `protobuf:"bytes,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// ID's of users to add/remove to/from the group.
	UserIds              []string `protobuf:"bytes,2,rep,name=user_ids,json=userIds,proto3" json:"user_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMembersRequest) Reset()         { *m = GroupMembersRequest{} }
func (m *GroupMembersRequest) String() string { return proto.CompactTextString(m) }
func (*GroupMembersRequest) ProtoMessage()    {}
func (*GroupMembersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{6}
}
func (m *GroupMembersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupMembersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMembersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupMembersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMembersRequest.Merge(m, src)
}
func (m *GroupMembersRequest) XXX_Size() int {
	return m.Size()
}
func (m *GroupMembersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMembersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMembersRequest proto.InternalMessageInfo

func (m *GroupMembersRequest) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *GroupMembersRequest) GetUserIds() []string {
	if m != nil {
		return m.UserIds
	}
	return nil
}

// List of permissions.
type PermissionList struct {
	Items                []string `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PermissionList) Reset()         { *m = PermissionList{} }
func (m *PermissionList) String() string { return proto.CompactTextString(m) }
func (*PermissionList) ProtoMessage()    {}
func (*PermissionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{7}
}
func (m *PermissionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PermissionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PermissionList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PermissionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PermissionList.Merge(m, src)
}
func (m *PermissionList) XXX_Size() int {
	return m.Size()
}
func (m *PermissionList) XXX_DiscardUnknown() {
	xxx_messageInfo_PermissionList.DiscardUnknown(m)
}

var xxx_messageInfo_PermissionList proto.InternalMessageInfo

func (m *PermissionList) GetItems() []string {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for HasPermissionsRequest.
type HasPermissionsRequest struct {
	// URL of the resource to query permissions for.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The list of permissions that are required.
	Permissions          []string `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HasPermissionsRequest) Reset()         { *m = HasPermissionsRequest{} }
func (m *HasPermissionsRequest) String() string { return proto.CompactTextString(m) }
func (*HasPermissionsRequest) ProtoMessage()    {}
func (*HasPermissionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{8}
}
func (m *HasPermissionsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HasPermissionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HasPermissionsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HasPermissionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HasPermissionsRequest.Merge(m, src)
}
func (m *HasPermissionsRequest) XXX_Size() int {
	return m.Size()
}
func (m *HasPermissionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HasPermissionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HasPermissionsRequest proto.InternalMessageInfo

func (m *HasPermissionsRequest) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *HasPermissionsRequest) GetPermissions() []string {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// A role is a list of permissions.
// Roles can be bound to resources for members.
type Role struct {
	// System identifier of the role.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the organization that owns this role.
	// This value is undefined for predefined roles.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the role
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the role
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Permissions to grant when this role is bound.
	Permissions []string `protobuf:"bytes,5,rep,name=permissions,proto3" json:"permissions,omitempty"`
	// Set if this role is predefined.
	// This is a read-only value.
	IsPredefined bool `protobuf:"varint,6,opt,name=is_predefined,json=isPredefined,proto3" json:"is_predefined,omitempty"`
	// The creation timestamp of the role
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the role
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this organization is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url                  string   `protobuf:"bytes,10,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Role) Reset()         { *m = Role{} }
func (m *Role) String() string { return proto.CompactTextString(m) }
func (*Role) ProtoMessage()    {}
func (*Role) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{9}
}
func (m *Role) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Role) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Role.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Role) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Role.Merge(m, src)
}
func (m *Role) XXX_Size() int {
	return m.Size()
}
func (m *Role) XXX_DiscardUnknown() {
	xxx_messageInfo_Role.DiscardUnknown(m)
}

var xxx_messageInfo_Role proto.InternalMessageInfo

func (m *Role) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Role) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Role) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Role) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Role) GetPermissions() []string {
	if m != nil {
		return m.Permissions
	}
	return nil
}

func (m *Role) GetIsPredefined() bool {
	if m != nil {
		return m.IsPredefined
	}
	return false
}

func (m *Role) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Role) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Role) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Role) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// List of roles.
type RoleList struct {
	Items                []*Role  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleList) Reset()         { *m = RoleList{} }
func (m *RoleList) String() string { return proto.CompactTextString(m) }
func (*RoleList) ProtoMessage()    {}
func (*RoleList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{10}
}
func (m *RoleList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleList.Merge(m, src)
}
func (m *RoleList) XXX_Size() int {
	return m.Size()
}
func (m *RoleList) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleList.DiscardUnknown(m)
}

var xxx_messageInfo_RoleList proto.InternalMessageInfo

func (m *RoleList) GetItems() []*Role {
	if m != nil {
		return m.Items
	}
	return nil
}

// RoleBinding binds a Role to a member.
type RoleBinding struct {
	// System identifier of the role-binding.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the member to bind a role to.
	// Member ID is formatted as:
	// - user:<user_id>
	// - group:<group_id>
	MemberId string `protobuf:"bytes,2,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	// Identifier of the Role to grant to member
	RoleId string `protobuf:"bytes,3,opt,name=role_id,json=roleId,proto3" json:"role_id,omitempty"`
	// If set, this this role-binding cannot be deleted
	// This is a read-only value.
	DeleteNotAllowed     bool     `protobuf:"varint,4,opt,name=delete_not_allowed,json=deleteNotAllowed,proto3" json:"delete_not_allowed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleBinding) Reset()         { *m = RoleBinding{} }
func (m *RoleBinding) String() string { return proto.CompactTextString(m) }
func (*RoleBinding) ProtoMessage()    {}
func (*RoleBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{11}
}
func (m *RoleBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleBinding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleBinding.Merge(m, src)
}
func (m *RoleBinding) XXX_Size() int {
	return m.Size()
}
func (m *RoleBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleBinding.DiscardUnknown(m)
}

var xxx_messageInfo_RoleBinding proto.InternalMessageInfo

func (m *RoleBinding) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RoleBinding) GetMemberId() string {
	if m != nil {
		return m.MemberId
	}
	return ""
}

func (m *RoleBinding) GetRoleId() string {
	if m != nil {
		return m.RoleId
	}
	return ""
}

func (m *RoleBinding) GetDeleteNotAllowed() bool {
	if m != nil {
		return m.DeleteNotAllowed
	}
	return false
}

// Policy bindings members to roles for access to a resource.
type Policy struct {
	// URL of the resource to which this policy applies.
	ResourceUrl string `protobuf:"bytes,1,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// Role bindings to apply to the resource.
	Bindings             []*RoleBinding `protobuf:"bytes,2,rep,name=bindings,proto3" json:"bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Policy) Reset()         { *m = Policy{} }
func (m *Policy) String() string { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()    {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{12}
}
func (m *Policy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return m.Size()
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

func (m *Policy) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *Policy) GetBindings() []*RoleBinding {
	if m != nil {
		return m.Bindings
	}
	return nil
}

// Request arguments for Add/DeleteRoleBindings.
type RoleBindingsRequest struct {
	// URL of the resource to add/remove policy binding to/from.
	ResourceUrl string `protobuf:"bytes,1,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// Role bindings to add/remove to the policy.
	Bindings             []*RoleBinding `protobuf:"bytes,2,rep,name=bindings,proto3" json:"bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RoleBindingsRequest) Reset()         { *m = RoleBindingsRequest{} }
func (m *RoleBindingsRequest) String() string { return proto.CompactTextString(m) }
func (*RoleBindingsRequest) ProtoMessage()    {}
func (*RoleBindingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{13}
}
func (m *RoleBindingsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleBindingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleBindingsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleBindingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleBindingsRequest.Merge(m, src)
}
func (m *RoleBindingsRequest) XXX_Size() int {
	return m.Size()
}
func (m *RoleBindingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleBindingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RoleBindingsRequest proto.InternalMessageInfo

func (m *RoleBindingsRequest) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *RoleBindingsRequest) GetBindings() []*RoleBinding {
	if m != nil {
		return m.Bindings
	}
	return nil
}

// API Keys are authentication "keys" intended to be used for scripting.
type APIKey struct {
	// Identifier of this key
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this key.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// User represented by this key
	UserId string `protobuf:"bytes,3,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// If set, this key only grants access to this organization.
	OrganizationId string `protobuf:"bytes,4,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, this key only grants access to read-only API's (List..., Get...)
	IsReadonly bool `protobuf:"varint,5,opt,name=is_readonly,json=isReadonly,proto3" json:"is_readonly,omitempty"`
	// The creation timestamp of the key
	CreatedAt *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The expiration timestamp of the key
	ExpiresAt *types.Timestamp `protobuf:"bytes,7,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// Set when this key is expired.
	IsExpired bool `protobuf:"varint,8,opt,name=is_expired,json=isExpired,proto3" json:"is_expired,omitempty"`
	// The revocation timestamp of the key (if any)
	RevokedAt *types.Timestamp `protobuf:"bytes,9,opt,name=revoked_at,json=revokedAt,proto3" json:"revoked_at,omitempty"`
	// Set when this key is explicitly revoked.
	IsRevoked            bool     `protobuf:"varint,10,opt,name=is_revoked,json=isRevoked,proto3" json:"is_revoked,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *APIKey) Reset()         { *m = APIKey{} }
func (m *APIKey) String() string { return proto.CompactTextString(m) }
func (*APIKey) ProtoMessage()    {}
func (*APIKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{14}
}
func (m *APIKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *APIKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_APIKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *APIKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APIKey.Merge(m, src)
}
func (m *APIKey) XXX_Size() int {
	return m.Size()
}
func (m *APIKey) XXX_DiscardUnknown() {
	xxx_messageInfo_APIKey.DiscardUnknown(m)
}

var xxx_messageInfo_APIKey proto.InternalMessageInfo

func (m *APIKey) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *APIKey) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *APIKey) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *APIKey) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *APIKey) GetIsReadonly() bool {
	if m != nil {
		return m.IsReadonly
	}
	return false
}

func (m *APIKey) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *APIKey) GetExpiresAt() *types.Timestamp {
	if m != nil {
		return m.ExpiresAt
	}
	return nil
}

func (m *APIKey) GetIsExpired() bool {
	if m != nil {
		return m.IsExpired
	}
	return false
}

func (m *APIKey) GetRevokedAt() *types.Timestamp {
	if m != nil {
		return m.RevokedAt
	}
	return nil
}

func (m *APIKey) GetIsRevoked() bool {
	if m != nil {
		return m.IsRevoked
	}
	return false
}

// List of APIKey's
type APIKeyList struct {
	Items                []*APIKey `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *APIKeyList) Reset()         { *m = APIKeyList{} }
func (m *APIKeyList) String() string { return proto.CompactTextString(m) }
func (*APIKeyList) ProtoMessage()    {}
func (*APIKeyList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{15}
}
func (m *APIKeyList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *APIKeyList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_APIKeyList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *APIKeyList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APIKeyList.Merge(m, src)
}
func (m *APIKeyList) XXX_Size() int {
	return m.Size()
}
func (m *APIKeyList) XXX_DiscardUnknown() {
	xxx_messageInfo_APIKeyList.DiscardUnknown(m)
}

var xxx_messageInfo_APIKeyList proto.InternalMessageInfo

func (m *APIKeyList) GetItems() []*APIKey {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for CreateAPIKey.
type CreateAPIKeyRequest struct {
	// If set, the created key only grants access to this organization.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, the created key only grants access to read-only API's (List..., Get...).
	// If not set, the created key grants access to all API's (that the user has access to).
	Readonly bool `protobuf:"varint,2,opt,name=readonly,proto3" json:"readonly,omitempty"`
	// Duration between now and the expiration date of the created key.
	// A value of 0 means that the API key will not expire.
	// You can still use RevokeAPIKey to revoke such API keys.
	TimeToLive           *types.Duration `protobuf:"bytes,3,opt,name=time_to_live,json=timeToLive,proto3" json:"time_to_live,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CreateAPIKeyRequest) Reset()         { *m = CreateAPIKeyRequest{} }
func (m *CreateAPIKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAPIKeyRequest) ProtoMessage()    {}
func (*CreateAPIKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{16}
}
func (m *CreateAPIKeyRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreateAPIKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreateAPIKeyRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreateAPIKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAPIKeyRequest.Merge(m, src)
}
func (m *CreateAPIKeyRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreateAPIKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAPIKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAPIKeyRequest proto.InternalMessageInfo

func (m *CreateAPIKeyRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *CreateAPIKeyRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *CreateAPIKeyRequest) GetTimeToLive() *types.Duration {
	if m != nil {
		return m.TimeToLive
	}
	return nil
}

// API key secrets are used once to inform the users of the secret
// for an API key.
type APIKeySecret struct {
	// ID of the API key
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Secret of the API key
	Secret               string   `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *APIKeySecret) Reset()         { *m = APIKeySecret{} }
func (m *APIKeySecret) String() string { return proto.CompactTextString(m) }
func (*APIKeySecret) ProtoMessage()    {}
func (*APIKeySecret) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{17}
}
func (m *APIKeySecret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *APIKeySecret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_APIKeySecret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *APIKeySecret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APIKeySecret.Merge(m, src)
}
func (m *APIKeySecret) XXX_Size() int {
	return m.Size()
}
func (m *APIKeySecret) XXX_DiscardUnknown() {
	xxx_messageInfo_APIKeySecret.DiscardUnknown(m)
}

var xxx_messageInfo_APIKeySecret proto.InternalMessageInfo

func (m *APIKeySecret) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *APIKeySecret) GetSecret() string {
	if m != nil {
		return m.Secret
	}
	return ""
}

// Request arguments for AuthenticateAPIKey
type AuthenticateAPIKeyRequest struct {
	// API key id
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Secret of the API key
	Secret string `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	// Life time of the token.
	// If set, then this TTL is used reduce the default TTL
	// of an authentication token. It cannot be used to increase the default
	// lifetime of a token.
	TimeToLive           *types.Duration `protobuf:"bytes,3,opt,name=time_to_live,json=timeToLive,proto3" json:"time_to_live,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *AuthenticateAPIKeyRequest) Reset()         { *m = AuthenticateAPIKeyRequest{} }
func (m *AuthenticateAPIKeyRequest) String() string { return proto.CompactTextString(m) }
func (*AuthenticateAPIKeyRequest) ProtoMessage()    {}
func (*AuthenticateAPIKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{18}
}
func (m *AuthenticateAPIKeyRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuthenticateAPIKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthenticateAPIKeyRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuthenticateAPIKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthenticateAPIKeyRequest.Merge(m, src)
}
func (m *AuthenticateAPIKeyRequest) XXX_Size() int {
	return m.Size()
}
func (m *AuthenticateAPIKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthenticateAPIKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AuthenticateAPIKeyRequest proto.InternalMessageInfo

func (m *AuthenticateAPIKeyRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AuthenticateAPIKeyRequest) GetSecret() string {
	if m != nil {
		return m.Secret
	}
	return ""
}

func (m *AuthenticateAPIKeyRequest) GetTimeToLive() *types.Duration {
	if m != nil {
		return m.TimeToLive
	}
	return nil
}

// Response for AuthenticateAPIKey
type AuthenticateAPIKeyResponse struct {
	// Bearer token
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Actual life time of the token.
	TimeToLive           *types.Duration `protobuf:"bytes,2,opt,name=time_to_live,json=timeToLive,proto3" json:"time_to_live,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *AuthenticateAPIKeyResponse) Reset()         { *m = AuthenticateAPIKeyResponse{} }
func (m *AuthenticateAPIKeyResponse) String() string { return proto.CompactTextString(m) }
func (*AuthenticateAPIKeyResponse) ProtoMessage()    {}
func (*AuthenticateAPIKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{19}
}
func (m *AuthenticateAPIKeyResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuthenticateAPIKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuthenticateAPIKeyResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuthenticateAPIKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuthenticateAPIKeyResponse.Merge(m, src)
}
func (m *AuthenticateAPIKeyResponse) XXX_Size() int {
	return m.Size()
}
func (m *AuthenticateAPIKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AuthenticateAPIKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AuthenticateAPIKeyResponse proto.InternalMessageInfo

func (m *AuthenticateAPIKeyResponse) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *AuthenticateAPIKeyResponse) GetTimeToLive() *types.Duration {
	if m != nil {
		return m.TimeToLive
	}
	return nil
}

// Request arguments for RenewAPIKeyToken.
type RenewAPIKeyTokenRequest struct {
	// Bearer token
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Extended life time of the token.
	// By default, a renewed token will have a default lifetime from the moment
	// of the renew call.
	// If this field is set, then this TTL is used reduce the default TTL
	// of the renewed token. It cannot be used to increase the default
	// lifetime of the renewed token.
	TimeToLive           *types.Duration `protobuf:"bytes,2,opt,name=time_to_live,json=timeToLive,proto3" json:"time_to_live,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *RenewAPIKeyTokenRequest) Reset()         { *m = RenewAPIKeyTokenRequest{} }
func (m *RenewAPIKeyTokenRequest) String() string { return proto.CompactTextString(m) }
func (*RenewAPIKeyTokenRequest) ProtoMessage()    {}
func (*RenewAPIKeyTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{20}
}
func (m *RenewAPIKeyTokenRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RenewAPIKeyTokenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RenewAPIKeyTokenRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RenewAPIKeyTokenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RenewAPIKeyTokenRequest.Merge(m, src)
}
func (m *RenewAPIKeyTokenRequest) XXX_Size() int {
	return m.Size()
}
func (m *RenewAPIKeyTokenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RenewAPIKeyTokenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RenewAPIKeyTokenRequest proto.InternalMessageInfo

func (m *RenewAPIKeyTokenRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *RenewAPIKeyTokenRequest) GetTimeToLive() *types.Duration {
	if m != nil {
		return m.TimeToLive
	}
	return nil
}

// Response for RenewAPIKeyToken.
type RenewAPIKeyTokenResponse struct {
	// Actual life time of the token.
	TimeToLive           *types.Duration `protobuf:"bytes,1,opt,name=time_to_live,json=timeToLive,proto3" json:"time_to_live,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *RenewAPIKeyTokenResponse) Reset()         { *m = RenewAPIKeyTokenResponse{} }
func (m *RenewAPIKeyTokenResponse) String() string { return proto.CompactTextString(m) }
func (*RenewAPIKeyTokenResponse) ProtoMessage()    {}
func (*RenewAPIKeyTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{21}
}
func (m *RenewAPIKeyTokenResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RenewAPIKeyTokenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RenewAPIKeyTokenResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RenewAPIKeyTokenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RenewAPIKeyTokenResponse.Merge(m, src)
}
func (m *RenewAPIKeyTokenResponse) XXX_Size() int {
	return m.Size()
}
func (m *RenewAPIKeyTokenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RenewAPIKeyTokenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RenewAPIKeyTokenResponse proto.InternalMessageInfo

func (m *RenewAPIKeyTokenResponse) GetTimeToLive() *types.Duration {
	if m != nil {
		return m.TimeToLive
	}
	return nil
}

// Request arguments for RevokeAPIKeyToken.
type RevokeAPIKeyTokenRequest struct {
	// Bearer token
	Token                string   `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RevokeAPIKeyTokenRequest) Reset()         { *m = RevokeAPIKeyTokenRequest{} }
func (m *RevokeAPIKeyTokenRequest) String() string { return proto.CompactTextString(m) }
func (*RevokeAPIKeyTokenRequest) ProtoMessage()    {}
func (*RevokeAPIKeyTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{22}
}
func (m *RevokeAPIKeyTokenRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RevokeAPIKeyTokenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RevokeAPIKeyTokenRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RevokeAPIKeyTokenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RevokeAPIKeyTokenRequest.Merge(m, src)
}
func (m *RevokeAPIKeyTokenRequest) XXX_Size() int {
	return m.Size()
}
func (m *RevokeAPIKeyTokenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RevokeAPIKeyTokenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RevokeAPIKeyTokenRequest proto.InternalMessageInfo

func (m *RevokeAPIKeyTokenRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func init() {
	proto.RegisterType((*User)(nil), "arangodb.cloud.iam.v1.User")
	proto.RegisterType((*VerifyUserMobilePhoneRequest)(nil), "arangodb.cloud.iam.v1.VerifyUserMobilePhoneRequest")
	proto.RegisterType((*Group)(nil), "arangodb.cloud.iam.v1.Group")
	proto.RegisterType((*GroupList)(nil), "arangodb.cloud.iam.v1.GroupList")
	proto.RegisterType((*IsMemberOfGroupRequest)(nil), "arangodb.cloud.iam.v1.IsMemberOfGroupRequest")
	proto.RegisterType((*GroupMemberList)(nil), "arangodb.cloud.iam.v1.GroupMemberList")
	proto.RegisterType((*GroupMembersRequest)(nil), "arangodb.cloud.iam.v1.GroupMembersRequest")
	proto.RegisterType((*PermissionList)(nil), "arangodb.cloud.iam.v1.PermissionList")
	proto.RegisterType((*HasPermissionsRequest)(nil), "arangodb.cloud.iam.v1.HasPermissionsRequest")
	proto.RegisterType((*Role)(nil), "arangodb.cloud.iam.v1.Role")
	proto.RegisterType((*RoleList)(nil), "arangodb.cloud.iam.v1.RoleList")
	proto.RegisterType((*RoleBinding)(nil), "arangodb.cloud.iam.v1.RoleBinding")
	proto.RegisterType((*Policy)(nil), "arangodb.cloud.iam.v1.Policy")
	proto.RegisterType((*RoleBindingsRequest)(nil), "arangodb.cloud.iam.v1.RoleBindingsRequest")
	proto.RegisterType((*APIKey)(nil), "arangodb.cloud.iam.v1.APIKey")
	proto.RegisterType((*APIKeyList)(nil), "arangodb.cloud.iam.v1.APIKeyList")
	proto.RegisterType((*CreateAPIKeyRequest)(nil), "arangodb.cloud.iam.v1.CreateAPIKeyRequest")
	proto.RegisterType((*APIKeySecret)(nil), "arangodb.cloud.iam.v1.APIKeySecret")
	proto.RegisterType((*AuthenticateAPIKeyRequest)(nil), "arangodb.cloud.iam.v1.AuthenticateAPIKeyRequest")
	proto.RegisterType((*AuthenticateAPIKeyResponse)(nil), "arangodb.cloud.iam.v1.AuthenticateAPIKeyResponse")
	proto.RegisterType((*RenewAPIKeyTokenRequest)(nil), "arangodb.cloud.iam.v1.RenewAPIKeyTokenRequest")
	proto.RegisterType((*RenewAPIKeyTokenResponse)(nil), "arangodb.cloud.iam.v1.RenewAPIKeyTokenResponse")
	proto.RegisterType((*RevokeAPIKeyTokenRequest)(nil), "arangodb.cloud.iam.v1.RevokeAPIKeyTokenRequest")
}

func init() { proto.RegisterFile("iam.proto", fileDescriptor_0a2c201915207782) }

var fileDescriptor_0a2c201915207782 = []byte{
	// 2170 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xdd, 0x6e, 0x1b, 0xc7,
	0xf5, 0xff, 0x2f, 0xf5, 0x45, 0x1e, 0xca, 0x92, 0x32, 0xb2, 0x24, 0x9a, 0x92, 0x25, 0x6a, 0x1d,
	0x47, 0x8a, 0xfe, 0x16, 0xd7, 0xa2, 0x5b, 0x07, 0x6a, 0x9a, 0x14, 0x4c, 0x6c, 0xa8, 0x44, 0x64,
	0x5b, 0x60, 0xec, 0x14, 0xed, 0x0d, 0xb1, 0xe2, 0x8e, 0xa8, 0xa9, 0xf6, 0x2b, 0x3b, 0x4b, 0xda,
	0x8a, 0x61, 0xf4, 0x03, 0x45, 0xd1, 0xa0, 0xbd, 0x28, 0x1a, 0xa0, 0x2d, 0x8a, 0xb6, 0xe8, 0x65,
	0x1f, 0xa2, 0x0f, 0xd0, 0xcb, 0x02, 0x7d, 0x81, 0xc2, 0xe9, 0x23, 0xf4, 0xb2, 0x17, 0xc5, 0x9c,
	0x19, 0x92, 0x4b, 0x72, 0x97, 0xa4, 0x22, 0x3b, 0x57, 0xe2, 0x9e, 0x39, 0x73, 0x7e, 0xbf, 0x39,
	0xe7, 0xcc, 0x99, 0x39, 0x23, 0xc8, 0x30, 0xd3, 0x29, 0xfa, 0x81, 0x17, 0x7a, 0x64, 0xc9, 0x0c,
	0x4c, 0xb7, 0xe1, 0x59, 0xc7, 0xc5, 0xba, 0xed, 0x35, 0xad, 0xa2, 0x18, 0x69, 0xed, 0xe5, 0x97,
	0xeb, 0x9e, 0xe3, 0x78, 0xae, 0xd1, 0xda, 0x33, 0xe4, 0x2f, 0xa9, 0x9e, 0x7f, 0xb7, 0xc1, 0xc2,
	0xd3, 0xe6, 0x71, 0xb1, 0xee, 0x39, 0x46, 0xc3, 0xb3, 0x4d, 0xb7, 0x61, 0xe0, 0xc0, 0x71, 0xf3,
	0xc4, 0xf0, 0xc3, 0x73, 0x9f, 0x72, 0x23, 0x64, 0x0e, 0xe5, 0xa1, 0xe9, 0xf8, 0xdd, 0x5f, 0x6a,
	0xf2, 0xfe, 0xe8, 0xc9, 0x56, 0x33, 0x30, 0x43, 0xe6, 0xb9, 0x9d, 0x1f, 0x6a, 0xea, 0x5a, 0xc3,
	0xf3, 0x1a, 0x36, 0x35, 0x4c, 0x9f, 0x19, 0xa6, 0xeb, 0x7a, 0x21, 0x0e, 0x72, 0x39, 0xaa, 0xff,
	0x67, 0x12, 0x26, 0x9f, 0x70, 0x1a, 0x90, 0x39, 0x48, 0x31, 0x2b, 0xa7, 0x15, 0xb4, 0xed, 0x4c,
	0x35, 0xc5, 0x2c, 0x72, 0x15, 0xa6, 0xa8, 0x63, 0x32, 0x3b, 0x97, 0x42, 0x91, 0xfc, 0x20, 0x04,
	0x26, 0x5d, 0xd3, 0xa1, 0xb9, 0x09, 0x14, 0xe2, 0x6f, 0x72, 0x1d, 0xa0, 0xc1, 0x5a, 0xd4, 0xad,
	0xe1, 0xc8, 0x24, 0x8e, 0x64, 0x50, 0xf2, 0x50, 0x0c, 0x6f, 0x40, 0xf6, 0xc4, 0x74, 0x98, 0x7d,
	0x2e, 0xc7, 0xa7, 0x70, 0x1c, 0xa4, 0x08, 0x15, 0xf6, 0x01, 0xea, 0x01, 0x35, 0x43, 0x6a, 0xd5,
	0xcc, 0x30, 0x37, 0x5d, 0xd0, 0xb6, 0xb3, 0xa5, 0x7c, 0x51, 0xb2, 0x2e, 0xb6, 0x57, 0x59, 0x7c,
	0xdc, 0xf6, 0x48, 0x35, 0xa3, 0xb4, 0xcb, 0x21, 0xf9, 0x7f, 0x78, 0xc3, 0xb4, 0x2c, 0x26, 0x16,
	0x64, 0xda, 0x35, 0xa4, 0xc8, 0x73, 0x33, 0x85, 0x89, 0xed, 0x4c, 0x75, 0xa1, 0x3b, 0x70, 0x1f,
	0xe5, 0x64, 0x13, 0x66, 0x1d, 0xef, 0x98, 0xd9, 0xb4, 0xe6, 0x9f, 0x7a, 0x2e, 0xcd, 0xa5, 0x91,
	0x49, 0x56, 0xca, 0x8e, 0x84, 0x88, 0x94, 0x60, 0x29, 0xaa, 0x52, 0x6b, 0xd1, 0x80, 0x9d, 0x30,
	0x6a, 0xe5, 0x32, 0x05, 0x6d, 0x3b, 0x5d, 0x5d, 0x8c, 0xe8, 0x7e, 0xa2, 0x86, 0x84, 0xd9, 0xba,
	0xe7, 0xf8, 0xa6, 0xab, 0x16, 0x08, 0xd2, 0xac, 0x92, 0xe1, 0x0a, 0xef, 0xc2, 0x8a, 0x65, 0xf2,
	0xd3, 0x63, 0xcf, 0x0c, 0xac, 0x9a, 0x59, 0xaf, 0x53, 0xce, 0x6b, 0x16, 0x75, 0x85, 0xe1, 0x2c,
	0x1a, 0x5e, 0xea, 0x0c, 0x97, 0x71, 0xf4, 0x1e, 0x0e, 0x92, 0x0f, 0x61, 0x3d, 0x61, 0x5e, 0x2d,
	0xa0, 0x26, 0xf7, 0xdc, 0xdc, 0x2c, 0x82, 0xad, 0xc6, 0x4e, 0xaf, 0xa2, 0x0a, 0x59, 0x85, 0x8c,
	0xe9, 0xb3, 0x33, 0x7a, 0x5e, 0x63, 0x56, 0xee, 0x0a, 0xea, 0xa7, 0xa5, 0xa0, 0x62, 0x89, 0xd8,
	0x71, 0xdb, 0xac, 0x9f, 0x49, 0xea, 0x73, 0x32, 0x76, 0x28, 0x41, 0xe2, 0xef, 0xc3, 0x15, 0xdb,
	0xe4, 0x61, 0xcd, 0xf6, 0x1a, 0xcc, 0x15, 0xd1, 0x99, 0x1f, 0x19, 0x9d, 0xac, 0x98, 0x70, 0x28,
	0xf4, 0xcb, 0x21, 0x59, 0x81, 0x19, 0x9c, 0xcf, 0xfc, 0xdc, 0x02, 0xda, 0x9e, 0x16, 0x9f, 0x15,
	0x5f, 0x2f, 0xc1, 0x1a, 0x3a, 0xf0, 0x5c, 0xe4, 0xde, 0x83, 0xae, 0x57, 0xab, 0xf4, 0xd3, 0x26,
	0xe5, 0xa1, 0xc8, 0xb3, 0xba, 0x67, 0x51, 0x95, 0x8f, 0xf8, 0x5b, 0xff, 0x5b, 0x0a, 0xa6, 0x0e,
	0x02, 0xaf, 0xe9, 0x0f, 0xe4, 0xea, 0x16, 0xcc, 0x7b, 0x41, 0xc3, 0x74, 0xd9, 0x67, 0x98, 0xdb,
	0x62, 0xa1, 0x32, 0x6b, 0xe7, 0xa2, 0xe2, 0x8a, 0x15, 0x9b, 0xbe, 0x05, 0xc8, 0x5a, 0x94, 0xd7,
	0x03, 0xe6, 0x0b, 0x25, 0x95, 0xbf, 0x51, 0x51, 0x5f, 0x82, 0x4e, 0x5d, 0x24, 0x41, 0xf7, 0x01,
	0x2c, 0x6a, 0xd3, 0xf1, 0x73, 0x5b, 0x69, 0x97, 0x43, 0x11, 0x1a, 0x26, 0xc2, 0x8d, 0xdf, 0xb9,
	0x19, 0xcc, 0x93, 0x0c, 0xe3, 0xf7, 0xa4, 0x80, 0x2c, 0xc0, 0x44, 0x33, 0xb0, 0x55, 0x12, 0x8b,
	0x9f, 0x6a, 0x42, 0x8b, 0x05, 0x61, 0xd3, 0xb4, 0x55, 0xc6, 0x66, 0x18, 0xff, 0x44, 0x0a, 0xf4,
	0xef, 0x40, 0x06, 0xbd, 0x77, 0xc8, 0x78, 0x48, 0x4a, 0x30, 0xc5, 0x42, 0xea, 0xf0, 0x9c, 0x56,
	0x98, 0xd8, 0xce, 0x96, 0xd6, 0x8a, 0xb1, 0xb5, 0xac, 0x88, 0x13, 0xaa, 0x52, 0x55, 0x3f, 0x84,
	0xe5, 0x0a, 0x7f, 0x40, 0x9d, 0x63, 0x1a, 0x3c, 0x3a, 0x91, 0x23, 0x2a, 0x5a, 0x2b, 0x30, 0xd3,
	0xe4, 0x34, 0xa8, 0x75, 0x82, 0x32, 0x2d, 0x3e, 0x2b, 0x16, 0xb9, 0x06, 0xe9, 0x86, 0x50, 0xec,
	0x46, 0x64, 0x06, 0xbf, 0x2b, 0x96, 0xbe, 0x05, 0xf3, 0x68, 0x43, 0x1a, 0x44, 0x52, 0x57, 0xa3,
	0xa4, 0x32, 0x6d, 0xd8, 0x8f, 0x60, 0x31, 0xa2, 0xc8, 0xdb, 0x98, 0x51, 0xd3, 0x5a, 0x8f, 0x69,
	0x31, 0xa4, 0xe8, 0xf0, 0x5c, 0x0a, 0x4d, 0xcd, 0x48, 0x3e, 0x5c, 0x7f, 0x0b, 0xe6, 0x8e, 0x68,
	0xe0, 0x30, 0xce, 0x99, 0xe7, 0x0e, 0x05, 0x5d, 0xfa, 0xae, 0xc9, 0xbb, 0xaa, 0x1d, 0x58, 0xe5,
	0x76, 0xad, 0xeb, 0xf6, 0x02, 0x64, 0xfd, 0xae, 0x9e, 0x02, 0x8c, 0x8a, 0xf4, 0x2f, 0x53, 0x30,
	0x59, 0xf5, 0x6c, 0xfa, 0x75, 0xe7, 0x6d, 0x1f, 0xb3, 0xa9, 0x01, 0x66, 0xe4, 0x06, 0x5c, 0x61,
	0xbc, 0xe6, 0x07, 0xd4, 0xa2, 0x27, 0xcc, 0xa5, 0x16, 0x66, 0x68, 0xba, 0x3a, 0xcb, 0xf8, 0x51,
	0x47, 0xd6, 0x97, 0xfe, 0x33, 0x5f, 0x3d, 0xfd, 0xd3, 0x5f, 0x3d, 0xfd, 0x33, 0x09, 0xe9, 0x0f,
	0x9d, 0x38, 0xe8, 0xef, 0x41, 0x5a, 0x38, 0x19, 0x83, 0xba, 0xd7, 0x9b, 0xde, 0xab, 0x09, 0xe9,
	0x2d, 0xf4, 0xdb, 0x11, 0xff, 0x89, 0x06, 0x59, 0xf1, 0xfd, 0x01, 0x73, 0x2d, 0xe6, 0x36, 0x06,
	0x62, 0xb5, 0x0a, 0x19, 0x07, 0x33, 0xb0, 0x1b, 0xa5, 0xb4, 0x14, 0x54, 0x2c, 0xb1, 0x01, 0x02,
	0xcf, 0xa6, 0x62, 0x48, 0x86, 0x68, 0x5a, 0x7c, 0x56, 0x2c, 0x72, 0x0b, 0x88, 0x5c, 0x42, 0xcd,
	0xf5, 0xc2, 0x9a, 0x69, 0xdb, 0xde, 0x53, 0x6a, 0x61, 0xac, 0xd2, 0xd5, 0x05, 0x39, 0xf2, 0xd0,
	0x0b, 0xcb, 0x52, 0xae, 0x9f, 0xc1, 0xf4, 0x91, 0x67, 0xb3, 0xfa, 0xb9, 0x38, 0x54, 0x02, 0xca,
	0xbd, 0x66, 0x50, 0xa7, 0xb5, 0x6e, 0xbe, 0x65, 0xdb, 0xb2, 0x27, 0x81, 0x4d, 0xde, 0x87, 0xf4,
	0xb1, 0xe4, 0x2a, 0x93, 0x2e, 0x5b, 0xd2, 0x87, 0x2c, 0x53, 0x2d, 0xab, 0xda, 0x99, 0xa3, 0x3f,
	0x83, 0xc5, 0xc8, 0x40, 0x27, 0xc1, 0xbf, 0x06, 0xe4, 0xff, 0xa6, 0x60, 0xba, 0x7c, 0x54, 0xf9,
	0x88, 0x9e, 0x0f, 0x78, 0x59, 0x85, 0x35, 0xd5, 0xdd, 0x5e, 0x91, 0xda, 0x32, 0xd1, 0x53, 0x5b,
	0x62, 0x36, 0xcf, 0x64, 0xec, 0xe6, 0xd9, 0x80, 0x2c, 0xe3, 0xe2, 0xc0, 0xb4, 0x3c, 0xd7, 0x3e,
	0xc7, 0xfa, 0x9d, 0xae, 0x02, 0xe3, 0x55, 0x25, 0xb9, 0xcc, 0x05, 0x64, 0x1f, 0x80, 0x3e, 0xf3,
	0x59, 0x40, 0xf9, 0x98, 0x7b, 0x43, 0x69, 0x77, 0x12, 0x5c, 0x7e, 0x5b, 0xb8, 0x37, 0x30, 0xc1,
	0xef, 0x4b, 0x81, 0xb0, 0x1c, 0xd0, 0x96, 0x77, 0x26, 0x49, 0x65, 0x46, 0x5b, 0x56, 0xda, 0x1d,
	0xcb, 0xea, 0x1b, 0xb7, 0x08, 0x5a, 0xae, 0x4a, 0x81, 0x5e, 0x06, 0x90, 0xde, 0xc7, 0xad, 0x72,
	0xa7, 0x77, 0xab, 0x5c, 0x4f, 0x88, 0xa4, 0x9c, 0xd1, 0xde, 0x2c, 0xbf, 0xd3, 0x60, 0xf1, 0x43,
	0x74, 0x82, 0x92, 0xab, 0xe4, 0x89, 0x89, 0x89, 0x16, 0x1b, 0x93, 0x3c, 0xa4, 0x3b, 0x01, 0x49,
	0x21, 0xc1, 0xce, 0x37, 0x79, 0x17, 0x66, 0xc5, 0xf5, 0xb7, 0x16, 0x7a, 0x35, 0x9b, 0xb5, 0x64,
	0xd1, 0xcb, 0x96, 0xae, 0x0d, 0xac, 0xfd, 0x9e, 0xba, 0xe7, 0x56, 0x41, 0xa8, 0x3f, 0xf6, 0x0e,
	0x59, 0x8b, 0xea, 0x77, 0x61, 0x56, 0x52, 0xfa, 0x98, 0xd6, 0x03, 0x1a, 0x0e, 0x24, 0xd8, 0x32,
	0x4c, 0x73, 0x1c, 0x51, 0x39, 0xa6, 0xbe, 0xf4, 0x1f, 0x6b, 0x70, 0xad, 0xdc, 0x0c, 0x4f, 0xa9,
	0x1b, 0xb2, 0xfa, 0xc0, 0xba, 0xc6, 0xb4, 0x72, 0x39, 0xea, 0x1e, 0xe4, 0xe3, 0x18, 0x70, 0xdf,
	0x73, 0x39, 0x15, 0xe7, 0x54, 0xe8, 0x9d, 0x51, 0x57, 0xb1, 0x90, 0x1f, 0x03, 0x80, 0xa9, 0x8b,
	0x00, 0xda, 0xb0, 0x52, 0xa5, 0x2e, 0x7d, 0x2a, 0x91, 0x1e, 0x0b, 0x83, 0xed, 0x05, 0xbf, 0x06,
	0xb4, 0xef, 0x41, 0x6e, 0x10, 0x4d, 0x2d, 0xae, 0xdf, 0xb0, 0x76, 0x11, 0xc3, 0xb7, 0x85, 0x61,
	0x91, 0xda, 0xe3, 0xae, 0xa3, 0xf4, 0x17, 0x1d, 0xa0, 0x52, 0x7e, 0xf0, 0x31, 0x0d, 0x5a, 0xac,
	0x4e, 0xc9, 0x0f, 0x21, 0x7b, 0x40, 0xc3, 0xc7, 0xa7, 0x8c, 0x63, 0x27, 0xb4, 0xd1, 0xbf, 0x05,
	0x54, 0x1b, 0xd7, 0xda, 0x2b, 0xde, 0x77, 0xfc, 0xf0, 0x3c, 0x9f, 0x74, 0x9c, 0x88, 0xd9, 0xfa,
	0xf5, 0x9f, 0xfe, 0xf3, 0xdf, 0x5f, 0xa4, 0x56, 0xc8, 0x12, 0x36, 0x5c, 0xcc, 0x74, 0x44, 0x23,
	0xc8, 0xa9, 0x7d, 0x62, 0x88, 0xba, 0x45, 0xce, 0x60, 0xe6, 0x80, 0x86, 0x88, 0x73, 0x23, 0x19,
	0xa7, 0x72, 0xef, 0x11, 0x1e, 0xe1, 0x7c, 0x38, 0xd6, 0x3a, 0x62, 0xe5, 0xc8, 0x72, 0x14, 0x4b,
	0xc0, 0x70, 0xe3, 0x39, 0xb3, 0x5e, 0x10, 0x06, 0xf0, 0xc4, 0xb7, 0xcc, 0x90, 0x22, 0xde, 0x30,
	0x53, 0xc3, 0x71, 0x36, 0x11, 0x67, 0xb5, 0x94, 0x80, 0xf3, 0x2d, 0x6d, 0x87, 0xfc, 0x59, 0x83,
	0xa5, 0xd8, 0x1b, 0x3d, 0xb9, 0x93, 0x60, 0x79, 0xd8, 0xfd, 0x3f, 0x3f, 0x2a, 0x06, 0xba, 0x81,
	0x94, 0xde, 0xd6, 0xdf, 0xec, 0xa7, 0xb4, 0x2b, 0x7b, 0xb4, 0x5d, 0x6c, 0xe0, 0x0c, 0x6c, 0xe0,
	0xce, 0x05, 0xc1, 0xdf, 0x6a, 0xb0, 0x59, 0xa5, 0x9c, 0xba, 0x56, 0x1f, 0xa4, 0x6c, 0xe4, 0xea,
	0x98, 0x57, 0xa3, 0x63, 0xff, 0xaa, 0x88, 0x05, 0x48, 0x45, 0x10, 0xfb, 0x95, 0x06, 0x20, 0x2a,
	0x31, 0x5e, 0x72, 0x39, 0xb9, 0x99, 0x0c, 0x20, 0xb4, 0xda, 0x79, 0x51, 0x18, 0x76, 0x63, 0x17,
	0x8a, 0xfa, 0x37, 0x91, 0x88, 0x41, 0x76, 0xa3, 0x44, 0xa2, 0x65, 0x98, 0x1b, 0xcf, 0xeb, 0x9e,
	0x1b, 0xd2, 0x67, 0x61, 0x8d, 0x59, 0x2f, 0x8c, 0x86, 0xc4, 0x77, 0x21, 0x7d, 0x40, 0x25, 0x99,
	0xf1, 0x32, 0x74, 0x68, 0xef, 0xa0, 0x6f, 0x20, 0x8b, 0x6b, 0x64, 0x25, 0xca, 0x42, 0x42, 0xc9,
	0x1c, 0xfd, 0x85, 0x06, 0x59, 0x79, 0x94, 0x48, 0xcc, 0xa1, 0xe6, 0x46, 0x80, 0xbd, 0x87, 0x60,
	0xef, 0xe8, 0xa5, 0x21, 0x4b, 0xee, 0x3b, 0x9f, 0xda, 0xeb, 0x16, 0x91, 0x70, 0x20, 0x2b, 0xb7,
	0xcb, 0xe5, 0x99, 0xe8, 0xc8, 0x64, 0xad, 0x94, 0xb4, 0x6c, 0x01, 0x17, 0x42, 0x56, 0xde, 0x66,
	0x2f, 0xe0, 0xec, 0x91, 0xe9, 0xa7, 0xfc, 0xbd, 0x93, 0xe8, 0xef, 0xdf, 0x68, 0xb0, 0xd0, 0x49,
	0x37, 0xd5, 0x53, 0x8d, 0x9b, 0x74, 0x6f, 0x0d, 0x5b, 0x73, 0xb7, 0x91, 0x6b, 0xef, 0x01, 0xb2,
	0x15, 0x47, 0x22, 0x9a, 0x73, 0x8e, 0xc2, 0xff, 0xb5, 0x06, 0xf3, 0x65, 0xcb, 0xea, 0xe1, 0xb4,
	0x33, 0x1a, 0x8c, 0x8f, 0x5d, 0x2e, 0x6e, 0x23, 0xa3, 0x1d, 0xfd, 0x66, 0x1c, 0xa3, 0x76, 0x1f,
	0xd9, 0xe1, 0x23, 0xa2, 0xf3, 0x85, 0x06, 0x24, 0x12, 0x9e, 0xd7, 0xc9, 0x6a, 0x67, 0x7c, 0x56,
	0x7f, 0xd4, 0x60, 0xbe, 0xaf, 0x09, 0x27, 0xbb, 0x09, 0x94, 0xe2, 0x9b, 0xf5, 0xfc, 0x66, 0x32,
	0xab, 0xef, 0x53, 0xfe, 0x28, 0x78, 0xe8, 0xe9, 0xef, 0x20, 0xaf, 0x3d, 0x62, 0x8c, 0xc5, 0xcb,
	0x78, 0xae, 0x2e, 0xe8, 0x2f, 0xc8, 0xe7, 0x1a, 0x64, 0x44, 0x06, 0x88, 0x7b, 0xff, 0xd8, 0x59,
	0xb5, 0x31, 0xa4, 0x79, 0xc0, 0x74, 0xfa, 0x06, 0xd2, 0x29, 0x92, 0x5b, 0x63, 0x56, 0xb2, 0x00,
	0xd1, 0xe5, 0x49, 0x8b, 0x7d, 0xf7, 0xa5, 0x4e, 0x5a, 0x61, 0x21, 0xfe, 0xa4, 0x45, 0x1c, 0xb9,
	0xab, 0x7e, 0xa6, 0x01, 0xc8, 0x2a, 0x86, 0x80, 0xc3, 0x6c, 0x0d, 0x07, 0xfa, 0x36, 0x02, 0xdd,
	0xd5, 0xf7, 0x2e, 0x52, 0xc2, 0x90, 0x88, 0x48, 0x8f, 0xce, 0x81, 0x7f, 0x49, 0x16, 0xb1, 0x07,
	0x7e, 0x77, 0xb9, 0x02, 0x2a, 0x00, 0x90, 0xdb, 0x63, 0x7c, 0x0f, 0x8f, 0xdc, 0x0f, 0xca, 0xcb,
	0x3b, 0x49, 0x5e, 0x76, 0x21, 0x73, 0x40, 0x43, 0xd5, 0x22, 0xbf, 0x99, 0x6c, 0xed, 0x49, 0xf5,
	0xb0, 0x8d, 0x99, 0xd4, 0xcf, 0x48, 0x23, 0xfa, 0x1a, 0x22, 0x2e, 0x93, 0xab, 0x51, 0x44, 0x5f,
	0x8c, 0x31, 0xca, 0xc9, 0xcf, 0x65, 0x59, 0x8a, 0xb6, 0xc9, 0x89, 0x05, 0x20, 0xa6, 0x97, 0x1e,
	0x05, 0xbe, 0x8d, 0xe0, 0xba, 0x7e, 0x3d, 0x0e, 0xdc, 0x68, 0xb7, 0xcb, 0xc2, 0xd9, 0x9f, 0x77,
	0x8a, 0xd1, 0x6b, 0xe6, 0xb2, 0x33, 0x9a, 0xcb, 0x1f, 0x34, 0x58, 0x39, 0xa0, 0xe1, 0xfd, 0x93,
	0x13, 0x5a, 0x0f, 0x59, 0x8b, 0x46, 0x1e, 0xc9, 0xc6, 0x8c, 0xc9, 0xcd, 0x24, 0x2a, 0x3d, 0x2f,
	0x73, 0x7a, 0x09, 0x29, 0xdd, 0x22, 0x3b, 0xb1, 0x94, 0x68, 0x1b, 0x7f, 0x37, 0xfa, 0xa0, 0xf5,
	0x4b, 0x0d, 0xe6, 0x7a, 0x1f, 0xee, 0xc8, 0xad, 0x04, 0xb4, 0xd8, 0xf7, 0xbd, 0x71, 0xaa, 0xa3,
	0x72, 0x15, 0x29, 0xc4, 0xf2, 0x8a, 0xb2, 0xf9, 0x0c, 0xe6, 0xc5, 0x4a, 0xa2, 0x6c, 0x46, 0x5e,
	0x30, 0xc7, 0x74, 0x4e, 0xec, 0xbd, 0x2a, 0x8a, 0x1d, 0x42, 0x56, 0x28, 0xca, 0x9e, 0x68, 0xec,
	0x5a, 0xbc, 0x39, 0xb4, 0xfd, 0x47, 0xe4, 0x55, 0x44, 0x5e, 0x22, 0x8b, 0x51, 0x64, 0xf9, 0x0f,
	0x05, 0x4e, 0x3e, 0xc5, 0x1d, 0xaa, 0x1e, 0x77, 0xc6, 0x2a, 0x0a, 0xc3, 0x1f, 0x1c, 0xf4, 0x02,
	0xa2, 0xe5, 0x49, 0x2e, 0x06, 0x4d, 0x16, 0x85, 0x1f, 0xc1, 0x6c, 0xf4, 0x29, 0x22, 0x71, 0x53,
	0xc4, 0xbc, 0x57, 0xe4, 0x6f, 0x0c, 0x05, 0x97, 0x4f, 0x08, 0xed, 0xaa, 0xa4, 0xc7, 0x2d, 0x58,
	0x6c, 0x88, 0x17, 0x30, 0x1b, 0xed, 0x3f, 0x5f, 0x51, 0x2d, 0xdc, 0x42, 0xd4, 0x4d, 0x7d, 0x23,
	0x69, 0xe1, 0x86, 0x7c, 0xe0, 0x21, 0x2d, 0x98, 0x95, 0xa5, 0xe1, 0x95, 0xc2, 0x2b, 0xbf, 0xef,
	0x24, 0xfb, 0xfd, 0xaf, 0x1a, 0x90, 0xc1, 0xf7, 0x0a, 0x72, 0x3b, 0xc9, 0xa5, 0x49, 0x8f, 0x2b,
	0xf9, 0xbd, 0x0b, 0xcc, 0x90, 0xef, 0x05, 0xfa, 0x2e, 0xb2, 0xdb, 0xea, 0xbd, 0xce, 0xf5, 0x38,
	0xc7, 0x8c, 0x4c, 0x26, 0x7f, 0xd2, 0x60, 0xa1, 0xff, 0xed, 0x81, 0x14, 0x93, 0x8a, 0x67, 0xfc,
	0x93, 0x48, 0xde, 0x18, 0x5b, 0x5f, 0x91, 0x6c, 0x97, 0xf7, 0x9e, 0x3a, 0x81, 0x0f, 0x10, 0xdc,
	0x78, 0x8e, 0x7f, 0x45, 0x0c, 0x5d, 0xfa, 0x54, 0x5c, 0x7f, 0xdf, 0x18, 0x78, 0xc2, 0x20, 0xc9,
	0x80, 0xf1, 0x8f, 0x1d, 0xa3, 0x83, 0xfa, 0x36, 0x32, 0xba, 0xa1, 0x6f, 0x0e, 0x65, 0x24, 0xac,
	0x7f, 0xb0, 0xff, 0xf7, 0x97, 0xeb, 0xda, 0x3f, 0x5e, 0xae, 0x6b, 0xff, 0x7a, 0xb9, 0xae, 0xfd,
	0xfe, 0xcb, 0xf5, 0xff, 0xfb, 0xc1, 0x56, 0xe4, 0x5f, 0xd0, 0x6d, 0x9c, 0x5d, 0xc7, 0x74, 0xcd,
	0x06, 0xb5, 0x84, 0x3d, 0xae, 0x0c, 0x1e, 0x4f, 0xe3, 0x73, 0xcd, 0x9d, 0xff, 0x05, 0x00, 0x00,
	0xff, 0xff, 0xb5, 0xea, 0x8d, 0x82, 0x2b, 0x1f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// IAMServiceClient is the client API for IAMService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IAMServiceClient interface {
	// Fetch all available information of the currently authenticated user.
	// Required permissions:
	// - None
	GetThisUser(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*User, error)
	// Fetch all available information of the user identified by the given ID.
	// Required permissions:
	// - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of
	GetUser(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*User, error)
	// Update a user
	// Required permissions:
	// - None if the given user is the authenticated user.
	// or
	// - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of and
	// - iam.user.update on organization on one of the organizations that the requested user and authenticated user are both a member of
	UpdateUser(ctx context.Context, in *User, opts ...grpc.CallOption) (*User, error)
	// Verify the mobile phone number of a user, by provided the unique
	// code that was send to the number.
	// If the code is valid an empty result is returned, otherwise an InvalidArgument error is returned.
	// The authenticated user is always the subject of this request.
	// Required permissions:
	// - None (since the subject is always the authenticated user).
	VerifyUserMobilePhone(ctx context.Context, in *VerifyUserMobilePhoneRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Resend a verification code to the mobile phone number listed for the
	// authenticated user.
	// Required permissions:
	// - None (since the subject is always the authenticated user).
	ResendUserMobilePhoneVerification(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch all groups of the organization identified by the given context ID.
	// Required permissions:
	// - iam.group.list on organization identified by given context ID.
	ListGroups(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupList, error)
	// Fetch a group by its id.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	GetGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Group, error)
	// Create a group
	// Required permissions:
	// - iam.group.create on organization that owns the group
	CreateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error)
	// Update a group
	// Required permissions:
	// - iam.group.update on organization that owns the group
	UpdateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error)
	// Delete a group
	// Required permissions:
	// - iam.group.delete on organization that owns the group
	DeleteGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// List of members of the group identified by the given context ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	ListGroupMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupMemberList, error)
	// Add one or more members to the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	AddGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Remove one or more members from the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	DeleteGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Is the user identified by the given user ID a member of the group identified by the given group ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group, unless the requested user is identical to the authenticated user.
	// Note that if the identified group does not exist, no is returned.
	IsMemberOfGroup(ctx context.Context, in *IsMemberOfGroupRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error)
	// Fetch all roles in the organization identified by the given context ID.
	// Required permissions:
	// - iam.role.list on organization identified by given context ID.
	ListRoles(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*RoleList, error)
	// Fetch a role by its id.
	// Required permissions:
	// - iam.role.get on organization that owns the role
	GetRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Role, error)
	// Create a custom role
	// Required permissions:
	// - iam.role.create on organization that owns the role
	CreateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error)
	// Update a custom role
	// Required permissions:
	// - iam.role.update on organization that owns the role
	UpdateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error)
	// Delete a custom role
	// Required permissions:
	// - iam.role.delete on organization that owns the role
	DeleteRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Get the policy for a resource identified by given URL.
	// Required permissions:
	// - iam.policy.get on resource identified by the url
	GetPolicy(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*Policy, error)
	// Add one or more RoleBindings to the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	AddRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error)
	// Remove one or more RoleBindings from the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	DeleteRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error)
	// Return the list of permissions that are available to the currently authenticated
	// used for actions on the resource identified by the given URL.
	// Required permissions:
	// - None
	GetEffectivePermissions(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*PermissionList, error)
	// Does the authenticated user have all of the requested permissions for the resource
	// identified by the given URL?
	// Required permissions:
	// - None
	HasPermissions(ctx context.Context, in *HasPermissionsRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error)
	// List all known permissions.
	// Required permissions:
	// - None
	ListPermissions(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*PermissionList, error)
	// Fetch all API keys owned by the authenticated caller.
	// Required permissions:
	// - None
	ListAPIKeys(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*APIKeyList, error)
	// Fetch an API key by its id.
	// The API key must be owned by the authenticated caller.
	// Required permissions:
	// - None
	GetAPIKey(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*APIKey, error)
	// Create a new API key.
	// The API key will be owned by the authenticated caller.
	// Required permissions:
	// - None
	CreateAPIKey(ctx context.Context, in *CreateAPIKeyRequest, opts ...grpc.CallOption) (*APIKeySecret, error)
	// Ensure that the expiration date of the API key identified by given ID
	// is either in the past or set to now.
	// The API key must be owned by the authenticated caller.
	// Required permissions:
	// - None
	RevokeAPIKey(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Delete the API key identified by given ID
	// The API key must be owned by the authenticated caller.
	// Required permissions:
	// - None
	DeleteAPIKey(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Authenticate using an API key.
	// If authentication succeeds, this function returns a bearer token.
	// That token must be used to authenticate all other API requests.
	// If the given API key identifier is invalid or expired, or an incorrect secret
	// is given, this function will return an unauthenticated error.
	// Required permissions:
	// - None
	AuthenticateAPIKey(ctx context.Context, in *AuthenticateAPIKeyRequest, opts ...grpc.CallOption) (*AuthenticateAPIKeyResponse, error)
	// Renew a non-expired API key authentication token.
	// This allows to extend the lifetime of a token created by AuthenticateAPIKey.
	// If the given token is invalid or expired, or the underlying API key is expired
	// this function will return an unauthenticated error.
	// Required permissions:
	// - None
	RenewAPIKeyToken(ctx context.Context, in *RenewAPIKeyTokenRequest, opts ...grpc.CallOption) (*RenewAPIKeyTokenResponse, error)
	// Revoke an API key authentication token.
	// This function will return a non-error response, even if the given token
	// is invalid or already expired.
	// Required permissions:
	// - None
	RevokeAPIKeyToken(ctx context.Context, in *RevokeAPIKeyTokenRequest, opts ...grpc.CallOption) (*v1.Empty, error)
}

type iAMServiceClient struct {
	cc *grpc.ClientConn
}

func NewIAMServiceClient(cc *grpc.ClientConn) IAMServiceClient {
	return &iAMServiceClient{cc}
}

func (c *iAMServiceClient) GetThisUser(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetThisUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetUser(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) UpdateUser(ctx context.Context, in *User, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/UpdateUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) VerifyUserMobilePhone(ctx context.Context, in *VerifyUserMobilePhoneRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/VerifyUserMobilePhone", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ResendUserMobilePhoneVerification(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ResendUserMobilePhoneVerification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListGroups(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupList, error) {
	out := new(GroupList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) CreateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/CreateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) UpdateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/UpdateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListGroupMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupMemberList, error) {
	out := new(GroupMemberList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) AddGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/AddGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) IsMemberOfGroup(ctx context.Context, in *IsMemberOfGroupRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error) {
	out := new(v1.YesOrNo)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/IsMemberOfGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListRoles(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*RoleList, error) {
	out := new(RoleList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) CreateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/CreateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) UpdateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/UpdateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetPolicy(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) AddRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/AddRoleBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteRoleBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetEffectivePermissions(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*PermissionList, error) {
	out := new(PermissionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetEffectivePermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) HasPermissions(ctx context.Context, in *HasPermissionsRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error) {
	out := new(v1.YesOrNo)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/HasPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListPermissions(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*PermissionList, error) {
	out := new(PermissionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListAPIKeys(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*APIKeyList, error) {
	out := new(APIKeyList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListAPIKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetAPIKey(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*APIKey, error) {
	out := new(APIKey)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetAPIKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) CreateAPIKey(ctx context.Context, in *CreateAPIKeyRequest, opts ...grpc.CallOption) (*APIKeySecret, error) {
	out := new(APIKeySecret)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/CreateAPIKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) RevokeAPIKey(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/RevokeAPIKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteAPIKey(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteAPIKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) AuthenticateAPIKey(ctx context.Context, in *AuthenticateAPIKeyRequest, opts ...grpc.CallOption) (*AuthenticateAPIKeyResponse, error) {
	out := new(AuthenticateAPIKeyResponse)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/AuthenticateAPIKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) RenewAPIKeyToken(ctx context.Context, in *RenewAPIKeyTokenRequest, opts ...grpc.CallOption) (*RenewAPIKeyTokenResponse, error) {
	out := new(RenewAPIKeyTokenResponse)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/RenewAPIKeyToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) RevokeAPIKeyToken(ctx context.Context, in *RevokeAPIKeyTokenRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/RevokeAPIKeyToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IAMServiceServer is the server API for IAMService service.
type IAMServiceServer interface {
	// Fetch all available information of the currently authenticated user.
	// Required permissions:
	// - None
	GetThisUser(context.Context, *v1.Empty) (*User, error)
	// Fetch all available information of the user identified by the given ID.
	// Required permissions:
	// - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of
	GetUser(context.Context, *v1.IDOptions) (*User, error)
	// Update a user
	// Required permissions:
	// - None if the given user is the authenticated user.
	// or
	// - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of and
	// - iam.user.update on organization on one of the organizations that the requested user and authenticated user are both a member of
	UpdateUser(context.Context, *User) (*User, error)
	// Verify the mobile phone number of a user, by provided the unique
	// code that was send to the number.
	// If the code is valid an empty result is returned, otherwise an InvalidArgument error is returned.
	// The authenticated user is always the subject of this request.
	// Required permissions:
	// - None (since the subject is always the authenticated user).
	VerifyUserMobilePhone(context.Context, *VerifyUserMobilePhoneRequest) (*v1.Empty, error)
	// Resend a verification code to the mobile phone number listed for the
	// authenticated user.
	// Required permissions:
	// - None (since the subject is always the authenticated user).
	ResendUserMobilePhoneVerification(context.Context, *v1.Empty) (*v1.Empty, error)
	// Fetch all groups of the organization identified by the given context ID.
	// Required permissions:
	// - iam.group.list on organization identified by given context ID.
	ListGroups(context.Context, *v1.ListOptions) (*GroupList, error)
	// Fetch a group by its id.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	GetGroup(context.Context, *v1.IDOptions) (*Group, error)
	// Create a group
	// Required permissions:
	// - iam.group.create on organization that owns the group
	CreateGroup(context.Context, *Group) (*Group, error)
	// Update a group
	// Required permissions:
	// - iam.group.update on organization that owns the group
	UpdateGroup(context.Context, *Group) (*Group, error)
	// Delete a group
	// Required permissions:
	// - iam.group.delete on organization that owns the group
	DeleteGroup(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// List of members of the group identified by the given context ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	ListGroupMembers(context.Context, *v1.ListOptions) (*GroupMemberList, error)
	// Add one or more members to the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	AddGroupMembers(context.Context, *GroupMembersRequest) (*v1.Empty, error)
	// Remove one or more members from the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	DeleteGroupMembers(context.Context, *GroupMembersRequest) (*v1.Empty, error)
	// Is the user identified by the given user ID a member of the group identified by the given group ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group, unless the requested user is identical to the authenticated user.
	// Note that if the identified group does not exist, no is returned.
	IsMemberOfGroup(context.Context, *IsMemberOfGroupRequest) (*v1.YesOrNo, error)
	// Fetch all roles in the organization identified by the given context ID.
	// Required permissions:
	// - iam.role.list on organization identified by given context ID.
	ListRoles(context.Context, *v1.ListOptions) (*RoleList, error)
	// Fetch a role by its id.
	// Required permissions:
	// - iam.role.get on organization that owns the role
	GetRole(context.Context, *v1.IDOptions) (*Role, error)
	// Create a custom role
	// Required permissions:
	// - iam.role.create on organization that owns the role
	CreateRole(context.Context, *Role) (*Role, error)
	// Update a custom role
	// Required permissions:
	// - iam.role.update on organization that owns the role
	UpdateRole(context.Context, *Role) (*Role, error)
	// Delete a custom role
	// Required permissions:
	// - iam.role.delete on organization that owns the role
	DeleteRole(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Get the policy for a resource identified by given URL.
	// Required permissions:
	// - iam.policy.get on resource identified by the url
	GetPolicy(context.Context, *v1.URLOptions) (*Policy, error)
	// Add one or more RoleBindings to the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	AddRoleBindings(context.Context, *RoleBindingsRequest) (*Policy, error)
	// Remove one or more RoleBindings from the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	DeleteRoleBindings(context.Context, *RoleBindingsRequest) (*Policy, error)
	// Return the list of permissions that are available to the currently authenticated
	// used for actions on the resource identified by the given URL.
	// Required permissions:
	// - None
	GetEffectivePermissions(context.Context, *v1.URLOptions) (*PermissionList, error)
	// Does the authenticated user have all of the requested permissions for the resource
	// identified by the given URL?
	// Required permissions:
	// - None
	HasPermissions(context.Context, *HasPermissionsRequest) (*v1.YesOrNo, error)
	// List all known permissions.
	// Required permissions:
	// - None
	ListPermissions(context.Context, *v1.Empty) (*PermissionList, error)
	// Fetch all API keys owned by the authenticated caller.
	// Required permissions:
	// - None
	ListAPIKeys(context.Context, *v1.ListOptions) (*APIKeyList, error)
	// Fetch an API key by its id.
	// The API key must be owned by the authenticated caller.
	// Required permissions:
	// - None
	GetAPIKey(context.Context, *v1.IDOptions) (*APIKey, error)
	// Create a new API key.
	// The API key will be owned by the authenticated caller.
	// Required permissions:
	// - None
	CreateAPIKey(context.Context, *CreateAPIKeyRequest) (*APIKeySecret, error)
	// Ensure that the expiration date of the API key identified by given ID
	// is either in the past or set to now.
	// The API key must be owned by the authenticated caller.
	// Required permissions:
	// - None
	RevokeAPIKey(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Delete the API key identified by given ID
	// The API key must be owned by the authenticated caller.
	// Required permissions:
	// - None
	DeleteAPIKey(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Authenticate using an API key.
	// If authentication succeeds, this function returns a bearer token.
	// That token must be used to authenticate all other API requests.
	// If the given API key identifier is invalid or expired, or an incorrect secret
	// is given, this function will return an unauthenticated error.
	// Required permissions:
	// - None
	AuthenticateAPIKey(context.Context, *AuthenticateAPIKeyRequest) (*AuthenticateAPIKeyResponse, error)
	// Renew a non-expired API key authentication token.
	// This allows to extend the lifetime of a token created by AuthenticateAPIKey.
	// If the given token is invalid or expired, or the underlying API key is expired
	// this function will return an unauthenticated error.
	// Required permissions:
	// - None
	RenewAPIKeyToken(context.Context, *RenewAPIKeyTokenRequest) (*RenewAPIKeyTokenResponse, error)
	// Revoke an API key authentication token.
	// This function will return a non-error response, even if the given token
	// is invalid or already expired.
	// Required permissions:
	// - None
	RevokeAPIKeyToken(context.Context, *RevokeAPIKeyTokenRequest) (*v1.Empty, error)
}

// UnimplementedIAMServiceServer can be embedded to have forward compatible implementations.
type UnimplementedIAMServiceServer struct {
}

func (*UnimplementedIAMServiceServer) GetThisUser(ctx context.Context, req *v1.Empty) (*User, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetThisUser not implemented")
}
func (*UnimplementedIAMServiceServer) GetUser(ctx context.Context, req *v1.IDOptions) (*User, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUser not implemented")
}
func (*UnimplementedIAMServiceServer) UpdateUser(ctx context.Context, req *User) (*User, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUser not implemented")
}
func (*UnimplementedIAMServiceServer) VerifyUserMobilePhone(ctx context.Context, req *VerifyUserMobilePhoneRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyUserMobilePhone not implemented")
}
func (*UnimplementedIAMServiceServer) ResendUserMobilePhoneVerification(ctx context.Context, req *v1.Empty) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResendUserMobilePhoneVerification not implemented")
}
func (*UnimplementedIAMServiceServer) ListGroups(ctx context.Context, req *v1.ListOptions) (*GroupList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroups not implemented")
}
func (*UnimplementedIAMServiceServer) GetGroup(ctx context.Context, req *v1.IDOptions) (*Group, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroup not implemented")
}
func (*UnimplementedIAMServiceServer) CreateGroup(ctx context.Context, req *Group) (*Group, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGroup not implemented")
}
func (*UnimplementedIAMServiceServer) UpdateGroup(ctx context.Context, req *Group) (*Group, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGroup not implemented")
}
func (*UnimplementedIAMServiceServer) DeleteGroup(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGroup not implemented")
}
func (*UnimplementedIAMServiceServer) ListGroupMembers(ctx context.Context, req *v1.ListOptions) (*GroupMemberList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroupMembers not implemented")
}
func (*UnimplementedIAMServiceServer) AddGroupMembers(ctx context.Context, req *GroupMembersRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddGroupMembers not implemented")
}
func (*UnimplementedIAMServiceServer) DeleteGroupMembers(ctx context.Context, req *GroupMembersRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGroupMembers not implemented")
}
func (*UnimplementedIAMServiceServer) IsMemberOfGroup(ctx context.Context, req *IsMemberOfGroupRequest) (*v1.YesOrNo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsMemberOfGroup not implemented")
}
func (*UnimplementedIAMServiceServer) ListRoles(ctx context.Context, req *v1.ListOptions) (*RoleList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoles not implemented")
}
func (*UnimplementedIAMServiceServer) GetRole(ctx context.Context, req *v1.IDOptions) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRole not implemented")
}
func (*UnimplementedIAMServiceServer) CreateRole(ctx context.Context, req *Role) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRole not implemented")
}
func (*UnimplementedIAMServiceServer) UpdateRole(ctx context.Context, req *Role) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRole not implemented")
}
func (*UnimplementedIAMServiceServer) DeleteRole(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRole not implemented")
}
func (*UnimplementedIAMServiceServer) GetPolicy(ctx context.Context, req *v1.URLOptions) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicy not implemented")
}
func (*UnimplementedIAMServiceServer) AddRoleBindings(ctx context.Context, req *RoleBindingsRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddRoleBindings not implemented")
}
func (*UnimplementedIAMServiceServer) DeleteRoleBindings(ctx context.Context, req *RoleBindingsRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRoleBindings not implemented")
}
func (*UnimplementedIAMServiceServer) GetEffectivePermissions(ctx context.Context, req *v1.URLOptions) (*PermissionList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEffectivePermissions not implemented")
}
func (*UnimplementedIAMServiceServer) HasPermissions(ctx context.Context, req *HasPermissionsRequest) (*v1.YesOrNo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HasPermissions not implemented")
}
func (*UnimplementedIAMServiceServer) ListPermissions(ctx context.Context, req *v1.Empty) (*PermissionList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPermissions not implemented")
}
func (*UnimplementedIAMServiceServer) ListAPIKeys(ctx context.Context, req *v1.ListOptions) (*APIKeyList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAPIKeys not implemented")
}
func (*UnimplementedIAMServiceServer) GetAPIKey(ctx context.Context, req *v1.IDOptions) (*APIKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIKey not implemented")
}
func (*UnimplementedIAMServiceServer) CreateAPIKey(ctx context.Context, req *CreateAPIKeyRequest) (*APIKeySecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAPIKey not implemented")
}
func (*UnimplementedIAMServiceServer) RevokeAPIKey(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeAPIKey not implemented")
}
func (*UnimplementedIAMServiceServer) DeleteAPIKey(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAPIKey not implemented")
}
func (*UnimplementedIAMServiceServer) AuthenticateAPIKey(ctx context.Context, req *AuthenticateAPIKeyRequest) (*AuthenticateAPIKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AuthenticateAPIKey not implemented")
}
func (*UnimplementedIAMServiceServer) RenewAPIKeyToken(ctx context.Context, req *RenewAPIKeyTokenRequest) (*RenewAPIKeyTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenewAPIKeyToken not implemented")
}
func (*UnimplementedIAMServiceServer) RevokeAPIKeyToken(ctx context.Context, req *RevokeAPIKeyTokenRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeAPIKeyToken not implemented")
}

func RegisterIAMServiceServer(s *grpc.Server, srv IAMServiceServer) {
	s.RegisterService(&_IAMService_serviceDesc, srv)
}

func _IAMService_GetThisUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetThisUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetThisUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetThisUser(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetUser(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_UpdateUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(User)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).UpdateUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/UpdateUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).UpdateUser(ctx, req.(*User))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_VerifyUserMobilePhone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyUserMobilePhoneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).VerifyUserMobilePhone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/VerifyUserMobilePhone",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).VerifyUserMobilePhone(ctx, req.(*VerifyUserMobilePhoneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ResendUserMobilePhoneVerification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ResendUserMobilePhoneVerification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ResendUserMobilePhoneVerification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ResendUserMobilePhoneVerification(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListGroups(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetGroup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/CreateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).CreateGroup(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).UpdateGroup(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteGroup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListGroupMembers(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_AddGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).AddGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/AddGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).AddGroupMembers(ctx, req.(*GroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteGroupMembers(ctx, req.(*GroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_IsMemberOfGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsMemberOfGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).IsMemberOfGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/IsMemberOfGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).IsMemberOfGroup(ctx, req.(*IsMemberOfGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListRoles(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetRole(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_CreateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Role)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).CreateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/CreateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).CreateRole(ctx, req.(*Role))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_UpdateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Role)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).UpdateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/UpdateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).UpdateRole(ctx, req.(*Role))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteRole(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.URLOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetPolicy(ctx, req.(*v1.URLOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_AddRoleBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RoleBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).AddRoleBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/AddRoleBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).AddRoleBindings(ctx, req.(*RoleBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteRoleBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RoleBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteRoleBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteRoleBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteRoleBindings(ctx, req.(*RoleBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetEffectivePermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.URLOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetEffectivePermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetEffectivePermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetEffectivePermissions(ctx, req.(*v1.URLOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_HasPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).HasPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/HasPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).HasPermissions(ctx, req.(*HasPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListPermissions(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListAPIKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListAPIKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListAPIKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListAPIKeys(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetAPIKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetAPIKey(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_CreateAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).CreateAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/CreateAPIKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).CreateAPIKey(ctx, req.(*CreateAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_RevokeAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).RevokeAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/RevokeAPIKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).RevokeAPIKey(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteAPIKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteAPIKey(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_AuthenticateAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuthenticateAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).AuthenticateAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/AuthenticateAPIKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).AuthenticateAPIKey(ctx, req.(*AuthenticateAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_RenewAPIKeyToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenewAPIKeyTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).RenewAPIKeyToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/RenewAPIKeyToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).RenewAPIKeyToken(ctx, req.(*RenewAPIKeyTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_RevokeAPIKeyToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeAPIKeyTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).RevokeAPIKeyToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/RevokeAPIKeyToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).RevokeAPIKeyToken(ctx, req.(*RevokeAPIKeyTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IAMService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.iam.v1.IAMService",
	HandlerType: (*IAMServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetThisUser",
			Handler:    _IAMService_GetThisUser_Handler,
		},
		{
			MethodName: "GetUser",
			Handler:    _IAMService_GetUser_Handler,
		},
		{
			MethodName: "UpdateUser",
			Handler:    _IAMService_UpdateUser_Handler,
		},
		{
			MethodName: "VerifyUserMobilePhone",
			Handler:    _IAMService_VerifyUserMobilePhone_Handler,
		},
		{
			MethodName: "ResendUserMobilePhoneVerification",
			Handler:    _IAMService_ResendUserMobilePhoneVerification_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _IAMService_ListGroups_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _IAMService_GetGroup_Handler,
		},
		{
			MethodName: "CreateGroup",
			Handler:    _IAMService_CreateGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _IAMService_UpdateGroup_Handler,
		},
		{
			MethodName: "DeleteGroup",
			Handler:    _IAMService_DeleteGroup_Handler,
		},
		{
			MethodName: "ListGroupMembers",
			Handler:    _IAMService_ListGroupMembers_Handler,
		},
		{
			MethodName: "AddGroupMembers",
			Handler:    _IAMService_AddGroupMembers_Handler,
		},
		{
			MethodName: "DeleteGroupMembers",
			Handler:    _IAMService_DeleteGroupMembers_Handler,
		},
		{
			MethodName: "IsMemberOfGroup",
			Handler:    _IAMService_IsMemberOfGroup_Handler,
		},
		{
			MethodName: "ListRoles",
			Handler:    _IAMService_ListRoles_Handler,
		},
		{
			MethodName: "GetRole",
			Handler:    _IAMService_GetRole_Handler,
		},
		{
			MethodName: "CreateRole",
			Handler:    _IAMService_CreateRole_Handler,
		},
		{
			MethodName: "UpdateRole",
			Handler:    _IAMService_UpdateRole_Handler,
		},
		{
			MethodName: "DeleteRole",
			Handler:    _IAMService_DeleteRole_Handler,
		},
		{
			MethodName: "GetPolicy",
			Handler:    _IAMService_GetPolicy_Handler,
		},
		{
			MethodName: "AddRoleBindings",
			Handler:    _IAMService_AddRoleBindings_Handler,
		},
		{
			MethodName: "DeleteRoleBindings",
			Handler:    _IAMService_DeleteRoleBindings_Handler,
		},
		{
			MethodName: "GetEffectivePermissions",
			Handler:    _IAMService_GetEffectivePermissions_Handler,
		},
		{
			MethodName: "HasPermissions",
			Handler:    _IAMService_HasPermissions_Handler,
		},
		{
			MethodName: "ListPermissions",
			Handler:    _IAMService_ListPermissions_Handler,
		},
		{
			MethodName: "ListAPIKeys",
			Handler:    _IAMService_ListAPIKeys_Handler,
		},
		{
			MethodName: "GetAPIKey",
			Handler:    _IAMService_GetAPIKey_Handler,
		},
		{
			MethodName: "CreateAPIKey",
			Handler:    _IAMService_CreateAPIKey_Handler,
		},
		{
			MethodName: "RevokeAPIKey",
			Handler:    _IAMService_RevokeAPIKey_Handler,
		},
		{
			MethodName: "DeleteAPIKey",
			Handler:    _IAMService_DeleteAPIKey_Handler,
		},
		{
			MethodName: "AuthenticateAPIKey",
			Handler:    _IAMService_AuthenticateAPIKey_Handler,
		},
		{
			MethodName: "RenewAPIKeyToken",
			Handler:    _IAMService_RenewAPIKeyToken_Handler,
		},
		{
			MethodName: "RevokeAPIKeyToken",
			Handler:    _IAMService_RevokeAPIKeyToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "iam.proto",
}

func (m *User) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *User) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *User) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LastIp) > 0 {
		i -= len(m.LastIp)
		copy(dAtA[i:], m.LastIp)
		i = encodeVarintIam(dAtA, i, uint64(len(m.LastIp)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.LastLoginAt != nil {
		{
			size, err := m.LastLoginAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x7a
	}
	if len(m.SlackName) > 0 {
		i -= len(m.SlackName)
		copy(dAtA[i:], m.SlackName)
		i = encodeVarintIam(dAtA, i, uint64(len(m.SlackName)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.ApikeyId) > 0 {
		i -= len(m.ApikeyId)
		copy(dAtA[i:], m.ApikeyId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.ApikeyId)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.DashboardAccessDeniedReason) > 0 {
		i -= len(m.DashboardAccessDeniedReason)
		copy(dAtA[i:], m.DashboardAccessDeniedReason)
		i = encodeVarintIam(dAtA, i, uint64(len(m.DashboardAccessDeniedReason)))
		i--
		dAtA[i] = 0x62
	}
	if m.DashboardAccessDenied {
		i--
		if m.DashboardAccessDenied {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.CompanyName) > 0 {
		i -= len(m.CompanyName)
		copy(dAtA[i:], m.CompanyName)
		i = encodeVarintIam(dAtA, i, uint64(len(m.CompanyName)))
		i--
		dAtA[i] = 0x52
	}
	if m.MobilePhoneVerified {
		i--
		if m.MobilePhoneVerified {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if len(m.MobilePhone) > 0 {
		i -= len(m.MobilePhone)
		copy(dAtA[i:], m.MobilePhone)
		i = encodeVarintIam(dAtA, i, uint64(len(m.MobilePhone)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.AdditionalEmails) > 0 {
		for iNdEx := len(m.AdditionalEmails) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AdditionalEmails[iNdEx])
			copy(dAtA[i:], m.AdditionalEmails[iNdEx])
			i = encodeVarintIam(dAtA, i, uint64(len(m.AdditionalEmails[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.FamilyName) > 0 {
		i -= len(m.FamilyName)
		copy(dAtA[i:], m.FamilyName)
		i = encodeVarintIam(dAtA, i, uint64(len(m.FamilyName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.GivenName) > 0 {
		i -= len(m.GivenName)
		copy(dAtA[i:], m.GivenName)
		i = encodeVarintIam(dAtA, i, uint64(len(m.GivenName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Email) > 0 {
		i -= len(m.Email)
		copy(dAtA[i:], m.Email)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Email)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VerifyUserMobilePhoneRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerifyUserMobilePhoneRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VerifyUserMobilePhoneRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Code) > 0 {
		i -= len(m.Code)
		copy(dAtA[i:], m.Code)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Code)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Group) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Group) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Group) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsVirtual {
		i--
		if m.IsVirtual {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x42
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIam(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IsMemberOfGroupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsMemberOfGroupRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IsMemberOfGroupRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.GroupId) > 0 {
		i -= len(m.GroupId)
		copy(dAtA[i:], m.GroupId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.GroupId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.UserId) > 0 {
		i -= len(m.UserId)
		copy(dAtA[i:], m.UserId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.UserId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GroupMemberList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMemberList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMemberList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Items[iNdEx])
			copy(dAtA[i:], m.Items[iNdEx])
			i = encodeVarintIam(dAtA, i, uint64(len(m.Items[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GroupMembersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMembersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GroupMembersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.UserIds) > 0 {
		for iNdEx := len(m.UserIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.UserIds[iNdEx])
			copy(dAtA[i:], m.UserIds[iNdEx])
			i = encodeVarintIam(dAtA, i, uint64(len(m.UserIds[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.GroupId) > 0 {
		i -= len(m.GroupId)
		copy(dAtA[i:], m.GroupId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.GroupId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PermissionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PermissionList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PermissionList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Items[iNdEx])
			copy(dAtA[i:], m.Items[iNdEx])
			i = encodeVarintIam(dAtA, i, uint64(len(m.Items[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HasPermissionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HasPermissionsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HasPermissionsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Permissions) > 0 {
		for iNdEx := len(m.Permissions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Permissions[iNdEx])
			copy(dAtA[i:], m.Permissions[iNdEx])
			i = encodeVarintIam(dAtA, i, uint64(len(m.Permissions[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Role) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Role) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Role) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x52
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.IsPredefined {
		i--
		if m.IsPredefined {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Permissions) > 0 {
		for iNdEx := len(m.Permissions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Permissions[iNdEx])
			copy(dAtA[i:], m.Permissions[iNdEx])
			i = encodeVarintIam(dAtA, i, uint64(len(m.Permissions[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RoleList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RoleList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIam(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *RoleBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleBinding) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RoleBinding) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DeleteNotAllowed {
		i--
		if m.DeleteNotAllowed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.RoleId) > 0 {
		i -= len(m.RoleId)
		copy(dAtA[i:], m.RoleId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.RoleId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.MemberId) > 0 {
		i -= len(m.MemberId)
		copy(dAtA[i:], m.MemberId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.MemberId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Policy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Bindings) > 0 {
		for iNdEx := len(m.Bindings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Bindings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIam(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ResourceUrl) > 0 {
		i -= len(m.ResourceUrl)
		copy(dAtA[i:], m.ResourceUrl)
		i = encodeVarintIam(dAtA, i, uint64(len(m.ResourceUrl)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RoleBindingsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleBindingsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RoleBindingsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Bindings) > 0 {
		for iNdEx := len(m.Bindings) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Bindings[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIam(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ResourceUrl) > 0 {
		i -= len(m.ResourceUrl)
		copy(dAtA[i:], m.ResourceUrl)
		i = encodeVarintIam(dAtA, i, uint64(len(m.ResourceUrl)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *APIKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APIKey) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *APIKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsRevoked {
		i--
		if m.IsRevoked {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.RevokedAt != nil {
		{
			size, err := m.RevokedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.IsExpired {
		i--
		if m.IsExpired {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.ExpiresAt != nil {
		{
			size, err := m.ExpiresAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.IsReadonly {
		i--
		if m.IsReadonly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.UserId) > 0 {
		i -= len(m.UserId)
		copy(dAtA[i:], m.UserId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.UserId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *APIKeyList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APIKeyList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *APIKeyList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintIam(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CreateAPIKeyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreateAPIKeyRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreateAPIKeyRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TimeToLive != nil {
		{
			size, err := m.TimeToLive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Readonly {
		i--
		if m.Readonly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintIam(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *APIKeySecret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APIKeySecret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *APIKeySecret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Secret) > 0 {
		i -= len(m.Secret)
		copy(dAtA[i:], m.Secret)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Secret)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthenticateAPIKeyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthenticateAPIKeyRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthenticateAPIKeyRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TimeToLive != nil {
		{
			size, err := m.TimeToLive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Secret) > 0 {
		i -= len(m.Secret)
		copy(dAtA[i:], m.Secret)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Secret)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuthenticateAPIKeyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuthenticateAPIKeyResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuthenticateAPIKeyResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TimeToLive != nil {
		{
			size, err := m.TimeToLive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RenewAPIKeyTokenRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RenewAPIKeyTokenRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RenewAPIKeyTokenRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TimeToLive != nil {
		{
			size, err := m.TimeToLive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RenewAPIKeyTokenResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RenewAPIKeyTokenResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RenewAPIKeyTokenResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TimeToLive != nil {
		{
			size, err := m.TimeToLive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintIam(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RevokeAPIKeyTokenRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RevokeAPIKeyTokenRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RevokeAPIKeyTokenRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintIam(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintIam(dAtA []byte, offset int, v uint64) int {
	offset -= sovIam(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *User) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Email)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.GivenName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.FamilyName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.AdditionalEmails) > 0 {
		for _, s := range m.AdditionalEmails {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	l = len(m.MobilePhone)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.MobilePhoneVerified {
		n += 2
	}
	l = len(m.CompanyName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.DashboardAccessDenied {
		n += 2
	}
	l = len(m.DashboardAccessDeniedReason)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.ApikeyId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.SlackName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.LastLoginAt != nil {
		l = m.LastLoginAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.LastIp)
	if l > 0 {
		n += 2 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VerifyUserMobilePhoneRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Code)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Group) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsVirtual {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IsMemberOfGroupRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.GroupId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMemberList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMembersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.UserIds) > 0 {
		for _, s := range m.UserIds {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PermissionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HasPermissionsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Role) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.IsPredefined {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleBinding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.MemberId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.RoleId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.DeleteNotAllowed {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Policy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResourceUrl)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Bindings) > 0 {
		for _, e := range m.Bindings {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleBindingsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResourceUrl)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Bindings) > 0 {
		for _, e := range m.Bindings {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *APIKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsReadonly {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.ExpiresAt != nil {
		l = m.ExpiresAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsExpired {
		n += 2
	}
	if m.RevokedAt != nil {
		l = m.RevokedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsRevoked {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *APIKeyList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CreateAPIKeyRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.Readonly {
		n += 2
	}
	if m.TimeToLive != nil {
		l = m.TimeToLive.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *APIKeySecret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Secret)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthenticateAPIKeyRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Secret)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.TimeToLive != nil {
		l = m.TimeToLive.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuthenticateAPIKeyResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.TimeToLive != nil {
		l = m.TimeToLive.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RenewAPIKeyTokenRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.TimeToLive != nil {
		l = m.TimeToLive.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RenewAPIKeyTokenResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimeToLive != nil {
		l = m.TimeToLive.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RevokeAPIKeyTokenRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovIam(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozIam(x uint64) (n int) {
	return sovIam(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *User) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: User: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: User: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Email", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Email = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GivenName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GivenName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FamilyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FamilyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalEmails", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalEmails = append(m.AdditionalEmails, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MobilePhone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MobilePhone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MobilePhoneVerified", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MobilePhoneVerified = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompanyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompanyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DashboardAccessDenied", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DashboardAccessDenied = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DashboardAccessDeniedReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DashboardAccessDeniedReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApikeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApikeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlackName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SlackName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastLoginAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastLoginAt == nil {
				m.LastLoginAt = &types.Timestamp{}
			}
			if err := m.LastLoginAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VerifyUserMobilePhoneRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VerifyUserMobilePhoneRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VerifyUserMobilePhoneRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Code = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Group) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Group: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Group: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsVirtual", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsVirtual = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Group{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsMemberOfGroupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsMemberOfGroupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsMemberOfGroupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupMemberList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMemberList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMemberList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupMembersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMembersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMembersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserIds = append(m.UserIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PermissionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PermissionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PermissionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HasPermissionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HasPermissionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HasPermissionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = append(m.Permissions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Role) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Role: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Role: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = append(m.Permissions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsPredefined", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsPredefined = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Role{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleBinding) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleBinding: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleBinding: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoleId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RoleId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteNotAllowed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DeleteNotAllowed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bindings = append(m.Bindings, &RoleBinding{})
			if err := m.Bindings[len(m.Bindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleBindingsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleBindingsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleBindingsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bindings = append(m.Bindings, &RoleBinding{})
			if err := m.Bindings[len(m.Bindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *APIKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APIKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APIKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsReadonly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsReadonly = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiresAt == nil {
				m.ExpiresAt = &types.Timestamp{}
			}
			if err := m.ExpiresAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsExpired", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsExpired = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RevokedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RevokedAt == nil {
				m.RevokedAt = &types.Timestamp{}
			}
			if err := m.RevokedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRevoked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRevoked = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *APIKeyList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APIKeyList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APIKeyList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &APIKey{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreateAPIKeyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreateAPIKeyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreateAPIKeyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Readonly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Readonly = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLive == nil {
				m.TimeToLive = &types.Duration{}
			}
			if err := m.TimeToLive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *APIKeySecret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APIKeySecret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APIKeySecret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secret = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuthenticateAPIKeyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuthenticateAPIKeyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuthenticateAPIKeyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secret = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLive == nil {
				m.TimeToLive = &types.Duration{}
			}
			if err := m.TimeToLive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuthenticateAPIKeyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuthenticateAPIKeyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuthenticateAPIKeyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLive == nil {
				m.TimeToLive = &types.Duration{}
			}
			if err := m.TimeToLive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RenewAPIKeyTokenRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RenewAPIKeyTokenRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RenewAPIKeyTokenRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLive == nil {
				m.TimeToLive = &types.Duration{}
			}
			if err := m.TimeToLive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RenewAPIKeyTokenResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RenewAPIKeyTokenResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RenewAPIKeyTokenResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeToLive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeToLive == nil {
				m.TimeToLive = &types.Duration{}
			}
			if err := m.TimeToLive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RevokeAPIKeyTokenRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RevokeAPIKeyTokenRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RevokeAPIKeyTokenRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipIam(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowIam
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIam
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIam
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthIam
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthIam
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowIam
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipIam(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthIam
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthIam = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowIam   = fmt.Errorf("proto: integer overflow")
)
