// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: support.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Plan represents a specific support plan such as Bronze, Silver or Gold.
type Plan struct {
	// System identifier of the plan.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the plan.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// If set, this plan is the default support plan.
	IsDefault bool `protobuf:"varint,3,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// Human readable description of the plan
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// If set, this plan is shown, but not selectable.
	IsUnavailable bool `protobuf:"varint,5,opt,name=is_unavailable,json=isUnavailable,proto3" json:"is_unavailable,omitempty"`
	// SLA times to first response for various situations.
	// When this plan is unavailable, this field is optional.
	FirstResponseTimes   *ResponseTimes `protobuf:"bytes,6,opt,name=first_response_times,json=firstResponseTimes,proto3" json:"first_response_times,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Plan) Reset()         { *m = Plan{} }
func (m *Plan) String() string { return proto.CompactTextString(m) }
func (*Plan) ProtoMessage()    {}
func (*Plan) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{0}
}
func (m *Plan) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Plan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Plan.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Plan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Plan.Merge(m, src)
}
func (m *Plan) XXX_Size() int {
	return m.Size()
}
func (m *Plan) XXX_DiscardUnknown() {
	xxx_messageInfo_Plan.DiscardUnknown(m)
}

var xxx_messageInfo_Plan proto.InternalMessageInfo

func (m *Plan) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Plan) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Plan) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *Plan) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Plan) GetIsUnavailable() bool {
	if m != nil {
		return m.IsUnavailable
	}
	return false
}

func (m *Plan) GetFirstResponseTimes() *ResponseTimes {
	if m != nil {
		return m.FirstResponseTimes
	}
	return nil
}

// Response for various categories on situations.
// All values are in minutes.
// A value of 0 means "best effort".
type ResponseTimes struct {
	// Response time for operation-impeding Error in a production environment.
	Critical int32 `protobuf:"varint,1,opt,name=critical,proto3" json:"critical,omitempty"`
	// Response time for operation-limiting error.
	High int32 `protobuf:"varint,2,opt,name=high,proto3" json:"high,omitempty"`
	// Response time for minor error.
	Normal int32 `protobuf:"varint,3,opt,name=normal,proto3" json:"normal,omitempty"`
	// Response time for usage question.
	Low                  int32    `protobuf:"varint,4,opt,name=low,proto3" json:"low,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResponseTimes) Reset()         { *m = ResponseTimes{} }
func (m *ResponseTimes) String() string { return proto.CompactTextString(m) }
func (*ResponseTimes) ProtoMessage()    {}
func (*ResponseTimes) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{1}
}
func (m *ResponseTimes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResponseTimes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResponseTimes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResponseTimes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseTimes.Merge(m, src)
}
func (m *ResponseTimes) XXX_Size() int {
	return m.Size()
}
func (m *ResponseTimes) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseTimes.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseTimes proto.InternalMessageInfo

func (m *ResponseTimes) GetCritical() int32 {
	if m != nil {
		return m.Critical
	}
	return 0
}

func (m *ResponseTimes) GetHigh() int32 {
	if m != nil {
		return m.High
	}
	return 0
}

func (m *ResponseTimes) GetNormal() int32 {
	if m != nil {
		return m.Normal
	}
	return 0
}

func (m *ResponseTimes) GetLow() int32 {
	if m != nil {
		return m.Low
	}
	return 0
}

// List of plans.
type PlanList struct {
	Items                []*Plan  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PlanList) Reset()         { *m = PlanList{} }
func (m *PlanList) String() string { return proto.CompactTextString(m) }
func (*PlanList) ProtoMessage()    {}
func (*PlanList) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{2}
}
func (m *PlanList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PlanList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PlanList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PlanList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlanList.Merge(m, src)
}
func (m *PlanList) XXX_Size() int {
	return m.Size()
}
func (m *PlanList) XXX_DiscardUnknown() {
	xxx_messageInfo_PlanList.DiscardUnknown(m)
}

var xxx_messageInfo_PlanList proto.InternalMessageInfo

func (m *PlanList) GetItems() []*Plan {
	if m != nil {
		return m.Items
	}
	return nil
}

// Arguments for a ListPlans request
type ListPlansRequest struct {
	// Common list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, list plans as they are available for the organization identified by this ID.
	OrganizationId       string   `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPlansRequest) Reset()         { *m = ListPlansRequest{} }
func (m *ListPlansRequest) String() string { return proto.CompactTextString(m) }
func (*ListPlansRequest) ProtoMessage()    {}
func (*ListPlansRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{3}
}
func (m *ListPlansRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPlansRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPlansRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPlansRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlansRequest.Merge(m, src)
}
func (m *ListPlansRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListPlansRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlansRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlansRequest proto.InternalMessageInfo

func (m *ListPlansRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListPlansRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func init() {
	proto.RegisterType((*Plan)(nil), "arangodb.cloud.support.v1.Plan")
	proto.RegisterType((*ResponseTimes)(nil), "arangodb.cloud.support.v1.ResponseTimes")
	proto.RegisterType((*PlanList)(nil), "arangodb.cloud.support.v1.PlanList")
	proto.RegisterType((*ListPlansRequest)(nil), "arangodb.cloud.support.v1.ListPlansRequest")
}

func init() { proto.RegisterFile("support.proto", fileDescriptor_61fc54fa3a6fab31) }

var fileDescriptor_61fc54fa3a6fab31 = []byte{
	// 534 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x53, 0xd1, 0x6e, 0xd3, 0x30,
	0x14, 0x25, 0x6d, 0xd3, 0xb5, 0xae, 0x5a, 0x26, 0x0b, 0x46, 0x88, 0xb6, 0x52, 0x65, 0x9a, 0xa8,
	0x34, 0x91, 0xa8, 0x45, 0x3c, 0x22, 0x04, 0x9a, 0x84, 0x26, 0x21, 0x81, 0x3c, 0x78, 0xd9, 0x4b,
	0xe5, 0x26, 0x5e, 0x7a, 0xa5, 0xc4, 0x0e, 0xb1, 0x13, 0x24, 0x18, 0x2f, 0xf0, 0x09, 0xbc, 0xf0,
	0x49, 0x3c, 0x22, 0xf1, 0x03, 0xa8, 0xf0, 0xcc, 0x37, 0x20, 0x3b, 0xe9, 0xe8, 0x26, 0xb6, 0xbd,
	0xdd, 0x1c, 0xdf, 0x73, 0xcf, 0x3d, 0xc7, 0x0e, 0xea, 0xcb, 0x22, 0xcb, 0x44, 0xae, 0xfc, 0x2c,
	0x17, 0x4a, 0xe0, 0xbb, 0x34, 0xa7, 0x3c, 0x16, 0xd1, 0xdc, 0x0f, 0x13, 0x51, 0x44, 0xfe, 0xea,
	0xb4, 0x9c, 0xb8, 0x5b, 0xa1, 0x48, 0x53, 0xc1, 0x83, 0x72, 0x12, 0x54, 0x55, 0x45, 0x71, 0xb7,
	0x63, 0x21, 0xe2, 0x84, 0x05, 0x34, 0x83, 0x80, 0x72, 0x2e, 0x14, 0x55, 0x20, 0xb8, 0xac, 0x4e,
	0xbd, 0x3f, 0x16, 0x6a, 0xbd, 0x4a, 0x28, 0xc7, 0x03, 0xd4, 0x80, 0xc8, 0xb1, 0x46, 0xd6, 0xb8,
	0x4b, 0x1a, 0x10, 0x61, 0x8c, 0x5a, 0x9c, 0xa6, 0xcc, 0x69, 0x18, 0xc4, 0xd4, 0x78, 0x07, 0x21,
	0x90, 0xb3, 0x88, 0x9d, 0xd0, 0x22, 0x51, 0x4e, 0x73, 0x64, 0x8d, 0x3b, 0xa4, 0x0b, 0xf2, 0xa0,
	0x02, 0xf0, 0x08, 0xf5, 0x22, 0x26, 0xc3, 0x1c, 0x32, 0xad, 0xe0, 0xb4, 0x0c, 0x73, 0x1d, 0xc2,
	0x7b, 0x68, 0x00, 0x72, 0x56, 0x70, 0x5a, 0x52, 0x48, 0xe8, 0x3c, 0x61, 0x8e, 0x6d, 0x86, 0xf4,
	0x41, 0xbe, 0xf9, 0x07, 0xe2, 0x63, 0x74, 0xeb, 0x04, 0x72, 0xa9, 0x66, 0x39, 0x93, 0x99, 0xe0,
	0x92, 0xcd, 0x14, 0xa4, 0x4c, 0x3a, 0xed, 0x91, 0x35, 0xee, 0x4d, 0xc7, 0xfe, 0xa5, 0x21, 0xf8,
	0xa4, 0x26, 0xbc, 0xd6, 0xfd, 0x04, 0x9b, 0x29, 0xe7, 0x30, 0x0f, 0x50, 0xff, 0x1c, 0x80, 0x5d,
	0xd4, 0x09, 0x73, 0x50, 0x10, 0xd2, 0xc4, 0xd8, 0xb7, 0xc9, 0xd9, 0xb7, 0x0e, 0x61, 0x01, 0xf1,
	0xc2, 0x84, 0x60, 0x13, 0x53, 0xe3, 0x2d, 0xd4, 0xe6, 0x22, 0x4f, 0x69, 0x62, 0x02, 0xb0, 0x49,
	0xfd, 0x85, 0x37, 0x51, 0x33, 0x11, 0xef, 0x8c, 0x6b, 0x9b, 0xe8, 0xd2, 0x7b, 0x8a, 0x3a, 0x3a,
	0xda, 0x17, 0x20, 0x15, 0x7e, 0x84, 0x6c, 0x50, 0x2c, 0x95, 0x8e, 0x35, 0x6a, 0x8e, 0x7b, 0xd3,
	0x7b, 0x57, 0x78, 0xd0, 0x1c, 0x52, 0x75, 0x7b, 0xa7, 0x68, 0x53, 0xd3, 0x35, 0x24, 0x09, 0x7b,
	0x5b, 0x30, 0xa9, 0xf0, 0x13, 0xb4, 0x21, 0x4c, 0x9c, 0xd2, 0xec, 0xdb, 0x9b, 0xee, 0x5d, 0x1c,
	0x56, 0xdf, 0x7f, 0x39, 0xf1, 0x35, 0xf9, 0x65, 0xd5, 0x4c, 0x56, 0x2c, 0x7c, 0x1f, 0xdd, 0x14,
	0x79, 0x4c, 0x39, 0xbc, 0x37, 0x4f, 0x61, 0x06, 0x51, 0x7d, 0xcb, 0x83, 0x75, 0xf8, 0x30, 0x9a,
	0x7e, 0x6e, 0xa0, 0xc1, 0x51, 0xb5, 0xd8, 0x11, 0xcb, 0x4b, 0x08, 0x19, 0x3e, 0x45, 0xdd, 0xb3,
	0x85, 0xf0, 0xfe, 0x15, 0x2e, 0x2e, 0xae, 0xed, 0xee, 0x5e, 0x63, 0x59, 0x13, 0xbc, 0x9d, 0x4f,
	0x3f, 0x7e, 0x7f, 0x69, 0xdc, 0xc1, 0xb7, 0xcd, 0x73, 0xad, 0x3b, 0xf4, 0x93, 0xce, 0x8c, 0xa0,
	0x44, 0x1b, 0xcf, 0x99, 0x19, 0x8b, 0x77, 0x2f, 0x37, 0x7d, 0x78, 0x50, 0x5b, 0x76, 0xaf, 0x8b,
	0xd9, 0xf3, 0x8c, 0xde, 0x36, 0x76, 0xff, 0xab, 0x17, 0x7c, 0x80, 0xe8, 0xe3, 0xb3, 0xc7, 0xdf,
	0x96, 0x43, 0xeb, 0xfb, 0x72, 0x68, 0xfd, 0x5c, 0x0e, 0xad, 0xaf, 0xbf, 0x86, 0x37, 0x8e, 0xf7,
	0x63, 0x50, 0x8b, 0x62, 0xae, 0x25, 0x83, 0x95, 0xc0, 0x83, 0x94, 0x72, 0x1a, 0xb3, 0x48, 0x0f,
	0x92, 0x6b, 0x93, 0xe6, 0x6d, 0xf3, 0xa3, 0x3d, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x14, 0xd8,
	0xe2, 0x3f, 0xca, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SupportServiceClient is the client API for SupportService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SupportServiceClient interface {
	// Fetch all support plans that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListPlans(ctx context.Context, in *ListPlansRequest, opts ...grpc.CallOption) (*PlanList, error)
	// Fetch a support plan by its id.
	// Required permissions:
	// - None
	GetPlan(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Plan, error)
}

type supportServiceClient struct {
	cc *grpc.ClientConn
}

func NewSupportServiceClient(cc *grpc.ClientConn) SupportServiceClient {
	return &supportServiceClient{cc}
}

func (c *supportServiceClient) ListPlans(ctx context.Context, in *ListPlansRequest, opts ...grpc.CallOption) (*PlanList, error) {
	out := new(PlanList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.support.v1.SupportService/ListPlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *supportServiceClient) GetPlan(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Plan, error) {
	out := new(Plan)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.support.v1.SupportService/GetPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SupportServiceServer is the server API for SupportService service.
type SupportServiceServer interface {
	// Fetch all support plans that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListPlans(context.Context, *ListPlansRequest) (*PlanList, error)
	// Fetch a support plan by its id.
	// Required permissions:
	// - None
	GetPlan(context.Context, *v1.IDOptions) (*Plan, error)
}

// UnimplementedSupportServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSupportServiceServer struct {
}

func (*UnimplementedSupportServiceServer) ListPlans(ctx context.Context, req *ListPlansRequest) (*PlanList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlans not implemented")
}
func (*UnimplementedSupportServiceServer) GetPlan(ctx context.Context, req *v1.IDOptions) (*Plan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlan not implemented")
}

func RegisterSupportServiceServer(s *grpc.Server, srv SupportServiceServer) {
	s.RegisterService(&_SupportService_serviceDesc, srv)
}

func _SupportService_ListPlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SupportServiceServer).ListPlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.support.v1.SupportService/ListPlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SupportServiceServer).ListPlans(ctx, req.(*ListPlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SupportService_GetPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SupportServiceServer).GetPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.support.v1.SupportService/GetPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SupportServiceServer).GetPlan(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _SupportService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.support.v1.SupportService",
	HandlerType: (*SupportServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPlans",
			Handler:    _SupportService_ListPlans_Handler,
		},
		{
			MethodName: "GetPlan",
			Handler:    _SupportService_GetPlan_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "support.proto",
}

func (m *Plan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Plan) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Plan) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.FirstResponseTimes != nil {
		{
			size, err := m.FirstResponseTimes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSupport(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.IsUnavailable {
		i--
		if m.IsUnavailable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResponseTimes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseTimes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResponseTimes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Low != 0 {
		i = encodeVarintSupport(dAtA, i, uint64(m.Low))
		i--
		dAtA[i] = 0x20
	}
	if m.Normal != 0 {
		i = encodeVarintSupport(dAtA, i, uint64(m.Normal))
		i--
		dAtA[i] = 0x18
	}
	if m.High != 0 {
		i = encodeVarintSupport(dAtA, i, uint64(m.High))
		i--
		dAtA[i] = 0x10
	}
	if m.Critical != 0 {
		i = encodeVarintSupport(dAtA, i, uint64(m.Critical))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PlanList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlanList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PlanList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSupport(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListPlansRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPlansRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPlansRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSupport(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintSupport(dAtA []byte, offset int, v uint64) int {
	offset -= sovSupport(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Plan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.IsDefault {
		n += 2
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.IsUnavailable {
		n += 2
	}
	if m.FirstResponseTimes != nil {
		l = m.FirstResponseTimes.Size()
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResponseTimes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Critical != 0 {
		n += 1 + sovSupport(uint64(m.Critical))
	}
	if m.High != 0 {
		n += 1 + sovSupport(uint64(m.High))
	}
	if m.Normal != 0 {
		n += 1 + sovSupport(uint64(m.Normal))
	}
	if m.Low != 0 {
		n += 1 + sovSupport(uint64(m.Low))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PlanList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSupport(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListPlansRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSupport(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSupport(x uint64) (n int) {
	return sovSupport(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Plan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Plan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Plan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsUnavailable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsUnavailable = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstResponseTimes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstResponseTimes == nil {
				m.FirstResponseTimes = &ResponseTimes{}
			}
			if err := m.FirstResponseTimes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseTimes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseTimes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseTimes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Critical", wireType)
			}
			m.Critical = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Critical |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field High", wireType)
			}
			m.High = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.High |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Normal", wireType)
			}
			m.Normal = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Normal |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Low", wireType)
			}
			m.Low = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Low |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlanList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlanList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlanList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Plan{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPlansRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPlansRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPlansRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSupport(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSupport
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthSupport
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSupport
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSupport(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthSupport
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSupport = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSupport   = fmt.Errorf("proto: integer overflow")
)
