// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: resourcemanager.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An Organization is represents a real world organization such as a company.
type Organization struct {
	// System identifier of the organization.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the organization
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the organization
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Set when this organization is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,5,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// The creation timestamp of the organization
	CreatedAt *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the organization
	DeletedAt *types.Timestamp `protobuf:"bytes,7,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Tier used for this organization.
	// This is a read-only value and cannot be initialized.
	Tier *Tier `protobuf:"bytes,8,opt,name=tier,proto3" json:"tier,omitempty"`
	// Total number of deployments created in this organization throughout
	// its entire lifetime per tier-id.
	// map: tier-id -> count
	// This is a read-only value.
	TotalDeployments map[string]int32 `protobuf:"bytes,9,rep,name=total_deployments,json=totalDeployments,proto3" json:"total_deployments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// If set, all projects in this organization are allowed to use deployments using the flexible model.
	IsFlexibleDeploymentsEnabled bool `protobuf:"varint,10,opt,name=is_flexible_deployments_enabled,json=isFlexibleDeploymentsEnabled,proto3" json:"is_flexible_deployments_enabled,omitempty"`
	// If set, this organization is allowed to use custom images for ArangoDB deployments.
	IsAllowedToUseCustomImages bool     `protobuf:"varint,11,opt,name=is_allowed_to_use_custom_images,json=isAllowedToUseCustomImages,proto3" json:"is_allowed_to_use_custom_images,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *Organization) Reset()         { *m = Organization{} }
func (m *Organization) String() string { return proto.CompactTextString(m) }
func (*Organization) ProtoMessage()    {}
func (*Organization) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{0}
}
func (m *Organization) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Organization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Organization.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Organization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Organization.Merge(m, src)
}
func (m *Organization) XXX_Size() int {
	return m.Size()
}
func (m *Organization) XXX_DiscardUnknown() {
	xxx_messageInfo_Organization.DiscardUnknown(m)
}

var xxx_messageInfo_Organization proto.InternalMessageInfo

func (m *Organization) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Organization) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Organization) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Organization) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Organization) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Organization) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Organization) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Organization) GetTier() *Tier {
	if m != nil {
		return m.Tier
	}
	return nil
}

func (m *Organization) GetTotalDeployments() map[string]int32 {
	if m != nil {
		return m.TotalDeployments
	}
	return nil
}

func (m *Organization) GetIsFlexibleDeploymentsEnabled() bool {
	if m != nil {
		return m.IsFlexibleDeploymentsEnabled
	}
	return false
}

func (m *Organization) GetIsAllowedToUseCustomImages() bool {
	if m != nil {
		return m.IsAllowedToUseCustomImages
	}
	return false
}

// List of organizations.
type OrganizationList struct {
	// Actual organizations
	Items []*Organization `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// Budget for organizations (owned by the caller)
	Budget               *v1.Budget `protobuf:"bytes,2,opt,name=budget,proto3" json:"budget,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *OrganizationList) Reset()         { *m = OrganizationList{} }
func (m *OrganizationList) String() string { return proto.CompactTextString(m) }
func (*OrganizationList) ProtoMessage()    {}
func (*OrganizationList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{1}
}
func (m *OrganizationList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationList.Merge(m, src)
}
func (m *OrganizationList) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationList) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationList.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationList proto.InternalMessageInfo

func (m *OrganizationList) GetItems() []*Organization {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *OrganizationList) GetBudget() *v1.Budget {
	if m != nil {
		return m.Budget
	}
	return nil
}

// Tier of an organization.
type Tier struct {
	// Identifier of the tier.
	// This is a read-only value and cannot be initialized.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human readable name of the tier.
	// This is a read-only value and cannot be initialized.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// If set the tier has support plans.
	// This is a read-only value and cannot be initialized.
	HasSupportPlans bool `protobuf:"varint,3,opt,name=has_support_plans,json=hasSupportPlans,proto3" json:"has_support_plans,omitempty"`
	// If set the tier has backup uploads.
	// This is a read-only value and cannot be initialized.
	HasBackupUploads bool `protobuf:"varint,4,opt,name=has_backup_uploads,json=hasBackupUploads,proto3" json:"has_backup_uploads,omitempty"`
	// If set, the tier requires that new deployments accept the
	// current terms & conditions.
	// This is a read-only value and cannot be initialized.
	RequiresTermsAndConditions bool     `protobuf:"varint,5,opt,name=requires_terms_and_conditions,json=requiresTermsAndConditions,proto3" json:"requires_terms_and_conditions,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *Tier) Reset()         { *m = Tier{} }
func (m *Tier) String() string { return proto.CompactTextString(m) }
func (*Tier) ProtoMessage()    {}
func (*Tier) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{2}
}
func (m *Tier) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Tier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Tier.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Tier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tier.Merge(m, src)
}
func (m *Tier) XXX_Size() int {
	return m.Size()
}
func (m *Tier) XXX_DiscardUnknown() {
	xxx_messageInfo_Tier.DiscardUnknown(m)
}

var xxx_messageInfo_Tier proto.InternalMessageInfo

func (m *Tier) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Tier) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tier) GetHasSupportPlans() bool {
	if m != nil {
		return m.HasSupportPlans
	}
	return false
}

func (m *Tier) GetHasBackupUploads() bool {
	if m != nil {
		return m.HasBackupUploads
	}
	return false
}

func (m *Tier) GetRequiresTermsAndConditions() bool {
	if m != nil {
		return m.RequiresTermsAndConditions
	}
	return false
}

// Member of an organization.
// A member is always a user.
type Member struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Set if this user is owner of the organization
	Owner                bool     `protobuf:"varint,2,opt,name=owner,proto3" json:"owner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Member) Reset()         { *m = Member{} }
func (m *Member) String() string { return proto.CompactTextString(m) }
func (*Member) ProtoMessage()    {}
func (*Member) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{3}
}
func (m *Member) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Member) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Member.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Member) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Member.Merge(m, src)
}
func (m *Member) XXX_Size() int {
	return m.Size()
}
func (m *Member) XXX_DiscardUnknown() {
	xxx_messageInfo_Member.DiscardUnknown(m)
}

var xxx_messageInfo_Member proto.InternalMessageInfo

func (m *Member) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *Member) GetOwner() bool {
	if m != nil {
		return m.Owner
	}
	return false
}

// List of Members.
type MemberList struct {
	Items                []*Member `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MemberList) Reset()         { *m = MemberList{} }
func (m *MemberList) String() string { return proto.CompactTextString(m) }
func (*MemberList) ProtoMessage()    {}
func (*MemberList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{4}
}
func (m *MemberList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemberList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MemberList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MemberList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemberList.Merge(m, src)
}
func (m *MemberList) XXX_Size() int {
	return m.Size()
}
func (m *MemberList) XXX_DiscardUnknown() {
	xxx_messageInfo_MemberList.DiscardUnknown(m)
}

var xxx_messageInfo_MemberList proto.InternalMessageInfo

func (m *MemberList) GetItems() []*Member {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for IsMemberOfOrganization.
type IsMemberOfOrganizationRequest struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Identifier of the organization
	OrganizationId       string   `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsMemberOfOrganizationRequest) Reset()         { *m = IsMemberOfOrganizationRequest{} }
func (m *IsMemberOfOrganizationRequest) String() string { return proto.CompactTextString(m) }
func (*IsMemberOfOrganizationRequest) ProtoMessage()    {}
func (*IsMemberOfOrganizationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{5}
}
func (m *IsMemberOfOrganizationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsMemberOfOrganizationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsMemberOfOrganizationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsMemberOfOrganizationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsMemberOfOrganizationRequest.Merge(m, src)
}
func (m *IsMemberOfOrganizationRequest) XXX_Size() int {
	return m.Size()
}
func (m *IsMemberOfOrganizationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsMemberOfOrganizationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsMemberOfOrganizationRequest proto.InternalMessageInfo

func (m *IsMemberOfOrganizationRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *IsMemberOfOrganizationRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

// Response for IsMemberOfOrganization.
type IsMemberOfOrganizationResponse struct {
	// Set if the requested user is a member of the requested organization.
	Member bool `protobuf:"varint,1,opt,name=member,proto3" json:"member,omitempty"`
	// Set if the requested user is an owner of the requested organization.
	Owner                bool     `protobuf:"varint,2,opt,name=owner,proto3" json:"owner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsMemberOfOrganizationResponse) Reset()         { *m = IsMemberOfOrganizationResponse{} }
func (m *IsMemberOfOrganizationResponse) String() string { return proto.CompactTextString(m) }
func (*IsMemberOfOrganizationResponse) ProtoMessage()    {}
func (*IsMemberOfOrganizationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{6}
}
func (m *IsMemberOfOrganizationResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsMemberOfOrganizationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsMemberOfOrganizationResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsMemberOfOrganizationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsMemberOfOrganizationResponse.Merge(m, src)
}
func (m *IsMemberOfOrganizationResponse) XXX_Size() int {
	return m.Size()
}
func (m *IsMemberOfOrganizationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_IsMemberOfOrganizationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_IsMemberOfOrganizationResponse proto.InternalMessageInfo

func (m *IsMemberOfOrganizationResponse) GetMember() bool {
	if m != nil {
		return m.Member
	}
	return false
}

func (m *IsMemberOfOrganizationResponse) GetOwner() bool {
	if m != nil {
		return m.Owner
	}
	return false
}

// Request arguments for Add/DeleteOrganizationMembers.
type OrganizationMembersRequest struct {
	// Identifier of the organization to add/remove a user from
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Users to add/remove.
	// For every user, an owner flag is provided as well.
	// If you add an existing user, the owner flag or the add request
	// will overwrite the value of the existing owner flag.
	Members              *MemberList `protobuf:"bytes,2,opt,name=members,proto3" json:"members,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *OrganizationMembersRequest) Reset()         { *m = OrganizationMembersRequest{} }
func (m *OrganizationMembersRequest) String() string { return proto.CompactTextString(m) }
func (*OrganizationMembersRequest) ProtoMessage()    {}
func (*OrganizationMembersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{7}
}
func (m *OrganizationMembersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationMembersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationMembersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationMembersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationMembersRequest.Merge(m, src)
}
func (m *OrganizationMembersRequest) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationMembersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationMembersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationMembersRequest proto.InternalMessageInfo

func (m *OrganizationMembersRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *OrganizationMembersRequest) GetMembers() *MemberList {
	if m != nil {
		return m.Members
	}
	return nil
}

// A Project is represents a unit within an organization such as a department.
type Project struct {
	// System identifier of the project.
	// This is a read-only value.
	// It can be set when creating the project.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the project
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the project
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the organization that owns this project.
	// This is a read-only value.
	OrganizationId string `protobuf:"bytes,5,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Set when this project is deleted
	IsDeleted bool `protobuf:"varint,6,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// The creation timestamp of the project
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the project
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// If set, this project is allowed to use deployments using the flexible model.
	IsFlexibleDeploymentsEnabled bool     `protobuf:"varint,9,opt,name=is_flexible_deployments_enabled,json=isFlexibleDeploymentsEnabled,proto3" json:"is_flexible_deployments_enabled,omitempty"`
	XXX_NoUnkeyedLiteral         struct{} `json:"-"`
	XXX_unrecognized             []byte   `json:"-"`
	XXX_sizecache                int32    `json:"-"`
}

func (m *Project) Reset()         { *m = Project{} }
func (m *Project) String() string { return proto.CompactTextString(m) }
func (*Project) ProtoMessage()    {}
func (*Project) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{8}
}
func (m *Project) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Project) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Project.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Project) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Project.Merge(m, src)
}
func (m *Project) XXX_Size() int {
	return m.Size()
}
func (m *Project) XXX_DiscardUnknown() {
	xxx_messageInfo_Project.DiscardUnknown(m)
}

var xxx_messageInfo_Project proto.InternalMessageInfo

func (m *Project) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Project) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Project) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Project) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Project) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Project) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Project) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Project) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Project) GetIsFlexibleDeploymentsEnabled() bool {
	if m != nil {
		return m.IsFlexibleDeploymentsEnabled
	}
	return false
}

// List of Projects.
type ProjectList struct {
	// Resulting projects
	Items []*Project `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// Budget for projects
	Budget               *v1.Budget `protobuf:"bytes,2,opt,name=budget,proto3" json:"budget,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ProjectList) Reset()         { *m = ProjectList{} }
func (m *ProjectList) String() string { return proto.CompactTextString(m) }
func (*ProjectList) ProtoMessage()    {}
func (*ProjectList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{9}
}
func (m *ProjectList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProjectList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProjectList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProjectList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProjectList.Merge(m, src)
}
func (m *ProjectList) XXX_Size() int {
	return m.Size()
}
func (m *ProjectList) XXX_DiscardUnknown() {
	xxx_messageInfo_ProjectList.DiscardUnknown(m)
}

var xxx_messageInfo_ProjectList proto.InternalMessageInfo

func (m *ProjectList) GetItems() []*Project {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *ProjectList) GetBudget() *v1.Budget {
	if m != nil {
		return m.Budget
	}
	return nil
}

// An Event represents something that happened to an organization
// in the ArangoDB Managed service.
type Event struct {
	// System identifier of the event.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Identifier of the organization that owns this event.
	// This is a read-only value.
	OrganizationId string `protobuf:"bytes,3,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Identifier of the subject of this event.
	// This is a read-only value.
	// If the subject of this event is an organization,
	// this value is a duplicate of organization_id.
	SubjectId string `protobuf:"bytes,4,opt,name=subject_id,json=subjectId,proto3" json:"subject_id,omitempty"`
	// Type of the event.
	Type string `protobuf:"bytes,5,opt,name=type,proto3" json:"type,omitempty"`
	// Payload of the event.
	// The fields used in the payload are specific
	// to the type of event.
	Payload map[string]string `protobuf:"bytes,6,rep,name=payload,proto3" json:"payload,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The creation timestamp of the event
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// URL of the subject of this event.
	// This is a read-only value.
	SubjectUrl string `protobuf:"bytes,8,opt,name=subject_url,json=subjectUrl,proto3" json:"subject_url,omitempty"`
	// If set, this event is not persisted.
	// This is a read-only value.
	Volatile             bool     `protobuf:"varint,9,opt,name=volatile,proto3" json:"volatile,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{10}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Event) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Event) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Event) GetSubjectId() string {
	if m != nil {
		return m.SubjectId
	}
	return ""
}

func (m *Event) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Event) GetPayload() map[string]string {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Event) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Event) GetSubjectUrl() string {
	if m != nil {
		return m.SubjectUrl
	}
	return ""
}

func (m *Event) GetVolatile() bool {
	if m != nil {
		return m.Volatile
	}
	return false
}

// List of Events.
type EventList struct {
	Items                []*Event `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventList) Reset()         { *m = EventList{} }
func (m *EventList) String() string { return proto.CompactTextString(m) }
func (*EventList) ProtoMessage()    {}
func (*EventList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{11}
}
func (m *EventList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventList.Merge(m, src)
}
func (m *EventList) XXX_Size() int {
	return m.Size()
}
func (m *EventList) XXX_DiscardUnknown() {
	xxx_messageInfo_EventList.DiscardUnknown(m)
}

var xxx_messageInfo_EventList proto.InternalMessageInfo

func (m *EventList) GetItems() []*Event {
	if m != nil {
		return m.Items
	}
	return nil
}

// Options for ListEvents
type ListEventOptions struct {
	// Standard list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, filter on the subject_id of event
	SubjectIds []string `protobuf:"bytes,2,rep,name=subject_ids,json=subjectIds,proto3" json:"subject_ids,omitempty"`
	// If set, filter on the type of event
	Types []string `protobuf:"bytes,3,rep,name=types,proto3" json:"types,omitempty"`
	// If set, filter of events created after this timestamp
	CreatedAfter *types.Timestamp `protobuf:"bytes,4,opt,name=created_after,json=createdAfter,proto3" json:"created_after,omitempty"`
	// If set, filter of events created before this timestamp
	CreatedBefore        *types.Timestamp `protobuf:"bytes,5,opt,name=created_before,json=createdBefore,proto3" json:"created_before,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ListEventOptions) Reset()         { *m = ListEventOptions{} }
func (m *ListEventOptions) String() string { return proto.CompactTextString(m) }
func (*ListEventOptions) ProtoMessage()    {}
func (*ListEventOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{12}
}
func (m *ListEventOptions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListEventOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListEventOptions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListEventOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEventOptions.Merge(m, src)
}
func (m *ListEventOptions) XXX_Size() int {
	return m.Size()
}
func (m *ListEventOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEventOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ListEventOptions proto.InternalMessageInfo

func (m *ListEventOptions) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListEventOptions) GetSubjectIds() []string {
	if m != nil {
		return m.SubjectIds
	}
	return nil
}

func (m *ListEventOptions) GetTypes() []string {
	if m != nil {
		return m.Types
	}
	return nil
}

func (m *ListEventOptions) GetCreatedAfter() *types.Timestamp {
	if m != nil {
		return m.CreatedAfter
	}
	return nil
}

func (m *ListEventOptions) GetCreatedBefore() *types.Timestamp {
	if m != nil {
		return m.CreatedBefore
	}
	return nil
}

// An OrganizationInvite represents an invite for a human to join an
// organization.
type OrganizationInvite struct {
	// System identifier of the invite.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Identifier of the organization that the human is invited to join.
	// This is a read-only value.
	OrganizationId string `protobuf:"bytes,3,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Email address of the human who is invited.
	Email string `protobuf:"bytes,4,opt,name=email,proto3" json:"email,omitempty"`
	// If set, the invitee accepted the invite.
	// This is a read-only value.
	Accepted bool `protobuf:"varint,5,opt,name=accepted,proto3" json:"accepted,omitempty"`
	// If set, the invitee rejected the invite.
	// This is a read-only value.
	Rejected bool `protobuf:"varint,6,opt,name=rejected,proto3" json:"rejected,omitempty"`
	// The creation timestamp of the invite
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The acceptance timestamp of the invite
	// This is a read-only value.
	AcceptedAt *types.Timestamp `protobuf:"bytes,8,opt,name=accepted_at,json=acceptedAt,proto3" json:"accepted_at,omitempty"`
	// The rejection timestamp of the invite
	// This is a read-only value.
	RejectedAt *types.Timestamp `protobuf:"bytes,9,opt,name=rejected_at,json=rejectedAt,proto3" json:"rejected_at,omitempty"`
	// Identifier of the user that accepted or rejected this invite.
	// This is a read-only value.
	UserId string `protobuf:"bytes,10,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Identifier of the user that created this invite.
	CreatedById string `protobuf:"bytes,11,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// Identifier of the organization that the human is invited to join.
	// This is a read-only value.
	OrganizationName string `protobuf:"bytes,12,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// Name of the user that created this invite.
	// This is a read-only value.
	CreatedByName        string   `protobuf:"bytes,13,opt,name=created_by_name,json=createdByName,proto3" json:"created_by_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OrganizationInvite) Reset()         { *m = OrganizationInvite{} }
func (m *OrganizationInvite) String() string { return proto.CompactTextString(m) }
func (*OrganizationInvite) ProtoMessage()    {}
func (*OrganizationInvite) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{13}
}
func (m *OrganizationInvite) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationInvite) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationInvite.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationInvite) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationInvite.Merge(m, src)
}
func (m *OrganizationInvite) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationInvite) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationInvite.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationInvite proto.InternalMessageInfo

func (m *OrganizationInvite) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *OrganizationInvite) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *OrganizationInvite) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *OrganizationInvite) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *OrganizationInvite) GetAccepted() bool {
	if m != nil {
		return m.Accepted
	}
	return false
}

func (m *OrganizationInvite) GetRejected() bool {
	if m != nil {
		return m.Rejected
	}
	return false
}

func (m *OrganizationInvite) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *OrganizationInvite) GetAcceptedAt() *types.Timestamp {
	if m != nil {
		return m.AcceptedAt
	}
	return nil
}

func (m *OrganizationInvite) GetRejectedAt() *types.Timestamp {
	if m != nil {
		return m.RejectedAt
	}
	return nil
}

func (m *OrganizationInvite) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *OrganizationInvite) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *OrganizationInvite) GetOrganizationName() string {
	if m != nil {
		return m.OrganizationName
	}
	return ""
}

func (m *OrganizationInvite) GetCreatedByName() string {
	if m != nil {
		return m.CreatedByName
	}
	return ""
}

// List of OrganizationInvites.
type OrganizationInviteList struct {
	Items                []*OrganizationInvite `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *OrganizationInviteList) Reset()         { *m = OrganizationInviteList{} }
func (m *OrganizationInviteList) String() string { return proto.CompactTextString(m) }
func (*OrganizationInviteList) ProtoMessage()    {}
func (*OrganizationInviteList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{14}
}
func (m *OrganizationInviteList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OrganizationInviteList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OrganizationInviteList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OrganizationInviteList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationInviteList.Merge(m, src)
}
func (m *OrganizationInviteList) XXX_Size() int {
	return m.Size()
}
func (m *OrganizationInviteList) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationInviteList.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationInviteList proto.InternalMessageInfo

func (m *OrganizationInviteList) GetItems() []*OrganizationInvite {
	if m != nil {
		return m.Items
	}
	return nil
}

// Description of a kind of quota's
type QuotaDescription struct {
	// Kind of the quota
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Human readable description
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// If set, this kind of quota is valid at organization level
	ForOrganizations bool `protobuf:"varint,3,opt,name=for_organizations,json=forOrganizations,proto3" json:"for_organizations,omitempty"`
	// If set, this kind of quota is valid at project level
	ForProjects          bool     `protobuf:"varint,4,opt,name=for_projects,json=forProjects,proto3" json:"for_projects,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QuotaDescription) Reset()         { *m = QuotaDescription{} }
func (m *QuotaDescription) String() string { return proto.CompactTextString(m) }
func (*QuotaDescription) ProtoMessage()    {}
func (*QuotaDescription) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{15}
}
func (m *QuotaDescription) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaDescription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuotaDescription.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuotaDescription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaDescription.Merge(m, src)
}
func (m *QuotaDescription) XXX_Size() int {
	return m.Size()
}
func (m *QuotaDescription) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaDescription.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaDescription proto.InternalMessageInfo

func (m *QuotaDescription) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *QuotaDescription) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *QuotaDescription) GetForOrganizations() bool {
	if m != nil {
		return m.ForOrganizations
	}
	return false
}

func (m *QuotaDescription) GetForProjects() bool {
	if m != nil {
		return m.ForProjects
	}
	return false
}

// List of QuotaDescription's
type QuotaDescriptionList struct {
	Items                []*QuotaDescription `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *QuotaDescriptionList) Reset()         { *m = QuotaDescriptionList{} }
func (m *QuotaDescriptionList) String() string { return proto.CompactTextString(m) }
func (*QuotaDescriptionList) ProtoMessage()    {}
func (*QuotaDescriptionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{16}
}
func (m *QuotaDescriptionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaDescriptionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuotaDescriptionList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuotaDescriptionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaDescriptionList.Merge(m, src)
}
func (m *QuotaDescriptionList) XXX_Size() int {
	return m.Size()
}
func (m *QuotaDescriptionList) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaDescriptionList.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaDescriptionList proto.InternalMessageInfo

func (m *QuotaDescriptionList) GetItems() []*QuotaDescription {
	if m != nil {
		return m.Items
	}
	return nil
}

// Quota limit
type Quota struct {
	// Kind of quota
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Human readable description of the quota
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Current limit of the quota.
	// A value of 0 means unlimited.
	Limit                int64    `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Quota) Reset()         { *m = Quota{} }
func (m *Quota) String() string { return proto.CompactTextString(m) }
func (*Quota) ProtoMessage()    {}
func (*Quota) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{17}
}
func (m *Quota) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Quota) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Quota.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Quota) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Quota.Merge(m, src)
}
func (m *Quota) XXX_Size() int {
	return m.Size()
}
func (m *Quota) XXX_DiscardUnknown() {
	xxx_messageInfo_Quota.DiscardUnknown(m)
}

var xxx_messageInfo_Quota proto.InternalMessageInfo

func (m *Quota) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *Quota) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Quota) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

// List of Quota's
type QuotaList struct {
	Items                []*Quota `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QuotaList) Reset()         { *m = QuotaList{} }
func (m *QuotaList) String() string { return proto.CompactTextString(m) }
func (*QuotaList) ProtoMessage()    {}
func (*QuotaList) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{18}
}
func (m *QuotaList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QuotaList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QuotaList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QuotaList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaList.Merge(m, src)
}
func (m *QuotaList) XXX_Size() int {
	return m.Size()
}
func (m *QuotaList) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaList.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaList proto.InternalMessageInfo

func (m *QuotaList) GetItems() []*Quota {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListXyzQuotas
type ListQuotasRequest struct {
	// Common list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, limit the returned list of quota's to these kinds.
	Kinds                []string `protobuf:"bytes,2,rep,name=kinds,proto3" json:"kinds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListQuotasRequest) Reset()         { *m = ListQuotasRequest{} }
func (m *ListQuotasRequest) String() string { return proto.CompactTextString(m) }
func (*ListQuotasRequest) ProtoMessage()    {}
func (*ListQuotasRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{19}
}
func (m *ListQuotasRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListQuotasRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListQuotasRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListQuotasRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListQuotasRequest.Merge(m, src)
}
func (m *ListQuotasRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListQuotasRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListQuotasRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListQuotasRequest proto.InternalMessageInfo

func (m *ListQuotasRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListQuotasRequest) GetKinds() []string {
	if m != nil {
		return m.Kinds
	}
	return nil
}

type TermsAndConditions struct {
	// Identifier of this version of the terms & conditions
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Content of terms & conditions in markdown format
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Creation date of this version of the terms & conditions.
	CreatedAt            *types.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TermsAndConditions) Reset()         { *m = TermsAndConditions{} }
func (m *TermsAndConditions) String() string { return proto.CompactTextString(m) }
func (*TermsAndConditions) ProtoMessage()    {}
func (*TermsAndConditions) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{20}
}
func (m *TermsAndConditions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TermsAndConditions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TermsAndConditions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TermsAndConditions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TermsAndConditions.Merge(m, src)
}
func (m *TermsAndConditions) XXX_Size() int {
	return m.Size()
}
func (m *TermsAndConditions) XXX_DiscardUnknown() {
	xxx_messageInfo_TermsAndConditions.DiscardUnknown(m)
}

var xxx_messageInfo_TermsAndConditions proto.InternalMessageInfo

func (m *TermsAndConditions) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *TermsAndConditions) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *TermsAndConditions) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

type DataProcessingAddendum struct {
	// Identifier of this version of the DPA
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Content of DPA in markdown format
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Creation date of this version of the DPA.
	CreatedAt            *types.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *DataProcessingAddendum) Reset()         { *m = DataProcessingAddendum{} }
func (m *DataProcessingAddendum) String() string { return proto.CompactTextString(m) }
func (*DataProcessingAddendum) ProtoMessage()    {}
func (*DataProcessingAddendum) Descriptor() ([]byte, []int) {
	return fileDescriptor_81de387952a6887e, []int{21}
}
func (m *DataProcessingAddendum) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataProcessingAddendum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataProcessingAddendum.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataProcessingAddendum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataProcessingAddendum.Merge(m, src)
}
func (m *DataProcessingAddendum) XXX_Size() int {
	return m.Size()
}
func (m *DataProcessingAddendum) XXX_DiscardUnknown() {
	xxx_messageInfo_DataProcessingAddendum.DiscardUnknown(m)
}

var xxx_messageInfo_DataProcessingAddendum proto.InternalMessageInfo

func (m *DataProcessingAddendum) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DataProcessingAddendum) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *DataProcessingAddendum) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func init() {
	proto.RegisterType((*Organization)(nil), "arangodb.cloud.resourcemanager.v1.Organization")
	proto.RegisterMapType((map[string]int32)(nil), "arangodb.cloud.resourcemanager.v1.Organization.TotalDeploymentsEntry")
	proto.RegisterType((*OrganizationList)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationList")
	proto.RegisterType((*Tier)(nil), "arangodb.cloud.resourcemanager.v1.Tier")
	proto.RegisterType((*Member)(nil), "arangodb.cloud.resourcemanager.v1.Member")
	proto.RegisterType((*MemberList)(nil), "arangodb.cloud.resourcemanager.v1.MemberList")
	proto.RegisterType((*IsMemberOfOrganizationRequest)(nil), "arangodb.cloud.resourcemanager.v1.IsMemberOfOrganizationRequest")
	proto.RegisterType((*IsMemberOfOrganizationResponse)(nil), "arangodb.cloud.resourcemanager.v1.IsMemberOfOrganizationResponse")
	proto.RegisterType((*OrganizationMembersRequest)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationMembersRequest")
	proto.RegisterType((*Project)(nil), "arangodb.cloud.resourcemanager.v1.Project")
	proto.RegisterType((*ProjectList)(nil), "arangodb.cloud.resourcemanager.v1.ProjectList")
	proto.RegisterType((*Event)(nil), "arangodb.cloud.resourcemanager.v1.Event")
	proto.RegisterMapType((map[string]string)(nil), "arangodb.cloud.resourcemanager.v1.Event.PayloadEntry")
	proto.RegisterType((*EventList)(nil), "arangodb.cloud.resourcemanager.v1.EventList")
	proto.RegisterType((*ListEventOptions)(nil), "arangodb.cloud.resourcemanager.v1.ListEventOptions")
	proto.RegisterType((*OrganizationInvite)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationInvite")
	proto.RegisterType((*OrganizationInviteList)(nil), "arangodb.cloud.resourcemanager.v1.OrganizationInviteList")
	proto.RegisterType((*QuotaDescription)(nil), "arangodb.cloud.resourcemanager.v1.QuotaDescription")
	proto.RegisterType((*QuotaDescriptionList)(nil), "arangodb.cloud.resourcemanager.v1.QuotaDescriptionList")
	proto.RegisterType((*Quota)(nil), "arangodb.cloud.resourcemanager.v1.Quota")
	proto.RegisterType((*QuotaList)(nil), "arangodb.cloud.resourcemanager.v1.QuotaList")
	proto.RegisterType((*ListQuotasRequest)(nil), "arangodb.cloud.resourcemanager.v1.ListQuotasRequest")
	proto.RegisterType((*TermsAndConditions)(nil), "arangodb.cloud.resourcemanager.v1.TermsAndConditions")
	proto.RegisterType((*DataProcessingAddendum)(nil), "arangodb.cloud.resourcemanager.v1.DataProcessingAddendum")
}

func init() { proto.RegisterFile("resourcemanager.proto", fileDescriptor_81de387952a6887e) }

var fileDescriptor_81de387952a6887e = []byte{
	// 2225 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcb, 0x6f, 0x1b, 0xd7,
	0xd5, 0xff, 0xae, 0x28, 0xea, 0x71, 0x28, 0xd9, 0xd2, 0x85, 0xac, 0xd0, 0x84, 0x2d, 0xcb, 0x13,
	0xf8, 0xb3, 0x2a, 0x59, 0x64, 0x45, 0xc5, 0x88, 0x2d, 0x27, 0xb1, 0xa9, 0x47, 0x05, 0xd6, 0x71,
	0x24, 0xd3, 0x72, 0x0b, 0x74, 0x43, 0x0c, 0x39, 0x57, 0xf4, 0xc4, 0xc3, 0x99, 0xf1, 0xdc, 0x4b,
	0x26, 0x6c, 0x60, 0xa0, 0x28, 0xba, 0x69, 0x51, 0x78, 0x93, 0x4d, 0x8a, 0xec, 0xfa, 0x00, 0x8a,
	0x22, 0x6d, 0x17, 0x2d, 0x8a, 0xa2, 0x40, 0x77, 0x05, 0xd2, 0x45, 0x17, 0x05, 0xfa, 0x0f, 0xb4,
	0x6e, 0xd1, 0x75, 0x17, 0xdd, 0x16, 0x28, 0xee, 0xb9, 0x33, 0xd4, 0xf0, 0x25, 0x0e, 0x29, 0x59,
	0xe9, 0x6e, 0xee, 0x9d, 0x73, 0xce, 0xfd, 0x9d, 0xe7, 0x3d, 0x73, 0x48, 0xb8, 0xe0, 0x31, 0xee,
	0xd4, 0xbc, 0x32, 0xab, 0xea, 0xb6, 0x5e, 0x61, 0x5e, 0xda, 0xf5, 0x1c, 0xe1, 0xd0, 0xab, 0xba,
	0xa7, 0xdb, 0x15, 0xc7, 0x28, 0xa5, 0xcb, 0x96, 0x53, 0x33, 0xd2, 0xed, 0x54, 0xf5, 0xb5, 0xd4,
	0x7c, 0xd9, 0xa9, 0x56, 0x1d, 0x3b, 0x53, 0x5f, 0xcb, 0xa8, 0x27, 0xc5, 0x9a, 0xba, 0x53, 0x31,
	0xc5, 0x93, 0x5a, 0x29, 0x5d, 0x76, 0xaa, 0x99, 0x8a, 0x63, 0xe9, 0x76, 0x25, 0x83, 0x2f, 0x4a,
	0xb5, 0xc3, 0x8c, 0x2b, 0x1a, 0x2e, 0xe3, 0x19, 0x61, 0x56, 0x19, 0x17, 0x7a, 0xd5, 0x3d, 0x7a,
	0xf2, 0x99, 0x2f, 0x55, 0x1c, 0xa7, 0x62, 0xb1, 0x8c, 0xee, 0x9a, 0x19, 0xdd, 0xb6, 0x1d, 0xa1,
	0x0b, 0xd3, 0xb1, 0xb9, 0x7a, 0xab, 0xfd, 0x67, 0x14, 0xa6, 0xf6, 0xbc, 0x8a, 0x6e, 0x9b, 0xdf,
	0xc4, 0x7d, 0x7a, 0x0e, 0x46, 0x4c, 0x23, 0x49, 0x16, 0xc9, 0xd2, 0x64, 0x61, 0xc4, 0x34, 0xe8,
	0x0c, 0xc4, 0x6a, 0x9e, 0x95, 0x1c, 0xc1, 0x0d, 0xf9, 0x48, 0x29, 0x8c, 0xda, 0x7a, 0x95, 0x25,
	0x63, 0xb8, 0x85, 0xcf, 0x74, 0x11, 0x12, 0x06, 0xe3, 0x65, 0xcf, 0x74, 0xa5, 0x90, 0xe4, 0x28,
	0xbe, 0x0a, 0x6f, 0xd1, 0xcb, 0x00, 0x26, 0x2f, 0x1a, 0xcc, 0x62, 0x82, 0x19, 0xc9, 0xf8, 0x22,
	0x59, 0x9a, 0x28, 0x4c, 0x9a, 0x7c, 0x5b, 0x6d, 0xd0, 0xdb, 0x00, 0x65, 0x8f, 0xe9, 0x82, 0x19,
	0x45, 0x5d, 0x24, 0xc7, 0x16, 0xc9, 0x52, 0x22, 0x9b, 0x4a, 0x2b, 0xe8, 0xe9, 0x40, 0xd9, 0xf4,
	0x41, 0xa0, 0x5b, 0x61, 0xd2, 0xa7, 0xce, 0x09, 0xc9, 0xea, 0x8b, 0x95, 0xac, 0xe3, 0xfd, 0x59,
	0x7d, 0xea, 0x9c, 0xa0, 0x77, 0x60, 0x54, 0x98, 0xcc, 0x4b, 0x4e, 0x20, 0xd3, 0xf5, 0x74, 0x5f,
	0x17, 0xa5, 0x0f, 0x4c, 0xe6, 0x15, 0x90, 0x89, 0x7a, 0x30, 0x2b, 0x1c, 0xa1, 0x5b, 0x45, 0x83,
	0xb9, 0x96, 0xd3, 0xa8, 0x32, 0x5b, 0xf0, 0xe4, 0xe4, 0x62, 0x6c, 0x29, 0x91, 0xdd, 0x89, 0x20,
	0x29, 0x6c, 0xf5, 0xf4, 0x81, 0x14, 0xb4, 0x7d, 0x24, 0x67, 0xc7, 0x16, 0x5e, 0xa3, 0x30, 0x23,
	0xda, 0xb6, 0xe9, 0x0e, 0x5c, 0x31, 0x79, 0xf1, 0xd0, 0x62, 0x1f, 0x9a, 0x25, 0x8b, 0x85, 0x4f,
	0x2e, 0x32, 0x5b, 0x2f, 0x59, 0xcc, 0x48, 0x02, 0x9a, 0xf6, 0x92, 0xc9, 0xbf, 0xe2, 0x53, 0xb5,
	0x88, 0x45, 0x1a, 0xba, 0x85, 0x62, 0x74, 0xcb, 0x72, 0x3e, 0x60, 0x46, 0x51, 0x38, 0xc5, 0x1a,
	0x67, 0xc5, 0x72, 0x8d, 0x0b, 0xa7, 0x5a, 0x34, 0xab, 0x7a, 0x85, 0xf1, 0x64, 0x02, 0xc5, 0xa4,
	0x4c, 0x9e, 0x53, 0x54, 0x07, 0xce, 0x63, 0xce, 0xb6, 0x90, 0x24, 0x8f, 0x14, 0xa9, 0x2d, 0xb8,
	0xd0, 0x15, 0xb6, 0x0c, 0x99, 0xa7, 0xac, 0xe1, 0xc7, 0x90, 0x7c, 0xa4, 0x73, 0x10, 0xaf, 0xeb,
	0x56, 0x8d, 0x61, 0x18, 0xc5, 0x0b, 0x6a, 0xb1, 0x31, 0x72, 0x8b, 0x68, 0x1f, 0x13, 0x98, 0x09,
	0x5b, 0xe2, 0x5d, 0x93, 0x0b, 0xba, 0x03, 0x71, 0x53, 0xb0, 0x2a, 0x4f, 0x12, 0xb4, 0x66, 0x66,
	0x40, 0x6b, 0x16, 0x14, 0x37, 0xbd, 0x05, 0x63, 0xa5, 0x9a, 0x51, 0x61, 0x02, 0x8f, 0x4d, 0x64,
	0x17, 0xdb, 0xe5, 0xf8, 0x49, 0x56, 0x5f, 0x4b, 0x6f, 0x22, 0x5d, 0xc1, 0xa7, 0xd7, 0x3e, 0x27,
	0x30, 0x2a, 0x3d, 0xdd, 0x91, 0x0d, 0x41, 0xec, 0x8f, 0x84, 0x62, 0x7f, 0x19, 0x66, 0x9f, 0xe8,
	0xbc, 0xc8, 0x6b, 0xae, 0xeb, 0x78, 0xa2, 0xe8, 0x5a, 0xba, 0xcd, 0x31, 0x39, 0x26, 0x0a, 0xe7,
	0x9f, 0xe8, 0xfc, 0x91, 0xda, 0xdf, 0x97, 0xdb, 0xf4, 0x06, 0x50, 0x49, 0x5b, 0xd2, 0xcb, 0x4f,
	0x6b, 0x6e, 0xb1, 0xe6, 0x5a, 0x8e, 0x6e, 0x70, 0x4c, 0x97, 0x89, 0xc2, 0xcc, 0x13, 0x9d, 0x6f,
	0xe2, 0x8b, 0xc7, 0x6a, 0x9f, 0xe6, 0xe0, 0xb2, 0xc7, 0x9e, 0xd5, 0x4c, 0x8f, 0xf1, 0xa2, 0x60,
	0x5e, 0x95, 0x17, 0x75, 0xdb, 0x28, 0x96, 0x1d, 0xdb, 0x30, 0x31, 0x87, 0xfd, 0x34, 0x4a, 0x05,
	0x44, 0x07, 0x92, 0x26, 0x67, 0x1b, 0x5b, 0x4d, 0x0a, 0xed, 0x4d, 0x18, 0x7b, 0xc0, 0xaa, 0x25,
	0xe6, 0xd1, 0xd7, 0x60, 0xbc, 0xc6, 0x99, 0x57, 0x6c, 0xea, 0x33, 0x26, 0x97, 0x79, 0x43, 0x3a,
	0xc7, 0xf9, 0xc0, 0x66, 0x1e, 0x2a, 0x35, 0x51, 0x50, 0x0b, 0xed, 0x01, 0x80, 0x62, 0x44, 0x8f,
	0xdc, 0x6d, 0xf5, 0xc8, 0x97, 0x22, 0x78, 0x44, 0x71, 0xfb, 0xbe, 0xd0, 0x74, 0xb8, 0x9c, 0xe7,
	0x6a, 0x6b, 0xef, 0xb0, 0xc5, 0x59, 0xec, 0x59, 0x8d, 0x71, 0xd1, 0x1b, 0xde, 0x75, 0x38, 0xef,
	0x84, 0xe8, 0x25, 0x81, 0xb2, 0xfe, 0xb9, 0xf0, 0x76, 0xde, 0xd0, 0xde, 0x83, 0x85, 0x5e, 0x47,
	0x70, 0xd7, 0xb1, 0x39, 0xa3, 0xf3, 0x30, 0x56, 0xc5, 0xf7, 0x78, 0xc4, 0x44, 0xc1, 0x5f, 0xf5,
	0xb0, 0xc0, 0x0b, 0x02, 0xa9, 0xb0, 0x18, 0x25, 0x9a, 0x07, 0x80, 0xbb, 0xe0, 0x22, 0xdd, 0x70,
	0xd1, 0x5d, 0x18, 0x57, 0xe7, 0x70, 0x3f, 0x0e, 0x57, 0x23, 0x5b, 0x4f, 0xda, 0xbe, 0x10, 0x70,
	0x6b, 0xff, 0x1c, 0x81, 0xf1, 0x7d, 0xcf, 0x79, 0x9f, 0x95, 0xc5, 0x2b, 0x2b, 0xd3, 0x5d, 0xb4,
	0x8a, 0x77, 0xd5, 0xaa, 0xb5, 0x9e, 0x8f, 0x1d, 0x5f, 0xcf, 0xc7, 0x87, 0xaf, 0xe7, 0x13, 0x83,
	0xd4, 0xf3, 0x08, 0xe5, 0x71, 0xb2, 0x7f, 0x79, 0xd4, 0xbe, 0x4b, 0x20, 0xe1, 0x1b, 0x1a, 0xa3,
	0xff, 0x5e, 0x6b, 0xf4, 0x2f, 0x47, 0xf0, 0x9f, 0xcf, 0x7e, 0xf2, 0x52, 0xf4, 0xbd, 0x18, 0xc4,
	0x77, 0xea, 0xcc, 0x8e, 0xe2, 0xf2, 0x2e, 0xce, 0x8b, 0xf5, 0x72, 0x1e, 0xaf, 0x95, 0x24, 0x40,
	0x49, 0xa3, 0xc2, 0x60, 0xd2, 0xdf, 0xc9, 0x63, 0x95, 0x93, 0x5d, 0x85, 0xef, 0x79, 0x7c, 0xa6,
	0x7b, 0x30, 0xee, 0xea, 0x0d, 0x59, 0x97, 0x92, 0x63, 0x68, 0x85, 0x9b, 0x11, 0xac, 0x80, 0xc0,
	0xd3, 0xfb, 0x8a, 0x4f, 0xdd, 0x69, 0x81, 0x94, 0x93, 0x44, 0xc8, 0x15, 0x48, 0x04, 0xf0, 0xa5,
	0x05, 0x26, 0x10, 0x66, 0xa0, 0xd1, 0x63, 0xcf, 0xa2, 0x29, 0x98, 0xa8, 0x3b, 0x96, 0x2e, 0x4c,
	0x8b, 0xf9, 0x0e, 0x6f, 0xae, 0x53, 0x1b, 0x30, 0x15, 0x06, 0xd4, 0xef, 0xb6, 0x9a, 0x0c, 0xdf,
	0x56, 0xf7, 0x61, 0x12, 0x55, 0xc2, 0xa8, 0x78, 0xa7, 0x35, 0x2a, 0x96, 0xa2, 0xda, 0x23, 0x28,
	0x89, 0x2f, 0x46, 0x60, 0x46, 0x0a, 0xc2, 0xcd, 0x3d, 0x4c, 0x3f, 0x4e, 0xef, 0xc2, 0xb8, 0xa3,
	0x1e, 0x11, 0x51, 0x22, 0x7b, 0xad, 0x77, 0xa4, 0x48, 0x66, 0x9f, 0xaf, 0x10, 0x70, 0x85, 0x6d,
	0x63, 0x1a, 0xb2, 0xe2, 0xc4, 0x42, 0xb6, 0xc9, 0x1b, 0x5c, 0x6a, 0x87, 0x2d, 0x63, 0x32, 0x86,
	0xaf, 0xd4, 0x82, 0xde, 0x85, 0xe9, 0xa6, 0x37, 0x0e, 0x05, 0xf3, 0x30, 0x28, 0x8e, 0x77, 0xc8,
	0x54, 0xe0, 0x10, 0x49, 0x4f, 0x73, 0x70, 0x2e, 0x10, 0x50, 0x62, 0x87, 0x8e, 0xa7, 0xa2, 0xe7,
	0x78, 0x09, 0xc1, 0x91, 0x9b, 0xc8, 0xa0, 0xfd, 0x3b, 0x06, 0x34, 0x5c, 0x70, 0xf3, 0x76, 0xdd,
	0x14, 0xec, 0x34, 0xe3, 0x7e, 0x0e, 0xe2, 0xac, 0xaa, 0x9b, 0x96, 0x1f, 0xf2, 0x6a, 0x21, 0xa3,
	0x45, 0x2f, 0x97, 0x99, 0x7b, 0xd4, 0x98, 0x36, 0xd7, 0xf2, 0x9d, 0xc7, 0xa4, 0xe9, 0x9a, 0x45,
	0xae, 0xb9, 0x3e, 0x49, 0x04, 0xdf, 0x81, 0x44, 0x70, 0x44, 0xb4, 0x22, 0x07, 0x01, 0xb9, 0x62,
	0x0e, 0x30, 0x48, 0xe6, 0xc9, 0xfe, 0xcc, 0x01, 0x79, 0xae, 0xe5, 0x9e, 0x85, 0x96, 0x7b, 0x56,
	0x3b, 0x8a, 0x80, 0x52, 0x43, 0xbe, 0x4e, 0xa8, 0xdb, 0x21, 0xf0, 0x51, 0x23, 0x6f, 0xd0, 0x15,
	0x98, 0x6d, 0x31, 0x34, 0x5e, 0x30, 0x53, 0x48, 0x37, 0x13, 0x7e, 0xf1, 0x9e, 0xbc, 0x6c, 0xfe,
	0x1f, 0xce, 0x87, 0x04, 0x22, 0xe9, 0x34, 0x92, 0x36, 0xdd, 0xde, 0x90, 0x74, 0x1a, 0x83, 0xf9,
	0x4e, 0xaf, 0x63, 0x86, 0xdd, 0x6f, 0xcd, 0xb0, 0x9b, 0x03, 0xf6, 0x81, 0x4a, 0x52, 0x90, 0x6e,
	0x9f, 0x10, 0x98, 0x79, 0x58, 0x73, 0x84, 0xbe, 0x1d, 0xba, 0xee, 0x28, 0x8c, 0x3e, 0x35, 0xed,
	0x20, 0xba, 0xf0, 0xb9, 0xfd, 0x92, 0x1c, 0xe9, 0xbc, 0x24, 0x57, 0x60, 0xf6, 0xd0, 0xf1, 0x8a,
	0x61, 0x8d, 0x83, 0x8e, 0x6f, 0xe6, 0xd0, 0xf1, 0xc2, 0x18, 0x38, 0xbd, 0x0a, 0x53, 0x92, 0xd8,
	0x55, 0x17, 0x42, 0xd0, 0xec, 0x25, 0x0e, 0x1d, 0xcf, 0xbf, 0x23, 0x64, 0x73, 0x34, 0xd7, 0x8e,
	0x0c, 0xf5, 0xcf, 0xb7, 0xea, 0xbf, 0x1e, 0x41, 0xff, 0x76, 0x39, 0x81, 0xf6, 0x8f, 0x20, 0x8e,
	0xaf, 0x86, 0xd4, 0x78, 0x0e, 0xe2, 0x96, 0x59, 0x35, 0x05, 0x6a, 0x19, 0x2b, 0xa8, 0x85, 0x2c,
	0x87, 0x28, 0x74, 0xd8, 0x72, 0x88, 0xcc, 0x01, 0xc2, 0xf7, 0x61, 0x56, 0xca, 0xc1, 0xbd, 0x66,
	0x93, 0x75, 0xe2, 0x72, 0x38, 0x07, 0x71, 0xa9, 0x62, 0x50, 0x08, 0xd5, 0x42, 0x6b, 0x00, 0xed,
	0xec, 0x95, 0x3b, 0x0a, 0x4d, 0x12, 0xc6, 0xcb, 0x8e, 0x2d, 0x98, 0x2d, 0x7c, 0x93, 0x04, 0xcb,
	0xb6, 0xcc, 0x8f, 0x0d, 0x90, 0xf9, 0xda, 0x73, 0x98, 0xdf, 0xd6, 0x85, 0xbe, 0xef, 0x39, 0x65,
	0xc6, 0xb9, 0x69, 0x57, 0x72, 0x86, 0xc1, 0x6c, 0xa3, 0x56, 0x3d, 0x93, 0xe3, 0xb3, 0x3f, 0x5e,
	0x81, 0xf9, 0x82, 0xef, 0x89, 0x07, 0xca, 0x13, 0x8f, 0x98, 0x57, 0x37, 0xcb, 0x8c, 0x7e, 0x8b,
	0xc0, 0xf4, 0x2e, 0x13, 0xb9, 0xfd, 0xfc, 0xd7, 0x98, 0xc7, 0xa5, 0xd7, 0xaf, 0xf4, 0x36, 0xf6,
	0x4e, 0xd5, 0x15, 0x8d, 0xd4, 0xd5, 0xde, 0x04, 0xbe, 0x0c, 0x6d, 0xe5, 0xdb, 0x7f, 0xf9, 0xc7,
	0xc7, 0x23, 0xd7, 0xe8, 0xeb, 0x38, 0x80, 0x68, 0x0b, 0x82, 0x4c, 0x7d, 0x4d, 0x6e, 0xaf, 0xd6,
	0xfd, 0x03, 0x7f, 0x44, 0x54, 0x10, 0xb4, 0x66, 0x50, 0x34, 0x9f, 0xa7, 0xd6, 0x07, 0x2c, 0x0f,
	0x92, 0x57, 0xcb, 0x22, 0xbc, 0x1b, 0x74, 0xb9, 0x17, 0x3c, 0xce, 0xac, 0xc3, 0x4c, 0x4b, 0xa6,
	0xd3, 0x4f, 0x09, 0x9c, 0xdf, 0x65, 0x2d, 0x20, 0xe9, 0xeb, 0xbd, 0x31, 0xe6, 0xb7, 0x03, 0x84,
	0x83, 0x7e, 0xc8, 0xf6, 0x47, 0xd7, 0x02, 0x2c, 0xf3, 0x91, 0x69, 0x3c, 0xa7, 0x3f, 0x25, 0x40,
	0xb7, 0xd0, 0xdf, 0x2d, 0x00, 0x07, 0x3d, 0x7b, 0x70, 0xb0, 0x5f, 0x46, 0xb0, 0xcb, 0xda, 0xb5,
	0x48, 0x60, 0x37, 0xc8, 0x32, 0xfd, 0x39, 0x01, 0xfa, 0xd8, 0x35, 0xce, 0x1e, 0xea, 0x4d, 0x84,
	0x9a, 0xc9, 0x0e, 0x60, 0x57, 0x89, 0xf7, 0x05, 0x01, 0xaa, 0x3e, 0x70, 0x06, 0xf7, 0x7d, 0xbf,
	0x5c, 0x0a, 0x7c, 0xbd, 0x3c, 0x88, 0xaf, 0x7f, 0x45, 0xe0, 0xb5, 0xf6, 0x7c, 0xf1, 0x3f, 0x53,
	0xa3, 0x66, 0xcd, 0x60, 0x1f, 0xa3, 0xda, 0x26, 0xa2, 0x7c, 0x8b, 0x6e, 0x44, 0x44, 0x89, 0x25,
	0xeb, 0x43, 0xd9, 0x8b, 0x3e, 0xcf, 0xf8, 0xdf, 0xb1, 0xf4, 0x0f, 0x04, 0xe6, 0x73, 0x86, 0xd1,
	0x0d, 0xf4, 0xdb, 0x03, 0x7a, 0xb2, 0xf5, 0x9b, 0xbc, 0xbf, 0x91, 0xbf, 0x8a, 0xf0, 0xb7, 0xb5,
	0xbb, 0x11, 0xe1, 0xb7, 0xb5, 0x95, 0x4d, 0x1d, 0x64, 0x34, 0x7c, 0x4e, 0xe0, 0x62, 0x67, 0xf4,
	0x9e, 0xb1, 0x26, 0xd9, 0xd3, 0xd2, 0xa4, 0x33, 0xae, 0xcf, 0x58, 0x93, 0xe5, 0xd3, 0xd0, 0xe4,
	0x5f, 0x04, 0xe6, 0xbb, 0x0f, 0x81, 0xe8, 0xbd, 0x08, 0x6a, 0x1c, 0x3b, 0xa2, 0x4a, 0xe5, 0x4e,
	0x20, 0x41, 0x4d, 0xa0, 0xb4, 0x87, 0xa8, 0xeb, 0x7d, 0x9a, 0x3f, 0xa1, 0xae, 0x99, 0x8f, 0xfc,
	0x26, 0xfe, 0xb9, 0x74, 0xde, 0x7c, 0x7b, 0x0d, 0x50, 0x4d, 0x14, 0x7d, 0x23, 0x02, 0xe0, 0x8e,
	0x9e, 0x2b, 0x75, 0x23, 0x6a, 0xe7, 0x86, 0x05, 0x21, 0x8f, 0x1a, 0x6d, 0xd1, 0x5c, 0x54, 0x8d,
	0x54, 0xdd, 0x49, 0x87, 0x0b, 0xc3, 0x33, 0x05, 0xf7, 0x67, 0x04, 0xa6, 0xa4, 0xcc, 0xa0, 0x2f,
	0x8e, 0x5a, 0xc2, 0xd2, 0xd1, 0xe7, 0x31, 0x08, 0x79, 0x0b, 0x21, 0xbf, 0x4d, 0xef, 0x0c, 0x51,
	0xc3, 0x82, 0x36, 0x9e, 0x7e, 0x9f, 0x00, 0xec, 0xb2, 0x00, 0x6b, 0xb4, 0x3b, 0x60, 0x80, 0xc1,
	0x91, 0xb6, 0x8a, 0x20, 0xaf, 0xd3, 0x9e, 0xb7, 0x69, 0x80, 0x44, 0xdd, 0x04, 0xbf, 0x26, 0x30,
	0xad, 0x6e, 0xfd, 0x00, 0xd1, 0x00, 0x87, 0x0d, 0x04, 0xec, 0x3e, 0x02, 0xdb, 0xd1, 0xee, 0x0d,
	0x1b, 0xc2, 0x01, 0x70, 0x99, 0xaf, 0x3f, 0x20, 0x30, 0xad, 0x6a, 0xe8, 0xab, 0x86, 0xed, 0x77,
	0x27, 0xd9, 0x68, 0xf6, 0x94, 0xd8, 0xbe, 0x43, 0x60, 0x5a, 0x55, 0xc5, 0x81, 0x9c, 0xdc, 0xb7,
	0xde, 0xf9, 0x9e, 0x5d, 0x8e, 0xe8, 0xd9, 0xdf, 0xfb, 0x3d, 0xb1, 0x0f, 0xe2, 0x0c, 0x53, 0x7b,
	0x1b, 0x81, 0xbe, 0x43, 0xdf, 0xea, 0x0f, 0xf4, 0x98, 0xac, 0xfe, 0x1d, 0x01, 0x68, 0x8e, 0xb9,
	0x38, 0x5d, 0x8f, 0x08, 0x3c, 0x3c, 0x15, 0x8b, 0x84, 0xbb, 0x39, 0x98, 0x3b, 0x95, 0x92, 0xc4,
	0x14, 0xda, 0x3f, 0x75, 0x69, 0xb0, 0xd4, 0x58, 0x21, 0x72, 0x75, 0xba, 0x3d, 0xd4, 0xd4, 0x02,
	0x15, 0xd9, 0x43, 0x45, 0xf2, 0x74, 0x77, 0x88, 0x42, 0x15, 0x7e, 0xb5, 0x6a, 0xfa, 0x90, 0x7f,
	0x4b, 0xe0, 0xa2, 0x94, 0xfc, 0xa0, 0xf1, 0xc5, 0x28, 0x74, 0x1b, 0x15, 0x5a, 0xa7, 0x6b, 0x91,
	0xbf, 0xb6, 0x9a, 0xd0, 0x7f, 0x41, 0xe0, 0x42, 0xdb, 0x47, 0x97, 0x3f, 0x1f, 0x8c, 0x94, 0x95,
	0xc3, 0xcd, 0x8e, 0xfa, 0x03, 0xee, 0x86, 0x55, 0xe5, 0xed, 0xdf, 0x08, 0x24, 0x3b, 0xbf, 0xc3,
	0x7c, 0xcc, 0xc3, 0xc1, 0x19, 0x56, 0x8b, 0xaf, 0xa3, 0x16, 0x0f, 0xb5, 0x77, 0x87, 0x2d, 0xd9,
	0xdd, 0xb4, 0x94, 0x25, 0xf2, 0x53, 0x02, 0xc9, 0xce, 0xc6, 0x71, 0x10, 0xbf, 0xf4, 0xad, 0x96,
	0xbe, 0x07, 0x96, 0x87, 0xf0, 0xc0, 0x0f, 0x09, 0x24, 0x73, 0x38, 0x36, 0x7d, 0x65, 0xe8, 0xee,
	0x21, 0xba, 0x0d, 0xed, 0xd6, 0xc0, 0xe8, 0x32, 0x6a, 0xa0, 0x8b, 0x20, 0x0b, 0x38, 0x9e, 0xfd,
	0x5f, 0x04, 0xa9, 0x06, 0xc7, 0xf4, 0x33, 0x02, 0x17, 0x9a, 0xb7, 0x49, 0x68, 0xba, 0x18, 0xb9,
	0x66, 0xbc, 0x39, 0xc4, 0xe8, 0x12, 0x2b, 0xc6, 0x3a, 0x62, 0x5f, 0xa5, 0x2b, 0xbd, 0xb0, 0xab,
	0x5b, 0x26, 0x63, 0x84, 0x41, 0x7d, 0xa6, 0x6a, 0x45, 0x97, 0x11, 0xdf, 0xa9, 0xd5, 0x8a, 0x6e,
	0x3f, 0xb5, 0x23, 0xd4, 0x35, 0x9a, 0xe9, 0x05, 0x15, 0x7f, 0xc2, 0xd7, 0x6d, 0xe3, 0xe8, 0x07,
	0x7c, 0x15, 0xa7, 0xbf, 0x21, 0x70, 0x69, 0x97, 0x89, 0xad, 0x9a, 0xe7, 0x31, 0xfb, 0xac, 0x51,
	0x6f, 0x20, 0xea, 0x37, 0x68, 0xb6, 0x17, 0xea, 0xb2, 0x82, 0xb5, 0xda, 0x89, 0x9e, 0xfe, 0x84,
	0xc0, 0xc5, 0x5d, 0x26, 0x7a, 0xcc, 0x33, 0x23, 0xa1, 0x8e, 0x72, 0x99, 0x74, 0x97, 0xaf, 0x2d,
	0x21, 0x72, 0x8d, 0x2e, 0xf6, 0x42, 0x6e, 0xb8, 0xba, 0x32, 0xf0, 0x2f, 0x09, 0x2c, 0x1e, 0x19,
	0xf8, 0x0b, 0x82, 0xdb, 0x77, 0x10, 0x1a, 0x18, 0xda, 0x70, 0xf5, 0xcd, 0x9d, 0x3f, 0xbe, 0x5c,
	0x20, 0x7f, 0x7e, 0xb9, 0x40, 0xfe, 0xfa, 0x72, 0x81, 0x7c, 0xf2, 0xf7, 0x85, 0xff, 0xfb, 0xc6,
	0x7a, 0xe8, 0x3f, 0x60, 0x01, 0x86, 0x55, 0xc5, 0x6d, 0x48, 0x89, 0xbc, 0x8b, 0xc8, 0xd2, 0x18,
	0x0e, 0x83, 0xd7, 0xff, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x76, 0x47, 0xe0, 0x71, 0x93, 0x26, 0x00,
	0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ResourceManagerServiceClient is the client API for ResourceManagerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResourceManagerServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all organizations that the authenticated user is a member of.
	// Required permissions:
	// - None
	ListOrganizations(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationList, error)
	// Fetch an organization by its id.
	// The authenticated user must be a member of the organization.
	// Required permissions:
	// - None
	GetOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Organization, error)
	// Create a new organization
	// Required permissions:
	// - None
	CreateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error)
	// Update an organization
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	UpdateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error)
	// Delete an organization
	// Note that organization are never really removed.
	// Instead their is_deleted field is set to true.
	// Required permissions:
	// - resourcemanager.organization.delete on the organization
	DeleteOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Get a list of members of the organization identified by the given context ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*MemberList, error)
	// Add one or more members to an organization.
	// If there are members (in the request arguments) that are already member of the
	// organization an AlreadyExists error is returned.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	AddOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Update the ownership flag of one or more members of an organization.
	// If there are members (in the request arguments) that are not yet member of
	// the organization, an InvalidArgument error is returned.
	// If the request would result in the last owner no longer being an owner,
	// an InvalidArgument error is returned.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	UpdateOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Remove one or more members from an organization.
	// If the request would result in the last owner being removed as member
	// of the organization, an InvalidArgument error is returned.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	DeleteOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Is the user identified by the given user ID a member
	// of the organization identified by the given organization ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization, unless the requested user is identical to the authenticated user.
	// Note that if the identified user or organization does not exist, no is returned.
	IsMemberOfOrganization(ctx context.Context, in *IsMemberOfOrganizationRequest, opts ...grpc.CallOption) (*IsMemberOfOrganizationResponse, error)
	// Get a list of quota values for the organization identified by the given context ID.
	// If a quota is not specified on organization level, a (potentially tier specific) default
	// value is returned.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationQuotas(ctx context.Context, in *ListQuotasRequest, opts ...grpc.CallOption) (*QuotaList, error)
	// Fetch all projects in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.project.list on the organization identified by the given context ID
	ListProjects(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*ProjectList, error)
	// Fetch a project by its id.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.get on the project identified by the given ID
	GetProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Project, error)
	// Create a new project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.create on the organization that owns the project
	CreateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error)
	// Update a project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.update on the project
	UpdateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error)
	// Delete a project
	// Note that project are initially only marked for deleted.
	// Once all their resources are removed the project itself is deleted
	// and cannot be restored.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.delete on the project
	DeleteProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Get a list of quota values for the project identified by the given context ID.
	// If a quota is not specified on project level, a value from organization level
	// is returned.
	// Required permissions:
	// - resourcemanager.project.get on the project
	ListProjectQuotas(ctx context.Context, in *ListQuotasRequest, opts ...grpc.CallOption) (*QuotaList, error)
	// Fetch all events in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.event.list on the organization identified by the given context ID
	ListEvents(ctx context.Context, in *ListEventOptions, opts ...grpc.CallOption) (*EventList, error)
	// Fetch all organization invites in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.organization-invite.list on the invite.
	ListOrganizationInvites(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationInviteList, error)
	// Fetch all organization invites for the email address of the authenticated user.
	// Required permissions:
	// - None
	ListMyOrganizationInvites(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationInviteList, error)
	// Fetch an organization invite by its id.
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.get on the invite.
	GetOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*OrganizationInvite, error)
	// Create a new organization invite.
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.create on the organization that the invite is for.
	CreateOrganizationInvite(ctx context.Context, in *OrganizationInvite, opts ...grpc.CallOption) (*OrganizationInvite, error)
	// Delete an organization invite
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.delete on the invite
	DeleteOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Accept an organization invite
	// The authenticated user's email address must match the email address specified in
	// the invite.
	// Required permissions:
	// - None
	AcceptOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Reject an organization invite
	// The authenticated user's email address must match the email address specified in
	// the invite.
	// Required permissions:
	// - None
	RejectOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch descriptions for all quota kinds know by the platform.
	// Required permissions:
	// - None
	ListQuotaDescriptions(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*QuotaDescriptionList, error)
	// Fetch a specific version of the Terms & Conditions.
	// Required permissions:
	// - None
	GetTermsAndConditions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*TermsAndConditions, error)
	// Fetch the current version of the Terms & Conditions for the organization
	// identified by the given (optional) ID.
	// Required permissions:
	// - None If ID is empty.
	// - resourcemanager.organization.get If ID is not empty.
	GetCurrentTermsAndConditions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*TermsAndConditions, error)
	// Fetch a specific version of the Data Processing Addendum.
	// Required permissions:
	// - None
	GetDataProcessingAddendum(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*DataProcessingAddendum, error)
	// Fetch the current version of the Data Processing Addendum for the organization
	// identified by the given (optional) ID.
	// Required permissions:
	// - None If ID is empty.
	// - resourcemanager.organization.get If ID is not empty.
	GetCurrentDataProcessingAddendum(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*DataProcessingAddendum, error)
}

type resourceManagerServiceClient struct {
	cc *grpc.ClientConn
}

func NewResourceManagerServiceClient(cc *grpc.ClientConn) ResourceManagerServiceClient {
	return &resourceManagerServiceClient{cc}
}

func (c *resourceManagerServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListOrganizations(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationList, error) {
	out := new(OrganizationList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) CreateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) UpdateOrganization(ctx context.Context, in *Organization, opts ...grpc.CallOption) (*Organization, error) {
	out := new(Organization)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteOrganization(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListOrganizationMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*MemberList, error) {
	out := new(MemberList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) AddOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AddOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) UpdateOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteOrganizationMembers(ctx context.Context, in *OrganizationMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) IsMemberOfOrganization(ctx context.Context, in *IsMemberOfOrganizationRequest, opts ...grpc.CallOption) (*IsMemberOfOrganizationResponse, error) {
	out := new(IsMemberOfOrganizationResponse)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/IsMemberOfOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListOrganizationQuotas(ctx context.Context, in *ListQuotasRequest, opts ...grpc.CallOption) (*QuotaList, error) {
	out := new(QuotaList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationQuotas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListProjects(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*ProjectList, error) {
	out := new(ProjectList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) CreateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) UpdateProject(ctx context.Context, in *Project, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListProjectQuotas(ctx context.Context, in *ListQuotasRequest, opts ...grpc.CallOption) (*QuotaList, error) {
	out := new(QuotaList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjectQuotas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListEvents(ctx context.Context, in *ListEventOptions, opts ...grpc.CallOption) (*EventList, error) {
	out := new(EventList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListOrganizationInvites(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationInviteList, error) {
	out := new(OrganizationInviteList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationInvites", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListMyOrganizationInvites(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*OrganizationInviteList, error) {
	out := new(OrganizationInviteList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListMyOrganizationInvites", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*OrganizationInvite, error) {
	out := new(OrganizationInvite)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) CreateOrganizationInvite(ctx context.Context, in *OrganizationInvite, opts ...grpc.CallOption) (*OrganizationInvite, error) {
	out := new(OrganizationInvite)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) DeleteOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) AcceptOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AcceptOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) RejectOrganizationInvite(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/RejectOrganizationInvite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) ListQuotaDescriptions(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*QuotaDescriptionList, error) {
	out := new(QuotaDescriptionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListQuotaDescriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetTermsAndConditions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*TermsAndConditions, error) {
	out := new(TermsAndConditions)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetTermsAndConditions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetCurrentTermsAndConditions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*TermsAndConditions, error) {
	out := new(TermsAndConditions)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetCurrentTermsAndConditions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetDataProcessingAddendum(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*DataProcessingAddendum, error) {
	out := new(DataProcessingAddendum)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetDataProcessingAddendum", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceManagerServiceClient) GetCurrentDataProcessingAddendum(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*DataProcessingAddendum, error) {
	out := new(DataProcessingAddendum)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetCurrentDataProcessingAddendum", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResourceManagerServiceServer is the server API for ResourceManagerService service.
type ResourceManagerServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all organizations that the authenticated user is a member of.
	// Required permissions:
	// - None
	ListOrganizations(context.Context, *v1.ListOptions) (*OrganizationList, error)
	// Fetch an organization by its id.
	// The authenticated user must be a member of the organization.
	// Required permissions:
	// - None
	GetOrganization(context.Context, *v1.IDOptions) (*Organization, error)
	// Create a new organization
	// Required permissions:
	// - None
	CreateOrganization(context.Context, *Organization) (*Organization, error)
	// Update an organization
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	UpdateOrganization(context.Context, *Organization) (*Organization, error)
	// Delete an organization
	// Note that organization are never really removed.
	// Instead their is_deleted field is set to true.
	// Required permissions:
	// - resourcemanager.organization.delete on the organization
	DeleteOrganization(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Get a list of members of the organization identified by the given context ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationMembers(context.Context, *v1.ListOptions) (*MemberList, error)
	// Add one or more members to an organization.
	// If there are members (in the request arguments) that are already member of the
	// organization an AlreadyExists error is returned.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	AddOrganizationMembers(context.Context, *OrganizationMembersRequest) (*v1.Empty, error)
	// Update the ownership flag of one or more members of an organization.
	// If there are members (in the request arguments) that are not yet member of
	// the organization, an InvalidArgument error is returned.
	// If the request would result in the last owner no longer being an owner,
	// an InvalidArgument error is returned.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	UpdateOrganizationMembers(context.Context, *OrganizationMembersRequest) (*v1.Empty, error)
	// Remove one or more members from an organization.
	// If the request would result in the last owner being removed as member
	// of the organization, an InvalidArgument error is returned.
	// Required permissions:
	// - resourcemanager.organization.update on the organization
	DeleteOrganizationMembers(context.Context, *OrganizationMembersRequest) (*v1.Empty, error)
	// Is the user identified by the given user ID a member
	// of the organization identified by the given organization ID.
	// Required permissions:
	// - resourcemanager.organization.get on the organization, unless the requested user is identical to the authenticated user.
	// Note that if the identified user or organization does not exist, no is returned.
	IsMemberOfOrganization(context.Context, *IsMemberOfOrganizationRequest) (*IsMemberOfOrganizationResponse, error)
	// Get a list of quota values for the organization identified by the given context ID.
	// If a quota is not specified on organization level, a (potentially tier specific) default
	// value is returned.
	// Required permissions:
	// - resourcemanager.organization.get on the organization
	ListOrganizationQuotas(context.Context, *ListQuotasRequest) (*QuotaList, error)
	// Fetch all projects in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.project.list on the organization identified by the given context ID
	ListProjects(context.Context, *v1.ListOptions) (*ProjectList, error)
	// Fetch a project by its id.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.get on the project identified by the given ID
	GetProject(context.Context, *v1.IDOptions) (*Project, error)
	// Create a new project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.create on the organization that owns the project
	CreateProject(context.Context, *Project) (*Project, error)
	// Update a project
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.update on the project
	UpdateProject(context.Context, *Project) (*Project, error)
	// Delete a project
	// Note that project are initially only marked for deleted.
	// Once all their resources are removed the project itself is deleted
	// and cannot be restored.
	// The authenticated user must be a member of the organization that owns the project.
	// Required permissions:
	// - resourcemanager.project.delete on the project
	DeleteProject(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Get a list of quota values for the project identified by the given context ID.
	// If a quota is not specified on project level, a value from organization level
	// is returned.
	// Required permissions:
	// - resourcemanager.project.get on the project
	ListProjectQuotas(context.Context, *ListQuotasRequest) (*QuotaList, error)
	// Fetch all events in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.event.list on the organization identified by the given context ID
	ListEvents(context.Context, *ListEventOptions) (*EventList, error)
	// Fetch all organization invites in the organization identified by the given context ID.
	// The authenticated user must be a member of the organization identifier by the given context ID.
	// Required permissions:
	// - resourcemanager.organization-invite.list on the invite.
	ListOrganizationInvites(context.Context, *v1.ListOptions) (*OrganizationInviteList, error)
	// Fetch all organization invites for the email address of the authenticated user.
	// Required permissions:
	// - None
	ListMyOrganizationInvites(context.Context, *v1.ListOptions) (*OrganizationInviteList, error)
	// Fetch an organization invite by its id.
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.get on the invite.
	GetOrganizationInvite(context.Context, *v1.IDOptions) (*OrganizationInvite, error)
	// Create a new organization invite.
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.create on the organization that the invite is for.
	CreateOrganizationInvite(context.Context, *OrganizationInvite) (*OrganizationInvite, error)
	// Delete an organization invite
	// The authenticated user must be a member of the organization that the invite is for.
	// Required permissions:
	// - resourcemanager.organization-invite.delete on the invite
	DeleteOrganizationInvite(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Accept an organization invite
	// The authenticated user's email address must match the email address specified in
	// the invite.
	// Required permissions:
	// - None
	AcceptOrganizationInvite(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Reject an organization invite
	// The authenticated user's email address must match the email address specified in
	// the invite.
	// Required permissions:
	// - None
	RejectOrganizationInvite(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch descriptions for all quota kinds know by the platform.
	// Required permissions:
	// - None
	ListQuotaDescriptions(context.Context, *v1.ListOptions) (*QuotaDescriptionList, error)
	// Fetch a specific version of the Terms & Conditions.
	// Required permissions:
	// - None
	GetTermsAndConditions(context.Context, *v1.IDOptions) (*TermsAndConditions, error)
	// Fetch the current version of the Terms & Conditions for the organization
	// identified by the given (optional) ID.
	// Required permissions:
	// - None If ID is empty.
	// - resourcemanager.organization.get If ID is not empty.
	GetCurrentTermsAndConditions(context.Context, *v1.IDOptions) (*TermsAndConditions, error)
	// Fetch a specific version of the Data Processing Addendum.
	// Required permissions:
	// - None
	GetDataProcessingAddendum(context.Context, *v1.IDOptions) (*DataProcessingAddendum, error)
	// Fetch the current version of the Data Processing Addendum for the organization
	// identified by the given (optional) ID.
	// Required permissions:
	// - None If ID is empty.
	// - resourcemanager.organization.get If ID is not empty.
	GetCurrentDataProcessingAddendum(context.Context, *v1.IDOptions) (*DataProcessingAddendum, error)
}

// UnimplementedResourceManagerServiceServer can be embedded to have forward compatible implementations.
type UnimplementedResourceManagerServiceServer struct {
}

func (*UnimplementedResourceManagerServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListOrganizations(ctx context.Context, req *v1.ListOptions) (*OrganizationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrganizations not implemented")
}
func (*UnimplementedResourceManagerServiceServer) GetOrganization(ctx context.Context, req *v1.IDOptions) (*Organization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganization not implemented")
}
func (*UnimplementedResourceManagerServiceServer) CreateOrganization(ctx context.Context, req *Organization) (*Organization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateOrganization not implemented")
}
func (*UnimplementedResourceManagerServiceServer) UpdateOrganization(ctx context.Context, req *Organization) (*Organization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOrganization not implemented")
}
func (*UnimplementedResourceManagerServiceServer) DeleteOrganization(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOrganization not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListOrganizationMembers(ctx context.Context, req *v1.ListOptions) (*MemberList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrganizationMembers not implemented")
}
func (*UnimplementedResourceManagerServiceServer) AddOrganizationMembers(ctx context.Context, req *OrganizationMembersRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddOrganizationMembers not implemented")
}
func (*UnimplementedResourceManagerServiceServer) UpdateOrganizationMembers(ctx context.Context, req *OrganizationMembersRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOrganizationMembers not implemented")
}
func (*UnimplementedResourceManagerServiceServer) DeleteOrganizationMembers(ctx context.Context, req *OrganizationMembersRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOrganizationMembers not implemented")
}
func (*UnimplementedResourceManagerServiceServer) IsMemberOfOrganization(ctx context.Context, req *IsMemberOfOrganizationRequest) (*IsMemberOfOrganizationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsMemberOfOrganization not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListOrganizationQuotas(ctx context.Context, req *ListQuotasRequest) (*QuotaList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrganizationQuotas not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListProjects(ctx context.Context, req *v1.ListOptions) (*ProjectList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProjects not implemented")
}
func (*UnimplementedResourceManagerServiceServer) GetProject(ctx context.Context, req *v1.IDOptions) (*Project, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProject not implemented")
}
func (*UnimplementedResourceManagerServiceServer) CreateProject(ctx context.Context, req *Project) (*Project, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProject not implemented")
}
func (*UnimplementedResourceManagerServiceServer) UpdateProject(ctx context.Context, req *Project) (*Project, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProject not implemented")
}
func (*UnimplementedResourceManagerServiceServer) DeleteProject(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProject not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListProjectQuotas(ctx context.Context, req *ListQuotasRequest) (*QuotaList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProjectQuotas not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListEvents(ctx context.Context, req *ListEventOptions) (*EventList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvents not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListOrganizationInvites(ctx context.Context, req *v1.ListOptions) (*OrganizationInviteList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrganizationInvites not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListMyOrganizationInvites(ctx context.Context, req *v1.ListOptions) (*OrganizationInviteList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMyOrganizationInvites not implemented")
}
func (*UnimplementedResourceManagerServiceServer) GetOrganizationInvite(ctx context.Context, req *v1.IDOptions) (*OrganizationInvite, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrganizationInvite not implemented")
}
func (*UnimplementedResourceManagerServiceServer) CreateOrganizationInvite(ctx context.Context, req *OrganizationInvite) (*OrganizationInvite, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateOrganizationInvite not implemented")
}
func (*UnimplementedResourceManagerServiceServer) DeleteOrganizationInvite(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOrganizationInvite not implemented")
}
func (*UnimplementedResourceManagerServiceServer) AcceptOrganizationInvite(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcceptOrganizationInvite not implemented")
}
func (*UnimplementedResourceManagerServiceServer) RejectOrganizationInvite(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RejectOrganizationInvite not implemented")
}
func (*UnimplementedResourceManagerServiceServer) ListQuotaDescriptions(ctx context.Context, req *v1.ListOptions) (*QuotaDescriptionList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQuotaDescriptions not implemented")
}
func (*UnimplementedResourceManagerServiceServer) GetTermsAndConditions(ctx context.Context, req *v1.IDOptions) (*TermsAndConditions, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTermsAndConditions not implemented")
}
func (*UnimplementedResourceManagerServiceServer) GetCurrentTermsAndConditions(ctx context.Context, req *v1.IDOptions) (*TermsAndConditions, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCurrentTermsAndConditions not implemented")
}
func (*UnimplementedResourceManagerServiceServer) GetDataProcessingAddendum(ctx context.Context, req *v1.IDOptions) (*DataProcessingAddendum, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataProcessingAddendum not implemented")
}
func (*UnimplementedResourceManagerServiceServer) GetCurrentDataProcessingAddendum(ctx context.Context, req *v1.IDOptions) (*DataProcessingAddendum, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCurrentDataProcessingAddendum not implemented")
}

func RegisterResourceManagerServiceServer(s *grpc.Server, srv ResourceManagerServiceServer) {
	s.RegisterService(&_ResourceManagerService_serviceDesc, srv)
}

func _ResourceManagerService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListOrganizations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizations(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetOrganization(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_CreateOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Organization)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).CreateOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).CreateOrganization(ctx, req.(*Organization))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_UpdateOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Organization)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).UpdateOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).UpdateOrganization(ctx, req.(*Organization))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteOrganization(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizationMembers(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_AddOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).AddOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AddOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).AddOrganizationMembers(ctx, req.(*OrganizationMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_UpdateOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).UpdateOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).UpdateOrganizationMembers(ctx, req.(*OrganizationMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteOrganizationMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationMembers(ctx, req.(*OrganizationMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_IsMemberOfOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsMemberOfOrganizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).IsMemberOfOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/IsMemberOfOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).IsMemberOfOrganization(ctx, req.(*IsMemberOfOrganizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListOrganizationQuotas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQuotasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizationQuotas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationQuotas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizationQuotas(ctx, req.(*ListQuotasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListProjects(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetProject(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_CreateProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Project)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).CreateProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).CreateProject(ctx, req.(*Project))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_UpdateProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Project)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).UpdateProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/UpdateProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).UpdateProject(ctx, req.(*Project))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteProject(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListProjectQuotas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQuotasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListProjectQuotas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListProjectQuotas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListProjectQuotas(ctx, req.(*ListQuotasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListEvents(ctx, req.(*ListEventOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListOrganizationInvites_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListOrganizationInvites(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListOrganizationInvites",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListOrganizationInvites(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListMyOrganizationInvites_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListMyOrganizationInvites(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListMyOrganizationInvites",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListMyOrganizationInvites(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetOrganizationInvite(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_CreateOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OrganizationInvite)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).CreateOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/CreateOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).CreateOrganizationInvite(ctx, req.(*OrganizationInvite))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_DeleteOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/DeleteOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).DeleteOrganizationInvite(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_AcceptOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).AcceptOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/AcceptOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).AcceptOrganizationInvite(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_RejectOrganizationInvite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).RejectOrganizationInvite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/RejectOrganizationInvite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).RejectOrganizationInvite(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_ListQuotaDescriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).ListQuotaDescriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/ListQuotaDescriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).ListQuotaDescriptions(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetTermsAndConditions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetTermsAndConditions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetTermsAndConditions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetTermsAndConditions(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetCurrentTermsAndConditions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetCurrentTermsAndConditions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetCurrentTermsAndConditions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetCurrentTermsAndConditions(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetDataProcessingAddendum_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetDataProcessingAddendum(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetDataProcessingAddendum",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetDataProcessingAddendum(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceManagerService_GetCurrentDataProcessingAddendum_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceManagerServiceServer).GetCurrentDataProcessingAddendum(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.resourcemanager.v1.ResourceManagerService/GetCurrentDataProcessingAddendum",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceManagerServiceServer).GetCurrentDataProcessingAddendum(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResourceManagerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.resourcemanager.v1.ResourceManagerService",
	HandlerType: (*ResourceManagerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _ResourceManagerService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListOrganizations",
			Handler:    _ResourceManagerService_ListOrganizations_Handler,
		},
		{
			MethodName: "GetOrganization",
			Handler:    _ResourceManagerService_GetOrganization_Handler,
		},
		{
			MethodName: "CreateOrganization",
			Handler:    _ResourceManagerService_CreateOrganization_Handler,
		},
		{
			MethodName: "UpdateOrganization",
			Handler:    _ResourceManagerService_UpdateOrganization_Handler,
		},
		{
			MethodName: "DeleteOrganization",
			Handler:    _ResourceManagerService_DeleteOrganization_Handler,
		},
		{
			MethodName: "ListOrganizationMembers",
			Handler:    _ResourceManagerService_ListOrganizationMembers_Handler,
		},
		{
			MethodName: "AddOrganizationMembers",
			Handler:    _ResourceManagerService_AddOrganizationMembers_Handler,
		},
		{
			MethodName: "UpdateOrganizationMembers",
			Handler:    _ResourceManagerService_UpdateOrganizationMembers_Handler,
		},
		{
			MethodName: "DeleteOrganizationMembers",
			Handler:    _ResourceManagerService_DeleteOrganizationMembers_Handler,
		},
		{
			MethodName: "IsMemberOfOrganization",
			Handler:    _ResourceManagerService_IsMemberOfOrganization_Handler,
		},
		{
			MethodName: "ListOrganizationQuotas",
			Handler:    _ResourceManagerService_ListOrganizationQuotas_Handler,
		},
		{
			MethodName: "ListProjects",
			Handler:    _ResourceManagerService_ListProjects_Handler,
		},
		{
			MethodName: "GetProject",
			Handler:    _ResourceManagerService_GetProject_Handler,
		},
		{
			MethodName: "CreateProject",
			Handler:    _ResourceManagerService_CreateProject_Handler,
		},
		{
			MethodName: "UpdateProject",
			Handler:    _ResourceManagerService_UpdateProject_Handler,
		},
		{
			MethodName: "DeleteProject",
			Handler:    _ResourceManagerService_DeleteProject_Handler,
		},
		{
			MethodName: "ListProjectQuotas",
			Handler:    _ResourceManagerService_ListProjectQuotas_Handler,
		},
		{
			MethodName: "ListEvents",
			Handler:    _ResourceManagerService_ListEvents_Handler,
		},
		{
			MethodName: "ListOrganizationInvites",
			Handler:    _ResourceManagerService_ListOrganizationInvites_Handler,
		},
		{
			MethodName: "ListMyOrganizationInvites",
			Handler:    _ResourceManagerService_ListMyOrganizationInvites_Handler,
		},
		{
			MethodName: "GetOrganizationInvite",
			Handler:    _ResourceManagerService_GetOrganizationInvite_Handler,
		},
		{
			MethodName: "CreateOrganizationInvite",
			Handler:    _ResourceManagerService_CreateOrganizationInvite_Handler,
		},
		{
			MethodName: "DeleteOrganizationInvite",
			Handler:    _ResourceManagerService_DeleteOrganizationInvite_Handler,
		},
		{
			MethodName: "AcceptOrganizationInvite",
			Handler:    _ResourceManagerService_AcceptOrganizationInvite_Handler,
		},
		{
			MethodName: "RejectOrganizationInvite",
			Handler:    _ResourceManagerService_RejectOrganizationInvite_Handler,
		},
		{
			MethodName: "ListQuotaDescriptions",
			Handler:    _ResourceManagerService_ListQuotaDescriptions_Handler,
		},
		{
			MethodName: "GetTermsAndConditions",
			Handler:    _ResourceManagerService_GetTermsAndConditions_Handler,
		},
		{
			MethodName: "GetCurrentTermsAndConditions",
			Handler:    _ResourceManagerService_GetCurrentTermsAndConditions_Handler,
		},
		{
			MethodName: "GetDataProcessingAddendum",
			Handler:    _ResourceManagerService_GetDataProcessingAddendum_Handler,
		},
		{
			MethodName: "GetCurrentDataProcessingAddendum",
			Handler:    _ResourceManagerService_GetCurrentDataProcessingAddendum_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "resourcemanager.proto",
}

func (m *Organization) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Organization) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Organization) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsAllowedToUseCustomImages {
		i--
		if m.IsAllowedToUseCustomImages {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if m.IsFlexibleDeploymentsEnabled {
		i--
		if m.IsFlexibleDeploymentsEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if len(m.TotalDeployments) > 0 {
		for k := range m.TotalDeployments {
			v := m.TotalDeployments[k]
			baseI := i
			i = encodeVarintResourcemanager(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintResourcemanager(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.Tier != nil {
		{
			size, err := m.Tier.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OrganizationList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OrganizationList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Budget != nil {
		{
			size, err := m.Budget.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintResourcemanager(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Tier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tier) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Tier) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RequiresTermsAndConditions {
		i--
		if m.RequiresTermsAndConditions {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.HasBackupUploads {
		i--
		if m.HasBackupUploads {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.HasSupportPlans {
		i--
		if m.HasSupportPlans {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Member) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Member) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Member) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Owner {
		i--
		if m.Owner {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.UserId) > 0 {
		i -= len(m.UserId)
		copy(dAtA[i:], m.UserId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.UserId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MemberList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemberList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MemberList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintResourcemanager(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IsMemberOfOrganizationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsMemberOfOrganizationRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IsMemberOfOrganizationRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.UserId) > 0 {
		i -= len(m.UserId)
		copy(dAtA[i:], m.UserId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.UserId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IsMemberOfOrganizationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsMemberOfOrganizationResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IsMemberOfOrganizationResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Owner {
		i--
		if m.Owner {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Member {
		i--
		if m.Member {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OrganizationMembersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationMembersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OrganizationMembersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Members != nil {
		{
			size, err := m.Members.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Project) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Project) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Project) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsFlexibleDeploymentsEnabled {
		i--
		if m.IsFlexibleDeploymentsEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProjectList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProjectList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProjectList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Budget != nil {
		{
			size, err := m.Budget.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintResourcemanager(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Volatile {
		i--
		if m.Volatile {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if len(m.SubjectUrl) > 0 {
		i -= len(m.SubjectUrl)
		copy(dAtA[i:], m.SubjectUrl)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.SubjectUrl)))
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Payload) > 0 {
		for k := range m.Payload {
			v := m.Payload[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintResourcemanager(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.SubjectId) > 0 {
		i -= len(m.SubjectId)
		copy(dAtA[i:], m.SubjectId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.SubjectId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EventList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintResourcemanager(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListEventOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListEventOptions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListEventOptions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CreatedBefore != nil {
		{
			size, err := m.CreatedBefore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.CreatedAfter != nil {
		{
			size, err := m.CreatedAfter.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Types) > 0 {
		for iNdEx := len(m.Types) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Types[iNdEx])
			copy(dAtA[i:], m.Types[iNdEx])
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Types[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.SubjectIds) > 0 {
		for iNdEx := len(m.SubjectIds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SubjectIds[iNdEx])
			copy(dAtA[i:], m.SubjectIds[iNdEx])
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.SubjectIds[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OrganizationInvite) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationInvite) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OrganizationInvite) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CreatedByName) > 0 {
		i -= len(m.CreatedByName)
		copy(dAtA[i:], m.CreatedByName)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.CreatedByName)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.OrganizationName) > 0 {
		i -= len(m.OrganizationName)
		copy(dAtA[i:], m.OrganizationName)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationName)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.UserId) > 0 {
		i -= len(m.UserId)
		copy(dAtA[i:], m.UserId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.UserId)))
		i--
		dAtA[i] = 0x52
	}
	if m.RejectedAt != nil {
		{
			size, err := m.RejectedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.AcceptedAt != nil {
		{
			size, err := m.AcceptedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Rejected {
		i--
		if m.Rejected {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.Accepted {
		i--
		if m.Accepted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Email) > 0 {
		i -= len(m.Email)
		copy(dAtA[i:], m.Email)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Email)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OrganizationInviteList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OrganizationInviteList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OrganizationInviteList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintResourcemanager(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *QuotaDescription) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaDescription) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuotaDescription) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ForProjects {
		i--
		if m.ForProjects {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.ForOrganizations {
		i--
		if m.ForOrganizations {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QuotaDescriptionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaDescriptionList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuotaDescriptionList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintResourcemanager(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Quota) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Quota) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Quota) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Limit != 0 {
		i = encodeVarintResourcemanager(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Kind) > 0 {
		i -= len(m.Kind)
		copy(dAtA[i:], m.Kind)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Kind)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QuotaList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QuotaList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintResourcemanager(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListQuotasRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListQuotasRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListQuotasRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Kinds) > 0 {
		for iNdEx := len(m.Kinds) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Kinds[iNdEx])
			copy(dAtA[i:], m.Kinds[iNdEx])
			i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Kinds[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TermsAndConditions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TermsAndConditions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TermsAndConditions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Content) > 0 {
		i -= len(m.Content)
		copy(dAtA[i:], m.Content)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Content)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DataProcessingAddendum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataProcessingAddendum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataProcessingAddendum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintResourcemanager(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Content) > 0 {
		i -= len(m.Content)
		copy(dAtA[i:], m.Content)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Content)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintResourcemanager(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintResourcemanager(dAtA []byte, offset int, v uint64) int {
	offset -= sovResourcemanager(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Organization) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Tier != nil {
		l = m.Tier.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if len(m.TotalDeployments) > 0 {
		for k, v := range m.TotalDeployments {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovResourcemanager(uint64(len(k))) + 1 + sovResourcemanager(uint64(v))
			n += mapEntrySize + 1 + sovResourcemanager(uint64(mapEntrySize))
		}
	}
	if m.IsFlexibleDeploymentsEnabled {
		n += 2
	}
	if m.IsAllowedToUseCustomImages {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.Budget != nil {
		l = m.Budget.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Tier) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.HasSupportPlans {
		n += 2
	}
	if m.HasBackupUploads {
		n += 2
	}
	if m.RequiresTermsAndConditions {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Member) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Owner {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MemberList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IsMemberOfOrganizationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IsMemberOfOrganizationResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Member {
		n += 2
	}
	if m.Owner {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationMembersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Members != nil {
		l = m.Members.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Project) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.IsFlexibleDeploymentsEnabled {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProjectList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.Budget != nil {
		l = m.Budget.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.SubjectId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if len(m.Payload) > 0 {
		for k, v := range m.Payload {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovResourcemanager(uint64(len(k))) + 1 + len(v) + sovResourcemanager(uint64(len(v)))
			n += mapEntrySize + 1 + sovResourcemanager(uint64(mapEntrySize))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.SubjectUrl)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Volatile {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListEventOptions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if len(m.SubjectIds) > 0 {
		for _, s := range m.SubjectIds {
			l = len(s)
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if len(m.Types) > 0 {
		for _, s := range m.Types {
			l = len(s)
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.CreatedAfter != nil {
		l = m.CreatedAfter.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.CreatedBefore != nil {
		l = m.CreatedBefore.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationInvite) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Email)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Accepted {
		n += 2
	}
	if m.Rejected {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.AcceptedAt != nil {
		l = m.AcceptedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.RejectedAt != nil {
		l = m.RejectedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.OrganizationName)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.CreatedByName)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OrganizationInviteList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuotaDescription) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.ForOrganizations {
		n += 2
	}
	if m.ForProjects {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuotaDescriptionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Quota) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.Limit != 0 {
		n += 1 + sovResourcemanager(uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *QuotaList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListQuotasRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if len(m.Kinds) > 0 {
		for _, s := range m.Kinds {
			l = len(s)
			n += 1 + l + sovResourcemanager(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TermsAndConditions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Content)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataProcessingAddendum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	l = len(m.Content)
	if l > 0 {
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovResourcemanager(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovResourcemanager(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozResourcemanager(x uint64) (n int) {
	return sovResourcemanager(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Organization) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Organization: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Organization: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tier", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tier == nil {
				m.Tier = &Tier{}
			}
			if err := m.Tier.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalDeployments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TotalDeployments == nil {
				m.TotalDeployments = make(map[string]int32)
			}
			var mapkey string
			var mapvalue int32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowResourcemanager
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowResourcemanager
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthResourcemanager
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowResourcemanager
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipResourcemanager(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.TotalDeployments[mapkey] = mapvalue
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFlexibleDeploymentsEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFlexibleDeploymentsEnabled = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsAllowedToUseCustomImages", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsAllowedToUseCustomImages = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Organization{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Budget", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Budget == nil {
				m.Budget = &v1.Budget{}
			}
			if err := m.Budget.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tier) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tier: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tier: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasSupportPlans", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasSupportPlans = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasBackupUploads", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasBackupUploads = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequiresTermsAndConditions", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RequiresTermsAndConditions = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Member) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Member: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Member: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Owner = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemberList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemberList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemberList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Member{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsMemberOfOrganizationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsMemberOfOrganizationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsMemberOfOrganizationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsMemberOfOrganizationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsMemberOfOrganizationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsMemberOfOrganizationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Member", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Member = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owner", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Owner = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationMembersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationMembersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationMembersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Members", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Members == nil {
				m.Members = &MemberList{}
			}
			if err := m.Members.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Project) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Project: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Project: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFlexibleDeploymentsEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFlexibleDeploymentsEnabled = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProjectList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProjectList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProjectList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Project{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Budget", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Budget == nil {
				m.Budget = &v1.Budget{}
			}
			if err := m.Budget.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Payload == nil {
				m.Payload = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowResourcemanager
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowResourcemanager
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthResourcemanager
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowResourcemanager
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthResourcemanager
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipResourcemanager(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthResourcemanager
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Payload[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volatile", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Volatile = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Event{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListEventOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListEventOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListEventOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectIds = append(m.SubjectIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Types", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Types = append(m.Types, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAfter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAfter == nil {
				m.CreatedAfter = &types.Timestamp{}
			}
			if err := m.CreatedAfter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedBefore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedBefore == nil {
				m.CreatedBefore = &types.Timestamp{}
			}
			if err := m.CreatedBefore.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationInvite) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationInvite: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationInvite: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Email", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Email = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Accepted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Accepted = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rejected", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Rejected = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AcceptedAt == nil {
				m.AcceptedAt = &types.Timestamp{}
			}
			if err := m.AcceptedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RejectedAt == nil {
				m.RejectedAt = &types.Timestamp{}
			}
			if err := m.RejectedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedByName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedByName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OrganizationInviteList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OrganizationInviteList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OrganizationInviteList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &OrganizationInvite{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaDescription) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaDescription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaDescription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForOrganizations", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForOrganizations = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForProjects", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForProjects = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaDescriptionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaDescriptionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaDescriptionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &QuotaDescription{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Quota) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Quota: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Quota: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Quota{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListQuotasRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListQuotasRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListQuotasRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kinds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kinds = append(m.Kinds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TermsAndConditions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TermsAndConditions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TermsAndConditions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Content", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Content = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataProcessingAddendum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataProcessingAddendum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataProcessingAddendum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Content", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Content = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthResourcemanager
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipResourcemanager(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthResourcemanager
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipResourcemanager(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowResourcemanager
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowResourcemanager
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthResourcemanager
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthResourcemanager
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowResourcemanager
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipResourcemanager(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthResourcemanager
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthResourcemanager = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowResourcemanager   = fmt.Errorf("proto: integer overflow")
)
