// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: data.proto

package v1

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A Deployment is represents one deployment of an ArangoDB cluster.
type Deployment struct {
	// System identifier of the deployment.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the deployment
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the deployment
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that owns this deployment.
	// After creation, this value cannot be changed.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of the region in which the deployment is created.
	// After creation, this value cannot be changed.
	RegionId string `protobuf:"bytes,6,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// The creation timestamp of the deployment
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the deployment
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this deployment is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Optional identifier of the support plan selected for this deployment.
	// After creation, this value cannot be changed.
	// If no support plan identifier is set, the default support plan is used.
	SupportPlanId string `protobuf:"bytes,10,opt,name=support_plan_id,json=supportPlanId,proto3" json:"support_plan_id,omitempty"`
	// Identifier of the user who created this deployment.
	// This is a read-only value.
	CreatedById string `protobuf:"bytes,11,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// This field must be set to the identifier of the current Terms&Conditions
	// when creating a deployment.
	// If the tier of the organization does not require a non-empty Terms&Condition
	// identifier, this field may be left empty.
	// This is a read-only value after creation.
	AcceptedTermsAndConditionsId string `protobuf:"bytes,12,opt,name=accepted_terms_and_conditions_id,json=acceptedTermsAndConditionsId,proto3" json:"accepted_terms_and_conditions_id,omitempty"`
	// ArangoDB version to use for this deployment.
	// See Version.version.
	// If you change this value to a higher version,
	// the deployment will be upgraded.
	// If you change this value to a lower patch value,
	// the deployment will be downgraded.
	// Any attempt to change to a lower minor or major version
	// is considered an invalid request.
	// Any attempt to change to a version that is not in the
	// list of available versions is considered an invalid request.
	Version string `protobuf:"bytes,101,opt,name=version,proto3" json:"version,omitempty"`
	// If set, it is highly recommended to update to the ArangoDB release with the
	// version as listed in this field.
	ReplaceVersionBy *ReplaceVersionBy           `protobuf:"bytes,104,opt,name=replace_version_by,json=replaceVersionBy,proto3" json:"replace_version_by,omitempty"`
	Certificates     *Deployment_CertificateSpec `protobuf:"bytes,102,opt,name=certificates,proto3" json:"certificates,omitempty"`
	Servers          *Deployment_ServersSpec     `protobuf:"bytes,103,opt,name=servers,proto3" json:"servers,omitempty"`
	// Optional identifier of IP whitelist to use for this deployment.
	IpwhitelistId string                `protobuf:"bytes,105,opt,name=ipwhitelist_id,json=ipwhitelistId,proto3" json:"ipwhitelist_id,omitempty"`
	Model         *Deployment_ModelSpec `protobuf:"bytes,106,opt,name=model,proto3" json:"model,omitempty"`
	// If provided, dataclusterd will use this custom image tag instead of the configured one for a given version.
	// Further, ImagePullPolicy will be set to Always.
	// This field can only be set by selected organizations.
	CustomImage string `protobuf:"bytes,107,opt,name=custom_image,json=customImage,proto3" json:"custom_image,omitempty"`
	// Optional identifier of IAM provider to use for this deployment.
	IamproviderId string             `protobuf:"bytes,108,opt,name=iamprovider_id,json=iamproviderId,proto3" json:"iamprovider_id,omitempty"`
	Status        *Deployment_Status `protobuf:"bytes,201,opt,name=status,proto3" json:"status,omitempty"`
	// Detailed size of the deployment
	// This is a read-only field.
	Size_      *DeploymentSize        `protobuf:"bytes,202,opt,name=size,proto3" json:"size,omitempty"`
	Expiration *Deployment_Expiration `protobuf:"bytes,301,opt,name=expiration,proto3" json:"expiration,omitempty"`
	// Information about a backup restore.
	// If this field is set the deployment will be restored to that backup.
	// This is a read-only field. To set this field please use the backup service RestoreBackup method.
	BackupRestore *Deployment_BackupRestoreSpec `protobuf:"bytes,401,opt,name=backup_restore,json=backupRestore,proto3" json:"backup_restore,omitempty"`
	// Recommendations made for deployments using the "oneshard" or "sharded" model.
	DeploymentRecommendations []*DeploymentSizeRecommendation `protobuf:"bytes,501,rep,name=deployment_recommendations,json=deploymentRecommendations,proto3" json:"deployment_recommendations,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                        `json:"-"`
	XXX_unrecognized          []byte                          `json:"-"`
	XXX_sizecache             int32                           `json:"-"`
}

func (m *Deployment) Reset()         { *m = Deployment{} }
func (m *Deployment) String() string { return proto.CompactTextString(m) }
func (*Deployment) ProtoMessage()    {}
func (*Deployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0}
}
func (m *Deployment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment.Merge(m, src)
}
func (m *Deployment) XXX_Size() int {
	return m.Size()
}
func (m *Deployment) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment proto.InternalMessageInfo

func (m *Deployment) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Deployment) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Deployment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Deployment) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Deployment) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Deployment) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *Deployment) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Deployment) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Deployment) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Deployment) GetSupportPlanId() string {
	if m != nil {
		return m.SupportPlanId
	}
	return ""
}

func (m *Deployment) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *Deployment) GetAcceptedTermsAndConditionsId() string {
	if m != nil {
		return m.AcceptedTermsAndConditionsId
	}
	return ""
}

func (m *Deployment) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Deployment) GetReplaceVersionBy() *ReplaceVersionBy {
	if m != nil {
		return m.ReplaceVersionBy
	}
	return nil
}

func (m *Deployment) GetCertificates() *Deployment_CertificateSpec {
	if m != nil {
		return m.Certificates
	}
	return nil
}

func (m *Deployment) GetServers() *Deployment_ServersSpec {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *Deployment) GetIpwhitelistId() string {
	if m != nil {
		return m.IpwhitelistId
	}
	return ""
}

func (m *Deployment) GetModel() *Deployment_ModelSpec {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *Deployment) GetCustomImage() string {
	if m != nil {
		return m.CustomImage
	}
	return ""
}

func (m *Deployment) GetIamproviderId() string {
	if m != nil {
		return m.IamproviderId
	}
	return ""
}

func (m *Deployment) GetStatus() *Deployment_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Deployment) GetSize_() *DeploymentSize {
	if m != nil {
		return m.Size_
	}
	return nil
}

func (m *Deployment) GetExpiration() *Deployment_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (m *Deployment) GetBackupRestore() *Deployment_BackupRestoreSpec {
	if m != nil {
		return m.BackupRestore
	}
	return nil
}

func (m *Deployment) GetDeploymentRecommendations() []*DeploymentSizeRecommendation {
	if m != nil {
		return m.DeploymentRecommendations
	}
	return nil
}

type Deployment_CertificateSpec struct {
	// Identifier of the CACertificate used to sign TLS certificates for the deployment.
	// If you change this value after the creation of the deployment a complete
	// rotation of the deployment is required, which will result in some downtime.
	CaCertificateId string `protobuf:"bytes,1,opt,name=ca_certificate_id,json=caCertificateId,proto3" json:"ca_certificate_id,omitempty"`
	// Zero or more DNS names to include in the TLS certificate of the deployment.
	AlternateDnsNames    []string `protobuf:"bytes,2,rep,name=alternate_dns_names,json=alternateDnsNames,proto3" json:"alternate_dns_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_CertificateSpec) Reset()         { *m = Deployment_CertificateSpec{} }
func (m *Deployment_CertificateSpec) String() string { return proto.CompactTextString(m) }
func (*Deployment_CertificateSpec) ProtoMessage()    {}
func (*Deployment_CertificateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 0}
}
func (m *Deployment_CertificateSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_CertificateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_CertificateSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_CertificateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_CertificateSpec.Merge(m, src)
}
func (m *Deployment_CertificateSpec) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_CertificateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_CertificateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_CertificateSpec proto.InternalMessageInfo

func (m *Deployment_CertificateSpec) GetCaCertificateId() string {
	if m != nil {
		return m.CaCertificateId
	}
	return ""
}

func (m *Deployment_CertificateSpec) GetAlternateDnsNames() []string {
	if m != nil {
		return m.AlternateDnsNames
	}
	return nil
}

type Deployment_ServersSpec struct {
	// Number of coordinators of the deployment
	// This field is automatically set unless the flexible model is used.
	Coordinators int32 `protobuf:"varint,1,opt,name=coordinators,proto3" json:"coordinators,omitempty"`
	// Amount of memory (in GB) to allocate for coordinators.
	// This field is automatically set unless the flexible model is used.
	CoordinatorMemorySize int32 `protobuf:"varint,2,opt,name=coordinator_memory_size,json=coordinatorMemorySize,proto3" json:"coordinator_memory_size,omitempty"`
	// Custom command line arguments passed to all coordinators.
	// This field is ignored set unless the flexible model is used.
	CoordinatorArgs []string `protobuf:"bytes,3,rep,name=coordinator_args,json=coordinatorArgs,proto3" json:"coordinator_args,omitempty"`
	// Number of dbservers of the deployment
	// This field is automatically set unless the flexible model is used.
	Dbservers int32 `protobuf:"varint,11,opt,name=dbservers,proto3" json:"dbservers,omitempty"`
	// Amount of memory (in GB) to allocate for dbservers.
	// This field is automatically set unless the flexible model is used.
	DbserverMemorySize int32 `protobuf:"varint,12,opt,name=dbserver_memory_size,json=dbserverMemorySize,proto3" json:"dbserver_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for dbservers.
	// This field is automatically set unless the flexible model is used.
	DbserverDiskSize int32 `protobuf:"varint,13,opt,name=dbserver_disk_size,json=dbserverDiskSize,proto3" json:"dbserver_disk_size,omitempty"`
	// Custom command line arguments passed to all dbservers.
	// This field is ignored set unless the flexible model is used.
	DbserverArgs         []string `protobuf:"bytes,14,rep,name=dbserver_args,json=dbserverArgs,proto3" json:"dbserver_args,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_ServersSpec) Reset()         { *m = Deployment_ServersSpec{} }
func (m *Deployment_ServersSpec) String() string { return proto.CompactTextString(m) }
func (*Deployment_ServersSpec) ProtoMessage()    {}
func (*Deployment_ServersSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 1}
}
func (m *Deployment_ServersSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_ServersSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_ServersSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_ServersSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_ServersSpec.Merge(m, src)
}
func (m *Deployment_ServersSpec) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_ServersSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_ServersSpec.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_ServersSpec proto.InternalMessageInfo

func (m *Deployment_ServersSpec) GetCoordinators() int32 {
	if m != nil {
		return m.Coordinators
	}
	return 0
}

func (m *Deployment_ServersSpec) GetCoordinatorMemorySize() int32 {
	if m != nil {
		return m.CoordinatorMemorySize
	}
	return 0
}

func (m *Deployment_ServersSpec) GetCoordinatorArgs() []string {
	if m != nil {
		return m.CoordinatorArgs
	}
	return nil
}

func (m *Deployment_ServersSpec) GetDbservers() int32 {
	if m != nil {
		return m.Dbservers
	}
	return 0
}

func (m *Deployment_ServersSpec) GetDbserverMemorySize() int32 {
	if m != nil {
		return m.DbserverMemorySize
	}
	return 0
}

func (m *Deployment_ServersSpec) GetDbserverDiskSize() int32 {
	if m != nil {
		return m.DbserverDiskSize
	}
	return 0
}

func (m *Deployment_ServersSpec) GetDbserverArgs() []string {
	if m != nil {
		return m.DbserverArgs
	}
	return nil
}

type Deployment_ModelSpec struct {
	// Type of model being used
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Size of nodes being used
	// This field is ignored set in case the flexible model is used.
	NodeSizeId string `protobuf:"bytes,2,opt,name=node_size_id,json=nodeSizeId,proto3" json:"node_size_id,omitempty"`
	// Number of nodes being used
	// This field is ignored set in case the flexible model is used.
	NodeCount int32 `protobuf:"varint,3,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Amount of disk space per node (in GB)
	// This field is ignored set in case the flexible model is used.
	NodeDiskSize         int32    `protobuf:"varint,4,opt,name=node_disk_size,json=nodeDiskSize,proto3" json:"node_disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_ModelSpec) Reset()         { *m = Deployment_ModelSpec{} }
func (m *Deployment_ModelSpec) String() string { return proto.CompactTextString(m) }
func (*Deployment_ModelSpec) ProtoMessage()    {}
func (*Deployment_ModelSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 2}
}
func (m *Deployment_ModelSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_ModelSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_ModelSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_ModelSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_ModelSpec.Merge(m, src)
}
func (m *Deployment_ModelSpec) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_ModelSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_ModelSpec.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_ModelSpec proto.InternalMessageInfo

func (m *Deployment_ModelSpec) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *Deployment_ModelSpec) GetNodeSizeId() string {
	if m != nil {
		return m.NodeSizeId
	}
	return ""
}

func (m *Deployment_ModelSpec) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *Deployment_ModelSpec) GetNodeDiskSize() int32 {
	if m != nil {
		return m.NodeDiskSize
	}
	return 0
}

// Status of a single server (of the ArangoDB cluster)
type Deployment_ServerStatus struct {
	// ID of the server
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Type of server (agent|coordinator|dbserver)
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Human readable description of the status of the deployment.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The creation timestamp of the server
	CreatedAt *types.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Set once the server is ready
	Ready bool `protobuf:"varint,5,opt,name=ready,proto3" json:"ready,omitempty"`
	// Set once the server has been known to be a member of the cluster
	MemberOfCluster bool `protobuf:"varint,6,opt,name=member_of_cluster,json=memberOfCluster,proto3" json:"member_of_cluster,omitempty"`
	// Set if the server is in a failed state
	// Every server is always in 1 (and only 1) of these state: failed/creating/ok/upgrading.
	Failed bool `protobuf:"varint,7,opt,name=failed,proto3" json:"failed,omitempty"`
	// Set if the server is still being created
	// Every server is always in 1 (and only 1) of these state: failed/creating/ok/upgrading.
	Creating bool `protobuf:"varint,8,opt,name=creating,proto3" json:"creating,omitempty"`
	// Set if the server is in the ok state.
	// Every server is always in 1 (and only 1) of these state: failed/creating/ok/upgrading.
	Ok bool `protobuf:"varint,9,opt,name=ok,proto3" json:"ok,omitempty"`
	// Set if the server is still being upgraded
	// Every server is always in 1 (and only 1) of these state: failed/creating/ok/upgrading.
	Upgrading bool `protobuf:"varint,10,opt,name=upgrading,proto3" json:"upgrading,omitempty"`
	// Latest known ArangoDB version used by this server.
	// Initially this field is empty.
	Version string `protobuf:"bytes,11,opt,name=version,proto3" json:"version,omitempty"`
	// The last started timestamp of the server
	LastStartedAt *types.Timestamp `protobuf:"bytes,12,opt,name=last_started_at,json=lastStartedAt,proto3" json:"last_started_at,omitempty"`
	// Information about the data volume used to store the data
	DataVolumeInfo       *DataVolumeInfo `protobuf:"bytes,20,opt,name=data_volume_info,json=dataVolumeInfo,proto3" json:"data_volume_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Deployment_ServerStatus) Reset()         { *m = Deployment_ServerStatus{} }
func (m *Deployment_ServerStatus) String() string { return proto.CompactTextString(m) }
func (*Deployment_ServerStatus) ProtoMessage()    {}
func (*Deployment_ServerStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 3}
}
func (m *Deployment_ServerStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_ServerStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_ServerStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_ServerStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_ServerStatus.Merge(m, src)
}
func (m *Deployment_ServerStatus) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_ServerStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_ServerStatus.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_ServerStatus proto.InternalMessageInfo

func (m *Deployment_ServerStatus) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Deployment_ServerStatus) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Deployment_ServerStatus) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Deployment_ServerStatus) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Deployment_ServerStatus) GetReady() bool {
	if m != nil {
		return m.Ready
	}
	return false
}

func (m *Deployment_ServerStatus) GetMemberOfCluster() bool {
	if m != nil {
		return m.MemberOfCluster
	}
	return false
}

func (m *Deployment_ServerStatus) GetFailed() bool {
	if m != nil {
		return m.Failed
	}
	return false
}

func (m *Deployment_ServerStatus) GetCreating() bool {
	if m != nil {
		return m.Creating
	}
	return false
}

func (m *Deployment_ServerStatus) GetOk() bool {
	if m != nil {
		return m.Ok
	}
	return false
}

func (m *Deployment_ServerStatus) GetUpgrading() bool {
	if m != nil {
		return m.Upgrading
	}
	return false
}

func (m *Deployment_ServerStatus) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Deployment_ServerStatus) GetLastStartedAt() *types.Timestamp {
	if m != nil {
		return m.LastStartedAt
	}
	return nil
}

func (m *Deployment_ServerStatus) GetDataVolumeInfo() *DataVolumeInfo {
	if m != nil {
		return m.DataVolumeInfo
	}
	return nil
}

// Status of the deployment
// All members of this field are read-only.
type Deployment_Status struct {
	// Endpoint URL used to reach the deployment
	// This value will be empty during the creation of the deployment.
	// This field always contains the URL of the low port (8529) of the
	// deployment.
	// If a certificate with well known certificate is used, this
	// port is using the well known certificate.
	// Otherwise this port is using the self-signed certificate.
	// This endpoint is recommended for human-to-database connections.
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Human readable description of the status of the deployment.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Set once the deployment has been created.
	Created bool `protobuf:"varint,3,opt,name=created,proto3" json:"created,omitempty"`
	// Set if the deployment is ready to be used.
	// If the deployment has downtime (e.g. because of changing a CA certificate)
	// this will go to false until the downtime is over.
	Ready bool `protobuf:"varint,4,opt,name=ready,proto3" json:"ready,omitempty"`
	// Set if the deployment is being upgraded.
	Upgrading bool `protobuf:"varint,5,opt,name=upgrading,proto3" json:"upgrading,omitempty"`
	// Versions of running servers
	ServerVersions []string `protobuf:"bytes,6,rep,name=server_versions,json=serverVersions,proto3" json:"server_versions,omitempty"`
	// Status of individual servers of the deployment
	Servers []*Deployment_ServerStatus `protobuf:"bytes,7,rep,name=servers,proto3" json:"servers,omitempty"`
	// Set if the ready boolean is transitioned to true for the very first time.
	BootstrappedAt *types.Timestamp `protobuf:"bytes,8,opt,name=bootstrapped_at,json=bootstrappedAt,proto3" json:"bootstrapped_at,omitempty"`
	// Set if bootstrapped_at has a value, otherwise false.
	Bootstrapped bool `protobuf:"varint,9,opt,name=bootstrapped,proto3" json:"bootstrapped,omitempty"`
	// Endpoint URL used to reach the deployment on the port that uses
	// the self-signed certificate.
	// This endpoint is recommended for machine-to-database connections.
	EndpointSelfSigned string `protobuf:"bytes,10,opt,name=endpoint_self_signed,json=endpointSelfSigned,proto3" json:"endpoint_self_signed,omitempty"`
	// The status of backup restore (if applicable).
	// This field will be set to empty if a new revision of the spec is available
	BackupRestoreStatus *Deployment_BackupRestoreStatus `protobuf:"bytes,100,opt,name=backup_restore_status,json=backupRestoreStatus,proto3" json:"backup_restore_status,omitempty"`
	// The total size of all backups in the external source (in bytes)
	TotalBackupSizeBytes int64 `protobuf:"varint,101,opt,name=total_backup_size_bytes,json=totalBackupSizeBytes,proto3" json:"total_backup_size_bytes,omitempty"`
	// Set if there is any backup currently uploading data to the external source
	BackupUploadInProgress bool     `protobuf:"varint,102,opt,name=backup_upload_in_progress,json=backupUploadInProgress,proto3" json:"backup_upload_in_progress,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Deployment_Status) Reset()         { *m = Deployment_Status{} }
func (m *Deployment_Status) String() string { return proto.CompactTextString(m) }
func (*Deployment_Status) ProtoMessage()    {}
func (*Deployment_Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 4}
}
func (m *Deployment_Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_Status.Merge(m, src)
}
func (m *Deployment_Status) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_Status) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_Status.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_Status proto.InternalMessageInfo

func (m *Deployment_Status) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Deployment_Status) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Deployment_Status) GetCreated() bool {
	if m != nil {
		return m.Created
	}
	return false
}

func (m *Deployment_Status) GetReady() bool {
	if m != nil {
		return m.Ready
	}
	return false
}

func (m *Deployment_Status) GetUpgrading() bool {
	if m != nil {
		return m.Upgrading
	}
	return false
}

func (m *Deployment_Status) GetServerVersions() []string {
	if m != nil {
		return m.ServerVersions
	}
	return nil
}

func (m *Deployment_Status) GetServers() []*Deployment_ServerStatus {
	if m != nil {
		return m.Servers
	}
	return nil
}

func (m *Deployment_Status) GetBootstrappedAt() *types.Timestamp {
	if m != nil {
		return m.BootstrappedAt
	}
	return nil
}

func (m *Deployment_Status) GetBootstrapped() bool {
	if m != nil {
		return m.Bootstrapped
	}
	return false
}

func (m *Deployment_Status) GetEndpointSelfSigned() string {
	if m != nil {
		return m.EndpointSelfSigned
	}
	return ""
}

func (m *Deployment_Status) GetBackupRestoreStatus() *Deployment_BackupRestoreStatus {
	if m != nil {
		return m.BackupRestoreStatus
	}
	return nil
}

func (m *Deployment_Status) GetTotalBackupSizeBytes() int64 {
	if m != nil {
		return m.TotalBackupSizeBytes
	}
	return 0
}

func (m *Deployment_Status) GetBackupUploadInProgress() bool {
	if m != nil {
		return m.BackupUploadInProgress
	}
	return false
}

// The status of backup restore
// All members of this message are read-only.
type Deployment_BackupRestoreStatus struct {
	// The revision of the used BackupRestoreSpec
	Revision int32 `protobuf:"varint,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// Set if the deployment is preparing or restoring a backup
	Restoring bool `protobuf:"varint,10,opt,name=restoring,proto3" json:"restoring,omitempty"`
	// Status of the restore backup operation.
	// Enum of the following values: "<empty>|Preparing|Restoring|Restored|Failed"
	Status string `protobuf:"bytes,11,opt,name=status,proto3" json:"status,omitempty"`
	// Failure reason of the backup restore (if applicable)
	FailureReason        string   `protobuf:"bytes,12,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_BackupRestoreStatus) Reset()         { *m = Deployment_BackupRestoreStatus{} }
func (m *Deployment_BackupRestoreStatus) String() string { return proto.CompactTextString(m) }
func (*Deployment_BackupRestoreStatus) ProtoMessage()    {}
func (*Deployment_BackupRestoreStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 5}
}
func (m *Deployment_BackupRestoreStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_BackupRestoreStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_BackupRestoreStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_BackupRestoreStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_BackupRestoreStatus.Merge(m, src)
}
func (m *Deployment_BackupRestoreStatus) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_BackupRestoreStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_BackupRestoreStatus.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_BackupRestoreStatus proto.InternalMessageInfo

func (m *Deployment_BackupRestoreStatus) GetRevision() int32 {
	if m != nil {
		return m.Revision
	}
	return 0
}

func (m *Deployment_BackupRestoreStatus) GetRestoring() bool {
	if m != nil {
		return m.Restoring
	}
	return false
}

func (m *Deployment_BackupRestoreStatus) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Deployment_BackupRestoreStatus) GetFailureReason() string {
	if m != nil {
		return m.FailureReason
	}
	return ""
}

// Expiration of the deployment.
// All members of this message are read-only.
type Deployment_Expiration struct {
	// The expiration timestamp of the deployment
	// If not set, the deployment will not expire.
	ExpiresAt *types.Timestamp `protobuf:"bytes,1,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// Human readable reason for why the deployment expires (or does not expire).
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	// The timestamp of when the last "this deployment will expire at" email was
	// send.
	// If not set, no such email has been send.
	LastWarningEmailSendAt *types.Timestamp `protobuf:"bytes,3,opt,name=last_warning_email_send_at,json=lastWarningEmailSendAt,proto3" json:"last_warning_email_send_at,omitempty"`
	// List of email addresses to which the last warning email has been send.
	// Not set when no such email has been send.
	LastWarningEmailSendTo []string `protobuf:"bytes,4,rep,name=last_warning_email_send_to,json=lastWarningEmailSendTo,proto3" json:"last_warning_email_send_to,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *Deployment_Expiration) Reset()         { *m = Deployment_Expiration{} }
func (m *Deployment_Expiration) String() string { return proto.CompactTextString(m) }
func (*Deployment_Expiration) ProtoMessage()    {}
func (*Deployment_Expiration) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 6}
}
func (m *Deployment_Expiration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_Expiration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_Expiration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_Expiration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_Expiration.Merge(m, src)
}
func (m *Deployment_Expiration) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_Expiration) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_Expiration.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_Expiration proto.InternalMessageInfo

func (m *Deployment_Expiration) GetExpiresAt() *types.Timestamp {
	if m != nil {
		return m.ExpiresAt
	}
	return nil
}

func (m *Deployment_Expiration) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *Deployment_Expiration) GetLastWarningEmailSendAt() *types.Timestamp {
	if m != nil {
		return m.LastWarningEmailSendAt
	}
	return nil
}

func (m *Deployment_Expiration) GetLastWarningEmailSendTo() []string {
	if m != nil {
		return m.LastWarningEmailSendTo
	}
	return nil
}

// Information about a backup restore.
// All members of this message are read-only.
type Deployment_BackupRestoreSpec struct {
	// The revision of this BackupRestoreSpec
	Revision int32 `protobuf:"varint,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// The timestamp of when the last revision has been updated.
	LastUpdatedAt *types.Timestamp `protobuf:"bytes,2,opt,name=last_updated_at,json=lastUpdatedAt,proto3" json:"last_updated_at,omitempty"`
	// Identifier of a backup to restore to.
	BackupId             string   `protobuf:"bytes,10,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deployment_BackupRestoreSpec) Reset()         { *m = Deployment_BackupRestoreSpec{} }
func (m *Deployment_BackupRestoreSpec) String() string { return proto.CompactTextString(m) }
func (*Deployment_BackupRestoreSpec) ProtoMessage()    {}
func (*Deployment_BackupRestoreSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{0, 7}
}
func (m *Deployment_BackupRestoreSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deployment_BackupRestoreSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deployment_BackupRestoreSpec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deployment_BackupRestoreSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deployment_BackupRestoreSpec.Merge(m, src)
}
func (m *Deployment_BackupRestoreSpec) XXX_Size() int {
	return m.Size()
}
func (m *Deployment_BackupRestoreSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_Deployment_BackupRestoreSpec.DiscardUnknown(m)
}

var xxx_messageInfo_Deployment_BackupRestoreSpec proto.InternalMessageInfo

func (m *Deployment_BackupRestoreSpec) GetRevision() int32 {
	if m != nil {
		return m.Revision
	}
	return 0
}

func (m *Deployment_BackupRestoreSpec) GetLastUpdatedAt() *types.Timestamp {
	if m != nil {
		return m.LastUpdatedAt
	}
	return nil
}

func (m *Deployment_BackupRestoreSpec) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

// NodeSize specifies the size constraints of different data nodes.
type NodeSize struct {
	// System identifier of the node size
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human readable name of the node size
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Amount of memory (in GB) that is available on this size of node.
	MemorySize int32 `protobuf:"varint,3,opt,name=memory_size,json=memorySize,proto3" json:"memory_size,omitempty"`
	// Minimum amount of disk (in GB) that is available on this size of node.
	MinDiskSize int32 `protobuf:"varint,4,opt,name=min_disk_size,json=minDiskSize,proto3" json:"min_disk_size,omitempty"`
	// Maximum amount of disk (in GB) that is available on this size of node.
	MaxDiskSize int32 `protobuf:"varint,5,opt,name=max_disk_size,json=maxDiskSize,proto3" json:"max_disk_size,omitempty"`
	// CPU size that is available on this size of node (e.g. standard or high).
	CpuSize string `protobuf:"bytes,6,opt,name=cpu_size,json=cpuSize,proto3" json:"cpu_size,omitempty"`
	// If set, contains list of possible disk sizes (in GB) for the node.
	// In that case, this field overrides the min_disk_size & max_disk_size fields.
	DiskSizes            []int32  `protobuf:"varint,7,rep,packed,name=disk_sizes,json=diskSizes,proto3" json:"disk_sizes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeSize) Reset()         { *m = NodeSize{} }
func (m *NodeSize) String() string { return proto.CompactTextString(m) }
func (*NodeSize) ProtoMessage()    {}
func (*NodeSize) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{1}
}
func (m *NodeSize) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSize.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSize.Merge(m, src)
}
func (m *NodeSize) XXX_Size() int {
	return m.Size()
}
func (m *NodeSize) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSize.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSize proto.InternalMessageInfo

func (m *NodeSize) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *NodeSize) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NodeSize) GetMemorySize() int32 {
	if m != nil {
		return m.MemorySize
	}
	return 0
}

func (m *NodeSize) GetMinDiskSize() int32 {
	if m != nil {
		return m.MinDiskSize
	}
	return 0
}

func (m *NodeSize) GetMaxDiskSize() int32 {
	if m != nil {
		return m.MaxDiskSize
	}
	return 0
}

func (m *NodeSize) GetCpuSize() string {
	if m != nil {
		return m.CpuSize
	}
	return ""
}

func (m *NodeSize) GetDiskSizes() []int32 {
	if m != nil {
		return m.DiskSizes
	}
	return nil
}

// List of node sizes.
type NodeSizeList struct {
	Items                []*NodeSize `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *NodeSizeList) Reset()         { *m = NodeSizeList{} }
func (m *NodeSizeList) String() string { return proto.CompactTextString(m) }
func (*NodeSizeList) ProtoMessage()    {}
func (*NodeSizeList) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{2}
}
func (m *NodeSizeList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSizeList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSizeList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSizeList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSizeList.Merge(m, src)
}
func (m *NodeSizeList) XXX_Size() int {
	return m.Size()
}
func (m *NodeSizeList) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSizeList.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSizeList proto.InternalMessageInfo

func (m *NodeSizeList) GetItems() []*NodeSize {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListNodeSizes
type NodeSizesRequest struct {
	// Identifier of project that will own a deployment.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of a region in which a deployment will be created.
	RegionId string `protobuf:"bytes,2,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// If set, project_id & region_id will be taken from this deployment.
	// This also causes the node_size used by this deployment to be included
	// in the result, if it it would not match for new deployments.
	DeploymentId         string   `protobuf:"bytes,3,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NodeSizesRequest) Reset()         { *m = NodeSizesRequest{} }
func (m *NodeSizesRequest) String() string { return proto.CompactTextString(m) }
func (*NodeSizesRequest) ProtoMessage()    {}
func (*NodeSizesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{3}
}
func (m *NodeSizesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeSizesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeSizesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeSizesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeSizesRequest.Merge(m, src)
}
func (m *NodeSizesRequest) XXX_Size() int {
	return m.Size()
}
func (m *NodeSizesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeSizesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NodeSizesRequest proto.InternalMessageInfo

func (m *NodeSizesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *NodeSizesRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *NodeSizesRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

// DeploymentModel specifies the a specific model of deploying
// arangodb clusters.
type DeploymentModel struct {
	// System identifier of the model (e.g. oneshard)
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human readable name of the model (e.g. One shard)
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentModel) Reset()         { *m = DeploymentModel{} }
func (m *DeploymentModel) String() string { return proto.CompactTextString(m) }
func (*DeploymentModel) ProtoMessage()    {}
func (*DeploymentModel) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{4}
}
func (m *DeploymentModel) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentModel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentModel.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentModel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentModel.Merge(m, src)
}
func (m *DeploymentModel) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentModel) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentModel.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentModel proto.InternalMessageInfo

func (m *DeploymentModel) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeploymentModel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List of deployment models.
type DeploymentModelList struct {
	Items                []*DeploymentModel `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DeploymentModelList) Reset()         { *m = DeploymentModelList{} }
func (m *DeploymentModelList) String() string { return proto.CompactTextString(m) }
func (*DeploymentModelList) ProtoMessage()    {}
func (*DeploymentModelList) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{5}
}
func (m *DeploymentModelList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentModelList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentModelList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentModelList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentModelList.Merge(m, src)
}
func (m *DeploymentModelList) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentModelList) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentModelList.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentModelList proto.InternalMessageInfo

func (m *DeploymentModelList) GetItems() []*DeploymentModel {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListDeploymentModels
type ListDeploymentModelsRequest struct {
	// Identifier of project that will own a deployment.
	ProjectId            string   `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeploymentModelsRequest) Reset()         { *m = ListDeploymentModelsRequest{} }
func (m *ListDeploymentModelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeploymentModelsRequest) ProtoMessage()    {}
func (*ListDeploymentModelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{6}
}
func (m *ListDeploymentModelsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListDeploymentModelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListDeploymentModelsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListDeploymentModelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeploymentModelsRequest.Merge(m, src)
}
func (m *ListDeploymentModelsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListDeploymentModelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeploymentModelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeploymentModelsRequest proto.InternalMessageInfo

func (m *ListDeploymentModelsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// CPUSize specifies the a specific level of CPU for a node.
type CPUSize struct {
	// System identifier of the size (e.g. standard)
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human readable name of the size (e.g. Standard)
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CPUSize) Reset()         { *m = CPUSize{} }
func (m *CPUSize) String() string { return proto.CompactTextString(m) }
func (*CPUSize) ProtoMessage()    {}
func (*CPUSize) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{7}
}
func (m *CPUSize) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CPUSize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CPUSize.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CPUSize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CPUSize.Merge(m, src)
}
func (m *CPUSize) XXX_Size() int {
	return m.Size()
}
func (m *CPUSize) XXX_DiscardUnknown() {
	xxx_messageInfo_CPUSize.DiscardUnknown(m)
}

var xxx_messageInfo_CPUSize proto.InternalMessageInfo

func (m *CPUSize) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CPUSize) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List of CPU sizes.
type CPUSizeList struct {
	Items                []*CPUSize `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CPUSizeList) Reset()         { *m = CPUSizeList{} }
func (m *CPUSizeList) String() string { return proto.CompactTextString(m) }
func (*CPUSizeList) ProtoMessage()    {}
func (*CPUSizeList) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{8}
}
func (m *CPUSizeList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CPUSizeList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CPUSizeList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CPUSizeList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CPUSizeList.Merge(m, src)
}
func (m *CPUSizeList) XXX_Size() int {
	return m.Size()
}
func (m *CPUSizeList) XXX_DiscardUnknown() {
	xxx_messageInfo_CPUSizeList.DiscardUnknown(m)
}

var xxx_messageInfo_CPUSizeList proto.InternalMessageInfo

func (m *CPUSizeList) GetItems() []*CPUSize {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListCPUSizes
type ListCPUSizesRequest struct {
	// Identifier of project that will own a deployment.
	ProjectId            string   `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCPUSizesRequest) Reset()         { *m = ListCPUSizesRequest{} }
func (m *ListCPUSizesRequest) String() string { return proto.CompactTextString(m) }
func (*ListCPUSizesRequest) ProtoMessage()    {}
func (*ListCPUSizesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{9}
}
func (m *ListCPUSizesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListCPUSizesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListCPUSizesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListCPUSizesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCPUSizesRequest.Merge(m, src)
}
func (m *ListCPUSizesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListCPUSizesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCPUSizesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCPUSizesRequest proto.InternalMessageInfo

func (m *ListCPUSizesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Request arguments for GetDeploymentCredentials
type DeploymentCredentialsRequest struct {
	// Identifier of deployment to request credentials for.
	DeploymentId string `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Reason for requesting the credentials
	Reason               string   `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentCredentialsRequest) Reset()         { *m = DeploymentCredentialsRequest{} }
func (m *DeploymentCredentialsRequest) String() string { return proto.CompactTextString(m) }
func (*DeploymentCredentialsRequest) ProtoMessage()    {}
func (*DeploymentCredentialsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{10}
}
func (m *DeploymentCredentialsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentCredentialsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentCredentialsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentCredentialsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentCredentialsRequest.Merge(m, src)
}
func (m *DeploymentCredentialsRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentCredentialsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentCredentialsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentCredentialsRequest proto.InternalMessageInfo

func (m *DeploymentCredentialsRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *DeploymentCredentialsRequest) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

// Result for GetDeploymentCredentials
type DeploymentCredentials struct {
	// Name of the user for which credentials were asked.
	// Default to username of root user.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Password of the user for which credentials were asked.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentCredentials) Reset()         { *m = DeploymentCredentials{} }
func (m *DeploymentCredentials) String() string { return proto.CompactTextString(m) }
func (*DeploymentCredentials) ProtoMessage()    {}
func (*DeploymentCredentials) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{11}
}
func (m *DeploymentCredentials) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentCredentials) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentCredentials.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentCredentials) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentCredentials.Merge(m, src)
}
func (m *DeploymentCredentials) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentCredentials) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentCredentials.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentCredentials proto.InternalMessageInfo

func (m *DeploymentCredentials) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *DeploymentCredentials) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// List of Deployments.
type DeploymentList struct {
	// Actual deployments
	Items []*Deployment `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// Budget for deployments
	Budget               *v1.Budget `protobuf:"bytes,2,opt,name=budget,proto3" json:"budget,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *DeploymentList) Reset()         { *m = DeploymentList{} }
func (m *DeploymentList) String() string { return proto.CompactTextString(m) }
func (*DeploymentList) ProtoMessage()    {}
func (*DeploymentList) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{12}
}
func (m *DeploymentList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentList.Merge(m, src)
}
func (m *DeploymentList) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentList) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentList.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentList proto.InternalMessageInfo

func (m *DeploymentList) GetItems() []*Deployment {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *DeploymentList) GetBudget() *v1.Budget {
	if m != nil {
		return m.Budget
	}
	return nil
}

// Version of an ArangoDB release
type Version struct {
	// Version in the format of major.minor.patch
	// Format details can be found at: https://semver.org/
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// If set, deployments using this version should be updated to the ArangoDB release with the
	// version as listed in this message.
	ReplaceBy            *ReplaceVersionBy `protobuf:"bytes,2,opt,name=replace_by,json=replaceBy,proto3" json:"replace_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Version) Reset()         { *m = Version{} }
func (m *Version) String() string { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()    {}
func (*Version) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{13}
}
func (m *Version) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Version) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Version.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Version) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Version.Merge(m, src)
}
func (m *Version) XXX_Size() int {
	return m.Size()
}
func (m *Version) XXX_DiscardUnknown() {
	xxx_messageInfo_Version.DiscardUnknown(m)
}

var xxx_messageInfo_Version proto.InternalMessageInfo

func (m *Version) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Version) GetReplaceBy() *ReplaceVersionBy {
	if m != nil {
		return m.ReplaceBy
	}
	return nil
}

// ReplaceVersionBy holds replacement instructions.
type ReplaceVersionBy struct {
	// The version of the ArangoDB release that it should be upgraded to.
	// Version in the format of major.minor.patch
	// Format details can be found at: https://semver.org/
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Human readable reason why this version should be replaced.
	Reason               string   `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplaceVersionBy) Reset()         { *m = ReplaceVersionBy{} }
func (m *ReplaceVersionBy) String() string { return proto.CompactTextString(m) }
func (*ReplaceVersionBy) ProtoMessage()    {}
func (*ReplaceVersionBy) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{14}
}
func (m *ReplaceVersionBy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplaceVersionBy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplaceVersionBy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplaceVersionBy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplaceVersionBy.Merge(m, src)
}
func (m *ReplaceVersionBy) XXX_Size() int {
	return m.Size()
}
func (m *ReplaceVersionBy) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplaceVersionBy.DiscardUnknown(m)
}

var xxx_messageInfo_ReplaceVersionBy proto.InternalMessageInfo

func (m *ReplaceVersionBy) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ReplaceVersionBy) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

// List of Versions.
type VersionList struct {
	Items                []*Version `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *VersionList) Reset()         { *m = VersionList{} }
func (m *VersionList) String() string { return proto.CompactTextString(m) }
func (*VersionList) ProtoMessage()    {}
func (*VersionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{15}
}
func (m *VersionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VersionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VersionList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VersionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VersionList.Merge(m, src)
}
func (m *VersionList) XXX_Size() int {
	return m.Size()
}
func (m *VersionList) XXX_DiscardUnknown() {
	xxx_messageInfo_VersionList.DiscardUnknown(m)
}

var xxx_messageInfo_VersionList proto.InternalMessageInfo

func (m *VersionList) GetItems() []*Version {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListVersions.
type ListVersionsRequest struct {
	// Common list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, the result includes all versions for that are available for the
	// organization identified by this ID.
	// If not set, only versions are returned that are available to all organizations.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, only versions will be returned that are safe to upgrade to from this version.
	CurrentVersion       string   `protobuf:"bytes,3,opt,name=current_version,json=currentVersion,proto3" json:"current_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVersionsRequest) Reset()         { *m = ListVersionsRequest{} }
func (m *ListVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListVersionsRequest) ProtoMessage()    {}
func (*ListVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{16}
}
func (m *ListVersionsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListVersionsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVersionsRequest.Merge(m, src)
}
func (m *ListVersionsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListVersionsRequest proto.InternalMessageInfo

func (m *ListVersionsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListVersionsRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListVersionsRequest) GetCurrentVersion() string {
	if m != nil {
		return m.CurrentVersion
	}
	return ""
}

// Request arguments for ListServersSpecLimits
type ServersSpecLimitsRequest struct {
	// Identifier of project that will own a deployment.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of a region in which a deployment will be created.
	RegionId string `protobuf:"bytes,2,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// Optional identifier of a deployment for which compatible server specifications are request.
	DeploymentId         string   `protobuf:"bytes,3,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServersSpecLimitsRequest) Reset()         { *m = ServersSpecLimitsRequest{} }
func (m *ServersSpecLimitsRequest) String() string { return proto.CompactTextString(m) }
func (*ServersSpecLimitsRequest) ProtoMessage()    {}
func (*ServersSpecLimitsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{17}
}
func (m *ServersSpecLimitsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecLimitsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecLimitsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecLimitsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecLimitsRequest.Merge(m, src)
}
func (m *ServersSpecLimitsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecLimitsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecLimitsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecLimitsRequest proto.InternalMessageInfo

func (m *ServersSpecLimitsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ServersSpecLimitsRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *ServersSpecLimitsRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

// Limits of allowed values for fields of Deployment.ServersSpec.
type ServersSpecLimits struct {
	// Limits for the number of coordinators of the deployment
	Coordinators *ServersSpecLimits_Limits `protobuf:"bytes,1,opt,name=coordinators,proto3" json:"coordinators,omitempty"`
	// Possible values for the amount of memory (in GB) to allocate
	// for coordinators.
	CoordinatorMemorySize *ServersSpecLimits_Limits `protobuf:"bytes,2,opt,name=coordinator_memory_size,json=coordinatorMemorySize,proto3" json:"coordinator_memory_size,omitempty"`
	// Limits for the number of dbservers of the deployment
	Dbservers *ServersSpecLimits_Limits `protobuf:"bytes,11,opt,name=dbservers,proto3" json:"dbservers,omitempty"`
	// Possible values for the amount of memory (in GB) to allocate
	// for dbservers.
	DbserverMemorySize *ServersSpecLimits_Limits `protobuf:"bytes,12,opt,name=dbserver_memory_size,json=dbserverMemorySize,proto3" json:"dbserver_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for dbservers.
	DbserverDiskSize *ServersSpecLimits_Limits `protobuf:"bytes,13,opt,name=dbserver_disk_size,json=dbserverDiskSize,proto3" json:"dbserver_disk_size,omitempty"`
	// Possible values for the amount of memory (in GB) to allocate
	// for pairs of coordinator, dbserver.
	NodeMemorySize *ServersSpecLimits_Limits `protobuf:"bytes,21,opt,name=node_memory_size,json=nodeMemorySize,proto3" json:"node_memory_size,omitempty"`
	// Possible values for the number of nodes.
	// Value must be min/max (not using allowed_values)
	NodeCount            *ServersSpecLimits_Limits `protobuf:"bytes,22,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ServersSpecLimits) Reset()         { *m = ServersSpecLimits{} }
func (m *ServersSpecLimits) String() string { return proto.CompactTextString(m) }
func (*ServersSpecLimits) ProtoMessage()    {}
func (*ServersSpecLimits) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{18}
}
func (m *ServersSpecLimits) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecLimits) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecLimits.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecLimits) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecLimits.Merge(m, src)
}
func (m *ServersSpecLimits) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecLimits) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecLimits.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecLimits proto.InternalMessageInfo

func (m *ServersSpecLimits) GetCoordinators() *ServersSpecLimits_Limits {
	if m != nil {
		return m.Coordinators
	}
	return nil
}

func (m *ServersSpecLimits) GetCoordinatorMemorySize() *ServersSpecLimits_Limits {
	if m != nil {
		return m.CoordinatorMemorySize
	}
	return nil
}

func (m *ServersSpecLimits) GetDbservers() *ServersSpecLimits_Limits {
	if m != nil {
		return m.Dbservers
	}
	return nil
}

func (m *ServersSpecLimits) GetDbserverMemorySize() *ServersSpecLimits_Limits {
	if m != nil {
		return m.DbserverMemorySize
	}
	return nil
}

func (m *ServersSpecLimits) GetDbserverDiskSize() *ServersSpecLimits_Limits {
	if m != nil {
		return m.DbserverDiskSize
	}
	return nil
}

func (m *ServersSpecLimits) GetNodeMemorySize() *ServersSpecLimits_Limits {
	if m != nil {
		return m.NodeMemorySize
	}
	return nil
}

func (m *ServersSpecLimits) GetNodeCount() *ServersSpecLimits_Limits {
	if m != nil {
		return m.NodeCount
	}
	return nil
}

type ServersSpecLimits_Limits struct {
	// Minimum value
	Min int32 `protobuf:"varint,1,opt,name=min,proto3" json:"min,omitempty"`
	// Maximum value
	Max int32 `protobuf:"varint,2,opt,name=max,proto3" json:"max,omitempty"`
	// Set of allowed values.
	// If this field is non-empty, only one of these values
	// is allowed.
	AllowedValues        []int32  `protobuf:"varint,3,rep,packed,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServersSpecLimits_Limits) Reset()         { *m = ServersSpecLimits_Limits{} }
func (m *ServersSpecLimits_Limits) String() string { return proto.CompactTextString(m) }
func (*ServersSpecLimits_Limits) ProtoMessage()    {}
func (*ServersSpecLimits_Limits) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{18, 0}
}
func (m *ServersSpecLimits_Limits) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServersSpecLimits_Limits) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServersSpecLimits_Limits.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServersSpecLimits_Limits) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServersSpecLimits_Limits.Merge(m, src)
}
func (m *ServersSpecLimits_Limits) XXX_Size() int {
	return m.Size()
}
func (m *ServersSpecLimits_Limits) XXX_DiscardUnknown() {
	xxx_messageInfo_ServersSpecLimits_Limits.DiscardUnknown(m)
}

var xxx_messageInfo_ServersSpecLimits_Limits proto.InternalMessageInfo

func (m *ServersSpecLimits_Limits) GetMin() int32 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *ServersSpecLimits_Limits) GetMax() int32 {
	if m != nil {
		return m.Max
	}
	return 0
}

func (m *ServersSpecLimits_Limits) GetAllowedValues() []int32 {
	if m != nil {
		return m.AllowedValues
	}
	return nil
}

// Request arguments for CalculateDeploymentSize
type CalculateDeploymentSizeRequest struct {
	// Number of coordinators of the deployment
	// This field is ignored unless model is "flexible".
	Coordinators int32 `protobuf:"varint,1,opt,name=coordinators,proto3" json:"coordinators,omitempty"`
	// Amount of memory (in GB) to allocate for each coordinator.
	// This field is ignored unless model is "flexible".
	CoordinatorMemorySize int32 `protobuf:"varint,2,opt,name=coordinator_memory_size,json=coordinatorMemorySize,proto3" json:"coordinator_memory_size,omitempty"`
	// Number of dbservers of the deployment
	// This field is ignored unless model is "flexible".
	Dbservers int32 `protobuf:"varint,11,opt,name=dbservers,proto3" json:"dbservers,omitempty"`
	// Amount of memory (in GB) to allocate for each dbserver.
	// This field is ignored unless model is "flexible".
	DbserverMemorySize int32 `protobuf:"varint,12,opt,name=dbserver_memory_size,json=dbserverMemorySize,proto3" json:"dbserver_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for each dbserver.
	// This field is ignored unless model is "flexible".
	DbserverDiskSize int32 `protobuf:"varint,13,opt,name=dbserver_disk_size,json=dbserverDiskSize,proto3" json:"dbserver_disk_size,omitempty"`
	// Type of model being used
	Model string `protobuf:"bytes,21,opt,name=model,proto3" json:"model,omitempty"`
	// Size of nodes being used
	NodeSizeId string `protobuf:"bytes,22,opt,name=node_size_id,json=nodeSizeId,proto3" json:"node_size_id,omitempty"`
	// Number of nodes being used
	NodeCount int32 `protobuf:"varint,23,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Amount of disk space per node (in GB)
	NodeDiskSize int32 `protobuf:"varint,34,opt,name=node_disk_size,json=nodeDiskSize,proto3" json:"node_disk_size,omitempty"`
	// ID of region in which the deployment will be created.
	RegionId             string   `protobuf:"bytes,50,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CalculateDeploymentSizeRequest) Reset()         { *m = CalculateDeploymentSizeRequest{} }
func (m *CalculateDeploymentSizeRequest) String() string { return proto.CompactTextString(m) }
func (*CalculateDeploymentSizeRequest) ProtoMessage()    {}
func (*CalculateDeploymentSizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{19}
}
func (m *CalculateDeploymentSizeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CalculateDeploymentSizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CalculateDeploymentSizeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CalculateDeploymentSizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CalculateDeploymentSizeRequest.Merge(m, src)
}
func (m *CalculateDeploymentSizeRequest) XXX_Size() int {
	return m.Size()
}
func (m *CalculateDeploymentSizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CalculateDeploymentSizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CalculateDeploymentSizeRequest proto.InternalMessageInfo

func (m *CalculateDeploymentSizeRequest) GetCoordinators() int32 {
	if m != nil {
		return m.Coordinators
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetCoordinatorMemorySize() int32 {
	if m != nil {
		return m.CoordinatorMemorySize
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetDbservers() int32 {
	if m != nil {
		return m.Dbservers
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetDbserverMemorySize() int32 {
	if m != nil {
		return m.DbserverMemorySize
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetDbserverDiskSize() int32 {
	if m != nil {
		return m.DbserverDiskSize
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *CalculateDeploymentSizeRequest) GetNodeSizeId() string {
	if m != nil {
		return m.NodeSizeId
	}
	return ""
}

func (m *CalculateDeploymentSizeRequest) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetNodeDiskSize() int32 {
	if m != nil {
		return m.NodeDiskSize
	}
	return 0
}

func (m *CalculateDeploymentSizeRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

// Result of CalculateDeploymentSize
type DeploymentSize struct {
	// Number of agents
	Agents int32 `protobuf:"varint,1,opt,name=agents,proto3" json:"agents,omitempty"`
	// Amount of memory (in GB) to allocate for each agent.
	AgentMemorySize int32 `protobuf:"varint,2,opt,name=agent_memory_size,json=agentMemorySize,proto3" json:"agent_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for each agent.
	AgentDiskSize int32 `protobuf:"varint,3,opt,name=agent_disk_size,json=agentDiskSize,proto3" json:"agent_disk_size,omitempty"`
	// Total (combined) amount of memory (in GB) used by all servers (agents, coordinators & dbservers)
	TotalMemorySize int32 `protobuf:"varint,11,opt,name=total_memory_size,json=totalMemorySize,proto3" json:"total_memory_size,omitempty"`
	// Total (combined) amount of disk space (in GB) used by all servers (agents & dbservers)
	TotalDiskSize        int32    `protobuf:"varint,12,opt,name=total_disk_size,json=totalDiskSize,proto3" json:"total_disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentSize) Reset()         { *m = DeploymentSize{} }
func (m *DeploymentSize) String() string { return proto.CompactTextString(m) }
func (*DeploymentSize) ProtoMessage()    {}
func (*DeploymentSize) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{20}
}
func (m *DeploymentSize) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentSize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentSize.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentSize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentSize.Merge(m, src)
}
func (m *DeploymentSize) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentSize) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentSize.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentSize proto.InternalMessageInfo

func (m *DeploymentSize) GetAgents() int32 {
	if m != nil {
		return m.Agents
	}
	return 0
}

func (m *DeploymentSize) GetAgentMemorySize() int32 {
	if m != nil {
		return m.AgentMemorySize
	}
	return 0
}

func (m *DeploymentSize) GetAgentDiskSize() int32 {
	if m != nil {
		return m.AgentDiskSize
	}
	return 0
}

func (m *DeploymentSize) GetTotalMemorySize() int32 {
	if m != nil {
		return m.TotalMemorySize
	}
	return 0
}

func (m *DeploymentSize) GetTotalDiskSize() int32 {
	if m != nil {
		return m.TotalDiskSize
	}
	return 0
}

// Request arguments for RecommendDeploymentSize.
type DeploymentSizeRequest struct {
	// Size of entire dataset (on disk) in GB.
	// Required field.
	// Must be >= 1.
	DatasetSize int32 `protobuf:"varint,1,opt,name=dataset_size,json=datasetSize,proto3" json:"dataset_size,omitempty"`
	// Primary use case for the database
	// Possible values:
	// - GRAPH
	// - DOCUMENT
	// - MULTIMODEL
	// - KEYVALUE
	Usecase string `protobuf:"bytes,2,opt,name=usecase,proto3" json:"usecase,omitempty"`
	// Customer preferred model
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// File format on dataset
	// Possible values:
	// - JSON
	// - CSV
	FileFormat string `protobuf:"bytes,4,opt,name=file_format,json=fileFormat,proto3" json:"file_format,omitempty"`
	// Number of documents in the entire dataset (in case of JSON).
	// Number of rows in the entire dataset (in case of CSV).
	NumberOfDocuments int64 `protobuf:"varint,5,opt,name=number_of_documents,json=numberOfDocuments,proto3" json:"number_of_documents,omitempty"`
	// Largest number of columns of the dataset (in case of CSV).
	NumberOfColumns int32 `protobuf:"varint,6,opt,name=number_of_columns,json=numberOfColumns,proto3" json:"number_of_columns,omitempty"`
	// Percentage of dataset_size that is considered "hot"
	// Must be >= 0.0 and <= 1.0
	WorkingSetPercentage float32 `protobuf:"fixed32,7,opt,name=working_set_percentage,json=workingSetPercentage,proto3" json:"working_set_percentage,omitempty"`
	// Percentage of operations that are READ
	// Must be >= 0.0 and <= 1.0
	AccessReadPercentage float32 `protobuf:"fixed32,8,opt,name=access_read_percentage,json=accessReadPercentage,proto3" json:"access_read_percentage,omitempty"`
	// Percentage of operations that are CREATE
	// Must be >= 0.0 and <= 1.0
	AccessCreatePercentage float32 `protobuf:"fixed32,9,opt,name=access_create_percentage,json=accessCreatePercentage,proto3" json:"access_create_percentage,omitempty"`
	// Percentage of operations that are UPDATE
	// Must be >= 0.0 and <= 1.0
	AccessUpdatePercentage float32 `protobuf:"fixed32,10,opt,name=access_update_percentage,json=accessUpdatePercentage,proto3" json:"access_update_percentage,omitempty"`
	// Increase factor of the dataset_size in 1 year.
	GrowthRate float32 `protobuf:"fixed32,11,opt,name=growth_rate,json=growthRate,proto3" json:"growth_rate,omitempty"`
	// Desired number of replicas.
	// Must be >= 3 and <= 5
	ReplicationFactor int32 `protobuf:"varint,12,opt,name=replication_factor,json=replicationFactor,proto3" json:"replication_factor,omitempty"`
	// Identifier of project to request a recommendation in
	ProjectId string `protobuf:"bytes,21,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of region to request a recommendation in
	RegionId             string   `protobuf:"bytes,22,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentSizeRequest) Reset()         { *m = DeploymentSizeRequest{} }
func (m *DeploymentSizeRequest) String() string { return proto.CompactTextString(m) }
func (*DeploymentSizeRequest) ProtoMessage()    {}
func (*DeploymentSizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{21}
}
func (m *DeploymentSizeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentSizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentSizeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentSizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentSizeRequest.Merge(m, src)
}
func (m *DeploymentSizeRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentSizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentSizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentSizeRequest proto.InternalMessageInfo

func (m *DeploymentSizeRequest) GetDatasetSize() int32 {
	if m != nil {
		return m.DatasetSize
	}
	return 0
}

func (m *DeploymentSizeRequest) GetUsecase() string {
	if m != nil {
		return m.Usecase
	}
	return ""
}

func (m *DeploymentSizeRequest) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *DeploymentSizeRequest) GetFileFormat() string {
	if m != nil {
		return m.FileFormat
	}
	return ""
}

func (m *DeploymentSizeRequest) GetNumberOfDocuments() int64 {
	if m != nil {
		return m.NumberOfDocuments
	}
	return 0
}

func (m *DeploymentSizeRequest) GetNumberOfColumns() int32 {
	if m != nil {
		return m.NumberOfColumns
	}
	return 0
}

func (m *DeploymentSizeRequest) GetWorkingSetPercentage() float32 {
	if m != nil {
		return m.WorkingSetPercentage
	}
	return 0
}

func (m *DeploymentSizeRequest) GetAccessReadPercentage() float32 {
	if m != nil {
		return m.AccessReadPercentage
	}
	return 0
}

func (m *DeploymentSizeRequest) GetAccessCreatePercentage() float32 {
	if m != nil {
		return m.AccessCreatePercentage
	}
	return 0
}

func (m *DeploymentSizeRequest) GetAccessUpdatePercentage() float32 {
	if m != nil {
		return m.AccessUpdatePercentage
	}
	return 0
}

func (m *DeploymentSizeRequest) GetGrowthRate() float32 {
	if m != nil {
		return m.GrowthRate
	}
	return 0
}

func (m *DeploymentSizeRequest) GetReplicationFactor() int32 {
	if m != nil {
		return m.ReplicationFactor
	}
	return 0
}

func (m *DeploymentSizeRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeploymentSizeRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

// Response of RecommendDeploymentSize.
type DeploymentSizeRecommendation struct {
	// Request that resulted in this recommendation.
	Request *DeploymentSizeRequest `protobuf:"bytes,1,opt,name=request,proto3" json:"request,omitempty"`
	// Time when the recommendation was made.
	CreatedAt *types.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Amount of memory space per node (in GB) being recommended
	NodeMemorySize int32 `protobuf:"varint,11,opt,name=node_memory_size,json=nodeMemorySize,proto3" json:"node_memory_size,omitempty"`
	// Amount of disk space per node (in GB) being recommended
	NodeDiskSize int32 `protobuf:"varint,12,opt,name=node_disk_size,json=nodeDiskSize,proto3" json:"node_disk_size,omitempty"`
	// Number of nodes being recommended
	NodeCount int32 `protobuf:"varint,13,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// If set, this recommendation does not fit in
	// the callers quota.
	ExceedsQuota bool `protobuf:"varint,21,opt,name=exceeds_quota,json=exceedsQuota,proto3" json:"exceeds_quota,omitempty"`
	// If set, this recommendation does not fit in
	// the Oasis platform.
	ExceedsPlatform      bool     `protobuf:"varint,22,opt,name=exceeds_platform,json=exceedsPlatform,proto3" json:"exceeds_platform,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentSizeRecommendation) Reset()         { *m = DeploymentSizeRecommendation{} }
func (m *DeploymentSizeRecommendation) String() string { return proto.CompactTextString(m) }
func (*DeploymentSizeRecommendation) ProtoMessage()    {}
func (*DeploymentSizeRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{22}
}
func (m *DeploymentSizeRecommendation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentSizeRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentSizeRecommendation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentSizeRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentSizeRecommendation.Merge(m, src)
}
func (m *DeploymentSizeRecommendation) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentSizeRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentSizeRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentSizeRecommendation proto.InternalMessageInfo

func (m *DeploymentSizeRecommendation) GetRequest() *DeploymentSizeRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *DeploymentSizeRecommendation) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *DeploymentSizeRecommendation) GetNodeMemorySize() int32 {
	if m != nil {
		return m.NodeMemorySize
	}
	return 0
}

func (m *DeploymentSizeRecommendation) GetNodeDiskSize() int32 {
	if m != nil {
		return m.NodeDiskSize
	}
	return 0
}

func (m *DeploymentSizeRecommendation) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *DeploymentSizeRecommendation) GetExceedsQuota() bool {
	if m != nil {
		return m.ExceedsQuota
	}
	return false
}

func (m *DeploymentSizeRecommendation) GetExceedsPlatform() bool {
	if m != nil {
		return m.ExceedsPlatform
	}
	return false
}

// DataVolumeInfo provides information about a data volume
type DataVolumeInfo struct {
	// The total number of bytes of the data volume.
	TotalBytes int64 `protobuf:"varint,1,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	// The number of bytes used on the data volume.
	UsedBytes int64 `protobuf:"varint,2,opt,name=used_bytes,json=usedBytes,proto3" json:"used_bytes,omitempty"`
	// The number of bytes available on the data volume.
	AvailableBytes int64 `protobuf:"varint,3,opt,name=available_bytes,json=availableBytes,proto3" json:"available_bytes,omitempty"`
	// When this info has been measused
	MeasuredAt           *types.Timestamp `protobuf:"bytes,10,opt,name=measured_at,json=measuredAt,proto3" json:"measured_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *DataVolumeInfo) Reset()         { *m = DataVolumeInfo{} }
func (m *DataVolumeInfo) String() string { return proto.CompactTextString(m) }
func (*DataVolumeInfo) ProtoMessage()    {}
func (*DataVolumeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{23}
}
func (m *DataVolumeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataVolumeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataVolumeInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataVolumeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataVolumeInfo.Merge(m, src)
}
func (m *DataVolumeInfo) XXX_Size() int {
	return m.Size()
}
func (m *DataVolumeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DataVolumeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DataVolumeInfo proto.InternalMessageInfo

func (m *DataVolumeInfo) GetTotalBytes() int64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

func (m *DataVolumeInfo) GetUsedBytes() int64 {
	if m != nil {
		return m.UsedBytes
	}
	return 0
}

func (m *DataVolumeInfo) GetAvailableBytes() int64 {
	if m != nil {
		return m.AvailableBytes
	}
	return 0
}

func (m *DataVolumeInfo) GetMeasuredAt() *types.Timestamp {
	if m != nil {
		return m.MeasuredAt
	}
	return nil
}

// Instructions for connecting a driver to a deployment
type ConnectDriverInstructions struct {
	// Per driver instructions for connecting to a deployment
	Drivers              []*ConnectDriverInstructions_DriverInstructions `protobuf:"bytes,1,rep,name=drivers,proto3" json:"drivers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *ConnectDriverInstructions) Reset()         { *m = ConnectDriverInstructions{} }
func (m *ConnectDriverInstructions) String() string { return proto.CompactTextString(m) }
func (*ConnectDriverInstructions) ProtoMessage()    {}
func (*ConnectDriverInstructions) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{24}
}
func (m *ConnectDriverInstructions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectDriverInstructions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectDriverInstructions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectDriverInstructions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectDriverInstructions.Merge(m, src)
}
func (m *ConnectDriverInstructions) XXX_Size() int {
	return m.Size()
}
func (m *ConnectDriverInstructions) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectDriverInstructions.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectDriverInstructions proto.InternalMessageInfo

func (m *ConnectDriverInstructions) GetDrivers() []*ConnectDriverInstructions_DriverInstructions {
	if m != nil {
		return m.Drivers
	}
	return nil
}

// Instructions for a specific driver
type ConnectDriverInstructions_DriverInstructions struct {
	// Human readable name of the driver.
	// E.g. "ArangoDB Go driver"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Lines of code
	Code []string `protobuf:"bytes,2,rep,name=code,proto3" json:"code,omitempty"`
	// Human readable remarks
	Remarks []string `protobuf:"bytes,3,rep,name=remarks,proto3" json:"remarks,omitempty"`
	// URL for getting more information on the driver.
	DriverUrl            string   `protobuf:"bytes,4,opt,name=driver_url,json=driverUrl,proto3" json:"driver_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectDriverInstructions_DriverInstructions) Reset() {
	*m = ConnectDriverInstructions_DriverInstructions{}
}
func (m *ConnectDriverInstructions_DriverInstructions) String() string {
	return proto.CompactTextString(m)
}
func (*ConnectDriverInstructions_DriverInstructions) ProtoMessage() {}
func (*ConnectDriverInstructions_DriverInstructions) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{24, 0}
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConnectDriverInstructions_DriverInstructions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectDriverInstructions_DriverInstructions.Merge(m, src)
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_Size() int {
	return m.Size()
}
func (m *ConnectDriverInstructions_DriverInstructions) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectDriverInstructions_DriverInstructions.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectDriverInstructions_DriverInstructions proto.InternalMessageInfo

func (m *ConnectDriverInstructions_DriverInstructions) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ConnectDriverInstructions_DriverInstructions) GetCode() []string {
	if m != nil {
		return m.Code
	}
	return nil
}

func (m *ConnectDriverInstructions_DriverInstructions) GetRemarks() []string {
	if m != nil {
		return m.Remarks
	}
	return nil
}

func (m *ConnectDriverInstructions_DriverInstructions) GetDriverUrl() string {
	if m != nil {
		return m.DriverUrl
	}
	return ""
}

// Instructions for importing data into a deployment
type ImportDataInstructions struct {
	// Lines of code to run arangorestore
	ImportDump           []string `protobuf:"bytes,2,rep,name=import_dump,json=importDump,proto3" json:"import_dump,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportDataInstructions) Reset()         { *m = ImportDataInstructions{} }
func (m *ImportDataInstructions) String() string { return proto.CompactTextString(m) }
func (*ImportDataInstructions) ProtoMessage()    {}
func (*ImportDataInstructions) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{25}
}
func (m *ImportDataInstructions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImportDataInstructions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImportDataInstructions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImportDataInstructions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataInstructions.Merge(m, src)
}
func (m *ImportDataInstructions) XXX_Size() int {
	return m.Size()
}
func (m *ImportDataInstructions) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataInstructions.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataInstructions proto.InternalMessageInfo

func (m *ImportDataInstructions) GetImportDump() []string {
	if m != nil {
		return m.ImportDump
	}
	return nil
}

// Arguments for requesting a price a deployment of given properties.
type DeploymentPriceRequest struct {
	// Identifier of organization containing the deployment.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Identifier of project containing the deployment.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of the support plan of the deployment.
	SupportPlanId string `protobuf:"bytes,3,opt,name=support_plan_id,json=supportPlanId,proto3" json:"support_plan_id,omitempty"`
	// Identifier of the cloud provider of the deployment.
	CloudProviderId string `protobuf:"bytes,4,opt,name=cloud_provider_id,json=cloudProviderId,proto3" json:"cloud_provider_id,omitempty"`
	// Identifier of the cloud region of the deployment.
	CloudRegionId string `protobuf:"bytes,5,opt,name=cloud_region_id,json=cloudRegionId,proto3" json:"cloud_region_id,omitempty"`
	// Model of the deployment.
	Model string `protobuf:"bytes,6,opt,name=model,proto3" json:"model,omitempty"`
	// Node size use for deployments
	NodeSizeId string `protobuf:"bytes,7,opt,name=node_size_id,json=nodeSizeId,proto3" json:"node_size_id,omitempty"`
	// Number of nodes being used
	// This field is ignored if model is "flexible".
	NodeCount int32 `protobuf:"varint,8,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Amount of disk space per node (in GB)
	// This field is ignored if model is "flexible".
	NodeDiskSize int32 `protobuf:"varint,9,opt,name=node_disk_size,json=nodeDiskSize,proto3" json:"node_disk_size,omitempty"`
	// Number of coordinators of the deployment
	// This field is ignored unless model is "flexible".
	Coordinators int32 `protobuf:"varint,10,opt,name=coordinators,proto3" json:"coordinators,omitempty"`
	// Amount of memory (in GB) to allocate for each coordinator.
	// This field is ignored unless model is "flexible".
	CoordinatorMemorySize int32 `protobuf:"varint,11,opt,name=coordinator_memory_size,json=coordinatorMemorySize,proto3" json:"coordinator_memory_size,omitempty"`
	// Number of dbservers of the deployment
	// This field is ignored unless model is "flexible".
	Dbservers int32 `protobuf:"varint,12,opt,name=dbservers,proto3" json:"dbservers,omitempty"`
	// Amount of memory (in GB) to allocate for each dbserver.
	// This field is ignored unless model is "flexible".
	DbserverMemorySize int32 `protobuf:"varint,13,opt,name=dbserver_memory_size,json=dbserverMemorySize,proto3" json:"dbserver_memory_size,omitempty"`
	// Amount of disk space (in GB) to allocate for each dbserver.
	// This field is ignored unless model is "flexible".
	DbserverDiskSize     int32    `protobuf:"varint,14,opt,name=dbserver_disk_size,json=dbserverDiskSize,proto3" json:"dbserver_disk_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentPriceRequest) Reset()         { *m = DeploymentPriceRequest{} }
func (m *DeploymentPriceRequest) String() string { return proto.CompactTextString(m) }
func (*DeploymentPriceRequest) ProtoMessage()    {}
func (*DeploymentPriceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{26}
}
func (m *DeploymentPriceRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentPriceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentPriceRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentPriceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentPriceRequest.Merge(m, src)
}
func (m *DeploymentPriceRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentPriceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentPriceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentPriceRequest proto.InternalMessageInfo

func (m *DeploymentPriceRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *DeploymentPriceRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeploymentPriceRequest) GetSupportPlanId() string {
	if m != nil {
		return m.SupportPlanId
	}
	return ""
}

func (m *DeploymentPriceRequest) GetCloudProviderId() string {
	if m != nil {
		return m.CloudProviderId
	}
	return ""
}

func (m *DeploymentPriceRequest) GetCloudRegionId() string {
	if m != nil {
		return m.CloudRegionId
	}
	return ""
}

func (m *DeploymentPriceRequest) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *DeploymentPriceRequest) GetNodeSizeId() string {
	if m != nil {
		return m.NodeSizeId
	}
	return ""
}

func (m *DeploymentPriceRequest) GetNodeCount() int32 {
	if m != nil {
		return m.NodeCount
	}
	return 0
}

func (m *DeploymentPriceRequest) GetNodeDiskSize() int32 {
	if m != nil {
		return m.NodeDiskSize
	}
	return 0
}

func (m *DeploymentPriceRequest) GetCoordinators() int32 {
	if m != nil {
		return m.Coordinators
	}
	return 0
}

func (m *DeploymentPriceRequest) GetCoordinatorMemorySize() int32 {
	if m != nil {
		return m.CoordinatorMemorySize
	}
	return 0
}

func (m *DeploymentPriceRequest) GetDbservers() int32 {
	if m != nil {
		return m.Dbservers
	}
	return 0
}

func (m *DeploymentPriceRequest) GetDbserverMemorySize() int32 {
	if m != nil {
		return m.DbserverMemorySize
	}
	return 0
}

func (m *DeploymentPriceRequest) GetDbserverDiskSize() int32 {
	if m != nil {
		return m.DbserverDiskSize
	}
	return 0
}

type DeploymentPrice struct {
	// Price per hour in given currency for the deployment.
	PricePerHour float32 `protobuf:"fixed32,1,opt,name=price_per_hour,json=pricePerHour,proto3" json:"price_per_hour,omitempty"`
	// Network transfer prices (variable depending on usage)
	NetworkTransferPrices []*DeploymentPrice_NetworkTransferPrice `protobuf:"bytes,2,rep,name=network_transfer_prices,json=networkTransferPrices,proto3" json:"network_transfer_prices,omitempty"`
	// Network transfer prices (variable depending on usage)
	BackupPrice *DeploymentPrice_BackupPrice `protobuf:"bytes,3,opt,name=backup_price,json=backupPrice,proto3" json:"backup_price,omitempty"`
	// Identifier of the currency in which the price is specified.
	CurrencyId           string   `protobuf:"bytes,4,opt,name=currency_id,json=currencyId,proto3" json:"currency_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentPrice) Reset()         { *m = DeploymentPrice{} }
func (m *DeploymentPrice) String() string { return proto.CompactTextString(m) }
func (*DeploymentPrice) ProtoMessage()    {}
func (*DeploymentPrice) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{27}
}
func (m *DeploymentPrice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentPrice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentPrice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentPrice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentPrice.Merge(m, src)
}
func (m *DeploymentPrice) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentPrice) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentPrice.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentPrice proto.InternalMessageInfo

func (m *DeploymentPrice) GetPricePerHour() float32 {
	if m != nil {
		return m.PricePerHour
	}
	return 0
}

func (m *DeploymentPrice) GetNetworkTransferPrices() []*DeploymentPrice_NetworkTransferPrice {
	if m != nil {
		return m.NetworkTransferPrices
	}
	return nil
}

func (m *DeploymentPrice) GetBackupPrice() *DeploymentPrice_BackupPrice {
	if m != nil {
		return m.BackupPrice
	}
	return nil
}

func (m *DeploymentPrice) GetCurrencyId() string {
	if m != nil {
		return m.CurrencyId
	}
	return ""
}

type DeploymentPrice_NetworkTransferPrice struct {
	// Price per GB of network transfer into the database
	IngressPricePerGb float32 `protobuf:"fixed32,1,opt,name=ingress_price_per_gb,json=ingressPricePerGb,proto3" json:"ingress_price_per_gb,omitempty"`
	// Price per GB of network transfer out of the database
	EgressPricePerGb float32 `protobuf:"fixed32,2,opt,name=egress_price_per_gb,json=egressPricePerGb,proto3" json:"egress_price_per_gb,omitempty"`
	// Description of this price
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentPrice_NetworkTransferPrice) Reset()         { *m = DeploymentPrice_NetworkTransferPrice{} }
func (m *DeploymentPrice_NetworkTransferPrice) String() string { return proto.CompactTextString(m) }
func (*DeploymentPrice_NetworkTransferPrice) ProtoMessage()    {}
func (*DeploymentPrice_NetworkTransferPrice) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{27, 0}
}
func (m *DeploymentPrice_NetworkTransferPrice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentPrice_NetworkTransferPrice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentPrice_NetworkTransferPrice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentPrice_NetworkTransferPrice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentPrice_NetworkTransferPrice.Merge(m, src)
}
func (m *DeploymentPrice_NetworkTransferPrice) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentPrice_NetworkTransferPrice) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentPrice_NetworkTransferPrice.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentPrice_NetworkTransferPrice proto.InternalMessageInfo

func (m *DeploymentPrice_NetworkTransferPrice) GetIngressPricePerGb() float32 {
	if m != nil {
		return m.IngressPricePerGb
	}
	return 0
}

func (m *DeploymentPrice_NetworkTransferPrice) GetEgressPricePerGb() float32 {
	if m != nil {
		return m.EgressPricePerGb
	}
	return 0
}

func (m *DeploymentPrice_NetworkTransferPrice) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type DeploymentPrice_BackupPrice struct {
	// Price per GB/hour of uploaded backup storage
	PricePerGbPerHour    float32  `protobuf:"fixed32,1,opt,name=price_per_gb_per_hour,json=pricePerGbPerHour,proto3" json:"price_per_gb_per_hour,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentPrice_BackupPrice) Reset()         { *m = DeploymentPrice_BackupPrice{} }
func (m *DeploymentPrice_BackupPrice) String() string { return proto.CompactTextString(m) }
func (*DeploymentPrice_BackupPrice) ProtoMessage()    {}
func (*DeploymentPrice_BackupPrice) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{27, 1}
}
func (m *DeploymentPrice_BackupPrice) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentPrice_BackupPrice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentPrice_BackupPrice.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentPrice_BackupPrice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentPrice_BackupPrice.Merge(m, src)
}
func (m *DeploymentPrice_BackupPrice) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentPrice_BackupPrice) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentPrice_BackupPrice.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentPrice_BackupPrice proto.InternalMessageInfo

func (m *DeploymentPrice_BackupPrice) GetPricePerGbPerHour() float32 {
	if m != nil {
		return m.PricePerGbPerHour
	}
	return 0
}

// Features that are available to new deployments in a given context.
type DeploymentFeatures struct {
	// Is the use of an IAM provider available?
	Iamprovider          bool     `protobuf:"varint,1,opt,name=iamprovider,proto3" json:"iamprovider,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentFeatures) Reset()         { *m = DeploymentFeatures{} }
func (m *DeploymentFeatures) String() string { return proto.CompactTextString(m) }
func (*DeploymentFeatures) ProtoMessage()    {}
func (*DeploymentFeatures) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{28}
}
func (m *DeploymentFeatures) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentFeatures) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentFeatures.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentFeatures) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentFeatures.Merge(m, src)
}
func (m *DeploymentFeatures) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentFeatures) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentFeatures.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentFeatures proto.InternalMessageInfo

func (m *DeploymentFeatures) GetIamprovider() bool {
	if m != nil {
		return m.Iamprovider
	}
	return false
}

// Request arguments for GetDeploymentFeatures
type DeploymentFeaturesRequest struct {
	// Identifier of project that will own a deployment.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Identifier of a region in which a deployment will be created.
	RegionId string `protobuf:"bytes,2,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// Model of the intended deployment.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// Node size use for the intended deployments
	NodeSizeId           string   `protobuf:"bytes,4,opt,name=node_size_id,json=nodeSizeId,proto3" json:"node_size_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeploymentFeaturesRequest) Reset()         { *m = DeploymentFeaturesRequest{} }
func (m *DeploymentFeaturesRequest) String() string { return proto.CompactTextString(m) }
func (*DeploymentFeaturesRequest) ProtoMessage()    {}
func (*DeploymentFeaturesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_871986018790d2fd, []int{29}
}
func (m *DeploymentFeaturesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeploymentFeaturesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeploymentFeaturesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeploymentFeaturesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentFeaturesRequest.Merge(m, src)
}
func (m *DeploymentFeaturesRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeploymentFeaturesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentFeaturesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentFeaturesRequest proto.InternalMessageInfo

func (m *DeploymentFeaturesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeploymentFeaturesRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func (m *DeploymentFeaturesRequest) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *DeploymentFeaturesRequest) GetNodeSizeId() string {
	if m != nil {
		return m.NodeSizeId
	}
	return ""
}

func init() {
	proto.RegisterType((*Deployment)(nil), "arangodb.cloud.data.v1.Deployment")
	proto.RegisterType((*Deployment_CertificateSpec)(nil), "arangodb.cloud.data.v1.Deployment.CertificateSpec")
	proto.RegisterType((*Deployment_ServersSpec)(nil), "arangodb.cloud.data.v1.Deployment.ServersSpec")
	proto.RegisterType((*Deployment_ModelSpec)(nil), "arangodb.cloud.data.v1.Deployment.ModelSpec")
	proto.RegisterType((*Deployment_ServerStatus)(nil), "arangodb.cloud.data.v1.Deployment.ServerStatus")
	proto.RegisterType((*Deployment_Status)(nil), "arangodb.cloud.data.v1.Deployment.Status")
	proto.RegisterType((*Deployment_BackupRestoreStatus)(nil), "arangodb.cloud.data.v1.Deployment.BackupRestoreStatus")
	proto.RegisterType((*Deployment_Expiration)(nil), "arangodb.cloud.data.v1.Deployment.Expiration")
	proto.RegisterType((*Deployment_BackupRestoreSpec)(nil), "arangodb.cloud.data.v1.Deployment.BackupRestoreSpec")
	proto.RegisterType((*NodeSize)(nil), "arangodb.cloud.data.v1.NodeSize")
	proto.RegisterType((*NodeSizeList)(nil), "arangodb.cloud.data.v1.NodeSizeList")
	proto.RegisterType((*NodeSizesRequest)(nil), "arangodb.cloud.data.v1.NodeSizesRequest")
	proto.RegisterType((*DeploymentModel)(nil), "arangodb.cloud.data.v1.DeploymentModel")
	proto.RegisterType((*DeploymentModelList)(nil), "arangodb.cloud.data.v1.DeploymentModelList")
	proto.RegisterType((*ListDeploymentModelsRequest)(nil), "arangodb.cloud.data.v1.ListDeploymentModelsRequest")
	proto.RegisterType((*CPUSize)(nil), "arangodb.cloud.data.v1.CPUSize")
	proto.RegisterType((*CPUSizeList)(nil), "arangodb.cloud.data.v1.CPUSizeList")
	proto.RegisterType((*ListCPUSizesRequest)(nil), "arangodb.cloud.data.v1.ListCPUSizesRequest")
	proto.RegisterType((*DeploymentCredentialsRequest)(nil), "arangodb.cloud.data.v1.DeploymentCredentialsRequest")
	proto.RegisterType((*DeploymentCredentials)(nil), "arangodb.cloud.data.v1.DeploymentCredentials")
	proto.RegisterType((*DeploymentList)(nil), "arangodb.cloud.data.v1.DeploymentList")
	proto.RegisterType((*Version)(nil), "arangodb.cloud.data.v1.Version")
	proto.RegisterType((*ReplaceVersionBy)(nil), "arangodb.cloud.data.v1.ReplaceVersionBy")
	proto.RegisterType((*VersionList)(nil), "arangodb.cloud.data.v1.VersionList")
	proto.RegisterType((*ListVersionsRequest)(nil), "arangodb.cloud.data.v1.ListVersionsRequest")
	proto.RegisterType((*ServersSpecLimitsRequest)(nil), "arangodb.cloud.data.v1.ServersSpecLimitsRequest")
	proto.RegisterType((*ServersSpecLimits)(nil), "arangodb.cloud.data.v1.ServersSpecLimits")
	proto.RegisterType((*ServersSpecLimits_Limits)(nil), "arangodb.cloud.data.v1.ServersSpecLimits.Limits")
	proto.RegisterType((*CalculateDeploymentSizeRequest)(nil), "arangodb.cloud.data.v1.CalculateDeploymentSizeRequest")
	proto.RegisterType((*DeploymentSize)(nil), "arangodb.cloud.data.v1.DeploymentSize")
	proto.RegisterType((*DeploymentSizeRequest)(nil), "arangodb.cloud.data.v1.DeploymentSizeRequest")
	proto.RegisterType((*DeploymentSizeRecommendation)(nil), "arangodb.cloud.data.v1.DeploymentSizeRecommendation")
	proto.RegisterType((*DataVolumeInfo)(nil), "arangodb.cloud.data.v1.DataVolumeInfo")
	proto.RegisterType((*ConnectDriverInstructions)(nil), "arangodb.cloud.data.v1.ConnectDriverInstructions")
	proto.RegisterType((*ConnectDriverInstructions_DriverInstructions)(nil), "arangodb.cloud.data.v1.ConnectDriverInstructions.DriverInstructions")
	proto.RegisterType((*ImportDataInstructions)(nil), "arangodb.cloud.data.v1.ImportDataInstructions")
	proto.RegisterType((*DeploymentPriceRequest)(nil), "arangodb.cloud.data.v1.DeploymentPriceRequest")
	proto.RegisterType((*DeploymentPrice)(nil), "arangodb.cloud.data.v1.DeploymentPrice")
	proto.RegisterType((*DeploymentPrice_NetworkTransferPrice)(nil), "arangodb.cloud.data.v1.DeploymentPrice.NetworkTransferPrice")
	proto.RegisterType((*DeploymentPrice_BackupPrice)(nil), "arangodb.cloud.data.v1.DeploymentPrice.BackupPrice")
	proto.RegisterType((*DeploymentFeatures)(nil), "arangodb.cloud.data.v1.DeploymentFeatures")
	proto.RegisterType((*DeploymentFeaturesRequest)(nil), "arangodb.cloud.data.v1.DeploymentFeaturesRequest")
}

func init() { proto.RegisterFile("data.proto", fileDescriptor_871986018790d2fd) }

var fileDescriptor_871986018790d2fd = []byte{
	// 3702 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x3b, 0x4b, 0x8f, 0x1c, 0x49,
	0x5a, 0x64, 0xf5, 0xab, 0xfa, 0xab, 0xaa, 0x7e, 0x84, 0xbb, 0xdb, 0xe5, 0x1a, 0x3f, 0x7a, 0x72,
	0xd6, 0x76, 0xdb, 0xb3, 0x5d, 0x35, 0x6e, 0xcf, 0x58, 0x1e, 0x7b, 0x97, 0xa1, 0x1f, 0x63, 0x4f,
	0x49, 0xbb, 0x76, 0x93, 0xed, 0x31, 0xd2, 0x82, 0x36, 0x15, 0x95, 0x19, 0x55, 0xce, 0x71, 0xbe,
	0x36, 0x33, 0xb2, 0xed, 0x1e, 0x33, 0x1a, 0xb1, 0xda, 0x03, 0x27, 0x1e, 0x62, 0x91, 0xe6, 0x0e,
	0x07, 0xf6, 0x00, 0x42, 0x42, 0x80, 0x80, 0x3f, 0x00, 0x1c, 0xd0, 0xa2, 0xfd, 0x03, 0x30, 0xcb,
	0x85, 0x13, 0x12, 0x88, 0x3b, 0x8a, 0x2f, 0x22, 0xab, 0x32, 0xeb, 0xd1, 0x95, 0xdd, 0x62, 0xe1,
	0x56, 0xf9, 0xbd, 0xe2, 0xcb, 0x2f, 0xbe, 0xf8, 0x5e, 0x91, 0x05, 0x60, 0x53, 0x4e, 0x9b, 0x61,
	0x14, 0xf0, 0x80, 0x6c, 0xd0, 0x88, 0xfa, 0xbd, 0xc0, 0xee, 0x34, 0x2d, 0x37, 0x48, 0xec, 0x26,
	0xa2, 0x8e, 0xef, 0x34, 0x36, 0xac, 0xc0, 0xf3, 0x02, 0xbf, 0x75, 0x7c, 0xa7, 0x25, 0x7f, 0x49,
	0xfa, 0xc6, 0xc3, 0x9e, 0xc3, 0x5f, 0x24, 0x9d, 0xa6, 0x15, 0x78, 0xad, 0x5e, 0xe0, 0x52, 0xbf,
	0xd7, 0x42, 0x44, 0x27, 0xe9, 0xb6, 0x42, 0x7e, 0x12, 0xb2, 0xb8, 0xc5, 0x1d, 0x8f, 0xc5, 0x9c,
	0x7a, 0xe1, 0xe0, 0x97, 0x62, 0xbe, 0xdc, 0x0b, 0x82, 0x9e, 0xcb, 0x5a, 0x34, 0x74, 0x5a, 0xd4,
	0xf7, 0x03, 0x4e, 0xb9, 0x13, 0xf8, 0xb1, 0xc4, 0xea, 0xff, 0xf1, 0x16, 0xc0, 0x01, 0x0b, 0xdd,
	0xe0, 0xc4, 0x63, 0x3e, 0x27, 0x4b, 0x50, 0x72, 0xec, 0xba, 0xb6, 0xa9, 0x6d, 0x2d, 0x1a, 0x25,
	0xc7, 0x26, 0x2b, 0x30, 0x93, 0x44, 0x6e, 0xbd, 0x84, 0x00, 0xf1, 0x93, 0x10, 0x98, 0xf5, 0xa9,
	0xc7, 0xea, 0x33, 0x08, 0xc2, 0xdf, 0x64, 0x13, 0x2a, 0x36, 0x8b, 0xad, 0xc8, 0x09, 0x85, 0xe8,
	0xfa, 0x2c, 0xa2, 0xb2, 0x20, 0x72, 0x05, 0x20, 0x8c, 0x82, 0xcf, 0x98, 0xc5, 0x4d, 0xc7, 0xae,
	0xcf, 0x21, 0xc1, 0xa2, 0x82, 0xb4, 0x6d, 0xf2, 0x16, 0x2c, 0x46, 0xac, 0xe7, 0x04, 0xbe, 0xc0,
	0xce, 0x23, 0xb6, 0x2c, 0x01, 0x6d, 0x9b, 0x7c, 0x08, 0x60, 0x45, 0x8c, 0x72, 0x66, 0x9b, 0x94,
	0xd7, 0x17, 0x36, 0xb5, 0xad, 0xca, 0x4e, 0xa3, 0x29, 0xdf, 0xaa, 0x99, 0xda, 0xa1, 0xf9, 0x2c,
	0x7d, 0x6d, 0x63, 0x51, 0x51, 0xef, 0x72, 0xc1, 0x6a, 0x33, 0x97, 0x29, 0xd6, 0xf2, 0x74, 0x56,
	0x45, 0xbd, 0xcb, 0x85, 0xc6, 0x4e, 0x6c, 0xaa, 0xe7, 0xfa, 0xe2, 0xa6, 0xb6, 0x55, 0x36, 0x16,
	0x9d, 0xf8, 0x40, 0x02, 0xc8, 0x0d, 0x58, 0x8e, 0x93, 0x30, 0x0c, 0x22, 0x6e, 0x86, 0x2e, 0x45,
	0xbd, 0x01, 0xf5, 0xae, 0x29, 0xf0, 0xa1, 0x4b, 0x85, 0xf2, 0x3a, 0xd4, 0x52, 0xe5, 0x3b, 0x27,
	0x82, 0xaa, 0x22, 0x8d, 0xa3, 0x80, 0x7b, 0x27, 0x6d, 0x9b, 0x3c, 0x82, 0x4d, 0x6a, 0x59, 0x2c,
	0x14, 0x44, 0x9c, 0x45, 0x5e, 0x6c, 0x52, 0xdf, 0x36, 0xad, 0xc0, 0xb7, 0x1d, 0xdc, 0x2a, 0xc1,
	0x56, 0x45, 0xb6, 0xcb, 0x29, 0xdd, 0x33, 0x41, 0xb6, 0xeb, 0xdb, 0xfb, 0x7d, 0xa2, 0xb6, 0x4d,
	0xea, 0xb0, 0x70, 0xcc, 0xa2, 0x58, 0x6c, 0x01, 0x43, 0xf2, 0xf4, 0x91, 0x3c, 0x07, 0x12, 0xb1,
	0xd0, 0xa5, 0x16, 0x33, 0x15, 0xc8, 0xec, 0x9c, 0xd4, 0x5f, 0xa0, 0x3d, 0xb6, 0x9a, 0xe3, 0xbd,
	0xb1, 0x69, 0x48, 0x8e, 0xe7, 0x92, 0x61, 0xef, 0xc4, 0x58, 0x89, 0x86, 0x20, 0xe4, 0x39, 0x54,
	0x2d, 0x16, 0x71, 0xa7, 0xeb, 0x58, 0x94, 0xb3, 0xb8, 0xde, 0x45, 0x89, 0x3b, 0x93, 0x24, 0x0e,
	0x1c, 0xad, 0xb9, 0x3f, 0x60, 0x3b, 0x0a, 0x99, 0x65, 0xe4, 0xe4, 0x90, 0x4f, 0x60, 0x21, 0x66,
	0x91, 0x50, 0xb5, 0xde, 0x43, 0x91, 0xcd, 0x02, 0x22, 0x8f, 0x24, 0x07, 0x8a, 0x4b, 0xd9, 0xc9,
	0x75, 0x58, 0x72, 0xc2, 0x57, 0x2f, 0x1c, 0xce, 0x5c, 0x27, 0x46, 0xe7, 0x73, 0xe4, 0x36, 0x65,
	0xa0, 0x6d, 0x9b, 0xec, 0xc1, 0x9c, 0x17, 0xd8, 0xcc, 0xad, 0x7f, 0x86, 0xcb, 0x7d, 0xb3, 0xc0,
	0x72, 0xdf, 0x15, 0xf4, 0xb8, 0x98, 0x64, 0x25, 0x6f, 0x43, 0xd5, 0x4a, 0x62, 0x1e, 0x78, 0xa6,
	0xe3, 0xd1, 0x1e, 0xab, 0xbf, 0x54, 0x3b, 0x8d, 0xb0, 0xb6, 0x00, 0xa1, 0x36, 0xd4, 0x0b, 0xa3,
	0xe0, 0xd8, 0xb1, 0x59, 0x24, 0xb4, 0x71, 0x95, 0x36, 0x03, 0x28, 0x6a, 0x33, 0x1f, 0x73, 0xca,
	0x93, 0xb8, 0xfe, 0x0f, 0x1a, 0xea, 0x73, 0xab, 0xc8, 0xeb, 0x23, 0x87, 0xa1, 0x38, 0xc9, 0x43,
	0x98, 0x8d, 0x9d, 0xcf, 0x59, 0xfd, 0x1f, 0xa5, 0x84, 0x1b, 0xd3, 0x25, 0x1c, 0x39, 0x9f, 0x33,
	0x03, 0x99, 0xc8, 0x13, 0x00, 0xf6, 0x3a, 0x74, 0x22, 0x0c, 0x15, 0xf5, 0x3f, 0x2d, 0xa1, 0x88,
	0xed, 0x02, 0x4a, 0x7c, 0xdc, 0xe7, 0x32, 0x32, 0x12, 0xc8, 0x6f, 0xc0, 0x52, 0x87, 0x5a, 0x2f,
	0x93, 0xd0, 0x8c, 0x58, 0xcc, 0x83, 0x88, 0xd5, 0x7f, 0x7f, 0x06, 0x65, 0xbe, 0x5f, 0x40, 0xe6,
	0x1e, 0x72, 0x1a, 0x92, 0x11, 0x0d, 0x5e, 0xeb, 0x64, 0x41, 0x84, 0x43, 0xc3, 0xee, 0x93, 0x9b,
	0x11, 0x13, 0xb1, 0x93, 0xf9, 0xb6, 0x8c, 0x73, 0xf5, 0xff, 0x9e, 0xd9, 0x9c, 0x29, 0xb6, 0x12,
	0x1a, 0x20, 0xc7, 0x6d, 0x5c, 0x1a, 0x08, 0xce, 0x63, 0xe2, 0x86, 0x07, 0xcb, 0x43, 0x4e, 0x4c,
	0x6e, 0xc3, 0xaa, 0x45, 0xcd, 0x8c, 0x27, 0x9b, 0xfd, 0x60, 0xba, 0x6c, 0xd1, 0x0c, 0x75, 0xdb,
	0x26, 0x4d, 0xb8, 0x40, 0x5d, 0xce, 0x22, 0x5f, 0x90, 0xd9, 0x7e, 0x6c, 0x8a, 0x48, 0x1a, 0xd7,
	0x4b, 0x9b, 0x33, 0x5b, 0x8b, 0xc6, 0x6a, 0x1f, 0x75, 0xe0, 0xc7, 0x4f, 0x04, 0xa2, 0xf1, 0xd7,
	0x25, 0xa8, 0x64, 0x3c, 0x9c, 0xe8, 0x50, 0xb5, 0x82, 0x20, 0xb2, 0x1d, 0x9f, 0xf2, 0x20, 0x8a,
	0x71, 0x99, 0x39, 0x23, 0x07, 0x23, 0xf7, 0xe0, 0x62, 0xe6, 0xd9, 0xf4, 0x98, 0x17, 0x44, 0x27,
	0x26, 0xba, 0x45, 0x09, 0xc9, 0xd7, 0x33, 0xe8, 0xef, 0x22, 0x56, 0xd8, 0x80, 0xdc, 0x82, 0x95,
	0x2c, 0x1f, 0x8d, 0x7a, 0x71, 0x7d, 0x06, 0x15, 0x5b, 0xce, 0xc0, 0x77, 0xa3, 0x5e, 0x4c, 0x2e,
	0xc3, 0xa2, 0xdd, 0x49, 0xcf, 0x6a, 0x05, 0x85, 0x0e, 0x00, 0xe4, 0x3d, 0x58, 0x4b, 0x1f, 0x72,
	0xab, 0x57, 0x91, 0x90, 0xa4, 0xb8, 0xcc, 0xd2, 0xdf, 0x84, 0x3e, 0xd4, 0xb4, 0x9d, 0xf8, 0xa5,
	0xa4, 0xaf, 0x21, 0xfd, 0x4a, 0x8a, 0x39, 0x70, 0xe2, 0x97, 0x48, 0xfd, 0x0e, 0xd4, 0xfa, 0xd4,
	0xa8, 0xe5, 0x12, 0x6a, 0x59, 0x4d, 0x81, 0x42, 0xc5, 0xc6, 0x6f, 0x6b, 0xb0, 0xd8, 0x3f, 0xac,
	0x64, 0x2d, 0x3d, 0xe9, 0x72, 0x5f, 0xd4, 0xd9, 0xdd, 0x84, 0xaa, 0x1f, 0xd8, 0x0c, 0x57, 0x13,
	0x9b, 0x26, 0x13, 0x1e, 0x08, 0x98, 0x58, 0xa8, 0x6d, 0x8b, 0x7c, 0x80, 0x14, 0x56, 0x90, 0xf8,
	0x1c, 0xb3, 0xdf, 0x9c, 0xb1, 0x28, 0x20, 0xfb, 0x02, 0x40, 0xbe, 0x01, 0x4b, 0x88, 0x1e, 0xe8,
	0x3c, 0x2b, 0x37, 0x44, 0x40, 0x53, 0x7d, 0x1b, 0x3f, 0x9f, 0x81, 0xaa, 0xdc, 0x44, 0x79, 0x5a,
	0x47, 0xf2, 0x2d, 0x81, 0x59, 0x91, 0xcf, 0xd5, 0xfa, 0xf8, 0x7b, 0x38, 0xbb, 0xce, 0x8c, 0x66,
	0xd7, 0x7c, 0x86, 0x9c, 0x3d, 0x4b, 0x86, 0x5c, 0x83, 0xb9, 0x88, 0x51, 0xfb, 0x04, 0x73, 0x72,
	0xd9, 0x90, 0x0f, 0xc2, 0x91, 0x3d, 0xe6, 0x75, 0x58, 0x64, 0x06, 0x5d, 0xd3, 0x72, 0x93, 0x98,
	0xb3, 0x08, 0xf3, 0x72, 0xd9, 0x58, 0x96, 0x88, 0xa7, 0xdd, 0x7d, 0x09, 0x26, 0x1b, 0x30, 0xdf,
	0xa5, 0x8e, 0xcb, 0x6c, 0x4c, 0xcd, 0x65, 0x43, 0x3d, 0x91, 0x06, 0x94, 0x71, 0x19, 0xc7, 0xef,
	0x61, 0xe6, 0x2d, 0x1b, 0xfd, 0x67, 0xf1, 0xda, 0xc1, 0x4b, 0x95, 0x54, 0x4b, 0xc1, 0x4b, 0xe1,
	0x45, 0x49, 0xd8, 0x8b, 0xa8, 0x2d, 0x88, 0x41, 0xe6, 0xda, 0x3e, 0x20, 0x9b, 0xd7, 0x2a, 0xf9,
	0xbc, 0xb6, 0x07, 0xcb, 0x2e, 0x8d, 0xb9, 0x19, 0x73, 0x1a, 0xa9, 0xb7, 0xaf, 0x4e, 0x7d, 0xfb,
	0x9a, 0x60, 0x39, 0x92, 0x1c, 0xbb, 0x9c, 0x1c, 0xc2, 0x8a, 0x08, 0x05, 0xe6, 0x71, 0xe0, 0x26,
	0x1e, 0x33, 0x1d, 0xbf, 0x1b, 0xd4, 0xd7, 0xa6, 0xc4, 0x4c, 0xca, 0xe9, 0x73, 0x24, 0x6f, 0xfb,
	0xdd, 0xc0, 0x58, 0xb2, 0x73, 0xcf, 0x8d, 0xdf, 0x9a, 0x83, 0x79, 0xb5, 0xbf, 0x0d, 0x28, 0x33,
	0xdf, 0x0e, 0x03, 0xc7, 0xe7, 0x6a, 0x97, 0xfb, 0xcf, 0xc3, 0xfb, 0x5a, 0x1a, 0xdd, 0xd7, 0x3a,
	0x2c, 0xa8, 0x9d, 0xc2, 0x5d, 0x2f, 0x1b, 0xe9, 0xe3, 0x60, 0xdb, 0x66, 0xb3, 0xdb, 0x96, 0x33,
	0xe3, 0xdc, 0xb0, 0x19, 0x6f, 0xc2, 0xb2, 0x3a, 0x2a, 0xca, 0x7c, 0x71, 0x7d, 0x1e, 0x8f, 0xcb,
	0x92, 0x04, 0xab, 0xb4, 0x1e, 0x93, 0xf6, 0x20, 0xfb, 0x2e, 0x60, 0xec, 0x6c, 0x15, 0xce, 0xbe,
	0x2a, 0x09, 0xf5, 0xd3, 0xef, 0x3e, 0x2c, 0x77, 0x82, 0x80, 0xc7, 0x3c, 0xa2, 0x61, 0x58, 0xb4,
	0x0a, 0x5b, 0xca, 0xb2, 0xec, 0x72, 0x11, 0xea, 0xb2, 0x10, 0xe5, 0x37, 0x39, 0x98, 0x88, 0x34,
	0xa9, 0x61, 0xcd, 0x98, 0xb9, 0x5d, 0x33, 0x76, 0x7a, 0x3e, 0x4b, 0x8b, 0x32, 0x92, 0xe2, 0x8e,
	0x98, 0xdb, 0x3d, 0x42, 0x0c, 0xf9, 0x0c, 0xd6, 0xf3, 0x39, 0xc9, 0x54, 0x39, 0xd7, 0x46, 0x05,
	0xef, 0x9d, 0x39, 0x33, 0xc9, 0x57, 0xbf, 0xd0, 0x19, 0x05, 0x92, 0x0f, 0xe0, 0x22, 0x0f, 0x38,
	0x75, 0x4d, 0xb5, 0x22, 0x86, 0x99, 0xce, 0x89, 0x28, 0x99, 0x44, 0xa5, 0x36, 0x63, 0xac, 0x21,
	0x5a, 0xca, 0x13, 0x91, 0x62, 0x4f, 0xe0, 0xc8, 0x87, 0x70, 0x49, 0x31, 0x24, 0xa1, 0x1b, 0x50,
	0xdb, 0x74, 0x7c, 0x33, 0x8c, 0x82, 0x5e, 0xc4, 0x62, 0x59, 0x6b, 0x95, 0x8d, 0x0d, 0x49, 0xf0,
	0x29, 0xe2, 0xdb, 0xfe, 0xa1, 0xc2, 0x36, 0x7e, 0x47, 0x83, 0x0b, 0x63, 0xd4, 0x13, 0x0e, 0x19,
	0xb1, 0x63, 0x07, 0x0f, 0x93, 0x4c, 0x19, 0xfd, 0x67, 0xe1, 0x3e, 0xd2, 0x14, 0x99, 0x53, 0xd8,
	0x07, 0x88, 0x73, 0xae, 0x0c, 0x24, 0x0f, 0x61, 0x5a, 0x68, 0x5c, 0x87, 0x25, 0x71, 0xe2, 0x93,
	0x88, 0x99, 0x11, 0xa3, 0x71, 0xe0, 0xab, 0x5a, 0xb5, 0xa6, 0xa0, 0x06, 0x02, 0x1b, 0xff, 0xa5,
	0x01, 0x0c, 0xaa, 0x03, 0x11, 0xb2, 0xb0, 0x3e, 0x60, 0xb1, 0xf0, 0x09, 0x6d, 0x7a, 0xc8, 0x52,
	0xd4, 0xbb, 0x5c, 0x28, 0xa2, 0x16, 0x92, 0x47, 0x46, 0x3d, 0x91, 0xe7, 0xd0, 0xc0, 0x60, 0xf0,
	0x8a, 0x46, 0xbe, 0xe3, 0xf7, 0x4c, 0xe6, 0x51, 0xc7, 0x35, 0x63, 0xe6, 0xa3, 0xdb, 0xcd, 0x4c,
	0x5d, 0x62, 0x43, 0x70, 0xff, 0x9a, 0x64, 0xfe, 0x58, 0xf0, 0x1e, 0x31, 0x5f, 0xb8, 0xdf, 0x83,
	0xc9, 0x72, 0x79, 0x50, 0x9f, 0xc5, 0x23, 0x34, 0x96, 0xf7, 0x59, 0xd0, 0xf8, 0x3d, 0x0d, 0x56,
	0x47, 0xea, 0x97, 0x53, 0x37, 0x21, 0x0d, 0x69, 0x49, 0x68, 0xa7, 0x01, 0xbd, 0x54, 0x2c, 0xa4,
	0x7d, 0x2a, 0x39, 0x76, 0xb9, 0x68, 0xa7, 0x94, 0xdf, 0xf4, 0xdb, 0x92, 0xb2, 0x04, 0xb4, 0x6d,
	0xfd, 0x9f, 0x35, 0x28, 0x3f, 0x51, 0x79, 0x6d, 0x5c, 0xfe, 0xc1, 0xee, 0xae, 0x94, 0xe9, 0xee,
	0xae, 0x41, 0x25, 0x9b, 0xbb, 0x65, 0xea, 0x03, 0x6f, 0x90, 0xb3, 0x75, 0xa8, 0x79, 0x8e, 0x3f,
	0x92, 0xfa, 0x2a, 0x9e, 0xe3, 0xf7, 0x33, 0xb5, 0xa0, 0xa1, 0xaf, 0x33, 0x34, 0x73, 0x8a, 0x86,
	0xbe, 0xee, 0xd3, 0x5c, 0x82, 0xb2, 0x15, 0x26, 0x12, 0x2d, 0x9b, 0xc0, 0x05, 0x2b, 0x4c, 0x10,
	0x75, 0x05, 0xa0, 0xcf, 0x2a, 0xa3, 0x92, 0xa8, 0x33, 0x14, 0x63, 0xac, 0x3f, 0x82, 0x6a, 0xfa,
	0x4a, 0xdf, 0x71, 0x62, 0x4e, 0xee, 0xc1, 0x9c, 0xc3, 0x99, 0x27, 0xaa, 0x22, 0x11, 0xbf, 0x36,
	0x27, 0x9d, 0xe5, 0x94, 0xc9, 0x90, 0xe4, 0x7a, 0x0c, 0x2b, 0x29, 0x28, 0x36, 0xd8, 0x0f, 0x12,
	0x16, 0xf3, 0xa1, 0xd6, 0x55, 0x3b, 0xb5, 0x75, 0x2d, 0x0d, 0xb5, 0xae, 0xa2, 0x3e, 0x19, 0x54,
	0xa6, 0x8e, 0xad, 0x92, 0x77, 0x75, 0x00, 0x6c, 0xdb, 0xfa, 0x07, 0xb0, 0x3c, 0x88, 0x29, 0x58,
	0xa8, 0x14, 0xd9, 0x16, 0xfd, 0x19, 0x5c, 0x18, 0x62, 0xc3, 0x57, 0xff, 0x76, 0xfe, 0xd5, 0x6f,
	0x4e, 0x0f, 0x63, 0xc8, 0x9b, 0x5a, 0xe0, 0x5b, 0xf0, 0x96, 0x10, 0x33, 0x84, 0x2d, 0x68, 0x0c,
	0x7d, 0x1b, 0x16, 0xf6, 0x0f, 0x3f, 0x2d, 0xea, 0x59, 0xfa, 0x01, 0x54, 0x14, 0x39, 0xaa, 0xfe,
	0x41, 0x5e, 0xf5, 0x6b, 0x93, 0x54, 0x57, 0x3c, 0xa9, 0xca, 0xef, 0xc3, 0x05, 0xc1, 0xae, 0xa0,
	0x45, 0x55, 0xfd, 0x75, 0xb8, 0x3c, 0x78, 0xc9, 0xfd, 0x88, 0xd9, 0xcc, 0xe7, 0x0e, 0x1d, 0xbc,
	0xe9, 0xc8, 0xd6, 0x69, 0xa3, 0x5b, 0x37, 0x29, 0x14, 0xe9, 0x4f, 0x61, 0x7d, 0xac, 0x70, 0x71,
	0xf2, 0x93, 0x58, 0x54, 0xf6, 0x1e, 0x4b, 0xeb, 0x81, 0xf4, 0x59, 0xe0, 0x42, 0x1a, 0xc7, 0xaf,
	0x82, 0xa8, 0xef, 0x48, 0xe9, 0xb3, 0xfe, 0x23, 0x0d, 0x96, 0x06, 0x12, 0xd1, 0x5a, 0xf7, 0xf3,
	0xd6, 0xd2, 0xa7, 0x6f, 0xb4, 0x32, 0x18, 0xb9, 0x0f, 0xf3, 0x9d, 0xc4, 0xee, 0xb1, 0x34, 0xb2,
	0x8c, 0x1c, 0x0f, 0x35, 0x7c, 0x3a, 0xbe, 0xd3, 0xdc, 0x43, 0x3a, 0x43, 0xd1, 0xeb, 0x2e, 0x2c,
	0xa8, 0x2a, 0x21, 0x5b, 0x94, 0x69, 0xf9, 0xa2, 0xec, 0x31, 0x40, 0x3a, 0x6c, 0xe8, 0x9c, 0xa8,
	0x25, 0x8a, 0x0f, 0x19, 0x16, 0x15, 0xef, 0xde, 0x89, 0x7e, 0x00, 0x2b, 0xc3, 0xe8, 0x53, 0x96,
	0x9d, 0xb4, 0x17, 0x07, 0x50, 0x51, 0xec, 0x67, 0x72, 0x32, 0xc5, 0x93, 0x3a, 0xd9, 0x9f, 0x68,
	0xd2, 0xcb, 0xd2, 0x22, 0x29, 0x75, 0x93, 0x8f, 0x60, 0x21, 0x08, 0x65, 0xa3, 0x29, 0x93, 0xd8,
	0xf5, 0xc9, 0xc6, 0x14, 0xfc, 0x4f, 0x25, 0xb1, 0x91, 0x72, 0x89, 0xaa, 0x2c, 0x88, 0x7a, 0xd4,
	0x77, 0x3e, 0xc7, 0xc4, 0x38, 0x88, 0x22, 0x4b, 0x59, 0x70, 0xdb, 0x16, 0x84, 0x56, 0x12, 0x45,
	0xc2, 0x1b, 0x53, 0x0b, 0xc8, 0x68, 0xb2, 0xa4, 0xc0, 0x4a, 0x35, 0xfd, 0x0d, 0xd4, 0x33, 0x8d,
	0xe2, 0x77, 0x1c, 0xcf, 0xe1, 0xff, 0x77, 0xc1, 0xec, 0xdf, 0xe7, 0x60, 0x75, 0x64, 0x75, 0xf2,
	0x6c, 0x4c, 0xb3, 0x5a, 0xd9, 0x79, 0x6f, 0x92, 0xed, 0x47, 0x04, 0x34, 0xd5, 0x5b, 0xe4, 0xdb,
	0xdb, 0x17, 0xa7, 0xb7, 0xb7, 0xe7, 0x59, 0x60, 0x42, 0x43, 0xfc, 0x64, 0xb8, 0xcb, 0x3d, 0x8f,
	0xec, 0x4c, 0x5f, 0xdc, 0x39, 0xa5, 0x2f, 0x3e, 0x8f, 0xe8, 0x71, 0x9d, 0xf4, 0xf7, 0x27, 0x76,
	0xd2, 0xe7, 0x59, 0x61, 0xb4, 0xf7, 0xfe, 0x1e, 0xac, 0x60, 0xc7, 0x9b, 0xd5, 0x7f, 0xfd, 0x9c,
	0xd2, 0xb1, 0x77, 0xce, 0xe8, 0xfe, 0x34, 0xd7, 0x6c, 0x6f, 0x9c, 0xd7, 0xe0, 0xfd, 0xf6, 0xbc,
	0x71, 0x04, 0xf3, 0xca, 0x15, 0x57, 0x60, 0xc6, 0x73, 0xd2, 0xb2, 0x4b, 0xfc, 0x44, 0x08, 0x7d,
	0xad, 0x26, 0x22, 0xe2, 0xa7, 0x28, 0x69, 0xa9, 0xeb, 0x06, 0xaf, 0x98, 0x6d, 0x1e, 0x53, 0x37,
	0x61, 0x72, 0xfa, 0x31, 0x67, 0xd4, 0x14, 0xf4, 0x39, 0x02, 0xf5, 0x1f, 0xcf, 0xc0, 0xd5, 0x7d,
	0xea, 0x5a, 0x89, 0x4b, 0x39, 0x1b, 0x1e, 0x23, 0xc9, 0xf3, 0xf6, 0x8b, 0x9c, 0xd2, 0xfc, 0xff,
	0x8e, 0x5e, 0xfa, 0x73, 0x94, 0xf5, 0xd3, 0xe6, 0x28, 0x1b, 0x53, 0xe6, 0x28, 0x17, 0xa7, 0xcf,
	0x51, 0xf4, 0xd1, 0x39, 0x4a, 0x3e, 0x4e, 0xed, 0xe4, 0xe3, 0x94, 0xfe, 0xd3, 0x5c, 0xae, 0x44,
	0xfa, 0x0d, 0x98, 0xa7, 0x3d, 0xe6, 0xf3, 0x74, 0x03, 0xd4, 0x13, 0xb9, 0x0d, 0xab, 0xf8, 0x6b,
	0x8c, 0xd1, 0x97, 0x11, 0x91, 0x31, 0xcf, 0x0d, 0x90, 0xa0, 0x8c, 0x6a, 0xb2, 0x14, 0xae, 0x21,
	0xb8, 0xaf, 0xdb, 0x6d, 0x58, 0x95, 0xbd, 0x5e, 0x56, 0xa6, 0xdc, 0x9e, 0x65, 0x44, 0xe4, 0x65,
	0x4a, 0xda, 0x81, 0x4c, 0xb9, 0x3f, 0x35, 0x04, 0xa7, 0x32, 0xf5, 0x9f, 0xcd, 0x66, 0x0b, 0x8a,
	0xac, 0x83, 0xbd, 0x0d, 0x55, 0x71, 0x0e, 0x62, 0xc6, 0x25, 0xbb, 0x7c, 0xbf, 0x8a, 0x82, 0xe1,
	0x22, 0x75, 0x58, 0x48, 0x62, 0x66, 0xd1, 0x38, 0x2d, 0xbe, 0xd2, 0xc7, 0xc1, 0x1e, 0xce, 0x64,
	0xf7, 0xf0, 0x1a, 0x54, 0xba, 0x8e, 0xcb, 0xcc, 0x6e, 0x10, 0x79, 0x6a, 0x9c, 0xb4, 0x68, 0x80,
	0x00, 0x3d, 0x42, 0x08, 0x69, 0xc2, 0x05, 0x3f, 0x49, 0xa7, 0x43, 0x76, 0x60, 0x25, 0x1e, 0x9a,
	0x76, 0x0e, 0x3b, 0xd9, 0x55, 0x89, 0x7a, 0xda, 0x3d, 0x48, 0x11, 0xc2, 0x22, 0x03, 0x7a, 0x2b,
	0x70, 0x13, 0x0f, 0x47, 0x0f, 0x68, 0x91, 0x94, 0x7a, 0x5f, 0x82, 0xc9, 0xfb, 0xb0, 0xf1, 0x2a,
	0x88, 0x5e, 0x8a, 0x3e, 0x4b, 0xbc, 0x53, 0xc8, 0x22, 0x8b, 0xf9, 0x9c, 0xf6, 0x18, 0x4e, 0x97,
	0x4a, 0xc6, 0x9a, 0xc2, 0x1e, 0x31, 0x7e, 0xd8, 0xc7, 0x09, 0x2e, 0x6a, 0x59, 0x2c, 0x8e, 0x45,
	0x0b, 0x6a, 0x67, 0xb9, 0xca, 0x92, 0x4b, 0x62, 0x0d, 0x46, 0xed, 0x0c, 0xd7, 0x7d, 0xa8, 0x2b,
	0x2e, 0x39, 0x56, 0xc9, 0xf2, 0x2d, 0x22, 0x9f, 0x92, 0xba, 0x8f, 0xe8, 0xb1, 0x9c, 0xb2, 0x4d,
	0xcb, 0x72, 0x42, 0x96, 0x53, 0xf6, 0x64, 0x19, 0xce, 0x6b, 0x50, 0xe9, 0x45, 0xc1, 0x2b, 0xfe,
	0xc2, 0x8c, 0x28, 0x97, 0x7e, 0x51, 0x32, 0x40, 0x82, 0x0c, 0xca, 0x19, 0xd9, 0x96, 0x57, 0x35,
	0x8e, 0x25, 0xcb, 0x81, 0x2e, 0xb5, 0x78, 0x10, 0x29, 0xaf, 0x58, 0xcd, 0x60, 0x1e, 0x21, 0x62,
	0x28, 0xa1, 0xaf, 0x9f, 0x9a, 0xd0, 0x37, 0x86, 0x0e, 0xca, 0xbf, 0x96, 0xb2, 0x35, 0xf0, 0xe8,
	0xf4, 0x9b, 0x3c, 0x86, 0x85, 0x48, 0xfa, 0x99, 0xca, 0xd8, 0xdb, 0x45, 0x87, 0xe8, 0xc8, 0x64,
	0xa4, 0xdc, 0x43, 0x03, 0xca, 0xd2, 0x59, 0x06, 0x94, 0x5b, 0x63, 0xd2, 0x8c, 0x3c, 0x4d, 0xc3,
	0x49, 0x63, 0x34, 0x74, 0x54, 0xc7, 0x84, 0x8e, 0x7c, 0xfc, 0xa9, 0x0d, 0xc7, 0x9f, 0x77, 0xa0,
	0xc6, 0x5e, 0x5b, 0x8c, 0xd9, 0xb1, 0xf9, 0x83, 0x24, 0xe0, 0x14, 0x4d, 0x5a, 0x36, 0xaa, 0x0a,
	0xf8, 0xab, 0x02, 0x46, 0x6e, 0xc1, 0x4a, 0x4a, 0x14, 0xba, 0x94, 0x8b, 0x83, 0x82, 0xc6, 0x2d,
	0x1b, 0xcb, 0x0a, 0x7e, 0xa8, 0xc0, 0xfa, 0x5f, 0x89, 0x60, 0x94, 0x1b, 0x0f, 0x0a, 0x17, 0x50,
	0xc3, 0x20, 0x1c, 0x00, 0x69, 0x78, 0x6c, 0x40, 0x0e, 0x80, 0x70, 0xec, 0x73, 0x05, 0x20, 0x89,
	0xf1, 0xc2, 0x90, 0xe3, 0x8d, 0x80, 0xc0, 0x2f, 0x0a, 0x88, 0x44, 0xdf, 0x84, 0x65, 0x7a, 0x4c,
	0x1d, 0x97, 0x76, 0xdc, 0x74, 0x88, 0x34, 0x83, 0x34, 0x4b, 0x7d, 0xb0, 0x24, 0x7c, 0x28, 0x1a,
	0x77, 0x1a, 0x27, 0x91, 0x34, 0x3b, 0x4c, 0x35, 0x3b, 0xa4, 0xe4, 0xbb, 0x5c, 0xff, 0x4f, 0x0d,
	0x2e, 0xed, 0x07, 0xbe, 0xcf, 0x2c, 0x7e, 0x10, 0x39, 0xc7, 0x2c, 0x6a, 0xfb, 0x31, 0x8f, 0x12,
	0x4b, 0x56, 0xad, 0xdf, 0x87, 0x05, 0x1b, 0xa1, 0x69, 0x1d, 0x7d, 0x30, 0xb1, 0x59, 0x9b, 0x24,
	0xa3, 0x39, 0x0a, 0x32, 0x52, 0xa1, 0x8d, 0x04, 0xc8, 0x98, 0x55, 0xd3, 0x1e, 0x52, 0xcb, 0x4c,
	0x27, 0x08, 0xcc, 0x5a, 0x81, 0xcd, 0xd4, 0xc5, 0x09, 0xfe, 0x16, 0x11, 0x2f, 0x62, 0x1e, 0x8d,
	0x5e, 0xa6, 0xd7, 0x16, 0xe9, 0x23, 0xce, 0x11, 0x50, 0xae, 0x99, 0x44, 0xae, 0x0a, 0x6d, 0x8b,
	0x12, 0xf2, 0x69, 0xe4, 0xea, 0x1f, 0xc2, 0x46, 0xdb, 0x0b, 0x83, 0x88, 0x8b, 0x2d, 0xcb, 0x2d,
	0x7d, 0x0d, 0x2a, 0x0e, 0x62, 0x4c, 0x3b, 0xf1, 0x42, 0xb5, 0x1a, 0x48, 0xd0, 0x41, 0xe2, 0x85,
	0xfa, 0x5f, 0xcc, 0xc2, 0xc6, 0xe0, 0x14, 0x1c, 0x46, 0x8e, 0xd5, 0x8f, 0xd1, 0x63, 0x4a, 0x7c,
	0x6d, 0x6c, 0x89, 0x9f, 0x3f, 0xcc, 0xa5, 0xe1, 0xc3, 0x3c, 0xe6, 0xce, 0x79, 0x66, 0xdc, 0x9d,
	0xf3, 0x6d, 0x58, 0xc5, 0x3d, 0x30, 0xb3, 0x17, 0x8d, 0xb3, 0xea, 0x1a, 0x4a, 0x20, 0x0e, 0x07,
	0x57, 0x8d, 0x37, 0x40, 0x82, 0xcc, 0x41, 0x98, 0x90, 0xb7, 0xf3, 0x35, 0x04, 0x1b, 0x69, 0xf1,
	0xdf, 0x4f, 0x15, 0xf3, 0xa7, 0xa5, 0xfb, 0x85, 0x29, 0xe9, 0xbe, 0x3c, 0x3d, 0xdd, 0x2f, 0x8e,
	0x39, 0xb3, 0xc3, 0x55, 0x14, 0x9c, 0xad, 0x8a, 0xaa, 0x14, 0xae, 0xa2, 0xaa, 0x45, 0xab, 0xa8,
	0xda, 0x19, 0xab, 0xa8, 0xa5, 0xf1, 0x55, 0x94, 0xfe, 0xc3, 0xd9, 0xec, 0xf0, 0x07, 0xbd, 0x46,
	0xd8, 0x24, 0x14, 0x3f, 0x44, 0x52, 0x31, 0x5f, 0x04, 0x49, 0x84, 0xde, 0x52, 0x32, 0xaa, 0x08,
	0x3d, 0x64, 0xd1, 0x27, 0x41, 0x12, 0x11, 0x0e, 0x17, 0x7d, 0xc6, 0x45, 0x36, 0x34, 0x79, 0x44,
	0xfd, 0xb8, 0xcb, 0x22, 0x13, 0x09, 0xe4, 0x1d, 0x62, 0x65, 0xe7, 0x5b, 0xd3, 0x63, 0x35, 0xae,
	0xd7, 0x7c, 0x22, 0xc5, 0x3c, 0x53, 0x52, 0xa4, 0xeb, 0xae, 0xfb, 0x63, 0xa0, 0x31, 0x79, 0x0e,
	0x55, 0x35, 0x59, 0xc4, 0xb5, 0xd4, 0x54, 0xf5, 0x6e, 0xd1, 0xa5, 0xe4, 0x28, 0x54, 0xae, 0x50,
	0xe9, 0x0c, 0x1e, 0xc4, 0xf1, 0x92, 0x5d, 0xac, 0x75, 0x32, 0x70, 0x56, 0x48, 0x41, 0x6d, 0xbb,
	0xf1, 0x95, 0x06, 0x6b, 0xe3, 0x14, 0x25, 0x2d, 0x58, 0x73, 0x7c, 0x9c, 0x79, 0x9b, 0x03, 0xab,
	0xf5, 0x3a, 0xca, 0x66, 0xab, 0x0a, 0x77, 0xa8, 0x4c, 0xf7, 0xb8, 0x43, 0xb6, 0xe1, 0x02, 0x1b,
	0x43, 0x5f, 0x42, 0xfa, 0x15, 0x36, 0x4c, 0x3e, 0xf5, 0xf6, 0xad, 0xf1, 0x11, 0x54, 0x32, 0xef,
	0x45, 0xde, 0x83, 0xf5, 0xac, 0xe0, 0xe1, 0x5d, 0x5c, 0x0d, 0xfb, 0xb2, 0xd5, 0x56, 0xea, 0xf7,
	0x80, 0x0c, 0x0c, 0xf5, 0x88, 0x51, 0x9e, 0x44, 0x2c, 0x16, 0x0b, 0x67, 0xbe, 0x0a, 0x40, 0xee,
	0xb2, 0x91, 0x05, 0xe9, 0xbf, 0xab, 0xc1, 0xa5, 0x51, 0xc6, 0xff, 0x8d, 0x56, 0x7f, 0x7c, 0x61,
	0x38, 0x7c, 0xda, 0x67, 0x87, 0x4f, 0xfb, 0xce, 0x3f, 0x5d, 0x84, 0x8a, 0x08, 0x9d, 0xa2, 0x25,
	0x13, 0xb6, 0x48, 0xa0, 0xf6, 0x98, 0xf1, 0xdd, 0xc3, 0x76, 0x3a, 0x35, 0xba, 0x36, 0x79, 0x3a,
	0xf2, 0xb1, 0x17, 0xf2, 0x93, 0xc6, 0xdb, 0x93, 0x09, 0xd2, 0xf9, 0xc6, 0xe6, 0x0f, 0x7f, 0xf6,
	0x6f, 0x7f, 0x50, 0x6a, 0x90, 0x3a, 0x7e, 0xd2, 0x24, 0x5c, 0xad, 0x75, 0x7c, 0x47, 0xfc, 0xde,
	0x4e, 0x47, 0x41, 0x5f, 0x69, 0xb0, 0x9c, 0x9f, 0x62, 0xc6, 0xa4, 0xd8, 0x5c, 0xa6, 0x51, 0xe0,
	0x3b, 0x09, 0x41, 0xae, 0xdf, 0x43, 0x25, 0xde, 0x23, 0xcd, 0x9c, 0x12, 0xca, 0xbc, 0x71, 0xeb,
	0x8d, 0x15, 0xf8, 0x9c, 0xbd, 0x16, 0xa6, 0xff, 0xa2, 0x65, 0x67, 0xd4, 0xf8, 0x12, 0x2d, 0x92,
	0xf9, 0xe2, 0xea, 0x9d, 0xc9, 0x7a, 0xb5, 0x0f, 0x52, 0xad, 0x0a, 0x0c, 0xf7, 0xf4, 0xeb, 0xa8,
	0xd1, 0x35, 0x72, 0x25, 0xa7, 0x51, 0x66, 0xed, 0xd6, 0x1b, 0xc7, 0xfe, 0x82, 0xfc, 0x58, 0x83,
	0x15, 0x59, 0xcf, 0x66, 0x94, 0x28, 0x20, 0xbf, 0x90, 0x0e, 0xf7, 0x51, 0x87, 0x1d, 0x7d, 0x7b,
	0x9c, 0x55, 0x5a, 0x6f, 0x06, 0xfe, 0x98, 0x33, 0xca, 0x03, 0xed, 0x36, 0xf9, 0x91, 0x06, 0x2b,
	0xb2, 0x58, 0xfe, 0x05, 0xa8, 0xb5, 0x85, 0x6a, 0xe9, 0x3b, 0xa7, 0x9b, 0x46, 0xa8, 0xf1, 0x25,
	0xac, 0xc8, 0x2f, 0xbc, 0xce, 0xba, 0x43, 0xd3, 0x1c, 0x3b, 0xdd, 0x9e, 0xdb, 0x53, 0xb6, 0xe7,
	0xef, 0x34, 0xa8, 0xe7, 0x1c, 0x24, 0x3b, 0x3d, 0x2e, 0xf0, 0x0d, 0xcb, 0xe8, 0x24, 0xbb, 0xb1,
	0x7d, 0x26, 0x2e, 0xfd, 0x01, 0x2a, 0xfa, 0x3e, 0xd9, 0x99, 0xa0, 0xa8, 0x35, 0xa0, 0x6d, 0xbd,
	0xc9, 0x0d, 0x04, 0xbf, 0x20, 0x5f, 0x42, 0x35, 0x3b, 0x24, 0x25, 0xef, 0x4e, 0x5a, 0x7a, 0xcc,
	0x28, 0xb5, 0xf1, 0xce, 0x94, 0x51, 0x2c, 0x9e, 0xbb, 0x2b, 0xa8, 0xdd, 0x45, 0xb2, 0x9e, 0xd3,
	0x2e, 0xbd, 0xd0, 0x26, 0xbf, 0x09, 0xab, 0x68, 0xbd, 0x2e, 0x4d, 0x5c, 0x5e, 0x38, 0xe8, 0x4c,
	0x1b, 0x02, 0x4f, 0x38, 0x5b, 0xe9, 0xaa, 0x2d, 0x5b, 0xae, 0x47, 0xfe, 0x56, 0x83, 0xb5, 0xc7,
	0x8c, 0x8f, 0xce, 0x3f, 0x8b, 0xcf, 0xae, 0x52, 0x63, 0xdc, 0x2a, 0xcc, 0xa1, 0x7f, 0x8c, 0xca,
	0x7d, 0x44, 0xbe, 0x3d, 0x21, 0x14, 0x65, 0x4f, 0x9d, 0x8c, 0xf0, 0x71, 0xeb, 0x4d, 0x3f, 0xf6,
	0x7f, 0xd1, 0x72, 0xa5, 0x8e, 0x3f, 0xd1, 0xa0, 0x26, 0x4c, 0xdc, 0xbf, 0x00, 0x23, 0x5b, 0xd3,
	0xae, 0xcd, 0xfa, 0xda, 0x7e, 0x63, 0x1a, 0x25, 0xee, 0xdd, 0x27, 0xa8, 0xe8, 0x1e, 0xf9, 0x95,
	0x73, 0x2a, 0x2a, 0x12, 0x0d, 0x5e, 0x00, 0x92, 0xbf, 0xd4, 0x60, 0x6d, 0xdc, 0x35, 0x15, 0xb9,
	0x7b, 0x9a, 0xc3, 0x4d, 0xb8, 0xd4, 0x6a, 0xbc, 0x5b, 0xf0, 0x8e, 0x0c, 0x5f, 0xe2, 0x21, 0xbe,
	0xc4, 0x07, 0xe4, 0x6e, 0x81, 0x97, 0x18, 0x9c, 0x0e, 0x4f, 0xaa, 0xf7, 0x87, 0x9a, 0x3c, 0x20,
	0xe9, 0x5d, 0xd5, 0xe9, 0x07, 0x64, 0xe8, 0x46, 0x6b, 0xf2, 0x01, 0xc9, 0x5c, 0xa2, 0xe9, 0x77,
	0x51, 0xbf, 0x6d, 0xf2, 0x6e, 0x01, 0xfd, 0xac, 0x30, 0x91, 0xf6, 0xfc, 0x89, 0x06, 0x17, 0x27,
	0x4c, 0x32, 0xc9, 0xc4, 0x0f, 0x21, 0x4e, 0x1f, 0x7d, 0x36, 0x0a, 0x7e, 0x71, 0xa8, 0x37, 0x51,
	0xe1, 0x2d, 0x72, 0x63, 0x42, 0xbc, 0xd9, 0x16, 0x2a, 0xb6, 0xac, 0x74, 0x31, 0xf2, 0x67, 0x1a,
	0x5c, 0xec, 0xcf, 0x29, 0x86, 0x74, 0x3d, 0xdb, 0x7c, 0xa2, 0x71, 0xae, 0x6f, 0x02, 0x0b, 0x2a,
	0xdc, 0xff, 0x0c, 0x91, 0xfc, 0x8d, 0x06, 0x97, 0x1f, 0x33, 0x3e, 0xb9, 0x99, 0x2e, 0x94, 0x60,
	0xee, 0x9c, 0xb9, 0xc1, 0xd6, 0x77, 0x51, 0xd1, 0x87, 0xe4, 0xc3, 0x53, 0x53, 0x4e, 0xcb, 0x92,
	0x02, 0xb6, 0x65, 0x1b, 0xbc, 0xed, 0x64, 0x55, 0xfb, 0x73, 0x0d, 0x2e, 0x3d, 0x66, 0x7c, 0x42,
	0x53, 0x5c, 0x48, 0xf1, 0x89, 0x9f, 0xee, 0x8e, 0x17, 0xaa, 0xff, 0x32, 0x6a, 0x7d, 0x9f, 0xdc,
	0x3b, 0x5d, 0x6b, 0xd9, 0x7a, 0x6f, 0x0b, 0x7c, 0x5e, 0xe5, 0x3f, 0xd6, 0xa0, 0x3e, 0xc6, 0x35,
	0x65, 0x71, 0xde, 0x2c, 0xd8, 0xa9, 0xa4, 0x1e, 0x72, 0xb3, 0x20, 0xbd, 0xde, 0x42, 0xad, 0x6f,
	0x91, 0x9b, 0x93, 0x9c, 0x02, 0xcb, 0xfe, 0x8c, 0x1b, 0xff, 0x91, 0x06, 0xeb, 0xb9, 0x44, 0xdf,
	0x2f, 0xfc, 0xef, 0x4c, 0x5f, 0x73, 0xa8, 0xd6, 0x6f, 0xdc, 0x2e, 0xce, 0xa2, 0xbf, 0x8b, 0x9a,
	0x5e, 0xd7, 0x37, 0x27, 0x69, 0xda, 0x55, 0x94, 0x0f, 0xb4, 0xdb, 0x7b, 0x0f, 0xfe, 0xfe, 0xeb,
	0xab, 0xda, 0x4f, 0xbf, 0xbe, 0xaa, 0xfd, 0xcb, 0xd7, 0x57, 0xb5, 0xaf, 0x7e, 0x7e, 0xf5, 0x97,
	0xbe, 0xb7, 0x95, 0xf9, 0x2f, 0x42, 0xba, 0xe8, 0xb6, 0x47, 0x7d, 0xda, 0x63, 0xb6, 0x90, 0x18,
	0xa7, 0x22, 0x3b, 0xf3, 0x38, 0x61, 0xba, 0xfb, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xf4, 0x1c,
	0x34, 0xa0, 0xfa, 0x30, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataServiceClient is the client API for DataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all deployments in the project identified by the given context ID.
	// Required permissions:
	// - data.deployment.list on the project identified by the given context ID
	ListDeployments(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*DeploymentList, error)
	// Fetch a deployment by its id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetDeployment(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Deployment, error)
	// Create a new deployment
	// Required permissions:
	// - data.deployment.create on the project that owns the deployment
	// Note that deployment.status & deployment.expiration are ignored
	// in this request.
	CreateDeployment(ctx context.Context, in *Deployment, opts ...grpc.CallOption) (*Deployment, error)
	// Update a deployment
	// Required permissions:
	// - data.deployment.update on the deployment
	// Note that deployment.status & deployment.expiration are ignored
	// in this request.
	UpdateDeployment(ctx context.Context, in *Deployment, opts ...grpc.CallOption) (*Deployment, error)
	// Delete a deployment
	// Note that deployments are initially only marked for deletion.
	// Once all their resources are removed the deployment itself is removed.
	// Required permissions:
	// - data.deployment.delete on the deployment
	DeleteDeployment(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch credentials for accessing deployment by its id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	// - data.deploymentcredentials.get on the deployment identified by the given ID
	GetDeploymentCredentials(ctx context.Context, in *DeploymentCredentialsRequest, opts ...grpc.CallOption) (*DeploymentCredentials, error)
	// Fetch all ArangoDB versions that are available for deployments.
	// Required permissions:
	// - None
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*VersionList, error)
	// Fetch the default ArangoDB version for new deployment.
	// Required permissions:
	// - None
	GetDefaultVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*Version, error)
	// Fetch the limits for server specifications for deployments
	// owned by the given projected, created in the given region.
	// Required permissions:
	// - data.limits.get on the requested project
	// - data.deployment.get on the specified deployment (if deployment_id is set)
	// This method is deprecated and will be remove in the very near future, do not use this method anymore
	GetServersSpecLimits(ctx context.Context, in *ServersSpecLimitsRequest, opts ...grpc.CallOption) (*ServersSpecLimits, error)
	// Fetch the node sizes available for deployments
	// owned by the project with given ID, created in the given region with given ID.
	// If project ID "all" is used, then all node sizes for the region with given
	// ID are returned.
	// Required permissions:
	// - data.nodesize.list on the requested project (if project ID does not equal "all")
	// - None if project ID does equals "all"
	ListNodeSizes(ctx context.Context, in *NodeSizesRequest, opts ...grpc.CallOption) (*NodeSizeList, error)
	// Fetch the models available for deployments owned by the project with given ID.
	// Required permissions:
	// - data.deploymentmodel.list on the requested project
	ListDeploymentModels(ctx context.Context, in *ListDeploymentModelsRequest, opts ...grpc.CallOption) (*DeploymentModelList, error)
	// Fetch the CPU sizes available for deployments owned by the project with given ID.
	// Required permissions:
	// - data.cpusize.list on the requested project
	ListCPUSizes(ctx context.Context, in *ListCPUSizesRequest, opts ...grpc.CallOption) (*CPUSizeList, error)
	// Calculate the total size of a deployment with given arguments.
	// Required permissions:
	// - none
	CalculateDeploymentSize(ctx context.Context, in *CalculateDeploymentSizeRequest, opts ...grpc.CallOption) (*DeploymentSize, error)
	// Recommend a deployment size, for a oneshard or sharded deployments, using the
	// given input values.
	// Required permissions:
	// - none
	RecommendDeploymentSize(ctx context.Context, in *DeploymentSizeRequest, opts ...grpc.CallOption) (*DeploymentSizeRecommendation, error)
	// Fetch instructions for connecting drivers to the deployment identified by the given id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetConnectDriverInstructions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ConnectDriverInstructions, error)
	// Fetch instructions for importing data into the deployment identified by the given id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetImportDataInstructions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ImportDataInstructions, error)
	// Calculate the price of a deployment of given settings.
	// Required permissions:
	// - data.deploymentprice.calculate
	CalculateDeploymentPrice(ctx context.Context, in *DeploymentPriceRequest, opts ...grpc.CallOption) (*DeploymentPrice, error)
	// Get the features that will be available to a deployment in the given context.
	// Required permissions:
	// - data.deploymentfeatures.get on the project that is given in the request.
	GetDeploymentFeatures(ctx context.Context, in *DeploymentFeaturesRequest, opts ...grpc.CallOption) (*DeploymentFeatures, error)
}

type dataServiceClient struct {
	cc *grpc.ClientConn
}

func NewDataServiceClient(cc *grpc.ClientConn) DataServiceClient {
	return &dataServiceClient{cc}
}

func (c *dataServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) ListDeployments(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*DeploymentList, error) {
	out := new(DeploymentList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetDeployment(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) CreateDeployment(ctx context.Context, in *Deployment, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/CreateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) UpdateDeployment(ctx context.Context, in *Deployment, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/UpdateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) DeleteDeployment(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/DeleteDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetDeploymentCredentials(ctx context.Context, in *DeploymentCredentialsRequest, opts ...grpc.CallOption) (*DeploymentCredentials, error) {
	out := new(DeploymentCredentials)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetDeploymentCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*VersionList, error) {
	out := new(VersionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/ListVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetDefaultVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetDefaultVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetServersSpecLimits(ctx context.Context, in *ServersSpecLimitsRequest, opts ...grpc.CallOption) (*ServersSpecLimits, error) {
	out := new(ServersSpecLimits)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetServersSpecLimits", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) ListNodeSizes(ctx context.Context, in *NodeSizesRequest, opts ...grpc.CallOption) (*NodeSizeList, error) {
	out := new(NodeSizeList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/ListNodeSizes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) ListDeploymentModels(ctx context.Context, in *ListDeploymentModelsRequest, opts ...grpc.CallOption) (*DeploymentModelList, error) {
	out := new(DeploymentModelList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/ListDeploymentModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) ListCPUSizes(ctx context.Context, in *ListCPUSizesRequest, opts ...grpc.CallOption) (*CPUSizeList, error) {
	out := new(CPUSizeList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/ListCPUSizes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) CalculateDeploymentSize(ctx context.Context, in *CalculateDeploymentSizeRequest, opts ...grpc.CallOption) (*DeploymentSize, error) {
	out := new(DeploymentSize)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/CalculateDeploymentSize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) RecommendDeploymentSize(ctx context.Context, in *DeploymentSizeRequest, opts ...grpc.CallOption) (*DeploymentSizeRecommendation, error) {
	out := new(DeploymentSizeRecommendation)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/RecommendDeploymentSize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetConnectDriverInstructions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ConnectDriverInstructions, error) {
	out := new(ConnectDriverInstructions)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetConnectDriverInstructions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetImportDataInstructions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ImportDataInstructions, error) {
	out := new(ImportDataInstructions)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetImportDataInstructions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) CalculateDeploymentPrice(ctx context.Context, in *DeploymentPriceRequest, opts ...grpc.CallOption) (*DeploymentPrice, error) {
	out := new(DeploymentPrice)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/CalculateDeploymentPrice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataServiceClient) GetDeploymentFeatures(ctx context.Context, in *DeploymentFeaturesRequest, opts ...grpc.CallOption) (*DeploymentFeatures, error) {
	out := new(DeploymentFeatures)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.data.v1.DataService/GetDeploymentFeatures", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataServiceServer is the server API for DataService service.
type DataServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all deployments in the project identified by the given context ID.
	// Required permissions:
	// - data.deployment.list on the project identified by the given context ID
	ListDeployments(context.Context, *v1.ListOptions) (*DeploymentList, error)
	// Fetch a deployment by its id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetDeployment(context.Context, *v1.IDOptions) (*Deployment, error)
	// Create a new deployment
	// Required permissions:
	// - data.deployment.create on the project that owns the deployment
	// Note that deployment.status & deployment.expiration are ignored
	// in this request.
	CreateDeployment(context.Context, *Deployment) (*Deployment, error)
	// Update a deployment
	// Required permissions:
	// - data.deployment.update on the deployment
	// Note that deployment.status & deployment.expiration are ignored
	// in this request.
	UpdateDeployment(context.Context, *Deployment) (*Deployment, error)
	// Delete a deployment
	// Note that deployments are initially only marked for deletion.
	// Once all their resources are removed the deployment itself is removed.
	// Required permissions:
	// - data.deployment.delete on the deployment
	DeleteDeployment(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch credentials for accessing deployment by its id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	// - data.deploymentcredentials.get on the deployment identified by the given ID
	GetDeploymentCredentials(context.Context, *DeploymentCredentialsRequest) (*DeploymentCredentials, error)
	// Fetch all ArangoDB versions that are available for deployments.
	// Required permissions:
	// - None
	ListVersions(context.Context, *ListVersionsRequest) (*VersionList, error)
	// Fetch the default ArangoDB version for new deployment.
	// Required permissions:
	// - None
	GetDefaultVersion(context.Context, *v1.Empty) (*Version, error)
	// Fetch the limits for server specifications for deployments
	// owned by the given projected, created in the given region.
	// Required permissions:
	// - data.limits.get on the requested project
	// - data.deployment.get on the specified deployment (if deployment_id is set)
	// This method is deprecated and will be remove in the very near future, do not use this method anymore
	GetServersSpecLimits(context.Context, *ServersSpecLimitsRequest) (*ServersSpecLimits, error)
	// Fetch the node sizes available for deployments
	// owned by the project with given ID, created in the given region with given ID.
	// If project ID "all" is used, then all node sizes for the region with given
	// ID are returned.
	// Required permissions:
	// - data.nodesize.list on the requested project (if project ID does not equal "all")
	// - None if project ID does equals "all"
	ListNodeSizes(context.Context, *NodeSizesRequest) (*NodeSizeList, error)
	// Fetch the models available for deployments owned by the project with given ID.
	// Required permissions:
	// - data.deploymentmodel.list on the requested project
	ListDeploymentModels(context.Context, *ListDeploymentModelsRequest) (*DeploymentModelList, error)
	// Fetch the CPU sizes available for deployments owned by the project with given ID.
	// Required permissions:
	// - data.cpusize.list on the requested project
	ListCPUSizes(context.Context, *ListCPUSizesRequest) (*CPUSizeList, error)
	// Calculate the total size of a deployment with given arguments.
	// Required permissions:
	// - none
	CalculateDeploymentSize(context.Context, *CalculateDeploymentSizeRequest) (*DeploymentSize, error)
	// Recommend a deployment size, for a oneshard or sharded deployments, using the
	// given input values.
	// Required permissions:
	// - none
	RecommendDeploymentSize(context.Context, *DeploymentSizeRequest) (*DeploymentSizeRecommendation, error)
	// Fetch instructions for connecting drivers to the deployment identified by the given id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetConnectDriverInstructions(context.Context, *v1.IDOptions) (*ConnectDriverInstructions, error)
	// Fetch instructions for importing data into the deployment identified by the given id.
	// Required permissions:
	// - data.deployment.get on the deployment identified by the given ID
	GetImportDataInstructions(context.Context, *v1.IDOptions) (*ImportDataInstructions, error)
	// Calculate the price of a deployment of given settings.
	// Required permissions:
	// - data.deploymentprice.calculate
	CalculateDeploymentPrice(context.Context, *DeploymentPriceRequest) (*DeploymentPrice, error)
	// Get the features that will be available to a deployment in the given context.
	// Required permissions:
	// - data.deploymentfeatures.get on the project that is given in the request.
	GetDeploymentFeatures(context.Context, *DeploymentFeaturesRequest) (*DeploymentFeatures, error)
}

// UnimplementedDataServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDataServiceServer struct {
}

func (*UnimplementedDataServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedDataServiceServer) ListDeployments(ctx context.Context, req *v1.ListOptions) (*DeploymentList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (*UnimplementedDataServiceServer) GetDeployment(ctx context.Context, req *v1.IDOptions) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (*UnimplementedDataServiceServer) CreateDeployment(ctx context.Context, req *Deployment) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeployment not implemented")
}
func (*UnimplementedDataServiceServer) UpdateDeployment(ctx context.Context, req *Deployment) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeployment not implemented")
}
func (*UnimplementedDataServiceServer) DeleteDeployment(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeployment not implemented")
}
func (*UnimplementedDataServiceServer) GetDeploymentCredentials(ctx context.Context, req *DeploymentCredentialsRequest) (*DeploymentCredentials, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeploymentCredentials not implemented")
}
func (*UnimplementedDataServiceServer) ListVersions(ctx context.Context, req *ListVersionsRequest) (*VersionList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (*UnimplementedDataServiceServer) GetDefaultVersion(ctx context.Context, req *v1.Empty) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultVersion not implemented")
}
func (*UnimplementedDataServiceServer) GetServersSpecLimits(ctx context.Context, req *ServersSpecLimitsRequest) (*ServersSpecLimits, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServersSpecLimits not implemented")
}
func (*UnimplementedDataServiceServer) ListNodeSizes(ctx context.Context, req *NodeSizesRequest) (*NodeSizeList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodeSizes not implemented")
}
func (*UnimplementedDataServiceServer) ListDeploymentModels(ctx context.Context, req *ListDeploymentModelsRequest) (*DeploymentModelList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeploymentModels not implemented")
}
func (*UnimplementedDataServiceServer) ListCPUSizes(ctx context.Context, req *ListCPUSizesRequest) (*CPUSizeList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCPUSizes not implemented")
}
func (*UnimplementedDataServiceServer) CalculateDeploymentSize(ctx context.Context, req *CalculateDeploymentSizeRequest) (*DeploymentSize, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateDeploymentSize not implemented")
}
func (*UnimplementedDataServiceServer) RecommendDeploymentSize(ctx context.Context, req *DeploymentSizeRequest) (*DeploymentSizeRecommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecommendDeploymentSize not implemented")
}
func (*UnimplementedDataServiceServer) GetConnectDriverInstructions(ctx context.Context, req *v1.IDOptions) (*ConnectDriverInstructions, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectDriverInstructions not implemented")
}
func (*UnimplementedDataServiceServer) GetImportDataInstructions(ctx context.Context, req *v1.IDOptions) (*ImportDataInstructions, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImportDataInstructions not implemented")
}
func (*UnimplementedDataServiceServer) CalculateDeploymentPrice(ctx context.Context, req *DeploymentPriceRequest) (*DeploymentPrice, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalculateDeploymentPrice not implemented")
}
func (*UnimplementedDataServiceServer) GetDeploymentFeatures(ctx context.Context, req *DeploymentFeaturesRequest) (*DeploymentFeatures, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeploymentFeatures not implemented")
}

func RegisterDataServiceServer(s *grpc.Server, srv DataServiceServer) {
	s.RegisterService(&_DataService_serviceDesc, srv)
}

func _DataService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).ListDeployments(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetDeployment(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_CreateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Deployment)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).CreateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/CreateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).CreateDeployment(ctx, req.(*Deployment))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_UpdateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Deployment)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).UpdateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/UpdateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).UpdateDeployment(ctx, req.(*Deployment))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_DeleteDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).DeleteDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/DeleteDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).DeleteDeployment(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetDeploymentCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeploymentCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetDeploymentCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetDeploymentCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetDeploymentCredentials(ctx, req.(*DeploymentCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetDefaultVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetDefaultVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetDefaultVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetDefaultVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetServersSpecLimits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ServersSpecLimitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetServersSpecLimits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetServersSpecLimits",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetServersSpecLimits(ctx, req.(*ServersSpecLimitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_ListNodeSizes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeSizesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).ListNodeSizes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/ListNodeSizes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).ListNodeSizes(ctx, req.(*NodeSizesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_ListDeploymentModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).ListDeploymentModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/ListDeploymentModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).ListDeploymentModels(ctx, req.(*ListDeploymentModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_ListCPUSizes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCPUSizesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).ListCPUSizes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/ListCPUSizes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).ListCPUSizes(ctx, req.(*ListCPUSizesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_CalculateDeploymentSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateDeploymentSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).CalculateDeploymentSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/CalculateDeploymentSize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).CalculateDeploymentSize(ctx, req.(*CalculateDeploymentSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_RecommendDeploymentSize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeploymentSizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).RecommendDeploymentSize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/RecommendDeploymentSize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).RecommendDeploymentSize(ctx, req.(*DeploymentSizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetConnectDriverInstructions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetConnectDriverInstructions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetConnectDriverInstructions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetConnectDriverInstructions(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetImportDataInstructions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetImportDataInstructions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetImportDataInstructions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetImportDataInstructions(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_CalculateDeploymentPrice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeploymentPriceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).CalculateDeploymentPrice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/CalculateDeploymentPrice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).CalculateDeploymentPrice(ctx, req.(*DeploymentPriceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataService_GetDeploymentFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeploymentFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataServiceServer).GetDeploymentFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.data.v1.DataService/GetDeploymentFeatures",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataServiceServer).GetDeploymentFeatures(ctx, req.(*DeploymentFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.data.v1.DataService",
	HandlerType: (*DataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _DataService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListDeployments",
			Handler:    _DataService_ListDeployments_Handler,
		},
		{
			MethodName: "GetDeployment",
			Handler:    _DataService_GetDeployment_Handler,
		},
		{
			MethodName: "CreateDeployment",
			Handler:    _DataService_CreateDeployment_Handler,
		},
		{
			MethodName: "UpdateDeployment",
			Handler:    _DataService_UpdateDeployment_Handler,
		},
		{
			MethodName: "DeleteDeployment",
			Handler:    _DataService_DeleteDeployment_Handler,
		},
		{
			MethodName: "GetDeploymentCredentials",
			Handler:    _DataService_GetDeploymentCredentials_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _DataService_ListVersions_Handler,
		},
		{
			MethodName: "GetDefaultVersion",
			Handler:    _DataService_GetDefaultVersion_Handler,
		},
		{
			MethodName: "GetServersSpecLimits",
			Handler:    _DataService_GetServersSpecLimits_Handler,
		},
		{
			MethodName: "ListNodeSizes",
			Handler:    _DataService_ListNodeSizes_Handler,
		},
		{
			MethodName: "ListDeploymentModels",
			Handler:    _DataService_ListDeploymentModels_Handler,
		},
		{
			MethodName: "ListCPUSizes",
			Handler:    _DataService_ListCPUSizes_Handler,
		},
		{
			MethodName: "CalculateDeploymentSize",
			Handler:    _DataService_CalculateDeploymentSize_Handler,
		},
		{
			MethodName: "RecommendDeploymentSize",
			Handler:    _DataService_RecommendDeploymentSize_Handler,
		},
		{
			MethodName: "GetConnectDriverInstructions",
			Handler:    _DataService_GetConnectDriverInstructions_Handler,
		},
		{
			MethodName: "GetImportDataInstructions",
			Handler:    _DataService_GetImportDataInstructions_Handler,
		},
		{
			MethodName: "CalculateDeploymentPrice",
			Handler:    _DataService_CalculateDeploymentPrice_Handler,
		},
		{
			MethodName: "GetDeploymentFeatures",
			Handler:    _DataService_GetDeploymentFeatures_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "data.proto",
}

func (m *Deployment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentRecommendations) > 0 {
		for iNdEx := len(m.DeploymentRecommendations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DeploymentRecommendations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1f
			i--
			dAtA[i] = 0xaa
		}
	}
	if m.BackupRestore != nil {
		{
			size, err := m.BackupRestore.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x8a
	}
	if m.Expiration != nil {
		{
			size, err := m.Expiration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xea
	}
	if m.Size_ != nil {
		{
			size, err := m.Size_.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd2
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xca
	}
	if len(m.IamproviderId) > 0 {
		i -= len(m.IamproviderId)
		copy(dAtA[i:], m.IamproviderId)
		i = encodeVarintData(dAtA, i, uint64(len(m.IamproviderId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xe2
	}
	if len(m.CustomImage) > 0 {
		i -= len(m.CustomImage)
		copy(dAtA[i:], m.CustomImage)
		i = encodeVarintData(dAtA, i, uint64(len(m.CustomImage)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xda
	}
	if m.Model != nil {
		{
			size, err := m.Model.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xd2
	}
	if len(m.IpwhitelistId) > 0 {
		i -= len(m.IpwhitelistId)
		copy(dAtA[i:], m.IpwhitelistId)
		i = encodeVarintData(dAtA, i, uint64(len(m.IpwhitelistId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xca
	}
	if m.ReplaceVersionBy != nil {
		{
			size, err := m.ReplaceVersionBy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xc2
	}
	if m.Servers != nil {
		{
			size, err := m.Servers.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xba
	}
	if m.Certificates != nil {
		{
			size, err := m.Certificates.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb2
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintData(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.AcceptedTermsAndConditionsId) > 0 {
		i -= len(m.AcceptedTermsAndConditionsId)
		copy(dAtA[i:], m.AcceptedTermsAndConditionsId)
		i = encodeVarintData(dAtA, i, uint64(len(m.AcceptedTermsAndConditionsId)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintData(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.SupportPlanId) > 0 {
		i -= len(m.SupportPlanId)
		copy(dAtA[i:], m.SupportPlanId)
		i = encodeVarintData(dAtA, i, uint64(len(m.SupportPlanId)))
		i--
		dAtA[i] = 0x52
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintData(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintData(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintData(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_CertificateSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_CertificateSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_CertificateSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AlternateDnsNames) > 0 {
		for iNdEx := len(m.AlternateDnsNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.AlternateDnsNames[iNdEx])
			copy(dAtA[i:], m.AlternateDnsNames[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.AlternateDnsNames[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.CaCertificateId) > 0 {
		i -= len(m.CaCertificateId)
		copy(dAtA[i:], m.CaCertificateId)
		i = encodeVarintData(dAtA, i, uint64(len(m.CaCertificateId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_ServersSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_ServersSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_ServersSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DbserverArgs) > 0 {
		for iNdEx := len(m.DbserverArgs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DbserverArgs[iNdEx])
			copy(dAtA[i:], m.DbserverArgs[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.DbserverArgs[iNdEx])))
			i--
			dAtA[i] = 0x72
		}
	}
	if m.DbserverDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverDiskSize))
		i--
		dAtA[i] = 0x68
	}
	if m.DbserverMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverMemorySize))
		i--
		dAtA[i] = 0x60
	}
	if m.Dbservers != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Dbservers))
		i--
		dAtA[i] = 0x58
	}
	if len(m.CoordinatorArgs) > 0 {
		for iNdEx := len(m.CoordinatorArgs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.CoordinatorArgs[iNdEx])
			copy(dAtA[i:], m.CoordinatorArgs[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.CoordinatorArgs[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.CoordinatorMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.CoordinatorMemorySize))
		i--
		dAtA[i] = 0x10
	}
	if m.Coordinators != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Coordinators))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_ModelSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_ModelSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_ModelSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NodeDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeDiskSize))
		i--
		dAtA[i] = 0x20
	}
	if m.NodeCount != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeCount))
		i--
		dAtA[i] = 0x18
	}
	if len(m.NodeSizeId) > 0 {
		i -= len(m.NodeSizeId)
		copy(dAtA[i:], m.NodeSizeId)
		i = encodeVarintData(dAtA, i, uint64(len(m.NodeSizeId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Model) > 0 {
		i -= len(m.Model)
		copy(dAtA[i:], m.Model)
		i = encodeVarintData(dAtA, i, uint64(len(m.Model)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_ServerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_ServerStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_ServerStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DataVolumeInfo != nil {
		{
			size, err := m.DataVolumeInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.LastStartedAt != nil {
		{
			size, err := m.LastStartedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintData(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Upgrading {
		i--
		if m.Upgrading {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.Ok {
		i--
		if m.Ok {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.Creating {
		i--
		if m.Creating {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.Failed {
		i--
		if m.Failed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.MemberOfCluster {
		i--
		if m.MemberOfCluster {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.Ready {
		i--
		if m.Ready {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintData(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintData(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintData(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_Status) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_Status) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BackupUploadInProgress {
		i--
		if m.BackupUploadInProgress {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb0
	}
	if m.TotalBackupSizeBytes != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.TotalBackupSizeBytes))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa8
	}
	if m.BackupRestoreStatus != nil {
		{
			size, err := m.BackupRestoreStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if len(m.EndpointSelfSigned) > 0 {
		i -= len(m.EndpointSelfSigned)
		copy(dAtA[i:], m.EndpointSelfSigned)
		i = encodeVarintData(dAtA, i, uint64(len(m.EndpointSelfSigned)))
		i--
		dAtA[i] = 0x52
	}
	if m.Bootstrapped {
		i--
		if m.Bootstrapped {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.BootstrappedAt != nil {
		{
			size, err := m.BootstrappedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if len(m.Servers) > 0 {
		for iNdEx := len(m.Servers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Servers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.ServerVersions) > 0 {
		for iNdEx := len(m.ServerVersions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ServerVersions[iNdEx])
			copy(dAtA[i:], m.ServerVersions[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.ServerVersions[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Upgrading {
		i--
		if m.Upgrading {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Ready {
		i--
		if m.Ready {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Created {
		i--
		if m.Created {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintData(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintData(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_BackupRestoreStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_BackupRestoreStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_BackupRestoreStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.FailureReason) > 0 {
		i -= len(m.FailureReason)
		copy(dAtA[i:], m.FailureReason)
		i = encodeVarintData(dAtA, i, uint64(len(m.FailureReason)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintData(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Restoring {
		i--
		if m.Restoring {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.Revision != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Revision))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_Expiration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_Expiration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_Expiration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.LastWarningEmailSendTo) > 0 {
		for iNdEx := len(m.LastWarningEmailSendTo) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.LastWarningEmailSendTo[iNdEx])
			copy(dAtA[i:], m.LastWarningEmailSendTo[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.LastWarningEmailSendTo[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.LastWarningEmailSendAt != nil {
		{
			size, err := m.LastWarningEmailSendAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintData(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x12
	}
	if m.ExpiresAt != nil {
		{
			size, err := m.ExpiresAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deployment_BackupRestoreSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deployment_BackupRestoreSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deployment_BackupRestoreSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.BackupId) > 0 {
		i -= len(m.BackupId)
		copy(dAtA[i:], m.BackupId)
		i = encodeVarintData(dAtA, i, uint64(len(m.BackupId)))
		i--
		dAtA[i] = 0x52
	}
	if m.LastUpdatedAt != nil {
		{
			size, err := m.LastUpdatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Revision != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Revision))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NodeSize) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSize) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeSize) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DiskSizes) > 0 {
		dAtA20 := make([]byte, len(m.DiskSizes)*10)
		var j19 int
		for _, num1 := range m.DiskSizes {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA20[j19] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j19++
			}
			dAtA20[j19] = uint8(num)
			j19++
		}
		i -= j19
		copy(dAtA[i:], dAtA20[:j19])
		i = encodeVarintData(dAtA, i, uint64(j19))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.CpuSize) > 0 {
		i -= len(m.CpuSize)
		copy(dAtA[i:], m.CpuSize)
		i = encodeVarintData(dAtA, i, uint64(len(m.CpuSize)))
		i--
		dAtA[i] = 0x32
	}
	if m.MaxDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.MaxDiskSize))
		i--
		dAtA[i] = 0x28
	}
	if m.MinDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.MinDiskSize))
		i--
		dAtA[i] = 0x20
	}
	if m.MemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.MemorySize))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintData(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NodeSizeList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSizeList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeSizeList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NodeSizesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeSizesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeSizesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintData(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentModel) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentModel) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentModel) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintData(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentModelList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentModelList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentModelList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListDeploymentModelsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListDeploymentModelsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListDeploymentModelsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CPUSize) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CPUSize) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CPUSize) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintData(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CPUSizeList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CPUSizeList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CPUSizeList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListCPUSizesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListCPUSizesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListCPUSizesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentCredentialsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentCredentialsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentCredentialsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintData(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintData(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentCredentials) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentCredentials) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentCredentials) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintData(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintData(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Budget != nil {
		{
			size, err := m.Budget.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Version) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Version) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Version) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReplaceBy != nil {
		{
			size, err := m.ReplaceBy.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintData(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReplaceVersionBy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplaceVersionBy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplaceVersionBy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Reason) > 0 {
		i -= len(m.Reason)
		copy(dAtA[i:], m.Reason)
		i = encodeVarintData(dAtA, i, uint64(len(m.Reason)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintData(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *VersionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VersionList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *VersionList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListVersionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListVersionsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListVersionsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CurrentVersion) > 0 {
		i -= len(m.CurrentVersion)
		copy(dAtA[i:], m.CurrentVersion)
		i = encodeVarintData(dAtA, i, uint64(len(m.CurrentVersion)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintData(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecLimitsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecLimitsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecLimitsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintData(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecLimits) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecLimits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecLimits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NodeCount != nil {
		{
			size, err := m.NodeCount.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.NodeMemorySize != nil {
		{
			size, err := m.NodeMemorySize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.DbserverDiskSize != nil {
		{
			size, err := m.DbserverDiskSize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.DbserverMemorySize != nil {
		{
			size, err := m.DbserverMemorySize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.Dbservers != nil {
		{
			size, err := m.Dbservers.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.CoordinatorMemorySize != nil {
		{
			size, err := m.CoordinatorMemorySize.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Coordinators != nil {
		{
			size, err := m.Coordinators.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServersSpecLimits_Limits) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServersSpecLimits_Limits) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServersSpecLimits_Limits) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AllowedValues) > 0 {
		dAtA32 := make([]byte, len(m.AllowedValues)*10)
		var j31 int
		for _, num1 := range m.AllowedValues {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA32[j31] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j31++
			}
			dAtA32[j31] = uint8(num)
			j31++
		}
		i -= j31
		copy(dAtA[i:], dAtA32[:j31])
		i = encodeVarintData(dAtA, i, uint64(j31))
		i--
		dAtA[i] = 0x1a
	}
	if m.Max != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Max))
		i--
		dAtA[i] = 0x10
	}
	if m.Min != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Min))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CalculateDeploymentSizeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CalculateDeploymentSizeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CalculateDeploymentSizeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x3
		i--
		dAtA[i] = 0x92
	}
	if m.NodeDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeDiskSize))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x90
	}
	if m.NodeCount != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeCount))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if len(m.NodeSizeId) > 0 {
		i -= len(m.NodeSizeId)
		copy(dAtA[i:], m.NodeSizeId)
		i = encodeVarintData(dAtA, i, uint64(len(m.NodeSizeId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if len(m.Model) > 0 {
		i -= len(m.Model)
		copy(dAtA[i:], m.Model)
		i = encodeVarintData(dAtA, i, uint64(len(m.Model)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.DbserverDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverDiskSize))
		i--
		dAtA[i] = 0x68
	}
	if m.DbserverMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverMemorySize))
		i--
		dAtA[i] = 0x60
	}
	if m.Dbservers != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Dbservers))
		i--
		dAtA[i] = 0x58
	}
	if m.CoordinatorMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.CoordinatorMemorySize))
		i--
		dAtA[i] = 0x10
	}
	if m.Coordinators != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Coordinators))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentSize) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentSize) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentSize) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TotalDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.TotalDiskSize))
		i--
		dAtA[i] = 0x60
	}
	if m.TotalMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.TotalMemorySize))
		i--
		dAtA[i] = 0x58
	}
	if m.AgentDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.AgentDiskSize))
		i--
		dAtA[i] = 0x18
	}
	if m.AgentMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.AgentMemorySize))
		i--
		dAtA[i] = 0x10
	}
	if m.Agents != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Agents))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentSizeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentSizeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentSizeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if m.ReplicationFactor != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.ReplicationFactor))
		i--
		dAtA[i] = 0x60
	}
	if m.GrowthRate != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.GrowthRate))))
		i--
		dAtA[i] = 0x5d
	}
	if m.AccessUpdatePercentage != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.AccessUpdatePercentage))))
		i--
		dAtA[i] = 0x55
	}
	if m.AccessCreatePercentage != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.AccessCreatePercentage))))
		i--
		dAtA[i] = 0x4d
	}
	if m.AccessReadPercentage != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.AccessReadPercentage))))
		i--
		dAtA[i] = 0x45
	}
	if m.WorkingSetPercentage != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.WorkingSetPercentage))))
		i--
		dAtA[i] = 0x3d
	}
	if m.NumberOfColumns != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NumberOfColumns))
		i--
		dAtA[i] = 0x30
	}
	if m.NumberOfDocuments != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NumberOfDocuments))
		i--
		dAtA[i] = 0x28
	}
	if len(m.FileFormat) > 0 {
		i -= len(m.FileFormat)
		copy(dAtA[i:], m.FileFormat)
		i = encodeVarintData(dAtA, i, uint64(len(m.FileFormat)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Model) > 0 {
		i -= len(m.Model)
		copy(dAtA[i:], m.Model)
		i = encodeVarintData(dAtA, i, uint64(len(m.Model)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Usecase) > 0 {
		i -= len(m.Usecase)
		copy(dAtA[i:], m.Usecase)
		i = encodeVarintData(dAtA, i, uint64(len(m.Usecase)))
		i--
		dAtA[i] = 0x12
	}
	if m.DatasetSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DatasetSize))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentSizeRecommendation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentSizeRecommendation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentSizeRecommendation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExceedsPlatform {
		i--
		if m.ExceedsPlatform {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.ExceedsQuota {
		i--
		if m.ExceedsQuota {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.NodeCount != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeCount))
		i--
		dAtA[i] = 0x68
	}
	if m.NodeDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeDiskSize))
		i--
		dAtA[i] = 0x60
	}
	if m.NodeMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeMemorySize))
		i--
		dAtA[i] = 0x58
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Request != nil {
		{
			size, err := m.Request.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DataVolumeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataVolumeInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataVolumeInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MeasuredAt != nil {
		{
			size, err := m.MeasuredAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.AvailableBytes != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.AvailableBytes))
		i--
		dAtA[i] = 0x18
	}
	if m.UsedBytes != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.UsedBytes))
		i--
		dAtA[i] = 0x10
	}
	if m.TotalBytes != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.TotalBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConnectDriverInstructions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectDriverInstructions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectDriverInstructions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Drivers) > 0 {
		for iNdEx := len(m.Drivers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Drivers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ConnectDriverInstructions_DriverInstructions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectDriverInstructions_DriverInstructions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConnectDriverInstructions_DriverInstructions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DriverUrl) > 0 {
		i -= len(m.DriverUrl)
		copy(dAtA[i:], m.DriverUrl)
		i = encodeVarintData(dAtA, i, uint64(len(m.DriverUrl)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Remarks) > 0 {
		for iNdEx := len(m.Remarks) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Remarks[iNdEx])
			copy(dAtA[i:], m.Remarks[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.Remarks[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Code) > 0 {
		for iNdEx := len(m.Code) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Code[iNdEx])
			copy(dAtA[i:], m.Code[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.Code[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImportDataInstructions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportDataInstructions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImportDataInstructions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ImportDump) > 0 {
		for iNdEx := len(m.ImportDump) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ImportDump[iNdEx])
			copy(dAtA[i:], m.ImportDump[iNdEx])
			i = encodeVarintData(dAtA, i, uint64(len(m.ImportDump[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentPriceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentPriceRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentPriceRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DbserverDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverDiskSize))
		i--
		dAtA[i] = 0x70
	}
	if m.DbserverMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.DbserverMemorySize))
		i--
		dAtA[i] = 0x68
	}
	if m.Dbservers != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Dbservers))
		i--
		dAtA[i] = 0x60
	}
	if m.CoordinatorMemorySize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.CoordinatorMemorySize))
		i--
		dAtA[i] = 0x58
	}
	if m.Coordinators != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.Coordinators))
		i--
		dAtA[i] = 0x50
	}
	if m.NodeDiskSize != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeDiskSize))
		i--
		dAtA[i] = 0x48
	}
	if m.NodeCount != 0 {
		i = encodeVarintData(dAtA, i, uint64(m.NodeCount))
		i--
		dAtA[i] = 0x40
	}
	if len(m.NodeSizeId) > 0 {
		i -= len(m.NodeSizeId)
		copy(dAtA[i:], m.NodeSizeId)
		i = encodeVarintData(dAtA, i, uint64(len(m.NodeSizeId)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Model) > 0 {
		i -= len(m.Model)
		copy(dAtA[i:], m.Model)
		i = encodeVarintData(dAtA, i, uint64(len(m.Model)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.CloudRegionId) > 0 {
		i -= len(m.CloudRegionId)
		copy(dAtA[i:], m.CloudRegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.CloudRegionId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.CloudProviderId) > 0 {
		i -= len(m.CloudProviderId)
		copy(dAtA[i:], m.CloudProviderId)
		i = encodeVarintData(dAtA, i, uint64(len(m.CloudProviderId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.SupportPlanId) > 0 {
		i -= len(m.SupportPlanId)
		copy(dAtA[i:], m.SupportPlanId)
		i = encodeVarintData(dAtA, i, uint64(len(m.SupportPlanId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintData(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentPrice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentPrice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentPrice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CurrencyId) > 0 {
		i -= len(m.CurrencyId)
		copy(dAtA[i:], m.CurrencyId)
		i = encodeVarintData(dAtA, i, uint64(len(m.CurrencyId)))
		i--
		dAtA[i] = 0x22
	}
	if m.BackupPrice != nil {
		{
			size, err := m.BackupPrice.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintData(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.NetworkTransferPrices) > 0 {
		for iNdEx := len(m.NetworkTransferPrices) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NetworkTransferPrices[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintData(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.PricePerHour != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.PricePerHour))))
		i--
		dAtA[i] = 0xd
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentPrice_NetworkTransferPrice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentPrice_NetworkTransferPrice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentPrice_NetworkTransferPrice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintData(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x1a
	}
	if m.EgressPricePerGb != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.EgressPricePerGb))))
		i--
		dAtA[i] = 0x15
	}
	if m.IngressPricePerGb != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.IngressPricePerGb))))
		i--
		dAtA[i] = 0xd
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentPrice_BackupPrice) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentPrice_BackupPrice) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentPrice_BackupPrice) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.PricePerGbPerHour != 0 {
		i -= 4
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.PricePerGbPerHour))))
		i--
		dAtA[i] = 0xd
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentFeatures) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentFeatures) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentFeatures) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Iamprovider {
		i--
		if m.Iamprovider {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DeploymentFeaturesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeploymentFeaturesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeploymentFeaturesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.NodeSizeId) > 0 {
		i -= len(m.NodeSizeId)
		copy(dAtA[i:], m.NodeSizeId)
		i = encodeVarintData(dAtA, i, uint64(len(m.NodeSizeId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Model) > 0 {
		i -= len(m.Model)
		copy(dAtA[i:], m.Model)
		i = encodeVarintData(dAtA, i, uint64(len(m.Model)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintData(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintData(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintData(dAtA []byte, offset int, v uint64) int {
	offset -= sovData(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Deployment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.SupportPlanId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.AcceptedTermsAndConditionsId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	if m.Certificates != nil {
		l = m.Certificates.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.Servers != nil {
		l = m.Servers.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.ReplaceVersionBy != nil {
		l = m.ReplaceVersionBy.Size()
		n += 2 + l + sovData(uint64(l))
	}
	l = len(m.IpwhitelistId)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	if m.Model != nil {
		l = m.Model.Size()
		n += 2 + l + sovData(uint64(l))
	}
	l = len(m.CustomImage)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	l = len(m.IamproviderId)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.Size_ != nil {
		l = m.Size_.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.Expiration != nil {
		l = m.Expiration.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.BackupRestore != nil {
		l = m.BackupRestore.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if len(m.DeploymentRecommendations) > 0 {
		for _, e := range m.DeploymentRecommendations {
			l = e.Size()
			n += 2 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_CertificateSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CaCertificateId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.AlternateDnsNames) > 0 {
		for _, s := range m.AlternateDnsNames {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_ServersSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Coordinators != 0 {
		n += 1 + sovData(uint64(m.Coordinators))
	}
	if m.CoordinatorMemorySize != 0 {
		n += 1 + sovData(uint64(m.CoordinatorMemorySize))
	}
	if len(m.CoordinatorArgs) > 0 {
		for _, s := range m.CoordinatorArgs {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.Dbservers != 0 {
		n += 1 + sovData(uint64(m.Dbservers))
	}
	if m.DbserverMemorySize != 0 {
		n += 1 + sovData(uint64(m.DbserverMemorySize))
	}
	if m.DbserverDiskSize != 0 {
		n += 1 + sovData(uint64(m.DbserverDiskSize))
	}
	if len(m.DbserverArgs) > 0 {
		for _, s := range m.DbserverArgs {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_ModelSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Model)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.NodeSizeId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.NodeCount != 0 {
		n += 1 + sovData(uint64(m.NodeCount))
	}
	if m.NodeDiskSize != 0 {
		n += 1 + sovData(uint64(m.NodeDiskSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_ServerStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Ready {
		n += 2
	}
	if m.MemberOfCluster {
		n += 2
	}
	if m.Failed {
		n += 2
	}
	if m.Creating {
		n += 2
	}
	if m.Ok {
		n += 2
	}
	if m.Upgrading {
		n += 2
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.LastStartedAt != nil {
		l = m.LastStartedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.DataVolumeInfo != nil {
		l = m.DataVolumeInfo.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.Created {
		n += 2
	}
	if m.Ready {
		n += 2
	}
	if m.Upgrading {
		n += 2
	}
	if len(m.ServerVersions) > 0 {
		for _, s := range m.ServerVersions {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if len(m.Servers) > 0 {
		for _, e := range m.Servers {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.BootstrappedAt != nil {
		l = m.BootstrappedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Bootstrapped {
		n += 2
	}
	l = len(m.EndpointSelfSigned)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.BackupRestoreStatus != nil {
		l = m.BackupRestoreStatus.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.TotalBackupSizeBytes != 0 {
		n += 2 + sovData(uint64(m.TotalBackupSizeBytes))
	}
	if m.BackupUploadInProgress {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_BackupRestoreStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Revision != 0 {
		n += 1 + sovData(uint64(m.Revision))
	}
	if m.Restoring {
		n += 2
	}
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.FailureReason)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_Expiration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExpiresAt != nil {
		l = m.ExpiresAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.LastWarningEmailSendAt != nil {
		l = m.LastWarningEmailSendAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.LastWarningEmailSendTo) > 0 {
		for _, s := range m.LastWarningEmailSendTo {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deployment_BackupRestoreSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Revision != 0 {
		n += 1 + sovData(uint64(m.Revision))
	}
	if m.LastUpdatedAt != nil {
		l = m.LastUpdatedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.BackupId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeSize) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.MemorySize != 0 {
		n += 1 + sovData(uint64(m.MemorySize))
	}
	if m.MinDiskSize != 0 {
		n += 1 + sovData(uint64(m.MinDiskSize))
	}
	if m.MaxDiskSize != 0 {
		n += 1 + sovData(uint64(m.MaxDiskSize))
	}
	l = len(m.CpuSize)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.DiskSizes) > 0 {
		l = 0
		for _, e := range m.DiskSizes {
			l += sovData(uint64(e))
		}
		n += 1 + sovData(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeSizeList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NodeSizesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentModel) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentModelList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListDeploymentModelsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CPUSize) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CPUSizeList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListCPUSizesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentCredentialsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentCredentials) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.Budget != nil {
		l = m.Budget.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Version) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.ReplaceBy != nil {
		l = m.ReplaceBy.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReplaceVersionBy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Reason)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VersionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListVersionsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.CurrentVersion)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecLimitsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecLimits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Coordinators != nil {
		l = m.Coordinators.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.CoordinatorMemorySize != nil {
		l = m.CoordinatorMemorySize.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Dbservers != nil {
		l = m.Dbservers.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.DbserverMemorySize != nil {
		l = m.DbserverMemorySize.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.DbserverDiskSize != nil {
		l = m.DbserverDiskSize.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.NodeMemorySize != nil {
		l = m.NodeMemorySize.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.NodeCount != nil {
		l = m.NodeCount.Size()
		n += 2 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ServersSpecLimits_Limits) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Min != 0 {
		n += 1 + sovData(uint64(m.Min))
	}
	if m.Max != 0 {
		n += 1 + sovData(uint64(m.Max))
	}
	if len(m.AllowedValues) > 0 {
		l = 0
		for _, e := range m.AllowedValues {
			l += sovData(uint64(e))
		}
		n += 1 + sovData(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CalculateDeploymentSizeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Coordinators != 0 {
		n += 1 + sovData(uint64(m.Coordinators))
	}
	if m.CoordinatorMemorySize != 0 {
		n += 1 + sovData(uint64(m.CoordinatorMemorySize))
	}
	if m.Dbservers != 0 {
		n += 1 + sovData(uint64(m.Dbservers))
	}
	if m.DbserverMemorySize != 0 {
		n += 1 + sovData(uint64(m.DbserverMemorySize))
	}
	if m.DbserverDiskSize != 0 {
		n += 1 + sovData(uint64(m.DbserverDiskSize))
	}
	l = len(m.Model)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	l = len(m.NodeSizeId)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	if m.NodeCount != 0 {
		n += 2 + sovData(uint64(m.NodeCount))
	}
	if m.NodeDiskSize != 0 {
		n += 2 + sovData(uint64(m.NodeDiskSize))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentSize) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Agents != 0 {
		n += 1 + sovData(uint64(m.Agents))
	}
	if m.AgentMemorySize != 0 {
		n += 1 + sovData(uint64(m.AgentMemorySize))
	}
	if m.AgentDiskSize != 0 {
		n += 1 + sovData(uint64(m.AgentDiskSize))
	}
	if m.TotalMemorySize != 0 {
		n += 1 + sovData(uint64(m.TotalMemorySize))
	}
	if m.TotalDiskSize != 0 {
		n += 1 + sovData(uint64(m.TotalDiskSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentSizeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.DatasetSize != 0 {
		n += 1 + sovData(uint64(m.DatasetSize))
	}
	l = len(m.Usecase)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Model)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.FileFormat)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.NumberOfDocuments != 0 {
		n += 1 + sovData(uint64(m.NumberOfDocuments))
	}
	if m.NumberOfColumns != 0 {
		n += 1 + sovData(uint64(m.NumberOfColumns))
	}
	if m.WorkingSetPercentage != 0 {
		n += 5
	}
	if m.AccessReadPercentage != 0 {
		n += 5
	}
	if m.AccessCreatePercentage != 0 {
		n += 5
	}
	if m.AccessUpdatePercentage != 0 {
		n += 5
	}
	if m.GrowthRate != 0 {
		n += 5
	}
	if m.ReplicationFactor != 0 {
		n += 1 + sovData(uint64(m.ReplicationFactor))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 2 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentSizeRecommendation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.NodeMemorySize != 0 {
		n += 1 + sovData(uint64(m.NodeMemorySize))
	}
	if m.NodeDiskSize != 0 {
		n += 1 + sovData(uint64(m.NodeDiskSize))
	}
	if m.NodeCount != 0 {
		n += 1 + sovData(uint64(m.NodeCount))
	}
	if m.ExceedsQuota {
		n += 3
	}
	if m.ExceedsPlatform {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataVolumeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalBytes != 0 {
		n += 1 + sovData(uint64(m.TotalBytes))
	}
	if m.UsedBytes != 0 {
		n += 1 + sovData(uint64(m.UsedBytes))
	}
	if m.AvailableBytes != 0 {
		n += 1 + sovData(uint64(m.AvailableBytes))
	}
	if m.MeasuredAt != nil {
		l = m.MeasuredAt.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectDriverInstructions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Drivers) > 0 {
		for _, e := range m.Drivers {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConnectDriverInstructions_DriverInstructions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if len(m.Code) > 0 {
		for _, s := range m.Code {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if len(m.Remarks) > 0 {
		for _, s := range m.Remarks {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	l = len(m.DriverUrl)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImportDataInstructions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ImportDump) > 0 {
		for _, s := range m.ImportDump {
			l = len(s)
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentPriceRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.SupportPlanId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.CloudProviderId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.CloudRegionId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Model)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.NodeSizeId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.NodeCount != 0 {
		n += 1 + sovData(uint64(m.NodeCount))
	}
	if m.NodeDiskSize != 0 {
		n += 1 + sovData(uint64(m.NodeDiskSize))
	}
	if m.Coordinators != 0 {
		n += 1 + sovData(uint64(m.Coordinators))
	}
	if m.CoordinatorMemorySize != 0 {
		n += 1 + sovData(uint64(m.CoordinatorMemorySize))
	}
	if m.Dbservers != 0 {
		n += 1 + sovData(uint64(m.Dbservers))
	}
	if m.DbserverMemorySize != 0 {
		n += 1 + sovData(uint64(m.DbserverMemorySize))
	}
	if m.DbserverDiskSize != 0 {
		n += 1 + sovData(uint64(m.DbserverDiskSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentPrice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PricePerHour != 0 {
		n += 5
	}
	if len(m.NetworkTransferPrices) > 0 {
		for _, e := range m.NetworkTransferPrices {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.BackupPrice != nil {
		l = m.BackupPrice.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.CurrencyId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentPrice_NetworkTransferPrice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IngressPricePerGb != 0 {
		n += 5
	}
	if m.EgressPricePerGb != 0 {
		n += 5
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentPrice_BackupPrice) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PricePerGbPerHour != 0 {
		n += 5
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentFeatures) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Iamprovider {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeploymentFeaturesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.Model)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.NodeSizeId)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovData(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozData(x uint64) (n int) {
	return sovData(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Deployment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Deployment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Deployment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportPlanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SupportPlanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptedTermsAndConditionsId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AcceptedTermsAndConditionsId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 102:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Certificates == nil {
				m.Certificates = &Deployment_CertificateSpec{}
			}
			if err := m.Certificates.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 103:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Servers == nil {
				m.Servers = &Deployment_ServersSpec{}
			}
			if err := m.Servers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 104:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplaceVersionBy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplaceVersionBy == nil {
				m.ReplaceVersionBy = &ReplaceVersionBy{}
			}
			if err := m.ReplaceVersionBy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 105:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpwhitelistId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IpwhitelistId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 106:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Model", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Model == nil {
				m.Model = &Deployment_ModelSpec{}
			}
			if err := m.Model.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 107:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomImage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CustomImage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 108:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IamproviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IamproviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 201:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &Deployment_Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 202:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Size_ == nil {
				m.Size_ = &DeploymentSize{}
			}
			if err := m.Size_.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 301:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expiration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expiration == nil {
				m.Expiration = &Deployment_Expiration{}
			}
			if err := m.Expiration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 401:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupRestore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BackupRestore == nil {
				m.BackupRestore = &Deployment_BackupRestoreSpec{}
			}
			if err := m.BackupRestore.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 501:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentRecommendations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentRecommendations = append(m.DeploymentRecommendations, &DeploymentSizeRecommendation{})
			if err := m.DeploymentRecommendations[len(m.DeploymentRecommendations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_CertificateSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificateSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificateSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificateId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificateId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlternateDnsNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlternateDnsNames = append(m.AlternateDnsNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_ServersSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Coordinators", wireType)
			}
			m.Coordinators = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Coordinators |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorMemorySize", wireType)
			}
			m.CoordinatorMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CoordinatorMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorArgs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CoordinatorArgs = append(m.CoordinatorArgs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dbservers", wireType)
			}
			m.Dbservers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Dbservers |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverMemorySize", wireType)
			}
			m.DbserverMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverDiskSize", wireType)
			}
			m.DbserverDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverArgs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DbserverArgs = append(m.DbserverArgs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_ModelSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ModelSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ModelSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Model", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Model = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeSizeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeSizeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCount", wireType)
			}
			m.NodeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeDiskSize", wireType)
			}
			m.NodeDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_ServerStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ready", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ready = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberOfCluster", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MemberOfCluster = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Failed = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Creating", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Creating = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ok", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ok = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Upgrading", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Upgrading = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastStartedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastStartedAt == nil {
				m.LastStartedAt = &types.Timestamp{}
			}
			if err := m.LastStartedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataVolumeInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DataVolumeInfo == nil {
				m.DataVolumeInfo = &DataVolumeInfo{}
			}
			if err := m.DataVolumeInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Created", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Created = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ready", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ready = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Upgrading", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Upgrading = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerVersions = append(m.ServerVersions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Servers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Servers = append(m.Servers, &Deployment_ServerStatus{})
			if err := m.Servers[len(m.Servers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BootstrappedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BootstrappedAt == nil {
				m.BootstrappedAt = &types.Timestamp{}
			}
			if err := m.BootstrappedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bootstrapped", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Bootstrapped = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndpointSelfSigned", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndpointSelfSigned = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupRestoreStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BackupRestoreStatus == nil {
				m.BackupRestoreStatus = &Deployment_BackupRestoreStatus{}
			}
			if err := m.BackupRestoreStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 101:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBackupSizeBytes", wireType)
			}
			m.TotalBackupSizeBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBackupSizeBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 102:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupUploadInProgress", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BackupUploadInProgress = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_BackupRestoreStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupRestoreStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupRestoreStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			m.Revision = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Revision |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restoring", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Restoring = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailureReason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailureReason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_Expiration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Expiration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Expiration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiresAt == nil {
				m.ExpiresAt = &types.Timestamp{}
			}
			if err := m.ExpiresAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWarningEmailSendAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastWarningEmailSendAt == nil {
				m.LastWarningEmailSendAt = &types.Timestamp{}
			}
			if err := m.LastWarningEmailSendAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastWarningEmailSendTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastWarningEmailSendTo = append(m.LastWarningEmailSendTo, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deployment_BackupRestoreSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupRestoreSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupRestoreSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			m.Revision = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Revision |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdatedAt == nil {
				m.LastUpdatedAt = &types.Timestamp{}
			}
			if err := m.LastUpdatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeSize) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeSize: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeSize: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemorySize", wireType)
			}
			m.MemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinDiskSize", wireType)
			}
			m.MinDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxDiskSize", wireType)
			}
			m.MaxDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CpuSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CpuSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowData
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.DiskSizes = append(m.DiskSizes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowData
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthData
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthData
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.DiskSizes) == 0 {
					m.DiskSizes = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowData
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.DiskSizes = append(m.DiskSizes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskSizes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeSizeList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeSizeList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeSizeList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &NodeSize{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeSizesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeSizesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeSizesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentModel) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentModel: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentModel: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentModelList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentModelList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentModelList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &DeploymentModel{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListDeploymentModelsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListDeploymentModelsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListDeploymentModelsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CPUSize) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CPUSize: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CPUSize: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CPUSizeList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CPUSizeList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CPUSizeList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &CPUSize{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListCPUSizesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListCPUSizesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListCPUSizesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentCredentialsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentCredentialsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentCredentialsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentCredentials) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentCredentials: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentCredentials: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Deployment{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Budget", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Budget == nil {
				m.Budget = &v1.Budget{}
			}
			if err := m.Budget.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Version) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Version: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Version: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplaceBy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplaceBy == nil {
				m.ReplaceBy = &ReplaceVersionBy{}
			}
			if err := m.ReplaceBy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplaceVersionBy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplaceVersionBy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplaceVersionBy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VersionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VersionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VersionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Version{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListVersionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListVersionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListVersionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrentVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecLimitsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpecLimitsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpecLimitsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecLimits) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServersSpecLimits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServersSpecLimits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Coordinators", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Coordinators == nil {
				m.Coordinators = &ServersSpecLimits_Limits{}
			}
			if err := m.Coordinators.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorMemorySize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CoordinatorMemorySize == nil {
				m.CoordinatorMemorySize = &ServersSpecLimits_Limits{}
			}
			if err := m.CoordinatorMemorySize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dbservers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dbservers == nil {
				m.Dbservers = &ServersSpecLimits_Limits{}
			}
			if err := m.Dbservers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverMemorySize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DbserverMemorySize == nil {
				m.DbserverMemorySize = &ServersSpecLimits_Limits{}
			}
			if err := m.DbserverMemorySize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverDiskSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DbserverDiskSize == nil {
				m.DbserverDiskSize = &ServersSpecLimits_Limits{}
			}
			if err := m.DbserverDiskSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeMemorySize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeMemorySize == nil {
				m.NodeMemorySize = &ServersSpecLimits_Limits{}
			}
			if err := m.NodeMemorySize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCount", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeCount == nil {
				m.NodeCount = &ServersSpecLimits_Limits{}
			}
			if err := m.NodeCount.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServersSpecLimits_Limits) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Limits: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Limits: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			m.Min = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Min |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			m.Max = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Max |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowData
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AllowedValues = append(m.AllowedValues, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowData
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthData
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthData
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.AllowedValues) == 0 {
					m.AllowedValues = make([]int32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowData
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AllowedValues = append(m.AllowedValues, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowedValues", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CalculateDeploymentSizeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CalculateDeploymentSizeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CalculateDeploymentSizeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Coordinators", wireType)
			}
			m.Coordinators = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Coordinators |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorMemorySize", wireType)
			}
			m.CoordinatorMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CoordinatorMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dbservers", wireType)
			}
			m.Dbservers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Dbservers |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverMemorySize", wireType)
			}
			m.DbserverMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverDiskSize", wireType)
			}
			m.DbserverDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Model", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Model = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeSizeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeSizeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCount", wireType)
			}
			m.NodeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 34:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeDiskSize", wireType)
			}
			m.NodeDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 50:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentSize) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentSize: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentSize: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Agents", wireType)
			}
			m.Agents = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Agents |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentMemorySize", wireType)
			}
			m.AgentMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AgentMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentDiskSize", wireType)
			}
			m.AgentDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AgentDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalMemorySize", wireType)
			}
			m.TotalMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalDiskSize", wireType)
			}
			m.TotalDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentSizeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentSizeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentSizeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatasetSize", wireType)
			}
			m.DatasetSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DatasetSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Usecase", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Usecase = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Model", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Model = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileFormat", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FileFormat = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumberOfDocuments", wireType)
			}
			m.NumberOfDocuments = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumberOfDocuments |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumberOfColumns", wireType)
			}
			m.NumberOfColumns = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumberOfColumns |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field WorkingSetPercentage", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.WorkingSetPercentage = float32(math.Float32frombits(v))
		case 8:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessReadPercentage", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.AccessReadPercentage = float32(math.Float32frombits(v))
		case 9:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessCreatePercentage", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.AccessCreatePercentage = float32(math.Float32frombits(v))
		case 10:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessUpdatePercentage", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.AccessUpdatePercentage = float32(math.Float32frombits(v))
		case 11:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrowthRate", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.GrowthRate = float32(math.Float32frombits(v))
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationFactor", wireType)
			}
			m.ReplicationFactor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicationFactor |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentSizeRecommendation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentSizeRecommendation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentSizeRecommendation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &DeploymentSizeRequest{}
			}
			if err := m.Request.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeMemorySize", wireType)
			}
			m.NodeMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeDiskSize", wireType)
			}
			m.NodeDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCount", wireType)
			}
			m.NodeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExceedsQuota", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExceedsQuota = bool(v != 0)
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExceedsPlatform", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExceedsPlatform = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataVolumeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataVolumeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataVolumeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UsedBytes", wireType)
			}
			m.UsedBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UsedBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailableBytes", wireType)
			}
			m.AvailableBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvailableBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MeasuredAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MeasuredAt == nil {
				m.MeasuredAt = &types.Timestamp{}
			}
			if err := m.MeasuredAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectDriverInstructions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectDriverInstructions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectDriverInstructions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Drivers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Drivers = append(m.Drivers, &ConnectDriverInstructions_DriverInstructions{})
			if err := m.Drivers[len(m.Drivers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectDriverInstructions_DriverInstructions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DriverInstructions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DriverInstructions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Code = append(m.Code, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Remarks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Remarks = append(m.Remarks, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DriverUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DriverUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportDataInstructions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportDataInstructions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportDataInstructions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ImportDump", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ImportDump = append(m.ImportDump, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentPriceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentPriceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentPriceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportPlanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SupportPlanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloudProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CloudProviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloudRegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CloudRegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Model", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Model = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeSizeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeSizeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeCount", wireType)
			}
			m.NodeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeDiskSize", wireType)
			}
			m.NodeDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Coordinators", wireType)
			}
			m.Coordinators = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Coordinators |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CoordinatorMemorySize", wireType)
			}
			m.CoordinatorMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CoordinatorMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dbservers", wireType)
			}
			m.Dbservers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Dbservers |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverMemorySize", wireType)
			}
			m.DbserverMemorySize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverMemorySize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DbserverDiskSize", wireType)
			}
			m.DbserverDiskSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DbserverDiskSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentPrice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentPrice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentPrice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field PricePerHour", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.PricePerHour = float32(math.Float32frombits(v))
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkTransferPrices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkTransferPrices = append(m.NetworkTransferPrices, &DeploymentPrice_NetworkTransferPrice{})
			if err := m.NetworkTransferPrices[len(m.NetworkTransferPrices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupPrice", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BackupPrice == nil {
				m.BackupPrice = &DeploymentPrice_BackupPrice{}
			}
			if err := m.BackupPrice.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrencyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CurrencyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentPrice_NetworkTransferPrice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkTransferPrice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkTransferPrice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressPricePerGb", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.IngressPricePerGb = float32(math.Float32frombits(v))
		case 2:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field EgressPricePerGb", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.EgressPricePerGb = float32(math.Float32frombits(v))
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentPrice_BackupPrice) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupPrice: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupPrice: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field PricePerGbPerHour", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.PricePerGbPerHour = float32(math.Float32frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentFeatures) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentFeatures: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentFeatures: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iamprovider", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Iamprovider = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeploymentFeaturesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeploymentFeaturesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeploymentFeaturesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Model", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Model = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeSizeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthData
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeSizeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipData(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowData
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthData
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthData
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowData
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipData(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthData
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthData = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowData   = fmt.Errorf("proto: integer overflow")
)
