// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: example.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// ExampleDataset represents a single example dataaset.
type ExampleDataset struct {
	// System identifier of the example dataset.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource.
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the example dataset
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the example dataset
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Guide contains description of the example dataset including several example queries.
	// Content type of guide is markdown.
	Guide string `protobuf:"bytes,6,opt,name=guide,proto3" json:"guide,omitempty"`
	// The creation timestamp of the example dataset (database object)
	// This is a read-only value.
	CreatedAt            *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ExampleDataset) Reset()         { *m = ExampleDataset{} }
func (m *ExampleDataset) String() string { return proto.CompactTextString(m) }
func (*ExampleDataset) ProtoMessage()    {}
func (*ExampleDataset) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{0}
}
func (m *ExampleDataset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDataset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDataset.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDataset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDataset.Merge(m, src)
}
func (m *ExampleDataset) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDataset) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDataset.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDataset proto.InternalMessageInfo

func (m *ExampleDataset) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ExampleDataset) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *ExampleDataset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExampleDataset) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ExampleDataset) GetGuide() string {
	if m != nil {
		return m.Guide
	}
	return ""
}

func (m *ExampleDataset) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

// ExampleDatasetInstallation represents an installation of a dataset initiated by the user.
type ExampleDatasetInstallation struct {
	// System identifier of the installation.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Identifier of the deployment that owns this installation.
	// After creation, this value cannot be changed.
	DeploymentId string `protobuf:"bytes,3,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Identifier of the example dataset which will be installed.
	// After creation, this value cannot be changed.
	ExampledatasetId string `protobuf:"bytes,4,opt,name=exampledataset_id,json=exampledatasetId,proto3" json:"exampledataset_id,omitempty"`
	// The creation timestamp of the installation.
	CreatedAt *types.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the installation
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,6,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this installation is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,7,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Status of the actual installation.
	Status               *ExampleDatasetInstallation_Status `protobuf:"bytes,100,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ExampleDatasetInstallation) Reset()         { *m = ExampleDatasetInstallation{} }
func (m *ExampleDatasetInstallation) String() string { return proto.CompactTextString(m) }
func (*ExampleDatasetInstallation) ProtoMessage()    {}
func (*ExampleDatasetInstallation) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{1}
}
func (m *ExampleDatasetInstallation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDatasetInstallation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDatasetInstallation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDatasetInstallation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDatasetInstallation.Merge(m, src)
}
func (m *ExampleDatasetInstallation) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDatasetInstallation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDatasetInstallation.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDatasetInstallation proto.InternalMessageInfo

func (m *ExampleDatasetInstallation) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ExampleDatasetInstallation) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *ExampleDatasetInstallation) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ExampleDatasetInstallation) GetExampledatasetId() string {
	if m != nil {
		return m.ExampledatasetId
	}
	return ""
}

func (m *ExampleDatasetInstallation) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *ExampleDatasetInstallation) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *ExampleDatasetInstallation) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *ExampleDatasetInstallation) GetStatus() *ExampleDatasetInstallation_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// Status of the installation.
// All members of this field are read-only.
type ExampleDatasetInstallation_Status struct {
	// Name of the database into which this example dataset was installed.
	DatabaseName string `protobuf:"bytes,1,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// The state of the installation.
	// Will be one of the following: "InProgress|Create|Ready|Failed"
	State string `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	// Set when the installation is failed.
	IsFailed bool `protobuf:"varint,4,opt,name=is_failed,json=isFailed,proto3" json:"is_failed,omitempty"`
	// Set when once the installation finished successfully and the dataset is available to be used.
	IsAvailable          bool     `protobuf:"varint,5,opt,name=is_available,json=isAvailable,proto3" json:"is_available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExampleDatasetInstallation_Status) Reset()         { *m = ExampleDatasetInstallation_Status{} }
func (m *ExampleDatasetInstallation_Status) String() string { return proto.CompactTextString(m) }
func (*ExampleDatasetInstallation_Status) ProtoMessage()    {}
func (*ExampleDatasetInstallation_Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{1, 0}
}
func (m *ExampleDatasetInstallation_Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDatasetInstallation_Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDatasetInstallation_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDatasetInstallation_Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDatasetInstallation_Status.Merge(m, src)
}
func (m *ExampleDatasetInstallation_Status) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDatasetInstallation_Status) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDatasetInstallation_Status.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDatasetInstallation_Status proto.InternalMessageInfo

func (m *ExampleDatasetInstallation_Status) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

func (m *ExampleDatasetInstallation_Status) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *ExampleDatasetInstallation_Status) GetIsFailed() bool {
	if m != nil {
		return m.IsFailed
	}
	return false
}

func (m *ExampleDatasetInstallation_Status) GetIsAvailable() bool {
	if m != nil {
		return m.IsAvailable
	}
	return false
}

// ListExampleDatasetsRequest provides an extendable list request for listing datasets.
type ListExampleDatasetsRequest struct {
	// Optional common list options, the context_id is ignored.
	Options              *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListExampleDatasetsRequest) Reset()         { *m = ListExampleDatasetsRequest{} }
func (m *ListExampleDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListExampleDatasetsRequest) ProtoMessage()    {}
func (*ListExampleDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{2}
}
func (m *ListExampleDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListExampleDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListExampleDatasetsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListExampleDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExampleDatasetsRequest.Merge(m, src)
}
func (m *ListExampleDatasetsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListExampleDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExampleDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListExampleDatasetsRequest proto.InternalMessageInfo

func (m *ListExampleDatasetsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// List of example datasets.
type ExampleDatasetList struct {
	Items                []*ExampleDataset `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ExampleDatasetList) Reset()         { *m = ExampleDatasetList{} }
func (m *ExampleDatasetList) String() string { return proto.CompactTextString(m) }
func (*ExampleDatasetList) ProtoMessage()    {}
func (*ExampleDatasetList) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{3}
}
func (m *ExampleDatasetList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDatasetList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDatasetList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDatasetList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDatasetList.Merge(m, src)
}
func (m *ExampleDatasetList) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDatasetList) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDatasetList.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDatasetList proto.InternalMessageInfo

func (m *ExampleDatasetList) GetItems() []*ExampleDataset {
	if m != nil {
		return m.Items
	}
	return nil
}

// List of example datasets.
type ExampleDatasetInstallationList struct {
	Items                []*ExampleDatasetInstallation `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ExampleDatasetInstallationList) Reset()         { *m = ExampleDatasetInstallationList{} }
func (m *ExampleDatasetInstallationList) String() string { return proto.CompactTextString(m) }
func (*ExampleDatasetInstallationList) ProtoMessage()    {}
func (*ExampleDatasetInstallationList) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{4}
}
func (m *ExampleDatasetInstallationList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDatasetInstallationList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDatasetInstallationList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDatasetInstallationList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDatasetInstallationList.Merge(m, src)
}
func (m *ExampleDatasetInstallationList) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDatasetInstallationList) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDatasetInstallationList.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDatasetInstallationList proto.InternalMessageInfo

func (m *ExampleDatasetInstallationList) GetItems() []*ExampleDatasetInstallation {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListExampleDatasetInstallations.
type ListExampleDatasetInstallationsRequest struct {
	// Identifier of the deployment to request the installations for.
	DeploymentId string `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Optional common list options, the context_id is ignored.
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListExampleDatasetInstallationsRequest) Reset() {
	*m = ListExampleDatasetInstallationsRequest{}
}
func (m *ListExampleDatasetInstallationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListExampleDatasetInstallationsRequest) ProtoMessage()    {}
func (*ListExampleDatasetInstallationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{5}
}
func (m *ListExampleDatasetInstallationsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListExampleDatasetInstallationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListExampleDatasetInstallationsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListExampleDatasetInstallationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExampleDatasetInstallationsRequest.Merge(m, src)
}
func (m *ListExampleDatasetInstallationsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListExampleDatasetInstallationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExampleDatasetInstallationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListExampleDatasetInstallationsRequest proto.InternalMessageInfo

func (m *ListExampleDatasetInstallationsRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ListExampleDatasetInstallationsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func init() {
	proto.RegisterType((*ExampleDataset)(nil), "arangodb.cloud.example.v1.ExampleDataset")
	proto.RegisterType((*ExampleDatasetInstallation)(nil), "arangodb.cloud.example.v1.ExampleDatasetInstallation")
	proto.RegisterType((*ExampleDatasetInstallation_Status)(nil), "arangodb.cloud.example.v1.ExampleDatasetInstallation.Status")
	proto.RegisterType((*ListExampleDatasetsRequest)(nil), "arangodb.cloud.example.v1.ListExampleDatasetsRequest")
	proto.RegisterType((*ExampleDatasetList)(nil), "arangodb.cloud.example.v1.ExampleDatasetList")
	proto.RegisterType((*ExampleDatasetInstallationList)(nil), "arangodb.cloud.example.v1.ExampleDatasetInstallationList")
	proto.RegisterType((*ListExampleDatasetInstallationsRequest)(nil), "arangodb.cloud.example.v1.ListExampleDatasetInstallationsRequest")
}

func init() { proto.RegisterFile("example.proto", fileDescriptor_15a1dc8d40dadaa6) }

var fileDescriptor_15a1dc8d40dadaa6 = []byte{
	// 884 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0x4d, 0x6f, 0x23, 0x35,
	0x18, 0xc6, 0x69, 0x93, 0x4d, 0xde, 0x6c, 0x57, 0xbb, 0x66, 0x41, 0x61, 0x96, 0x66, 0xb3, 0x13,
	0xed, 0xaa, 0x6c, 0xd5, 0x19, 0x25, 0x80, 0xd0, 0x2e, 0xa0, 0x55, 0xa0, 0xa5, 0x0a, 0x9f, 0xd5,
	0xb4, 0xe5, 0x80, 0x84, 0x22, 0x27, 0x76, 0x07, 0x4b, 0xf3, 0x45, 0xec, 0x44, 0xad, 0xaa, 0x1e,
	0x80, 0x3b, 0x42, 0xe2, 0xc2, 0x15, 0xf1, 0x17, 0xb8, 0xf0, 0x0f, 0x10, 0xe2, 0x80, 0xc4, 0x1f,
	0x40, 0x81, 0x33, 0xbf, 0x01, 0x8d, 0x3d, 0x43, 0x33, 0x69, 0x93, 0x26, 0x81, 0xc3, 0xde, 0xc6,
	0xaf, 0xfd, 0xbe, 0x7e, 0x9e, 0xe7, 0x7d, 0x6c, 0x0f, 0xac, 0xb1, 0x63, 0xe2, 0x47, 0x1e, 0xb3,
	0xa2, 0x7e, 0x28, 0x43, 0xfc, 0x02, 0xe9, 0x93, 0xc0, 0x0d, 0x69, 0xd7, 0xea, 0x79, 0xe1, 0x80,
	0x5a, 0xe9, 0xec, 0xb0, 0x61, 0x3c, 0xdf, 0x0b, 0x7d, 0x3f, 0x0c, 0xec, 0x61, 0xc3, 0xd6, 0x5f,
	0x3a, 0xc5, 0x78, 0xdd, 0xe5, 0xf2, 0xb3, 0x41, 0xd7, 0xea, 0x85, 0xbe, 0xed, 0x86, 0x1e, 0x09,
	0x5c, 0x5b, 0x4d, 0x74, 0x07, 0x47, 0x76, 0x24, 0x4f, 0x22, 0x26, 0x6c, 0xc9, 0x7d, 0x26, 0x24,
	0xf1, 0xa3, 0xf3, 0xaf, 0x24, 0xf9, 0x45, 0x37, 0x0c, 0x5d, 0x8f, 0xd9, 0x24, 0xe2, 0x36, 0x09,
	0x82, 0x50, 0x12, 0xc9, 0xc3, 0x40, 0xe8, 0x59, 0xf3, 0x27, 0x04, 0x37, 0x76, 0x34, 0x82, 0x6d,
	0x22, 0x89, 0x60, 0x12, 0xdf, 0x80, 0x1c, 0xa7, 0x15, 0x54, 0x43, 0x1b, 0x25, 0x27, 0xc7, 0x29,
	0xbe, 0x09, 0x2b, 0x83, 0xbe, 0x57, 0xc9, 0xa9, 0x40, 0xfc, 0x89, 0x31, 0xac, 0x06, 0xc4, 0x67,
	0x95, 0x15, 0x15, 0x52, 0xdf, 0xb8, 0x06, 0x65, 0xca, 0x44, 0xaf, 0xcf, 0xa3, 0xb8, 0x7c, 0x65,
	0x55, 0x4d, 0x8d, 0x87, 0xf0, 0x6d, 0xc8, 0xbb, 0x03, 0x4e, 0x59, 0xa5, 0xa0, 0xe6, 0xf4, 0x00,
	0x3f, 0x02, 0xe8, 0xf5, 0x19, 0x91, 0x8c, 0x76, 0x88, 0xac, 0x5c, 0xab, 0xa1, 0x8d, 0x72, 0xd3,
	0xb0, 0x34, 0x66, 0x2b, 0x65, 0x69, 0x1d, 0xa4, 0xa4, 0x9c, 0x52, 0xb2, 0xba, 0x25, 0xcd, 0x2f,
	0x56, 0xc1, 0xc8, 0x62, 0x6f, 0x07, 0x42, 0x12, 0xcf, 0x53, 0x0c, 0xe7, 0xe0, 0x51, 0x87, 0x35,
	0xca, 0x22, 0x2f, 0x3c, 0xf1, 0x59, 0x20, 0x3b, 0x9c, 0x26, 0x84, 0xae, 0x9f, 0x07, 0xdb, 0x14,
	0x6f, 0xc2, 0xad, 0xa4, 0x45, 0x54, 0x6f, 0x12, 0x2f, 0xd4, 0xf4, 0x6e, 0x66, 0x27, 0xda, 0x74,
	0x82, 0x4d, 0x7e, 0x01, 0x36, 0x71, 0x2a, 0x65, 0x1e, 0x4b, 0x52, 0x0b, 0x57, 0xa7, 0x26, 0xab,
	0x5b, 0x12, 0xaf, 0x03, 0x70, 0xd1, 0x49, 0xc6, 0x4a, 0xc3, 0xa2, 0x53, 0xe2, 0x62, 0x5b, 0x07,
	0xf0, 0x01, 0x14, 0x84, 0x24, 0x72, 0x20, 0x2a, 0x54, 0x55, 0x7d, 0xc3, 0x9a, 0x6a, 0x41, 0x6b,
	0xba, 0x9e, 0xd6, 0xbe, 0xaa, 0xe1, 0x24, 0xb5, 0x8c, 0xaf, 0x10, 0x14, 0x74, 0x48, 0xe9, 0x48,
	0x24, 0xe9, 0x12, 0xc1, 0x3a, 0xca, 0x18, 0x28, 0xd1, 0x31, 0x09, 0x7e, 0x18, 0x1b, 0xe4, 0x36,
	0xe4, 0xe3, 0xcc, 0xd4, 0x35, 0x7a, 0x80, 0xef, 0x40, 0x89, 0x8b, 0xce, 0x11, 0xe1, 0x1e, 0xd3,
	0xaa, 0x16, 0x9d, 0x22, 0x17, 0xef, 0xa8, 0x31, 0xbe, 0x07, 0xd7, 0xb9, 0xe8, 0x90, 0x21, 0xe1,
	0x1e, 0xe9, 0x7a, 0x4c, 0xe9, 0x59, 0x74, 0xca, 0x5c, 0xb4, 0xd2, 0x90, 0xf9, 0x29, 0x18, 0xef,
	0x73, 0x21, 0xb3, 0xb0, 0x85, 0xc3, 0x3e, 0x1f, 0x30, 0x21, 0xf1, 0x13, 0xb8, 0x16, 0x2a, 0xf3,
	0x09, 0x05, 0xa9, 0xdc, 0xbc, 0x3f, 0x49, 0x3d, 0x39, 0x67, 0xc3, 0x86, 0x15, 0x97, 0xf9, 0x48,
	0x2f, 0x76, 0xd2, 0x2c, 0xf3, 0x10, 0x70, 0xb6, 0x74, 0xbc, 0x0a, 0x3f, 0x81, 0x3c, 0x97, 0xcc,
	0x8f, 0x8b, 0xae, 0x6c, 0x94, 0x9b, 0x2f, 0xcd, 0xad, 0xa7, 0xa3, 0xf3, 0x4c, 0x1f, 0xaa, 0xd3,
	0x85, 0x56, 0x5b, 0xbc, 0x97, 0xdd, 0xe2, 0xd5, 0xa5, 0x5a, 0x96, 0x6e, 0xf7, 0x35, 0x82, 0x07,
	0x17, 0x55, 0x1a, 0x5f, 0xf9, 0xaf, 0x62, 0x17, 0x8e, 0x04, 0xba, 0xe4, 0x48, 0x8c, 0xc9, 0x0a,
	0xcb, 0xc8, 0xda, 0xfc, 0xa5, 0x0c, 0xcf, 0x65, 0xc1, 0xec, 0xb3, 0xfe, 0x90, 0xf7, 0x18, 0x3e,
	0x86, 0xb5, 0x5d, 0x26, 0x5b, 0x7b, 0xed, 0x8f, 0x59, 0x5f, 0xc4, 0xa7, 0xf8, 0xee, 0xf4, 0xd2,
	0x3b, 0x7e, 0x24, 0x4f, 0x8c, 0x7b, 0xd3, 0x17, 0x24, 0x35, 0xcc, 0xfa, 0x97, 0xbf, 0xff, 0xf5,
	0x6d, 0x6e, 0x1d, 0xdf, 0x51, 0x97, 0x60, 0x22, 0x5d, 0x7c, 0xcb, 0x92, 0x88, 0x6f, 0x0d, 0x93,
	0x8d, 0x7e, 0x40, 0xf0, 0xec, 0x25, 0x56, 0xc2, 0xb3, 0xa4, 0x9f, 0x6e, 0x3d, 0x63, 0x6b, 0xee,
	0x8e, 0xc5, 0x45, 0xcc, 0x07, 0x0a, 0x62, 0x0d, 0x57, 0x27, 0x21, 0x66, 0xaf, 0x18, 0xfc, 0x0d,
	0x82, 0x5b, 0xbb, 0x6c, 0x62, 0x53, 0x5c, 0x9f, 0xae, 0x41, 0x7b, 0x3b, 0x51, 0xdf, 0x98, 0xdf,
	0xa6, 0xe6, 0xa6, 0x42, 0x73, 0x1f, 0xd7, 0x67, 0xa3, 0xb1, 0x4f, 0x39, 0x3d, 0xc3, 0x7f, 0x23,
	0xb8, 0x7b, 0x85, 0xbb, 0x70, 0x6b, 0x21, 0x11, 0x2f, 0x73, 0xa6, 0xf1, 0x68, 0xa9, 0x23, 0xa0,
	0xc4, 0xfd, 0x40, 0xd1, 0xd9, 0xc5, 0x3b, 0x93, 0x74, 0xce, 0x5d, 0x6d, 0x9f, 0x66, 0x6c, 0x7f,
	0x36, 0xc1, 0x94, 0x8f, 0x3f, 0x2c, 0x3f, 0x22, 0x58, 0xbf, 0xd0, 0x83, 0xcc, 0xd3, 0x33, 0x57,
	0x3f, 0x96, 0x3b, 0xd3, 0xe6, 0x6b, 0x8a, 0x4c, 0x03, 0xdb, 0xb3, 0x7b, 0x33, 0x8e, 0x58, 0xf7,
	0x69, 0x84, 0xa0, 0xf6, 0xb6, 0x7a, 0x6e, 0x66, 0x20, 0x5f, 0x0e, 0xd4, 0xb2, 0x5c, 0xf6, 0x14,
	0x97, 0x77, 0xcd, 0xff, 0xa7, 0x31, 0x8f, 0xd1, 0x43, 0xfc, 0x2b, 0x82, 0xda, 0x61, 0x44, 0x9f,
	0x26, 0x92, 0x8f, 0x15, 0xc9, 0x57, 0x9a, 0x8b, 0x36, 0x2c, 0xa6, 0xf3, 0x3d, 0x82, 0x9a, 0x7e,
	0xc6, 0xff, 0xab, 0xdb, 0xae, 0xba, 0x47, 0x53, 0x5f, 0x3d, 0x5c, 0x14, 0xe6, 0x5b, 0x6f, 0xfe,
	0x3c, 0xaa, 0xa2, 0xdf, 0x46, 0x55, 0xf4, 0xc7, 0xa8, 0x8a, 0xbe, 0xfb, 0xb3, 0xfa, 0xcc, 0x27,
	0x9b, 0x63, 0xff, 0xab, 0xe9, 0xae, 0x5b, 0x3e, 0x09, 0x88, 0xcb, 0x68, 0x5c, 0x5d, 0x8c, 0x95,
	0xef, 0x16, 0xd4, 0xbf, 0xcd, 0xcb, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0x35, 0xf5, 0x8c, 0x4b,
	0x27, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ExampleDatasetServiceClient is the client API for ExampleDatasetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExampleDatasetServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all example datasets.
	// Required permissions:
	// - None: Caller must be authenticated.
	ListExampleDatasets(ctx context.Context, in *ListExampleDatasetsRequest, opts ...grpc.CallOption) (*ExampleDatasetList, error)
	// Fetch an example dataset identified by the given ID.
	// Required permissions:
	// - None: Caller must be authenticated.
	GetExampleDataset(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ExampleDataset, error)
	// Fetch all installations for a specific deployment.
	// Required permissions:
	// - example.exampledatasetinstallation.list on the deployment that owns the installation and is identified by the given ID.
	ListExampleDatasetInstallations(ctx context.Context, in *ListExampleDatasetInstallationsRequest, opts ...grpc.CallOption) (*ExampleDatasetInstallationList, error)
	// Fetch an installations identified by the given ID.
	// Required permissions:
	// - example.exampledatasetinstallation.get on the installation identified by the given ID.
	GetExampleDatasetInstallation(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error)
	// Create a new example installation. This represents a request made by the user to create an installation
	// for a deployment given a specified example dataset.
	// Required permissions:
	// -  example.exampledatasetinstallation.create on the deployment that the installation is for and is identified by the given ID.
	CreateExampleDatasetInstallation(ctx context.Context, in *ExampleDatasetInstallation, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error)
	// Update an installation.
	// Required permissions:
	// -  example.exampledatasetinstallation.update on the installation identified by the given ID.
	UpdateExampleDatasetInstallation(ctx context.Context, in *ExampleDatasetInstallation, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error)
	// Delete an installation identified by the given ID.
	// Required permissions:
	// -  example.exampledatasetinstallation.delete on the installation identified by the given ID.
	DeleteExampleDatasetInstallation(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
}

type exampleDatasetServiceClient struct {
	cc *grpc.ClientConn
}

func NewExampleDatasetServiceClient(cc *grpc.ClientConn) ExampleDatasetServiceClient {
	return &exampleDatasetServiceClient{cc}
}

func (c *exampleDatasetServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) ListExampleDatasets(ctx context.Context, in *ListExampleDatasetsRequest, opts ...grpc.CallOption) (*ExampleDatasetList, error) {
	out := new(ExampleDatasetList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/ListExampleDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) GetExampleDataset(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ExampleDataset, error) {
	out := new(ExampleDataset)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/GetExampleDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) ListExampleDatasetInstallations(ctx context.Context, in *ListExampleDatasetInstallationsRequest, opts ...grpc.CallOption) (*ExampleDatasetInstallationList, error) {
	out := new(ExampleDatasetInstallationList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/ListExampleDatasetInstallations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) GetExampleDatasetInstallation(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error) {
	out := new(ExampleDatasetInstallation)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/GetExampleDatasetInstallation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) CreateExampleDatasetInstallation(ctx context.Context, in *ExampleDatasetInstallation, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error) {
	out := new(ExampleDatasetInstallation)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/CreateExampleDatasetInstallation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) UpdateExampleDatasetInstallation(ctx context.Context, in *ExampleDatasetInstallation, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error) {
	out := new(ExampleDatasetInstallation)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/UpdateExampleDatasetInstallation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) DeleteExampleDatasetInstallation(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/DeleteExampleDatasetInstallation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExampleDatasetServiceServer is the server API for ExampleDatasetService service.
type ExampleDatasetServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all example datasets.
	// Required permissions:
	// - None: Caller must be authenticated.
	ListExampleDatasets(context.Context, *ListExampleDatasetsRequest) (*ExampleDatasetList, error)
	// Fetch an example dataset identified by the given ID.
	// Required permissions:
	// - None: Caller must be authenticated.
	GetExampleDataset(context.Context, *v1.IDOptions) (*ExampleDataset, error)
	// Fetch all installations for a specific deployment.
	// Required permissions:
	// - example.exampledatasetinstallation.list on the deployment that owns the installation and is identified by the given ID.
	ListExampleDatasetInstallations(context.Context, *ListExampleDatasetInstallationsRequest) (*ExampleDatasetInstallationList, error)
	// Fetch an installations identified by the given ID.
	// Required permissions:
	// - example.exampledatasetinstallation.get on the installation identified by the given ID.
	GetExampleDatasetInstallation(context.Context, *v1.IDOptions) (*ExampleDatasetInstallation, error)
	// Create a new example installation. This represents a request made by the user to create an installation
	// for a deployment given a specified example dataset.
	// Required permissions:
	// -  example.exampledatasetinstallation.create on the deployment that the installation is for and is identified by the given ID.
	CreateExampleDatasetInstallation(context.Context, *ExampleDatasetInstallation) (*ExampleDatasetInstallation, error)
	// Update an installation.
	// Required permissions:
	// -  example.exampledatasetinstallation.update on the installation identified by the given ID.
	UpdateExampleDatasetInstallation(context.Context, *ExampleDatasetInstallation) (*ExampleDatasetInstallation, error)
	// Delete an installation identified by the given ID.
	// Required permissions:
	// -  example.exampledatasetinstallation.delete on the installation identified by the given ID.
	DeleteExampleDatasetInstallation(context.Context, *v1.IDOptions) (*v1.Empty, error)
}

// UnimplementedExampleDatasetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedExampleDatasetServiceServer struct {
}

func (*UnimplementedExampleDatasetServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) ListExampleDatasets(ctx context.Context, req *ListExampleDatasetsRequest) (*ExampleDatasetList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExampleDatasets not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) GetExampleDataset(ctx context.Context, req *v1.IDOptions) (*ExampleDataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExampleDataset not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) ListExampleDatasetInstallations(ctx context.Context, req *ListExampleDatasetInstallationsRequest) (*ExampleDatasetInstallationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExampleDatasetInstallations not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) GetExampleDatasetInstallation(ctx context.Context, req *v1.IDOptions) (*ExampleDatasetInstallation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExampleDatasetInstallation not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) CreateExampleDatasetInstallation(ctx context.Context, req *ExampleDatasetInstallation) (*ExampleDatasetInstallation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExampleDatasetInstallation not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) UpdateExampleDatasetInstallation(ctx context.Context, req *ExampleDatasetInstallation) (*ExampleDatasetInstallation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExampleDatasetInstallation not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) DeleteExampleDatasetInstallation(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExampleDatasetInstallation not implemented")
}

func RegisterExampleDatasetServiceServer(s *grpc.Server, srv ExampleDatasetServiceServer) {
	s.RegisterService(&_ExampleDatasetService_serviceDesc, srv)
}

func _ExampleDatasetService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_ListExampleDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExampleDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).ListExampleDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/ListExampleDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).ListExampleDatasets(ctx, req.(*ListExampleDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_GetExampleDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).GetExampleDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/GetExampleDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).GetExampleDataset(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_ListExampleDatasetInstallations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExampleDatasetInstallationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).ListExampleDatasetInstallations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/ListExampleDatasetInstallations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).ListExampleDatasetInstallations(ctx, req.(*ListExampleDatasetInstallationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_GetExampleDatasetInstallation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).GetExampleDatasetInstallation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/GetExampleDatasetInstallation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).GetExampleDatasetInstallation(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_CreateExampleDatasetInstallation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExampleDatasetInstallation)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).CreateExampleDatasetInstallation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/CreateExampleDatasetInstallation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).CreateExampleDatasetInstallation(ctx, req.(*ExampleDatasetInstallation))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_UpdateExampleDatasetInstallation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExampleDatasetInstallation)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).UpdateExampleDatasetInstallation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/UpdateExampleDatasetInstallation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).UpdateExampleDatasetInstallation(ctx, req.(*ExampleDatasetInstallation))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_DeleteExampleDatasetInstallation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).DeleteExampleDatasetInstallation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/DeleteExampleDatasetInstallation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).DeleteExampleDatasetInstallation(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _ExampleDatasetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.example.v1.ExampleDatasetService",
	HandlerType: (*ExampleDatasetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _ExampleDatasetService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListExampleDatasets",
			Handler:    _ExampleDatasetService_ListExampleDatasets_Handler,
		},
		{
			MethodName: "GetExampleDataset",
			Handler:    _ExampleDatasetService_GetExampleDataset_Handler,
		},
		{
			MethodName: "ListExampleDatasetInstallations",
			Handler:    _ExampleDatasetService_ListExampleDatasetInstallations_Handler,
		},
		{
			MethodName: "GetExampleDatasetInstallation",
			Handler:    _ExampleDatasetService_GetExampleDatasetInstallation_Handler,
		},
		{
			MethodName: "CreateExampleDatasetInstallation",
			Handler:    _ExampleDatasetService_CreateExampleDatasetInstallation_Handler,
		},
		{
			MethodName: "UpdateExampleDatasetInstallation",
			Handler:    _ExampleDatasetService_UpdateExampleDatasetInstallation_Handler,
		},
		{
			MethodName: "DeleteExampleDatasetInstallation",
			Handler:    _ExampleDatasetService_DeleteExampleDatasetInstallation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "example.proto",
}

func (m *ExampleDataset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDataset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDataset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Guide) > 0 {
		i -= len(m.Guide)
		copy(dAtA[i:], m.Guide)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Guide)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExampleDatasetInstallation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDatasetInstallation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDatasetInstallation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ExampledatasetId) > 0 {
		i -= len(m.ExampledatasetId)
		copy(dAtA[i:], m.ExampledatasetId)
		i = encodeVarintExample(dAtA, i, uint64(len(m.ExampledatasetId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintExample(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExampleDatasetInstallation_Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDatasetInstallation_Status) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDatasetInstallation_Status) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsAvailable {
		i--
		if m.IsAvailable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.IsFailed {
		i--
		if m.IsFailed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.State) > 0 {
		i -= len(m.State)
		copy(dAtA[i:], m.State)
		i = encodeVarintExample(dAtA, i, uint64(len(m.State)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DatabaseName) > 0 {
		i -= len(m.DatabaseName)
		copy(dAtA[i:], m.DatabaseName)
		i = encodeVarintExample(dAtA, i, uint64(len(m.DatabaseName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListExampleDatasetsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListExampleDatasetsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListExampleDatasetsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExampleDatasetList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDatasetList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDatasetList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintExample(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExampleDatasetInstallationList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDatasetInstallationList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDatasetInstallationList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintExample(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListExampleDatasetInstallationsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListExampleDatasetInstallationsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListExampleDatasetInstallationsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintExample(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintExample(dAtA []byte, offset int, v uint64) int {
	offset -= sovExample(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ExampleDataset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Guide)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExampleDatasetInstallation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.ExampledatasetId)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 2 + l + sovExample(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExampleDatasetInstallation_Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DatabaseName)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.IsFailed {
		n += 2
	}
	if m.IsAvailable {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListExampleDatasetsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExampleDatasetList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovExample(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExampleDatasetInstallationList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovExample(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListExampleDatasetInstallationsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovExample(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozExample(x uint64) (n int) {
	return sovExample(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ExampleDataset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExampleDataset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExampleDataset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Guide", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Guide = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExampleDatasetInstallation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExampleDatasetInstallation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExampleDatasetInstallation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExampledatasetId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExampledatasetId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &ExampleDatasetInstallation_Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExampleDatasetInstallation_Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DatabaseName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFailed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFailed = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsAvailable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsAvailable = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListExampleDatasetsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListExampleDatasetsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListExampleDatasetsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExampleDatasetList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExampleDatasetList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExampleDatasetList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &ExampleDataset{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExampleDatasetInstallationList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExampleDatasetInstallationList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExampleDatasetInstallationList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &ExampleDatasetInstallation{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListExampleDatasetInstallationsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListExampleDatasetInstallationsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListExampleDatasetInstallationsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipExample(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowExample
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExample
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExample
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthExample
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthExample
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowExample
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipExample(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthExample
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthExample = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowExample   = fmt.Errorf("proto: integer overflow")
)
