// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: security.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// IPWhitelist represents a list of CIDR ranges from which a deployment is accessible.
type IPWhitelist struct {
	// System identifier of the whitelist.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of the whitelist.
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the whitelist.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the whitelist.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that contains this whitelist.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// List of CIDR ranges.
	// Values must follow format as defined in RFC 4632 and RFC 4291.
	CidrRanges []string `protobuf:"bytes,6,rep,name=cidr_ranges,json=cidrRanges,proto3" json:"cidr_ranges,omitempty"`
	// The creation timestamp of this whitelist.
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the whitelist
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this whitelist is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the user who created this whitelist.
	// This is a read-only value.
	CreatedById          string   `protobuf:"bytes,10,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IPWhitelist) Reset()         { *m = IPWhitelist{} }
func (m *IPWhitelist) String() string { return proto.CompactTextString(m) }
func (*IPWhitelist) ProtoMessage()    {}
func (*IPWhitelist) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{0}
}
func (m *IPWhitelist) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPWhitelist) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPWhitelist.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPWhitelist) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPWhitelist.Merge(m, src)
}
func (m *IPWhitelist) XXX_Size() int {
	return m.Size()
}
func (m *IPWhitelist) XXX_DiscardUnknown() {
	xxx_messageInfo_IPWhitelist.DiscardUnknown(m)
}

var xxx_messageInfo_IPWhitelist proto.InternalMessageInfo

func (m *IPWhitelist) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *IPWhitelist) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *IPWhitelist) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IPWhitelist) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *IPWhitelist) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *IPWhitelist) GetCidrRanges() []string {
	if m != nil {
		return m.CidrRanges
	}
	return nil
}

func (m *IPWhitelist) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *IPWhitelist) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *IPWhitelist) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *IPWhitelist) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

// List of IP whitelists.
type IPWhitelistList struct {
	Items                []*IPWhitelist `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *IPWhitelistList) Reset()         { *m = IPWhitelistList{} }
func (m *IPWhitelistList) String() string { return proto.CompactTextString(m) }
func (*IPWhitelistList) ProtoMessage()    {}
func (*IPWhitelistList) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{1}
}
func (m *IPWhitelistList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPWhitelistList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPWhitelistList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPWhitelistList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPWhitelistList.Merge(m, src)
}
func (m *IPWhitelistList) XXX_Size() int {
	return m.Size()
}
func (m *IPWhitelistList) XXX_DiscardUnknown() {
	xxx_messageInfo_IPWhitelistList.DiscardUnknown(m)
}

var xxx_messageInfo_IPWhitelistList proto.InternalMessageInfo

func (m *IPWhitelistList) GetItems() []*IPWhitelist {
	if m != nil {
		return m.Items
	}
	return nil
}

// IAMProvider provides configuration for a custom Identity & Access management provider
// for deployments.
type IAMProvider struct {
	// System identifier of the provider.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of the provider.
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the provider.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the provider.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that contains this provider.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Type of provider
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// The creation timestamp of this provider.
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the provider
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this provider is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the user who created this provider.
	// This is a read-only value.
	CreatedById string `protobuf:"bytes,10,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// Set when this provider is the default in its project.
	// This is a read-only value.
	IsDefault            bool                      `protobuf:"varint,11,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	LdapSettings         *IAMProvider_LDAPSettings `protobuf:"bytes,101,opt,name=ldap_settings,json=ldapSettings,proto3" json:"ldap_settings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *IAMProvider) Reset()         { *m = IAMProvider{} }
func (m *IAMProvider) String() string { return proto.CompactTextString(m) }
func (*IAMProvider) ProtoMessage()    {}
func (*IAMProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{2}
}
func (m *IAMProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IAMProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IAMProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IAMProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IAMProvider.Merge(m, src)
}
func (m *IAMProvider) XXX_Size() int {
	return m.Size()
}
func (m *IAMProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_IAMProvider.DiscardUnknown(m)
}

var xxx_messageInfo_IAMProvider proto.InternalMessageInfo

func (m *IAMProvider) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *IAMProvider) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *IAMProvider) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IAMProvider) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *IAMProvider) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *IAMProvider) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *IAMProvider) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *IAMProvider) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *IAMProvider) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *IAMProvider) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *IAMProvider) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *IAMProvider) GetLdapSettings() *IAMProvider_LDAPSettings {
	if m != nil {
		return m.LdapSettings
	}
	return nil
}

// LDAP provider specific settings
type IAMProvider_LDAPSettings struct {
	// Hostname or IP address of the server
	Server string `protobuf:"bytes,1,opt,name=server,proto3" json:"server,omitempty"`
	// Port number of the server (defaults to 389)
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Base distinguished name under which the search takes place
	BaseDistinguishedName string `protobuf:"bytes,3,opt,name=base_distinguished_name,json=baseDistinguishedName,proto3" json:"base_distinguished_name,omitempty"`
	// distinguished name for a read-only LDAP user to which ArangoDB can bind to search the LDAP server
	BindDistinguishedName string `protobuf:"bytes,4,opt,name=bind_distinguished_name,json=bindDistinguishedName,proto3" json:"bind_distinguished_name,omitempty"`
	// Password name for a read-only LDAP user to which ArangoDB can bind to search the LDAP server.
	// This is a set-only field. During get/list requests, this field will be empty.
	BindPassword string `protobuf:"bytes,5,opt,name=bind_password,json=bindPassword,proto3" json:"bind_password,omitempty"`
	// Refresh rate in seconds (defaults to 300)
	RefreshRate int32 `protobuf:"varint,6,opt,name=refresh_rate,json=refreshRate,proto3" json:"refresh_rate,omitempty"`
	// PEM encoded version of the CA certificate used by the LDAP server.
	TlsCaCertificatePem string `protobuf:"bytes,10,opt,name=tls_ca_certificate_pem,json=tlsCaCertificatePem,proto3" json:"tls_ca_certificate_pem,omitempty"`
	// If set, calls into the underlying LDAP library are serialized.
	// This option can be used to work around thread-unsafe LDAP library functionality.
	Serialized bool `protobuf:"varint,20,opt,name=serialized,proto3" json:"serialized,omitempty"`
	// Timeout (in seconds) used when waiting to enter the LDAP library call serialization lock.
	// This is only meaningful when serialized has been set to true.
	SerializeTimeoutSec int32 `protobuf:"varint,21,opt,name=serialize_timeout_sec,json=serializeTimeoutSec,proto3" json:"serialize_timeout_sec,omitempty"`
	// Number of retries to attempt a connection to the LDAP server.
	// Setting this to values greater than zero will make ArangoDB retry to contact the
	// LDAP server in case no connection can be made initially.
	Retries int32 `protobuf:"varint,22,opt,name=retries,proto3" json:"retries,omitempty"`
	// If set, the LDAP library will implicitly restart connections.
	Restart bool `protobuf:"varint,23,opt,name=restart,proto3" json:"restart,omitempty"`
	// If set, the LDAP library will implicitly chase referrals.
	Referrals bool `protobuf:"varint,24,opt,name=referrals,proto3" json:"referrals,omitempty"`
	// Timeout value (in seconds) for synchronous LDAP API calls (a value of 0 means default timeout).
	TimeoutSec int32 `protobuf:"varint,25,opt,name=timeout_sec,json=timeoutSec,proto3" json:"timeout_sec,omitempty"`
	// Timeout value (in seconds) after which network operations following the initial
	// connection return in case of no activity (a value of 0 means default timeout).
	NetworkTimeoutSec int32 `protobuf:"varint,26,opt,name=network_timeout_sec,json=networkTimeoutSec,proto3" json:"network_timeout_sec,omitempty"`
	// If set, the LDAP library will connect asynchronously.
	AsyncConnect bool `protobuf:"varint,27,opt,name=async_connect,json=asyncConnect,proto3" json:"async_connect,omitempty"`
	// Prefix for simple authentication
	Prefix string `protobuf:"bytes,100,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Suffix for simple authentication
	Suffix string `protobuf:"bytes,101,opt,name=suffix,proto3" json:"suffix,omitempty"`
	// LDAP search scope with possible values "base" (just search the base distinguished name),
	// "sub" (recursive search under the base distinguished name) or
	// "one" (search the base’s immediate children) (default: "sub").
	SearchScope string `protobuf:"bytes,200,opt,name=search_scope,json=searchScope,proto3" json:"search_scope,omitempty"`
	// LDAP filter expression which limits the set of LDAP users being considered
	// (default: "objectClass=*"" which means all objects).
	SearchFilter string `protobuf:"bytes,201,opt,name=search_filter,json=searchFilter,proto3" json:"search_filter,omitempty"`
	// Specifies the attribute in the user objects which is used to match the ArangoDB user name (default: "uid").
	SearchAttribute string `protobuf:"bytes,202,opt,name=search_attribute,json=searchAttribute,proto3" json:"search_attribute,omitempty"`
	// If set, this field specifies the name of the attribute used to fetch the roles of a user.
	RolesAttributeName string `protobuf:"bytes,300,opt,name=roles_attribute_name,json=rolesAttributeName,proto3" json:"roles_attribute_name,omitempty"`
	// If set, then the string {USER} in the value of this field is replaced with the distinguished
	// name of the authenticated LDAP user and the resulting search expression is used to
	// match distinguished names of LDAP objects representing roles of that user.
	RolesSearch string `protobuf:"bytes,301,opt,name=roles_search,json=rolesSearch,proto3" json:"roles_search,omitempty"`
	// Regular expression that is used to filter roles.
	// Only roles that match the regular expression are used.
	RolesInclude string `protobuf:"bytes,400,opt,name=roles_include,json=rolesInclude,proto3" json:"roles_include,omitempty"`
	// Regular expression that is used to filter roles.
	// Only roles that do not match the regular expression are used.
	RolesExclude string `protobuf:"bytes,401,opt,name=roles_exclude,json=rolesExclude,proto3" json:"roles_exclude,omitempty"`
	// A regular expression in the format of a replacement text (/re/text/).
	// This regular expression is applied to the role name found.
	// This is especially useful in the roles-search variant to extract the real role name out of the dn value.
	RolesTransformation string `protobuf:"bytes,402,opt,name=roles_transformation,json=rolesTransformation,proto3" json:"roles_transformation,omitempty"`
	// Name of role associated with the superuser.
	// Any user belonging to this role gains superuser status.
	// This role is checked after applying the roles_transformation expression.
	SuperUserRole        string   `protobuf:"bytes,403,opt,name=super_user_role,json=superUserRole,proto3" json:"super_user_role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IAMProvider_LDAPSettings) Reset()         { *m = IAMProvider_LDAPSettings{} }
func (m *IAMProvider_LDAPSettings) String() string { return proto.CompactTextString(m) }
func (*IAMProvider_LDAPSettings) ProtoMessage()    {}
func (*IAMProvider_LDAPSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{2, 0}
}
func (m *IAMProvider_LDAPSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IAMProvider_LDAPSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IAMProvider_LDAPSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IAMProvider_LDAPSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IAMProvider_LDAPSettings.Merge(m, src)
}
func (m *IAMProvider_LDAPSettings) XXX_Size() int {
	return m.Size()
}
func (m *IAMProvider_LDAPSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_IAMProvider_LDAPSettings.DiscardUnknown(m)
}

var xxx_messageInfo_IAMProvider_LDAPSettings proto.InternalMessageInfo

func (m *IAMProvider_LDAPSettings) GetServer() string {
	if m != nil {
		return m.Server
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetBaseDistinguishedName() string {
	if m != nil {
		return m.BaseDistinguishedName
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetBindDistinguishedName() string {
	if m != nil {
		return m.BindDistinguishedName
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetBindPassword() string {
	if m != nil {
		return m.BindPassword
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRefreshRate() int32 {
	if m != nil {
		return m.RefreshRate
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetTlsCaCertificatePem() string {
	if m != nil {
		return m.TlsCaCertificatePem
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSerialized() bool {
	if m != nil {
		return m.Serialized
	}
	return false
}

func (m *IAMProvider_LDAPSettings) GetSerializeTimeoutSec() int32 {
	if m != nil {
		return m.SerializeTimeoutSec
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetRetries() int32 {
	if m != nil {
		return m.Retries
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetRestart() bool {
	if m != nil {
		return m.Restart
	}
	return false
}

func (m *IAMProvider_LDAPSettings) GetReferrals() bool {
	if m != nil {
		return m.Referrals
	}
	return false
}

func (m *IAMProvider_LDAPSettings) GetTimeoutSec() int32 {
	if m != nil {
		return m.TimeoutSec
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetNetworkTimeoutSec() int32 {
	if m != nil {
		return m.NetworkTimeoutSec
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetAsyncConnect() bool {
	if m != nil {
		return m.AsyncConnect
	}
	return false
}

func (m *IAMProvider_LDAPSettings) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSuffix() string {
	if m != nil {
		return m.Suffix
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSearchScope() string {
	if m != nil {
		return m.SearchScope
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSearchFilter() string {
	if m != nil {
		return m.SearchFilter
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSearchAttribute() string {
	if m != nil {
		return m.SearchAttribute
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesAttributeName() string {
	if m != nil {
		return m.RolesAttributeName
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesSearch() string {
	if m != nil {
		return m.RolesSearch
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesInclude() string {
	if m != nil {
		return m.RolesInclude
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesExclude() string {
	if m != nil {
		return m.RolesExclude
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesTransformation() string {
	if m != nil {
		return m.RolesTransformation
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSuperUserRole() string {
	if m != nil {
		return m.SuperUserRole
	}
	return ""
}

// List of IAM providers.
type IAMProviderList struct {
	Items                []*IAMProvider `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *IAMProviderList) Reset()         { *m = IAMProviderList{} }
func (m *IAMProviderList) String() string { return proto.CompactTextString(m) }
func (*IAMProviderList) ProtoMessage()    {}
func (*IAMProviderList) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{3}
}
func (m *IAMProviderList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IAMProviderList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IAMProviderList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IAMProviderList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IAMProviderList.Merge(m, src)
}
func (m *IAMProviderList) XXX_Size() int {
	return m.Size()
}
func (m *IAMProviderList) XXX_DiscardUnknown() {
	xxx_messageInfo_IAMProviderList.DiscardUnknown(m)
}

var xxx_messageInfo_IAMProviderList proto.InternalMessageInfo

func (m *IAMProviderList) GetItems() []*IAMProvider {
	if m != nil {
		return m.Items
	}
	return nil
}

func init() {
	proto.RegisterType((*IPWhitelist)(nil), "arangodb.cloud.security.v1.IPWhitelist")
	proto.RegisterType((*IPWhitelistList)(nil), "arangodb.cloud.security.v1.IPWhitelistList")
	proto.RegisterType((*IAMProvider)(nil), "arangodb.cloud.security.v1.IAMProvider")
	proto.RegisterType((*IAMProvider_LDAPSettings)(nil), "arangodb.cloud.security.v1.IAMProvider.LDAPSettings")
	proto.RegisterType((*IAMProviderList)(nil), "arangodb.cloud.security.v1.IAMProviderList")
}

func init() { proto.RegisterFile("security.proto", fileDescriptor_55a487c716a8b59c) }

var fileDescriptor_55a487c716a8b59c = []byte{
	// 1307 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x57, 0xcf, 0x6f, 0x1b, 0x45,
	0x14, 0x66, 0xf3, 0xab, 0xf5, 0xd8, 0x4e, 0x9a, 0x49, 0x93, 0x0e, 0xa6, 0xa4, 0xa9, 0x5b, 0xd4,
	0x28, 0x50, 0x5b, 0x71, 0xf9, 0x21, 0x5a, 0x15, 0x91, 0x26, 0x6d, 0x65, 0xa9, 0x80, 0x65, 0xb7,
	0x20, 0xb8, 0xac, 0xc6, 0xbb, 0xcf, 0xce, 0xc0, 0x7a, 0x77, 0x35, 0x33, 0x76, 0x6b, 0xaa, 0x5e,
	0x90, 0xb8, 0x70, 0x02, 0xca, 0x81, 0x3b, 0x5c, 0x40, 0x70, 0xe6, 0x5f, 0x28, 0x9c, 0x90, 0xb8,
	0x23, 0x54, 0xb8, 0xf0, 0x5f, 0xa0, 0xf9, 0xb1, 0xde, 0x4d, 0x42, 0x52, 0x07, 0x5a, 0x21, 0x6e,
	0x3b, 0xdf, 0xfb, 0xde, 0x9b, 0x6f, 0xe7, 0x7d, 0xde, 0x37, 0x46, 0xb3, 0x02, 0xbc, 0x3e, 0x67,
	0x72, 0x58, 0x89, 0x79, 0x24, 0x23, 0x5c, 0xa2, 0x9c, 0x86, 0xdd, 0xc8, 0x6f, 0x57, 0xbc, 0x20,
	0xea, 0xfb, 0x95, 0x51, 0x78, 0xb0, 0x5e, 0x5a, 0xf2, 0xa2, 0x5e, 0x2f, 0x0a, 0xab, 0x83, 0xf5,
	0xaa, 0x79, 0x32, 0x39, 0xa5, 0x4b, 0x5d, 0x26, 0xb7, 0xfb, 0xed, 0x8a, 0x17, 0xf5, 0xaa, 0xdd,
	0x28, 0xa0, 0x61, 0xb7, 0xaa, 0x03, 0xed, 0x7e, 0xa7, 0x1a, 0xcb, 0x61, 0x0c, 0xa2, 0x2a, 0x59,
	0x0f, 0x84, 0xa4, 0xbd, 0x38, 0x7d, 0xb2, 0xc9, 0x27, 0xbb, 0x51, 0xd4, 0x0d, 0xa0, 0x4a, 0x63,
	0x56, 0xa5, 0x61, 0x18, 0x49, 0x2a, 0x59, 0x14, 0x0a, 0x13, 0x2d, 0xff, 0x3a, 0x81, 0xf2, 0xf5,
	0xc6, 0x3b, 0xdb, 0x4c, 0x42, 0xc0, 0x84, 0xc4, 0xb3, 0x68, 0x82, 0xf9, 0xc4, 0x59, 0x71, 0x56,
	0x73, 0xcd, 0x09, 0xe6, 0xe3, 0x63, 0x68, 0xb2, 0xcf, 0x03, 0x32, 0xa1, 0x01, 0xf5, 0x88, 0x31,
	0x9a, 0x0a, 0x69, 0x0f, 0xc8, 0xa4, 0x86, 0xf4, 0x33, 0x5e, 0x41, 0x79, 0x1f, 0x84, 0xc7, 0x59,
	0xac, 0x6a, 0x93, 0x29, 0x1d, 0xca, 0x42, 0xf8, 0x59, 0x84, 0x62, 0x1e, 0xbd, 0x0f, 0x9e, 0x74,
	0x99, 0x4f, 0xa6, 0x35, 0x21, 0x67, 0x91, 0xba, 0x8f, 0x4f, 0xa1, 0xbc, 0xc7, 0x7c, 0xee, 0xaa,
	0xb3, 0x01, 0x41, 0x66, 0x56, 0x26, 0x57, 0x73, 0x4d, 0xa4, 0xa0, 0xa6, 0x46, 0xf0, 0xab, 0x08,
	0x79, 0x1c, 0xa8, 0x04, 0xdf, 0xa5, 0x92, 0x1c, 0x59, 0x71, 0x56, 0xf3, 0xb5, 0x52, 0xc5, 0xbc,
	0x5a, 0x25, 0x39, 0x8c, 0xca, 0xcd, 0xe4, 0xdd, 0x9b, 0x39, 0xcb, 0xde, 0x90, 0x2a, 0xd5, 0x87,
	0x00, 0x6c, 0xea, 0xd1, 0x47, 0xa7, 0x5a, 0xf6, 0x86, 0x54, 0xaa, 0x99, 0x70, 0xed, 0x9a, 0xe4,
	0x56, 0x9c, 0xd5, 0xa3, 0xcd, 0x1c, 0x13, 0x5b, 0x06, 0xc0, 0x65, 0x54, 0x4c, 0x44, 0xb5, 0x87,
	0xea, 0xbd, 0x90, 0x79, 0x71, 0x0b, 0x5e, 0x19, 0xd6, 0xfd, 0x72, 0x03, 0xcd, 0x65, 0xce, 0xf7,
	0x86, 0x3a, 0xe3, 0xcb, 0x68, 0x9a, 0x49, 0xe8, 0x09, 0xe2, 0xac, 0x4c, 0xae, 0xe6, 0x6b, 0xe7,
	0x2a, 0xfb, 0x5b, 0xa2, 0x92, 0xc9, 0x6d, 0x9a, 0xac, 0xf2, 0x0f, 0x79, 0x94, 0xaf, 0x6f, 0xbc,
	0xd1, 0xe0, 0xd1, 0x80, 0xf9, 0xc0, 0xff, 0xab, 0x96, 0x61, 0x34, 0xa5, 0xac, 0x47, 0x66, 0x4c,
	0x51, 0xf5, 0xfc, 0xbf, 0xed, 0xd2, 0xa8, 0x44, 0x87, 0xf6, 0x03, 0x49, 0xf2, 0x69, 0x09, 0x0d,
	0xe0, 0x77, 0x51, 0x31, 0xf0, 0x69, 0xec, 0x0a, 0x90, 0x92, 0x85, 0x5d, 0x41, 0x40, 0xeb, 0x7b,
	0xf1, 0xc0, 0xce, 0xa5, 0x2d, 0xaa, 0xdc, 0xd8, 0xda, 0x68, 0xb4, 0x6c, 0x6e, 0xb3, 0xa0, 0x4a,
	0x25, 0xab, 0xd2, 0x9f, 0x47, 0x50, 0x21, 0x1b, 0xc6, 0x4b, 0x68, 0x46, 0x00, 0x1f, 0x00, 0xb7,
	0x2d, 0xb5, 0x2b, 0x75, 0xde, 0x71, 0xc4, 0xa5, 0xee, 0xeb, 0x74, 0x53, 0x3f, 0xe3, 0x97, 0xd1,
	0x89, 0x36, 0x15, 0xe0, 0xfa, 0x4c, 0xa8, 0xe4, 0x3e, 0x13, 0xdb, 0xe0, 0xbb, 0x99, 0x5e, 0x2f,
	0xaa, 0xf0, 0x56, 0x36, 0xfa, 0xa6, 0x6a, 0xbe, 0xca, 0x63, 0xa1, 0xff, 0x77, 0x79, 0x53, 0x36,
	0x8f, 0x85, 0xfe, 0xde, 0xbc, 0x33, 0xa8, 0xa8, 0xf3, 0x62, 0x2a, 0xc4, 0xed, 0x88, 0x27, 0xae,
	0x28, 0x28, 0xb0, 0x61, 0x31, 0x7c, 0x1a, 0x15, 0x38, 0x74, 0x38, 0x88, 0x6d, 0x97, 0x53, 0x69,
	0x0c, 0x32, 0xdd, 0xcc, 0x5b, 0xac, 0x49, 0x25, 0xe0, 0x0b, 0x68, 0x49, 0x06, 0xc2, 0xf5, 0xa8,
	0xeb, 0x01, 0x97, 0xac, 0xc3, 0x3c, 0x2a, 0xc1, 0x8d, 0xa1, 0x67, 0x7b, 0xb3, 0x20, 0x03, 0xb1,
	0x49, 0x37, 0xd3, 0x58, 0x03, 0x7a, 0x78, 0x19, 0x21, 0x01, 0x9c, 0xd1, 0x80, 0x7d, 0x08, 0x3e,
	0x39, 0xae, 0x7b, 0x94, 0x41, 0x70, 0x0d, 0x2d, 0x8e, 0x56, 0xae, 0xfa, 0x0a, 0x46, 0x7d, 0xe9,
	0x0a, 0xf0, 0xc8, 0xa2, 0x16, 0xb0, 0x30, 0x0a, 0xde, 0x34, 0xb1, 0x16, 0x78, 0x98, 0xa0, 0x23,
	0x1c, 0x24, 0x67, 0x20, 0xc8, 0x92, 0x66, 0x25, 0x4b, 0x13, 0x11, 0x92, 0x72, 0x49, 0x4e, 0xe8,
	0xad, 0x92, 0x25, 0x3e, 0x89, 0x72, 0x1c, 0x3a, 0xc0, 0x39, 0x0d, 0x04, 0x21, 0xc6, 0x2a, 0x23,
	0x40, 0x7d, 0xc9, 0xb2, 0x7b, 0x3f, 0xad, 0xab, 0x22, 0x99, 0x6e, 0x59, 0x41, 0x0b, 0x21, 0xc8,
	0xdb, 0x11, 0xff, 0x60, 0x87, 0xc8, 0x92, 0x26, 0xce, 0xdb, 0x50, 0x46, 0xe2, 0x19, 0x54, 0xa4,
	0x62, 0x18, 0x7a, 0xae, 0x17, 0x85, 0x21, 0x78, 0x92, 0x3c, 0xa3, 0xb7, 0x2c, 0x68, 0x70, 0xd3,
	0x60, 0xca, 0x34, 0x31, 0x87, 0x0e, 0xbb, 0x43, 0x7c, 0x63, 0x1a, 0xb3, 0xd2, 0x66, 0xea, 0x77,
	0x14, 0x0e, 0xd6, 0x4c, 0x7a, 0x85, 0xcb, 0xa8, 0x20, 0x80, 0x72, 0x6f, 0xdb, 0x15, 0x5e, 0x14,
	0x03, 0x79, 0x60, 0xbc, 0x96, 0x37, 0x60, 0x4b, 0x61, 0xf8, 0x2c, 0x2a, 0x5a, 0x4e, 0x87, 0x05,
	0x12, 0x38, 0xf9, 0xd1, 0x90, 0x6c, 0xe6, 0x35, 0x0d, 0xe2, 0x35, 0x74, 0xcc, 0xb2, 0xa8, 0x94,
	0x9c, 0xb5, 0xfb, 0x12, 0xc8, 0x4f, 0x86, 0x38, 0x67, 0x02, 0x1b, 0x09, 0x8e, 0xd7, 0xd1, 0x71,
	0x1e, 0x05, 0x20, 0x52, 0xaa, 0xf1, 0xdc, 0x77, 0xe6, 0x5b, 0x85, 0x75, 0x70, 0x44, 0xd7, 0x8e,
	0x2b, 0xa3, 0x82, 0x49, 0x31, 0xb5, 0xc8, 0xf7, 0x86, 0x9a, 0xd7, 0x60, 0x4b, 0x63, 0x4a, 0xa8,
	0xe1, 0xb0, 0xd0, 0x0b, 0xfa, 0x3e, 0x90, 0x4f, 0x8d, 0xf9, 0x4d, 0x66, 0xdd, 0x80, 0x29, 0x0b,
	0xee, 0x18, 0xd6, 0x67, 0x59, 0xd6, 0x55, 0x03, 0xe2, 0x5a, 0x22, 0x51, 0x72, 0x1a, 0x8a, 0x4e,
	0xc4, 0x7b, 0x7a, 0x5c, 0x92, 0xcf, 0x0d, 0x79, 0x41, 0x07, 0x6f, 0xee, 0x88, 0xe1, 0x73, 0x68,
	0x4e, 0xf4, 0x63, 0xe0, 0x6e, 0x5f, 0x00, 0x77, 0x15, 0x83, 0xdc, 0x37, 0xf4, 0xa2, 0xc6, 0x6f,
	0x09, 0xe0, 0xcd, 0x28, 0x00, 0x3d, 0x0b, 0xd2, 0xaf, 0xc2, 0xe1, 0x67, 0x41, 0x9a, 0x6b, 0x67,
	0x41, 0xed, 0xdb, 0x59, 0x34, 0xd7, 0xb2, 0x94, 0x16, 0xf0, 0x01, 0xf3, 0x00, 0x0f, 0x51, 0xf1,
	0x3a, 0xc8, 0x8d, 0x46, 0xfd, 0x6d, 0xe0, 0x42, 0xe9, 0x3b, 0xb5, 0xbb, 0xa8, 0xbd, 0x5c, 0x0c,
	0xd6, 0x2b, 0x57, 0x7b, 0xb1, 0x1c, 0x96, 0x4e, 0xef, 0x4f, 0xb0, 0x35, 0xca, 0x67, 0x3f, 0xfa,
	0xe5, 0x8f, 0xfb, 0x13, 0xcb, 0xf8, 0xa4, 0xbe, 0x47, 0x24, 0xaa, 0xd4, 0x4d, 0x85, 0xc6, 0xec,
	0xfc, 0xc0, 0xee, 0xf4, 0x95, 0x83, 0x8e, 0xa9, 0xd7, 0xca, 0x4c, 0x2d, 0x81, 0x9f, 0xdb, 0xbf,
	0xba, 0xe2, 0xbe, 0xa5, 0xa7, 0x8d, 0x28, 0x3d, 0x3f, 0xe6, 0x18, 0x54, 0x39, 0xe5, 0x4b, 0x5a,
	0xce, 0x4b, 0xf8, 0xc2, 0x1e, 0x39, 0x76, 0x40, 0x89, 0xea, 0x5d, 0x2f, 0x0a, 0x25, 0xdc, 0x51,
	0xc3, 0xeb, 0x5e, 0x95, 0xc5, 0xb7, 0x53, 0x41, 0x9f, 0x38, 0x68, 0xf6, 0x3a, 0x64, 0x45, 0xe2,
	0x33, 0xfb, 0x6b, 0xac, 0x6f, 0x25, 0x0a, 0xc7, 0x1d, 0xd4, 0xe5, 0x35, 0xad, 0xee, 0x2c, 0x2e,
	0xef, 0x51, 0x97, 0xd5, 0x51, 0xbd, 0xcb, 0xfc, 0x7b, 0xf8, 0x6b, 0x07, 0xcd, 0x6f, 0xea, 0x49,
	0x94, 0xd5, 0x33, 0xee, 0x56, 0xe3, 0x6b, 0xba, 0xac, 0x35, 0xbd, 0x52, 0xae, 0xed, 0x77, 0x62,
	0xd5, 0xbb, 0xe9, 0xb4, 0xdf, 0x79, 0x60, 0x17, 0x9d, 0x35, 0xfc, 0x85, 0x83, 0xe6, 0x6f, 0xc5,
	0xfe, 0x13, 0x97, 0x79, 0x5e, 0xcb, 0x3c, 0x57, 0x1b, 0xe3, 0xe8, 0x94, 0xac, 0x8f, 0x1d, 0x34,
	0x6f, 0xe6, 0xfc, 0xa1, 0xbb, 0xf9, 0xa8, 0x5f, 0x45, 0xd2, 0xc5, 0xb5, 0x71, 0xba, 0x38, 0x32,
	0x7e, 0xfa, 0x13, 0x7d, 0x4c, 0xc6, 0xdf, 0xf9, 0xbd, 0x38, 0xbc, 0xf1, 0x69, 0x2f, 0x1e, 0x09,
	0x4a, 0x8c, 0x9f, 0xb9, 0x3c, 0x3e, 0x06, 0xe3, 0xa7, 0xd5, 0x0e, 0x32, 0x7e, 0x46, 0xc7, 0x1e,
	0xe3, 0x67, 0xf4, 0x8c, 0xbb, 0xd5, 0xf8, 0x9a, 0x0e, 0x6b, 0xfc, 0x8c, 0xd0, 0x5d, 0xc6, 0x7f,
	0xa2, 0x32, 0x0f, 0x30, 0xfe, 0xee, 0xa3, 0xdb, 0x65, 0xfc, 0xc3, 0x76, 0xf3, 0xdf, 0x18, 0x7f,
	0x4f, 0x17, 0xbf, 0x71, 0xd0, 0x62, 0x0b, 0xa4, 0xbd, 0x28, 0xff, 0xa3, 0x23, 0x7a, 0xa4, 0x9e,
	0x6b, 0x5a, 0xcf, 0xeb, 0xe5, 0x4b, 0x07, 0x78, 0x7e, 0xbf, 0x16, 0x56, 0xed, 0x9d, 0xfe, 0xa2,
	0xb3, 0x76, 0xe5, 0xb5, 0x07, 0x0f, 0x97, 0x9d, 0x9f, 0x1f, 0x2e, 0x3b, 0xbf, 0x3d, 0x5c, 0x76,
	0xbe, 0xfc, 0x7d, 0xf9, 0xa9, 0xf7, 0x5e, 0xc8, 0xfc, 0xb1, 0x4e, 0x44, 0x9c, 0xef, 0xd1, 0x90,
	0x76, 0xc1, 0x57, 0x9b, 0x89, 0xec, 0x6e, 0xed, 0x19, 0xfd, 0x37, 0xe4, 0xc2, 0x5f, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xe3, 0xc9, 0x50, 0x90, 0xd3, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SecurityServiceClient is the client API for SecurityService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all IP whitelists that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.ipwhitelist.list on the project identified by the given context ID.
	ListIPWhitelists(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IPWhitelistList, error)
	// Fetch an IP whitelist by its id.
	// Required permissions:
	// - security.ipwhitelist.get on the IP whitelist
	GetIPWhitelist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IPWhitelist, error)
	// Create a new IP whitelist
	// Required permissions:
	// - security.ipwhitelist.create on the project that owns the IP whitelist.
	CreateIPWhitelist(ctx context.Context, in *IPWhitelist, opts ...grpc.CallOption) (*IPWhitelist, error)
	// Update an IP whitelist
	// Required permissions:
	// - security.ipwhitelist.update on the IP whitelist
	UpdateIPWhitelist(ctx context.Context, in *IPWhitelist, opts ...grpc.CallOption) (*IPWhitelist, error)
	// Delete an IP whitelist.
	// Note that IP whitelists are initially only marked for deletion.
	// Once all their dependent deployments are removed, the whitelist is removed.
	// Required permissions:
	// - security.ipwhitelist.delete on the IP whitelist
	DeleteIPWhitelist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch all IAM providers that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.iamprovider.list on the project identified by the given context ID.
	ListIAMProviders(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IAMProviderList, error)
	// Fetch an IAM provider by its id.
	// Required permissions:
	// - security.iamprovider.get on the IAM provider
	GetIAMProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IAMProvider, error)
	// Create a new IAM provider
	// Required permissions:
	// - security.iamprovider.create on the project that owns the IAM provider.
	CreateIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*IAMProvider, error)
	// Update an IAM provider
	// Required permissions:
	// - security.iamprovider.update on the IAM provider
	UpdateIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*IAMProvider, error)
	// Delete an IAM provider.
	// Note that IAM providers are initially only marked for deletion.
	// Once all their dependent deployments are removed, the provider is removed.
	// Required permissions:
	// - security.iamprovider.delete on the IP whitelist
	DeleteIAMProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Mark the given IAM provider as default for its containing project.
	// Required permissions:
	// - security.iamprovider.set-default on the project that owns the provider.
	SetDefaultIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*v1.Empty, error)
}

type securityServiceClient struct {
	cc *grpc.ClientConn
}

func NewSecurityServiceClient(cc *grpc.ClientConn) SecurityServiceClient {
	return &securityServiceClient{cc}
}

func (c *securityServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) ListIPWhitelists(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IPWhitelistList, error) {
	out := new(IPWhitelistList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/ListIPWhitelists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) GetIPWhitelist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IPWhitelist, error) {
	out := new(IPWhitelist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/GetIPWhitelist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) CreateIPWhitelist(ctx context.Context, in *IPWhitelist, opts ...grpc.CallOption) (*IPWhitelist, error) {
	out := new(IPWhitelist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/CreateIPWhitelist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) UpdateIPWhitelist(ctx context.Context, in *IPWhitelist, opts ...grpc.CallOption) (*IPWhitelist, error) {
	out := new(IPWhitelist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/UpdateIPWhitelist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) DeleteIPWhitelist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/DeleteIPWhitelist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) ListIAMProviders(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IAMProviderList, error) {
	out := new(IAMProviderList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/ListIAMProviders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) GetIAMProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IAMProvider, error) {
	out := new(IAMProvider)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/GetIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) CreateIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*IAMProvider, error) {
	out := new(IAMProvider)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/CreateIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) UpdateIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*IAMProvider, error) {
	out := new(IAMProvider)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/UpdateIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) DeleteIAMProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/DeleteIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) SetDefaultIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/SetDefaultIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityServiceServer is the server API for SecurityService service.
type SecurityServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all IP whitelists that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.ipwhitelist.list on the project identified by the given context ID.
	ListIPWhitelists(context.Context, *v1.ListOptions) (*IPWhitelistList, error)
	// Fetch an IP whitelist by its id.
	// Required permissions:
	// - security.ipwhitelist.get on the IP whitelist
	GetIPWhitelist(context.Context, *v1.IDOptions) (*IPWhitelist, error)
	// Create a new IP whitelist
	// Required permissions:
	// - security.ipwhitelist.create on the project that owns the IP whitelist.
	CreateIPWhitelist(context.Context, *IPWhitelist) (*IPWhitelist, error)
	// Update an IP whitelist
	// Required permissions:
	// - security.ipwhitelist.update on the IP whitelist
	UpdateIPWhitelist(context.Context, *IPWhitelist) (*IPWhitelist, error)
	// Delete an IP whitelist.
	// Note that IP whitelists are initially only marked for deletion.
	// Once all their dependent deployments are removed, the whitelist is removed.
	// Required permissions:
	// - security.ipwhitelist.delete on the IP whitelist
	DeleteIPWhitelist(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch all IAM providers that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.iamprovider.list on the project identified by the given context ID.
	ListIAMProviders(context.Context, *v1.ListOptions) (*IAMProviderList, error)
	// Fetch an IAM provider by its id.
	// Required permissions:
	// - security.iamprovider.get on the IAM provider
	GetIAMProvider(context.Context, *v1.IDOptions) (*IAMProvider, error)
	// Create a new IAM provider
	// Required permissions:
	// - security.iamprovider.create on the project that owns the IAM provider.
	CreateIAMProvider(context.Context, *IAMProvider) (*IAMProvider, error)
	// Update an IAM provider
	// Required permissions:
	// - security.iamprovider.update on the IAM provider
	UpdateIAMProvider(context.Context, *IAMProvider) (*IAMProvider, error)
	// Delete an IAM provider.
	// Note that IAM providers are initially only marked for deletion.
	// Once all their dependent deployments are removed, the provider is removed.
	// Required permissions:
	// - security.iamprovider.delete on the IP whitelist
	DeleteIAMProvider(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Mark the given IAM provider as default for its containing project.
	// Required permissions:
	// - security.iamprovider.set-default on the project that owns the provider.
	SetDefaultIAMProvider(context.Context, *IAMProvider) (*v1.Empty, error)
}

// UnimplementedSecurityServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityServiceServer struct {
}

func (*UnimplementedSecurityServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedSecurityServiceServer) ListIPWhitelists(ctx context.Context, req *v1.ListOptions) (*IPWhitelistList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIPWhitelists not implemented")
}
func (*UnimplementedSecurityServiceServer) GetIPWhitelist(ctx context.Context, req *v1.IDOptions) (*IPWhitelist, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIPWhitelist not implemented")
}
func (*UnimplementedSecurityServiceServer) CreateIPWhitelist(ctx context.Context, req *IPWhitelist) (*IPWhitelist, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIPWhitelist not implemented")
}
func (*UnimplementedSecurityServiceServer) UpdateIPWhitelist(ctx context.Context, req *IPWhitelist) (*IPWhitelist, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIPWhitelist not implemented")
}
func (*UnimplementedSecurityServiceServer) DeleteIPWhitelist(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIPWhitelist not implemented")
}
func (*UnimplementedSecurityServiceServer) ListIAMProviders(ctx context.Context, req *v1.ListOptions) (*IAMProviderList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIAMProviders not implemented")
}
func (*UnimplementedSecurityServiceServer) GetIAMProvider(ctx context.Context, req *v1.IDOptions) (*IAMProvider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIAMProvider not implemented")
}
func (*UnimplementedSecurityServiceServer) CreateIAMProvider(ctx context.Context, req *IAMProvider) (*IAMProvider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIAMProvider not implemented")
}
func (*UnimplementedSecurityServiceServer) UpdateIAMProvider(ctx context.Context, req *IAMProvider) (*IAMProvider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIAMProvider not implemented")
}
func (*UnimplementedSecurityServiceServer) DeleteIAMProvider(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIAMProvider not implemented")
}
func (*UnimplementedSecurityServiceServer) SetDefaultIAMProvider(ctx context.Context, req *IAMProvider) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultIAMProvider not implemented")
}

func RegisterSecurityServiceServer(s *grpc.Server, srv SecurityServiceServer) {
	s.RegisterService(&_SecurityService_serviceDesc, srv)
}

func _SecurityService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_ListIPWhitelists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).ListIPWhitelists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/ListIPWhitelists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).ListIPWhitelists(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_GetIPWhitelist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).GetIPWhitelist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/GetIPWhitelist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).GetIPWhitelist(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_CreateIPWhitelist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IPWhitelist)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).CreateIPWhitelist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/CreateIPWhitelist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).CreateIPWhitelist(ctx, req.(*IPWhitelist))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_UpdateIPWhitelist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IPWhitelist)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).UpdateIPWhitelist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/UpdateIPWhitelist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).UpdateIPWhitelist(ctx, req.(*IPWhitelist))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_DeleteIPWhitelist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).DeleteIPWhitelist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/DeleteIPWhitelist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).DeleteIPWhitelist(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_ListIAMProviders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).ListIAMProviders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/ListIAMProviders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).ListIAMProviders(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_GetIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).GetIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/GetIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).GetIAMProvider(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_CreateIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IAMProvider)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).CreateIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/CreateIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).CreateIAMProvider(ctx, req.(*IAMProvider))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_UpdateIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IAMProvider)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).UpdateIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/UpdateIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).UpdateIAMProvider(ctx, req.(*IAMProvider))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_DeleteIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).DeleteIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/DeleteIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).DeleteIAMProvider(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_SetDefaultIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IAMProvider)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).SetDefaultIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/SetDefaultIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).SetDefaultIAMProvider(ctx, req.(*IAMProvider))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.security.v1.SecurityService",
	HandlerType: (*SecurityServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _SecurityService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListIPWhitelists",
			Handler:    _SecurityService_ListIPWhitelists_Handler,
		},
		{
			MethodName: "GetIPWhitelist",
			Handler:    _SecurityService_GetIPWhitelist_Handler,
		},
		{
			MethodName: "CreateIPWhitelist",
			Handler:    _SecurityService_CreateIPWhitelist_Handler,
		},
		{
			MethodName: "UpdateIPWhitelist",
			Handler:    _SecurityService_UpdateIPWhitelist_Handler,
		},
		{
			MethodName: "DeleteIPWhitelist",
			Handler:    _SecurityService_DeleteIPWhitelist_Handler,
		},
		{
			MethodName: "ListIAMProviders",
			Handler:    _SecurityService_ListIAMProviders_Handler,
		},
		{
			MethodName: "GetIAMProvider",
			Handler:    _SecurityService_GetIAMProvider_Handler,
		},
		{
			MethodName: "CreateIAMProvider",
			Handler:    _SecurityService_CreateIAMProvider_Handler,
		},
		{
			MethodName: "UpdateIAMProvider",
			Handler:    _SecurityService_UpdateIAMProvider_Handler,
		},
		{
			MethodName: "DeleteIAMProvider",
			Handler:    _SecurityService_DeleteIAMProvider_Handler,
		},
		{
			MethodName: "SetDefaultIAMProvider",
			Handler:    _SecurityService_SetDefaultIAMProvider_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "security.proto",
}

func (m *IPWhitelist) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPWhitelist) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPWhitelist) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x52
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.CidrRanges) > 0 {
		for iNdEx := len(m.CidrRanges) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.CidrRanges[iNdEx])
			copy(dAtA[i:], m.CidrRanges[iNdEx])
			i = encodeVarintSecurity(dAtA, i, uint64(len(m.CidrRanges[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IPWhitelistList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPWhitelistList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPWhitelistList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSecurity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IAMProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IAMProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IAMProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LdapSettings != nil {
		{
			size, err := m.LdapSettings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x52
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IAMProvider_LDAPSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IAMProvider_LDAPSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IAMProvider_LDAPSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SuperUserRole) > 0 {
		i -= len(m.SuperUserRole)
		copy(dAtA[i:], m.SuperUserRole)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.SuperUserRole)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x9a
	}
	if len(m.RolesTransformation) > 0 {
		i -= len(m.RolesTransformation)
		copy(dAtA[i:], m.RolesTransformation)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesTransformation)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x92
	}
	if len(m.RolesExclude) > 0 {
		i -= len(m.RolesExclude)
		copy(dAtA[i:], m.RolesExclude)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesExclude)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x8a
	}
	if len(m.RolesInclude) > 0 {
		i -= len(m.RolesInclude)
		copy(dAtA[i:], m.RolesInclude)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesInclude)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x82
	}
	if len(m.RolesSearch) > 0 {
		i -= len(m.RolesSearch)
		copy(dAtA[i:], m.RolesSearch)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesSearch)))
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xea
	}
	if len(m.RolesAttributeName) > 0 {
		i -= len(m.RolesAttributeName)
		copy(dAtA[i:], m.RolesAttributeName)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesAttributeName)))
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xe2
	}
	if len(m.SearchAttribute) > 0 {
		i -= len(m.SearchAttribute)
		copy(dAtA[i:], m.SearchAttribute)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.SearchAttribute)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd2
	}
	if len(m.SearchFilter) > 0 {
		i -= len(m.SearchFilter)
		copy(dAtA[i:], m.SearchFilter)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.SearchFilter)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xca
	}
	if len(m.SearchScope) > 0 {
		i -= len(m.SearchScope)
		copy(dAtA[i:], m.SearchScope)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.SearchScope)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xc2
	}
	if len(m.Suffix) > 0 {
		i -= len(m.Suffix)
		copy(dAtA[i:], m.Suffix)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Suffix)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.Prefix) > 0 {
		i -= len(m.Prefix)
		copy(dAtA[i:], m.Prefix)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Prefix)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if m.AsyncConnect {
		i--
		if m.AsyncConnect {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd8
	}
	if m.NetworkTimeoutSec != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.NetworkTimeoutSec))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if m.TimeoutSec != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.TimeoutSec))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc8
	}
	if m.Referrals {
		i--
		if m.Referrals {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.Restart {
		i--
		if m.Restart {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.Retries != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.Retries))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.SerializeTimeoutSec != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.SerializeTimeoutSec))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.Serialized {
		i--
		if m.Serialized {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if len(m.TlsCaCertificatePem) > 0 {
		i -= len(m.TlsCaCertificatePem)
		copy(dAtA[i:], m.TlsCaCertificatePem)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.TlsCaCertificatePem)))
		i--
		dAtA[i] = 0x52
	}
	if m.RefreshRate != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.RefreshRate))
		i--
		dAtA[i] = 0x30
	}
	if len(m.BindPassword) > 0 {
		i -= len(m.BindPassword)
		copy(dAtA[i:], m.BindPassword)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.BindPassword)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.BindDistinguishedName) > 0 {
		i -= len(m.BindDistinguishedName)
		copy(dAtA[i:], m.BindDistinguishedName)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.BindDistinguishedName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.BaseDistinguishedName) > 0 {
		i -= len(m.BaseDistinguishedName)
		copy(dAtA[i:], m.BaseDistinguishedName)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.BaseDistinguishedName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Port != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Server) > 0 {
		i -= len(m.Server)
		copy(dAtA[i:], m.Server)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Server)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IAMProviderList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IAMProviderList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IAMProviderList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSecurity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintSecurity(dAtA []byte, offset int, v uint64) int {
	offset -= sovSecurity(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *IPWhitelist) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if len(m.CidrRanges) > 0 {
		for _, s := range m.CidrRanges {
			l = len(s)
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IPWhitelistList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IAMProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.IsDefault {
		n += 2
	}
	if m.LdapSettings != nil {
		l = m.LdapSettings.Size()
		n += 2 + l + sovSecurity(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IAMProvider_LDAPSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Server)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovSecurity(uint64(m.Port))
	}
	l = len(m.BaseDistinguishedName)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.BindDistinguishedName)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.BindPassword)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.RefreshRate != 0 {
		n += 1 + sovSecurity(uint64(m.RefreshRate))
	}
	l = len(m.TlsCaCertificatePem)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.Serialized {
		n += 3
	}
	if m.SerializeTimeoutSec != 0 {
		n += 2 + sovSecurity(uint64(m.SerializeTimeoutSec))
	}
	if m.Retries != 0 {
		n += 2 + sovSecurity(uint64(m.Retries))
	}
	if m.Restart {
		n += 3
	}
	if m.Referrals {
		n += 3
	}
	if m.TimeoutSec != 0 {
		n += 2 + sovSecurity(uint64(m.TimeoutSec))
	}
	if m.NetworkTimeoutSec != 0 {
		n += 2 + sovSecurity(uint64(m.NetworkTimeoutSec))
	}
	if m.AsyncConnect {
		n += 3
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.Suffix)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.SearchScope)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.SearchFilter)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.SearchAttribute)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesAttributeName)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesSearch)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesInclude)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesExclude)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesTransformation)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.SuperUserRole)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IAMProviderList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSecurity(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSecurity(x uint64) (n int) {
	return sovSecurity(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *IPWhitelist) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPWhitelist: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPWhitelist: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CidrRanges", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CidrRanges = append(m.CidrRanges, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPWhitelistList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPWhitelistList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPWhitelistList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &IPWhitelist{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IAMProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IAMProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IAMProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LdapSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LdapSettings == nil {
				m.LdapSettings = &IAMProvider_LDAPSettings{}
			}
			if err := m.LdapSettings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IAMProvider_LDAPSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LDAPSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LDAPSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Server", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Server = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseDistinguishedName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BaseDistinguishedName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BindDistinguishedName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BindDistinguishedName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BindPassword", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BindPassword = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshRate", wireType)
			}
			m.RefreshRate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RefreshRate |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCaCertificatePem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TlsCaCertificatePem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Serialized", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Serialized = bool(v != 0)
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SerializeTimeoutSec", wireType)
			}
			m.SerializeTimeoutSec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SerializeTimeoutSec |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retries", wireType)
			}
			m.Retries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Retries |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restart", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Restart = bool(v != 0)
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Referrals", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Referrals = bool(v != 0)
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutSec", wireType)
			}
			m.TimeoutSec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeoutSec |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkTimeoutSec", wireType)
			}
			m.NetworkTimeoutSec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NetworkTimeoutSec |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsyncConnect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AsyncConnect = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suffix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Suffix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 200:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchScope", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchScope = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 201:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchFilter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchFilter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 202:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttribute", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchAttribute = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 300:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesAttributeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesAttributeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 301:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesSearch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesSearch = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 400:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesInclude", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesInclude = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 401:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesExclude", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesExclude = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 402:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesTransformation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesTransformation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 403:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuperUserRole", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SuperUserRole = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IAMProviderList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IAMProviderList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IAMProviderList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &IAMProvider{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSecurity(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSecurity
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthSecurity
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSecurity
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSecurity(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthSecurity
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSecurity = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSecurity   = fmt.Errorf("proto: integer overflow")
)
